//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armnetwork.ClientFactory type.
type ServerFactory struct {
	AdminRuleCollectionsServer                            AdminRuleCollectionsServer
	AdminRulesServer                                      AdminRulesServer
	ApplicationGatewayPrivateEndpointConnectionsServer    ApplicationGatewayPrivateEndpointConnectionsServer
	ApplicationGatewayPrivateLinkResourcesServer          ApplicationGatewayPrivateLinkResourcesServer
	ApplicationGatewayWafDynamicManifestsServer           ApplicationGatewayWafDynamicManifestsServer
	ApplicationGatewayWafDynamicManifestsDefaultServer    ApplicationGatewayWafDynamicManifestsDefaultServer
	ApplicationGatewaysServer                             ApplicationGatewaysServer
	ApplicationSecurityGroupsServer                       ApplicationSecurityGroupsServer
	AvailableDelegationsServer                            AvailableDelegationsServer
	AvailableEndpointServicesServer                       AvailableEndpointServicesServer
	AvailablePrivateEndpointTypesServer                   AvailablePrivateEndpointTypesServer
	AvailableResourceGroupDelegationsServer               AvailableResourceGroupDelegationsServer
	AvailableServiceAliasesServer                         AvailableServiceAliasesServer
	AzureFirewallFqdnTagsServer                           AzureFirewallFqdnTagsServer
	AzureFirewallsServer                                  AzureFirewallsServer
	BastionHostsServer                                    BastionHostsServer
	BgpServiceCommunitiesServer                           BgpServiceCommunitiesServer
	ConfigurationPolicyGroupsServer                       ConfigurationPolicyGroupsServer
	ConnectionMonitorsServer                              ConnectionMonitorsServer
	ConnectivityConfigurationsServer                      ConnectivityConfigurationsServer
	CustomIPPrefixesServer                                CustomIPPrefixesServer
	DdosCustomPoliciesServer                              DdosCustomPoliciesServer
	DdosProtectionPlansServer                             DdosProtectionPlansServer
	DefaultSecurityRulesServer                            DefaultSecurityRulesServer
	DscpConfigurationServer                               DscpConfigurationServer
	ExpressRouteCircuitAuthorizationsServer               ExpressRouteCircuitAuthorizationsServer
	ExpressRouteCircuitConnectionsServer                  ExpressRouteCircuitConnectionsServer
	ExpressRouteCircuitPeeringsServer                     ExpressRouteCircuitPeeringsServer
	ExpressRouteCircuitsServer                            ExpressRouteCircuitsServer
	ExpressRouteConnectionsServer                         ExpressRouteConnectionsServer
	ExpressRouteCrossConnectionPeeringsServer             ExpressRouteCrossConnectionPeeringsServer
	ExpressRouteCrossConnectionsServer                    ExpressRouteCrossConnectionsServer
	ExpressRouteGatewaysServer                            ExpressRouteGatewaysServer
	ExpressRouteLinksServer                               ExpressRouteLinksServer
	ExpressRoutePortAuthorizationsServer                  ExpressRoutePortAuthorizationsServer
	ExpressRoutePortsServer                               ExpressRoutePortsServer
	ExpressRoutePortsLocationsServer                      ExpressRoutePortsLocationsServer
	ExpressRouteProviderPortsLocationServer               ExpressRouteProviderPortsLocationServer
	ExpressRouteServiceProvidersServer                    ExpressRouteServiceProvidersServer
	FirewallPoliciesServer                                FirewallPoliciesServer
	FirewallPolicyIdpsSignaturesServer                    FirewallPolicyIdpsSignaturesServer
	FirewallPolicyIdpsSignaturesFilterValuesServer        FirewallPolicyIdpsSignaturesFilterValuesServer
	FirewallPolicyIdpsSignaturesOverridesServer           FirewallPolicyIdpsSignaturesOverridesServer
	FirewallPolicyRuleCollectionGroupsServer              FirewallPolicyRuleCollectionGroupsServer
	FlowLogsServer                                        FlowLogsServer
	GroupsServer                                          GroupsServer
	HubRouteTablesServer                                  HubRouteTablesServer
	HubVirtualNetworkConnectionsServer                    HubVirtualNetworkConnectionsServer
	IPAllocationsServer                                   IPAllocationsServer
	IPGroupsServer                                        IPGroupsServer
	InboundNatRulesServer                                 InboundNatRulesServer
	InboundSecurityRuleServer                             InboundSecurityRuleServer
	InterfaceIPConfigurationsServer                       InterfaceIPConfigurationsServer
	InterfaceLoadBalancersServer                          InterfaceLoadBalancersServer
	InterfaceTapConfigurationsServer                      InterfaceTapConfigurationsServer
	InterfacesServer                                      InterfacesServer
	LoadBalancerBackendAddressPoolsServer                 LoadBalancerBackendAddressPoolsServer
	LoadBalancerFrontendIPConfigurationsServer            LoadBalancerFrontendIPConfigurationsServer
	LoadBalancerLoadBalancingRulesServer                  LoadBalancerLoadBalancingRulesServer
	LoadBalancerNetworkInterfacesServer                   LoadBalancerNetworkInterfacesServer
	LoadBalancerOutboundRulesServer                       LoadBalancerOutboundRulesServer
	LoadBalancerProbesServer                              LoadBalancerProbesServer
	LoadBalancersServer                                   LoadBalancersServer
	LocalNetworkGatewaysServer                            LocalNetworkGatewaysServer
	ManagementServer                                      ManagementServer
	ManagementGroupNetworkManagerConnectionsServer        ManagementGroupNetworkManagerConnectionsServer
	ManagerCommitsServer                                  ManagerCommitsServer
	ManagerDeploymentStatusServer                         ManagerDeploymentStatusServer
	ManagersServer                                        ManagersServer
	NatGatewaysServer                                     NatGatewaysServer
	NatRulesServer                                        NatRulesServer
	OperationsServer                                      OperationsServer
	P2SVPNGatewaysServer                                  P2SVPNGatewaysServer
	PacketCapturesServer                                  PacketCapturesServer
	PeerExpressRouteCircuitConnectionsServer              PeerExpressRouteCircuitConnectionsServer
	PrivateDNSZoneGroupsServer                            PrivateDNSZoneGroupsServer
	PrivateEndpointsServer                                PrivateEndpointsServer
	PrivateLinkServicesServer                             PrivateLinkServicesServer
	ProfilesServer                                        ProfilesServer
	PublicIPAddressesServer                               PublicIPAddressesServer
	PublicIPPrefixesServer                                PublicIPPrefixesServer
	ResourceNavigationLinksServer                         ResourceNavigationLinksServer
	RouteFilterRulesServer                                RouteFilterRulesServer
	RouteFiltersServer                                    RouteFiltersServer
	RouteMapsServer                                       RouteMapsServer
	RouteTablesServer                                     RouteTablesServer
	RoutesServer                                          RoutesServer
	RoutingIntentServer                                   RoutingIntentServer
	ScopeConnectionsServer                                ScopeConnectionsServer
	SecurityAdminConfigurationsServer                     SecurityAdminConfigurationsServer
	SecurityGroupsServer                                  SecurityGroupsServer
	SecurityPartnerProvidersServer                        SecurityPartnerProvidersServer
	SecurityRulesServer                                   SecurityRulesServer
	ServiceAssociationLinksServer                         ServiceAssociationLinksServer
	ServiceEndpointPoliciesServer                         ServiceEndpointPoliciesServer
	ServiceEndpointPolicyDefinitionsServer                ServiceEndpointPolicyDefinitionsServer
	ServiceTagInformationServer                           ServiceTagInformationServer
	ServiceTagsServer                                     ServiceTagsServer
	StaticMembersServer                                   StaticMembersServer
	SubnetsServer                                         SubnetsServer
	SubscriptionNetworkManagerConnectionsServer           SubscriptionNetworkManagerConnectionsServer
	UsagesServer                                          UsagesServer
	VPNConnectionsServer                                  VPNConnectionsServer
	VPNGatewaysServer                                     VPNGatewaysServer
	VPNLinkConnectionsServer                              VPNLinkConnectionsServer
	VPNServerConfigurationsAssociatedWithVirtualWanServer VPNServerConfigurationsAssociatedWithVirtualWanServer
	VPNServerConfigurationsServer                         VPNServerConfigurationsServer
	VPNSiteLinkConnectionsServer                          VPNSiteLinkConnectionsServer
	VPNSiteLinksServer                                    VPNSiteLinksServer
	VPNSitesServer                                        VPNSitesServer
	VPNSitesConfigurationServer                           VPNSitesConfigurationServer
	VipSwapServer                                         VipSwapServer
	VirtualApplianceConnectionsServer                     VirtualApplianceConnectionsServer
	VirtualApplianceSKUsServer                            VirtualApplianceSKUsServer
	VirtualApplianceSitesServer                           VirtualApplianceSitesServer
	VirtualAppliancesServer                               VirtualAppliancesServer
	VirtualHubBgpConnectionServer                         VirtualHubBgpConnectionServer
	VirtualHubBgpConnectionsServer                        VirtualHubBgpConnectionsServer
	VirtualHubIPConfigurationServer                       VirtualHubIPConfigurationServer
	VirtualHubRouteTableV2SServer                         VirtualHubRouteTableV2SServer
	VirtualHubsServer                                     VirtualHubsServer
	VirtualNetworkGatewayConnectionsServer                VirtualNetworkGatewayConnectionsServer
	VirtualNetworkGatewayNatRulesServer                   VirtualNetworkGatewayNatRulesServer
	VirtualNetworkGatewaysServer                          VirtualNetworkGatewaysServer
	VirtualNetworkPeeringsServer                          VirtualNetworkPeeringsServer
	VirtualNetworkTapsServer                              VirtualNetworkTapsServer
	VirtualNetworksServer                                 VirtualNetworksServer
	VirtualRouterPeeringsServer                           VirtualRouterPeeringsServer
	VirtualRoutersServer                                  VirtualRoutersServer
	VirtualWansServer                                     VirtualWansServer
	WatchersServer                                        WatchersServer
	WebApplicationFirewallPoliciesServer                  WebApplicationFirewallPoliciesServer
	WebCategoriesServer                                   WebCategoriesServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armnetwork.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armnetwork.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                                                     *ServerFactory
	trMu                                                    sync.Mutex
	trAdminRuleCollectionsServer                            *AdminRuleCollectionsServerTransport
	trAdminRulesServer                                      *AdminRulesServerTransport
	trApplicationGatewayPrivateEndpointConnectionsServer    *ApplicationGatewayPrivateEndpointConnectionsServerTransport
	trApplicationGatewayPrivateLinkResourcesServer          *ApplicationGatewayPrivateLinkResourcesServerTransport
	trApplicationGatewayWafDynamicManifestsServer           *ApplicationGatewayWafDynamicManifestsServerTransport
	trApplicationGatewayWafDynamicManifestsDefaultServer    *ApplicationGatewayWafDynamicManifestsDefaultServerTransport
	trApplicationGatewaysServer                             *ApplicationGatewaysServerTransport
	trApplicationSecurityGroupsServer                       *ApplicationSecurityGroupsServerTransport
	trAvailableDelegationsServer                            *AvailableDelegationsServerTransport
	trAvailableEndpointServicesServer                       *AvailableEndpointServicesServerTransport
	trAvailablePrivateEndpointTypesServer                   *AvailablePrivateEndpointTypesServerTransport
	trAvailableResourceGroupDelegationsServer               *AvailableResourceGroupDelegationsServerTransport
	trAvailableServiceAliasesServer                         *AvailableServiceAliasesServerTransport
	trAzureFirewallFqdnTagsServer                           *AzureFirewallFqdnTagsServerTransport
	trAzureFirewallsServer                                  *AzureFirewallsServerTransport
	trBastionHostsServer                                    *BastionHostsServerTransport
	trBgpServiceCommunitiesServer                           *BgpServiceCommunitiesServerTransport
	trConfigurationPolicyGroupsServer                       *ConfigurationPolicyGroupsServerTransport
	trConnectionMonitorsServer                              *ConnectionMonitorsServerTransport
	trConnectivityConfigurationsServer                      *ConnectivityConfigurationsServerTransport
	trCustomIPPrefixesServer                                *CustomIPPrefixesServerTransport
	trDdosCustomPoliciesServer                              *DdosCustomPoliciesServerTransport
	trDdosProtectionPlansServer                             *DdosProtectionPlansServerTransport
	trDefaultSecurityRulesServer                            *DefaultSecurityRulesServerTransport
	trDscpConfigurationServer                               *DscpConfigurationServerTransport
	trExpressRouteCircuitAuthorizationsServer               *ExpressRouteCircuitAuthorizationsServerTransport
	trExpressRouteCircuitConnectionsServer                  *ExpressRouteCircuitConnectionsServerTransport
	trExpressRouteCircuitPeeringsServer                     *ExpressRouteCircuitPeeringsServerTransport
	trExpressRouteCircuitsServer                            *ExpressRouteCircuitsServerTransport
	trExpressRouteConnectionsServer                         *ExpressRouteConnectionsServerTransport
	trExpressRouteCrossConnectionPeeringsServer             *ExpressRouteCrossConnectionPeeringsServerTransport
	trExpressRouteCrossConnectionsServer                    *ExpressRouteCrossConnectionsServerTransport
	trExpressRouteGatewaysServer                            *ExpressRouteGatewaysServerTransport
	trExpressRouteLinksServer                               *ExpressRouteLinksServerTransport
	trExpressRoutePortAuthorizationsServer                  *ExpressRoutePortAuthorizationsServerTransport
	trExpressRoutePortsServer                               *ExpressRoutePortsServerTransport
	trExpressRoutePortsLocationsServer                      *ExpressRoutePortsLocationsServerTransport
	trExpressRouteProviderPortsLocationServer               *ExpressRouteProviderPortsLocationServerTransport
	trExpressRouteServiceProvidersServer                    *ExpressRouteServiceProvidersServerTransport
	trFirewallPoliciesServer                                *FirewallPoliciesServerTransport
	trFirewallPolicyIdpsSignaturesServer                    *FirewallPolicyIdpsSignaturesServerTransport
	trFirewallPolicyIdpsSignaturesFilterValuesServer        *FirewallPolicyIdpsSignaturesFilterValuesServerTransport
	trFirewallPolicyIdpsSignaturesOverridesServer           *FirewallPolicyIdpsSignaturesOverridesServerTransport
	trFirewallPolicyRuleCollectionGroupsServer              *FirewallPolicyRuleCollectionGroupsServerTransport
	trFlowLogsServer                                        *FlowLogsServerTransport
	trGroupsServer                                          *GroupsServerTransport
	trHubRouteTablesServer                                  *HubRouteTablesServerTransport
	trHubVirtualNetworkConnectionsServer                    *HubVirtualNetworkConnectionsServerTransport
	trIPAllocationsServer                                   *IPAllocationsServerTransport
	trIPGroupsServer                                        *IPGroupsServerTransport
	trInboundNatRulesServer                                 *InboundNatRulesServerTransport
	trInboundSecurityRuleServer                             *InboundSecurityRuleServerTransport
	trInterfaceIPConfigurationsServer                       *InterfaceIPConfigurationsServerTransport
	trInterfaceLoadBalancersServer                          *InterfaceLoadBalancersServerTransport
	trInterfaceTapConfigurationsServer                      *InterfaceTapConfigurationsServerTransport
	trInterfacesServer                                      *InterfacesServerTransport
	trLoadBalancerBackendAddressPoolsServer                 *LoadBalancerBackendAddressPoolsServerTransport
	trLoadBalancerFrontendIPConfigurationsServer            *LoadBalancerFrontendIPConfigurationsServerTransport
	trLoadBalancerLoadBalancingRulesServer                  *LoadBalancerLoadBalancingRulesServerTransport
	trLoadBalancerNetworkInterfacesServer                   *LoadBalancerNetworkInterfacesServerTransport
	trLoadBalancerOutboundRulesServer                       *LoadBalancerOutboundRulesServerTransport
	trLoadBalancerProbesServer                              *LoadBalancerProbesServerTransport
	trLoadBalancersServer                                   *LoadBalancersServerTransport
	trLocalNetworkGatewaysServer                            *LocalNetworkGatewaysServerTransport
	trManagementServer                                      *ManagementServerTransport
	trManagementGroupNetworkManagerConnectionsServer        *ManagementGroupNetworkManagerConnectionsServerTransport
	trManagerCommitsServer                                  *ManagerCommitsServerTransport
	trManagerDeploymentStatusServer                         *ManagerDeploymentStatusServerTransport
	trManagersServer                                        *ManagersServerTransport
	trNatGatewaysServer                                     *NatGatewaysServerTransport
	trNatRulesServer                                        *NatRulesServerTransport
	trOperationsServer                                      *OperationsServerTransport
	trP2SVPNGatewaysServer                                  *P2SVPNGatewaysServerTransport
	trPacketCapturesServer                                  *PacketCapturesServerTransport
	trPeerExpressRouteCircuitConnectionsServer              *PeerExpressRouteCircuitConnectionsServerTransport
	trPrivateDNSZoneGroupsServer                            *PrivateDNSZoneGroupsServerTransport
	trPrivateEndpointsServer                                *PrivateEndpointsServerTransport
	trPrivateLinkServicesServer                             *PrivateLinkServicesServerTransport
	trProfilesServer                                        *ProfilesServerTransport
	trPublicIPAddressesServer                               *PublicIPAddressesServerTransport
	trPublicIPPrefixesServer                                *PublicIPPrefixesServerTransport
	trResourceNavigationLinksServer                         *ResourceNavigationLinksServerTransport
	trRouteFilterRulesServer                                *RouteFilterRulesServerTransport
	trRouteFiltersServer                                    *RouteFiltersServerTransport
	trRouteMapsServer                                       *RouteMapsServerTransport
	trRouteTablesServer                                     *RouteTablesServerTransport
	trRoutesServer                                          *RoutesServerTransport
	trRoutingIntentServer                                   *RoutingIntentServerTransport
	trScopeConnectionsServer                                *ScopeConnectionsServerTransport
	trSecurityAdminConfigurationsServer                     *SecurityAdminConfigurationsServerTransport
	trSecurityGroupsServer                                  *SecurityGroupsServerTransport
	trSecurityPartnerProvidersServer                        *SecurityPartnerProvidersServerTransport
	trSecurityRulesServer                                   *SecurityRulesServerTransport
	trServiceAssociationLinksServer                         *ServiceAssociationLinksServerTransport
	trServiceEndpointPoliciesServer                         *ServiceEndpointPoliciesServerTransport
	trServiceEndpointPolicyDefinitionsServer                *ServiceEndpointPolicyDefinitionsServerTransport
	trServiceTagInformationServer                           *ServiceTagInformationServerTransport
	trServiceTagsServer                                     *ServiceTagsServerTransport
	trStaticMembersServer                                   *StaticMembersServerTransport
	trSubnetsServer                                         *SubnetsServerTransport
	trSubscriptionNetworkManagerConnectionsServer           *SubscriptionNetworkManagerConnectionsServerTransport
	trUsagesServer                                          *UsagesServerTransport
	trVPNConnectionsServer                                  *VPNConnectionsServerTransport
	trVPNGatewaysServer                                     *VPNGatewaysServerTransport
	trVPNLinkConnectionsServer                              *VPNLinkConnectionsServerTransport
	trVPNServerConfigurationsAssociatedWithVirtualWanServer *VPNServerConfigurationsAssociatedWithVirtualWanServerTransport
	trVPNServerConfigurationsServer                         *VPNServerConfigurationsServerTransport
	trVPNSiteLinkConnectionsServer                          *VPNSiteLinkConnectionsServerTransport
	trVPNSiteLinksServer                                    *VPNSiteLinksServerTransport
	trVPNSitesServer                                        *VPNSitesServerTransport
	trVPNSitesConfigurationServer                           *VPNSitesConfigurationServerTransport
	trVipSwapServer                                         *VipSwapServerTransport
	trVirtualApplianceConnectionsServer                     *VirtualApplianceConnectionsServerTransport
	trVirtualApplianceSKUsServer                            *VirtualApplianceSKUsServerTransport
	trVirtualApplianceSitesServer                           *VirtualApplianceSitesServerTransport
	trVirtualAppliancesServer                               *VirtualAppliancesServerTransport
	trVirtualHubBgpConnectionServer                         *VirtualHubBgpConnectionServerTransport
	trVirtualHubBgpConnectionsServer                        *VirtualHubBgpConnectionsServerTransport
	trVirtualHubIPConfigurationServer                       *VirtualHubIPConfigurationServerTransport
	trVirtualHubRouteTableV2SServer                         *VirtualHubRouteTableV2SServerTransport
	trVirtualHubsServer                                     *VirtualHubsServerTransport
	trVirtualNetworkGatewayConnectionsServer                *VirtualNetworkGatewayConnectionsServerTransport
	trVirtualNetworkGatewayNatRulesServer                   *VirtualNetworkGatewayNatRulesServerTransport
	trVirtualNetworkGatewaysServer                          *VirtualNetworkGatewaysServerTransport
	trVirtualNetworkPeeringsServer                          *VirtualNetworkPeeringsServerTransport
	trVirtualNetworkTapsServer                              *VirtualNetworkTapsServerTransport
	trVirtualNetworksServer                                 *VirtualNetworksServerTransport
	trVirtualRouterPeeringsServer                           *VirtualRouterPeeringsServerTransport
	trVirtualRoutersServer                                  *VirtualRoutersServerTransport
	trVirtualWansServer                                     *VirtualWansServerTransport
	trWatchersServer                                        *WatchersServerTransport
	trWebApplicationFirewallPoliciesServer                  *WebApplicationFirewallPoliciesServerTransport
	trWebCategoriesServer                                   *WebCategoriesServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "AdminRuleCollectionsClient":
		initServer(s, &s.trAdminRuleCollectionsServer, func() *AdminRuleCollectionsServerTransport {
			return NewAdminRuleCollectionsServerTransport(&s.srv.AdminRuleCollectionsServer)
		})
		resp, err = s.trAdminRuleCollectionsServer.Do(req)
	case "AdminRulesClient":
		initServer(s, &s.trAdminRulesServer, func() *AdminRulesServerTransport { return NewAdminRulesServerTransport(&s.srv.AdminRulesServer) })
		resp, err = s.trAdminRulesServer.Do(req)
	case "ApplicationGatewayPrivateEndpointConnectionsClient":
		initServer(s, &s.trApplicationGatewayPrivateEndpointConnectionsServer, func() *ApplicationGatewayPrivateEndpointConnectionsServerTransport {
			return NewApplicationGatewayPrivateEndpointConnectionsServerTransport(&s.srv.ApplicationGatewayPrivateEndpointConnectionsServer)
		})
		resp, err = s.trApplicationGatewayPrivateEndpointConnectionsServer.Do(req)
	case "ApplicationGatewayPrivateLinkResourcesClient":
		initServer(s, &s.trApplicationGatewayPrivateLinkResourcesServer, func() *ApplicationGatewayPrivateLinkResourcesServerTransport {
			return NewApplicationGatewayPrivateLinkResourcesServerTransport(&s.srv.ApplicationGatewayPrivateLinkResourcesServer)
		})
		resp, err = s.trApplicationGatewayPrivateLinkResourcesServer.Do(req)
	case "ApplicationGatewayWafDynamicManifestsClient":
		initServer(s, &s.trApplicationGatewayWafDynamicManifestsServer, func() *ApplicationGatewayWafDynamicManifestsServerTransport {
			return NewApplicationGatewayWafDynamicManifestsServerTransport(&s.srv.ApplicationGatewayWafDynamicManifestsServer)
		})
		resp, err = s.trApplicationGatewayWafDynamicManifestsServer.Do(req)
	case "ApplicationGatewayWafDynamicManifestsDefaultClient":
		initServer(s, &s.trApplicationGatewayWafDynamicManifestsDefaultServer, func() *ApplicationGatewayWafDynamicManifestsDefaultServerTransport {
			return NewApplicationGatewayWafDynamicManifestsDefaultServerTransport(&s.srv.ApplicationGatewayWafDynamicManifestsDefaultServer)
		})
		resp, err = s.trApplicationGatewayWafDynamicManifestsDefaultServer.Do(req)
	case "ApplicationGatewaysClient":
		initServer(s, &s.trApplicationGatewaysServer, func() *ApplicationGatewaysServerTransport {
			return NewApplicationGatewaysServerTransport(&s.srv.ApplicationGatewaysServer)
		})
		resp, err = s.trApplicationGatewaysServer.Do(req)
	case "ApplicationSecurityGroupsClient":
		initServer(s, &s.trApplicationSecurityGroupsServer, func() *ApplicationSecurityGroupsServerTransport {
			return NewApplicationSecurityGroupsServerTransport(&s.srv.ApplicationSecurityGroupsServer)
		})
		resp, err = s.trApplicationSecurityGroupsServer.Do(req)
	case "AvailableDelegationsClient":
		initServer(s, &s.trAvailableDelegationsServer, func() *AvailableDelegationsServerTransport {
			return NewAvailableDelegationsServerTransport(&s.srv.AvailableDelegationsServer)
		})
		resp, err = s.trAvailableDelegationsServer.Do(req)
	case "AvailableEndpointServicesClient":
		initServer(s, &s.trAvailableEndpointServicesServer, func() *AvailableEndpointServicesServerTransport {
			return NewAvailableEndpointServicesServerTransport(&s.srv.AvailableEndpointServicesServer)
		})
		resp, err = s.trAvailableEndpointServicesServer.Do(req)
	case "AvailablePrivateEndpointTypesClient":
		initServer(s, &s.trAvailablePrivateEndpointTypesServer, func() *AvailablePrivateEndpointTypesServerTransport {
			return NewAvailablePrivateEndpointTypesServerTransport(&s.srv.AvailablePrivateEndpointTypesServer)
		})
		resp, err = s.trAvailablePrivateEndpointTypesServer.Do(req)
	case "AvailableResourceGroupDelegationsClient":
		initServer(s, &s.trAvailableResourceGroupDelegationsServer, func() *AvailableResourceGroupDelegationsServerTransport {
			return NewAvailableResourceGroupDelegationsServerTransport(&s.srv.AvailableResourceGroupDelegationsServer)
		})
		resp, err = s.trAvailableResourceGroupDelegationsServer.Do(req)
	case "AvailableServiceAliasesClient":
		initServer(s, &s.trAvailableServiceAliasesServer, func() *AvailableServiceAliasesServerTransport {
			return NewAvailableServiceAliasesServerTransport(&s.srv.AvailableServiceAliasesServer)
		})
		resp, err = s.trAvailableServiceAliasesServer.Do(req)
	case "AzureFirewallFqdnTagsClient":
		initServer(s, &s.trAzureFirewallFqdnTagsServer, func() *AzureFirewallFqdnTagsServerTransport {
			return NewAzureFirewallFqdnTagsServerTransport(&s.srv.AzureFirewallFqdnTagsServer)
		})
		resp, err = s.trAzureFirewallFqdnTagsServer.Do(req)
	case "AzureFirewallsClient":
		initServer(s, &s.trAzureFirewallsServer, func() *AzureFirewallsServerTransport {
			return NewAzureFirewallsServerTransport(&s.srv.AzureFirewallsServer)
		})
		resp, err = s.trAzureFirewallsServer.Do(req)
	case "BastionHostsClient":
		initServer(s, &s.trBastionHostsServer, func() *BastionHostsServerTransport { return NewBastionHostsServerTransport(&s.srv.BastionHostsServer) })
		resp, err = s.trBastionHostsServer.Do(req)
	case "BgpServiceCommunitiesClient":
		initServer(s, &s.trBgpServiceCommunitiesServer, func() *BgpServiceCommunitiesServerTransport {
			return NewBgpServiceCommunitiesServerTransport(&s.srv.BgpServiceCommunitiesServer)
		})
		resp, err = s.trBgpServiceCommunitiesServer.Do(req)
	case "ConfigurationPolicyGroupsClient":
		initServer(s, &s.trConfigurationPolicyGroupsServer, func() *ConfigurationPolicyGroupsServerTransport {
			return NewConfigurationPolicyGroupsServerTransport(&s.srv.ConfigurationPolicyGroupsServer)
		})
		resp, err = s.trConfigurationPolicyGroupsServer.Do(req)
	case "ConnectionMonitorsClient":
		initServer(s, &s.trConnectionMonitorsServer, func() *ConnectionMonitorsServerTransport {
			return NewConnectionMonitorsServerTransport(&s.srv.ConnectionMonitorsServer)
		})
		resp, err = s.trConnectionMonitorsServer.Do(req)
	case "ConnectivityConfigurationsClient":
		initServer(s, &s.trConnectivityConfigurationsServer, func() *ConnectivityConfigurationsServerTransport {
			return NewConnectivityConfigurationsServerTransport(&s.srv.ConnectivityConfigurationsServer)
		})
		resp, err = s.trConnectivityConfigurationsServer.Do(req)
	case "CustomIPPrefixesClient":
		initServer(s, &s.trCustomIPPrefixesServer, func() *CustomIPPrefixesServerTransport {
			return NewCustomIPPrefixesServerTransport(&s.srv.CustomIPPrefixesServer)
		})
		resp, err = s.trCustomIPPrefixesServer.Do(req)
	case "DdosCustomPoliciesClient":
		initServer(s, &s.trDdosCustomPoliciesServer, func() *DdosCustomPoliciesServerTransport {
			return NewDdosCustomPoliciesServerTransport(&s.srv.DdosCustomPoliciesServer)
		})
		resp, err = s.trDdosCustomPoliciesServer.Do(req)
	case "DdosProtectionPlansClient":
		initServer(s, &s.trDdosProtectionPlansServer, func() *DdosProtectionPlansServerTransport {
			return NewDdosProtectionPlansServerTransport(&s.srv.DdosProtectionPlansServer)
		})
		resp, err = s.trDdosProtectionPlansServer.Do(req)
	case "DefaultSecurityRulesClient":
		initServer(s, &s.trDefaultSecurityRulesServer, func() *DefaultSecurityRulesServerTransport {
			return NewDefaultSecurityRulesServerTransport(&s.srv.DefaultSecurityRulesServer)
		})
		resp, err = s.trDefaultSecurityRulesServer.Do(req)
	case "DscpConfigurationClient":
		initServer(s, &s.trDscpConfigurationServer, func() *DscpConfigurationServerTransport {
			return NewDscpConfigurationServerTransport(&s.srv.DscpConfigurationServer)
		})
		resp, err = s.trDscpConfigurationServer.Do(req)
	case "ExpressRouteCircuitAuthorizationsClient":
		initServer(s, &s.trExpressRouteCircuitAuthorizationsServer, func() *ExpressRouteCircuitAuthorizationsServerTransport {
			return NewExpressRouteCircuitAuthorizationsServerTransport(&s.srv.ExpressRouteCircuitAuthorizationsServer)
		})
		resp, err = s.trExpressRouteCircuitAuthorizationsServer.Do(req)
	case "ExpressRouteCircuitConnectionsClient":
		initServer(s, &s.trExpressRouteCircuitConnectionsServer, func() *ExpressRouteCircuitConnectionsServerTransport {
			return NewExpressRouteCircuitConnectionsServerTransport(&s.srv.ExpressRouteCircuitConnectionsServer)
		})
		resp, err = s.trExpressRouteCircuitConnectionsServer.Do(req)
	case "ExpressRouteCircuitPeeringsClient":
		initServer(s, &s.trExpressRouteCircuitPeeringsServer, func() *ExpressRouteCircuitPeeringsServerTransport {
			return NewExpressRouteCircuitPeeringsServerTransport(&s.srv.ExpressRouteCircuitPeeringsServer)
		})
		resp, err = s.trExpressRouteCircuitPeeringsServer.Do(req)
	case "ExpressRouteCircuitsClient":
		initServer(s, &s.trExpressRouteCircuitsServer, func() *ExpressRouteCircuitsServerTransport {
			return NewExpressRouteCircuitsServerTransport(&s.srv.ExpressRouteCircuitsServer)
		})
		resp, err = s.trExpressRouteCircuitsServer.Do(req)
	case "ExpressRouteConnectionsClient":
		initServer(s, &s.trExpressRouteConnectionsServer, func() *ExpressRouteConnectionsServerTransport {
			return NewExpressRouteConnectionsServerTransport(&s.srv.ExpressRouteConnectionsServer)
		})
		resp, err = s.trExpressRouteConnectionsServer.Do(req)
	case "ExpressRouteCrossConnectionPeeringsClient":
		initServer(s, &s.trExpressRouteCrossConnectionPeeringsServer, func() *ExpressRouteCrossConnectionPeeringsServerTransport {
			return NewExpressRouteCrossConnectionPeeringsServerTransport(&s.srv.ExpressRouteCrossConnectionPeeringsServer)
		})
		resp, err = s.trExpressRouteCrossConnectionPeeringsServer.Do(req)
	case "ExpressRouteCrossConnectionsClient":
		initServer(s, &s.trExpressRouteCrossConnectionsServer, func() *ExpressRouteCrossConnectionsServerTransport {
			return NewExpressRouteCrossConnectionsServerTransport(&s.srv.ExpressRouteCrossConnectionsServer)
		})
		resp, err = s.trExpressRouteCrossConnectionsServer.Do(req)
	case "ExpressRouteGatewaysClient":
		initServer(s, &s.trExpressRouteGatewaysServer, func() *ExpressRouteGatewaysServerTransport {
			return NewExpressRouteGatewaysServerTransport(&s.srv.ExpressRouteGatewaysServer)
		})
		resp, err = s.trExpressRouteGatewaysServer.Do(req)
	case "ExpressRouteLinksClient":
		initServer(s, &s.trExpressRouteLinksServer, func() *ExpressRouteLinksServerTransport {
			return NewExpressRouteLinksServerTransport(&s.srv.ExpressRouteLinksServer)
		})
		resp, err = s.trExpressRouteLinksServer.Do(req)
	case "ExpressRoutePortAuthorizationsClient":
		initServer(s, &s.trExpressRoutePortAuthorizationsServer, func() *ExpressRoutePortAuthorizationsServerTransport {
			return NewExpressRoutePortAuthorizationsServerTransport(&s.srv.ExpressRoutePortAuthorizationsServer)
		})
		resp, err = s.trExpressRoutePortAuthorizationsServer.Do(req)
	case "ExpressRoutePortsClient":
		initServer(s, &s.trExpressRoutePortsServer, func() *ExpressRoutePortsServerTransport {
			return NewExpressRoutePortsServerTransport(&s.srv.ExpressRoutePortsServer)
		})
		resp, err = s.trExpressRoutePortsServer.Do(req)
	case "ExpressRoutePortsLocationsClient":
		initServer(s, &s.trExpressRoutePortsLocationsServer, func() *ExpressRoutePortsLocationsServerTransport {
			return NewExpressRoutePortsLocationsServerTransport(&s.srv.ExpressRoutePortsLocationsServer)
		})
		resp, err = s.trExpressRoutePortsLocationsServer.Do(req)
	case "ExpressRouteProviderPortsLocationClient":
		initServer(s, &s.trExpressRouteProviderPortsLocationServer, func() *ExpressRouteProviderPortsLocationServerTransport {
			return NewExpressRouteProviderPortsLocationServerTransport(&s.srv.ExpressRouteProviderPortsLocationServer)
		})
		resp, err = s.trExpressRouteProviderPortsLocationServer.Do(req)
	case "ExpressRouteServiceProvidersClient":
		initServer(s, &s.trExpressRouteServiceProvidersServer, func() *ExpressRouteServiceProvidersServerTransport {
			return NewExpressRouteServiceProvidersServerTransport(&s.srv.ExpressRouteServiceProvidersServer)
		})
		resp, err = s.trExpressRouteServiceProvidersServer.Do(req)
	case "FirewallPoliciesClient":
		initServer(s, &s.trFirewallPoliciesServer, func() *FirewallPoliciesServerTransport {
			return NewFirewallPoliciesServerTransport(&s.srv.FirewallPoliciesServer)
		})
		resp, err = s.trFirewallPoliciesServer.Do(req)
	case "FirewallPolicyIdpsSignaturesClient":
		initServer(s, &s.trFirewallPolicyIdpsSignaturesServer, func() *FirewallPolicyIdpsSignaturesServerTransport {
			return NewFirewallPolicyIdpsSignaturesServerTransport(&s.srv.FirewallPolicyIdpsSignaturesServer)
		})
		resp, err = s.trFirewallPolicyIdpsSignaturesServer.Do(req)
	case "FirewallPolicyIdpsSignaturesFilterValuesClient":
		initServer(s, &s.trFirewallPolicyIdpsSignaturesFilterValuesServer, func() *FirewallPolicyIdpsSignaturesFilterValuesServerTransport {
			return NewFirewallPolicyIdpsSignaturesFilterValuesServerTransport(&s.srv.FirewallPolicyIdpsSignaturesFilterValuesServer)
		})
		resp, err = s.trFirewallPolicyIdpsSignaturesFilterValuesServer.Do(req)
	case "FirewallPolicyIdpsSignaturesOverridesClient":
		initServer(s, &s.trFirewallPolicyIdpsSignaturesOverridesServer, func() *FirewallPolicyIdpsSignaturesOverridesServerTransport {
			return NewFirewallPolicyIdpsSignaturesOverridesServerTransport(&s.srv.FirewallPolicyIdpsSignaturesOverridesServer)
		})
		resp, err = s.trFirewallPolicyIdpsSignaturesOverridesServer.Do(req)
	case "FirewallPolicyRuleCollectionGroupsClient":
		initServer(s, &s.trFirewallPolicyRuleCollectionGroupsServer, func() *FirewallPolicyRuleCollectionGroupsServerTransport {
			return NewFirewallPolicyRuleCollectionGroupsServerTransport(&s.srv.FirewallPolicyRuleCollectionGroupsServer)
		})
		resp, err = s.trFirewallPolicyRuleCollectionGroupsServer.Do(req)
	case "FlowLogsClient":
		initServer(s, &s.trFlowLogsServer, func() *FlowLogsServerTransport { return NewFlowLogsServerTransport(&s.srv.FlowLogsServer) })
		resp, err = s.trFlowLogsServer.Do(req)
	case "GroupsClient":
		initServer(s, &s.trGroupsServer, func() *GroupsServerTransport { return NewGroupsServerTransport(&s.srv.GroupsServer) })
		resp, err = s.trGroupsServer.Do(req)
	case "HubRouteTablesClient":
		initServer(s, &s.trHubRouteTablesServer, func() *HubRouteTablesServerTransport {
			return NewHubRouteTablesServerTransport(&s.srv.HubRouteTablesServer)
		})
		resp, err = s.trHubRouteTablesServer.Do(req)
	case "HubVirtualNetworkConnectionsClient":
		initServer(s, &s.trHubVirtualNetworkConnectionsServer, func() *HubVirtualNetworkConnectionsServerTransport {
			return NewHubVirtualNetworkConnectionsServerTransport(&s.srv.HubVirtualNetworkConnectionsServer)
		})
		resp, err = s.trHubVirtualNetworkConnectionsServer.Do(req)
	case "IPAllocationsClient":
		initServer(s, &s.trIPAllocationsServer, func() *IPAllocationsServerTransport {
			return NewIPAllocationsServerTransport(&s.srv.IPAllocationsServer)
		})
		resp, err = s.trIPAllocationsServer.Do(req)
	case "IPGroupsClient":
		initServer(s, &s.trIPGroupsServer, func() *IPGroupsServerTransport { return NewIPGroupsServerTransport(&s.srv.IPGroupsServer) })
		resp, err = s.trIPGroupsServer.Do(req)
	case "InboundNatRulesClient":
		initServer(s, &s.trInboundNatRulesServer, func() *InboundNatRulesServerTransport {
			return NewInboundNatRulesServerTransport(&s.srv.InboundNatRulesServer)
		})
		resp, err = s.trInboundNatRulesServer.Do(req)
	case "InboundSecurityRuleClient":
		initServer(s, &s.trInboundSecurityRuleServer, func() *InboundSecurityRuleServerTransport {
			return NewInboundSecurityRuleServerTransport(&s.srv.InboundSecurityRuleServer)
		})
		resp, err = s.trInboundSecurityRuleServer.Do(req)
	case "InterfaceIPConfigurationsClient":
		initServer(s, &s.trInterfaceIPConfigurationsServer, func() *InterfaceIPConfigurationsServerTransport {
			return NewInterfaceIPConfigurationsServerTransport(&s.srv.InterfaceIPConfigurationsServer)
		})
		resp, err = s.trInterfaceIPConfigurationsServer.Do(req)
	case "InterfaceLoadBalancersClient":
		initServer(s, &s.trInterfaceLoadBalancersServer, func() *InterfaceLoadBalancersServerTransport {
			return NewInterfaceLoadBalancersServerTransport(&s.srv.InterfaceLoadBalancersServer)
		})
		resp, err = s.trInterfaceLoadBalancersServer.Do(req)
	case "InterfaceTapConfigurationsClient":
		initServer(s, &s.trInterfaceTapConfigurationsServer, func() *InterfaceTapConfigurationsServerTransport {
			return NewInterfaceTapConfigurationsServerTransport(&s.srv.InterfaceTapConfigurationsServer)
		})
		resp, err = s.trInterfaceTapConfigurationsServer.Do(req)
	case "InterfacesClient":
		initServer(s, &s.trInterfacesServer, func() *InterfacesServerTransport { return NewInterfacesServerTransport(&s.srv.InterfacesServer) })
		resp, err = s.trInterfacesServer.Do(req)
	case "LoadBalancerBackendAddressPoolsClient":
		initServer(s, &s.trLoadBalancerBackendAddressPoolsServer, func() *LoadBalancerBackendAddressPoolsServerTransport {
			return NewLoadBalancerBackendAddressPoolsServerTransport(&s.srv.LoadBalancerBackendAddressPoolsServer)
		})
		resp, err = s.trLoadBalancerBackendAddressPoolsServer.Do(req)
	case "LoadBalancerFrontendIPConfigurationsClient":
		initServer(s, &s.trLoadBalancerFrontendIPConfigurationsServer, func() *LoadBalancerFrontendIPConfigurationsServerTransport {
			return NewLoadBalancerFrontendIPConfigurationsServerTransport(&s.srv.LoadBalancerFrontendIPConfigurationsServer)
		})
		resp, err = s.trLoadBalancerFrontendIPConfigurationsServer.Do(req)
	case "LoadBalancerLoadBalancingRulesClient":
		initServer(s, &s.trLoadBalancerLoadBalancingRulesServer, func() *LoadBalancerLoadBalancingRulesServerTransport {
			return NewLoadBalancerLoadBalancingRulesServerTransport(&s.srv.LoadBalancerLoadBalancingRulesServer)
		})
		resp, err = s.trLoadBalancerLoadBalancingRulesServer.Do(req)
	case "LoadBalancerNetworkInterfacesClient":
		initServer(s, &s.trLoadBalancerNetworkInterfacesServer, func() *LoadBalancerNetworkInterfacesServerTransport {
			return NewLoadBalancerNetworkInterfacesServerTransport(&s.srv.LoadBalancerNetworkInterfacesServer)
		})
		resp, err = s.trLoadBalancerNetworkInterfacesServer.Do(req)
	case "LoadBalancerOutboundRulesClient":
		initServer(s, &s.trLoadBalancerOutboundRulesServer, func() *LoadBalancerOutboundRulesServerTransport {
			return NewLoadBalancerOutboundRulesServerTransport(&s.srv.LoadBalancerOutboundRulesServer)
		})
		resp, err = s.trLoadBalancerOutboundRulesServer.Do(req)
	case "LoadBalancerProbesClient":
		initServer(s, &s.trLoadBalancerProbesServer, func() *LoadBalancerProbesServerTransport {
			return NewLoadBalancerProbesServerTransport(&s.srv.LoadBalancerProbesServer)
		})
		resp, err = s.trLoadBalancerProbesServer.Do(req)
	case "LoadBalancersClient":
		initServer(s, &s.trLoadBalancersServer, func() *LoadBalancersServerTransport {
			return NewLoadBalancersServerTransport(&s.srv.LoadBalancersServer)
		})
		resp, err = s.trLoadBalancersServer.Do(req)
	case "LocalNetworkGatewaysClient":
		initServer(s, &s.trLocalNetworkGatewaysServer, func() *LocalNetworkGatewaysServerTransport {
			return NewLocalNetworkGatewaysServerTransport(&s.srv.LocalNetworkGatewaysServer)
		})
		resp, err = s.trLocalNetworkGatewaysServer.Do(req)
	case "ManagementClient":
		initServer(s, &s.trManagementServer, func() *ManagementServerTransport { return NewManagementServerTransport(&s.srv.ManagementServer) })
		resp, err = s.trManagementServer.Do(req)
	case "ManagementGroupNetworkManagerConnectionsClient":
		initServer(s, &s.trManagementGroupNetworkManagerConnectionsServer, func() *ManagementGroupNetworkManagerConnectionsServerTransport {
			return NewManagementGroupNetworkManagerConnectionsServerTransport(&s.srv.ManagementGroupNetworkManagerConnectionsServer)
		})
		resp, err = s.trManagementGroupNetworkManagerConnectionsServer.Do(req)
	case "ManagerCommitsClient":
		initServer(s, &s.trManagerCommitsServer, func() *ManagerCommitsServerTransport {
			return NewManagerCommitsServerTransport(&s.srv.ManagerCommitsServer)
		})
		resp, err = s.trManagerCommitsServer.Do(req)
	case "ManagerDeploymentStatusClient":
		initServer(s, &s.trManagerDeploymentStatusServer, func() *ManagerDeploymentStatusServerTransport {
			return NewManagerDeploymentStatusServerTransport(&s.srv.ManagerDeploymentStatusServer)
		})
		resp, err = s.trManagerDeploymentStatusServer.Do(req)
	case "ManagersClient":
		initServer(s, &s.trManagersServer, func() *ManagersServerTransport { return NewManagersServerTransport(&s.srv.ManagersServer) })
		resp, err = s.trManagersServer.Do(req)
	case "NatGatewaysClient":
		initServer(s, &s.trNatGatewaysServer, func() *NatGatewaysServerTransport { return NewNatGatewaysServerTransport(&s.srv.NatGatewaysServer) })
		resp, err = s.trNatGatewaysServer.Do(req)
	case "NatRulesClient":
		initServer(s, &s.trNatRulesServer, func() *NatRulesServerTransport { return NewNatRulesServerTransport(&s.srv.NatRulesServer) })
		resp, err = s.trNatRulesServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	case "P2SVPNGatewaysClient":
		initServer(s, &s.trP2SVPNGatewaysServer, func() *P2SVPNGatewaysServerTransport {
			return NewP2SVPNGatewaysServerTransport(&s.srv.P2SVPNGatewaysServer)
		})
		resp, err = s.trP2SVPNGatewaysServer.Do(req)
	case "PacketCapturesClient":
		initServer(s, &s.trPacketCapturesServer, func() *PacketCapturesServerTransport {
			return NewPacketCapturesServerTransport(&s.srv.PacketCapturesServer)
		})
		resp, err = s.trPacketCapturesServer.Do(req)
	case "PeerExpressRouteCircuitConnectionsClient":
		initServer(s, &s.trPeerExpressRouteCircuitConnectionsServer, func() *PeerExpressRouteCircuitConnectionsServerTransport {
			return NewPeerExpressRouteCircuitConnectionsServerTransport(&s.srv.PeerExpressRouteCircuitConnectionsServer)
		})
		resp, err = s.trPeerExpressRouteCircuitConnectionsServer.Do(req)
	case "PrivateDNSZoneGroupsClient":
		initServer(s, &s.trPrivateDNSZoneGroupsServer, func() *PrivateDNSZoneGroupsServerTransport {
			return NewPrivateDNSZoneGroupsServerTransport(&s.srv.PrivateDNSZoneGroupsServer)
		})
		resp, err = s.trPrivateDNSZoneGroupsServer.Do(req)
	case "PrivateEndpointsClient":
		initServer(s, &s.trPrivateEndpointsServer, func() *PrivateEndpointsServerTransport {
			return NewPrivateEndpointsServerTransport(&s.srv.PrivateEndpointsServer)
		})
		resp, err = s.trPrivateEndpointsServer.Do(req)
	case "PrivateLinkServicesClient":
		initServer(s, &s.trPrivateLinkServicesServer, func() *PrivateLinkServicesServerTransport {
			return NewPrivateLinkServicesServerTransport(&s.srv.PrivateLinkServicesServer)
		})
		resp, err = s.trPrivateLinkServicesServer.Do(req)
	case "ProfilesClient":
		initServer(s, &s.trProfilesServer, func() *ProfilesServerTransport { return NewProfilesServerTransport(&s.srv.ProfilesServer) })
		resp, err = s.trProfilesServer.Do(req)
	case "PublicIPAddressesClient":
		initServer(s, &s.trPublicIPAddressesServer, func() *PublicIPAddressesServerTransport {
			return NewPublicIPAddressesServerTransport(&s.srv.PublicIPAddressesServer)
		})
		resp, err = s.trPublicIPAddressesServer.Do(req)
	case "PublicIPPrefixesClient":
		initServer(s, &s.trPublicIPPrefixesServer, func() *PublicIPPrefixesServerTransport {
			return NewPublicIPPrefixesServerTransport(&s.srv.PublicIPPrefixesServer)
		})
		resp, err = s.trPublicIPPrefixesServer.Do(req)
	case "ResourceNavigationLinksClient":
		initServer(s, &s.trResourceNavigationLinksServer, func() *ResourceNavigationLinksServerTransport {
			return NewResourceNavigationLinksServerTransport(&s.srv.ResourceNavigationLinksServer)
		})
		resp, err = s.trResourceNavigationLinksServer.Do(req)
	case "RouteFilterRulesClient":
		initServer(s, &s.trRouteFilterRulesServer, func() *RouteFilterRulesServerTransport {
			return NewRouteFilterRulesServerTransport(&s.srv.RouteFilterRulesServer)
		})
		resp, err = s.trRouteFilterRulesServer.Do(req)
	case "RouteFiltersClient":
		initServer(s, &s.trRouteFiltersServer, func() *RouteFiltersServerTransport { return NewRouteFiltersServerTransport(&s.srv.RouteFiltersServer) })
		resp, err = s.trRouteFiltersServer.Do(req)
	case "RouteMapsClient":
		initServer(s, &s.trRouteMapsServer, func() *RouteMapsServerTransport { return NewRouteMapsServerTransport(&s.srv.RouteMapsServer) })
		resp, err = s.trRouteMapsServer.Do(req)
	case "RouteTablesClient":
		initServer(s, &s.trRouteTablesServer, func() *RouteTablesServerTransport { return NewRouteTablesServerTransport(&s.srv.RouteTablesServer) })
		resp, err = s.trRouteTablesServer.Do(req)
	case "RoutesClient":
		initServer(s, &s.trRoutesServer, func() *RoutesServerTransport { return NewRoutesServerTransport(&s.srv.RoutesServer) })
		resp, err = s.trRoutesServer.Do(req)
	case "RoutingIntentClient":
		initServer(s, &s.trRoutingIntentServer, func() *RoutingIntentServerTransport {
			return NewRoutingIntentServerTransport(&s.srv.RoutingIntentServer)
		})
		resp, err = s.trRoutingIntentServer.Do(req)
	case "ScopeConnectionsClient":
		initServer(s, &s.trScopeConnectionsServer, func() *ScopeConnectionsServerTransport {
			return NewScopeConnectionsServerTransport(&s.srv.ScopeConnectionsServer)
		})
		resp, err = s.trScopeConnectionsServer.Do(req)
	case "SecurityAdminConfigurationsClient":
		initServer(s, &s.trSecurityAdminConfigurationsServer, func() *SecurityAdminConfigurationsServerTransport {
			return NewSecurityAdminConfigurationsServerTransport(&s.srv.SecurityAdminConfigurationsServer)
		})
		resp, err = s.trSecurityAdminConfigurationsServer.Do(req)
	case "SecurityGroupsClient":
		initServer(s, &s.trSecurityGroupsServer, func() *SecurityGroupsServerTransport {
			return NewSecurityGroupsServerTransport(&s.srv.SecurityGroupsServer)
		})
		resp, err = s.trSecurityGroupsServer.Do(req)
	case "SecurityPartnerProvidersClient":
		initServer(s, &s.trSecurityPartnerProvidersServer, func() *SecurityPartnerProvidersServerTransport {
			return NewSecurityPartnerProvidersServerTransport(&s.srv.SecurityPartnerProvidersServer)
		})
		resp, err = s.trSecurityPartnerProvidersServer.Do(req)
	case "SecurityRulesClient":
		initServer(s, &s.trSecurityRulesServer, func() *SecurityRulesServerTransport {
			return NewSecurityRulesServerTransport(&s.srv.SecurityRulesServer)
		})
		resp, err = s.trSecurityRulesServer.Do(req)
	case "ServiceAssociationLinksClient":
		initServer(s, &s.trServiceAssociationLinksServer, func() *ServiceAssociationLinksServerTransport {
			return NewServiceAssociationLinksServerTransport(&s.srv.ServiceAssociationLinksServer)
		})
		resp, err = s.trServiceAssociationLinksServer.Do(req)
	case "ServiceEndpointPoliciesClient":
		initServer(s, &s.trServiceEndpointPoliciesServer, func() *ServiceEndpointPoliciesServerTransport {
			return NewServiceEndpointPoliciesServerTransport(&s.srv.ServiceEndpointPoliciesServer)
		})
		resp, err = s.trServiceEndpointPoliciesServer.Do(req)
	case "ServiceEndpointPolicyDefinitionsClient":
		initServer(s, &s.trServiceEndpointPolicyDefinitionsServer, func() *ServiceEndpointPolicyDefinitionsServerTransport {
			return NewServiceEndpointPolicyDefinitionsServerTransport(&s.srv.ServiceEndpointPolicyDefinitionsServer)
		})
		resp, err = s.trServiceEndpointPolicyDefinitionsServer.Do(req)
	case "ServiceTagInformationClient":
		initServer(s, &s.trServiceTagInformationServer, func() *ServiceTagInformationServerTransport {
			return NewServiceTagInformationServerTransport(&s.srv.ServiceTagInformationServer)
		})
		resp, err = s.trServiceTagInformationServer.Do(req)
	case "ServiceTagsClient":
		initServer(s, &s.trServiceTagsServer, func() *ServiceTagsServerTransport { return NewServiceTagsServerTransport(&s.srv.ServiceTagsServer) })
		resp, err = s.trServiceTagsServer.Do(req)
	case "StaticMembersClient":
		initServer(s, &s.trStaticMembersServer, func() *StaticMembersServerTransport {
			return NewStaticMembersServerTransport(&s.srv.StaticMembersServer)
		})
		resp, err = s.trStaticMembersServer.Do(req)
	case "SubnetsClient":
		initServer(s, &s.trSubnetsServer, func() *SubnetsServerTransport { return NewSubnetsServerTransport(&s.srv.SubnetsServer) })
		resp, err = s.trSubnetsServer.Do(req)
	case "SubscriptionNetworkManagerConnectionsClient":
		initServer(s, &s.trSubscriptionNetworkManagerConnectionsServer, func() *SubscriptionNetworkManagerConnectionsServerTransport {
			return NewSubscriptionNetworkManagerConnectionsServerTransport(&s.srv.SubscriptionNetworkManagerConnectionsServer)
		})
		resp, err = s.trSubscriptionNetworkManagerConnectionsServer.Do(req)
	case "UsagesClient":
		initServer(s, &s.trUsagesServer, func() *UsagesServerTransport { return NewUsagesServerTransport(&s.srv.UsagesServer) })
		resp, err = s.trUsagesServer.Do(req)
	case "VPNConnectionsClient":
		initServer(s, &s.trVPNConnectionsServer, func() *VPNConnectionsServerTransport {
			return NewVPNConnectionsServerTransport(&s.srv.VPNConnectionsServer)
		})
		resp, err = s.trVPNConnectionsServer.Do(req)
	case "VPNGatewaysClient":
		initServer(s, &s.trVPNGatewaysServer, func() *VPNGatewaysServerTransport { return NewVPNGatewaysServerTransport(&s.srv.VPNGatewaysServer) })
		resp, err = s.trVPNGatewaysServer.Do(req)
	case "VPNLinkConnectionsClient":
		initServer(s, &s.trVPNLinkConnectionsServer, func() *VPNLinkConnectionsServerTransport {
			return NewVPNLinkConnectionsServerTransport(&s.srv.VPNLinkConnectionsServer)
		})
		resp, err = s.trVPNLinkConnectionsServer.Do(req)
	case "VPNServerConfigurationsAssociatedWithVirtualWanClient":
		initServer(s, &s.trVPNServerConfigurationsAssociatedWithVirtualWanServer, func() *VPNServerConfigurationsAssociatedWithVirtualWanServerTransport {
			return NewVPNServerConfigurationsAssociatedWithVirtualWanServerTransport(&s.srv.VPNServerConfigurationsAssociatedWithVirtualWanServer)
		})
		resp, err = s.trVPNServerConfigurationsAssociatedWithVirtualWanServer.Do(req)
	case "VPNServerConfigurationsClient":
		initServer(s, &s.trVPNServerConfigurationsServer, func() *VPNServerConfigurationsServerTransport {
			return NewVPNServerConfigurationsServerTransport(&s.srv.VPNServerConfigurationsServer)
		})
		resp, err = s.trVPNServerConfigurationsServer.Do(req)
	case "VPNSiteLinkConnectionsClient":
		initServer(s, &s.trVPNSiteLinkConnectionsServer, func() *VPNSiteLinkConnectionsServerTransport {
			return NewVPNSiteLinkConnectionsServerTransport(&s.srv.VPNSiteLinkConnectionsServer)
		})
		resp, err = s.trVPNSiteLinkConnectionsServer.Do(req)
	case "VPNSiteLinksClient":
		initServer(s, &s.trVPNSiteLinksServer, func() *VPNSiteLinksServerTransport { return NewVPNSiteLinksServerTransport(&s.srv.VPNSiteLinksServer) })
		resp, err = s.trVPNSiteLinksServer.Do(req)
	case "VPNSitesClient":
		initServer(s, &s.trVPNSitesServer, func() *VPNSitesServerTransport { return NewVPNSitesServerTransport(&s.srv.VPNSitesServer) })
		resp, err = s.trVPNSitesServer.Do(req)
	case "VPNSitesConfigurationClient":
		initServer(s, &s.trVPNSitesConfigurationServer, func() *VPNSitesConfigurationServerTransport {
			return NewVPNSitesConfigurationServerTransport(&s.srv.VPNSitesConfigurationServer)
		})
		resp, err = s.trVPNSitesConfigurationServer.Do(req)
	case "VipSwapClient":
		initServer(s, &s.trVipSwapServer, func() *VipSwapServerTransport { return NewVipSwapServerTransport(&s.srv.VipSwapServer) })
		resp, err = s.trVipSwapServer.Do(req)
	case "VirtualApplianceConnectionsClient":
		initServer(s, &s.trVirtualApplianceConnectionsServer, func() *VirtualApplianceConnectionsServerTransport {
			return NewVirtualApplianceConnectionsServerTransport(&s.srv.VirtualApplianceConnectionsServer)
		})
		resp, err = s.trVirtualApplianceConnectionsServer.Do(req)
	case "VirtualApplianceSKUsClient":
		initServer(s, &s.trVirtualApplianceSKUsServer, func() *VirtualApplianceSKUsServerTransport {
			return NewVirtualApplianceSKUsServerTransport(&s.srv.VirtualApplianceSKUsServer)
		})
		resp, err = s.trVirtualApplianceSKUsServer.Do(req)
	case "VirtualApplianceSitesClient":
		initServer(s, &s.trVirtualApplianceSitesServer, func() *VirtualApplianceSitesServerTransport {
			return NewVirtualApplianceSitesServerTransport(&s.srv.VirtualApplianceSitesServer)
		})
		resp, err = s.trVirtualApplianceSitesServer.Do(req)
	case "VirtualAppliancesClient":
		initServer(s, &s.trVirtualAppliancesServer, func() *VirtualAppliancesServerTransport {
			return NewVirtualAppliancesServerTransport(&s.srv.VirtualAppliancesServer)
		})
		resp, err = s.trVirtualAppliancesServer.Do(req)
	case "VirtualHubBgpConnectionClient":
		initServer(s, &s.trVirtualHubBgpConnectionServer, func() *VirtualHubBgpConnectionServerTransport {
			return NewVirtualHubBgpConnectionServerTransport(&s.srv.VirtualHubBgpConnectionServer)
		})
		resp, err = s.trVirtualHubBgpConnectionServer.Do(req)
	case "VirtualHubBgpConnectionsClient":
		initServer(s, &s.trVirtualHubBgpConnectionsServer, func() *VirtualHubBgpConnectionsServerTransport {
			return NewVirtualHubBgpConnectionsServerTransport(&s.srv.VirtualHubBgpConnectionsServer)
		})
		resp, err = s.trVirtualHubBgpConnectionsServer.Do(req)
	case "VirtualHubIPConfigurationClient":
		initServer(s, &s.trVirtualHubIPConfigurationServer, func() *VirtualHubIPConfigurationServerTransport {
			return NewVirtualHubIPConfigurationServerTransport(&s.srv.VirtualHubIPConfigurationServer)
		})
		resp, err = s.trVirtualHubIPConfigurationServer.Do(req)
	case "VirtualHubRouteTableV2SClient":
		initServer(s, &s.trVirtualHubRouteTableV2SServer, func() *VirtualHubRouteTableV2SServerTransport {
			return NewVirtualHubRouteTableV2SServerTransport(&s.srv.VirtualHubRouteTableV2SServer)
		})
		resp, err = s.trVirtualHubRouteTableV2SServer.Do(req)
	case "VirtualHubsClient":
		initServer(s, &s.trVirtualHubsServer, func() *VirtualHubsServerTransport { return NewVirtualHubsServerTransport(&s.srv.VirtualHubsServer) })
		resp, err = s.trVirtualHubsServer.Do(req)
	case "VirtualNetworkGatewayConnectionsClient":
		initServer(s, &s.trVirtualNetworkGatewayConnectionsServer, func() *VirtualNetworkGatewayConnectionsServerTransport {
			return NewVirtualNetworkGatewayConnectionsServerTransport(&s.srv.VirtualNetworkGatewayConnectionsServer)
		})
		resp, err = s.trVirtualNetworkGatewayConnectionsServer.Do(req)
	case "VirtualNetworkGatewayNatRulesClient":
		initServer(s, &s.trVirtualNetworkGatewayNatRulesServer, func() *VirtualNetworkGatewayNatRulesServerTransport {
			return NewVirtualNetworkGatewayNatRulesServerTransport(&s.srv.VirtualNetworkGatewayNatRulesServer)
		})
		resp, err = s.trVirtualNetworkGatewayNatRulesServer.Do(req)
	case "VirtualNetworkGatewaysClient":
		initServer(s, &s.trVirtualNetworkGatewaysServer, func() *VirtualNetworkGatewaysServerTransport {
			return NewVirtualNetworkGatewaysServerTransport(&s.srv.VirtualNetworkGatewaysServer)
		})
		resp, err = s.trVirtualNetworkGatewaysServer.Do(req)
	case "VirtualNetworkPeeringsClient":
		initServer(s, &s.trVirtualNetworkPeeringsServer, func() *VirtualNetworkPeeringsServerTransport {
			return NewVirtualNetworkPeeringsServerTransport(&s.srv.VirtualNetworkPeeringsServer)
		})
		resp, err = s.trVirtualNetworkPeeringsServer.Do(req)
	case "VirtualNetworkTapsClient":
		initServer(s, &s.trVirtualNetworkTapsServer, func() *VirtualNetworkTapsServerTransport {
			return NewVirtualNetworkTapsServerTransport(&s.srv.VirtualNetworkTapsServer)
		})
		resp, err = s.trVirtualNetworkTapsServer.Do(req)
	case "VirtualNetworksClient":
		initServer(s, &s.trVirtualNetworksServer, func() *VirtualNetworksServerTransport {
			return NewVirtualNetworksServerTransport(&s.srv.VirtualNetworksServer)
		})
		resp, err = s.trVirtualNetworksServer.Do(req)
	case "VirtualRouterPeeringsClient":
		initServer(s, &s.trVirtualRouterPeeringsServer, func() *VirtualRouterPeeringsServerTransport {
			return NewVirtualRouterPeeringsServerTransport(&s.srv.VirtualRouterPeeringsServer)
		})
		resp, err = s.trVirtualRouterPeeringsServer.Do(req)
	case "VirtualRoutersClient":
		initServer(s, &s.trVirtualRoutersServer, func() *VirtualRoutersServerTransport {
			return NewVirtualRoutersServerTransport(&s.srv.VirtualRoutersServer)
		})
		resp, err = s.trVirtualRoutersServer.Do(req)
	case "VirtualWansClient":
		initServer(s, &s.trVirtualWansServer, func() *VirtualWansServerTransport { return NewVirtualWansServerTransport(&s.srv.VirtualWansServer) })
		resp, err = s.trVirtualWansServer.Do(req)
	case "WatchersClient":
		initServer(s, &s.trWatchersServer, func() *WatchersServerTransport { return NewWatchersServerTransport(&s.srv.WatchersServer) })
		resp, err = s.trWatchersServer.Do(req)
	case "WebApplicationFirewallPoliciesClient":
		initServer(s, &s.trWebApplicationFirewallPoliciesServer, func() *WebApplicationFirewallPoliciesServerTransport {
			return NewWebApplicationFirewallPoliciesServerTransport(&s.srv.WebApplicationFirewallPoliciesServer)
		})
		resp, err = s.trWebApplicationFirewallPoliciesServer.Do(req)
	case "WebCategoriesClient":
		initServer(s, &s.trWebCategoriesServer, func() *WebCategoriesServerTransport {
			return NewWebCategoriesServerTransport(&s.srv.WebCategoriesServer)
		})
		resp, err = s.trWebCategoriesServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
