// Copyright 2020-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.5
// 	protoc        (unknown)
// source: buf/alpha/registry/v1alpha1/doc.proto

package registryv1alpha1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// FieldType indicates whether a field is a normal, an extension or an any.
type FieldType int32

const (
	FieldType_FIELD_TYPE_UNSPECIFIED FieldType = 0
	FieldType_FIELD_TYPE_NORMAL      FieldType = 1
	FieldType_FIELD_TYPE_EXTENSION   FieldType = 2
	FieldType_FIELD_TYPE_ANY         FieldType = 3
)

// Enum value maps for FieldType.
var (
	FieldType_name = map[int32]string{
		0: "FIELD_TYPE_UNSPECIFIED",
		1: "FIELD_TYPE_NORMAL",
		2: "FIELD_TYPE_EXTENSION",
		3: "FIELD_TYPE_ANY",
	}
	FieldType_value = map[string]int32{
		"FIELD_TYPE_UNSPECIFIED": 0,
		"FIELD_TYPE_NORMAL":      1,
		"FIELD_TYPE_EXTENSION":   2,
		"FIELD_TYPE_ANY":         3,
	}
)

func (x FieldType) Enum() *FieldType {
	p := new(FieldType)
	*p = x
	return p
}

func (x FieldType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FieldType) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_registry_v1alpha1_doc_proto_enumTypes[0].Descriptor()
}

func (FieldType) Type() protoreflect.EnumType {
	return &file_buf_alpha_registry_v1alpha1_doc_proto_enumTypes[0]
}

func (x FieldType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// GetSourceDirectoryInfoRequest takes an owner, repository, and reference.
type GetSourceDirectoryInfoRequest struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Owner      string                 `protobuf:"bytes,1,opt,name=owner,proto3"`
	xxx_hidden_Repository string                 `protobuf:"bytes,2,opt,name=repository,proto3"`
	xxx_hidden_Reference  string                 `protobuf:"bytes,3,opt,name=reference,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *GetSourceDirectoryInfoRequest) Reset() {
	*x = GetSourceDirectoryInfoRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetSourceDirectoryInfoRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSourceDirectoryInfoRequest) ProtoMessage() {}

func (x *GetSourceDirectoryInfoRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetSourceDirectoryInfoRequest) GetOwner() string {
	if x != nil {
		return x.xxx_hidden_Owner
	}
	return ""
}

func (x *GetSourceDirectoryInfoRequest) GetRepository() string {
	if x != nil {
		return x.xxx_hidden_Repository
	}
	return ""
}

func (x *GetSourceDirectoryInfoRequest) GetReference() string {
	if x != nil {
		return x.xxx_hidden_Reference
	}
	return ""
}

func (x *GetSourceDirectoryInfoRequest) SetOwner(v string) {
	x.xxx_hidden_Owner = v
}

func (x *GetSourceDirectoryInfoRequest) SetRepository(v string) {
	x.xxx_hidden_Repository = v
}

func (x *GetSourceDirectoryInfoRequest) SetReference(v string) {
	x.xxx_hidden_Reference = v
}

type GetSourceDirectoryInfoRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Owner      string
	Repository string
	// Optional reference (if unspecified, will use the repository's default_branch).
	Reference string
}

func (b0 GetSourceDirectoryInfoRequest_builder) Build() *GetSourceDirectoryInfoRequest {
	m0 := &GetSourceDirectoryInfoRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Owner = b.Owner
	x.xxx_hidden_Repository = b.Repository
	x.xxx_hidden_Reference = b.Reference
	return m0
}

// GetSourceDirectoryInfoResponse returns the root FileInfo for the requested module.
type GetSourceDirectoryInfoResponse struct {
	state           protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Root *FileInfo              `protobuf:"bytes,1,opt,name=root,proto3"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *GetSourceDirectoryInfoResponse) Reset() {
	*x = GetSourceDirectoryInfoResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetSourceDirectoryInfoResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSourceDirectoryInfoResponse) ProtoMessage() {}

func (x *GetSourceDirectoryInfoResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetSourceDirectoryInfoResponse) GetRoot() *FileInfo {
	if x != nil {
		return x.xxx_hidden_Root
	}
	return nil
}

func (x *GetSourceDirectoryInfoResponse) SetRoot(v *FileInfo) {
	x.xxx_hidden_Root = v
}

func (x *GetSourceDirectoryInfoResponse) HasRoot() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Root != nil
}

func (x *GetSourceDirectoryInfoResponse) ClearRoot() {
	x.xxx_hidden_Root = nil
}

type GetSourceDirectoryInfoResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Root *FileInfo
}

func (b0 GetSourceDirectoryInfoResponse_builder) Build() *GetSourceDirectoryInfoResponse {
	m0 := &GetSourceDirectoryInfoResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Root = b.Root
	return m0
}

// FileInfo is a nested structure that contains the file path, whether or not it's a directory,
// and if so, the FileInfo children of that directory.
type FileInfo struct {
	state               protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Path     string                 `protobuf:"bytes,1,opt,name=path,proto3"`
	xxx_hidden_IsDir    bool                   `protobuf:"varint,2,opt,name=is_dir,json=isDir,proto3"`
	xxx_hidden_Children *[]*FileInfo           `protobuf:"bytes,3,rep,name=children,proto3"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *FileInfo) Reset() {
	*x = FileInfo{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FileInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileInfo) ProtoMessage() {}

func (x *FileInfo) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *FileInfo) GetPath() string {
	if x != nil {
		return x.xxx_hidden_Path
	}
	return ""
}

func (x *FileInfo) GetIsDir() bool {
	if x != nil {
		return x.xxx_hidden_IsDir
	}
	return false
}

func (x *FileInfo) GetChildren() []*FileInfo {
	if x != nil {
		if x.xxx_hidden_Children != nil {
			return *x.xxx_hidden_Children
		}
	}
	return nil
}

func (x *FileInfo) SetPath(v string) {
	x.xxx_hidden_Path = v
}

func (x *FileInfo) SetIsDir(v bool) {
	x.xxx_hidden_IsDir = v
}

func (x *FileInfo) SetChildren(v []*FileInfo) {
	x.xxx_hidden_Children = &v
}

type FileInfo_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// the normalized path of the directory, relative to the root of the module.
	Path     string
	IsDir    bool
	Children []*FileInfo
}

func (b0 FileInfo_builder) Build() *FileInfo {
	m0 := &FileInfo{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Path = b.Path
	x.xxx_hidden_IsDir = b.IsDir
	x.xxx_hidden_Children = &b.Children
	return m0
}

// GetSourceFileRequest takes an owner, repository, reference, and normalized path.
type GetSourceFileRequest struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Owner      string                 `protobuf:"bytes,1,opt,name=owner,proto3"`
	xxx_hidden_Repository string                 `protobuf:"bytes,2,opt,name=repository,proto3"`
	xxx_hidden_Reference  string                 `protobuf:"bytes,3,opt,name=reference,proto3"`
	xxx_hidden_Path       string                 `protobuf:"bytes,4,opt,name=path,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *GetSourceFileRequest) Reset() {
	*x = GetSourceFileRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetSourceFileRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSourceFileRequest) ProtoMessage() {}

func (x *GetSourceFileRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetSourceFileRequest) GetOwner() string {
	if x != nil {
		return x.xxx_hidden_Owner
	}
	return ""
}

func (x *GetSourceFileRequest) GetRepository() string {
	if x != nil {
		return x.xxx_hidden_Repository
	}
	return ""
}

func (x *GetSourceFileRequest) GetReference() string {
	if x != nil {
		return x.xxx_hidden_Reference
	}
	return ""
}

func (x *GetSourceFileRequest) GetPath() string {
	if x != nil {
		return x.xxx_hidden_Path
	}
	return ""
}

func (x *GetSourceFileRequest) SetOwner(v string) {
	x.xxx_hidden_Owner = v
}

func (x *GetSourceFileRequest) SetRepository(v string) {
	x.xxx_hidden_Repository = v
}

func (x *GetSourceFileRequest) SetReference(v string) {
	x.xxx_hidden_Reference = v
}

func (x *GetSourceFileRequest) SetPath(v string) {
	x.xxx_hidden_Path = v
}

type GetSourceFileRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Owner      string
	Repository string
	// Optional reference (if unspecified, will use the repository's default_branch).
	Reference string
	// the normalized path to the requested file, relative to the root of the module.
	Path string
}

func (b0 GetSourceFileRequest_builder) Build() *GetSourceFileRequest {
	m0 := &GetSourceFileRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Owner = b.Owner
	x.xxx_hidden_Repository = b.Repository
	x.xxx_hidden_Reference = b.Reference
	x.xxx_hidden_Path = b.Path
	return m0
}

// GetSourceFileResponse returns the source code contents of the requested file.
type GetSourceFileResponse struct {
	state              protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Content []byte                 `protobuf:"bytes,1,opt,name=content,proto3"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *GetSourceFileResponse) Reset() {
	*x = GetSourceFileResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetSourceFileResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSourceFileResponse) ProtoMessage() {}

func (x *GetSourceFileResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetSourceFileResponse) GetContent() []byte {
	if x != nil {
		return x.xxx_hidden_Content
	}
	return nil
}

func (x *GetSourceFileResponse) SetContent(v []byte) {
	if v == nil {
		v = []byte{}
	}
	x.xxx_hidden_Content = v
}

type GetSourceFileResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// content is the content of the file.
	Content []byte
}

func (b0 GetSourceFileResponse_builder) Build() *GetSourceFileResponse {
	m0 := &GetSourceFileResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Content = b.Content
	return m0
}

// GetModulePackagesRequest takes an owner, repository, and reference.
type GetModulePackagesRequest struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Owner      string                 `protobuf:"bytes,1,opt,name=owner,proto3"`
	xxx_hidden_Repository string                 `protobuf:"bytes,2,opt,name=repository,proto3"`
	xxx_hidden_Reference  string                 `protobuf:"bytes,3,opt,name=reference,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *GetModulePackagesRequest) Reset() {
	*x = GetModulePackagesRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetModulePackagesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetModulePackagesRequest) ProtoMessage() {}

func (x *GetModulePackagesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetModulePackagesRequest) GetOwner() string {
	if x != nil {
		return x.xxx_hidden_Owner
	}
	return ""
}

func (x *GetModulePackagesRequest) GetRepository() string {
	if x != nil {
		return x.xxx_hidden_Repository
	}
	return ""
}

func (x *GetModulePackagesRequest) GetReference() string {
	if x != nil {
		return x.xxx_hidden_Reference
	}
	return ""
}

func (x *GetModulePackagesRequest) SetOwner(v string) {
	x.xxx_hidden_Owner = v
}

func (x *GetModulePackagesRequest) SetRepository(v string) {
	x.xxx_hidden_Repository = v
}

func (x *GetModulePackagesRequest) SetReference(v string) {
	x.xxx_hidden_Reference = v
}

type GetModulePackagesRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Owner      string
	Repository string
	// Optional reference (if unspecified, will use the repository's default_branch).
	Reference string
}

func (b0 GetModulePackagesRequest_builder) Build() *GetModulePackagesRequest {
	m0 := &GetModulePackagesRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Owner = b.Owner
	x.xxx_hidden_Repository = b.Repository
	x.xxx_hidden_Reference = b.Reference
	return m0
}

// GetModulePackagesResponse returns the list of ModulePackages for the requested module.
type GetModulePackagesResponse struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Name           string                 `protobuf:"bytes,1,opt,name=name,proto3"`
	xxx_hidden_ModulePackages *[]*ModulePackage      `protobuf:"bytes,2,rep,name=module_packages,json=modulePackages,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *GetModulePackagesResponse) Reset() {
	*x = GetModulePackagesResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetModulePackagesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetModulePackagesResponse) ProtoMessage() {}

func (x *GetModulePackagesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetModulePackagesResponse) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *GetModulePackagesResponse) GetModulePackages() []*ModulePackage {
	if x != nil {
		if x.xxx_hidden_ModulePackages != nil {
			return *x.xxx_hidden_ModulePackages
		}
	}
	return nil
}

func (x *GetModulePackagesResponse) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *GetModulePackagesResponse) SetModulePackages(v []*ModulePackage) {
	x.xxx_hidden_ModulePackages = &v
}

type GetModulePackagesResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Name           string
	ModulePackages []*ModulePackage
}

func (b0 GetModulePackagesResponse_builder) Build() *GetModulePackagesResponse {
	m0 := &GetModulePackagesResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_ModulePackages = &b.ModulePackages
	return m0
}

// ModulePackage provides the details about a module's associated package.
type ModulePackage struct {
	state                  protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Name        string                 `protobuf:"bytes,1,opt,name=name,proto3"`
	xxx_hidden_Description string                 `protobuf:"bytes,2,opt,name=description,proto3"`
	unknownFields          protoimpl.UnknownFields
	sizeCache              protoimpl.SizeCache
}

func (x *ModulePackage) Reset() {
	*x = ModulePackage{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ModulePackage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModulePackage) ProtoMessage() {}

func (x *ModulePackage) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ModulePackage) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *ModulePackage) GetDescription() string {
	if x != nil {
		return x.xxx_hidden_Description
	}
	return ""
}

func (x *ModulePackage) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *ModulePackage) SetDescription(v string) {
	x.xxx_hidden_Description = v
}

type ModulePackage_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Name        string
	Description string
}

func (b0 ModulePackage_builder) Build() *ModulePackage {
	m0 := &ModulePackage{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_Description = b.Description
	return m0
}

// GetModuleDocumentationRequest takes an owner, repository, and reference.
type GetModuleDocumentationRequest struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Owner      string                 `protobuf:"bytes,1,opt,name=owner,proto3"`
	xxx_hidden_Repository string                 `protobuf:"bytes,2,opt,name=repository,proto3"`
	xxx_hidden_Reference  string                 `protobuf:"bytes,3,opt,name=reference,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *GetModuleDocumentationRequest) Reset() {
	*x = GetModuleDocumentationRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetModuleDocumentationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetModuleDocumentationRequest) ProtoMessage() {}

func (x *GetModuleDocumentationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetModuleDocumentationRequest) GetOwner() string {
	if x != nil {
		return x.xxx_hidden_Owner
	}
	return ""
}

func (x *GetModuleDocumentationRequest) GetRepository() string {
	if x != nil {
		return x.xxx_hidden_Repository
	}
	return ""
}

func (x *GetModuleDocumentationRequest) GetReference() string {
	if x != nil {
		return x.xxx_hidden_Reference
	}
	return ""
}

func (x *GetModuleDocumentationRequest) SetOwner(v string) {
	x.xxx_hidden_Owner = v
}

func (x *GetModuleDocumentationRequest) SetRepository(v string) {
	x.xxx_hidden_Repository = v
}

func (x *GetModuleDocumentationRequest) SetReference(v string) {
	x.xxx_hidden_Reference = v
}

type GetModuleDocumentationRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Owner      string
	Repository string
	// Optional reference (if unspecified, will use the repository's default_branch).
	Reference string
}

func (b0 GetModuleDocumentationRequest_builder) Build() *GetModuleDocumentationRequest {
	m0 := &GetModuleDocumentationRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Owner = b.Owner
	x.xxx_hidden_Repository = b.Repository
	x.xxx_hidden_Reference = b.Reference
	return m0
}

// GetModuleDocumentationResponse returns the ModuleDocumentation for the requested module.
type GetModuleDocumentationResponse struct {
	state                          protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_ModuleDocumentation *ModuleDocumentation   `protobuf:"bytes,1,opt,name=module_documentation,json=moduleDocumentation,proto3"`
	unknownFields                  protoimpl.UnknownFields
	sizeCache                      protoimpl.SizeCache
}

func (x *GetModuleDocumentationResponse) Reset() {
	*x = GetModuleDocumentationResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetModuleDocumentationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetModuleDocumentationResponse) ProtoMessage() {}

func (x *GetModuleDocumentationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetModuleDocumentationResponse) GetModuleDocumentation() *ModuleDocumentation {
	if x != nil {
		return x.xxx_hidden_ModuleDocumentation
	}
	return nil
}

func (x *GetModuleDocumentationResponse) SetModuleDocumentation(v *ModuleDocumentation) {
	x.xxx_hidden_ModuleDocumentation = v
}

func (x *GetModuleDocumentationResponse) HasModuleDocumentation() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_ModuleDocumentation != nil
}

func (x *GetModuleDocumentationResponse) ClearModuleDocumentation() {
	x.xxx_hidden_ModuleDocumentation = nil
}

type GetModuleDocumentationResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	ModuleDocumentation *ModuleDocumentation
}

func (b0 GetModuleDocumentationResponse_builder) Build() *GetModuleDocumentationResponse {
	m0 := &GetModuleDocumentationResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_ModuleDocumentation = b.ModuleDocumentation
	return m0
}

// ModuleDocumentation provides the name of the module and associated documentations.
type ModuleDocumentation struct {
	state                        protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Name              string                 `protobuf:"bytes,1,opt,name=name,proto3"`
	xxx_hidden_Documentation     string                 `protobuf:"bytes,3,opt,name=documentation,proto3"`
	xxx_hidden_License           string                 `protobuf:"bytes,4,opt,name=license,proto3"`
	xxx_hidden_DocumentationPath string                 `protobuf:"bytes,5,opt,name=documentation_path,json=documentationPath,proto3"`
	unknownFields                protoimpl.UnknownFields
	sizeCache                    protoimpl.SizeCache
}

func (x *ModuleDocumentation) Reset() {
	*x = ModuleDocumentation{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ModuleDocumentation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModuleDocumentation) ProtoMessage() {}

func (x *ModuleDocumentation) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ModuleDocumentation) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *ModuleDocumentation) GetDocumentation() string {
	if x != nil {
		return x.xxx_hidden_Documentation
	}
	return ""
}

func (x *ModuleDocumentation) GetLicense() string {
	if x != nil {
		return x.xxx_hidden_License
	}
	return ""
}

func (x *ModuleDocumentation) GetDocumentationPath() string {
	if x != nil {
		return x.xxx_hidden_DocumentationPath
	}
	return ""
}

func (x *ModuleDocumentation) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *ModuleDocumentation) SetDocumentation(v string) {
	x.xxx_hidden_Documentation = v
}

func (x *ModuleDocumentation) SetLicense(v string) {
	x.xxx_hidden_License = v
}

func (x *ModuleDocumentation) SetDocumentationPath(v string) {
	x.xxx_hidden_DocumentationPath = v
}

type ModuleDocumentation_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Name string
	// This is the string representation of the contents of the buf.md file for module-level documentation.
	//
	// The buf.md file is a part of the module.
	// string is used to enforce UTF-8 encoding or 7-bit ASCII text.
	Documentation string
	// This is the string representation of the contents of the LICENSE file for module-level license.
	//
	// The LICENSE file is a part of the module.
	// string is used to enforce UTF-8 encoding or 7-bit ASCII text.
	License string
	// documentation_path is the path of the file which contains the module documentation.
	//
	// either `buf.md`, `README.md` or `README.markdown`.
	// if empty, assumes buf.md.
	DocumentationPath string
}

func (b0 ModuleDocumentation_builder) Build() *ModuleDocumentation {
	m0 := &ModuleDocumentation{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_Documentation = b.Documentation
	x.xxx_hidden_License = b.License
	x.xxx_hidden_DocumentationPath = b.DocumentationPath
	return m0
}

// GetPackageDocumentationRequest takes an owner, repository, reference, and package name.
type GetPackageDocumentationRequest struct {
	state                  protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Owner       string                 `protobuf:"bytes,1,opt,name=owner,proto3"`
	xxx_hidden_Repository  string                 `protobuf:"bytes,2,opt,name=repository,proto3"`
	xxx_hidden_Reference   string                 `protobuf:"bytes,3,opt,name=reference,proto3"`
	xxx_hidden_PackageName string                 `protobuf:"bytes,4,opt,name=package_name,json=packageName,proto3"`
	unknownFields          protoimpl.UnknownFields
	sizeCache              protoimpl.SizeCache
}

func (x *GetPackageDocumentationRequest) Reset() {
	*x = GetPackageDocumentationRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetPackageDocumentationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPackageDocumentationRequest) ProtoMessage() {}

func (x *GetPackageDocumentationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetPackageDocumentationRequest) GetOwner() string {
	if x != nil {
		return x.xxx_hidden_Owner
	}
	return ""
}

func (x *GetPackageDocumentationRequest) GetRepository() string {
	if x != nil {
		return x.xxx_hidden_Repository
	}
	return ""
}

func (x *GetPackageDocumentationRequest) GetReference() string {
	if x != nil {
		return x.xxx_hidden_Reference
	}
	return ""
}

func (x *GetPackageDocumentationRequest) GetPackageName() string {
	if x != nil {
		return x.xxx_hidden_PackageName
	}
	return ""
}

func (x *GetPackageDocumentationRequest) SetOwner(v string) {
	x.xxx_hidden_Owner = v
}

func (x *GetPackageDocumentationRequest) SetRepository(v string) {
	x.xxx_hidden_Repository = v
}

func (x *GetPackageDocumentationRequest) SetReference(v string) {
	x.xxx_hidden_Reference = v
}

func (x *GetPackageDocumentationRequest) SetPackageName(v string) {
	x.xxx_hidden_PackageName = v
}

type GetPackageDocumentationRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Owner      string
	Repository string
	// Optional reference (if unspecified, will use the repository's default_branch).
	Reference string
	// this is the fully qualified package name.
	PackageName string
}

func (b0 GetPackageDocumentationRequest_builder) Build() *GetPackageDocumentationRequest {
	m0 := &GetPackageDocumentationRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Owner = b.Owner
	x.xxx_hidden_Repository = b.Repository
	x.xxx_hidden_Reference = b.Reference
	x.xxx_hidden_PackageName = b.PackageName
	return m0
}

// GetPackageDocumentationResponse returns the documentation for the requested package.
type GetPackageDocumentationResponse struct {
	state                           protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_PackageDocumentation *PackageDocumentation  `protobuf:"bytes,1,opt,name=package_documentation,json=packageDocumentation,proto3"`
	unknownFields                   protoimpl.UnknownFields
	sizeCache                       protoimpl.SizeCache
}

func (x *GetPackageDocumentationResponse) Reset() {
	*x = GetPackageDocumentationResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetPackageDocumentationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPackageDocumentationResponse) ProtoMessage() {}

func (x *GetPackageDocumentationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetPackageDocumentationResponse) GetPackageDocumentation() *PackageDocumentation {
	if x != nil {
		return x.xxx_hidden_PackageDocumentation
	}
	return nil
}

func (x *GetPackageDocumentationResponse) SetPackageDocumentation(v *PackageDocumentation) {
	x.xxx_hidden_PackageDocumentation = v
}

func (x *GetPackageDocumentationResponse) HasPackageDocumentation() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_PackageDocumentation != nil
}

func (x *GetPackageDocumentationResponse) ClearPackageDocumentation() {
	x.xxx_hidden_PackageDocumentation = nil
}

type GetPackageDocumentationResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	PackageDocumentation *PackageDocumentation
}

func (b0 GetPackageDocumentationResponse_builder) Build() *GetPackageDocumentationResponse {
	m0 := &GetPackageDocumentationResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_PackageDocumentation = b.PackageDocumentation
	return m0
}

// PackageDocumentation provides the name, description, and top level types defined in the package.
type PackageDocumentation struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Name           string                 `protobuf:"bytes,1,opt,name=name,proto3"`
	xxx_hidden_Comments       string                 `protobuf:"bytes,2,opt,name=comments,proto3"`
	xxx_hidden_Services       *[]*Service            `protobuf:"bytes,3,rep,name=services,proto3"`
	xxx_hidden_Enums          *[]*Enum               `protobuf:"bytes,4,rep,name=enums,proto3"`
	xxx_hidden_Messages       *[]*Message            `protobuf:"bytes,5,rep,name=messages,proto3"`
	xxx_hidden_FileExtensions *[]*FileExtension      `protobuf:"bytes,6,rep,name=file_extensions,json=fileExtensions,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *PackageDocumentation) Reset() {
	*x = PackageDocumentation{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PackageDocumentation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PackageDocumentation) ProtoMessage() {}

func (x *PackageDocumentation) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PackageDocumentation) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *PackageDocumentation) GetComments() string {
	if x != nil {
		return x.xxx_hidden_Comments
	}
	return ""
}

func (x *PackageDocumentation) GetServices() []*Service {
	if x != nil {
		if x.xxx_hidden_Services != nil {
			return *x.xxx_hidden_Services
		}
	}
	return nil
}

func (x *PackageDocumentation) GetEnums() []*Enum {
	if x != nil {
		if x.xxx_hidden_Enums != nil {
			return *x.xxx_hidden_Enums
		}
	}
	return nil
}

func (x *PackageDocumentation) GetMessages() []*Message {
	if x != nil {
		if x.xxx_hidden_Messages != nil {
			return *x.xxx_hidden_Messages
		}
	}
	return nil
}

func (x *PackageDocumentation) GetFileExtensions() []*FileExtension {
	if x != nil {
		if x.xxx_hidden_FileExtensions != nil {
			return *x.xxx_hidden_FileExtensions
		}
	}
	return nil
}

func (x *PackageDocumentation) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *PackageDocumentation) SetComments(v string) {
	x.xxx_hidden_Comments = v
}

func (x *PackageDocumentation) SetServices(v []*Service) {
	x.xxx_hidden_Services = &v
}

func (x *PackageDocumentation) SetEnums(v []*Enum) {
	x.xxx_hidden_Enums = &v
}

func (x *PackageDocumentation) SetMessages(v []*Message) {
	x.xxx_hidden_Messages = &v
}

func (x *PackageDocumentation) SetFileExtensions(v []*FileExtension) {
	x.xxx_hidden_FileExtensions = &v
}

type PackageDocumentation_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Name string
	// comments contains the package-level comment documentation.
	// There is currently no convention for this.
	//
	// This is derived from the leading comments at the top level of the package.
	// Paragraph newlines (double new lines) are respected, however single newlines are not.
	// Note that any leading and trailing `//` or spaces within a `/* */` block will be stripped.
	Comments string
	// services contains all the services defined in the package in alphabetical order.
	Services []*Service
	// enums contains all the enums defined in the package in alphabetical order.
	Enums []*Enum
	// messages contains all the messages defined in the package in alphabetical order.
	Messages []*Message
	// extensions contains all the file level extensions in the package in alphabetical order.
	FileExtensions []*FileExtension
}

func (b0 PackageDocumentation_builder) Build() *PackageDocumentation {
	m0 := &PackageDocumentation{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_Comments = b.Comments
	x.xxx_hidden_Services = &b.Services
	x.xxx_hidden_Enums = &b.Enums
	x.xxx_hidden_Messages = &b.Messages
	x.xxx_hidden_FileExtensions = &b.FileExtensions
	return m0
}

// Location provides the location information for the source code.
//
// This does not provide the leading or trailing comments as these will
// be parsed into descriptions or dropped respectively.
type Location struct {
	state                  protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_StartLine   int32                  `protobuf:"varint,1,opt,name=start_line,json=startLine,proto3"`
	xxx_hidden_StartColumn int32                  `protobuf:"varint,2,opt,name=start_column,json=startColumn,proto3"`
	xxx_hidden_EndLine     int32                  `protobuf:"varint,3,opt,name=end_line,json=endLine,proto3"`
	xxx_hidden_EndColumn   int32                  `protobuf:"varint,4,opt,name=end_column,json=endColumn,proto3"`
	unknownFields          protoimpl.UnknownFields
	sizeCache              protoimpl.SizeCache
}

func (x *Location) Reset() {
	*x = Location{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Location) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Location) ProtoMessage() {}

func (x *Location) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Location) GetStartLine() int32 {
	if x != nil {
		return x.xxx_hidden_StartLine
	}
	return 0
}

func (x *Location) GetStartColumn() int32 {
	if x != nil {
		return x.xxx_hidden_StartColumn
	}
	return 0
}

func (x *Location) GetEndLine() int32 {
	if x != nil {
		return x.xxx_hidden_EndLine
	}
	return 0
}

func (x *Location) GetEndColumn() int32 {
	if x != nil {
		return x.xxx_hidden_EndColumn
	}
	return 0
}

func (x *Location) SetStartLine(v int32) {
	x.xxx_hidden_StartLine = v
}

func (x *Location) SetStartColumn(v int32) {
	x.xxx_hidden_StartColumn = v
}

func (x *Location) SetEndLine(v int32) {
	x.xxx_hidden_EndLine = v
}

func (x *Location) SetEndColumn(v int32) {
	x.xxx_hidden_EndColumn = v
}

type Location_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	StartLine   int32
	StartColumn int32
	EndLine     int32
	EndColumn   int32
}

func (b0 Location_builder) Build() *Location {
	m0 := &Location{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_StartLine = b.StartLine
	x.xxx_hidden_StartColumn = b.StartColumn
	x.xxx_hidden_EndLine = b.EndLine
	x.xxx_hidden_EndColumn = b.EndColumn
	return m0
}

// Service provides information for the documentation for a given service type in a file.
type Service struct {
	state                           protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Name                 string                 `protobuf:"bytes,1,opt,name=name,proto3"`
	xxx_hidden_NestedName           string                 `protobuf:"bytes,2,opt,name=nested_name,json=nestedName,proto3"`
	xxx_hidden_FullName             string                 `protobuf:"bytes,3,opt,name=full_name,json=fullName,proto3"`
	xxx_hidden_Comments             string                 `protobuf:"bytes,4,opt,name=comments,proto3"`
	xxx_hidden_FilePath             string                 `protobuf:"bytes,5,opt,name=file_path,json=filePath,proto3"`
	xxx_hidden_Location             *Location              `protobuf:"bytes,6,opt,name=location,proto3"`
	xxx_hidden_Methods              *[]*Method             `protobuf:"bytes,7,rep,name=methods,proto3"`
	xxx_hidden_ImplicitlyDeprecated bool                   `protobuf:"varint,9,opt,name=implicitly_deprecated,json=implicitlyDeprecated,proto3"`
	xxx_hidden_Options              *[]*FieldLiteral       `protobuf:"bytes,10,rep,name=options,proto3"`
	xxx_hidden_ServiceOptions       *ServiceOptions        `protobuf:"bytes,8,opt,name=service_options,json=serviceOptions,proto3"`
	unknownFields                   protoimpl.UnknownFields
	sizeCache                       protoimpl.SizeCache
}

func (x *Service) Reset() {
	*x = Service{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Service) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Service) ProtoMessage() {}

func (x *Service) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Service) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *Service) GetNestedName() string {
	if x != nil {
		return x.xxx_hidden_NestedName
	}
	return ""
}

func (x *Service) GetFullName() string {
	if x != nil {
		return x.xxx_hidden_FullName
	}
	return ""
}

func (x *Service) GetComments() string {
	if x != nil {
		return x.xxx_hidden_Comments
	}
	return ""
}

func (x *Service) GetFilePath() string {
	if x != nil {
		return x.xxx_hidden_FilePath
	}
	return ""
}

func (x *Service) GetLocation() *Location {
	if x != nil {
		return x.xxx_hidden_Location
	}
	return nil
}

func (x *Service) GetMethods() []*Method {
	if x != nil {
		if x.xxx_hidden_Methods != nil {
			return *x.xxx_hidden_Methods
		}
	}
	return nil
}

func (x *Service) GetImplicitlyDeprecated() bool {
	if x != nil {
		return x.xxx_hidden_ImplicitlyDeprecated
	}
	return false
}

func (x *Service) GetOptions() []*FieldLiteral {
	if x != nil {
		if x.xxx_hidden_Options != nil {
			return *x.xxx_hidden_Options
		}
	}
	return nil
}

// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
func (x *Service) GetServiceOptions() *ServiceOptions {
	if x != nil {
		return x.xxx_hidden_ServiceOptions
	}
	return nil
}

func (x *Service) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *Service) SetNestedName(v string) {
	x.xxx_hidden_NestedName = v
}

func (x *Service) SetFullName(v string) {
	x.xxx_hidden_FullName = v
}

func (x *Service) SetComments(v string) {
	x.xxx_hidden_Comments = v
}

func (x *Service) SetFilePath(v string) {
	x.xxx_hidden_FilePath = v
}

func (x *Service) SetLocation(v *Location) {
	x.xxx_hidden_Location = v
}

func (x *Service) SetMethods(v []*Method) {
	x.xxx_hidden_Methods = &v
}

func (x *Service) SetImplicitlyDeprecated(v bool) {
	x.xxx_hidden_ImplicitlyDeprecated = v
}

func (x *Service) SetOptions(v []*FieldLiteral) {
	x.xxx_hidden_Options = &v
}

// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
func (x *Service) SetServiceOptions(v *ServiceOptions) {
	x.xxx_hidden_ServiceOptions = v
}

func (x *Service) HasLocation() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Location != nil
}

// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
func (x *Service) HasServiceOptions() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_ServiceOptions != nil
}

func (x *Service) ClearLocation() {
	x.xxx_hidden_Location = nil
}

// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
func (x *Service) ClearServiceOptions() {
	x.xxx_hidden_ServiceOptions = nil
}

type Service_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Name string
	// nested_name includes the nested types for a given type definition.
	NestedName string
	// full_name includes the package name and nested types for a given type definition.
	FullName string
	// comments is derived from the leading comments of a given service.
	//
	// Paragraph newlines (double new lines) are respected, however single newlines are not.
	// Note that any leading and trailing `//` or spaces within a `/* */` block will be stripped.
	Comments string
	// file_path is the normalized path of the file containing the service.
	// This is used for navigating to the source code for the service.
	FilePath string
	Location *Location
	Methods  []*Method
	// implicitly_deprecated is true if its enclosing file is deprecated.
	ImplicitlyDeprecated bool
	// All options that are present on the service. This is a super-set of
	// service_options and uses a dynamic representation so it can also
	// accommodate custom options with arbitrary types.
	// This supersedes service_options.
	Options []*FieldLiteral
	// Use options instead.
	//
	// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
	ServiceOptions *ServiceOptions
}

func (b0 Service_builder) Build() *Service {
	m0 := &Service{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_NestedName = b.NestedName
	x.xxx_hidden_FullName = b.FullName
	x.xxx_hidden_Comments = b.Comments
	x.xxx_hidden_FilePath = b.FilePath
	x.xxx_hidden_Location = b.Location
	x.xxx_hidden_Methods = &b.Methods
	x.xxx_hidden_ImplicitlyDeprecated = b.ImplicitlyDeprecated
	x.xxx_hidden_Options = &b.Options
	x.xxx_hidden_ServiceOptions = b.ServiceOptions
	return m0
}

// ServiceOptions provides information for the documentation of options for a given service.
//
// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
type ServiceOptions struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Deprecated bool                   `protobuf:"varint,1,opt,name=deprecated,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *ServiceOptions) Reset() {
	*x = ServiceOptions{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServiceOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceOptions) ProtoMessage() {}

func (x *ServiceOptions) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ServiceOptions) GetDeprecated() bool {
	if x != nil {
		return x.xxx_hidden_Deprecated
	}
	return false
}

func (x *ServiceOptions) SetDeprecated(v bool) {
	x.xxx_hidden_Deprecated = v
}

// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
type ServiceOptions_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Deprecated bool
}

func (b0 ServiceOptions_builder) Build() *ServiceOptions {
	m0 := &ServiceOptions{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Deprecated = b.Deprecated
	return m0
}

// Method provides information for the documentation for a method of a given service.
type Method struct {
	state                           protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Name                 string                 `protobuf:"bytes,1,opt,name=name,proto3"`
	xxx_hidden_Comments             string                 `protobuf:"bytes,2,opt,name=comments,proto3"`
	xxx_hidden_Request              *MethodRequestResponse `protobuf:"bytes,3,opt,name=request,proto3"`
	xxx_hidden_Response             *MethodRequestResponse `protobuf:"bytes,4,opt,name=response,proto3"`
	xxx_hidden_ImplicitlyDeprecated bool                   `protobuf:"varint,6,opt,name=implicitly_deprecated,json=implicitlyDeprecated,proto3"`
	xxx_hidden_Options              *[]*FieldLiteral       `protobuf:"bytes,7,rep,name=options,proto3"`
	xxx_hidden_MethodOptions        *MethodOptions         `protobuf:"bytes,5,opt,name=method_options,json=methodOptions,proto3"`
	unknownFields                   protoimpl.UnknownFields
	sizeCache                       protoimpl.SizeCache
}

func (x *Method) Reset() {
	*x = Method{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Method) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Method) ProtoMessage() {}

func (x *Method) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Method) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *Method) GetComments() string {
	if x != nil {
		return x.xxx_hidden_Comments
	}
	return ""
}

func (x *Method) GetRequest() *MethodRequestResponse {
	if x != nil {
		return x.xxx_hidden_Request
	}
	return nil
}

func (x *Method) GetResponse() *MethodRequestResponse {
	if x != nil {
		return x.xxx_hidden_Response
	}
	return nil
}

func (x *Method) GetImplicitlyDeprecated() bool {
	if x != nil {
		return x.xxx_hidden_ImplicitlyDeprecated
	}
	return false
}

func (x *Method) GetOptions() []*FieldLiteral {
	if x != nil {
		if x.xxx_hidden_Options != nil {
			return *x.xxx_hidden_Options
		}
	}
	return nil
}

// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
func (x *Method) GetMethodOptions() *MethodOptions {
	if x != nil {
		return x.xxx_hidden_MethodOptions
	}
	return nil
}

func (x *Method) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *Method) SetComments(v string) {
	x.xxx_hidden_Comments = v
}

func (x *Method) SetRequest(v *MethodRequestResponse) {
	x.xxx_hidden_Request = v
}

func (x *Method) SetResponse(v *MethodRequestResponse) {
	x.xxx_hidden_Response = v
}

func (x *Method) SetImplicitlyDeprecated(v bool) {
	x.xxx_hidden_ImplicitlyDeprecated = v
}

func (x *Method) SetOptions(v []*FieldLiteral) {
	x.xxx_hidden_Options = &v
}

// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
func (x *Method) SetMethodOptions(v *MethodOptions) {
	x.xxx_hidden_MethodOptions = v
}

func (x *Method) HasRequest() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Request != nil
}

func (x *Method) HasResponse() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Response != nil
}

// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
func (x *Method) HasMethodOptions() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_MethodOptions != nil
}

func (x *Method) ClearRequest() {
	x.xxx_hidden_Request = nil
}

func (x *Method) ClearResponse() {
	x.xxx_hidden_Response = nil
}

// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
func (x *Method) ClearMethodOptions() {
	x.xxx_hidden_MethodOptions = nil
}

type Method_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Name string
	// comments is derived from the leading comments of a given method.
	//
	// Paragraph newlines (double new lines) are respected, however single newlines are not.
	// Note that any leading and trailing `//` or spaces within a `/* */` block will be stripped.
	Comments string
	Request  *MethodRequestResponse
	Response *MethodRequestResponse
	// implicitly_deprecated is true if its enclosing file or parent element is deprecated.
	ImplicitlyDeprecated bool
	// All options that are present on the method. This is a super-set of
	// method_options and uses a dynamic representation so it can also
	// accommodate custom options with arbitrary types.
	// This supersedes method_options.
	Options []*FieldLiteral
	// Use options instead.
	//
	// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
	MethodOptions *MethodOptions
}

func (b0 Method_builder) Build() *Method {
	m0 := &Method{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_Comments = b.Comments
	x.xxx_hidden_Request = b.Request
	x.xxx_hidden_Response = b.Response
	x.xxx_hidden_ImplicitlyDeprecated = b.ImplicitlyDeprecated
	x.xxx_hidden_Options = &b.Options
	x.xxx_hidden_MethodOptions = b.MethodOptions
	return m0
}

// MethodOptions provides information for the documentation of options for a method.
//
// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
type MethodOptions struct {
	state                       protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Deprecated       bool                   `protobuf:"varint,1,opt,name=deprecated,proto3"`
	xxx_hidden_IdempotencyLevel int32                  `protobuf:"varint,2,opt,name=idempotency_level,json=idempotencyLevel,proto3"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *MethodOptions) Reset() {
	*x = MethodOptions{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MethodOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MethodOptions) ProtoMessage() {}

func (x *MethodOptions) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *MethodOptions) GetDeprecated() bool {
	if x != nil {
		return x.xxx_hidden_Deprecated
	}
	return false
}

func (x *MethodOptions) GetIdempotencyLevel() int32 {
	if x != nil {
		return x.xxx_hidden_IdempotencyLevel
	}
	return 0
}

func (x *MethodOptions) SetDeprecated(v bool) {
	x.xxx_hidden_Deprecated = v
}

func (x *MethodOptions) SetIdempotencyLevel(v int32) {
	x.xxx_hidden_IdempotencyLevel = v
}

// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
type MethodOptions_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Deprecated bool
	// idempotency_level holds a value of the enumeration `google.protobuf.MethodOptions.IdempotencyLevel.
	IdempotencyLevel int32
}

func (b0 MethodOptions_builder) Build() *MethodOptions {
	m0 := &MethodOptions{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Deprecated = b.Deprecated
	x.xxx_hidden_IdempotencyLevel = b.IdempotencyLevel
	return m0
}

// MethodRequestResponse provides information for the documentation of a Method request or response message.
type MethodRequestResponse struct {
	state                      protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_NestedType      string                 `protobuf:"bytes,1,opt,name=nested_type,json=nestedType,proto3"`
	xxx_hidden_FullType        string                 `protobuf:"bytes,2,opt,name=full_type,json=fullType,proto3"`
	xxx_hidden_Streaming       bool                   `protobuf:"varint,3,opt,name=streaming,proto3"`
	xxx_hidden_Message         *Message               `protobuf:"bytes,4,opt,name=message,proto3"`
	xxx_hidden_ImportModuleRef *ImportModuleRef       `protobuf:"bytes,5,opt,name=import_module_ref,json=importModuleRef,proto3"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *MethodRequestResponse) Reset() {
	*x = MethodRequestResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MethodRequestResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MethodRequestResponse) ProtoMessage() {}

func (x *MethodRequestResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *MethodRequestResponse) GetNestedType() string {
	if x != nil {
		return x.xxx_hidden_NestedType
	}
	return ""
}

func (x *MethodRequestResponse) GetFullType() string {
	if x != nil {
		return x.xxx_hidden_FullType
	}
	return ""
}

func (x *MethodRequestResponse) GetStreaming() bool {
	if x != nil {
		return x.xxx_hidden_Streaming
	}
	return false
}

func (x *MethodRequestResponse) GetMessage() *Message {
	if x != nil {
		return x.xxx_hidden_Message
	}
	return nil
}

func (x *MethodRequestResponse) GetImportModuleRef() *ImportModuleRef {
	if x != nil {
		return x.xxx_hidden_ImportModuleRef
	}
	return nil
}

func (x *MethodRequestResponse) SetNestedType(v string) {
	x.xxx_hidden_NestedType = v
}

func (x *MethodRequestResponse) SetFullType(v string) {
	x.xxx_hidden_FullType = v
}

func (x *MethodRequestResponse) SetStreaming(v bool) {
	x.xxx_hidden_Streaming = v
}

func (x *MethodRequestResponse) SetMessage(v *Message) {
	x.xxx_hidden_Message = v
}

func (x *MethodRequestResponse) SetImportModuleRef(v *ImportModuleRef) {
	x.xxx_hidden_ImportModuleRef = v
}

func (x *MethodRequestResponse) HasMessage() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Message != nil
}

func (x *MethodRequestResponse) HasImportModuleRef() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_ImportModuleRef != nil
}

func (x *MethodRequestResponse) ClearMessage() {
	x.xxx_hidden_Message = nil
}

func (x *MethodRequestResponse) ClearImportModuleRef() {
	x.xxx_hidden_ImportModuleRef = nil
}

type MethodRequestResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// nested_type is the nested name of the message of the request or response. This includes nested definitions.
	NestedType string
	// full_type is the fully qualified name of the message of the request or response. This includes package and nested definitions.
	FullType string
	// boolean flag for whether the streaming label is set on an method request or response.
	Streaming bool
	Message   *Message
	// import_module_ref is included if the request or response is an imported type.
	// It contains all the metadata for the import.
	ImportModuleRef *ImportModuleRef
}

func (b0 MethodRequestResponse_builder) Build() *MethodRequestResponse {
	m0 := &MethodRequestResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_NestedType = b.NestedType
	x.xxx_hidden_FullType = b.FullType
	x.xxx_hidden_Streaming = b.Streaming
	x.xxx_hidden_Message = b.Message
	x.xxx_hidden_ImportModuleRef = b.ImportModuleRef
	return m0
}

// Enum provides information for the documentation of an enum.
type Enum struct {
	state                           protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Name                 string                 `protobuf:"bytes,1,opt,name=name,proto3"`
	xxx_hidden_NestedName           string                 `protobuf:"bytes,2,opt,name=nested_name,json=nestedName,proto3"`
	xxx_hidden_FullName             string                 `protobuf:"bytes,3,opt,name=full_name,json=fullName,proto3"`
	xxx_hidden_Comments             string                 `protobuf:"bytes,4,opt,name=comments,proto3"`
	xxx_hidden_FilePath             string                 `protobuf:"bytes,5,opt,name=file_path,json=filePath,proto3"`
	xxx_hidden_Location             *Location              `protobuf:"bytes,6,opt,name=location,proto3"`
	xxx_hidden_Values               *[]*EnumValue          `protobuf:"bytes,7,rep,name=values,proto3"`
	xxx_hidden_ImplicitlyDeprecated bool                   `protobuf:"varint,9,opt,name=implicitly_deprecated,json=implicitlyDeprecated,proto3"`
	xxx_hidden_Options              *[]*FieldLiteral       `protobuf:"bytes,10,rep,name=options,proto3"`
	xxx_hidden_EnumOptions          *EnumOptions           `protobuf:"bytes,8,opt,name=enum_options,json=enumOptions,proto3"`
	unknownFields                   protoimpl.UnknownFields
	sizeCache                       protoimpl.SizeCache
}

func (x *Enum) Reset() {
	*x = Enum{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Enum) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Enum) ProtoMessage() {}

func (x *Enum) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Enum) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *Enum) GetNestedName() string {
	if x != nil {
		return x.xxx_hidden_NestedName
	}
	return ""
}

func (x *Enum) GetFullName() string {
	if x != nil {
		return x.xxx_hidden_FullName
	}
	return ""
}

func (x *Enum) GetComments() string {
	if x != nil {
		return x.xxx_hidden_Comments
	}
	return ""
}

func (x *Enum) GetFilePath() string {
	if x != nil {
		return x.xxx_hidden_FilePath
	}
	return ""
}

func (x *Enum) GetLocation() *Location {
	if x != nil {
		return x.xxx_hidden_Location
	}
	return nil
}

func (x *Enum) GetValues() []*EnumValue {
	if x != nil {
		if x.xxx_hidden_Values != nil {
			return *x.xxx_hidden_Values
		}
	}
	return nil
}

func (x *Enum) GetImplicitlyDeprecated() bool {
	if x != nil {
		return x.xxx_hidden_ImplicitlyDeprecated
	}
	return false
}

func (x *Enum) GetOptions() []*FieldLiteral {
	if x != nil {
		if x.xxx_hidden_Options != nil {
			return *x.xxx_hidden_Options
		}
	}
	return nil
}

// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
func (x *Enum) GetEnumOptions() *EnumOptions {
	if x != nil {
		return x.xxx_hidden_EnumOptions
	}
	return nil
}

func (x *Enum) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *Enum) SetNestedName(v string) {
	x.xxx_hidden_NestedName = v
}

func (x *Enum) SetFullName(v string) {
	x.xxx_hidden_FullName = v
}

func (x *Enum) SetComments(v string) {
	x.xxx_hidden_Comments = v
}

func (x *Enum) SetFilePath(v string) {
	x.xxx_hidden_FilePath = v
}

func (x *Enum) SetLocation(v *Location) {
	x.xxx_hidden_Location = v
}

func (x *Enum) SetValues(v []*EnumValue) {
	x.xxx_hidden_Values = &v
}

func (x *Enum) SetImplicitlyDeprecated(v bool) {
	x.xxx_hidden_ImplicitlyDeprecated = v
}

func (x *Enum) SetOptions(v []*FieldLiteral) {
	x.xxx_hidden_Options = &v
}

// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
func (x *Enum) SetEnumOptions(v *EnumOptions) {
	x.xxx_hidden_EnumOptions = v
}

func (x *Enum) HasLocation() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Location != nil
}

// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
func (x *Enum) HasEnumOptions() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_EnumOptions != nil
}

func (x *Enum) ClearLocation() {
	x.xxx_hidden_Location = nil
}

// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
func (x *Enum) ClearEnumOptions() {
	x.xxx_hidden_EnumOptions = nil
}

type Enum_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Name string
	// nested_name includes the nested types for a given type definition.
	NestedName string
	// full_name includes the package name and nested types for a given type definition.
	FullName string
	// comments is derived from the leading comments of a given Enum.
	//
	// Paragraph newlines (double new lines) are respected, however single newlines are not.
	// Note that any leading and trailing `//` or spaces within a `/* */` block will be stripped.
	Comments string
	// file_path is the normalized path of the file containing the enum.
	FilePath string
	Location *Location
	Values   []*EnumValue
	// implicitly_deprecated is true if its enclosing file or parent element is deprecated.
	ImplicitlyDeprecated bool
	// All options that are present on the enum. This is a super-set of
	// enum_options and uses a dynamic representation so it can also
	// accommodate custom options with arbitrary types.
	// // This supersedes enum_options.
	Options []*FieldLiteral
	// Use options instead.
	//
	// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
	EnumOptions *EnumOptions
}

func (b0 Enum_builder) Build() *Enum {
	m0 := &Enum{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_NestedName = b.NestedName
	x.xxx_hidden_FullName = b.FullName
	x.xxx_hidden_Comments = b.Comments
	x.xxx_hidden_FilePath = b.FilePath
	x.xxx_hidden_Location = b.Location
	x.xxx_hidden_Values = &b.Values
	x.xxx_hidden_ImplicitlyDeprecated = b.ImplicitlyDeprecated
	x.xxx_hidden_Options = &b.Options
	x.xxx_hidden_EnumOptions = b.EnumOptions
	return m0
}

// EnumOptions provides information for the documentation of options for an enum.
//
// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
type EnumOptions struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Deprecated bool                   `protobuf:"varint,1,opt,name=deprecated,proto3"`
	xxx_hidden_AllowAlias bool                   `protobuf:"varint,2,opt,name=allow_alias,json=allowAlias,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *EnumOptions) Reset() {
	*x = EnumOptions{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EnumOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnumOptions) ProtoMessage() {}

func (x *EnumOptions) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *EnumOptions) GetDeprecated() bool {
	if x != nil {
		return x.xxx_hidden_Deprecated
	}
	return false
}

func (x *EnumOptions) GetAllowAlias() bool {
	if x != nil {
		return x.xxx_hidden_AllowAlias
	}
	return false
}

func (x *EnumOptions) SetDeprecated(v bool) {
	x.xxx_hidden_Deprecated = v
}

func (x *EnumOptions) SetAllowAlias(v bool) {
	x.xxx_hidden_AllowAlias = v
}

// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
type EnumOptions_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Deprecated bool
	AllowAlias bool
}

func (b0 EnumOptions_builder) Build() *EnumOptions {
	m0 := &EnumOptions{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Deprecated = b.Deprecated
	x.xxx_hidden_AllowAlias = b.AllowAlias
	return m0
}

// EnumValue provides information for the documentation of an enum value.
type EnumValue struct {
	state                       protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Name             string                 `protobuf:"bytes,1,opt,name=name,proto3"`
	xxx_hidden_Number           int32                  `protobuf:"varint,2,opt,name=number,proto3"`
	xxx_hidden_Comments         string                 `protobuf:"bytes,3,opt,name=comments,proto3"`
	xxx_hidden_Options          *[]*FieldLiteral       `protobuf:"bytes,5,rep,name=options,proto3"`
	xxx_hidden_EnumValueOptions *EnumValueOptions      `protobuf:"bytes,4,opt,name=enum_value_options,json=enumValueOptions,proto3"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *EnumValue) Reset() {
	*x = EnumValue{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EnumValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnumValue) ProtoMessage() {}

func (x *EnumValue) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *EnumValue) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *EnumValue) GetNumber() int32 {
	if x != nil {
		return x.xxx_hidden_Number
	}
	return 0
}

func (x *EnumValue) GetComments() string {
	if x != nil {
		return x.xxx_hidden_Comments
	}
	return ""
}

func (x *EnumValue) GetOptions() []*FieldLiteral {
	if x != nil {
		if x.xxx_hidden_Options != nil {
			return *x.xxx_hidden_Options
		}
	}
	return nil
}

// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
func (x *EnumValue) GetEnumValueOptions() *EnumValueOptions {
	if x != nil {
		return x.xxx_hidden_EnumValueOptions
	}
	return nil
}

func (x *EnumValue) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *EnumValue) SetNumber(v int32) {
	x.xxx_hidden_Number = v
}

func (x *EnumValue) SetComments(v string) {
	x.xxx_hidden_Comments = v
}

func (x *EnumValue) SetOptions(v []*FieldLiteral) {
	x.xxx_hidden_Options = &v
}

// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
func (x *EnumValue) SetEnumValueOptions(v *EnumValueOptions) {
	x.xxx_hidden_EnumValueOptions = v
}

// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
func (x *EnumValue) HasEnumValueOptions() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_EnumValueOptions != nil
}

// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
func (x *EnumValue) ClearEnumValueOptions() {
	x.xxx_hidden_EnumValueOptions = nil
}

type EnumValue_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Name   string
	Number int32
	// comments is derived from the leading comments of a given enum value.
	//
	// Paragraph newlines (double new lines) are respected, however single newlines are not.
	// Note that any leading and trailing `//` or spaces within a `/* */` block will be stripped.
	Comments string
	// All options that are present on the enum. This is a super-set of
	// enum_value_options and uses a dynamic representation so it can also
	// accommodate custom options with arbitrary types.
	// // This supersedes enum_value_options.
	Options []*FieldLiteral
	// Use options instead.
	//
	// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
	EnumValueOptions *EnumValueOptions
}

func (b0 EnumValue_builder) Build() *EnumValue {
	m0 := &EnumValue{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_Number = b.Number
	x.xxx_hidden_Comments = b.Comments
	x.xxx_hidden_Options = &b.Options
	x.xxx_hidden_EnumValueOptions = b.EnumValueOptions
	return m0
}

// EnumValueOptions provides information for the documentation of options for an enum value.
//
// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
type EnumValueOptions struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Deprecated bool                   `protobuf:"varint,1,opt,name=deprecated,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *EnumValueOptions) Reset() {
	*x = EnumValueOptions{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EnumValueOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnumValueOptions) ProtoMessage() {}

func (x *EnumValueOptions) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *EnumValueOptions) GetDeprecated() bool {
	if x != nil {
		return x.xxx_hidden_Deprecated
	}
	return false
}

func (x *EnumValueOptions) SetDeprecated(v bool) {
	x.xxx_hidden_Deprecated = v
}

// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
type EnumValueOptions_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Deprecated bool
}

func (b0 EnumValueOptions_builder) Build() *EnumValueOptions {
	m0 := &EnumValueOptions{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Deprecated = b.Deprecated
	return m0
}

// ImportRef provides the import metadata if a type is imported.
type ImportModuleRef struct {
	state                  protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Remote      string                 `protobuf:"bytes,1,opt,name=remote,proto3"`
	xxx_hidden_Owner       string                 `protobuf:"bytes,2,opt,name=owner,proto3"`
	xxx_hidden_Repository  string                 `protobuf:"bytes,3,opt,name=repository,proto3"`
	xxx_hidden_Commit      string                 `protobuf:"bytes,4,opt,name=commit,proto3"`
	xxx_hidden_PackageName string                 `protobuf:"bytes,5,opt,name=package_name,json=packageName,proto3"`
	unknownFields          protoimpl.UnknownFields
	sizeCache              protoimpl.SizeCache
}

func (x *ImportModuleRef) Reset() {
	*x = ImportModuleRef{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportModuleRef) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportModuleRef) ProtoMessage() {}

func (x *ImportModuleRef) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ImportModuleRef) GetRemote() string {
	if x != nil {
		return x.xxx_hidden_Remote
	}
	return ""
}

func (x *ImportModuleRef) GetOwner() string {
	if x != nil {
		return x.xxx_hidden_Owner
	}
	return ""
}

func (x *ImportModuleRef) GetRepository() string {
	if x != nil {
		return x.xxx_hidden_Repository
	}
	return ""
}

func (x *ImportModuleRef) GetCommit() string {
	if x != nil {
		return x.xxx_hidden_Commit
	}
	return ""
}

func (x *ImportModuleRef) GetPackageName() string {
	if x != nil {
		return x.xxx_hidden_PackageName
	}
	return ""
}

func (x *ImportModuleRef) SetRemote(v string) {
	x.xxx_hidden_Remote = v
}

func (x *ImportModuleRef) SetOwner(v string) {
	x.xxx_hidden_Owner = v
}

func (x *ImportModuleRef) SetRepository(v string) {
	x.xxx_hidden_Repository = v
}

func (x *ImportModuleRef) SetCommit(v string) {
	x.xxx_hidden_Commit = v
}

func (x *ImportModuleRef) SetPackageName(v string) {
	x.xxx_hidden_PackageName = v
}

type ImportModuleRef_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Remote     string
	Owner      string
	Repository string
	// the commit is based on the module commit of the imported type provided
	// by the image.
	Commit      string
	PackageName string
}

func (b0 ImportModuleRef_builder) Build() *ImportModuleRef {
	m0 := &ImportModuleRef{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Remote = b.Remote
	x.xxx_hidden_Owner = b.Owner
	x.xxx_hidden_Repository = b.Repository
	x.xxx_hidden_Commit = b.Commit
	x.xxx_hidden_PackageName = b.PackageName
	return m0
}

// Message provides information for the documentation of a protobuf message.
type Message struct {
	state                           protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Name                 string                 `protobuf:"bytes,1,opt,name=name,proto3"`
	xxx_hidden_NestedName           string                 `protobuf:"bytes,2,opt,name=nested_name,json=nestedName,proto3"`
	xxx_hidden_FullName             string                 `protobuf:"bytes,3,opt,name=full_name,json=fullName,proto3"`
	xxx_hidden_Comments             string                 `protobuf:"bytes,4,opt,name=comments,proto3"`
	xxx_hidden_FilePath             string                 `protobuf:"bytes,5,opt,name=file_path,json=filePath,proto3"`
	xxx_hidden_IsMapEntry           bool                   `protobuf:"varint,6,opt,name=is_map_entry,json=isMapEntry,proto3"`
	xxx_hidden_Fields               *[]*MessageField       `protobuf:"bytes,7,rep,name=fields,proto3"`
	xxx_hidden_Location             *Location              `protobuf:"bytes,8,opt,name=location,proto3"`
	xxx_hidden_MessageExtensions    *[]*Field              `protobuf:"bytes,9,rep,name=message_extensions,json=messageExtensions,proto3"`
	xxx_hidden_ImplicitlyDeprecated bool                   `protobuf:"varint,11,opt,name=implicitly_deprecated,json=implicitlyDeprecated,proto3"`
	xxx_hidden_Options              *[]*FieldLiteral       `protobuf:"bytes,12,rep,name=options,proto3"`
	xxx_hidden_MessageOptions       *MessageOptions        `protobuf:"bytes,10,opt,name=message_options,json=messageOptions,proto3"`
	unknownFields                   protoimpl.UnknownFields
	sizeCache                       protoimpl.SizeCache
}

func (x *Message) Reset() {
	*x = Message{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Message) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Message) ProtoMessage() {}

func (x *Message) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Message) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *Message) GetNestedName() string {
	if x != nil {
		return x.xxx_hidden_NestedName
	}
	return ""
}

func (x *Message) GetFullName() string {
	if x != nil {
		return x.xxx_hidden_FullName
	}
	return ""
}

func (x *Message) GetComments() string {
	if x != nil {
		return x.xxx_hidden_Comments
	}
	return ""
}

func (x *Message) GetFilePath() string {
	if x != nil {
		return x.xxx_hidden_FilePath
	}
	return ""
}

func (x *Message) GetIsMapEntry() bool {
	if x != nil {
		return x.xxx_hidden_IsMapEntry
	}
	return false
}

func (x *Message) GetFields() []*MessageField {
	if x != nil {
		if x.xxx_hidden_Fields != nil {
			return *x.xxx_hidden_Fields
		}
	}
	return nil
}

func (x *Message) GetLocation() *Location {
	if x != nil {
		return x.xxx_hidden_Location
	}
	return nil
}

func (x *Message) GetMessageExtensions() []*Field {
	if x != nil {
		if x.xxx_hidden_MessageExtensions != nil {
			return *x.xxx_hidden_MessageExtensions
		}
	}
	return nil
}

func (x *Message) GetImplicitlyDeprecated() bool {
	if x != nil {
		return x.xxx_hidden_ImplicitlyDeprecated
	}
	return false
}

func (x *Message) GetOptions() []*FieldLiteral {
	if x != nil {
		if x.xxx_hidden_Options != nil {
			return *x.xxx_hidden_Options
		}
	}
	return nil
}

// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
func (x *Message) GetMessageOptions() *MessageOptions {
	if x != nil {
		return x.xxx_hidden_MessageOptions
	}
	return nil
}

func (x *Message) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *Message) SetNestedName(v string) {
	x.xxx_hidden_NestedName = v
}

func (x *Message) SetFullName(v string) {
	x.xxx_hidden_FullName = v
}

func (x *Message) SetComments(v string) {
	x.xxx_hidden_Comments = v
}

func (x *Message) SetFilePath(v string) {
	x.xxx_hidden_FilePath = v
}

func (x *Message) SetIsMapEntry(v bool) {
	x.xxx_hidden_IsMapEntry = v
}

func (x *Message) SetFields(v []*MessageField) {
	x.xxx_hidden_Fields = &v
}

func (x *Message) SetLocation(v *Location) {
	x.xxx_hidden_Location = v
}

func (x *Message) SetMessageExtensions(v []*Field) {
	x.xxx_hidden_MessageExtensions = &v
}

func (x *Message) SetImplicitlyDeprecated(v bool) {
	x.xxx_hidden_ImplicitlyDeprecated = v
}

func (x *Message) SetOptions(v []*FieldLiteral) {
	x.xxx_hidden_Options = &v
}

// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
func (x *Message) SetMessageOptions(v *MessageOptions) {
	x.xxx_hidden_MessageOptions = v
}

func (x *Message) HasLocation() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Location != nil
}

// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
func (x *Message) HasMessageOptions() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_MessageOptions != nil
}

func (x *Message) ClearLocation() {
	x.xxx_hidden_Location = nil
}

// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
func (x *Message) ClearMessageOptions() {
	x.xxx_hidden_MessageOptions = nil
}

type Message_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Name string
	// nested_name includes the nested types for a given type definition.
	NestedName string
	// full_name includes the package name and nested types for a given type definition.
	FullName string
	// comments is derived from the leading comments of a given message.
	//
	// Paragraph newlines (double new lines) are respected, however single newlines are not.
	// Note that any leading and trailing `//` or spaces within a `/* */` block will be stripped.
	Comments string
	// file_path is the normalized path of the file containing the message.
	FilePath          string
	IsMapEntry        bool
	Fields            []*MessageField
	Location          *Location
	MessageExtensions []*Field
	// implicitly_deprecated is true if its enclosing file or parent element is deprecated.
	ImplicitlyDeprecated bool
	// All options that are present on the message. This is a super-set of
	// message_options and uses a dynamic representation so it can also
	// accommodate custom options with arbitrary types.
	// // This supersedes message_options.
	Options []*FieldLiteral
	// Use options instead.
	//
	// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
	MessageOptions *MessageOptions
}

func (b0 Message_builder) Build() *Message {
	m0 := &Message{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_NestedName = b.NestedName
	x.xxx_hidden_FullName = b.FullName
	x.xxx_hidden_Comments = b.Comments
	x.xxx_hidden_FilePath = b.FilePath
	x.xxx_hidden_IsMapEntry = b.IsMapEntry
	x.xxx_hidden_Fields = &b.Fields
	x.xxx_hidden_Location = b.Location
	x.xxx_hidden_MessageExtensions = &b.MessageExtensions
	x.xxx_hidden_ImplicitlyDeprecated = b.ImplicitlyDeprecated
	x.xxx_hidden_Options = &b.Options
	x.xxx_hidden_MessageOptions = b.MessageOptions
	return m0
}

// MessageField can be either a single field or a oneof set of fields.
type MessageField struct {
	state                   protoimpl.MessageState      `protogen:"opaque.v1"`
	xxx_hidden_MessageField isMessageField_MessageField `protobuf_oneof:"message_field"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *MessageField) Reset() {
	*x = MessageField{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MessageField) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MessageField) ProtoMessage() {}

func (x *MessageField) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *MessageField) GetField() *Field {
	if x != nil {
		if x, ok := x.xxx_hidden_MessageField.(*messageField_Field); ok {
			return x.Field
		}
	}
	return nil
}

func (x *MessageField) GetOneof() *Oneof {
	if x != nil {
		if x, ok := x.xxx_hidden_MessageField.(*messageField_Oneof); ok {
			return x.Oneof
		}
	}
	return nil
}

func (x *MessageField) SetField(v *Field) {
	if v == nil {
		x.xxx_hidden_MessageField = nil
		return
	}
	x.xxx_hidden_MessageField = &messageField_Field{v}
}

func (x *MessageField) SetOneof(v *Oneof) {
	if v == nil {
		x.xxx_hidden_MessageField = nil
		return
	}
	x.xxx_hidden_MessageField = &messageField_Oneof{v}
}

func (x *MessageField) HasMessageField() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_MessageField != nil
}

func (x *MessageField) HasField() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_MessageField.(*messageField_Field)
	return ok
}

func (x *MessageField) HasOneof() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_MessageField.(*messageField_Oneof)
	return ok
}

func (x *MessageField) ClearMessageField() {
	x.xxx_hidden_MessageField = nil
}

func (x *MessageField) ClearField() {
	if _, ok := x.xxx_hidden_MessageField.(*messageField_Field); ok {
		x.xxx_hidden_MessageField = nil
	}
}

func (x *MessageField) ClearOneof() {
	if _, ok := x.xxx_hidden_MessageField.(*messageField_Oneof); ok {
		x.xxx_hidden_MessageField = nil
	}
}

const MessageField_MessageField_not_set_case case_MessageField_MessageField = 0
const MessageField_Field_case case_MessageField_MessageField = 1
const MessageField_Oneof_case case_MessageField_MessageField = 2

func (x *MessageField) WhichMessageField() case_MessageField_MessageField {
	if x == nil {
		return MessageField_MessageField_not_set_case
	}
	switch x.xxx_hidden_MessageField.(type) {
	case *messageField_Field:
		return MessageField_Field_case
	case *messageField_Oneof:
		return MessageField_Oneof_case
	default:
		return MessageField_MessageField_not_set_case
	}
}

type MessageField_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Fields of oneof xxx_hidden_MessageField:
	Field *Field
	Oneof *Oneof
	// -- end of xxx_hidden_MessageField
}

func (b0 MessageField_builder) Build() *MessageField {
	m0 := &MessageField{}
	b, x := &b0, m0
	_, _ = b, x
	if b.Field != nil {
		x.xxx_hidden_MessageField = &messageField_Field{b.Field}
	}
	if b.Oneof != nil {
		x.xxx_hidden_MessageField = &messageField_Oneof{b.Oneof}
	}
	return m0
}

type case_MessageField_MessageField protoreflect.FieldNumber

func (x case_MessageField_MessageField) String() string {
	md := file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[26].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isMessageField_MessageField interface {
	isMessageField_MessageField()
}

type messageField_Field struct {
	Field *Field `protobuf:"bytes,1,opt,name=field,proto3,oneof"`
}

type messageField_Oneof struct {
	Oneof *Oneof `protobuf:"bytes,2,opt,name=oneof,proto3,oneof"`
}

func (*messageField_Field) isMessageField_MessageField() {}

func (*messageField_Oneof) isMessageField_MessageField() {}

// MessageOptions provides information for the documentation of options for a message.
//
// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
type MessageOptions struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Deprecated bool                   `protobuf:"varint,1,opt,name=deprecated,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *MessageOptions) Reset() {
	*x = MessageOptions{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MessageOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MessageOptions) ProtoMessage() {}

func (x *MessageOptions) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *MessageOptions) GetDeprecated() bool {
	if x != nil {
		return x.xxx_hidden_Deprecated
	}
	return false
}

func (x *MessageOptions) SetDeprecated(v bool) {
	x.xxx_hidden_Deprecated = v
}

// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
type MessageOptions_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Deprecated bool
}

func (b0 MessageOptions_builder) Build() *MessageOptions {
	m0 := &MessageOptions{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Deprecated = b.Deprecated
	return m0
}

// Oneof represents a oneof set of fields.
type Oneof struct {
	state              protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Name    string                 `protobuf:"bytes,1,opt,name=name,proto3"`
	xxx_hidden_Fields  *[]*Field              `protobuf:"bytes,2,rep,name=fields,proto3"`
	xxx_hidden_Options *[]*FieldLiteral       `protobuf:"bytes,3,rep,name=options,proto3"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *Oneof) Reset() {
	*x = Oneof{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Oneof) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Oneof) ProtoMessage() {}

func (x *Oneof) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Oneof) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *Oneof) GetFields() []*Field {
	if x != nil {
		if x.xxx_hidden_Fields != nil {
			return *x.xxx_hidden_Fields
		}
	}
	return nil
}

func (x *Oneof) GetOptions() []*FieldLiteral {
	if x != nil {
		if x.xxx_hidden_Options != nil {
			return *x.xxx_hidden_Options
		}
	}
	return nil
}

func (x *Oneof) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *Oneof) SetFields(v []*Field) {
	x.xxx_hidden_Fields = &v
}

func (x *Oneof) SetOptions(v []*FieldLiteral) {
	x.xxx_hidden_Options = &v
}

type Oneof_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Name   string
	Fields []*Field
	// All options that are present on the OneOf.
	// This is a dynamic representation so it can also
	// accommodate custom options with arbitrary types.
	Options []*FieldLiteral
}

func (b0 Oneof_builder) Build() *Oneof {
	m0 := &Oneof{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_Fields = &b.Fields
	x.xxx_hidden_Options = &b.Options
	return m0
}

// Field provides information for the documentation of a message field.
type Field struct {
	state                      protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Name            string                 `protobuf:"bytes,1,opt,name=name,proto3"`
	xxx_hidden_Comments        string                 `protobuf:"bytes,2,opt,name=comments,proto3"`
	xxx_hidden_Label           string                 `protobuf:"bytes,3,opt,name=label,proto3"`
	xxx_hidden_NestedType      string                 `protobuf:"bytes,4,opt,name=nested_type,json=nestedType,proto3"`
	xxx_hidden_FullType        string                 `protobuf:"bytes,5,opt,name=full_type,json=fullType,proto3"`
	xxx_hidden_Tag             uint32                 `protobuf:"varint,6,opt,name=tag,proto3"`
	xxx_hidden_MapEntry        *MapEntry              `protobuf:"bytes,7,opt,name=map_entry,json=mapEntry,proto3"`
	xxx_hidden_ImportModuleRef *ImportModuleRef       `protobuf:"bytes,8,opt,name=import_module_ref,json=importModuleRef,proto3"`
	xxx_hidden_Extendee        string                 `protobuf:"bytes,9,opt,name=extendee,proto3"`
	xxx_hidden_Options         *[]*FieldLiteral       `protobuf:"bytes,11,rep,name=options,proto3"`
	xxx_hidden_FieldOptions    *FieldOptions          `protobuf:"bytes,10,opt,name=field_options,json=fieldOptions,proto3"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *Field) Reset() {
	*x = Field{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Field) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Field) ProtoMessage() {}

func (x *Field) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Field) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *Field) GetComments() string {
	if x != nil {
		return x.xxx_hidden_Comments
	}
	return ""
}

func (x *Field) GetLabel() string {
	if x != nil {
		return x.xxx_hidden_Label
	}
	return ""
}

func (x *Field) GetNestedType() string {
	if x != nil {
		return x.xxx_hidden_NestedType
	}
	return ""
}

func (x *Field) GetFullType() string {
	if x != nil {
		return x.xxx_hidden_FullType
	}
	return ""
}

func (x *Field) GetTag() uint32 {
	if x != nil {
		return x.xxx_hidden_Tag
	}
	return 0
}

func (x *Field) GetMapEntry() *MapEntry {
	if x != nil {
		return x.xxx_hidden_MapEntry
	}
	return nil
}

func (x *Field) GetImportModuleRef() *ImportModuleRef {
	if x != nil {
		return x.xxx_hidden_ImportModuleRef
	}
	return nil
}

func (x *Field) GetExtendee() string {
	if x != nil {
		return x.xxx_hidden_Extendee
	}
	return ""
}

func (x *Field) GetOptions() []*FieldLiteral {
	if x != nil {
		if x.xxx_hidden_Options != nil {
			return *x.xxx_hidden_Options
		}
	}
	return nil
}

// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
func (x *Field) GetFieldOptions() *FieldOptions {
	if x != nil {
		return x.xxx_hidden_FieldOptions
	}
	return nil
}

func (x *Field) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *Field) SetComments(v string) {
	x.xxx_hidden_Comments = v
}

func (x *Field) SetLabel(v string) {
	x.xxx_hidden_Label = v
}

func (x *Field) SetNestedType(v string) {
	x.xxx_hidden_NestedType = v
}

func (x *Field) SetFullType(v string) {
	x.xxx_hidden_FullType = v
}

func (x *Field) SetTag(v uint32) {
	x.xxx_hidden_Tag = v
}

func (x *Field) SetMapEntry(v *MapEntry) {
	x.xxx_hidden_MapEntry = v
}

func (x *Field) SetImportModuleRef(v *ImportModuleRef) {
	x.xxx_hidden_ImportModuleRef = v
}

func (x *Field) SetExtendee(v string) {
	x.xxx_hidden_Extendee = v
}

func (x *Field) SetOptions(v []*FieldLiteral) {
	x.xxx_hidden_Options = &v
}

// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
func (x *Field) SetFieldOptions(v *FieldOptions) {
	x.xxx_hidden_FieldOptions = v
}

func (x *Field) HasMapEntry() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_MapEntry != nil
}

func (x *Field) HasImportModuleRef() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_ImportModuleRef != nil
}

// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
func (x *Field) HasFieldOptions() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_FieldOptions != nil
}

func (x *Field) ClearMapEntry() {
	x.xxx_hidden_MapEntry = nil
}

func (x *Field) ClearImportModuleRef() {
	x.xxx_hidden_ImportModuleRef = nil
}

// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
func (x *Field) ClearFieldOptions() {
	x.xxx_hidden_FieldOptions = nil
}

type Field_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Name string
	// comments is derived from the leading comments of a given message field.
	//
	// Paragraph newlines (double new lines) are respected, however single newlines are not.
	// Note that any leading and trailing `//` or spaces within a `/* */` block will be stripped.
	Comments string
	Label    string
	// string representation of the nested name of the field type, which includes nested definitions.
	NestedType string
	// string representation of the full name of the field type, which includes package name
	// and nested definitions.
	FullType string
	Tag      uint32
	// MapEntry is present if the field is a map type.
	MapEntry *MapEntry
	// import_module_ref is included if the field is an imported type.
	// It contains all the metadata for the import.
	ImportModuleRef *ImportModuleRef
	// Extendee is the name of the type that is being ext if the field is an extension.
	// This is an empty string for fields that are not extensions.
	Extendee string
	// All options that are present on the field. This is a super-set of
	// field_options and uses a dynamic representation so it can also
	// accommodate custom options with arbitrary types.
	// This supersedes field_options.
	Options []*FieldLiteral
	// Use options instead.
	//
	// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
	FieldOptions *FieldOptions
}

func (b0 Field_builder) Build() *Field {
	m0 := &Field{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_Comments = b.Comments
	x.xxx_hidden_Label = b.Label
	x.xxx_hidden_NestedType = b.NestedType
	x.xxx_hidden_FullType = b.FullType
	x.xxx_hidden_Tag = b.Tag
	x.xxx_hidden_MapEntry = b.MapEntry
	x.xxx_hidden_ImportModuleRef = b.ImportModuleRef
	x.xxx_hidden_Extendee = b.Extendee
	x.xxx_hidden_Options = &b.Options
	x.xxx_hidden_FieldOptions = b.FieldOptions
	return m0
}

// FieldOptions provides information for the documentation of options for a field.
//
// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
type FieldOptions struct {
	state                  protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Deprecated  bool                   `protobuf:"varint,1,opt,name=deprecated,proto3"`
	xxx_hidden_Packed      bool                   `protobuf:"varint,2,opt,name=packed,proto3,oneof"`
	xxx_hidden_Ctype       int32                  `protobuf:"varint,3,opt,name=ctype,proto3"`
	xxx_hidden_Jstype      int32                  `protobuf:"varint,4,opt,name=jstype,proto3"`
	XXX_raceDetectHookData protoimpl.RaceDetectHookData
	XXX_presence           [1]uint32
	unknownFields          protoimpl.UnknownFields
	sizeCache              protoimpl.SizeCache
}

func (x *FieldOptions) Reset() {
	*x = FieldOptions{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FieldOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FieldOptions) ProtoMessage() {}

func (x *FieldOptions) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *FieldOptions) GetDeprecated() bool {
	if x != nil {
		return x.xxx_hidden_Deprecated
	}
	return false
}

func (x *FieldOptions) GetPacked() bool {
	if x != nil {
		return x.xxx_hidden_Packed
	}
	return false
}

func (x *FieldOptions) GetCtype() int32 {
	if x != nil {
		return x.xxx_hidden_Ctype
	}
	return 0
}

func (x *FieldOptions) GetJstype() int32 {
	if x != nil {
		return x.xxx_hidden_Jstype
	}
	return 0
}

func (x *FieldOptions) SetDeprecated(v bool) {
	x.xxx_hidden_Deprecated = v
}

func (x *FieldOptions) SetPacked(v bool) {
	x.xxx_hidden_Packed = v
	protoimpl.X.SetPresent(&(x.XXX_presence[0]), 1, 4)
}

func (x *FieldOptions) SetCtype(v int32) {
	x.xxx_hidden_Ctype = v
}

func (x *FieldOptions) SetJstype(v int32) {
	x.xxx_hidden_Jstype = v
}

func (x *FieldOptions) HasPacked() bool {
	if x == nil {
		return false
	}
	return protoimpl.X.Present(&(x.XXX_presence[0]), 1)
}

func (x *FieldOptions) ClearPacked() {
	protoimpl.X.ClearPresent(&(x.XXX_presence[0]), 1)
	x.xxx_hidden_Packed = false
}

// Deprecated: Marked as deprecated in buf/alpha/registry/v1alpha1/doc.proto.
type FieldOptions_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Deprecated bool
	Packed     *bool
	// ctype holds a value of the enumeration `google.protobuf.FieldOptions.CType.
	Ctype int32
	// jstype holds a value of the enumeration `google.protobuf.FieldOptions.JSType.
	Jstype int32
}

func (b0 FieldOptions_builder) Build() *FieldOptions {
	m0 := &FieldOptions{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Deprecated = b.Deprecated
	if b.Packed != nil {
		protoimpl.X.SetPresentNonAtomic(&(x.XXX_presence[0]), 1, 4)
		x.xxx_hidden_Packed = *b.Packed
	}
	x.xxx_hidden_Ctype = b.Ctype
	x.xxx_hidden_Jstype = b.Jstype
	return m0
}

// FieldLiteral represents a field and its value. It can be used to model descriptor options.
type FieldLiteral struct {
	state                      protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Name            string                 `protobuf:"bytes,1,opt,name=name,proto3"`
	xxx_hidden_Tag             int32                  `protobuf:"varint,2,opt,name=tag,proto3"`
	xxx_hidden_FieldType       FieldType              `protobuf:"varint,3,opt,name=field_type,json=fieldType,proto3,enum=buf.alpha.registry.v1alpha1.FieldType"`
	xxx_hidden_Value           *LiteralValue          `protobuf:"bytes,4,opt,name=value,proto3"`
	xxx_hidden_ImportModuleRef *ImportModuleRef       `protobuf:"bytes,5,opt,name=import_module_ref,json=importModuleRef,proto3"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *FieldLiteral) Reset() {
	*x = FieldLiteral{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FieldLiteral) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FieldLiteral) ProtoMessage() {}

func (x *FieldLiteral) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *FieldLiteral) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *FieldLiteral) GetTag() int32 {
	if x != nil {
		return x.xxx_hidden_Tag
	}
	return 0
}

func (x *FieldLiteral) GetFieldType() FieldType {
	if x != nil {
		return x.xxx_hidden_FieldType
	}
	return FieldType_FIELD_TYPE_UNSPECIFIED
}

func (x *FieldLiteral) GetValue() *LiteralValue {
	if x != nil {
		return x.xxx_hidden_Value
	}
	return nil
}

func (x *FieldLiteral) GetImportModuleRef() *ImportModuleRef {
	if x != nil {
		return x.xxx_hidden_ImportModuleRef
	}
	return nil
}

func (x *FieldLiteral) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *FieldLiteral) SetTag(v int32) {
	x.xxx_hidden_Tag = v
}

func (x *FieldLiteral) SetFieldType(v FieldType) {
	x.xxx_hidden_FieldType = v
}

func (x *FieldLiteral) SetValue(v *LiteralValue) {
	x.xxx_hidden_Value = v
}

func (x *FieldLiteral) SetImportModuleRef(v *ImportModuleRef) {
	x.xxx_hidden_ImportModuleRef = v
}

func (x *FieldLiteral) HasValue() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Value != nil
}

func (x *FieldLiteral) HasImportModuleRef() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_ImportModuleRef != nil
}

func (x *FieldLiteral) ClearValue() {
	x.xxx_hidden_Value = nil
}

func (x *FieldLiteral) ClearImportModuleRef() {
	x.xxx_hidden_ImportModuleRef = nil
}

type FieldLiteral_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// When is_extension is true, name is the fully-qualified name of the
	// extension. Otherwise, it is the simple name of the field.
	Name string
	// The unique field number associated with the field.
	Tag int32
	// Indicates whether this is an extension or not.
	FieldType FieldType
	// The field's value.
	Value *LiteralValue
	// This is the module where the extension is defined if the field type
	// is extension or the module where the messages is defined for field type any.
	ImportModuleRef *ImportModuleRef
}

func (b0 FieldLiteral_builder) Build() *FieldLiteral {
	m0 := &FieldLiteral{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_Tag = b.Tag
	x.xxx_hidden_FieldType = b.FieldType
	x.xxx_hidden_Value = b.Value
	x.xxx_hidden_ImportModuleRef = b.ImportModuleRef
	return m0
}

// MessageLiteral represents an option value for a type that is a message.
type MessageLiteral struct {
	state             protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Fields *[]*FieldLiteral       `protobuf:"bytes,1,rep,name=fields,proto3"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *MessageLiteral) Reset() {
	*x = MessageLiteral{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MessageLiteral) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MessageLiteral) ProtoMessage() {}

func (x *MessageLiteral) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *MessageLiteral) GetFields() []*FieldLiteral {
	if x != nil {
		if x.xxx_hidden_Fields != nil {
			return *x.xxx_hidden_Fields
		}
	}
	return nil
}

func (x *MessageLiteral) SetFields(v []*FieldLiteral) {
	x.xxx_hidden_Fields = &v
}

type MessageLiteral_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Map of field names to value. Extension field names will be in the form:
	// [fully.qualified.extension.Name].
	Fields []*FieldLiteral
}

func (b0 MessageLiteral_builder) Build() *MessageLiteral {
	m0 := &MessageLiteral{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Fields = &b.Fields
	return m0
}

// ArrayLiteral represents an option value for a type that is a repeated field.
// Maps are also represented using an ArrayLiteral, where each map entry is a MessageLiteral
// that contains a key and value field.
type ArrayLiteral struct {
	state               protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Elements *[]*LiteralValue       `protobuf:"bytes,1,rep,name=elements,proto3"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *ArrayLiteral) Reset() {
	*x = ArrayLiteral{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ArrayLiteral) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArrayLiteral) ProtoMessage() {}

func (x *ArrayLiteral) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ArrayLiteral) GetElements() []*LiteralValue {
	if x != nil {
		if x.xxx_hidden_Elements != nil {
			return *x.xxx_hidden_Elements
		}
	}
	return nil
}

func (x *ArrayLiteral) SetElements(v []*LiteralValue) {
	x.xxx_hidden_Elements = &v
}

type ArrayLiteral_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Elements []*LiteralValue
}

func (b0 ArrayLiteral_builder) Build() *ArrayLiteral {
	m0 := &ArrayLiteral{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Elements = &b.Elements
	return m0
}

// LiteralValue represents the actual value of the extension.
type LiteralValue struct {
	state               protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Value    isLiteralValue_Value   `protobuf_oneof:"value"`
	xxx_hidden_Comments string                 `protobuf:"bytes,10,opt,name=comments,proto3"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *LiteralValue) Reset() {
	*x = LiteralValue{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LiteralValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LiteralValue) ProtoMessage() {}

func (x *LiteralValue) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *LiteralValue) GetStringValue() string {
	if x != nil {
		if x, ok := x.xxx_hidden_Value.(*literalValue_StringValue); ok {
			return x.StringValue
		}
	}
	return ""
}

func (x *LiteralValue) GetIntValue() int64 {
	if x != nil {
		if x, ok := x.xxx_hidden_Value.(*literalValue_IntValue); ok {
			return x.IntValue
		}
	}
	return 0
}

func (x *LiteralValue) GetUintValue() uint64 {
	if x != nil {
		if x, ok := x.xxx_hidden_Value.(*literalValue_UintValue); ok {
			return x.UintValue
		}
	}
	return 0
}

func (x *LiteralValue) GetDoubleValue() float64 {
	if x != nil {
		if x, ok := x.xxx_hidden_Value.(*literalValue_DoubleValue); ok {
			return x.DoubleValue
		}
	}
	return 0
}

func (x *LiteralValue) GetBoolValue() bool {
	if x != nil {
		if x, ok := x.xxx_hidden_Value.(*literalValue_BoolValue); ok {
			return x.BoolValue
		}
	}
	return false
}

func (x *LiteralValue) GetEnumValueNameValue() string {
	if x != nil {
		if x, ok := x.xxx_hidden_Value.(*literalValue_EnumValueNameValue); ok {
			return x.EnumValueNameValue
		}
	}
	return ""
}

func (x *LiteralValue) GetArrayValue() *ArrayLiteral {
	if x != nil {
		if x, ok := x.xxx_hidden_Value.(*literalValue_ArrayValue); ok {
			return x.ArrayValue
		}
	}
	return nil
}

func (x *LiteralValue) GetMessageValue() *MessageLiteral {
	if x != nil {
		if x, ok := x.xxx_hidden_Value.(*literalValue_MessageValue); ok {
			return x.MessageValue
		}
	}
	return nil
}

func (x *LiteralValue) GetComments() string {
	if x != nil {
		return x.xxx_hidden_Comments
	}
	return ""
}

func (x *LiteralValue) SetStringValue(v string) {
	x.xxx_hidden_Value = &literalValue_StringValue{v}
}

func (x *LiteralValue) SetIntValue(v int64) {
	x.xxx_hidden_Value = &literalValue_IntValue{v}
}

func (x *LiteralValue) SetUintValue(v uint64) {
	x.xxx_hidden_Value = &literalValue_UintValue{v}
}

func (x *LiteralValue) SetDoubleValue(v float64) {
	x.xxx_hidden_Value = &literalValue_DoubleValue{v}
}

func (x *LiteralValue) SetBoolValue(v bool) {
	x.xxx_hidden_Value = &literalValue_BoolValue{v}
}

func (x *LiteralValue) SetEnumValueNameValue(v string) {
	x.xxx_hidden_Value = &literalValue_EnumValueNameValue{v}
}

func (x *LiteralValue) SetArrayValue(v *ArrayLiteral) {
	if v == nil {
		x.xxx_hidden_Value = nil
		return
	}
	x.xxx_hidden_Value = &literalValue_ArrayValue{v}
}

func (x *LiteralValue) SetMessageValue(v *MessageLiteral) {
	if v == nil {
		x.xxx_hidden_Value = nil
		return
	}
	x.xxx_hidden_Value = &literalValue_MessageValue{v}
}

func (x *LiteralValue) SetComments(v string) {
	x.xxx_hidden_Comments = v
}

func (x *LiteralValue) HasValue() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Value != nil
}

func (x *LiteralValue) HasStringValue() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Value.(*literalValue_StringValue)
	return ok
}

func (x *LiteralValue) HasIntValue() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Value.(*literalValue_IntValue)
	return ok
}

func (x *LiteralValue) HasUintValue() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Value.(*literalValue_UintValue)
	return ok
}

func (x *LiteralValue) HasDoubleValue() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Value.(*literalValue_DoubleValue)
	return ok
}

func (x *LiteralValue) HasBoolValue() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Value.(*literalValue_BoolValue)
	return ok
}

func (x *LiteralValue) HasEnumValueNameValue() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Value.(*literalValue_EnumValueNameValue)
	return ok
}

func (x *LiteralValue) HasArrayValue() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Value.(*literalValue_ArrayValue)
	return ok
}

func (x *LiteralValue) HasMessageValue() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Value.(*literalValue_MessageValue)
	return ok
}

func (x *LiteralValue) ClearValue() {
	x.xxx_hidden_Value = nil
}

func (x *LiteralValue) ClearStringValue() {
	if _, ok := x.xxx_hidden_Value.(*literalValue_StringValue); ok {
		x.xxx_hidden_Value = nil
	}
}

func (x *LiteralValue) ClearIntValue() {
	if _, ok := x.xxx_hidden_Value.(*literalValue_IntValue); ok {
		x.xxx_hidden_Value = nil
	}
}

func (x *LiteralValue) ClearUintValue() {
	if _, ok := x.xxx_hidden_Value.(*literalValue_UintValue); ok {
		x.xxx_hidden_Value = nil
	}
}

func (x *LiteralValue) ClearDoubleValue() {
	if _, ok := x.xxx_hidden_Value.(*literalValue_DoubleValue); ok {
		x.xxx_hidden_Value = nil
	}
}

func (x *LiteralValue) ClearBoolValue() {
	if _, ok := x.xxx_hidden_Value.(*literalValue_BoolValue); ok {
		x.xxx_hidden_Value = nil
	}
}

func (x *LiteralValue) ClearEnumValueNameValue() {
	if _, ok := x.xxx_hidden_Value.(*literalValue_EnumValueNameValue); ok {
		x.xxx_hidden_Value = nil
	}
}

func (x *LiteralValue) ClearArrayValue() {
	if _, ok := x.xxx_hidden_Value.(*literalValue_ArrayValue); ok {
		x.xxx_hidden_Value = nil
	}
}

func (x *LiteralValue) ClearMessageValue() {
	if _, ok := x.xxx_hidden_Value.(*literalValue_MessageValue); ok {
		x.xxx_hidden_Value = nil
	}
}

const LiteralValue_Value_not_set_case case_LiteralValue_Value = 0
const LiteralValue_StringValue_case case_LiteralValue_Value = 2
const LiteralValue_IntValue_case case_LiteralValue_Value = 3
const LiteralValue_UintValue_case case_LiteralValue_Value = 4
const LiteralValue_DoubleValue_case case_LiteralValue_Value = 5
const LiteralValue_BoolValue_case case_LiteralValue_Value = 6
const LiteralValue_EnumValueNameValue_case case_LiteralValue_Value = 7
const LiteralValue_ArrayValue_case case_LiteralValue_Value = 8
const LiteralValue_MessageValue_case case_LiteralValue_Value = 9

func (x *LiteralValue) WhichValue() case_LiteralValue_Value {
	if x == nil {
		return LiteralValue_Value_not_set_case
	}
	switch x.xxx_hidden_Value.(type) {
	case *literalValue_StringValue:
		return LiteralValue_StringValue_case
	case *literalValue_IntValue:
		return LiteralValue_IntValue_case
	case *literalValue_UintValue:
		return LiteralValue_UintValue_case
	case *literalValue_DoubleValue:
		return LiteralValue_DoubleValue_case
	case *literalValue_BoolValue:
		return LiteralValue_BoolValue_case
	case *literalValue_EnumValueNameValue:
		return LiteralValue_EnumValueNameValue_case
	case *literalValue_ArrayValue:
		return LiteralValue_ArrayValue_case
	case *literalValue_MessageValue:
		return LiteralValue_MessageValue_case
	default:
		return LiteralValue_Value_not_set_case
	}
}

type LiteralValue_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Fields of oneof xxx_hidden_Value:
	StringValue        *string
	IntValue           *int64
	UintValue          *uint64
	DoubleValue        *float64
	BoolValue          *bool
	EnumValueNameValue *string
	ArrayValue         *ArrayLiteral
	MessageValue       *MessageLiteral
	// -- end of xxx_hidden_Value
	Comments string
}

func (b0 LiteralValue_builder) Build() *LiteralValue {
	m0 := &LiteralValue{}
	b, x := &b0, m0
	_, _ = b, x
	if b.StringValue != nil {
		x.xxx_hidden_Value = &literalValue_StringValue{*b.StringValue}
	}
	if b.IntValue != nil {
		x.xxx_hidden_Value = &literalValue_IntValue{*b.IntValue}
	}
	if b.UintValue != nil {
		x.xxx_hidden_Value = &literalValue_UintValue{*b.UintValue}
	}
	if b.DoubleValue != nil {
		x.xxx_hidden_Value = &literalValue_DoubleValue{*b.DoubleValue}
	}
	if b.BoolValue != nil {
		x.xxx_hidden_Value = &literalValue_BoolValue{*b.BoolValue}
	}
	if b.EnumValueNameValue != nil {
		x.xxx_hidden_Value = &literalValue_EnumValueNameValue{*b.EnumValueNameValue}
	}
	if b.ArrayValue != nil {
		x.xxx_hidden_Value = &literalValue_ArrayValue{b.ArrayValue}
	}
	if b.MessageValue != nil {
		x.xxx_hidden_Value = &literalValue_MessageValue{b.MessageValue}
	}
	x.xxx_hidden_Comments = b.Comments
	return m0
}

type case_LiteralValue_Value protoreflect.FieldNumber

func (x case_LiteralValue_Value) String() string {
	md := file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[34].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isLiteralValue_Value interface {
	isLiteralValue_Value()
}

type literalValue_StringValue struct {
	StringValue string `protobuf:"bytes,2,opt,name=string_value,json=stringValue,proto3,oneof"`
}

type literalValue_IntValue struct {
	IntValue int64 `protobuf:"varint,3,opt,name=int_value,json=intValue,proto3,oneof"`
}

type literalValue_UintValue struct {
	UintValue uint64 `protobuf:"varint,4,opt,name=uint_value,json=uintValue,proto3,oneof"`
}

type literalValue_DoubleValue struct {
	DoubleValue float64 `protobuf:"fixed64,5,opt,name=double_value,json=doubleValue,proto3,oneof"`
}

type literalValue_BoolValue struct {
	BoolValue bool `protobuf:"varint,6,opt,name=bool_value,json=boolValue,proto3,oneof"`
}

type literalValue_EnumValueNameValue struct {
	EnumValueNameValue string `protobuf:"bytes,7,opt,name=enum_value_name_value,json=enumValueNameValue,proto3,oneof"`
}

type literalValue_ArrayValue struct {
	ArrayValue *ArrayLiteral `protobuf:"bytes,8,opt,name=array_value,json=arrayValue,proto3,oneof"`
}

type literalValue_MessageValue struct {
	MessageValue *MessageLiteral `protobuf:"bytes,9,opt,name=message_value,json=messageValue,proto3,oneof"`
}

func (*literalValue_StringValue) isLiteralValue_Value() {}

func (*literalValue_IntValue) isLiteralValue_Value() {}

func (*literalValue_UintValue) isLiteralValue_Value() {}

func (*literalValue_DoubleValue) isLiteralValue_Value() {}

func (*literalValue_BoolValue) isLiteralValue_Value() {}

func (*literalValue_EnumValueNameValue) isLiteralValue_Value() {}

func (*literalValue_ArrayValue) isLiteralValue_Value() {}

func (*literalValue_MessageValue) isLiteralValue_Value() {}

// MapEntry provides the key and value types for the MapEntry type for a map field.
type MapEntry struct {
	state                           protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_KeyFullType          string                 `protobuf:"bytes,1,opt,name=key_full_type,json=keyFullType,proto3"`
	xxx_hidden_ValueNestedType      string                 `protobuf:"bytes,2,opt,name=value_nested_type,json=valueNestedType,proto3"`
	xxx_hidden_ValueFullType        string                 `protobuf:"bytes,3,opt,name=value_full_type,json=valueFullType,proto3"`
	xxx_hidden_ValueImportModuleRef *ImportModuleRef       `protobuf:"bytes,4,opt,name=value_import_module_ref,json=valueImportModuleRef,proto3"`
	unknownFields                   protoimpl.UnknownFields
	sizeCache                       protoimpl.SizeCache
}

func (x *MapEntry) Reset() {
	*x = MapEntry{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MapEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MapEntry) ProtoMessage() {}

func (x *MapEntry) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *MapEntry) GetKeyFullType() string {
	if x != nil {
		return x.xxx_hidden_KeyFullType
	}
	return ""
}

func (x *MapEntry) GetValueNestedType() string {
	if x != nil {
		return x.xxx_hidden_ValueNestedType
	}
	return ""
}

func (x *MapEntry) GetValueFullType() string {
	if x != nil {
		return x.xxx_hidden_ValueFullType
	}
	return ""
}

func (x *MapEntry) GetValueImportModuleRef() *ImportModuleRef {
	if x != nil {
		return x.xxx_hidden_ValueImportModuleRef
	}
	return nil
}

func (x *MapEntry) SetKeyFullType(v string) {
	x.xxx_hidden_KeyFullType = v
}

func (x *MapEntry) SetValueNestedType(v string) {
	x.xxx_hidden_ValueNestedType = v
}

func (x *MapEntry) SetValueFullType(v string) {
	x.xxx_hidden_ValueFullType = v
}

func (x *MapEntry) SetValueImportModuleRef(v *ImportModuleRef) {
	x.xxx_hidden_ValueImportModuleRef = v
}

func (x *MapEntry) HasValueImportModuleRef() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_ValueImportModuleRef != nil
}

func (x *MapEntry) ClearValueImportModuleRef() {
	x.xxx_hidden_ValueImportModuleRef = nil
}

type MapEntry_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// string representation of the full name of the type for the map key. keys can only be
	// scalar types: https://developers.google.com/protocol-buffers/docs/overview#maps
	KeyFullType string
	// string representation of the nested name of the type for the map value.
	ValueNestedType string
	// string representation of the full name of the type for the map value.
	ValueFullType string
	// if the value is an imported type, this is the import module ref
	ValueImportModuleRef *ImportModuleRef
}

func (b0 MapEntry_builder) Build() *MapEntry {
	m0 := &MapEntry{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_KeyFullType = b.KeyFullType
	x.xxx_hidden_ValueNestedType = b.ValueNestedType
	x.xxx_hidden_ValueFullType = b.ValueFullType
	x.xxx_hidden_ValueImportModuleRef = b.ValueImportModuleRef
	return m0
}

// FileExtension provides the information for the documentation of a file extension.
type FileExtension struct {
	state                           protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_ExtensionType        string                 `protobuf:"bytes,1,opt,name=extension_type,json=extensionType,proto3"`
	xxx_hidden_Comments             string                 `protobuf:"bytes,2,opt,name=comments,proto3"`
	xxx_hidden_FilePath             string                 `protobuf:"bytes,3,opt,name=file_path,json=filePath,proto3"`
	xxx_hidden_Location             *Location              `protobuf:"bytes,4,opt,name=location,proto3"`
	xxx_hidden_Fields               *[]*Field              `protobuf:"bytes,5,rep,name=fields,proto3"`
	xxx_hidden_ImplicitlyDeprecated bool                   `protobuf:"varint,6,opt,name=implicitly_deprecated,json=implicitlyDeprecated,proto3"`
	unknownFields                   protoimpl.UnknownFields
	sizeCache                       protoimpl.SizeCache
}

func (x *FileExtension) Reset() {
	*x = FileExtension{}
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FileExtension) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileExtension) ProtoMessage() {}

func (x *FileExtension) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *FileExtension) GetExtensionType() string {
	if x != nil {
		return x.xxx_hidden_ExtensionType
	}
	return ""
}

func (x *FileExtension) GetComments() string {
	if x != nil {
		return x.xxx_hidden_Comments
	}
	return ""
}

func (x *FileExtension) GetFilePath() string {
	if x != nil {
		return x.xxx_hidden_FilePath
	}
	return ""
}

func (x *FileExtension) GetLocation() *Location {
	if x != nil {
		return x.xxx_hidden_Location
	}
	return nil
}

func (x *FileExtension) GetFields() []*Field {
	if x != nil {
		if x.xxx_hidden_Fields != nil {
			return *x.xxx_hidden_Fields
		}
	}
	return nil
}

func (x *FileExtension) GetImplicitlyDeprecated() bool {
	if x != nil {
		return x.xxx_hidden_ImplicitlyDeprecated
	}
	return false
}

func (x *FileExtension) SetExtensionType(v string) {
	x.xxx_hidden_ExtensionType = v
}

func (x *FileExtension) SetComments(v string) {
	x.xxx_hidden_Comments = v
}

func (x *FileExtension) SetFilePath(v string) {
	x.xxx_hidden_FilePath = v
}

func (x *FileExtension) SetLocation(v *Location) {
	x.xxx_hidden_Location = v
}

func (x *FileExtension) SetFields(v []*Field) {
	x.xxx_hidden_Fields = &v
}

func (x *FileExtension) SetImplicitlyDeprecated(v bool) {
	x.xxx_hidden_ImplicitlyDeprecated = v
}

func (x *FileExtension) HasLocation() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Location != nil
}

func (x *FileExtension) ClearLocation() {
	x.xxx_hidden_Location = nil
}

type FileExtension_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// extension_type is the string representation of the type being extended.
	ExtensionType string
	// comments is derived from the leading comments of a given message field.
	//
	// Paragraph newlines (double new lines) are respected, however single newlines are not.
	// Note that any leading and trailing `//` or spaces within a `/* */` block will be stripped.
	Comments string
	// file_path is the normalized path of the file containing the message.
	FilePath string
	Location *Location
	// fields are all the fields that are associated with the extension.
	Fields []*Field
	// implicitly_deprecated is true if its enclosing file or parent element is deprecated.
	ImplicitlyDeprecated bool
}

func (b0 FileExtension_builder) Build() *FileExtension {
	m0 := &FileExtension{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_ExtensionType = b.ExtensionType
	x.xxx_hidden_Comments = b.Comments
	x.xxx_hidden_FilePath = b.FilePath
	x.xxx_hidden_Location = b.Location
	x.xxx_hidden_Fields = &b.Fields
	x.xxx_hidden_ImplicitlyDeprecated = b.ImplicitlyDeprecated
	return m0
}

var File_buf_alpha_registry_v1alpha1_doc_proto protoreflect.FileDescriptor

var file_buf_alpha_registry_v1alpha1_doc_proto_rawDesc = string([]byte{
	0x0a, 0x25, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x64, 0x6f,
	0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1b, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x22, 0x73, 0x0a, 0x1d, 0x47, 0x65, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x0a, 0x72,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x1c, 0x0a, 0x09, 0x72,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x5b, 0x0a, 0x1e, 0x47, 0x65, 0x74,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x49,
	0x6e, 0x66, 0x6f, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x39, 0x0a, 0x04, 0x72,
	0x6f, 0x6f, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f,
	0x52, 0x04, 0x72, 0x6f, 0x6f, 0x74, 0x22, 0x78, 0x0a, 0x08, 0x46, 0x69, 0x6c, 0x65, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x15, 0x0a, 0x06, 0x69, 0x73, 0x5f, 0x64, 0x69, 0x72,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x69, 0x73, 0x44, 0x69, 0x72, 0x12, 0x41, 0x0a,
	0x08, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x72, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x25, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x46, 0x69,
	0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x08, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x72, 0x65, 0x6e,
	0x22, 0x7e, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x46, 0x69, 0x6c,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x6f, 0x77, 0x6e, 0x65,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x12, 0x1e,
	0x0a, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x1c,
	0x0a, 0x09, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04,
	0x70, 0x61, 0x74, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68,
	0x22, 0x31, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x46, 0x69, 0x6c,
	0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x22, 0x6e, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x14, 0x0a, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x6f, 0x77, 0x6e, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x1c, 0x0a, 0x09, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x22, 0x84, 0x01, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x53, 0x0a, 0x0f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f,
	0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x52, 0x0e, 0x6d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x22, 0x45, 0x0a, 0x0d, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x73, 0x0a, 0x1d, 0x47, 0x65, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x44, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x0a, 0x72, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x72, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x1c, 0x0a, 0x09, 0x72, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x85, 0x01, 0x0a, 0x1e, 0x47, 0x65, 0x74, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x63, 0x0a, 0x14, 0x6d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x6d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x98,
	0x01, 0x0a, 0x13, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0d, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x18, 0x0a, 0x07, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x12, 0x2d, 0x0a, 0x12, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x61, 0x74, 0x68,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x74, 0x68, 0x22, 0x97, 0x01, 0x0a, 0x1e, 0x47, 0x65,
	0x74, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x14, 0x0a, 0x05,
	0x6f, 0x77, 0x6e, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6f, 0x77, 0x6e,
	0x65, 0x72, 0x12, 0x1e, 0x0a, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x12, 0x1c, 0x0a, 0x09, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x12, 0x21, 0x0a, 0x0c, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x4e,
	0x61, 0x6d, 0x65, 0x22, 0x89, 0x01, 0x0a, 0x1f, 0x47, 0x65, 0x74, 0x50, 0x61, 0x63, 0x6b, 0x61,
	0x67, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x66, 0x0a, 0x15, 0x70, 0x61, 0x63, 0x6b, 0x61,
	0x67, 0x65, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x14, 0x70, 0x61, 0x63, 0x6b, 0x61,
	0x67, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0xd8, 0x02, 0x0a, 0x14, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08,
	0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x40, 0x0a, 0x08, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x52, 0x08, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0x37, 0x0a, 0x05, 0x65, 0x6e,
	0x75, 0x6d, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x45, 0x6e, 0x75, 0x6d, 0x52, 0x05, 0x65, 0x6e,
	0x75, 0x6d, 0x73, 0x12, 0x40, 0x0a, 0x08, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x18,
	0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x08, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x73, 0x12, 0x53, 0x0a, 0x0f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x65, 0x78,
	0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x46, 0x69, 0x6c,
	0x65, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x66, 0x69, 0x6c, 0x65,
	0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x86, 0x01, 0x0a, 0x08, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x5f, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x4c, 0x69, 0x6e, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f,
	0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x12, 0x19, 0x0a, 0x08, 0x65, 0x6e, 0x64,
	0x5f, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x07, 0x65, 0x6e, 0x64,
	0x4c, 0x69, 0x6e, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x65, 0x6e, 0x64, 0x5f, 0x63, 0x6f, 0x6c, 0x75,
	0x6d, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x65, 0x6e, 0x64, 0x43, 0x6f, 0x6c,
	0x75, 0x6d, 0x6e, 0x22, 0xea, 0x03, 0x0a, 0x07, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x6e, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6e, 0x65, 0x73, 0x74, 0x65, 0x64,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x66, 0x75, 0x6c, 0x6c, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x1b, 0x0a,
	0x09, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x50, 0x61, 0x74, 0x68, 0x12, 0x41, 0x0a, 0x08, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x0a,
	0x07, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4d, 0x65, 0x74,
	0x68, 0x6f, 0x64, 0x52, 0x07, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x12, 0x33, 0x0a, 0x15,
	0x69, 0x6d, 0x70, 0x6c, 0x69, 0x63, 0x69, 0x74, 0x6c, 0x79, 0x5f, 0x64, 0x65, 0x70, 0x72, 0x65,
	0x63, 0x61, 0x74, 0x65, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x69, 0x6d, 0x70,
	0x6c, 0x69, 0x63, 0x69, 0x74, 0x6c, 0x79, 0x44, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65,
	0x64, 0x12, 0x43, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0a, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x29, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x52, 0x07, 0x6f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x58, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2b, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x02, 0x18, 0x01,
	0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x22, 0x34, 0x0a, 0x0e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74,
	0x65, 0x64, 0x3a, 0x02, 0x18, 0x01, 0x22, 0xa7, 0x03, 0x0a, 0x06, 0x4d, 0x65, 0x74, 0x68, 0x6f,
	0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x12, 0x4c, 0x0a, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x32, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x4e, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x32, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x08, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x33, 0x0a, 0x15, 0x69, 0x6d, 0x70, 0x6c, 0x69, 0x63, 0x69, 0x74, 0x6c, 0x79, 0x5f, 0x64, 0x65,
	0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14,
	0x69, 0x6d, 0x70, 0x6c, 0x69, 0x63, 0x69, 0x74, 0x6c, 0x79, 0x44, 0x65, 0x70, 0x72, 0x65, 0x63,
	0x61, 0x74, 0x65, 0x64, 0x12, 0x43, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c,
	0x52, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x55, 0x0a, 0x0e, 0x6d, 0x65, 0x74,
	0x68, 0x6f, 0x64, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x02, 0x18,
	0x01, 0x52, 0x0d, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x22, 0x60, 0x0a, 0x0d, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65,
	0x64, 0x12, 0x2b, 0x0a, 0x11, 0x69, 0x64, 0x65, 0x6d, 0x70, 0x6f, 0x74, 0x65, 0x6e, 0x63, 0x79,
	0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x10, 0x69, 0x64,
	0x65, 0x6d, 0x70, 0x6f, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x3a, 0x02,
	0x18, 0x01, 0x22, 0x8d, 0x02, 0x0a, 0x15, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1f, 0x0a, 0x0b,
	0x6e, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x6e, 0x65, 0x73, 0x74, 0x65, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a,
	0x09, 0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x66, 0x75, 0x6c, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x73, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x12, 0x3e, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52,
	0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x58, 0x0a, 0x11, 0x69, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65,
	0x66, 0x52, 0x0f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52,
	0x65, 0x66, 0x22, 0xdf, 0x03, 0x0a, 0x04, 0x45, 0x6e, 0x75, 0x6d, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x1f, 0x0a, 0x0b, 0x6e, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6e, 0x65, 0x73, 0x74, 0x65, 0x64, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x1b, 0x0a, 0x09, 0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x66, 0x75, 0x6c, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a,
	0x08, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x66, 0x69, 0x6c,
	0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x66, 0x69,
	0x6c, 0x65, 0x50, 0x61, 0x74, 0x68, 0x12, 0x41, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3e, 0x0a, 0x06, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x45, 0x6e, 0x75, 0x6d, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x33, 0x0a, 0x15, 0x69, 0x6d, 0x70,
	0x6c, 0x69, 0x63, 0x69, 0x74, 0x6c, 0x79, 0x5f, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74,
	0x65, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x69, 0x6d, 0x70, 0x6c, 0x69, 0x63,
	0x69, 0x74, 0x6c, 0x79, 0x44, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x12, 0x43,
	0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x52, 0x07, 0x6f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x4f, 0x0a, 0x0c, 0x65, 0x6e, 0x75, 0x6d, 0x5f, 0x6f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x45, 0x6e, 0x75, 0x6d, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0b, 0x65, 0x6e, 0x75, 0x6d, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x22, 0x52, 0x0a, 0x0b, 0x45, 0x6e, 0x75, 0x6d, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61,
	0x74, 0x65, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x61, 0x6c, 0x69,
	0x61, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x41,
	0x6c, 0x69, 0x61, 0x73, 0x3a, 0x02, 0x18, 0x01, 0x22, 0xf9, 0x01, 0x0a, 0x09, 0x45, 0x6e, 0x75,
	0x6d, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x6e, 0x75,
	0x6d, 0x62, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x6e, 0x75, 0x6d, 0x62,
	0x65, 0x72, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x43,
	0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x52, 0x07, 0x6f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x5f, 0x0a, 0x12, 0x65, 0x6e, 0x75, 0x6d, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2d, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x45, 0x6e,
	0x75, 0x6d, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x02,
	0x18, 0x01, 0x52, 0x10, 0x65, 0x6e, 0x75, 0x6d, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x22, 0x36, 0x0a, 0x10, 0x45, 0x6e, 0x75, 0x6d, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x64, 0x65, 0x70, 0x72,
	0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x64, 0x65,
	0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x3a, 0x02, 0x18, 0x01, 0x22, 0x9a, 0x01, 0x0a,
	0x0f, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x66,
	0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x6f, 0x77, 0x6e, 0x65,
	0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x12, 0x1e,
	0x0a, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x16,
	0x0a, 0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x61,
	0x63, 0x6b, 0x61, 0x67, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0xe3, 0x04, 0x0a, 0x07, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x6e, 0x65, 0x73,
	0x74, 0x65, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a,
	0x6e, 0x65, 0x73, 0x74, 0x65, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x66, 0x75,
	0x6c, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x66,
	0x75, 0x6c, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x6f, 0x6d, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x6f, 0x6d, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x50, 0x61, 0x74, 0x68,
	0x12, 0x20, 0x0a, 0x0c, 0x69, 0x73, 0x5f, 0x6d, 0x61, 0x70, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x79,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x69, 0x73, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x41, 0x0a, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x07, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x29, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x06, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x73, 0x12, 0x41, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x51, 0x0a, 0x12, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x09,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x11, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x33, 0x0a, 0x15, 0x69,
	0x6d, 0x70, 0x6c, 0x69, 0x63, 0x69, 0x74, 0x6c, 0x79, 0x5f, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63,
	0x61, 0x74, 0x65, 0x64, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x69, 0x6d, 0x70, 0x6c,
	0x69, 0x63, 0x69, 0x74, 0x6c, 0x79, 0x44, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64,
	0x12, 0x43, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x29, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x52, 0x07, 0x6f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x58, 0x0a, 0x0f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x02, 0x18, 0x01, 0x52,
	0x0e, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22,
	0x97, 0x01, 0x0a, 0x0c, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x12, 0x3a, 0x0a, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x22, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x48, 0x00, 0x52, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x3a, 0x0a, 0x05,
	0x6f, 0x6e, 0x65, 0x6f, 0x66, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4f, 0x6e, 0x65, 0x6f, 0x66, 0x48,
	0x00, 0x52, 0x05, 0x6f, 0x6e, 0x65, 0x6f, 0x66, 0x42, 0x0f, 0x0a, 0x0d, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x22, 0x34, 0x0a, 0x0e, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x64,
	0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0a, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x3a, 0x02, 0x18, 0x01, 0x22,
	0x9c, 0x01, 0x0a, 0x05, 0x4f, 0x6e, 0x65, 0x6f, 0x66, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3a, 0x0a,
	0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x52, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x12, 0x43, 0x0a, 0x07, 0x6f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4c, 0x69,
	0x74, 0x65, 0x72, 0x61, 0x6c, 0x52, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xf0,
	0x03, 0x0a, 0x05, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08,
	0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x1f,
	0x0a, 0x0b, 0x6e, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x6e, 0x65, 0x73, 0x74, 0x65, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x1b, 0x0a, 0x09, 0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x66, 0x75, 0x6c, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x12, 0x10, 0x0a, 0x03,
	0x74, 0x61, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x03, 0x74, 0x61, 0x67, 0x12, 0x42,
	0x0a, 0x09, 0x6d, 0x61, 0x70, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x25, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x08, 0x6d, 0x61, 0x70, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x58, 0x0a, 0x11, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x52, 0x0f, 0x69, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x12, 0x1a, 0x0a, 0x08,
	0x65, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x65, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x65, 0x12, 0x43, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4c, 0x69, 0x74,
	0x65, 0x72, 0x61, 0x6c, 0x52, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x52, 0x0a,
	0x0d, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42,
	0x02, 0x18, 0x01, 0x52, 0x0c, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x22, 0x88, 0x01, 0x0a, 0x0c, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74,
	0x65, 0x64, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x48, 0x00, 0x52, 0x06, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x64, 0x88, 0x01, 0x01, 0x12,
	0x14, 0x0a, 0x05, 0x63, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05,
	0x63, 0x74, 0x79, 0x70, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x6a, 0x73, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x6a, 0x73, 0x74, 0x79, 0x70, 0x65, 0x3a, 0x02, 0x18,
	0x01, 0x42, 0x09, 0x0a, 0x07, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x64, 0x22, 0x96, 0x02, 0x0a,
	0x0c, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x10, 0x0a, 0x03, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x03,
	0x74, 0x61, 0x67, 0x12, 0x45, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x26, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x3f, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x58, 0x0a, 0x11, 0x69,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x66,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x52, 0x65, 0x66, 0x52, 0x0f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x52, 0x65, 0x66, 0x22, 0x53, 0x0a, 0x0e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x12, 0x41, 0x0a, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4c, 0x69, 0x74, 0x65, 0x72,
	0x61, 0x6c, 0x52, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x22, 0x55, 0x0a, 0x0c, 0x41, 0x72,
	0x72, 0x61, 0x79, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x12, 0x45, 0x0a, 0x08, 0x65, 0x6c,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x74, 0x65, 0x72,
	0x61, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x08, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x22, 0xb5, 0x03, 0x0a, 0x0c, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x23, 0x0a, 0x0c, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0b, 0x73, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1d, 0x0a, 0x09, 0x69, 0x6e, 0x74, 0x5f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x08, 0x69, 0x6e,
	0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1f, 0x0a, 0x0a, 0x75, 0x69, 0x6e, 0x74, 0x5f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x48, 0x00, 0x52, 0x09, 0x75, 0x69,
	0x6e, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x23, 0x0a, 0x0c, 0x64, 0x6f, 0x75, 0x62, 0x6c,
	0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x01, 0x48, 0x00, 0x52,
	0x0b, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1f, 0x0a, 0x0a,
	0x62, 0x6f, 0x6f, 0x6c, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08,
	0x48, 0x00, 0x52, 0x09, 0x62, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x33, 0x0a,
	0x15, 0x65, 0x6e, 0x75, 0x6d, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x12,
	0x65, 0x6e, 0x75, 0x6d, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x4c, 0x0a, 0x0b, 0x61, 0x72, 0x72, 0x61, 0x79, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x41, 0x72, 0x72, 0x61, 0x79, 0x4c, 0x69, 0x74, 0x65, 0x72,
	0x61, 0x6c, 0x48, 0x00, 0x52, 0x0a, 0x61, 0x72, 0x72, 0x61, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x52, 0x0a, 0x0d, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x4c, 0x69, 0x74,
	0x65, 0x72, 0x61, 0x6c, 0x48, 0x00, 0x52, 0x0c, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x42, 0x07, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xe7, 0x01, 0x0a, 0x08, 0x4d, 0x61,
	0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x22, 0x0a, 0x0d, 0x6b, 0x65, 0x79, 0x5f, 0x66, 0x75,
	0x6c, 0x6c, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x6b,
	0x65, 0x79, 0x46, 0x75, 0x6c, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2a, 0x0a, 0x11, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x5f, 0x6e, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x4e, 0x65, 0x73, 0x74,
	0x65, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x26, 0x0a, 0x0f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f,
	0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x46, 0x75, 0x6c, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x12, 0x63,
	0x0a, 0x17, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2c, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x49, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x52, 0x14, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x52, 0x65, 0x66, 0x22, 0xa3, 0x02, 0x0a, 0x0d, 0x46, 0x69, 0x6c, 0x65, 0x45, 0x78, 0x74, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x0e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x65,
	0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x08,
	0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x66, 0x69, 0x6c, 0x65,
	0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x66, 0x69, 0x6c,
	0x65, 0x50, 0x61, 0x74, 0x68, 0x12, 0x41, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3a, 0x0a, 0x06, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x06, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x73, 0x12, 0x33, 0x0a, 0x15, 0x69, 0x6d, 0x70, 0x6c, 0x69, 0x63, 0x69, 0x74,
	0x6c, 0x79, 0x5f, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x14, 0x69, 0x6d, 0x70, 0x6c, 0x69, 0x63, 0x69, 0x74, 0x6c, 0x79, 0x44,
	0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x2a, 0x6c, 0x0a, 0x09, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x46, 0x49, 0x45, 0x4c, 0x44, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x46, 0x49, 0x45, 0x4c, 0x44, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x4e, 0x4f, 0x52, 0x4d, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x18, 0x0a, 0x14, 0x46, 0x49, 0x45,
	0x4c, 0x44, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x45, 0x58, 0x54, 0x45, 0x4e, 0x53, 0x49, 0x4f,
	0x4e, 0x10, 0x02, 0x12, 0x12, 0x0a, 0x0e, 0x46, 0x49, 0x45, 0x4c, 0x44, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x41, 0x4e, 0x59, 0x10, 0x03, 0x32, 0xe1, 0x05, 0x0a, 0x0a, 0x44, 0x6f, 0x63, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x96, 0x01, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x3a, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x49, 0x6e,
	0x66, 0x6f, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12,
	0x7b, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x46, 0x69, 0x6c, 0x65,
	0x12, 0x31, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0x87, 0x01, 0x0a,
	0x11, 0x47, 0x65, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x73, 0x12, 0x35, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0x96, 0x01, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x3a, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12,
	0x99, 0x01, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x44, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x42, 0x95, 0x02, 0x0a, 0x1f,
	0x63, 0x6f, 0x6d, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x42,
	0x08, 0x44, 0x6f, 0x63, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x59, 0x67, 0x69, 0x74,
	0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x62, 0x75, 0x66, 0x62, 0x75, 0x69, 0x6c, 0x64,
	0x2f, 0x62, 0x75, 0x66, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x2f, 0x67, 0x65, 0x6e,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x3b, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0xa2, 0x02, 0x03, 0x42, 0x41, 0x52, 0xaa, 0x02, 0x1b, 0x42,
	0x75, 0x66, 0x2e, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2e, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0xca, 0x02, 0x1b, 0x42, 0x75, 0x66,
	0x5c, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x5c, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x5c,
	0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0xe2, 0x02, 0x27, 0x42, 0x75, 0x66, 0x5c, 0x41,
	0x6c, 0x70, 0x68, 0x61, 0x5c, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x5c, 0x56, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x5c, 0x47, 0x50, 0x42, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xea, 0x02, 0x1e, 0x42, 0x75, 0x66, 0x3a, 0x3a, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x3a,
	0x3a, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x3a, 0x3a, 0x56, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
})

var file_buf_alpha_registry_v1alpha1_doc_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes = make([]protoimpl.MessageInfo, 37)
var file_buf_alpha_registry_v1alpha1_doc_proto_goTypes = []any{
	(FieldType)(0),                          // 0: buf.alpha.registry.v1alpha1.FieldType
	(*GetSourceDirectoryInfoRequest)(nil),   // 1: buf.alpha.registry.v1alpha1.GetSourceDirectoryInfoRequest
	(*GetSourceDirectoryInfoResponse)(nil),  // 2: buf.alpha.registry.v1alpha1.GetSourceDirectoryInfoResponse
	(*FileInfo)(nil),                        // 3: buf.alpha.registry.v1alpha1.FileInfo
	(*GetSourceFileRequest)(nil),            // 4: buf.alpha.registry.v1alpha1.GetSourceFileRequest
	(*GetSourceFileResponse)(nil),           // 5: buf.alpha.registry.v1alpha1.GetSourceFileResponse
	(*GetModulePackagesRequest)(nil),        // 6: buf.alpha.registry.v1alpha1.GetModulePackagesRequest
	(*GetModulePackagesResponse)(nil),       // 7: buf.alpha.registry.v1alpha1.GetModulePackagesResponse
	(*ModulePackage)(nil),                   // 8: buf.alpha.registry.v1alpha1.ModulePackage
	(*GetModuleDocumentationRequest)(nil),   // 9: buf.alpha.registry.v1alpha1.GetModuleDocumentationRequest
	(*GetModuleDocumentationResponse)(nil),  // 10: buf.alpha.registry.v1alpha1.GetModuleDocumentationResponse
	(*ModuleDocumentation)(nil),             // 11: buf.alpha.registry.v1alpha1.ModuleDocumentation
	(*GetPackageDocumentationRequest)(nil),  // 12: buf.alpha.registry.v1alpha1.GetPackageDocumentationRequest
	(*GetPackageDocumentationResponse)(nil), // 13: buf.alpha.registry.v1alpha1.GetPackageDocumentationResponse
	(*PackageDocumentation)(nil),            // 14: buf.alpha.registry.v1alpha1.PackageDocumentation
	(*Location)(nil),                        // 15: buf.alpha.registry.v1alpha1.Location
	(*Service)(nil),                         // 16: buf.alpha.registry.v1alpha1.Service
	(*ServiceOptions)(nil),                  // 17: buf.alpha.registry.v1alpha1.ServiceOptions
	(*Method)(nil),                          // 18: buf.alpha.registry.v1alpha1.Method
	(*MethodOptions)(nil),                   // 19: buf.alpha.registry.v1alpha1.MethodOptions
	(*MethodRequestResponse)(nil),           // 20: buf.alpha.registry.v1alpha1.MethodRequestResponse
	(*Enum)(nil),                            // 21: buf.alpha.registry.v1alpha1.Enum
	(*EnumOptions)(nil),                     // 22: buf.alpha.registry.v1alpha1.EnumOptions
	(*EnumValue)(nil),                       // 23: buf.alpha.registry.v1alpha1.EnumValue
	(*EnumValueOptions)(nil),                // 24: buf.alpha.registry.v1alpha1.EnumValueOptions
	(*ImportModuleRef)(nil),                 // 25: buf.alpha.registry.v1alpha1.ImportModuleRef
	(*Message)(nil),                         // 26: buf.alpha.registry.v1alpha1.Message
	(*MessageField)(nil),                    // 27: buf.alpha.registry.v1alpha1.MessageField
	(*MessageOptions)(nil),                  // 28: buf.alpha.registry.v1alpha1.MessageOptions
	(*Oneof)(nil),                           // 29: buf.alpha.registry.v1alpha1.Oneof
	(*Field)(nil),                           // 30: buf.alpha.registry.v1alpha1.Field
	(*FieldOptions)(nil),                    // 31: buf.alpha.registry.v1alpha1.FieldOptions
	(*FieldLiteral)(nil),                    // 32: buf.alpha.registry.v1alpha1.FieldLiteral
	(*MessageLiteral)(nil),                  // 33: buf.alpha.registry.v1alpha1.MessageLiteral
	(*ArrayLiteral)(nil),                    // 34: buf.alpha.registry.v1alpha1.ArrayLiteral
	(*LiteralValue)(nil),                    // 35: buf.alpha.registry.v1alpha1.LiteralValue
	(*MapEntry)(nil),                        // 36: buf.alpha.registry.v1alpha1.MapEntry
	(*FileExtension)(nil),                   // 37: buf.alpha.registry.v1alpha1.FileExtension
}
var file_buf_alpha_registry_v1alpha1_doc_proto_depIdxs = []int32{
	3,  // 0: buf.alpha.registry.v1alpha1.GetSourceDirectoryInfoResponse.root:type_name -> buf.alpha.registry.v1alpha1.FileInfo
	3,  // 1: buf.alpha.registry.v1alpha1.FileInfo.children:type_name -> buf.alpha.registry.v1alpha1.FileInfo
	8,  // 2: buf.alpha.registry.v1alpha1.GetModulePackagesResponse.module_packages:type_name -> buf.alpha.registry.v1alpha1.ModulePackage
	11, // 3: buf.alpha.registry.v1alpha1.GetModuleDocumentationResponse.module_documentation:type_name -> buf.alpha.registry.v1alpha1.ModuleDocumentation
	14, // 4: buf.alpha.registry.v1alpha1.GetPackageDocumentationResponse.package_documentation:type_name -> buf.alpha.registry.v1alpha1.PackageDocumentation
	16, // 5: buf.alpha.registry.v1alpha1.PackageDocumentation.services:type_name -> buf.alpha.registry.v1alpha1.Service
	21, // 6: buf.alpha.registry.v1alpha1.PackageDocumentation.enums:type_name -> buf.alpha.registry.v1alpha1.Enum
	26, // 7: buf.alpha.registry.v1alpha1.PackageDocumentation.messages:type_name -> buf.alpha.registry.v1alpha1.Message
	37, // 8: buf.alpha.registry.v1alpha1.PackageDocumentation.file_extensions:type_name -> buf.alpha.registry.v1alpha1.FileExtension
	15, // 9: buf.alpha.registry.v1alpha1.Service.location:type_name -> buf.alpha.registry.v1alpha1.Location
	18, // 10: buf.alpha.registry.v1alpha1.Service.methods:type_name -> buf.alpha.registry.v1alpha1.Method
	32, // 11: buf.alpha.registry.v1alpha1.Service.options:type_name -> buf.alpha.registry.v1alpha1.FieldLiteral
	17, // 12: buf.alpha.registry.v1alpha1.Service.service_options:type_name -> buf.alpha.registry.v1alpha1.ServiceOptions
	20, // 13: buf.alpha.registry.v1alpha1.Method.request:type_name -> buf.alpha.registry.v1alpha1.MethodRequestResponse
	20, // 14: buf.alpha.registry.v1alpha1.Method.response:type_name -> buf.alpha.registry.v1alpha1.MethodRequestResponse
	32, // 15: buf.alpha.registry.v1alpha1.Method.options:type_name -> buf.alpha.registry.v1alpha1.FieldLiteral
	19, // 16: buf.alpha.registry.v1alpha1.Method.method_options:type_name -> buf.alpha.registry.v1alpha1.MethodOptions
	26, // 17: buf.alpha.registry.v1alpha1.MethodRequestResponse.message:type_name -> buf.alpha.registry.v1alpha1.Message
	25, // 18: buf.alpha.registry.v1alpha1.MethodRequestResponse.import_module_ref:type_name -> buf.alpha.registry.v1alpha1.ImportModuleRef
	15, // 19: buf.alpha.registry.v1alpha1.Enum.location:type_name -> buf.alpha.registry.v1alpha1.Location
	23, // 20: buf.alpha.registry.v1alpha1.Enum.values:type_name -> buf.alpha.registry.v1alpha1.EnumValue
	32, // 21: buf.alpha.registry.v1alpha1.Enum.options:type_name -> buf.alpha.registry.v1alpha1.FieldLiteral
	22, // 22: buf.alpha.registry.v1alpha1.Enum.enum_options:type_name -> buf.alpha.registry.v1alpha1.EnumOptions
	32, // 23: buf.alpha.registry.v1alpha1.EnumValue.options:type_name -> buf.alpha.registry.v1alpha1.FieldLiteral
	24, // 24: buf.alpha.registry.v1alpha1.EnumValue.enum_value_options:type_name -> buf.alpha.registry.v1alpha1.EnumValueOptions
	27, // 25: buf.alpha.registry.v1alpha1.Message.fields:type_name -> buf.alpha.registry.v1alpha1.MessageField
	15, // 26: buf.alpha.registry.v1alpha1.Message.location:type_name -> buf.alpha.registry.v1alpha1.Location
	30, // 27: buf.alpha.registry.v1alpha1.Message.message_extensions:type_name -> buf.alpha.registry.v1alpha1.Field
	32, // 28: buf.alpha.registry.v1alpha1.Message.options:type_name -> buf.alpha.registry.v1alpha1.FieldLiteral
	28, // 29: buf.alpha.registry.v1alpha1.Message.message_options:type_name -> buf.alpha.registry.v1alpha1.MessageOptions
	30, // 30: buf.alpha.registry.v1alpha1.MessageField.field:type_name -> buf.alpha.registry.v1alpha1.Field
	29, // 31: buf.alpha.registry.v1alpha1.MessageField.oneof:type_name -> buf.alpha.registry.v1alpha1.Oneof
	30, // 32: buf.alpha.registry.v1alpha1.Oneof.fields:type_name -> buf.alpha.registry.v1alpha1.Field
	32, // 33: buf.alpha.registry.v1alpha1.Oneof.options:type_name -> buf.alpha.registry.v1alpha1.FieldLiteral
	36, // 34: buf.alpha.registry.v1alpha1.Field.map_entry:type_name -> buf.alpha.registry.v1alpha1.MapEntry
	25, // 35: buf.alpha.registry.v1alpha1.Field.import_module_ref:type_name -> buf.alpha.registry.v1alpha1.ImportModuleRef
	32, // 36: buf.alpha.registry.v1alpha1.Field.options:type_name -> buf.alpha.registry.v1alpha1.FieldLiteral
	31, // 37: buf.alpha.registry.v1alpha1.Field.field_options:type_name -> buf.alpha.registry.v1alpha1.FieldOptions
	0,  // 38: buf.alpha.registry.v1alpha1.FieldLiteral.field_type:type_name -> buf.alpha.registry.v1alpha1.FieldType
	35, // 39: buf.alpha.registry.v1alpha1.FieldLiteral.value:type_name -> buf.alpha.registry.v1alpha1.LiteralValue
	25, // 40: buf.alpha.registry.v1alpha1.FieldLiteral.import_module_ref:type_name -> buf.alpha.registry.v1alpha1.ImportModuleRef
	32, // 41: buf.alpha.registry.v1alpha1.MessageLiteral.fields:type_name -> buf.alpha.registry.v1alpha1.FieldLiteral
	35, // 42: buf.alpha.registry.v1alpha1.ArrayLiteral.elements:type_name -> buf.alpha.registry.v1alpha1.LiteralValue
	34, // 43: buf.alpha.registry.v1alpha1.LiteralValue.array_value:type_name -> buf.alpha.registry.v1alpha1.ArrayLiteral
	33, // 44: buf.alpha.registry.v1alpha1.LiteralValue.message_value:type_name -> buf.alpha.registry.v1alpha1.MessageLiteral
	25, // 45: buf.alpha.registry.v1alpha1.MapEntry.value_import_module_ref:type_name -> buf.alpha.registry.v1alpha1.ImportModuleRef
	15, // 46: buf.alpha.registry.v1alpha1.FileExtension.location:type_name -> buf.alpha.registry.v1alpha1.Location
	30, // 47: buf.alpha.registry.v1alpha1.FileExtension.fields:type_name -> buf.alpha.registry.v1alpha1.Field
	1,  // 48: buf.alpha.registry.v1alpha1.DocService.GetSourceDirectoryInfo:input_type -> buf.alpha.registry.v1alpha1.GetSourceDirectoryInfoRequest
	4,  // 49: buf.alpha.registry.v1alpha1.DocService.GetSourceFile:input_type -> buf.alpha.registry.v1alpha1.GetSourceFileRequest
	6,  // 50: buf.alpha.registry.v1alpha1.DocService.GetModulePackages:input_type -> buf.alpha.registry.v1alpha1.GetModulePackagesRequest
	9,  // 51: buf.alpha.registry.v1alpha1.DocService.GetModuleDocumentation:input_type -> buf.alpha.registry.v1alpha1.GetModuleDocumentationRequest
	12, // 52: buf.alpha.registry.v1alpha1.DocService.GetPackageDocumentation:input_type -> buf.alpha.registry.v1alpha1.GetPackageDocumentationRequest
	2,  // 53: buf.alpha.registry.v1alpha1.DocService.GetSourceDirectoryInfo:output_type -> buf.alpha.registry.v1alpha1.GetSourceDirectoryInfoResponse
	5,  // 54: buf.alpha.registry.v1alpha1.DocService.GetSourceFile:output_type -> buf.alpha.registry.v1alpha1.GetSourceFileResponse
	7,  // 55: buf.alpha.registry.v1alpha1.DocService.GetModulePackages:output_type -> buf.alpha.registry.v1alpha1.GetModulePackagesResponse
	10, // 56: buf.alpha.registry.v1alpha1.DocService.GetModuleDocumentation:output_type -> buf.alpha.registry.v1alpha1.GetModuleDocumentationResponse
	13, // 57: buf.alpha.registry.v1alpha1.DocService.GetPackageDocumentation:output_type -> buf.alpha.registry.v1alpha1.GetPackageDocumentationResponse
	53, // [53:58] is the sub-list for method output_type
	48, // [48:53] is the sub-list for method input_type
	48, // [48:48] is the sub-list for extension type_name
	48, // [48:48] is the sub-list for extension extendee
	0,  // [0:48] is the sub-list for field type_name
}

func init() { file_buf_alpha_registry_v1alpha1_doc_proto_init() }
func file_buf_alpha_registry_v1alpha1_doc_proto_init() {
	if File_buf_alpha_registry_v1alpha1_doc_proto != nil {
		return
	}
	file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[26].OneofWrappers = []any{
		(*messageField_Field)(nil),
		(*messageField_Oneof)(nil),
	}
	file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[30].OneofWrappers = []any{}
	file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes[34].OneofWrappers = []any{
		(*literalValue_StringValue)(nil),
		(*literalValue_IntValue)(nil),
		(*literalValue_UintValue)(nil),
		(*literalValue_DoubleValue)(nil),
		(*literalValue_BoolValue)(nil),
		(*literalValue_EnumValueNameValue)(nil),
		(*literalValue_ArrayValue)(nil),
		(*literalValue_MessageValue)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_alpha_registry_v1alpha1_doc_proto_rawDesc), len(file_buf_alpha_registry_v1alpha1_doc_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   37,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_buf_alpha_registry_v1alpha1_doc_proto_goTypes,
		DependencyIndexes: file_buf_alpha_registry_v1alpha1_doc_proto_depIdxs,
		EnumInfos:         file_buf_alpha_registry_v1alpha1_doc_proto_enumTypes,
		MessageInfos:      file_buf_alpha_registry_v1alpha1_doc_proto_msgTypes,
	}.Build()
	File_buf_alpha_registry_v1alpha1_doc_proto = out.File
	file_buf_alpha_registry_v1alpha1_doc_proto_goTypes = nil
	file_buf_alpha_registry_v1alpha1_doc_proto_depIdxs = nil
}
