//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/extensions/bootstrap/internal_listener/v3/internal_listener.proto

package internal_listenerv3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on InternalListener with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *InternalListener) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on InternalListener with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// InternalListenerMultiError, or nil if none found.
func (m *InternalListener) ValidateAll() error {
	return m.validate(true)
}

func (m *InternalListener) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if wrapper := m.GetBufferSizeKb(); wrapper != nil {

		if val := wrapper.GetValue(); val < 1 || val > 8192 {
			err := InternalListenerValidationError{
				field:  "BufferSizeKb",
				reason: "value must be inside range [1, 8192]",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(errors) > 0 {
		return InternalListenerMultiError(errors)
	}

	return nil
}

// InternalListenerMultiError is an error wrapping multiple validation errors
// returned by InternalListener.ValidateAll() if the designated constraints
// aren't met.
type InternalListenerMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m InternalListenerMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m InternalListenerMultiError) AllErrors() []error { return m }

// InternalListenerValidationError is the validation error returned by
// InternalListener.Validate if the designated constraints aren't met.
type InternalListenerValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e InternalListenerValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e InternalListenerValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e InternalListenerValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e InternalListenerValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e InternalListenerValidationError) ErrorName() string { return "InternalListenerValidationError" }

// Error satisfies the builtin error interface
func (e InternalListenerValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sInternalListener.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = InternalListenerValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = InternalListenerValidationError{}
