/*
 * CLOUD API
 *
 *  IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.
 *
 * API version: 6.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionoscloud

import (
	"bytes"
	"context"
	"crypto/sha256"
	"crypto/tls"
	"crypto/x509"
	"encoding/hex"
	"encoding/json"
	"encoding/xml"
	"errors"
	"fmt"
	"io"
	"mime/multipart"
	"net"
	"net/http"
	"net/http/httputil"
	"net/url"
	"os"
	"path/filepath"
	"reflect"
	"regexp"
	"strconv"
	"strings"
	"time"
	"unicode/utf8"

	"golang.org/x/oauth2"
)

var (
	jsonCheck = regexp.MustCompile(`(?i:(?:application|text)/(?:vnd\.[^;]+\+)?json)`)
	xmlCheck  = regexp.MustCompile(`(?i:(?:application|text)/xml)`)
)

const DepthParam = "depth"

const (
	RequestStatusQueued  = "QUEUED"
	RequestStatusRunning = "RUNNING"
	RequestStatusFailed  = "FAILED"
	RequestStatusDone    = "DONE"

	Version = "6.3.3"
)

// Constants for APIs
const FilterQueryParam = "filter.%s"
const FormatStringErr = "%s %s"

// APIClient manages communication with the CLOUD API API v6.0
// In most cases there should be only one, shared, APIClient.
type APIClient struct {
	cfg    *Configuration
	common service // Reuse a single struct instead of allocating one for each service on the heap.

	// API Services

	DefaultApi *DefaultApiService

	ApplicationLoadBalancersApi *ApplicationLoadBalancersApiService

	BackupUnitsApi *BackupUnitsApiService

	ContractResourcesApi *ContractResourcesApiService

	DataCentersApi *DataCentersApiService

	FirewallRulesApi *FirewallRulesApiService

	FlowLogsApi *FlowLogsApiService

	IPBlocksApi *IPBlocksApiService

	ImagesApi *ImagesApiService

	KubernetesApi *KubernetesApiService

	LANsApi *LANsApiService

	LabelsApi *LabelsApiService

	LoadBalancersApi *LoadBalancersApiService

	LocationsApi *LocationsApiService

	NATGatewaysApi *NATGatewaysApiService

	NetworkInterfacesApi *NetworkInterfacesApiService

	NetworkLoadBalancersApi *NetworkLoadBalancersApiService

	PrivateCrossConnectsApi *PrivateCrossConnectsApiService

	RequestsApi *RequestsApiService

	SecurityGroupsApi *SecurityGroupsApiService

	ServersApi *ServersApiService

	SnapshotsApi *SnapshotsApiService

	TargetGroupsApi *TargetGroupsApiService

	TemplatesApi *TemplatesApiService

	UserManagementApi *UserManagementApiService

	UserS3KeysApi *UserS3KeysApiService

	VolumesApi *VolumesApiService
}

type service struct {
	client *APIClient
}

// NewAPIClient creates a new API client. Requires a userAgent string describing your application.
// optionally a custom http.Client to allow for advanced features such as caching.
func NewAPIClient(cfg *Configuration) *APIClient {
	if cfg.HTTPClient == nil {
		cfg.HTTPClient = http.DefaultClient
	}
	//enable certificate pinning if the env variable is set
	pkFingerprint := os.Getenv(IonosPinnedCertEnvVar)
	if pkFingerprint != "" {
		httpTransport := &http.Transport{}
		AddPinnedCert(httpTransport, pkFingerprint)
		cfg.HTTPClient.Transport = httpTransport
	}

	c := &APIClient{}
	c.cfg = cfg
	c.common.client = c

	// API Services
	c.DefaultApi = (*DefaultApiService)(&c.common)
	c.ApplicationLoadBalancersApi = (*ApplicationLoadBalancersApiService)(&c.common)
	c.BackupUnitsApi = (*BackupUnitsApiService)(&c.common)
	c.ContractResourcesApi = (*ContractResourcesApiService)(&c.common)
	c.DataCentersApi = (*DataCentersApiService)(&c.common)
	c.FirewallRulesApi = (*FirewallRulesApiService)(&c.common)
	c.FlowLogsApi = (*FlowLogsApiService)(&c.common)
	c.IPBlocksApi = (*IPBlocksApiService)(&c.common)
	c.ImagesApi = (*ImagesApiService)(&c.common)
	c.KubernetesApi = (*KubernetesApiService)(&c.common)
	c.LANsApi = (*LANsApiService)(&c.common)
	c.LabelsApi = (*LabelsApiService)(&c.common)
	c.LoadBalancersApi = (*LoadBalancersApiService)(&c.common)
	c.LocationsApi = (*LocationsApiService)(&c.common)
	c.NATGatewaysApi = (*NATGatewaysApiService)(&c.common)
	c.NetworkInterfacesApi = (*NetworkInterfacesApiService)(&c.common)
	c.NetworkLoadBalancersApi = (*NetworkLoadBalancersApiService)(&c.common)
	c.PrivateCrossConnectsApi = (*PrivateCrossConnectsApiService)(&c.common)
	c.RequestsApi = (*RequestsApiService)(&c.common)
	c.SecurityGroupsApi = (*SecurityGroupsApiService)(&c.common)
	c.ServersApi = (*ServersApiService)(&c.common)
	c.SnapshotsApi = (*SnapshotsApiService)(&c.common)
	c.TargetGroupsApi = (*TargetGroupsApiService)(&c.common)
	c.TemplatesApi = (*TemplatesApiService)(&c.common)
	c.UserManagementApi = (*UserManagementApiService)(&c.common)
	c.UserS3KeysApi = (*UserS3KeysApiService)(&c.common)
	c.VolumesApi = (*VolumesApiService)(&c.common)

	return c
}

// AddPinnedCert - enables pinning of the sha256 public fingerprint to the http client's transport
func AddPinnedCert(transport *http.Transport, pkFingerprint string) {
	if pkFingerprint != "" {
		transport.DialTLSContext = addPinnedCertVerification([]byte(pkFingerprint), new(tls.Config))
	}
}

// TLSDial can be assigned to a http.Transport's DialTLS field.
type TLSDial func(ctx context.Context, network, addr string) (net.Conn, error)

// AddPinnedCertVerification returns a TLSDial function which checks that
// the remote server provides a certificate whose SHA256 fingerprint matches
// the provided value.
//
// The returned dialer function can be plugged into a http.Transport's DialTLS
// field to allow for certificate pinning.
func addPinnedCertVerification(fingerprint []byte, tlsConfig *tls.Config) TLSDial {
	return func(ctx context.Context, network, addr string) (net.Conn, error) {
		//fingerprints can be added with ':', we need to trim
		fingerprint = bytes.ReplaceAll(fingerprint, []byte(":"), []byte(""))
		fingerprint = bytes.ReplaceAll(fingerprint, []byte(" "), []byte(""))
		//we are manually checking a certificate, so we need to enable insecure
		tlsConfig.InsecureSkipVerify = true

		// Dial the connection to get certificates to check
		conn, err := tls.Dial(network, addr, tlsConfig)
		if err != nil {
			return nil, err
		}

		if err := verifyPinnedCert(fingerprint, conn.ConnectionState().PeerCertificates); err != nil {
			_ = conn.Close()
			return nil, err
		}

		return conn, nil
	}
}

// verifyPinnedCert iterates the list of peer certificates and attempts to
// locate a certificate that is not a CA and whose public key fingerprint matches pkFingerprint.
func verifyPinnedCert(pkFingerprint []byte, peerCerts []*x509.Certificate) error {
	for _, cert := range peerCerts {
		fingerprint := sha256.Sum256(cert.Raw)

		var bytesFingerPrint = make([]byte, hex.EncodedLen(len(fingerprint[:])))
		hex.Encode(bytesFingerPrint, fingerprint[:])

		// we have a match, and it's not an authority certificate
		if cert.IsCA == false && bytes.EqualFold(bytesFingerPrint, pkFingerprint) {
			return nil
		}
	}

	return fmt.Errorf("remote server presented a certificate which does not match the provided fingerprint")
}

func atoi(in string) (int, error) {
	return strconv.Atoi(in)
}

// selectHeaderContentType select a content type from the available list.
func selectHeaderContentType(contentTypes []string) string {
	if len(contentTypes) == 0 {
		return ""
	}
	if contains(contentTypes, "application/json") {
		return "application/json"
	}
	return contentTypes[0] // use the first content type specified in 'consumes'
}

// selectHeaderAccept join all accept types and return
func selectHeaderAccept(accepts []string) string {
	if len(accepts) == 0 {
		return ""
	}

	if contains(accepts, "application/json") {
		return "application/json"
	}

	return strings.Join(accepts, ",")
}

// contains is a case insenstive match, finding needle in a haystack
func contains(haystack []string, needle string) bool {
	for _, a := range haystack {
		if strings.ToLower(a) == strings.ToLower(needle) {
			return true
		}
	}
	return false
}

// Verify optional parameters are of the correct type.
func typeCheckParameter(obj interface{}, expected string, name string) error {
	// Make sure there is an object.
	if obj == nil {
		return nil
	}

	// Check the type is as expected.
	if reflect.TypeOf(obj).String() != expected {
		return fmt.Errorf("Expected %s to be of type %s but received %s.", name, expected, reflect.TypeOf(obj).String())
	}
	return nil
}

// parameterToString convert interface{} parameters to string, using a delimiter if format is provided.
func parameterToString(obj interface{}, collectionFormat string) string {
	var delimiter string

	switch collectionFormat {
	case "pipes":
		delimiter = "|"
	case "ssv":
		delimiter = " "
	case "tsv":
		delimiter = "\t"
	case "csv":
		delimiter = ","
	}

	if reflect.TypeOf(obj).Kind() == reflect.Slice {
		return strings.Trim(strings.Replace(fmt.Sprint(obj), " ", delimiter, -1), "[]")
	} else if t, ok := obj.(time.Time); ok {
		return t.Format(time.RFC3339)
	}

	return fmt.Sprintf("%v", obj)
}

// helper for converting interface{} parameters to json strings
func parameterToJson(obj interface{}) (string, error) {
	jsonBuf, err := json.Marshal(obj)
	if err != nil {
		return "", err
	}
	return string(jsonBuf), err
}

// callAPI do the request.
func (c *APIClient) callAPI(request *http.Request) (*http.Response, time.Duration, error) {
	retryCount := 0

	var resp *http.Response
	var httpRequestTime time.Duration
	var err error

	for {

		retryCount++

		/* we need to clone the request with every retry time because Body closes after the request */
		var clonedRequest *http.Request = request.Clone(request.Context())
		if request.Body != nil {
			clonedRequest.Body, err = request.GetBody()
			if err != nil {
				return nil, httpRequestTime, err
			}
		}

		if c.cfg.Debug || c.cfg.LogLevel.Satisfies(Debug) {
			logRequest := request.Clone(request.Context())

			// Remove the Authorization header if Debug is enabled (but not in Trace mode)
			if !c.cfg.LogLevel.Satisfies(Trace) {
				logRequest.Header.Del("Authorization")
			}

			dump, err := httputil.DumpRequestOut(logRequest, true)
			if err == nil {
				c.cfg.Logger.Printf(" DumpRequestOut : %s\n", string(dump))
			} else {
				c.cfg.Logger.Printf(" DumpRequestOut err: %+v", err)
			}
			c.cfg.Logger.Printf("\n try no: %d\n", retryCount)
		}

		httpRequestStartTime := time.Now()
		clonedRequest.Close = true
		resp, err = c.cfg.HTTPClient.Do(clonedRequest)
		httpRequestTime = time.Since(httpRequestStartTime)
		if err != nil {
			return resp, httpRequestTime, err
		}

		if c.cfg.Debug || c.cfg.LogLevel.Satisfies(Debug) {
			dump, err := httputil.DumpResponse(resp, true)
			if err == nil {
				c.cfg.Logger.Printf("\n DumpResponse : %s\n", string(dump))
			} else {
				c.cfg.Logger.Printf(" DumpResponse err %+v", err)
			}
		}

		var backoffTime time.Duration

		switch resp.StatusCode {
		case http.StatusServiceUnavailable,
			http.StatusGatewayTimeout,
			http.StatusBadGateway:
			if request.Method == http.MethodPost {
				return resp, httpRequestTime, err
			}
			backoffTime = c.GetConfig().WaitTime

		case http.StatusTooManyRequests:
			if retryAfterSeconds := resp.Header.Get("Retry-After"); retryAfterSeconds != "" {
				waitTime, err := time.ParseDuration(retryAfterSeconds + "s")
				if err != nil {
					return resp, httpRequestTime, err
				}
				backoffTime = waitTime
			} else {
				backoffTime = c.GetConfig().WaitTime
			}
		default:
			return resp, httpRequestTime, err

		}

		if retryCount >= c.GetConfig().MaxRetries {
			if c.cfg.Debug || c.cfg.LogLevel.Satisfies(Debug) {
				c.cfg.Logger.Printf(" Number of maximum retries exceeded (%d retries)\n", c.cfg.MaxRetries)
			}
			break
		} else {
			c.backOff(request.Context(), backoffTime)
		}
	}

	return resp, httpRequestTime, err
}

func (c *APIClient) backOff(ctx context.Context, t time.Duration) {
	if t > c.GetConfig().MaxWaitTime {
		t = c.GetConfig().MaxWaitTime
	}
	if c.cfg.Debug || c.cfg.LogLevel.Satisfies(Debug) {
		c.cfg.Logger.Printf(" sleeping %s before retrying request\n", t.String())
	}

	if t <= 0 {
		return
	}

	timer := time.NewTimer(t)
	defer timer.Stop()

	select {
	case <-ctx.Done():
	case <-timer.C:
	}
}

// Allow modification of underlying config for alternate implementations and testing
// Caution: modifying the configuration while live can cause data races and potentially unwanted behavior
func (c *APIClient) GetConfig() *Configuration {
	return c.cfg
}

// prepareRequest build the request
func (c *APIClient) prepareRequest(
	ctx context.Context,
	path string, method string,
	postBody interface{},
	headerParams map[string]string,
	queryParams url.Values,
	formParams url.Values,
	formFileName string,
	fileName string,
	fileBytes []byte) (localVarRequest *http.Request, err error) {

	var body *bytes.Buffer

	val, isSetInEnv := os.LookupEnv(IonosContractNumber)
	_, isSetInMap := headerParams["X-Contract-Number"]
	if headerParams == nil {
		headerParams = make(map[string]string)
	}
	if !isSetInMap && isSetInEnv {
		headerParams["X-Contract-Number"] = val
	}

	// Detect postBody type and post.
	if postBody != nil {
		contentType := headerParams["Content-Type"]
		if contentType == "" {
			contentType = detectContentType(postBody)
			headerParams["Content-Type"] = contentType
		}

		body, err = setBody(postBody, contentType)
		if err != nil {
			return nil, err
		}
	}

	// add form parameters and file if available.
	if strings.HasPrefix(headerParams["Content-Type"], "multipart/form-data") && len(formParams) > 0 || (len(fileBytes) > 0 && fileName != "") {
		if body != nil {
			return nil, errors.New("Cannot specify postBody and multipart form at the same time.")
		}
		body = &bytes.Buffer{}
		w := multipart.NewWriter(body)

		for k, v := range formParams {
			for _, iv := range v {
				if strings.HasPrefix(k, "@") { // file
					err = addFile(w, k[1:], iv)
					if err != nil {
						return nil, err
					}
				} else { // form value
					w.WriteField(k, iv)
				}
			}
		}
		if len(fileBytes) > 0 && fileName != "" {
			w.Boundary()
			//_, fileNm := filepath.Split(fileName)
			part, err := w.CreateFormFile(formFileName, filepath.Base(fileName))
			if err != nil {
				return nil, err
			}
			_, err = part.Write(fileBytes)
			if err != nil {
				return nil, err
			}
		}

		// Set the Boundary in the Content-Type
		headerParams["Content-Type"] = w.FormDataContentType()

		// Set Content-Length
		headerParams["Content-Length"] = fmt.Sprintf("%d", body.Len())
		w.Close()
	}

	if strings.HasPrefix(headerParams["Content-Type"], "application/x-www-form-urlencoded") && len(formParams) > 0 {
		if body != nil {
			return nil, errors.New("Cannot specify postBody and x-www-form-urlencoded form at the same time.")
		}
		body = &bytes.Buffer{}
		body.WriteString(formParams.Encode())
		// Set Content-Length
		headerParams["Content-Length"] = fmt.Sprintf("%d", body.Len())
	}

	if queryParams == nil {
		queryParams = make(url.Values)
	}

	// Setup path and query parameters
	url, err := url.Parse(path)
	if err != nil {
		return nil, err
	}

	// Override request host, if applicable
	if c.cfg.Host != "" {
		url.Host = c.cfg.Host
	}

	// Override request scheme, if applicable
	if c.cfg.Scheme != "" {
		url.Scheme = c.cfg.Scheme
	}

	// Adding Query Param
	query := url.Query()
	/* adding default query params */
	for k, v := range c.cfg.DefaultQueryParams {
		if _, ok := queryParams[k]; !ok {
			queryParams[k] = v
		}
	}
	for k, v := range queryParams {
		for _, iv := range v {
			query.Add(k, iv)
		}
	}

	// Encode the parameters.
	url.RawQuery = query.Encode()

	// Generate a new request
	if body != nil {
		localVarRequest, err = http.NewRequest(method, url.String(), body)
	} else {
		localVarRequest, err = http.NewRequest(method, url.String(), nil)
	}
	if err != nil {
		return nil, err
	}

	// add header parameters, if any
	if len(headerParams) > 0 {
		headers := http.Header{}
		for h, v := range headerParams {
			headers.Set(h, v)
		}
		localVarRequest.Header = headers
	}

	// Add the user agent to the request.
	localVarRequest.Header.Add("User-Agent", c.cfg.UserAgent)

	if c.cfg.Token != "" {
		localVarRequest.Header.Add("Authorization", "Bearer "+c.cfg.Token)
	} else {
		if c.cfg.Username != "" {
			localVarRequest.SetBasicAuth(c.cfg.Username, c.cfg.Password)
		}
	}

	if ctx != nil {
		// add context to the request
		localVarRequest = localVarRequest.WithContext(ctx)

		// Walk through any authentication.

		// OAuth2 authentication
		if tok, ok := ctx.Value(ContextOAuth2).(oauth2.TokenSource); ok {
			// We were able to grab an oauth2 token from the context
			var latestToken *oauth2.Token
			if latestToken, err = tok.Token(); err != nil {
				return nil, err
			}

			latestToken.SetAuthHeader(localVarRequest)
		}

		// Basic HTTP Authentication
		if auth, ok := ctx.Value(ContextBasicAuth).(BasicAuth); ok {
			localVarRequest.SetBasicAuth(auth.UserName, auth.Password)
		}

		// AccessToken Authentication
		if auth, ok := ctx.Value(ContextAccessToken).(string); ok {
			localVarRequest.Header.Add("Authorization", "Bearer "+auth)
		}

	}

	for header, value := range c.cfg.DefaultHeader {
		localVarRequest.Header.Add(header, value)
	}
	return localVarRequest, nil
}

func (c *APIClient) decode(v interface{}, b []byte, contentType string) (err error) {
	if len(b) == 0 {
		return nil
	}
	if s, ok := v.(*string); ok {
		*s = string(b)
		return nil
	}
	if xmlCheck.MatchString(contentType) {
		if err = xml.Unmarshal(b, v); err != nil {
			return err
		}
		return nil
	}
	if jsonCheck.MatchString(contentType) {
		if actualObj, ok := v.(interface{ GetActualInstance() interface{} }); ok { // oneOf, anyOf schemas
			if unmarshalObj, ok := actualObj.(interface{ UnmarshalJSON([]byte) error }); ok { // make sure it has UnmarshalJSON defined
				if err = unmarshalObj.UnmarshalJSON(b); err != nil {
					return err
				}
			} else {
				return errors.New("unknown type with GetActualInstance but no unmarshalObj.UnmarshalJSON defined")
			}
		} else if err = json.Unmarshal(b, v); err != nil { // simple model
			return err
		}
		return nil
	}
	return fmt.Errorf("undefined response type for content %s", contentType)
}

func (c *APIClient) GetRequestStatus(ctx context.Context, path string) (*RequestStatus, *APIResponse, error) {

	r, err := c.prepareRequest(ctx, path, http.MethodGet, nil, nil, nil, nil, "", "", nil)
	if err != nil {
		return nil, nil, err
	}

	resp, httpRequestTime, err := c.callAPI(r)

	var responseBody = make([]byte, 0)
	if resp != nil {
		var errRead error
		responseBody, errRead = io.ReadAll(resp.Body)
		_ = resp.Body.Close()
		if errRead != nil {
			return nil, nil, errRead
		}

	}

	apiResponse := &APIResponse{
		Response:    resp,
		Method:      http.MethodGet,
		RequestTime: httpRequestTime,
		RequestURL:  path,
		Operation:   "GetRequestStatus",
	}

	apiResponse.Payload = responseBody

	if err != nil {
		return nil, apiResponse, err
	}

	status := &RequestStatus{}
	err = c.decode(status, responseBody, resp.Header.Get("Content-Type"))
	if err != nil {
		return nil, apiResponse, err
	}

	return status, apiResponse, nil

}

type ResourceHandler interface {
	GetMetadata() *DatacenterElementMetadata
	GetMetadataOk() (*DatacenterElementMetadata, bool)
}

const (
	Available        string = "AVAILABLE"
	Busy                    = "BUSY"
	Inactive                = "INACTIVE"
	Deploying               = "DEPLOYING"
	Active                  = "ACTIVE"
	Failed                  = "FAILED"
	Suspended               = "SUSPENDED"
	FailedSuspended         = "FAILED_SUSPENDED"
	Updating                = "UPDATING"
	FailedUpdating          = "FAILED_UPDATING"
	Destroying              = "DESTROYING"
	FailedDestroying        = "FAILED_DESTROYING"
	Terminated              = "TERMINATED"
)

type resourceGetCallFn func(apiClient *APIClient, resourceID string) (ResourceHandler, error)
type resourceDeleteCallFn func(apiClient *APIClient, resourceID string) (*APIResponse, error)

type StateChannel struct {
	Msg string
	Err error
}

type DeleteStateChannel struct {
	Msg int
	Err error
}

// fn() is a function that returns from the API the resource you want to check it's state.
// Successful states that can be checked: Available, or Active
func (c *APIClient) WaitForState(ctx context.Context, fn resourceGetCallFn, resourceID string) (bool, error) {
	ticker := time.NewTicker(c.cfg.PollInterval)
	defer ticker.Stop()

	for {
		select {
		case <-ctx.Done():
			return false, ctx.Err()
		case <-ticker.C:
			resource, err := fn(c, resourceID)
			if err != nil {
				return false, fmt.Errorf("error occurred when calling the fn function: %w", err)
			}
			if resource == nil {
				return false, errors.New("fail to get resource")
			}
			if metadata := resource.GetMetadata(); metadata != nil {
				if state, ok := metadata.GetStateOk(); ok && state != nil {
					if *state == Available || *state == Active {
						return true, nil
					}
					if *state == Failed || *state == FailedSuspended || *state == FailedUpdating {
						return false, errors.New("state of the resource is " + *state)
					}
				}
			} else {
				return false, errors.New("metadata could not be retrieved from the fn API call")
			}
		}
		continue
	}
}

// fn() is a function that returns from the API the resource you want to check it's state
// the channel is of type StateChannel and it represents the state of the resource. Successful states that can be checked: Available, or Active
func (c *APIClient) waitForStateWithChanel(ctx context.Context, fn resourceGetCallFn, resourceID string, ch chan<- StateChannel) {
	ticker := time.NewTicker(c.cfg.PollInterval)
	defer ticker.Stop()
	done := make(chan bool, 1)

	for {
		select {
		case <-ctx.Done():
			ch <- StateChannel{
				"",
				ctx.Err(),
			}
			return
		case <-done:
			return
		case <-ticker.C:
			resource, err := fn(c, resourceID)
			if err != nil {
				ch <- StateChannel{
					"",
					fmt.Errorf("error occurred when calling the fn function: %w", err),
				}
			} else if resource == nil {
				ch <- StateChannel{
					"",
					errors.New("fail to get resource"),
				}
			} else if metadata := resource.GetMetadata(); metadata != nil {
				if state, ok := metadata.GetStateOk(); ok && state != nil {
					if *state == Available || *state == Active {
						ch <- StateChannel{
							*state,
							nil,
						}
					}
					if *state == Failed || *state == FailedSuspended || *state == FailedUpdating {
						ch <- StateChannel{
							"",
							errors.New("state of the resource is " + *state),
						}
					}
				}
			} else {
				ch <- StateChannel{
					"",
					errors.New("metadata could not be retrieved from the fn API call"),
				}
			}
			done <- true
		}
		continue
	}
}

// fn() is a function that returns from the API the resource you want to check it's state
// the channel is of type StateChannel and it represents the state of the resource. Successful states that can be checked: Available, or Active
func (c *APIClient) WaitForStateAsync(ctx context.Context, fn resourceGetCallFn, resourceID string, ch chan<- StateChannel) {
	go c.waitForStateWithChanel(ctx, fn, resourceID, ch)
}

// fn() is a function that returns from the API the resource you want to check it's state.
// a resource is deleted when status code 404 is returned from the get call to API
func (c *APIClient) WaitForDeletion(ctx context.Context, fn resourceDeleteCallFn, resourceID string) (bool, error) {
	ticker := time.NewTicker(c.cfg.PollInterval)
	defer ticker.Stop()

	for {
		select {
		case <-ctx.Done():
			return false, ctx.Err()
		case <-ticker.C:
			apiResponse, err := fn(c, resourceID)
			if err != nil {
				if apiResponse == nil {
					return false, fmt.Errorf("fail to get response: %w", err)
				}
				if apiResp := apiResponse.Response; apiResp != nil {
					if apiResp.StatusCode == http.StatusNotFound {
						return true, nil
					}
				}
				return false, err
			}
		}
		continue
	}
}

// fn() is a function that returns from the API the resource you want to check it's state
// the channel is of type int and it represents the status response of the resource, which in this case is 404 to check when the resource is not found.
func (c *APIClient) waitForDeletionWithChannel(ctx context.Context, fn resourceDeleteCallFn, resourceID string, ch chan<- DeleteStateChannel) {
	ticker := time.NewTicker(c.cfg.PollInterval)
	defer ticker.Stop()
	done := make(chan bool, 1)

	for {
		select {
		case <-ctx.Done():
			ch <- DeleteStateChannel{
				0,
				ctx.Err(),
			}
			return
		case <-done:
			return
		case <-ticker.C:
			apiResponse, err := fn(c, resourceID)
			if err != nil {
				if apiResponse == nil {
					ch <- DeleteStateChannel{
						0,
						fmt.Errorf("API Response from fn is empty: %w ", err),
					}
				} else if apiresp := apiResponse.Response; apiresp != nil {
					if statusCode := apiresp.StatusCode; statusCode == http.StatusNotFound {
						ch <- DeleteStateChannel{
							statusCode,
							nil,
						}
					} else {
						ch <- DeleteStateChannel{
							statusCode,
							err,
						}
					}
					done <- true
				}
			}
		}
		continue
	}
}

// fn() is a function that returns from the API the resource you want to check it's state
// the channel is of type int and it represents the status response of the resource, which in this case is 404 to check when the resource is not found.
func (c *APIClient) WaitForDeletionAsync(ctx context.Context, fn resourceDeleteCallFn, resourceID string, ch chan<- DeleteStateChannel) {
	go c.waitForDeletionWithChannel(ctx, fn, resourceID, ch)
}

func (c *APIClient) WaitForRequest(ctx context.Context, path string) (*APIResponse, error) {

	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
	)

	// create path and map variables
	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	r, err := c.prepareRequest(ctx, path, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	ticker := time.NewTicker(c.cfg.PollInterval)
	defer ticker.Stop()
	for {
		resp, httpRequestTime, err := c.callAPI(r)

		var localVarBody = make([]byte, 0)
		if resp != nil {
			var errRead error
			localVarBody, errRead = io.ReadAll(resp.Body)
			_ = resp.Body.Close()
			if errRead != nil {
				return nil, errRead
			}

		}

		localVarAPIResponse := &APIResponse{
			Response:    resp,
			Method:      localVarHTTPMethod,
			RequestTime: httpRequestTime,
			RequestURL:  path,
			Operation:   "WaitForRequest",
		}

		localVarAPIResponse.Payload = localVarBody

		if err != nil {
			return localVarAPIResponse, err
		}

		status := RequestStatus{}
		err = c.decode(&status, localVarBody, resp.Header.Get("Content-Type"))
		if err != nil {
			return localVarAPIResponse, err
		}

		if resp.StatusCode != http.StatusOK {
			msg := fmt.Sprintf("WaitForRequest failed; received status code %d from API", resp.StatusCode)
			return localVarAPIResponse, NewGenericOpenAPIError(msg, localVarBody, nil, resp.StatusCode)
		}
		if status.Metadata != nil && status.Metadata.Status != nil {
			switch *status.Metadata.Status {
			case RequestStatusDone:
				return localVarAPIResponse, nil
			case RequestStatusFailed:
				var id = "<none>"
				var message = "<none>"
				if status.Id != nil {
					id = *status.Id
				}
				if status.Metadata.Message != nil {
					message = *status.Metadata.Message
				}
				return localVarAPIResponse, fmt.Errorf("Request %s failed: %s", id, message)
			}
		}
		select {
		case <-ctx.Done():
			return nil, ctx.Err()
		case <-ticker.C:
			continue
		}
	}
}

// Add a file to the multipart request
func addFile(w *multipart.Writer, fieldName, path string) error {
	file, err := os.Open(path)
	if err != nil {
		return err
	}
	defer file.Close()

	part, err := w.CreateFormFile(fieldName, filepath.Base(path))
	if err != nil {
		return err
	}
	_, err = io.Copy(part, file)

	return err
}

// Prevent trying to import "fmt"
func reportError(format string, a ...interface{}) error {
	return fmt.Errorf(format, a...)
}

// Set request body from an interface{}
func setBody(body interface{}, contentType string) (bodyBuf *bytes.Buffer, err error) {
	if bodyBuf == nil {
		bodyBuf = &bytes.Buffer{}
	}

	if reader, ok := body.(io.Reader); ok {
		_, err = bodyBuf.ReadFrom(reader)
	} else if b, ok := body.([]byte); ok {
		_, err = bodyBuf.Write(b)
	} else if s, ok := body.(string); ok {
		_, err = bodyBuf.WriteString(s)
	} else if s, ok := body.(*string); ok {
		_, err = bodyBuf.WriteString(*s)
	} else if jsonCheck.MatchString(contentType) {
		err = json.NewEncoder(bodyBuf).Encode(body)
	} else if xmlCheck.MatchString(contentType) {
		err = xml.NewEncoder(bodyBuf).Encode(body)
	}

	if err != nil {
		return nil, err
	}

	if bodyBuf.Len() == 0 {
		err = fmt.Errorf("Invalid body type %s\n", contentType)
		return nil, err
	}
	return bodyBuf, nil
}

// detectContentType method is used to figure out `Request.Body` content type for request header
func detectContentType(body interface{}) string {
	contentType := "text/plain; charset=utf-8"
	kind := reflect.TypeOf(body).Kind()

	switch kind {
	case reflect.Struct, reflect.Map, reflect.Ptr:
		contentType = "application/json; charset=utf-8"
	case reflect.String:
		contentType = "text/plain; charset=utf-8"
	default:
		if b, ok := body.([]byte); ok {
			contentType = http.DetectContentType(b)
		} else if kind == reflect.Slice {
			contentType = "application/json; charset=utf-8"
		}
	}

	return contentType
}

// Ripped from https://github.com/gregjones/httpcache/blob/master/httpcache.go
type cacheControl map[string]string

func parseCacheControl(headers http.Header) cacheControl {
	cc := cacheControl{}
	ccHeader := headers.Get("Cache-Control")
	for _, part := range strings.Split(ccHeader, ",") {
		part = strings.Trim(part, " ")
		if part == "" {
			continue
		}
		if strings.ContainsRune(part, '=') {
			keyval := strings.Split(part, "=")
			cc[strings.Trim(keyval[0], " ")] = strings.Trim(keyval[1], ",")
		} else {
			cc[part] = ""
		}
	}
	return cc
}

// CacheExpires helper function to determine remaining time before repeating a request.
func CacheExpires(r *http.Response) time.Time {
	// Figure out when the cache expires.
	var expires time.Time
	now, err := time.Parse(time.RFC1123, r.Header.Get("date"))
	if err != nil {
		return time.Now()
	}
	respCacheControl := parseCacheControl(r.Header)

	if maxAge, ok := respCacheControl["max-age"]; ok {
		lifetime, err := time.ParseDuration(maxAge + "s")
		if err != nil {
			expires = now
		} else {
			expires = now.Add(lifetime)
		}
	} else {
		expiresHeader := r.Header.Get("Expires")
		if expiresHeader != "" {
			expires, err = time.Parse(time.RFC1123, expiresHeader)
			if err != nil {
				expires = now
			}
		}
	}
	return expires
}

func strlen(s string) int {
	return utf8.RuneCountInString(s)
}

// GenericOpenAPIError provides access to the body, error and model on returned errors.
type GenericOpenAPIError struct {
	statusCode int
	body       []byte
	error      string
	model      interface{}
}

// NewGenericOpenAPIError - constructor for GenericOpenAPIError
func NewGenericOpenAPIError(message string, body []byte, model interface{}, statusCode int) GenericOpenAPIError {
	return GenericOpenAPIError{
		statusCode: statusCode,
		body:       body,
		error:      message,
		model:      model,
	}
}

// Error returns non-empty string if there was an error.
func (e GenericOpenAPIError) Error() string {
	return e.error
}

// SetError sets the error string
func (e *GenericOpenAPIError) SetError(error string) {
	e.error = error
}

// Body returns the raw bytes of the response
func (e GenericOpenAPIError) Body() []byte {
	return e.body
}

// SetBody sets the raw body of the error
func (e *GenericOpenAPIError) SetBody(body []byte) {
	e.body = body
}

// Model returns the unpacked model of the error
func (e GenericOpenAPIError) Model() interface{} {
	return e.model
}

// SetModel sets the model of the error
func (e *GenericOpenAPIError) SetModel(model interface{}) {
	e.model = model
}

// StatusCode returns the status code of the error
func (e GenericOpenAPIError) StatusCode() int {
	return e.statusCode
}

// SetStatusCode sets the status code of the error
func (e *GenericOpenAPIError) SetStatusCode(statusCode int) {
	e.statusCode = statusCode
}
