/*========================== begin_copyright_notice ============================

Copyright (C) 2020-2025 Intel Corporation

SPDX-License-Identifier: MIT

============================= end_copyright_notice ===========================*/

/*
@file ml_macros_os.h

@brief Os specific macros.
*/

#pragma once

//////////////////////////////////////////////////////////////////////////
/// @brief Pragma definition.
//////////////////////////////////////////////////////////////////////////
#define ML_PRAGMA( x )           _Pragma( #x )

//////////////////////////////////////////////////////////////////////////
/// @brief Inline macros.
//////////////////////////////////////////////////////////////////////////
#define ML_INLINE                inline
#define ML_FORCE_INLINE          __attribute__( ( always_inline ) ) inline

//////////////////////////////////////////////////////////////////////////
/// @brief Export definition.
//////////////////////////////////////////////////////////////////////////
#define ML_EXPORT( RETURN_TYPE ) RETURN_TYPE __attribute__( ( visibility( "default" ) ) )

//////////////////////////////////////////////////////////////////////////
/// @brief ML_LINUX.
//////////////////////////////////////////////////////////////////////////
#if defined( __linux__ )
    #define ML_LINUX 1
#else
    #define ML_LINUX 0
#endif
