/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.spanner.ui.views;

import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.spanner.ui.SpannerActivator;
import org.jkiss.dbeaver.ext.spanner.ui.internal.SpannerMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.IDialogPageProvider;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageWithAuth;
import org.jkiss.dbeaver.ui.dialogs.connection.DriverPropertiesDialogPage;
import org.jkiss.utils.CommonUtils;

public class SpannerConnectionPage
extends ConnectionPageWithAuth
implements IDialogPageProvider {
    private static final Log log = Log.getLog(SpannerConnectionPage.class);
    private Text projectText;
    private Text instanceText;
    private Text databaseText;
    private static ImageDescriptor logoImage = SpannerActivator.getImageDescriptor("icons/spanner_logo.png");
    private DriverPropertiesDialogPage driverPropsPage = new DriverPropertiesDialogPage((ConnectionPageAbstract)this);

    public void dispose() {
        super.dispose();
    }

    public void createControl(Composite composite) {
        this.setImageDescriptor(logoImage);
        Composite settingsGroup = new Composite(composite, 0);
        settingsGroup.setLayout((Layout)new GridLayout(1, false));
        settingsGroup.setLayoutData((Object)new GridData(1808));
        ModifyListener textListener = e -> this.site.updateButtons();
        Group addrGroup = UIUtils.createControlGroup((Composite)settingsGroup, (String)SpannerMessages.label_connection, (int)2, (int)0, (int)0);
        addrGroup.setLayoutData((Object)new GridData(768));
        this.projectText = UIUtils.createLabelText((Composite)addrGroup, (String)SpannerMessages.label_project, (String)"");
        this.projectText.addModifyListener(textListener);
        this.instanceText = UIUtils.createLabelText((Composite)addrGroup, (String)SpannerMessages.label_instance, (String)"");
        this.instanceText.setToolTipText(SpannerMessages.label_instance_tip);
        this.instanceText.addModifyListener(textListener);
        this.databaseText = UIUtils.createLabelText((Composite)addrGroup, (String)SpannerMessages.label_database, (String)"");
        this.databaseText.setToolTipText(SpannerMessages.label_database_tip);
        this.databaseText.addModifyListener(textListener);
        this.createAuthPanel(settingsGroup, 1);
        this.createDriverPanel(settingsGroup);
        this.setControl((Control)settingsGroup);
    }

    public boolean isComplete() {
        return this.projectText != null && !CommonUtils.isEmpty((String)this.projectText.getText()) && this.instanceText != null && !CommonUtils.isEmpty((String)this.instanceText.getText()) && this.databaseText != null && !CommonUtils.isEmpty((String)this.databaseText.getText());
    }

    public void loadSettings() {
        super.loadSettings();
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        if (this.projectText != null) {
            this.projectText.setText(CommonUtils.notEmpty((String)connectionInfo.getServerName()));
        }
        if (this.instanceText != null) {
            this.instanceText.setText(CommonUtils.notEmpty((String)connectionInfo.getHostName()));
        }
        if (this.databaseText != null) {
            this.databaseText.setText(CommonUtils.notEmpty((String)connectionInfo.getDatabaseName()));
        }
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.projectText != null) {
            connectionInfo.setServerName(this.projectText.getText().trim());
        }
        if (this.instanceText != null) {
            connectionInfo.setHostName(this.instanceText.getText().trim());
        }
        if (this.databaseText != null) {
            connectionInfo.setDatabaseName(this.databaseText.getText().trim());
        }
        super.saveSettings(dataSource);
    }

    @NotNull
    protected String getDefaultAuthModelId(DBPDataSourceContainer dataSource) {
        return "google_spanner";
    }

    public IDialogPage[] getDialogPages(boolean extrasOnly, boolean forceCreate) {
        return new IDialogPage[]{this.driverPropsPage};
    }
}

