// Code generated by go-swagger; DO NOT EDIT.

package global_network_manager_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new global network manager service API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for global network manager service API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	AgentBootstrapConfig(params *AgentBootstrapConfigParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AgentBootstrapConfigOK, error)

	AgentDiscover(params *AgentDiscoverParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AgentDiscoverOK, error)

	AgentPushServerState(params *AgentPushServerStateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AgentPushServerStateOK, error)

	CreateCluster(params *CreateClusterParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateClusterOK, error)

	CreatePeeringConnections(params *CreatePeeringConnectionsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreatePeeringConnectionsOK, error)

	DeleteCluster(params *DeleteClusterParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteClusterOK, error)

	DeletePeeringConnection(params *DeletePeeringConnectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeletePeeringConnectionOK, error)

	GetAggregateServiceSummary(params *GetAggregateServiceSummaryParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetAggregateServiceSummaryOK, error)

	GetCluster(params *GetClusterParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetClusterOK, error)

	GetClusterAPIInfo(params *GetClusterAPIInfoParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetClusterAPIInfoOK, error)

	GetClusterManagementTokenDetails(params *GetClusterManagementTokenDetailsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetClusterManagementTokenDetailsOK, error)

	GetClusterSecrets(params *GetClusterSecretsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetClusterSecretsOK, error)

	GetObservabilitySecret(params *GetObservabilitySecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetObservabilitySecretOK, error)

	GetService(params *GetServiceParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetServiceOK, error)

	GetServiceSummaries(params *GetServiceSummariesParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetServiceSummariesOK, error)

	GetTrial(params *GetTrialParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetTrialOK, error)

	ListClusterPartitions(params *ListClusterPartitionsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListClusterPartitionsOK, error)

	ListClusterServers(params *ListClusterServersParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListClusterServersOK, error)

	ListClusterServices(params *ListClusterServicesParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListClusterServicesOK, error)

	ListClusters(params *ListClustersParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListClustersOK, error)

	ListClustersWithAcceptorEligibility(params *ListClustersWithAcceptorEligibilityParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListClustersWithAcceptorEligibilityOK, error)

	ListClustersWithDialerEligibility(params *ListClustersWithDialerEligibilityParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListClustersWithDialerEligibilityOK, error)

	ListConsulVersions(params *ListConsulVersionsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListConsulVersionsOK, error)

	ListPeersByClusterPartition(params *ListPeersByClusterPartitionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListPeersByClusterPartitionOK, error)

	ListServiceInstances(params *ListServiceInstancesParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListServiceInstancesOK, error)

	ListServices(params *ListServicesParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListServicesOK, error)

	UpdateCluster(params *UpdateClusterParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateClusterOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
AgentBootstrapConfig agent bootstrap config API
*/
func (a *Client) AgentBootstrapConfig(params *AgentBootstrapConfigParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AgentBootstrapConfigOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAgentBootstrapConfigParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "AgentBootstrapConfig",
		Method:             "GET",
		PathPattern:        "/global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{id}/agent/bootstrap_config",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &AgentBootstrapConfigReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AgentBootstrapConfigOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AgentBootstrapConfigDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
AgentDiscover agent discover API
*/
func (a *Client) AgentDiscover(params *AgentDiscoverParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AgentDiscoverOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAgentDiscoverParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "AgentDiscover",
		Method:             "POST",
		PathPattern:        "/global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{id}/agent/discover",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &AgentDiscoverReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AgentDiscoverOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AgentDiscoverDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
AgentPushServerState agent push server state API
*/
func (a *Client) AgentPushServerState(params *AgentPushServerStateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AgentPushServerStateOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAgentPushServerStateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "AgentPushServerState",
		Method:             "POST",
		PathPattern:        "/global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{id}/agent/server-state",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &AgentPushServerStateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AgentPushServerStateOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AgentPushServerStateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CreateCluster create cluster API
*/
func (a *Client) CreateCluster(params *CreateClusterParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateClusterOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateClusterParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreateCluster",
		Method:             "POST",
		PathPattern:        "/global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/clusters",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &CreateClusterReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateClusterOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CreateClusterDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CreatePeeringConnections create peering connections API
*/
func (a *Client) CreatePeeringConnections(params *CreatePeeringConnectionsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreatePeeringConnectionsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreatePeeringConnectionsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreatePeeringConnections",
		Method:             "POST",
		PathPattern:        "/global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/peering_connections",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &CreatePeeringConnectionsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreatePeeringConnectionsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CreatePeeringConnectionsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DeleteCluster delete cluster API
*/
func (a *Client) DeleteCluster(params *DeleteClusterParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteClusterOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteClusterParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "DeleteCluster",
		Method:             "DELETE",
		PathPattern:        "/global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &DeleteClusterReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteClusterOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DeleteClusterDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DeletePeeringConnection delete peering connection API
*/
func (a *Client) DeletePeeringConnection(params *DeletePeeringConnectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeletePeeringConnectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeletePeeringConnectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "DeletePeeringConnection",
		Method:             "DELETE",
		PathPattern:        "/global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/peering_connections/{peering_connection_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &DeletePeeringConnectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeletePeeringConnectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DeletePeeringConnectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetAggregateServiceSummary gets aggregate service sumamry returns a summary of all the service instances callers should use the response s aggregate service summary by kind field that keys service summaries by service kind
*/
func (a *Client) GetAggregateServiceSummary(params *GetAggregateServiceSummaryParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetAggregateServiceSummaryOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetAggregateServiceSummaryParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetAggregateServiceSummary",
		Method:             "GET",
		PathPattern:        "/global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/aggregate_service_summary",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetAggregateServiceSummaryReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetAggregateServiceSummaryOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetAggregateServiceSummaryDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetCluster get cluster API
*/
func (a *Client) GetCluster(params *GetClusterParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetClusterOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetClusterParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetCluster",
		Method:             "GET",
		PathPattern:        "/global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetClusterReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetClusterOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetClusterDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetClusterAPIInfo get cluster API info API
*/
func (a *Client) GetClusterAPIInfo(params *GetClusterAPIInfoParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetClusterAPIInfoOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetClusterAPIInfoParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetClusterAPIInfo",
		Method:             "GET",
		PathPattern:        "/global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{id}/api_information",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetClusterAPIInfoReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetClusterAPIInfoOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetClusterAPIInfoDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetClusterManagementTokenDetails get cluster management token details API
*/
func (a *Client) GetClusterManagementTokenDetails(params *GetClusterManagementTokenDetailsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetClusterManagementTokenDetailsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetClusterManagementTokenDetailsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetClusterManagementTokenDetails",
		Method:             "GET",
		PathPattern:        "/global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{id}/management_token_details",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetClusterManagementTokenDetailsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetClusterManagementTokenDetailsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetClusterManagementTokenDetailsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetClusterSecrets get cluster secrets API
*/
func (a *Client) GetClusterSecrets(params *GetClusterSecretsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetClusterSecretsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetClusterSecretsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetClusterSecrets",
		Method:             "GET",
		PathPattern:        "/global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{id}/secrets",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetClusterSecretsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetClusterSecretsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetClusterSecretsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetObservabilitySecret get observability secret API
*/
func (a *Client) GetObservabilitySecret(params *GetObservabilitySecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetObservabilitySecretOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetObservabilitySecretParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetObservabilitySecret",
		Method:             "GET",
		PathPattern:        "/global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{id}/credentials/observability",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetObservabilitySecretReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetObservabilitySecretOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetObservabilitySecretDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetService get service API
*/
func (a *Client) GetService(params *GetServiceParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetServiceOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetServiceParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetService",
		Method:             "GET",
		PathPattern:        "/2022-02-15/global-network-manager/{cluster_resource_name}/service/{service_name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetServiceReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetServiceOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetServiceDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetServiceSummaries get service summaries API
*/
func (a *Client) GetServiceSummaries(params *GetServiceSummariesParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetServiceSummariesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetServiceSummariesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetServiceSummaries",
		Method:             "GET",
		PathPattern:        "/global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/services",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetServiceSummariesReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetServiceSummariesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetServiceSummariesDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetTrial get trial API
*/
func (a *Client) GetTrial(params *GetTrialParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetTrialOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetTrialParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetTrial",
		Method:             "GET",
		PathPattern:        "/global-network-manager/2022-02-15/organizations/{organization_id}/trial",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetTrialReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetTrialOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetTrialDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ListClusterPartitions lists cluster partitions returns the list of consul admin partitions for a given cluster
*/
func (a *Client) ListClusterPartitions(params *ListClusterPartitionsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListClusterPartitionsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewListClusterPartitionsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ListClusterPartitions",
		Method:             "GET",
		PathPattern:        "/global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{id}/partitions",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ListClusterPartitionsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListClusterPartitionsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ListClusterPartitionsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ListClusterServers list cluster servers API
*/
func (a *Client) ListClusterServers(params *ListClusterServersParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListClusterServersOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewListClusterServersParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ListClusterServers",
		Method:             "GET",
		PathPattern:        "/global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{id}/servers",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ListClusterServersReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListClusterServersOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ListClusterServersDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ListClusterServices list cluster services API
*/
func (a *Client) ListClusterServices(params *ListClusterServicesParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListClusterServicesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewListClusterServicesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ListClusterServices",
		Method:             "GET",
		PathPattern:        "/2022-02-15/global-network-manager/{cluster_resource_name}/services",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ListClusterServicesReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListClusterServicesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ListClusterServicesDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ListClusters list clusters API
*/
func (a *Client) ListClusters(params *ListClustersParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListClustersOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewListClustersParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ListClusters",
		Method:             "GET",
		PathPattern:        "/global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/clusters",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ListClustersReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListClustersOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ListClustersDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ListClustersWithAcceptorEligibility lists clusters with acceptor eligibility returns the list of clusters along with whether they are eligible to be the acceptor in a peering connection
*/
func (a *Client) ListClustersWithAcceptorEligibility(params *ListClustersWithAcceptorEligibilityParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListClustersWithAcceptorEligibilityOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewListClustersWithAcceptorEligibilityParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ListClustersWithAcceptorEligibility",
		Method:             "GET",
		PathPattern:        "/global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/clusters_with_acceptor_eligibility",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ListClustersWithAcceptorEligibilityReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListClustersWithAcceptorEligibilityOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ListClustersWithAcceptorEligibilityDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ListClustersWithDialerEligibility lists clusters with dialer eligibility returns the list of clusters along with whether they are eligible to be the dialer in a peering connection
*/
func (a *Client) ListClustersWithDialerEligibility(params *ListClustersWithDialerEligibilityParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListClustersWithDialerEligibilityOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewListClustersWithDialerEligibilityParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ListClustersWithDialerEligibility",
		Method:             "GET",
		PathPattern:        "/global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/clusters_with_dialer_eligibility",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ListClustersWithDialerEligibilityReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListClustersWithDialerEligibilityOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ListClustersWithDialerEligibilityDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ListConsulVersions list consul versions API
*/
func (a *Client) ListConsulVersions(params *ListConsulVersionsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListConsulVersionsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewListConsulVersionsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ListConsulVersions",
		Method:             "GET",
		PathPattern:        "/global-network-manager/2022-02-15/list_consul_versions",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ListConsulVersionsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListConsulVersionsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ListConsulVersionsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ListPeersByClusterPartition lists peers by cluster partition returns the list of cluster partitions each containing their respective lists of cluster peers if a cluster id is supplied this endpoint returns the list of cluster partitions only for the specified cluster
*/
func (a *Client) ListPeersByClusterPartition(params *ListPeersByClusterPartitionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListPeersByClusterPartitionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewListPeersByClusterPartitionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ListPeersByClusterPartition",
		Method:             "GET",
		PathPattern:        "/global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/peers_by_cluster_partition",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ListPeersByClusterPartitionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListPeersByClusterPartitionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ListPeersByClusterPartitionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ListServiceInstances list service instances API
*/
func (a *Client) ListServiceInstances(params *ListServiceInstancesParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListServiceInstancesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewListServiceInstancesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ListServiceInstances",
		Method:             "GET",
		PathPattern:        "/2022-02-15/global-network-manager/{cluster_resource_name}/service/{service_name}/instances",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ListServiceInstancesReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListServiceInstancesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ListServiceInstancesDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ListServices lists services returns a list of services for all clusters within an h c p project
*/
func (a *Client) ListServices(params *ListServicesParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListServicesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewListServicesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ListServices",
		Method:             "GET",
		PathPattern:        "/2022-02-15/global-network-manager/{project_resource_name}/services",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ListServicesReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListServicesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ListServicesDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
UpdateCluster update cluster API
*/
func (a *Client) UpdateCluster(params *UpdateClusterParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateClusterOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateClusterParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "UpdateCluster",
		Method:             "PATCH",
		PathPattern:        "/global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &UpdateClusterReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateClusterOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UpdateClusterDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
