// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>A custom word configured in a guardrail.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct GuardrailCustomWord {
    /// <p>The match for the custom word.</p>
    pub r#match: ::std::string::String,
    /// <p>The action for the custom word.</p>
    pub action: crate::types::GuardrailWordPolicyAction,
    /// <p>Indicates whether custom word content that breaches the guardrail configuration is detected.</p>
    pub detected: ::std::option::Option<bool>,
}
impl GuardrailCustomWord {
    /// <p>The match for the custom word.</p>
    pub fn r#match(&self) -> &str {
        use std::ops::Deref;
        self.r#match.deref()
    }
    /// <p>The action for the custom word.</p>
    pub fn action(&self) -> &crate::types::GuardrailWordPolicyAction {
        &self.action
    }
    /// <p>Indicates whether custom word content that breaches the guardrail configuration is detected.</p>
    pub fn detected(&self) -> ::std::option::Option<bool> {
        self.detected
    }
}
impl GuardrailCustomWord {
    /// Creates a new builder-style object to manufacture [`GuardrailCustomWord`](crate::types::GuardrailCustomWord).
    pub fn builder() -> crate::types::builders::GuardrailCustomWordBuilder {
        crate::types::builders::GuardrailCustomWordBuilder::default()
    }
}

/// A builder for [`GuardrailCustomWord`](crate::types::GuardrailCustomWord).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct GuardrailCustomWordBuilder {
    pub(crate) r#match: ::std::option::Option<::std::string::String>,
    pub(crate) action: ::std::option::Option<crate::types::GuardrailWordPolicyAction>,
    pub(crate) detected: ::std::option::Option<bool>,
}
impl GuardrailCustomWordBuilder {
    /// <p>The match for the custom word.</p>
    /// This field is required.
    pub fn r#match(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.r#match = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The match for the custom word.</p>
    pub fn set_match(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.r#match = input;
        self
    }
    /// <p>The match for the custom word.</p>
    pub fn get_match(&self) -> &::std::option::Option<::std::string::String> {
        &self.r#match
    }
    /// <p>The action for the custom word.</p>
    /// This field is required.
    pub fn action(mut self, input: crate::types::GuardrailWordPolicyAction) -> Self {
        self.action = ::std::option::Option::Some(input);
        self
    }
    /// <p>The action for the custom word.</p>
    pub fn set_action(mut self, input: ::std::option::Option<crate::types::GuardrailWordPolicyAction>) -> Self {
        self.action = input;
        self
    }
    /// <p>The action for the custom word.</p>
    pub fn get_action(&self) -> &::std::option::Option<crate::types::GuardrailWordPolicyAction> {
        &self.action
    }
    /// <p>Indicates whether custom word content that breaches the guardrail configuration is detected.</p>
    pub fn detected(mut self, input: bool) -> Self {
        self.detected = ::std::option::Option::Some(input);
        self
    }
    /// <p>Indicates whether custom word content that breaches the guardrail configuration is detected.</p>
    pub fn set_detected(mut self, input: ::std::option::Option<bool>) -> Self {
        self.detected = input;
        self
    }
    /// <p>Indicates whether custom word content that breaches the guardrail configuration is detected.</p>
    pub fn get_detected(&self) -> &::std::option::Option<bool> {
        &self.detected
    }
    /// Consumes the builder and constructs a [`GuardrailCustomWord`](crate::types::GuardrailCustomWord).
    /// This method will fail if any of the following fields are not set:
    /// - [`r#match`](crate::types::builders::GuardrailCustomWordBuilder::match)
    /// - [`action`](crate::types::builders::GuardrailCustomWordBuilder::action)
    pub fn build(self) -> ::std::result::Result<crate::types::GuardrailCustomWord, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::GuardrailCustomWord {
            r#match: self.r#match.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "r#match",
                    "r#match was not specified but it is required when building GuardrailCustomWord",
                )
            })?,
            action: self.action.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "action",
                    "action was not specified but it is required when building GuardrailCustomWord",
                )
            })?,
            detected: self.detected,
        })
    }
}
