//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern "C" {
    /// The attribute name for adding a text item with a specified custom tag. The value of the attribute must be an `NSString`.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uitextitemtagattributename?language=objc)
    pub static UITextItemTagAttributeName: &'static NSAttributedStringKey;
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitextitemcontenttype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UITextItemContentType(pub NSInteger);
impl UITextItemContentType {
    /// The text item represents a link.
    #[doc(alias = "UITextItemContentTypeLink")]
    pub const Link: Self = Self(0);
    /// The text item represents a text attachment.
    #[doc(alias = "UITextItemContentTypeTextAttachment")]
    pub const TextAttachment: Self = Self(1);
    /// The text item represents a custom tag.
    #[doc(alias = "UITextItemContentTypeTag")]
    pub const Tag: Self = Self(2);
}

unsafe impl Encode for UITextItemContentType {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UITextItemContentType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitextitem?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UITextItem;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for UITextItem {}
);

impl UITextItem {
    extern_methods!(
        /// The content type of the text item.
        #[unsafe(method(contentType))]
        #[unsafe(method_family = none)]
        pub unsafe fn contentType(&self) -> UITextItemContentType;

        /// The range of the text item.
        #[unsafe(method(range))]
        #[unsafe(method_family = none)]
        pub unsafe fn range(&self) -> NSRange;

        /// The link represented by the text item. This value is `nil` if the `contentType != UITextItemContentTypeLink`
        #[unsafe(method(link))]
        #[unsafe(method_family = none)]
        pub unsafe fn link(&self) -> Option<Retained<NSURL>>;

        #[cfg(feature = "NSTextAttachment")]
        /// The text attachment represented by the text item. This value is `nil` if the `contentType != UITextItemContentTypeTextAttachment`
        #[unsafe(method(textAttachment))]
        #[unsafe(method_family = none)]
        pub unsafe fn textAttachment(&self) -> Option<Retained<NSTextAttachment>>;

        /// The custom tag identifier represented by the text item. This value is `nil` if the `contentType != UITextItemContentTypeTag`
        #[unsafe(method(tagIdentifier))]
        #[unsafe(method_family = none)]
        pub unsafe fn tagIdentifier(&self) -> Option<Retained<NSString>>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_class!(
    /// An object representing the preview for a text item.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uitextitemmenupreview?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UITextItemMenuPreview;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for UITextItemMenuPreview {}
);

impl UITextItemMenuPreview {
    extern_methods!(
        /// Show the default system preview for the given text item.
        #[unsafe(method(defaultPreview))]
        #[unsafe(method_family = none)]
        pub unsafe fn defaultPreview(mtm: MainThreadMarker) -> Retained<Self>;

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        /// Show the specified preview view for the given text item.
        #[unsafe(method(initWithView:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithView(this: Allocated<Self>, view: &UIView) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitextitemmenuconfiguration?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UITextItemMenuConfiguration;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for UITextItemMenuConfiguration {}
);

impl UITextItemMenuConfiguration {
    extern_methods!(
        #[cfg(all(feature = "UIMenu", feature = "UIMenuElement"))]
        /// Creates a menu configuration with the specified menu and a default preview.
        ///
        ///
        /// Parameter `menu`: The menu to be presented.
        #[unsafe(method(configurationWithMenu:))]
        #[unsafe(method_family = none)]
        pub unsafe fn configurationWithMenu(menu: &UIMenu) -> Retained<Self>;

        #[cfg(all(feature = "UIMenu", feature = "UIMenuElement"))]
        /// Creates a menu configuration with the specified menu and custom preview.
        ///
        ///
        /// Parameter `menu`: The menu to be presented.
        ///
        /// Parameter `preview`: The preview associated with the menu. Specify
        /// `nil`for no preview.
        #[unsafe(method(configurationWithPreview:menu:))]
        #[unsafe(method_family = none)]
        pub unsafe fn configurationWithPreview_menu(
            preview: Option<&UITextItemMenuPreview>,
            menu: &UIMenu,
        ) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}
