/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_my extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_AZ = "အဇာဘိုင်ဂျန်";
        final String metaValue_BY = "ဘီလာရုစ်";
        final String metaValue_BG = "ဘူလ်ဂေးရီးယား";
        final String metaValue_DK = "ဒိန်းမတ်";
        final String metaValue_GR = "ဂရိ";
        final String metaValue_ES = "စပိန်";
        final String metaValue_FI = "ဖင်လန်";
        final String metaValue_FJ = "ဖီဂျီ";
        final String metaValue_FR = "ပြင်သစ်";
        final String metaValue_HR = "ခရိုအေးရှား";
        final String metaValue_HT = "ဟေတီ";
        final String metaValue_HU = "ဟန်ဂေရီ";
        final String metaValue_AM = "အာမေးနီးယား";
        final String metaValue_ID = "အင်ဒိုနီးရှား";
        final String metaValue_IT = "အီတလီ";
        final String metaValue_JP = "ဂျပန်";
        final String metaValue_GE = "ဂျော်ဂျီယာ";
        final String metaValue_CD = "ကွန်ဂို";
        final String metaValue_LU = "လူဇင်ဘတ်";
        final String metaValue_LA = "လာအို";
        final String metaValue_LT = "လစ်သူဝေးနီးယား";
        final String metaValue_LV = "လတ်ဗီးယား";
        final String metaValue_MM = "မြန်မာ";
        final String metaValue_NR = "နော်ရူး";
        final String metaValue_NP = "နီပေါ";
        final String metaValue_NO = "နော်ဝေ";
        final String metaValue_PL = "ပိုလန်";
        final String metaValue_PT = "ပေါ်တူဂီ";
        final String metaValue_SI = "ဆလိုဗေးနီးယား";
        final String metaValue_AL = "အယ်လ်ဘေးနီးယား";
        final String metaValue_RS = "ဆားဘီးယား";
        final String metaValue_SZ = "ဆွာဇီလန်";
        final String metaValue_SD = "ဆူဒန်";
        final String metaValue_SE = "ဆွီဒင်";
        final String metaValue_TH = "ထိုင်း";
        final String metaValue_TM = "တာ့ခ်မင်နစ္စတန်";
        final String metaValue_TO = "တွန်ဂါ";
        final String metaValue_TR = "တူရကီ";
        final String metaValue_UA = "ယူကရိန်း";
        final String metaValue_VN = "ဗီယက်နမ်";
        final String metaValue_CN = "တရုတ်";
        final String metaValue_PH = "ဖိလစ်ပိုင်";
        final String metaValue_MU = "မောရစ်ရှ";
        final String metaValue_PW = "ပလာအို";
        final String metaValue_SY = "ဆီးရီးယား";
        final String metaValue_bn = "ဘင်္ဂါလီ";
        final String metaValue_ET = "အီသီယိုးပီးယား";
        final String metaValue_km = "ခမာ";
        final String metaValue_ko = "ကိုရီးယား";
        final String metaValue_la = "လက်တင်";
        final String metaValue_ml = "မလေယာလမ်";
        final String metaValue_mn = "မွန်ဂိုလီးယား";
        final String metaValue_nqo = "အွန်ကို";
        final String metaValue_ta = "တမီးလ်";
        final String metaValue_bo = "တိဘက်";
        final String metaValue_peo = "ပါရှန် အဟောင်း";
        final Object[][] data = new Object[][] {
            { "001", "ကမ္ဘာ" },
            { "002", "အာဖရိက" },
            { "003", "မြောက် အမေရိကတိုက်" },
            { "005", "တောင် အမေရိက" },
            { "009", "သမုဒ္ဒရာဒေသ" },
            { "011", "အနောက် အာဖရိက" },
            { "013", "ဗဟို အမေရိက" },
            { "014", "အရှေ့ အာဖရိက" },
            { "015", "မြောက် အာဖရိက" },
            { "017", "အလယ် အာဖရိက" },
            { "018", "အာဖရိက တောင်ပိုင်း" },
            { "019", "အမေရိကန်" },
            { "021", "မြောက် အမေရိက" },
            { "029", "ကာရစ်ဘီယံ" },
            { "030", "အရှေ့အာရှ" },
            { "034", "တောင်အာရှ" },
            { "035", "အရှေ့တောင်အာရှ" },
            { "039", "တောင်ဥရောပ" },
            { "053", "ဩစတြေးလျနှင့် နယူးဇီလန်" },
            { "054", "မီလာနီးရှား" },
            { "057", "မိုက်ခရိုနီးရှား ဒေသ" },
            { "061", "ပိုလီနီရှား" },
            { "142", "အာရှ" },
            { "143", "အလယ်အာရှ" },
            { "145", "အနောက်အာရှ" },
            { "150", "ဥရောပ" },
            { "151", "အရှေ့ ဥရောပ" },
            { "154", "မြောက် ဥရောပ" },
            { "155", "အနောက် ဥရောပ" },
            { "202", "ဆာဟာရ-အောက်ပိုင်း အာဖရိက" },
            { "419", "လက်တင်အမေရိက" },
            { "AC", "အဆန်းရှင်းကျွန်း" },
            { "AD", "အန်ဒိုရာ" },
            { "AE", "ယူအေအီး" },
            { "AF", "အာဖဂန်နစ္စတန်" },
            { "AG", "အန်တီဂွါနှင့် ဘာဘူဒါ" },
            { "AI", "အန်ဂီလာ" },
            { "AL", metaValue_AL },
            { "AM", metaValue_AM },
            { "AO", "အန်ဂိုလာ" },
            { "AQ", "အန်တာတိက" },
            { "AR", "အာဂျင်တီးနား" },
            { "AS", "အမေရိကန် ဆမိုးအား" },
            { "AT", "ဩစတြီးယား" },
            { "AU", "ဩစတြေးလျ" },
            { "AW", "အာရူးဗား" },
            { "AX", "အာလန်ကျွန်း" },
            { "AZ", metaValue_AZ },
            { "BA", "ဘော့စနီးယားနှင့် ဟာဇီဂိုဗီနား" },
            { "BB", "ဘာဘေးဒိုးစ်" },
            { "BD", "ဘင်္ဂလားဒေ့ရှ်" },
            { "BE", "ဘယ်လ်ဂျီယမ်" },
            { "BF", "ဘာကီးနား ဖားဆို" },
            { "BG", metaValue_BG },
            { "BH", "ဘာရိန်း" },
            { "BI", "ဘူရွန်ဒီ" },
            { "BJ", "ဘီနင်" },
            { "BL", "စိန့်ဘာသယ်လ်မီ" },
            { "BM", "ဘာမြူဒါ" },
            { "BN", "ဘရူနိုင်း" },
            { "BO", "ဘိုလီးဗီးယား" },
            { "BQ", "ကာရစ်ဘီယံ နယ်သာလန်" },
            { "BR", "ဘရာဇီး" },
            { "BS", "ဘဟားမား" },
            { "BT", "ဘူတန်" },
            { "BV", "ဘူဗက်ကျွန်း" },
            { "BW", "ဘော့ဆွာနာ" },
            { "BY", metaValue_BY },
            { "BZ", "ဘလိဇ်" },
            { "CA", "ကနေဒါ" },
            { "CC", "ကိုကိုးကျွန်း" },
            { "CD", metaValue_CD },
            { "CF", "ဗဟို အာဖရိက ပြည်ထောင်စု" },
            { "CG", "ကွန်ဂို-ဘရာဇာဗီးလ်" },
            { "CH", "ဆွစ်ဇာလန်" },
            { "CI", "ကို့တ် ဒီဗွာ" },
            { "CK", "ကွတ် ကျွန်းစု" },
            { "CL", "ချီလီ" },
            { "CM", "ကင်မရွန်း" },
            { "CN", metaValue_CN },
            { "CO", "ကိုလံဘီယာ" },
            { "CP", "ကလစ်ပါတန်ကျွန်း" },
            { "CQ", "ဆာ့က်" },
            { "CR", "ကို့စ်တာရီကာ" },
            { "CU", "ကျူးဘား" },
            { "CV", "ကိတ်ဗာဒီ" },
            { "CW", "ကျူရေးကိုးစ်" },
            { "CX", "ခရစ်စမတ် ကျွန်း" },
            { "CY", "ဆိုက်ပရပ်စ်" },
            { "CZ", "ချက်ကီယား" },
            { "DE", "ဂျာမနီ" },
            { "DG", "ဒီအဲဂိုဂါစီရာ" },
            { "DJ", "ဂျီဘူတီ" },
            { "DK", metaValue_DK },
            { "DM", "ဒိုမီနီကာ" },
            { "DO", "ဒိုမီနီကန်" },
            { "DZ", "အယ်လ်ဂျီးရီးယား" },
            { "EA", "ဆယ်ဥတာနှင့်မယ်လီလ်လာ" },
            { "EC", "အီကွေဒေါ" },
            { "EE", "အက်စတိုးနီးယား" },
            { "EG", "အီဂျစ်" },
            { "EH", "အနောက် ဆာဟာရ" },
            { "ER", "အီရီထရီးယား" },
            { "ES", metaValue_ES },
            { "ET", metaValue_ET },
            { "EU", "ဥရောပသမဂ္ဂ" },
            { "EZ", "ဥရောပဒေသ" },
            { "FI", metaValue_FI },
            { "FJ", metaValue_FJ },
            { "FK", "ဖော့ကလန် ကျွန်းစု" },
            { "FM", "မိုင်ခရိုနီရှား" },
            { "FO", "ဖာရိုး ကျွန်းစုများ" },
            { "FR", metaValue_FR },
            { "GA", "ဂါဘွန်" },
            { "GB", "ယူနိုက်တက်ကင်းဒမ်း" },
            { "GD", "ဂရီနေဒါ" },
            { "GE", metaValue_GE },
            { "GF", "ပြင်သစ် ဂီယာနာ" },
            { "GG", "ဂွန်းဇီ" },
            { "GH", "ဂါနာ" },
            { "GI", "ဂျီဘရော်လ်တာ" },
            { "GL", "ဂရင်းလန်း" },
            { "GM", "ဂမ်ဘီရာ" },
            { "GN", "ဂီနီ" },
            { "GP", "ဂွါဒီလု" },
            { "GQ", "အီကွေတာ ဂီနီ" },
            { "GR", metaValue_GR },
            { "GS", "တောင် ဂျော်ဂျီယာ နှင့် တောင် ဆင်းဒဝစ်ဂျ် ကျွန်းစုများ" },
            { "GT", "ဂွါတီမာလာ" },
            { "GU", "ဂူအမ်" },
            { "GW", "ဂီနီ-ဘီစော" },
            { "GY", "ဂိုင်ယာနာ" },
            { "HK", "ဟောင်ကောင် (တရုတ်ပြည်)" },
            { "HM", "ဟတ်ကျွန်းနှင့်မက်ဒေါနယ်ကျွန်းစု" },
            { "HN", "ဟွန်ဒူးရပ်စ်" },
            { "HR", metaValue_HR },
            { "HT", metaValue_HT },
            { "HU", metaValue_HU },
            { "IC", "ကနေရီ ကျွန်းစု" },
            { "ID", metaValue_ID },
            { "IE", "အိုင်ယာလန်" },
            { "IL", "အစ္စရေး" },
            { "IM", "မန်ကျွန်း" },
            { "IN", "အိန္ဒိယ" },
            { "IO", "ဗြိတိသျှပိုင် အိန္ဒိယသမုဒ္ဒရာကျွန်းများ" },
            { "IQ", "အီရတ်" },
            { "IR", "အီရန်" },
            { "IS", "အိုက်စလန်" },
            { "IT", metaValue_IT },
            { "JE", "ဂျာစီ" },
            { "JM", "ဂျမေကာ" },
            { "JO", "ဂျော်ဒန်" },
            { "JP", metaValue_JP },
            { "KE", "ကင်ညာ" },
            { "KG", "ကာဂျစ္စတန်" },
            { "KH", "ကမ္ဘောဒီးယား" },
            { "KI", "ခီရီဘာတီ" },
            { "KM", "ကိုမိုရိုစ်" },
            { "KN", "စိန့်ကစ်နှင့်နီဗီစ်" },
            { "KP", "မြောက်ကိုရီးယား" },
            { "KR", "တောင်ကိုရီးယား" },
            { "KW", "ကူဝိတ်" },
            { "KY", "ကေမန် ကျွန်းစု" },
            { "KZ", "ကာဇက်စတန်" },
            { "LA", metaValue_LA },
            { "LB", "လက်ဘနွန်" },
            { "LC", "စိန့်လူစီယာ" },
            { "LI", "လစ်တန်စတိန်း" },
            { "LK", "သီရိလင်္ကာ" },
            { "LR", "လိုက်ဘေးရီးယား" },
            { "LS", "လီဆိုသို" },
            { "LT", metaValue_LT },
            { "LU", metaValue_LU },
            { "LV", metaValue_LV },
            { "LY", "လစ်ဗျား" },
            { "MA", "မော်ရိုကို" },
            { "MC", "မိုနာကို" },
            { "MD", "မောလ်ဒိုဗာ" },
            { "ME", "မွန်တီနိဂရိုး" },
            { "MF", "စိန့်မာတင်" },
            { "MG", "မဒါဂတ်စကား" },
            { "MH", "မာရှယ် ကျွန်းစု" },
            { "MK", "မြောက် မက်ဆီဒိုးနီးယား" },
            { "ML", "မာလီ" },
            { "MM", metaValue_MM },
            { "MN", "မွန်ဂိုးလီးယား" },
            { "MO", "မကာအို (တရုတ်ပြည်)" },
            { "MP", "မြောက်ပိုင်းမာရီအာနာကျွန်းစု" },
            { "MQ", "မာတီနိခ်" },
            { "MR", "မော်ရီတေးနီးယား" },
            { "MS", "မောင့်စဲရက်" },
            { "MT", "မောလ်တာ" },
            { "MU", metaValue_MU },
            { "MV", "မော်လ်ဒိုက်" },
            { "MW", "မာလာဝီ" },
            { "MX", "မက်ကဆီကို" },
            { "MY", "မလေးရှား" },
            { "MZ", "မိုဇမ်ဘစ်" },
            { "NA", "နမီးဘီးယား" },
            { "NC", "နယူး ကယ်လီဒိုနီးယား" },
            { "NE", "နိုင်ဂျာ" },
            { "NF", "နောဖုတ်ကျွန်း" },
            { "NG", "နိုင်ဂျီးရီးယား" },
            { "NI", "နီကာရာဂွါ" },
            { "NL", "နယ်သာလန်" },
            { "NO", metaValue_NO },
            { "NP", metaValue_NP },
            { "NR", metaValue_NR },
            { "NU", "နီဥူအေ" },
            { "NZ", "နယူးဇီလန်" },
            { "OM", "အိုမန်" },
            { "PA", "ပနားမား" },
            { "PE", "ပီရူး" },
            { "PF", "ပြင်သစ် ပေါ်လီနီးရှား" },
            { "PG", "ပါပူအာ နယူးဂီနီ" },
            { "PH", metaValue_PH },
            { "PK", "ပါကစ္စတန်" },
            { "PL", metaValue_PL },
            { "PM", "စိန့်ပီအဲရ်နှင့် မီကွီလွန်" },
            { "PN", "ပစ်တ်ကိန်းကျွန်းစု" },
            { "PR", "ပေါ်တိုရီကို" },
            { "PS", "ပါလက်စတိုင်း ပိုင်နက်" },
            { "PT", metaValue_PT },
            { "PW", metaValue_PW },
            { "PY", "ပါရာဂွေး" },
            { "QA", "ကာတာ" },
            { "QO", "သမုဒ္ဒရာ အပြင်ဘက်ရှိ ကျွန်းနိုင်ငံများ" },
            { "RE", "ရီယူနီယန်" },
            { "RO", "ရိုမေးနီးယား" },
            { "RS", metaValue_RS },
            { "RU", "ရုရှား" },
            { "RW", "ရဝန်ဒါ" },
            { "SA", "ဆော်ဒီအာရေးဘီးယား" },
            { "SB", "ဆော်လမွန်ကျွန်းစု" },
            { "SC", "ဆေးရှဲ" },
            { "SD", metaValue_SD },
            { "SE", metaValue_SE },
            { "SG", "စင်္ကာပူ" },
            { "SH", "စိန့်ဟယ်လယ်နာ" },
            { "SI", metaValue_SI },
            { "SJ", "စဗိုလ်ဘတ်နှင့်ဂျန်မေရန်" },
            { "SK", "ဆလိုဗက်ကီးယား" },
            { "SL", "ဆီယာရာ လီယွန်း" },
            { "SM", "ဆန်မာရီနို" },
            { "SN", "ဆီနီဂေါ" },
            { "SO", "ဆိုမာလီယာ" },
            { "SR", "ဆူရာနမ်" },
            { "SS", "တောင် ဆူဒန်" },
            { "ST", "ဆောင်တူမေးနှင့် ပရင်စီပီ" },
            { "SV", "အယ်လ်ဆာဗေးဒိုး" },
            { "SX", "စင့်မာတင်" },
            { "SY", metaValue_SY },
            { "SZ", metaValue_SZ },
            { "TA", "ထရစ္စတန် ဒါ ကွန်ဟာ" },
            { "TC", "တခ်စ်နှင့်ကာအီကိုစ်ကျွန်းစု" },
            { "TD", "ချဒ်" },
            { "TF", "ပြင်သစ် တောင်ပိုင်း ပိုင်နက်များ" },
            { "TG", "တိုဂို" },
            { "TH", metaValue_TH },
            { "TJ", "တာဂျီကစ္စတန်" },
            { "TK", "တိုကလောင်" },
            { "TL", "အရှေ့တီမော" },
            { "TM", metaValue_TM },
            { "TN", "တူနီးရှား" },
            { "TO", metaValue_TO },
            { "TR", metaValue_TR },
            { "TT", "ထရီနီဒတ်နှင့် တိုဘက်ဂို" },
            { "TV", "တူဗားလူ" },
            { "TW", "ထိုင်ဝမ်" },
            { "TZ", "တန်ဇန်းနီးယား" },
            { "UA", metaValue_UA },
            { "UG", "ယူဂန်းဒါး" },
            { "UM", "ယူနိုက်တက်စတိတ် ကျွန်းနိုင်ငံများ" },
            { "UN", "ကုလသမဂ္ဂ" },
            { "US", "အမေရိကန် ပြည်ထောင်စု" },
            { "UY", "ဥရုဂွေး" },
            { "UZ", "ဥဇဘက်ကစ္စတန်" },
            { "VA", "ဗာတီကန်စီးတီး" },
            { "VC", "စိန့်ဗင်းဆင့်နှင့် ဂရိနေဒိုင်" },
            { "VE", "ဗင်နီဇွဲလား" },
            { "VG", "ဗြိတိသျှ ဗာဂျင်း ကျွန်းစု" },
            { "VI", "ယူအက်စ် ဗာဂျင်း ကျွန်းစု" },
            { "VN", metaValue_VN },
            { "VU", "ဗနွားတူ" },
            { "WF", "ဝေါလစ်နှင့် ဖူကျူးနား" },
            { "WS", "ဆမိုးအား" },
            { "XA", "နိုင်ငံခြားသံ" },
            { "XB", "စာပြောင်းပြန်" },
            { "XK", "ကိုဆိုဗို" },
            { "YE", "ယီမင်" },
            { "YT", "မေယော့" },
            { "ZA", "တောင်အာဖရိက" },
            { "ZM", "ဇမ်ဘီယာ" },
            { "ZW", "ဇင်ဘာဘွေ" },
            { "ZZ", "မသိ (သို့) မရှိသော ဒေသ" },
            { "aa", "အာဖာ" },
            { "ab", "အဘ်ခါဇီရာ" },
            { "af", "အာဖရိကန်" },
            { "ak", "အာကန်" },
            { "am", "အမ်ဟာရစ်ခ်" },
            { "an", "အာရာဂွန်" },
            { "ar", "အာရဗီ" },
            { "as", "အာသံ" },
            { "av", "အာဗာရစ်ခ်" },
            { "ay", "အိုင်မာရ" },
            { "az", metaValue_AZ },
            { "ba", "ဘက်ရှ်ကာ" },
            { "be", metaValue_BY },
            { "bg", metaValue_BG },
            { "bi", "ဘစ်စ်လာမာ" },
            { "bm", "ဘန်ဘာရာ" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "ဘရီတွန်" },
            { "bs", "ဘော့စ်နီးယား" },
            { "ca", "ကတ်တလန်" },
            { "ce", "ချက်ချန်း" },
            { "ch", "ချမိုရို" },
            { "co", "ခိုစီကန်" },
            { "cr", "ခရီး" },
            { "cs", "ချက်" },
            { "cu", "ချပ်ချ် စလာဗစ်" },
            { "cv", "ချူဗက်ရှ်" },
            { "cy", "ဝေလ" },
            { "da", metaValue_DK },
            { "de", "ဂျာမန်" },
            { "dv", "ဒီဗာဟီ" },
            { "dz", "ဒဇွန်ကာ" },
            { "ee", "အီဝီ" },
            { "el", metaValue_GR },
            { "en", "အင်္ဂလိပ်" },
            { "eo", "အက်စ်ပရန်တို" },
            { "es", metaValue_ES },
            { "et", "အက်စ်တိုးနီးယား" },
            { "eu", "ဘာစ်ခ်" },
            { "fa", "ပါရှန်" },
            { "ff", "ဖူလာ" },
            { "fi", metaValue_FI },
            { "fj", metaValue_FJ },
            { "fo", "ဖာရို" },
            { "fr", metaValue_FR },
            { "fy", "အနောက် ဖရီစီရန်" },
            { "ga", "အိုင်းရစ်ရှ်" },
            { "gd", "စကော့တစ်ရှ် ဂေးလစ်ခ်" },
            { "gl", "ဂါလီစီယာ" },
            { "gn", "ဂူအာရာနီ" },
            { "gu", "ဂူဂျာရသီ" },
            { "gv", "မန်းဇ်" },
            { "ha", "ဟာဥစာ" },
            { "he", "ဟီဘရူး" },
            { "hi", "ဟိန္ဒီ" },
            { "hr", metaValue_HR },
            { "ht", metaValue_HT },
            { "hu", metaValue_HU },
            { "hy", metaValue_AM },
            { "hz", "ဟီရဲရို" },
            { "ia", "အင်တာလင်ဂွါ" },
            { "id", metaValue_ID },
            { "ie", "အင်တာလင်း" },
            { "ig", "အစ္ဂဘို" },
            { "ii", "စီချွမ် ရီ" },
            { "io", "အီဒို" },
            { "is", "အိုက်စ်လန်" },
            { "it", metaValue_IT },
            { "iu", "အီနုခ်တီတု" },
            { "ja", metaValue_JP },
            { "jv", "ဂျာဗား" },
            { "ka", metaValue_GE },
            { "kg", metaValue_CD },
            { "ki", "ကီကူယူ" },
            { "kj", "ကွန်းယာမာ" },
            { "kk", "ကာဇာချ" },
            { "kl", "ကလာအ်လီဆပ်" },
            { "km", metaValue_km },
            { "kn", "ကန်နာဒါ" },
            { "ko", metaValue_ko },
            { "kr", "ကနူရီ" },
            { "ks", "ကက်ရှ်မီးယား" },
            { "ku", "ကာမန်းဂျီ" },
            { "kv", "ကိုမီ" },
            { "kw", "ခိုနီရှ်" },
            { "ky", "ကာဂျစ်" },
            { "la", metaValue_la },
            { "lb", metaValue_LU },
            { "lg", "ဂန်ဒါ" },
            { "li", "လင်ဘာဂစ်ရှ်" },
            { "ln", "လင်ဂါလာ" },
            { "lo", metaValue_LA },
            { "lt", metaValue_LT },
            { "lu", "လူဘာ-ကတန်ဂါ" },
            { "lv", metaValue_LV },
            { "mg", "မာလဂက်စီ" },
            { "mh", "မာရှယ်လိဇ်" },
            { "mi", "မာအိုရီ" },
            { "mk", "မက်ဆီဒိုးနီးယား" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "မာရသီ" },
            { "ms", "မလေး" },
            { "mt", "မော်လ်တာ" },
            { "my", metaValue_MM },
            { "na", metaValue_NR },
            { "nb", "နော်ဝေ ဘွတ်ခ်မော်လ်" },
            { "nd", "မြောက် အွန်န်ဒီဘီလီ" },
            { "ne", metaValue_NP },
            { "ng", "အွန်ဒွန်ဂါ" },
            { "nl", "ဒတ်ခ်ျ" },
            { "nn", "နော်ဝေ နီးနောစ်" },
            { "no", metaValue_NO },
            { "nr", "တောင် အွန်န်ဘီလီ" },
            { "nv", "နာဗာဟို" },
            { "ny", "နရန်ဂျာ" },
            { "oc", "အိုစီတန်" },
            { "om", "အိုရိုမို" },
            { "or", "အိုရီရာ" },
            { "os", "အိုဆဲတစ်ခ်" },
            { "pa", "ပန်ချာပီ" },
            { "pi", "ပါဠိ" },
            { "pl", metaValue_PL },
            { "ps", "ပက်ရှ်တွန်း" },
            { "pt", metaValue_PT },
            { "qu", "ခီချူဝါအိုဝါ" },
            { "rm", "ရောမ" },
            { "rn", "ရွန်ဒီ" },
            { "ro", "ရိုမေနီယား" },
            { "ru", "ရုရှ" },
            { "rw", "ကင်ရာဝန်ဒါ" },
            { "sa", "သင်္သကရိုက်" },
            { "sc", "ဆာဒီနီးယား" },
            { "sd", "စင်ဒီ" },
            { "se", "မြောက် ဆာမိ" },
            { "sg", "ဆန်ဂို" },
            { "si", "စင်ဟာလာ" },
            { "sk", "ဆလိုဗက်" },
            { "sl", metaValue_SI },
            { "sm", "ဆမိုအာ" },
            { "sn", "ရှိုနာ" },
            { "so", "ဆိုမာလီ" },
            { "sq", metaValue_AL },
            { "sr", metaValue_RS },
            { "ss", metaValue_SZ },
            { "st", "တောင်ပိုင်း ဆိုသို" },
            { "su", metaValue_SD },
            { "sv", metaValue_SE },
            { "sw", "ဆွာဟီလီ" },
            { "ta", metaValue_ta },
            { "te", "တီလီဂူ" },
            { "tg", "တာဂျစ်" },
            { "th", metaValue_TH },
            { "ti", "တီဂ်ရင်ယာ" },
            { "tk", metaValue_TM },
            { "tn", "တီဆဝါနာ" },
            { "to", metaValue_TO },
            { "tr", metaValue_TR },
            { "ts", "ဆွန်ဂါ" },
            { "tt", "တာတာ" },
            { "ty", "တဟီတီ" },
            { "ug", "ဝီဂါ" },
            { "uk", metaValue_UA },
            { "ur", "အူရ်ဒူ" },
            { "uz", "ဥဇဘတ်" },
            { "ve", "ဗင်န်ဒါ" },
            { "vi", metaValue_VN },
            { "vo", "ဗိုလာပိုက်" },
            { "wa", "ဝါလူးန်" },
            { "wo", "ဝူလိုဖ်" },
            { "xh", "ဇိုစာ" },
            { "yi", "ရဟူဒီ" },
            { "yo", "ယိုရူဘာ" },
            { "za", "ဂျွမ်" },
            { "zh", metaValue_CN },
            { "zu", "ဇူးလူး" },
            { "ace", "အာချေး" },
            { "ada", "ဒန်မဲ" },
            { "ady", "အဒိုင်ဂီ" },
            { "agq", "အာဂ်ဟိန်း" },
            { "ain", "အိန်နု" },
            { "ale", "အာလီယု" },
            { "alt", "တောင် အာလ်တိုင်း" },
            { "ang", "အင်ဂလို ဆက္ကစွန်" },
            { "ann", "အိုဘိုလို" },
            { "anp", "အန်ဂီကာ" },
            { "arn", "မာပုချီ" },
            { "arp", "အာရာပါဟို" },
            { "ars", "နာ့ဂျဒီ အာရဗစ်" },
            { "asa", "အာစု" },
            { "ast", "အက်စ်တိုးရီးယား" },
            { "atj", "အာတီကမဲကု" },
            { "awa", "အာဝါဒီ" },
            { "bal", "ဘယ်လူချီ" },
            { "ban", "ဘာလီ" },
            { "bas", "ဘာဆာ" },
            { "bem", "ဘိန်ဘာ" },
            { "bez", "ဘီနာ" },
            { "bgc", "ဟာယန်ဗီ" },
            { "bgn", "အနောက် ဘဲလိုချီ" },
            { "bho", "ဘို့ဂျ်ပူရီ" },
            { "bin", "ဘီနီ" },
            { "bla", "စစ္စီကာ" },
            { "blo", "အန်နီ" },
            { "brx", "ဗိုဒို" },
            { "bug", "ဘူဂစ်စ်" },
            { "byn", "ဘလင်" },
            { "cay", "ကာယုဂါ" },
            { "ccp", "ချတ်ခ်မာ" },
            { "ceb", "စီဗူအာနို" },
            { "cgg", "ချီဂါ" },
            { "chk", "ချူကီးစ်" },
            { "chm", "မာရီ" },
            { "cho", "ချော့တို" },
            { "chp", "ချီပွေဝိုင်ရန်" },
            { "chr", "ချာရိုကီ" },
            { "chy", "ချေယန်း" },
            { "ckb", "ဗဟိုဒေသသုံး ကဒ်ဘာသာ" },
            { "clc", "ချီကိုလ်တင်" },
            { "crg", "မစ်ချစ်ခ်" },
            { "crj", "တောင်ပိုင်း အရှေ့ခရီ" },
            { "crk", "ပလိန်းစ် ခရီ" },
            { "crl", "မြောက်ပိုင်း အရှေ့ခရီ" },
            { "crm", "မုစ်ခရီး" },
            { "crr", "ကယ်ရိုလိုင်းနား အယ်လ်ဂွန်းကီယန်" },
            { "crs", "ခရီအိုလီ" },
            { "csw", "ဆွမ်ပီ ခရီ" },
            { "dak", "ဒါကိုတာ" },
            { "dar", "ဒါဂ်ဝါ" },
            { "dav", "တိုင်တာ" },
            { "del", "ဒယ်လာဝဲလ်" },
            { "dgr", "ဒေါ့ဂ်ရစ်ဘ်" },
            { "dje", "ဇာမာ" },
            { "doi", "ဒိုဂရီ" },
            { "dsb", "အနိမ့် ဆိုဘီယန်း" },
            { "dua", "ဒူအလာ" },
            { "dum", "အလယ်ပိုင်း ဒတ်ချ်" },
            { "dyo", "ဂျိုလာ-ဖွန်ရီ" },
            { "dzg", "ဒဇာဂါ" },
            { "ebu", "အမ်ဘူ" },
            { "efi", "အာဖိခ်" },
            { "egy", "ရှေးဟောင်း အီဂျစ်" },
            { "eka", "အီကာဂျုခ်" },
            { "enm", "အလယ်ပိုင်း အင်္ဂလိပ်" },
            { "ewo", "အီဝန်ဒို" },
            { "fil", metaValue_PH },
            { "fon", "ဖော်န်" },
            { "frc", "ကေဂျန် ဖရန့်စ်" },
            { "frm", "အလယ်ပိုင်း ပြင်သစ်" },
            { "fro", "ဖရန်စီစ်" },
            { "frr", "မြောက် ဖရီစီရန်" },
            { "frs", "အရှေ့ ဖရီစီရန်" },
            { "fur", "ဖရူလီယန်း" },
            { "gaa", "ဂါ" },
            { "gag", "ဂါဂုဇ်" },
            { "gez", "ဂီးဇ်" },
            { "gil", "ကာရီဗာတီ" },
            { "gmh", "အလယ်ပိုင်း အမြင့် ဂျာမန်" },
            { "gor", "ဂိုရိုတာလို" },
            { "grc", "ရှေးဟောင်း ဂရိ" },
            { "gsw", "ဆွစ် ဂျာမန်" },
            { "guz", "ဂူစီး" },
            { "gwi", "ဂွစ်ချင်" },
            { "hai", "ဟေဒါ" },
            { "haw", "ဟာဝိုင်ယီ" },
            { "hax", "တောင် ဟိုင်ဒါ" },
            { "hil", "ဟီလီဂေနွန်" },
            { "hmn", "မုံ" },
            { "hsb", "ဆက္ကဆိုနီ" },
            { "hup", "ဟူပါ" },
            { "hur", "ဟော့ကမိုလွမ်" },
            { "iba", "အီဗန်" },
            { "ibb", "အီဘီဘီယို" },
            { "ikt", "အနောက် ကနေဒီယန် အီနုတီတွတ်" },
            { "ilo", "အီလိုကို" },
            { "inh", "အင်ဂုရှ်" },
            { "jbo", "လိုဂျ်ဘန်" },
            { "jgo", "ဂွမ်ဘာ" },
            { "jmc", "မချာမီ" },
            { "jpr", "ဂျူဒီယို-ပါရှန်" },
            { "jrb", "ဂျူဒီယို-အာရဗီ" },
            { "kab", "ကဘိုင်လ်" },
            { "kac", "ကချင်" },
            { "kaj", "ဂျူအူ" },
            { "kam", "ကမ်ဘာ" },
            { "kbd", "ကဘာဒင်" },
            { "kcg", "တိုင်အပ်" },
            { "kde", "မာခွန်ဒီ" },
            { "kea", "ကဘူဗာဒီအာနူ" },
            { "kfo", "ကိုရို" },
            { "kgp", "ကိန်းဂန်" },
            { "kha", "ခါစီ" },
            { "khq", "ကိုရာ ချီအီနီ" },
            { "kkj", "ကကို" },
            { "kln", "ကလန်ဂျင်" },
            { "kmb", "ကင်ဘွန်ဒူ" },
            { "koi", "ကိုမီ-ပါမြက်" },
            { "kok", "ကွန်ကနီ" },
            { "kpe", "ကပ်ပဲလ်" },
            { "krc", "ကရာချေး-ဘာကာ" },
            { "krl", "ကာရီလီယန်" },
            { "kru", "ကူရုပ်ခ်" },
            { "ksb", "ရှန်ဘာလာ" },
            { "ksf", "ဘာဖီအာ" },
            { "ksh", "ကိုလိုနီယန်း" },
            { "kum", "ကွမ်မိုက်" },
            { "kwk", "ကွပ်ခ်ဝါလာ" },
            { "kxv", "ကူဗီ" },
            { "lad", "လာဒီနို" },
            { "lag", "လန်ဂီ" },
            { "lez", "လက်ဇ်ဂီးယား" },
            { "lij", "လက်ဂါးရီရန်" },
            { "lil", "လာလူးဝစ်တ်" },
            { "lkt", "လာကိုတာ" },
            { "lmo", "လန်းဘတ်" },
            { "lou", "လူဝီဇီယားနား ခရီးယို" },
            { "loz", "လိုဇီ" },
            { "lrc", "မြောက်လူရီ" },
            { "lsm", "ဆာမိအာ" },
            { "lua", "လူဘာ-လူလူအာ" },
            { "lun", "လွန်ဒါ" },
            { "luo", "လူအို" },
            { "lus", "မီဇို" },
            { "luy", "လူရီအာ" },
            { "mad", "မဒူရာ" },
            { "mag", "မဂါဟီ" },
            { "mai", "မိုင်သီလီ" },
            { "mak", "မကာဆာ" },
            { "mas", "မာဆိုင်" },
            { "mdf", "မို့ခ်ရှာ" },
            { "men", "မန်ဒဲ" },
            { "mer", "မီရု" },
            { "mfe", metaValue_MU },
            { "mga", "အလယ်ပိုင်း အိုင်းရစ်ရှ်" },
            { "mgh", "မာခူဝါ-မီအီတို" },
            { "mgo", "မီတာ" },
            { "mic", "မစ်ခ်မက်ခ်" },
            { "min", "စူကူမီနန်" },
            { "mnc", "မန်ချူး" },
            { "mni", "မနိပူရ" },
            { "moe", "အီနုအေမွန်" },
            { "moh", "မိုဟော့ခ်" },
            { "mos", "မိုစီ" },
            { "mua", "မွန်ဒန်း" },
            { "mul", "ဘာသာစကား အမျိုးမျိုး" },
            { "mus", "ခရိချ" },
            { "mwl", "မီရန်ဒီးဇ်" },
            { "myv", "အီဇယာ" },
            { "mzn", "မာဇန်ဒါရန်နီ" },
            { "nap", "နပိုလီတန်" },
            { "naq", "နာမာ" },
            { "nds", "အနိမ့် ဂျာမန်" },
            { "new", "နီဝါရီ" },
            { "nia", "နီးရပ်စ်" },
            { "niu", "နူအဲယန်း" },
            { "nmg", "ကွာစီအို" },
            { "nnh", "အွန်ရဲဘွန်း" },
            { "nog", "နိုဂိုင်" },
            { "nqo", metaValue_nqo },
            { "nso", "မြောက် ဆိုသို" },
            { "nus", "နူအာ" },
            { "nyn", "နရန်ကိုလီ" },
            { "ojb", "အိုဂျစ်ဘွာ" },
            { "ojc", "အိုဂျစ်ဘွေး" },
            { "ojs", "အိုဂျီခရီ" },
            { "ojw", "အနောက် အိုဂျီဘွာ" },
            { "oka", "အိုကနဂန်" },
            { "pag", "ပန်ဂါစီနန်" },
            { "pam", "ပမ်ပန်ညာ" },
            { "pap", "ပါပီမင်တို" },
            { "pau", metaValue_PW },
            { "pcm", "နိုင်ဂျီးရီးယား ပစ်ဂျင်" },
            { "peo", metaValue_peo },
            { "pis", "ပီဂျင်" },
            { "pqm", "မလိဇိ ပါစမ်မကွာဒီ" },
            { "prg", "ပရူရှန်" },
            { "quc", "ကီခ်အီချီ" },
            { "raj", "ရာဂျာစတာနီ" },
            { "rap", "ရပန်နူအီ" },
            { "rar", "ရရိုတွန်ဂန်" },
            { "rhg", "ရိုဟင်ဂျာ" },
            { "rof", "ရွမ်ဘို" },
            { "rup", "အာရိုမန်းနီးယန်း" },
            { "rwk", "ရူဝမ်" },
            { "sad", "ဆန်ဒါဝီ" },
            { "sah", "ဆခါ" },
            { "saq", "ဆမ်ဘူရူ" },
            { "sat", "ဆန်တာလီ" },
            { "sba", "အွန်ဂမ်းဘေး" },
            { "sbp", "ဆန်ဂု" },
            { "scn", "စစ္စလီ" },
            { "sco", "စကော့တ်" },
            { "seh", "စီနာ" },
            { "ses", "ကိုရာဘိုရို ဆမ်နီ" },
            { "sga", "အိုင်းရစ် ဟောင်း" },
            { "shi", "တာချယ်လ်ဟစ်" },
            { "shn", "ရှမ်း" },
            { "slh", "တောင် လာ့ရှုစတိ" },
            { "sma", "တောင် ဆာမိ" },
            { "smj", "လူလီ ဆာမိ" },
            { "smn", "အီနာရီ ဆာမိ" },
            { "sms", "စခိုးလ် ဆာမိ" },
            { "snk", "ဆိုနင်ကေး" },
            { "srn", "ဆရာနန် တွန်ဂို" },
            { "ssy", "ဆာဟို" },
            { "str", "ဆဲလစ်ရှ် ရေလက်ကြား" },
            { "suk", "ဆူကူမာ" },
            { "swb", "ကိုမိုရီးယန်း" },
            { "syr", metaValue_SY },
            { "szl", "စလီရှန်" },
            { "tce", "တောင် တပ်ချွန်" },
            { "tem", "တင်မ်နဲ" },
            { "teo", "တီဆို" },
            { "tet", "တီတွမ်" },
            { "tgx", "တာဂစ်ရှ်" },
            { "tht", "တဟီတန်" },
            { "tig", "တီဂရီ" },
            { "tlh", "ကလင်ဂွန်" },
            { "tli", "တလင်းဂစ်" },
            { "tok", "တိုကီပိုနာ" },
            { "tpi", "တော့ခ် ပိစင်" },
            { "trv", "တရိုကို" },
            { "ttm", "မြောက် တပ်ချွန်" },
            { "tum", "တမ်ဘူကာ" },
            { "tvl", "တူဗာလူ" },
            { "twq", "တာဆာဝါချ" },
            { "tyv", "တူဗန်" },
            { "tzm", "အလယ်အာ့တလာစ် တာမာဇိုက်" },
            { "udm", "အူမူရတ်" },
            { "umb", "အူဘန်ဒူ" },
            { "und", "မသိသော ဘာသာ" },
            { "vai", "ဗိုင်" },
            { "vec", "ဗနီးရှန်" },
            { "vmw", "မတ်ကူးဝါး" },
            { "vun", "ဗွန်ဂျို" },
            { "wae", "ဝေါလ်ဆာ" },
            { "wal", "ဝိုလက်တာ" },
            { "war", "ဝါရေး" },
            { "wbp", "ဝေါလ်ပီရီ" },
            { "wuu", "ဝူ တရုတ်" },
            { "xal", "ကာလ်မိုက်" },
            { "xnr", "ခန်းဂရီ" },
            { "xog", "ဆိုဂါ" },
            { "yav", "ရန်ဘဲန်" },
            { "ybb", "ရမ်ဘာ" },
            { "yrl", "အန်ဟင်းဂတူ" },
            { "yue", "ကွမ်းတုံ" },
            { "zgh", "မိုရိုကို တမဇိုက်" },
            { "zun", "ဇူနီ" },
            { "zxx", "ဘာသာစကားနှင့် ပတ်သက်သောအရာ မရှိပါ" },
            { "zza", "ဇာဇာ" },
            { "Adlm", "အက်ဒ်လမ်" },
            { "Arab", "အာရေဗျ" },
            { "Aran", "နက်စ်တာလိခ်" },
            { "Armn", metaValue_AM },
            { "Beng", metaValue_bn },
            { "Bopo", "ဘိုပို" },
            { "Brah", "ဗွဟ်မမီ" },
            { "Brai", "ဘရေ" },
            { "Cakm", "ချပ်ခ်မာ" },
            { "Cans", "ကင်န်စ်" },
            { "Cher", "ချာရိုကီး" },
            { "Cyrl", "စစ်ရိလစ်" },
            { "Deva", "ဒီဗနာဂရီ" },
            { "Ethi", metaValue_ET },
            { "Geor", metaValue_GE },
            { "Grek", metaValue_GR },
            { "Gujr", "ဂုဂျာရသီ" },
            { "Guru", "ဂူရူ" },
            { "Hanb", "ဟန်ဘ်" },
            { "Hang", "ဟန်ဂူးလ်" },
            { "Hani", "ဟန်" },
            { "Hans", "ရိုးရှင်း" },
            { "Hant", "ရိုးရာ" },
            { "Hebr", "ဟီဗရူး" },
            { "Hira", "ဟီရဂန" },
            { "Hrkt", "ဂျပန် အက္ခရာ" },
            { "Jamo", "ဂျမို" },
            { "Java", "ဂျာဗားနီးစ်" },
            { "Jpan", metaValue_JP },
            { "Kali", "ကယားလီ" },
            { "Kana", "ခတခန" },
            { "Khmr", metaValue_km },
            { "Knda", "ခန်နာဒါ" },
            { "Kore", metaValue_ko },
            { "Laoo", metaValue_LA },
            { "Latn", metaValue_la },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Mtei", "မေတဲမာယက်" },
            { "Mymr", metaValue_MM },
            { "Nkoo", metaValue_nqo },
            { "Olck", "အိုလ်ချီကီ" },
            { "Orya", "အိုရာ" },
            { "Rohg", "ဟာနီဖီ" },
            { "Sinh", "ဆင်ဟာလ" },
            { "Sund", metaValue_SD },
            { "Syrc", "ဆီရီရက်ခ်" },
            { "Tale", "တိုင်လီ" },
            { "Taml", metaValue_ta },
            { "Telu", "တယ်လူဂူ" },
            { "Tfng", "တီဖီနော" },
            { "Tglg", "တဂလော့ဂ်" },
            { "Thaa", "သာအ်" },
            { "Thai", metaValue_TH },
            { "Tibt", metaValue_bo },
            { "Vaii", "ဗိုင်း" },
            { "Visp", "မြင်နိုင်သော စကား" },
            { "Xpeo", metaValue_peo },
            { "Yiii", "ရီ" },
            { "Zmth", "ဂဏန်းသင်္ချာ" },
            { "Zsye", "အီမိုဂျီ" },
            { "Zsym", "သင်္ကေတ" },
            { "Zxxx", "ထုံးတမ်းသဖွယ်လိုက်နာလျက်ရှိသော" },
            { "Zyyy", "အများနှင့်သက်ဆိုင်သော" },
            { "Zzzz", "မသိ သို့မဟုတ် မရှိသော စကားလုံး" },
            { "de_AT", "ဩစတြီးယား ဂျာမန်" },
            { "de_CH", "အလီမဲန်နစ် ဂျာမန်" },
            { "en_AU", "ဩစတြေးလျ အင်္ဂလိပ်" },
            { "en_CA", "ကနေဒါ အင်္ဂလိပ်" },
            { "en_GB", "ဗြိတိသျှ အင်္ဂလိပ်" },
            { "en_US", "အမေရိကန် အင်္ဂလိပ်" },
            { "es_ES", "စပိန် (ဥရောပ)" },
            { "es_MX", "စပိန် (မက္ကဆီကို)" },
            { "fa_AF", "ဒါရီ" },
            { "fr_CA", "ကနေဒါ ပြင်သစ်" },
            { "fr_CH", "ဆွစ် ပြင်သစ်" },
            { "nl_BE", "ဖလီမစ်ရှ်" },
            { "pt_BR", "ဘရာဇီး ပေါ်တူဂီ" },
            { "pt_PT", "ဥရောပ ပေါ်တူဂီ" },
            { "ro_MD", "မော်လဒိုဗာ" },
            { "sw_CD", "ကွန်ဂို ဆွာဟီလီ" },
            { "%%1901", "ရှေးရိုးစဉ်လာ ဂျာမန် ရေးထုံး" },
            { "%%1996", "၁၉၉၆ ဂျာမန် ရေးထုံး" },
            { "ar_001", "ခေတ်သစ် ရှေ့ဆောင် အာရဗီ" },
            { "key.ca", "ပြက္ခဒိန်" },
            { "key.cf", "ငွေရေတွက်ပုံစနစ်" },
            { "key.co", "အစဉ်လိုက်စီရန်" },
            { "key.cu", "ငွေကြေး" },
            { "key.em", "အီမိုဂျီဖော်ပြချက်" },
            { "key.hc", "နာရီစက်ဝန်း (၁၂ နှင့် ၂၄)" },
            { "key.lb", "စာပိုဒ်ခွဲပုံစံ" },
            { "key.lw", "စာပုဒ်ခြား" },
            { "key.ms", "တိုင်းတာရေးစနစ်" },
            { "key.nu", "ကိန်းဂဏန်း" },
            { "key.ss", "စာလုံးခြား" },
            { "nds_NL", "ဂျာမန် (နယ်သာလန်)" },
            { "%%POSIX", "ကွန်ပျူတာ" },
            { "%%FONIPA", "IPA အသံထွက်" },
            { "%%FONUPA", "UPA အသံထွက်" },
            { "%%AREVELA", "အရှေ့ပိုင်းအာမေးနီးယန်း" },
            { "%%REVISED", "ပြန်လည်စီစစ်ထားသော ရေးထုံး" },
            { "%%1606NICT", "အလယ်ပိုင်းနောက်ကျသောပြင်သစ်မှ ၁၆၀၆" },
            { "%%1694ACAD", "၁၆၉၄ACAD" },
            { "%%BAKU1926", "ပေါင်းစပ်ထားသော တူရကီ လက်တင်စကားလုံး" },
            { "%%SCOTLAND", "စကော့ စံ အင်္ဂလိပ်" },
            { "type.ca.roc", "မင်ဂုအို ပြက္ခဒိန်" },
            { "type.hc.h11", "၁၂ နာရီ စနစ် (၀–၁၁)" },
            { "type.hc.h12", "၁၂ နာရီစနစ် (၁–၁၂)" },
            { "type.hc.h23", "၂၄ နာရီ စနစ် (၀–၂၃)" },
            { "type.hc.h24", "၂၄ နာရီ စနစ်(၁–၂၄)" },
            { "type.nu.arab", "အာရပ် ဂဏန်းခြေ" },
            { "type.nu.armn", "အာမေးနီးယား ဂဏန်းခြေ" },
            { "type.nu.beng", "ဘင်္ဂါလီ ဂဏန်းခြေ" },
            { "type.nu.cakm", "ချာ့ခ်မာ ဂဏန်းခြေ" },
            { "type.nu.deva", "ဒီဗာနာဂရီ ဂဏန်းခြေ" },
            { "type.nu.ethi", "အီသီယိုပီးယား ဂဏန်းခြေ" },
            { "type.nu.geor", "နိုင်ငံတကာသုံးဂဏန်းခြေ" },
            { "type.nu.grek", "ဂရိ ဂဏန်းခြေ" },
            { "type.nu.gujr", "ဂုဂျာရတီ ဂဏန်းခြေ" },
            { "type.nu.guru", "ဂူမူခီ ဂဏန်းခြေ" },
            { "type.nu.hans", "ရိုးရှင်း တရုတ် ဂဏန်းခြေ" },
            { "type.nu.hant", "ရိုးရာ တရုတ် ဂဏန်းခြေ" },
            { "type.nu.hebr", "ဟီဘရူး ဂဏန်းခြေ" },
            { "type.nu.java", "ဂျာဗား ဂဏန်းခြေ" },
            { "type.nu.jpan", "ဂျပန် ဂဏန်းခြေ" },
            { "type.nu.khmr", "ခမာ ဂဏန်းခြေ" },
            { "type.nu.knda", "ခန္နဒါ ဂဏန်းခြေ" },
            { "type.nu.laoo", "လာအို ဂဏန်းခြေ" },
            { "type.nu.latn", "အနောက်တိုင်း ဂဏန်းခြေ" },
            { "type.nu.mlym", "မလေယာလမ် ဂဏန်းခြေ" },
            { "type.nu.mtei", "မီတဲမာယစ်ခ် ဂဏန်းခြေ" },
            { "type.nu.mymr", "မြန်မာ ဂဏန်းခြေ" },
            { "type.nu.olck", "အိုလ်ချီကီ ဂဏန်းခြေ" },
            { "type.nu.orya", "ဩရီရာ ဂဏန်းခြေ" },
            { "type.nu.taml", "ရိုးရာ တမီးလ် ဂဏန်းခြေ" },
            { "type.nu.telu", "တလုဂု ဂဏန်းခြေ" },
            { "type.nu.thai", "ထိုင်း ဂဏန်းခြေ" },
            { "type.nu.tibt", "တိဘက် ဂဏန်းခြေ" },
            { "type.nu.vaii", "ဗိုင်း ဂဏန်းခြေ" },
            { "type.ca.dangi", "ဒန်းဂိ ပြက္ခဒိန်" },
            { "type.co.ducet", "အစဉ်လိုက်စီထားသော ယူနီကုတ်" },
            { "type.lb.loose", "ကန့်သတ်မထားသော စာပိုဒ်ခွဲပုံစံ" },
            { "type.nu.roman", "ရောမ ဂဏန်းခြေ" },
            { "type.ca.coptic", "ကို့ပ်တစ် ပြက္ခဒိန်" },
            { "type.ca.hebrew", "ဟီဘရူး ပြက္ခဒိန်" },
            { "type.ca.indian", "အိန္ဒြိယ အမျိုးသား ပြက္ခဒိန်" },
            { "type.co.search", "ယေဘုယျရှာခြင်း" },
            { "type.lb.normal", "ပုံမှန်စာပိုဒ်ခွဲပုံစံ" },
            { "type.lb.strict", "ကန့်သတ်ထားသော စာပိုဒ်ခွဲပုံစံ" },
            { "type.ms.metric", "မက်ထရစ်စနစ်" },
            { "type.ca.chinese", "တရုတ် ပြက္ခဒိန်" },
            { "type.ca.islamic", "အစ္စလာမ် ပြက္ခဒိန်" },
            { "type.ca.iso8601", "ISO-8601 ပြက္ခဒိန်" },
            { "type.ca.persian", "ပါရှား ပြက္ခဒိန်" },
            { "type.cf.account", "စာရင်းကိုင်သုံး ငွေရေတွက်ပုံစနစ်" },
            { "type.nu.arabext", "တိုးချဲ့အာရပ် ဂဏန်းခြေ" },
            { "type.nu.armnlow", "အာမေးနီးယား ဂဏန်းခြေ စာလုံးသေး" },
            { "type.nu.greklow", "ဂရိ ဂဏန်းခြေ စာလုံးသေး" },
            { "type.nu.hanidec", "တရုတ် ဆယ်လီစနစ် ဂဏန်းခြေ" },
            { "type.nu.hansfin", "ရိုးရှင်း တရုတ် ဘဏ္ဍာရေးသုံး ဂဏန်းခြေ" },
            { "type.nu.hantfin", "ရိုးရာ တရုတ် ဘဏ္ဍာရေးသုံး ဂဏန်းခြေ" },
            { "type.nu.jpanfin", "ဂျပန် ဘဏ္ဍာရေးသုံး ဂဏန်းခြေ" },
            { "type.nu.tamldec", "တမီးလ် ဂဏန်းခြေ" },
            { "type.ca.buddhist", "ဗုဒ္ဓ ပြက္ခဒိန်" },
            { "type.ca.ethiopic", "အီသီယိုးပီးယား ပြက္ခဒိန်" },
            { "type.ca.japanese", "ဂျပန် ပြက္ခဒိန်" },
            { "type.cf.standard", "ပုံမှန် ငွေရေတွက်ပုံစနစ်" },
            { "type.co.standard", "ပုံမှန်စီထားသော" },
            { "type.ms.uksystem", "ဗြိတိသျှတိုင်းတာစနစ်" },
            { "type.ms.ussystem", "အမေရိကန်တိုင်းတာစနစ်" },
            { "type.nu.fullwide", "ဗြက်ပြည့် ဂဏန်းခြေ" },
            { "type.nu.mymrshan", "ရှမ်း ဂဏန်းခြေ" },
            { "type.nu.romanlow", "ရောမ ဂဏန်းခြေ စာလုံးသေး" },
            { "type.ca.gregorian", "နိုင်ငံတကာသုံး ပြက္ခဒိန်" },
            { "type.co.phonebook", "ဖုန်းစာအုပ် အစီအစဉ်" },
            { "ListKeyTypePattern", "{0}- {1}" },
            { "type.ca.islamic-civil", "အစ္စလာမ်မစ် ပြက္ခဒိန်" },
            { "ListCompositionPattern", "{0}/ {1}" },
            { "type.ca.islamic-umalqura", "အယ်လ်ကူရာ အစ္စလာမ်မစ် ပြက္ခဒိန်" },
            { "type.ca.ethiopic-amete-alem", "အီသီယိုပစ်ခ် အာမဲတဲ အာလင်မ် ပြက္ခဒိန်" },
        };
        return data;
    }
}
