/* CPU feature detection for AArch64 architecture.
   Copyright (C) 2023-2025 Free Software Foundation, Inc.

   This file is part of GCC.

   This file is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 3, or (at your option) any
   later version.

   This file is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   Under Section 7 of GPL version 3, you are granted additional
   permissions described in the GCC Runtime Library Exception, version
   3.1, as published by the Free Software Foundation.

   You should have received a copy of the GNU General Public License and
   a copy of the GCC Runtime Library Exception along with this program;
   see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
   <http://www.gnu.org/licenses/>.  */

/* This enum is used in libgcc feature detection, and in the function
   multiversioning implementation in aarch64.cc.  The enum should use the same
   values as the corresponding enum in LLVM's compiler-rt, to faciliate
   compatibility between compilers.  */

enum CPUFeatures {
  FEAT_RNG,
  FEAT_FLAGM,
  FEAT_FLAGM2,
  FEAT_FP16FML,
  FEAT_DOTPROD,
  FEAT_SM4,
  FEAT_RDM,
  FEAT_LSE,
  FEAT_FP,
  FEAT_SIMD,
  FEAT_CRC,
  FEAT_CSSC,
  FEAT_SHA2,
  FEAT_SHA3,
  FEAT_unused5,
  FEAT_PMULL,
  FEAT_FP16,
  FEAT_DIT,
  FEAT_DPB,
  FEAT_DPB2,
  FEAT_JSCVT,
  FEAT_FCMA,
  FEAT_RCPC,
  FEAT_RCPC2,
  FEAT_FRINTTS,
  FEAT_unused6,
  FEAT_I8MM,
  FEAT_BF16,
  FEAT_unused7,
  FEAT_unused8,
  FEAT_SVE,
  FEAT_unused9,
  FEAT_unused10,
  FEAT_unused11,
  FEAT_SVE_F32MM,
  FEAT_SVE_F64MM,
  FEAT_SVE2,
  FEAT_unused12,
  FEAT_SVE_PMULL128,
  FEAT_SVE_BITPERM,
  FEAT_SVE_SHA3,
  FEAT_SVE_SM4,
  FEAT_SME,
  FEAT_unused13,
  FEAT_MEMTAG2,
  FEAT_unused14,
  FEAT_SB,
  FEAT_unused1,
  FEAT_unused15,
  FEAT_SSBS2,
  FEAT_BTI,
  FEAT_unused2,
  FEAT_unused3,
  FEAT_unused4,
  FEAT_WFXT,
  FEAT_SME_F64,
  FEAT_SME_I64,
  FEAT_SME2,
  FEAT_RCPC3,
  FEAT_MOPS,
  FEAT_MAX,
  FEAT_EXT = 62, /* Reserved to indicate presence of additional features field
		    in __aarch64_cpu_features.  */
  FEAT_INIT      /* Used as flag of features initialization completion.  */
};
