// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Represents the request parameters for configuring minimum throughput billing commitment.</p><note>
/// <ul>
/// <li>
/// <p>Minimum throughput billing commitments provide cost savings on on-demand data streams in exchange for committing to a minimum level of throughput usage.</p></li>
/// <li>
/// <p>Commitments have a minimum duration of 24 hours that must be honored before they can be disabled.</p></li>
/// <li>
/// <p>If you attempt to disable a commitment before the minimum commitment period ends, the commitment will be scheduled for automatic disable at the earliest allowed end time.</p></li>
/// <li>
/// <p>You can cancel a pending disable by enabling the commitment again before the earliest allowed end time.</p></li>
/// </ul>
/// </note>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct MinimumThroughputBillingCommitmentInput {
    /// <p>The desired status of the minimum throughput billing commitment.</p>
    pub status: crate::types::MinimumThroughputBillingCommitmentInputStatus,
}
impl MinimumThroughputBillingCommitmentInput {
    /// <p>The desired status of the minimum throughput billing commitment.</p>
    pub fn status(&self) -> &crate::types::MinimumThroughputBillingCommitmentInputStatus {
        &self.status
    }
}
impl MinimumThroughputBillingCommitmentInput {
    /// Creates a new builder-style object to manufacture [`MinimumThroughputBillingCommitmentInput`](crate::types::MinimumThroughputBillingCommitmentInput).
    pub fn builder() -> crate::types::builders::MinimumThroughputBillingCommitmentInputBuilder {
        crate::types::builders::MinimumThroughputBillingCommitmentInputBuilder::default()
    }
}

/// A builder for [`MinimumThroughputBillingCommitmentInput`](crate::types::MinimumThroughputBillingCommitmentInput).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct MinimumThroughputBillingCommitmentInputBuilder {
    pub(crate) status: ::std::option::Option<crate::types::MinimumThroughputBillingCommitmentInputStatus>,
}
impl MinimumThroughputBillingCommitmentInputBuilder {
    /// <p>The desired status of the minimum throughput billing commitment.</p>
    /// This field is required.
    pub fn status(mut self, input: crate::types::MinimumThroughputBillingCommitmentInputStatus) -> Self {
        self.status = ::std::option::Option::Some(input);
        self
    }
    /// <p>The desired status of the minimum throughput billing commitment.</p>
    pub fn set_status(mut self, input: ::std::option::Option<crate::types::MinimumThroughputBillingCommitmentInputStatus>) -> Self {
        self.status = input;
        self
    }
    /// <p>The desired status of the minimum throughput billing commitment.</p>
    pub fn get_status(&self) -> &::std::option::Option<crate::types::MinimumThroughputBillingCommitmentInputStatus> {
        &self.status
    }
    /// Consumes the builder and constructs a [`MinimumThroughputBillingCommitmentInput`](crate::types::MinimumThroughputBillingCommitmentInput).
    /// This method will fail if any of the following fields are not set:
    /// - [`status`](crate::types::builders::MinimumThroughputBillingCommitmentInputBuilder::status)
    pub fn build(
        self,
    ) -> ::std::result::Result<crate::types::MinimumThroughputBillingCommitmentInput, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::MinimumThroughputBillingCommitmentInput {
            status: self.status.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "status",
                    "status was not specified but it is required when building MinimumThroughputBillingCommitmentInput",
                )
            })?,
        })
    }
}
