// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Represents the warm throughput configuration on the stream. This is only present for On-Demand Kinesis Data Streams in accounts that have <code>MinimumThroughputBillingCommitment</code> enabled.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct WarmThroughputObject {
    /// <p>The target warm throughput value on the stream. This indicates that the stream is currently scaling towards this target value.</p>
    pub target_mibps: ::std::option::Option<i32>,
    /// <p>The current warm throughput value on the stream. This is the write throughput in MiBps that the stream is currently scaled to handle.</p>
    pub current_mibps: ::std::option::Option<i32>,
}
impl WarmThroughputObject {
    /// <p>The target warm throughput value on the stream. This indicates that the stream is currently scaling towards this target value.</p>
    pub fn target_mibps(&self) -> ::std::option::Option<i32> {
        self.target_mibps
    }
    /// <p>The current warm throughput value on the stream. This is the write throughput in MiBps that the stream is currently scaled to handle.</p>
    pub fn current_mibps(&self) -> ::std::option::Option<i32> {
        self.current_mibps
    }
}
impl WarmThroughputObject {
    /// Creates a new builder-style object to manufacture [`WarmThroughputObject`](crate::types::WarmThroughputObject).
    pub fn builder() -> crate::types::builders::WarmThroughputObjectBuilder {
        crate::types::builders::WarmThroughputObjectBuilder::default()
    }
}

/// A builder for [`WarmThroughputObject`](crate::types::WarmThroughputObject).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct WarmThroughputObjectBuilder {
    pub(crate) target_mibps: ::std::option::Option<i32>,
    pub(crate) current_mibps: ::std::option::Option<i32>,
}
impl WarmThroughputObjectBuilder {
    /// <p>The target warm throughput value on the stream. This indicates that the stream is currently scaling towards this target value.</p>
    pub fn target_mibps(mut self, input: i32) -> Self {
        self.target_mibps = ::std::option::Option::Some(input);
        self
    }
    /// <p>The target warm throughput value on the stream. This indicates that the stream is currently scaling towards this target value.</p>
    pub fn set_target_mibps(mut self, input: ::std::option::Option<i32>) -> Self {
        self.target_mibps = input;
        self
    }
    /// <p>The target warm throughput value on the stream. This indicates that the stream is currently scaling towards this target value.</p>
    pub fn get_target_mibps(&self) -> &::std::option::Option<i32> {
        &self.target_mibps
    }
    /// <p>The current warm throughput value on the stream. This is the write throughput in MiBps that the stream is currently scaled to handle.</p>
    pub fn current_mibps(mut self, input: i32) -> Self {
        self.current_mibps = ::std::option::Option::Some(input);
        self
    }
    /// <p>The current warm throughput value on the stream. This is the write throughput in MiBps that the stream is currently scaled to handle.</p>
    pub fn set_current_mibps(mut self, input: ::std::option::Option<i32>) -> Self {
        self.current_mibps = input;
        self
    }
    /// <p>The current warm throughput value on the stream. This is the write throughput in MiBps that the stream is currently scaled to handle.</p>
    pub fn get_current_mibps(&self) -> &::std::option::Option<i32> {
        &self.current_mibps
    }
    /// Consumes the builder and constructs a [`WarmThroughputObject`](crate::types::WarmThroughputObject).
    pub fn build(self) -> crate::types::WarmThroughputObject {
        crate::types::WarmThroughputObject {
            target_mibps: self.target_mibps,
            current_mibps: self.current_mibps,
        }
    }
}
