/*
 * Decompiled with CFR 0.152.
 */
package com.anthropic.code.plugin.services;

import com.anthropic.code.plugin.UtilsKt;
import com.anthropic.code.plugin.services.LockFileJsonContent;
import com.anthropic.code.plugin.settings.PluginSettings;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.net.ServerSocket;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/anthropic/code/plugin/services/LockFileUtil;", "", "<init>", "()V", "secureRandom", "Ljava/security/SecureRandom;", "generateAuthToken", "", "findAvailablePort", "", "createLockFile", "Lcom/anthropic/code/plugin/services/LockFileJsonContent;", "port", "project", "Lcom/intellij/openapi/project/Project;", "expandPath", "path", "ensureLockFileDirectory", "Ljava/io/File;", "deleteLockFile", "", "claude-code-jetbrains-plugin"})
@SourceDebugExtension(value={"SMAP\nLockFileUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LockFileUtil.kt\ncom/anthropic/code/plugin/services/LockFileUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,127:1\n1#2:128\n205#3:129\n*S KotlinDebug\n*F\n+ 1 LockFileUtil.kt\ncom/anthropic/code/plugin/services/LockFileUtil\n*L\n74#1:129\n*E\n"})
public final class LockFileUtil {
    @NotNull
    public static final LockFileUtil INSTANCE = new LockFileUtil();
    @NotNull
    private static final SecureRandom secureRandom = new SecureRandom();

    private LockFileUtil() {
    }

    private final String generateAuthToken() {
        byte[] bytes = new byte[64];
        secureRandom.nextBytes(bytes);
        String string = Base64.getUrlEncoder().withoutPadding().encodeToString(bytes);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(...)");
        return string;
    }

    public final int findAvailablePort() {
        ServerSocket socket = new ServerSocket(0);
        int port = socket.getLocalPort();
        socket.close();
        return port;
    }

    @Nullable
    public final LockFileJsonContent createLockFile(int port, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        File lockFileDir = this.ensureLockFileDirectory();
        File lockFile = new File(lockFileDir, port + ".lock");
        Set workspaceFolders = new LinkedHashSet();
        String string = project.getBasePath();
        if (string != null) {
            String it = string;
            int n = 0;
            workspaceFolders.add(UtilsKt.convertFromOSFilePath(it));
        }
        ModuleManager moduleManager = ModuleManager.Companion.getInstance(project);
        for (Module module : moduleManager.getModules()) {
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            for (VirtualFile contentRoot : moduleRootManager.getContentRoots()) {
                String path;
                Intrinsics.checkNotNullExpressionValue((Object)contentRoot.getPath(), (String)"getPath(...)");
                String projectPath = project.getBasePath();
                if (projectPath != null && StringsKt.startsWith$default((String)path, (String)projectPath, (boolean)false, (int)2, null)) continue;
                workspaceFolders.add(UtilsKt.convertFromOSFilePath(path));
            }
        }
        if (!((Collection)workspaceFolders).isEmpty()) {
            LockFileJsonContent contents = new LockFileJsonContent(CollectionsKt.toList((Iterable)workspaceFolders), ProcessHandle.current().pid(), ApplicationInfo.getInstance().getVersionName(), "ws", SystemInfo.isWindows, this.generateAuthToken());
            Json this_$iv = (Json)Json.Default;
            boolean $i$f$encodeToString = false;
            this_$iv.getSerializersModule();
            FilesKt.writeText$default((File)lockFile, (String)this_$iv.encodeToString((SerializationStrategy)LockFileJsonContent.Companion.serializer(), (Object)contents), null, (int)2, null);
            return contents;
        }
        return null;
    }

    private final String expandPath(String path) {
        Object object;
        if (StringsKt.isBlank((CharSequence)path)) {
            return path;
        }
        String homeDir = System.getProperty("user.home");
        if (StringsKt.startsWith$default((String)path, (String)"~/", (boolean)false, (int)2, null)) {
            String string = path.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            object = homeDir + string;
        } else if (Intrinsics.areEqual((Object)path, (Object)"~")) {
            Intrinsics.checkNotNull((Object)homeDir);
            object = homeDir;
        } else {
            object = path;
        }
        return object;
    }

    private final File ensureLockFileDirectory() {
        File lockFileDir;
        String string;
        String string2;
        String string3;
        PluginSettings settings = PluginSettings.Companion.getInstance();
        String it = string3 = settings.getClaudeConfigDir();
        boolean bl = false;
        String string4 = !StringsKt.isBlank((CharSequence)it) ? string3 : null;
        if (string4 != null) {
            it = string4;
            boolean bl2 = false;
            string2 = INSTANCE.expandPath(it);
        } else {
            string2 = null;
        }
        String settingsConfigDir = string2;
        String string5 = System.getenv("CLAUDE_CONFIG_DIR");
        if (string5 != null) {
            String it2 = string5;
            boolean bl3 = false;
            string = INSTANCE.expandPath(it2);
        } else {
            string = null;
        }
        String envConfigDir = string;
        if (settingsConfigDir != null) {
            v4 = new File(settingsConfigDir, "ide");
        } else if (envConfigDir != null) {
            v4 = new File(envConfigDir, "ide");
        } else {
            String homeDir = System.getProperty("user.home");
            v4 = lockFileDir = new File(homeDir, ".claude/ide");
        }
        if (!lockFileDir.exists()) {
            lockFileDir.mkdirs();
        }
        return lockFileDir;
    }

    public final void deleteLockFile(int port) {
        File lockFileDir = this.ensureLockFileDirectory();
        File lockFile = new File(lockFileDir, port + ".lock");
        if (lockFile.exists()) {
            try {
                lockFile.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

