/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.engine;

import java.io.IOException;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineExceptionHandler;
import kotlinx.coroutines.CoroutineName;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0010\u0010\u0005\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\u00040\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0015\b\u0016\u0012\n\u0010\u0005\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0004\b\u0006\u0010\bJ\u001f\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0005\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\u00040\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0010R\u0018\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lio/ktor/server/engine/DefaultUncaughtExceptionHandler;", "Lkotlinx/coroutines/CoroutineExceptionHandler;", "Lkotlin/Function0;", "Lorg/slf4j/Logger;", "Lio/ktor/util/logging/Logger;", "logger", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "(Lorg/slf4j/Logger;)V", "Lkotlin/coroutines/CoroutineContext;", "context", "", "exception", "", "handleException", "(Lkotlin/coroutines/CoroutineContext;Ljava/lang/Throwable;)V", "Lkotlin/jvm/functions/Function0;", "Lkotlin/coroutines/CoroutineContext$Key;", "getKey", "()Lkotlin/coroutines/CoroutineContext$Key;", "key", "ktor-server-core"})
public final class DefaultUncaughtExceptionHandler
implements CoroutineExceptionHandler {
    @NotNull
    private final Function0<Logger> logger;

    public DefaultUncaughtExceptionHandler(@NotNull Function0<? extends Logger> logger) {
        Intrinsics.checkNotNullParameter(logger, (String)"logger");
        this.logger = logger;
    }

    public DefaultUncaughtExceptionHandler(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this((Function0<? extends Logger>)((Function0)() -> DefaultUncaughtExceptionHandler._init_$lambda$0(logger)));
    }

    @NotNull
    public CoroutineContext.Key<?> getKey() {
        return (CoroutineContext.Key)CoroutineExceptionHandler.Key;
    }

    public void handleException(@NotNull CoroutineContext context, @NotNull Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        if (exception instanceof CancellationException) {
            return;
        }
        if (exception instanceof IOException) {
            return;
        }
        Object object = (CoroutineName)context.get((CoroutineContext.Key)CoroutineName.Key);
        if (object == null) {
            object = context.toString();
        }
        CoroutineName coroutineName = object;
        ((Logger)this.logger.invoke()).error("Unhandled exception caught for " + coroutineName, exception);
    }

    public <R> R fold(R initial, @NotNull Function2<? super R, ? super CoroutineContext.Element, ? extends R> operation) {
        return (R)CoroutineExceptionHandler.DefaultImpls.fold((CoroutineExceptionHandler)this, initial, operation);
    }

    @Nullable
    public <E extends CoroutineContext.Element> E get(@NotNull CoroutineContext.Key<E> key2) {
        return (E)CoroutineExceptionHandler.DefaultImpls.get((CoroutineExceptionHandler)this, key2);
    }

    @NotNull
    public CoroutineContext minusKey(@NotNull CoroutineContext.Key<?> key2) {
        return CoroutineExceptionHandler.DefaultImpls.minusKey((CoroutineExceptionHandler)this, key2);
    }

    @NotNull
    public CoroutineContext plus(@NotNull CoroutineContext context) {
        return CoroutineExceptionHandler.DefaultImpls.plus((CoroutineExceptionHandler)this, (CoroutineContext)context);
    }

    private static final Logger _init_$lambda$0(Logger $logger) {
        return $logger;
    }
}

