/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.websocket.impl;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.debugger.SmackDebugger;
import org.jxmpp.xml.splitter.XmlPrettyPrinter;
import org.jxmpp.xml.splitter.XmppXmlSplitter;

public class SmackWebSocketDebugger {
    private static final Logger LOGGER = Logger.getLogger(SmackWebSocketDebugger.class.getName());
    private final SmackDebugger debugger;
    private final XmppXmlSplitter incomingXmlSplitter;
    private final XmppXmlSplitter outgoingXmlSplitter;

    SmackWebSocketDebugger(SmackDebugger smackDebugger) {
        this.debugger = smackDebugger;
        XmlPrettyPrinter incomingTextPrinter = XmlPrettyPrinter.builder().setPrettyWriter(sb -> this.debugger.incomingStreamSink(sb)).setTabWidth(4).build();
        this.incomingXmlSplitter = new XmppXmlSplitter(incomingTextPrinter);
        XmlPrettyPrinter outgoingTextPrinter = XmlPrettyPrinter.builder().setPrettyWriter(sb -> this.debugger.outgoingStreamSink(sb)).setTabWidth(4).build();
        this.outgoingXmlSplitter = new XmppXmlSplitter(outgoingTextPrinter);
    }

    void incoming(String text) {
        try {
            this.incomingXmlSplitter.write(text);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "IOException encountered while parsing received text: " + text, e);
        }
    }

    void outgoing(String text) {
        try {
            this.outgoingXmlSplitter.write(text);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "IOException encountered while parsing outgoing text: " + text, e);
        }
    }
}

