/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.processor.modeler.annotation;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.Messager;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.declaration.TypeParameterDeclaration;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.util.DeclarationVisitor;
import com.sun.mirror.util.SourcePosition;
import com.sun.tools.ws.ToolVersion;
import com.sun.tools.ws.processor.generator.GeneratorUtil;
import com.sun.tools.ws.processor.generator.Names;
import com.sun.tools.ws.processor.model.Operation;
import com.sun.tools.ws.processor.model.Port;
import com.sun.tools.ws.processor.model.Service;
import com.sun.tools.ws.processor.modeler.ModelerException;
import com.sun.tools.ws.processor.modeler.annotation.AnnotationProcessorContext;
import com.sun.tools.ws.processor.modeler.annotation.ModelBuilder;
import com.sun.tools.ws.processor.modeler.annotation.TypeModeler;
import com.sun.tools.ws.processor.modeler.annotation.WebServiceConstants;
import com.sun.tools.ws.processor.modeler.annotation.WebServiceVisitor;
import com.sun.tools.ws.processor.modeler.annotation.WebServiceWrapperGenerator;
import com.sun.tools.ws.processor.modeler.wsdl.ConsoleErrorReporter;
import com.sun.tools.ws.resources.WebserviceapMessages;
import com.sun.tools.ws.wscompile.AbortException;
import com.sun.tools.ws.wscompile.ErrorReceiver;
import com.sun.tools.ws.wscompile.ErrorReceiverFilter;
import com.sun.tools.ws.wscompile.WsgenOptions;
import com.sun.tools.ws.wscompile.WsimportListener;
import com.sun.xml.ws.util.localization.Localizable;
import com.sun.xml.ws.util.localization.Localizer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jws.WebService;
import javax.xml.ws.WebServiceProvider;
import org.xml.sax.SAXParseException;

public class WebServiceAP
implements AnnotationProcessor,
ModelBuilder,
WebServiceConstants {
    protected AnnotationProcessorEnvironment apEnv;
    private File sourceDir;
    private TypeDeclaration remoteDecl;
    private TypeDeclaration remoteExceptionDecl;
    private TypeDeclaration exceptionDecl;
    private TypeDeclaration defHolderDecl;
    private Service service;
    private Port port;
    protected AnnotationProcessorContext context;
    private Set<TypeDeclaration> processedTypeDecls = new HashSet<TypeDeclaration>();
    protected Messager messager;
    private boolean doNotOverWrite = false;
    private WsgenOptions options;
    private ErrorReceiver receiver;
    private PrintStream out;
    private boolean isAPTInvocation = false;
    private static final Localizer localizer = new Localizer();

    public void run() {
    }

    protected boolean parseArguments(String[] args) {
        return true;
    }

    public WebServiceAP(WsgenOptions options, AnnotationProcessorContext context, ErrorReceiver receiver, PrintStream out) {
        this.options = options;
        this.sourceDir = options != null ? options.sourceDir : null;
        this.doNotOverWrite = options != null && options.doNotOverWrite;
        this.receiver = receiver;
        this.out = out;
        this.context = context;
    }

    public void init(AnnotationProcessorEnvironment apEnv) {
        this.apEnv = apEnv;
        this.remoteDecl = this.apEnv.getTypeDeclaration(REMOTE_CLASSNAME);
        this.remoteExceptionDecl = this.apEnv.getTypeDeclaration(REMOTE_EXCEPTION_CLASSNAME);
        this.exceptionDecl = this.apEnv.getTypeDeclaration(EXCEPTION_CLASSNAME);
        this.defHolderDecl = this.apEnv.getTypeDeclaration(HOLDER_CLASSNAME);
        if (this.options == null) {
            String cpath;
            this.options = new WsgenOptions();
            this.out = new PrintStream(new ByteArrayOutputStream());
            class Listener
            extends WsimportListener {
                ConsoleErrorReporter cer;

                Listener() {
                    this.cer = new ConsoleErrorReporter(WebServiceAP.this.out);
                }

                public void generatedFile(String fileName) {
                    this.message(fileName);
                }

                public void message(String msg) {
                    WebServiceAP.this.out.println(msg);
                }

                public void error(SAXParseException exception) {
                    this.cer.error(exception);
                }

                public void fatalError(SAXParseException exception) {
                    this.cer.fatalError(exception);
                }

                public void warning(SAXParseException exception) {
                    this.cer.warning(exception);
                }

                public void info(SAXParseException exception) {
                    this.cer.info(exception);
                }
            }
            final Listener listener = new Listener();
            this.receiver = new ErrorReceiverFilter(new Listener()){
                {
                    super(x0);
                }

                public void info(SAXParseException exception) {
                    if (((WebServiceAP)WebServiceAP.this).options.verbose) {
                        super.info(exception);
                    }
                }

                public void warning(SAXParseException exception) {
                    if (!((WebServiceAP)WebServiceAP.this).options.quiet) {
                        super.warning(exception);
                    }
                }

                public void pollAbort() throws AbortException {
                    if (listener.isCanceled()) {
                        throw new AbortException();
                    }
                }
            };
            Map apOptions = apEnv.getOptions();
            String classDir = (String)apOptions.get("-d");
            if (classDir == null) {
                classDir = ".";
            }
            this.sourceDir = apOptions.get("-s") != null ? new File((String)apOptions.get("-s")) : new File(classDir);
            String cp = (String)apOptions.get("-classpath");
            this.options.classpath = cpath = classDir + File.pathSeparator + cp + File.pathSeparator + System.getProperty("java.class.path");
            boolean setVerbose = false;
            for (String key : apOptions.keySet()) {
                if (!key.equals("-verbose")) continue;
                setVerbose = true;
            }
            this.options.verbose = setVerbose;
            this.messager = apEnv.getMessager();
            this.isAPTInvocation = true;
        }
        this.options.filer = apEnv.getFiler();
    }

    public AnnotationProcessorEnvironment getAPEnv() {
        return this.apEnv;
    }

    public WsgenOptions getOptions() {
        return this.options;
    }

    public File getSourceDir() {
        return this.sourceDir;
    }

    public void onError(String message) {
        if (this.messager != null) {
            this.messager.printError(message);
            throw new AbortException();
        }
        throw new ModelerException(message, new Object[0]);
    }

    public void onError(SourcePosition pos, Localizable msg) throws ModelerException {
        if (this.messager == null) {
            throw new ModelerException(msg);
        }
        this.messager.printError(pos, localizer.localize(msg));
    }

    public void onWarning(String message) {
        if (this.messager != null) {
            this.messager.printWarning(message);
        } else {
            this.report(message);
        }
    }

    public void onInfo(String message) {
        if (this.messager != null) {
            this.messager.printNotice(message);
        } else {
            this.report(message);
        }
    }

    protected void report(String msg) {
        PrintStream outstream = this.out instanceof PrintStream ? this.out : new PrintStream(this.out, true);
        outstream.println(msg);
        outstream.flush();
    }

    public void process() {
        if (this.context.getRound() == 1) {
            this.buildModel();
        }
        this.context.incrementRound();
    }

    public boolean checkAndSetProcessed(TypeDeclaration typeDecl) {
        if (!this.processedTypeDecls.contains(typeDecl)) {
            this.processedTypeDecls.add(typeDecl);
            return false;
        }
        return true;
    }

    public void clearProcessed() {
        this.processedTypeDecls.clear();
    }

    public void setService(Service service) {
        this.service = service;
    }

    public void setPort(Port port) {
        this.port = port;
        this.service.addPort(port);
    }

    public void addOperation(Operation operation) {
        this.port.addOperation(operation);
    }

    public void setWrapperGenerated(boolean wrapperGenerated) {
    }

    public TypeDeclaration getTypeDeclaration(String typeName) {
        return this.apEnv.getTypeDeclaration(typeName);
    }

    public String getSourceVersion() {
        return ToolVersion.VERSION.MAJOR_VERSION;
    }

    private void buildModel() {
        WebServiceVisitor wrapperGenerator = this.createWrapperGenerator();
        boolean processedEndpoint = false;
        for (TypeDeclaration typedecl : this.apEnv.getTypeDeclarations()) {
            if (!(typedecl instanceof ClassDeclaration)) continue;
            WebServiceProvider webServiceProvider = (WebServiceProvider)typedecl.getAnnotation(WebServiceProvider.class);
            WebService webService = (WebService)typedecl.getAnnotation(WebService.class);
            if (webServiceProvider != null) {
                if (webService != null) {
                    this.onError(WebserviceapMessages.WEBSERVICEAP_WEBSERVICE_AND_WEBSERVICEPROVIDER(typedecl.getQualifiedName()));
                }
                processedEndpoint = true;
            }
            if (!this.shouldProcessWebService(webService)) continue;
            typedecl.accept((DeclarationVisitor)wrapperGenerator);
            processedEndpoint = true;
        }
        if (!processedEndpoint) {
            if (this.isAPTInvocation) {
                this.onWarning(WebserviceapMessages.WEBSERVICEAP_NO_WEBSERVICE_ENDPOINT_FOUND());
            } else {
                this.onError(WebserviceapMessages.WEBSERVICEAP_NO_WEBSERVICE_ENDPOINT_FOUND());
            }
        }
    }

    protected WebServiceVisitor createWrapperGenerator() {
        return new WebServiceWrapperGenerator(this, this.context);
    }

    protected boolean shouldProcessWebService(WebService webService) {
        return webService != null;
    }

    public boolean isException(TypeDeclaration typeDecl) {
        return WebServiceAP.isSubtype(typeDecl, this.exceptionDecl);
    }

    public boolean isRemoteException(TypeDeclaration typeDecl) {
        return WebServiceAP.isSubtype(typeDecl, this.remoteExceptionDecl);
    }

    public boolean isRemote(TypeDeclaration typeDecl) {
        return WebServiceAP.isSubtype(typeDecl, this.remoteDecl);
    }

    public static boolean isSubtype(TypeDeclaration d1, TypeDeclaration d2) {
        ClassType superClass;
        if (d1.equals(d2)) {
            return true;
        }
        ClassDeclaration superClassDecl = null;
        if (d1 instanceof ClassDeclaration && (superClass = ((ClassDeclaration)d1).getSuperclass()) != null && (superClassDecl = superClass.getDeclaration()).equals(d2)) {
            return true;
        }
        InterfaceDeclaration superIntf = null;
        for (InterfaceType interfaceType : d1.getSuperinterfaces()) {
            superIntf = interfaceType.getDeclaration();
            if (!superIntf.equals(d2)) continue;
            return true;
        }
        if (superIntf != null && WebServiceAP.isSubtype(superIntf, d2)) {
            return true;
        }
        return superClassDecl != null && WebServiceAP.isSubtype((TypeDeclaration)superClassDecl, d2);
    }

    public static String getMethodSig(MethodDeclaration method) {
        StringBuffer buf = new StringBuffer(method.getSimpleName() + "(");
        Iterator params = method.getFormalTypeParameters().iterator();
        int i = 0;
        while (params.hasNext()) {
            if (i > 0) {
                buf.append(", ");
            }
            TypeParameterDeclaration param = (TypeParameterDeclaration)params.next();
            buf.append(param.getSimpleName());
            ++i;
        }
        buf.append(")");
        return buf.toString();
    }

    public String getOperationName(String messageName) {
        return messageName;
    }

    public String getResponseName(String operationName) {
        return Names.getResponseName(operationName);
    }

    public TypeMirror getHolderValueType(TypeMirror type) {
        return TypeModeler.getHolderValueType(type, this.defHolderDecl);
    }

    public boolean canOverWriteClass(String className) {
        return !this.doNotOverWrite || !GeneratorUtil.classExists(this.options, className);
    }

    public void log(String msg) {
        if (this.options != null && this.options.verbose) {
            String message = "[" + msg + "]";
            if (this.messager != null) {
                this.messager.printNotice(message);
            } else {
                System.out.println(message);
            }
        }
    }

    public String getXMLName(String javaName) {
        return javaName;
    }
}

