/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.transform;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.common.registry.Provider;
import org.openhab.core.common.registry.ProviderChangeListener;
import org.openhab.core.service.WatchService;
import org.openhab.core.transform.Transformation;
import org.openhab.core.transform.TransformationProvider;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(service={TransformationProvider.class}, immediate=true)
public class FileTransformationProvider
implements WatchService.WatchEventListener,
TransformationProvider {
    private static final Set<String> IGNORED_EXTENSIONS = Set.of("txt", "swp");
    private static final Pattern FILENAME_PATTERN = Pattern.compile("(?<filename>.+?)(_(?<language>[a-z]{2}))?\\.(?<extension>[^.]*)$");
    private final Logger logger = LoggerFactory.getLogger(FileTransformationProvider.class);
    private final Set<ProviderChangeListener<Transformation>> listeners = ConcurrentHashMap.newKeySet();
    private final Map<Path, Transformation> transformationConfigurations = new ConcurrentHashMap<Path, Transformation>();
    private final Path transformationPath;
    private final WatchService watchService;

    @Activate
    public FileTransformationProvider(@Reference(target="(watchservice.name=configWatcher)") WatchService watchService) {
        this.watchService = watchService;
        this.transformationPath = watchService.getWatchPath().resolve("transform");
        watchService.registerListener((WatchService.WatchEventListener)this, this.transformationPath);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Stream<Path> files = Files.walk(this.transformationPath, new FileVisitOption[0]);){
                files.filter(path -> Files.isRegularFile(path, new LinkOption[0])).forEach(f -> this.processWatchEvent(WatchService.Kind.CREATE, (Path)f));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.logger.warn("Could not list files in '{}', transformation configurations might be missing: {}", (Object)this.transformationPath, (Object)e.getMessage());
        }
    }

    @Deactivate
    public void deactivate() {
        this.watchService.unregisterListener((WatchService.WatchEventListener)this);
    }

    public void addProviderChangeListener(ProviderChangeListener<Transformation> listener) {
        this.listeners.add(listener);
    }

    public void removeProviderChangeListener(ProviderChangeListener<Transformation> listener) {
        this.listeners.remove(listener);
    }

    public Collection<Transformation> getAll() {
        return this.transformationConfigurations.values();
    }

    public void processWatchEvent(WatchService.Kind kind, Path fullPath) {
        Path path = this.transformationPath.relativize(fullPath);
        try {
            if (kind == WatchService.Kind.DELETE) {
                Transformation oldElement = this.transformationConfigurations.remove(path);
                if (oldElement != null) {
                    this.logger.trace("Removed configuration from file '{}", (Object)path);
                    this.listeners.forEach(listener -> listener.removed((Provider)this, (Object)oldElement));
                }
            } else if (Files.isRegularFile(fullPath, new LinkOption[0]) && !Files.isHidden(fullPath) && (kind == WatchService.Kind.CREATE || kind == WatchService.Kind.MODIFY)) {
                String fileName = path.getFileName().toString();
                Matcher m = FILENAME_PATTERN.matcher(fileName);
                if (!m.matches()) {
                    this.logger.debug("Skipping {} event for '{}' - no file extensions found or remaining filename empty", (Object)kind, (Object)path);
                    return;
                }
                String fileExtension = m.group("extension");
                if (IGNORED_EXTENSIONS.contains(fileExtension)) {
                    this.logger.debug("Skipping {} event for '{}' - file extension '{}' is ignored", new Object[]{kind, path, fileExtension});
                    return;
                }
                String content = new String(Files.readAllBytes(fullPath));
                String uid = path.toString();
                Transformation newElement = new Transformation(uid, uid, fileExtension, Map.of("function", content));
                Transformation oldElement = this.transformationConfigurations.put(path, newElement);
                if (oldElement == null) {
                    this.logger.trace("Added new configuration from file '{}'", (Object)path);
                    this.listeners.forEach(listener -> listener.added((Provider)this, (Object)newElement));
                } else {
                    this.logger.trace("Updated new configuration from file '{}'", (Object)path);
                    this.listeners.forEach(listener -> listener.updated((Provider)this, (Object)oldElement, (Object)newElement));
                }
            } else {
                this.logger.trace("Skipping {} event for '{}' - not a regular file", (Object)kind, (Object)path);
            }
        }
        catch (IOException e) {
            this.logger.warn("Skipping {} event for '{}' - failed to process it: {}", new Object[]{kind, path, e.getMessage()});
        }
    }
}

