//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;

use crate::*;

/// *************    Type definitions        **********
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nsroundingmode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSRoundingMode(pub NSUInteger);
impl NSRoundingMode {
    #[doc(alias = "NSRoundPlain")]
    pub const RoundPlain: Self = Self(0);
    #[doc(alias = "NSRoundDown")]
    pub const RoundDown: Self = Self(1);
    #[doc(alias = "NSRoundUp")]
    pub const RoundUp: Self = Self(2);
    #[doc(alias = "NSRoundBankers")]
    pub const RoundBankers: Self = Self(3);
}

unsafe impl Encode for NSRoundingMode {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSRoundingMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nscalculationerror?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSCalculationError(pub NSUInteger);
impl NSCalculationError {
    #[doc(alias = "NSCalculationNoError")]
    pub const NoError: Self = Self(0);
    #[doc(alias = "NSCalculationLossOfPrecision")]
    pub const LossOfPrecision: Self = Self(1);
    #[doc(alias = "NSCalculationUnderflow")]
    pub const Underflow: Self = Self(2);
    #[doc(alias = "NSCalculationOverflow")]
    pub const Overflow: Self = Self(3);
    #[doc(alias = "NSCalculationDivideByZero")]
    pub const DivideByZero: Self = Self(4);
}

unsafe impl Encode for NSCalculationError {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSCalculationError {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

impl NSDecimal {
    // TODO: pub fn NSDecimalIsNotANumber(dcm: NonNull<NSDecimal>,) -> Bool;

    /// *************    Operations        **********
    #[doc(alias = "NSDecimalCopy")]
    #[inline]
    pub unsafe fn copy(destination: NonNull<NSDecimal>, source: NonNull<NSDecimal>) {
        extern "C-unwind" {
            fn NSDecimalCopy(destination: NonNull<NSDecimal>, source: NonNull<NSDecimal>);
        }
        unsafe { NSDecimalCopy(destination, source) }
    }

    #[doc(alias = "NSDecimalCompact")]
    #[inline]
    pub unsafe fn compact(number: NonNull<NSDecimal>) {
        extern "C-unwind" {
            fn NSDecimalCompact(number: NonNull<NSDecimal>);
        }
        unsafe { NSDecimalCompact(number) }
    }

    #[doc(alias = "NSDecimalCompare")]
    #[cfg(feature = "NSObjCRuntime")]
    #[inline]
    pub unsafe fn compare(
        left_operand: NonNull<NSDecimal>,
        right_operand: NonNull<NSDecimal>,
    ) -> NSComparisonResult {
        extern "C-unwind" {
            fn NSDecimalCompare(
                left_operand: NonNull<NSDecimal>,
                right_operand: NonNull<NSDecimal>,
            ) -> NSComparisonResult;
        }
        unsafe { NSDecimalCompare(left_operand, right_operand) }
    }

    #[doc(alias = "NSDecimalRound")]
    #[inline]
    pub unsafe fn round(
        result: NonNull<NSDecimal>,
        number: NonNull<NSDecimal>,
        scale: NSInteger,
        rounding_mode: NSRoundingMode,
    ) {
        extern "C-unwind" {
            fn NSDecimalRound(
                result: NonNull<NSDecimal>,
                number: NonNull<NSDecimal>,
                scale: NSInteger,
                rounding_mode: NSRoundingMode,
            );
        }
        unsafe { NSDecimalRound(result, number, scale, rounding_mode) }
    }

    #[doc(alias = "NSDecimalNormalize")]
    #[inline]
    pub unsafe fn normalize(
        number1: NonNull<NSDecimal>,
        number2: NonNull<NSDecimal>,
        rounding_mode: NSRoundingMode,
    ) -> NSCalculationError {
        extern "C-unwind" {
            fn NSDecimalNormalize(
                number1: NonNull<NSDecimal>,
                number2: NonNull<NSDecimal>,
                rounding_mode: NSRoundingMode,
            ) -> NSCalculationError;
        }
        unsafe { NSDecimalNormalize(number1, number2, rounding_mode) }
    }

    #[doc(alias = "NSDecimalAdd")]
    #[inline]
    pub unsafe fn add(
        result: NonNull<NSDecimal>,
        left_operand: NonNull<NSDecimal>,
        right_operand: NonNull<NSDecimal>,
        rounding_mode: NSRoundingMode,
    ) -> NSCalculationError {
        extern "C-unwind" {
            fn NSDecimalAdd(
                result: NonNull<NSDecimal>,
                left_operand: NonNull<NSDecimal>,
                right_operand: NonNull<NSDecimal>,
                rounding_mode: NSRoundingMode,
            ) -> NSCalculationError;
        }
        unsafe { NSDecimalAdd(result, left_operand, right_operand, rounding_mode) }
    }

    #[doc(alias = "NSDecimalSubtract")]
    #[inline]
    pub unsafe fn subtract(
        result: NonNull<NSDecimal>,
        left_operand: NonNull<NSDecimal>,
        right_operand: NonNull<NSDecimal>,
        rounding_mode: NSRoundingMode,
    ) -> NSCalculationError {
        extern "C-unwind" {
            fn NSDecimalSubtract(
                result: NonNull<NSDecimal>,
                left_operand: NonNull<NSDecimal>,
                right_operand: NonNull<NSDecimal>,
                rounding_mode: NSRoundingMode,
            ) -> NSCalculationError;
        }
        unsafe { NSDecimalSubtract(result, left_operand, right_operand, rounding_mode) }
    }

    #[doc(alias = "NSDecimalMultiply")]
    #[inline]
    pub unsafe fn multiply(
        result: NonNull<NSDecimal>,
        left_operand: NonNull<NSDecimal>,
        right_operand: NonNull<NSDecimal>,
        rounding_mode: NSRoundingMode,
    ) -> NSCalculationError {
        extern "C-unwind" {
            fn NSDecimalMultiply(
                result: NonNull<NSDecimal>,
                left_operand: NonNull<NSDecimal>,
                right_operand: NonNull<NSDecimal>,
                rounding_mode: NSRoundingMode,
            ) -> NSCalculationError;
        }
        unsafe { NSDecimalMultiply(result, left_operand, right_operand, rounding_mode) }
    }

    #[doc(alias = "NSDecimalDivide")]
    #[inline]
    pub unsafe fn divide(
        result: NonNull<NSDecimal>,
        left_operand: NonNull<NSDecimal>,
        right_operand: NonNull<NSDecimal>,
        rounding_mode: NSRoundingMode,
    ) -> NSCalculationError {
        extern "C-unwind" {
            fn NSDecimalDivide(
                result: NonNull<NSDecimal>,
                left_operand: NonNull<NSDecimal>,
                right_operand: NonNull<NSDecimal>,
                rounding_mode: NSRoundingMode,
            ) -> NSCalculationError;
        }
        unsafe { NSDecimalDivide(result, left_operand, right_operand, rounding_mode) }
    }

    #[doc(alias = "NSDecimalPower")]
    #[inline]
    pub unsafe fn power(
        result: NonNull<NSDecimal>,
        number: NonNull<NSDecimal>,
        power: NSUInteger,
        rounding_mode: NSRoundingMode,
    ) -> NSCalculationError {
        extern "C-unwind" {
            fn NSDecimalPower(
                result: NonNull<NSDecimal>,
                number: NonNull<NSDecimal>,
                power: NSUInteger,
                rounding_mode: NSRoundingMode,
            ) -> NSCalculationError;
        }
        unsafe { NSDecimalPower(result, number, power, rounding_mode) }
    }

    #[doc(alias = "NSDecimalMultiplyByPowerOf10")]
    #[inline]
    pub unsafe fn multiply_by_power_of10(
        result: NonNull<NSDecimal>,
        number: NonNull<NSDecimal>,
        power: c_short,
        rounding_mode: NSRoundingMode,
    ) -> NSCalculationError {
        extern "C-unwind" {
            fn NSDecimalMultiplyByPowerOf10(
                result: NonNull<NSDecimal>,
                number: NonNull<NSDecimal>,
                power: c_short,
                rounding_mode: NSRoundingMode,
            ) -> NSCalculationError;
        }
        unsafe { NSDecimalMultiplyByPowerOf10(result, number, power, rounding_mode) }
    }

    #[doc(alias = "NSDecimalString")]
    #[cfg(feature = "NSString")]
    #[inline]
    pub unsafe fn string(
        dcm: NonNull<NSDecimal>,
        locale: Option<&AnyObject>,
    ) -> Retained<NSString> {
        extern "C-unwind" {
            fn NSDecimalString(
                dcm: NonNull<NSDecimal>,
                locale: Option<&AnyObject>,
            ) -> *mut NSString;
        }
        let ret = unsafe { NSDecimalString(dcm, locale) };
        unsafe { Retained::retain_autoreleased(ret) }
            .expect("function was marked as returning non-null, but actually returned NULL")
    }
}

extern "C-unwind" {
    #[deprecated = "renamed to `NSDecimal::copy`"]
    pub fn NSDecimalCopy(destination: NonNull<NSDecimal>, source: NonNull<NSDecimal>);
}

extern "C-unwind" {
    #[deprecated = "renamed to `NSDecimal::compact`"]
    pub fn NSDecimalCompact(number: NonNull<NSDecimal>);
}

extern "C-unwind" {
    #[cfg(feature = "NSObjCRuntime")]
    #[deprecated = "renamed to `NSDecimal::compare`"]
    pub fn NSDecimalCompare(
        left_operand: NonNull<NSDecimal>,
        right_operand: NonNull<NSDecimal>,
    ) -> NSComparisonResult;
}

extern "C-unwind" {
    #[deprecated = "renamed to `NSDecimal::round`"]
    pub fn NSDecimalRound(
        result: NonNull<NSDecimal>,
        number: NonNull<NSDecimal>,
        scale: NSInteger,
        rounding_mode: NSRoundingMode,
    );
}

extern "C-unwind" {
    #[deprecated = "renamed to `NSDecimal::normalize`"]
    pub fn NSDecimalNormalize(
        number1: NonNull<NSDecimal>,
        number2: NonNull<NSDecimal>,
        rounding_mode: NSRoundingMode,
    ) -> NSCalculationError;
}

extern "C-unwind" {
    #[deprecated = "renamed to `NSDecimal::add`"]
    pub fn NSDecimalAdd(
        result: NonNull<NSDecimal>,
        left_operand: NonNull<NSDecimal>,
        right_operand: NonNull<NSDecimal>,
        rounding_mode: NSRoundingMode,
    ) -> NSCalculationError;
}

extern "C-unwind" {
    #[deprecated = "renamed to `NSDecimal::subtract`"]
    pub fn NSDecimalSubtract(
        result: NonNull<NSDecimal>,
        left_operand: NonNull<NSDecimal>,
        right_operand: NonNull<NSDecimal>,
        rounding_mode: NSRoundingMode,
    ) -> NSCalculationError;
}

extern "C-unwind" {
    #[deprecated = "renamed to `NSDecimal::multiply`"]
    pub fn NSDecimalMultiply(
        result: NonNull<NSDecimal>,
        left_operand: NonNull<NSDecimal>,
        right_operand: NonNull<NSDecimal>,
        rounding_mode: NSRoundingMode,
    ) -> NSCalculationError;
}

extern "C-unwind" {
    #[deprecated = "renamed to `NSDecimal::divide`"]
    pub fn NSDecimalDivide(
        result: NonNull<NSDecimal>,
        left_operand: NonNull<NSDecimal>,
        right_operand: NonNull<NSDecimal>,
        rounding_mode: NSRoundingMode,
    ) -> NSCalculationError;
}

extern "C-unwind" {
    #[deprecated = "renamed to `NSDecimal::power`"]
    pub fn NSDecimalPower(
        result: NonNull<NSDecimal>,
        number: NonNull<NSDecimal>,
        power: NSUInteger,
        rounding_mode: NSRoundingMode,
    ) -> NSCalculationError;
}

extern "C-unwind" {
    #[deprecated = "renamed to `NSDecimal::multiply_by_power_of10`"]
    pub fn NSDecimalMultiplyByPowerOf10(
        result: NonNull<NSDecimal>,
        number: NonNull<NSDecimal>,
        power: c_short,
        rounding_mode: NSRoundingMode,
    ) -> NSCalculationError;
}

#[cfg(feature = "NSString")]
#[deprecated = "renamed to `NSDecimal::string`"]
#[inline]
pub unsafe extern "C-unwind" fn NSDecimalString(
    dcm: NonNull<NSDecimal>,
    locale: Option<&AnyObject>,
) -> Retained<NSString> {
    extern "C-unwind" {
        fn NSDecimalString(dcm: NonNull<NSDecimal>, locale: Option<&AnyObject>) -> *mut NSString;
    }
    let ret = unsafe { NSDecimalString(dcm, locale) };
    unsafe { Retained::retain_autoreleased(ret) }
        .expect("function was marked as returning non-null, but actually returned NULL")
}
