/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.cli;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.cli.ApplicationInstanceController;
import org.jkiss.dbeaver.model.cli.CLIException;
import org.jkiss.dbeaver.model.cli.CLIProcessResult;
import org.jkiss.dbeaver.model.cli.CLIRunMeta;
import org.jkiss.dbeaver.model.cli.CommandLineContext;
import org.jkiss.dbeaver.model.cli.ExceptionHandler;
import org.jkiss.dbeaver.model.cli.command.AbstractTopLevelCommand;
import org.jkiss.dbeaver.model.cli.registry.CommandLineParameterDescriptor;
import org.jkiss.utils.CommonUtils;
import picocli.CommandLine;

public abstract class ApplicationCommandLine<T extends ApplicationInstanceController> {
    private static final Log log;
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.commandLine";
    private static final Gson gson;
    protected static final Map<Class<?>, CommandLineParameterDescriptor> customParameters;

    static {
        IConfigurationElement[] extElements;
        log = Log.getLog(ApplicationCommandLine.class);
        gson = new GsonBuilder().setPrettyPrinting().create();
        customParameters = new LinkedHashMap();
        IExtensionRegistry er = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extElements = er.getConfigurationElementsFor(EXTENSION_ID);
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if ("parameter".equals(ext.getName())) {
                try {
                    CommandLineParameterDescriptor parameter = new CommandLineParameterDescriptor(ext);
                    customParameters.put(parameter.getImplClass(), parameter);
                }
                catch (Exception e) {
                    log.error((Object)"Can't load contributed parameter", (Throwable)e);
                }
            }
            ++n2;
        }
    }

    protected ApplicationCommandLine() {
    }

    protected abstract AbstractTopLevelCommand createTopLevelCommand(@Nullable T var1, @NotNull CommandLineContext var2, @NotNull CLIRunMeta var3);

    /*
     * Exception decompiling
     */
    public CLIProcessResult executeCommandLineCommands(@Nullable T controller, boolean uiActivated, boolean supportNewInstance, @NotNull String[] args) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void validateCommandLineParameters(@NotNull CommandLine.ParseResult parseResult) throws CLIException {
    }

    @NotNull
    public String[] preprocessCommandLine(@NotNull String[] args) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (CommandLineContext context = new CommandLineContext(null);){
            CommandLine commandLine = this.initCommandLine(null, context, new CLIRunMeta(false, false));
            commandLine.setUnmatchedArgumentsAllowed(true);
            CommandLine.ParseResult parseResult = commandLine.parseArgs(args);
            if (this.commandLineIsEmpty(parseResult)) {
                return args;
            }
            for (CommandLineParameterDescriptor descriptor : customParameters.values()) {
                CommandLine.ParseResult cliCommand = this.findCommand(parseResult, descriptor.getImplClass());
                if (cliCommand == null) continue;
                this.preprocessCommandLineParameter(descriptor, cliCommand, context, false);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return args;
    }

    protected void preprocessCommandLineParameter(@NotNull CommandLineParameterDescriptor descriptor, @NotNull CommandLine.ParseResult cliCommand, @NotNull CommandLineContext context, boolean uiActivated) {
    }

    @NotNull
    protected CommandLine initCommandLine(@Nullable T applicationInstanceController, @NotNull CommandLineContext context, @NotNull CLIRunMeta runMeta) {
        CommandLine cmd = new CommandLine((Object)this.createTopLevelCommand(applicationInstanceController, context, runMeta));
        cmd.setExecutionStrategy((CommandLine.IExecutionStrategy)new CommandLine.RunAll());
        ExceptionHandler exceptionHandler = new ExceptionHandler();
        cmd.setExecutionExceptionHandler((CommandLine.IExecutionExceptionHandler)exceptionHandler);
        for (CommandLineParameterDescriptor param : customParameters.values()) {
            if (param.getImplClass().getAnnotation(CommandLine.Command.class) == null) {
                log.warn((Object)("Class is not annotated '" + param.getImplClass().getName() + "'"));
                continue;
            }
            cmd.addSubcommand(param.getImplClass());
        }
        return cmd;
    }

    protected boolean commandLineIsEmpty(@Nullable CommandLine.ParseResult commandLine) {
        return commandLine == null || CommonUtils.isEmpty((Collection)commandLine.matchedArgs()) && CommonUtils.isEmpty((Collection)commandLine.matchedOptions()) && CommonUtils.isEmpty((Collection)commandLine.subcommands());
    }

    @Nullable
    protected CommandLine.ParseResult findCommand(@NotNull CommandLine.ParseResult pr, @NotNull Class<?> clazz) {
        Object commandObject = pr.commandSpec().userObject();
        if (clazz.equals(commandObject.getClass())) {
            return pr;
        }
        for (CommandLine.ParseResult sub : pr.subcommands()) {
            CommandLine.ParseResult found = this.findCommand(sub, clazz);
            if (found == null) continue;
            return found;
        }
        return null;
    }
}

