#!/bin/bash

rm -f enum_string.go

TYPES=$(cat enum.go|sed -n '/^type /p'|awk '{print $2}'|sed -e 's/Type$//'|sort)

echo -e "package evdev\n// Code generated by gen.sh; DO NOT EDIT." > enum_string.go

for i in $TYPES; do
  stringer -trimprefix $i -type "${i}Type" -output tmp.go
  cat tmp.go|sed -e 's/^package.*//' -e 's/^import.*//' -e 's/\/\/.*//' >> enum_string.go
  rm -f tmp.go
  goimports -w enum_string.go
  gofmt -w -s enum_string.go
done

