/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import org.bouncycastle.bcpg.BCPGObject;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.UnsupportedPacketVersionException;
import org.bouncycastle.crypto.CryptoServicesRegistrar;

public class S2K
extends BCPGObject {
    private static final int EXPBIAS = 6;
    public static final int SIMPLE = 0;
    public static final int SALTED = 1;
    public static final int SALTED_AND_ITERATED = 3;
    public static final int ARGON_2 = 4;
    public static final int GNU_DUMMY_S2K = 101;
    public static final int GNU_PROTECTION_MODE_NO_PRIVATE_KEY = 1;
    public static final int GNU_PROTECTION_MODE_DIVERT_TO_CARD = 2;
    public static final int GNU_PROTECTION_MODE_INTERNAL = 3;
    int type;
    int algorithm;
    byte[] iv;
    int itCount = -1;
    int passes = -1;
    int protectionMode = -1;
    int parallelism;
    int memorySizeExponent;

    S2K(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        this.type = dataInputStream.read();
        switch (this.type) {
            case 0: {
                this.algorithm = dataInputStream.read();
                break;
            }
            case 1: {
                this.algorithm = dataInputStream.read();
                this.iv = new byte[8];
                dataInputStream.readFully(this.iv, 0, this.iv.length);
                break;
            }
            case 3: {
                this.algorithm = dataInputStream.read();
                this.iv = new byte[8];
                dataInputStream.readFully(this.iv, 0, this.iv.length);
                this.itCount = dataInputStream.read();
                break;
            }
            case 4: {
                this.iv = new byte[16];
                dataInputStream.readFully(this.iv);
                this.passes = dataInputStream.read();
                this.parallelism = dataInputStream.read();
                this.memorySizeExponent = dataInputStream.read();
                break;
            }
            case 101: {
                this.algorithm = dataInputStream.read();
                dataInputStream.read();
                dataInputStream.read();
                dataInputStream.read();
                this.protectionMode = dataInputStream.read();
                break;
            }
            default: {
                throw new UnsupportedPacketVersionException("Invalid S2K type: " + this.type);
            }
        }
    }

    public S2K(int n) {
        this.type = 0;
        this.algorithm = n;
    }

    public S2K(int n, byte[] byArray) {
        this.type = 1;
        this.algorithm = n;
        this.iv = byArray;
    }

    public S2K(int n, byte[] byArray, int n2) {
        this.type = 3;
        this.algorithm = n;
        this.iv = byArray;
        if (n2 >= 256 && n2 <= 65536) {
            throw new IllegalArgumentException("invalid itCount");
        }
        this.itCount = n2;
    }

    public S2K(Argon2Params argon2Params) {
        this.type = 4;
        this.iv = argon2Params.getSalt();
        this.passes = argon2Params.getPasses();
        this.parallelism = argon2Params.getParallelism();
        this.memorySizeExponent = argon2Params.getMemSizeExp();
    }

    public S2K(GNUDummyParams gNUDummyParams) {
        this.type = 101;
        this.protectionMode = gNUDummyParams.getProtectionMode();
    }

    public static S2K simpleS2K(int n) {
        return new S2K(n);
    }

    public static S2K saltedS2K(int n, byte[] byArray) {
        return new S2K(n, byArray);
    }

    public static S2K saltedAndIteratedS2K(int n, byte[] byArray, int n2) {
        return new S2K(n, byArray, n2);
    }

    public static S2K argon2S2K(Argon2Params argon2Params) {
        return new S2K(argon2Params);
    }

    public static S2K gnuDummyS2K(GNUDummyParams gNUDummyParams) {
        return new S2K(gNUDummyParams);
    }

    public int getType() {
        return this.type;
    }

    public int getHashAlgorithm() {
        return this.algorithm;
    }

    public byte[] getIV() {
        return this.iv;
    }

    public long getIterationCount() {
        if (this.itCount >= 256) {
            return this.itCount;
        }
        return 16 + (this.itCount & 0xF) << (this.itCount >> 4) + 6;
    }

    public int getPasses() {
        return this.passes;
    }

    public int getProtectionMode() {
        return this.protectionMode;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public int getMemorySizeExponent() {
        return this.memorySizeExponent;
    }

    @Override
    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        switch (this.type) {
            case 0: {
                bCPGOutputStream.write(this.type);
                bCPGOutputStream.write(this.algorithm);
                break;
            }
            case 1: {
                bCPGOutputStream.write(this.type);
                bCPGOutputStream.write(this.algorithm);
                bCPGOutputStream.write(this.iv);
                break;
            }
            case 3: {
                bCPGOutputStream.write(this.type);
                bCPGOutputStream.write(this.algorithm);
                bCPGOutputStream.write(this.iv);
                this.writeOneOctetOrThrow(bCPGOutputStream, this.itCount, "Iteration count");
                break;
            }
            case 4: {
                bCPGOutputStream.write(this.type);
                bCPGOutputStream.write(this.iv);
                this.writeOneOctetOrThrow(bCPGOutputStream, this.passes, "Passes");
                this.writeOneOctetOrThrow(bCPGOutputStream, this.parallelism, "Parallelism");
                this.writeOneOctetOrThrow(bCPGOutputStream, this.memorySizeExponent, "Memory size exponent");
                break;
            }
            case 101: {
                bCPGOutputStream.write(this.type);
                bCPGOutputStream.write(this.algorithm);
                bCPGOutputStream.write(71);
                bCPGOutputStream.write(78);
                bCPGOutputStream.write(85);
                bCPGOutputStream.write(this.protectionMode);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown S2K type " + this.type);
            }
        }
    }

    private void writeOneOctetOrThrow(BCPGOutputStream bCPGOutputStream, int n, String string) throws IOException {
        if (n >= 256) {
            throw new IllegalStateException(string + " not encodable");
        }
        bCPGOutputStream.write(n);
    }

    public static class Argon2Params {
        private final byte[] salt;
        private final int passes;
        private final int parallelism;
        private final int memSizeExp;

        public Argon2Params() {
            this(CryptoServicesRegistrar.getSecureRandom());
        }

        public Argon2Params(SecureRandom secureRandom) {
            this(1, 4, 21, secureRandom);
        }

        public Argon2Params(int n, int n2, int n3, SecureRandom secureRandom) {
            this(Argon2Params.mineSalt(secureRandom), n, n2, n3);
        }

        public Argon2Params(byte[] byArray, int n, int n2, int n3) {
            if (byArray.length != 16) {
                throw new IllegalArgumentException("Argon2 uses 16 bytes of salt");
            }
            this.salt = byArray;
            if (n < 1) {
                throw new IllegalArgumentException("Number of passes MUST be positive, non-zero");
            }
            this.passes = n;
            if (n2 < 1) {
                throw new IllegalArgumentException("Parallelism MUST be positive, non-zero.");
            }
            this.parallelism = n2;
            double d = Math.log(n2) / Math.log(2.0);
            if ((double)n3 < 3.0 + Math.ceil(d) || n3 > 31) {
                throw new IllegalArgumentException("Memory size exponent MUST be between 3 + \u2308log\u2082(parallelism)\u2309 and 31");
            }
            this.memSizeExp = n3;
        }

        public static Argon2Params universallyRecommendedParameters() {
            return new Argon2Params(1, 4, 21, CryptoServicesRegistrar.getSecureRandom());
        }

        public static Argon2Params memoryConstrainedParameters() {
            return new Argon2Params(3, 4, 16, CryptoServicesRegistrar.getSecureRandom());
        }

        private static byte[] mineSalt(SecureRandom secureRandom) {
            byte[] byArray = new byte[16];
            secureRandom.nextBytes(byArray);
            return byArray;
        }

        public byte[] getSalt() {
            return this.salt;
        }

        public int getPasses() {
            return this.passes;
        }

        public int getParallelism() {
            return this.parallelism;
        }

        public int getMemSizeExp() {
            return this.memSizeExp;
        }
    }

    public static class GNUDummyParams {
        private final int protectionMode;

        private GNUDummyParams(int n) {
            this.protectionMode = n;
        }

        public static GNUDummyParams noPrivateKey() {
            return new GNUDummyParams(1);
        }

        public static GNUDummyParams divertToCard() {
            return new GNUDummyParams(2);
        }

        public static GNUDummyParams internal() {
            return new GNUDummyParams(3);
        }

        public int getProtectionMode() {
            return this.protectionMode;
        }
    }
}

