/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.inspections.quickfixes;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.angular2.cli.AngularCliUtil;
import org.angular2.cli.actions.AngularCliAddDependencyAction;
import org.angular2.lang.Angular2Bundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\f\u001a\u00020\u0006H\u0017J\b\u0010\r\u001a\u00020\u0006H\u0017J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0013H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/angular2/inspections/quickfixes/AngularCliAddQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "myPackageJson", "Lcom/intellij/openapi/vfs/VirtualFile;", "myPackageName", "", "myVersionSpec", "myReinstall", "", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;Ljava/lang/String;Z)V", "getName", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "previewDescriptor", "intellij.angular"})
@SourceDebugExtension(value={"SMAP\nAngularCliAddQuickFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AngularCliAddQuickFix.kt\norg/angular2/inspections/quickfixes/AngularCliAddQuickFix\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,47:1\n106#2:48\n78#2,22:49\n*S KotlinDebug\n*F\n+ 1 AngularCliAddQuickFix.kt\norg/angular2/inspections/quickfixes/AngularCliAddQuickFix\n*L\n35#1:48\n35#1:49,22\n*E\n"})
public final class AngularCliAddQuickFix
implements LocalQuickFix,
HighPriorityAction {
    @NotNull
    private final VirtualFile myPackageJson;
    @NotNull
    private final String myPackageName;
    @NotNull
    private final String myVersionSpec;
    private final boolean myReinstall;

    public AngularCliAddQuickFix(@NotNull VirtualFile myPackageJson, @NotNull String myPackageName, @NotNull String myVersionSpec, boolean myReinstall) {
        Intrinsics.checkNotNullParameter((Object)myPackageJson, (String)"myPackageJson");
        Intrinsics.checkNotNullParameter((Object)myPackageName, (String)"myPackageName");
        Intrinsics.checkNotNullParameter((Object)myVersionSpec, (String)"myVersionSpec");
        this.myPackageJson = myPackageJson;
        this.myPackageName = myPackageName;
        this.myVersionSpec = myVersionSpec;
        this.myReinstall = myReinstall;
    }

    @Nls
    @NotNull
    public String getName() {
        Object[] objectArray = new Object[]{this.myPackageName};
        return Angular2Bundle.Companion.message(this.myReinstall ? "angular.quickfix.json.ng-add.name.reinstall" : "angular.quickfix.json.ng-add.name.run", objectArray);
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return Angular2Bundle.Companion.message("angular.quickfix.json.ng-add.family", new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (AngularCliUtil.hasAngularCLIPackageInstalled(this.myPackageJson)) {
            void $this$trim$iv;
            VirtualFile virtualFile = this.myPackageJson.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getParent(...)");
            String string = this.myVersionSpec;
            String string2 = this.myPackageName;
            VirtualFile virtualFile2 = virtualFile;
            Project project2 = project;
            AngularCliAddDependencyAction.Companion companion = AngularCliAddDependencyAction.Companion;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String string3 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            companion.runAndShowConsoleLater(project2, virtualFile2, string2, string3, !this.myReinstall);
        } else {
            VirtualFile virtualFile = this.myPackageJson.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getParent(...)");
            AngularCliUtil.notifyAngularCliNotInstalled(project, virtualFile, Angular2Bundle.Companion.message("angular.quickfix.json.ng-add.error.cant-run", new Object[0]));
        }
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)previewDescriptor, (String)"previewDescriptor");
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
        return intentionPreviewInfo;
    }
}

