/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.dialects;

import com.intellij.FilePropertyPusherBase;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSDialectsMappings;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.dialects.JSLanguageLevelApplicableRootsCache;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectStorePathManager;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.FilePropertyKey;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FilePropertyPusherEx;
import com.intellij.util.indexing.roots.PartialAdditionalLibraryIndexableSetOrigin;
import com.intellij.util.indexing.roots.kind.IndexableSetContributorOrigin;
import com.intellij.util.indexing.roots.kind.IndexableSetOrigin;
import com.intellij.util.indexing.roots.kind.LibraryOrigin;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;

public final class JSLanguageLevelPusher
extends FilePropertyPusherBase<String>
implements FilePropertyPusherEx<String> {
    private static final Key<MiscFileInfo> SUB_PROJECT_MISC_FILE_KEY = Key.create((String)"js.sub.project.misc.file");
    private static final Key<LanguageLevelInfo> LEVEL_IN_MISC_FILE_KEY = Key.create((String)"js.level.in.misc.file");

    @NotNull
    public FilePropertyKey<String> getFilePropertyKey() {
        FilePropertyKey<String> filePropertyKey = DialectDetector.KEY;
        if (filePropertyKey == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(0);
        }
        return filePropertyKey;
    }

    public boolean pushDirectoriesOnly() {
        return true;
    }

    @NotNull
    public String getDefaultValue() {
        String string = JSLanguageLevel.DEFAULT.getId();
        if (string == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public String getImmediateValue(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(2);
        }
        if (file == null) {
            return JSRootConfiguration.getInstance((Project)project).getLanguageLevel().getId();
        }
        String id = (String)JSDialectsMappings.getInstance(project).getImmediateMapping(file);
        if (id != null) {
            return id;
        }
        if (file.isDirectory()) {
            VirtualFile miscXml;
            MiscFileInfo cachedValue = (MiscFileInfo)file.getUserData(SUB_PROJECT_MISC_FILE_KEY);
            long vfsStructureModificationsCount = VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS.getModificationCount();
            if (cachedValue == null || cachedValue.vfsStructureModificationsCount() != vfsStructureModificationsCount) {
                miscXml = null;
                String basePath = project.getBasePath();
                if (basePath != null) {
                    try {
                        ProjectStorePathManager storePathManager = ProjectStorePathManager.getInstance();
                        VirtualFile ideaDirectory = storePathManager.getStoreDirectory(file);
                        if (ideaDirectory != null && (miscXml = ideaDirectory.findChild("misc.xml")) != null && VfsUtilCore.pathEqualsTo((VirtualFile)file, (String)basePath)) {
                            miscXml = null;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                cachedValue = new MiscFileInfo(miscXml, vfsStructureModificationsCount);
                file.putUserData(SUB_PROJECT_MISC_FILE_KEY, (Object)cachedValue);
            }
            if ((miscXml = cachedValue.file()) != null) {
                return JSLanguageLevelPusher.findLevelInMiscXml(miscXml);
            }
        }
        return null;
    }

    @Nullable
    private static String findLevelInMiscXml(@NotNull VirtualFile misc) {
        if (misc == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(3);
        }
        LanguageLevelInfo cachedValue = (LanguageLevelInfo)misc.getUserData(LEVEL_IN_MISC_FILE_KEY);
        long modificationCount = misc.getModificationCount();
        if (cachedValue == null || modificationCount != cachedValue.modificationCount()) {
            String languageLevel = null;
            try {
                Element root = JDOMUtil.load((InputStream)misc.getInputStream());
                Element jsSettings = JDomSerializationUtil.findComponent((Element)root, (String)"JavaScriptSettings");
                if (jsSettings != null) {
                    languageLevel = JDOMExternalizerUtil.readField((Element)jsSettings, (String)"languageLevel");
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            cachedValue = new LanguageLevelInfo(languageLevel, modificationCount);
            misc.putUserData(LEVEL_IN_MISC_FILE_KEY, (Object)cachedValue);
        }
        return cachedValue.languageLevel();
    }

    @Nullable
    public String getImmediateValue(@NotNull Module module) {
        if (module == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(4);
        }
        return null;
    }

    public boolean acceptsDirectory(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(5);
        }
        if (project == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(6);
        }
        return true;
    }

    @RequiresReadLock
    public void persistAttribute(@NotNull Project project, @NotNull VirtualFile fileOrDir, @NotNull String actualLevel) throws IOException {
        if (project == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(7);
        }
        if (fileOrDir == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(8);
        }
        if (actualLevel == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(9);
        }
        ThreadingAssertions.softAssertReadAccess();
        if (JSCorePredefinedLibrariesProvider.getAllJSPredefinedLibraryFiles().contains(fileOrDir)) {
            return;
        }
        super.persistAttribute(project, fileOrDir, (Object)actualLevel);
    }

    public void propertyChanged(@NotNull Project project, @NotNull VirtualFile fileOrDir, @NotNull String level) {
        if (project == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(10);
        }
        if (fileOrDir == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(11);
        }
        if (level == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(12);
        }
        PushedFilePropertiesUpdater.getInstance((Project)project).filePropertiesChanged(fileOrDir, JSLanguageLevelPusher::isIndexedFile);
    }

    private static boolean isIndexedFile(@NotNull VirtualFile child) {
        if (child == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(13);
        }
        if (child.isDirectory()) {
            return false;
        }
        FileType fileType = FileTypeRegistry.getInstance().getFileTypeByFileName(child.getNameSequence());
        return JavaScriptIndex.getFileTypesToIndexJS().contains(fileType);
    }

    public boolean acceptsOrigin(@NotNull Project project, @NotNull IndexableSetOrigin origin2) {
        if (project == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(14);
        }
        if (origin2 == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(15);
        }
        if (origin2 instanceof LibraryOrigin) {
            Set<VirtualFile> files = JSLanguageLevelPusher.getCachedApplicableLibraryFiles(project);
            if (files.isEmpty()) {
                return false;
            }
            return JSLanguageLevelPusher.intersectFiles(files, ((LibraryOrigin)origin2).getClassRoots()) || JSLanguageLevelPusher.intersectFiles(files, ((LibraryOrigin)origin2).getSourceRoots());
        }
        if (origin2 instanceof IndexableSetContributorOrigin) {
            Set<VirtualFile> files = JSLanguageLevelPusher.getCachedApplicableLibraryFiles(project);
            if (files.isEmpty()) {
                return false;
            }
            return JSLanguageLevelPusher.intersectFiles(files, ((IndexableSetContributorOrigin)origin2).getRootsToIndex());
        }
        if (origin2 instanceof PartialAdditionalLibraryIndexableSetOrigin) {
            Set<VirtualFile> files = JSLanguageLevelPusher.getCachedApplicableLibraryFiles(project);
            if (files.isEmpty()) {
                return false;
            }
            return JSLanguageLevelPusher.intersectFiles(files, ((PartialAdditionalLibraryIndexableSetOrigin)origin2).getRootsToIndex());
        }
        return false;
    }

    @NotNull
    private static Set<VirtualFile> getCachedApplicableLibraryFiles(@NotNull Project project) {
        JSLanguageLevelApplicableRootsCache cache;
        if (project == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(16);
        }
        Set<Object> set = (cache = (JSLanguageLevelApplicableRootsCache)ReadAction.compute(() -> {
            if (project.isDisposed()) {
                return null;
            }
            return JSLanguageLevelApplicableRootsCache.getInstance(project);
        })) != null ? cache.getApplicableLibraryFiles() : Set.of();
        if (set == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(17);
        }
        return set;
    }

    private static boolean intersectFiles(Collection<VirtualFile> first, Collection<VirtualFile> second) {
        return ContainerUtil.intersects(first, second);
    }

    @Nullable
    public String getImmediateValueEx(@NotNull IndexableSetOrigin origin2) {
        if (origin2 == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(18);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 18 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/dialects/JSLanguageLevelPusher";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 10: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "misc";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualLevel";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origin";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePropertyKey";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/dialects/JSLanguageLevelPusher";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedApplicableLibraryFiles";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getImmediateValue";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findLevelInMiscXml";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "acceptsDirectory";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "persistAttribute";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "propertyChanged";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isIndexedFile";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "acceptsOrigin";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getCachedApplicableLibraryFiles";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getImmediateValueEx";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 18 -> new IllegalArgumentException(string);
        };
    }

    private record MiscFileInfo(VirtualFile file, long vfsStructureModificationsCount) {
    }

    private record LanguageLevelInfo(String languageLevel, long modificationCount) {
    }
}

