/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.welcomeScreen.toolbox;

import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.gateway.actions.ToolboxDiscovery;
import com.jetbrains.gateway.welcomeScreen.toolbox.ToolboxStatus;
import com.jetbrains.gateway.welcomeScreen.toolbox.ToolboxStatusServiceKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0001\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u000eJ\u0006\u0010\u0010\u001a\u00020\u000eJ\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012J\u0006\u0010\u0014\u001a\u00020\u000eJ\u0006\u0010\u0015\u001a\u00020\u000eJ\b\u0010\u0016\u001a\u00020\u000eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/gateway/welcomeScreen/toolbox/ToolboxStatusService;", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "toolboxStatus", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/jetbrains/gateway/welcomeScreen/toolbox/ToolboxStatus;", "getToolboxStatus", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "rememberAboutInstallationAttempt", "", "rememberToolboxPromoPlaceholderDismissed", "forgetAboutInstallationAttempt", "wasToolboxOpenedViaLink", "", "wasToolboxPromoPlaceholderDismissed", "scheduleUpdateToolboxStatus", "updateToolboxStatusSafe", "updateToolboxStatusUnsafe", "Companion", "intellij.gateway.core"})
public final class ToolboxStatusService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final MutableStateFlow<ToolboxStatus> toolboxStatus;

    public ToolboxStatusService(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
        this.toolboxStatus = StateFlowKt.MutableStateFlow((Object)((Object)ToolboxStatus.NotYetComputed));
    }

    @NotNull
    public final CoroutineScope getCoroutineScope() {
        return this.coroutineScope;
    }

    @NotNull
    public final MutableStateFlow<ToolboxStatus> getToolboxStatus() {
        return this.toolboxStatus;
    }

    public final void rememberAboutInstallationAttempt() {
        PropertiesComponent.getInstance().setValue("toolbox.installation.attempt", true);
    }

    public final void rememberToolboxPromoPlaceholderDismissed() {
        PropertiesComponent.getInstance().setValue("toolbox.promo.placeholder.dismissed", true);
    }

    public final void forgetAboutInstallationAttempt() {
        PropertiesComponent.getInstance().setValue("toolbox.installation.attempt", false);
        PropertiesComponent.getInstance().setValue("toolbox.promo.placeholder.dismissed", false);
    }

    public final boolean wasToolboxOpenedViaLink() {
        boolean registryKeyEnabled = Registry.Companion.is("gateway.ssh.welcome.screen.toolbox.promo.enabled");
        boolean userHadClickedOnOpenToolboxLink = PropertiesComponent.getInstance().getBoolean("toolbox.installation.attempt", false);
        ToolboxStatus[] toolboxStatusArray = new ToolboxStatus[]{ToolboxStatus.UpToDateAndRunning, ToolboxStatus.UpToDateAndNotRunning};
        boolean isUpToDateToolboxInstallationConfirmed = SetsKt.setOf((Object[])toolboxStatusArray).contains(this.toolboxStatus.getValue());
        ToolboxStatusServiceKt.access$getLOG().debug("Previous toolbox opening data: registry key enabled: " + registryKeyEnabled + ", user had clicked on 'open' link: " + userHadClickedOnOpenToolboxLink + ", is up to date toolbox installed: " + isUpToDateToolboxInstallationConfirmed);
        return registryKeyEnabled && userHadClickedOnOpenToolboxLink && isUpToDateToolboxInstallationConfirmed;
    }

    public final boolean wasToolboxPromoPlaceholderDismissed() {
        return PropertiesComponent.getInstance().getBoolean("toolbox.promo.placeholder.dismissed", false);
    }

    public final void scheduleUpdateToolboxStatus() {
        if (!Registry.Companion.is("gateway.ssh.welcome.screen.toolbox.promo.enabled") && !Registry.Companion.is("gateway.welcome.screen.toolbox.promo.enabled")) {
            return;
        }
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ToolboxStatusService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.this$0.updateToolboxStatusSafe();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void updateToolboxStatusSafe() {
        try {
            this.updateToolboxStatusUnsafe();
        }
        catch (IllegalArgumentException exception) {
            ToolboxStatusServiceKt.access$getLOG().warn("Failed to update toolbox status. Unsatisfied requirement: ", (Throwable)exception);
            this.toolboxStatus.setValue((Object)ToolboxStatus.Unsupported);
        }
    }

    private final void updateToolboxStatusUnsafe() {
        ToolboxStatus toolboxStatus;
        BuildNumber installedToolboxBuildNumber = ToolboxDiscovery.INSTANCE.getInstalledBuild$intellij_gateway_core();
        List<ProcessInfo> runningToolboxProcesses = ToolboxDiscovery.INSTANCE.listRunningToolboxProcesses();
        BuildNumber installerVersion = ToolboxDiscovery.INSTANCE.discoverFreshToolboxInstallerNumber();
        ToolboxStatusServiceKt.access$getLOG().debug("Toolbox discovery status: existing toolbox build " + installedToolboxBuildNumber + ", running processes " + runningToolboxProcesses.size() + ",installer version " + installerVersion);
        if (installedToolboxBuildNumber == null && runningToolboxProcesses.isEmpty()) {
            toolboxStatus = ToolboxStatus.NotInstalled;
        } else if (installedToolboxBuildNumber != null && installedToolboxBuildNumber.compareTo(installerVersion) < 0) {
            toolboxStatus = runningToolboxProcesses.isEmpty() ? ToolboxStatus.OutdatedAndNotRunning : ToolboxStatus.OutdatedAndRunning;
        } else if (installedToolboxBuildNumber != null && installedToolboxBuildNumber.compareTo(installerVersion) >= 0) {
            toolboxStatus = runningToolboxProcesses.isEmpty() ? ToolboxStatus.UpToDateAndNotRunning : ToolboxStatus.UpToDateAndRunning;
        } else {
            ToolboxStatusServiceKt.access$getLOG().debug("Toolbox discovery is unsure about installed version.Falling back to `not installed`");
            toolboxStatus = ToolboxStatus.NotInstalled;
        }
        this.toolboxStatus.setValue((Object)toolboxStatus);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/gateway/welcomeScreen/toolbox/ToolboxStatusService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/gateway/welcomeScreen/toolbox/ToolboxStatusService;", "intellij.gateway.core"})
    @SourceDebugExtension(value={"SMAP\nToolboxStatusService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolboxStatusService.kt\ncom/jetbrains/gateway/welcomeScreen/toolbox/ToolboxStatusService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,116:1\n40#2,3:117\n*S KotlinDebug\n*F\n+ 1 ToolboxStatusService.kt\ncom/jetbrains/gateway/welcomeScreen/toolbox/ToolboxStatusService$Companion\n*L\n102#1:117,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ToolboxStatusService getInstance() {
            boolean $i$f$service = false;
            Class<ToolboxStatusService> serviceClass$iv = ToolboxStatusService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (ToolboxStatusService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

