// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package iotiface provides an interface to enable mocking the AWS IoT service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package iotiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/iot"
)

// IoTAPI provides an interface to enable mocking the
// iot.IoT service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// AWS IoT.
//	func myFunc(svc iotiface.IoTAPI) bool {
//	    // Make svc.AcceptCertificateTransfer request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := iot.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockIoTClient struct {
//	    iotiface.IoTAPI
//	}
//	func (m *mockIoTClient) AcceptCertificateTransfer(input *iot.AcceptCertificateTransferInput) (*iot.AcceptCertificateTransferOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockIoTClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type IoTAPI interface {
	AcceptCertificateTransfer(*iot.AcceptCertificateTransferInput) (*iot.AcceptCertificateTransferOutput, error)
	AcceptCertificateTransferWithContext(aws.Context, *iot.AcceptCertificateTransferInput, ...request.Option) (*iot.AcceptCertificateTransferOutput, error)
	AcceptCertificateTransferRequest(*iot.AcceptCertificateTransferInput) (*request.Request, *iot.AcceptCertificateTransferOutput)

	AddThingToBillingGroup(*iot.AddThingToBillingGroupInput) (*iot.AddThingToBillingGroupOutput, error)
	AddThingToBillingGroupWithContext(aws.Context, *iot.AddThingToBillingGroupInput, ...request.Option) (*iot.AddThingToBillingGroupOutput, error)
	AddThingToBillingGroupRequest(*iot.AddThingToBillingGroupInput) (*request.Request, *iot.AddThingToBillingGroupOutput)

	AddThingToThingGroup(*iot.AddThingToThingGroupInput) (*iot.AddThingToThingGroupOutput, error)
	AddThingToThingGroupWithContext(aws.Context, *iot.AddThingToThingGroupInput, ...request.Option) (*iot.AddThingToThingGroupOutput, error)
	AddThingToThingGroupRequest(*iot.AddThingToThingGroupInput) (*request.Request, *iot.AddThingToThingGroupOutput)

	AssociateTargetsWithJob(*iot.AssociateTargetsWithJobInput) (*iot.AssociateTargetsWithJobOutput, error)
	AssociateTargetsWithJobWithContext(aws.Context, *iot.AssociateTargetsWithJobInput, ...request.Option) (*iot.AssociateTargetsWithJobOutput, error)
	AssociateTargetsWithJobRequest(*iot.AssociateTargetsWithJobInput) (*request.Request, *iot.AssociateTargetsWithJobOutput)

	AttachPolicy(*iot.AttachPolicyInput) (*iot.AttachPolicyOutput, error)
	AttachPolicyWithContext(aws.Context, *iot.AttachPolicyInput, ...request.Option) (*iot.AttachPolicyOutput, error)
	AttachPolicyRequest(*iot.AttachPolicyInput) (*request.Request, *iot.AttachPolicyOutput)

	AttachPrincipalPolicy(*iot.AttachPrincipalPolicyInput) (*iot.AttachPrincipalPolicyOutput, error)
	AttachPrincipalPolicyWithContext(aws.Context, *iot.AttachPrincipalPolicyInput, ...request.Option) (*iot.AttachPrincipalPolicyOutput, error)
	AttachPrincipalPolicyRequest(*iot.AttachPrincipalPolicyInput) (*request.Request, *iot.AttachPrincipalPolicyOutput)

	AttachSecurityProfile(*iot.AttachSecurityProfileInput) (*iot.AttachSecurityProfileOutput, error)
	AttachSecurityProfileWithContext(aws.Context, *iot.AttachSecurityProfileInput, ...request.Option) (*iot.AttachSecurityProfileOutput, error)
	AttachSecurityProfileRequest(*iot.AttachSecurityProfileInput) (*request.Request, *iot.AttachSecurityProfileOutput)

	AttachThingPrincipal(*iot.AttachThingPrincipalInput) (*iot.AttachThingPrincipalOutput, error)
	AttachThingPrincipalWithContext(aws.Context, *iot.AttachThingPrincipalInput, ...request.Option) (*iot.AttachThingPrincipalOutput, error)
	AttachThingPrincipalRequest(*iot.AttachThingPrincipalInput) (*request.Request, *iot.AttachThingPrincipalOutput)

	CancelAuditMitigationActionsTask(*iot.CancelAuditMitigationActionsTaskInput) (*iot.CancelAuditMitigationActionsTaskOutput, error)
	CancelAuditMitigationActionsTaskWithContext(aws.Context, *iot.CancelAuditMitigationActionsTaskInput, ...request.Option) (*iot.CancelAuditMitigationActionsTaskOutput, error)
	CancelAuditMitigationActionsTaskRequest(*iot.CancelAuditMitigationActionsTaskInput) (*request.Request, *iot.CancelAuditMitigationActionsTaskOutput)

	CancelAuditTask(*iot.CancelAuditTaskInput) (*iot.CancelAuditTaskOutput, error)
	CancelAuditTaskWithContext(aws.Context, *iot.CancelAuditTaskInput, ...request.Option) (*iot.CancelAuditTaskOutput, error)
	CancelAuditTaskRequest(*iot.CancelAuditTaskInput) (*request.Request, *iot.CancelAuditTaskOutput)

	CancelCertificateTransfer(*iot.CancelCertificateTransferInput) (*iot.CancelCertificateTransferOutput, error)
	CancelCertificateTransferWithContext(aws.Context, *iot.CancelCertificateTransferInput, ...request.Option) (*iot.CancelCertificateTransferOutput, error)
	CancelCertificateTransferRequest(*iot.CancelCertificateTransferInput) (*request.Request, *iot.CancelCertificateTransferOutput)

	CancelDetectMitigationActionsTask(*iot.CancelDetectMitigationActionsTaskInput) (*iot.CancelDetectMitigationActionsTaskOutput, error)
	CancelDetectMitigationActionsTaskWithContext(aws.Context, *iot.CancelDetectMitigationActionsTaskInput, ...request.Option) (*iot.CancelDetectMitigationActionsTaskOutput, error)
	CancelDetectMitigationActionsTaskRequest(*iot.CancelDetectMitigationActionsTaskInput) (*request.Request, *iot.CancelDetectMitigationActionsTaskOutput)

	CancelJob(*iot.CancelJobInput) (*iot.CancelJobOutput, error)
	CancelJobWithContext(aws.Context, *iot.CancelJobInput, ...request.Option) (*iot.CancelJobOutput, error)
	CancelJobRequest(*iot.CancelJobInput) (*request.Request, *iot.CancelJobOutput)

	CancelJobExecution(*iot.CancelJobExecutionInput) (*iot.CancelJobExecutionOutput, error)
	CancelJobExecutionWithContext(aws.Context, *iot.CancelJobExecutionInput, ...request.Option) (*iot.CancelJobExecutionOutput, error)
	CancelJobExecutionRequest(*iot.CancelJobExecutionInput) (*request.Request, *iot.CancelJobExecutionOutput)

	ClearDefaultAuthorizer(*iot.ClearDefaultAuthorizerInput) (*iot.ClearDefaultAuthorizerOutput, error)
	ClearDefaultAuthorizerWithContext(aws.Context, *iot.ClearDefaultAuthorizerInput, ...request.Option) (*iot.ClearDefaultAuthorizerOutput, error)
	ClearDefaultAuthorizerRequest(*iot.ClearDefaultAuthorizerInput) (*request.Request, *iot.ClearDefaultAuthorizerOutput)

	ConfirmTopicRuleDestination(*iot.ConfirmTopicRuleDestinationInput) (*iot.ConfirmTopicRuleDestinationOutput, error)
	ConfirmTopicRuleDestinationWithContext(aws.Context, *iot.ConfirmTopicRuleDestinationInput, ...request.Option) (*iot.ConfirmTopicRuleDestinationOutput, error)
	ConfirmTopicRuleDestinationRequest(*iot.ConfirmTopicRuleDestinationInput) (*request.Request, *iot.ConfirmTopicRuleDestinationOutput)

	CreateAuditSuppression(*iot.CreateAuditSuppressionInput) (*iot.CreateAuditSuppressionOutput, error)
	CreateAuditSuppressionWithContext(aws.Context, *iot.CreateAuditSuppressionInput, ...request.Option) (*iot.CreateAuditSuppressionOutput, error)
	CreateAuditSuppressionRequest(*iot.CreateAuditSuppressionInput) (*request.Request, *iot.CreateAuditSuppressionOutput)

	CreateAuthorizer(*iot.CreateAuthorizerInput) (*iot.CreateAuthorizerOutput, error)
	CreateAuthorizerWithContext(aws.Context, *iot.CreateAuthorizerInput, ...request.Option) (*iot.CreateAuthorizerOutput, error)
	CreateAuthorizerRequest(*iot.CreateAuthorizerInput) (*request.Request, *iot.CreateAuthorizerOutput)

	CreateBillingGroup(*iot.CreateBillingGroupInput) (*iot.CreateBillingGroupOutput, error)
	CreateBillingGroupWithContext(aws.Context, *iot.CreateBillingGroupInput, ...request.Option) (*iot.CreateBillingGroupOutput, error)
	CreateBillingGroupRequest(*iot.CreateBillingGroupInput) (*request.Request, *iot.CreateBillingGroupOutput)

	CreateCertificateFromCsr(*iot.CreateCertificateFromCsrInput) (*iot.CreateCertificateFromCsrOutput, error)
	CreateCertificateFromCsrWithContext(aws.Context, *iot.CreateCertificateFromCsrInput, ...request.Option) (*iot.CreateCertificateFromCsrOutput, error)
	CreateCertificateFromCsrRequest(*iot.CreateCertificateFromCsrInput) (*request.Request, *iot.CreateCertificateFromCsrOutput)

	CreateCertificateProvider(*iot.CreateCertificateProviderInput) (*iot.CreateCertificateProviderOutput, error)
	CreateCertificateProviderWithContext(aws.Context, *iot.CreateCertificateProviderInput, ...request.Option) (*iot.CreateCertificateProviderOutput, error)
	CreateCertificateProviderRequest(*iot.CreateCertificateProviderInput) (*request.Request, *iot.CreateCertificateProviderOutput)

	CreateCustomMetric(*iot.CreateCustomMetricInput) (*iot.CreateCustomMetricOutput, error)
	CreateCustomMetricWithContext(aws.Context, *iot.CreateCustomMetricInput, ...request.Option) (*iot.CreateCustomMetricOutput, error)
	CreateCustomMetricRequest(*iot.CreateCustomMetricInput) (*request.Request, *iot.CreateCustomMetricOutput)

	CreateDimension(*iot.CreateDimensionInput) (*iot.CreateDimensionOutput, error)
	CreateDimensionWithContext(aws.Context, *iot.CreateDimensionInput, ...request.Option) (*iot.CreateDimensionOutput, error)
	CreateDimensionRequest(*iot.CreateDimensionInput) (*request.Request, *iot.CreateDimensionOutput)

	CreateDomainConfiguration(*iot.CreateDomainConfigurationInput) (*iot.CreateDomainConfigurationOutput, error)
	CreateDomainConfigurationWithContext(aws.Context, *iot.CreateDomainConfigurationInput, ...request.Option) (*iot.CreateDomainConfigurationOutput, error)
	CreateDomainConfigurationRequest(*iot.CreateDomainConfigurationInput) (*request.Request, *iot.CreateDomainConfigurationOutput)

	CreateDynamicThingGroup(*iot.CreateDynamicThingGroupInput) (*iot.CreateDynamicThingGroupOutput, error)
	CreateDynamicThingGroupWithContext(aws.Context, *iot.CreateDynamicThingGroupInput, ...request.Option) (*iot.CreateDynamicThingGroupOutput, error)
	CreateDynamicThingGroupRequest(*iot.CreateDynamicThingGroupInput) (*request.Request, *iot.CreateDynamicThingGroupOutput)

	CreateFleetMetric(*iot.CreateFleetMetricInput) (*iot.CreateFleetMetricOutput, error)
	CreateFleetMetricWithContext(aws.Context, *iot.CreateFleetMetricInput, ...request.Option) (*iot.CreateFleetMetricOutput, error)
	CreateFleetMetricRequest(*iot.CreateFleetMetricInput) (*request.Request, *iot.CreateFleetMetricOutput)

	CreateJob(*iot.CreateJobInput) (*iot.CreateJobOutput, error)
	CreateJobWithContext(aws.Context, *iot.CreateJobInput, ...request.Option) (*iot.CreateJobOutput, error)
	CreateJobRequest(*iot.CreateJobInput) (*request.Request, *iot.CreateJobOutput)

	CreateJobTemplate(*iot.CreateJobTemplateInput) (*iot.CreateJobTemplateOutput, error)
	CreateJobTemplateWithContext(aws.Context, *iot.CreateJobTemplateInput, ...request.Option) (*iot.CreateJobTemplateOutput, error)
	CreateJobTemplateRequest(*iot.CreateJobTemplateInput) (*request.Request, *iot.CreateJobTemplateOutput)

	CreateKeysAndCertificate(*iot.CreateKeysAndCertificateInput) (*iot.CreateKeysAndCertificateOutput, error)
	CreateKeysAndCertificateWithContext(aws.Context, *iot.CreateKeysAndCertificateInput, ...request.Option) (*iot.CreateKeysAndCertificateOutput, error)
	CreateKeysAndCertificateRequest(*iot.CreateKeysAndCertificateInput) (*request.Request, *iot.CreateKeysAndCertificateOutput)

	CreateMitigationAction(*iot.CreateMitigationActionInput) (*iot.CreateMitigationActionOutput, error)
	CreateMitigationActionWithContext(aws.Context, *iot.CreateMitigationActionInput, ...request.Option) (*iot.CreateMitigationActionOutput, error)
	CreateMitigationActionRequest(*iot.CreateMitigationActionInput) (*request.Request, *iot.CreateMitigationActionOutput)

	CreateOTAUpdate(*iot.CreateOTAUpdateInput) (*iot.CreateOTAUpdateOutput, error)
	CreateOTAUpdateWithContext(aws.Context, *iot.CreateOTAUpdateInput, ...request.Option) (*iot.CreateOTAUpdateOutput, error)
	CreateOTAUpdateRequest(*iot.CreateOTAUpdateInput) (*request.Request, *iot.CreateOTAUpdateOutput)

	CreatePackage(*iot.CreatePackageInput) (*iot.CreatePackageOutput, error)
	CreatePackageWithContext(aws.Context, *iot.CreatePackageInput, ...request.Option) (*iot.CreatePackageOutput, error)
	CreatePackageRequest(*iot.CreatePackageInput) (*request.Request, *iot.CreatePackageOutput)

	CreatePackageVersion(*iot.CreatePackageVersionInput) (*iot.CreatePackageVersionOutput, error)
	CreatePackageVersionWithContext(aws.Context, *iot.CreatePackageVersionInput, ...request.Option) (*iot.CreatePackageVersionOutput, error)
	CreatePackageVersionRequest(*iot.CreatePackageVersionInput) (*request.Request, *iot.CreatePackageVersionOutput)

	CreatePolicy(*iot.CreatePolicyInput) (*iot.CreatePolicyOutput, error)
	CreatePolicyWithContext(aws.Context, *iot.CreatePolicyInput, ...request.Option) (*iot.CreatePolicyOutput, error)
	CreatePolicyRequest(*iot.CreatePolicyInput) (*request.Request, *iot.CreatePolicyOutput)

	CreatePolicyVersion(*iot.CreatePolicyVersionInput) (*iot.CreatePolicyVersionOutput, error)
	CreatePolicyVersionWithContext(aws.Context, *iot.CreatePolicyVersionInput, ...request.Option) (*iot.CreatePolicyVersionOutput, error)
	CreatePolicyVersionRequest(*iot.CreatePolicyVersionInput) (*request.Request, *iot.CreatePolicyVersionOutput)

	CreateProvisioningClaim(*iot.CreateProvisioningClaimInput) (*iot.CreateProvisioningClaimOutput, error)
	CreateProvisioningClaimWithContext(aws.Context, *iot.CreateProvisioningClaimInput, ...request.Option) (*iot.CreateProvisioningClaimOutput, error)
	CreateProvisioningClaimRequest(*iot.CreateProvisioningClaimInput) (*request.Request, *iot.CreateProvisioningClaimOutput)

	CreateProvisioningTemplate(*iot.CreateProvisioningTemplateInput) (*iot.CreateProvisioningTemplateOutput, error)
	CreateProvisioningTemplateWithContext(aws.Context, *iot.CreateProvisioningTemplateInput, ...request.Option) (*iot.CreateProvisioningTemplateOutput, error)
	CreateProvisioningTemplateRequest(*iot.CreateProvisioningTemplateInput) (*request.Request, *iot.CreateProvisioningTemplateOutput)

	CreateProvisioningTemplateVersion(*iot.CreateProvisioningTemplateVersionInput) (*iot.CreateProvisioningTemplateVersionOutput, error)
	CreateProvisioningTemplateVersionWithContext(aws.Context, *iot.CreateProvisioningTemplateVersionInput, ...request.Option) (*iot.CreateProvisioningTemplateVersionOutput, error)
	CreateProvisioningTemplateVersionRequest(*iot.CreateProvisioningTemplateVersionInput) (*request.Request, *iot.CreateProvisioningTemplateVersionOutput)

	CreateRoleAlias(*iot.CreateRoleAliasInput) (*iot.CreateRoleAliasOutput, error)
	CreateRoleAliasWithContext(aws.Context, *iot.CreateRoleAliasInput, ...request.Option) (*iot.CreateRoleAliasOutput, error)
	CreateRoleAliasRequest(*iot.CreateRoleAliasInput) (*request.Request, *iot.CreateRoleAliasOutput)

	CreateScheduledAudit(*iot.CreateScheduledAuditInput) (*iot.CreateScheduledAuditOutput, error)
	CreateScheduledAuditWithContext(aws.Context, *iot.CreateScheduledAuditInput, ...request.Option) (*iot.CreateScheduledAuditOutput, error)
	CreateScheduledAuditRequest(*iot.CreateScheduledAuditInput) (*request.Request, *iot.CreateScheduledAuditOutput)

	CreateSecurityProfile(*iot.CreateSecurityProfileInput) (*iot.CreateSecurityProfileOutput, error)
	CreateSecurityProfileWithContext(aws.Context, *iot.CreateSecurityProfileInput, ...request.Option) (*iot.CreateSecurityProfileOutput, error)
	CreateSecurityProfileRequest(*iot.CreateSecurityProfileInput) (*request.Request, *iot.CreateSecurityProfileOutput)

	CreateStream(*iot.CreateStreamInput) (*iot.CreateStreamOutput, error)
	CreateStreamWithContext(aws.Context, *iot.CreateStreamInput, ...request.Option) (*iot.CreateStreamOutput, error)
	CreateStreamRequest(*iot.CreateStreamInput) (*request.Request, *iot.CreateStreamOutput)

	CreateThing(*iot.CreateThingInput) (*iot.CreateThingOutput, error)
	CreateThingWithContext(aws.Context, *iot.CreateThingInput, ...request.Option) (*iot.CreateThingOutput, error)
	CreateThingRequest(*iot.CreateThingInput) (*request.Request, *iot.CreateThingOutput)

	CreateThingGroup(*iot.CreateThingGroupInput) (*iot.CreateThingGroupOutput, error)
	CreateThingGroupWithContext(aws.Context, *iot.CreateThingGroupInput, ...request.Option) (*iot.CreateThingGroupOutput, error)
	CreateThingGroupRequest(*iot.CreateThingGroupInput) (*request.Request, *iot.CreateThingGroupOutput)

	CreateThingType(*iot.CreateThingTypeInput) (*iot.CreateThingTypeOutput, error)
	CreateThingTypeWithContext(aws.Context, *iot.CreateThingTypeInput, ...request.Option) (*iot.CreateThingTypeOutput, error)
	CreateThingTypeRequest(*iot.CreateThingTypeInput) (*request.Request, *iot.CreateThingTypeOutput)

	CreateTopicRule(*iot.CreateTopicRuleInput) (*iot.CreateTopicRuleOutput, error)
	CreateTopicRuleWithContext(aws.Context, *iot.CreateTopicRuleInput, ...request.Option) (*iot.CreateTopicRuleOutput, error)
	CreateTopicRuleRequest(*iot.CreateTopicRuleInput) (*request.Request, *iot.CreateTopicRuleOutput)

	CreateTopicRuleDestination(*iot.CreateTopicRuleDestinationInput) (*iot.CreateTopicRuleDestinationOutput, error)
	CreateTopicRuleDestinationWithContext(aws.Context, *iot.CreateTopicRuleDestinationInput, ...request.Option) (*iot.CreateTopicRuleDestinationOutput, error)
	CreateTopicRuleDestinationRequest(*iot.CreateTopicRuleDestinationInput) (*request.Request, *iot.CreateTopicRuleDestinationOutput)

	DeleteAccountAuditConfiguration(*iot.DeleteAccountAuditConfigurationInput) (*iot.DeleteAccountAuditConfigurationOutput, error)
	DeleteAccountAuditConfigurationWithContext(aws.Context, *iot.DeleteAccountAuditConfigurationInput, ...request.Option) (*iot.DeleteAccountAuditConfigurationOutput, error)
	DeleteAccountAuditConfigurationRequest(*iot.DeleteAccountAuditConfigurationInput) (*request.Request, *iot.DeleteAccountAuditConfigurationOutput)

	DeleteAuditSuppression(*iot.DeleteAuditSuppressionInput) (*iot.DeleteAuditSuppressionOutput, error)
	DeleteAuditSuppressionWithContext(aws.Context, *iot.DeleteAuditSuppressionInput, ...request.Option) (*iot.DeleteAuditSuppressionOutput, error)
	DeleteAuditSuppressionRequest(*iot.DeleteAuditSuppressionInput) (*request.Request, *iot.DeleteAuditSuppressionOutput)

	DeleteAuthorizer(*iot.DeleteAuthorizerInput) (*iot.DeleteAuthorizerOutput, error)
	DeleteAuthorizerWithContext(aws.Context, *iot.DeleteAuthorizerInput, ...request.Option) (*iot.DeleteAuthorizerOutput, error)
	DeleteAuthorizerRequest(*iot.DeleteAuthorizerInput) (*request.Request, *iot.DeleteAuthorizerOutput)

	DeleteBillingGroup(*iot.DeleteBillingGroupInput) (*iot.DeleteBillingGroupOutput, error)
	DeleteBillingGroupWithContext(aws.Context, *iot.DeleteBillingGroupInput, ...request.Option) (*iot.DeleteBillingGroupOutput, error)
	DeleteBillingGroupRequest(*iot.DeleteBillingGroupInput) (*request.Request, *iot.DeleteBillingGroupOutput)

	DeleteCACertificate(*iot.DeleteCACertificateInput) (*iot.DeleteCACertificateOutput, error)
	DeleteCACertificateWithContext(aws.Context, *iot.DeleteCACertificateInput, ...request.Option) (*iot.DeleteCACertificateOutput, error)
	DeleteCACertificateRequest(*iot.DeleteCACertificateInput) (*request.Request, *iot.DeleteCACertificateOutput)

	DeleteCertificate(*iot.DeleteCertificateInput) (*iot.DeleteCertificateOutput, error)
	DeleteCertificateWithContext(aws.Context, *iot.DeleteCertificateInput, ...request.Option) (*iot.DeleteCertificateOutput, error)
	DeleteCertificateRequest(*iot.DeleteCertificateInput) (*request.Request, *iot.DeleteCertificateOutput)

	DeleteCertificateProvider(*iot.DeleteCertificateProviderInput) (*iot.DeleteCertificateProviderOutput, error)
	DeleteCertificateProviderWithContext(aws.Context, *iot.DeleteCertificateProviderInput, ...request.Option) (*iot.DeleteCertificateProviderOutput, error)
	DeleteCertificateProviderRequest(*iot.DeleteCertificateProviderInput) (*request.Request, *iot.DeleteCertificateProviderOutput)

	DeleteCustomMetric(*iot.DeleteCustomMetricInput) (*iot.DeleteCustomMetricOutput, error)
	DeleteCustomMetricWithContext(aws.Context, *iot.DeleteCustomMetricInput, ...request.Option) (*iot.DeleteCustomMetricOutput, error)
	DeleteCustomMetricRequest(*iot.DeleteCustomMetricInput) (*request.Request, *iot.DeleteCustomMetricOutput)

	DeleteDimension(*iot.DeleteDimensionInput) (*iot.DeleteDimensionOutput, error)
	DeleteDimensionWithContext(aws.Context, *iot.DeleteDimensionInput, ...request.Option) (*iot.DeleteDimensionOutput, error)
	DeleteDimensionRequest(*iot.DeleteDimensionInput) (*request.Request, *iot.DeleteDimensionOutput)

	DeleteDomainConfiguration(*iot.DeleteDomainConfigurationInput) (*iot.DeleteDomainConfigurationOutput, error)
	DeleteDomainConfigurationWithContext(aws.Context, *iot.DeleteDomainConfigurationInput, ...request.Option) (*iot.DeleteDomainConfigurationOutput, error)
	DeleteDomainConfigurationRequest(*iot.DeleteDomainConfigurationInput) (*request.Request, *iot.DeleteDomainConfigurationOutput)

	DeleteDynamicThingGroup(*iot.DeleteDynamicThingGroupInput) (*iot.DeleteDynamicThingGroupOutput, error)
	DeleteDynamicThingGroupWithContext(aws.Context, *iot.DeleteDynamicThingGroupInput, ...request.Option) (*iot.DeleteDynamicThingGroupOutput, error)
	DeleteDynamicThingGroupRequest(*iot.DeleteDynamicThingGroupInput) (*request.Request, *iot.DeleteDynamicThingGroupOutput)

	DeleteFleetMetric(*iot.DeleteFleetMetricInput) (*iot.DeleteFleetMetricOutput, error)
	DeleteFleetMetricWithContext(aws.Context, *iot.DeleteFleetMetricInput, ...request.Option) (*iot.DeleteFleetMetricOutput, error)
	DeleteFleetMetricRequest(*iot.DeleteFleetMetricInput) (*request.Request, *iot.DeleteFleetMetricOutput)

	DeleteJob(*iot.DeleteJobInput) (*iot.DeleteJobOutput, error)
	DeleteJobWithContext(aws.Context, *iot.DeleteJobInput, ...request.Option) (*iot.DeleteJobOutput, error)
	DeleteJobRequest(*iot.DeleteJobInput) (*request.Request, *iot.DeleteJobOutput)

	DeleteJobExecution(*iot.DeleteJobExecutionInput) (*iot.DeleteJobExecutionOutput, error)
	DeleteJobExecutionWithContext(aws.Context, *iot.DeleteJobExecutionInput, ...request.Option) (*iot.DeleteJobExecutionOutput, error)
	DeleteJobExecutionRequest(*iot.DeleteJobExecutionInput) (*request.Request, *iot.DeleteJobExecutionOutput)

	DeleteJobTemplate(*iot.DeleteJobTemplateInput) (*iot.DeleteJobTemplateOutput, error)
	DeleteJobTemplateWithContext(aws.Context, *iot.DeleteJobTemplateInput, ...request.Option) (*iot.DeleteJobTemplateOutput, error)
	DeleteJobTemplateRequest(*iot.DeleteJobTemplateInput) (*request.Request, *iot.DeleteJobTemplateOutput)

	DeleteMitigationAction(*iot.DeleteMitigationActionInput) (*iot.DeleteMitigationActionOutput, error)
	DeleteMitigationActionWithContext(aws.Context, *iot.DeleteMitigationActionInput, ...request.Option) (*iot.DeleteMitigationActionOutput, error)
	DeleteMitigationActionRequest(*iot.DeleteMitigationActionInput) (*request.Request, *iot.DeleteMitigationActionOutput)

	DeleteOTAUpdate(*iot.DeleteOTAUpdateInput) (*iot.DeleteOTAUpdateOutput, error)
	DeleteOTAUpdateWithContext(aws.Context, *iot.DeleteOTAUpdateInput, ...request.Option) (*iot.DeleteOTAUpdateOutput, error)
	DeleteOTAUpdateRequest(*iot.DeleteOTAUpdateInput) (*request.Request, *iot.DeleteOTAUpdateOutput)

	DeletePackage(*iot.DeletePackageInput) (*iot.DeletePackageOutput, error)
	DeletePackageWithContext(aws.Context, *iot.DeletePackageInput, ...request.Option) (*iot.DeletePackageOutput, error)
	DeletePackageRequest(*iot.DeletePackageInput) (*request.Request, *iot.DeletePackageOutput)

	DeletePackageVersion(*iot.DeletePackageVersionInput) (*iot.DeletePackageVersionOutput, error)
	DeletePackageVersionWithContext(aws.Context, *iot.DeletePackageVersionInput, ...request.Option) (*iot.DeletePackageVersionOutput, error)
	DeletePackageVersionRequest(*iot.DeletePackageVersionInput) (*request.Request, *iot.DeletePackageVersionOutput)

	DeletePolicy(*iot.DeletePolicyInput) (*iot.DeletePolicyOutput, error)
	DeletePolicyWithContext(aws.Context, *iot.DeletePolicyInput, ...request.Option) (*iot.DeletePolicyOutput, error)
	DeletePolicyRequest(*iot.DeletePolicyInput) (*request.Request, *iot.DeletePolicyOutput)

	DeletePolicyVersion(*iot.DeletePolicyVersionInput) (*iot.DeletePolicyVersionOutput, error)
	DeletePolicyVersionWithContext(aws.Context, *iot.DeletePolicyVersionInput, ...request.Option) (*iot.DeletePolicyVersionOutput, error)
	DeletePolicyVersionRequest(*iot.DeletePolicyVersionInput) (*request.Request, *iot.DeletePolicyVersionOutput)

	DeleteProvisioningTemplate(*iot.DeleteProvisioningTemplateInput) (*iot.DeleteProvisioningTemplateOutput, error)
	DeleteProvisioningTemplateWithContext(aws.Context, *iot.DeleteProvisioningTemplateInput, ...request.Option) (*iot.DeleteProvisioningTemplateOutput, error)
	DeleteProvisioningTemplateRequest(*iot.DeleteProvisioningTemplateInput) (*request.Request, *iot.DeleteProvisioningTemplateOutput)

	DeleteProvisioningTemplateVersion(*iot.DeleteProvisioningTemplateVersionInput) (*iot.DeleteProvisioningTemplateVersionOutput, error)
	DeleteProvisioningTemplateVersionWithContext(aws.Context, *iot.DeleteProvisioningTemplateVersionInput, ...request.Option) (*iot.DeleteProvisioningTemplateVersionOutput, error)
	DeleteProvisioningTemplateVersionRequest(*iot.DeleteProvisioningTemplateVersionInput) (*request.Request, *iot.DeleteProvisioningTemplateVersionOutput)

	DeleteRegistrationCode(*iot.DeleteRegistrationCodeInput) (*iot.DeleteRegistrationCodeOutput, error)
	DeleteRegistrationCodeWithContext(aws.Context, *iot.DeleteRegistrationCodeInput, ...request.Option) (*iot.DeleteRegistrationCodeOutput, error)
	DeleteRegistrationCodeRequest(*iot.DeleteRegistrationCodeInput) (*request.Request, *iot.DeleteRegistrationCodeOutput)

	DeleteRoleAlias(*iot.DeleteRoleAliasInput) (*iot.DeleteRoleAliasOutput, error)
	DeleteRoleAliasWithContext(aws.Context, *iot.DeleteRoleAliasInput, ...request.Option) (*iot.DeleteRoleAliasOutput, error)
	DeleteRoleAliasRequest(*iot.DeleteRoleAliasInput) (*request.Request, *iot.DeleteRoleAliasOutput)

	DeleteScheduledAudit(*iot.DeleteScheduledAuditInput) (*iot.DeleteScheduledAuditOutput, error)
	DeleteScheduledAuditWithContext(aws.Context, *iot.DeleteScheduledAuditInput, ...request.Option) (*iot.DeleteScheduledAuditOutput, error)
	DeleteScheduledAuditRequest(*iot.DeleteScheduledAuditInput) (*request.Request, *iot.DeleteScheduledAuditOutput)

	DeleteSecurityProfile(*iot.DeleteSecurityProfileInput) (*iot.DeleteSecurityProfileOutput, error)
	DeleteSecurityProfileWithContext(aws.Context, *iot.DeleteSecurityProfileInput, ...request.Option) (*iot.DeleteSecurityProfileOutput, error)
	DeleteSecurityProfileRequest(*iot.DeleteSecurityProfileInput) (*request.Request, *iot.DeleteSecurityProfileOutput)

	DeleteStream(*iot.DeleteStreamInput) (*iot.DeleteStreamOutput, error)
	DeleteStreamWithContext(aws.Context, *iot.DeleteStreamInput, ...request.Option) (*iot.DeleteStreamOutput, error)
	DeleteStreamRequest(*iot.DeleteStreamInput) (*request.Request, *iot.DeleteStreamOutput)

	DeleteThing(*iot.DeleteThingInput) (*iot.DeleteThingOutput, error)
	DeleteThingWithContext(aws.Context, *iot.DeleteThingInput, ...request.Option) (*iot.DeleteThingOutput, error)
	DeleteThingRequest(*iot.DeleteThingInput) (*request.Request, *iot.DeleteThingOutput)

	DeleteThingGroup(*iot.DeleteThingGroupInput) (*iot.DeleteThingGroupOutput, error)
	DeleteThingGroupWithContext(aws.Context, *iot.DeleteThingGroupInput, ...request.Option) (*iot.DeleteThingGroupOutput, error)
	DeleteThingGroupRequest(*iot.DeleteThingGroupInput) (*request.Request, *iot.DeleteThingGroupOutput)

	DeleteThingType(*iot.DeleteThingTypeInput) (*iot.DeleteThingTypeOutput, error)
	DeleteThingTypeWithContext(aws.Context, *iot.DeleteThingTypeInput, ...request.Option) (*iot.DeleteThingTypeOutput, error)
	DeleteThingTypeRequest(*iot.DeleteThingTypeInput) (*request.Request, *iot.DeleteThingTypeOutput)

	DeleteTopicRule(*iot.DeleteTopicRuleInput) (*iot.DeleteTopicRuleOutput, error)
	DeleteTopicRuleWithContext(aws.Context, *iot.DeleteTopicRuleInput, ...request.Option) (*iot.DeleteTopicRuleOutput, error)
	DeleteTopicRuleRequest(*iot.DeleteTopicRuleInput) (*request.Request, *iot.DeleteTopicRuleOutput)

	DeleteTopicRuleDestination(*iot.DeleteTopicRuleDestinationInput) (*iot.DeleteTopicRuleDestinationOutput, error)
	DeleteTopicRuleDestinationWithContext(aws.Context, *iot.DeleteTopicRuleDestinationInput, ...request.Option) (*iot.DeleteTopicRuleDestinationOutput, error)
	DeleteTopicRuleDestinationRequest(*iot.DeleteTopicRuleDestinationInput) (*request.Request, *iot.DeleteTopicRuleDestinationOutput)

	DeleteV2LoggingLevel(*iot.DeleteV2LoggingLevelInput) (*iot.DeleteV2LoggingLevelOutput, error)
	DeleteV2LoggingLevelWithContext(aws.Context, *iot.DeleteV2LoggingLevelInput, ...request.Option) (*iot.DeleteV2LoggingLevelOutput, error)
	DeleteV2LoggingLevelRequest(*iot.DeleteV2LoggingLevelInput) (*request.Request, *iot.DeleteV2LoggingLevelOutput)

	DeprecateThingType(*iot.DeprecateThingTypeInput) (*iot.DeprecateThingTypeOutput, error)
	DeprecateThingTypeWithContext(aws.Context, *iot.DeprecateThingTypeInput, ...request.Option) (*iot.DeprecateThingTypeOutput, error)
	DeprecateThingTypeRequest(*iot.DeprecateThingTypeInput) (*request.Request, *iot.DeprecateThingTypeOutput)

	DescribeAccountAuditConfiguration(*iot.DescribeAccountAuditConfigurationInput) (*iot.DescribeAccountAuditConfigurationOutput, error)
	DescribeAccountAuditConfigurationWithContext(aws.Context, *iot.DescribeAccountAuditConfigurationInput, ...request.Option) (*iot.DescribeAccountAuditConfigurationOutput, error)
	DescribeAccountAuditConfigurationRequest(*iot.DescribeAccountAuditConfigurationInput) (*request.Request, *iot.DescribeAccountAuditConfigurationOutput)

	DescribeAuditFinding(*iot.DescribeAuditFindingInput) (*iot.DescribeAuditFindingOutput, error)
	DescribeAuditFindingWithContext(aws.Context, *iot.DescribeAuditFindingInput, ...request.Option) (*iot.DescribeAuditFindingOutput, error)
	DescribeAuditFindingRequest(*iot.DescribeAuditFindingInput) (*request.Request, *iot.DescribeAuditFindingOutput)

	DescribeAuditMitigationActionsTask(*iot.DescribeAuditMitigationActionsTaskInput) (*iot.DescribeAuditMitigationActionsTaskOutput, error)
	DescribeAuditMitigationActionsTaskWithContext(aws.Context, *iot.DescribeAuditMitigationActionsTaskInput, ...request.Option) (*iot.DescribeAuditMitigationActionsTaskOutput, error)
	DescribeAuditMitigationActionsTaskRequest(*iot.DescribeAuditMitigationActionsTaskInput) (*request.Request, *iot.DescribeAuditMitigationActionsTaskOutput)

	DescribeAuditSuppression(*iot.DescribeAuditSuppressionInput) (*iot.DescribeAuditSuppressionOutput, error)
	DescribeAuditSuppressionWithContext(aws.Context, *iot.DescribeAuditSuppressionInput, ...request.Option) (*iot.DescribeAuditSuppressionOutput, error)
	DescribeAuditSuppressionRequest(*iot.DescribeAuditSuppressionInput) (*request.Request, *iot.DescribeAuditSuppressionOutput)

	DescribeAuditTask(*iot.DescribeAuditTaskInput) (*iot.DescribeAuditTaskOutput, error)
	DescribeAuditTaskWithContext(aws.Context, *iot.DescribeAuditTaskInput, ...request.Option) (*iot.DescribeAuditTaskOutput, error)
	DescribeAuditTaskRequest(*iot.DescribeAuditTaskInput) (*request.Request, *iot.DescribeAuditTaskOutput)

	DescribeAuthorizer(*iot.DescribeAuthorizerInput) (*iot.DescribeAuthorizerOutput, error)
	DescribeAuthorizerWithContext(aws.Context, *iot.DescribeAuthorizerInput, ...request.Option) (*iot.DescribeAuthorizerOutput, error)
	DescribeAuthorizerRequest(*iot.DescribeAuthorizerInput) (*request.Request, *iot.DescribeAuthorizerOutput)

	DescribeBillingGroup(*iot.DescribeBillingGroupInput) (*iot.DescribeBillingGroupOutput, error)
	DescribeBillingGroupWithContext(aws.Context, *iot.DescribeBillingGroupInput, ...request.Option) (*iot.DescribeBillingGroupOutput, error)
	DescribeBillingGroupRequest(*iot.DescribeBillingGroupInput) (*request.Request, *iot.DescribeBillingGroupOutput)

	DescribeCACertificate(*iot.DescribeCACertificateInput) (*iot.DescribeCACertificateOutput, error)
	DescribeCACertificateWithContext(aws.Context, *iot.DescribeCACertificateInput, ...request.Option) (*iot.DescribeCACertificateOutput, error)
	DescribeCACertificateRequest(*iot.DescribeCACertificateInput) (*request.Request, *iot.DescribeCACertificateOutput)

	DescribeCertificate(*iot.DescribeCertificateInput) (*iot.DescribeCertificateOutput, error)
	DescribeCertificateWithContext(aws.Context, *iot.DescribeCertificateInput, ...request.Option) (*iot.DescribeCertificateOutput, error)
	DescribeCertificateRequest(*iot.DescribeCertificateInput) (*request.Request, *iot.DescribeCertificateOutput)

	DescribeCertificateProvider(*iot.DescribeCertificateProviderInput) (*iot.DescribeCertificateProviderOutput, error)
	DescribeCertificateProviderWithContext(aws.Context, *iot.DescribeCertificateProviderInput, ...request.Option) (*iot.DescribeCertificateProviderOutput, error)
	DescribeCertificateProviderRequest(*iot.DescribeCertificateProviderInput) (*request.Request, *iot.DescribeCertificateProviderOutput)

	DescribeCustomMetric(*iot.DescribeCustomMetricInput) (*iot.DescribeCustomMetricOutput, error)
	DescribeCustomMetricWithContext(aws.Context, *iot.DescribeCustomMetricInput, ...request.Option) (*iot.DescribeCustomMetricOutput, error)
	DescribeCustomMetricRequest(*iot.DescribeCustomMetricInput) (*request.Request, *iot.DescribeCustomMetricOutput)

	DescribeDefaultAuthorizer(*iot.DescribeDefaultAuthorizerInput) (*iot.DescribeDefaultAuthorizerOutput, error)
	DescribeDefaultAuthorizerWithContext(aws.Context, *iot.DescribeDefaultAuthorizerInput, ...request.Option) (*iot.DescribeDefaultAuthorizerOutput, error)
	DescribeDefaultAuthorizerRequest(*iot.DescribeDefaultAuthorizerInput) (*request.Request, *iot.DescribeDefaultAuthorizerOutput)

	DescribeDetectMitigationActionsTask(*iot.DescribeDetectMitigationActionsTaskInput) (*iot.DescribeDetectMitigationActionsTaskOutput, error)
	DescribeDetectMitigationActionsTaskWithContext(aws.Context, *iot.DescribeDetectMitigationActionsTaskInput, ...request.Option) (*iot.DescribeDetectMitigationActionsTaskOutput, error)
	DescribeDetectMitigationActionsTaskRequest(*iot.DescribeDetectMitigationActionsTaskInput) (*request.Request, *iot.DescribeDetectMitigationActionsTaskOutput)

	DescribeDimension(*iot.DescribeDimensionInput) (*iot.DescribeDimensionOutput, error)
	DescribeDimensionWithContext(aws.Context, *iot.DescribeDimensionInput, ...request.Option) (*iot.DescribeDimensionOutput, error)
	DescribeDimensionRequest(*iot.DescribeDimensionInput) (*request.Request, *iot.DescribeDimensionOutput)

	DescribeDomainConfiguration(*iot.DescribeDomainConfigurationInput) (*iot.DescribeDomainConfigurationOutput, error)
	DescribeDomainConfigurationWithContext(aws.Context, *iot.DescribeDomainConfigurationInput, ...request.Option) (*iot.DescribeDomainConfigurationOutput, error)
	DescribeDomainConfigurationRequest(*iot.DescribeDomainConfigurationInput) (*request.Request, *iot.DescribeDomainConfigurationOutput)

	DescribeEndpoint(*iot.DescribeEndpointInput) (*iot.DescribeEndpointOutput, error)
	DescribeEndpointWithContext(aws.Context, *iot.DescribeEndpointInput, ...request.Option) (*iot.DescribeEndpointOutput, error)
	DescribeEndpointRequest(*iot.DescribeEndpointInput) (*request.Request, *iot.DescribeEndpointOutput)

	DescribeEventConfigurations(*iot.DescribeEventConfigurationsInput) (*iot.DescribeEventConfigurationsOutput, error)
	DescribeEventConfigurationsWithContext(aws.Context, *iot.DescribeEventConfigurationsInput, ...request.Option) (*iot.DescribeEventConfigurationsOutput, error)
	DescribeEventConfigurationsRequest(*iot.DescribeEventConfigurationsInput) (*request.Request, *iot.DescribeEventConfigurationsOutput)

	DescribeFleetMetric(*iot.DescribeFleetMetricInput) (*iot.DescribeFleetMetricOutput, error)
	DescribeFleetMetricWithContext(aws.Context, *iot.DescribeFleetMetricInput, ...request.Option) (*iot.DescribeFleetMetricOutput, error)
	DescribeFleetMetricRequest(*iot.DescribeFleetMetricInput) (*request.Request, *iot.DescribeFleetMetricOutput)

	DescribeIndex(*iot.DescribeIndexInput) (*iot.DescribeIndexOutput, error)
	DescribeIndexWithContext(aws.Context, *iot.DescribeIndexInput, ...request.Option) (*iot.DescribeIndexOutput, error)
	DescribeIndexRequest(*iot.DescribeIndexInput) (*request.Request, *iot.DescribeIndexOutput)

	DescribeJob(*iot.DescribeJobInput) (*iot.DescribeJobOutput, error)
	DescribeJobWithContext(aws.Context, *iot.DescribeJobInput, ...request.Option) (*iot.DescribeJobOutput, error)
	DescribeJobRequest(*iot.DescribeJobInput) (*request.Request, *iot.DescribeJobOutput)

	DescribeJobExecution(*iot.DescribeJobExecutionInput) (*iot.DescribeJobExecutionOutput, error)
	DescribeJobExecutionWithContext(aws.Context, *iot.DescribeJobExecutionInput, ...request.Option) (*iot.DescribeJobExecutionOutput, error)
	DescribeJobExecutionRequest(*iot.DescribeJobExecutionInput) (*request.Request, *iot.DescribeJobExecutionOutput)

	DescribeJobTemplate(*iot.DescribeJobTemplateInput) (*iot.DescribeJobTemplateOutput, error)
	DescribeJobTemplateWithContext(aws.Context, *iot.DescribeJobTemplateInput, ...request.Option) (*iot.DescribeJobTemplateOutput, error)
	DescribeJobTemplateRequest(*iot.DescribeJobTemplateInput) (*request.Request, *iot.DescribeJobTemplateOutput)

	DescribeManagedJobTemplate(*iot.DescribeManagedJobTemplateInput) (*iot.DescribeManagedJobTemplateOutput, error)
	DescribeManagedJobTemplateWithContext(aws.Context, *iot.DescribeManagedJobTemplateInput, ...request.Option) (*iot.DescribeManagedJobTemplateOutput, error)
	DescribeManagedJobTemplateRequest(*iot.DescribeManagedJobTemplateInput) (*request.Request, *iot.DescribeManagedJobTemplateOutput)

	DescribeMitigationAction(*iot.DescribeMitigationActionInput) (*iot.DescribeMitigationActionOutput, error)
	DescribeMitigationActionWithContext(aws.Context, *iot.DescribeMitigationActionInput, ...request.Option) (*iot.DescribeMitigationActionOutput, error)
	DescribeMitigationActionRequest(*iot.DescribeMitigationActionInput) (*request.Request, *iot.DescribeMitigationActionOutput)

	DescribeProvisioningTemplate(*iot.DescribeProvisioningTemplateInput) (*iot.DescribeProvisioningTemplateOutput, error)
	DescribeProvisioningTemplateWithContext(aws.Context, *iot.DescribeProvisioningTemplateInput, ...request.Option) (*iot.DescribeProvisioningTemplateOutput, error)
	DescribeProvisioningTemplateRequest(*iot.DescribeProvisioningTemplateInput) (*request.Request, *iot.DescribeProvisioningTemplateOutput)

	DescribeProvisioningTemplateVersion(*iot.DescribeProvisioningTemplateVersionInput) (*iot.DescribeProvisioningTemplateVersionOutput, error)
	DescribeProvisioningTemplateVersionWithContext(aws.Context, *iot.DescribeProvisioningTemplateVersionInput, ...request.Option) (*iot.DescribeProvisioningTemplateVersionOutput, error)
	DescribeProvisioningTemplateVersionRequest(*iot.DescribeProvisioningTemplateVersionInput) (*request.Request, *iot.DescribeProvisioningTemplateVersionOutput)

	DescribeRoleAlias(*iot.DescribeRoleAliasInput) (*iot.DescribeRoleAliasOutput, error)
	DescribeRoleAliasWithContext(aws.Context, *iot.DescribeRoleAliasInput, ...request.Option) (*iot.DescribeRoleAliasOutput, error)
	DescribeRoleAliasRequest(*iot.DescribeRoleAliasInput) (*request.Request, *iot.DescribeRoleAliasOutput)

	DescribeScheduledAudit(*iot.DescribeScheduledAuditInput) (*iot.DescribeScheduledAuditOutput, error)
	DescribeScheduledAuditWithContext(aws.Context, *iot.DescribeScheduledAuditInput, ...request.Option) (*iot.DescribeScheduledAuditOutput, error)
	DescribeScheduledAuditRequest(*iot.DescribeScheduledAuditInput) (*request.Request, *iot.DescribeScheduledAuditOutput)

	DescribeSecurityProfile(*iot.DescribeSecurityProfileInput) (*iot.DescribeSecurityProfileOutput, error)
	DescribeSecurityProfileWithContext(aws.Context, *iot.DescribeSecurityProfileInput, ...request.Option) (*iot.DescribeSecurityProfileOutput, error)
	DescribeSecurityProfileRequest(*iot.DescribeSecurityProfileInput) (*request.Request, *iot.DescribeSecurityProfileOutput)

	DescribeStream(*iot.DescribeStreamInput) (*iot.DescribeStreamOutput, error)
	DescribeStreamWithContext(aws.Context, *iot.DescribeStreamInput, ...request.Option) (*iot.DescribeStreamOutput, error)
	DescribeStreamRequest(*iot.DescribeStreamInput) (*request.Request, *iot.DescribeStreamOutput)

	DescribeThing(*iot.DescribeThingInput) (*iot.DescribeThingOutput, error)
	DescribeThingWithContext(aws.Context, *iot.DescribeThingInput, ...request.Option) (*iot.DescribeThingOutput, error)
	DescribeThingRequest(*iot.DescribeThingInput) (*request.Request, *iot.DescribeThingOutput)

	DescribeThingGroup(*iot.DescribeThingGroupInput) (*iot.DescribeThingGroupOutput, error)
	DescribeThingGroupWithContext(aws.Context, *iot.DescribeThingGroupInput, ...request.Option) (*iot.DescribeThingGroupOutput, error)
	DescribeThingGroupRequest(*iot.DescribeThingGroupInput) (*request.Request, *iot.DescribeThingGroupOutput)

	DescribeThingRegistrationTask(*iot.DescribeThingRegistrationTaskInput) (*iot.DescribeThingRegistrationTaskOutput, error)
	DescribeThingRegistrationTaskWithContext(aws.Context, *iot.DescribeThingRegistrationTaskInput, ...request.Option) (*iot.DescribeThingRegistrationTaskOutput, error)
	DescribeThingRegistrationTaskRequest(*iot.DescribeThingRegistrationTaskInput) (*request.Request, *iot.DescribeThingRegistrationTaskOutput)

	DescribeThingType(*iot.DescribeThingTypeInput) (*iot.DescribeThingTypeOutput, error)
	DescribeThingTypeWithContext(aws.Context, *iot.DescribeThingTypeInput, ...request.Option) (*iot.DescribeThingTypeOutput, error)
	DescribeThingTypeRequest(*iot.DescribeThingTypeInput) (*request.Request, *iot.DescribeThingTypeOutput)

	DetachPolicy(*iot.DetachPolicyInput) (*iot.DetachPolicyOutput, error)
	DetachPolicyWithContext(aws.Context, *iot.DetachPolicyInput, ...request.Option) (*iot.DetachPolicyOutput, error)
	DetachPolicyRequest(*iot.DetachPolicyInput) (*request.Request, *iot.DetachPolicyOutput)

	DetachPrincipalPolicy(*iot.DetachPrincipalPolicyInput) (*iot.DetachPrincipalPolicyOutput, error)
	DetachPrincipalPolicyWithContext(aws.Context, *iot.DetachPrincipalPolicyInput, ...request.Option) (*iot.DetachPrincipalPolicyOutput, error)
	DetachPrincipalPolicyRequest(*iot.DetachPrincipalPolicyInput) (*request.Request, *iot.DetachPrincipalPolicyOutput)

	DetachSecurityProfile(*iot.DetachSecurityProfileInput) (*iot.DetachSecurityProfileOutput, error)
	DetachSecurityProfileWithContext(aws.Context, *iot.DetachSecurityProfileInput, ...request.Option) (*iot.DetachSecurityProfileOutput, error)
	DetachSecurityProfileRequest(*iot.DetachSecurityProfileInput) (*request.Request, *iot.DetachSecurityProfileOutput)

	DetachThingPrincipal(*iot.DetachThingPrincipalInput) (*iot.DetachThingPrincipalOutput, error)
	DetachThingPrincipalWithContext(aws.Context, *iot.DetachThingPrincipalInput, ...request.Option) (*iot.DetachThingPrincipalOutput, error)
	DetachThingPrincipalRequest(*iot.DetachThingPrincipalInput) (*request.Request, *iot.DetachThingPrincipalOutput)

	DisableTopicRule(*iot.DisableTopicRuleInput) (*iot.DisableTopicRuleOutput, error)
	DisableTopicRuleWithContext(aws.Context, *iot.DisableTopicRuleInput, ...request.Option) (*iot.DisableTopicRuleOutput, error)
	DisableTopicRuleRequest(*iot.DisableTopicRuleInput) (*request.Request, *iot.DisableTopicRuleOutput)

	EnableTopicRule(*iot.EnableTopicRuleInput) (*iot.EnableTopicRuleOutput, error)
	EnableTopicRuleWithContext(aws.Context, *iot.EnableTopicRuleInput, ...request.Option) (*iot.EnableTopicRuleOutput, error)
	EnableTopicRuleRequest(*iot.EnableTopicRuleInput) (*request.Request, *iot.EnableTopicRuleOutput)

	GetBehaviorModelTrainingSummaries(*iot.GetBehaviorModelTrainingSummariesInput) (*iot.GetBehaviorModelTrainingSummariesOutput, error)
	GetBehaviorModelTrainingSummariesWithContext(aws.Context, *iot.GetBehaviorModelTrainingSummariesInput, ...request.Option) (*iot.GetBehaviorModelTrainingSummariesOutput, error)
	GetBehaviorModelTrainingSummariesRequest(*iot.GetBehaviorModelTrainingSummariesInput) (*request.Request, *iot.GetBehaviorModelTrainingSummariesOutput)

	GetBehaviorModelTrainingSummariesPages(*iot.GetBehaviorModelTrainingSummariesInput, func(*iot.GetBehaviorModelTrainingSummariesOutput, bool) bool) error
	GetBehaviorModelTrainingSummariesPagesWithContext(aws.Context, *iot.GetBehaviorModelTrainingSummariesInput, func(*iot.GetBehaviorModelTrainingSummariesOutput, bool) bool, ...request.Option) error

	GetBucketsAggregation(*iot.GetBucketsAggregationInput) (*iot.GetBucketsAggregationOutput, error)
	GetBucketsAggregationWithContext(aws.Context, *iot.GetBucketsAggregationInput, ...request.Option) (*iot.GetBucketsAggregationOutput, error)
	GetBucketsAggregationRequest(*iot.GetBucketsAggregationInput) (*request.Request, *iot.GetBucketsAggregationOutput)

	GetCardinality(*iot.GetCardinalityInput) (*iot.GetCardinalityOutput, error)
	GetCardinalityWithContext(aws.Context, *iot.GetCardinalityInput, ...request.Option) (*iot.GetCardinalityOutput, error)
	GetCardinalityRequest(*iot.GetCardinalityInput) (*request.Request, *iot.GetCardinalityOutput)

	GetEffectivePolicies(*iot.GetEffectivePoliciesInput) (*iot.GetEffectivePoliciesOutput, error)
	GetEffectivePoliciesWithContext(aws.Context, *iot.GetEffectivePoliciesInput, ...request.Option) (*iot.GetEffectivePoliciesOutput, error)
	GetEffectivePoliciesRequest(*iot.GetEffectivePoliciesInput) (*request.Request, *iot.GetEffectivePoliciesOutput)

	GetIndexingConfiguration(*iot.GetIndexingConfigurationInput) (*iot.GetIndexingConfigurationOutput, error)
	GetIndexingConfigurationWithContext(aws.Context, *iot.GetIndexingConfigurationInput, ...request.Option) (*iot.GetIndexingConfigurationOutput, error)
	GetIndexingConfigurationRequest(*iot.GetIndexingConfigurationInput) (*request.Request, *iot.GetIndexingConfigurationOutput)

	GetJobDocument(*iot.GetJobDocumentInput) (*iot.GetJobDocumentOutput, error)
	GetJobDocumentWithContext(aws.Context, *iot.GetJobDocumentInput, ...request.Option) (*iot.GetJobDocumentOutput, error)
	GetJobDocumentRequest(*iot.GetJobDocumentInput) (*request.Request, *iot.GetJobDocumentOutput)

	GetLoggingOptions(*iot.GetLoggingOptionsInput) (*iot.GetLoggingOptionsOutput, error)
	GetLoggingOptionsWithContext(aws.Context, *iot.GetLoggingOptionsInput, ...request.Option) (*iot.GetLoggingOptionsOutput, error)
	GetLoggingOptionsRequest(*iot.GetLoggingOptionsInput) (*request.Request, *iot.GetLoggingOptionsOutput)

	GetOTAUpdate(*iot.GetOTAUpdateInput) (*iot.GetOTAUpdateOutput, error)
	GetOTAUpdateWithContext(aws.Context, *iot.GetOTAUpdateInput, ...request.Option) (*iot.GetOTAUpdateOutput, error)
	GetOTAUpdateRequest(*iot.GetOTAUpdateInput) (*request.Request, *iot.GetOTAUpdateOutput)

	GetPackage(*iot.GetPackageInput) (*iot.GetPackageOutput, error)
	GetPackageWithContext(aws.Context, *iot.GetPackageInput, ...request.Option) (*iot.GetPackageOutput, error)
	GetPackageRequest(*iot.GetPackageInput) (*request.Request, *iot.GetPackageOutput)

	GetPackageConfiguration(*iot.GetPackageConfigurationInput) (*iot.GetPackageConfigurationOutput, error)
	GetPackageConfigurationWithContext(aws.Context, *iot.GetPackageConfigurationInput, ...request.Option) (*iot.GetPackageConfigurationOutput, error)
	GetPackageConfigurationRequest(*iot.GetPackageConfigurationInput) (*request.Request, *iot.GetPackageConfigurationOutput)

	GetPackageVersion(*iot.GetPackageVersionInput) (*iot.GetPackageVersionOutput, error)
	GetPackageVersionWithContext(aws.Context, *iot.GetPackageVersionInput, ...request.Option) (*iot.GetPackageVersionOutput, error)
	GetPackageVersionRequest(*iot.GetPackageVersionInput) (*request.Request, *iot.GetPackageVersionOutput)

	GetPercentiles(*iot.GetPercentilesInput) (*iot.GetPercentilesOutput, error)
	GetPercentilesWithContext(aws.Context, *iot.GetPercentilesInput, ...request.Option) (*iot.GetPercentilesOutput, error)
	GetPercentilesRequest(*iot.GetPercentilesInput) (*request.Request, *iot.GetPercentilesOutput)

	GetPolicy(*iot.GetPolicyInput) (*iot.GetPolicyOutput, error)
	GetPolicyWithContext(aws.Context, *iot.GetPolicyInput, ...request.Option) (*iot.GetPolicyOutput, error)
	GetPolicyRequest(*iot.GetPolicyInput) (*request.Request, *iot.GetPolicyOutput)

	GetPolicyVersion(*iot.GetPolicyVersionInput) (*iot.GetPolicyVersionOutput, error)
	GetPolicyVersionWithContext(aws.Context, *iot.GetPolicyVersionInput, ...request.Option) (*iot.GetPolicyVersionOutput, error)
	GetPolicyVersionRequest(*iot.GetPolicyVersionInput) (*request.Request, *iot.GetPolicyVersionOutput)

	GetRegistrationCode(*iot.GetRegistrationCodeInput) (*iot.GetRegistrationCodeOutput, error)
	GetRegistrationCodeWithContext(aws.Context, *iot.GetRegistrationCodeInput, ...request.Option) (*iot.GetRegistrationCodeOutput, error)
	GetRegistrationCodeRequest(*iot.GetRegistrationCodeInput) (*request.Request, *iot.GetRegistrationCodeOutput)

	GetStatistics(*iot.GetStatisticsInput) (*iot.GetStatisticsOutput, error)
	GetStatisticsWithContext(aws.Context, *iot.GetStatisticsInput, ...request.Option) (*iot.GetStatisticsOutput, error)
	GetStatisticsRequest(*iot.GetStatisticsInput) (*request.Request, *iot.GetStatisticsOutput)

	GetTopicRule(*iot.GetTopicRuleInput) (*iot.GetTopicRuleOutput, error)
	GetTopicRuleWithContext(aws.Context, *iot.GetTopicRuleInput, ...request.Option) (*iot.GetTopicRuleOutput, error)
	GetTopicRuleRequest(*iot.GetTopicRuleInput) (*request.Request, *iot.GetTopicRuleOutput)

	GetTopicRuleDestination(*iot.GetTopicRuleDestinationInput) (*iot.GetTopicRuleDestinationOutput, error)
	GetTopicRuleDestinationWithContext(aws.Context, *iot.GetTopicRuleDestinationInput, ...request.Option) (*iot.GetTopicRuleDestinationOutput, error)
	GetTopicRuleDestinationRequest(*iot.GetTopicRuleDestinationInput) (*request.Request, *iot.GetTopicRuleDestinationOutput)

	GetV2LoggingOptions(*iot.GetV2LoggingOptionsInput) (*iot.GetV2LoggingOptionsOutput, error)
	GetV2LoggingOptionsWithContext(aws.Context, *iot.GetV2LoggingOptionsInput, ...request.Option) (*iot.GetV2LoggingOptionsOutput, error)
	GetV2LoggingOptionsRequest(*iot.GetV2LoggingOptionsInput) (*request.Request, *iot.GetV2LoggingOptionsOutput)

	ListActiveViolations(*iot.ListActiveViolationsInput) (*iot.ListActiveViolationsOutput, error)
	ListActiveViolationsWithContext(aws.Context, *iot.ListActiveViolationsInput, ...request.Option) (*iot.ListActiveViolationsOutput, error)
	ListActiveViolationsRequest(*iot.ListActiveViolationsInput) (*request.Request, *iot.ListActiveViolationsOutput)

	ListActiveViolationsPages(*iot.ListActiveViolationsInput, func(*iot.ListActiveViolationsOutput, bool) bool) error
	ListActiveViolationsPagesWithContext(aws.Context, *iot.ListActiveViolationsInput, func(*iot.ListActiveViolationsOutput, bool) bool, ...request.Option) error

	ListAttachedPolicies(*iot.ListAttachedPoliciesInput) (*iot.ListAttachedPoliciesOutput, error)
	ListAttachedPoliciesWithContext(aws.Context, *iot.ListAttachedPoliciesInput, ...request.Option) (*iot.ListAttachedPoliciesOutput, error)
	ListAttachedPoliciesRequest(*iot.ListAttachedPoliciesInput) (*request.Request, *iot.ListAttachedPoliciesOutput)

	ListAttachedPoliciesPages(*iot.ListAttachedPoliciesInput, func(*iot.ListAttachedPoliciesOutput, bool) bool) error
	ListAttachedPoliciesPagesWithContext(aws.Context, *iot.ListAttachedPoliciesInput, func(*iot.ListAttachedPoliciesOutput, bool) bool, ...request.Option) error

	ListAuditFindings(*iot.ListAuditFindingsInput) (*iot.ListAuditFindingsOutput, error)
	ListAuditFindingsWithContext(aws.Context, *iot.ListAuditFindingsInput, ...request.Option) (*iot.ListAuditFindingsOutput, error)
	ListAuditFindingsRequest(*iot.ListAuditFindingsInput) (*request.Request, *iot.ListAuditFindingsOutput)

	ListAuditFindingsPages(*iot.ListAuditFindingsInput, func(*iot.ListAuditFindingsOutput, bool) bool) error
	ListAuditFindingsPagesWithContext(aws.Context, *iot.ListAuditFindingsInput, func(*iot.ListAuditFindingsOutput, bool) bool, ...request.Option) error

	ListAuditMitigationActionsExecutions(*iot.ListAuditMitigationActionsExecutionsInput) (*iot.ListAuditMitigationActionsExecutionsOutput, error)
	ListAuditMitigationActionsExecutionsWithContext(aws.Context, *iot.ListAuditMitigationActionsExecutionsInput, ...request.Option) (*iot.ListAuditMitigationActionsExecutionsOutput, error)
	ListAuditMitigationActionsExecutionsRequest(*iot.ListAuditMitigationActionsExecutionsInput) (*request.Request, *iot.ListAuditMitigationActionsExecutionsOutput)

	ListAuditMitigationActionsExecutionsPages(*iot.ListAuditMitigationActionsExecutionsInput, func(*iot.ListAuditMitigationActionsExecutionsOutput, bool) bool) error
	ListAuditMitigationActionsExecutionsPagesWithContext(aws.Context, *iot.ListAuditMitigationActionsExecutionsInput, func(*iot.ListAuditMitigationActionsExecutionsOutput, bool) bool, ...request.Option) error

	ListAuditMitigationActionsTasks(*iot.ListAuditMitigationActionsTasksInput) (*iot.ListAuditMitigationActionsTasksOutput, error)
	ListAuditMitigationActionsTasksWithContext(aws.Context, *iot.ListAuditMitigationActionsTasksInput, ...request.Option) (*iot.ListAuditMitigationActionsTasksOutput, error)
	ListAuditMitigationActionsTasksRequest(*iot.ListAuditMitigationActionsTasksInput) (*request.Request, *iot.ListAuditMitigationActionsTasksOutput)

	ListAuditMitigationActionsTasksPages(*iot.ListAuditMitigationActionsTasksInput, func(*iot.ListAuditMitigationActionsTasksOutput, bool) bool) error
	ListAuditMitigationActionsTasksPagesWithContext(aws.Context, *iot.ListAuditMitigationActionsTasksInput, func(*iot.ListAuditMitigationActionsTasksOutput, bool) bool, ...request.Option) error

	ListAuditSuppressions(*iot.ListAuditSuppressionsInput) (*iot.ListAuditSuppressionsOutput, error)
	ListAuditSuppressionsWithContext(aws.Context, *iot.ListAuditSuppressionsInput, ...request.Option) (*iot.ListAuditSuppressionsOutput, error)
	ListAuditSuppressionsRequest(*iot.ListAuditSuppressionsInput) (*request.Request, *iot.ListAuditSuppressionsOutput)

	ListAuditSuppressionsPages(*iot.ListAuditSuppressionsInput, func(*iot.ListAuditSuppressionsOutput, bool) bool) error
	ListAuditSuppressionsPagesWithContext(aws.Context, *iot.ListAuditSuppressionsInput, func(*iot.ListAuditSuppressionsOutput, bool) bool, ...request.Option) error

	ListAuditTasks(*iot.ListAuditTasksInput) (*iot.ListAuditTasksOutput, error)
	ListAuditTasksWithContext(aws.Context, *iot.ListAuditTasksInput, ...request.Option) (*iot.ListAuditTasksOutput, error)
	ListAuditTasksRequest(*iot.ListAuditTasksInput) (*request.Request, *iot.ListAuditTasksOutput)

	ListAuditTasksPages(*iot.ListAuditTasksInput, func(*iot.ListAuditTasksOutput, bool) bool) error
	ListAuditTasksPagesWithContext(aws.Context, *iot.ListAuditTasksInput, func(*iot.ListAuditTasksOutput, bool) bool, ...request.Option) error

	ListAuthorizers(*iot.ListAuthorizersInput) (*iot.ListAuthorizersOutput, error)
	ListAuthorizersWithContext(aws.Context, *iot.ListAuthorizersInput, ...request.Option) (*iot.ListAuthorizersOutput, error)
	ListAuthorizersRequest(*iot.ListAuthorizersInput) (*request.Request, *iot.ListAuthorizersOutput)

	ListAuthorizersPages(*iot.ListAuthorizersInput, func(*iot.ListAuthorizersOutput, bool) bool) error
	ListAuthorizersPagesWithContext(aws.Context, *iot.ListAuthorizersInput, func(*iot.ListAuthorizersOutput, bool) bool, ...request.Option) error

	ListBillingGroups(*iot.ListBillingGroupsInput) (*iot.ListBillingGroupsOutput, error)
	ListBillingGroupsWithContext(aws.Context, *iot.ListBillingGroupsInput, ...request.Option) (*iot.ListBillingGroupsOutput, error)
	ListBillingGroupsRequest(*iot.ListBillingGroupsInput) (*request.Request, *iot.ListBillingGroupsOutput)

	ListBillingGroupsPages(*iot.ListBillingGroupsInput, func(*iot.ListBillingGroupsOutput, bool) bool) error
	ListBillingGroupsPagesWithContext(aws.Context, *iot.ListBillingGroupsInput, func(*iot.ListBillingGroupsOutput, bool) bool, ...request.Option) error

	ListCACertificates(*iot.ListCACertificatesInput) (*iot.ListCACertificatesOutput, error)
	ListCACertificatesWithContext(aws.Context, *iot.ListCACertificatesInput, ...request.Option) (*iot.ListCACertificatesOutput, error)
	ListCACertificatesRequest(*iot.ListCACertificatesInput) (*request.Request, *iot.ListCACertificatesOutput)

	ListCACertificatesPages(*iot.ListCACertificatesInput, func(*iot.ListCACertificatesOutput, bool) bool) error
	ListCACertificatesPagesWithContext(aws.Context, *iot.ListCACertificatesInput, func(*iot.ListCACertificatesOutput, bool) bool, ...request.Option) error

	ListCertificateProviders(*iot.ListCertificateProvidersInput) (*iot.ListCertificateProvidersOutput, error)
	ListCertificateProvidersWithContext(aws.Context, *iot.ListCertificateProvidersInput, ...request.Option) (*iot.ListCertificateProvidersOutput, error)
	ListCertificateProvidersRequest(*iot.ListCertificateProvidersInput) (*request.Request, *iot.ListCertificateProvidersOutput)

	ListCertificates(*iot.ListCertificatesInput) (*iot.ListCertificatesOutput, error)
	ListCertificatesWithContext(aws.Context, *iot.ListCertificatesInput, ...request.Option) (*iot.ListCertificatesOutput, error)
	ListCertificatesRequest(*iot.ListCertificatesInput) (*request.Request, *iot.ListCertificatesOutput)

	ListCertificatesPages(*iot.ListCertificatesInput, func(*iot.ListCertificatesOutput, bool) bool) error
	ListCertificatesPagesWithContext(aws.Context, *iot.ListCertificatesInput, func(*iot.ListCertificatesOutput, bool) bool, ...request.Option) error

	ListCertificatesByCA(*iot.ListCertificatesByCAInput) (*iot.ListCertificatesByCAOutput, error)
	ListCertificatesByCAWithContext(aws.Context, *iot.ListCertificatesByCAInput, ...request.Option) (*iot.ListCertificatesByCAOutput, error)
	ListCertificatesByCARequest(*iot.ListCertificatesByCAInput) (*request.Request, *iot.ListCertificatesByCAOutput)

	ListCertificatesByCAPages(*iot.ListCertificatesByCAInput, func(*iot.ListCertificatesByCAOutput, bool) bool) error
	ListCertificatesByCAPagesWithContext(aws.Context, *iot.ListCertificatesByCAInput, func(*iot.ListCertificatesByCAOutput, bool) bool, ...request.Option) error

	ListCustomMetrics(*iot.ListCustomMetricsInput) (*iot.ListCustomMetricsOutput, error)
	ListCustomMetricsWithContext(aws.Context, *iot.ListCustomMetricsInput, ...request.Option) (*iot.ListCustomMetricsOutput, error)
	ListCustomMetricsRequest(*iot.ListCustomMetricsInput) (*request.Request, *iot.ListCustomMetricsOutput)

	ListCustomMetricsPages(*iot.ListCustomMetricsInput, func(*iot.ListCustomMetricsOutput, bool) bool) error
	ListCustomMetricsPagesWithContext(aws.Context, *iot.ListCustomMetricsInput, func(*iot.ListCustomMetricsOutput, bool) bool, ...request.Option) error

	ListDetectMitigationActionsExecutions(*iot.ListDetectMitigationActionsExecutionsInput) (*iot.ListDetectMitigationActionsExecutionsOutput, error)
	ListDetectMitigationActionsExecutionsWithContext(aws.Context, *iot.ListDetectMitigationActionsExecutionsInput, ...request.Option) (*iot.ListDetectMitigationActionsExecutionsOutput, error)
	ListDetectMitigationActionsExecutionsRequest(*iot.ListDetectMitigationActionsExecutionsInput) (*request.Request, *iot.ListDetectMitigationActionsExecutionsOutput)

	ListDetectMitigationActionsExecutionsPages(*iot.ListDetectMitigationActionsExecutionsInput, func(*iot.ListDetectMitigationActionsExecutionsOutput, bool) bool) error
	ListDetectMitigationActionsExecutionsPagesWithContext(aws.Context, *iot.ListDetectMitigationActionsExecutionsInput, func(*iot.ListDetectMitigationActionsExecutionsOutput, bool) bool, ...request.Option) error

	ListDetectMitigationActionsTasks(*iot.ListDetectMitigationActionsTasksInput) (*iot.ListDetectMitigationActionsTasksOutput, error)
	ListDetectMitigationActionsTasksWithContext(aws.Context, *iot.ListDetectMitigationActionsTasksInput, ...request.Option) (*iot.ListDetectMitigationActionsTasksOutput, error)
	ListDetectMitigationActionsTasksRequest(*iot.ListDetectMitigationActionsTasksInput) (*request.Request, *iot.ListDetectMitigationActionsTasksOutput)

	ListDetectMitigationActionsTasksPages(*iot.ListDetectMitigationActionsTasksInput, func(*iot.ListDetectMitigationActionsTasksOutput, bool) bool) error
	ListDetectMitigationActionsTasksPagesWithContext(aws.Context, *iot.ListDetectMitigationActionsTasksInput, func(*iot.ListDetectMitigationActionsTasksOutput, bool) bool, ...request.Option) error

	ListDimensions(*iot.ListDimensionsInput) (*iot.ListDimensionsOutput, error)
	ListDimensionsWithContext(aws.Context, *iot.ListDimensionsInput, ...request.Option) (*iot.ListDimensionsOutput, error)
	ListDimensionsRequest(*iot.ListDimensionsInput) (*request.Request, *iot.ListDimensionsOutput)

	ListDimensionsPages(*iot.ListDimensionsInput, func(*iot.ListDimensionsOutput, bool) bool) error
	ListDimensionsPagesWithContext(aws.Context, *iot.ListDimensionsInput, func(*iot.ListDimensionsOutput, bool) bool, ...request.Option) error

	ListDomainConfigurations(*iot.ListDomainConfigurationsInput) (*iot.ListDomainConfigurationsOutput, error)
	ListDomainConfigurationsWithContext(aws.Context, *iot.ListDomainConfigurationsInput, ...request.Option) (*iot.ListDomainConfigurationsOutput, error)
	ListDomainConfigurationsRequest(*iot.ListDomainConfigurationsInput) (*request.Request, *iot.ListDomainConfigurationsOutput)

	ListDomainConfigurationsPages(*iot.ListDomainConfigurationsInput, func(*iot.ListDomainConfigurationsOutput, bool) bool) error
	ListDomainConfigurationsPagesWithContext(aws.Context, *iot.ListDomainConfigurationsInput, func(*iot.ListDomainConfigurationsOutput, bool) bool, ...request.Option) error

	ListFleetMetrics(*iot.ListFleetMetricsInput) (*iot.ListFleetMetricsOutput, error)
	ListFleetMetricsWithContext(aws.Context, *iot.ListFleetMetricsInput, ...request.Option) (*iot.ListFleetMetricsOutput, error)
	ListFleetMetricsRequest(*iot.ListFleetMetricsInput) (*request.Request, *iot.ListFleetMetricsOutput)

	ListFleetMetricsPages(*iot.ListFleetMetricsInput, func(*iot.ListFleetMetricsOutput, bool) bool) error
	ListFleetMetricsPagesWithContext(aws.Context, *iot.ListFleetMetricsInput, func(*iot.ListFleetMetricsOutput, bool) bool, ...request.Option) error

	ListIndices(*iot.ListIndicesInput) (*iot.ListIndicesOutput, error)
	ListIndicesWithContext(aws.Context, *iot.ListIndicesInput, ...request.Option) (*iot.ListIndicesOutput, error)
	ListIndicesRequest(*iot.ListIndicesInput) (*request.Request, *iot.ListIndicesOutput)

	ListIndicesPages(*iot.ListIndicesInput, func(*iot.ListIndicesOutput, bool) bool) error
	ListIndicesPagesWithContext(aws.Context, *iot.ListIndicesInput, func(*iot.ListIndicesOutput, bool) bool, ...request.Option) error

	ListJobExecutionsForJob(*iot.ListJobExecutionsForJobInput) (*iot.ListJobExecutionsForJobOutput, error)
	ListJobExecutionsForJobWithContext(aws.Context, *iot.ListJobExecutionsForJobInput, ...request.Option) (*iot.ListJobExecutionsForJobOutput, error)
	ListJobExecutionsForJobRequest(*iot.ListJobExecutionsForJobInput) (*request.Request, *iot.ListJobExecutionsForJobOutput)

	ListJobExecutionsForJobPages(*iot.ListJobExecutionsForJobInput, func(*iot.ListJobExecutionsForJobOutput, bool) bool) error
	ListJobExecutionsForJobPagesWithContext(aws.Context, *iot.ListJobExecutionsForJobInput, func(*iot.ListJobExecutionsForJobOutput, bool) bool, ...request.Option) error

	ListJobExecutionsForThing(*iot.ListJobExecutionsForThingInput) (*iot.ListJobExecutionsForThingOutput, error)
	ListJobExecutionsForThingWithContext(aws.Context, *iot.ListJobExecutionsForThingInput, ...request.Option) (*iot.ListJobExecutionsForThingOutput, error)
	ListJobExecutionsForThingRequest(*iot.ListJobExecutionsForThingInput) (*request.Request, *iot.ListJobExecutionsForThingOutput)

	ListJobExecutionsForThingPages(*iot.ListJobExecutionsForThingInput, func(*iot.ListJobExecutionsForThingOutput, bool) bool) error
	ListJobExecutionsForThingPagesWithContext(aws.Context, *iot.ListJobExecutionsForThingInput, func(*iot.ListJobExecutionsForThingOutput, bool) bool, ...request.Option) error

	ListJobTemplates(*iot.ListJobTemplatesInput) (*iot.ListJobTemplatesOutput, error)
	ListJobTemplatesWithContext(aws.Context, *iot.ListJobTemplatesInput, ...request.Option) (*iot.ListJobTemplatesOutput, error)
	ListJobTemplatesRequest(*iot.ListJobTemplatesInput) (*request.Request, *iot.ListJobTemplatesOutput)

	ListJobTemplatesPages(*iot.ListJobTemplatesInput, func(*iot.ListJobTemplatesOutput, bool) bool) error
	ListJobTemplatesPagesWithContext(aws.Context, *iot.ListJobTemplatesInput, func(*iot.ListJobTemplatesOutput, bool) bool, ...request.Option) error

	ListJobs(*iot.ListJobsInput) (*iot.ListJobsOutput, error)
	ListJobsWithContext(aws.Context, *iot.ListJobsInput, ...request.Option) (*iot.ListJobsOutput, error)
	ListJobsRequest(*iot.ListJobsInput) (*request.Request, *iot.ListJobsOutput)

	ListJobsPages(*iot.ListJobsInput, func(*iot.ListJobsOutput, bool) bool) error
	ListJobsPagesWithContext(aws.Context, *iot.ListJobsInput, func(*iot.ListJobsOutput, bool) bool, ...request.Option) error

	ListManagedJobTemplates(*iot.ListManagedJobTemplatesInput) (*iot.ListManagedJobTemplatesOutput, error)
	ListManagedJobTemplatesWithContext(aws.Context, *iot.ListManagedJobTemplatesInput, ...request.Option) (*iot.ListManagedJobTemplatesOutput, error)
	ListManagedJobTemplatesRequest(*iot.ListManagedJobTemplatesInput) (*request.Request, *iot.ListManagedJobTemplatesOutput)

	ListManagedJobTemplatesPages(*iot.ListManagedJobTemplatesInput, func(*iot.ListManagedJobTemplatesOutput, bool) bool) error
	ListManagedJobTemplatesPagesWithContext(aws.Context, *iot.ListManagedJobTemplatesInput, func(*iot.ListManagedJobTemplatesOutput, bool) bool, ...request.Option) error

	ListMetricValues(*iot.ListMetricValuesInput) (*iot.ListMetricValuesOutput, error)
	ListMetricValuesWithContext(aws.Context, *iot.ListMetricValuesInput, ...request.Option) (*iot.ListMetricValuesOutput, error)
	ListMetricValuesRequest(*iot.ListMetricValuesInput) (*request.Request, *iot.ListMetricValuesOutput)

	ListMetricValuesPages(*iot.ListMetricValuesInput, func(*iot.ListMetricValuesOutput, bool) bool) error
	ListMetricValuesPagesWithContext(aws.Context, *iot.ListMetricValuesInput, func(*iot.ListMetricValuesOutput, bool) bool, ...request.Option) error

	ListMitigationActions(*iot.ListMitigationActionsInput) (*iot.ListMitigationActionsOutput, error)
	ListMitigationActionsWithContext(aws.Context, *iot.ListMitigationActionsInput, ...request.Option) (*iot.ListMitigationActionsOutput, error)
	ListMitigationActionsRequest(*iot.ListMitigationActionsInput) (*request.Request, *iot.ListMitigationActionsOutput)

	ListMitigationActionsPages(*iot.ListMitigationActionsInput, func(*iot.ListMitigationActionsOutput, bool) bool) error
	ListMitigationActionsPagesWithContext(aws.Context, *iot.ListMitigationActionsInput, func(*iot.ListMitigationActionsOutput, bool) bool, ...request.Option) error

	ListOTAUpdates(*iot.ListOTAUpdatesInput) (*iot.ListOTAUpdatesOutput, error)
	ListOTAUpdatesWithContext(aws.Context, *iot.ListOTAUpdatesInput, ...request.Option) (*iot.ListOTAUpdatesOutput, error)
	ListOTAUpdatesRequest(*iot.ListOTAUpdatesInput) (*request.Request, *iot.ListOTAUpdatesOutput)

	ListOTAUpdatesPages(*iot.ListOTAUpdatesInput, func(*iot.ListOTAUpdatesOutput, bool) bool) error
	ListOTAUpdatesPagesWithContext(aws.Context, *iot.ListOTAUpdatesInput, func(*iot.ListOTAUpdatesOutput, bool) bool, ...request.Option) error

	ListOutgoingCertificates(*iot.ListOutgoingCertificatesInput) (*iot.ListOutgoingCertificatesOutput, error)
	ListOutgoingCertificatesWithContext(aws.Context, *iot.ListOutgoingCertificatesInput, ...request.Option) (*iot.ListOutgoingCertificatesOutput, error)
	ListOutgoingCertificatesRequest(*iot.ListOutgoingCertificatesInput) (*request.Request, *iot.ListOutgoingCertificatesOutput)

	ListOutgoingCertificatesPages(*iot.ListOutgoingCertificatesInput, func(*iot.ListOutgoingCertificatesOutput, bool) bool) error
	ListOutgoingCertificatesPagesWithContext(aws.Context, *iot.ListOutgoingCertificatesInput, func(*iot.ListOutgoingCertificatesOutput, bool) bool, ...request.Option) error

	ListPackageVersions(*iot.ListPackageVersionsInput) (*iot.ListPackageVersionsOutput, error)
	ListPackageVersionsWithContext(aws.Context, *iot.ListPackageVersionsInput, ...request.Option) (*iot.ListPackageVersionsOutput, error)
	ListPackageVersionsRequest(*iot.ListPackageVersionsInput) (*request.Request, *iot.ListPackageVersionsOutput)

	ListPackageVersionsPages(*iot.ListPackageVersionsInput, func(*iot.ListPackageVersionsOutput, bool) bool) error
	ListPackageVersionsPagesWithContext(aws.Context, *iot.ListPackageVersionsInput, func(*iot.ListPackageVersionsOutput, bool) bool, ...request.Option) error

	ListPackages(*iot.ListPackagesInput) (*iot.ListPackagesOutput, error)
	ListPackagesWithContext(aws.Context, *iot.ListPackagesInput, ...request.Option) (*iot.ListPackagesOutput, error)
	ListPackagesRequest(*iot.ListPackagesInput) (*request.Request, *iot.ListPackagesOutput)

	ListPackagesPages(*iot.ListPackagesInput, func(*iot.ListPackagesOutput, bool) bool) error
	ListPackagesPagesWithContext(aws.Context, *iot.ListPackagesInput, func(*iot.ListPackagesOutput, bool) bool, ...request.Option) error

	ListPolicies(*iot.ListPoliciesInput) (*iot.ListPoliciesOutput, error)
	ListPoliciesWithContext(aws.Context, *iot.ListPoliciesInput, ...request.Option) (*iot.ListPoliciesOutput, error)
	ListPoliciesRequest(*iot.ListPoliciesInput) (*request.Request, *iot.ListPoliciesOutput)

	ListPoliciesPages(*iot.ListPoliciesInput, func(*iot.ListPoliciesOutput, bool) bool) error
	ListPoliciesPagesWithContext(aws.Context, *iot.ListPoliciesInput, func(*iot.ListPoliciesOutput, bool) bool, ...request.Option) error

	ListPolicyPrincipals(*iot.ListPolicyPrincipalsInput) (*iot.ListPolicyPrincipalsOutput, error)
	ListPolicyPrincipalsWithContext(aws.Context, *iot.ListPolicyPrincipalsInput, ...request.Option) (*iot.ListPolicyPrincipalsOutput, error)
	ListPolicyPrincipalsRequest(*iot.ListPolicyPrincipalsInput) (*request.Request, *iot.ListPolicyPrincipalsOutput)

	ListPolicyPrincipalsPages(*iot.ListPolicyPrincipalsInput, func(*iot.ListPolicyPrincipalsOutput, bool) bool) error
	ListPolicyPrincipalsPagesWithContext(aws.Context, *iot.ListPolicyPrincipalsInput, func(*iot.ListPolicyPrincipalsOutput, bool) bool, ...request.Option) error

	ListPolicyVersions(*iot.ListPolicyVersionsInput) (*iot.ListPolicyVersionsOutput, error)
	ListPolicyVersionsWithContext(aws.Context, *iot.ListPolicyVersionsInput, ...request.Option) (*iot.ListPolicyVersionsOutput, error)
	ListPolicyVersionsRequest(*iot.ListPolicyVersionsInput) (*request.Request, *iot.ListPolicyVersionsOutput)

	ListPrincipalPolicies(*iot.ListPrincipalPoliciesInput) (*iot.ListPrincipalPoliciesOutput, error)
	ListPrincipalPoliciesWithContext(aws.Context, *iot.ListPrincipalPoliciesInput, ...request.Option) (*iot.ListPrincipalPoliciesOutput, error)
	ListPrincipalPoliciesRequest(*iot.ListPrincipalPoliciesInput) (*request.Request, *iot.ListPrincipalPoliciesOutput)

	ListPrincipalPoliciesPages(*iot.ListPrincipalPoliciesInput, func(*iot.ListPrincipalPoliciesOutput, bool) bool) error
	ListPrincipalPoliciesPagesWithContext(aws.Context, *iot.ListPrincipalPoliciesInput, func(*iot.ListPrincipalPoliciesOutput, bool) bool, ...request.Option) error

	ListPrincipalThings(*iot.ListPrincipalThingsInput) (*iot.ListPrincipalThingsOutput, error)
	ListPrincipalThingsWithContext(aws.Context, *iot.ListPrincipalThingsInput, ...request.Option) (*iot.ListPrincipalThingsOutput, error)
	ListPrincipalThingsRequest(*iot.ListPrincipalThingsInput) (*request.Request, *iot.ListPrincipalThingsOutput)

	ListPrincipalThingsPages(*iot.ListPrincipalThingsInput, func(*iot.ListPrincipalThingsOutput, bool) bool) error
	ListPrincipalThingsPagesWithContext(aws.Context, *iot.ListPrincipalThingsInput, func(*iot.ListPrincipalThingsOutput, bool) bool, ...request.Option) error

	ListProvisioningTemplateVersions(*iot.ListProvisioningTemplateVersionsInput) (*iot.ListProvisioningTemplateVersionsOutput, error)
	ListProvisioningTemplateVersionsWithContext(aws.Context, *iot.ListProvisioningTemplateVersionsInput, ...request.Option) (*iot.ListProvisioningTemplateVersionsOutput, error)
	ListProvisioningTemplateVersionsRequest(*iot.ListProvisioningTemplateVersionsInput) (*request.Request, *iot.ListProvisioningTemplateVersionsOutput)

	ListProvisioningTemplateVersionsPages(*iot.ListProvisioningTemplateVersionsInput, func(*iot.ListProvisioningTemplateVersionsOutput, bool) bool) error
	ListProvisioningTemplateVersionsPagesWithContext(aws.Context, *iot.ListProvisioningTemplateVersionsInput, func(*iot.ListProvisioningTemplateVersionsOutput, bool) bool, ...request.Option) error

	ListProvisioningTemplates(*iot.ListProvisioningTemplatesInput) (*iot.ListProvisioningTemplatesOutput, error)
	ListProvisioningTemplatesWithContext(aws.Context, *iot.ListProvisioningTemplatesInput, ...request.Option) (*iot.ListProvisioningTemplatesOutput, error)
	ListProvisioningTemplatesRequest(*iot.ListProvisioningTemplatesInput) (*request.Request, *iot.ListProvisioningTemplatesOutput)

	ListProvisioningTemplatesPages(*iot.ListProvisioningTemplatesInput, func(*iot.ListProvisioningTemplatesOutput, bool) bool) error
	ListProvisioningTemplatesPagesWithContext(aws.Context, *iot.ListProvisioningTemplatesInput, func(*iot.ListProvisioningTemplatesOutput, bool) bool, ...request.Option) error

	ListRelatedResourcesForAuditFinding(*iot.ListRelatedResourcesForAuditFindingInput) (*iot.ListRelatedResourcesForAuditFindingOutput, error)
	ListRelatedResourcesForAuditFindingWithContext(aws.Context, *iot.ListRelatedResourcesForAuditFindingInput, ...request.Option) (*iot.ListRelatedResourcesForAuditFindingOutput, error)
	ListRelatedResourcesForAuditFindingRequest(*iot.ListRelatedResourcesForAuditFindingInput) (*request.Request, *iot.ListRelatedResourcesForAuditFindingOutput)

	ListRelatedResourcesForAuditFindingPages(*iot.ListRelatedResourcesForAuditFindingInput, func(*iot.ListRelatedResourcesForAuditFindingOutput, bool) bool) error
	ListRelatedResourcesForAuditFindingPagesWithContext(aws.Context, *iot.ListRelatedResourcesForAuditFindingInput, func(*iot.ListRelatedResourcesForAuditFindingOutput, bool) bool, ...request.Option) error

	ListRoleAliases(*iot.ListRoleAliasesInput) (*iot.ListRoleAliasesOutput, error)
	ListRoleAliasesWithContext(aws.Context, *iot.ListRoleAliasesInput, ...request.Option) (*iot.ListRoleAliasesOutput, error)
	ListRoleAliasesRequest(*iot.ListRoleAliasesInput) (*request.Request, *iot.ListRoleAliasesOutput)

	ListRoleAliasesPages(*iot.ListRoleAliasesInput, func(*iot.ListRoleAliasesOutput, bool) bool) error
	ListRoleAliasesPagesWithContext(aws.Context, *iot.ListRoleAliasesInput, func(*iot.ListRoleAliasesOutput, bool) bool, ...request.Option) error

	ListScheduledAudits(*iot.ListScheduledAuditsInput) (*iot.ListScheduledAuditsOutput, error)
	ListScheduledAuditsWithContext(aws.Context, *iot.ListScheduledAuditsInput, ...request.Option) (*iot.ListScheduledAuditsOutput, error)
	ListScheduledAuditsRequest(*iot.ListScheduledAuditsInput) (*request.Request, *iot.ListScheduledAuditsOutput)

	ListScheduledAuditsPages(*iot.ListScheduledAuditsInput, func(*iot.ListScheduledAuditsOutput, bool) bool) error
	ListScheduledAuditsPagesWithContext(aws.Context, *iot.ListScheduledAuditsInput, func(*iot.ListScheduledAuditsOutput, bool) bool, ...request.Option) error

	ListSecurityProfiles(*iot.ListSecurityProfilesInput) (*iot.ListSecurityProfilesOutput, error)
	ListSecurityProfilesWithContext(aws.Context, *iot.ListSecurityProfilesInput, ...request.Option) (*iot.ListSecurityProfilesOutput, error)
	ListSecurityProfilesRequest(*iot.ListSecurityProfilesInput) (*request.Request, *iot.ListSecurityProfilesOutput)

	ListSecurityProfilesPages(*iot.ListSecurityProfilesInput, func(*iot.ListSecurityProfilesOutput, bool) bool) error
	ListSecurityProfilesPagesWithContext(aws.Context, *iot.ListSecurityProfilesInput, func(*iot.ListSecurityProfilesOutput, bool) bool, ...request.Option) error

	ListSecurityProfilesForTarget(*iot.ListSecurityProfilesForTargetInput) (*iot.ListSecurityProfilesForTargetOutput, error)
	ListSecurityProfilesForTargetWithContext(aws.Context, *iot.ListSecurityProfilesForTargetInput, ...request.Option) (*iot.ListSecurityProfilesForTargetOutput, error)
	ListSecurityProfilesForTargetRequest(*iot.ListSecurityProfilesForTargetInput) (*request.Request, *iot.ListSecurityProfilesForTargetOutput)

	ListSecurityProfilesForTargetPages(*iot.ListSecurityProfilesForTargetInput, func(*iot.ListSecurityProfilesForTargetOutput, bool) bool) error
	ListSecurityProfilesForTargetPagesWithContext(aws.Context, *iot.ListSecurityProfilesForTargetInput, func(*iot.ListSecurityProfilesForTargetOutput, bool) bool, ...request.Option) error

	ListStreams(*iot.ListStreamsInput) (*iot.ListStreamsOutput, error)
	ListStreamsWithContext(aws.Context, *iot.ListStreamsInput, ...request.Option) (*iot.ListStreamsOutput, error)
	ListStreamsRequest(*iot.ListStreamsInput) (*request.Request, *iot.ListStreamsOutput)

	ListStreamsPages(*iot.ListStreamsInput, func(*iot.ListStreamsOutput, bool) bool) error
	ListStreamsPagesWithContext(aws.Context, *iot.ListStreamsInput, func(*iot.ListStreamsOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*iot.ListTagsForResourceInput) (*iot.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *iot.ListTagsForResourceInput, ...request.Option) (*iot.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*iot.ListTagsForResourceInput) (*request.Request, *iot.ListTagsForResourceOutput)

	ListTagsForResourcePages(*iot.ListTagsForResourceInput, func(*iot.ListTagsForResourceOutput, bool) bool) error
	ListTagsForResourcePagesWithContext(aws.Context, *iot.ListTagsForResourceInput, func(*iot.ListTagsForResourceOutput, bool) bool, ...request.Option) error

	ListTargetsForPolicy(*iot.ListTargetsForPolicyInput) (*iot.ListTargetsForPolicyOutput, error)
	ListTargetsForPolicyWithContext(aws.Context, *iot.ListTargetsForPolicyInput, ...request.Option) (*iot.ListTargetsForPolicyOutput, error)
	ListTargetsForPolicyRequest(*iot.ListTargetsForPolicyInput) (*request.Request, *iot.ListTargetsForPolicyOutput)

	ListTargetsForPolicyPages(*iot.ListTargetsForPolicyInput, func(*iot.ListTargetsForPolicyOutput, bool) bool) error
	ListTargetsForPolicyPagesWithContext(aws.Context, *iot.ListTargetsForPolicyInput, func(*iot.ListTargetsForPolicyOutput, bool) bool, ...request.Option) error

	ListTargetsForSecurityProfile(*iot.ListTargetsForSecurityProfileInput) (*iot.ListTargetsForSecurityProfileOutput, error)
	ListTargetsForSecurityProfileWithContext(aws.Context, *iot.ListTargetsForSecurityProfileInput, ...request.Option) (*iot.ListTargetsForSecurityProfileOutput, error)
	ListTargetsForSecurityProfileRequest(*iot.ListTargetsForSecurityProfileInput) (*request.Request, *iot.ListTargetsForSecurityProfileOutput)

	ListTargetsForSecurityProfilePages(*iot.ListTargetsForSecurityProfileInput, func(*iot.ListTargetsForSecurityProfileOutput, bool) bool) error
	ListTargetsForSecurityProfilePagesWithContext(aws.Context, *iot.ListTargetsForSecurityProfileInput, func(*iot.ListTargetsForSecurityProfileOutput, bool) bool, ...request.Option) error

	ListThingGroups(*iot.ListThingGroupsInput) (*iot.ListThingGroupsOutput, error)
	ListThingGroupsWithContext(aws.Context, *iot.ListThingGroupsInput, ...request.Option) (*iot.ListThingGroupsOutput, error)
	ListThingGroupsRequest(*iot.ListThingGroupsInput) (*request.Request, *iot.ListThingGroupsOutput)

	ListThingGroupsPages(*iot.ListThingGroupsInput, func(*iot.ListThingGroupsOutput, bool) bool) error
	ListThingGroupsPagesWithContext(aws.Context, *iot.ListThingGroupsInput, func(*iot.ListThingGroupsOutput, bool) bool, ...request.Option) error

	ListThingGroupsForThing(*iot.ListThingGroupsForThingInput) (*iot.ListThingGroupsForThingOutput, error)
	ListThingGroupsForThingWithContext(aws.Context, *iot.ListThingGroupsForThingInput, ...request.Option) (*iot.ListThingGroupsForThingOutput, error)
	ListThingGroupsForThingRequest(*iot.ListThingGroupsForThingInput) (*request.Request, *iot.ListThingGroupsForThingOutput)

	ListThingGroupsForThingPages(*iot.ListThingGroupsForThingInput, func(*iot.ListThingGroupsForThingOutput, bool) bool) error
	ListThingGroupsForThingPagesWithContext(aws.Context, *iot.ListThingGroupsForThingInput, func(*iot.ListThingGroupsForThingOutput, bool) bool, ...request.Option) error

	ListThingPrincipals(*iot.ListThingPrincipalsInput) (*iot.ListThingPrincipalsOutput, error)
	ListThingPrincipalsWithContext(aws.Context, *iot.ListThingPrincipalsInput, ...request.Option) (*iot.ListThingPrincipalsOutput, error)
	ListThingPrincipalsRequest(*iot.ListThingPrincipalsInput) (*request.Request, *iot.ListThingPrincipalsOutput)

	ListThingPrincipalsPages(*iot.ListThingPrincipalsInput, func(*iot.ListThingPrincipalsOutput, bool) bool) error
	ListThingPrincipalsPagesWithContext(aws.Context, *iot.ListThingPrincipalsInput, func(*iot.ListThingPrincipalsOutput, bool) bool, ...request.Option) error

	ListThingRegistrationTaskReports(*iot.ListThingRegistrationTaskReportsInput) (*iot.ListThingRegistrationTaskReportsOutput, error)
	ListThingRegistrationTaskReportsWithContext(aws.Context, *iot.ListThingRegistrationTaskReportsInput, ...request.Option) (*iot.ListThingRegistrationTaskReportsOutput, error)
	ListThingRegistrationTaskReportsRequest(*iot.ListThingRegistrationTaskReportsInput) (*request.Request, *iot.ListThingRegistrationTaskReportsOutput)

	ListThingRegistrationTaskReportsPages(*iot.ListThingRegistrationTaskReportsInput, func(*iot.ListThingRegistrationTaskReportsOutput, bool) bool) error
	ListThingRegistrationTaskReportsPagesWithContext(aws.Context, *iot.ListThingRegistrationTaskReportsInput, func(*iot.ListThingRegistrationTaskReportsOutput, bool) bool, ...request.Option) error

	ListThingRegistrationTasks(*iot.ListThingRegistrationTasksInput) (*iot.ListThingRegistrationTasksOutput, error)
	ListThingRegistrationTasksWithContext(aws.Context, *iot.ListThingRegistrationTasksInput, ...request.Option) (*iot.ListThingRegistrationTasksOutput, error)
	ListThingRegistrationTasksRequest(*iot.ListThingRegistrationTasksInput) (*request.Request, *iot.ListThingRegistrationTasksOutput)

	ListThingRegistrationTasksPages(*iot.ListThingRegistrationTasksInput, func(*iot.ListThingRegistrationTasksOutput, bool) bool) error
	ListThingRegistrationTasksPagesWithContext(aws.Context, *iot.ListThingRegistrationTasksInput, func(*iot.ListThingRegistrationTasksOutput, bool) bool, ...request.Option) error

	ListThingTypes(*iot.ListThingTypesInput) (*iot.ListThingTypesOutput, error)
	ListThingTypesWithContext(aws.Context, *iot.ListThingTypesInput, ...request.Option) (*iot.ListThingTypesOutput, error)
	ListThingTypesRequest(*iot.ListThingTypesInput) (*request.Request, *iot.ListThingTypesOutput)

	ListThingTypesPages(*iot.ListThingTypesInput, func(*iot.ListThingTypesOutput, bool) bool) error
	ListThingTypesPagesWithContext(aws.Context, *iot.ListThingTypesInput, func(*iot.ListThingTypesOutput, bool) bool, ...request.Option) error

	ListThings(*iot.ListThingsInput) (*iot.ListThingsOutput, error)
	ListThingsWithContext(aws.Context, *iot.ListThingsInput, ...request.Option) (*iot.ListThingsOutput, error)
	ListThingsRequest(*iot.ListThingsInput) (*request.Request, *iot.ListThingsOutput)

	ListThingsPages(*iot.ListThingsInput, func(*iot.ListThingsOutput, bool) bool) error
	ListThingsPagesWithContext(aws.Context, *iot.ListThingsInput, func(*iot.ListThingsOutput, bool) bool, ...request.Option) error

	ListThingsInBillingGroup(*iot.ListThingsInBillingGroupInput) (*iot.ListThingsInBillingGroupOutput, error)
	ListThingsInBillingGroupWithContext(aws.Context, *iot.ListThingsInBillingGroupInput, ...request.Option) (*iot.ListThingsInBillingGroupOutput, error)
	ListThingsInBillingGroupRequest(*iot.ListThingsInBillingGroupInput) (*request.Request, *iot.ListThingsInBillingGroupOutput)

	ListThingsInBillingGroupPages(*iot.ListThingsInBillingGroupInput, func(*iot.ListThingsInBillingGroupOutput, bool) bool) error
	ListThingsInBillingGroupPagesWithContext(aws.Context, *iot.ListThingsInBillingGroupInput, func(*iot.ListThingsInBillingGroupOutput, bool) bool, ...request.Option) error

	ListThingsInThingGroup(*iot.ListThingsInThingGroupInput) (*iot.ListThingsInThingGroupOutput, error)
	ListThingsInThingGroupWithContext(aws.Context, *iot.ListThingsInThingGroupInput, ...request.Option) (*iot.ListThingsInThingGroupOutput, error)
	ListThingsInThingGroupRequest(*iot.ListThingsInThingGroupInput) (*request.Request, *iot.ListThingsInThingGroupOutput)

	ListThingsInThingGroupPages(*iot.ListThingsInThingGroupInput, func(*iot.ListThingsInThingGroupOutput, bool) bool) error
	ListThingsInThingGroupPagesWithContext(aws.Context, *iot.ListThingsInThingGroupInput, func(*iot.ListThingsInThingGroupOutput, bool) bool, ...request.Option) error

	ListTopicRuleDestinations(*iot.ListTopicRuleDestinationsInput) (*iot.ListTopicRuleDestinationsOutput, error)
	ListTopicRuleDestinationsWithContext(aws.Context, *iot.ListTopicRuleDestinationsInput, ...request.Option) (*iot.ListTopicRuleDestinationsOutput, error)
	ListTopicRuleDestinationsRequest(*iot.ListTopicRuleDestinationsInput) (*request.Request, *iot.ListTopicRuleDestinationsOutput)

	ListTopicRuleDestinationsPages(*iot.ListTopicRuleDestinationsInput, func(*iot.ListTopicRuleDestinationsOutput, bool) bool) error
	ListTopicRuleDestinationsPagesWithContext(aws.Context, *iot.ListTopicRuleDestinationsInput, func(*iot.ListTopicRuleDestinationsOutput, bool) bool, ...request.Option) error

	ListTopicRules(*iot.ListTopicRulesInput) (*iot.ListTopicRulesOutput, error)
	ListTopicRulesWithContext(aws.Context, *iot.ListTopicRulesInput, ...request.Option) (*iot.ListTopicRulesOutput, error)
	ListTopicRulesRequest(*iot.ListTopicRulesInput) (*request.Request, *iot.ListTopicRulesOutput)

	ListTopicRulesPages(*iot.ListTopicRulesInput, func(*iot.ListTopicRulesOutput, bool) bool) error
	ListTopicRulesPagesWithContext(aws.Context, *iot.ListTopicRulesInput, func(*iot.ListTopicRulesOutput, bool) bool, ...request.Option) error

	ListV2LoggingLevels(*iot.ListV2LoggingLevelsInput) (*iot.ListV2LoggingLevelsOutput, error)
	ListV2LoggingLevelsWithContext(aws.Context, *iot.ListV2LoggingLevelsInput, ...request.Option) (*iot.ListV2LoggingLevelsOutput, error)
	ListV2LoggingLevelsRequest(*iot.ListV2LoggingLevelsInput) (*request.Request, *iot.ListV2LoggingLevelsOutput)

	ListV2LoggingLevelsPages(*iot.ListV2LoggingLevelsInput, func(*iot.ListV2LoggingLevelsOutput, bool) bool) error
	ListV2LoggingLevelsPagesWithContext(aws.Context, *iot.ListV2LoggingLevelsInput, func(*iot.ListV2LoggingLevelsOutput, bool) bool, ...request.Option) error

	ListViolationEvents(*iot.ListViolationEventsInput) (*iot.ListViolationEventsOutput, error)
	ListViolationEventsWithContext(aws.Context, *iot.ListViolationEventsInput, ...request.Option) (*iot.ListViolationEventsOutput, error)
	ListViolationEventsRequest(*iot.ListViolationEventsInput) (*request.Request, *iot.ListViolationEventsOutput)

	ListViolationEventsPages(*iot.ListViolationEventsInput, func(*iot.ListViolationEventsOutput, bool) bool) error
	ListViolationEventsPagesWithContext(aws.Context, *iot.ListViolationEventsInput, func(*iot.ListViolationEventsOutput, bool) bool, ...request.Option) error

	PutVerificationStateOnViolation(*iot.PutVerificationStateOnViolationInput) (*iot.PutVerificationStateOnViolationOutput, error)
	PutVerificationStateOnViolationWithContext(aws.Context, *iot.PutVerificationStateOnViolationInput, ...request.Option) (*iot.PutVerificationStateOnViolationOutput, error)
	PutVerificationStateOnViolationRequest(*iot.PutVerificationStateOnViolationInput) (*request.Request, *iot.PutVerificationStateOnViolationOutput)

	RegisterCACertificate(*iot.RegisterCACertificateInput) (*iot.RegisterCACertificateOutput, error)
	RegisterCACertificateWithContext(aws.Context, *iot.RegisterCACertificateInput, ...request.Option) (*iot.RegisterCACertificateOutput, error)
	RegisterCACertificateRequest(*iot.RegisterCACertificateInput) (*request.Request, *iot.RegisterCACertificateOutput)

	RegisterCertificate(*iot.RegisterCertificateInput) (*iot.RegisterCertificateOutput, error)
	RegisterCertificateWithContext(aws.Context, *iot.RegisterCertificateInput, ...request.Option) (*iot.RegisterCertificateOutput, error)
	RegisterCertificateRequest(*iot.RegisterCertificateInput) (*request.Request, *iot.RegisterCertificateOutput)

	RegisterCertificateWithoutCA(*iot.RegisterCertificateWithoutCAInput) (*iot.RegisterCertificateWithoutCAOutput, error)
	RegisterCertificateWithoutCAWithContext(aws.Context, *iot.RegisterCertificateWithoutCAInput, ...request.Option) (*iot.RegisterCertificateWithoutCAOutput, error)
	RegisterCertificateWithoutCARequest(*iot.RegisterCertificateWithoutCAInput) (*request.Request, *iot.RegisterCertificateWithoutCAOutput)

	RegisterThing(*iot.RegisterThingInput) (*iot.RegisterThingOutput, error)
	RegisterThingWithContext(aws.Context, *iot.RegisterThingInput, ...request.Option) (*iot.RegisterThingOutput, error)
	RegisterThingRequest(*iot.RegisterThingInput) (*request.Request, *iot.RegisterThingOutput)

	RejectCertificateTransfer(*iot.RejectCertificateTransferInput) (*iot.RejectCertificateTransferOutput, error)
	RejectCertificateTransferWithContext(aws.Context, *iot.RejectCertificateTransferInput, ...request.Option) (*iot.RejectCertificateTransferOutput, error)
	RejectCertificateTransferRequest(*iot.RejectCertificateTransferInput) (*request.Request, *iot.RejectCertificateTransferOutput)

	RemoveThingFromBillingGroup(*iot.RemoveThingFromBillingGroupInput) (*iot.RemoveThingFromBillingGroupOutput, error)
	RemoveThingFromBillingGroupWithContext(aws.Context, *iot.RemoveThingFromBillingGroupInput, ...request.Option) (*iot.RemoveThingFromBillingGroupOutput, error)
	RemoveThingFromBillingGroupRequest(*iot.RemoveThingFromBillingGroupInput) (*request.Request, *iot.RemoveThingFromBillingGroupOutput)

	RemoveThingFromThingGroup(*iot.RemoveThingFromThingGroupInput) (*iot.RemoveThingFromThingGroupOutput, error)
	RemoveThingFromThingGroupWithContext(aws.Context, *iot.RemoveThingFromThingGroupInput, ...request.Option) (*iot.RemoveThingFromThingGroupOutput, error)
	RemoveThingFromThingGroupRequest(*iot.RemoveThingFromThingGroupInput) (*request.Request, *iot.RemoveThingFromThingGroupOutput)

	ReplaceTopicRule(*iot.ReplaceTopicRuleInput) (*iot.ReplaceTopicRuleOutput, error)
	ReplaceTopicRuleWithContext(aws.Context, *iot.ReplaceTopicRuleInput, ...request.Option) (*iot.ReplaceTopicRuleOutput, error)
	ReplaceTopicRuleRequest(*iot.ReplaceTopicRuleInput) (*request.Request, *iot.ReplaceTopicRuleOutput)

	SearchIndex(*iot.SearchIndexInput) (*iot.SearchIndexOutput, error)
	SearchIndexWithContext(aws.Context, *iot.SearchIndexInput, ...request.Option) (*iot.SearchIndexOutput, error)
	SearchIndexRequest(*iot.SearchIndexInput) (*request.Request, *iot.SearchIndexOutput)

	SetDefaultAuthorizer(*iot.SetDefaultAuthorizerInput) (*iot.SetDefaultAuthorizerOutput, error)
	SetDefaultAuthorizerWithContext(aws.Context, *iot.SetDefaultAuthorizerInput, ...request.Option) (*iot.SetDefaultAuthorizerOutput, error)
	SetDefaultAuthorizerRequest(*iot.SetDefaultAuthorizerInput) (*request.Request, *iot.SetDefaultAuthorizerOutput)

	SetDefaultPolicyVersion(*iot.SetDefaultPolicyVersionInput) (*iot.SetDefaultPolicyVersionOutput, error)
	SetDefaultPolicyVersionWithContext(aws.Context, *iot.SetDefaultPolicyVersionInput, ...request.Option) (*iot.SetDefaultPolicyVersionOutput, error)
	SetDefaultPolicyVersionRequest(*iot.SetDefaultPolicyVersionInput) (*request.Request, *iot.SetDefaultPolicyVersionOutput)

	SetLoggingOptions(*iot.SetLoggingOptionsInput) (*iot.SetLoggingOptionsOutput, error)
	SetLoggingOptionsWithContext(aws.Context, *iot.SetLoggingOptionsInput, ...request.Option) (*iot.SetLoggingOptionsOutput, error)
	SetLoggingOptionsRequest(*iot.SetLoggingOptionsInput) (*request.Request, *iot.SetLoggingOptionsOutput)

	SetV2LoggingLevel(*iot.SetV2LoggingLevelInput) (*iot.SetV2LoggingLevelOutput, error)
	SetV2LoggingLevelWithContext(aws.Context, *iot.SetV2LoggingLevelInput, ...request.Option) (*iot.SetV2LoggingLevelOutput, error)
	SetV2LoggingLevelRequest(*iot.SetV2LoggingLevelInput) (*request.Request, *iot.SetV2LoggingLevelOutput)

	SetV2LoggingOptions(*iot.SetV2LoggingOptionsInput) (*iot.SetV2LoggingOptionsOutput, error)
	SetV2LoggingOptionsWithContext(aws.Context, *iot.SetV2LoggingOptionsInput, ...request.Option) (*iot.SetV2LoggingOptionsOutput, error)
	SetV2LoggingOptionsRequest(*iot.SetV2LoggingOptionsInput) (*request.Request, *iot.SetV2LoggingOptionsOutput)

	StartAuditMitigationActionsTask(*iot.StartAuditMitigationActionsTaskInput) (*iot.StartAuditMitigationActionsTaskOutput, error)
	StartAuditMitigationActionsTaskWithContext(aws.Context, *iot.StartAuditMitigationActionsTaskInput, ...request.Option) (*iot.StartAuditMitigationActionsTaskOutput, error)
	StartAuditMitigationActionsTaskRequest(*iot.StartAuditMitigationActionsTaskInput) (*request.Request, *iot.StartAuditMitigationActionsTaskOutput)

	StartDetectMitigationActionsTask(*iot.StartDetectMitigationActionsTaskInput) (*iot.StartDetectMitigationActionsTaskOutput, error)
	StartDetectMitigationActionsTaskWithContext(aws.Context, *iot.StartDetectMitigationActionsTaskInput, ...request.Option) (*iot.StartDetectMitigationActionsTaskOutput, error)
	StartDetectMitigationActionsTaskRequest(*iot.StartDetectMitigationActionsTaskInput) (*request.Request, *iot.StartDetectMitigationActionsTaskOutput)

	StartOnDemandAuditTask(*iot.StartOnDemandAuditTaskInput) (*iot.StartOnDemandAuditTaskOutput, error)
	StartOnDemandAuditTaskWithContext(aws.Context, *iot.StartOnDemandAuditTaskInput, ...request.Option) (*iot.StartOnDemandAuditTaskOutput, error)
	StartOnDemandAuditTaskRequest(*iot.StartOnDemandAuditTaskInput) (*request.Request, *iot.StartOnDemandAuditTaskOutput)

	StartThingRegistrationTask(*iot.StartThingRegistrationTaskInput) (*iot.StartThingRegistrationTaskOutput, error)
	StartThingRegistrationTaskWithContext(aws.Context, *iot.StartThingRegistrationTaskInput, ...request.Option) (*iot.StartThingRegistrationTaskOutput, error)
	StartThingRegistrationTaskRequest(*iot.StartThingRegistrationTaskInput) (*request.Request, *iot.StartThingRegistrationTaskOutput)

	StopThingRegistrationTask(*iot.StopThingRegistrationTaskInput) (*iot.StopThingRegistrationTaskOutput, error)
	StopThingRegistrationTaskWithContext(aws.Context, *iot.StopThingRegistrationTaskInput, ...request.Option) (*iot.StopThingRegistrationTaskOutput, error)
	StopThingRegistrationTaskRequest(*iot.StopThingRegistrationTaskInput) (*request.Request, *iot.StopThingRegistrationTaskOutput)

	TagResource(*iot.TagResourceInput) (*iot.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *iot.TagResourceInput, ...request.Option) (*iot.TagResourceOutput, error)
	TagResourceRequest(*iot.TagResourceInput) (*request.Request, *iot.TagResourceOutput)

	TestAuthorization(*iot.TestAuthorizationInput) (*iot.TestAuthorizationOutput, error)
	TestAuthorizationWithContext(aws.Context, *iot.TestAuthorizationInput, ...request.Option) (*iot.TestAuthorizationOutput, error)
	TestAuthorizationRequest(*iot.TestAuthorizationInput) (*request.Request, *iot.TestAuthorizationOutput)

	TestInvokeAuthorizer(*iot.TestInvokeAuthorizerInput) (*iot.TestInvokeAuthorizerOutput, error)
	TestInvokeAuthorizerWithContext(aws.Context, *iot.TestInvokeAuthorizerInput, ...request.Option) (*iot.TestInvokeAuthorizerOutput, error)
	TestInvokeAuthorizerRequest(*iot.TestInvokeAuthorizerInput) (*request.Request, *iot.TestInvokeAuthorizerOutput)

	TransferCertificate(*iot.TransferCertificateInput) (*iot.TransferCertificateOutput, error)
	TransferCertificateWithContext(aws.Context, *iot.TransferCertificateInput, ...request.Option) (*iot.TransferCertificateOutput, error)
	TransferCertificateRequest(*iot.TransferCertificateInput) (*request.Request, *iot.TransferCertificateOutput)

	UntagResource(*iot.UntagResourceInput) (*iot.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *iot.UntagResourceInput, ...request.Option) (*iot.UntagResourceOutput, error)
	UntagResourceRequest(*iot.UntagResourceInput) (*request.Request, *iot.UntagResourceOutput)

	UpdateAccountAuditConfiguration(*iot.UpdateAccountAuditConfigurationInput) (*iot.UpdateAccountAuditConfigurationOutput, error)
	UpdateAccountAuditConfigurationWithContext(aws.Context, *iot.UpdateAccountAuditConfigurationInput, ...request.Option) (*iot.UpdateAccountAuditConfigurationOutput, error)
	UpdateAccountAuditConfigurationRequest(*iot.UpdateAccountAuditConfigurationInput) (*request.Request, *iot.UpdateAccountAuditConfigurationOutput)

	UpdateAuditSuppression(*iot.UpdateAuditSuppressionInput) (*iot.UpdateAuditSuppressionOutput, error)
	UpdateAuditSuppressionWithContext(aws.Context, *iot.UpdateAuditSuppressionInput, ...request.Option) (*iot.UpdateAuditSuppressionOutput, error)
	UpdateAuditSuppressionRequest(*iot.UpdateAuditSuppressionInput) (*request.Request, *iot.UpdateAuditSuppressionOutput)

	UpdateAuthorizer(*iot.UpdateAuthorizerInput) (*iot.UpdateAuthorizerOutput, error)
	UpdateAuthorizerWithContext(aws.Context, *iot.UpdateAuthorizerInput, ...request.Option) (*iot.UpdateAuthorizerOutput, error)
	UpdateAuthorizerRequest(*iot.UpdateAuthorizerInput) (*request.Request, *iot.UpdateAuthorizerOutput)

	UpdateBillingGroup(*iot.UpdateBillingGroupInput) (*iot.UpdateBillingGroupOutput, error)
	UpdateBillingGroupWithContext(aws.Context, *iot.UpdateBillingGroupInput, ...request.Option) (*iot.UpdateBillingGroupOutput, error)
	UpdateBillingGroupRequest(*iot.UpdateBillingGroupInput) (*request.Request, *iot.UpdateBillingGroupOutput)

	UpdateCACertificate(*iot.UpdateCACertificateInput) (*iot.UpdateCACertificateOutput, error)
	UpdateCACertificateWithContext(aws.Context, *iot.UpdateCACertificateInput, ...request.Option) (*iot.UpdateCACertificateOutput, error)
	UpdateCACertificateRequest(*iot.UpdateCACertificateInput) (*request.Request, *iot.UpdateCACertificateOutput)

	UpdateCertificate(*iot.UpdateCertificateInput) (*iot.UpdateCertificateOutput, error)
	UpdateCertificateWithContext(aws.Context, *iot.UpdateCertificateInput, ...request.Option) (*iot.UpdateCertificateOutput, error)
	UpdateCertificateRequest(*iot.UpdateCertificateInput) (*request.Request, *iot.UpdateCertificateOutput)

	UpdateCertificateProvider(*iot.UpdateCertificateProviderInput) (*iot.UpdateCertificateProviderOutput, error)
	UpdateCertificateProviderWithContext(aws.Context, *iot.UpdateCertificateProviderInput, ...request.Option) (*iot.UpdateCertificateProviderOutput, error)
	UpdateCertificateProviderRequest(*iot.UpdateCertificateProviderInput) (*request.Request, *iot.UpdateCertificateProviderOutput)

	UpdateCustomMetric(*iot.UpdateCustomMetricInput) (*iot.UpdateCustomMetricOutput, error)
	UpdateCustomMetricWithContext(aws.Context, *iot.UpdateCustomMetricInput, ...request.Option) (*iot.UpdateCustomMetricOutput, error)
	UpdateCustomMetricRequest(*iot.UpdateCustomMetricInput) (*request.Request, *iot.UpdateCustomMetricOutput)

	UpdateDimension(*iot.UpdateDimensionInput) (*iot.UpdateDimensionOutput, error)
	UpdateDimensionWithContext(aws.Context, *iot.UpdateDimensionInput, ...request.Option) (*iot.UpdateDimensionOutput, error)
	UpdateDimensionRequest(*iot.UpdateDimensionInput) (*request.Request, *iot.UpdateDimensionOutput)

	UpdateDomainConfiguration(*iot.UpdateDomainConfigurationInput) (*iot.UpdateDomainConfigurationOutput, error)
	UpdateDomainConfigurationWithContext(aws.Context, *iot.UpdateDomainConfigurationInput, ...request.Option) (*iot.UpdateDomainConfigurationOutput, error)
	UpdateDomainConfigurationRequest(*iot.UpdateDomainConfigurationInput) (*request.Request, *iot.UpdateDomainConfigurationOutput)

	UpdateDynamicThingGroup(*iot.UpdateDynamicThingGroupInput) (*iot.UpdateDynamicThingGroupOutput, error)
	UpdateDynamicThingGroupWithContext(aws.Context, *iot.UpdateDynamicThingGroupInput, ...request.Option) (*iot.UpdateDynamicThingGroupOutput, error)
	UpdateDynamicThingGroupRequest(*iot.UpdateDynamicThingGroupInput) (*request.Request, *iot.UpdateDynamicThingGroupOutput)

	UpdateEventConfigurations(*iot.UpdateEventConfigurationsInput) (*iot.UpdateEventConfigurationsOutput, error)
	UpdateEventConfigurationsWithContext(aws.Context, *iot.UpdateEventConfigurationsInput, ...request.Option) (*iot.UpdateEventConfigurationsOutput, error)
	UpdateEventConfigurationsRequest(*iot.UpdateEventConfigurationsInput) (*request.Request, *iot.UpdateEventConfigurationsOutput)

	UpdateFleetMetric(*iot.UpdateFleetMetricInput) (*iot.UpdateFleetMetricOutput, error)
	UpdateFleetMetricWithContext(aws.Context, *iot.UpdateFleetMetricInput, ...request.Option) (*iot.UpdateFleetMetricOutput, error)
	UpdateFleetMetricRequest(*iot.UpdateFleetMetricInput) (*request.Request, *iot.UpdateFleetMetricOutput)

	UpdateIndexingConfiguration(*iot.UpdateIndexingConfigurationInput) (*iot.UpdateIndexingConfigurationOutput, error)
	UpdateIndexingConfigurationWithContext(aws.Context, *iot.UpdateIndexingConfigurationInput, ...request.Option) (*iot.UpdateIndexingConfigurationOutput, error)
	UpdateIndexingConfigurationRequest(*iot.UpdateIndexingConfigurationInput) (*request.Request, *iot.UpdateIndexingConfigurationOutput)

	UpdateJob(*iot.UpdateJobInput) (*iot.UpdateJobOutput, error)
	UpdateJobWithContext(aws.Context, *iot.UpdateJobInput, ...request.Option) (*iot.UpdateJobOutput, error)
	UpdateJobRequest(*iot.UpdateJobInput) (*request.Request, *iot.UpdateJobOutput)

	UpdateMitigationAction(*iot.UpdateMitigationActionInput) (*iot.UpdateMitigationActionOutput, error)
	UpdateMitigationActionWithContext(aws.Context, *iot.UpdateMitigationActionInput, ...request.Option) (*iot.UpdateMitigationActionOutput, error)
	UpdateMitigationActionRequest(*iot.UpdateMitigationActionInput) (*request.Request, *iot.UpdateMitigationActionOutput)

	UpdatePackage(*iot.UpdatePackageInput) (*iot.UpdatePackageOutput, error)
	UpdatePackageWithContext(aws.Context, *iot.UpdatePackageInput, ...request.Option) (*iot.UpdatePackageOutput, error)
	UpdatePackageRequest(*iot.UpdatePackageInput) (*request.Request, *iot.UpdatePackageOutput)

	UpdatePackageConfiguration(*iot.UpdatePackageConfigurationInput) (*iot.UpdatePackageConfigurationOutput, error)
	UpdatePackageConfigurationWithContext(aws.Context, *iot.UpdatePackageConfigurationInput, ...request.Option) (*iot.UpdatePackageConfigurationOutput, error)
	UpdatePackageConfigurationRequest(*iot.UpdatePackageConfigurationInput) (*request.Request, *iot.UpdatePackageConfigurationOutput)

	UpdatePackageVersion(*iot.UpdatePackageVersionInput) (*iot.UpdatePackageVersionOutput, error)
	UpdatePackageVersionWithContext(aws.Context, *iot.UpdatePackageVersionInput, ...request.Option) (*iot.UpdatePackageVersionOutput, error)
	UpdatePackageVersionRequest(*iot.UpdatePackageVersionInput) (*request.Request, *iot.UpdatePackageVersionOutput)

	UpdateProvisioningTemplate(*iot.UpdateProvisioningTemplateInput) (*iot.UpdateProvisioningTemplateOutput, error)
	UpdateProvisioningTemplateWithContext(aws.Context, *iot.UpdateProvisioningTemplateInput, ...request.Option) (*iot.UpdateProvisioningTemplateOutput, error)
	UpdateProvisioningTemplateRequest(*iot.UpdateProvisioningTemplateInput) (*request.Request, *iot.UpdateProvisioningTemplateOutput)

	UpdateRoleAlias(*iot.UpdateRoleAliasInput) (*iot.UpdateRoleAliasOutput, error)
	UpdateRoleAliasWithContext(aws.Context, *iot.UpdateRoleAliasInput, ...request.Option) (*iot.UpdateRoleAliasOutput, error)
	UpdateRoleAliasRequest(*iot.UpdateRoleAliasInput) (*request.Request, *iot.UpdateRoleAliasOutput)

	UpdateScheduledAudit(*iot.UpdateScheduledAuditInput) (*iot.UpdateScheduledAuditOutput, error)
	UpdateScheduledAuditWithContext(aws.Context, *iot.UpdateScheduledAuditInput, ...request.Option) (*iot.UpdateScheduledAuditOutput, error)
	UpdateScheduledAuditRequest(*iot.UpdateScheduledAuditInput) (*request.Request, *iot.UpdateScheduledAuditOutput)

	UpdateSecurityProfile(*iot.UpdateSecurityProfileInput) (*iot.UpdateSecurityProfileOutput, error)
	UpdateSecurityProfileWithContext(aws.Context, *iot.UpdateSecurityProfileInput, ...request.Option) (*iot.UpdateSecurityProfileOutput, error)
	UpdateSecurityProfileRequest(*iot.UpdateSecurityProfileInput) (*request.Request, *iot.UpdateSecurityProfileOutput)

	UpdateStream(*iot.UpdateStreamInput) (*iot.UpdateStreamOutput, error)
	UpdateStreamWithContext(aws.Context, *iot.UpdateStreamInput, ...request.Option) (*iot.UpdateStreamOutput, error)
	UpdateStreamRequest(*iot.UpdateStreamInput) (*request.Request, *iot.UpdateStreamOutput)

	UpdateThing(*iot.UpdateThingInput) (*iot.UpdateThingOutput, error)
	UpdateThingWithContext(aws.Context, *iot.UpdateThingInput, ...request.Option) (*iot.UpdateThingOutput, error)
	UpdateThingRequest(*iot.UpdateThingInput) (*request.Request, *iot.UpdateThingOutput)

	UpdateThingGroup(*iot.UpdateThingGroupInput) (*iot.UpdateThingGroupOutput, error)
	UpdateThingGroupWithContext(aws.Context, *iot.UpdateThingGroupInput, ...request.Option) (*iot.UpdateThingGroupOutput, error)
	UpdateThingGroupRequest(*iot.UpdateThingGroupInput) (*request.Request, *iot.UpdateThingGroupOutput)

	UpdateThingGroupsForThing(*iot.UpdateThingGroupsForThingInput) (*iot.UpdateThingGroupsForThingOutput, error)
	UpdateThingGroupsForThingWithContext(aws.Context, *iot.UpdateThingGroupsForThingInput, ...request.Option) (*iot.UpdateThingGroupsForThingOutput, error)
	UpdateThingGroupsForThingRequest(*iot.UpdateThingGroupsForThingInput) (*request.Request, *iot.UpdateThingGroupsForThingOutput)

	UpdateTopicRuleDestination(*iot.UpdateTopicRuleDestinationInput) (*iot.UpdateTopicRuleDestinationOutput, error)
	UpdateTopicRuleDestinationWithContext(aws.Context, *iot.UpdateTopicRuleDestinationInput, ...request.Option) (*iot.UpdateTopicRuleDestinationOutput, error)
	UpdateTopicRuleDestinationRequest(*iot.UpdateTopicRuleDestinationInput) (*request.Request, *iot.UpdateTopicRuleDestinationOutput)

	ValidateSecurityProfileBehaviors(*iot.ValidateSecurityProfileBehaviorsInput) (*iot.ValidateSecurityProfileBehaviorsOutput, error)
	ValidateSecurityProfileBehaviorsWithContext(aws.Context, *iot.ValidateSecurityProfileBehaviorsInput, ...request.Option) (*iot.ValidateSecurityProfileBehaviorsOutput, error)
	ValidateSecurityProfileBehaviorsRequest(*iot.ValidateSecurityProfileBehaviorsInput) (*request.Request, *iot.ValidateSecurityProfileBehaviorsOutput)
}

var _ IoTAPI = (*iot.IoT)(nil)
