#[cfg(feature = "Win32_Security_Cryptography_Catalog")]
pub mod Catalog;
#[cfg(feature = "Win32_Security_Cryptography_Certificates")]
pub mod Certificates;
#[cfg(feature = "Win32_Security_Cryptography_Sip")]
pub mod Sip;
#[cfg(feature = "Win32_Security_Cryptography_UI")]
pub mod UI;
#[inline]
pub unsafe fn BCryptAddContextFunction<P0, P1>(dwtable: BCRYPT_TABLE, pszcontext: P0, dwinterface: BCRYPT_INTERFACE, pszfunction: P1, dwposition: u32) -> super::super::Foundation::NTSTATUS
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("bcrypt.dll" "system" fn BCryptAddContextFunction(dwtable : BCRYPT_TABLE, pszcontext : windows_core::PCWSTR, dwinterface : BCRYPT_INTERFACE, pszfunction : windows_core::PCWSTR, dwposition : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptAddContextFunction(dwtable, pszcontext.param().abi(), dwinterface, pszfunction.param().abi(), dwposition)
}
#[inline]
pub unsafe fn BCryptCloseAlgorithmProvider(halgorithm: BCRYPT_ALG_HANDLE, dwflags: u32) -> super::super::Foundation::NTSTATUS {
    windows_targets::link!("bcrypt.dll" "system" fn BCryptCloseAlgorithmProvider(halgorithm : BCRYPT_ALG_HANDLE, dwflags : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptCloseAlgorithmProvider(halgorithm, dwflags)
}
#[inline]
pub unsafe fn BCryptConfigureContext<P0>(dwtable: BCRYPT_TABLE, pszcontext: P0, pconfig: *const CRYPT_CONTEXT_CONFIG) -> super::super::Foundation::NTSTATUS
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("bcrypt.dll" "system" fn BCryptConfigureContext(dwtable : BCRYPT_TABLE, pszcontext : windows_core::PCWSTR, pconfig : *const CRYPT_CONTEXT_CONFIG) -> super::super::Foundation:: NTSTATUS);
    BCryptConfigureContext(dwtable, pszcontext.param().abi(), pconfig)
}
#[inline]
pub unsafe fn BCryptConfigureContextFunction<P0, P1>(dwtable: BCRYPT_TABLE, pszcontext: P0, dwinterface: BCRYPT_INTERFACE, pszfunction: P1, pconfig: *const CRYPT_CONTEXT_FUNCTION_CONFIG) -> super::super::Foundation::NTSTATUS
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("bcrypt.dll" "system" fn BCryptConfigureContextFunction(dwtable : BCRYPT_TABLE, pszcontext : windows_core::PCWSTR, dwinterface : BCRYPT_INTERFACE, pszfunction : windows_core::PCWSTR, pconfig : *const CRYPT_CONTEXT_FUNCTION_CONFIG) -> super::super::Foundation:: NTSTATUS);
    BCryptConfigureContextFunction(dwtable, pszcontext.param().abi(), dwinterface, pszfunction.param().abi(), pconfig)
}
#[inline]
pub unsafe fn BCryptCreateContext<P0>(dwtable: BCRYPT_TABLE, pszcontext: P0, pconfig: Option<*const CRYPT_CONTEXT_CONFIG>) -> super::super::Foundation::NTSTATUS
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("bcrypt.dll" "system" fn BCryptCreateContext(dwtable : BCRYPT_TABLE, pszcontext : windows_core::PCWSTR, pconfig : *const CRYPT_CONTEXT_CONFIG) -> super::super::Foundation:: NTSTATUS);
    BCryptCreateContext(dwtable, pszcontext.param().abi(), core::mem::transmute(pconfig.unwrap_or(std::ptr::null())))
}
#[inline]
pub unsafe fn BCryptCreateHash(halgorithm: BCRYPT_ALG_HANDLE, phhash: *mut BCRYPT_HASH_HANDLE, pbhashobject: Option<&mut [u8]>, pbsecret: Option<&[u8]>, dwflags: u32) -> super::super::Foundation::NTSTATUS {
    windows_targets::link!("bcrypt.dll" "system" fn BCryptCreateHash(halgorithm : BCRYPT_ALG_HANDLE, phhash : *mut BCRYPT_HASH_HANDLE, pbhashobject : *mut u8, cbhashobject : u32, pbsecret : *const u8, cbsecret : u32, dwflags : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptCreateHash(halgorithm, phhash, core::mem::transmute(pbhashobject.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), pbhashobject.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(pbsecret.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), pbsecret.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), dwflags)
}
#[inline]
pub unsafe fn BCryptCreateMultiHash(halgorithm: BCRYPT_ALG_HANDLE, phhash: *mut BCRYPT_HASH_HANDLE, nhashes: u32, pbhashobject: Option<&mut [u8]>, pbsecret: Option<&[u8]>, dwflags: u32) -> super::super::Foundation::NTSTATUS {
    windows_targets::link!("bcrypt.dll" "system" fn BCryptCreateMultiHash(halgorithm : BCRYPT_ALG_HANDLE, phhash : *mut BCRYPT_HASH_HANDLE, nhashes : u32, pbhashobject : *mut u8, cbhashobject : u32, pbsecret : *const u8, cbsecret : u32, dwflags : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptCreateMultiHash(halgorithm, phhash, nhashes, core::mem::transmute(pbhashobject.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), pbhashobject.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(pbsecret.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), pbsecret.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), dwflags)
}
#[inline]
pub unsafe fn BCryptDecrypt(hkey: BCRYPT_KEY_HANDLE, pbinput: Option<&[u8]>, ppaddinginfo: Option<*const core::ffi::c_void>, pbiv: Option<&mut [u8]>, pboutput: Option<&mut [u8]>, pcbresult: *mut u32, dwflags: BCRYPT_FLAGS) -> super::super::Foundation::NTSTATUS {
    windows_targets::link!("bcrypt.dll" "system" fn BCryptDecrypt(hkey : BCRYPT_KEY_HANDLE, pbinput : *const u8, cbinput : u32, ppaddinginfo : *const core::ffi::c_void, pbiv : *mut u8, cbiv : u32, pboutput : *mut u8, cboutput : u32, pcbresult : *mut u32, dwflags : BCRYPT_FLAGS) -> super::super::Foundation:: NTSTATUS);
    BCryptDecrypt(
        hkey,
        core::mem::transmute(pbinput.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
        pbinput.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
        core::mem::transmute(ppaddinginfo.unwrap_or(std::ptr::null())),
        core::mem::transmute(pbiv.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
        pbiv.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
        core::mem::transmute(pboutput.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
        pboutput.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
        pcbresult,
        dwflags,
    )
}
#[inline]
pub unsafe fn BCryptDeleteContext<P0>(dwtable: BCRYPT_TABLE, pszcontext: P0) -> super::super::Foundation::NTSTATUS
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("bcrypt.dll" "system" fn BCryptDeleteContext(dwtable : BCRYPT_TABLE, pszcontext : windows_core::PCWSTR) -> super::super::Foundation:: NTSTATUS);
    BCryptDeleteContext(dwtable, pszcontext.param().abi())
}
#[inline]
pub unsafe fn BCryptDeriveKey<P0, P1>(hsharedsecret: P0, pwszkdf: P1, pparameterlist: Option<*const BCryptBufferDesc>, pbderivedkey: Option<&mut [u8]>, pcbresult: *mut u32, dwflags: u32) -> super::super::Foundation::NTSTATUS
where
    P0: windows_core::Param<BCRYPT_SECRET_HANDLE>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("bcrypt.dll" "system" fn BCryptDeriveKey(hsharedsecret : BCRYPT_SECRET_HANDLE, pwszkdf : windows_core::PCWSTR, pparameterlist : *const BCryptBufferDesc, pbderivedkey : *mut u8, cbderivedkey : u32, pcbresult : *mut u32, dwflags : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptDeriveKey(hsharedsecret.param().abi(), pwszkdf.param().abi(), core::mem::transmute(pparameterlist.unwrap_or(std::ptr::null())), core::mem::transmute(pbderivedkey.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), pbderivedkey.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), pcbresult, dwflags)
}
#[inline]
pub unsafe fn BCryptDeriveKeyCapi<P0, P1>(hhash: P0, htargetalg: P1, pbderivedkey: &mut [u8], dwflags: u32) -> super::super::Foundation::NTSTATUS
where
    P0: windows_core::Param<BCRYPT_HASH_HANDLE>,
    P1: windows_core::Param<BCRYPT_ALG_HANDLE>,
{
    windows_targets::link!("bcrypt.dll" "system" fn BCryptDeriveKeyCapi(hhash : BCRYPT_HASH_HANDLE, htargetalg : BCRYPT_ALG_HANDLE, pbderivedkey : *mut u8, cbderivedkey : u32, dwflags : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptDeriveKeyCapi(hhash.param().abi(), htargetalg.param().abi(), core::mem::transmute(pbderivedkey.as_ptr()), pbderivedkey.len().try_into().unwrap(), dwflags)
}
#[inline]
pub unsafe fn BCryptDeriveKeyPBKDF2<P0>(hprf: P0, pbpassword: Option<&[u8]>, pbsalt: Option<&[u8]>, citerations: u64, pbderivedkey: &mut [u8], dwflags: u32) -> super::super::Foundation::NTSTATUS
where
    P0: windows_core::Param<BCRYPT_ALG_HANDLE>,
{
    windows_targets::link!("bcrypt.dll" "system" fn BCryptDeriveKeyPBKDF2(hprf : BCRYPT_ALG_HANDLE, pbpassword : *const u8, cbpassword : u32, pbsalt : *const u8, cbsalt : u32, citerations : u64, pbderivedkey : *mut u8, cbderivedkey : u32, dwflags : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptDeriveKeyPBKDF2(hprf.param().abi(), core::mem::transmute(pbpassword.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), pbpassword.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(pbsalt.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), pbsalt.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), citerations, core::mem::transmute(pbderivedkey.as_ptr()), pbderivedkey.len().try_into().unwrap(), dwflags)
}
#[inline]
pub unsafe fn BCryptDestroyHash(hhash: BCRYPT_HASH_HANDLE) -> super::super::Foundation::NTSTATUS {
    windows_targets::link!("bcrypt.dll" "system" fn BCryptDestroyHash(hhash : BCRYPT_HASH_HANDLE) -> super::super::Foundation:: NTSTATUS);
    BCryptDestroyHash(hhash)
}
#[inline]
pub unsafe fn BCryptDestroyKey(hkey: BCRYPT_KEY_HANDLE) -> super::super::Foundation::NTSTATUS {
    windows_targets::link!("bcrypt.dll" "system" fn BCryptDestroyKey(hkey : BCRYPT_KEY_HANDLE) -> super::super::Foundation:: NTSTATUS);
    BCryptDestroyKey(hkey)
}
#[inline]
pub unsafe fn BCryptDestroySecret(hsecret: BCRYPT_SECRET_HANDLE) -> super::super::Foundation::NTSTATUS {
    windows_targets::link!("bcrypt.dll" "system" fn BCryptDestroySecret(hsecret : BCRYPT_SECRET_HANDLE) -> super::super::Foundation:: NTSTATUS);
    BCryptDestroySecret(hsecret)
}
#[inline]
pub unsafe fn BCryptDuplicateHash<P0>(hhash: P0, phnewhash: *mut BCRYPT_HASH_HANDLE, pbhashobject: Option<&mut [u8]>, dwflags: u32) -> super::super::Foundation::NTSTATUS
where
    P0: windows_core::Param<BCRYPT_HASH_HANDLE>,
{
    windows_targets::link!("bcrypt.dll" "system" fn BCryptDuplicateHash(hhash : BCRYPT_HASH_HANDLE, phnewhash : *mut BCRYPT_HASH_HANDLE, pbhashobject : *mut u8, cbhashobject : u32, dwflags : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptDuplicateHash(hhash.param().abi(), phnewhash, core::mem::transmute(pbhashobject.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), pbhashobject.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), dwflags)
}
#[inline]
pub unsafe fn BCryptDuplicateKey<P0>(hkey: P0, phnewkey: *mut BCRYPT_KEY_HANDLE, pbkeyobject: Option<&mut [u8]>, dwflags: u32) -> super::super::Foundation::NTSTATUS
where
    P0: windows_core::Param<BCRYPT_KEY_HANDLE>,
{
    windows_targets::link!("bcrypt.dll" "system" fn BCryptDuplicateKey(hkey : BCRYPT_KEY_HANDLE, phnewkey : *mut BCRYPT_KEY_HANDLE, pbkeyobject : *mut u8, cbkeyobject : u32, dwflags : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptDuplicateKey(hkey.param().abi(), phnewkey, core::mem::transmute(pbkeyobject.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), pbkeyobject.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), dwflags)
}
#[inline]
pub unsafe fn BCryptEncrypt(hkey: BCRYPT_KEY_HANDLE, pbinput: Option<&[u8]>, ppaddinginfo: Option<*const core::ffi::c_void>, pbiv: Option<&mut [u8]>, pboutput: Option<&mut [u8]>, pcbresult: *mut u32, dwflags: BCRYPT_FLAGS) -> super::super::Foundation::NTSTATUS {
    windows_targets::link!("bcrypt.dll" "system" fn BCryptEncrypt(hkey : BCRYPT_KEY_HANDLE, pbinput : *const u8, cbinput : u32, ppaddinginfo : *const core::ffi::c_void, pbiv : *mut u8, cbiv : u32, pboutput : *mut u8, cboutput : u32, pcbresult : *mut u32, dwflags : BCRYPT_FLAGS) -> super::super::Foundation:: NTSTATUS);
    BCryptEncrypt(
        hkey,
        core::mem::transmute(pbinput.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
        pbinput.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
        core::mem::transmute(ppaddinginfo.unwrap_or(std::ptr::null())),
        core::mem::transmute(pbiv.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
        pbiv.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
        core::mem::transmute(pboutput.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
        pboutput.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
        pcbresult,
        dwflags,
    )
}
#[inline]
pub unsafe fn BCryptEnumAlgorithms(dwalgoperations: BCRYPT_OPERATION, palgcount: *mut u32, ppalglist: *mut *mut BCRYPT_ALGORITHM_IDENTIFIER, dwflags: u32) -> super::super::Foundation::NTSTATUS {
    windows_targets::link!("bcrypt.dll" "system" fn BCryptEnumAlgorithms(dwalgoperations : BCRYPT_OPERATION, palgcount : *mut u32, ppalglist : *mut *mut BCRYPT_ALGORITHM_IDENTIFIER, dwflags : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptEnumAlgorithms(dwalgoperations, palgcount, ppalglist, dwflags)
}
#[inline]
pub unsafe fn BCryptEnumContextFunctionProviders<P0, P1>(dwtable: BCRYPT_TABLE, pszcontext: P0, dwinterface: BCRYPT_INTERFACE, pszfunction: P1, pcbbuffer: *mut u32, ppbuffer: Option<*mut *mut CRYPT_CONTEXT_FUNCTION_PROVIDERS>) -> super::super::Foundation::NTSTATUS
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("bcrypt.dll" "system" fn BCryptEnumContextFunctionProviders(dwtable : BCRYPT_TABLE, pszcontext : windows_core::PCWSTR, dwinterface : BCRYPT_INTERFACE, pszfunction : windows_core::PCWSTR, pcbbuffer : *mut u32, ppbuffer : *mut *mut CRYPT_CONTEXT_FUNCTION_PROVIDERS) -> super::super::Foundation:: NTSTATUS);
    BCryptEnumContextFunctionProviders(dwtable, pszcontext.param().abi(), dwinterface, pszfunction.param().abi(), pcbbuffer, core::mem::transmute(ppbuffer.unwrap_or(std::ptr::null_mut())))
}
#[inline]
pub unsafe fn BCryptEnumContextFunctions<P0>(dwtable: BCRYPT_TABLE, pszcontext: P0, dwinterface: BCRYPT_INTERFACE, pcbbuffer: *mut u32, ppbuffer: Option<*mut *mut CRYPT_CONTEXT_FUNCTIONS>) -> super::super::Foundation::NTSTATUS
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("bcrypt.dll" "system" fn BCryptEnumContextFunctions(dwtable : BCRYPT_TABLE, pszcontext : windows_core::PCWSTR, dwinterface : BCRYPT_INTERFACE, pcbbuffer : *mut u32, ppbuffer : *mut *mut CRYPT_CONTEXT_FUNCTIONS) -> super::super::Foundation:: NTSTATUS);
    BCryptEnumContextFunctions(dwtable, pszcontext.param().abi(), dwinterface, pcbbuffer, core::mem::transmute(ppbuffer.unwrap_or(std::ptr::null_mut())))
}
#[inline]
pub unsafe fn BCryptEnumContexts(dwtable: BCRYPT_TABLE, pcbbuffer: *mut u32, ppbuffer: Option<*mut *mut CRYPT_CONTEXTS>) -> super::super::Foundation::NTSTATUS {
    windows_targets::link!("bcrypt.dll" "system" fn BCryptEnumContexts(dwtable : BCRYPT_TABLE, pcbbuffer : *mut u32, ppbuffer : *mut *mut CRYPT_CONTEXTS) -> super::super::Foundation:: NTSTATUS);
    BCryptEnumContexts(dwtable, pcbbuffer, core::mem::transmute(ppbuffer.unwrap_or(std::ptr::null_mut())))
}
#[inline]
pub unsafe fn BCryptEnumProviders<P0>(pszalgid: P0, pimplcount: *mut u32, ppimpllist: *mut *mut BCRYPT_PROVIDER_NAME, dwflags: u32) -> super::super::Foundation::NTSTATUS
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("bcrypt.dll" "system" fn BCryptEnumProviders(pszalgid : windows_core::PCWSTR, pimplcount : *mut u32, ppimpllist : *mut *mut BCRYPT_PROVIDER_NAME, dwflags : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptEnumProviders(pszalgid.param().abi(), pimplcount, ppimpllist, dwflags)
}
#[inline]
pub unsafe fn BCryptEnumRegisteredProviders(pcbbuffer: *mut u32, ppbuffer: Option<*mut *mut CRYPT_PROVIDERS>) -> super::super::Foundation::NTSTATUS {
    windows_targets::link!("bcrypt.dll" "system" fn BCryptEnumRegisteredProviders(pcbbuffer : *mut u32, ppbuffer : *mut *mut CRYPT_PROVIDERS) -> super::super::Foundation:: NTSTATUS);
    BCryptEnumRegisteredProviders(pcbbuffer, core::mem::transmute(ppbuffer.unwrap_or(std::ptr::null_mut())))
}
#[inline]
pub unsafe fn BCryptExportKey<P0, P1, P2>(hkey: P0, hexportkey: P1, pszblobtype: P2, pboutput: Option<&mut [u8]>, pcbresult: *mut u32, dwflags: u32) -> super::super::Foundation::NTSTATUS
where
    P0: windows_core::Param<BCRYPT_KEY_HANDLE>,
    P1: windows_core::Param<BCRYPT_KEY_HANDLE>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("bcrypt.dll" "system" fn BCryptExportKey(hkey : BCRYPT_KEY_HANDLE, hexportkey : BCRYPT_KEY_HANDLE, pszblobtype : windows_core::PCWSTR, pboutput : *mut u8, cboutput : u32, pcbresult : *mut u32, dwflags : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptExportKey(hkey.param().abi(), hexportkey.param().abi(), pszblobtype.param().abi(), core::mem::transmute(pboutput.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), pboutput.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), pcbresult, dwflags)
}
#[inline]
pub unsafe fn BCryptFinalizeKeyPair(hkey: BCRYPT_KEY_HANDLE, dwflags: u32) -> super::super::Foundation::NTSTATUS {
    windows_targets::link!("bcrypt.dll" "system" fn BCryptFinalizeKeyPair(hkey : BCRYPT_KEY_HANDLE, dwflags : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptFinalizeKeyPair(hkey, dwflags)
}
#[inline]
pub unsafe fn BCryptFinishHash(hhash: BCRYPT_HASH_HANDLE, pboutput: &mut [u8], dwflags: u32) -> super::super::Foundation::NTSTATUS {
    windows_targets::link!("bcrypt.dll" "system" fn BCryptFinishHash(hhash : BCRYPT_HASH_HANDLE, pboutput : *mut u8, cboutput : u32, dwflags : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptFinishHash(hhash, core::mem::transmute(pboutput.as_ptr()), pboutput.len().try_into().unwrap(), dwflags)
}
#[inline]
pub unsafe fn BCryptFreeBuffer(pvbuffer: *const core::ffi::c_void) {
    windows_targets::link!("bcrypt.dll" "system" fn BCryptFreeBuffer(pvbuffer : *const core::ffi::c_void));
    BCryptFreeBuffer(pvbuffer)
}
#[inline]
pub unsafe fn BCryptGenRandom<P0>(halgorithm: P0, pbbuffer: &mut [u8], dwflags: BCRYPTGENRANDOM_FLAGS) -> super::super::Foundation::NTSTATUS
where
    P0: windows_core::Param<BCRYPT_ALG_HANDLE>,
{
    windows_targets::link!("bcrypt.dll" "system" fn BCryptGenRandom(halgorithm : BCRYPT_ALG_HANDLE, pbbuffer : *mut u8, cbbuffer : u32, dwflags : BCRYPTGENRANDOM_FLAGS) -> super::super::Foundation:: NTSTATUS);
    BCryptGenRandom(halgorithm.param().abi(), core::mem::transmute(pbbuffer.as_ptr()), pbbuffer.len().try_into().unwrap(), dwflags)
}
#[inline]
pub unsafe fn BCryptGenerateKeyPair(halgorithm: BCRYPT_ALG_HANDLE, phkey: *mut BCRYPT_KEY_HANDLE, dwlength: u32, dwflags: u32) -> super::super::Foundation::NTSTATUS {
    windows_targets::link!("bcrypt.dll" "system" fn BCryptGenerateKeyPair(halgorithm : BCRYPT_ALG_HANDLE, phkey : *mut BCRYPT_KEY_HANDLE, dwlength : u32, dwflags : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptGenerateKeyPair(halgorithm, phkey, dwlength, dwflags)
}
#[inline]
pub unsafe fn BCryptGenerateSymmetricKey(halgorithm: BCRYPT_ALG_HANDLE, phkey: *mut BCRYPT_KEY_HANDLE, pbkeyobject: Option<&mut [u8]>, pbsecret: &[u8], dwflags: u32) -> super::super::Foundation::NTSTATUS {
    windows_targets::link!("bcrypt.dll" "system" fn BCryptGenerateSymmetricKey(halgorithm : BCRYPT_ALG_HANDLE, phkey : *mut BCRYPT_KEY_HANDLE, pbkeyobject : *mut u8, cbkeyobject : u32, pbsecret : *const u8, cbsecret : u32, dwflags : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptGenerateSymmetricKey(halgorithm, phkey, core::mem::transmute(pbkeyobject.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), pbkeyobject.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(pbsecret.as_ptr()), pbsecret.len().try_into().unwrap(), dwflags)
}
#[inline]
pub unsafe fn BCryptGetFipsAlgorithmMode(pfenabled: *mut u8) -> super::super::Foundation::NTSTATUS {
    windows_targets::link!("bcrypt.dll" "system" fn BCryptGetFipsAlgorithmMode(pfenabled : *mut u8) -> super::super::Foundation:: NTSTATUS);
    BCryptGetFipsAlgorithmMode(pfenabled)
}
#[inline]
pub unsafe fn BCryptGetProperty<P0, P1>(hobject: P0, pszproperty: P1, pboutput: Option<&mut [u8]>, pcbresult: *mut u32, dwflags: u32) -> super::super::Foundation::NTSTATUS
where
    P0: windows_core::Param<BCRYPT_HANDLE>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("bcrypt.dll" "system" fn BCryptGetProperty(hobject : BCRYPT_HANDLE, pszproperty : windows_core::PCWSTR, pboutput : *mut u8, cboutput : u32, pcbresult : *mut u32, dwflags : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptGetProperty(hobject.param().abi(), pszproperty.param().abi(), core::mem::transmute(pboutput.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), pboutput.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), pcbresult, dwflags)
}
#[inline]
pub unsafe fn BCryptHash(halgorithm: BCRYPT_ALG_HANDLE, pbsecret: Option<&[u8]>, pbinput: &[u8], pboutput: &mut [u8]) -> super::super::Foundation::NTSTATUS {
    windows_targets::link!("bcrypt.dll" "system" fn BCryptHash(halgorithm : BCRYPT_ALG_HANDLE, pbsecret : *const u8, cbsecret : u32, pbinput : *const u8, cbinput : u32, pboutput : *mut u8, cboutput : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptHash(halgorithm, core::mem::transmute(pbsecret.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), pbsecret.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(pbinput.as_ptr()), pbinput.len().try_into().unwrap(), core::mem::transmute(pboutput.as_ptr()), pboutput.len().try_into().unwrap())
}
#[inline]
pub unsafe fn BCryptHashData(hhash: BCRYPT_HASH_HANDLE, pbinput: &[u8], dwflags: u32) -> super::super::Foundation::NTSTATUS {
    windows_targets::link!("bcrypt.dll" "system" fn BCryptHashData(hhash : BCRYPT_HASH_HANDLE, pbinput : *const u8, cbinput : u32, dwflags : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptHashData(hhash, core::mem::transmute(pbinput.as_ptr()), pbinput.len().try_into().unwrap(), dwflags)
}
#[inline]
pub unsafe fn BCryptImportKey<P0, P1, P2>(halgorithm: P0, himportkey: P1, pszblobtype: P2, phkey: *mut BCRYPT_KEY_HANDLE, pbkeyobject: Option<&mut [u8]>, pbinput: &[u8], dwflags: u32) -> super::super::Foundation::NTSTATUS
where
    P0: windows_core::Param<BCRYPT_ALG_HANDLE>,
    P1: windows_core::Param<BCRYPT_KEY_HANDLE>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("bcrypt.dll" "system" fn BCryptImportKey(halgorithm : BCRYPT_ALG_HANDLE, himportkey : BCRYPT_KEY_HANDLE, pszblobtype : windows_core::PCWSTR, phkey : *mut BCRYPT_KEY_HANDLE, pbkeyobject : *mut u8, cbkeyobject : u32, pbinput : *const u8, cbinput : u32, dwflags : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptImportKey(halgorithm.param().abi(), himportkey.param().abi(), pszblobtype.param().abi(), phkey, core::mem::transmute(pbkeyobject.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), pbkeyobject.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(pbinput.as_ptr()), pbinput.len().try_into().unwrap(), dwflags)
}
#[inline]
pub unsafe fn BCryptImportKeyPair<P0, P1, P2>(halgorithm: P0, himportkey: P1, pszblobtype: P2, phkey: *mut BCRYPT_KEY_HANDLE, pbinput: &[u8], dwflags: u32) -> super::super::Foundation::NTSTATUS
where
    P0: windows_core::Param<BCRYPT_ALG_HANDLE>,
    P1: windows_core::Param<BCRYPT_KEY_HANDLE>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("bcrypt.dll" "system" fn BCryptImportKeyPair(halgorithm : BCRYPT_ALG_HANDLE, himportkey : BCRYPT_KEY_HANDLE, pszblobtype : windows_core::PCWSTR, phkey : *mut BCRYPT_KEY_HANDLE, pbinput : *const u8, cbinput : u32, dwflags : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptImportKeyPair(halgorithm.param().abi(), himportkey.param().abi(), pszblobtype.param().abi(), phkey, core::mem::transmute(pbinput.as_ptr()), pbinput.len().try_into().unwrap(), dwflags)
}
#[inline]
pub unsafe fn BCryptKeyDerivation<P0>(hkey: P0, pparameterlist: Option<*const BCryptBufferDesc>, pbderivedkey: &mut [u8], pcbresult: *mut u32, dwflags: u32) -> super::super::Foundation::NTSTATUS
where
    P0: windows_core::Param<BCRYPT_KEY_HANDLE>,
{
    windows_targets::link!("bcrypt.dll" "system" fn BCryptKeyDerivation(hkey : BCRYPT_KEY_HANDLE, pparameterlist : *const BCryptBufferDesc, pbderivedkey : *mut u8, cbderivedkey : u32, pcbresult : *mut u32, dwflags : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptKeyDerivation(hkey.param().abi(), core::mem::transmute(pparameterlist.unwrap_or(std::ptr::null())), core::mem::transmute(pbderivedkey.as_ptr()), pbderivedkey.len().try_into().unwrap(), pcbresult, dwflags)
}
#[inline]
pub unsafe fn BCryptOpenAlgorithmProvider<P0, P1>(phalgorithm: *mut BCRYPT_ALG_HANDLE, pszalgid: P0, pszimplementation: P1, dwflags: BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS) -> super::super::Foundation::NTSTATUS
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("bcrypt.dll" "system" fn BCryptOpenAlgorithmProvider(phalgorithm : *mut BCRYPT_ALG_HANDLE, pszalgid : windows_core::PCWSTR, pszimplementation : windows_core::PCWSTR, dwflags : BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS) -> super::super::Foundation:: NTSTATUS);
    BCryptOpenAlgorithmProvider(phalgorithm, pszalgid.param().abi(), pszimplementation.param().abi(), dwflags)
}
#[inline]
pub unsafe fn BCryptProcessMultiOperations(hobject: BCRYPT_HANDLE, operationtype: BCRYPT_MULTI_OPERATION_TYPE, poperations: *const core::ffi::c_void, cboperations: u32, dwflags: u32) -> super::super::Foundation::NTSTATUS {
    windows_targets::link!("bcrypt.dll" "system" fn BCryptProcessMultiOperations(hobject : BCRYPT_HANDLE, operationtype : BCRYPT_MULTI_OPERATION_TYPE, poperations : *const core::ffi::c_void, cboperations : u32, dwflags : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptProcessMultiOperations(hobject, operationtype, poperations, cboperations, dwflags)
}
#[inline]
pub unsafe fn BCryptQueryContextConfiguration<P0>(dwtable: BCRYPT_TABLE, pszcontext: P0, pcbbuffer: *mut u32, ppbuffer: Option<*mut *mut CRYPT_CONTEXT_CONFIG>) -> super::super::Foundation::NTSTATUS
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("bcrypt.dll" "system" fn BCryptQueryContextConfiguration(dwtable : BCRYPT_TABLE, pszcontext : windows_core::PCWSTR, pcbbuffer : *mut u32, ppbuffer : *mut *mut CRYPT_CONTEXT_CONFIG) -> super::super::Foundation:: NTSTATUS);
    BCryptQueryContextConfiguration(dwtable, pszcontext.param().abi(), pcbbuffer, core::mem::transmute(ppbuffer.unwrap_or(std::ptr::null_mut())))
}
#[inline]
pub unsafe fn BCryptQueryContextFunctionConfiguration<P0, P1>(dwtable: BCRYPT_TABLE, pszcontext: P0, dwinterface: BCRYPT_INTERFACE, pszfunction: P1, pcbbuffer: *mut u32, ppbuffer: Option<*mut *mut CRYPT_CONTEXT_FUNCTION_CONFIG>) -> super::super::Foundation::NTSTATUS
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("bcrypt.dll" "system" fn BCryptQueryContextFunctionConfiguration(dwtable : BCRYPT_TABLE, pszcontext : windows_core::PCWSTR, dwinterface : BCRYPT_INTERFACE, pszfunction : windows_core::PCWSTR, pcbbuffer : *mut u32, ppbuffer : *mut *mut CRYPT_CONTEXT_FUNCTION_CONFIG) -> super::super::Foundation:: NTSTATUS);
    BCryptQueryContextFunctionConfiguration(dwtable, pszcontext.param().abi(), dwinterface, pszfunction.param().abi(), pcbbuffer, core::mem::transmute(ppbuffer.unwrap_or(std::ptr::null_mut())))
}
#[inline]
pub unsafe fn BCryptQueryContextFunctionProperty<P0, P1, P2>(dwtable: BCRYPT_TABLE, pszcontext: P0, dwinterface: BCRYPT_INTERFACE, pszfunction: P1, pszproperty: P2, pcbvalue: *mut u32, ppbvalue: Option<*mut *mut u8>) -> super::super::Foundation::NTSTATUS
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("bcrypt.dll" "system" fn BCryptQueryContextFunctionProperty(dwtable : BCRYPT_TABLE, pszcontext : windows_core::PCWSTR, dwinterface : BCRYPT_INTERFACE, pszfunction : windows_core::PCWSTR, pszproperty : windows_core::PCWSTR, pcbvalue : *mut u32, ppbvalue : *mut *mut u8) -> super::super::Foundation:: NTSTATUS);
    BCryptQueryContextFunctionProperty(dwtable, pszcontext.param().abi(), dwinterface, pszfunction.param().abi(), pszproperty.param().abi(), pcbvalue, core::mem::transmute(ppbvalue.unwrap_or(std::ptr::null_mut())))
}
#[inline]
pub unsafe fn BCryptQueryProviderRegistration<P0>(pszprovider: P0, dwmode: BCRYPT_QUERY_PROVIDER_MODE, dwinterface: BCRYPT_INTERFACE, pcbbuffer: *mut u32, ppbuffer: Option<*mut *mut CRYPT_PROVIDER_REG>) -> super::super::Foundation::NTSTATUS
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("bcrypt.dll" "system" fn BCryptQueryProviderRegistration(pszprovider : windows_core::PCWSTR, dwmode : BCRYPT_QUERY_PROVIDER_MODE, dwinterface : BCRYPT_INTERFACE, pcbbuffer : *mut u32, ppbuffer : *mut *mut CRYPT_PROVIDER_REG) -> super::super::Foundation:: NTSTATUS);
    BCryptQueryProviderRegistration(pszprovider.param().abi(), dwmode, dwinterface, pcbbuffer, core::mem::transmute(ppbuffer.unwrap_or(std::ptr::null_mut())))
}
#[inline]
pub unsafe fn BCryptRegisterConfigChangeNotify(phevent: *mut super::super::Foundation::HANDLE) -> super::super::Foundation::NTSTATUS {
    windows_targets::link!("bcrypt.dll" "system" fn BCryptRegisterConfigChangeNotify(phevent : *mut super::super::Foundation:: HANDLE) -> super::super::Foundation:: NTSTATUS);
    BCryptRegisterConfigChangeNotify(phevent)
}
#[inline]
pub unsafe fn BCryptRemoveContextFunction<P0, P1>(dwtable: BCRYPT_TABLE, pszcontext: P0, dwinterface: BCRYPT_INTERFACE, pszfunction: P1) -> super::super::Foundation::NTSTATUS
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("bcrypt.dll" "system" fn BCryptRemoveContextFunction(dwtable : BCRYPT_TABLE, pszcontext : windows_core::PCWSTR, dwinterface : BCRYPT_INTERFACE, pszfunction : windows_core::PCWSTR) -> super::super::Foundation:: NTSTATUS);
    BCryptRemoveContextFunction(dwtable, pszcontext.param().abi(), dwinterface, pszfunction.param().abi())
}
#[inline]
pub unsafe fn BCryptResolveProviders<P0, P1, P2>(pszcontext: P0, dwinterface: u32, pszfunction: P1, pszprovider: P2, dwmode: BCRYPT_QUERY_PROVIDER_MODE, dwflags: BCRYPT_RESOLVE_PROVIDERS_FLAGS, pcbbuffer: *mut u32, ppbuffer: Option<*mut *mut CRYPT_PROVIDER_REFS>) -> super::super::Foundation::NTSTATUS
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("bcrypt.dll" "system" fn BCryptResolveProviders(pszcontext : windows_core::PCWSTR, dwinterface : u32, pszfunction : windows_core::PCWSTR, pszprovider : windows_core::PCWSTR, dwmode : BCRYPT_QUERY_PROVIDER_MODE, dwflags : BCRYPT_RESOLVE_PROVIDERS_FLAGS, pcbbuffer : *mut u32, ppbuffer : *mut *mut CRYPT_PROVIDER_REFS) -> super::super::Foundation:: NTSTATUS);
    BCryptResolveProviders(pszcontext.param().abi(), dwinterface, pszfunction.param().abi(), pszprovider.param().abi(), dwmode, dwflags, pcbbuffer, core::mem::transmute(ppbuffer.unwrap_or(std::ptr::null_mut())))
}
#[inline]
pub unsafe fn BCryptSecretAgreement<P0, P1>(hprivkey: P0, hpubkey: P1, phagreedsecret: *mut BCRYPT_SECRET_HANDLE, dwflags: u32) -> super::super::Foundation::NTSTATUS
where
    P0: windows_core::Param<BCRYPT_KEY_HANDLE>,
    P1: windows_core::Param<BCRYPT_KEY_HANDLE>,
{
    windows_targets::link!("bcrypt.dll" "system" fn BCryptSecretAgreement(hprivkey : BCRYPT_KEY_HANDLE, hpubkey : BCRYPT_KEY_HANDLE, phagreedsecret : *mut BCRYPT_SECRET_HANDLE, dwflags : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptSecretAgreement(hprivkey.param().abi(), hpubkey.param().abi(), phagreedsecret, dwflags)
}
#[inline]
pub unsafe fn BCryptSetContextFunctionProperty<P0, P1, P2>(dwtable: BCRYPT_TABLE, pszcontext: P0, dwinterface: BCRYPT_INTERFACE, pszfunction: P1, pszproperty: P2, pbvalue: Option<&[u8]>) -> super::super::Foundation::NTSTATUS
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("bcrypt.dll" "system" fn BCryptSetContextFunctionProperty(dwtable : BCRYPT_TABLE, pszcontext : windows_core::PCWSTR, dwinterface : BCRYPT_INTERFACE, pszfunction : windows_core::PCWSTR, pszproperty : windows_core::PCWSTR, cbvalue : u32, pbvalue : *const u8) -> super::super::Foundation:: NTSTATUS);
    BCryptSetContextFunctionProperty(dwtable, pszcontext.param().abi(), dwinterface, pszfunction.param().abi(), pszproperty.param().abi(), pbvalue.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(pbvalue.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())))
}
#[inline]
pub unsafe fn BCryptSetProperty<P0>(hobject: BCRYPT_HANDLE, pszproperty: P0, pbinput: &[u8], dwflags: u32) -> super::super::Foundation::NTSTATUS
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("bcrypt.dll" "system" fn BCryptSetProperty(hobject : BCRYPT_HANDLE, pszproperty : windows_core::PCWSTR, pbinput : *const u8, cbinput : u32, dwflags : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptSetProperty(hobject, pszproperty.param().abi(), core::mem::transmute(pbinput.as_ptr()), pbinput.len().try_into().unwrap(), dwflags)
}
#[inline]
pub unsafe fn BCryptSignHash<P0>(hkey: P0, ppaddinginfo: Option<*const core::ffi::c_void>, pbinput: &[u8], pboutput: Option<&mut [u8]>, pcbresult: *mut u32, dwflags: BCRYPT_FLAGS) -> super::super::Foundation::NTSTATUS
where
    P0: windows_core::Param<BCRYPT_KEY_HANDLE>,
{
    windows_targets::link!("bcrypt.dll" "system" fn BCryptSignHash(hkey : BCRYPT_KEY_HANDLE, ppaddinginfo : *const core::ffi::c_void, pbinput : *const u8, cbinput : u32, pboutput : *mut u8, cboutput : u32, pcbresult : *mut u32, dwflags : BCRYPT_FLAGS) -> super::super::Foundation:: NTSTATUS);
    BCryptSignHash(hkey.param().abi(), core::mem::transmute(ppaddinginfo.unwrap_or(std::ptr::null())), core::mem::transmute(pbinput.as_ptr()), pbinput.len().try_into().unwrap(), core::mem::transmute(pboutput.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), pboutput.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), pcbresult, dwflags)
}
#[inline]
pub unsafe fn BCryptUnregisterConfigChangeNotify<P0>(hevent: P0) -> super::super::Foundation::NTSTATUS
where
    P0: windows_core::Param<super::super::Foundation::HANDLE>,
{
    windows_targets::link!("bcrypt.dll" "system" fn BCryptUnregisterConfigChangeNotify(hevent : super::super::Foundation:: HANDLE) -> super::super::Foundation:: NTSTATUS);
    BCryptUnregisterConfigChangeNotify(hevent.param().abi())
}
#[inline]
pub unsafe fn BCryptVerifySignature<P0>(hkey: P0, ppaddinginfo: Option<*const core::ffi::c_void>, pbhash: &[u8], pbsignature: &[u8], dwflags: BCRYPT_FLAGS) -> super::super::Foundation::NTSTATUS
where
    P0: windows_core::Param<BCRYPT_KEY_HANDLE>,
{
    windows_targets::link!("bcrypt.dll" "system" fn BCryptVerifySignature(hkey : BCRYPT_KEY_HANDLE, ppaddinginfo : *const core::ffi::c_void, pbhash : *const u8, cbhash : u32, pbsignature : *const u8, cbsignature : u32, dwflags : BCRYPT_FLAGS) -> super::super::Foundation:: NTSTATUS);
    BCryptVerifySignature(hkey.param().abi(), core::mem::transmute(ppaddinginfo.unwrap_or(std::ptr::null())), core::mem::transmute(pbhash.as_ptr()), pbhash.len().try_into().unwrap(), core::mem::transmute(pbsignature.as_ptr()), pbsignature.len().try_into().unwrap(), dwflags)
}
#[inline]
pub unsafe fn CertAddCRLContextToStore<P0>(hcertstore: P0, pcrlcontext: *const CRL_CONTEXT, dwadddisposition: u32, ppstorecontext: Option<*mut *mut CRL_CONTEXT>) -> windows_core::Result<()>
where
    P0: windows_core::Param<HCERTSTORE>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertAddCRLContextToStore(hcertstore : HCERTSTORE, pcrlcontext : *const CRL_CONTEXT, dwadddisposition : u32, ppstorecontext : *mut *mut CRL_CONTEXT) -> super::super::Foundation:: BOOL);
    CertAddCRLContextToStore(hcertstore.param().abi(), pcrlcontext, dwadddisposition, core::mem::transmute(ppstorecontext.unwrap_or(std::ptr::null_mut()))).ok()
}
#[inline]
pub unsafe fn CertAddCRLLinkToStore<P0>(hcertstore: P0, pcrlcontext: *const CRL_CONTEXT, dwadddisposition: u32, ppstorecontext: Option<*mut *mut CRL_CONTEXT>) -> windows_core::Result<()>
where
    P0: windows_core::Param<HCERTSTORE>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertAddCRLLinkToStore(hcertstore : HCERTSTORE, pcrlcontext : *const CRL_CONTEXT, dwadddisposition : u32, ppstorecontext : *mut *mut CRL_CONTEXT) -> super::super::Foundation:: BOOL);
    CertAddCRLLinkToStore(hcertstore.param().abi(), pcrlcontext, dwadddisposition, core::mem::transmute(ppstorecontext.unwrap_or(std::ptr::null_mut()))).ok()
}
#[inline]
pub unsafe fn CertAddCTLContextToStore<P0>(hcertstore: P0, pctlcontext: *const CTL_CONTEXT, dwadddisposition: u32, ppstorecontext: Option<*mut *mut CTL_CONTEXT>) -> windows_core::Result<()>
where
    P0: windows_core::Param<HCERTSTORE>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertAddCTLContextToStore(hcertstore : HCERTSTORE, pctlcontext : *const CTL_CONTEXT, dwadddisposition : u32, ppstorecontext : *mut *mut CTL_CONTEXT) -> super::super::Foundation:: BOOL);
    CertAddCTLContextToStore(hcertstore.param().abi(), pctlcontext, dwadddisposition, core::mem::transmute(ppstorecontext.unwrap_or(std::ptr::null_mut()))).ok()
}
#[inline]
pub unsafe fn CertAddCTLLinkToStore<P0>(hcertstore: P0, pctlcontext: *const CTL_CONTEXT, dwadddisposition: u32, ppstorecontext: Option<*mut *mut CTL_CONTEXT>) -> windows_core::Result<()>
where
    P0: windows_core::Param<HCERTSTORE>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertAddCTLLinkToStore(hcertstore : HCERTSTORE, pctlcontext : *const CTL_CONTEXT, dwadddisposition : u32, ppstorecontext : *mut *mut CTL_CONTEXT) -> super::super::Foundation:: BOOL);
    CertAddCTLLinkToStore(hcertstore.param().abi(), pctlcontext, dwadddisposition, core::mem::transmute(ppstorecontext.unwrap_or(std::ptr::null_mut()))).ok()
}
#[inline]
pub unsafe fn CertAddCertificateContextToStore<P0>(hcertstore: P0, pcertcontext: *const CERT_CONTEXT, dwadddisposition: u32, ppstorecontext: Option<*mut *mut CERT_CONTEXT>) -> windows_core::Result<()>
where
    P0: windows_core::Param<HCERTSTORE>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertAddCertificateContextToStore(hcertstore : HCERTSTORE, pcertcontext : *const CERT_CONTEXT, dwadddisposition : u32, ppstorecontext : *mut *mut CERT_CONTEXT) -> super::super::Foundation:: BOOL);
    CertAddCertificateContextToStore(hcertstore.param().abi(), pcertcontext, dwadddisposition, core::mem::transmute(ppstorecontext.unwrap_or(std::ptr::null_mut()))).ok()
}
#[inline]
pub unsafe fn CertAddCertificateLinkToStore<P0>(hcertstore: P0, pcertcontext: *const CERT_CONTEXT, dwadddisposition: u32, ppstorecontext: Option<*mut *mut CERT_CONTEXT>) -> windows_core::Result<()>
where
    P0: windows_core::Param<HCERTSTORE>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertAddCertificateLinkToStore(hcertstore : HCERTSTORE, pcertcontext : *const CERT_CONTEXT, dwadddisposition : u32, ppstorecontext : *mut *mut CERT_CONTEXT) -> super::super::Foundation:: BOOL);
    CertAddCertificateLinkToStore(hcertstore.param().abi(), pcertcontext, dwadddisposition, core::mem::transmute(ppstorecontext.unwrap_or(std::ptr::null_mut()))).ok()
}
#[inline]
pub unsafe fn CertAddEncodedCRLToStore<P0>(hcertstore: P0, dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pbcrlencoded: &[u8], dwadddisposition: u32, ppcrlcontext: Option<*mut *mut CRL_CONTEXT>) -> windows_core::Result<()>
where
    P0: windows_core::Param<HCERTSTORE>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertAddEncodedCRLToStore(hcertstore : HCERTSTORE, dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pbcrlencoded : *const u8, cbcrlencoded : u32, dwadddisposition : u32, ppcrlcontext : *mut *mut CRL_CONTEXT) -> super::super::Foundation:: BOOL);
    CertAddEncodedCRLToStore(hcertstore.param().abi(), dwcertencodingtype, core::mem::transmute(pbcrlencoded.as_ptr()), pbcrlencoded.len().try_into().unwrap(), dwadddisposition, core::mem::transmute(ppcrlcontext.unwrap_or(std::ptr::null_mut()))).ok()
}
#[inline]
pub unsafe fn CertAddEncodedCTLToStore<P0>(hcertstore: P0, dwmsgandcertencodingtype: CERT_QUERY_ENCODING_TYPE, pbctlencoded: &[u8], dwadddisposition: u32, ppctlcontext: Option<*mut *mut CTL_CONTEXT>) -> windows_core::Result<()>
where
    P0: windows_core::Param<HCERTSTORE>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertAddEncodedCTLToStore(hcertstore : HCERTSTORE, dwmsgandcertencodingtype : CERT_QUERY_ENCODING_TYPE, pbctlencoded : *const u8, cbctlencoded : u32, dwadddisposition : u32, ppctlcontext : *mut *mut CTL_CONTEXT) -> super::super::Foundation:: BOOL);
    CertAddEncodedCTLToStore(hcertstore.param().abi(), dwmsgandcertencodingtype, core::mem::transmute(pbctlencoded.as_ptr()), pbctlencoded.len().try_into().unwrap(), dwadddisposition, core::mem::transmute(ppctlcontext.unwrap_or(std::ptr::null_mut()))).ok()
}
#[inline]
pub unsafe fn CertAddEncodedCertificateToStore<P0>(hcertstore: P0, dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pbcertencoded: &[u8], dwadddisposition: u32, ppcertcontext: Option<*mut *mut CERT_CONTEXT>) -> windows_core::Result<()>
where
    P0: windows_core::Param<HCERTSTORE>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertAddEncodedCertificateToStore(hcertstore : HCERTSTORE, dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pbcertencoded : *const u8, cbcertencoded : u32, dwadddisposition : u32, ppcertcontext : *mut *mut CERT_CONTEXT) -> super::super::Foundation:: BOOL);
    CertAddEncodedCertificateToStore(hcertstore.param().abi(), dwcertencodingtype, core::mem::transmute(pbcertencoded.as_ptr()), pbcertencoded.len().try_into().unwrap(), dwadddisposition, core::mem::transmute(ppcertcontext.unwrap_or(std::ptr::null_mut()))).ok()
}
#[inline]
pub unsafe fn CertAddEncodedCertificateToSystemStoreA<P0>(szcertstorename: P0, pbcertencoded: &[u8]) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertAddEncodedCertificateToSystemStoreA(szcertstorename : windows_core::PCSTR, pbcertencoded : *const u8, cbcertencoded : u32) -> super::super::Foundation:: BOOL);
    CertAddEncodedCertificateToSystemStoreA(szcertstorename.param().abi(), core::mem::transmute(pbcertencoded.as_ptr()), pbcertencoded.len().try_into().unwrap()).ok()
}
#[inline]
pub unsafe fn CertAddEncodedCertificateToSystemStoreW<P0>(szcertstorename: P0, pbcertencoded: &[u8]) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertAddEncodedCertificateToSystemStoreW(szcertstorename : windows_core::PCWSTR, pbcertencoded : *const u8, cbcertencoded : u32) -> super::super::Foundation:: BOOL);
    CertAddEncodedCertificateToSystemStoreW(szcertstorename.param().abi(), core::mem::transmute(pbcertencoded.as_ptr()), pbcertencoded.len().try_into().unwrap()).ok()
}
#[inline]
pub unsafe fn CertAddEnhancedKeyUsageIdentifier<P0>(pcertcontext: *const CERT_CONTEXT, pszusageidentifier: P0) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertAddEnhancedKeyUsageIdentifier(pcertcontext : *const CERT_CONTEXT, pszusageidentifier : windows_core::PCSTR) -> super::super::Foundation:: BOOL);
    CertAddEnhancedKeyUsageIdentifier(pcertcontext, pszusageidentifier.param().abi()).ok()
}
#[inline]
pub unsafe fn CertAddRefServerOcspResponse(hserverocspresponse: Option<*const core::ffi::c_void>) {
    windows_targets::link!("crypt32.dll" "system" fn CertAddRefServerOcspResponse(hserverocspresponse : *const core::ffi::c_void));
    CertAddRefServerOcspResponse(core::mem::transmute(hserverocspresponse.unwrap_or(std::ptr::null())))
}
#[inline]
pub unsafe fn CertAddRefServerOcspResponseContext(pserverocspresponsecontext: Option<*const CERT_SERVER_OCSP_RESPONSE_CONTEXT>) {
    windows_targets::link!("crypt32.dll" "system" fn CertAddRefServerOcspResponseContext(pserverocspresponsecontext : *const CERT_SERVER_OCSP_RESPONSE_CONTEXT));
    CertAddRefServerOcspResponseContext(core::mem::transmute(pserverocspresponsecontext.unwrap_or(std::ptr::null())))
}
#[inline]
pub unsafe fn CertAddSerializedElementToStore<P0>(hcertstore: P0, pbelement: &[u8], dwadddisposition: u32, dwflags: u32, dwcontexttypeflags: u32, pdwcontexttype: Option<*mut u32>, ppvcontext: Option<*mut *mut core::ffi::c_void>) -> windows_core::Result<()>
where
    P0: windows_core::Param<HCERTSTORE>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertAddSerializedElementToStore(hcertstore : HCERTSTORE, pbelement : *const u8, cbelement : u32, dwadddisposition : u32, dwflags : u32, dwcontexttypeflags : u32, pdwcontexttype : *mut u32, ppvcontext : *mut *mut core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CertAddSerializedElementToStore(hcertstore.param().abi(), core::mem::transmute(pbelement.as_ptr()), pbelement.len().try_into().unwrap(), dwadddisposition, dwflags, dwcontexttypeflags, core::mem::transmute(pdwcontexttype.unwrap_or(std::ptr::null_mut())), core::mem::transmute(ppvcontext.unwrap_or(std::ptr::null_mut()))).ok()
}
#[inline]
pub unsafe fn CertAddStoreToCollection<P0, P1>(hcollectionstore: P0, hsiblingstore: P1, dwupdateflags: u32, dwpriority: u32) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<HCERTSTORE>,
    P1: windows_core::Param<HCERTSTORE>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertAddStoreToCollection(hcollectionstore : HCERTSTORE, hsiblingstore : HCERTSTORE, dwupdateflags : u32, dwpriority : u32) -> super::super::Foundation:: BOOL);
    CertAddStoreToCollection(hcollectionstore.param().abi(), hsiblingstore.param().abi(), dwupdateflags, dwpriority)
}
#[inline]
pub unsafe fn CertAlgIdToOID(dwalgid: u32) -> windows_core::PCSTR {
    windows_targets::link!("crypt32.dll" "system" fn CertAlgIdToOID(dwalgid : u32) -> windows_core::PCSTR);
    CertAlgIdToOID(dwalgid)
}
#[inline]
pub unsafe fn CertCloseServerOcspResponse(hserverocspresponse: Option<*const core::ffi::c_void>, dwflags: u32) {
    windows_targets::link!("crypt32.dll" "system" fn CertCloseServerOcspResponse(hserverocspresponse : *const core::ffi::c_void, dwflags : u32));
    CertCloseServerOcspResponse(core::mem::transmute(hserverocspresponse.unwrap_or(std::ptr::null())), dwflags)
}
#[inline]
pub unsafe fn CertCloseStore<P0>(hcertstore: P0, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<HCERTSTORE>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertCloseStore(hcertstore : HCERTSTORE, dwflags : u32) -> super::super::Foundation:: BOOL);
    CertCloseStore(hcertstore.param().abi(), dwflags).ok()
}
#[inline]
pub unsafe fn CertCompareCertificate(dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pcertid1: *const CERT_INFO, pcertid2: *const CERT_INFO) -> super::super::Foundation::BOOL {
    windows_targets::link!("crypt32.dll" "system" fn CertCompareCertificate(dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pcertid1 : *const CERT_INFO, pcertid2 : *const CERT_INFO) -> super::super::Foundation:: BOOL);
    CertCompareCertificate(dwcertencodingtype, pcertid1, pcertid2)
}
#[inline]
pub unsafe fn CertCompareCertificateName(dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pcertname1: *const CRYPT_INTEGER_BLOB, pcertname2: *const CRYPT_INTEGER_BLOB) -> super::super::Foundation::BOOL {
    windows_targets::link!("crypt32.dll" "system" fn CertCompareCertificateName(dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pcertname1 : *const CRYPT_INTEGER_BLOB, pcertname2 : *const CRYPT_INTEGER_BLOB) -> super::super::Foundation:: BOOL);
    CertCompareCertificateName(dwcertencodingtype, pcertname1, pcertname2)
}
#[inline]
pub unsafe fn CertCompareIntegerBlob(pint1: *const CRYPT_INTEGER_BLOB, pint2: *const CRYPT_INTEGER_BLOB) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CertCompareIntegerBlob(pint1 : *const CRYPT_INTEGER_BLOB, pint2 : *const CRYPT_INTEGER_BLOB) -> super::super::Foundation:: BOOL);
    CertCompareIntegerBlob(pint1, pint2).ok()
}
#[inline]
pub unsafe fn CertComparePublicKeyInfo(dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, ppublickey1: *const CERT_PUBLIC_KEY_INFO, ppublickey2: *const CERT_PUBLIC_KEY_INFO) -> super::super::Foundation::BOOL {
    windows_targets::link!("crypt32.dll" "system" fn CertComparePublicKeyInfo(dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, ppublickey1 : *const CERT_PUBLIC_KEY_INFO, ppublickey2 : *const CERT_PUBLIC_KEY_INFO) -> super::super::Foundation:: BOOL);
    CertComparePublicKeyInfo(dwcertencodingtype, ppublickey1, ppublickey2)
}
#[inline]
pub unsafe fn CertControlStore<P0>(hcertstore: P0, dwflags: CERT_CONTROL_STORE_FLAGS, dwctrltype: u32, pvctrlpara: Option<*const core::ffi::c_void>) -> windows_core::Result<()>
where
    P0: windows_core::Param<HCERTSTORE>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertControlStore(hcertstore : HCERTSTORE, dwflags : CERT_CONTROL_STORE_FLAGS, dwctrltype : u32, pvctrlpara : *const core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CertControlStore(hcertstore.param().abi(), dwflags, dwctrltype, core::mem::transmute(pvctrlpara.unwrap_or(std::ptr::null()))).ok()
}
#[inline]
pub unsafe fn CertCreateCRLContext(dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pbcrlencoded: &[u8]) -> *mut CRL_CONTEXT {
    windows_targets::link!("crypt32.dll" "system" fn CertCreateCRLContext(dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pbcrlencoded : *const u8, cbcrlencoded : u32) -> *mut CRL_CONTEXT);
    CertCreateCRLContext(dwcertencodingtype, core::mem::transmute(pbcrlencoded.as_ptr()), pbcrlencoded.len().try_into().unwrap())
}
#[inline]
pub unsafe fn CertCreateCTLContext(dwmsgandcertencodingtype: u32, pbctlencoded: &[u8]) -> *mut CTL_CONTEXT {
    windows_targets::link!("crypt32.dll" "system" fn CertCreateCTLContext(dwmsgandcertencodingtype : u32, pbctlencoded : *const u8, cbctlencoded : u32) -> *mut CTL_CONTEXT);
    CertCreateCTLContext(dwmsgandcertencodingtype, core::mem::transmute(pbctlencoded.as_ptr()), pbctlencoded.len().try_into().unwrap())
}
#[inline]
pub unsafe fn CertCreateCTLEntryFromCertificateContextProperties(pcertcontext: *const CERT_CONTEXT, rgoptattr: Option<&[CRYPT_ATTRIBUTE]>, dwflags: u32, pvreserved: Option<*const core::ffi::c_void>, pctlentry: Option<*mut CTL_ENTRY>, pcbctlentry: *mut u32) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CertCreateCTLEntryFromCertificateContextProperties(pcertcontext : *const CERT_CONTEXT, coptattr : u32, rgoptattr : *const CRYPT_ATTRIBUTE, dwflags : u32, pvreserved : *const core::ffi::c_void, pctlentry : *mut CTL_ENTRY, pcbctlentry : *mut u32) -> super::super::Foundation:: BOOL);
    CertCreateCTLEntryFromCertificateContextProperties(pcertcontext, rgoptattr.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(rgoptattr.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), dwflags, core::mem::transmute(pvreserved.unwrap_or(std::ptr::null())), core::mem::transmute(pctlentry.unwrap_or(std::ptr::null_mut())), pcbctlentry).ok()
}
#[inline]
pub unsafe fn CertCreateCertificateChainEngine(pconfig: *const CERT_CHAIN_ENGINE_CONFIG, phchainengine: *mut HCERTCHAINENGINE) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CertCreateCertificateChainEngine(pconfig : *const CERT_CHAIN_ENGINE_CONFIG, phchainengine : *mut HCERTCHAINENGINE) -> super::super::Foundation:: BOOL);
    CertCreateCertificateChainEngine(pconfig, phchainengine).ok()
}
#[inline]
pub unsafe fn CertCreateCertificateContext(dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pbcertencoded: &[u8]) -> *mut CERT_CONTEXT {
    windows_targets::link!("crypt32.dll" "system" fn CertCreateCertificateContext(dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pbcertencoded : *const u8, cbcertencoded : u32) -> *mut CERT_CONTEXT);
    CertCreateCertificateContext(dwcertencodingtype, core::mem::transmute(pbcertencoded.as_ptr()), pbcertencoded.len().try_into().unwrap())
}
#[inline]
pub unsafe fn CertCreateContext(dwcontexttype: u32, dwencodingtype: u32, pbencoded: &[u8], dwflags: u32, pcreatepara: Option<*const CERT_CREATE_CONTEXT_PARA>) -> *mut core::ffi::c_void {
    windows_targets::link!("crypt32.dll" "system" fn CertCreateContext(dwcontexttype : u32, dwencodingtype : u32, pbencoded : *const u8, cbencoded : u32, dwflags : u32, pcreatepara : *const CERT_CREATE_CONTEXT_PARA) -> *mut core::ffi::c_void);
    CertCreateContext(dwcontexttype, dwencodingtype, core::mem::transmute(pbencoded.as_ptr()), pbencoded.len().try_into().unwrap(), dwflags, core::mem::transmute(pcreatepara.unwrap_or(std::ptr::null())))
}
#[inline]
pub unsafe fn CertCreateSelfSignCertificate<P0>(hcryptprovorncryptkey: P0, psubjectissuerblob: *const CRYPT_INTEGER_BLOB, dwflags: CERT_CREATE_SELFSIGN_FLAGS, pkeyprovinfo: Option<*const CRYPT_KEY_PROV_INFO>, psignaturealgorithm: Option<*const CRYPT_ALGORITHM_IDENTIFIER>, pstarttime: Option<*const super::super::Foundation::SYSTEMTIME>, pendtime: Option<*const super::super::Foundation::SYSTEMTIME>, pextensions: Option<*const CERT_EXTENSIONS>) -> *mut CERT_CONTEXT
where
    P0: windows_core::Param<HCRYPTPROV_OR_NCRYPT_KEY_HANDLE>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertCreateSelfSignCertificate(hcryptprovorncryptkey : HCRYPTPROV_OR_NCRYPT_KEY_HANDLE, psubjectissuerblob : *const CRYPT_INTEGER_BLOB, dwflags : CERT_CREATE_SELFSIGN_FLAGS, pkeyprovinfo : *const CRYPT_KEY_PROV_INFO, psignaturealgorithm : *const CRYPT_ALGORITHM_IDENTIFIER, pstarttime : *const super::super::Foundation:: SYSTEMTIME, pendtime : *const super::super::Foundation:: SYSTEMTIME, pextensions : *const CERT_EXTENSIONS) -> *mut CERT_CONTEXT);
    CertCreateSelfSignCertificate(hcryptprovorncryptkey.param().abi(), psubjectissuerblob, dwflags, core::mem::transmute(pkeyprovinfo.unwrap_or(std::ptr::null())), core::mem::transmute(psignaturealgorithm.unwrap_or(std::ptr::null())), core::mem::transmute(pstarttime.unwrap_or(std::ptr::null())), core::mem::transmute(pendtime.unwrap_or(std::ptr::null())), core::mem::transmute(pextensions.unwrap_or(std::ptr::null())))
}
#[inline]
pub unsafe fn CertDeleteCRLFromStore(pcrlcontext: *const CRL_CONTEXT) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CertDeleteCRLFromStore(pcrlcontext : *const CRL_CONTEXT) -> super::super::Foundation:: BOOL);
    CertDeleteCRLFromStore(pcrlcontext).ok()
}
#[inline]
pub unsafe fn CertDeleteCTLFromStore(pctlcontext: *const CTL_CONTEXT) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CertDeleteCTLFromStore(pctlcontext : *const CTL_CONTEXT) -> super::super::Foundation:: BOOL);
    CertDeleteCTLFromStore(pctlcontext).ok()
}
#[inline]
pub unsafe fn CertDeleteCertificateFromStore(pcertcontext: *const CERT_CONTEXT) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CertDeleteCertificateFromStore(pcertcontext : *const CERT_CONTEXT) -> super::super::Foundation:: BOOL);
    CertDeleteCertificateFromStore(pcertcontext).ok()
}
#[inline]
pub unsafe fn CertDuplicateCRLContext(pcrlcontext: Option<*const CRL_CONTEXT>) -> *mut CRL_CONTEXT {
    windows_targets::link!("crypt32.dll" "system" fn CertDuplicateCRLContext(pcrlcontext : *const CRL_CONTEXT) -> *mut CRL_CONTEXT);
    CertDuplicateCRLContext(core::mem::transmute(pcrlcontext.unwrap_or(std::ptr::null())))
}
#[inline]
pub unsafe fn CertDuplicateCTLContext(pctlcontext: Option<*const CTL_CONTEXT>) -> *mut CTL_CONTEXT {
    windows_targets::link!("crypt32.dll" "system" fn CertDuplicateCTLContext(pctlcontext : *const CTL_CONTEXT) -> *mut CTL_CONTEXT);
    CertDuplicateCTLContext(core::mem::transmute(pctlcontext.unwrap_or(std::ptr::null())))
}
#[inline]
pub unsafe fn CertDuplicateCertificateChain(pchaincontext: *const CERT_CHAIN_CONTEXT) -> *mut CERT_CHAIN_CONTEXT {
    windows_targets::link!("crypt32.dll" "system" fn CertDuplicateCertificateChain(pchaincontext : *const CERT_CHAIN_CONTEXT) -> *mut CERT_CHAIN_CONTEXT);
    CertDuplicateCertificateChain(pchaincontext)
}
#[inline]
pub unsafe fn CertDuplicateCertificateContext(pcertcontext: Option<*const CERT_CONTEXT>) -> *mut CERT_CONTEXT {
    windows_targets::link!("crypt32.dll" "system" fn CertDuplicateCertificateContext(pcertcontext : *const CERT_CONTEXT) -> *mut CERT_CONTEXT);
    CertDuplicateCertificateContext(core::mem::transmute(pcertcontext.unwrap_or(std::ptr::null())))
}
#[inline]
pub unsafe fn CertDuplicateStore<P0>(hcertstore: P0) -> HCERTSTORE
where
    P0: windows_core::Param<HCERTSTORE>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertDuplicateStore(hcertstore : HCERTSTORE) -> HCERTSTORE);
    CertDuplicateStore(hcertstore.param().abi())
}
#[inline]
pub unsafe fn CertEnumCRLContextProperties(pcrlcontext: *const CRL_CONTEXT, dwpropid: u32) -> u32 {
    windows_targets::link!("crypt32.dll" "system" fn CertEnumCRLContextProperties(pcrlcontext : *const CRL_CONTEXT, dwpropid : u32) -> u32);
    CertEnumCRLContextProperties(pcrlcontext, dwpropid)
}
#[inline]
pub unsafe fn CertEnumCRLsInStore<P0>(hcertstore: P0, pprevcrlcontext: Option<*const CRL_CONTEXT>) -> *mut CRL_CONTEXT
where
    P0: windows_core::Param<HCERTSTORE>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertEnumCRLsInStore(hcertstore : HCERTSTORE, pprevcrlcontext : *const CRL_CONTEXT) -> *mut CRL_CONTEXT);
    CertEnumCRLsInStore(hcertstore.param().abi(), core::mem::transmute(pprevcrlcontext.unwrap_or(std::ptr::null())))
}
#[inline]
pub unsafe fn CertEnumCTLContextProperties(pctlcontext: *const CTL_CONTEXT, dwpropid: u32) -> u32 {
    windows_targets::link!("crypt32.dll" "system" fn CertEnumCTLContextProperties(pctlcontext : *const CTL_CONTEXT, dwpropid : u32) -> u32);
    CertEnumCTLContextProperties(pctlcontext, dwpropid)
}
#[inline]
pub unsafe fn CertEnumCTLsInStore<P0>(hcertstore: P0, pprevctlcontext: Option<*const CTL_CONTEXT>) -> *mut CTL_CONTEXT
where
    P0: windows_core::Param<HCERTSTORE>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertEnumCTLsInStore(hcertstore : HCERTSTORE, pprevctlcontext : *const CTL_CONTEXT) -> *mut CTL_CONTEXT);
    CertEnumCTLsInStore(hcertstore.param().abi(), core::mem::transmute(pprevctlcontext.unwrap_or(std::ptr::null())))
}
#[inline]
pub unsafe fn CertEnumCertificateContextProperties(pcertcontext: *const CERT_CONTEXT, dwpropid: u32) -> u32 {
    windows_targets::link!("crypt32.dll" "system" fn CertEnumCertificateContextProperties(pcertcontext : *const CERT_CONTEXT, dwpropid : u32) -> u32);
    CertEnumCertificateContextProperties(pcertcontext, dwpropid)
}
#[inline]
pub unsafe fn CertEnumCertificatesInStore<P0>(hcertstore: P0, pprevcertcontext: Option<*const CERT_CONTEXT>) -> *mut CERT_CONTEXT
where
    P0: windows_core::Param<HCERTSTORE>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertEnumCertificatesInStore(hcertstore : HCERTSTORE, pprevcertcontext : *const CERT_CONTEXT) -> *mut CERT_CONTEXT);
    CertEnumCertificatesInStore(hcertstore.param().abi(), core::mem::transmute(pprevcertcontext.unwrap_or(std::ptr::null())))
}
#[inline]
pub unsafe fn CertEnumPhysicalStore(pvsystemstore: *const core::ffi::c_void, dwflags: u32, pvarg: Option<*mut core::ffi::c_void>, pfnenum: PFN_CERT_ENUM_PHYSICAL_STORE) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CertEnumPhysicalStore(pvsystemstore : *const core::ffi::c_void, dwflags : u32, pvarg : *mut core::ffi::c_void, pfnenum : PFN_CERT_ENUM_PHYSICAL_STORE) -> super::super::Foundation:: BOOL);
    CertEnumPhysicalStore(pvsystemstore, dwflags, core::mem::transmute(pvarg.unwrap_or(std::ptr::null_mut())), pfnenum).ok()
}
#[inline]
pub unsafe fn CertEnumSubjectInSortedCTL(pctlcontext: *const CTL_CONTEXT, ppvnextsubject: *mut *mut core::ffi::c_void, psubjectidentifier: Option<*mut CRYPT_INTEGER_BLOB>, pencodedattributes: Option<*mut CRYPT_INTEGER_BLOB>) -> super::super::Foundation::BOOL {
    windows_targets::link!("crypt32.dll" "system" fn CertEnumSubjectInSortedCTL(pctlcontext : *const CTL_CONTEXT, ppvnextsubject : *mut *mut core::ffi::c_void, psubjectidentifier : *mut CRYPT_INTEGER_BLOB, pencodedattributes : *mut CRYPT_INTEGER_BLOB) -> super::super::Foundation:: BOOL);
    CertEnumSubjectInSortedCTL(pctlcontext, ppvnextsubject, core::mem::transmute(psubjectidentifier.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pencodedattributes.unwrap_or(std::ptr::null_mut())))
}
#[inline]
pub unsafe fn CertEnumSystemStore(dwflags: u32, pvsystemstorelocationpara: Option<*const core::ffi::c_void>, pvarg: Option<*mut core::ffi::c_void>, pfnenum: PFN_CERT_ENUM_SYSTEM_STORE) -> super::super::Foundation::BOOL {
    windows_targets::link!("crypt32.dll" "system" fn CertEnumSystemStore(dwflags : u32, pvsystemstorelocationpara : *const core::ffi::c_void, pvarg : *mut core::ffi::c_void, pfnenum : PFN_CERT_ENUM_SYSTEM_STORE) -> super::super::Foundation:: BOOL);
    CertEnumSystemStore(dwflags, core::mem::transmute(pvsystemstorelocationpara.unwrap_or(std::ptr::null())), core::mem::transmute(pvarg.unwrap_or(std::ptr::null_mut())), pfnenum)
}
#[inline]
pub unsafe fn CertEnumSystemStoreLocation(dwflags: u32, pvarg: Option<*mut core::ffi::c_void>, pfnenum: PFN_CERT_ENUM_SYSTEM_STORE_LOCATION) -> super::super::Foundation::BOOL {
    windows_targets::link!("crypt32.dll" "system" fn CertEnumSystemStoreLocation(dwflags : u32, pvarg : *mut core::ffi::c_void, pfnenum : PFN_CERT_ENUM_SYSTEM_STORE_LOCATION) -> super::super::Foundation:: BOOL);
    CertEnumSystemStoreLocation(dwflags, core::mem::transmute(pvarg.unwrap_or(std::ptr::null_mut())), pfnenum)
}
#[inline]
pub unsafe fn CertFindAttribute<P0>(pszobjid: P0, rgattr: &[CRYPT_ATTRIBUTE]) -> *mut CRYPT_ATTRIBUTE
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertFindAttribute(pszobjid : windows_core::PCSTR, cattr : u32, rgattr : *const CRYPT_ATTRIBUTE) -> *mut CRYPT_ATTRIBUTE);
    CertFindAttribute(pszobjid.param().abi(), rgattr.len().try_into().unwrap(), core::mem::transmute(rgattr.as_ptr()))
}
#[inline]
pub unsafe fn CertFindCRLInStore<P0>(hcertstore: P0, dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, dwfindflags: u32, dwfindtype: u32, pvfindpara: Option<*const core::ffi::c_void>, pprevcrlcontext: Option<*const CRL_CONTEXT>) -> *mut CRL_CONTEXT
where
    P0: windows_core::Param<HCERTSTORE>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertFindCRLInStore(hcertstore : HCERTSTORE, dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, dwfindflags : u32, dwfindtype : u32, pvfindpara : *const core::ffi::c_void, pprevcrlcontext : *const CRL_CONTEXT) -> *mut CRL_CONTEXT);
    CertFindCRLInStore(hcertstore.param().abi(), dwcertencodingtype, dwfindflags, dwfindtype, core::mem::transmute(pvfindpara.unwrap_or(std::ptr::null())), core::mem::transmute(pprevcrlcontext.unwrap_or(std::ptr::null())))
}
#[inline]
pub unsafe fn CertFindCTLInStore<P0>(hcertstore: P0, dwmsgandcertencodingtype: u32, dwfindflags: u32, dwfindtype: CERT_FIND_TYPE, pvfindpara: Option<*const core::ffi::c_void>, pprevctlcontext: Option<*const CTL_CONTEXT>) -> *mut CTL_CONTEXT
where
    P0: windows_core::Param<HCERTSTORE>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertFindCTLInStore(hcertstore : HCERTSTORE, dwmsgandcertencodingtype : u32, dwfindflags : u32, dwfindtype : CERT_FIND_TYPE, pvfindpara : *const core::ffi::c_void, pprevctlcontext : *const CTL_CONTEXT) -> *mut CTL_CONTEXT);
    CertFindCTLInStore(hcertstore.param().abi(), dwmsgandcertencodingtype, dwfindflags, dwfindtype, core::mem::transmute(pvfindpara.unwrap_or(std::ptr::null())), core::mem::transmute(pprevctlcontext.unwrap_or(std::ptr::null())))
}
#[inline]
pub unsafe fn CertFindCertificateInCRL(pcert: *const CERT_CONTEXT, pcrlcontext: *const CRL_CONTEXT, dwflags: u32, pvreserved: Option<*const core::ffi::c_void>, ppcrlentry: *mut *mut CRL_ENTRY) -> super::super::Foundation::BOOL {
    windows_targets::link!("crypt32.dll" "system" fn CertFindCertificateInCRL(pcert : *const CERT_CONTEXT, pcrlcontext : *const CRL_CONTEXT, dwflags : u32, pvreserved : *const core::ffi::c_void, ppcrlentry : *mut *mut CRL_ENTRY) -> super::super::Foundation:: BOOL);
    CertFindCertificateInCRL(pcert, pcrlcontext, dwflags, core::mem::transmute(pvreserved.unwrap_or(std::ptr::null())), ppcrlentry)
}
#[inline]
pub unsafe fn CertFindCertificateInStore<P0>(hcertstore: P0, dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, dwfindflags: u32, dwfindtype: CERT_FIND_FLAGS, pvfindpara: Option<*const core::ffi::c_void>, pprevcertcontext: Option<*const CERT_CONTEXT>) -> *mut CERT_CONTEXT
where
    P0: windows_core::Param<HCERTSTORE>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertFindCertificateInStore(hcertstore : HCERTSTORE, dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, dwfindflags : u32, dwfindtype : CERT_FIND_FLAGS, pvfindpara : *const core::ffi::c_void, pprevcertcontext : *const CERT_CONTEXT) -> *mut CERT_CONTEXT);
    CertFindCertificateInStore(hcertstore.param().abi(), dwcertencodingtype, dwfindflags, dwfindtype, core::mem::transmute(pvfindpara.unwrap_or(std::ptr::null())), core::mem::transmute(pprevcertcontext.unwrap_or(std::ptr::null())))
}
#[inline]
pub unsafe fn CertFindChainInStore<P0>(hcertstore: P0, dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, dwfindflags: CERT_FIND_CHAIN_IN_STORE_FLAGS, dwfindtype: u32, pvfindpara: Option<*const core::ffi::c_void>, pprevchaincontext: Option<*const CERT_CHAIN_CONTEXT>) -> *mut CERT_CHAIN_CONTEXT
where
    P0: windows_core::Param<HCERTSTORE>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertFindChainInStore(hcertstore : HCERTSTORE, dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, dwfindflags : CERT_FIND_CHAIN_IN_STORE_FLAGS, dwfindtype : u32, pvfindpara : *const core::ffi::c_void, pprevchaincontext : *const CERT_CHAIN_CONTEXT) -> *mut CERT_CHAIN_CONTEXT);
    CertFindChainInStore(hcertstore.param().abi(), dwcertencodingtype, dwfindflags, dwfindtype, core::mem::transmute(pvfindpara.unwrap_or(std::ptr::null())), core::mem::transmute(pprevchaincontext.unwrap_or(std::ptr::null())))
}
#[inline]
pub unsafe fn CertFindExtension<P0>(pszobjid: P0, rgextensions: &[CERT_EXTENSION]) -> *mut CERT_EXTENSION
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertFindExtension(pszobjid : windows_core::PCSTR, cextensions : u32, rgextensions : *const CERT_EXTENSION) -> *mut CERT_EXTENSION);
    CertFindExtension(pszobjid.param().abi(), rgextensions.len().try_into().unwrap(), core::mem::transmute(rgextensions.as_ptr()))
}
#[inline]
pub unsafe fn CertFindRDNAttr<P0>(pszobjid: P0, pname: *const CERT_NAME_INFO) -> *mut CERT_RDN_ATTR
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertFindRDNAttr(pszobjid : windows_core::PCSTR, pname : *const CERT_NAME_INFO) -> *mut CERT_RDN_ATTR);
    CertFindRDNAttr(pszobjid.param().abi(), pname)
}
#[inline]
pub unsafe fn CertFindSubjectInCTL(dwencodingtype: u32, dwsubjecttype: u32, pvsubject: *const core::ffi::c_void, pctlcontext: *const CTL_CONTEXT, dwflags: u32) -> *mut CTL_ENTRY {
    windows_targets::link!("crypt32.dll" "system" fn CertFindSubjectInCTL(dwencodingtype : u32, dwsubjecttype : u32, pvsubject : *const core::ffi::c_void, pctlcontext : *const CTL_CONTEXT, dwflags : u32) -> *mut CTL_ENTRY);
    CertFindSubjectInCTL(dwencodingtype, dwsubjecttype, pvsubject, pctlcontext, dwflags)
}
#[inline]
pub unsafe fn CertFindSubjectInSortedCTL(psubjectidentifier: *const CRYPT_INTEGER_BLOB, pctlcontext: *const CTL_CONTEXT, dwflags: u32, pvreserved: Option<*const core::ffi::c_void>, pencodedattributes: Option<*mut CRYPT_INTEGER_BLOB>) -> super::super::Foundation::BOOL {
    windows_targets::link!("crypt32.dll" "system" fn CertFindSubjectInSortedCTL(psubjectidentifier : *const CRYPT_INTEGER_BLOB, pctlcontext : *const CTL_CONTEXT, dwflags : u32, pvreserved : *const core::ffi::c_void, pencodedattributes : *mut CRYPT_INTEGER_BLOB) -> super::super::Foundation:: BOOL);
    CertFindSubjectInSortedCTL(psubjectidentifier, pctlcontext, dwflags, core::mem::transmute(pvreserved.unwrap_or(std::ptr::null())), core::mem::transmute(pencodedattributes.unwrap_or(std::ptr::null_mut())))
}
#[inline]
pub unsafe fn CertFreeCRLContext(pcrlcontext: Option<*const CRL_CONTEXT>) -> super::super::Foundation::BOOL {
    windows_targets::link!("crypt32.dll" "system" fn CertFreeCRLContext(pcrlcontext : *const CRL_CONTEXT) -> super::super::Foundation:: BOOL);
    CertFreeCRLContext(core::mem::transmute(pcrlcontext.unwrap_or(std::ptr::null())))
}
#[inline]
pub unsafe fn CertFreeCTLContext(pctlcontext: Option<*const CTL_CONTEXT>) -> super::super::Foundation::BOOL {
    windows_targets::link!("crypt32.dll" "system" fn CertFreeCTLContext(pctlcontext : *const CTL_CONTEXT) -> super::super::Foundation:: BOOL);
    CertFreeCTLContext(core::mem::transmute(pctlcontext.unwrap_or(std::ptr::null())))
}
#[inline]
pub unsafe fn CertFreeCertificateChain(pchaincontext: *const CERT_CHAIN_CONTEXT) {
    windows_targets::link!("crypt32.dll" "system" fn CertFreeCertificateChain(pchaincontext : *const CERT_CHAIN_CONTEXT));
    CertFreeCertificateChain(pchaincontext)
}
#[inline]
pub unsafe fn CertFreeCertificateChainEngine<P0>(hchainengine: P0)
where
    P0: windows_core::Param<HCERTCHAINENGINE>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertFreeCertificateChainEngine(hchainengine : HCERTCHAINENGINE));
    CertFreeCertificateChainEngine(hchainengine.param().abi())
}
#[inline]
pub unsafe fn CertFreeCertificateChainList(prgpselection: *const *const CERT_CHAIN_CONTEXT) {
    windows_targets::link!("crypt32.dll" "system" fn CertFreeCertificateChainList(prgpselection : *const *const CERT_CHAIN_CONTEXT));
    CertFreeCertificateChainList(prgpselection)
}
#[inline]
pub unsafe fn CertFreeCertificateContext(pcertcontext: Option<*const CERT_CONTEXT>) -> super::super::Foundation::BOOL {
    windows_targets::link!("crypt32.dll" "system" fn CertFreeCertificateContext(pcertcontext : *const CERT_CONTEXT) -> super::super::Foundation:: BOOL);
    CertFreeCertificateContext(core::mem::transmute(pcertcontext.unwrap_or(std::ptr::null())))
}
#[inline]
pub unsafe fn CertFreeServerOcspResponseContext(pserverocspresponsecontext: Option<*const CERT_SERVER_OCSP_RESPONSE_CONTEXT>) {
    windows_targets::link!("crypt32.dll" "system" fn CertFreeServerOcspResponseContext(pserverocspresponsecontext : *const CERT_SERVER_OCSP_RESPONSE_CONTEXT));
    CertFreeServerOcspResponseContext(core::mem::transmute(pserverocspresponsecontext.unwrap_or(std::ptr::null())))
}
#[inline]
pub unsafe fn CertGetCRLContextProperty(pcrlcontext: *const CRL_CONTEXT, dwpropid: u32, pvdata: Option<*mut core::ffi::c_void>, pcbdata: *mut u32) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CertGetCRLContextProperty(pcrlcontext : *const CRL_CONTEXT, dwpropid : u32, pvdata : *mut core::ffi::c_void, pcbdata : *mut u32) -> super::super::Foundation:: BOOL);
    CertGetCRLContextProperty(pcrlcontext, dwpropid, core::mem::transmute(pvdata.unwrap_or(std::ptr::null_mut())), pcbdata).ok()
}
#[inline]
pub unsafe fn CertGetCRLFromStore<P0>(hcertstore: P0, pissuercontext: Option<*const CERT_CONTEXT>, pprevcrlcontext: Option<*const CRL_CONTEXT>, pdwflags: *mut u32) -> *mut CRL_CONTEXT
where
    P0: windows_core::Param<HCERTSTORE>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertGetCRLFromStore(hcertstore : HCERTSTORE, pissuercontext : *const CERT_CONTEXT, pprevcrlcontext : *const CRL_CONTEXT, pdwflags : *mut u32) -> *mut CRL_CONTEXT);
    CertGetCRLFromStore(hcertstore.param().abi(), core::mem::transmute(pissuercontext.unwrap_or(std::ptr::null())), core::mem::transmute(pprevcrlcontext.unwrap_or(std::ptr::null())), pdwflags)
}
#[inline]
pub unsafe fn CertGetCTLContextProperty(pctlcontext: *const CTL_CONTEXT, dwpropid: u32, pvdata: Option<*mut core::ffi::c_void>, pcbdata: *mut u32) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CertGetCTLContextProperty(pctlcontext : *const CTL_CONTEXT, dwpropid : u32, pvdata : *mut core::ffi::c_void, pcbdata : *mut u32) -> super::super::Foundation:: BOOL);
    CertGetCTLContextProperty(pctlcontext, dwpropid, core::mem::transmute(pvdata.unwrap_or(std::ptr::null_mut())), pcbdata).ok()
}
#[inline]
pub unsafe fn CertGetCertificateChain<P0, P1>(hchainengine: P0, pcertcontext: *const CERT_CONTEXT, ptime: Option<*const super::super::Foundation::FILETIME>, hadditionalstore: P1, pchainpara: *const CERT_CHAIN_PARA, dwflags: u32, pvreserved: Option<*const core::ffi::c_void>, ppchaincontext: *mut *mut CERT_CHAIN_CONTEXT) -> windows_core::Result<()>
where
    P0: windows_core::Param<HCERTCHAINENGINE>,
    P1: windows_core::Param<HCERTSTORE>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertGetCertificateChain(hchainengine : HCERTCHAINENGINE, pcertcontext : *const CERT_CONTEXT, ptime : *const super::super::Foundation:: FILETIME, hadditionalstore : HCERTSTORE, pchainpara : *const CERT_CHAIN_PARA, dwflags : u32, pvreserved : *const core::ffi::c_void, ppchaincontext : *mut *mut CERT_CHAIN_CONTEXT) -> super::super::Foundation:: BOOL);
    CertGetCertificateChain(hchainengine.param().abi(), pcertcontext, core::mem::transmute(ptime.unwrap_or(std::ptr::null())), hadditionalstore.param().abi(), pchainpara, dwflags, core::mem::transmute(pvreserved.unwrap_or(std::ptr::null())), ppchaincontext).ok()
}
#[inline]
pub unsafe fn CertGetCertificateContextProperty(pcertcontext: *const CERT_CONTEXT, dwpropid: u32, pvdata: Option<*mut core::ffi::c_void>, pcbdata: *mut u32) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CertGetCertificateContextProperty(pcertcontext : *const CERT_CONTEXT, dwpropid : u32, pvdata : *mut core::ffi::c_void, pcbdata : *mut u32) -> super::super::Foundation:: BOOL);
    CertGetCertificateContextProperty(pcertcontext, dwpropid, core::mem::transmute(pvdata.unwrap_or(std::ptr::null_mut())), pcbdata).ok()
}
#[inline]
pub unsafe fn CertGetEnhancedKeyUsage(pcertcontext: *const CERT_CONTEXT, dwflags: u32, pusage: Option<*mut CTL_USAGE>, pcbusage: *mut u32) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CertGetEnhancedKeyUsage(pcertcontext : *const CERT_CONTEXT, dwflags : u32, pusage : *mut CTL_USAGE, pcbusage : *mut u32) -> super::super::Foundation:: BOOL);
    CertGetEnhancedKeyUsage(pcertcontext, dwflags, core::mem::transmute(pusage.unwrap_or(std::ptr::null_mut())), pcbusage).ok()
}
#[inline]
pub unsafe fn CertGetIntendedKeyUsage(dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pcertinfo: *const CERT_INFO, pbkeyusage: &mut [u8]) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CertGetIntendedKeyUsage(dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pcertinfo : *const CERT_INFO, pbkeyusage : *mut u8, cbkeyusage : u32) -> super::super::Foundation:: BOOL);
    CertGetIntendedKeyUsage(dwcertencodingtype, pcertinfo, core::mem::transmute(pbkeyusage.as_ptr()), pbkeyusage.len().try_into().unwrap()).ok()
}
#[inline]
pub unsafe fn CertGetIssuerCertificateFromStore<P0>(hcertstore: P0, psubjectcontext: *const CERT_CONTEXT, pprevissuercontext: Option<*const CERT_CONTEXT>, pdwflags: *mut u32) -> *mut CERT_CONTEXT
where
    P0: windows_core::Param<HCERTSTORE>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertGetIssuerCertificateFromStore(hcertstore : HCERTSTORE, psubjectcontext : *const CERT_CONTEXT, pprevissuercontext : *const CERT_CONTEXT, pdwflags : *mut u32) -> *mut CERT_CONTEXT);
    CertGetIssuerCertificateFromStore(hcertstore.param().abi(), psubjectcontext, core::mem::transmute(pprevissuercontext.unwrap_or(std::ptr::null())), pdwflags)
}
#[inline]
pub unsafe fn CertGetNameStringA(pcertcontext: *const CERT_CONTEXT, dwtype: u32, dwflags: u32, pvtypepara: Option<*const core::ffi::c_void>, psznamestring: Option<&mut [u8]>) -> u32 {
    windows_targets::link!("crypt32.dll" "system" fn CertGetNameStringA(pcertcontext : *const CERT_CONTEXT, dwtype : u32, dwflags : u32, pvtypepara : *const core::ffi::c_void, psznamestring : windows_core::PSTR, cchnamestring : u32) -> u32);
    CertGetNameStringA(pcertcontext, dwtype, dwflags, core::mem::transmute(pvtypepara.unwrap_or(std::ptr::null())), core::mem::transmute(psznamestring.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), psznamestring.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()))
}
#[inline]
pub unsafe fn CertGetNameStringW(pcertcontext: *const CERT_CONTEXT, dwtype: u32, dwflags: u32, pvtypepara: Option<*const core::ffi::c_void>, psznamestring: Option<&mut [u16]>) -> u32 {
    windows_targets::link!("crypt32.dll" "system" fn CertGetNameStringW(pcertcontext : *const CERT_CONTEXT, dwtype : u32, dwflags : u32, pvtypepara : *const core::ffi::c_void, psznamestring : windows_core::PWSTR, cchnamestring : u32) -> u32);
    CertGetNameStringW(pcertcontext, dwtype, dwflags, core::mem::transmute(pvtypepara.unwrap_or(std::ptr::null())), core::mem::transmute(psznamestring.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), psznamestring.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()))
}
#[inline]
pub unsafe fn CertGetPublicKeyLength(dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, ppublickey: *const CERT_PUBLIC_KEY_INFO) -> u32 {
    windows_targets::link!("crypt32.dll" "system" fn CertGetPublicKeyLength(dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, ppublickey : *const CERT_PUBLIC_KEY_INFO) -> u32);
    CertGetPublicKeyLength(dwcertencodingtype, ppublickey)
}
#[inline]
pub unsafe fn CertGetServerOcspResponseContext(hserverocspresponse: *const core::ffi::c_void, dwflags: u32, pvreserved: Option<*const core::ffi::c_void>) -> *mut CERT_SERVER_OCSP_RESPONSE_CONTEXT {
    windows_targets::link!("crypt32.dll" "system" fn CertGetServerOcspResponseContext(hserverocspresponse : *const core::ffi::c_void, dwflags : u32, pvreserved : *const core::ffi::c_void) -> *mut CERT_SERVER_OCSP_RESPONSE_CONTEXT);
    CertGetServerOcspResponseContext(hserverocspresponse, dwflags, core::mem::transmute(pvreserved.unwrap_or(std::ptr::null())))
}
#[inline]
pub unsafe fn CertGetStoreProperty<P0>(hcertstore: P0, dwpropid: u32, pvdata: Option<*mut core::ffi::c_void>, pcbdata: *mut u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<HCERTSTORE>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertGetStoreProperty(hcertstore : HCERTSTORE, dwpropid : u32, pvdata : *mut core::ffi::c_void, pcbdata : *mut u32) -> super::super::Foundation:: BOOL);
    CertGetStoreProperty(hcertstore.param().abi(), dwpropid, core::mem::transmute(pvdata.unwrap_or(std::ptr::null_mut())), pcbdata).ok()
}
#[inline]
pub unsafe fn CertGetSubjectCertificateFromStore<P0>(hcertstore: P0, dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pcertid: *const CERT_INFO) -> *mut CERT_CONTEXT
where
    P0: windows_core::Param<HCERTSTORE>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertGetSubjectCertificateFromStore(hcertstore : HCERTSTORE, dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pcertid : *const CERT_INFO) -> *mut CERT_CONTEXT);
    CertGetSubjectCertificateFromStore(hcertstore.param().abi(), dwcertencodingtype, pcertid)
}
#[inline]
pub unsafe fn CertGetValidUsages(rghcerts: &[*const CERT_CONTEXT], cnumoids: *mut i32, rghoids: Option<*mut windows_core::PSTR>, pcboids: *mut u32) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CertGetValidUsages(ccerts : u32, rghcerts : *const *const CERT_CONTEXT, cnumoids : *mut i32, rghoids : *mut windows_core::PSTR, pcboids : *mut u32) -> super::super::Foundation:: BOOL);
    CertGetValidUsages(rghcerts.len().try_into().unwrap(), core::mem::transmute(rghcerts.as_ptr()), cnumoids, core::mem::transmute(rghoids.unwrap_or(std::ptr::null_mut())), pcboids).ok()
}
#[inline]
pub unsafe fn CertIsRDNAttrsInCertificateName(dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, dwflags: u32, pcertname: *const CRYPT_INTEGER_BLOB, prdn: *const CERT_RDN) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CertIsRDNAttrsInCertificateName(dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, dwflags : u32, pcertname : *const CRYPT_INTEGER_BLOB, prdn : *const CERT_RDN) -> super::super::Foundation:: BOOL);
    CertIsRDNAttrsInCertificateName(dwcertencodingtype, dwflags, pcertname, prdn).ok()
}
#[inline]
pub unsafe fn CertIsStrongHashToSign<P0>(pstrongsignpara: *const CERT_STRONG_SIGN_PARA, pwszcnghashalgid: P0, psigningcert: Option<*const CERT_CONTEXT>) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertIsStrongHashToSign(pstrongsignpara : *const CERT_STRONG_SIGN_PARA, pwszcnghashalgid : windows_core::PCWSTR, psigningcert : *const CERT_CONTEXT) -> super::super::Foundation:: BOOL);
    CertIsStrongHashToSign(pstrongsignpara, pwszcnghashalgid.param().abi(), core::mem::transmute(psigningcert.unwrap_or(std::ptr::null()))).ok()
}
#[inline]
pub unsafe fn CertIsValidCRLForCertificate(pcert: *const CERT_CONTEXT, pcrl: *const CRL_CONTEXT, dwflags: u32, pvreserved: Option<*const core::ffi::c_void>) -> super::super::Foundation::BOOL {
    windows_targets::link!("crypt32.dll" "system" fn CertIsValidCRLForCertificate(pcert : *const CERT_CONTEXT, pcrl : *const CRL_CONTEXT, dwflags : u32, pvreserved : *const core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CertIsValidCRLForCertificate(pcert, pcrl, dwflags, core::mem::transmute(pvreserved.unwrap_or(std::ptr::null())))
}
#[inline]
pub unsafe fn CertIsWeakHash<P0, P1>(dwhashusetype: u32, pwszcnghashalgid: P0, dwchainflags: u32, psignerchaincontext: Option<*const CERT_CHAIN_CONTEXT>, ptimestamp: Option<*const super::super::Foundation::FILETIME>, pwszfilename: P1) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertIsWeakHash(dwhashusetype : u32, pwszcnghashalgid : windows_core::PCWSTR, dwchainflags : u32, psignerchaincontext : *const CERT_CHAIN_CONTEXT, ptimestamp : *const super::super::Foundation:: FILETIME, pwszfilename : windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    CertIsWeakHash(dwhashusetype, pwszcnghashalgid.param().abi(), dwchainflags, core::mem::transmute(psignerchaincontext.unwrap_or(std::ptr::null())), core::mem::transmute(ptimestamp.unwrap_or(std::ptr::null())), pwszfilename.param().abi())
}
#[inline]
pub unsafe fn CertNameToStrA(dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pname: *const CRYPT_INTEGER_BLOB, dwstrtype: CERT_STRING_TYPE, psz: Option<&mut [u8]>) -> u32 {
    windows_targets::link!("crypt32.dll" "system" fn CertNameToStrA(dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pname : *const CRYPT_INTEGER_BLOB, dwstrtype : CERT_STRING_TYPE, psz : windows_core::PSTR, csz : u32) -> u32);
    CertNameToStrA(dwcertencodingtype, pname, dwstrtype, core::mem::transmute(psz.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), psz.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()))
}
#[inline]
pub unsafe fn CertNameToStrW(dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pname: *const CRYPT_INTEGER_BLOB, dwstrtype: CERT_STRING_TYPE, psz: Option<&mut [u16]>) -> u32 {
    windows_targets::link!("crypt32.dll" "system" fn CertNameToStrW(dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pname : *const CRYPT_INTEGER_BLOB, dwstrtype : CERT_STRING_TYPE, psz : windows_core::PWSTR, csz : u32) -> u32);
    CertNameToStrW(dwcertencodingtype, pname, dwstrtype, core::mem::transmute(psz.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), psz.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()))
}
#[inline]
pub unsafe fn CertOIDToAlgId<P0>(pszobjid: P0) -> u32
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertOIDToAlgId(pszobjid : windows_core::PCSTR) -> u32);
    CertOIDToAlgId(pszobjid.param().abi())
}
#[inline]
pub unsafe fn CertOpenServerOcspResponse(pchaincontext: *const CERT_CHAIN_CONTEXT, dwflags: u32, popenpara: Option<*const CERT_SERVER_OCSP_RESPONSE_OPEN_PARA>) -> *mut core::ffi::c_void {
    windows_targets::link!("crypt32.dll" "system" fn CertOpenServerOcspResponse(pchaincontext : *const CERT_CHAIN_CONTEXT, dwflags : u32, popenpara : *const CERT_SERVER_OCSP_RESPONSE_OPEN_PARA) -> *mut core::ffi::c_void);
    CertOpenServerOcspResponse(pchaincontext, dwflags, core::mem::transmute(popenpara.unwrap_or(std::ptr::null())))
}
#[inline]
pub unsafe fn CertOpenStore<P0, P1>(lpszstoreprovider: P0, dwencodingtype: CERT_QUERY_ENCODING_TYPE, hcryptprov: P1, dwflags: CERT_OPEN_STORE_FLAGS, pvpara: Option<*const core::ffi::c_void>) -> windows_core::Result<HCERTSTORE>
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<HCRYPTPROV_LEGACY>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertOpenStore(lpszstoreprovider : windows_core::PCSTR, dwencodingtype : CERT_QUERY_ENCODING_TYPE, hcryptprov : HCRYPTPROV_LEGACY, dwflags : CERT_OPEN_STORE_FLAGS, pvpara : *const core::ffi::c_void) -> HCERTSTORE);
    let result__ = CertOpenStore(lpszstoreprovider.param().abi(), dwencodingtype, hcryptprov.param().abi(), dwflags, core::mem::transmute(pvpara.unwrap_or(std::ptr::null())));
    (!result__.is_invalid()).then(|| result__).ok_or_else(windows_core::Error::from_win32)
}
#[inline]
pub unsafe fn CertOpenSystemStoreA<P0, P1>(hprov: P0, szsubsystemprotocol: P1) -> windows_core::Result<HCERTSTORE>
where
    P0: windows_core::Param<HCRYPTPROV_LEGACY>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertOpenSystemStoreA(hprov : HCRYPTPROV_LEGACY, szsubsystemprotocol : windows_core::PCSTR) -> HCERTSTORE);
    let result__ = CertOpenSystemStoreA(hprov.param().abi(), szsubsystemprotocol.param().abi());
    (!result__.is_invalid()).then(|| result__).ok_or_else(windows_core::Error::from_win32)
}
#[inline]
pub unsafe fn CertOpenSystemStoreW<P0, P1>(hprov: P0, szsubsystemprotocol: P1) -> windows_core::Result<HCERTSTORE>
where
    P0: windows_core::Param<HCRYPTPROV_LEGACY>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertOpenSystemStoreW(hprov : HCRYPTPROV_LEGACY, szsubsystemprotocol : windows_core::PCWSTR) -> HCERTSTORE);
    let result__ = CertOpenSystemStoreW(hprov.param().abi(), szsubsystemprotocol.param().abi());
    (!result__.is_invalid()).then(|| result__).ok_or_else(windows_core::Error::from_win32)
}
#[inline]
pub unsafe fn CertRDNValueToStrA(dwvaluetype: u32, pvalue: *const CRYPT_INTEGER_BLOB, psz: Option<&mut [u8]>) -> u32 {
    windows_targets::link!("crypt32.dll" "system" fn CertRDNValueToStrA(dwvaluetype : u32, pvalue : *const CRYPT_INTEGER_BLOB, psz : windows_core::PSTR, csz : u32) -> u32);
    CertRDNValueToStrA(dwvaluetype, pvalue, core::mem::transmute(psz.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), psz.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()))
}
#[inline]
pub unsafe fn CertRDNValueToStrW(dwvaluetype: u32, pvalue: *const CRYPT_INTEGER_BLOB, psz: Option<&mut [u16]>) -> u32 {
    windows_targets::link!("crypt32.dll" "system" fn CertRDNValueToStrW(dwvaluetype : u32, pvalue : *const CRYPT_INTEGER_BLOB, psz : windows_core::PWSTR, csz : u32) -> u32);
    CertRDNValueToStrW(dwvaluetype, pvalue, core::mem::transmute(psz.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), psz.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()))
}
#[inline]
pub unsafe fn CertRegisterPhysicalStore<P0>(pvsystemstore: *const core::ffi::c_void, dwflags: u32, pwszstorename: P0, pstoreinfo: *const CERT_PHYSICAL_STORE_INFO, pvreserved: Option<*const core::ffi::c_void>) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertRegisterPhysicalStore(pvsystemstore : *const core::ffi::c_void, dwflags : u32, pwszstorename : windows_core::PCWSTR, pstoreinfo : *const CERT_PHYSICAL_STORE_INFO, pvreserved : *const core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CertRegisterPhysicalStore(pvsystemstore, dwflags, pwszstorename.param().abi(), pstoreinfo, core::mem::transmute(pvreserved.unwrap_or(std::ptr::null())))
}
#[inline]
pub unsafe fn CertRegisterSystemStore(pvsystemstore: *const core::ffi::c_void, dwflags: u32, pstoreinfo: Option<*const CERT_SYSTEM_STORE_INFO>, pvreserved: Option<*const core::ffi::c_void>) -> super::super::Foundation::BOOL {
    windows_targets::link!("crypt32.dll" "system" fn CertRegisterSystemStore(pvsystemstore : *const core::ffi::c_void, dwflags : u32, pstoreinfo : *const CERT_SYSTEM_STORE_INFO, pvreserved : *const core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CertRegisterSystemStore(pvsystemstore, dwflags, core::mem::transmute(pstoreinfo.unwrap_or(std::ptr::null())), core::mem::transmute(pvreserved.unwrap_or(std::ptr::null())))
}
#[inline]
pub unsafe fn CertRemoveEnhancedKeyUsageIdentifier<P0>(pcertcontext: *const CERT_CONTEXT, pszusageidentifier: P0) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertRemoveEnhancedKeyUsageIdentifier(pcertcontext : *const CERT_CONTEXT, pszusageidentifier : windows_core::PCSTR) -> super::super::Foundation:: BOOL);
    CertRemoveEnhancedKeyUsageIdentifier(pcertcontext, pszusageidentifier.param().abi()).ok()
}
#[inline]
pub unsafe fn CertRemoveStoreFromCollection<P0, P1>(hcollectionstore: P0, hsiblingstore: P1)
where
    P0: windows_core::Param<HCERTSTORE>,
    P1: windows_core::Param<HCERTSTORE>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertRemoveStoreFromCollection(hcollectionstore : HCERTSTORE, hsiblingstore : HCERTSTORE));
    CertRemoveStoreFromCollection(hcollectionstore.param().abi(), hsiblingstore.param().abi())
}
#[inline]
pub unsafe fn CertResyncCertificateChainEngine<P0>(hchainengine: P0) -> windows_core::Result<()>
where
    P0: windows_core::Param<HCERTCHAINENGINE>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertResyncCertificateChainEngine(hchainengine : HCERTCHAINENGINE) -> super::super::Foundation:: BOOL);
    CertResyncCertificateChainEngine(hchainengine.param().abi()).ok()
}
#[inline]
pub unsafe fn CertRetrieveLogoOrBiometricInfo<P0>(pcertcontext: *const CERT_CONTEXT, lpszlogoorbiometrictype: P0, dwretrievalflags: u32, dwtimeout: u32, dwflags: u32, pvreserved: Option<*const core::ffi::c_void>, ppbdata: *mut *mut u8, pcbdata: *mut u32, ppwszmimetype: Option<*mut windows_core::PWSTR>) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertRetrieveLogoOrBiometricInfo(pcertcontext : *const CERT_CONTEXT, lpszlogoorbiometrictype : windows_core::PCSTR, dwretrievalflags : u32, dwtimeout : u32, dwflags : u32, pvreserved : *const core::ffi::c_void, ppbdata : *mut *mut u8, pcbdata : *mut u32, ppwszmimetype : *mut windows_core::PWSTR) -> super::super::Foundation:: BOOL);
    CertRetrieveLogoOrBiometricInfo(pcertcontext, lpszlogoorbiometrictype.param().abi(), dwretrievalflags, dwtimeout, dwflags, core::mem::transmute(pvreserved.unwrap_or(std::ptr::null())), ppbdata, pcbdata, core::mem::transmute(ppwszmimetype.unwrap_or(std::ptr::null_mut()))).ok()
}
#[inline]
pub unsafe fn CertSaveStore<P0>(hcertstore: P0, dwencodingtype: CERT_QUERY_ENCODING_TYPE, dwsaveas: CERT_STORE_SAVE_AS, dwsaveto: CERT_STORE_SAVE_TO, pvsavetopara: *mut core::ffi::c_void, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<HCERTSTORE>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertSaveStore(hcertstore : HCERTSTORE, dwencodingtype : CERT_QUERY_ENCODING_TYPE, dwsaveas : CERT_STORE_SAVE_AS, dwsaveto : CERT_STORE_SAVE_TO, pvsavetopara : *mut core::ffi::c_void, dwflags : u32) -> super::super::Foundation:: BOOL);
    CertSaveStore(hcertstore.param().abi(), dwencodingtype, dwsaveas, dwsaveto, pvsavetopara, dwflags).ok()
}
#[inline]
pub unsafe fn CertSelectCertificateChains<P0>(pselectioncontext: Option<*const windows_core::GUID>, dwflags: u32, pchainparameters: Option<*const CERT_SELECT_CHAIN_PARA>, rgpcriteria: Option<&[CERT_SELECT_CRITERIA]>, hstore: P0, pcselection: *mut u32, pprgpselection: *mut *mut *mut CERT_CHAIN_CONTEXT) -> windows_core::Result<()>
where
    P0: windows_core::Param<HCERTSTORE>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertSelectCertificateChains(pselectioncontext : *const windows_core::GUID, dwflags : u32, pchainparameters : *const CERT_SELECT_CHAIN_PARA, ccriteria : u32, rgpcriteria : *const CERT_SELECT_CRITERIA, hstore : HCERTSTORE, pcselection : *mut u32, pprgpselection : *mut *mut *mut CERT_CHAIN_CONTEXT) -> super::super::Foundation:: BOOL);
    CertSelectCertificateChains(core::mem::transmute(pselectioncontext.unwrap_or(std::ptr::null())), dwflags, core::mem::transmute(pchainparameters.unwrap_or(std::ptr::null())), rgpcriteria.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(rgpcriteria.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), hstore.param().abi(), pcselection, pprgpselection).ok()
}
#[inline]
pub unsafe fn CertSerializeCRLStoreElement(pcrlcontext: *const CRL_CONTEXT, dwflags: u32, pbelement: Option<*mut u8>, pcbelement: *mut u32) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CertSerializeCRLStoreElement(pcrlcontext : *const CRL_CONTEXT, dwflags : u32, pbelement : *mut u8, pcbelement : *mut u32) -> super::super::Foundation:: BOOL);
    CertSerializeCRLStoreElement(pcrlcontext, dwflags, core::mem::transmute(pbelement.unwrap_or(std::ptr::null_mut())), pcbelement).ok()
}
#[inline]
pub unsafe fn CertSerializeCTLStoreElement(pctlcontext: *const CTL_CONTEXT, dwflags: u32, pbelement: Option<*mut u8>, pcbelement: *mut u32) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CertSerializeCTLStoreElement(pctlcontext : *const CTL_CONTEXT, dwflags : u32, pbelement : *mut u8, pcbelement : *mut u32) -> super::super::Foundation:: BOOL);
    CertSerializeCTLStoreElement(pctlcontext, dwflags, core::mem::transmute(pbelement.unwrap_or(std::ptr::null_mut())), pcbelement).ok()
}
#[inline]
pub unsafe fn CertSerializeCertificateStoreElement(pcertcontext: *const CERT_CONTEXT, dwflags: u32, pbelement: Option<*mut u8>, pcbelement: *mut u32) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CertSerializeCertificateStoreElement(pcertcontext : *const CERT_CONTEXT, dwflags : u32, pbelement : *mut u8, pcbelement : *mut u32) -> super::super::Foundation:: BOOL);
    CertSerializeCertificateStoreElement(pcertcontext, dwflags, core::mem::transmute(pbelement.unwrap_or(std::ptr::null_mut())), pcbelement).ok()
}
#[inline]
pub unsafe fn CertSetCRLContextProperty(pcrlcontext: *const CRL_CONTEXT, dwpropid: u32, dwflags: u32, pvdata: Option<*const core::ffi::c_void>) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CertSetCRLContextProperty(pcrlcontext : *const CRL_CONTEXT, dwpropid : u32, dwflags : u32, pvdata : *const core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CertSetCRLContextProperty(pcrlcontext, dwpropid, dwflags, core::mem::transmute(pvdata.unwrap_or(std::ptr::null()))).ok()
}
#[inline]
pub unsafe fn CertSetCTLContextProperty(pctlcontext: *const CTL_CONTEXT, dwpropid: u32, dwflags: u32, pvdata: Option<*const core::ffi::c_void>) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CertSetCTLContextProperty(pctlcontext : *const CTL_CONTEXT, dwpropid : u32, dwflags : u32, pvdata : *const core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CertSetCTLContextProperty(pctlcontext, dwpropid, dwflags, core::mem::transmute(pvdata.unwrap_or(std::ptr::null()))).ok()
}
#[inline]
pub unsafe fn CertSetCertificateContextPropertiesFromCTLEntry(pcertcontext: *const CERT_CONTEXT, pctlentry: *const CTL_ENTRY, dwflags: u32) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CertSetCertificateContextPropertiesFromCTLEntry(pcertcontext : *const CERT_CONTEXT, pctlentry : *const CTL_ENTRY, dwflags : u32) -> super::super::Foundation:: BOOL);
    CertSetCertificateContextPropertiesFromCTLEntry(pcertcontext, pctlentry, dwflags).ok()
}
#[inline]
pub unsafe fn CertSetCertificateContextProperty(pcertcontext: *const CERT_CONTEXT, dwpropid: u32, dwflags: u32, pvdata: Option<*const core::ffi::c_void>) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CertSetCertificateContextProperty(pcertcontext : *const CERT_CONTEXT, dwpropid : u32, dwflags : u32, pvdata : *const core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CertSetCertificateContextProperty(pcertcontext, dwpropid, dwflags, core::mem::transmute(pvdata.unwrap_or(std::ptr::null()))).ok()
}
#[inline]
pub unsafe fn CertSetEnhancedKeyUsage(pcertcontext: *const CERT_CONTEXT, pusage: Option<*const CTL_USAGE>) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CertSetEnhancedKeyUsage(pcertcontext : *const CERT_CONTEXT, pusage : *const CTL_USAGE) -> super::super::Foundation:: BOOL);
    CertSetEnhancedKeyUsage(pcertcontext, core::mem::transmute(pusage.unwrap_or(std::ptr::null()))).ok()
}
#[inline]
pub unsafe fn CertSetStoreProperty<P0>(hcertstore: P0, dwpropid: u32, dwflags: u32, pvdata: Option<*const core::ffi::c_void>) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<HCERTSTORE>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertSetStoreProperty(hcertstore : HCERTSTORE, dwpropid : u32, dwflags : u32, pvdata : *const core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CertSetStoreProperty(hcertstore.param().abi(), dwpropid, dwflags, core::mem::transmute(pvdata.unwrap_or(std::ptr::null())))
}
#[inline]
pub unsafe fn CertStrToNameA<P0>(dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pszx500: P0, dwstrtype: CERT_STRING_TYPE, pvreserved: Option<*const core::ffi::c_void>, pbencoded: Option<*mut u8>, pcbencoded: *mut u32, ppszerror: Option<*mut windows_core::PCSTR>) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertStrToNameA(dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pszx500 : windows_core::PCSTR, dwstrtype : CERT_STRING_TYPE, pvreserved : *const core::ffi::c_void, pbencoded : *mut u8, pcbencoded : *mut u32, ppszerror : *mut windows_core::PCSTR) -> super::super::Foundation:: BOOL);
    CertStrToNameA(dwcertencodingtype, pszx500.param().abi(), dwstrtype, core::mem::transmute(pvreserved.unwrap_or(std::ptr::null())), core::mem::transmute(pbencoded.unwrap_or(std::ptr::null_mut())), pcbencoded, core::mem::transmute(ppszerror.unwrap_or(std::ptr::null_mut()))).ok()
}
#[inline]
pub unsafe fn CertStrToNameW<P0>(dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pszx500: P0, dwstrtype: CERT_STRING_TYPE, pvreserved: Option<*const core::ffi::c_void>, pbencoded: Option<*mut u8>, pcbencoded: *mut u32, ppszerror: Option<*mut windows_core::PCWSTR>) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertStrToNameW(dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pszx500 : windows_core::PCWSTR, dwstrtype : CERT_STRING_TYPE, pvreserved : *const core::ffi::c_void, pbencoded : *mut u8, pcbencoded : *mut u32, ppszerror : *mut windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    CertStrToNameW(dwcertencodingtype, pszx500.param().abi(), dwstrtype, core::mem::transmute(pvreserved.unwrap_or(std::ptr::null())), core::mem::transmute(pbencoded.unwrap_or(std::ptr::null_mut())), pcbencoded, core::mem::transmute(ppszerror.unwrap_or(std::ptr::null_mut()))).ok()
}
#[inline]
pub unsafe fn CertUnregisterPhysicalStore<P0>(pvsystemstore: *const core::ffi::c_void, dwflags: u32, pwszstorename: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertUnregisterPhysicalStore(pvsystemstore : *const core::ffi::c_void, dwflags : u32, pwszstorename : windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    CertUnregisterPhysicalStore(pvsystemstore, dwflags, pwszstorename.param().abi())
}
#[inline]
pub unsafe fn CertUnregisterSystemStore(pvsystemstore: *const core::ffi::c_void, dwflags: u32) -> super::super::Foundation::BOOL {
    windows_targets::link!("crypt32.dll" "system" fn CertUnregisterSystemStore(pvsystemstore : *const core::ffi::c_void, dwflags : u32) -> super::super::Foundation:: BOOL);
    CertUnregisterSystemStore(pvsystemstore, dwflags)
}
#[inline]
pub unsafe fn CertVerifyCRLRevocation(dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pcertid: *const CERT_INFO, rgpcrlinfo: &[*const CRL_INFO]) -> super::super::Foundation::BOOL {
    windows_targets::link!("crypt32.dll" "system" fn CertVerifyCRLRevocation(dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pcertid : *const CERT_INFO, ccrlinfo : u32, rgpcrlinfo : *const *const CRL_INFO) -> super::super::Foundation:: BOOL);
    CertVerifyCRLRevocation(dwcertencodingtype, pcertid, rgpcrlinfo.len().try_into().unwrap(), core::mem::transmute(rgpcrlinfo.as_ptr()))
}
#[inline]
pub unsafe fn CertVerifyCRLTimeValidity(ptimetoverify: Option<*const super::super::Foundation::FILETIME>, pcrlinfo: *const CRL_INFO) -> i32 {
    windows_targets::link!("crypt32.dll" "system" fn CertVerifyCRLTimeValidity(ptimetoverify : *const super::super::Foundation:: FILETIME, pcrlinfo : *const CRL_INFO) -> i32);
    CertVerifyCRLTimeValidity(core::mem::transmute(ptimetoverify.unwrap_or(std::ptr::null())), pcrlinfo)
}
#[inline]
pub unsafe fn CertVerifyCTLUsage(dwencodingtype: u32, dwsubjecttype: u32, pvsubject: *const core::ffi::c_void, psubjectusage: *const CTL_USAGE, dwflags: u32, pverifyusagepara: Option<*const CTL_VERIFY_USAGE_PARA>, pverifyusagestatus: *mut CTL_VERIFY_USAGE_STATUS) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CertVerifyCTLUsage(dwencodingtype : u32, dwsubjecttype : u32, pvsubject : *const core::ffi::c_void, psubjectusage : *const CTL_USAGE, dwflags : u32, pverifyusagepara : *const CTL_VERIFY_USAGE_PARA, pverifyusagestatus : *mut CTL_VERIFY_USAGE_STATUS) -> super::super::Foundation:: BOOL);
    CertVerifyCTLUsage(dwencodingtype, dwsubjecttype, pvsubject, psubjectusage, dwflags, core::mem::transmute(pverifyusagepara.unwrap_or(std::ptr::null())), pverifyusagestatus).ok()
}
#[inline]
pub unsafe fn CertVerifyCertificateChainPolicy<P0>(pszpolicyoid: P0, pchaincontext: *const CERT_CHAIN_CONTEXT, ppolicypara: *const CERT_CHAIN_POLICY_PARA, ppolicystatus: *mut CERT_CHAIN_POLICY_STATUS) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CertVerifyCertificateChainPolicy(pszpolicyoid : windows_core::PCSTR, pchaincontext : *const CERT_CHAIN_CONTEXT, ppolicypara : *const CERT_CHAIN_POLICY_PARA, ppolicystatus : *mut CERT_CHAIN_POLICY_STATUS) -> super::super::Foundation:: BOOL);
    CertVerifyCertificateChainPolicy(pszpolicyoid.param().abi(), pchaincontext, ppolicypara, ppolicystatus)
}
#[inline]
pub unsafe fn CertVerifyRevocation(dwencodingtype: u32, dwrevtype: u32, rgpvcontext: &[*const core::ffi::c_void], dwflags: u32, prevpara: Option<*const CERT_REVOCATION_PARA>, prevstatus: *mut CERT_REVOCATION_STATUS) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CertVerifyRevocation(dwencodingtype : u32, dwrevtype : u32, ccontext : u32, rgpvcontext : *const *const core::ffi::c_void, dwflags : u32, prevpara : *const CERT_REVOCATION_PARA, prevstatus : *mut CERT_REVOCATION_STATUS) -> super::super::Foundation:: BOOL);
    CertVerifyRevocation(dwencodingtype, dwrevtype, rgpvcontext.len().try_into().unwrap(), core::mem::transmute(rgpvcontext.as_ptr()), dwflags, core::mem::transmute(prevpara.unwrap_or(std::ptr::null())), prevstatus).ok()
}
#[inline]
pub unsafe fn CertVerifySubjectCertificateContext(psubject: *const CERT_CONTEXT, pissuer: Option<*const CERT_CONTEXT>, pdwflags: *mut u32) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CertVerifySubjectCertificateContext(psubject : *const CERT_CONTEXT, pissuer : *const CERT_CONTEXT, pdwflags : *mut u32) -> super::super::Foundation:: BOOL);
    CertVerifySubjectCertificateContext(psubject, core::mem::transmute(pissuer.unwrap_or(std::ptr::null())), pdwflags).ok()
}
#[inline]
pub unsafe fn CertVerifyTimeValidity(ptimetoverify: Option<*const super::super::Foundation::FILETIME>, pcertinfo: *const CERT_INFO) -> i32 {
    windows_targets::link!("crypt32.dll" "system" fn CertVerifyTimeValidity(ptimetoverify : *const super::super::Foundation:: FILETIME, pcertinfo : *const CERT_INFO) -> i32);
    CertVerifyTimeValidity(core::mem::transmute(ptimetoverify.unwrap_or(std::ptr::null())), pcertinfo)
}
#[inline]
pub unsafe fn CertVerifyValidityNesting(psubjectinfo: *const CERT_INFO, pissuerinfo: *const CERT_INFO) -> super::super::Foundation::BOOL {
    windows_targets::link!("crypt32.dll" "system" fn CertVerifyValidityNesting(psubjectinfo : *const CERT_INFO, pissuerinfo : *const CERT_INFO) -> super::super::Foundation:: BOOL);
    CertVerifyValidityNesting(psubjectinfo, pissuerinfo)
}
#[inline]
pub unsafe fn CloseCryptoHandle(hcrypto: *const INFORMATIONCARD_CRYPTO_HANDLE) -> windows_core::Result<()> {
    windows_targets::link!("infocardapi.dll" "system" fn CloseCryptoHandle(hcrypto : *const INFORMATIONCARD_CRYPTO_HANDLE) -> windows_core::HRESULT);
    CloseCryptoHandle(hcrypto).ok()
}
#[inline]
pub unsafe fn CryptAcquireCertificatePrivateKey(pcert: *const CERT_CONTEXT, dwflags: CRYPT_ACQUIRE_FLAGS, pvparameters: Option<*const core::ffi::c_void>, phcryptprovorncryptkey: *mut HCRYPTPROV_OR_NCRYPT_KEY_HANDLE, pdwkeyspec: Option<*mut CERT_KEY_SPEC>, pfcallerfreeprovorncryptkey: Option<*mut super::super::Foundation::BOOL>) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CryptAcquireCertificatePrivateKey(pcert : *const CERT_CONTEXT, dwflags : CRYPT_ACQUIRE_FLAGS, pvparameters : *const core::ffi::c_void, phcryptprovorncryptkey : *mut HCRYPTPROV_OR_NCRYPT_KEY_HANDLE, pdwkeyspec : *mut CERT_KEY_SPEC, pfcallerfreeprovorncryptkey : *mut super::super::Foundation:: BOOL) -> super::super::Foundation:: BOOL);
    CryptAcquireCertificatePrivateKey(pcert, dwflags, core::mem::transmute(pvparameters.unwrap_or(std::ptr::null())), phcryptprovorncryptkey, core::mem::transmute(pdwkeyspec.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pfcallerfreeprovorncryptkey.unwrap_or(std::ptr::null_mut()))).ok()
}
#[inline]
pub unsafe fn CryptAcquireContextA<P0, P1>(phprov: *mut usize, szcontainer: P0, szprovider: P1, dwprovtype: u32, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("advapi32.dll" "system" fn CryptAcquireContextA(phprov : *mut usize, szcontainer : windows_core::PCSTR, szprovider : windows_core::PCSTR, dwprovtype : u32, dwflags : u32) -> super::super::Foundation:: BOOL);
    CryptAcquireContextA(phprov, szcontainer.param().abi(), szprovider.param().abi(), dwprovtype, dwflags).ok()
}
#[inline]
pub unsafe fn CryptAcquireContextW<P0, P1>(phprov: *mut usize, szcontainer: P0, szprovider: P1, dwprovtype: u32, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("advapi32.dll" "system" fn CryptAcquireContextW(phprov : *mut usize, szcontainer : windows_core::PCWSTR, szprovider : windows_core::PCWSTR, dwprovtype : u32, dwflags : u32) -> super::super::Foundation:: BOOL);
    CryptAcquireContextW(phprov, szcontainer.param().abi(), szprovider.param().abi(), dwprovtype, dwflags).ok()
}
#[inline]
pub unsafe fn CryptBinaryToStringA(pbbinary: &[u8], dwflags: CRYPT_STRING, pszstring: windows_core::PSTR, pcchstring: *mut u32) -> super::super::Foundation::BOOL {
    windows_targets::link!("crypt32.dll" "system" fn CryptBinaryToStringA(pbbinary : *const u8, cbbinary : u32, dwflags : CRYPT_STRING, pszstring : windows_core::PSTR, pcchstring : *mut u32) -> super::super::Foundation:: BOOL);
    CryptBinaryToStringA(core::mem::transmute(pbbinary.as_ptr()), pbbinary.len().try_into().unwrap(), dwflags, core::mem::transmute(pszstring), pcchstring)
}
#[inline]
pub unsafe fn CryptBinaryToStringW(pbbinary: &[u8], dwflags: CRYPT_STRING, pszstring: windows_core::PWSTR, pcchstring: *mut u32) -> super::super::Foundation::BOOL {
    windows_targets::link!("crypt32.dll" "system" fn CryptBinaryToStringW(pbbinary : *const u8, cbbinary : u32, dwflags : CRYPT_STRING, pszstring : windows_core::PWSTR, pcchstring : *mut u32) -> super::super::Foundation:: BOOL);
    CryptBinaryToStringW(core::mem::transmute(pbbinary.as_ptr()), pbbinary.len().try_into().unwrap(), dwflags, core::mem::transmute(pszstring), pcchstring)
}
#[inline]
pub unsafe fn CryptCloseAsyncHandle<P0>(hasync: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<HCRYPTASYNC>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptCloseAsyncHandle(hasync : HCRYPTASYNC) -> super::super::Foundation:: BOOL);
    CryptCloseAsyncHandle(hasync.param().abi())
}
#[inline]
pub unsafe fn CryptContextAddRef(hprov: usize, pdwreserved: Option<*const u32>, dwflags: u32) -> windows_core::Result<()> {
    windows_targets::link!("advapi32.dll" "system" fn CryptContextAddRef(hprov : usize, pdwreserved : *const u32, dwflags : u32) -> super::super::Foundation:: BOOL);
    CryptContextAddRef(hprov, core::mem::transmute(pdwreserved.unwrap_or(std::ptr::null())), dwflags).ok()
}
#[inline]
pub unsafe fn CryptCreateAsyncHandle(dwflags: u32, phasync: *mut HCRYPTASYNC) -> super::super::Foundation::BOOL {
    windows_targets::link!("crypt32.dll" "system" fn CryptCreateAsyncHandle(dwflags : u32, phasync : *mut HCRYPTASYNC) -> super::super::Foundation:: BOOL);
    CryptCreateAsyncHandle(dwflags, phasync)
}
#[inline]
pub unsafe fn CryptCreateHash(hprov: usize, algid: ALG_ID, hkey: usize, dwflags: u32, phhash: *mut usize) -> windows_core::Result<()> {
    windows_targets::link!("advapi32.dll" "system" fn CryptCreateHash(hprov : usize, algid : ALG_ID, hkey : usize, dwflags : u32, phhash : *mut usize) -> super::super::Foundation:: BOOL);
    CryptCreateHash(hprov, algid, hkey, dwflags, phhash).ok()
}
#[inline]
pub unsafe fn CryptCreateKeyIdentifierFromCSP<P0>(dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pszpubkeyoid: P0, ppubkeystruc: *const PUBLICKEYSTRUC, cbpubkeystruc: u32, dwflags: u32, pvreserved: Option<*const core::ffi::c_void>, pbhash: Option<*mut u8>, pcbhash: *mut u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptCreateKeyIdentifierFromCSP(dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pszpubkeyoid : windows_core::PCSTR, ppubkeystruc : *const PUBLICKEYSTRUC, cbpubkeystruc : u32, dwflags : u32, pvreserved : *const core::ffi::c_void, pbhash : *mut u8, pcbhash : *mut u32) -> super::super::Foundation:: BOOL);
    CryptCreateKeyIdentifierFromCSP(dwcertencodingtype, pszpubkeyoid.param().abi(), ppubkeystruc, cbpubkeystruc, dwflags, core::mem::transmute(pvreserved.unwrap_or(std::ptr::null())), core::mem::transmute(pbhash.unwrap_or(std::ptr::null_mut())), pcbhash).ok()
}
#[inline]
pub unsafe fn CryptDecodeMessage(dwmsgtypeflags: u32, pdecryptpara: Option<*const CRYPT_DECRYPT_MESSAGE_PARA>, pverifypara: Option<*const CRYPT_VERIFY_MESSAGE_PARA>, dwsignerindex: u32, pbencodedblob: &[u8], dwprevinnercontenttype: u32, pdwmsgtype: Option<*mut u32>, pdwinnercontenttype: Option<*mut u32>, pbdecoded: Option<*mut u8>, pcbdecoded: Option<*mut u32>, ppxchgcert: Option<*mut *mut CERT_CONTEXT>, ppsignercert: Option<*mut *mut CERT_CONTEXT>) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CryptDecodeMessage(dwmsgtypeflags : u32, pdecryptpara : *const CRYPT_DECRYPT_MESSAGE_PARA, pverifypara : *const CRYPT_VERIFY_MESSAGE_PARA, dwsignerindex : u32, pbencodedblob : *const u8, cbencodedblob : u32, dwprevinnercontenttype : u32, pdwmsgtype : *mut u32, pdwinnercontenttype : *mut u32, pbdecoded : *mut u8, pcbdecoded : *mut u32, ppxchgcert : *mut *mut CERT_CONTEXT, ppsignercert : *mut *mut CERT_CONTEXT) -> super::super::Foundation:: BOOL);
    CryptDecodeMessage(
        dwmsgtypeflags,
        core::mem::transmute(pdecryptpara.unwrap_or(std::ptr::null())),
        core::mem::transmute(pverifypara.unwrap_or(std::ptr::null())),
        dwsignerindex,
        core::mem::transmute(pbencodedblob.as_ptr()),
        pbencodedblob.len().try_into().unwrap(),
        dwprevinnercontenttype,
        core::mem::transmute(pdwmsgtype.unwrap_or(std::ptr::null_mut())),
        core::mem::transmute(pdwinnercontenttype.unwrap_or(std::ptr::null_mut())),
        core::mem::transmute(pbdecoded.unwrap_or(std::ptr::null_mut())),
        core::mem::transmute(pcbdecoded.unwrap_or(std::ptr::null_mut())),
        core::mem::transmute(ppxchgcert.unwrap_or(std::ptr::null_mut())),
        core::mem::transmute(ppsignercert.unwrap_or(std::ptr::null_mut())),
    )
    .ok()
}
#[inline]
pub unsafe fn CryptDecodeObject<P0>(dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, lpszstructtype: P0, pbencoded: &[u8], dwflags: u32, pvstructinfo: Option<*mut core::ffi::c_void>, pcbstructinfo: *mut u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptDecodeObject(dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, lpszstructtype : windows_core::PCSTR, pbencoded : *const u8, cbencoded : u32, dwflags : u32, pvstructinfo : *mut core::ffi::c_void, pcbstructinfo : *mut u32) -> super::super::Foundation:: BOOL);
    CryptDecodeObject(dwcertencodingtype, lpszstructtype.param().abi(), core::mem::transmute(pbencoded.as_ptr()), pbencoded.len().try_into().unwrap(), dwflags, core::mem::transmute(pvstructinfo.unwrap_or(std::ptr::null_mut())), pcbstructinfo).ok()
}
#[inline]
pub unsafe fn CryptDecodeObjectEx<P0>(dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, lpszstructtype: P0, pbencoded: &[u8], dwflags: u32, pdecodepara: Option<*const CRYPT_DECODE_PARA>, pvstructinfo: Option<*mut core::ffi::c_void>, pcbstructinfo: *mut u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptDecodeObjectEx(dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, lpszstructtype : windows_core::PCSTR, pbencoded : *const u8, cbencoded : u32, dwflags : u32, pdecodepara : *const CRYPT_DECODE_PARA, pvstructinfo : *mut core::ffi::c_void, pcbstructinfo : *mut u32) -> super::super::Foundation:: BOOL);
    CryptDecodeObjectEx(dwcertencodingtype, lpszstructtype.param().abi(), core::mem::transmute(pbencoded.as_ptr()), pbencoded.len().try_into().unwrap(), dwflags, core::mem::transmute(pdecodepara.unwrap_or(std::ptr::null())), core::mem::transmute(pvstructinfo.unwrap_or(std::ptr::null_mut())), pcbstructinfo).ok()
}
#[inline]
pub unsafe fn CryptDecrypt<P0>(hkey: usize, hhash: usize, r#final: P0, dwflags: u32, pbdata: *mut u8, pdwdatalen: *mut u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::Foundation::BOOL>,
{
    windows_targets::link!("advapi32.dll" "system" fn CryptDecrypt(hkey : usize, hhash : usize, r#final : super::super::Foundation:: BOOL, dwflags : u32, pbdata : *mut u8, pdwdatalen : *mut u32) -> super::super::Foundation:: BOOL);
    CryptDecrypt(hkey, hhash, r#final.param().abi(), dwflags, pbdata, pdwdatalen).ok()
}
#[inline]
pub unsafe fn CryptDecryptAndVerifyMessageSignature(pdecryptpara: *const CRYPT_DECRYPT_MESSAGE_PARA, pverifypara: *const CRYPT_VERIFY_MESSAGE_PARA, dwsignerindex: u32, pbencryptedblob: &[u8], pbdecrypted: Option<*mut u8>, pcbdecrypted: Option<*mut u32>, ppxchgcert: Option<*mut *mut CERT_CONTEXT>, ppsignercert: Option<*mut *mut CERT_CONTEXT>) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CryptDecryptAndVerifyMessageSignature(pdecryptpara : *const CRYPT_DECRYPT_MESSAGE_PARA, pverifypara : *const CRYPT_VERIFY_MESSAGE_PARA, dwsignerindex : u32, pbencryptedblob : *const u8, cbencryptedblob : u32, pbdecrypted : *mut u8, pcbdecrypted : *mut u32, ppxchgcert : *mut *mut CERT_CONTEXT, ppsignercert : *mut *mut CERT_CONTEXT) -> super::super::Foundation:: BOOL);
    CryptDecryptAndVerifyMessageSignature(pdecryptpara, pverifypara, dwsignerindex, core::mem::transmute(pbencryptedblob.as_ptr()), pbencryptedblob.len().try_into().unwrap(), core::mem::transmute(pbdecrypted.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pcbdecrypted.unwrap_or(std::ptr::null_mut())), core::mem::transmute(ppxchgcert.unwrap_or(std::ptr::null_mut())), core::mem::transmute(ppsignercert.unwrap_or(std::ptr::null_mut()))).ok()
}
#[inline]
pub unsafe fn CryptDecryptMessage(pdecryptpara: *const CRYPT_DECRYPT_MESSAGE_PARA, pbencryptedblob: &[u8], pbdecrypted: Option<*mut u8>, pcbdecrypted: Option<*mut u32>, ppxchgcert: Option<*mut *mut CERT_CONTEXT>) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CryptDecryptMessage(pdecryptpara : *const CRYPT_DECRYPT_MESSAGE_PARA, pbencryptedblob : *const u8, cbencryptedblob : u32, pbdecrypted : *mut u8, pcbdecrypted : *mut u32, ppxchgcert : *mut *mut CERT_CONTEXT) -> super::super::Foundation:: BOOL);
    CryptDecryptMessage(pdecryptpara, core::mem::transmute(pbencryptedblob.as_ptr()), pbencryptedblob.len().try_into().unwrap(), core::mem::transmute(pbdecrypted.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pcbdecrypted.unwrap_or(std::ptr::null_mut())), core::mem::transmute(ppxchgcert.unwrap_or(std::ptr::null_mut()))).ok()
}
#[inline]
pub unsafe fn CryptDeriveKey(hprov: usize, algid: ALG_ID, hbasedata: usize, dwflags: u32, phkey: *mut usize) -> windows_core::Result<()> {
    windows_targets::link!("advapi32.dll" "system" fn CryptDeriveKey(hprov : usize, algid : ALG_ID, hbasedata : usize, dwflags : u32, phkey : *mut usize) -> super::super::Foundation:: BOOL);
    CryptDeriveKey(hprov, algid, hbasedata, dwflags, phkey).ok()
}
#[inline]
pub unsafe fn CryptDestroyHash(hhash: usize) -> windows_core::Result<()> {
    windows_targets::link!("advapi32.dll" "system" fn CryptDestroyHash(hhash : usize) -> super::super::Foundation:: BOOL);
    CryptDestroyHash(hhash).ok()
}
#[inline]
pub unsafe fn CryptDestroyKey(hkey: usize) -> windows_core::Result<()> {
    windows_targets::link!("advapi32.dll" "system" fn CryptDestroyKey(hkey : usize) -> super::super::Foundation:: BOOL);
    CryptDestroyKey(hkey).ok()
}
#[inline]
pub unsafe fn CryptDuplicateHash(hhash: usize, pdwreserved: Option<*const u32>, dwflags: u32, phhash: *mut usize) -> windows_core::Result<()> {
    windows_targets::link!("advapi32.dll" "system" fn CryptDuplicateHash(hhash : usize, pdwreserved : *const u32, dwflags : u32, phhash : *mut usize) -> super::super::Foundation:: BOOL);
    CryptDuplicateHash(hhash, core::mem::transmute(pdwreserved.unwrap_or(std::ptr::null())), dwflags, phhash).ok()
}
#[inline]
pub unsafe fn CryptDuplicateKey(hkey: usize, pdwreserved: Option<*const u32>, dwflags: u32, phkey: *mut usize) -> windows_core::Result<()> {
    windows_targets::link!("advapi32.dll" "system" fn CryptDuplicateKey(hkey : usize, pdwreserved : *const u32, dwflags : u32, phkey : *mut usize) -> super::super::Foundation:: BOOL);
    CryptDuplicateKey(hkey, core::mem::transmute(pdwreserved.unwrap_or(std::ptr::null())), dwflags, phkey).ok()
}
#[inline]
pub unsafe fn CryptEncodeObject<P0>(dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, lpszstructtype: P0, pvstructinfo: *const core::ffi::c_void, pbencoded: Option<*mut u8>, pcbencoded: *mut u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptEncodeObject(dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, lpszstructtype : windows_core::PCSTR, pvstructinfo : *const core::ffi::c_void, pbencoded : *mut u8, pcbencoded : *mut u32) -> super::super::Foundation:: BOOL);
    CryptEncodeObject(dwcertencodingtype, lpszstructtype.param().abi(), pvstructinfo, core::mem::transmute(pbencoded.unwrap_or(std::ptr::null_mut())), pcbencoded).ok()
}
#[inline]
pub unsafe fn CryptEncodeObjectEx<P0>(dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, lpszstructtype: P0, pvstructinfo: *const core::ffi::c_void, dwflags: CRYPT_ENCODE_OBJECT_FLAGS, pencodepara: Option<*const CRYPT_ENCODE_PARA>, pvencoded: Option<*mut core::ffi::c_void>, pcbencoded: *mut u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptEncodeObjectEx(dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, lpszstructtype : windows_core::PCSTR, pvstructinfo : *const core::ffi::c_void, dwflags : CRYPT_ENCODE_OBJECT_FLAGS, pencodepara : *const CRYPT_ENCODE_PARA, pvencoded : *mut core::ffi::c_void, pcbencoded : *mut u32) -> super::super::Foundation:: BOOL);
    CryptEncodeObjectEx(dwcertencodingtype, lpszstructtype.param().abi(), pvstructinfo, dwflags, core::mem::transmute(pencodepara.unwrap_or(std::ptr::null())), core::mem::transmute(pvencoded.unwrap_or(std::ptr::null_mut())), pcbencoded).ok()
}
#[inline]
pub unsafe fn CryptEncrypt<P0>(hkey: usize, hhash: usize, r#final: P0, dwflags: u32, pbdata: Option<&mut [u8]>, pdwdatalen: *mut u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::Foundation::BOOL>,
{
    windows_targets::link!("advapi32.dll" "system" fn CryptEncrypt(hkey : usize, hhash : usize, r#final : super::super::Foundation:: BOOL, dwflags : u32, pbdata : *mut u8, pdwdatalen : *mut u32, dwbuflen : u32) -> super::super::Foundation:: BOOL);
    CryptEncrypt(hkey, hhash, r#final.param().abi(), dwflags, core::mem::transmute(pbdata.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), pdwdatalen, pbdata.as_deref().map_or(0, |slice| slice.len().try_into().unwrap())).ok()
}
#[inline]
pub unsafe fn CryptEncryptMessage(pencryptpara: *const CRYPT_ENCRYPT_MESSAGE_PARA, rgprecipientcert: &[*const CERT_CONTEXT], pbtobeencrypted: Option<&[u8]>, pbencryptedblob: Option<*mut u8>, pcbencryptedblob: *mut u32) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CryptEncryptMessage(pencryptpara : *const CRYPT_ENCRYPT_MESSAGE_PARA, crecipientcert : u32, rgprecipientcert : *const *const CERT_CONTEXT, pbtobeencrypted : *const u8, cbtobeencrypted : u32, pbencryptedblob : *mut u8, pcbencryptedblob : *mut u32) -> super::super::Foundation:: BOOL);
    CryptEncryptMessage(pencryptpara, rgprecipientcert.len().try_into().unwrap(), core::mem::transmute(rgprecipientcert.as_ptr()), core::mem::transmute(pbtobeencrypted.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), pbtobeencrypted.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(pbencryptedblob.unwrap_or(std::ptr::null_mut())), pcbencryptedblob).ok()
}
#[inline]
pub unsafe fn CryptEnumKeyIdentifierProperties<P0>(pkeyidentifier: Option<*const CRYPT_INTEGER_BLOB>, dwpropid: u32, dwflags: u32, pwszcomputername: P0, pvreserved: Option<*const core::ffi::c_void>, pvarg: Option<*mut core::ffi::c_void>, pfnenum: PFN_CRYPT_ENUM_KEYID_PROP) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptEnumKeyIdentifierProperties(pkeyidentifier : *const CRYPT_INTEGER_BLOB, dwpropid : u32, dwflags : u32, pwszcomputername : windows_core::PCWSTR, pvreserved : *const core::ffi::c_void, pvarg : *mut core::ffi::c_void, pfnenum : PFN_CRYPT_ENUM_KEYID_PROP) -> super::super::Foundation:: BOOL);
    CryptEnumKeyIdentifierProperties(core::mem::transmute(pkeyidentifier.unwrap_or(std::ptr::null())), dwpropid, dwflags, pwszcomputername.param().abi(), core::mem::transmute(pvreserved.unwrap_or(std::ptr::null())), core::mem::transmute(pvarg.unwrap_or(std::ptr::null_mut())), pfnenum).ok()
}
#[inline]
pub unsafe fn CryptEnumOIDFunction<P0, P1>(dwencodingtype: u32, pszfuncname: P0, pszoid: P1, dwflags: u32, pvarg: Option<*mut core::ffi::c_void>, pfnenumoidfunc: PFN_CRYPT_ENUM_OID_FUNC) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptEnumOIDFunction(dwencodingtype : u32, pszfuncname : windows_core::PCSTR, pszoid : windows_core::PCSTR, dwflags : u32, pvarg : *mut core::ffi::c_void, pfnenumoidfunc : PFN_CRYPT_ENUM_OID_FUNC) -> super::super::Foundation:: BOOL);
    CryptEnumOIDFunction(dwencodingtype, pszfuncname.param().abi(), pszoid.param().abi(), dwflags, core::mem::transmute(pvarg.unwrap_or(std::ptr::null_mut())), pfnenumoidfunc).ok()
}
#[inline]
pub unsafe fn CryptEnumOIDInfo(dwgroupid: u32, dwflags: u32, pvarg: Option<*mut core::ffi::c_void>, pfnenumoidinfo: PFN_CRYPT_ENUM_OID_INFO) -> super::super::Foundation::BOOL {
    windows_targets::link!("crypt32.dll" "system" fn CryptEnumOIDInfo(dwgroupid : u32, dwflags : u32, pvarg : *mut core::ffi::c_void, pfnenumoidinfo : PFN_CRYPT_ENUM_OID_INFO) -> super::super::Foundation:: BOOL);
    CryptEnumOIDInfo(dwgroupid, dwflags, core::mem::transmute(pvarg.unwrap_or(std::ptr::null_mut())), pfnenumoidinfo)
}
#[inline]
pub unsafe fn CryptEnumProviderTypesA(dwindex: u32, pdwreserved: Option<*const u32>, dwflags: u32, pdwprovtype: *mut u32, sztypename: windows_core::PSTR, pcbtypename: *mut u32) -> windows_core::Result<()> {
    windows_targets::link!("advapi32.dll" "system" fn CryptEnumProviderTypesA(dwindex : u32, pdwreserved : *const u32, dwflags : u32, pdwprovtype : *mut u32, sztypename : windows_core::PSTR, pcbtypename : *mut u32) -> super::super::Foundation:: BOOL);
    CryptEnumProviderTypesA(dwindex, core::mem::transmute(pdwreserved.unwrap_or(std::ptr::null())), dwflags, pdwprovtype, core::mem::transmute(sztypename), pcbtypename).ok()
}
#[inline]
pub unsafe fn CryptEnumProviderTypesW(dwindex: u32, pdwreserved: Option<*const u32>, dwflags: u32, pdwprovtype: *mut u32, sztypename: windows_core::PWSTR, pcbtypename: *mut u32) -> windows_core::Result<()> {
    windows_targets::link!("advapi32.dll" "system" fn CryptEnumProviderTypesW(dwindex : u32, pdwreserved : *const u32, dwflags : u32, pdwprovtype : *mut u32, sztypename : windows_core::PWSTR, pcbtypename : *mut u32) -> super::super::Foundation:: BOOL);
    CryptEnumProviderTypesW(dwindex, core::mem::transmute(pdwreserved.unwrap_or(std::ptr::null())), dwflags, pdwprovtype, core::mem::transmute(sztypename), pcbtypename).ok()
}
#[inline]
pub unsafe fn CryptEnumProvidersA(dwindex: u32, pdwreserved: Option<*const u32>, dwflags: u32, pdwprovtype: *mut u32, szprovname: windows_core::PSTR, pcbprovname: *mut u32) -> windows_core::Result<()> {
    windows_targets::link!("advapi32.dll" "system" fn CryptEnumProvidersA(dwindex : u32, pdwreserved : *const u32, dwflags : u32, pdwprovtype : *mut u32, szprovname : windows_core::PSTR, pcbprovname : *mut u32) -> super::super::Foundation:: BOOL);
    CryptEnumProvidersA(dwindex, core::mem::transmute(pdwreserved.unwrap_or(std::ptr::null())), dwflags, pdwprovtype, core::mem::transmute(szprovname), pcbprovname).ok()
}
#[inline]
pub unsafe fn CryptEnumProvidersW(dwindex: u32, pdwreserved: Option<*const u32>, dwflags: u32, pdwprovtype: *mut u32, szprovname: windows_core::PWSTR, pcbprovname: *mut u32) -> windows_core::Result<()> {
    windows_targets::link!("advapi32.dll" "system" fn CryptEnumProvidersW(dwindex : u32, pdwreserved : *const u32, dwflags : u32, pdwprovtype : *mut u32, szprovname : windows_core::PWSTR, pcbprovname : *mut u32) -> super::super::Foundation:: BOOL);
    CryptEnumProvidersW(dwindex, core::mem::transmute(pdwreserved.unwrap_or(std::ptr::null())), dwflags, pdwprovtype, core::mem::transmute(szprovname), pcbprovname).ok()
}
#[inline]
pub unsafe fn CryptExportKey(hkey: usize, hexpkey: usize, dwblobtype: u32, dwflags: CRYPT_KEY_FLAGS, pbdata: Option<*mut u8>, pdwdatalen: *mut u32) -> windows_core::Result<()> {
    windows_targets::link!("advapi32.dll" "system" fn CryptExportKey(hkey : usize, hexpkey : usize, dwblobtype : u32, dwflags : CRYPT_KEY_FLAGS, pbdata : *mut u8, pdwdatalen : *mut u32) -> super::super::Foundation:: BOOL);
    CryptExportKey(hkey, hexpkey, dwblobtype, dwflags, core::mem::transmute(pbdata.unwrap_or(std::ptr::null_mut())), pdwdatalen).ok()
}
#[inline]
pub unsafe fn CryptExportPKCS8<P0>(hcryptprov: usize, dwkeyspec: u32, pszprivatekeyobjid: P0, dwflags: u32, pvauxinfo: Option<*const core::ffi::c_void>, pbprivatekeyblob: Option<*mut u8>, pcbprivatekeyblob: *mut u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptExportPKCS8(hcryptprov : usize, dwkeyspec : u32, pszprivatekeyobjid : windows_core::PCSTR, dwflags : u32, pvauxinfo : *const core::ffi::c_void, pbprivatekeyblob : *mut u8, pcbprivatekeyblob : *mut u32) -> super::super::Foundation:: BOOL);
    CryptExportPKCS8(hcryptprov, dwkeyspec, pszprivatekeyobjid.param().abi(), dwflags, core::mem::transmute(pvauxinfo.unwrap_or(std::ptr::null())), core::mem::transmute(pbprivatekeyblob.unwrap_or(std::ptr::null_mut())), pcbprivatekeyblob).ok()
}
#[inline]
pub unsafe fn CryptExportPublicKeyInfo<P0>(hcryptprovorncryptkey: P0, dwkeyspec: u32, dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pinfo: Option<*mut CERT_PUBLIC_KEY_INFO>, pcbinfo: *mut u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<HCRYPTPROV_OR_NCRYPT_KEY_HANDLE>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptExportPublicKeyInfo(hcryptprovorncryptkey : HCRYPTPROV_OR_NCRYPT_KEY_HANDLE, dwkeyspec : u32, dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pinfo : *mut CERT_PUBLIC_KEY_INFO, pcbinfo : *mut u32) -> super::super::Foundation:: BOOL);
    CryptExportPublicKeyInfo(hcryptprovorncryptkey.param().abi(), dwkeyspec, dwcertencodingtype, core::mem::transmute(pinfo.unwrap_or(std::ptr::null_mut())), pcbinfo).ok()
}
#[inline]
pub unsafe fn CryptExportPublicKeyInfoEx<P0, P1>(hcryptprovorncryptkey: P0, dwkeyspec: u32, dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pszpublickeyobjid: P1, dwflags: u32, pvauxinfo: Option<*const core::ffi::c_void>, pinfo: Option<*mut CERT_PUBLIC_KEY_INFO>, pcbinfo: *mut u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<HCRYPTPROV_OR_NCRYPT_KEY_HANDLE>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptExportPublicKeyInfoEx(hcryptprovorncryptkey : HCRYPTPROV_OR_NCRYPT_KEY_HANDLE, dwkeyspec : u32, dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pszpublickeyobjid : windows_core::PCSTR, dwflags : u32, pvauxinfo : *const core::ffi::c_void, pinfo : *mut CERT_PUBLIC_KEY_INFO, pcbinfo : *mut u32) -> super::super::Foundation:: BOOL);
    CryptExportPublicKeyInfoEx(hcryptprovorncryptkey.param().abi(), dwkeyspec, dwcertencodingtype, pszpublickeyobjid.param().abi(), dwflags, core::mem::transmute(pvauxinfo.unwrap_or(std::ptr::null())), core::mem::transmute(pinfo.unwrap_or(std::ptr::null_mut())), pcbinfo).ok()
}
#[inline]
pub unsafe fn CryptExportPublicKeyInfoFromBCryptKeyHandle<P0, P1>(hbcryptkey: P0, dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pszpublickeyobjid: P1, dwflags: u32, pvauxinfo: Option<*const core::ffi::c_void>, pinfo: Option<*mut CERT_PUBLIC_KEY_INFO>, pcbinfo: *mut u32) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<BCRYPT_KEY_HANDLE>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptExportPublicKeyInfoFromBCryptKeyHandle(hbcryptkey : BCRYPT_KEY_HANDLE, dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pszpublickeyobjid : windows_core::PCSTR, dwflags : u32, pvauxinfo : *const core::ffi::c_void, pinfo : *mut CERT_PUBLIC_KEY_INFO, pcbinfo : *mut u32) -> super::super::Foundation:: BOOL);
    CryptExportPublicKeyInfoFromBCryptKeyHandle(hbcryptkey.param().abi(), dwcertencodingtype, pszpublickeyobjid.param().abi(), dwflags, core::mem::transmute(pvauxinfo.unwrap_or(std::ptr::null())), core::mem::transmute(pinfo.unwrap_or(std::ptr::null_mut())), pcbinfo)
}
#[inline]
pub unsafe fn CryptFindCertificateKeyProvInfo(pcert: *const CERT_CONTEXT, dwflags: CRYPT_FIND_FLAGS, pvreserved: Option<*const core::ffi::c_void>) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CryptFindCertificateKeyProvInfo(pcert : *const CERT_CONTEXT, dwflags : CRYPT_FIND_FLAGS, pvreserved : *const core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CryptFindCertificateKeyProvInfo(pcert, dwflags, core::mem::transmute(pvreserved.unwrap_or(std::ptr::null()))).ok()
}
#[inline]
pub unsafe fn CryptFindLocalizedName<P0>(pwszcryptname: P0) -> windows_core::PCWSTR
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptFindLocalizedName(pwszcryptname : windows_core::PCWSTR) -> windows_core::PCWSTR);
    CryptFindLocalizedName(pwszcryptname.param().abi())
}
#[inline]
pub unsafe fn CryptFindOIDInfo(dwkeytype: u32, pvkey: *const core::ffi::c_void, dwgroupid: u32) -> *mut CRYPT_OID_INFO {
    windows_targets::link!("crypt32.dll" "system" fn CryptFindOIDInfo(dwkeytype : u32, pvkey : *const core::ffi::c_void, dwgroupid : u32) -> *mut CRYPT_OID_INFO);
    CryptFindOIDInfo(dwkeytype, pvkey, dwgroupid)
}
#[inline]
pub unsafe fn CryptFormatObject<P0>(dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, dwformattype: u32, dwformatstrtype: u32, pformatstruct: Option<*const core::ffi::c_void>, lpszstructtype: P0, pbencoded: &[u8], pbformat: Option<*mut core::ffi::c_void>, pcbformat: *mut u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptFormatObject(dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, dwformattype : u32, dwformatstrtype : u32, pformatstruct : *const core::ffi::c_void, lpszstructtype : windows_core::PCSTR, pbencoded : *const u8, cbencoded : u32, pbformat : *mut core::ffi::c_void, pcbformat : *mut u32) -> super::super::Foundation:: BOOL);
    CryptFormatObject(dwcertencodingtype, dwformattype, dwformatstrtype, core::mem::transmute(pformatstruct.unwrap_or(std::ptr::null())), lpszstructtype.param().abi(), core::mem::transmute(pbencoded.as_ptr()), pbencoded.len().try_into().unwrap(), core::mem::transmute(pbformat.unwrap_or(std::ptr::null_mut())), pcbformat).ok()
}
#[inline]
pub unsafe fn CryptFreeOIDFunctionAddress(hfuncaddr: *const core::ffi::c_void, dwflags: u32) -> super::super::Foundation::BOOL {
    windows_targets::link!("crypt32.dll" "system" fn CryptFreeOIDFunctionAddress(hfuncaddr : *const core::ffi::c_void, dwflags : u32) -> super::super::Foundation:: BOOL);
    CryptFreeOIDFunctionAddress(hfuncaddr, dwflags)
}
#[inline]
pub unsafe fn CryptGenKey(hprov: usize, algid: ALG_ID, dwflags: CRYPT_KEY_FLAGS, phkey: *mut usize) -> windows_core::Result<()> {
    windows_targets::link!("advapi32.dll" "system" fn CryptGenKey(hprov : usize, algid : ALG_ID, dwflags : CRYPT_KEY_FLAGS, phkey : *mut usize) -> super::super::Foundation:: BOOL);
    CryptGenKey(hprov, algid, dwflags, phkey).ok()
}
#[inline]
pub unsafe fn CryptGenRandom(hprov: usize, pbbuffer: &mut [u8]) -> windows_core::Result<()> {
    windows_targets::link!("advapi32.dll" "system" fn CryptGenRandom(hprov : usize, dwlen : u32, pbbuffer : *mut u8) -> super::super::Foundation:: BOOL);
    CryptGenRandom(hprov, pbbuffer.len().try_into().unwrap(), core::mem::transmute(pbbuffer.as_ptr())).ok()
}
#[inline]
pub unsafe fn CryptGetAsyncParam<P0, P1>(hasync: P0, pszparamoid: P1, ppvparam: Option<*mut *mut core::ffi::c_void>, ppfnfree: Option<*mut PFN_CRYPT_ASYNC_PARAM_FREE_FUNC>) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<HCRYPTASYNC>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptGetAsyncParam(hasync : HCRYPTASYNC, pszparamoid : windows_core::PCSTR, ppvparam : *mut *mut core::ffi::c_void, ppfnfree : *mut PFN_CRYPT_ASYNC_PARAM_FREE_FUNC) -> super::super::Foundation:: BOOL);
    CryptGetAsyncParam(hasync.param().abi(), pszparamoid.param().abi(), core::mem::transmute(ppvparam.unwrap_or(std::ptr::null_mut())), core::mem::transmute(ppfnfree.unwrap_or(std::ptr::null_mut())))
}
#[inline]
pub unsafe fn CryptGetDefaultOIDDllList(hfuncset: *const core::ffi::c_void, dwencodingtype: u32, pwszdlllist: windows_core::PWSTR, pcchdlllist: *mut u32) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CryptGetDefaultOIDDllList(hfuncset : *const core::ffi::c_void, dwencodingtype : u32, pwszdlllist : windows_core::PWSTR, pcchdlllist : *mut u32) -> super::super::Foundation:: BOOL);
    CryptGetDefaultOIDDllList(hfuncset, dwencodingtype, core::mem::transmute(pwszdlllist), pcchdlllist).ok()
}
#[inline]
pub unsafe fn CryptGetDefaultOIDFunctionAddress<P0>(hfuncset: *const core::ffi::c_void, dwencodingtype: u32, pwszdll: P0, dwflags: u32, ppvfuncaddr: *mut *mut core::ffi::c_void, phfuncaddr: *mut *mut core::ffi::c_void) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptGetDefaultOIDFunctionAddress(hfuncset : *const core::ffi::c_void, dwencodingtype : u32, pwszdll : windows_core::PCWSTR, dwflags : u32, ppvfuncaddr : *mut *mut core::ffi::c_void, phfuncaddr : *mut *mut core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CryptGetDefaultOIDFunctionAddress(hfuncset, dwencodingtype, pwszdll.param().abi(), dwflags, ppvfuncaddr, phfuncaddr)
}
#[inline]
pub unsafe fn CryptGetDefaultProviderA(dwprovtype: u32, pdwreserved: Option<*const u32>, dwflags: u32, pszprovname: windows_core::PSTR, pcbprovname: *mut u32) -> windows_core::Result<()> {
    windows_targets::link!("advapi32.dll" "system" fn CryptGetDefaultProviderA(dwprovtype : u32, pdwreserved : *const u32, dwflags : u32, pszprovname : windows_core::PSTR, pcbprovname : *mut u32) -> super::super::Foundation:: BOOL);
    CryptGetDefaultProviderA(dwprovtype, core::mem::transmute(pdwreserved.unwrap_or(std::ptr::null())), dwflags, core::mem::transmute(pszprovname), pcbprovname).ok()
}
#[inline]
pub unsafe fn CryptGetDefaultProviderW(dwprovtype: u32, pdwreserved: Option<*const u32>, dwflags: u32, pszprovname: windows_core::PWSTR, pcbprovname: *mut u32) -> windows_core::Result<()> {
    windows_targets::link!("advapi32.dll" "system" fn CryptGetDefaultProviderW(dwprovtype : u32, pdwreserved : *const u32, dwflags : u32, pszprovname : windows_core::PWSTR, pcbprovname : *mut u32) -> super::super::Foundation:: BOOL);
    CryptGetDefaultProviderW(dwprovtype, core::mem::transmute(pdwreserved.unwrap_or(std::ptr::null())), dwflags, core::mem::transmute(pszprovname), pcbprovname).ok()
}
#[inline]
pub unsafe fn CryptGetHashParam(hhash: usize, dwparam: u32, pbdata: Option<*mut u8>, pdwdatalen: *mut u32, dwflags: u32) -> windows_core::Result<()> {
    windows_targets::link!("advapi32.dll" "system" fn CryptGetHashParam(hhash : usize, dwparam : u32, pbdata : *mut u8, pdwdatalen : *mut u32, dwflags : u32) -> super::super::Foundation:: BOOL);
    CryptGetHashParam(hhash, dwparam, core::mem::transmute(pbdata.unwrap_or(std::ptr::null_mut())), pdwdatalen, dwflags).ok()
}
#[inline]
pub unsafe fn CryptGetKeyIdentifierProperty<P0>(pkeyidentifier: *const CRYPT_INTEGER_BLOB, dwpropid: u32, dwflags: u32, pwszcomputername: P0, pvreserved: Option<*const core::ffi::c_void>, pvdata: Option<*mut core::ffi::c_void>, pcbdata: *mut u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptGetKeyIdentifierProperty(pkeyidentifier : *const CRYPT_INTEGER_BLOB, dwpropid : u32, dwflags : u32, pwszcomputername : windows_core::PCWSTR, pvreserved : *const core::ffi::c_void, pvdata : *mut core::ffi::c_void, pcbdata : *mut u32) -> super::super::Foundation:: BOOL);
    CryptGetKeyIdentifierProperty(pkeyidentifier, dwpropid, dwflags, pwszcomputername.param().abi(), core::mem::transmute(pvreserved.unwrap_or(std::ptr::null())), core::mem::transmute(pvdata.unwrap_or(std::ptr::null_mut())), pcbdata).ok()
}
#[inline]
pub unsafe fn CryptGetKeyParam(hkey: usize, dwparam: CRYPT_KEY_PARAM_ID, pbdata: Option<*mut u8>, pdwdatalen: *mut u32, dwflags: u32) -> windows_core::Result<()> {
    windows_targets::link!("advapi32.dll" "system" fn CryptGetKeyParam(hkey : usize, dwparam : CRYPT_KEY_PARAM_ID, pbdata : *mut u8, pdwdatalen : *mut u32, dwflags : u32) -> super::super::Foundation:: BOOL);
    CryptGetKeyParam(hkey, dwparam, core::mem::transmute(pbdata.unwrap_or(std::ptr::null_mut())), pdwdatalen, dwflags).ok()
}
#[inline]
pub unsafe fn CryptGetMessageCertificates<P0>(dwmsgandcertencodingtype: u32, hcryptprov: P0, dwflags: u32, pbsignedblob: &[u8]) -> windows_core::Result<HCERTSTORE>
where
    P0: windows_core::Param<HCRYPTPROV_LEGACY>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptGetMessageCertificates(dwmsgandcertencodingtype : u32, hcryptprov : HCRYPTPROV_LEGACY, dwflags : u32, pbsignedblob : *const u8, cbsignedblob : u32) -> HCERTSTORE);
    let result__ = CryptGetMessageCertificates(dwmsgandcertencodingtype, hcryptprov.param().abi(), dwflags, core::mem::transmute(pbsignedblob.as_ptr()), pbsignedblob.len().try_into().unwrap());
    (!result__.is_invalid()).then(|| result__).ok_or_else(windows_core::Error::from_win32)
}
#[inline]
pub unsafe fn CryptGetMessageSignerCount(dwmsgencodingtype: u32, pbsignedblob: &[u8]) -> i32 {
    windows_targets::link!("crypt32.dll" "system" fn CryptGetMessageSignerCount(dwmsgencodingtype : u32, pbsignedblob : *const u8, cbsignedblob : u32) -> i32);
    CryptGetMessageSignerCount(dwmsgencodingtype, core::mem::transmute(pbsignedblob.as_ptr()), pbsignedblob.len().try_into().unwrap())
}
#[inline]
pub unsafe fn CryptGetOIDFunctionAddress<P0>(hfuncset: *const core::ffi::c_void, dwencodingtype: u32, pszoid: P0, dwflags: u32, ppvfuncaddr: *mut *mut core::ffi::c_void, phfuncaddr: *mut *mut core::ffi::c_void) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptGetOIDFunctionAddress(hfuncset : *const core::ffi::c_void, dwencodingtype : u32, pszoid : windows_core::PCSTR, dwflags : u32, ppvfuncaddr : *mut *mut core::ffi::c_void, phfuncaddr : *mut *mut core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CryptGetOIDFunctionAddress(hfuncset, dwencodingtype, pszoid.param().abi(), dwflags, ppvfuncaddr, phfuncaddr).ok()
}
#[inline]
pub unsafe fn CryptGetOIDFunctionValue<P0, P1, P2>(dwencodingtype: u32, pszfuncname: P0, pszoid: P1, pwszvaluename: P2, pdwvaluetype: Option<*mut u32>, pbvaluedata: Option<*mut u8>, pcbvaluedata: Option<*mut u32>) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptGetOIDFunctionValue(dwencodingtype : u32, pszfuncname : windows_core::PCSTR, pszoid : windows_core::PCSTR, pwszvaluename : windows_core::PCWSTR, pdwvaluetype : *mut u32, pbvaluedata : *mut u8, pcbvaluedata : *mut u32) -> super::super::Foundation:: BOOL);
    CryptGetOIDFunctionValue(dwencodingtype, pszfuncname.param().abi(), pszoid.param().abi(), pwszvaluename.param().abi(), core::mem::transmute(pdwvaluetype.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pbvaluedata.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pcbvaluedata.unwrap_or(std::ptr::null_mut()))).ok()
}
#[inline]
pub unsafe fn CryptGetObjectUrl<P0>(pszurloid: P0, pvpara: *const core::ffi::c_void, dwflags: CRYPT_GET_URL_FLAGS, purlarray: Option<*mut CRYPT_URL_ARRAY>, pcburlarray: *mut u32, purlinfo: Option<*mut CRYPT_URL_INFO>, pcburlinfo: Option<*mut u32>, pvreserved: Option<*const core::ffi::c_void>) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("cryptnet.dll" "system" fn CryptGetObjectUrl(pszurloid : windows_core::PCSTR, pvpara : *const core::ffi::c_void, dwflags : CRYPT_GET_URL_FLAGS, purlarray : *mut CRYPT_URL_ARRAY, pcburlarray : *mut u32, purlinfo : *mut CRYPT_URL_INFO, pcburlinfo : *mut u32, pvreserved : *const core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CryptGetObjectUrl(pszurloid.param().abi(), pvpara, dwflags, core::mem::transmute(purlarray.unwrap_or(std::ptr::null_mut())), pcburlarray, core::mem::transmute(purlinfo.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pcburlinfo.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pvreserved.unwrap_or(std::ptr::null()))).ok()
}
#[inline]
pub unsafe fn CryptGetProvParam(hprov: usize, dwparam: u32, pbdata: Option<*mut u8>, pdwdatalen: *mut u32, dwflags: u32) -> windows_core::Result<()> {
    windows_targets::link!("advapi32.dll" "system" fn CryptGetProvParam(hprov : usize, dwparam : u32, pbdata : *mut u8, pdwdatalen : *mut u32, dwflags : u32) -> super::super::Foundation:: BOOL);
    CryptGetProvParam(hprov, dwparam, core::mem::transmute(pbdata.unwrap_or(std::ptr::null_mut())), pdwdatalen, dwflags).ok()
}
#[inline]
pub unsafe fn CryptGetUserKey(hprov: usize, dwkeyspec: u32, phuserkey: *mut usize) -> windows_core::Result<()> {
    windows_targets::link!("advapi32.dll" "system" fn CryptGetUserKey(hprov : usize, dwkeyspec : u32, phuserkey : *mut usize) -> super::super::Foundation:: BOOL);
    CryptGetUserKey(hprov, dwkeyspec, phuserkey).ok()
}
#[inline]
pub unsafe fn CryptHashCertificate<P0>(hcryptprov: P0, algid: ALG_ID, dwflags: u32, pbencoded: &[u8], pbcomputedhash: Option<*mut u8>, pcbcomputedhash: *mut u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<HCRYPTPROV_LEGACY>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptHashCertificate(hcryptprov : HCRYPTPROV_LEGACY, algid : ALG_ID, dwflags : u32, pbencoded : *const u8, cbencoded : u32, pbcomputedhash : *mut u8, pcbcomputedhash : *mut u32) -> super::super::Foundation:: BOOL);
    CryptHashCertificate(hcryptprov.param().abi(), algid, dwflags, core::mem::transmute(pbencoded.as_ptr()), pbencoded.len().try_into().unwrap(), core::mem::transmute(pbcomputedhash.unwrap_or(std::ptr::null_mut())), pcbcomputedhash).ok()
}
#[inline]
pub unsafe fn CryptHashCertificate2<P0>(pwszcnghashalgid: P0, dwflags: u32, pvreserved: Option<*const core::ffi::c_void>, pbencoded: Option<&[u8]>, pbcomputedhash: Option<*mut u8>, pcbcomputedhash: *mut u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptHashCertificate2(pwszcnghashalgid : windows_core::PCWSTR, dwflags : u32, pvreserved : *const core::ffi::c_void, pbencoded : *const u8, cbencoded : u32, pbcomputedhash : *mut u8, pcbcomputedhash : *mut u32) -> super::super::Foundation:: BOOL);
    CryptHashCertificate2(pwszcnghashalgid.param().abi(), dwflags, core::mem::transmute(pvreserved.unwrap_or(std::ptr::null())), core::mem::transmute(pbencoded.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), pbencoded.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(pbcomputedhash.unwrap_or(std::ptr::null_mut())), pcbcomputedhash).ok()
}
#[inline]
pub unsafe fn CryptHashData(hhash: usize, pbdata: &[u8], dwflags: u32) -> windows_core::Result<()> {
    windows_targets::link!("advapi32.dll" "system" fn CryptHashData(hhash : usize, pbdata : *const u8, dwdatalen : u32, dwflags : u32) -> super::super::Foundation:: BOOL);
    CryptHashData(hhash, core::mem::transmute(pbdata.as_ptr()), pbdata.len().try_into().unwrap(), dwflags).ok()
}
#[inline]
pub unsafe fn CryptHashMessage<P0>(phashpara: *const CRYPT_HASH_MESSAGE_PARA, fdetachedhash: P0, ctobehashed: u32, rgpbtobehashed: *const *const u8, rgcbtobehashed: *const u32, pbhashedblob: Option<*mut u8>, pcbhashedblob: Option<*mut u32>, pbcomputedhash: Option<*mut u8>, pcbcomputedhash: Option<*mut u32>) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::Foundation::BOOL>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptHashMessage(phashpara : *const CRYPT_HASH_MESSAGE_PARA, fdetachedhash : super::super::Foundation:: BOOL, ctobehashed : u32, rgpbtobehashed : *const *const u8, rgcbtobehashed : *const u32, pbhashedblob : *mut u8, pcbhashedblob : *mut u32, pbcomputedhash : *mut u8, pcbcomputedhash : *mut u32) -> super::super::Foundation:: BOOL);
    CryptHashMessage(phashpara, fdetachedhash.param().abi(), ctobehashed, rgpbtobehashed, rgcbtobehashed, core::mem::transmute(pbhashedblob.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pcbhashedblob.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pbcomputedhash.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pcbcomputedhash.unwrap_or(std::ptr::null_mut()))).ok()
}
#[inline]
pub unsafe fn CryptHashPublicKeyInfo<P0>(hcryptprov: P0, algid: ALG_ID, dwflags: u32, dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pinfo: *const CERT_PUBLIC_KEY_INFO, pbcomputedhash: Option<*mut u8>, pcbcomputedhash: *mut u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<HCRYPTPROV_LEGACY>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptHashPublicKeyInfo(hcryptprov : HCRYPTPROV_LEGACY, algid : ALG_ID, dwflags : u32, dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pinfo : *const CERT_PUBLIC_KEY_INFO, pbcomputedhash : *mut u8, pcbcomputedhash : *mut u32) -> super::super::Foundation:: BOOL);
    CryptHashPublicKeyInfo(hcryptprov.param().abi(), algid, dwflags, dwcertencodingtype, pinfo, core::mem::transmute(pbcomputedhash.unwrap_or(std::ptr::null_mut())), pcbcomputedhash).ok()
}
#[inline]
pub unsafe fn CryptHashSessionKey(hhash: usize, hkey: usize, dwflags: u32) -> windows_core::Result<()> {
    windows_targets::link!("advapi32.dll" "system" fn CryptHashSessionKey(hhash : usize, hkey : usize, dwflags : u32) -> super::super::Foundation:: BOOL);
    CryptHashSessionKey(hhash, hkey, dwflags).ok()
}
#[inline]
pub unsafe fn CryptHashToBeSigned<P0>(hcryptprov: P0, dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pbencoded: &[u8], pbcomputedhash: Option<*mut u8>, pcbcomputedhash: *mut u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<HCRYPTPROV_LEGACY>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptHashToBeSigned(hcryptprov : HCRYPTPROV_LEGACY, dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pbencoded : *const u8, cbencoded : u32, pbcomputedhash : *mut u8, pcbcomputedhash : *mut u32) -> super::super::Foundation:: BOOL);
    CryptHashToBeSigned(hcryptprov.param().abi(), dwcertencodingtype, core::mem::transmute(pbencoded.as_ptr()), pbencoded.len().try_into().unwrap(), core::mem::transmute(pbcomputedhash.unwrap_or(std::ptr::null_mut())), pcbcomputedhash).ok()
}
#[inline]
pub unsafe fn CryptImportKey(hprov: usize, pbdata: &[u8], hpubkey: usize, dwflags: CRYPT_KEY_FLAGS, phkey: *mut usize) -> windows_core::Result<()> {
    windows_targets::link!("advapi32.dll" "system" fn CryptImportKey(hprov : usize, pbdata : *const u8, dwdatalen : u32, hpubkey : usize, dwflags : CRYPT_KEY_FLAGS, phkey : *mut usize) -> super::super::Foundation:: BOOL);
    CryptImportKey(hprov, core::mem::transmute(pbdata.as_ptr()), pbdata.len().try_into().unwrap(), hpubkey, dwflags, phkey).ok()
}
#[inline]
pub unsafe fn CryptImportPKCS8(sprivatekeyandparams: CRYPT_PKCS8_IMPORT_PARAMS, dwflags: CRYPT_KEY_FLAGS, phcryptprov: Option<*mut usize>, pvauxinfo: Option<*const core::ffi::c_void>) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CryptImportPKCS8(sprivatekeyandparams : CRYPT_PKCS8_IMPORT_PARAMS, dwflags : CRYPT_KEY_FLAGS, phcryptprov : *mut usize, pvauxinfo : *const core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CryptImportPKCS8(core::mem::transmute(sprivatekeyandparams), dwflags, core::mem::transmute(phcryptprov.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pvauxinfo.unwrap_or(std::ptr::null()))).ok()
}
#[inline]
pub unsafe fn CryptImportPublicKeyInfo(hcryptprov: usize, dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pinfo: *const CERT_PUBLIC_KEY_INFO, phkey: *mut usize) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CryptImportPublicKeyInfo(hcryptprov : usize, dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pinfo : *const CERT_PUBLIC_KEY_INFO, phkey : *mut usize) -> super::super::Foundation:: BOOL);
    CryptImportPublicKeyInfo(hcryptprov, dwcertencodingtype, pinfo, phkey).ok()
}
#[inline]
pub unsafe fn CryptImportPublicKeyInfoEx(hcryptprov: usize, dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pinfo: *const CERT_PUBLIC_KEY_INFO, aikeyalg: ALG_ID, dwflags: u32, pvauxinfo: Option<*const core::ffi::c_void>, phkey: *mut usize) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CryptImportPublicKeyInfoEx(hcryptprov : usize, dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pinfo : *const CERT_PUBLIC_KEY_INFO, aikeyalg : ALG_ID, dwflags : u32, pvauxinfo : *const core::ffi::c_void, phkey : *mut usize) -> super::super::Foundation:: BOOL);
    CryptImportPublicKeyInfoEx(hcryptprov, dwcertencodingtype, pinfo, aikeyalg, dwflags, core::mem::transmute(pvauxinfo.unwrap_or(std::ptr::null())), phkey).ok()
}
#[inline]
pub unsafe fn CryptImportPublicKeyInfoEx2(dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pinfo: *const CERT_PUBLIC_KEY_INFO, dwflags: CRYPT_IMPORT_PUBLIC_KEY_FLAGS, pvauxinfo: Option<*const core::ffi::c_void>, phkey: *mut BCRYPT_KEY_HANDLE) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CryptImportPublicKeyInfoEx2(dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pinfo : *const CERT_PUBLIC_KEY_INFO, dwflags : CRYPT_IMPORT_PUBLIC_KEY_FLAGS, pvauxinfo : *const core::ffi::c_void, phkey : *mut BCRYPT_KEY_HANDLE) -> super::super::Foundation:: BOOL);
    CryptImportPublicKeyInfoEx2(dwcertencodingtype, pinfo, dwflags, core::mem::transmute(pvauxinfo.unwrap_or(std::ptr::null())), phkey).ok()
}
#[inline]
pub unsafe fn CryptInitOIDFunctionSet<P0>(pszfuncname: P0, dwflags: u32) -> *mut core::ffi::c_void
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptInitOIDFunctionSet(pszfuncname : windows_core::PCSTR, dwflags : u32) -> *mut core::ffi::c_void);
    CryptInitOIDFunctionSet(pszfuncname.param().abi(), dwflags)
}
#[inline]
pub unsafe fn CryptInstallCancelRetrieval(pfncancel: PFN_CRYPT_CANCEL_RETRIEVAL, pvarg: Option<*const core::ffi::c_void>, dwflags: u32, pvreserved: Option<*const core::ffi::c_void>) -> super::super::Foundation::BOOL {
    windows_targets::link!("cryptnet.dll" "system" fn CryptInstallCancelRetrieval(pfncancel : PFN_CRYPT_CANCEL_RETRIEVAL, pvarg : *const core::ffi::c_void, dwflags : u32, pvreserved : *const core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CryptInstallCancelRetrieval(pfncancel, core::mem::transmute(pvarg.unwrap_or(std::ptr::null())), dwflags, core::mem::transmute(pvreserved.unwrap_or(std::ptr::null())))
}
#[inline]
pub unsafe fn CryptInstallDefaultContext(hcryptprov: usize, dwdefaulttype: CRYPT_DEFAULT_CONTEXT_TYPE, pvdefaultpara: Option<*const core::ffi::c_void>, dwflags: CRYPT_DEFAULT_CONTEXT_FLAGS, pvreserved: Option<*const core::ffi::c_void>, phdefaultcontext: *mut *mut core::ffi::c_void) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CryptInstallDefaultContext(hcryptprov : usize, dwdefaulttype : CRYPT_DEFAULT_CONTEXT_TYPE, pvdefaultpara : *const core::ffi::c_void, dwflags : CRYPT_DEFAULT_CONTEXT_FLAGS, pvreserved : *const core::ffi::c_void, phdefaultcontext : *mut *mut core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CryptInstallDefaultContext(hcryptprov, dwdefaulttype, core::mem::transmute(pvdefaultpara.unwrap_or(std::ptr::null())), dwflags, core::mem::transmute(pvreserved.unwrap_or(std::ptr::null())), phdefaultcontext).ok()
}
#[inline]
pub unsafe fn CryptInstallOIDFunctionAddress<P0, P1>(hmodule: P0, dwencodingtype: u32, pszfuncname: P1, rgfuncentry: &[CRYPT_OID_FUNC_ENTRY], dwflags: u32) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<super::super::Foundation::HMODULE>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptInstallOIDFunctionAddress(hmodule : super::super::Foundation:: HMODULE, dwencodingtype : u32, pszfuncname : windows_core::PCSTR, cfuncentry : u32, rgfuncentry : *const CRYPT_OID_FUNC_ENTRY, dwflags : u32) -> super::super::Foundation:: BOOL);
    CryptInstallOIDFunctionAddress(hmodule.param().abi(), dwencodingtype, pszfuncname.param().abi(), rgfuncentry.len().try_into().unwrap(), core::mem::transmute(rgfuncentry.as_ptr()), dwflags)
}
#[inline]
pub unsafe fn CryptMemAlloc(cbsize: u32) -> *mut core::ffi::c_void {
    windows_targets::link!("crypt32.dll" "system" fn CryptMemAlloc(cbsize : u32) -> *mut core::ffi::c_void);
    CryptMemAlloc(cbsize)
}
#[inline]
pub unsafe fn CryptMemFree(pv: Option<*const core::ffi::c_void>) {
    windows_targets::link!("crypt32.dll" "system" fn CryptMemFree(pv : *const core::ffi::c_void));
    CryptMemFree(core::mem::transmute(pv.unwrap_or(std::ptr::null())))
}
#[inline]
pub unsafe fn CryptMemRealloc(pv: Option<*const core::ffi::c_void>, cbsize: u32) -> *mut core::ffi::c_void {
    windows_targets::link!("crypt32.dll" "system" fn CryptMemRealloc(pv : *const core::ffi::c_void, cbsize : u32) -> *mut core::ffi::c_void);
    CryptMemRealloc(core::mem::transmute(pv.unwrap_or(std::ptr::null())), cbsize)
}
#[inline]
pub unsafe fn CryptMsgCalculateEncodedLength<P0>(dwmsgencodingtype: u32, dwflags: u32, dwmsgtype: u32, pvmsgencodeinfo: *const core::ffi::c_void, pszinnercontentobjid: P0, cbdata: u32) -> u32
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptMsgCalculateEncodedLength(dwmsgencodingtype : u32, dwflags : u32, dwmsgtype : u32, pvmsgencodeinfo : *const core::ffi::c_void, pszinnercontentobjid : windows_core::PCSTR, cbdata : u32) -> u32);
    CryptMsgCalculateEncodedLength(dwmsgencodingtype, dwflags, dwmsgtype, pvmsgencodeinfo, pszinnercontentobjid.param().abi(), cbdata)
}
#[inline]
pub unsafe fn CryptMsgClose(hcryptmsg: Option<*const core::ffi::c_void>) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CryptMsgClose(hcryptmsg : *const core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CryptMsgClose(core::mem::transmute(hcryptmsg.unwrap_or(std::ptr::null()))).ok()
}
#[inline]
pub unsafe fn CryptMsgControl(hcryptmsg: *const core::ffi::c_void, dwflags: u32, dwctrltype: u32, pvctrlpara: Option<*const core::ffi::c_void>) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CryptMsgControl(hcryptmsg : *const core::ffi::c_void, dwflags : u32, dwctrltype : u32, pvctrlpara : *const core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CryptMsgControl(hcryptmsg, dwflags, dwctrltype, core::mem::transmute(pvctrlpara.unwrap_or(std::ptr::null()))).ok()
}
#[inline]
pub unsafe fn CryptMsgCountersign(hcryptmsg: *const core::ffi::c_void, dwindex: u32, rgcountersigners: &[CMSG_SIGNER_ENCODE_INFO]) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CryptMsgCountersign(hcryptmsg : *const core::ffi::c_void, dwindex : u32, ccountersigners : u32, rgcountersigners : *const CMSG_SIGNER_ENCODE_INFO) -> super::super::Foundation:: BOOL);
    CryptMsgCountersign(hcryptmsg, dwindex, rgcountersigners.len().try_into().unwrap(), core::mem::transmute(rgcountersigners.as_ptr())).ok()
}
#[inline]
pub unsafe fn CryptMsgCountersignEncoded(dwencodingtype: u32, pbsignerinfo: &[u8], rgcountersigners: &[CMSG_SIGNER_ENCODE_INFO], pbcountersignature: Option<*mut u8>, pcbcountersignature: *mut u32) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CryptMsgCountersignEncoded(dwencodingtype : u32, pbsignerinfo : *const u8, cbsignerinfo : u32, ccountersigners : u32, rgcountersigners : *const CMSG_SIGNER_ENCODE_INFO, pbcountersignature : *mut u8, pcbcountersignature : *mut u32) -> super::super::Foundation:: BOOL);
    CryptMsgCountersignEncoded(dwencodingtype, core::mem::transmute(pbsignerinfo.as_ptr()), pbsignerinfo.len().try_into().unwrap(), rgcountersigners.len().try_into().unwrap(), core::mem::transmute(rgcountersigners.as_ptr()), core::mem::transmute(pbcountersignature.unwrap_or(std::ptr::null_mut())), pcbcountersignature).ok()
}
#[inline]
pub unsafe fn CryptMsgDuplicate(hcryptmsg: Option<*const core::ffi::c_void>) -> *mut core::ffi::c_void {
    windows_targets::link!("crypt32.dll" "system" fn CryptMsgDuplicate(hcryptmsg : *const core::ffi::c_void) -> *mut core::ffi::c_void);
    CryptMsgDuplicate(core::mem::transmute(hcryptmsg.unwrap_or(std::ptr::null())))
}
#[inline]
pub unsafe fn CryptMsgEncodeAndSignCTL(dwmsgencodingtype: u32, pctlinfo: *const CTL_INFO, psigninfo: *const CMSG_SIGNED_ENCODE_INFO, dwflags: u32, pbencoded: Option<*mut u8>, pcbencoded: *mut u32) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CryptMsgEncodeAndSignCTL(dwmsgencodingtype : u32, pctlinfo : *const CTL_INFO, psigninfo : *const CMSG_SIGNED_ENCODE_INFO, dwflags : u32, pbencoded : *mut u8, pcbencoded : *mut u32) -> super::super::Foundation:: BOOL);
    CryptMsgEncodeAndSignCTL(dwmsgencodingtype, pctlinfo, psigninfo, dwflags, core::mem::transmute(pbencoded.unwrap_or(std::ptr::null_mut())), pcbencoded).ok()
}
#[inline]
pub unsafe fn CryptMsgGetAndVerifySigner(hcryptmsg: *const core::ffi::c_void, rghsignerstore: Option<&[HCERTSTORE]>, dwflags: u32, ppsigner: Option<*mut *mut CERT_CONTEXT>, pdwsignerindex: Option<*mut u32>) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CryptMsgGetAndVerifySigner(hcryptmsg : *const core::ffi::c_void, csignerstore : u32, rghsignerstore : *const HCERTSTORE, dwflags : u32, ppsigner : *mut *mut CERT_CONTEXT, pdwsignerindex : *mut u32) -> super::super::Foundation:: BOOL);
    CryptMsgGetAndVerifySigner(hcryptmsg, rghsignerstore.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(rghsignerstore.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), dwflags, core::mem::transmute(ppsigner.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pdwsignerindex.unwrap_or(std::ptr::null_mut()))).ok()
}
#[inline]
pub unsafe fn CryptMsgGetParam(hcryptmsg: *const core::ffi::c_void, dwparamtype: u32, dwindex: u32, pvdata: Option<*mut core::ffi::c_void>, pcbdata: *mut u32) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CryptMsgGetParam(hcryptmsg : *const core::ffi::c_void, dwparamtype : u32, dwindex : u32, pvdata : *mut core::ffi::c_void, pcbdata : *mut u32) -> super::super::Foundation:: BOOL);
    CryptMsgGetParam(hcryptmsg, dwparamtype, dwindex, core::mem::transmute(pvdata.unwrap_or(std::ptr::null_mut())), pcbdata).ok()
}
#[inline]
pub unsafe fn CryptMsgOpenToDecode<P0>(dwmsgencodingtype: u32, dwflags: u32, dwmsgtype: u32, hcryptprov: P0, precipientinfo: Option<*const CERT_INFO>, pstreaminfo: Option<*const CMSG_STREAM_INFO>) -> *mut core::ffi::c_void
where
    P0: windows_core::Param<HCRYPTPROV_LEGACY>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptMsgOpenToDecode(dwmsgencodingtype : u32, dwflags : u32, dwmsgtype : u32, hcryptprov : HCRYPTPROV_LEGACY, precipientinfo : *const CERT_INFO, pstreaminfo : *const CMSG_STREAM_INFO) -> *mut core::ffi::c_void);
    CryptMsgOpenToDecode(dwmsgencodingtype, dwflags, dwmsgtype, hcryptprov.param().abi(), core::mem::transmute(precipientinfo.unwrap_or(std::ptr::null())), core::mem::transmute(pstreaminfo.unwrap_or(std::ptr::null())))
}
#[inline]
pub unsafe fn CryptMsgOpenToEncode<P0>(dwmsgencodingtype: u32, dwflags: u32, dwmsgtype: CRYPT_MSG_TYPE, pvmsgencodeinfo: *const core::ffi::c_void, pszinnercontentobjid: P0, pstreaminfo: Option<*const CMSG_STREAM_INFO>) -> *mut core::ffi::c_void
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptMsgOpenToEncode(dwmsgencodingtype : u32, dwflags : u32, dwmsgtype : CRYPT_MSG_TYPE, pvmsgencodeinfo : *const core::ffi::c_void, pszinnercontentobjid : windows_core::PCSTR, pstreaminfo : *const CMSG_STREAM_INFO) -> *mut core::ffi::c_void);
    CryptMsgOpenToEncode(dwmsgencodingtype, dwflags, dwmsgtype, pvmsgencodeinfo, pszinnercontentobjid.param().abi(), core::mem::transmute(pstreaminfo.unwrap_or(std::ptr::null())))
}
#[inline]
pub unsafe fn CryptMsgSignCTL(dwmsgencodingtype: u32, pbctlcontent: &[u8], psigninfo: *const CMSG_SIGNED_ENCODE_INFO, dwflags: u32, pbencoded: Option<*mut u8>, pcbencoded: *mut u32) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CryptMsgSignCTL(dwmsgencodingtype : u32, pbctlcontent : *const u8, cbctlcontent : u32, psigninfo : *const CMSG_SIGNED_ENCODE_INFO, dwflags : u32, pbencoded : *mut u8, pcbencoded : *mut u32) -> super::super::Foundation:: BOOL);
    CryptMsgSignCTL(dwmsgencodingtype, core::mem::transmute(pbctlcontent.as_ptr()), pbctlcontent.len().try_into().unwrap(), psigninfo, dwflags, core::mem::transmute(pbencoded.unwrap_or(std::ptr::null_mut())), pcbencoded).ok()
}
#[inline]
pub unsafe fn CryptMsgUpdate<P0>(hcryptmsg: *const core::ffi::c_void, pbdata: Option<&[u8]>, ffinal: P0) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::Foundation::BOOL>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptMsgUpdate(hcryptmsg : *const core::ffi::c_void, pbdata : *const u8, cbdata : u32, ffinal : super::super::Foundation:: BOOL) -> super::super::Foundation:: BOOL);
    CryptMsgUpdate(hcryptmsg, core::mem::transmute(pbdata.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), pbdata.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), ffinal.param().abi()).ok()
}
#[inline]
pub unsafe fn CryptMsgVerifyCountersignatureEncoded<P0>(hcryptprov: P0, dwencodingtype: u32, pbsignerinfo: &[u8], pbsignerinfocountersignature: &[u8], pcicountersigner: *const CERT_INFO) -> windows_core::Result<()>
where
    P0: windows_core::Param<HCRYPTPROV_LEGACY>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptMsgVerifyCountersignatureEncoded(hcryptprov : HCRYPTPROV_LEGACY, dwencodingtype : u32, pbsignerinfo : *const u8, cbsignerinfo : u32, pbsignerinfocountersignature : *const u8, cbsignerinfocountersignature : u32, pcicountersigner : *const CERT_INFO) -> super::super::Foundation:: BOOL);
    CryptMsgVerifyCountersignatureEncoded(hcryptprov.param().abi(), dwencodingtype, core::mem::transmute(pbsignerinfo.as_ptr()), pbsignerinfo.len().try_into().unwrap(), core::mem::transmute(pbsignerinfocountersignature.as_ptr()), pbsignerinfocountersignature.len().try_into().unwrap(), pcicountersigner).ok()
}
#[inline]
pub unsafe fn CryptMsgVerifyCountersignatureEncodedEx<P0>(hcryptprov: P0, dwencodingtype: u32, pbsignerinfo: &[u8], pbsignerinfocountersignature: &[u8], dwsignertype: u32, pvsigner: *const core::ffi::c_void, dwflags: u32, pvextra: Option<*mut core::ffi::c_void>) -> windows_core::Result<()>
where
    P0: windows_core::Param<HCRYPTPROV_LEGACY>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptMsgVerifyCountersignatureEncodedEx(hcryptprov : HCRYPTPROV_LEGACY, dwencodingtype : u32, pbsignerinfo : *const u8, cbsignerinfo : u32, pbsignerinfocountersignature : *const u8, cbsignerinfocountersignature : u32, dwsignertype : u32, pvsigner : *const core::ffi::c_void, dwflags : u32, pvextra : *mut core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CryptMsgVerifyCountersignatureEncodedEx(hcryptprov.param().abi(), dwencodingtype, core::mem::transmute(pbsignerinfo.as_ptr()), pbsignerinfo.len().try_into().unwrap(), core::mem::transmute(pbsignerinfocountersignature.as_ptr()), pbsignerinfocountersignature.len().try_into().unwrap(), dwsignertype, pvsigner, dwflags, core::mem::transmute(pvextra.unwrap_or(std::ptr::null_mut()))).ok()
}
#[inline]
pub unsafe fn CryptProtectData<P0>(pdatain: *const CRYPT_INTEGER_BLOB, szdatadescr: P0, poptionalentropy: Option<*const CRYPT_INTEGER_BLOB>, pvreserved: Option<*const core::ffi::c_void>, ppromptstruct: Option<*const CRYPTPROTECT_PROMPTSTRUCT>, dwflags: u32, pdataout: *mut CRYPT_INTEGER_BLOB) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptProtectData(pdatain : *const CRYPT_INTEGER_BLOB, szdatadescr : windows_core::PCWSTR, poptionalentropy : *const CRYPT_INTEGER_BLOB, pvreserved : *const core::ffi::c_void, ppromptstruct : *const CRYPTPROTECT_PROMPTSTRUCT, dwflags : u32, pdataout : *mut CRYPT_INTEGER_BLOB) -> super::super::Foundation:: BOOL);
    CryptProtectData(pdatain, szdatadescr.param().abi(), core::mem::transmute(poptionalentropy.unwrap_or(std::ptr::null())), core::mem::transmute(pvreserved.unwrap_or(std::ptr::null())), core::mem::transmute(ppromptstruct.unwrap_or(std::ptr::null())), dwflags, pdataout).ok()
}
#[inline]
pub unsafe fn CryptProtectMemory(pdatain: *mut core::ffi::c_void, cbdatain: u32, dwflags: u32) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CryptProtectMemory(pdatain : *mut core::ffi::c_void, cbdatain : u32, dwflags : u32) -> super::super::Foundation:: BOOL);
    CryptProtectMemory(pdatain, cbdatain, dwflags).ok()
}
#[inline]
pub unsafe fn CryptQueryObject(dwobjecttype: CERT_QUERY_OBJECT_TYPE, pvobject: *const core::ffi::c_void, dwexpectedcontenttypeflags: CERT_QUERY_CONTENT_TYPE_FLAGS, dwexpectedformattypeflags: CERT_QUERY_FORMAT_TYPE_FLAGS, dwflags: u32, pdwmsgandcertencodingtype: Option<*mut CERT_QUERY_ENCODING_TYPE>, pdwcontenttype: Option<*mut CERT_QUERY_CONTENT_TYPE>, pdwformattype: Option<*mut CERT_QUERY_FORMAT_TYPE>, phcertstore: Option<*mut HCERTSTORE>, phmsg: Option<*mut *mut core::ffi::c_void>, ppvcontext: Option<*mut *mut core::ffi::c_void>) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CryptQueryObject(dwobjecttype : CERT_QUERY_OBJECT_TYPE, pvobject : *const core::ffi::c_void, dwexpectedcontenttypeflags : CERT_QUERY_CONTENT_TYPE_FLAGS, dwexpectedformattypeflags : CERT_QUERY_FORMAT_TYPE_FLAGS, dwflags : u32, pdwmsgandcertencodingtype : *mut CERT_QUERY_ENCODING_TYPE, pdwcontenttype : *mut CERT_QUERY_CONTENT_TYPE, pdwformattype : *mut CERT_QUERY_FORMAT_TYPE, phcertstore : *mut HCERTSTORE, phmsg : *mut *mut core::ffi::c_void, ppvcontext : *mut *mut core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CryptQueryObject(
        dwobjecttype,
        pvobject,
        dwexpectedcontenttypeflags,
        dwexpectedformattypeflags,
        dwflags,
        core::mem::transmute(pdwmsgandcertencodingtype.unwrap_or(std::ptr::null_mut())),
        core::mem::transmute(pdwcontenttype.unwrap_or(std::ptr::null_mut())),
        core::mem::transmute(pdwformattype.unwrap_or(std::ptr::null_mut())),
        core::mem::transmute(phcertstore.unwrap_or(std::ptr::null_mut())),
        core::mem::transmute(phmsg.unwrap_or(std::ptr::null_mut())),
        core::mem::transmute(ppvcontext.unwrap_or(std::ptr::null_mut())),
    )
    .ok()
}
#[inline]
pub unsafe fn CryptRegisterDefaultOIDFunction<P0, P1>(dwencodingtype: u32, pszfuncname: P0, dwindex: u32, pwszdll: P1) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptRegisterDefaultOIDFunction(dwencodingtype : u32, pszfuncname : windows_core::PCSTR, dwindex : u32, pwszdll : windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    CryptRegisterDefaultOIDFunction(dwencodingtype, pszfuncname.param().abi(), dwindex, pwszdll.param().abi())
}
#[inline]
pub unsafe fn CryptRegisterOIDFunction<P0, P1, P2, P3>(dwencodingtype: u32, pszfuncname: P0, pszoid: P1, pwszdll: P2, pszoverridefuncname: P3) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
    P3: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptRegisterOIDFunction(dwencodingtype : u32, pszfuncname : windows_core::PCSTR, pszoid : windows_core::PCSTR, pwszdll : windows_core::PCWSTR, pszoverridefuncname : windows_core::PCSTR) -> super::super::Foundation:: BOOL);
    CryptRegisterOIDFunction(dwencodingtype, pszfuncname.param().abi(), pszoid.param().abi(), pwszdll.param().abi(), pszoverridefuncname.param().abi())
}
#[inline]
pub unsafe fn CryptRegisterOIDInfo(pinfo: *const CRYPT_OID_INFO, dwflags: u32) -> super::super::Foundation::BOOL {
    windows_targets::link!("crypt32.dll" "system" fn CryptRegisterOIDInfo(pinfo : *const CRYPT_OID_INFO, dwflags : u32) -> super::super::Foundation:: BOOL);
    CryptRegisterOIDInfo(pinfo, dwflags)
}
#[inline]
pub unsafe fn CryptReleaseContext(hprov: usize, dwflags: u32) -> windows_core::Result<()> {
    windows_targets::link!("advapi32.dll" "system" fn CryptReleaseContext(hprov : usize, dwflags : u32) -> super::super::Foundation:: BOOL);
    CryptReleaseContext(hprov, dwflags).ok()
}
#[inline]
pub unsafe fn CryptRetrieveObjectByUrlA<P0, P1, P2>(pszurl: P0, pszobjectoid: P1, dwretrievalflags: u32, dwtimeout: u32, ppvobject: *mut *mut core::ffi::c_void, hasyncretrieve: P2, pcredentials: Option<*const CRYPT_CREDENTIALS>, pvverify: Option<*const core::ffi::c_void>, pauxinfo: Option<*mut CRYPT_RETRIEVE_AUX_INFO>) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
    P2: windows_core::Param<HCRYPTASYNC>,
{
    windows_targets::link!("cryptnet.dll" "system" fn CryptRetrieveObjectByUrlA(pszurl : windows_core::PCSTR, pszobjectoid : windows_core::PCSTR, dwretrievalflags : u32, dwtimeout : u32, ppvobject : *mut *mut core::ffi::c_void, hasyncretrieve : HCRYPTASYNC, pcredentials : *const CRYPT_CREDENTIALS, pvverify : *const core::ffi::c_void, pauxinfo : *mut CRYPT_RETRIEVE_AUX_INFO) -> super::super::Foundation:: BOOL);
    CryptRetrieveObjectByUrlA(pszurl.param().abi(), pszobjectoid.param().abi(), dwretrievalflags, dwtimeout, ppvobject, hasyncretrieve.param().abi(), core::mem::transmute(pcredentials.unwrap_or(std::ptr::null())), core::mem::transmute(pvverify.unwrap_or(std::ptr::null())), core::mem::transmute(pauxinfo.unwrap_or(std::ptr::null_mut())))
}
#[inline]
pub unsafe fn CryptRetrieveObjectByUrlW<P0, P1, P2>(pszurl: P0, pszobjectoid: P1, dwretrievalflags: u32, dwtimeout: u32, ppvobject: *mut *mut core::ffi::c_void, hasyncretrieve: P2, pcredentials: Option<*const CRYPT_CREDENTIALS>, pvverify: Option<*const core::ffi::c_void>, pauxinfo: Option<*mut CRYPT_RETRIEVE_AUX_INFO>) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
    P2: windows_core::Param<HCRYPTASYNC>,
{
    windows_targets::link!("cryptnet.dll" "system" fn CryptRetrieveObjectByUrlW(pszurl : windows_core::PCWSTR, pszobjectoid : windows_core::PCSTR, dwretrievalflags : u32, dwtimeout : u32, ppvobject : *mut *mut core::ffi::c_void, hasyncretrieve : HCRYPTASYNC, pcredentials : *const CRYPT_CREDENTIALS, pvverify : *const core::ffi::c_void, pauxinfo : *mut CRYPT_RETRIEVE_AUX_INFO) -> super::super::Foundation:: BOOL);
    CryptRetrieveObjectByUrlW(pszurl.param().abi(), pszobjectoid.param().abi(), dwretrievalflags, dwtimeout, ppvobject, hasyncretrieve.param().abi(), core::mem::transmute(pcredentials.unwrap_or(std::ptr::null())), core::mem::transmute(pvverify.unwrap_or(std::ptr::null())), core::mem::transmute(pauxinfo.unwrap_or(std::ptr::null_mut())))
}
#[inline]
pub unsafe fn CryptRetrieveTimeStamp<P0, P1>(wszurl: P0, dwretrievalflags: u32, dwtimeout: u32, pszhashid: P1, ppara: Option<*const CRYPT_TIMESTAMP_PARA>, pbdata: &[u8], pptscontext: *mut *mut CRYPT_TIMESTAMP_CONTEXT, pptssigner: *mut *mut CERT_CONTEXT, phstore: Option<*mut HCERTSTORE>) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptRetrieveTimeStamp(wszurl : windows_core::PCWSTR, dwretrievalflags : u32, dwtimeout : u32, pszhashid : windows_core::PCSTR, ppara : *const CRYPT_TIMESTAMP_PARA, pbdata : *const u8, cbdata : u32, pptscontext : *mut *mut CRYPT_TIMESTAMP_CONTEXT, pptssigner : *mut *mut CERT_CONTEXT, phstore : *mut HCERTSTORE) -> super::super::Foundation:: BOOL);
    CryptRetrieveTimeStamp(wszurl.param().abi(), dwretrievalflags, dwtimeout, pszhashid.param().abi(), core::mem::transmute(ppara.unwrap_or(std::ptr::null())), core::mem::transmute(pbdata.as_ptr()), pbdata.len().try_into().unwrap(), pptscontext, pptssigner, core::mem::transmute(phstore.unwrap_or(std::ptr::null_mut()))).ok()
}
#[inline]
pub unsafe fn CryptSetAsyncParam<P0, P1>(hasync: P0, pszparamoid: P1, pvparam: Option<*const core::ffi::c_void>, pfnfree: PFN_CRYPT_ASYNC_PARAM_FREE_FUNC) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<HCRYPTASYNC>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptSetAsyncParam(hasync : HCRYPTASYNC, pszparamoid : windows_core::PCSTR, pvparam : *const core::ffi::c_void, pfnfree : PFN_CRYPT_ASYNC_PARAM_FREE_FUNC) -> super::super::Foundation:: BOOL);
    CryptSetAsyncParam(hasync.param().abi(), pszparamoid.param().abi(), core::mem::transmute(pvparam.unwrap_or(std::ptr::null())), pfnfree)
}
#[inline]
pub unsafe fn CryptSetHashParam(hhash: usize, dwparam: CRYPT_SET_HASH_PARAM, pbdata: *const u8, dwflags: u32) -> windows_core::Result<()> {
    windows_targets::link!("advapi32.dll" "system" fn CryptSetHashParam(hhash : usize, dwparam : CRYPT_SET_HASH_PARAM, pbdata : *const u8, dwflags : u32) -> super::super::Foundation:: BOOL);
    CryptSetHashParam(hhash, dwparam, pbdata, dwflags).ok()
}
#[inline]
pub unsafe fn CryptSetKeyIdentifierProperty<P0>(pkeyidentifier: *const CRYPT_INTEGER_BLOB, dwpropid: u32, dwflags: u32, pwszcomputername: P0, pvreserved: Option<*const core::ffi::c_void>, pvdata: Option<*const core::ffi::c_void>) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptSetKeyIdentifierProperty(pkeyidentifier : *const CRYPT_INTEGER_BLOB, dwpropid : u32, dwflags : u32, pwszcomputername : windows_core::PCWSTR, pvreserved : *const core::ffi::c_void, pvdata : *const core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CryptSetKeyIdentifierProperty(pkeyidentifier, dwpropid, dwflags, pwszcomputername.param().abi(), core::mem::transmute(pvreserved.unwrap_or(std::ptr::null())), core::mem::transmute(pvdata.unwrap_or(std::ptr::null()))).ok()
}
#[inline]
pub unsafe fn CryptSetKeyParam(hkey: usize, dwparam: CRYPT_KEY_PARAM_ID, pbdata: *const u8, dwflags: u32) -> windows_core::Result<()> {
    windows_targets::link!("advapi32.dll" "system" fn CryptSetKeyParam(hkey : usize, dwparam : CRYPT_KEY_PARAM_ID, pbdata : *const u8, dwflags : u32) -> super::super::Foundation:: BOOL);
    CryptSetKeyParam(hkey, dwparam, pbdata, dwflags).ok()
}
#[cfg(feature = "Win32_System_Registry")]
#[inline]
pub unsafe fn CryptSetOIDFunctionValue<P0, P1, P2>(dwencodingtype: u32, pszfuncname: P0, pszoid: P1, pwszvaluename: P2, dwvaluetype: super::super::System::Registry::REG_VALUE_TYPE, pbvaluedata: Option<&[u8]>) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptSetOIDFunctionValue(dwencodingtype : u32, pszfuncname : windows_core::PCSTR, pszoid : windows_core::PCSTR, pwszvaluename : windows_core::PCWSTR, dwvaluetype : super::super::System::Registry:: REG_VALUE_TYPE, pbvaluedata : *const u8, cbvaluedata : u32) -> super::super::Foundation:: BOOL);
    CryptSetOIDFunctionValue(dwencodingtype, pszfuncname.param().abi(), pszoid.param().abi(), pwszvaluename.param().abi(), dwvaluetype, core::mem::transmute(pbvaluedata.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), pbvaluedata.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()))
}
#[inline]
pub unsafe fn CryptSetProvParam(hprov: usize, dwparam: CRYPT_SET_PROV_PARAM_ID, pbdata: *const u8, dwflags: u32) -> windows_core::Result<()> {
    windows_targets::link!("advapi32.dll" "system" fn CryptSetProvParam(hprov : usize, dwparam : CRYPT_SET_PROV_PARAM_ID, pbdata : *const u8, dwflags : u32) -> super::super::Foundation:: BOOL);
    CryptSetProvParam(hprov, dwparam, pbdata, dwflags).ok()
}
#[inline]
pub unsafe fn CryptSetProviderA<P0>(pszprovname: P0, dwprovtype: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("advapi32.dll" "system" fn CryptSetProviderA(pszprovname : windows_core::PCSTR, dwprovtype : u32) -> super::super::Foundation:: BOOL);
    CryptSetProviderA(pszprovname.param().abi(), dwprovtype).ok()
}
#[inline]
pub unsafe fn CryptSetProviderExA<P0>(pszprovname: P0, dwprovtype: u32, pdwreserved: Option<*const u32>, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("advapi32.dll" "system" fn CryptSetProviderExA(pszprovname : windows_core::PCSTR, dwprovtype : u32, pdwreserved : *const u32, dwflags : u32) -> super::super::Foundation:: BOOL);
    CryptSetProviderExA(pszprovname.param().abi(), dwprovtype, core::mem::transmute(pdwreserved.unwrap_or(std::ptr::null())), dwflags).ok()
}
#[inline]
pub unsafe fn CryptSetProviderExW<P0>(pszprovname: P0, dwprovtype: u32, pdwreserved: Option<*const u32>, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("advapi32.dll" "system" fn CryptSetProviderExW(pszprovname : windows_core::PCWSTR, dwprovtype : u32, pdwreserved : *const u32, dwflags : u32) -> super::super::Foundation:: BOOL);
    CryptSetProviderExW(pszprovname.param().abi(), dwprovtype, core::mem::transmute(pdwreserved.unwrap_or(std::ptr::null())), dwflags).ok()
}
#[inline]
pub unsafe fn CryptSetProviderW<P0>(pszprovname: P0, dwprovtype: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("advapi32.dll" "system" fn CryptSetProviderW(pszprovname : windows_core::PCWSTR, dwprovtype : u32) -> super::super::Foundation:: BOOL);
    CryptSetProviderW(pszprovname.param().abi(), dwprovtype).ok()
}
#[inline]
pub unsafe fn CryptSignAndEncodeCertificate<P0, P1>(hcryptprovorncryptkey: P0, dwkeyspec: CERT_KEY_SPEC, dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, lpszstructtype: P1, pvstructinfo: *const core::ffi::c_void, psignaturealgorithm: *const CRYPT_ALGORITHM_IDENTIFIER, pvhashauxinfo: Option<*const core::ffi::c_void>, pbencoded: Option<*mut u8>, pcbencoded: *mut u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<HCRYPTPROV_OR_NCRYPT_KEY_HANDLE>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptSignAndEncodeCertificate(hcryptprovorncryptkey : HCRYPTPROV_OR_NCRYPT_KEY_HANDLE, dwkeyspec : CERT_KEY_SPEC, dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, lpszstructtype : windows_core::PCSTR, pvstructinfo : *const core::ffi::c_void, psignaturealgorithm : *const CRYPT_ALGORITHM_IDENTIFIER, pvhashauxinfo : *const core::ffi::c_void, pbencoded : *mut u8, pcbencoded : *mut u32) -> super::super::Foundation:: BOOL);
    CryptSignAndEncodeCertificate(hcryptprovorncryptkey.param().abi(), dwkeyspec, dwcertencodingtype, lpszstructtype.param().abi(), pvstructinfo, psignaturealgorithm, core::mem::transmute(pvhashauxinfo.unwrap_or(std::ptr::null())), core::mem::transmute(pbencoded.unwrap_or(std::ptr::null_mut())), pcbencoded).ok()
}
#[inline]
pub unsafe fn CryptSignAndEncryptMessage(psignpara: *const CRYPT_SIGN_MESSAGE_PARA, pencryptpara: *const CRYPT_ENCRYPT_MESSAGE_PARA, rgprecipientcert: &[*const CERT_CONTEXT], pbtobesignedandencrypted: &[u8], pbsignedandencryptedblob: Option<*mut u8>, pcbsignedandencryptedblob: *mut u32) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CryptSignAndEncryptMessage(psignpara : *const CRYPT_SIGN_MESSAGE_PARA, pencryptpara : *const CRYPT_ENCRYPT_MESSAGE_PARA, crecipientcert : u32, rgprecipientcert : *const *const CERT_CONTEXT, pbtobesignedandencrypted : *const u8, cbtobesignedandencrypted : u32, pbsignedandencryptedblob : *mut u8, pcbsignedandencryptedblob : *mut u32) -> super::super::Foundation:: BOOL);
    CryptSignAndEncryptMessage(psignpara, pencryptpara, rgprecipientcert.len().try_into().unwrap(), core::mem::transmute(rgprecipientcert.as_ptr()), core::mem::transmute(pbtobesignedandencrypted.as_ptr()), pbtobesignedandencrypted.len().try_into().unwrap(), core::mem::transmute(pbsignedandencryptedblob.unwrap_or(std::ptr::null_mut())), pcbsignedandencryptedblob).ok()
}
#[inline]
pub unsafe fn CryptSignCertificate<P0>(hcryptprovorncryptkey: P0, dwkeyspec: u32, dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pbencodedtobesigned: &[u8], psignaturealgorithm: *const CRYPT_ALGORITHM_IDENTIFIER, pvhashauxinfo: Option<*const core::ffi::c_void>, pbsignature: Option<*mut u8>, pcbsignature: *mut u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<HCRYPTPROV_OR_NCRYPT_KEY_HANDLE>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptSignCertificate(hcryptprovorncryptkey : HCRYPTPROV_OR_NCRYPT_KEY_HANDLE, dwkeyspec : u32, dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pbencodedtobesigned : *const u8, cbencodedtobesigned : u32, psignaturealgorithm : *const CRYPT_ALGORITHM_IDENTIFIER, pvhashauxinfo : *const core::ffi::c_void, pbsignature : *mut u8, pcbsignature : *mut u32) -> super::super::Foundation:: BOOL);
    CryptSignCertificate(hcryptprovorncryptkey.param().abi(), dwkeyspec, dwcertencodingtype, core::mem::transmute(pbencodedtobesigned.as_ptr()), pbencodedtobesigned.len().try_into().unwrap(), psignaturealgorithm, core::mem::transmute(pvhashauxinfo.unwrap_or(std::ptr::null())), core::mem::transmute(pbsignature.unwrap_or(std::ptr::null_mut())), pcbsignature).ok()
}
#[inline]
pub unsafe fn CryptSignHashA<P0>(hhash: usize, dwkeyspec: u32, szdescription: P0, dwflags: u32, pbsignature: Option<*mut u8>, pdwsiglen: *mut u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("advapi32.dll" "system" fn CryptSignHashA(hhash : usize, dwkeyspec : u32, szdescription : windows_core::PCSTR, dwflags : u32, pbsignature : *mut u8, pdwsiglen : *mut u32) -> super::super::Foundation:: BOOL);
    CryptSignHashA(hhash, dwkeyspec, szdescription.param().abi(), dwflags, core::mem::transmute(pbsignature.unwrap_or(std::ptr::null_mut())), pdwsiglen).ok()
}
#[inline]
pub unsafe fn CryptSignHashW<P0>(hhash: usize, dwkeyspec: u32, szdescription: P0, dwflags: u32, pbsignature: Option<*mut u8>, pdwsiglen: *mut u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("advapi32.dll" "system" fn CryptSignHashW(hhash : usize, dwkeyspec : u32, szdescription : windows_core::PCWSTR, dwflags : u32, pbsignature : *mut u8, pdwsiglen : *mut u32) -> super::super::Foundation:: BOOL);
    CryptSignHashW(hhash, dwkeyspec, szdescription.param().abi(), dwflags, core::mem::transmute(pbsignature.unwrap_or(std::ptr::null_mut())), pdwsiglen).ok()
}
#[inline]
pub unsafe fn CryptSignMessage<P0>(psignpara: *const CRYPT_SIGN_MESSAGE_PARA, fdetachedsignature: P0, ctobesigned: u32, rgpbtobesigned: Option<*const *const u8>, rgcbtobesigned: *const u32, pbsignedblob: Option<*mut u8>, pcbsignedblob: *mut u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::Foundation::BOOL>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptSignMessage(psignpara : *const CRYPT_SIGN_MESSAGE_PARA, fdetachedsignature : super::super::Foundation:: BOOL, ctobesigned : u32, rgpbtobesigned : *const *const u8, rgcbtobesigned : *const u32, pbsignedblob : *mut u8, pcbsignedblob : *mut u32) -> super::super::Foundation:: BOOL);
    CryptSignMessage(psignpara, fdetachedsignature.param().abi(), ctobesigned, core::mem::transmute(rgpbtobesigned.unwrap_or(std::ptr::null())), rgcbtobesigned, core::mem::transmute(pbsignedblob.unwrap_or(std::ptr::null_mut())), pcbsignedblob).ok()
}
#[inline]
pub unsafe fn CryptSignMessageWithKey(psignpara: *const CRYPT_KEY_SIGN_MESSAGE_PARA, pbtobesigned: &[u8], pbsignedblob: Option<*mut u8>, pcbsignedblob: *mut u32) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CryptSignMessageWithKey(psignpara : *const CRYPT_KEY_SIGN_MESSAGE_PARA, pbtobesigned : *const u8, cbtobesigned : u32, pbsignedblob : *mut u8, pcbsignedblob : *mut u32) -> super::super::Foundation:: BOOL);
    CryptSignMessageWithKey(psignpara, core::mem::transmute(pbtobesigned.as_ptr()), pbtobesigned.len().try_into().unwrap(), core::mem::transmute(pbsignedblob.unwrap_or(std::ptr::null_mut())), pcbsignedblob).ok()
}
#[inline]
pub unsafe fn CryptStringToBinaryA(pszstring: &[u8], dwflags: CRYPT_STRING, pbbinary: Option<*mut u8>, pcbbinary: *mut u32, pdwskip: Option<*mut u32>, pdwflags: Option<*mut u32>) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CryptStringToBinaryA(pszstring : windows_core::PCSTR, cchstring : u32, dwflags : CRYPT_STRING, pbbinary : *mut u8, pcbbinary : *mut u32, pdwskip : *mut u32, pdwflags : *mut u32) -> super::super::Foundation:: BOOL);
    CryptStringToBinaryA(core::mem::transmute(pszstring.as_ptr()), pszstring.len().try_into().unwrap(), dwflags, core::mem::transmute(pbbinary.unwrap_or(std::ptr::null_mut())), pcbbinary, core::mem::transmute(pdwskip.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pdwflags.unwrap_or(std::ptr::null_mut()))).ok()
}
#[inline]
pub unsafe fn CryptStringToBinaryW(pszstring: &[u16], dwflags: CRYPT_STRING, pbbinary: Option<*mut u8>, pcbbinary: *mut u32, pdwskip: Option<*mut u32>, pdwflags: Option<*mut u32>) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CryptStringToBinaryW(pszstring : windows_core::PCWSTR, cchstring : u32, dwflags : CRYPT_STRING, pbbinary : *mut u8, pcbbinary : *mut u32, pdwskip : *mut u32, pdwflags : *mut u32) -> super::super::Foundation:: BOOL);
    CryptStringToBinaryW(core::mem::transmute(pszstring.as_ptr()), pszstring.len().try_into().unwrap(), dwflags, core::mem::transmute(pbbinary.unwrap_or(std::ptr::null_mut())), pcbbinary, core::mem::transmute(pdwskip.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pdwflags.unwrap_or(std::ptr::null_mut()))).ok()
}
#[inline]
pub unsafe fn CryptUninstallCancelRetrieval(dwflags: u32, pvreserved: Option<*const core::ffi::c_void>) -> super::super::Foundation::BOOL {
    windows_targets::link!("cryptnet.dll" "system" fn CryptUninstallCancelRetrieval(dwflags : u32, pvreserved : *const core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CryptUninstallCancelRetrieval(dwflags, core::mem::transmute(pvreserved.unwrap_or(std::ptr::null())))
}
#[inline]
pub unsafe fn CryptUninstallDefaultContext(hdefaultcontext: Option<*const core::ffi::c_void>, dwflags: u32, pvreserved: Option<*const core::ffi::c_void>) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CryptUninstallDefaultContext(hdefaultcontext : *const core::ffi::c_void, dwflags : u32, pvreserved : *const core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CryptUninstallDefaultContext(core::mem::transmute(hdefaultcontext.unwrap_or(std::ptr::null())), dwflags, core::mem::transmute(pvreserved.unwrap_or(std::ptr::null()))).ok()
}
#[inline]
pub unsafe fn CryptUnprotectData(pdatain: *const CRYPT_INTEGER_BLOB, ppszdatadescr: Option<*mut windows_core::PWSTR>, poptionalentropy: Option<*const CRYPT_INTEGER_BLOB>, pvreserved: Option<*const core::ffi::c_void>, ppromptstruct: Option<*const CRYPTPROTECT_PROMPTSTRUCT>, dwflags: u32, pdataout: *mut CRYPT_INTEGER_BLOB) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CryptUnprotectData(pdatain : *const CRYPT_INTEGER_BLOB, ppszdatadescr : *mut windows_core::PWSTR, poptionalentropy : *const CRYPT_INTEGER_BLOB, pvreserved : *const core::ffi::c_void, ppromptstruct : *const CRYPTPROTECT_PROMPTSTRUCT, dwflags : u32, pdataout : *mut CRYPT_INTEGER_BLOB) -> super::super::Foundation:: BOOL);
    CryptUnprotectData(pdatain, core::mem::transmute(ppszdatadescr.unwrap_or(std::ptr::null_mut())), core::mem::transmute(poptionalentropy.unwrap_or(std::ptr::null())), core::mem::transmute(pvreserved.unwrap_or(std::ptr::null())), core::mem::transmute(ppromptstruct.unwrap_or(std::ptr::null())), dwflags, pdataout).ok()
}
#[inline]
pub unsafe fn CryptUnprotectMemory(pdatain: *mut core::ffi::c_void, cbdatain: u32, dwflags: u32) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CryptUnprotectMemory(pdatain : *mut core::ffi::c_void, cbdatain : u32, dwflags : u32) -> super::super::Foundation:: BOOL);
    CryptUnprotectMemory(pdatain, cbdatain, dwflags).ok()
}
#[inline]
pub unsafe fn CryptUnregisterDefaultOIDFunction<P0, P1>(dwencodingtype: u32, pszfuncname: P0, pwszdll: P1) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptUnregisterDefaultOIDFunction(dwencodingtype : u32, pszfuncname : windows_core::PCSTR, pwszdll : windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    CryptUnregisterDefaultOIDFunction(dwencodingtype, pszfuncname.param().abi(), pwszdll.param().abi())
}
#[inline]
pub unsafe fn CryptUnregisterOIDFunction<P0, P1>(dwencodingtype: u32, pszfuncname: P0, pszoid: P1) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptUnregisterOIDFunction(dwencodingtype : u32, pszfuncname : windows_core::PCSTR, pszoid : windows_core::PCSTR) -> super::super::Foundation:: BOOL);
    CryptUnregisterOIDFunction(dwencodingtype, pszfuncname.param().abi(), pszoid.param().abi())
}
#[inline]
pub unsafe fn CryptUnregisterOIDInfo(pinfo: *const CRYPT_OID_INFO) -> super::super::Foundation::BOOL {
    windows_targets::link!("crypt32.dll" "system" fn CryptUnregisterOIDInfo(pinfo : *const CRYPT_OID_INFO) -> super::super::Foundation:: BOOL);
    CryptUnregisterOIDInfo(pinfo)
}
#[inline]
pub unsafe fn CryptUpdateProtectedState<P0, P1>(poldsid: P0, pwszoldpassword: P1, dwflags: u32, pdwsuccesscount: Option<*mut u32>, pdwfailurecount: Option<*mut u32>) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::Foundation::PSID>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptUpdateProtectedState(poldsid : super::super::Foundation:: PSID, pwszoldpassword : windows_core::PCWSTR, dwflags : u32, pdwsuccesscount : *mut u32, pdwfailurecount : *mut u32) -> super::super::Foundation:: BOOL);
    CryptUpdateProtectedState(poldsid.param().abi(), pwszoldpassword.param().abi(), dwflags, core::mem::transmute(pdwsuccesscount.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pdwfailurecount.unwrap_or(std::ptr::null_mut()))).ok()
}
#[inline]
pub unsafe fn CryptVerifyCertificateSignature<P0>(hcryptprov: P0, dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pbencoded: &[u8], ppublickey: *const CERT_PUBLIC_KEY_INFO) -> windows_core::Result<()>
where
    P0: windows_core::Param<HCRYPTPROV_LEGACY>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptVerifyCertificateSignature(hcryptprov : HCRYPTPROV_LEGACY, dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pbencoded : *const u8, cbencoded : u32, ppublickey : *const CERT_PUBLIC_KEY_INFO) -> super::super::Foundation:: BOOL);
    CryptVerifyCertificateSignature(hcryptprov.param().abi(), dwcertencodingtype, core::mem::transmute(pbencoded.as_ptr()), pbencoded.len().try_into().unwrap(), ppublickey).ok()
}
#[inline]
pub unsafe fn CryptVerifyCertificateSignatureEx<P0>(hcryptprov: P0, dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, dwsubjecttype: u32, pvsubject: *const core::ffi::c_void, dwissuertype: u32, pvissuer: Option<*const core::ffi::c_void>, dwflags: CRYPT_VERIFY_CERT_FLAGS, pvextra: Option<*mut core::ffi::c_void>) -> windows_core::Result<()>
where
    P0: windows_core::Param<HCRYPTPROV_LEGACY>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptVerifyCertificateSignatureEx(hcryptprov : HCRYPTPROV_LEGACY, dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, dwsubjecttype : u32, pvsubject : *const core::ffi::c_void, dwissuertype : u32, pvissuer : *const core::ffi::c_void, dwflags : CRYPT_VERIFY_CERT_FLAGS, pvextra : *mut core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CryptVerifyCertificateSignatureEx(hcryptprov.param().abi(), dwcertencodingtype, dwsubjecttype, pvsubject, dwissuertype, core::mem::transmute(pvissuer.unwrap_or(std::ptr::null())), dwflags, core::mem::transmute(pvextra.unwrap_or(std::ptr::null_mut()))).ok()
}
#[inline]
pub unsafe fn CryptVerifyDetachedMessageHash(phashpara: *const CRYPT_HASH_MESSAGE_PARA, pbdetachedhashblob: &[u8], ctobehashed: u32, rgpbtobehashed: *const *const u8, rgcbtobehashed: *const u32, pbcomputedhash: Option<*mut u8>, pcbcomputedhash: Option<*mut u32>) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CryptVerifyDetachedMessageHash(phashpara : *const CRYPT_HASH_MESSAGE_PARA, pbdetachedhashblob : *const u8, cbdetachedhashblob : u32, ctobehashed : u32, rgpbtobehashed : *const *const u8, rgcbtobehashed : *const u32, pbcomputedhash : *mut u8, pcbcomputedhash : *mut u32) -> super::super::Foundation:: BOOL);
    CryptVerifyDetachedMessageHash(phashpara, core::mem::transmute(pbdetachedhashblob.as_ptr()), pbdetachedhashblob.len().try_into().unwrap(), ctobehashed, rgpbtobehashed, rgcbtobehashed, core::mem::transmute(pbcomputedhash.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pcbcomputedhash.unwrap_or(std::ptr::null_mut()))).ok()
}
#[inline]
pub unsafe fn CryptVerifyDetachedMessageSignature(pverifypara: *const CRYPT_VERIFY_MESSAGE_PARA, dwsignerindex: u32, pbdetachedsignblob: &[u8], ctobesigned: u32, rgpbtobesigned: *const *const u8, rgcbtobesigned: *const u32, ppsignercert: Option<*mut *mut CERT_CONTEXT>) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CryptVerifyDetachedMessageSignature(pverifypara : *const CRYPT_VERIFY_MESSAGE_PARA, dwsignerindex : u32, pbdetachedsignblob : *const u8, cbdetachedsignblob : u32, ctobesigned : u32, rgpbtobesigned : *const *const u8, rgcbtobesigned : *const u32, ppsignercert : *mut *mut CERT_CONTEXT) -> super::super::Foundation:: BOOL);
    CryptVerifyDetachedMessageSignature(pverifypara, dwsignerindex, core::mem::transmute(pbdetachedsignblob.as_ptr()), pbdetachedsignblob.len().try_into().unwrap(), ctobesigned, rgpbtobesigned, rgcbtobesigned, core::mem::transmute(ppsignercert.unwrap_or(std::ptr::null_mut()))).ok()
}
#[inline]
pub unsafe fn CryptVerifyMessageHash(phashpara: *const CRYPT_HASH_MESSAGE_PARA, pbhashedblob: &[u8], pbtobehashed: Option<*mut u8>, pcbtobehashed: Option<*mut u32>, pbcomputedhash: Option<*mut u8>, pcbcomputedhash: Option<*mut u32>) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CryptVerifyMessageHash(phashpara : *const CRYPT_HASH_MESSAGE_PARA, pbhashedblob : *const u8, cbhashedblob : u32, pbtobehashed : *mut u8, pcbtobehashed : *mut u32, pbcomputedhash : *mut u8, pcbcomputedhash : *mut u32) -> super::super::Foundation:: BOOL);
    CryptVerifyMessageHash(phashpara, core::mem::transmute(pbhashedblob.as_ptr()), pbhashedblob.len().try_into().unwrap(), core::mem::transmute(pbtobehashed.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pcbtobehashed.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pbcomputedhash.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pcbcomputedhash.unwrap_or(std::ptr::null_mut()))).ok()
}
#[inline]
pub unsafe fn CryptVerifyMessageSignature(pverifypara: *const CRYPT_VERIFY_MESSAGE_PARA, dwsignerindex: u32, pbsignedblob: &[u8], pbdecoded: Option<*mut u8>, pcbdecoded: Option<*mut u32>, ppsignercert: Option<*mut *mut CERT_CONTEXT>) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CryptVerifyMessageSignature(pverifypara : *const CRYPT_VERIFY_MESSAGE_PARA, dwsignerindex : u32, pbsignedblob : *const u8, cbsignedblob : u32, pbdecoded : *mut u8, pcbdecoded : *mut u32, ppsignercert : *mut *mut CERT_CONTEXT) -> super::super::Foundation:: BOOL);
    CryptVerifyMessageSignature(pverifypara, dwsignerindex, core::mem::transmute(pbsignedblob.as_ptr()), pbsignedblob.len().try_into().unwrap(), core::mem::transmute(pbdecoded.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pcbdecoded.unwrap_or(std::ptr::null_mut())), core::mem::transmute(ppsignercert.unwrap_or(std::ptr::null_mut()))).ok()
}
#[inline]
pub unsafe fn CryptVerifyMessageSignatureWithKey(pverifypara: *const CRYPT_KEY_VERIFY_MESSAGE_PARA, ppublickeyinfo: Option<*const CERT_PUBLIC_KEY_INFO>, pbsignedblob: &[u8], pbdecoded: Option<*mut u8>, pcbdecoded: Option<*mut u32>) -> windows_core::Result<()> {
    windows_targets::link!("crypt32.dll" "system" fn CryptVerifyMessageSignatureWithKey(pverifypara : *const CRYPT_KEY_VERIFY_MESSAGE_PARA, ppublickeyinfo : *const CERT_PUBLIC_KEY_INFO, pbsignedblob : *const u8, cbsignedblob : u32, pbdecoded : *mut u8, pcbdecoded : *mut u32) -> super::super::Foundation:: BOOL);
    CryptVerifyMessageSignatureWithKey(pverifypara, core::mem::transmute(ppublickeyinfo.unwrap_or(std::ptr::null())), core::mem::transmute(pbsignedblob.as_ptr()), pbsignedblob.len().try_into().unwrap(), core::mem::transmute(pbdecoded.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pcbdecoded.unwrap_or(std::ptr::null_mut()))).ok()
}
#[inline]
pub unsafe fn CryptVerifySignatureA<P0>(hhash: usize, pbsignature: &[u8], hpubkey: usize, szdescription: P0, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_targets::link!("advapi32.dll" "system" fn CryptVerifySignatureA(hhash : usize, pbsignature : *const u8, dwsiglen : u32, hpubkey : usize, szdescription : windows_core::PCSTR, dwflags : u32) -> super::super::Foundation:: BOOL);
    CryptVerifySignatureA(hhash, core::mem::transmute(pbsignature.as_ptr()), pbsignature.len().try_into().unwrap(), hpubkey, szdescription.param().abi(), dwflags).ok()
}
#[inline]
pub unsafe fn CryptVerifySignatureW<P0>(hhash: usize, pbsignature: &[u8], hpubkey: usize, szdescription: P0, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("advapi32.dll" "system" fn CryptVerifySignatureW(hhash : usize, pbsignature : *const u8, dwsiglen : u32, hpubkey : usize, szdescription : windows_core::PCWSTR, dwflags : u32) -> super::super::Foundation:: BOOL);
    CryptVerifySignatureW(hhash, core::mem::transmute(pbsignature.as_ptr()), pbsignature.len().try_into().unwrap(), hpubkey, szdescription.param().abi(), dwflags).ok()
}
#[inline]
pub unsafe fn CryptVerifyTimeStampSignature<P0>(pbtscontentinfo: &[u8], pbdata: Option<&[u8]>, hadditionalstore: P0, pptscontext: *mut *mut CRYPT_TIMESTAMP_CONTEXT, pptssigner: *mut *mut CERT_CONTEXT, phstore: Option<*mut HCERTSTORE>) -> windows_core::Result<()>
where
    P0: windows_core::Param<HCERTSTORE>,
{
    windows_targets::link!("crypt32.dll" "system" fn CryptVerifyTimeStampSignature(pbtscontentinfo : *const u8, cbtscontentinfo : u32, pbdata : *const u8, cbdata : u32, hadditionalstore : HCERTSTORE, pptscontext : *mut *mut CRYPT_TIMESTAMP_CONTEXT, pptssigner : *mut *mut CERT_CONTEXT, phstore : *mut HCERTSTORE) -> super::super::Foundation:: BOOL);
    CryptVerifyTimeStampSignature(core::mem::transmute(pbtscontentinfo.as_ptr()), pbtscontentinfo.len().try_into().unwrap(), core::mem::transmute(pbdata.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), pbdata.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), hadditionalstore.param().abi(), pptscontext, pptssigner, core::mem::transmute(phstore.unwrap_or(std::ptr::null_mut()))).ok()
}
#[inline]
pub unsafe fn CryptXmlAddObject(hsignatureorobject: *const core::ffi::c_void, dwflags: u32, rgproperty: Option<&[CRYPT_XML_PROPERTY]>, pencoded: *const CRYPT_XML_BLOB) -> windows_core::Result<*mut CRYPT_XML_OBJECT> {
    windows_targets::link!("cryptxml.dll" "system" fn CryptXmlAddObject(hsignatureorobject : *const core::ffi::c_void, dwflags : u32, rgproperty : *const CRYPT_XML_PROPERTY, cproperty : u32, pencoded : *const CRYPT_XML_BLOB, ppobject : *mut *mut CRYPT_XML_OBJECT) -> windows_core::HRESULT);
    let mut result__ = std::mem::zeroed();
    CryptXmlAddObject(hsignatureorobject, dwflags, core::mem::transmute(rgproperty.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), rgproperty.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), pencoded, &mut result__).map(|| result__)
}
#[inline]
pub unsafe fn CryptXmlClose(hcryptxml: *const core::ffi::c_void) -> windows_core::Result<()> {
    windows_targets::link!("cryptxml.dll" "system" fn CryptXmlClose(hcryptxml : *const core::ffi::c_void) -> windows_core::HRESULT);
    CryptXmlClose(hcryptxml).ok()
}
#[inline]
pub unsafe fn CryptXmlCreateReference<P0, P1, P2>(hcryptxml: *const core::ffi::c_void, dwflags: u32, wszid: P0, wszuri: P1, wsztype: P2, pdigestmethod: *const CRYPT_XML_ALGORITHM, rgtransform: Option<&[CRYPT_XML_ALGORITHM]>, phreference: *mut *mut core::ffi::c_void) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("cryptxml.dll" "system" fn CryptXmlCreateReference(hcryptxml : *const core::ffi::c_void, dwflags : u32, wszid : windows_core::PCWSTR, wszuri : windows_core::PCWSTR, wsztype : windows_core::PCWSTR, pdigestmethod : *const CRYPT_XML_ALGORITHM, ctransform : u32, rgtransform : *const CRYPT_XML_ALGORITHM, phreference : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    CryptXmlCreateReference(hcryptxml, dwflags, wszid.param().abi(), wszuri.param().abi(), wsztype.param().abi(), pdigestmethod, rgtransform.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(rgtransform.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), phreference).ok()
}
#[inline]
pub unsafe fn CryptXmlDigestReference(hreference: *const core::ffi::c_void, dwflags: u32, pdataproviderin: *const CRYPT_XML_DATA_PROVIDER) -> windows_core::Result<()> {
    windows_targets::link!("cryptxml.dll" "system" fn CryptXmlDigestReference(hreference : *const core::ffi::c_void, dwflags : u32, pdataproviderin : *const CRYPT_XML_DATA_PROVIDER) -> windows_core::HRESULT);
    CryptXmlDigestReference(hreference, dwflags, pdataproviderin).ok()
}
#[inline]
pub unsafe fn CryptXmlEncode(hcryptxml: *const core::ffi::c_void, dwcharset: CRYPT_XML_CHARSET, rgproperty: Option<&[CRYPT_XML_PROPERTY]>, pvcallbackstate: *mut core::ffi::c_void, pfnwrite: PFN_CRYPT_XML_WRITE_CALLBACK) -> windows_core::Result<()> {
    windows_targets::link!("cryptxml.dll" "system" fn CryptXmlEncode(hcryptxml : *const core::ffi::c_void, dwcharset : CRYPT_XML_CHARSET, rgproperty : *const CRYPT_XML_PROPERTY, cproperty : u32, pvcallbackstate : *mut core::ffi::c_void, pfnwrite : PFN_CRYPT_XML_WRITE_CALLBACK) -> windows_core::HRESULT);
    CryptXmlEncode(hcryptxml, dwcharset, core::mem::transmute(rgproperty.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), rgproperty.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), pvcallbackstate, pfnwrite).ok()
}
#[inline]
pub unsafe fn CryptXmlEnumAlgorithmInfo(dwgroupid: u32, dwflags: u32, pvarg: Option<*mut core::ffi::c_void>, pfnenumalginfo: PFN_CRYPT_XML_ENUM_ALG_INFO) -> windows_core::Result<()> {
    windows_targets::link!("cryptxml.dll" "system" fn CryptXmlEnumAlgorithmInfo(dwgroupid : u32, dwflags : u32, pvarg : *mut core::ffi::c_void, pfnenumalginfo : PFN_CRYPT_XML_ENUM_ALG_INFO) -> windows_core::HRESULT);
    CryptXmlEnumAlgorithmInfo(dwgroupid, dwflags, core::mem::transmute(pvarg.unwrap_or(std::ptr::null_mut())), pfnenumalginfo).ok()
}
#[inline]
pub unsafe fn CryptXmlFindAlgorithmInfo(dwfindbytype: u32, pvfindby: *const core::ffi::c_void, dwgroupid: u32, dwflags: u32) -> *mut CRYPT_XML_ALGORITHM_INFO {
    windows_targets::link!("cryptxml.dll" "system" fn CryptXmlFindAlgorithmInfo(dwfindbytype : u32, pvfindby : *const core::ffi::c_void, dwgroupid : u32, dwflags : u32) -> *mut CRYPT_XML_ALGORITHM_INFO);
    CryptXmlFindAlgorithmInfo(dwfindbytype, pvfindby, dwgroupid, dwflags)
}
#[inline]
pub unsafe fn CryptXmlGetAlgorithmInfo(pxmlalgorithm: *const CRYPT_XML_ALGORITHM, dwflags: CRYPT_XML_FLAGS) -> windows_core::Result<*mut CRYPT_XML_ALGORITHM_INFO> {
    windows_targets::link!("cryptxml.dll" "system" fn CryptXmlGetAlgorithmInfo(pxmlalgorithm : *const CRYPT_XML_ALGORITHM, dwflags : CRYPT_XML_FLAGS, ppalginfo : *mut *mut CRYPT_XML_ALGORITHM_INFO) -> windows_core::HRESULT);
    let mut result__ = std::mem::zeroed();
    CryptXmlGetAlgorithmInfo(pxmlalgorithm, dwflags, &mut result__).map(|| result__)
}
#[inline]
pub unsafe fn CryptXmlGetDocContext(hcryptxml: *const core::ffi::c_void) -> windows_core::Result<*mut CRYPT_XML_DOC_CTXT> {
    windows_targets::link!("cryptxml.dll" "system" fn CryptXmlGetDocContext(hcryptxml : *const core::ffi::c_void, ppstruct : *mut *mut CRYPT_XML_DOC_CTXT) -> windows_core::HRESULT);
    let mut result__ = std::mem::zeroed();
    CryptXmlGetDocContext(hcryptxml, &mut result__).map(|| result__)
}
#[inline]
pub unsafe fn CryptXmlGetReference(hcryptxml: *const core::ffi::c_void) -> windows_core::Result<*mut CRYPT_XML_REFERENCE> {
    windows_targets::link!("cryptxml.dll" "system" fn CryptXmlGetReference(hcryptxml : *const core::ffi::c_void, ppstruct : *mut *mut CRYPT_XML_REFERENCE) -> windows_core::HRESULT);
    let mut result__ = std::mem::zeroed();
    CryptXmlGetReference(hcryptxml, &mut result__).map(|| result__)
}
#[inline]
pub unsafe fn CryptXmlGetSignature(hcryptxml: *const core::ffi::c_void) -> windows_core::Result<*mut CRYPT_XML_SIGNATURE> {
    windows_targets::link!("cryptxml.dll" "system" fn CryptXmlGetSignature(hcryptxml : *const core::ffi::c_void, ppstruct : *mut *mut CRYPT_XML_SIGNATURE) -> windows_core::HRESULT);
    let mut result__ = std::mem::zeroed();
    CryptXmlGetSignature(hcryptxml, &mut result__).map(|| result__)
}
#[inline]
pub unsafe fn CryptXmlGetStatus(hcryptxml: *const core::ffi::c_void) -> windows_core::Result<CRYPT_XML_STATUS> {
    windows_targets::link!("cryptxml.dll" "system" fn CryptXmlGetStatus(hcryptxml : *const core::ffi::c_void, pstatus : *mut CRYPT_XML_STATUS) -> windows_core::HRESULT);
    let mut result__ = std::mem::zeroed();
    CryptXmlGetStatus(hcryptxml, &mut result__).map(|| result__)
}
#[inline]
pub unsafe fn CryptXmlGetTransforms() -> windows_core::Result<*mut CRYPT_XML_TRANSFORM_CHAIN_CONFIG> {
    windows_targets::link!("cryptxml.dll" "system" fn CryptXmlGetTransforms(ppconfig : *mut *mut CRYPT_XML_TRANSFORM_CHAIN_CONFIG) -> windows_core::HRESULT);
    let mut result__ = std::mem::zeroed();
    CryptXmlGetTransforms(&mut result__).map(|| result__)
}
#[inline]
pub unsafe fn CryptXmlImportPublicKey(dwflags: CRYPT_XML_FLAGS, pkeyvalue: *const CRYPT_XML_KEY_VALUE) -> windows_core::Result<BCRYPT_KEY_HANDLE> {
    windows_targets::link!("cryptxml.dll" "system" fn CryptXmlImportPublicKey(dwflags : CRYPT_XML_FLAGS, pkeyvalue : *const CRYPT_XML_KEY_VALUE, phkey : *mut BCRYPT_KEY_HANDLE) -> windows_core::HRESULT);
    let mut result__ = std::mem::zeroed();
    CryptXmlImportPublicKey(dwflags, pkeyvalue, &mut result__).map(|| result__)
}
#[inline]
pub unsafe fn CryptXmlOpenToDecode(pconfig: Option<*const CRYPT_XML_TRANSFORM_CHAIN_CONFIG>, dwflags: CRYPT_XML_FLAGS, rgproperty: Option<&[CRYPT_XML_PROPERTY]>, pencoded: *const CRYPT_XML_BLOB, phcryptxml: *mut *mut core::ffi::c_void) -> windows_core::Result<()> {
    windows_targets::link!("cryptxml.dll" "system" fn CryptXmlOpenToDecode(pconfig : *const CRYPT_XML_TRANSFORM_CHAIN_CONFIG, dwflags : CRYPT_XML_FLAGS, rgproperty : *const CRYPT_XML_PROPERTY, cproperty : u32, pencoded : *const CRYPT_XML_BLOB, phcryptxml : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    CryptXmlOpenToDecode(core::mem::transmute(pconfig.unwrap_or(std::ptr::null())), dwflags, core::mem::transmute(rgproperty.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), rgproperty.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), pencoded, phcryptxml).ok()
}
#[inline]
pub unsafe fn CryptXmlOpenToEncode<P0>(pconfig: Option<*const CRYPT_XML_TRANSFORM_CHAIN_CONFIG>, dwflags: CRYPT_XML_FLAGS, wszid: P0, rgproperty: Option<&[CRYPT_XML_PROPERTY]>, pencoded: Option<*const CRYPT_XML_BLOB>, phsignature: *mut *mut core::ffi::c_void) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("cryptxml.dll" "system" fn CryptXmlOpenToEncode(pconfig : *const CRYPT_XML_TRANSFORM_CHAIN_CONFIG, dwflags : CRYPT_XML_FLAGS, wszid : windows_core::PCWSTR, rgproperty : *const CRYPT_XML_PROPERTY, cproperty : u32, pencoded : *const CRYPT_XML_BLOB, phsignature : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    CryptXmlOpenToEncode(core::mem::transmute(pconfig.unwrap_or(std::ptr::null())), dwflags, wszid.param().abi(), core::mem::transmute(rgproperty.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), rgproperty.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(pencoded.unwrap_or(std::ptr::null())), phsignature).ok()
}
#[inline]
pub unsafe fn CryptXmlSetHMACSecret(hsignature: *const core::ffi::c_void, pbsecret: &[u8]) -> windows_core::Result<()> {
    windows_targets::link!("cryptxml.dll" "system" fn CryptXmlSetHMACSecret(hsignature : *const core::ffi::c_void, pbsecret : *const u8, cbsecret : u32) -> windows_core::HRESULT);
    CryptXmlSetHMACSecret(hsignature, core::mem::transmute(pbsecret.as_ptr()), pbsecret.len().try_into().unwrap()).ok()
}
#[inline]
pub unsafe fn CryptXmlSign<P0>(hsignature: *const core::ffi::c_void, hkey: P0, dwkeyspec: CERT_KEY_SPEC, dwflags: CRYPT_XML_FLAGS, dwkeyinfospec: CRYPT_XML_KEYINFO_SPEC, pvkeyinfospec: Option<*const core::ffi::c_void>, psignaturemethod: *const CRYPT_XML_ALGORITHM, pcanonicalization: *const CRYPT_XML_ALGORITHM) -> windows_core::Result<()>
where
    P0: windows_core::Param<HCRYPTPROV_OR_NCRYPT_KEY_HANDLE>,
{
    windows_targets::link!("cryptxml.dll" "system" fn CryptXmlSign(hsignature : *const core::ffi::c_void, hkey : HCRYPTPROV_OR_NCRYPT_KEY_HANDLE, dwkeyspec : CERT_KEY_SPEC, dwflags : CRYPT_XML_FLAGS, dwkeyinfospec : CRYPT_XML_KEYINFO_SPEC, pvkeyinfospec : *const core::ffi::c_void, psignaturemethod : *const CRYPT_XML_ALGORITHM, pcanonicalization : *const CRYPT_XML_ALGORITHM) -> windows_core::HRESULT);
    CryptXmlSign(hsignature, hkey.param().abi(), dwkeyspec, dwflags, dwkeyinfospec, core::mem::transmute(pvkeyinfospec.unwrap_or(std::ptr::null())), psignaturemethod, pcanonicalization).ok()
}
#[inline]
pub unsafe fn CryptXmlVerifySignature<P0>(hsignature: *const core::ffi::c_void, hkey: P0, dwflags: CRYPT_XML_FLAGS) -> windows_core::Result<()>
where
    P0: windows_core::Param<BCRYPT_KEY_HANDLE>,
{
    windows_targets::link!("cryptxml.dll" "system" fn CryptXmlVerifySignature(hsignature : *const core::ffi::c_void, hkey : BCRYPT_KEY_HANDLE, dwflags : CRYPT_XML_FLAGS) -> windows_core::HRESULT);
    CryptXmlVerifySignature(hsignature, hkey.param().abi(), dwflags).ok()
}
#[inline]
pub unsafe fn Decrypt<P0>(hcrypto: *const INFORMATIONCARD_CRYPTO_HANDLE, foaep: P0, pindata: &[u8], pcboutdata: *mut u32, ppoutdata: *mut *mut u8) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::Foundation::BOOL>,
{
    windows_targets::link!("infocardapi.dll" "system" fn Decrypt(hcrypto : *const INFORMATIONCARD_CRYPTO_HANDLE, foaep : super::super::Foundation:: BOOL, cbindata : u32, pindata : *const u8, pcboutdata : *mut u32, ppoutdata : *mut *mut u8) -> windows_core::HRESULT);
    Decrypt(hcrypto, foaep.param().abi(), pindata.len().try_into().unwrap(), core::mem::transmute(pindata.as_ptr()), pcboutdata, ppoutdata).ok()
}
#[inline]
pub unsafe fn Encrypt<P0>(hcrypto: *const INFORMATIONCARD_CRYPTO_HANDLE, foaep: P0, pindata: &[u8], pcboutdata: *mut u32, ppoutdata: *mut *mut u8) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::Foundation::BOOL>,
{
    windows_targets::link!("infocardapi.dll" "system" fn Encrypt(hcrypto : *const INFORMATIONCARD_CRYPTO_HANDLE, foaep : super::super::Foundation:: BOOL, cbindata : u32, pindata : *const u8, pcboutdata : *mut u32, ppoutdata : *mut *mut u8) -> windows_core::HRESULT);
    Encrypt(hcrypto, foaep.param().abi(), pindata.len().try_into().unwrap(), core::mem::transmute(pindata.as_ptr()), pcboutdata, ppoutdata).ok()
}
#[inline]
pub unsafe fn FindCertsByIssuer<P0>(pcertchains: Option<*mut CERT_CHAIN>, pcbcertchains: *mut u32, pccertchains: *mut u32, pbencodedissuername: Option<&[u8]>, pwszpurpose: P0, dwkeyspec: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("wintrust.dll" "system" fn FindCertsByIssuer(pcertchains : *mut CERT_CHAIN, pcbcertchains : *mut u32, pccertchains : *mut u32, pbencodedissuername : *const u8, cbencodedissuername : u32, pwszpurpose : windows_core::PCWSTR, dwkeyspec : u32) -> windows_core::HRESULT);
    FindCertsByIssuer(core::mem::transmute(pcertchains.unwrap_or(std::ptr::null_mut())), pcbcertchains, pccertchains, core::mem::transmute(pbencodedissuername.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), pbencodedissuername.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), pwszpurpose.param().abi(), dwkeyspec).ok()
}
#[inline]
pub unsafe fn FreeToken(pallocmemory: *const GENERIC_XML_TOKEN) -> super::super::Foundation::BOOL {
    windows_targets::link!("infocardapi.dll" "system" fn FreeToken(pallocmemory : *const GENERIC_XML_TOKEN) -> super::super::Foundation:: BOOL);
    FreeToken(pallocmemory)
}
#[inline]
pub unsafe fn GenerateDerivedKey<P0>(hcrypto: *const INFORMATIONCARD_CRYPTO_HANDLE, plabel: &[u8], pnonce: &[u8], derivedkeylength: u32, offset: u32, algid: P0, pcbkey: *mut u32, ppkey: *mut *mut u8) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("infocardapi.dll" "system" fn GenerateDerivedKey(hcrypto : *const INFORMATIONCARD_CRYPTO_HANDLE, cblabel : u32, plabel : *const u8, cbnonce : u32, pnonce : *const u8, derivedkeylength : u32, offset : u32, algid : windows_core::PCWSTR, pcbkey : *mut u32, ppkey : *mut *mut u8) -> windows_core::HRESULT);
    GenerateDerivedKey(hcrypto, plabel.len().try_into().unwrap(), core::mem::transmute(plabel.as_ptr()), pnonce.len().try_into().unwrap(), core::mem::transmute(pnonce.as_ptr()), derivedkeylength, offset, algid.param().abi(), pcbkey, ppkey).ok()
}
#[inline]
pub unsafe fn GetBrowserToken(dwparamtype: u32, pparam: *const core::ffi::c_void, pcbtoken: Option<*mut u32>, pptoken: Option<*mut *mut u8>) -> windows_core::Result<()> {
    windows_targets::link!("infocardapi.dll" "system" fn GetBrowserToken(dwparamtype : u32, pparam : *const core::ffi::c_void, pcbtoken : *mut u32, pptoken : *mut *mut u8) -> windows_core::HRESULT);
    GetBrowserToken(dwparamtype, pparam, core::mem::transmute(pcbtoken.unwrap_or(std::ptr::null_mut())), core::mem::transmute(pptoken.unwrap_or(std::ptr::null_mut()))).ok()
}
#[inline]
pub unsafe fn GetCryptoTransform(hsymmetriccrypto: *const INFORMATIONCARD_CRYPTO_HANDLE, mode: u32, padding: PaddingMode, feedbacksize: u32, direction: Direction, piv: &[u8]) -> windows_core::Result<*mut INFORMATIONCARD_CRYPTO_HANDLE> {
    windows_targets::link!("infocardapi.dll" "system" fn GetCryptoTransform(hsymmetriccrypto : *const INFORMATIONCARD_CRYPTO_HANDLE, mode : u32, padding : PaddingMode, feedbacksize : u32, direction : Direction, cbiv : u32, piv : *const u8, pphtransform : *mut *mut INFORMATIONCARD_CRYPTO_HANDLE) -> windows_core::HRESULT);
    let mut result__ = std::mem::zeroed();
    GetCryptoTransform(hsymmetriccrypto, mode, padding, feedbacksize, direction, piv.len().try_into().unwrap(), core::mem::transmute(piv.as_ptr()), &mut result__).map(|| result__)
}
#[inline]
pub unsafe fn GetKeyedHash(hsymmetriccrypto: *const INFORMATIONCARD_CRYPTO_HANDLE) -> windows_core::Result<*mut INFORMATIONCARD_CRYPTO_HANDLE> {
    windows_targets::link!("infocardapi.dll" "system" fn GetKeyedHash(hsymmetriccrypto : *const INFORMATIONCARD_CRYPTO_HANDLE, pphhash : *mut *mut INFORMATIONCARD_CRYPTO_HANDLE) -> windows_core::HRESULT);
    let mut result__ = std::mem::zeroed();
    GetKeyedHash(hsymmetriccrypto, &mut result__).map(|| result__)
}
#[inline]
pub unsafe fn GetToken(ppolicychain: &[POLICY_ELEMENT], securitytoken: *mut *mut GENERIC_XML_TOKEN, phprooftokencrypto: *mut *mut INFORMATIONCARD_CRYPTO_HANDLE) -> windows_core::Result<()> {
    windows_targets::link!("infocardapi.dll" "system" fn GetToken(cpolicychain : u32, ppolicychain : *const POLICY_ELEMENT, securitytoken : *mut *mut GENERIC_XML_TOKEN, phprooftokencrypto : *mut *mut INFORMATIONCARD_CRYPTO_HANDLE) -> windows_core::HRESULT);
    GetToken(ppolicychain.len().try_into().unwrap(), core::mem::transmute(ppolicychain.as_ptr()), securitytoken, phprooftokencrypto).ok()
}
#[inline]
pub unsafe fn HashCore(hcrypto: *const INFORMATIONCARD_CRYPTO_HANDLE, pindata: &[u8]) -> windows_core::Result<()> {
    windows_targets::link!("infocardapi.dll" "system" fn HashCore(hcrypto : *const INFORMATIONCARD_CRYPTO_HANDLE, cbindata : u32, pindata : *const u8) -> windows_core::HRESULT);
    HashCore(hcrypto, pindata.len().try_into().unwrap(), core::mem::transmute(pindata.as_ptr())).ok()
}
#[inline]
pub unsafe fn HashFinal(hcrypto: *const INFORMATIONCARD_CRYPTO_HANDLE, pindata: &[u8], pcboutdata: *mut u32, ppoutdata: *mut *mut u8) -> windows_core::Result<()> {
    windows_targets::link!("infocardapi.dll" "system" fn HashFinal(hcrypto : *const INFORMATIONCARD_CRYPTO_HANDLE, cbindata : u32, pindata : *const u8, pcboutdata : *mut u32, ppoutdata : *mut *mut u8) -> windows_core::HRESULT);
    HashFinal(hcrypto, pindata.len().try_into().unwrap(), core::mem::transmute(pindata.as_ptr()), pcboutdata, ppoutdata).ok()
}
#[inline]
pub unsafe fn ImportInformationCard<P0>(filename: P0) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("infocardapi.dll" "system" fn ImportInformationCard(filename : windows_core::PCWSTR) -> windows_core::HRESULT);
    ImportInformationCard(filename.param().abi()).ok()
}
#[inline]
pub unsafe fn ManageCardSpace() -> windows_core::Result<()> {
    windows_targets::link!("infocardapi.dll" "system" fn ManageCardSpace() -> windows_core::HRESULT);
    ManageCardSpace().ok()
}
#[inline]
pub unsafe fn NCryptCloseProtectionDescriptor<P0>(hdescriptor: P0) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::NCRYPT_DESCRIPTOR_HANDLE>,
{
    windows_targets::link!("ncrypt.dll" "system" fn NCryptCloseProtectionDescriptor(hdescriptor : super:: NCRYPT_DESCRIPTOR_HANDLE) -> windows_core::HRESULT);
    NCryptCloseProtectionDescriptor(hdescriptor.param().abi()).ok()
}
#[inline]
pub unsafe fn NCryptCreateClaim<P0, P1>(hsubjectkey: P0, hauthoritykey: P1, dwclaimtype: u32, pparameterlist: Option<*const BCryptBufferDesc>, pbclaimblob: Option<&mut [u8]>, pcbresult: *mut u32, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<NCRYPT_KEY_HANDLE>,
    P1: windows_core::Param<NCRYPT_KEY_HANDLE>,
{
    windows_targets::link!("ncrypt.dll" "system" fn NCryptCreateClaim(hsubjectkey : NCRYPT_KEY_HANDLE, hauthoritykey : NCRYPT_KEY_HANDLE, dwclaimtype : u32, pparameterlist : *const BCryptBufferDesc, pbclaimblob : *mut u8, cbclaimblob : u32, pcbresult : *mut u32, dwflags : u32) -> windows_core::HRESULT);
    NCryptCreateClaim(hsubjectkey.param().abi(), hauthoritykey.param().abi(), dwclaimtype, core::mem::transmute(pparameterlist.unwrap_or(std::ptr::null())), core::mem::transmute(pbclaimblob.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), pbclaimblob.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), pcbresult, dwflags).ok()
}
#[inline]
pub unsafe fn NCryptCreatePersistedKey<P0, P1, P2>(hprovider: P0, phkey: *mut NCRYPT_KEY_HANDLE, pszalgid: P1, pszkeyname: P2, dwlegacykeyspec: CERT_KEY_SPEC, dwflags: NCRYPT_FLAGS) -> windows_core::Result<()>
where
    P0: windows_core::Param<NCRYPT_PROV_HANDLE>,
    P1: windows_core::Param<windows_core::PCWSTR>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("ncrypt.dll" "system" fn NCryptCreatePersistedKey(hprovider : NCRYPT_PROV_HANDLE, phkey : *mut NCRYPT_KEY_HANDLE, pszalgid : windows_core::PCWSTR, pszkeyname : windows_core::PCWSTR, dwlegacykeyspec : CERT_KEY_SPEC, dwflags : NCRYPT_FLAGS) -> windows_core::HRESULT);
    NCryptCreatePersistedKey(hprovider.param().abi(), phkey, pszalgid.param().abi(), pszkeyname.param().abi(), dwlegacykeyspec, dwflags).ok()
}
#[inline]
pub unsafe fn NCryptCreateProtectionDescriptor<P0>(pwszdescriptorstring: P0, dwflags: u32) -> windows_core::Result<super::NCRYPT_DESCRIPTOR_HANDLE>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("ncrypt.dll" "system" fn NCryptCreateProtectionDescriptor(pwszdescriptorstring : windows_core::PCWSTR, dwflags : u32, phdescriptor : *mut super:: NCRYPT_DESCRIPTOR_HANDLE) -> windows_core::HRESULT);
    let mut result__ = std::mem::zeroed();
    NCryptCreateProtectionDescriptor(pwszdescriptorstring.param().abi(), dwflags, &mut result__).map(|| result__)
}
#[inline]
pub unsafe fn NCryptDecrypt<P0>(hkey: P0, pbinput: Option<&[u8]>, ppaddinginfo: Option<*const core::ffi::c_void>, pboutput: Option<&mut [u8]>, pcbresult: *mut u32, dwflags: NCRYPT_FLAGS) -> windows_core::Result<()>
where
    P0: windows_core::Param<NCRYPT_KEY_HANDLE>,
{
    windows_targets::link!("ncrypt.dll" "system" fn NCryptDecrypt(hkey : NCRYPT_KEY_HANDLE, pbinput : *const u8, cbinput : u32, ppaddinginfo : *const core::ffi::c_void, pboutput : *mut u8, cboutput : u32, pcbresult : *mut u32, dwflags : NCRYPT_FLAGS) -> windows_core::HRESULT);
    NCryptDecrypt(hkey.param().abi(), core::mem::transmute(pbinput.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), pbinput.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(ppaddinginfo.unwrap_or(std::ptr::null())), core::mem::transmute(pboutput.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), pboutput.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), pcbresult, dwflags).ok()
}
#[inline]
pub unsafe fn NCryptDeleteKey<P0>(hkey: P0, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<NCRYPT_KEY_HANDLE>,
{
    windows_targets::link!("ncrypt.dll" "system" fn NCryptDeleteKey(hkey : NCRYPT_KEY_HANDLE, dwflags : u32) -> windows_core::HRESULT);
    NCryptDeleteKey(hkey.param().abi(), dwflags).ok()
}
#[inline]
pub unsafe fn NCryptDeriveKey<P0, P1>(hsharedsecret: P0, pwszkdf: P1, pparameterlist: Option<*const BCryptBufferDesc>, pbderivedkey: Option<&mut [u8]>, pcbresult: *mut u32, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<NCRYPT_SECRET_HANDLE>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("ncrypt.dll" "system" fn NCryptDeriveKey(hsharedsecret : NCRYPT_SECRET_HANDLE, pwszkdf : windows_core::PCWSTR, pparameterlist : *const BCryptBufferDesc, pbderivedkey : *mut u8, cbderivedkey : u32, pcbresult : *mut u32, dwflags : u32) -> windows_core::HRESULT);
    NCryptDeriveKey(hsharedsecret.param().abi(), pwszkdf.param().abi(), core::mem::transmute(pparameterlist.unwrap_or(std::ptr::null())), core::mem::transmute(pbderivedkey.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), pbderivedkey.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), pcbresult, dwflags).ok()
}
#[inline]
pub unsafe fn NCryptEncrypt<P0>(hkey: P0, pbinput: Option<&[u8]>, ppaddinginfo: Option<*const core::ffi::c_void>, pboutput: Option<&mut [u8]>, pcbresult: *mut u32, dwflags: NCRYPT_FLAGS) -> windows_core::Result<()>
where
    P0: windows_core::Param<NCRYPT_KEY_HANDLE>,
{
    windows_targets::link!("ncrypt.dll" "system" fn NCryptEncrypt(hkey : NCRYPT_KEY_HANDLE, pbinput : *const u8, cbinput : u32, ppaddinginfo : *const core::ffi::c_void, pboutput : *mut u8, cboutput : u32, pcbresult : *mut u32, dwflags : NCRYPT_FLAGS) -> windows_core::HRESULT);
    NCryptEncrypt(hkey.param().abi(), core::mem::transmute(pbinput.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), pbinput.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), core::mem::transmute(ppaddinginfo.unwrap_or(std::ptr::null())), core::mem::transmute(pboutput.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), pboutput.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), pcbresult, dwflags).ok()
}
#[inline]
pub unsafe fn NCryptEnumAlgorithms<P0>(hprovider: P0, dwalgoperations: NCRYPT_OPERATION, pdwalgcount: *mut u32, ppalglist: *mut *mut NCryptAlgorithmName, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<NCRYPT_PROV_HANDLE>,
{
    windows_targets::link!("ncrypt.dll" "system" fn NCryptEnumAlgorithms(hprovider : NCRYPT_PROV_HANDLE, dwalgoperations : NCRYPT_OPERATION, pdwalgcount : *mut u32, ppalglist : *mut *mut NCryptAlgorithmName, dwflags : u32) -> windows_core::HRESULT);
    NCryptEnumAlgorithms(hprovider.param().abi(), dwalgoperations, pdwalgcount, ppalglist, dwflags).ok()
}
#[inline]
pub unsafe fn NCryptEnumKeys<P0, P1>(hprovider: P0, pszscope: P1, ppkeyname: *mut *mut NCryptKeyName, ppenumstate: *mut *mut core::ffi::c_void, dwflags: NCRYPT_FLAGS) -> windows_core::Result<()>
where
    P0: windows_core::Param<NCRYPT_PROV_HANDLE>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("ncrypt.dll" "system" fn NCryptEnumKeys(hprovider : NCRYPT_PROV_HANDLE, pszscope : windows_core::PCWSTR, ppkeyname : *mut *mut NCryptKeyName, ppenumstate : *mut *mut core::ffi::c_void, dwflags : NCRYPT_FLAGS) -> windows_core::HRESULT);
    NCryptEnumKeys(hprovider.param().abi(), pszscope.param().abi(), ppkeyname, ppenumstate, dwflags).ok()
}
#[inline]
pub unsafe fn NCryptEnumStorageProviders(pdwprovidercount: *mut u32, ppproviderlist: *mut *mut NCryptProviderName, dwflags: u32) -> windows_core::Result<()> {
    windows_targets::link!("ncrypt.dll" "system" fn NCryptEnumStorageProviders(pdwprovidercount : *mut u32, ppproviderlist : *mut *mut NCryptProviderName, dwflags : u32) -> windows_core::HRESULT);
    NCryptEnumStorageProviders(pdwprovidercount, ppproviderlist, dwflags).ok()
}
#[inline]
pub unsafe fn NCryptExportKey<P0, P1, P2>(hkey: P0, hexportkey: P1, pszblobtype: P2, pparameterlist: Option<*const BCryptBufferDesc>, pboutput: Option<&mut [u8]>, pcbresult: *mut u32, dwflags: NCRYPT_FLAGS) -> windows_core::Result<()>
where
    P0: windows_core::Param<NCRYPT_KEY_HANDLE>,
    P1: windows_core::Param<NCRYPT_KEY_HANDLE>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("ncrypt.dll" "system" fn NCryptExportKey(hkey : NCRYPT_KEY_HANDLE, hexportkey : NCRYPT_KEY_HANDLE, pszblobtype : windows_core::PCWSTR, pparameterlist : *const BCryptBufferDesc, pboutput : *mut u8, cboutput : u32, pcbresult : *mut u32, dwflags : NCRYPT_FLAGS) -> windows_core::HRESULT);
    NCryptExportKey(hkey.param().abi(), hexportkey.param().abi(), pszblobtype.param().abi(), core::mem::transmute(pparameterlist.unwrap_or(std::ptr::null())), core::mem::transmute(pboutput.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), pboutput.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), pcbresult, dwflags).ok()
}
#[inline]
pub unsafe fn NCryptFinalizeKey<P0>(hkey: P0, dwflags: NCRYPT_FLAGS) -> windows_core::Result<()>
where
    P0: windows_core::Param<NCRYPT_KEY_HANDLE>,
{
    windows_targets::link!("ncrypt.dll" "system" fn NCryptFinalizeKey(hkey : NCRYPT_KEY_HANDLE, dwflags : NCRYPT_FLAGS) -> windows_core::HRESULT);
    NCryptFinalizeKey(hkey.param().abi(), dwflags).ok()
}
#[inline]
pub unsafe fn NCryptFreeBuffer(pvinput: *mut core::ffi::c_void) -> windows_core::Result<()> {
    windows_targets::link!("ncrypt.dll" "system" fn NCryptFreeBuffer(pvinput : *mut core::ffi::c_void) -> windows_core::HRESULT);
    NCryptFreeBuffer(pvinput).ok()
}
#[inline]
pub unsafe fn NCryptFreeObject<P0>(hobject: P0) -> windows_core::Result<()>
where
    P0: windows_core::Param<NCRYPT_HANDLE>,
{
    windows_targets::link!("ncrypt.dll" "system" fn NCryptFreeObject(hobject : NCRYPT_HANDLE) -> windows_core::HRESULT);
    NCryptFreeObject(hobject.param().abi()).ok()
}
#[inline]
pub unsafe fn NCryptGetProperty<P0, P1>(hobject: P0, pszproperty: P1, pboutput: Option<&mut [u8]>, pcbresult: *mut u32, dwflags: super::OBJECT_SECURITY_INFORMATION) -> windows_core::Result<()>
where
    P0: windows_core::Param<NCRYPT_HANDLE>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("ncrypt.dll" "system" fn NCryptGetProperty(hobject : NCRYPT_HANDLE, pszproperty : windows_core::PCWSTR, pboutput : *mut u8, cboutput : u32, pcbresult : *mut u32, dwflags : super:: OBJECT_SECURITY_INFORMATION) -> windows_core::HRESULT);
    NCryptGetProperty(hobject.param().abi(), pszproperty.param().abi(), core::mem::transmute(pboutput.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), pboutput.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), pcbresult, dwflags).ok()
}
#[inline]
pub unsafe fn NCryptGetProtectionDescriptorInfo<P0>(hdescriptor: P0, pmempara: Option<*const NCRYPT_ALLOC_PARA>, dwinfotype: u32, ppvinfo: *mut *mut core::ffi::c_void) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::NCRYPT_DESCRIPTOR_HANDLE>,
{
    windows_targets::link!("ncrypt.dll" "system" fn NCryptGetProtectionDescriptorInfo(hdescriptor : super:: NCRYPT_DESCRIPTOR_HANDLE, pmempara : *const NCRYPT_ALLOC_PARA, dwinfotype : u32, ppvinfo : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    NCryptGetProtectionDescriptorInfo(hdescriptor.param().abi(), core::mem::transmute(pmempara.unwrap_or(std::ptr::null())), dwinfotype, ppvinfo).ok()
}
#[inline]
pub unsafe fn NCryptImportKey<P0, P1, P2>(hprovider: P0, himportkey: P1, pszblobtype: P2, pparameterlist: Option<*const BCryptBufferDesc>, phkey: *mut NCRYPT_KEY_HANDLE, pbdata: &[u8], dwflags: NCRYPT_FLAGS) -> windows_core::Result<()>
where
    P0: windows_core::Param<NCRYPT_PROV_HANDLE>,
    P1: windows_core::Param<NCRYPT_KEY_HANDLE>,
    P2: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("ncrypt.dll" "system" fn NCryptImportKey(hprovider : NCRYPT_PROV_HANDLE, himportkey : NCRYPT_KEY_HANDLE, pszblobtype : windows_core::PCWSTR, pparameterlist : *const BCryptBufferDesc, phkey : *mut NCRYPT_KEY_HANDLE, pbdata : *const u8, cbdata : u32, dwflags : NCRYPT_FLAGS) -> windows_core::HRESULT);
    NCryptImportKey(hprovider.param().abi(), himportkey.param().abi(), pszblobtype.param().abi(), core::mem::transmute(pparameterlist.unwrap_or(std::ptr::null())), phkey, core::mem::transmute(pbdata.as_ptr()), pbdata.len().try_into().unwrap(), dwflags).ok()
}
#[inline]
pub unsafe fn NCryptIsAlgSupported<P0, P1>(hprovider: P0, pszalgid: P1, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<NCRYPT_PROV_HANDLE>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("ncrypt.dll" "system" fn NCryptIsAlgSupported(hprovider : NCRYPT_PROV_HANDLE, pszalgid : windows_core::PCWSTR, dwflags : u32) -> windows_core::HRESULT);
    NCryptIsAlgSupported(hprovider.param().abi(), pszalgid.param().abi(), dwflags).ok()
}
#[inline]
pub unsafe fn NCryptIsKeyHandle<P0>(hkey: P0) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<NCRYPT_KEY_HANDLE>,
{
    windows_targets::link!("ncrypt.dll" "system" fn NCryptIsKeyHandle(hkey : NCRYPT_KEY_HANDLE) -> super::super::Foundation:: BOOL);
    NCryptIsKeyHandle(hkey.param().abi())
}
#[inline]
pub unsafe fn NCryptKeyDerivation<P0>(hkey: P0, pparameterlist: Option<*const BCryptBufferDesc>, pbderivedkey: &mut [u8], pcbresult: *mut u32, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<NCRYPT_KEY_HANDLE>,
{
    windows_targets::link!("ncrypt.dll" "system" fn NCryptKeyDerivation(hkey : NCRYPT_KEY_HANDLE, pparameterlist : *const BCryptBufferDesc, pbderivedkey : *mut u8, cbderivedkey : u32, pcbresult : *mut u32, dwflags : u32) -> windows_core::HRESULT);
    NCryptKeyDerivation(hkey.param().abi(), core::mem::transmute(pparameterlist.unwrap_or(std::ptr::null())), core::mem::transmute(pbderivedkey.as_ptr()), pbderivedkey.len().try_into().unwrap(), pcbresult, dwflags).ok()
}
#[inline]
pub unsafe fn NCryptNotifyChangeKey<P0>(hprovider: P0, phevent: *mut super::super::Foundation::HANDLE, dwflags: NCRYPT_FLAGS) -> windows_core::Result<()>
where
    P0: windows_core::Param<NCRYPT_PROV_HANDLE>,
{
    windows_targets::link!("ncrypt.dll" "system" fn NCryptNotifyChangeKey(hprovider : NCRYPT_PROV_HANDLE, phevent : *mut super::super::Foundation:: HANDLE, dwflags : NCRYPT_FLAGS) -> windows_core::HRESULT);
    NCryptNotifyChangeKey(hprovider.param().abi(), phevent, dwflags).ok()
}
#[inline]
pub unsafe fn NCryptOpenKey<P0, P1>(hprovider: P0, phkey: *mut NCRYPT_KEY_HANDLE, pszkeyname: P1, dwlegacykeyspec: CERT_KEY_SPEC, dwflags: NCRYPT_FLAGS) -> windows_core::Result<()>
where
    P0: windows_core::Param<NCRYPT_PROV_HANDLE>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("ncrypt.dll" "system" fn NCryptOpenKey(hprovider : NCRYPT_PROV_HANDLE, phkey : *mut NCRYPT_KEY_HANDLE, pszkeyname : windows_core::PCWSTR, dwlegacykeyspec : CERT_KEY_SPEC, dwflags : NCRYPT_FLAGS) -> windows_core::HRESULT);
    NCryptOpenKey(hprovider.param().abi(), phkey, pszkeyname.param().abi(), dwlegacykeyspec, dwflags).ok()
}
#[inline]
pub unsafe fn NCryptOpenStorageProvider<P0>(phprovider: *mut NCRYPT_PROV_HANDLE, pszprovidername: P0, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("ncrypt.dll" "system" fn NCryptOpenStorageProvider(phprovider : *mut NCRYPT_PROV_HANDLE, pszprovidername : windows_core::PCWSTR, dwflags : u32) -> windows_core::HRESULT);
    NCryptOpenStorageProvider(phprovider, pszprovidername.param().abi(), dwflags).ok()
}
#[inline]
pub unsafe fn NCryptProtectSecret<P0, P1>(hdescriptor: P0, dwflags: u32, pbdata: &[u8], pmempara: Option<*const NCRYPT_ALLOC_PARA>, hwnd: P1, ppbprotectedblob: *mut *mut u8, pcbprotectedblob: *mut u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::NCRYPT_DESCRIPTOR_HANDLE>,
    P1: windows_core::Param<super::super::Foundation::HWND>,
{
    windows_targets::link!("ncrypt.dll" "system" fn NCryptProtectSecret(hdescriptor : super:: NCRYPT_DESCRIPTOR_HANDLE, dwflags : u32, pbdata : *const u8, cbdata : u32, pmempara : *const NCRYPT_ALLOC_PARA, hwnd : super::super::Foundation:: HWND, ppbprotectedblob : *mut *mut u8, pcbprotectedblob : *mut u32) -> windows_core::HRESULT);
    NCryptProtectSecret(hdescriptor.param().abi(), dwflags, core::mem::transmute(pbdata.as_ptr()), pbdata.len().try_into().unwrap(), core::mem::transmute(pmempara.unwrap_or(std::ptr::null())), hwnd.param().abi(), ppbprotectedblob, pcbprotectedblob).ok()
}
#[inline]
pub unsafe fn NCryptQueryProtectionDescriptorName<P0>(pwszname: P0, pwszdescriptorstring: windows_core::PWSTR, pcdescriptorstring: *mut usize, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("ncrypt.dll" "system" fn NCryptQueryProtectionDescriptorName(pwszname : windows_core::PCWSTR, pwszdescriptorstring : windows_core::PWSTR, pcdescriptorstring : *mut usize, dwflags : u32) -> windows_core::HRESULT);
    NCryptQueryProtectionDescriptorName(pwszname.param().abi(), core::mem::transmute(pwszdescriptorstring), pcdescriptorstring, dwflags).ok()
}
#[inline]
pub unsafe fn NCryptRegisterProtectionDescriptorName<P0, P1>(pwszname: P0, pwszdescriptorstring: P1, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("ncrypt.dll" "system" fn NCryptRegisterProtectionDescriptorName(pwszname : windows_core::PCWSTR, pwszdescriptorstring : windows_core::PCWSTR, dwflags : u32) -> windows_core::HRESULT);
    NCryptRegisterProtectionDescriptorName(pwszname.param().abi(), pwszdescriptorstring.param().abi(), dwflags).ok()
}
#[inline]
pub unsafe fn NCryptSecretAgreement<P0, P1>(hprivkey: P0, hpubkey: P1, phagreedsecret: *mut NCRYPT_SECRET_HANDLE, dwflags: NCRYPT_FLAGS) -> windows_core::Result<()>
where
    P0: windows_core::Param<NCRYPT_KEY_HANDLE>,
    P1: windows_core::Param<NCRYPT_KEY_HANDLE>,
{
    windows_targets::link!("ncrypt.dll" "system" fn NCryptSecretAgreement(hprivkey : NCRYPT_KEY_HANDLE, hpubkey : NCRYPT_KEY_HANDLE, phagreedsecret : *mut NCRYPT_SECRET_HANDLE, dwflags : NCRYPT_FLAGS) -> windows_core::HRESULT);
    NCryptSecretAgreement(hprivkey.param().abi(), hpubkey.param().abi(), phagreedsecret, dwflags).ok()
}
#[inline]
pub unsafe fn NCryptSetProperty<P0, P1>(hobject: P0, pszproperty: P1, pbinput: &[u8], dwflags: NCRYPT_FLAGS) -> windows_core::Result<()>
where
    P0: windows_core::Param<NCRYPT_HANDLE>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("ncrypt.dll" "system" fn NCryptSetProperty(hobject : NCRYPT_HANDLE, pszproperty : windows_core::PCWSTR, pbinput : *const u8, cbinput : u32, dwflags : NCRYPT_FLAGS) -> windows_core::HRESULT);
    NCryptSetProperty(hobject.param().abi(), pszproperty.param().abi(), core::mem::transmute(pbinput.as_ptr()), pbinput.len().try_into().unwrap(), dwflags).ok()
}
#[inline]
pub unsafe fn NCryptSignHash<P0>(hkey: P0, ppaddinginfo: Option<*const core::ffi::c_void>, pbhashvalue: &[u8], pbsignature: Option<&mut [u8]>, pcbresult: *mut u32, dwflags: NCRYPT_FLAGS) -> windows_core::Result<()>
where
    P0: windows_core::Param<NCRYPT_KEY_HANDLE>,
{
    windows_targets::link!("ncrypt.dll" "system" fn NCryptSignHash(hkey : NCRYPT_KEY_HANDLE, ppaddinginfo : *const core::ffi::c_void, pbhashvalue : *const u8, cbhashvalue : u32, pbsignature : *mut u8, cbsignature : u32, pcbresult : *mut u32, dwflags : NCRYPT_FLAGS) -> windows_core::HRESULT);
    NCryptSignHash(hkey.param().abi(), core::mem::transmute(ppaddinginfo.unwrap_or(std::ptr::null())), core::mem::transmute(pbhashvalue.as_ptr()), pbhashvalue.len().try_into().unwrap(), core::mem::transmute(pbsignature.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), pbsignature.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), pcbresult, dwflags).ok()
}
#[inline]
pub unsafe fn NCryptStreamClose<P0>(hstream: P0) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::NCRYPT_STREAM_HANDLE>,
{
    windows_targets::link!("ncrypt.dll" "system" fn NCryptStreamClose(hstream : super:: NCRYPT_STREAM_HANDLE) -> windows_core::HRESULT);
    NCryptStreamClose(hstream.param().abi()).ok()
}
#[inline]
pub unsafe fn NCryptStreamOpenToProtect<P0, P1>(hdescriptor: P0, dwflags: u32, hwnd: P1, pstreaminfo: *const NCRYPT_PROTECT_STREAM_INFO) -> windows_core::Result<super::NCRYPT_STREAM_HANDLE>
where
    P0: windows_core::Param<super::NCRYPT_DESCRIPTOR_HANDLE>,
    P1: windows_core::Param<super::super::Foundation::HWND>,
{
    windows_targets::link!("ncrypt.dll" "system" fn NCryptStreamOpenToProtect(hdescriptor : super:: NCRYPT_DESCRIPTOR_HANDLE, dwflags : u32, hwnd : super::super::Foundation:: HWND, pstreaminfo : *const NCRYPT_PROTECT_STREAM_INFO, phstream : *mut super:: NCRYPT_STREAM_HANDLE) -> windows_core::HRESULT);
    let mut result__ = std::mem::zeroed();
    NCryptStreamOpenToProtect(hdescriptor.param().abi(), dwflags, hwnd.param().abi(), pstreaminfo, &mut result__).map(|| result__)
}
#[inline]
pub unsafe fn NCryptStreamOpenToUnprotect<P0>(pstreaminfo: *const NCRYPT_PROTECT_STREAM_INFO, dwflags: u32, hwnd: P0) -> windows_core::Result<super::NCRYPT_STREAM_HANDLE>
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
{
    windows_targets::link!("ncrypt.dll" "system" fn NCryptStreamOpenToUnprotect(pstreaminfo : *const NCRYPT_PROTECT_STREAM_INFO, dwflags : u32, hwnd : super::super::Foundation:: HWND, phstream : *mut super:: NCRYPT_STREAM_HANDLE) -> windows_core::HRESULT);
    let mut result__ = std::mem::zeroed();
    NCryptStreamOpenToUnprotect(pstreaminfo, dwflags, hwnd.param().abi(), &mut result__).map(|| result__)
}
#[inline]
pub unsafe fn NCryptStreamOpenToUnprotectEx<P0>(pstreaminfo: *const NCRYPT_PROTECT_STREAM_INFO_EX, dwflags: u32, hwnd: P0) -> windows_core::Result<super::NCRYPT_STREAM_HANDLE>
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
{
    windows_targets::link!("ncrypt.dll" "system" fn NCryptStreamOpenToUnprotectEx(pstreaminfo : *const NCRYPT_PROTECT_STREAM_INFO_EX, dwflags : u32, hwnd : super::super::Foundation:: HWND, phstream : *mut super:: NCRYPT_STREAM_HANDLE) -> windows_core::HRESULT);
    let mut result__ = std::mem::zeroed();
    NCryptStreamOpenToUnprotectEx(pstreaminfo, dwflags, hwnd.param().abi(), &mut result__).map(|| result__)
}
#[inline]
pub unsafe fn NCryptStreamUpdate<P0, P1>(hstream: P0, pbdata: &[u8], ffinal: P1) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::NCRYPT_STREAM_HANDLE>,
    P1: windows_core::Param<super::super::Foundation::BOOL>,
{
    windows_targets::link!("ncrypt.dll" "system" fn NCryptStreamUpdate(hstream : super:: NCRYPT_STREAM_HANDLE, pbdata : *const u8, cbdata : usize, ffinal : super::super::Foundation:: BOOL) -> windows_core::HRESULT);
    NCryptStreamUpdate(hstream.param().abi(), core::mem::transmute(pbdata.as_ptr()), pbdata.len().try_into().unwrap(), ffinal.param().abi()).ok()
}
#[inline]
pub unsafe fn NCryptTranslateHandle(phprovider: Option<*mut NCRYPT_PROV_HANDLE>, phkey: *mut NCRYPT_KEY_HANDLE, hlegacyprov: usize, hlegacykey: usize, dwlegacykeyspec: CERT_KEY_SPEC, dwflags: u32) -> windows_core::Result<()> {
    windows_targets::link!("ncrypt.dll" "system" fn NCryptTranslateHandle(phprovider : *mut NCRYPT_PROV_HANDLE, phkey : *mut NCRYPT_KEY_HANDLE, hlegacyprov : usize, hlegacykey : usize, dwlegacykeyspec : CERT_KEY_SPEC, dwflags : u32) -> windows_core::HRESULT);
    NCryptTranslateHandle(core::mem::transmute(phprovider.unwrap_or(std::ptr::null_mut())), phkey, hlegacyprov, hlegacykey, dwlegacykeyspec, dwflags).ok()
}
#[inline]
pub unsafe fn NCryptUnprotectSecret<P0>(phdescriptor: Option<*mut super::NCRYPT_DESCRIPTOR_HANDLE>, dwflags: NCRYPT_FLAGS, pbprotectedblob: &[u8], pmempara: Option<*const NCRYPT_ALLOC_PARA>, hwnd: P0, ppbdata: *mut *mut u8, pcbdata: *mut u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<super::super::Foundation::HWND>,
{
    windows_targets::link!("ncrypt.dll" "system" fn NCryptUnprotectSecret(phdescriptor : *mut super:: NCRYPT_DESCRIPTOR_HANDLE, dwflags : NCRYPT_FLAGS, pbprotectedblob : *const u8, cbprotectedblob : u32, pmempara : *const NCRYPT_ALLOC_PARA, hwnd : super::super::Foundation:: HWND, ppbdata : *mut *mut u8, pcbdata : *mut u32) -> windows_core::HRESULT);
    NCryptUnprotectSecret(core::mem::transmute(phdescriptor.unwrap_or(std::ptr::null_mut())), dwflags, core::mem::transmute(pbprotectedblob.as_ptr()), pbprotectedblob.len().try_into().unwrap(), core::mem::transmute(pmempara.unwrap_or(std::ptr::null())), hwnd.param().abi(), ppbdata, pcbdata).ok()
}
#[inline]
pub unsafe fn NCryptVerifyClaim<P0, P1>(hsubjectkey: P0, hauthoritykey: P1, dwclaimtype: u32, pparameterlist: Option<*const BCryptBufferDesc>, pbclaimblob: &[u8], poutput: *mut BCryptBufferDesc, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<NCRYPT_KEY_HANDLE>,
    P1: windows_core::Param<NCRYPT_KEY_HANDLE>,
{
    windows_targets::link!("ncrypt.dll" "system" fn NCryptVerifyClaim(hsubjectkey : NCRYPT_KEY_HANDLE, hauthoritykey : NCRYPT_KEY_HANDLE, dwclaimtype : u32, pparameterlist : *const BCryptBufferDesc, pbclaimblob : *const u8, cbclaimblob : u32, poutput : *mut BCryptBufferDesc, dwflags : u32) -> windows_core::HRESULT);
    NCryptVerifyClaim(hsubjectkey.param().abi(), hauthoritykey.param().abi(), dwclaimtype, core::mem::transmute(pparameterlist.unwrap_or(std::ptr::null())), core::mem::transmute(pbclaimblob.as_ptr()), pbclaimblob.len().try_into().unwrap(), poutput, dwflags).ok()
}
#[inline]
pub unsafe fn NCryptVerifySignature<P0>(hkey: P0, ppaddinginfo: Option<*const core::ffi::c_void>, pbhashvalue: &[u8], pbsignature: &[u8], dwflags: NCRYPT_FLAGS) -> windows_core::Result<()>
where
    P0: windows_core::Param<NCRYPT_KEY_HANDLE>,
{
    windows_targets::link!("ncrypt.dll" "system" fn NCryptVerifySignature(hkey : NCRYPT_KEY_HANDLE, ppaddinginfo : *const core::ffi::c_void, pbhashvalue : *const u8, cbhashvalue : u32, pbsignature : *const u8, cbsignature : u32, dwflags : NCRYPT_FLAGS) -> windows_core::HRESULT);
    NCryptVerifySignature(hkey.param().abi(), core::mem::transmute(ppaddinginfo.unwrap_or(std::ptr::null())), core::mem::transmute(pbhashvalue.as_ptr()), pbhashvalue.len().try_into().unwrap(), core::mem::transmute(pbsignature.as_ptr()), pbsignature.len().try_into().unwrap(), dwflags).ok()
}
#[inline]
pub unsafe fn PFXExportCertStore<P0, P1>(hstore: P0, ppfx: *mut CRYPT_INTEGER_BLOB, szpassword: P1, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<HCERTSTORE>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn PFXExportCertStore(hstore : HCERTSTORE, ppfx : *mut CRYPT_INTEGER_BLOB, szpassword : windows_core::PCWSTR, dwflags : u32) -> super::super::Foundation:: BOOL);
    PFXExportCertStore(hstore.param().abi(), ppfx, szpassword.param().abi(), dwflags).ok()
}
#[inline]
pub unsafe fn PFXExportCertStoreEx<P0, P1>(hstore: P0, ppfx: *mut CRYPT_INTEGER_BLOB, szpassword: P1, pvpara: *const core::ffi::c_void, dwflags: u32) -> windows_core::Result<()>
where
    P0: windows_core::Param<HCERTSTORE>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn PFXExportCertStoreEx(hstore : HCERTSTORE, ppfx : *mut CRYPT_INTEGER_BLOB, szpassword : windows_core::PCWSTR, pvpara : *const core::ffi::c_void, dwflags : u32) -> super::super::Foundation:: BOOL);
    PFXExportCertStoreEx(hstore.param().abi(), ppfx, szpassword.param().abi(), pvpara, dwflags).ok()
}
#[inline]
pub unsafe fn PFXImportCertStore<P0>(ppfx: *const CRYPT_INTEGER_BLOB, szpassword: P0, dwflags: CRYPT_KEY_FLAGS) -> windows_core::Result<HCERTSTORE>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn PFXImportCertStore(ppfx : *const CRYPT_INTEGER_BLOB, szpassword : windows_core::PCWSTR, dwflags : CRYPT_KEY_FLAGS) -> HCERTSTORE);
    let result__ = PFXImportCertStore(ppfx, szpassword.param().abi(), dwflags);
    (!result__.is_invalid()).then(|| result__).ok_or_else(windows_core::Error::from_win32)
}
#[inline]
pub unsafe fn PFXIsPFXBlob(ppfx: *const CRYPT_INTEGER_BLOB) -> super::super::Foundation::BOOL {
    windows_targets::link!("crypt32.dll" "system" fn PFXIsPFXBlob(ppfx : *const CRYPT_INTEGER_BLOB) -> super::super::Foundation:: BOOL);
    PFXIsPFXBlob(ppfx)
}
#[inline]
pub unsafe fn PFXVerifyPassword<P0>(ppfx: *const CRYPT_INTEGER_BLOB, szpassword: P0, dwflags: u32) -> super::super::Foundation::BOOL
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("crypt32.dll" "system" fn PFXVerifyPassword(ppfx : *const CRYPT_INTEGER_BLOB, szpassword : windows_core::PCWSTR, dwflags : u32) -> super::super::Foundation:: BOOL);
    PFXVerifyPassword(ppfx, szpassword.param().abi(), dwflags)
}
#[inline]
pub unsafe fn ProcessPrng(pbdata: &mut [u8]) -> super::super::Foundation::BOOL {
    windows_targets::link!("bcryptprimitives.dll" "system" fn ProcessPrng(pbdata : *mut u8, cbdata : usize) -> super::super::Foundation:: BOOL);
    ProcessPrng(core::mem::transmute(pbdata.as_ptr()), pbdata.len().try_into().unwrap())
}
#[inline]
pub unsafe fn SignError() -> windows_core::Result<()> {
    windows_targets::link!("mssign32.dll" "system" fn SignError() -> windows_core::HRESULT);
    SignError().ok()
}
#[inline]
pub unsafe fn SignHash<P0>(hcrypto: *const INFORMATIONCARD_CRYPTO_HANDLE, phash: &[u8], hashalgoid: P0, pcbsig: *mut u32, ppsig: *mut *mut u8) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("infocardapi.dll" "system" fn SignHash(hcrypto : *const INFORMATIONCARD_CRYPTO_HANDLE, cbhash : u32, phash : *const u8, hashalgoid : windows_core::PCWSTR, pcbsig : *mut u32, ppsig : *mut *mut u8) -> windows_core::HRESULT);
    SignHash(hcrypto, phash.len().try_into().unwrap(), core::mem::transmute(phash.as_ptr()), hashalgoid.param().abi(), pcbsig, ppsig).ok()
}
#[inline]
pub unsafe fn SignerFreeSignerContext(psignercontext: *const SIGNER_CONTEXT) -> windows_core::Result<()> {
    windows_targets::link!("mssign32.dll" "system" fn SignerFreeSignerContext(psignercontext : *const SIGNER_CONTEXT) -> windows_core::HRESULT);
    SignerFreeSignerContext(psignercontext).ok()
}
#[inline]
pub unsafe fn SignerSign<P0>(psubjectinfo: *const SIGNER_SUBJECT_INFO, psignercert: *const SIGNER_CERT, psignatureinfo: *const SIGNER_SIGNATURE_INFO, pproviderinfo: Option<*const SIGNER_PROVIDER_INFO>, pwszhttptimestamp: P0, psrequest: Option<*const CRYPT_ATTRIBUTES>, psipdata: Option<*const core::ffi::c_void>) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("mssign32.dll" "system" fn SignerSign(psubjectinfo : *const SIGNER_SUBJECT_INFO, psignercert : *const SIGNER_CERT, psignatureinfo : *const SIGNER_SIGNATURE_INFO, pproviderinfo : *const SIGNER_PROVIDER_INFO, pwszhttptimestamp : windows_core::PCWSTR, psrequest : *const CRYPT_ATTRIBUTES, psipdata : *const core::ffi::c_void) -> windows_core::HRESULT);
    SignerSign(psubjectinfo, psignercert, psignatureinfo, core::mem::transmute(pproviderinfo.unwrap_or(std::ptr::null())), pwszhttptimestamp.param().abi(), core::mem::transmute(psrequest.unwrap_or(std::ptr::null())), core::mem::transmute(psipdata.unwrap_or(std::ptr::null()))).ok()
}
#[inline]
pub unsafe fn SignerSignEx<P0>(dwflags: SIGNER_SIGN_FLAGS, psubjectinfo: *const SIGNER_SUBJECT_INFO, psignercert: *const SIGNER_CERT, psignatureinfo: *const SIGNER_SIGNATURE_INFO, pproviderinfo: Option<*const SIGNER_PROVIDER_INFO>, pwszhttptimestamp: P0, psrequest: Option<*const CRYPT_ATTRIBUTES>, psipdata: Option<*const core::ffi::c_void>) -> windows_core::Result<*mut SIGNER_CONTEXT>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("mssign32.dll" "system" fn SignerSignEx(dwflags : SIGNER_SIGN_FLAGS, psubjectinfo : *const SIGNER_SUBJECT_INFO, psignercert : *const SIGNER_CERT, psignatureinfo : *const SIGNER_SIGNATURE_INFO, pproviderinfo : *const SIGNER_PROVIDER_INFO, pwszhttptimestamp : windows_core::PCWSTR, psrequest : *const CRYPT_ATTRIBUTES, psipdata : *const core::ffi::c_void, ppsignercontext : *mut *mut SIGNER_CONTEXT) -> windows_core::HRESULT);
    let mut result__ = std::mem::zeroed();
    SignerSignEx(dwflags, psubjectinfo, psignercert, psignatureinfo, core::mem::transmute(pproviderinfo.unwrap_or(std::ptr::null())), pwszhttptimestamp.param().abi(), core::mem::transmute(psrequest.unwrap_or(std::ptr::null())), core::mem::transmute(psipdata.unwrap_or(std::ptr::null())), &mut result__).map(|| result__)
}
#[inline]
pub unsafe fn SignerSignEx2<P0, P1>(dwflags: SIGNER_SIGN_FLAGS, psubjectinfo: *const SIGNER_SUBJECT_INFO, psignercert: *const SIGNER_CERT, psignatureinfo: *const SIGNER_SIGNATURE_INFO, pproviderinfo: Option<*const SIGNER_PROVIDER_INFO>, dwtimestampflags: SIGNER_TIMESTAMP_FLAGS, psztimestampalgorithmoid: P0, pwszhttptimestamp: P1, psrequest: Option<*const CRYPT_ATTRIBUTES>, psipdata: Option<*const core::ffi::c_void>, ppsignercontext: *mut *mut SIGNER_CONTEXT, pcryptopolicy: Option<*const CERT_STRONG_SIGN_PARA>, preserved: Option<*const core::ffi::c_void>) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("mssign32.dll" "system" fn SignerSignEx2(dwflags : SIGNER_SIGN_FLAGS, psubjectinfo : *const SIGNER_SUBJECT_INFO, psignercert : *const SIGNER_CERT, psignatureinfo : *const SIGNER_SIGNATURE_INFO, pproviderinfo : *const SIGNER_PROVIDER_INFO, dwtimestampflags : SIGNER_TIMESTAMP_FLAGS, psztimestampalgorithmoid : windows_core::PCSTR, pwszhttptimestamp : windows_core::PCWSTR, psrequest : *const CRYPT_ATTRIBUTES, psipdata : *const core::ffi::c_void, ppsignercontext : *mut *mut SIGNER_CONTEXT, pcryptopolicy : *const CERT_STRONG_SIGN_PARA, preserved : *const core::ffi::c_void) -> windows_core::HRESULT);
    SignerSignEx2(dwflags, psubjectinfo, psignercert, psignatureinfo, core::mem::transmute(pproviderinfo.unwrap_or(std::ptr::null())), dwtimestampflags, psztimestampalgorithmoid.param().abi(), pwszhttptimestamp.param().abi(), core::mem::transmute(psrequest.unwrap_or(std::ptr::null())), core::mem::transmute(psipdata.unwrap_or(std::ptr::null())), ppsignercontext, core::mem::transmute(pcryptopolicy.unwrap_or(std::ptr::null())), core::mem::transmute(preserved.unwrap_or(std::ptr::null()))).ok()
}
#[inline]
pub unsafe fn SignerSignEx3<P0, P1>(dwflags: SIGNER_SIGN_FLAGS, psubjectinfo: *const SIGNER_SUBJECT_INFO, psignercert: *const SIGNER_CERT, psignatureinfo: *const SIGNER_SIGNATURE_INFO, pproviderinfo: Option<*const SIGNER_PROVIDER_INFO>, dwtimestampflags: SIGNER_TIMESTAMP_FLAGS, psztimestampalgorithmoid: P0, pwszhttptimestamp: P1, psrequest: Option<*const CRYPT_ATTRIBUTES>, psipdata: Option<*const core::ffi::c_void>, ppsignercontext: *mut *mut SIGNER_CONTEXT, pcryptopolicy: Option<*const CERT_STRONG_SIGN_PARA>, pdigestsigninfo: Option<*const SIGNER_DIGEST_SIGN_INFO>, preserved: Option<*const core::ffi::c_void>) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("mssign32.dll" "system" fn SignerSignEx3(dwflags : SIGNER_SIGN_FLAGS, psubjectinfo : *const SIGNER_SUBJECT_INFO, psignercert : *const SIGNER_CERT, psignatureinfo : *const SIGNER_SIGNATURE_INFO, pproviderinfo : *const SIGNER_PROVIDER_INFO, dwtimestampflags : SIGNER_TIMESTAMP_FLAGS, psztimestampalgorithmoid : windows_core::PCSTR, pwszhttptimestamp : windows_core::PCWSTR, psrequest : *const CRYPT_ATTRIBUTES, psipdata : *const core::ffi::c_void, ppsignercontext : *mut *mut SIGNER_CONTEXT, pcryptopolicy : *const CERT_STRONG_SIGN_PARA, pdigestsigninfo : *const SIGNER_DIGEST_SIGN_INFO, preserved : *const core::ffi::c_void) -> windows_core::HRESULT);
    SignerSignEx3(
        dwflags,
        psubjectinfo,
        psignercert,
        psignatureinfo,
        core::mem::transmute(pproviderinfo.unwrap_or(std::ptr::null())),
        dwtimestampflags,
        psztimestampalgorithmoid.param().abi(),
        pwszhttptimestamp.param().abi(),
        core::mem::transmute(psrequest.unwrap_or(std::ptr::null())),
        core::mem::transmute(psipdata.unwrap_or(std::ptr::null())),
        ppsignercontext,
        core::mem::transmute(pcryptopolicy.unwrap_or(std::ptr::null())),
        core::mem::transmute(pdigestsigninfo.unwrap_or(std::ptr::null())),
        core::mem::transmute(preserved.unwrap_or(std::ptr::null())),
    )
    .ok()
}
#[inline]
pub unsafe fn SignerTimeStamp<P0>(psubjectinfo: *const SIGNER_SUBJECT_INFO, pwszhttptimestamp: P0, psrequest: Option<*const CRYPT_ATTRIBUTES>, psipdata: Option<*const core::ffi::c_void>) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("mssign32.dll" "system" fn SignerTimeStamp(psubjectinfo : *const SIGNER_SUBJECT_INFO, pwszhttptimestamp : windows_core::PCWSTR, psrequest : *const CRYPT_ATTRIBUTES, psipdata : *const core::ffi::c_void) -> windows_core::HRESULT);
    SignerTimeStamp(psubjectinfo, pwszhttptimestamp.param().abi(), core::mem::transmute(psrequest.unwrap_or(std::ptr::null())), core::mem::transmute(psipdata.unwrap_or(std::ptr::null()))).ok()
}
#[inline]
pub unsafe fn SignerTimeStampEx<P0>(dwflags: u32, psubjectinfo: *const SIGNER_SUBJECT_INFO, pwszhttptimestamp: P0, psrequest: *const CRYPT_ATTRIBUTES, psipdata: *const core::ffi::c_void) -> windows_core::Result<*mut SIGNER_CONTEXT>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("mssign32.dll" "system" fn SignerTimeStampEx(dwflags : u32, psubjectinfo : *const SIGNER_SUBJECT_INFO, pwszhttptimestamp : windows_core::PCWSTR, psrequest : *const CRYPT_ATTRIBUTES, psipdata : *const core::ffi::c_void, ppsignercontext : *mut *mut SIGNER_CONTEXT) -> windows_core::HRESULT);
    let mut result__ = std::mem::zeroed();
    SignerTimeStampEx(dwflags, psubjectinfo, pwszhttptimestamp.param().abi(), psrequest, psipdata, &mut result__).map(|| result__)
}
#[inline]
pub unsafe fn SignerTimeStampEx2<P0>(dwflags: SIGNER_TIMESTAMP_FLAGS, psubjectinfo: *const SIGNER_SUBJECT_INFO, pwszhttptimestamp: P0, dwalgid: ALG_ID, psrequest: *const CRYPT_ATTRIBUTES, psipdata: *const core::ffi::c_void) -> windows_core::Result<*mut SIGNER_CONTEXT>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("mssign32.dll" "system" fn SignerTimeStampEx2(dwflags : SIGNER_TIMESTAMP_FLAGS, psubjectinfo : *const SIGNER_SUBJECT_INFO, pwszhttptimestamp : windows_core::PCWSTR, dwalgid : ALG_ID, psrequest : *const CRYPT_ATTRIBUTES, psipdata : *const core::ffi::c_void, ppsignercontext : *mut *mut SIGNER_CONTEXT) -> windows_core::HRESULT);
    let mut result__ = std::mem::zeroed();
    SignerTimeStampEx2(dwflags, psubjectinfo, pwszhttptimestamp.param().abi(), dwalgid, psrequest, psipdata, &mut result__).map(|| result__)
}
#[inline]
pub unsafe fn SignerTimeStampEx3<P0, P1>(dwflags: SIGNER_TIMESTAMP_FLAGS, dwindex: u32, psubjectinfo: *const SIGNER_SUBJECT_INFO, pwszhttptimestamp: P0, pszalgorithmoid: P1, psrequest: Option<*const CRYPT_ATTRIBUTES>, psipdata: Option<*const core::ffi::c_void>, ppsignercontext: *mut *mut SIGNER_CONTEXT, pcryptopolicy: Option<*const CERT_STRONG_SIGN_PARA>, preserved: Option<*const core::ffi::c_void>) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
    P1: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("mssign32.dll" "system" fn SignerTimeStampEx3(dwflags : SIGNER_TIMESTAMP_FLAGS, dwindex : u32, psubjectinfo : *const SIGNER_SUBJECT_INFO, pwszhttptimestamp : windows_core::PCWSTR, pszalgorithmoid : windows_core::PCWSTR, psrequest : *const CRYPT_ATTRIBUTES, psipdata : *const core::ffi::c_void, ppsignercontext : *mut *mut SIGNER_CONTEXT, pcryptopolicy : *const CERT_STRONG_SIGN_PARA, preserved : *const core::ffi::c_void) -> windows_core::HRESULT);
    SignerTimeStampEx3(dwflags, dwindex, psubjectinfo, pwszhttptimestamp.param().abi(), pszalgorithmoid.param().abi(), core::mem::transmute(psrequest.unwrap_or(std::ptr::null())), core::mem::transmute(psipdata.unwrap_or(std::ptr::null())), ppsignercontext, core::mem::transmute(pcryptopolicy.unwrap_or(std::ptr::null())), core::mem::transmute(preserved.unwrap_or(std::ptr::null()))).ok()
}
#[inline]
pub unsafe fn SystemPrng(pbrandomdata: &mut [u8]) -> super::super::Foundation::BOOL {
    windows_targets::link!("bcryptprimitives.dll" "system" fn SystemPrng(pbrandomdata : *mut u8, cbrandomdata : usize) -> super::super::Foundation:: BOOL);
    SystemPrng(core::mem::transmute(pbrandomdata.as_ptr()), pbrandomdata.len().try_into().unwrap())
}
#[inline]
pub unsafe fn TransformBlock(hcrypto: *const INFORMATIONCARD_CRYPTO_HANDLE, pindata: &[u8], pcboutdata: *mut u32, ppoutdata: *mut *mut u8) -> windows_core::Result<()> {
    windows_targets::link!("infocardapi.dll" "system" fn TransformBlock(hcrypto : *const INFORMATIONCARD_CRYPTO_HANDLE, cbindata : u32, pindata : *const u8, pcboutdata : *mut u32, ppoutdata : *mut *mut u8) -> windows_core::HRESULT);
    TransformBlock(hcrypto, pindata.len().try_into().unwrap(), core::mem::transmute(pindata.as_ptr()), pcboutdata, ppoutdata).ok()
}
#[inline]
pub unsafe fn TransformFinalBlock(hcrypto: *const INFORMATIONCARD_CRYPTO_HANDLE, pindata: &[u8], pcboutdata: *mut u32, ppoutdata: *mut *mut u8) -> windows_core::Result<()> {
    windows_targets::link!("infocardapi.dll" "system" fn TransformFinalBlock(hcrypto : *const INFORMATIONCARD_CRYPTO_HANDLE, cbindata : u32, pindata : *const u8, pcboutdata : *mut u32, ppoutdata : *mut *mut u8) -> windows_core::HRESULT);
    TransformFinalBlock(hcrypto, pindata.len().try_into().unwrap(), core::mem::transmute(pindata.as_ptr()), pcboutdata, ppoutdata).ok()
}
#[inline]
pub unsafe fn VerifyHash<P0>(hcrypto: *const INFORMATIONCARD_CRYPTO_HANDLE, phash: &[u8], hashalgoid: P0, psig: &[u8]) -> windows_core::Result<super::super::Foundation::BOOL>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_targets::link!("infocardapi.dll" "system" fn VerifyHash(hcrypto : *const INFORMATIONCARD_CRYPTO_HANDLE, cbhash : u32, phash : *const u8, hashalgoid : windows_core::PCWSTR, cbsig : u32, psig : *const u8, pfverified : *mut super::super::Foundation:: BOOL) -> windows_core::HRESULT);
    let mut result__ = std::mem::zeroed();
    VerifyHash(hcrypto, phash.len().try_into().unwrap(), core::mem::transmute(phash.as_ptr()), hashalgoid.param().abi(), psig.len().try_into().unwrap(), core::mem::transmute(psig.as_ptr()), &mut result__).map(|| result__)
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(ICertSrvSetup, ICertSrvSetup_Vtbl, 0xb760a1bb_4784_44c0_8f12_555f0780ff25);
#[cfg(feature = "Win32_System_Com")]
impl std::ops::Deref for ICertSrvSetup {
    type Target = super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(ICertSrvSetup, windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl ICertSrvSetup {
    pub unsafe fn CAErrorId(&self) -> windows_core::Result<i32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).CAErrorId)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn CAErrorString(&self) -> windows_core::Result<windows_core::BSTR> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).CAErrorString)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn InitializeDefaults<P0, P1>(&self, bserver: P0, bclient: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::VARIANT_BOOL>,
        P1: windows_core::Param<super::super::Foundation::VARIANT_BOOL>,
    {
        (windows_core::Interface::vtable(self).InitializeDefaults)(windows_core::Interface::as_raw(self), bserver.param().abi(), bclient.param().abi()).ok()
    }
    pub unsafe fn GetCASetupProperty(&self, propertyid: CASetupProperty) -> windows_core::Result<windows_core::VARIANT> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetCASetupProperty)(windows_core::Interface::as_raw(self), propertyid, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetCASetupProperty(&self, propertyid: CASetupProperty, ppropertyvalue: *const windows_core::VARIANT) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetCASetupProperty)(windows_core::Interface::as_raw(self), propertyid, core::mem::transmute(ppropertyvalue)).ok()
    }
    pub unsafe fn IsPropertyEditable(&self, propertyid: CASetupProperty) -> windows_core::Result<super::super::Foundation::VARIANT_BOOL> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).IsPropertyEditable)(windows_core::Interface::as_raw(self), propertyid, &mut result__).map(|| result__)
    }
    pub unsafe fn GetSupportedCATypes(&self) -> windows_core::Result<windows_core::VARIANT> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetSupportedCATypes)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetProviderNameList(&self) -> windows_core::Result<windows_core::VARIANT> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetProviderNameList)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetKeyLengthList<P0>(&self, bstrprovidername: P0) -> windows_core::Result<windows_core::VARIANT>
    where
        P0: windows_core::Param<windows_core::BSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetKeyLengthList)(windows_core::Interface::as_raw(self), bstrprovidername.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetHashAlgorithmList<P0>(&self, bstrprovidername: P0) -> windows_core::Result<windows_core::VARIANT>
    where
        P0: windows_core::Param<windows_core::BSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetHashAlgorithmList)(windows_core::Interface::as_raw(self), bstrprovidername.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetPrivateKeyContainerList<P0>(&self, bstrprovidername: P0) -> windows_core::Result<windows_core::VARIANT>
    where
        P0: windows_core::Param<windows_core::BSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetPrivateKeyContainerList)(windows_core::Interface::as_raw(self), bstrprovidername.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetExistingCACertificates(&self) -> windows_core::Result<ICertSrvSetupKeyInformationCollection> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetExistingCACertificates)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CAImportPFX<P0, P1, P2>(&self, bstrfilename: P0, bstrpasswd: P1, boverwriteexistingkey: P2) -> windows_core::Result<ICertSrvSetupKeyInformation>
    where
        P0: windows_core::Param<windows_core::BSTR>,
        P1: windows_core::Param<windows_core::BSTR>,
        P2: windows_core::Param<super::super::Foundation::VARIANT_BOOL>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).CAImportPFX)(windows_core::Interface::as_raw(self), bstrfilename.param().abi(), bstrpasswd.param().abi(), boverwriteexistingkey.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetCADistinguishedName<P0, P1, P2, P3>(&self, bstrcadn: P0, bignoreunicode: P1, boverwriteexistingkey: P2, boverwriteexistingcainds: P3) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::BSTR>,
        P1: windows_core::Param<super::super::Foundation::VARIANT_BOOL>,
        P2: windows_core::Param<super::super::Foundation::VARIANT_BOOL>,
        P3: windows_core::Param<super::super::Foundation::VARIANT_BOOL>,
    {
        (windows_core::Interface::vtable(self).SetCADistinguishedName)(windows_core::Interface::as_raw(self), bstrcadn.param().abi(), bignoreunicode.param().abi(), boverwriteexistingkey.param().abi(), boverwriteexistingcainds.param().abi()).ok()
    }
    pub unsafe fn SetDatabaseInformation<P0, P1, P2, P3>(&self, bstrdbdirectory: P0, bstrlogdirectory: P1, bstrsharedfolder: P2, bforceoverwrite: P3) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::BSTR>,
        P1: windows_core::Param<windows_core::BSTR>,
        P2: windows_core::Param<windows_core::BSTR>,
        P3: windows_core::Param<super::super::Foundation::VARIANT_BOOL>,
    {
        (windows_core::Interface::vtable(self).SetDatabaseInformation)(windows_core::Interface::as_raw(self), bstrdbdirectory.param().abi(), bstrlogdirectory.param().abi(), bstrsharedfolder.param().abi(), bforceoverwrite.param().abi()).ok()
    }
    pub unsafe fn SetParentCAInformation<P0>(&self, bstrcaconfiguration: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::BSTR>,
    {
        (windows_core::Interface::vtable(self).SetParentCAInformation)(windows_core::Interface::as_raw(self), bstrcaconfiguration.param().abi()).ok()
    }
    pub unsafe fn SetWebCAInformation<P0>(&self, bstrcaconfiguration: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::BSTR>,
    {
        (windows_core::Interface::vtable(self).SetWebCAInformation)(windows_core::Interface::as_raw(self), bstrcaconfiguration.param().abi()).ok()
    }
    pub unsafe fn Install(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Install)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn PreUnInstall<P0>(&self, bclientonly: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::VARIANT_BOOL>,
    {
        (windows_core::Interface::vtable(self).PreUnInstall)(windows_core::Interface::as_raw(self), bclientonly.param().abi()).ok()
    }
    pub unsafe fn PostUnInstall(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).PostUnInstall)(windows_core::Interface::as_raw(self)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct ICertSrvSetup_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub CAErrorId: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub CAErrorString: unsafe extern "system" fn(*mut core::ffi::c_void, *mut std::mem::MaybeUninit<windows_core::BSTR>) -> windows_core::HRESULT,
    pub InitializeDefaults: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::VARIANT_BOOL, super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
    pub GetCASetupProperty: unsafe extern "system" fn(*mut core::ffi::c_void, CASetupProperty, *mut std::mem::MaybeUninit<windows_core::VARIANT>) -> windows_core::HRESULT,
    pub SetCASetupProperty: unsafe extern "system" fn(*mut core::ffi::c_void, CASetupProperty, *const std::mem::MaybeUninit<windows_core::VARIANT>) -> windows_core::HRESULT,
    pub IsPropertyEditable: unsafe extern "system" fn(*mut core::ffi::c_void, CASetupProperty, *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
    pub GetSupportedCATypes: unsafe extern "system" fn(*mut core::ffi::c_void, *mut std::mem::MaybeUninit<windows_core::VARIANT>) -> windows_core::HRESULT,
    pub GetProviderNameList: unsafe extern "system" fn(*mut core::ffi::c_void, *mut std::mem::MaybeUninit<windows_core::VARIANT>) -> windows_core::HRESULT,
    pub GetKeyLengthList: unsafe extern "system" fn(*mut core::ffi::c_void, std::mem::MaybeUninit<windows_core::BSTR>, *mut std::mem::MaybeUninit<windows_core::VARIANT>) -> windows_core::HRESULT,
    pub GetHashAlgorithmList: unsafe extern "system" fn(*mut core::ffi::c_void, std::mem::MaybeUninit<windows_core::BSTR>, *mut std::mem::MaybeUninit<windows_core::VARIANT>) -> windows_core::HRESULT,
    pub GetPrivateKeyContainerList: unsafe extern "system" fn(*mut core::ffi::c_void, std::mem::MaybeUninit<windows_core::BSTR>, *mut std::mem::MaybeUninit<windows_core::VARIANT>) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub GetExistingCACertificates: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetExistingCACertificates: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub CAImportPFX: unsafe extern "system" fn(*mut core::ffi::c_void, std::mem::MaybeUninit<windows_core::BSTR>, std::mem::MaybeUninit<windows_core::BSTR>, super::super::Foundation::VARIANT_BOOL, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    CAImportPFX: usize,
    pub SetCADistinguishedName: unsafe extern "system" fn(*mut core::ffi::c_void, std::mem::MaybeUninit<windows_core::BSTR>, super::super::Foundation::VARIANT_BOOL, super::super::Foundation::VARIANT_BOOL, super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
    pub SetDatabaseInformation: unsafe extern "system" fn(*mut core::ffi::c_void, std::mem::MaybeUninit<windows_core::BSTR>, std::mem::MaybeUninit<windows_core::BSTR>, std::mem::MaybeUninit<windows_core::BSTR>, super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
    pub SetParentCAInformation: unsafe extern "system" fn(*mut core::ffi::c_void, std::mem::MaybeUninit<windows_core::BSTR>) -> windows_core::HRESULT,
    pub SetWebCAInformation: unsafe extern "system" fn(*mut core::ffi::c_void, std::mem::MaybeUninit<windows_core::BSTR>) -> windows_core::HRESULT,
    pub Install: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub PreUnInstall: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
    pub PostUnInstall: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(ICertSrvSetupKeyInformation, ICertSrvSetupKeyInformation_Vtbl, 0x6ba73778_36da_4c39_8a85_bcfa7d000793);
#[cfg(feature = "Win32_System_Com")]
impl std::ops::Deref for ICertSrvSetupKeyInformation {
    type Target = super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(ICertSrvSetupKeyInformation, windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl ICertSrvSetupKeyInformation {
    pub unsafe fn ProviderName(&self) -> windows_core::Result<windows_core::BSTR> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).ProviderName)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetProviderName<P0>(&self, bstrval: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::BSTR>,
    {
        (windows_core::Interface::vtable(self).SetProviderName)(windows_core::Interface::as_raw(self), bstrval.param().abi()).ok()
    }
    pub unsafe fn Length(&self) -> windows_core::Result<i32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).Length)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetLength(&self, lval: i32) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetLength)(windows_core::Interface::as_raw(self), lval).ok()
    }
    pub unsafe fn Existing(&self) -> windows_core::Result<super::super::Foundation::VARIANT_BOOL> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).Existing)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn SetExisting<P0>(&self, bval: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::Foundation::VARIANT_BOOL>,
    {
        (windows_core::Interface::vtable(self).SetExisting)(windows_core::Interface::as_raw(self), bval.param().abi()).ok()
    }
    pub unsafe fn ContainerName(&self) -> windows_core::Result<windows_core::BSTR> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).ContainerName)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetContainerName<P0>(&self, bstrval: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::BSTR>,
    {
        (windows_core::Interface::vtable(self).SetContainerName)(windows_core::Interface::as_raw(self), bstrval.param().abi()).ok()
    }
    pub unsafe fn HashAlgorithm(&self) -> windows_core::Result<windows_core::BSTR> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).HashAlgorithm)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetHashAlgorithm<P0>(&self, bstrval: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::BSTR>,
    {
        (windows_core::Interface::vtable(self).SetHashAlgorithm)(windows_core::Interface::as_raw(self), bstrval.param().abi()).ok()
    }
    pub unsafe fn ExistingCACertificate(&self) -> windows_core::Result<windows_core::VARIANT> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).ExistingCACertificate)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetExistingCACertificate<P0>(&self, varval: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::VARIANT>,
    {
        (windows_core::Interface::vtable(self).SetExistingCACertificate)(windows_core::Interface::as_raw(self), varval.param().abi()).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct ICertSrvSetupKeyInformation_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub ProviderName: unsafe extern "system" fn(*mut core::ffi::c_void, *mut std::mem::MaybeUninit<windows_core::BSTR>) -> windows_core::HRESULT,
    pub SetProviderName: unsafe extern "system" fn(*mut core::ffi::c_void, std::mem::MaybeUninit<windows_core::BSTR>) -> windows_core::HRESULT,
    pub Length: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetLength: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub Existing: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
    pub SetExisting: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
    pub ContainerName: unsafe extern "system" fn(*mut core::ffi::c_void, *mut std::mem::MaybeUninit<windows_core::BSTR>) -> windows_core::HRESULT,
    pub SetContainerName: unsafe extern "system" fn(*mut core::ffi::c_void, std::mem::MaybeUninit<windows_core::BSTR>) -> windows_core::HRESULT,
    pub HashAlgorithm: unsafe extern "system" fn(*mut core::ffi::c_void, *mut std::mem::MaybeUninit<windows_core::BSTR>) -> windows_core::HRESULT,
    pub SetHashAlgorithm: unsafe extern "system" fn(*mut core::ffi::c_void, std::mem::MaybeUninit<windows_core::BSTR>) -> windows_core::HRESULT,
    pub ExistingCACertificate: unsafe extern "system" fn(*mut core::ffi::c_void, *mut std::mem::MaybeUninit<windows_core::VARIANT>) -> windows_core::HRESULT,
    pub SetExistingCACertificate: unsafe extern "system" fn(*mut core::ffi::c_void, std::mem::MaybeUninit<windows_core::VARIANT>) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(ICertSrvSetupKeyInformationCollection, ICertSrvSetupKeyInformationCollection_Vtbl, 0xe65c8b00_e58f_41f9_a9ec_a28d7427c844);
#[cfg(feature = "Win32_System_Com")]
impl std::ops::Deref for ICertSrvSetupKeyInformationCollection {
    type Target = super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(ICertSrvSetupKeyInformationCollection, windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl ICertSrvSetupKeyInformationCollection {
    pub unsafe fn _NewEnum(&self) -> windows_core::Result<windows_core::IUnknown> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self)._NewEnum)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn get_Item(&self, index: i32) -> windows_core::Result<windows_core::VARIANT> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).get_Item)(windows_core::Interface::as_raw(self), index, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn Count(&self) -> windows_core::Result<i32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).Count)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Add<P0>(&self, pikeyinformation: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<ICertSrvSetupKeyInformation>,
    {
        (windows_core::Interface::vtable(self).Add)(windows_core::Interface::as_raw(self), pikeyinformation.param().abi()).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct ICertSrvSetupKeyInformationCollection_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub _NewEnum: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub get_Item: unsafe extern "system" fn(*mut core::ffi::c_void, i32, *mut std::mem::MaybeUninit<windows_core::VARIANT>) -> windows_core::HRESULT,
    pub Count: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Add: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Add: usize,
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(ICertificateEnrollmentPolicyServerSetup, ICertificateEnrollmentPolicyServerSetup_Vtbl, 0x859252cc_238c_4a88_b8fd_a37e7d04e68b);
#[cfg(feature = "Win32_System_Com")]
impl std::ops::Deref for ICertificateEnrollmentPolicyServerSetup {
    type Target = super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(ICertificateEnrollmentPolicyServerSetup, windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl ICertificateEnrollmentPolicyServerSetup {
    pub unsafe fn ErrorString(&self) -> windows_core::Result<windows_core::BSTR> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).ErrorString)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn InitializeInstallDefaults(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).InitializeInstallDefaults)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetProperty(&self, propertyid: CEPSetupProperty) -> windows_core::Result<windows_core::VARIANT> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetProperty)(windows_core::Interface::as_raw(self), propertyid, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetProperty(&self, propertyid: CEPSetupProperty, ppropertyvalue: *const windows_core::VARIANT) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetProperty)(windows_core::Interface::as_raw(self), propertyid, core::mem::transmute(ppropertyvalue)).ok()
    }
    pub unsafe fn Install(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Install)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn UnInstall(&self, pauthkeybasedrenewal: *const windows_core::VARIANT) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).UnInstall)(windows_core::Interface::as_raw(self), core::mem::transmute(pauthkeybasedrenewal)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct ICertificateEnrollmentPolicyServerSetup_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub ErrorString: unsafe extern "system" fn(*mut core::ffi::c_void, *mut std::mem::MaybeUninit<windows_core::BSTR>) -> windows_core::HRESULT,
    pub InitializeInstallDefaults: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetProperty: unsafe extern "system" fn(*mut core::ffi::c_void, CEPSetupProperty, *mut std::mem::MaybeUninit<windows_core::VARIANT>) -> windows_core::HRESULT,
    pub SetProperty: unsafe extern "system" fn(*mut core::ffi::c_void, CEPSetupProperty, *const std::mem::MaybeUninit<windows_core::VARIANT>) -> windows_core::HRESULT,
    pub Install: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub UnInstall: unsafe extern "system" fn(*mut core::ffi::c_void, *const std::mem::MaybeUninit<windows_core::VARIANT>) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(ICertificateEnrollmentServerSetup, ICertificateEnrollmentServerSetup_Vtbl, 0x70027fdb_9dd9_4921_8944_b35cb31bd2ec);
#[cfg(feature = "Win32_System_Com")]
impl std::ops::Deref for ICertificateEnrollmentServerSetup {
    type Target = super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(ICertificateEnrollmentServerSetup, windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl ICertificateEnrollmentServerSetup {
    pub unsafe fn ErrorString(&self) -> windows_core::Result<windows_core::BSTR> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).ErrorString)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn InitializeInstallDefaults(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).InitializeInstallDefaults)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetProperty(&self, propertyid: CESSetupProperty) -> windows_core::Result<windows_core::VARIANT> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetProperty)(windows_core::Interface::as_raw(self), propertyid, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetProperty(&self, propertyid: CESSetupProperty, ppropertyvalue: *const windows_core::VARIANT) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetProperty)(windows_core::Interface::as_raw(self), propertyid, core::mem::transmute(ppropertyvalue)).ok()
    }
    pub unsafe fn SetApplicationPoolCredentials<P0, P1>(&self, bstrusername: P0, bstrpassword: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::BSTR>,
        P1: windows_core::Param<windows_core::BSTR>,
    {
        (windows_core::Interface::vtable(self).SetApplicationPoolCredentials)(windows_core::Interface::as_raw(self), bstrusername.param().abi(), bstrpassword.param().abi()).ok()
    }
    pub unsafe fn Install(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Install)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn UnInstall(&self, pcaconfig: *const windows_core::VARIANT, pauthentication: *const windows_core::VARIANT) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).UnInstall)(windows_core::Interface::as_raw(self), core::mem::transmute(pcaconfig), core::mem::transmute(pauthentication)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct ICertificateEnrollmentServerSetup_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub ErrorString: unsafe extern "system" fn(*mut core::ffi::c_void, *mut std::mem::MaybeUninit<windows_core::BSTR>) -> windows_core::HRESULT,
    pub InitializeInstallDefaults: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetProperty: unsafe extern "system" fn(*mut core::ffi::c_void, CESSetupProperty, *mut std::mem::MaybeUninit<windows_core::VARIANT>) -> windows_core::HRESULT,
    pub SetProperty: unsafe extern "system" fn(*mut core::ffi::c_void, CESSetupProperty, *const std::mem::MaybeUninit<windows_core::VARIANT>) -> windows_core::HRESULT,
    pub SetApplicationPoolCredentials: unsafe extern "system" fn(*mut core::ffi::c_void, std::mem::MaybeUninit<windows_core::BSTR>, std::mem::MaybeUninit<windows_core::BSTR>) -> windows_core::HRESULT,
    pub Install: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub UnInstall: unsafe extern "system" fn(*mut core::ffi::c_void, *const std::mem::MaybeUninit<windows_core::VARIANT>, *const std::mem::MaybeUninit<windows_core::VARIANT>) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IMSCEPSetup, IMSCEPSetup_Vtbl, 0x4f7761bb_9f3b_4592_9ee0_9a73259c313e);
#[cfg(feature = "Win32_System_Com")]
impl std::ops::Deref for IMSCEPSetup {
    type Target = super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { std::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IMSCEPSetup, windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl IMSCEPSetup {
    pub unsafe fn MSCEPErrorId(&self) -> windows_core::Result<i32> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).MSCEPErrorId)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn MSCEPErrorString(&self) -> windows_core::Result<windows_core::BSTR> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).MSCEPErrorString)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn InitializeDefaults(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).InitializeDefaults)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetMSCEPSetupProperty(&self, propertyid: MSCEPSetupProperty) -> windows_core::Result<windows_core::VARIANT> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetMSCEPSetupProperty)(windows_core::Interface::as_raw(self), propertyid, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn SetMSCEPSetupProperty(&self, propertyid: MSCEPSetupProperty, ppropertyvalue: *const windows_core::VARIANT) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).SetMSCEPSetupProperty)(windows_core::Interface::as_raw(self), propertyid, core::mem::transmute(ppropertyvalue)).ok()
    }
    pub unsafe fn SetAccountInformation<P0, P1>(&self, bstrusername: P0, bstrpassword: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::BSTR>,
        P1: windows_core::Param<windows_core::BSTR>,
    {
        (windows_core::Interface::vtable(self).SetAccountInformation)(windows_core::Interface::as_raw(self), bstrusername.param().abi(), bstrpassword.param().abi()).ok()
    }
    pub unsafe fn IsMSCEPStoreEmpty(&self) -> windows_core::Result<super::super::Foundation::VARIANT_BOOL> {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).IsMSCEPStoreEmpty)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
    }
    pub unsafe fn GetProviderNameList<P0>(&self, bexchange: P0) -> windows_core::Result<windows_core::VARIANT>
    where
        P0: windows_core::Param<super::super::Foundation::VARIANT_BOOL>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetProviderNameList)(windows_core::Interface::as_raw(self), bexchange.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn GetKeyLengthList<P0, P1>(&self, bexchange: P0, bstrprovidername: P1) -> windows_core::Result<windows_core::VARIANT>
    where
        P0: windows_core::Param<super::super::Foundation::VARIANT_BOOL>,
        P1: windows_core::Param<windows_core::BSTR>,
    {
        let mut result__ = std::mem::zeroed();
        (windows_core::Interface::vtable(self).GetKeyLengthList)(windows_core::Interface::as_raw(self), bexchange.param().abi(), bstrprovidername.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
    pub unsafe fn Install(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).Install)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn PreUnInstall(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).PreUnInstall)(windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn PostUnInstall(&self) -> windows_core::Result<()> {
        (windows_core::Interface::vtable(self).PostUnInstall)(windows_core::Interface::as_raw(self)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IMSCEPSetup_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub MSCEPErrorId: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub MSCEPErrorString: unsafe extern "system" fn(*mut core::ffi::c_void, *mut std::mem::MaybeUninit<windows_core::BSTR>) -> windows_core::HRESULT,
    pub InitializeDefaults: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetMSCEPSetupProperty: unsafe extern "system" fn(*mut core::ffi::c_void, MSCEPSetupProperty, *mut std::mem::MaybeUninit<windows_core::VARIANT>) -> windows_core::HRESULT,
    pub SetMSCEPSetupProperty: unsafe extern "system" fn(*mut core::ffi::c_void, MSCEPSetupProperty, *const std::mem::MaybeUninit<windows_core::VARIANT>) -> windows_core::HRESULT,
    pub SetAccountInformation: unsafe extern "system" fn(*mut core::ffi::c_void, std::mem::MaybeUninit<windows_core::BSTR>, std::mem::MaybeUninit<windows_core::BSTR>) -> windows_core::HRESULT,
    pub IsMSCEPStoreEmpty: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
    pub GetProviderNameList: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::VARIANT_BOOL, *mut std::mem::MaybeUninit<windows_core::VARIANT>) -> windows_core::HRESULT,
    pub GetKeyLengthList: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::VARIANT_BOOL, std::mem::MaybeUninit<windows_core::BSTR>, *mut std::mem::MaybeUninit<windows_core::VARIANT>) -> windows_core::HRESULT,
    pub Install: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub PreUnInstall: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub PostUnInstall: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub const ALG_CLASS_ALL: u32 = 57344u32;
pub const ALG_CLASS_ANY: u32 = 0u32;
pub const ALG_CLASS_DATA_ENCRYPT: u32 = 24576u32;
pub const ALG_CLASS_HASH: u32 = 32768u32;
pub const ALG_CLASS_KEY_EXCHANGE: u32 = 40960u32;
pub const ALG_CLASS_MSG_ENCRYPT: u32 = 16384u32;
pub const ALG_CLASS_SIGNATURE: u32 = 8192u32;
pub const ALG_SID_3DES: u32 = 3u32;
pub const ALG_SID_3DES_112: u32 = 9u32;
pub const ALG_SID_AES: u32 = 17u32;
pub const ALG_SID_AES_128: u32 = 14u32;
pub const ALG_SID_AES_192: u32 = 15u32;
pub const ALG_SID_AES_256: u32 = 16u32;
pub const ALG_SID_AGREED_KEY_ANY: u32 = 3u32;
pub const ALG_SID_ANY: u32 = 0u32;
pub const ALG_SID_CAST: u32 = 6u32;
pub const ALG_SID_CYLINK_MEK: u32 = 12u32;
pub const ALG_SID_DES: u32 = 1u32;
pub const ALG_SID_DESX: u32 = 4u32;
pub const ALG_SID_DH_EPHEM: u32 = 2u32;
pub const ALG_SID_DH_SANDF: u32 = 1u32;
pub const ALG_SID_DSS_ANY: u32 = 0u32;
pub const ALG_SID_DSS_DMS: u32 = 2u32;
pub const ALG_SID_DSS_PKCS: u32 = 1u32;
pub const ALG_SID_ECDH: u32 = 5u32;
pub const ALG_SID_ECDH_EPHEM: u32 = 6u32;
pub const ALG_SID_ECDSA: u32 = 3u32;
pub const ALG_SID_ECMQV: u32 = 1u32;
pub const ALG_SID_EXAMPLE: u32 = 80u32;
pub const ALG_SID_HASH_REPLACE_OWF: u32 = 11u32;
pub const ALG_SID_HMAC: u32 = 9u32;
pub const ALG_SID_IDEA: u32 = 5u32;
pub const ALG_SID_KEA: u32 = 4u32;
pub const ALG_SID_MAC: u32 = 5u32;
pub const ALG_SID_MD2: u32 = 1u32;
pub const ALG_SID_MD4: u32 = 2u32;
pub const ALG_SID_MD5: u32 = 3u32;
pub const ALG_SID_PCT1_MASTER: u32 = 4u32;
pub const ALG_SID_RC2: u32 = 2u32;
pub const ALG_SID_RC4: u32 = 1u32;
pub const ALG_SID_RC5: u32 = 13u32;
pub const ALG_SID_RIPEMD: u32 = 6u32;
pub const ALG_SID_RIPEMD160: u32 = 7u32;
pub const ALG_SID_RSA_ANY: u32 = 0u32;
pub const ALG_SID_RSA_ENTRUST: u32 = 3u32;
pub const ALG_SID_RSA_MSATWORK: u32 = 2u32;
pub const ALG_SID_RSA_PGP: u32 = 4u32;
pub const ALG_SID_RSA_PKCS: u32 = 1u32;
pub const ALG_SID_SAFERSK128: u32 = 8u32;
pub const ALG_SID_SAFERSK64: u32 = 7u32;
pub const ALG_SID_SCHANNEL_ENC_KEY: u32 = 7u32;
pub const ALG_SID_SCHANNEL_MAC_KEY: u32 = 3u32;
pub const ALG_SID_SCHANNEL_MASTER_HASH: u32 = 2u32;
pub const ALG_SID_SEAL: u32 = 2u32;
pub const ALG_SID_SHA: u32 = 4u32;
pub const ALG_SID_SHA1: u32 = 4u32;
pub const ALG_SID_SHA_256: u32 = 12u32;
pub const ALG_SID_SHA_384: u32 = 13u32;
pub const ALG_SID_SHA_512: u32 = 14u32;
pub const ALG_SID_SKIPJACK: u32 = 10u32;
pub const ALG_SID_SSL2_MASTER: u32 = 5u32;
pub const ALG_SID_SSL3SHAMD5: u32 = 8u32;
pub const ALG_SID_SSL3_MASTER: u32 = 1u32;
pub const ALG_SID_TEK: u32 = 11u32;
pub const ALG_SID_THIRDPARTY_ANY: u32 = 0u32;
pub const ALG_SID_TLS1PRF: u32 = 10u32;
pub const ALG_SID_TLS1_MASTER: u32 = 6u32;
pub const ALG_TYPE_ANY: u32 = 0u32;
pub const ALG_TYPE_BLOCK: u32 = 1536u32;
pub const ALG_TYPE_DH: u32 = 2560u32;
pub const ALG_TYPE_DSS: u32 = 512u32;
pub const ALG_TYPE_ECDH: u32 = 3584u32;
pub const ALG_TYPE_RSA: u32 = 1024u32;
pub const ALG_TYPE_SECURECHANNEL: u32 = 3072u32;
pub const ALG_TYPE_STREAM: u32 = 2048u32;
pub const ALG_TYPE_THIRDPARTY: u32 = 4096u32;
pub const AT_KEYEXCHANGE: CERT_KEY_SPEC = CERT_KEY_SPEC(1u32);
pub const AT_SIGNATURE: CERT_KEY_SPEC = CERT_KEY_SPEC(2u32);
pub const AUDIT_CARD_DELETE: windows_core::HRESULT = windows_core::HRESULT(0x40050201_u32 as _);
pub const AUDIT_CARD_IMPORT: windows_core::HRESULT = windows_core::HRESULT(0x40050202_u32 as _);
pub const AUDIT_CARD_WRITTEN: windows_core::HRESULT = windows_core::HRESULT(0x40050200_u32 as _);
pub const AUDIT_SERVICE_IDLE_STOP: windows_core::HRESULT = windows_core::HRESULT(0x40050206_u32 as _);
pub const AUDIT_STORE_DELETE: windows_core::HRESULT = windows_core::HRESULT(0x40050205_u32 as _);
pub const AUDIT_STORE_EXPORT: windows_core::HRESULT = windows_core::HRESULT(0x40050204_u32 as _);
pub const AUDIT_STORE_IMPORT: windows_core::HRESULT = windows_core::HRESULT(0x40050203_u32 as _);
pub const AUTHTYPE_CLIENT: HTTPSPOLICY_CALLBACK_DATA_AUTH_TYPE = HTTPSPOLICY_CALLBACK_DATA_AUTH_TYPE(1u32);
pub const AUTHTYPE_SERVER: HTTPSPOLICY_CALLBACK_DATA_AUTH_TYPE = HTTPSPOLICY_CALLBACK_DATA_AUTH_TYPE(2u32);
pub const BASIC_CONSTRAINTS_CERT_CHAIN_POLICY_CA_FLAG: u32 = 2147483648u32;
pub const BASIC_CONSTRAINTS_CERT_CHAIN_POLICY_END_ENTITY_FLAG: u32 = 1073741824u32;
pub const BCRYPTBUFFER_VERSION: u32 = 0u32;
pub const BCRYPT_3DES_112_ALGORITHM: windows_core::PCWSTR = windows_core::w!("3DES_112");
pub const BCRYPT_3DES_112_CBC_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(369u32 as _);
pub const BCRYPT_3DES_112_CFB_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(401u32 as _);
pub const BCRYPT_3DES_112_ECB_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(385u32 as _);
pub const BCRYPT_3DES_ALGORITHM: windows_core::PCWSTR = windows_core::w!("3DES");
pub const BCRYPT_3DES_CBC_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(321u32 as _);
pub const BCRYPT_3DES_CFB_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(353u32 as _);
pub const BCRYPT_3DES_ECB_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(337u32 as _);
pub const BCRYPT_AES_ALGORITHM: windows_core::PCWSTR = windows_core::w!("AES");
pub const BCRYPT_AES_CBC_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(417u32 as _);
pub const BCRYPT_AES_CCM_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(465u32 as _);
pub const BCRYPT_AES_CFB_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(449u32 as _);
pub const BCRYPT_AES_CMAC_ALGORITHM: windows_core::PCWSTR = windows_core::w!("AES-CMAC");
pub const BCRYPT_AES_CMAC_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(257u32 as _);
pub const BCRYPT_AES_ECB_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(433u32 as _);
pub const BCRYPT_AES_GCM_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(481u32 as _);
pub const BCRYPT_AES_GMAC_ALGORITHM: windows_core::PCWSTR = windows_core::w!("AES-GMAC");
pub const BCRYPT_AES_GMAC_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(273u32 as _);
pub const BCRYPT_AES_WRAP_KEY_BLOB: windows_core::PCWSTR = windows_core::w!("Rfc3565KeyWrapBlob");
pub const BCRYPT_ALGORITHM_NAME: windows_core::PCWSTR = windows_core::w!("AlgorithmName");
pub const BCRYPT_ALG_HANDLE_HMAC_FLAG: BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS = BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS(8u32);
pub const BCRYPT_ASYMMETRIC_ENCRYPTION_INTERFACE: BCRYPT_INTERFACE = BCRYPT_INTERFACE(3u32);
pub const BCRYPT_ASYMMETRIC_ENCRYPTION_OPERATION: BCRYPT_OPERATION = BCRYPT_OPERATION(4u32);
pub const BCRYPT_AUTHENTICATED_CIPHER_MODE_INFO_VERSION: u32 = 1u32;
pub const BCRYPT_AUTH_MODE_CHAIN_CALLS_FLAG: u32 = 1u32;
pub const BCRYPT_AUTH_MODE_IN_PROGRESS_FLAG: u32 = 2u32;
pub const BCRYPT_AUTH_TAG_LENGTH: windows_core::PCWSTR = windows_core::w!("AuthTagLength");
pub const BCRYPT_BLOCK_LENGTH: windows_core::PCWSTR = windows_core::w!("BlockLength");
pub const BCRYPT_BLOCK_PADDING: BCRYPT_FLAGS = BCRYPT_FLAGS(1u32);
pub const BCRYPT_BLOCK_SIZE_LIST: windows_core::PCWSTR = windows_core::w!("BlockSizeList");
pub const BCRYPT_BUFFERS_LOCKED_FLAG: u32 = 64u32;
pub const BCRYPT_CAPI_AES_FLAG: u32 = 16u32;
pub const BCRYPT_CAPI_KDF_ALGORITHM: windows_core::PCWSTR = windows_core::w!("CAPI_KDF");
pub const BCRYPT_CAPI_KDF_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(801u32 as _);
pub const BCRYPT_CHACHA20_POLY1305_ALGORITHM: windows_core::PCWSTR = windows_core::w!("CHACHA20_POLY1305");
pub const BCRYPT_CHACHA20_POLY1305_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(929u32 as _);
pub const BCRYPT_CHAINING_MODE: windows_core::PCWSTR = windows_core::w!("ChainingMode");
pub const BCRYPT_CHAIN_MODE_CBC: windows_core::PCWSTR = windows_core::w!("ChainingModeCBC");
pub const BCRYPT_CHAIN_MODE_CCM: windows_core::PCWSTR = windows_core::w!("ChainingModeCCM");
pub const BCRYPT_CHAIN_MODE_CFB: windows_core::PCWSTR = windows_core::w!("ChainingModeCFB");
pub const BCRYPT_CHAIN_MODE_ECB: windows_core::PCWSTR = windows_core::w!("ChainingModeECB");
pub const BCRYPT_CHAIN_MODE_GCM: windows_core::PCWSTR = windows_core::w!("ChainingModeGCM");
pub const BCRYPT_CHAIN_MODE_NA: windows_core::PCWSTR = windows_core::w!("ChainingModeN/A");
pub const BCRYPT_CIPHER_INTERFACE: BCRYPT_INTERFACE = BCRYPT_INTERFACE(1u32);
pub const BCRYPT_CIPHER_OPERATION: BCRYPT_OPERATION = BCRYPT_OPERATION(1u32);
pub const BCRYPT_DESX_ALGORITHM: windows_core::PCWSTR = windows_core::w!("DESX");
pub const BCRYPT_DESX_CBC_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(545u32 as _);
pub const BCRYPT_DESX_CFB_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(577u32 as _);
pub const BCRYPT_DESX_ECB_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(561u32 as _);
pub const BCRYPT_DES_ALGORITHM: windows_core::PCWSTR = windows_core::w!("DES");
pub const BCRYPT_DES_CBC_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(497u32 as _);
pub const BCRYPT_DES_CFB_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(529u32 as _);
pub const BCRYPT_DES_ECB_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(513u32 as _);
pub const BCRYPT_DH_ALGORITHM: windows_core::PCWSTR = windows_core::w!("DH");
pub const BCRYPT_DH_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(641u32 as _);
pub const BCRYPT_DH_PARAMETERS: windows_core::PCWSTR = windows_core::w!("DHParameters");
pub const BCRYPT_DH_PARAMETERS_MAGIC: u32 = 1297107012u32;
pub const BCRYPT_DH_PRIVATE_BLOB: windows_core::PCWSTR = windows_core::w!("DHPRIVATEBLOB");
pub const BCRYPT_DH_PRIVATE_MAGIC: BCRYPT_DH_KEY_BLOB_MAGIC = BCRYPT_DH_KEY_BLOB_MAGIC(1448101956u32);
pub const BCRYPT_DH_PUBLIC_BLOB: windows_core::PCWSTR = windows_core::w!("DHPUBLICBLOB");
pub const BCRYPT_DH_PUBLIC_MAGIC: BCRYPT_DH_KEY_BLOB_MAGIC = BCRYPT_DH_KEY_BLOB_MAGIC(1112557636u32);
pub const BCRYPT_DSA_ALGORITHM: windows_core::PCWSTR = windows_core::w!("DSA");
pub const BCRYPT_DSA_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(721u32 as _);
pub const BCRYPT_DSA_PARAMETERS: windows_core::PCWSTR = windows_core::w!("DSAParameters");
pub const BCRYPT_DSA_PARAMETERS_MAGIC: u32 = 1297109828u32;
pub const BCRYPT_DSA_PARAMETERS_MAGIC_V2: u32 = 843927620u32;
pub const BCRYPT_DSA_PRIVATE_BLOB: windows_core::PCWSTR = windows_core::w!("DSAPRIVATEBLOB");
pub const BCRYPT_DSA_PRIVATE_MAGIC: BCRYPT_DSA_MAGIC = BCRYPT_DSA_MAGIC(1448104772u32);
pub const BCRYPT_DSA_PRIVATE_MAGIC_V2: u32 = 844517444u32;
pub const BCRYPT_DSA_PUBLIC_BLOB: windows_core::PCWSTR = windows_core::w!("DSAPUBLICBLOB");
pub const BCRYPT_DSA_PUBLIC_MAGIC: BCRYPT_DSA_MAGIC = BCRYPT_DSA_MAGIC(1112560452u32);
pub const BCRYPT_DSA_PUBLIC_MAGIC_V2: u32 = 843206724u32;
pub const BCRYPT_ECCFULLPRIVATE_BLOB: windows_core::PCWSTR = windows_core::w!("ECCFULLPRIVATEBLOB");
pub const BCRYPT_ECCFULLPUBLIC_BLOB: windows_core::PCWSTR = windows_core::w!("ECCFULLPUBLICBLOB");
pub const BCRYPT_ECCPRIVATE_BLOB: windows_core::PCWSTR = windows_core::w!("ECCPRIVATEBLOB");
pub const BCRYPT_ECCPUBLIC_BLOB: windows_core::PCWSTR = windows_core::w!("ECCPUBLICBLOB");
pub const BCRYPT_ECC_CURVE_25519: windows_core::PCWSTR = windows_core::w!("curve25519");
pub const BCRYPT_ECC_CURVE_BRAINPOOLP160R1: windows_core::PCWSTR = windows_core::w!("brainpoolP160r1");
pub const BCRYPT_ECC_CURVE_BRAINPOOLP160T1: windows_core::PCWSTR = windows_core::w!("brainpoolP160t1");
pub const BCRYPT_ECC_CURVE_BRAINPOOLP192R1: windows_core::PCWSTR = windows_core::w!("brainpoolP192r1");
pub const BCRYPT_ECC_CURVE_BRAINPOOLP192T1: windows_core::PCWSTR = windows_core::w!("brainpoolP192t1");
pub const BCRYPT_ECC_CURVE_BRAINPOOLP224R1: windows_core::PCWSTR = windows_core::w!("brainpoolP224r1");
pub const BCRYPT_ECC_CURVE_BRAINPOOLP224T1: windows_core::PCWSTR = windows_core::w!("brainpoolP224t1");
pub const BCRYPT_ECC_CURVE_BRAINPOOLP256R1: windows_core::PCWSTR = windows_core::w!("brainpoolP256r1");
pub const BCRYPT_ECC_CURVE_BRAINPOOLP256T1: windows_core::PCWSTR = windows_core::w!("brainpoolP256t1");
pub const BCRYPT_ECC_CURVE_BRAINPOOLP320R1: windows_core::PCWSTR = windows_core::w!("brainpoolP320r1");
pub const BCRYPT_ECC_CURVE_BRAINPOOLP320T1: windows_core::PCWSTR = windows_core::w!("brainpoolP320t1");
pub const BCRYPT_ECC_CURVE_BRAINPOOLP384R1: windows_core::PCWSTR = windows_core::w!("brainpoolP384r1");
pub const BCRYPT_ECC_CURVE_BRAINPOOLP384T1: windows_core::PCWSTR = windows_core::w!("brainpoolP384t1");
pub const BCRYPT_ECC_CURVE_BRAINPOOLP512R1: windows_core::PCWSTR = windows_core::w!("brainpoolP512r1");
pub const BCRYPT_ECC_CURVE_BRAINPOOLP512T1: windows_core::PCWSTR = windows_core::w!("brainpoolP512t1");
pub const BCRYPT_ECC_CURVE_EC192WAPI: windows_core::PCWSTR = windows_core::w!("ec192wapi");
pub const BCRYPT_ECC_CURVE_NAME: windows_core::PCWSTR = windows_core::w!("ECCCurveName");
pub const BCRYPT_ECC_CURVE_NAME_LIST: windows_core::PCWSTR = windows_core::w!("ECCCurveNameList");
pub const BCRYPT_ECC_CURVE_NISTP192: windows_core::PCWSTR = windows_core::w!("nistP192");
pub const BCRYPT_ECC_CURVE_NISTP224: windows_core::PCWSTR = windows_core::w!("nistP224");
pub const BCRYPT_ECC_CURVE_NISTP256: windows_core::PCWSTR = windows_core::w!("nistP256");
pub const BCRYPT_ECC_CURVE_NISTP384: windows_core::PCWSTR = windows_core::w!("nistP384");
pub const BCRYPT_ECC_CURVE_NISTP521: windows_core::PCWSTR = windows_core::w!("nistP521");
pub const BCRYPT_ECC_CURVE_NUMSP256T1: windows_core::PCWSTR = windows_core::w!("numsP256t1");
pub const BCRYPT_ECC_CURVE_NUMSP384T1: windows_core::PCWSTR = windows_core::w!("numsP384t1");
pub const BCRYPT_ECC_CURVE_NUMSP512T1: windows_core::PCWSTR = windows_core::w!("numsP512t1");
pub const BCRYPT_ECC_CURVE_SECP160K1: windows_core::PCWSTR = windows_core::w!("secP160k1");
pub const BCRYPT_ECC_CURVE_SECP160R1: windows_core::PCWSTR = windows_core::w!("secP160r1");
pub const BCRYPT_ECC_CURVE_SECP160R2: windows_core::PCWSTR = windows_core::w!("secP160r2");
pub const BCRYPT_ECC_CURVE_SECP192K1: windows_core::PCWSTR = windows_core::w!("secP192k1");
pub const BCRYPT_ECC_CURVE_SECP192R1: windows_core::PCWSTR = windows_core::w!("secP192r1");
pub const BCRYPT_ECC_CURVE_SECP224K1: windows_core::PCWSTR = windows_core::w!("secP224k1");
pub const BCRYPT_ECC_CURVE_SECP224R1: windows_core::PCWSTR = windows_core::w!("secP224r1");
pub const BCRYPT_ECC_CURVE_SECP256K1: windows_core::PCWSTR = windows_core::w!("secP256k1");
pub const BCRYPT_ECC_CURVE_SECP256R1: windows_core::PCWSTR = windows_core::w!("secP256r1");
pub const BCRYPT_ECC_CURVE_SECP384R1: windows_core::PCWSTR = windows_core::w!("secP384r1");
pub const BCRYPT_ECC_CURVE_SECP521R1: windows_core::PCWSTR = windows_core::w!("secP521r1");
pub const BCRYPT_ECC_CURVE_WTLS12: windows_core::PCWSTR = windows_core::w!("wtls12");
pub const BCRYPT_ECC_CURVE_WTLS7: windows_core::PCWSTR = windows_core::w!("wtls7");
pub const BCRYPT_ECC_CURVE_WTLS9: windows_core::PCWSTR = windows_core::w!("wtls9");
pub const BCRYPT_ECC_CURVE_X962P192V1: windows_core::PCWSTR = windows_core::w!("x962P192v1");
pub const BCRYPT_ECC_CURVE_X962P192V2: windows_core::PCWSTR = windows_core::w!("x962P192v2");
pub const BCRYPT_ECC_CURVE_X962P192V3: windows_core::PCWSTR = windows_core::w!("x962P192v3");
pub const BCRYPT_ECC_CURVE_X962P239V1: windows_core::PCWSTR = windows_core::w!("x962P239v1");
pub const BCRYPT_ECC_CURVE_X962P239V2: windows_core::PCWSTR = windows_core::w!("x962P239v2");
pub const BCRYPT_ECC_CURVE_X962P239V3: windows_core::PCWSTR = windows_core::w!("x962P239v3");
pub const BCRYPT_ECC_CURVE_X962P256V1: windows_core::PCWSTR = windows_core::w!("x962P256v1");
pub const BCRYPT_ECC_FULLKEY_BLOB_V1: u32 = 1u32;
pub const BCRYPT_ECC_PARAMETERS: windows_core::PCWSTR = windows_core::w!("ECCParameters");
pub const BCRYPT_ECC_PARAMETERS_MAGIC: u32 = 1346585413u32;
pub const BCRYPT_ECC_PRIME_MONTGOMERY_CURVE: ECC_CURVE_TYPE_ENUM = ECC_CURVE_TYPE_ENUM(3i32);
pub const BCRYPT_ECC_PRIME_SHORT_WEIERSTRASS_CURVE: ECC_CURVE_TYPE_ENUM = ECC_CURVE_TYPE_ENUM(1i32);
pub const BCRYPT_ECC_PRIME_TWISTED_EDWARDS_CURVE: ECC_CURVE_TYPE_ENUM = ECC_CURVE_TYPE_ENUM(2i32);
pub const BCRYPT_ECDH_ALGORITHM: windows_core::PCWSTR = windows_core::w!("ECDH");
pub const BCRYPT_ECDH_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(657u32 as _);
pub const BCRYPT_ECDH_P256_ALGORITHM: windows_core::PCWSTR = windows_core::w!("ECDH_P256");
pub const BCRYPT_ECDH_P256_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(673u32 as _);
pub const BCRYPT_ECDH_P384_ALGORITHM: windows_core::PCWSTR = windows_core::w!("ECDH_P384");
pub const BCRYPT_ECDH_P384_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(689u32 as _);
pub const BCRYPT_ECDH_P521_ALGORITHM: windows_core::PCWSTR = windows_core::w!("ECDH_P521");
pub const BCRYPT_ECDH_P521_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(705u32 as _);
pub const BCRYPT_ECDH_PRIVATE_GENERIC_MAGIC: u32 = 1447772997u32;
pub const BCRYPT_ECDH_PRIVATE_P256_MAGIC: u32 = 843793221u32;
pub const BCRYPT_ECDH_PRIVATE_P384_MAGIC: u32 = 877347653u32;
pub const BCRYPT_ECDH_PRIVATE_P521_MAGIC: u32 = 910902085u32;
pub const BCRYPT_ECDH_PUBLIC_GENERIC_MAGIC: u32 = 1347109701u32;
pub const BCRYPT_ECDH_PUBLIC_P256_MAGIC: u32 = 827016005u32;
pub const BCRYPT_ECDH_PUBLIC_P384_MAGIC: u32 = 860570437u32;
pub const BCRYPT_ECDH_PUBLIC_P521_MAGIC: u32 = 894124869u32;
pub const BCRYPT_ECDSA_ALGORITHM: windows_core::PCWSTR = windows_core::w!("ECDSA");
pub const BCRYPT_ECDSA_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(241u32 as _);
pub const BCRYPT_ECDSA_P256_ALGORITHM: windows_core::PCWSTR = windows_core::w!("ECDSA_P256");
pub const BCRYPT_ECDSA_P256_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(737u32 as _);
pub const BCRYPT_ECDSA_P384_ALGORITHM: windows_core::PCWSTR = windows_core::w!("ECDSA_P384");
pub const BCRYPT_ECDSA_P384_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(753u32 as _);
pub const BCRYPT_ECDSA_P521_ALGORITHM: windows_core::PCWSTR = windows_core::w!("ECDSA_P521");
pub const BCRYPT_ECDSA_P521_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(769u32 as _);
pub const BCRYPT_ECDSA_PRIVATE_GENERIC_MAGIC: u32 = 1447314245u32;
pub const BCRYPT_ECDSA_PRIVATE_P256_MAGIC: u32 = 844317509u32;
pub const BCRYPT_ECDSA_PRIVATE_P384_MAGIC: u32 = 877871941u32;
pub const BCRYPT_ECDSA_PRIVATE_P521_MAGIC: u32 = 911426373u32;
pub const BCRYPT_ECDSA_PUBLIC_GENERIC_MAGIC: u32 = 1346650949u32;
pub const BCRYPT_ECDSA_PUBLIC_P256_MAGIC: u32 = 827540293u32;
pub const BCRYPT_ECDSA_PUBLIC_P384_MAGIC: u32 = 861094725u32;
pub const BCRYPT_ECDSA_PUBLIC_P521_MAGIC: u32 = 894649157u32;
pub const BCRYPT_EFFECTIVE_KEY_LENGTH: windows_core::PCWSTR = windows_core::w!("EffectiveKeyLength");
pub const BCRYPT_ENABLE_INCOMPATIBLE_FIPS_CHECKS: u32 = 256u32;
pub const BCRYPT_EXTENDED_KEYSIZE: u32 = 128u32;
pub const BCRYPT_GENERATE_IV: u32 = 32u32;
pub const BCRYPT_GLOBAL_PARAMETERS: windows_core::PCWSTR = windows_core::w!("SecretAgreementParam");
pub const BCRYPT_HASH_BLOCK_LENGTH: windows_core::PCWSTR = windows_core::w!("HashBlockLength");
pub const BCRYPT_HASH_INTERFACE: BCRYPT_INTERFACE = BCRYPT_INTERFACE(2u32);
pub const BCRYPT_HASH_INTERFACE_MAJORVERSION_2: u32 = 2u32;
pub const BCRYPT_HASH_LENGTH: windows_core::PCWSTR = windows_core::w!("HashDigestLength");
pub const BCRYPT_HASH_OID_LIST: windows_core::PCWSTR = windows_core::w!("HashOIDList");
pub const BCRYPT_HASH_OPERATION: BCRYPT_OPERATION = BCRYPT_OPERATION(2u32);
pub const BCRYPT_HASH_OPERATION_FINISH_HASH: BCRYPT_HASH_OPERATION_TYPE = BCRYPT_HASH_OPERATION_TYPE(2i32);
pub const BCRYPT_HASH_OPERATION_HASH_DATA: BCRYPT_HASH_OPERATION_TYPE = BCRYPT_HASH_OPERATION_TYPE(1i32);
pub const BCRYPT_HASH_REUSABLE_FLAG: BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS = BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS(32u32);
pub const BCRYPT_HKDF_ALGORITHM: windows_core::PCWSTR = windows_core::w!("HKDF");
pub const BCRYPT_HKDF_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(913u32 as _);
pub const BCRYPT_HKDF_HASH_ALGORITHM: windows_core::PCWSTR = windows_core::w!("HkdfHashAlgorithm");
pub const BCRYPT_HKDF_PRK_AND_FINALIZE: windows_core::PCWSTR = windows_core::w!("HkdfPrkAndFinalize");
pub const BCRYPT_HKDF_SALT_AND_FINALIZE: windows_core::PCWSTR = windows_core::w!("HkdfSaltAndFinalize");
pub const BCRYPT_HMAC_MD2_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(289u32 as _);
pub const BCRYPT_HMAC_MD4_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(305u32 as _);
pub const BCRYPT_HMAC_MD5_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(145u32 as _);
pub const BCRYPT_HMAC_SHA1_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(161u32 as _);
pub const BCRYPT_HMAC_SHA256_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(177u32 as _);
pub const BCRYPT_HMAC_SHA384_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(193u32 as _);
pub const BCRYPT_HMAC_SHA512_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(209u32 as _);
pub const BCRYPT_INITIALIZATION_VECTOR: windows_core::PCWSTR = windows_core::w!("IV");
pub const BCRYPT_IS_IFX_TPM_WEAK_KEY: windows_core::PCWSTR = windows_core::w!("IsIfxTpmWeakKey");
pub const BCRYPT_IS_KEYED_HASH: windows_core::PCWSTR = windows_core::w!("IsKeyedHash");
pub const BCRYPT_IS_REUSABLE_HASH: windows_core::PCWSTR = windows_core::w!("IsReusableHash");
pub const BCRYPT_KDF_HASH: windows_core::PCWSTR = windows_core::w!("HASH");
pub const BCRYPT_KDF_HKDF: windows_core::PCWSTR = windows_core::w!("HKDF");
pub const BCRYPT_KDF_HMAC: windows_core::PCWSTR = windows_core::w!("HMAC");
pub const BCRYPT_KDF_RAW_SECRET: windows_core::PCWSTR = windows_core::w!("TRUNCATE");
pub const BCRYPT_KDF_SP80056A_CONCAT: windows_core::PCWSTR = windows_core::w!("SP800_56A_CONCAT");
pub const BCRYPT_KDF_TLS_PRF: windows_core::PCWSTR = windows_core::w!("TLS_PRF");
pub const BCRYPT_KEY_DATA_BLOB: windows_core::PCWSTR = windows_core::w!("KeyDataBlob");
pub const BCRYPT_KEY_DATA_BLOB_MAGIC: u32 = 1296188491u32;
pub const BCRYPT_KEY_DATA_BLOB_VERSION1: u32 = 1u32;
pub const BCRYPT_KEY_DERIVATION_INTERFACE: u32 = 7u32;
pub const BCRYPT_KEY_DERIVATION_OPERATION: u32 = 64u32;
pub const BCRYPT_KEY_LENGTH: windows_core::PCWSTR = windows_core::w!("KeyLength");
pub const BCRYPT_KEY_LENGTHS: windows_core::PCWSTR = windows_core::w!("KeyLengths");
pub const BCRYPT_KEY_OBJECT_LENGTH: windows_core::PCWSTR = windows_core::w!("KeyObjectLength");
pub const BCRYPT_KEY_STRENGTH: windows_core::PCWSTR = windows_core::w!("KeyStrength");
pub const BCRYPT_KEY_VALIDATION_RANGE: u32 = 16u32;
pub const BCRYPT_KEY_VALIDATION_RANGE_AND_ORDER: u32 = 24u32;
pub const BCRYPT_KEY_VALIDATION_REGENERATE: u32 = 32u32;
pub const BCRYPT_MD2_ALGORITHM: windows_core::PCWSTR = windows_core::w!("MD2");
pub const BCRYPT_MD2_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(1u32 as _);
pub const BCRYPT_MD4_ALGORITHM: windows_core::PCWSTR = windows_core::w!("MD4");
pub const BCRYPT_MD4_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(17u32 as _);
pub const BCRYPT_MD5_ALGORITHM: windows_core::PCWSTR = windows_core::w!("MD5");
pub const BCRYPT_MD5_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(33u32 as _);
pub const BCRYPT_MESSAGE_BLOCK_LENGTH: windows_core::PCWSTR = windows_core::w!("MessageBlockLength");
pub const BCRYPT_MULTI_FLAG: u32 = 64u32;
pub const BCRYPT_MULTI_OBJECT_LENGTH: windows_core::PCWSTR = windows_core::w!("MultiObjectLength");
pub const BCRYPT_NO_CURVE_GENERATION_ALG_ID: ECC_CURVE_ALG_ID_ENUM = ECC_CURVE_ALG_ID_ENUM(0i32);
pub const BCRYPT_NO_KEY_VALIDATION: u32 = 8u32;
pub const BCRYPT_OBJECT_ALIGNMENT: u32 = 16u32;
pub const BCRYPT_OBJECT_LENGTH: windows_core::PCWSTR = windows_core::w!("ObjectLength");
pub const BCRYPT_OPAQUE_KEY_BLOB: windows_core::PCWSTR = windows_core::w!("OpaqueKeyBlob");
pub const BCRYPT_OPERATION_TYPE_HASH: BCRYPT_MULTI_OPERATION_TYPE = BCRYPT_MULTI_OPERATION_TYPE(1i32);
pub const BCRYPT_PADDING_SCHEMES: windows_core::PCWSTR = windows_core::w!("PaddingSchemes");
pub const BCRYPT_PAD_NONE: BCRYPT_FLAGS = BCRYPT_FLAGS(1u32);
pub const BCRYPT_PAD_OAEP: BCRYPT_FLAGS = BCRYPT_FLAGS(4u32);
pub const BCRYPT_PAD_PKCS1: BCRYPT_FLAGS = BCRYPT_FLAGS(2u32);
pub const BCRYPT_PAD_PKCS1_OPTIONAL_HASH_OID: u32 = 16u32;
pub const BCRYPT_PAD_PSS: BCRYPT_FLAGS = BCRYPT_FLAGS(8u32);
pub const BCRYPT_PBKDF2_ALGORITHM: windows_core::PCWSTR = windows_core::w!("PBKDF2");
pub const BCRYPT_PBKDF2_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(817u32 as _);
pub const BCRYPT_PCP_PLATFORM_TYPE_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_PLATFORM_TYPE");
pub const BCRYPT_PCP_PROVIDER_VERSION_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_PROVIDER_VERSION");
pub const BCRYPT_PRIMITIVE_TYPE: windows_core::PCWSTR = windows_core::w!("PrimitiveType");
pub const BCRYPT_PRIVATE_KEY: windows_core::PCWSTR = windows_core::w!("PrivKeyVal");
pub const BCRYPT_PRIVATE_KEY_BLOB: windows_core::PCWSTR = windows_core::w!("PRIVATEBLOB");
pub const BCRYPT_PRIVATE_KEY_FLAG: u32 = 2u32;
pub const BCRYPT_PROVIDER_HANDLE: windows_core::PCWSTR = windows_core::w!("ProviderHandle");
pub const BCRYPT_PROV_DISPATCH: BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS = BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS(1u32);
pub const BCRYPT_PUBLIC_KEY_BLOB: windows_core::PCWSTR = windows_core::w!("PUBLICBLOB");
pub const BCRYPT_PUBLIC_KEY_FLAG: u32 = 1u32;
pub const BCRYPT_PUBLIC_KEY_LENGTH: windows_core::PCWSTR = windows_core::w!("PublicKeyLength");
pub const BCRYPT_RC2_ALGORITHM: windows_core::PCWSTR = windows_core::w!("RC2");
pub const BCRYPT_RC2_CBC_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(593u32 as _);
pub const BCRYPT_RC2_CFB_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(625u32 as _);
pub const BCRYPT_RC2_ECB_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(609u32 as _);
pub const BCRYPT_RC4_ALGORITHM: windows_core::PCWSTR = windows_core::w!("RC4");
pub const BCRYPT_RC4_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(113u32 as _);
pub const BCRYPT_RNG_ALGORITHM: windows_core::PCWSTR = windows_core::w!("RNG");
pub const BCRYPT_RNG_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(129u32 as _);
pub const BCRYPT_RNG_DUAL_EC_ALGORITHM: windows_core::PCWSTR = windows_core::w!("DUALECRNG");
pub const BCRYPT_RNG_FIPS186_DSA_ALGORITHM: windows_core::PCWSTR = windows_core::w!("FIPS186DSARNG");
pub const BCRYPT_RNG_INTERFACE: BCRYPT_INTERFACE = BCRYPT_INTERFACE(6u32);
pub const BCRYPT_RNG_OPERATION: BCRYPT_OPERATION = BCRYPT_OPERATION(32u32);
pub const BCRYPT_RNG_USE_ENTROPY_IN_BUFFER: BCRYPTGENRANDOM_FLAGS = BCRYPTGENRANDOM_FLAGS(1u32);
pub const BCRYPT_RSAFULLPRIVATE_BLOB: windows_core::PCWSTR = windows_core::w!("RSAFULLPRIVATEBLOB");
pub const BCRYPT_RSAFULLPRIVATE_MAGIC: BCRYPT_RSAKEY_BLOB_MAGIC = BCRYPT_RSAKEY_BLOB_MAGIC(859919186u32);
pub const BCRYPT_RSAPRIVATE_BLOB: windows_core::PCWSTR = windows_core::w!("RSAPRIVATEBLOB");
pub const BCRYPT_RSAPRIVATE_MAGIC: BCRYPT_RSAKEY_BLOB_MAGIC = BCRYPT_RSAKEY_BLOB_MAGIC(843141970u32);
pub const BCRYPT_RSAPUBLIC_BLOB: windows_core::PCWSTR = windows_core::w!("RSAPUBLICBLOB");
pub const BCRYPT_RSAPUBLIC_MAGIC: BCRYPT_RSAKEY_BLOB_MAGIC = BCRYPT_RSAKEY_BLOB_MAGIC(826364754u32);
pub const BCRYPT_RSA_ALGORITHM: windows_core::PCWSTR = windows_core::w!("RSA");
pub const BCRYPT_RSA_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(225u32 as _);
pub const BCRYPT_RSA_SIGN_ALGORITHM: windows_core::PCWSTR = windows_core::w!("RSA_SIGN");
pub const BCRYPT_RSA_SIGN_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(785u32 as _);
pub const BCRYPT_SECRET_AGREEMENT_INTERFACE: BCRYPT_INTERFACE = BCRYPT_INTERFACE(4u32);
pub const BCRYPT_SECRET_AGREEMENT_OPERATION: BCRYPT_OPERATION = BCRYPT_OPERATION(8u32);
pub const BCRYPT_SHA1_ALGORITHM: windows_core::PCWSTR = windows_core::w!("SHA1");
pub const BCRYPT_SHA1_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(49u32 as _);
pub const BCRYPT_SHA256_ALGORITHM: windows_core::PCWSTR = windows_core::w!("SHA256");
pub const BCRYPT_SHA256_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(65u32 as _);
pub const BCRYPT_SHA384_ALGORITHM: windows_core::PCWSTR = windows_core::w!("SHA384");
pub const BCRYPT_SHA384_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(81u32 as _);
pub const BCRYPT_SHA512_ALGORITHM: windows_core::PCWSTR = windows_core::w!("SHA512");
pub const BCRYPT_SHA512_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(97u32 as _);
pub const BCRYPT_SIGNATURE_INTERFACE: BCRYPT_INTERFACE = BCRYPT_INTERFACE(5u32);
pub const BCRYPT_SIGNATURE_LENGTH: windows_core::PCWSTR = windows_core::w!("SignatureLength");
pub const BCRYPT_SIGNATURE_OPERATION: BCRYPT_OPERATION = BCRYPT_OPERATION(16u32);
pub const BCRYPT_SP800108_CTR_HMAC_ALGORITHM: windows_core::PCWSTR = windows_core::w!("SP800_108_CTR_HMAC");
pub const BCRYPT_SP800108_CTR_HMAC_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(833u32 as _);
pub const BCRYPT_SP80056A_CONCAT_ALGORITHM: windows_core::PCWSTR = windows_core::w!("SP800_56A_CONCAT");
pub const BCRYPT_SP80056A_CONCAT_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(849u32 as _);
pub const BCRYPT_SUPPORTED_PAD_OAEP: u32 = 8u32;
pub const BCRYPT_SUPPORTED_PAD_PKCS1_ENC: u32 = 2u32;
pub const BCRYPT_SUPPORTED_PAD_PKCS1_SIG: u32 = 4u32;
pub const BCRYPT_SUPPORTED_PAD_PSS: u32 = 16u32;
pub const BCRYPT_SUPPORTED_PAD_ROUTER: u32 = 1u32;
pub const BCRYPT_TLS1_1_KDF_ALGORITHM: windows_core::PCWSTR = windows_core::w!("TLS1_1_KDF");
pub const BCRYPT_TLS1_1_KDF_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(865u32 as _);
pub const BCRYPT_TLS1_2_KDF_ALGORITHM: windows_core::PCWSTR = windows_core::w!("TLS1_2_KDF");
pub const BCRYPT_TLS1_2_KDF_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(881u32 as _);
pub const BCRYPT_TLS_CBC_HMAC_VERIFY_FLAG: u32 = 4u32;
pub const BCRYPT_USE_SYSTEM_PREFERRED_RNG: BCRYPTGENRANDOM_FLAGS = BCRYPTGENRANDOM_FLAGS(2u32);
pub const BCRYPT_XTS_AES_ALGORITHM: windows_core::PCWSTR = windows_core::w!("XTS-AES");
pub const BCRYPT_XTS_AES_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(897u32 as _);
pub const CALG_3DES: ALG_ID = ALG_ID(26115u32);
pub const CALG_3DES_112: ALG_ID = ALG_ID(26121u32);
pub const CALG_AES: ALG_ID = ALG_ID(26129u32);
pub const CALG_AES_128: ALG_ID = ALG_ID(26126u32);
pub const CALG_AES_192: ALG_ID = ALG_ID(26127u32);
pub const CALG_AES_256: ALG_ID = ALG_ID(26128u32);
pub const CALG_AGREEDKEY_ANY: ALG_ID = ALG_ID(43523u32);
pub const CALG_CYLINK_MEK: ALG_ID = ALG_ID(26124u32);
pub const CALG_DES: ALG_ID = ALG_ID(26113u32);
pub const CALG_DESX: ALG_ID = ALG_ID(26116u32);
pub const CALG_DH_EPHEM: ALG_ID = ALG_ID(43522u32);
pub const CALG_DH_SF: ALG_ID = ALG_ID(43521u32);
pub const CALG_DSS_SIGN: ALG_ID = ALG_ID(8704u32);
pub const CALG_ECDH: ALG_ID = ALG_ID(43525u32);
pub const CALG_ECDH_EPHEM: ALG_ID = ALG_ID(44550u32);
pub const CALG_ECDSA: ALG_ID = ALG_ID(8707u32);
pub const CALG_ECMQV: ALG_ID = ALG_ID(40961u32);
pub const CALG_HASH_REPLACE_OWF: ALG_ID = ALG_ID(32779u32);
pub const CALG_HMAC: ALG_ID = ALG_ID(32777u32);
pub const CALG_HUGHES_MD5: ALG_ID = ALG_ID(40963u32);
pub const CALG_KEA_KEYX: ALG_ID = ALG_ID(43524u32);
pub const CALG_MAC: ALG_ID = ALG_ID(32773u32);
pub const CALG_MD2: ALG_ID = ALG_ID(32769u32);
pub const CALG_MD4: ALG_ID = ALG_ID(32770u32);
pub const CALG_MD5: ALG_ID = ALG_ID(32771u32);
pub const CALG_NO_SIGN: ALG_ID = ALG_ID(8192u32);
pub const CALG_NULLCIPHER: ALG_ID = ALG_ID(24576u32);
pub const CALG_OID_INFO_CNG_ONLY: u32 = 4294967295u32;
pub const CALG_OID_INFO_PARAMETERS: u32 = 4294967294u32;
pub const CALG_PCT1_MASTER: ALG_ID = ALG_ID(19460u32);
pub const CALG_RC2: ALG_ID = ALG_ID(26114u32);
pub const CALG_RC4: ALG_ID = ALG_ID(26625u32);
pub const CALG_RC5: ALG_ID = ALG_ID(26125u32);
pub const CALG_RSA_KEYX: ALG_ID = ALG_ID(41984u32);
pub const CALG_RSA_SIGN: ALG_ID = ALG_ID(9216u32);
pub const CALG_SCHANNEL_ENC_KEY: ALG_ID = ALG_ID(19463u32);
pub const CALG_SCHANNEL_MAC_KEY: ALG_ID = ALG_ID(19459u32);
pub const CALG_SCHANNEL_MASTER_HASH: ALG_ID = ALG_ID(19458u32);
pub const CALG_SEAL: ALG_ID = ALG_ID(26626u32);
pub const CALG_SHA: ALG_ID = ALG_ID(32772u32);
pub const CALG_SHA1: ALG_ID = ALG_ID(32772u32);
pub const CALG_SHA_256: ALG_ID = ALG_ID(32780u32);
pub const CALG_SHA_384: ALG_ID = ALG_ID(32781u32);
pub const CALG_SHA_512: ALG_ID = ALG_ID(32782u32);
pub const CALG_SKIPJACK: ALG_ID = ALG_ID(26122u32);
pub const CALG_SSL2_MASTER: ALG_ID = ALG_ID(19461u32);
pub const CALG_SSL3_MASTER: ALG_ID = ALG_ID(19457u32);
pub const CALG_SSL3_SHAMD5: ALG_ID = ALG_ID(32776u32);
pub const CALG_TEK: ALG_ID = ALG_ID(26123u32);
pub const CALG_THIRDPARTY_CIPHER: ALG_ID = ALG_ID(28672u32);
pub const CALG_THIRDPARTY_HASH: ALG_ID = ALG_ID(36864u32);
pub const CALG_THIRDPARTY_KEY_EXCHANGE: ALG_ID = ALG_ID(45056u32);
pub const CALG_THIRDPARTY_SIGNATURE: ALG_ID = ALG_ID(12288u32);
pub const CALG_TLS1PRF: ALG_ID = ALG_ID(32778u32);
pub const CALG_TLS1_MASTER: ALG_ID = ALG_ID(19462u32);
pub const CERT_ACCESS_STATE_GP_SYSTEM_STORE_FLAG: u32 = 8u32;
pub const CERT_ACCESS_STATE_LM_SYSTEM_STORE_FLAG: u32 = 4u32;
pub const CERT_ACCESS_STATE_PROP_ID: u32 = 14u32;
pub const CERT_ACCESS_STATE_SHARED_USER_FLAG: u32 = 16u32;
pub const CERT_ACCESS_STATE_SYSTEM_STORE_FLAG: u32 = 2u32;
pub const CERT_ACCESS_STATE_WRITE_PERSIST_FLAG: u32 = 1u32;
pub const CERT_AIA_URL_RETRIEVED_PROP_ID: u32 = 67u32;
pub const CERT_ALT_NAME_EDI_PARTY_NAME: u32 = 6u32;
pub const CERT_ALT_NAME_ENTRY_ERR_INDEX_MASK: u32 = 255u32;
pub const CERT_ALT_NAME_ENTRY_ERR_INDEX_SHIFT: u32 = 16u32;
pub const CERT_ALT_NAME_VALUE_ERR_INDEX_MASK: u32 = 65535u32;
pub const CERT_ALT_NAME_VALUE_ERR_INDEX_SHIFT: u32 = 0u32;
pub const CERT_ALT_NAME_X400_ADDRESS: u32 = 4u32;
pub const CERT_ARCHIVED_KEY_HASH_PROP_ID: u32 = 65u32;
pub const CERT_ARCHIVED_PROP_ID: u32 = 19u32;
pub const CERT_AUTHORITY_INFO_ACCESS_PROP_ID: u32 = 68u32;
pub const CERT_AUTH_ROOT_AUTO_UPDATE_DISABLE_PARTIAL_CHAIN_LOGGING_FLAG: u32 = 2u32;
pub const CERT_AUTH_ROOT_AUTO_UPDATE_DISABLE_UNTRUSTED_ROOT_LOGGING_FLAG: u32 = 1u32;
pub const CERT_AUTH_ROOT_AUTO_UPDATE_ENCODED_CTL_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("EncodedCtl");
pub const CERT_AUTH_ROOT_AUTO_UPDATE_FLAGS_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("Flags");
pub const CERT_AUTH_ROOT_AUTO_UPDATE_LAST_SYNC_TIME_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("LastSyncTime");
pub const CERT_AUTH_ROOT_AUTO_UPDATE_ROOT_DIR_URL_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("RootDirUrl");
pub const CERT_AUTH_ROOT_AUTO_UPDATE_SYNC_DELTA_TIME_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("SyncDeltaTime");
pub const CERT_AUTH_ROOT_CAB_FILENAME: windows_core::PCWSTR = windows_core::w!("authrootstl.cab");
pub const CERT_AUTH_ROOT_CERT_EXT: windows_core::PCWSTR = windows_core::w!(".crt");
pub const CERT_AUTH_ROOT_CTL_FILENAME: windows_core::PCWSTR = windows_core::w!("authroot.stl");
pub const CERT_AUTH_ROOT_CTL_FILENAME_A: windows_core::PCSTR = windows_core::s!("authroot.stl");
pub const CERT_AUTH_ROOT_SEQ_FILENAME: windows_core::PCWSTR = windows_core::w!("authrootseq.txt");
pub const CERT_AUTH_ROOT_SHA256_HASH_PROP_ID: u32 = 98u32;
pub const CERT_AUTO_ENROLL_PROP_ID: u32 = 21u32;
pub const CERT_AUTO_ENROLL_RETRY_PROP_ID: u32 = 66u32;
pub const CERT_AUTO_UPDATE_DISABLE_RANDOM_QUERY_STRING_FLAG: u32 = 4u32;
pub const CERT_AUTO_UPDATE_ROOT_DIR_URL_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("RootDirUrl");
pub const CERT_AUTO_UPDATE_SYNC_FROM_DIR_URL_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("SyncFromDirUrl");
pub const CERT_BACKED_UP_PROP_ID: u32 = 69u32;
pub const CERT_BIOMETRIC_OID_DATA_CHOICE: CERT_BIOMETRIC_DATA_TYPE = CERT_BIOMETRIC_DATA_TYPE(2u32);
pub const CERT_BIOMETRIC_PICTURE_TYPE: u32 = 0u32;
pub const CERT_BIOMETRIC_PREDEFINED_DATA_CHOICE: CERT_BIOMETRIC_DATA_TYPE = CERT_BIOMETRIC_DATA_TYPE(1u32);
pub const CERT_BIOMETRIC_SIGNATURE_TYPE: u32 = 1u32;
pub const CERT_BUNDLE_CERTIFICATE: u32 = 0u32;
pub const CERT_BUNDLE_CRL: u32 = 1u32;
pub const CERT_CASE_INSENSITIVE_IS_RDN_ATTRS_FLAG: u32 = 2u32;
pub const CERT_CA_DISABLE_CRL_PROP_ID: u32 = 82u32;
pub const CERT_CA_OCSP_AUTHORITY_INFO_ACCESS_PROP_ID: u32 = 81u32;
pub const CERT_CA_SUBJECT_FLAG: u32 = 128u32;
pub const CERT_CEP_PROP_ID: u32 = 87u32;
pub const CERT_CHAIN_AUTO_CURRENT_USER: u32 = 1u32;
pub const CERT_CHAIN_AUTO_FLAGS_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("AutoFlags");
pub const CERT_CHAIN_AUTO_FLUSH_DISABLE_FLAG: u32 = 1u32;
pub const CERT_CHAIN_AUTO_FLUSH_FIRST_DELTA_SECONDS_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("AutoFlushFirstDeltaSeconds");
pub const CERT_CHAIN_AUTO_FLUSH_NEXT_DELTA_SECONDS_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("AutoFlushNextDeltaSeconds");
pub const CERT_CHAIN_AUTO_HPKP_RULE_INFO: u32 = 8u32;
pub const CERT_CHAIN_AUTO_IMPERSONATED: u32 = 3u32;
pub const CERT_CHAIN_AUTO_LOCAL_MACHINE: u32 = 2u32;
pub const CERT_CHAIN_AUTO_LOG_CREATE_FLAG: u32 = 2u32;
pub const CERT_CHAIN_AUTO_LOG_FILE_NAME_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("AutoLogFileName");
pub const CERT_CHAIN_AUTO_LOG_FLUSH_FLAG: u32 = 8u32;
pub const CERT_CHAIN_AUTO_LOG_FREE_FLAG: u32 = 4u32;
pub const CERT_CHAIN_AUTO_NETWORK_INFO: u32 = 6u32;
pub const CERT_CHAIN_AUTO_PINRULE_INFO: u32 = 5u32;
pub const CERT_CHAIN_AUTO_PROCESS_INFO: u32 = 4u32;
pub const CERT_CHAIN_AUTO_SERIAL_LOCAL_MACHINE: u32 = 7u32;
pub const CERT_CHAIN_CACHE_END_CERT: u32 = 1u32;
pub const CERT_CHAIN_CACHE_ONLY_URL_RETRIEVAL: u32 = 4u32;
pub const CERT_CHAIN_CACHE_RESYNC_FILETIME_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("ChainCacheResyncFiletime");
pub const CERT_CHAIN_CONFIG_REGPATH: windows_core::PCWSTR = windows_core::w!("Software\\Microsoft\\Cryptography\\OID\\EncodingType 0\\CertDllCreateCertificateChainEngine\\Config");
pub const CERT_CHAIN_CRL_VALIDITY_EXT_PERIOD_HOURS_DEFAULT: u32 = 12u32;
pub const CERT_CHAIN_CRL_VALIDITY_EXT_PERIOD_HOURS_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("CRLValidityExtensionPeriod");
pub const CERT_CHAIN_CROSS_CERT_DOWNLOAD_INTERVAL_HOURS_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("CrossCertDownloadIntervalHours");
pub const CERT_CHAIN_DEFAULT_CONFIG_SUBDIR: windows_core::PCWSTR = windows_core::w!("Default");
pub const CERT_CHAIN_DISABLE_AIA: u32 = 8192u32;
pub const CERT_CHAIN_DISABLE_AIA_URL_RETRIEVAL_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("DisableAIAUrlRetrieval");
pub const CERT_CHAIN_DISABLE_ALL_EKU_WEAK_FLAG: u32 = 65536u32;
pub const CERT_CHAIN_DISABLE_AUTH_ROOT_AUTO_UPDATE: u32 = 256u32;
pub const CERT_CHAIN_DISABLE_AUTO_FLUSH_PROCESS_NAME_LIST_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("DisableAutoFlushProcessNameList");
pub const CERT_CHAIN_DISABLE_CA_NAME_CONSTRAINTS_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("DisableCANameConstraints");
pub const CERT_CHAIN_DISABLE_CODE_SIGNING_WEAK_FLAG: u32 = 4194304u32;
pub const CERT_CHAIN_DISABLE_ECC_PARA_FLAG: u32 = 16u32;
pub const CERT_CHAIN_DISABLE_FILE_HASH_WEAK_FLAG: u32 = 4096u32;
pub const CERT_CHAIN_DISABLE_MANDATORY_BASIC_CONSTRAINTS_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("DisableMandatoryBasicConstraints");
pub const CERT_CHAIN_DISABLE_MD2_MD4: u32 = 4096u32;
pub const CERT_CHAIN_DISABLE_MOTW_CODE_SIGNING_WEAK_FLAG: u32 = 8388608u32;
pub const CERT_CHAIN_DISABLE_MOTW_FILE_HASH_WEAK_FLAG: u32 = 8192u32;
pub const CERT_CHAIN_DISABLE_MOTW_TIMESTAMP_HASH_WEAK_FLAG: u32 = 32768u32;
pub const CERT_CHAIN_DISABLE_MOTW_TIMESTAMP_WEAK_FLAG: u32 = 134217728u32;
pub const CERT_CHAIN_DISABLE_MY_PEER_TRUST: u32 = 2048u32;
pub const CERT_CHAIN_DISABLE_OPT_IN_SERVER_AUTH_WEAK_FLAG: u32 = 262144u32;
pub const CERT_CHAIN_DISABLE_PASS1_QUALITY_FILTERING: u32 = 64u32;
pub const CERT_CHAIN_DISABLE_SERIAL_CHAIN_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("DisableSerialChain");
pub const CERT_CHAIN_DISABLE_SERVER_AUTH_WEAK_FLAG: u32 = 1048576u32;
pub const CERT_CHAIN_DISABLE_SYNC_WITH_SSL_TIME_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("DisableSyncWithSslTime");
pub const CERT_CHAIN_DISABLE_TIMESTAMP_HASH_WEAK_FLAG: u32 = 16384u32;
pub const CERT_CHAIN_DISABLE_TIMESTAMP_WEAK_FLAG: u32 = 67108864u32;
pub const CERT_CHAIN_DISABLE_UNSUPPORTED_CRITICAL_EXTENSIONS_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("DisableUnsupportedCriticalExtensions");
pub const CERT_CHAIN_ENABLE_ALL_EKU_HYGIENE_FLAG: u32 = 131072u32;
pub const CERT_CHAIN_ENABLE_CACHE_AUTO_UPDATE: u32 = 16u32;
pub const CERT_CHAIN_ENABLE_CODE_SIGNING_HYGIENE_FLAG: u32 = 16777216u32;
pub const CERT_CHAIN_ENABLE_DISALLOWED_CA: u32 = 131072u32;
pub const CERT_CHAIN_ENABLE_MD2_MD4_FLAG: u32 = 1u32;
pub const CERT_CHAIN_ENABLE_MOTW_CODE_SIGNING_HYGIENE_FLAG: u32 = 33554432u32;
pub const CERT_CHAIN_ENABLE_MOTW_TIMESTAMP_HYGIENE_FLAG: u32 = 536870912u32;
pub const CERT_CHAIN_ENABLE_ONLY_WEAK_LOGGING_FLAG: u32 = 8u32;
pub const CERT_CHAIN_ENABLE_PEER_TRUST: u32 = 1024u32;
pub const CERT_CHAIN_ENABLE_SERVER_AUTH_HYGIENE_FLAG: u32 = 2097152u32;
pub const CERT_CHAIN_ENABLE_SHARE_STORE: u32 = 32u32;
pub const CERT_CHAIN_ENABLE_TIMESTAMP_HYGIENE_FLAG: u32 = 268435456u32;
pub const CERT_CHAIN_ENABLE_WEAK_LOGGING_FLAG: u32 = 4u32;
pub const CERT_CHAIN_ENABLE_WEAK_RSA_ROOT_FLAG: u32 = 2u32;
pub const CERT_CHAIN_ENABLE_WEAK_SETTINGS_FLAG: u32 = 2147483648u32;
pub const CERT_CHAIN_ENABLE_WEAK_SIGNATURE_FLAGS_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("EnableWeakSignatureFlags");
pub const CERT_CHAIN_EXCLUSIVE_ENABLE_CA_FLAG: u32 = 1u32;
pub const CERT_CHAIN_FIND_BY_ISSUER: u32 = 1u32;
pub const CERT_CHAIN_FIND_BY_ISSUER_CACHE_ONLY_FLAG: CERT_FIND_CHAIN_IN_STORE_FLAGS = CERT_FIND_CHAIN_IN_STORE_FLAGS(32768u32);
pub const CERT_CHAIN_FIND_BY_ISSUER_CACHE_ONLY_URL_FLAG: CERT_FIND_CHAIN_IN_STORE_FLAGS = CERT_FIND_CHAIN_IN_STORE_FLAGS(4u32);
pub const CERT_CHAIN_FIND_BY_ISSUER_COMPARE_KEY_FLAG: CERT_FIND_CHAIN_IN_STORE_FLAGS = CERT_FIND_CHAIN_IN_STORE_FLAGS(1u32);
pub const CERT_CHAIN_FIND_BY_ISSUER_COMPLEX_CHAIN_FLAG: CERT_FIND_CHAIN_IN_STORE_FLAGS = CERT_FIND_CHAIN_IN_STORE_FLAGS(2u32);
pub const CERT_CHAIN_FIND_BY_ISSUER_LOCAL_MACHINE_FLAG: CERT_FIND_CHAIN_IN_STORE_FLAGS = CERT_FIND_CHAIN_IN_STORE_FLAGS(8u32);
pub const CERT_CHAIN_FIND_BY_ISSUER_NO_KEY_FLAG: CERT_FIND_CHAIN_IN_STORE_FLAGS = CERT_FIND_CHAIN_IN_STORE_FLAGS(16384u32);
pub const CERT_CHAIN_HAS_MOTW: u32 = 16384u32;
pub const CERT_CHAIN_MAX_AIA_URL_COUNT_IN_CERT_DEFAULT: u32 = 5u32;
pub const CERT_CHAIN_MAX_AIA_URL_COUNT_IN_CERT_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("MaxAIAUrlCountInCert");
pub const CERT_CHAIN_MAX_AIA_URL_RETRIEVAL_BYTE_COUNT_DEFAULT: u32 = 100000u32;
pub const CERT_CHAIN_MAX_AIA_URL_RETRIEVAL_BYTE_COUNT_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("MaxAIAUrlRetrievalByteCount");
pub const CERT_CHAIN_MAX_AIA_URL_RETRIEVAL_CERT_COUNT_DEFAULT: u32 = 10u32;
pub const CERT_CHAIN_MAX_AIA_URL_RETRIEVAL_CERT_COUNT_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("MaxAIAUrlRetrievalCertCount");
pub const CERT_CHAIN_MAX_AIA_URL_RETRIEVAL_COUNT_PER_CHAIN_DEFAULT: u32 = 3u32;
pub const CERT_CHAIN_MAX_AIA_URL_RETRIEVAL_COUNT_PER_CHAIN_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("MaxAIAUrlRetrievalCountPerChain");
pub const CERT_CHAIN_MAX_SSL_TIME_UPDATED_EVENT_COUNT_DEFAULT: u32 = 5u32;
pub const CERT_CHAIN_MAX_SSL_TIME_UPDATED_EVENT_COUNT_DISABLE: u32 = 4294967295u32;
pub const CERT_CHAIN_MAX_SSL_TIME_UPDATED_EVENT_COUNT_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("MaxSslTimeUpdatedEventCount");
pub const CERT_CHAIN_MAX_URL_RETRIEVAL_BYTE_COUNT_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("MaxUrlRetrievalByteCount");
pub const CERT_CHAIN_MIN_PUB_KEY_BIT_LENGTH_DISABLE: u32 = 4294967295u32;
pub const CERT_CHAIN_MIN_RSA_PUB_KEY_BIT_LENGTH_DEFAULT: u32 = 1023u32;
pub const CERT_CHAIN_MIN_RSA_PUB_KEY_BIT_LENGTH_DISABLE: u32 = 4294967295u32;
pub const CERT_CHAIN_MIN_RSA_PUB_KEY_BIT_LENGTH_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("MinRsaPubKeyBitLength");
pub const CERT_CHAIN_MOTW_IGNORE_AFTER_TIME_WEAK_FLAG: u32 = 1073741824u32;
pub const CERT_CHAIN_OCSP_VALIDITY_SECONDS_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("OcspValiditySeconds");
pub const CERT_CHAIN_ONLY_ADDITIONAL_AND_AUTH_ROOT: u32 = 32768u32;
pub const CERT_CHAIN_OPTIONS_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("Options");
pub const CERT_CHAIN_OPTION_DISABLE_AIA_URL_RETRIEVAL: u32 = 2u32;
pub const CERT_CHAIN_OPTION_ENABLE_SIA_URL_RETRIEVAL: u32 = 4u32;
pub const CERT_CHAIN_OPT_IN_WEAK_FLAGS: u32 = 262144u32;
pub const CERT_CHAIN_OPT_IN_WEAK_SIGNATURE: u32 = 65536u32;
pub const CERT_CHAIN_POLICY_ALLOW_TESTROOT_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(32768u32);
pub const CERT_CHAIN_POLICY_ALLOW_UNKNOWN_CA_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(16u32);
pub const CERT_CHAIN_POLICY_AUTHENTICODE: windows_core::PCSTR = windows_core::PCSTR(2i32 as _);
pub const CERT_CHAIN_POLICY_AUTHENTICODE_TS: windows_core::PCSTR = windows_core::PCSTR(3i32 as _);
pub const CERT_CHAIN_POLICY_BASE: windows_core::PCSTR = windows_core::PCSTR(1i32 as _);
pub const CERT_CHAIN_POLICY_BASIC_CONSTRAINTS: windows_core::PCSTR = windows_core::PCSTR(5i32 as _);
pub const CERT_CHAIN_POLICY_EV: windows_core::PCSTR = windows_core::PCSTR(8i32 as _);
pub const CERT_CHAIN_POLICY_IGNORE_ALL_NOT_TIME_VALID_FLAGS: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(7u32);
pub const CERT_CHAIN_POLICY_IGNORE_ALL_REV_UNKNOWN_FLAGS: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(3840u32);
pub const CERT_CHAIN_POLICY_IGNORE_CA_REV_UNKNOWN_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(1024u32);
pub const CERT_CHAIN_POLICY_IGNORE_CTL_NOT_TIME_VALID_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(2u32);
pub const CERT_CHAIN_POLICY_IGNORE_CTL_SIGNER_REV_UNKNOWN_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(512u32);
pub const CERT_CHAIN_POLICY_IGNORE_END_REV_UNKNOWN_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(256u32);
pub const CERT_CHAIN_POLICY_IGNORE_INVALID_BASIC_CONSTRAINTS_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(8u32);
pub const CERT_CHAIN_POLICY_IGNORE_INVALID_NAME_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(64u32);
pub const CERT_CHAIN_POLICY_IGNORE_INVALID_POLICY_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(128u32);
pub const CERT_CHAIN_POLICY_IGNORE_NOT_SUPPORTED_CRITICAL_EXT_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(8192u32);
pub const CERT_CHAIN_POLICY_IGNORE_NOT_TIME_NESTED_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(4u32);
pub const CERT_CHAIN_POLICY_IGNORE_NOT_TIME_VALID_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(1u32);
pub const CERT_CHAIN_POLICY_IGNORE_PEER_TRUST_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(4096u32);
pub const CERT_CHAIN_POLICY_IGNORE_ROOT_REV_UNKNOWN_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(2048u32);
pub const CERT_CHAIN_POLICY_IGNORE_WEAK_SIGNATURE_FLAG: u32 = 134217728u32;
pub const CERT_CHAIN_POLICY_IGNORE_WRONG_USAGE_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(32u32);
pub const CERT_CHAIN_POLICY_MICROSOFT_ROOT: windows_core::PCSTR = windows_core::PCSTR(7i32 as _);
pub const CERT_CHAIN_POLICY_NT_AUTH: windows_core::PCSTR = windows_core::PCSTR(6i32 as _);
pub const CERT_CHAIN_POLICY_SSL: windows_core::PCSTR = windows_core::PCSTR(4i32 as _);
pub const CERT_CHAIN_POLICY_SSL_F12: windows_core::PCSTR = windows_core::PCSTR(9i32 as _);
pub const CERT_CHAIN_POLICY_SSL_F12_ERROR_LEVEL: u32 = 2u32;
pub const CERT_CHAIN_POLICY_SSL_F12_NONE_CATEGORY: u32 = 0u32;
pub const CERT_CHAIN_POLICY_SSL_F12_ROOT_PROGRAM_CATEGORY: u32 = 2u32;
pub const CERT_CHAIN_POLICY_SSL_F12_SUCCESS_LEVEL: u32 = 0u32;
pub const CERT_CHAIN_POLICY_SSL_F12_WARNING_LEVEL: u32 = 1u32;
pub const CERT_CHAIN_POLICY_SSL_F12_WEAK_CRYPTO_CATEGORY: u32 = 1u32;
pub const CERT_CHAIN_POLICY_SSL_HPKP_HEADER: windows_core::PCSTR = windows_core::PCSTR(10i32 as _);
pub const CERT_CHAIN_POLICY_SSL_KEY_PIN: windows_core::PCSTR = windows_core::PCSTR(12i32 as _);
pub const CERT_CHAIN_POLICY_SSL_KEY_PIN_MISMATCH_ERROR: i32 = -2i32;
pub const CERT_CHAIN_POLICY_SSL_KEY_PIN_MISMATCH_WARNING: u32 = 2u32;
pub const CERT_CHAIN_POLICY_SSL_KEY_PIN_MITM_ERROR: i32 = -1i32;
pub const CERT_CHAIN_POLICY_SSL_KEY_PIN_MITM_WARNING: u32 = 1u32;
pub const CERT_CHAIN_POLICY_SSL_KEY_PIN_SUCCESS: u32 = 0u32;
pub const CERT_CHAIN_POLICY_THIRD_PARTY_ROOT: windows_core::PCSTR = windows_core::PCSTR(11i32 as _);
pub const CERT_CHAIN_POLICY_TRUST_TESTROOT_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(16384u32);
pub const CERT_CHAIN_RETURN_LOWER_QUALITY_CONTEXTS: u32 = 128u32;
pub const CERT_CHAIN_REVOCATION_ACCUMULATIVE_TIMEOUT: u32 = 134217728u32;
pub const CERT_CHAIN_REVOCATION_CHECK_CACHE_ONLY: u32 = 2147483648u32;
pub const CERT_CHAIN_REVOCATION_CHECK_CHAIN: u32 = 536870912u32;
pub const CERT_CHAIN_REVOCATION_CHECK_CHAIN_EXCLUDE_ROOT: u32 = 1073741824u32;
pub const CERT_CHAIN_REVOCATION_CHECK_END_CERT: u32 = 268435456u32;
pub const CERT_CHAIN_REVOCATION_CHECK_OCSP_CERT: u32 = 67108864u32;
pub const CERT_CHAIN_REV_ACCUMULATIVE_URL_RETRIEVAL_TIMEOUT_MILLISECONDS_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("ChainRevAccumulativeUrlRetrievalTimeoutMilliseconds");
pub const CERT_CHAIN_SERIAL_CHAIN_LOG_FILE_NAME_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("SerialChainLogFileName");
pub const CERT_CHAIN_SSL_HANDSHAKE_LOG_FILE_NAME_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("SslHandshakeLogFileName");
pub const CERT_CHAIN_STRONG_SIGN_DISABLE_END_CHECK_FLAG: u32 = 1u32;
pub const CERT_CHAIN_THREAD_STORE_SYNC: u32 = 2u32;
pub const CERT_CHAIN_TIMESTAMP_TIME: u32 = 512u32;
pub const CERT_CHAIN_URL_RETRIEVAL_TIMEOUT_MILLISECONDS_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("ChainUrlRetrievalTimeoutMilliseconds");
pub const CERT_CHAIN_USE_LOCAL_MACHINE_STORE: u32 = 8u32;
pub const CERT_CHAIN_WEAK_AFTER_TIME_NAME: windows_core::PCWSTR = windows_core::w!("AfterTime");
pub const CERT_CHAIN_WEAK_ALL_CONFIG_NAME: windows_core::PCWSTR = windows_core::w!("All");
pub const CERT_CHAIN_WEAK_FILE_HASH_AFTER_TIME_NAME: windows_core::PCWSTR = windows_core::w!("FileHashAfterTime");
pub const CERT_CHAIN_WEAK_FLAGS_NAME: windows_core::PCWSTR = windows_core::w!("Flags");
pub const CERT_CHAIN_WEAK_HYGIENE_NAME: windows_core::PCWSTR = windows_core::w!("Hygiene");
pub const CERT_CHAIN_WEAK_MIN_BIT_LENGTH_NAME: windows_core::PCWSTR = windows_core::w!("MinBitLength");
pub const CERT_CHAIN_WEAK_PREFIX_NAME: windows_core::PCWSTR = windows_core::w!("Weak");
pub const CERT_CHAIN_WEAK_RSA_PUB_KEY_TIME_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("WeakRsaPubKeyTime");
pub const CERT_CHAIN_WEAK_SHA256_ALLOW_NAME: windows_core::PCWSTR = windows_core::w!("Sha256Allow");
pub const CERT_CHAIN_WEAK_SIGNATURE_LOG_DIR_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("WeakSignatureLogDir");
pub const CERT_CHAIN_WEAK_THIRD_PARTY_CONFIG_NAME: windows_core::PCWSTR = windows_core::w!("ThirdParty");
pub const CERT_CHAIN_WEAK_TIMESTAMP_HASH_AFTER_TIME_NAME: windows_core::PCWSTR = windows_core::w!("TimestampHashAfterTime");
pub const CERT_CLOSE_STORE_CHECK_FLAG: u32 = 2u32;
pub const CERT_CLOSE_STORE_FORCE_FLAG: u32 = 1u32;
pub const CERT_CLR_DELETE_KEY_PROP_ID: u32 = 125u32;
pub const CERT_COMPARE_ANY: u32 = 0u32;
pub const CERT_COMPARE_ATTR: u32 = 3u32;
pub const CERT_COMPARE_CERT_ID: u32 = 16u32;
pub const CERT_COMPARE_CROSS_CERT_DIST_POINTS: u32 = 17u32;
pub const CERT_COMPARE_CTL_USAGE: u32 = 10u32;
pub const CERT_COMPARE_ENHKEY_USAGE: u32 = 10u32;
pub const CERT_COMPARE_EXISTING: u32 = 13u32;
pub const CERT_COMPARE_HASH: u32 = 1u32;
pub const CERT_COMPARE_HASH_STR: u32 = 20u32;
pub const CERT_COMPARE_HAS_PRIVATE_KEY: u32 = 21u32;
pub const CERT_COMPARE_ISSUER_OF: u32 = 12u32;
pub const CERT_COMPARE_KEY_IDENTIFIER: u32 = 15u32;
pub const CERT_COMPARE_KEY_SPEC: u32 = 9u32;
pub const CERT_COMPARE_MASK: u32 = 65535u32;
pub const CERT_COMPARE_MD5_HASH: u32 = 4u32;
pub const CERT_COMPARE_NAME: u32 = 2u32;
pub const CERT_COMPARE_NAME_STR_A: u32 = 7u32;
pub const CERT_COMPARE_NAME_STR_W: u32 = 8u32;
pub const CERT_COMPARE_PROPERTY: u32 = 5u32;
pub const CERT_COMPARE_PUBKEY_MD5_HASH: u32 = 18u32;
pub const CERT_COMPARE_PUBLIC_KEY: u32 = 6u32;
pub const CERT_COMPARE_SHA1_HASH: u32 = 1u32;
pub const CERT_COMPARE_SHIFT: i32 = 16i32;
pub const CERT_COMPARE_SIGNATURE_HASH: u32 = 14u32;
pub const CERT_COMPARE_SUBJECT_CERT: u32 = 11u32;
pub const CERT_COMPARE_SUBJECT_INFO_ACCESS: u32 = 19u32;
pub const CERT_CONTEXT_REVOCATION_TYPE: u32 = 1u32;
pub const CERT_CREATE_CONTEXT_NOCOPY_FLAG: u32 = 1u32;
pub const CERT_CREATE_CONTEXT_NO_ENTRY_FLAG: u32 = 8u32;
pub const CERT_CREATE_CONTEXT_NO_HCRYPTMSG_FLAG: u32 = 4u32;
pub const CERT_CREATE_CONTEXT_SORTED_FLAG: u32 = 2u32;
pub const CERT_CREATE_SELFSIGN_NO_KEY_INFO: CERT_CREATE_SELFSIGN_FLAGS = CERT_CREATE_SELFSIGN_FLAGS(2u32);
pub const CERT_CREATE_SELFSIGN_NO_SIGN: CERT_CREATE_SELFSIGN_FLAGS = CERT_CREATE_SELFSIGN_FLAGS(1u32);
pub const CERT_CRL_SIGN_KEY_USAGE: u32 = 2u32;
pub const CERT_CROSS_CERT_DIST_POINTS_PROP_ID: u32 = 23u32;
pub const CERT_CTL_USAGE_PROP_ID: u32 = 9u32;
pub const CERT_DATA_ENCIPHERMENT_KEY_USAGE: u32 = 16u32;
pub const CERT_DATE_STAMP_PROP_ID: u32 = 27u32;
pub const CERT_DECIPHER_ONLY_KEY_USAGE: u32 = 128u32;
pub const CERT_DEFAULT_OID_PUBLIC_KEY_SIGN: windows_core::PCWSTR = windows_core::w!("1.2.840.113549.1.1.1");
pub const CERT_DEFAULT_OID_PUBLIC_KEY_XCHG: windows_core::PCWSTR = windows_core::w!("1.2.840.113549.1.1.1");
pub const CERT_DESCRIPTION_PROP_ID: u32 = 13u32;
pub const CERT_DIGITAL_SIGNATURE_KEY_USAGE: u32 = 128u32;
pub const CERT_DISABLE_PIN_RULES_AUTO_UPDATE_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("DisablePinRulesAutoUpdate");
pub const CERT_DISABLE_ROOT_AUTO_UPDATE_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("DisableRootAutoUpdate");
pub const CERT_DISALLOWED_CA_FILETIME_PROP_ID: u32 = 128u32;
pub const CERT_DISALLOWED_CERT_AUTO_UPDATE_ENCODED_CTL_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("DisallowedCertEncodedCtl");
pub const CERT_DISALLOWED_CERT_AUTO_UPDATE_LAST_SYNC_TIME_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("DisallowedCertLastSyncTime");
pub const CERT_DISALLOWED_CERT_AUTO_UPDATE_LIST_IDENTIFIER: windows_core::PCWSTR = windows_core::w!("DisallowedCert_AutoUpdate_1");
pub const CERT_DISALLOWED_CERT_AUTO_UPDATE_SYNC_DELTA_TIME_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("DisallowedCertSyncDeltaTime");
pub const CERT_DISALLOWED_CERT_CAB_FILENAME: windows_core::PCWSTR = windows_core::w!("disallowedcertstl.cab");
pub const CERT_DISALLOWED_CERT_CTL_FILENAME: windows_core::PCWSTR = windows_core::w!("disallowedcert.stl");
pub const CERT_DISALLOWED_CERT_CTL_FILENAME_A: windows_core::PCSTR = windows_core::s!("disallowedcert.stl");
pub const CERT_DISALLOWED_ENHKEY_USAGE_PROP_ID: u32 = 122u32;
pub const CERT_DISALLOWED_FILETIME_PROP_ID: u32 = 104u32;
pub const CERT_DSS_R_LEN: u32 = 20u32;
pub const CERT_DSS_S_LEN: u32 = 20u32;
pub const CERT_EFSBLOB_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("EFSBlob");
pub const CERT_EFS_PROP_ID: u32 = 17u32;
pub const CERT_ENABLE_DISALLOWED_CERT_AUTO_UPDATE_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("EnableDisallowedCertAutoUpdate");
pub const CERT_ENCIPHER_ONLY_KEY_USAGE: u32 = 1u32;
pub const CERT_ENCODING_TYPE_MASK: u32 = 65535u32;
pub const CERT_END_ENTITY_SUBJECT_FLAG: u32 = 64u32;
pub const CERT_ENHKEY_USAGE_PROP_ID: u32 = 9u32;
pub const CERT_ENROLLMENT_PROP_ID: u32 = 26u32;
pub const CERT_EXCLUDED_SUBTREE_BIT: i32 = -2147483648i32;
pub const CERT_EXTENDED_ERROR_INFO_PROP_ID: u32 = 30u32;
pub const CERT_FILE_HASH_USE_TYPE: u32 = 1u32;
pub const CERT_FILE_STORE_COMMIT_ENABLE_FLAG: u32 = 65536u32;
pub const CERT_FIND_ANY: CERT_FIND_FLAGS = CERT_FIND_FLAGS(0u32);
pub const CERT_FIND_CERT_ID: CERT_FIND_FLAGS = CERT_FIND_FLAGS(1048576u32);
pub const CERT_FIND_CROSS_CERT_DIST_POINTS: CERT_FIND_FLAGS = CERT_FIND_FLAGS(1114112u32);
pub const CERT_FIND_CTL_USAGE: CERT_FIND_FLAGS = CERT_FIND_FLAGS(655360u32);
pub const CERT_FIND_ENHKEY_USAGE: CERT_FIND_FLAGS = CERT_FIND_FLAGS(655360u32);
pub const CERT_FIND_EXISTING: CERT_FIND_FLAGS = CERT_FIND_FLAGS(851968u32);
pub const CERT_FIND_EXT_ONLY_CTL_USAGE_FLAG: CERT_FIND_FLAGS = CERT_FIND_FLAGS(2u32);
pub const CERT_FIND_EXT_ONLY_ENHKEY_USAGE_FLAG: CERT_FIND_FLAGS = CERT_FIND_FLAGS(2u32);
pub const CERT_FIND_HASH: CERT_FIND_FLAGS = CERT_FIND_FLAGS(65536u32);
pub const CERT_FIND_HASH_STR: CERT_FIND_FLAGS = CERT_FIND_FLAGS(1310720u32);
pub const CERT_FIND_HAS_PRIVATE_KEY: CERT_FIND_FLAGS = CERT_FIND_FLAGS(1376256u32);
pub const CERT_FIND_ISSUER_ATTR: CERT_FIND_FLAGS = CERT_FIND_FLAGS(196612u32);
pub const CERT_FIND_ISSUER_NAME: CERT_FIND_FLAGS = CERT_FIND_FLAGS(131076u32);
pub const CERT_FIND_ISSUER_OF: CERT_FIND_FLAGS = CERT_FIND_FLAGS(786432u32);
pub const CERT_FIND_ISSUER_STR: CERT_FIND_FLAGS = CERT_FIND_FLAGS(524292u32);
pub const CERT_FIND_ISSUER_STR_A: CERT_FIND_FLAGS = CERT_FIND_FLAGS(458756u32);
pub const CERT_FIND_ISSUER_STR_W: CERT_FIND_FLAGS = CERT_FIND_FLAGS(524292u32);
pub const CERT_FIND_KEY_IDENTIFIER: CERT_FIND_FLAGS = CERT_FIND_FLAGS(983040u32);
pub const CERT_FIND_KEY_SPEC: CERT_FIND_FLAGS = CERT_FIND_FLAGS(589824u32);
pub const CERT_FIND_MD5_HASH: CERT_FIND_FLAGS = CERT_FIND_FLAGS(262144u32);
pub const CERT_FIND_NO_CTL_USAGE_FLAG: CERT_FIND_FLAGS = CERT_FIND_FLAGS(8u32);
pub const CERT_FIND_NO_ENHKEY_USAGE_FLAG: CERT_FIND_FLAGS = CERT_FIND_FLAGS(8u32);
pub const CERT_FIND_OPTIONAL_CTL_USAGE_FLAG: CERT_FIND_FLAGS = CERT_FIND_FLAGS(1u32);
pub const CERT_FIND_OPTIONAL_ENHKEY_USAGE_FLAG: CERT_FIND_FLAGS = CERT_FIND_FLAGS(1u32);
pub const CERT_FIND_OR_CTL_USAGE_FLAG: CERT_FIND_FLAGS = CERT_FIND_FLAGS(16u32);
pub const CERT_FIND_OR_ENHKEY_USAGE_FLAG: CERT_FIND_FLAGS = CERT_FIND_FLAGS(16u32);
pub const CERT_FIND_PROPERTY: CERT_FIND_FLAGS = CERT_FIND_FLAGS(327680u32);
pub const CERT_FIND_PROP_ONLY_CTL_USAGE_FLAG: CERT_FIND_FLAGS = CERT_FIND_FLAGS(4u32);
pub const CERT_FIND_PROP_ONLY_ENHKEY_USAGE_FLAG: CERT_FIND_FLAGS = CERT_FIND_FLAGS(4u32);
pub const CERT_FIND_PUBKEY_MD5_HASH: CERT_FIND_FLAGS = CERT_FIND_FLAGS(1179648u32);
pub const CERT_FIND_PUBLIC_KEY: CERT_FIND_FLAGS = CERT_FIND_FLAGS(393216u32);
pub const CERT_FIND_SHA1_HASH: CERT_FIND_FLAGS = CERT_FIND_FLAGS(65536u32);
pub const CERT_FIND_SIGNATURE_HASH: CERT_FIND_FLAGS = CERT_FIND_FLAGS(917504u32);
pub const CERT_FIND_SUBJECT_ATTR: CERT_FIND_FLAGS = CERT_FIND_FLAGS(196615u32);
pub const CERT_FIND_SUBJECT_CERT: CERT_FIND_FLAGS = CERT_FIND_FLAGS(720896u32);
pub const CERT_FIND_SUBJECT_INFO_ACCESS: CERT_FIND_FLAGS = CERT_FIND_FLAGS(1245184u32);
pub const CERT_FIND_SUBJECT_NAME: CERT_FIND_FLAGS = CERT_FIND_FLAGS(131079u32);
pub const CERT_FIND_SUBJECT_STR: CERT_FIND_FLAGS = CERT_FIND_FLAGS(524295u32);
pub const CERT_FIND_SUBJECT_STR_A: CERT_FIND_FLAGS = CERT_FIND_FLAGS(458759u32);
pub const CERT_FIND_SUBJECT_STR_W: CERT_FIND_FLAGS = CERT_FIND_FLAGS(524295u32);
pub const CERT_FIND_VALID_CTL_USAGE_FLAG: CERT_FIND_FLAGS = CERT_FIND_FLAGS(32u32);
pub const CERT_FIND_VALID_ENHKEY_USAGE_FLAG: CERT_FIND_FLAGS = CERT_FIND_FLAGS(32u32);
pub const CERT_FIRST_RESERVED_PROP_ID: u32 = 129u32;
pub const CERT_FIRST_USER_PROP_ID: u32 = 32768u32;
pub const CERT_FORTEZZA_DATA_PROP_ID: u32 = 18u32;
pub const CERT_FRIENDLY_NAME_PROP_ID: u32 = 11u32;
pub const CERT_GROUP_POLICY_SYSTEM_STORE_REGPATH: windows_core::PCWSTR = windows_core::w!("Software\\Policies\\Microsoft\\SystemCertificates");
pub const CERT_HASH_PROP_ID: u32 = 3u32;
pub const CERT_HCRYPTPROV_OR_NCRYPT_KEY_HANDLE_PROP_ID: u32 = 79u32;
pub const CERT_HCRYPTPROV_TRANSFER_PROP_ID: u32 = 100u32;
pub const CERT_ID_ISSUER_SERIAL_NUMBER: CERT_ID_OPTION = CERT_ID_OPTION(1u32);
pub const CERT_ID_KEY_IDENTIFIER: CERT_ID_OPTION = CERT_ID_OPTION(2u32);
pub const CERT_ID_SHA1_HASH: CERT_ID_OPTION = CERT_ID_OPTION(3u32);
pub const CERT_IE30_RESERVED_PROP_ID: u32 = 7u32;
pub const CERT_IE_DIRTY_FLAGS_REGPATH: windows_core::PCWSTR = windows_core::w!("Software\\Microsoft\\Cryptography\\IEDirtyFlags");
pub const CERT_INFO_EXTENSION_FLAG: u32 = 11u32;
pub const CERT_INFO_ISSUER_FLAG: u32 = 4u32;
pub const CERT_INFO_ISSUER_UNIQUE_ID_FLAG: u32 = 9u32;
pub const CERT_INFO_NOT_AFTER_FLAG: u32 = 6u32;
pub const CERT_INFO_NOT_BEFORE_FLAG: u32 = 5u32;
pub const CERT_INFO_SERIAL_NUMBER_FLAG: u32 = 2u32;
pub const CERT_INFO_SIGNATURE_ALGORITHM_FLAG: u32 = 3u32;
pub const CERT_INFO_SUBJECT_FLAG: u32 = 7u32;
pub const CERT_INFO_SUBJECT_PUBLIC_KEY_INFO_FLAG: u32 = 8u32;
pub const CERT_INFO_SUBJECT_UNIQUE_ID_FLAG: u32 = 10u32;
pub const CERT_INFO_VERSION_FLAG: u32 = 1u32;
pub const CERT_ISOLATED_KEY_PROP_ID: u32 = 118u32;
pub const CERT_ISSUER_CHAIN_PUB_KEY_CNG_ALG_BIT_LENGTH_PROP_ID: u32 = 96u32;
pub const CERT_ISSUER_CHAIN_SIGN_HASH_CNG_ALG_PROP_ID: u32 = 95u32;
pub const CERT_ISSUER_PUBLIC_KEY_MD5_HASH_PROP_ID: u32 = 24u32;
pub const CERT_ISSUER_PUB_KEY_BIT_LENGTH_PROP_ID: u32 = 94u32;
pub const CERT_ISSUER_SERIAL_NUMBER_MD5_HASH_PROP_ID: u32 = 28u32;
pub const CERT_KEYGEN_REQUEST_V1: u32 = 0u32;
pub const CERT_KEY_AGREEMENT_KEY_USAGE: u32 = 8u32;
pub const CERT_KEY_CERT_SIGN_KEY_USAGE: u32 = 4u32;
pub const CERT_KEY_CLASSIFICATION_PROP_ID: u32 = 120u32;
pub const CERT_KEY_CONTEXT_PROP_ID: u32 = 5u32;
pub const CERT_KEY_ENCIPHERMENT_KEY_USAGE: u32 = 32u32;
pub const CERT_KEY_IDENTIFIER_PROP_ID: u32 = 20u32;
pub const CERT_KEY_PROV_HANDLE_PROP_ID: u32 = 1u32;
pub const CERT_KEY_PROV_INFO_PROP_ID: u32 = 2u32;
pub const CERT_KEY_REPAIR_ATTEMPTED_PROP_ID: u32 = 103u32;
pub const CERT_KEY_SPEC_PROP_ID: u32 = 6u32;
pub const CERT_LAST_RESERVED_PROP_ID: u32 = 32767u32;
pub const CERT_LAST_USER_PROP_ID: u32 = 65535u32;
pub const CERT_LDAP_STORE_AREC_EXCLUSIVE_FLAG: u32 = 131072u32;
pub const CERT_LDAP_STORE_OPENED_FLAG: u32 = 262144u32;
pub const CERT_LDAP_STORE_SIGN_FLAG: u32 = 65536u32;
pub const CERT_LDAP_STORE_UNBIND_FLAG: u32 = 524288u32;
pub const CERT_LOCAL_MACHINE_SYSTEM_STORE_REGPATH: windows_core::PCWSTR = windows_core::w!("Software\\Microsoft\\SystemCertificates");
pub const CERT_LOGOTYPE_BITS_IMAGE_RESOLUTION_CHOICE: CERT_LOGOTYPE_CHOICE = CERT_LOGOTYPE_CHOICE(1u32);
pub const CERT_LOGOTYPE_COLOR_IMAGE_INFO_CHOICE: CERT_LOGOTYPE_IMAGE_INFO_TYPE = CERT_LOGOTYPE_IMAGE_INFO_TYPE(2u32);
pub const CERT_LOGOTYPE_DIRECT_INFO_CHOICE: CERT_LOGOTYPE_OPTION = CERT_LOGOTYPE_OPTION(1u32);
pub const CERT_LOGOTYPE_GRAY_SCALE_IMAGE_INFO_CHOICE: CERT_LOGOTYPE_IMAGE_INFO_TYPE = CERT_LOGOTYPE_IMAGE_INFO_TYPE(1u32);
pub const CERT_LOGOTYPE_INDIRECT_INFO_CHOICE: CERT_LOGOTYPE_OPTION = CERT_LOGOTYPE_OPTION(2u32);
pub const CERT_LOGOTYPE_NO_IMAGE_RESOLUTION_CHOICE: CERT_LOGOTYPE_CHOICE = CERT_LOGOTYPE_CHOICE(0u32);
pub const CERT_LOGOTYPE_TABLE_SIZE_IMAGE_RESOLUTION_CHOICE: CERT_LOGOTYPE_CHOICE = CERT_LOGOTYPE_CHOICE(2u32);
pub const CERT_MD5_HASH_PROP_ID: u32 = 4u32;
pub const CERT_NAME_ATTR_TYPE: u32 = 3u32;
pub const CERT_NAME_DISABLE_IE4_UTF8_FLAG: u32 = 65536u32;
pub const CERT_NAME_DNS_TYPE: u32 = 6u32;
pub const CERT_NAME_EMAIL_TYPE: u32 = 1u32;
pub const CERT_NAME_FRIENDLY_DISPLAY_TYPE: u32 = 5u32;
pub const CERT_NAME_ISSUER_FLAG: u32 = 1u32;
pub const CERT_NAME_RDN_TYPE: u32 = 2u32;
pub const CERT_NAME_SEARCH_ALL_NAMES_FLAG: u32 = 2u32;
pub const CERT_NAME_SIMPLE_DISPLAY_TYPE: u32 = 4u32;
pub const CERT_NAME_STR_COMMA_FLAG: u32 = 67108864u32;
pub const CERT_NAME_STR_CRLF_FLAG: u32 = 134217728u32;
pub const CERT_NAME_STR_DISABLE_IE4_UTF8_FLAG: u32 = 65536u32;
pub const CERT_NAME_STR_DISABLE_UTF8_DIR_STR_FLAG: u32 = 1048576u32;
pub const CERT_NAME_STR_ENABLE_PUNYCODE_FLAG: u32 = 2097152u32;
pub const CERT_NAME_STR_ENABLE_T61_UNICODE_FLAG: u32 = 131072u32;
pub const CERT_NAME_STR_ENABLE_UTF8_UNICODE_FLAG: u32 = 262144u32;
pub const CERT_NAME_STR_FORCE_UTF8_DIR_STR_FLAG: u32 = 524288u32;
pub const CERT_NAME_STR_FORWARD_FLAG: u32 = 16777216u32;
pub const CERT_NAME_STR_NO_PLUS_FLAG: u32 = 536870912u32;
pub const CERT_NAME_STR_NO_QUOTING_FLAG: u32 = 268435456u32;
pub const CERT_NAME_STR_REVERSE_FLAG: u32 = 33554432u32;
pub const CERT_NAME_STR_SEMICOLON_FLAG: u32 = 1073741824u32;
pub const CERT_NAME_UPN_TYPE: u32 = 8u32;
pub const CERT_NAME_URL_TYPE: u32 = 7u32;
pub const CERT_NCRYPT_KEY_HANDLE_PROP_ID: u32 = 78u32;
pub const CERT_NCRYPT_KEY_HANDLE_TRANSFER_PROP_ID: u32 = 99u32;
pub const CERT_NCRYPT_KEY_SPEC: CERT_KEY_SPEC = CERT_KEY_SPEC(4294967295u32);
pub const CERT_NEW_KEY_PROP_ID: u32 = 74u32;
pub const CERT_NEXT_UPDATE_LOCATION_PROP_ID: u32 = 10u32;
pub const CERT_NONCOMPLIANT_ROOT_URL_PROP_ID: u32 = 123u32;
pub const CERT_NON_REPUDIATION_KEY_USAGE: u32 = 64u32;
pub const CERT_NOT_BEFORE_ENHKEY_USAGE_PROP_ID: u32 = 127u32;
pub const CERT_NOT_BEFORE_FILETIME_PROP_ID: u32 = 126u32;
pub const CERT_NO_AUTO_EXPIRE_CHECK_PROP_ID: u32 = 77u32;
pub const CERT_NO_EXPIRE_NOTIFICATION_PROP_ID: u32 = 97u32;
pub const CERT_OCM_SUBCOMPONENTS_LOCAL_MACHINE_REGPATH: windows_core::PCWSTR = windows_core::w!("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Setup\\OC Manager\\Subcomponents");
pub const CERT_OCM_SUBCOMPONENTS_ROOT_AUTO_UPDATE_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("RootAutoUpdate");
pub const CERT_OCSP_CACHE_PREFIX_PROP_ID: u32 = 75u32;
pub const CERT_OCSP_MUST_STAPLE_PROP_ID: u32 = 121u32;
pub const CERT_OCSP_RESPONSE_PROP_ID: u32 = 70u32;
pub const CERT_OFFLINE_CRL_SIGN_KEY_USAGE: u32 = 2u32;
pub const CERT_OID_NAME_STR: CERT_STRING_TYPE = CERT_STRING_TYPE(2u32);
pub const CERT_PHYSICAL_STORE_ADD_ENABLE_FLAG: u32 = 1u32;
pub const CERT_PHYSICAL_STORE_AUTH_ROOT_NAME: windows_core::PCWSTR = windows_core::w!(".AuthRoot");
pub const CERT_PHYSICAL_STORE_DEFAULT_NAME: windows_core::PCWSTR = windows_core::w!(".Default");
pub const CERT_PHYSICAL_STORE_DS_USER_CERTIFICATE_NAME: windows_core::PCWSTR = windows_core::w!(".UserCertificate");
pub const CERT_PHYSICAL_STORE_ENTERPRISE_NAME: windows_core::PCWSTR = windows_core::w!(".Enterprise");
pub const CERT_PHYSICAL_STORE_GROUP_POLICY_NAME: windows_core::PCWSTR = windows_core::w!(".GroupPolicy");
pub const CERT_PHYSICAL_STORE_INSERT_COMPUTER_NAME_ENABLE_FLAG: u32 = 8u32;
pub const CERT_PHYSICAL_STORE_LOCAL_MACHINE_GROUP_POLICY_NAME: windows_core::PCWSTR = windows_core::w!(".LocalMachineGroupPolicy");
pub const CERT_PHYSICAL_STORE_LOCAL_MACHINE_NAME: windows_core::PCWSTR = windows_core::w!(".LocalMachine");
pub const CERT_PHYSICAL_STORE_OPEN_DISABLE_FLAG: u32 = 2u32;
pub const CERT_PHYSICAL_STORE_PREDEFINED_ENUM_FLAG: u32 = 1u32;
pub const CERT_PHYSICAL_STORE_REMOTE_OPEN_DISABLE_FLAG: u32 = 4u32;
pub const CERT_PHYSICAL_STORE_SMART_CARD_NAME: windows_core::PCWSTR = windows_core::w!(".SmartCard");
pub const CERT_PIN_RULES_AUTO_UPDATE_ENCODED_CTL_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("PinRulesEncodedCtl");
pub const CERT_PIN_RULES_AUTO_UPDATE_LAST_SYNC_TIME_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("PinRulesLastSyncTime");
pub const CERT_PIN_RULES_AUTO_UPDATE_LIST_IDENTIFIER: windows_core::PCWSTR = windows_core::w!("PinRules_AutoUpdate_1");
pub const CERT_PIN_RULES_AUTO_UPDATE_SYNC_DELTA_TIME_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("PinRulesSyncDeltaTime");
pub const CERT_PIN_RULES_CAB_FILENAME: windows_core::PCWSTR = windows_core::w!("pinrulesstl.cab");
pub const CERT_PIN_RULES_CTL_FILENAME: windows_core::PCWSTR = windows_core::w!("pinrules.stl");
pub const CERT_PIN_RULES_CTL_FILENAME_A: windows_core::PCSTR = windows_core::s!("pinrules.stl");
pub const CERT_PIN_SHA256_HASH_PROP_ID: u32 = 124u32;
pub const CERT_PROT_ROOT_DISABLE_CURRENT_USER_FLAG: u32 = 1u32;
pub const CERT_PROT_ROOT_DISABLE_LM_AUTH_FLAG: u32 = 8u32;
pub const CERT_PROT_ROOT_DISABLE_NOT_DEFINED_NAME_CONSTRAINT_FLAG: u32 = 32u32;
pub const CERT_PROT_ROOT_DISABLE_NT_AUTH_REQUIRED_FLAG: u32 = 16u32;
pub const CERT_PROT_ROOT_DISABLE_PEER_TRUST: u32 = 65536u32;
pub const CERT_PROT_ROOT_FLAGS_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("Flags");
pub const CERT_PROT_ROOT_INHIBIT_ADD_AT_INIT_FLAG: u32 = 2u32;
pub const CERT_PROT_ROOT_INHIBIT_PURGE_LM_FLAG: u32 = 4u32;
pub const CERT_PROT_ROOT_ONLY_LM_GPT_FLAG: u32 = 8u32;
pub const CERT_PROT_ROOT_PEER_USAGES_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("PeerUsages");
pub const CERT_PROT_ROOT_PEER_USAGES_VALUE_NAME_A: windows_core::PCSTR = windows_core::s!("PeerUsages");
pub const CERT_PUBKEY_ALG_PARA_PROP_ID: u32 = 22u32;
pub const CERT_PUBKEY_HASH_RESERVED_PROP_ID: u32 = 8u32;
pub const CERT_PUB_KEY_CNG_ALG_BIT_LENGTH_PROP_ID: u32 = 93u32;
pub const CERT_PVK_FILE_PROP_ID: u32 = 12u32;
pub const CERT_QUERY_CONTENT_CERT: CERT_QUERY_CONTENT_TYPE = CERT_QUERY_CONTENT_TYPE(1u32);
pub const CERT_QUERY_CONTENT_CERT_PAIR: CERT_QUERY_CONTENT_TYPE = CERT_QUERY_CONTENT_TYPE(13u32);
pub const CERT_QUERY_CONTENT_CRL: CERT_QUERY_CONTENT_TYPE = CERT_QUERY_CONTENT_TYPE(3u32);
pub const CERT_QUERY_CONTENT_CTL: CERT_QUERY_CONTENT_TYPE = CERT_QUERY_CONTENT_TYPE(2u32);
pub const CERT_QUERY_CONTENT_FLAG_ALL: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(16382u32);
pub const CERT_QUERY_CONTENT_FLAG_ALL_ISSUER_CERT: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(818u32);
pub const CERT_QUERY_CONTENT_FLAG_CERT: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(2u32);
pub const CERT_QUERY_CONTENT_FLAG_CERT_PAIR: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(8192u32);
pub const CERT_QUERY_CONTENT_FLAG_CRL: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(8u32);
pub const CERT_QUERY_CONTENT_FLAG_CTL: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(4u32);
pub const CERT_QUERY_CONTENT_FLAG_PFX: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(4096u32);
pub const CERT_QUERY_CONTENT_FLAG_PFX_AND_LOAD: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(16384u32);
pub const CERT_QUERY_CONTENT_FLAG_PKCS10: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(2048u32);
pub const CERT_QUERY_CONTENT_FLAG_PKCS7_SIGNED: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(256u32);
pub const CERT_QUERY_CONTENT_FLAG_PKCS7_SIGNED_EMBED: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(1024u32);
pub const CERT_QUERY_CONTENT_FLAG_PKCS7_UNSIGNED: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(512u32);
pub const CERT_QUERY_CONTENT_FLAG_SERIALIZED_CERT: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(32u32);
pub const CERT_QUERY_CONTENT_FLAG_SERIALIZED_CRL: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(128u32);
pub const CERT_QUERY_CONTENT_FLAG_SERIALIZED_CTL: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(64u32);
pub const CERT_QUERY_CONTENT_FLAG_SERIALIZED_STORE: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(16u32);
pub const CERT_QUERY_CONTENT_PFX: CERT_QUERY_CONTENT_TYPE = CERT_QUERY_CONTENT_TYPE(12u32);
pub const CERT_QUERY_CONTENT_PFX_AND_LOAD: CERT_QUERY_CONTENT_TYPE = CERT_QUERY_CONTENT_TYPE(14u32);
pub const CERT_QUERY_CONTENT_PKCS10: CERT_QUERY_CONTENT_TYPE = CERT_QUERY_CONTENT_TYPE(11u32);
pub const CERT_QUERY_CONTENT_PKCS7_SIGNED: CERT_QUERY_CONTENT_TYPE = CERT_QUERY_CONTENT_TYPE(8u32);
pub const CERT_QUERY_CONTENT_PKCS7_SIGNED_EMBED: CERT_QUERY_CONTENT_TYPE = CERT_QUERY_CONTENT_TYPE(10u32);
pub const CERT_QUERY_CONTENT_PKCS7_UNSIGNED: CERT_QUERY_CONTENT_TYPE = CERT_QUERY_CONTENT_TYPE(9u32);
pub const CERT_QUERY_CONTENT_SERIALIZED_CERT: CERT_QUERY_CONTENT_TYPE = CERT_QUERY_CONTENT_TYPE(5u32);
pub const CERT_QUERY_CONTENT_SERIALIZED_CRL: CERT_QUERY_CONTENT_TYPE = CERT_QUERY_CONTENT_TYPE(7u32);
pub const CERT_QUERY_CONTENT_SERIALIZED_CTL: CERT_QUERY_CONTENT_TYPE = CERT_QUERY_CONTENT_TYPE(6u32);
pub const CERT_QUERY_CONTENT_SERIALIZED_STORE: CERT_QUERY_CONTENT_TYPE = CERT_QUERY_CONTENT_TYPE(4u32);
pub const CERT_QUERY_FORMAT_ASN_ASCII_HEX_ENCODED: CERT_QUERY_FORMAT_TYPE = CERT_QUERY_FORMAT_TYPE(3u32);
pub const CERT_QUERY_FORMAT_BASE64_ENCODED: CERT_QUERY_FORMAT_TYPE = CERT_QUERY_FORMAT_TYPE(2u32);
pub const CERT_QUERY_FORMAT_BINARY: CERT_QUERY_FORMAT_TYPE = CERT_QUERY_FORMAT_TYPE(1u32);
pub const CERT_QUERY_FORMAT_FLAG_ALL: CERT_QUERY_FORMAT_TYPE_FLAGS = CERT_QUERY_FORMAT_TYPE_FLAGS(14u32);
pub const CERT_QUERY_FORMAT_FLAG_ASN_ASCII_HEX_ENCODED: CERT_QUERY_FORMAT_TYPE_FLAGS = CERT_QUERY_FORMAT_TYPE_FLAGS(8u32);
pub const CERT_QUERY_FORMAT_FLAG_BASE64_ENCODED: CERT_QUERY_FORMAT_TYPE_FLAGS = CERT_QUERY_FORMAT_TYPE_FLAGS(4u32);
pub const CERT_QUERY_FORMAT_FLAG_BINARY: CERT_QUERY_FORMAT_TYPE_FLAGS = CERT_QUERY_FORMAT_TYPE_FLAGS(2u32);
pub const CERT_QUERY_OBJECT_BLOB: CERT_QUERY_OBJECT_TYPE = CERT_QUERY_OBJECT_TYPE(2u32);
pub const CERT_QUERY_OBJECT_FILE: CERT_QUERY_OBJECT_TYPE = CERT_QUERY_OBJECT_TYPE(1u32);
pub const CERT_RDN_ANY_TYPE: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(0i32);
pub const CERT_RDN_BMP_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(12i32);
pub const CERT_RDN_DISABLE_CHECK_TYPE_FLAG: u32 = 1073741824u32;
pub const CERT_RDN_DISABLE_IE4_UTF8_FLAG: u32 = 16777216u32;
pub const CERT_RDN_ENABLE_PUNYCODE_FLAG: u32 = 33554432u32;
pub const CERT_RDN_ENABLE_T61_UNICODE_FLAG: u32 = 2147483648u32;
pub const CERT_RDN_ENABLE_UTF8_UNICODE_FLAG: u32 = 536870912u32;
pub const CERT_RDN_ENCODED_BLOB: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(1i32);
pub const CERT_RDN_FLAGS_MASK: u32 = 4278190080u32;
pub const CERT_RDN_FORCE_UTF8_UNICODE_FLAG: u32 = 268435456u32;
pub const CERT_RDN_GENERAL_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(10i32);
pub const CERT_RDN_GRAPHIC_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(8i32);
pub const CERT_RDN_IA5_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(7i32);
pub const CERT_RDN_INT4_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(11i32);
pub const CERT_RDN_ISO646_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(9i32);
pub const CERT_RDN_NUMERIC_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(3i32);
pub const CERT_RDN_OCTET_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(2i32);
pub const CERT_RDN_PRINTABLE_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(4i32);
pub const CERT_RDN_T61_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(5i32);
pub const CERT_RDN_TELETEX_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(5i32);
pub const CERT_RDN_TYPE_MASK: u32 = 255u32;
pub const CERT_RDN_UNICODE_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(12i32);
pub const CERT_RDN_UNIVERSAL_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(11i32);
pub const CERT_RDN_UTF8_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(13i32);
pub const CERT_RDN_VIDEOTEX_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(6i32);
pub const CERT_RDN_VISIBLE_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(9i32);
pub const CERT_REGISTRY_STORE_CLIENT_GPT_FLAG: u32 = 2147483648u32;
pub const CERT_REGISTRY_STORE_EXTERNAL_FLAG: u32 = 1048576u32;
pub const CERT_REGISTRY_STORE_LM_GPT_FLAG: u32 = 16777216u32;
pub const CERT_REGISTRY_STORE_MY_IE_DIRTY_FLAG: u32 = 524288u32;
pub const CERT_REGISTRY_STORE_REMOTE_FLAG: u32 = 65536u32;
pub const CERT_REGISTRY_STORE_ROAMING_FLAG: u32 = 262144u32;
pub const CERT_REGISTRY_STORE_SERIALIZED_FLAG: u32 = 131072u32;
pub const CERT_RENEWAL_PROP_ID: u32 = 64u32;
pub const CERT_REQUEST_ORIGINATOR_PROP_ID: u32 = 71u32;
pub const CERT_REQUEST_V1: u32 = 0u32;
pub const CERT_RETRIEVE_BIOMETRIC_PREDEFINED_BASE_TYPE: windows_core::PCSTR = windows_core::PCSTR(1000i32 as _);
pub const CERT_RETRIEVE_COMMUNITY_LOGO: windows_core::PCSTR = windows_core::PCSTR(3i32 as _);
pub const CERT_RETRIEVE_ISSUER_LOGO: windows_core::PCSTR = windows_core::PCSTR(1i32 as _);
pub const CERT_RETRIEVE_SUBJECT_LOGO: windows_core::PCSTR = windows_core::PCSTR(2i32 as _);
pub const CERT_RETR_BEHAVIOR_FILE_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("AllowFileUrlScheme");
pub const CERT_RETR_BEHAVIOR_INET_AUTH_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("EnableInetUnknownAuth");
pub const CERT_RETR_BEHAVIOR_INET_STATUS_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("EnableInetLocal");
pub const CERT_RETR_BEHAVIOR_LDAP_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("DisableLDAPSignAndEncrypt");
pub const CERT_ROOT_PROGRAM_CERT_POLICIES_PROP_ID: u32 = 83u32;
pub const CERT_ROOT_PROGRAM_CHAIN_POLICIES_PROP_ID: u32 = 105u32;
pub const CERT_ROOT_PROGRAM_FLAG_ADDRESS: u32 = 8u32;
pub const CERT_ROOT_PROGRAM_FLAG_LSC: CERT_ROOT_PROGRAM_FLAGS = CERT_ROOT_PROGRAM_FLAGS(64u32);
pub const CERT_ROOT_PROGRAM_FLAG_ORG: CERT_ROOT_PROGRAM_FLAGS = CERT_ROOT_PROGRAM_FLAGS(128u32);
pub const CERT_ROOT_PROGRAM_FLAG_OU: u32 = 16u32;
pub const CERT_ROOT_PROGRAM_FLAG_SUBJECT_LOGO: CERT_ROOT_PROGRAM_FLAGS = CERT_ROOT_PROGRAM_FLAGS(32u32);
pub const CERT_ROOT_PROGRAM_NAME_CONSTRAINTS_PROP_ID: u32 = 84u32;
pub const CERT_RSA_PUBLIC_KEY_OBJID: windows_core::PCWSTR = windows_core::w!("1.2.840.113549.1.1.1");
pub const CERT_SCARD_PIN_ID_PROP_ID: u32 = 90u32;
pub const CERT_SCARD_PIN_INFO_PROP_ID: u32 = 91u32;
pub const CERT_SCEP_CA_CERT_PROP_ID: u32 = 111u32;
pub const CERT_SCEP_ENCRYPT_HASH_CNG_ALG_PROP_ID: u32 = 114u32;
pub const CERT_SCEP_FLAGS_PROP_ID: u32 = 115u32;
pub const CERT_SCEP_GUID_PROP_ID: u32 = 116u32;
pub const CERT_SCEP_NONCE_PROP_ID: u32 = 113u32;
pub const CERT_SCEP_RA_ENCRYPTION_CERT_PROP_ID: u32 = 110u32;
pub const CERT_SCEP_RA_SIGNATURE_CERT_PROP_ID: u32 = 109u32;
pub const CERT_SCEP_SERVER_CERTS_PROP_ID: u32 = 108u32;
pub const CERT_SCEP_SIGNER_CERT_PROP_ID: u32 = 112u32;
pub const CERT_SELECT_ALLOW_DUPLICATES: u32 = 128u32;
pub const CERT_SELECT_ALLOW_EXPIRED: u32 = 1u32;
pub const CERT_SELECT_BY_ENHKEY_USAGE: CERT_SELECT_CRITERIA_TYPE = CERT_SELECT_CRITERIA_TYPE(1u32);
pub const CERT_SELECT_BY_EXTENSION: CERT_SELECT_CRITERIA_TYPE = CERT_SELECT_CRITERIA_TYPE(5u32);
pub const CERT_SELECT_BY_FRIENDLYNAME: u32 = 13u32;
pub const CERT_SELECT_BY_ISSUER_ATTR: CERT_SELECT_CRITERIA_TYPE = CERT_SELECT_CRITERIA_TYPE(7u32);
pub const CERT_SELECT_BY_ISSUER_DISPLAYNAME: u32 = 12u32;
pub const CERT_SELECT_BY_ISSUER_NAME: CERT_SELECT_CRITERIA_TYPE = CERT_SELECT_CRITERIA_TYPE(9u32);
pub const CERT_SELECT_BY_KEY_USAGE: CERT_SELECT_CRITERIA_TYPE = CERT_SELECT_CRITERIA_TYPE(2u32);
pub const CERT_SELECT_BY_POLICY_OID: CERT_SELECT_CRITERIA_TYPE = CERT_SELECT_CRITERIA_TYPE(3u32);
pub const CERT_SELECT_BY_PROV_NAME: CERT_SELECT_CRITERIA_TYPE = CERT_SELECT_CRITERIA_TYPE(4u32);
pub const CERT_SELECT_BY_PUBLIC_KEY: CERT_SELECT_CRITERIA_TYPE = CERT_SELECT_CRITERIA_TYPE(10u32);
pub const CERT_SELECT_BY_SUBJECT_ATTR: CERT_SELECT_CRITERIA_TYPE = CERT_SELECT_CRITERIA_TYPE(8u32);
pub const CERT_SELECT_BY_SUBJECT_HOST_NAME: CERT_SELECT_CRITERIA_TYPE = CERT_SELECT_CRITERIA_TYPE(6u32);
pub const CERT_SELECT_BY_THUMBPRINT: u32 = 14u32;
pub const CERT_SELECT_BY_TLS_SIGNATURES: CERT_SELECT_CRITERIA_TYPE = CERT_SELECT_CRITERIA_TYPE(11u32);
pub const CERT_SELECT_DISALLOW_SELFSIGNED: u32 = 4u32;
pub const CERT_SELECT_HARDWARE_ONLY: u32 = 64u32;
pub const CERT_SELECT_HAS_KEY_FOR_KEY_EXCHANGE: u32 = 32u32;
pub const CERT_SELECT_HAS_KEY_FOR_SIGNATURE: u32 = 16u32;
pub const CERT_SELECT_HAS_PRIVATE_KEY: u32 = 8u32;
pub const CERT_SELECT_IGNORE_AUTOSELECT: u32 = 256u32;
pub const CERT_SELECT_MAX_PARA: u32 = 500u32;
pub const CERT_SELECT_TRUSTED_ROOT: u32 = 2u32;
pub const CERT_SEND_AS_TRUSTED_ISSUER_PROP_ID: u32 = 102u32;
pub const CERT_SERIALIZABLE_KEY_CONTEXT_PROP_ID: u32 = 117u32;
pub const CERT_SERIAL_CHAIN_PROP_ID: u32 = 119u32;
pub const CERT_SERVER_OCSP_RESPONSE_ASYNC_FLAG: u32 = 1u32;
pub const CERT_SERVER_OCSP_RESPONSE_OPEN_PARA_READ_FLAG: u32 = 1u32;
pub const CERT_SERVER_OCSP_RESPONSE_OPEN_PARA_WRITE_FLAG: u32 = 2u32;
pub const CERT_SET_KEY_CONTEXT_PROP_ID: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(1u32);
pub const CERT_SET_KEY_PROV_HANDLE_PROP_ID: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(1u32);
pub const CERT_SET_PROPERTY_IGNORE_PERSIST_ERROR_FLAG: u32 = 2147483648u32;
pub const CERT_SET_PROPERTY_INHIBIT_PERSIST_FLAG: u32 = 1073741824u32;
pub const CERT_SHA1_HASH_PROP_ID: u32 = 3u32;
pub const CERT_SHA256_HASH_PROP_ID: u32 = 107u32;
pub const CERT_SIGNATURE_HASH_PROP_ID: u32 = 15u32;
pub const CERT_SIGN_HASH_CNG_ALG_PROP_ID: u32 = 89u32;
pub const CERT_SIMPLE_NAME_STR: CERT_STRING_TYPE = CERT_STRING_TYPE(1u32);
pub const CERT_SMART_CARD_DATA_PROP_ID: u32 = 16u32;
pub const CERT_SMART_CARD_READER_NON_REMOVABLE_PROP_ID: u32 = 106u32;
pub const CERT_SMART_CARD_READER_PROP_ID: u32 = 101u32;
pub const CERT_SMART_CARD_ROOT_INFO_PROP_ID: u32 = 76u32;
pub const CERT_SOURCE_LOCATION_PROP_ID: u32 = 72u32;
pub const CERT_SOURCE_URL_PROP_ID: u32 = 73u32;
pub const CERT_SRV_OCSP_RESP_MAX_BEFORE_NEXT_UPDATE_SECONDS_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("SrvOcspRespMaxBeforeNextUpdateSeconds");
pub const CERT_SRV_OCSP_RESP_MAX_SYNC_CERT_FILE_SECONDS_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("SrvOcspRespMaxSyncCertFileSeconds");
pub const CERT_SRV_OCSP_RESP_MIN_AFTER_NEXT_UPDATE_SECONDS_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("SrvOcspRespMinAfterNextUpdateSeconds");
pub const CERT_SRV_OCSP_RESP_MIN_BEFORE_NEXT_UPDATE_SECONDS_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("SrvOcspRespMinBeforeNextUpdateSeconds");
pub const CERT_SRV_OCSP_RESP_MIN_SYNC_CERT_FILE_SECONDS_DEFAULT: u32 = 5u32;
pub const CERT_SRV_OCSP_RESP_MIN_SYNC_CERT_FILE_SECONDS_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("SrvOcspRespMinSyncCertFileSeconds");
pub const CERT_SRV_OCSP_RESP_MIN_VALIDITY_SECONDS_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("SrvOcspRespMinValiditySeconds");
pub const CERT_SRV_OCSP_RESP_URL_RETRIEVAL_TIMEOUT_MILLISECONDS_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("SrvOcspRespUrlRetrievalTimeoutMilliseconds");
pub const CERT_STORE_ADD_ALWAYS: u32 = 4u32;
pub const CERT_STORE_ADD_NEW: u32 = 1u32;
pub const CERT_STORE_ADD_NEWER: u32 = 6u32;
pub const CERT_STORE_ADD_NEWER_INHERIT_PROPERTIES: u32 = 7u32;
pub const CERT_STORE_ADD_REPLACE_EXISTING: u32 = 3u32;
pub const CERT_STORE_ADD_REPLACE_EXISTING_INHERIT_PROPERTIES: u32 = 5u32;
pub const CERT_STORE_ADD_USE_EXISTING: u32 = 2u32;
pub const CERT_STORE_BACKUP_RESTORE_FLAG: CERT_OPEN_STORE_FLAGS = CERT_OPEN_STORE_FLAGS(2048u32);
pub const CERT_STORE_BASE_CRL_FLAG: u32 = 256u32;
pub const CERT_STORE_CERTIFICATE_CONTEXT: u32 = 1u32;
pub const CERT_STORE_CREATE_NEW_FLAG: CERT_OPEN_STORE_FLAGS = CERT_OPEN_STORE_FLAGS(8192u32);
pub const CERT_STORE_CRL_CONTEXT: u32 = 2u32;
pub const CERT_STORE_CTL_CONTEXT: u32 = 3u32;
pub const CERT_STORE_CTRL_AUTO_RESYNC: u32 = 4u32;
pub const CERT_STORE_CTRL_CANCEL_NOTIFY: u32 = 5u32;
pub const CERT_STORE_CTRL_COMMIT: u32 = 3u32;
pub const CERT_STORE_CTRL_COMMIT_CLEAR_FLAG: CERT_CONTROL_STORE_FLAGS = CERT_CONTROL_STORE_FLAGS(2u32);
pub const CERT_STORE_CTRL_COMMIT_FORCE_FLAG: CERT_CONTROL_STORE_FLAGS = CERT_CONTROL_STORE_FLAGS(1u32);
pub const CERT_STORE_CTRL_INHIBIT_DUPLICATE_HANDLE_FLAG: CERT_CONTROL_STORE_FLAGS = CERT_CONTROL_STORE_FLAGS(1u32);
pub const CERT_STORE_CTRL_NOTIFY_CHANGE: u32 = 2u32;
pub const CERT_STORE_CTRL_RESYNC: u32 = 1u32;
pub const CERT_STORE_DEFER_CLOSE_UNTIL_LAST_FREE_FLAG: CERT_OPEN_STORE_FLAGS = CERT_OPEN_STORE_FLAGS(4u32);
pub const CERT_STORE_DELETE_FLAG: CERT_OPEN_STORE_FLAGS = CERT_OPEN_STORE_FLAGS(16u32);
pub const CERT_STORE_DELTA_CRL_FLAG: u32 = 512u32;
pub const CERT_STORE_ENUM_ARCHIVED_FLAG: CERT_OPEN_STORE_FLAGS = CERT_OPEN_STORE_FLAGS(512u32);
pub const CERT_STORE_LOCALIZED_NAME_PROP_ID: u32 = 4096u32;
pub const CERT_STORE_MANIFOLD_FLAG: u32 = 256u32;
pub const CERT_STORE_MAXIMUM_ALLOWED_FLAG: CERT_OPEN_STORE_FLAGS = CERT_OPEN_STORE_FLAGS(4096u32);
pub const CERT_STORE_NO_CRL_FLAG: u32 = 65536u32;
pub const CERT_STORE_NO_CRYPT_RELEASE_FLAG: CERT_OPEN_STORE_FLAGS = CERT_OPEN_STORE_FLAGS(1u32);
pub const CERT_STORE_NO_ISSUER_FLAG: u32 = 131072u32;
pub const CERT_STORE_OPEN_EXISTING_FLAG: CERT_OPEN_STORE_FLAGS = CERT_OPEN_STORE_FLAGS(16384u32);
pub const CERT_STORE_PROV_CLOSE_FUNC: u32 = 0u32;
pub const CERT_STORE_PROV_COLLECTION: windows_core::PCSTR = windows_core::PCSTR(11i32 as _);
pub const CERT_STORE_PROV_CONTROL_FUNC: u32 = 13u32;
pub const CERT_STORE_PROV_DELETED_FLAG: CERT_STORE_PROV_FLAGS = CERT_STORE_PROV_FLAGS(2u32);
pub const CERT_STORE_PROV_DELETE_CERT_FUNC: u32 = 3u32;
pub const CERT_STORE_PROV_DELETE_CRL_FUNC: u32 = 7u32;
pub const CERT_STORE_PROV_DELETE_CTL_FUNC: u32 = 11u32;
pub const CERT_STORE_PROV_EXTERNAL_FLAG: CERT_STORE_PROV_FLAGS = CERT_STORE_PROV_FLAGS(1u32);
pub const CERT_STORE_PROV_FILE: windows_core::PCSTR = windows_core::PCSTR(3i32 as _);
pub const CERT_STORE_PROV_FILENAME: i32 = 8i32;
pub const CERT_STORE_PROV_FILENAME_A: windows_core::PCSTR = windows_core::PCSTR(7i32 as _);
pub const CERT_STORE_PROV_FILENAME_W: windows_core::PCSTR = windows_core::PCSTR(8i32 as _);
pub const CERT_STORE_PROV_FIND_CERT_FUNC: u32 = 14u32;
pub const CERT_STORE_PROV_FIND_CRL_FUNC: u32 = 17u32;
pub const CERT_STORE_PROV_FIND_CTL_FUNC: u32 = 20u32;
pub const CERT_STORE_PROV_FREE_FIND_CERT_FUNC: u32 = 15u32;
pub const CERT_STORE_PROV_FREE_FIND_CRL_FUNC: u32 = 18u32;
pub const CERT_STORE_PROV_FREE_FIND_CTL_FUNC: u32 = 21u32;
pub const CERT_STORE_PROV_GET_CERT_PROPERTY_FUNC: u32 = 16u32;
pub const CERT_STORE_PROV_GET_CRL_PROPERTY_FUNC: u32 = 19u32;
pub const CERT_STORE_PROV_GET_CTL_PROPERTY_FUNC: u32 = 22u32;
pub const CERT_STORE_PROV_GP_SYSTEM_STORE_FLAG: u32 = 32u32;
pub const CERT_STORE_PROV_LDAP: i32 = 16i32;
pub const CERT_STORE_PROV_LDAP_W: windows_core::PCSTR = windows_core::PCSTR(16i32 as _);
pub const CERT_STORE_PROV_LM_SYSTEM_STORE_FLAG: CERT_STORE_PROV_FLAGS = CERT_STORE_PROV_FLAGS(16u32);
pub const CERT_STORE_PROV_MEMORY: windows_core::PCSTR = windows_core::PCSTR(2i32 as _);
pub const CERT_STORE_PROV_MSG: windows_core::PCSTR = windows_core::PCSTR(1i32 as _);
pub const CERT_STORE_PROV_NO_PERSIST_FLAG: CERT_STORE_PROV_FLAGS = CERT_STORE_PROV_FLAGS(4u32);
pub const CERT_STORE_PROV_PHYSICAL: i32 = 14i32;
pub const CERT_STORE_PROV_PHYSICAL_W: windows_core::PCSTR = windows_core::PCSTR(14i32 as _);
pub const CERT_STORE_PROV_PKCS12: windows_core::PCSTR = windows_core::PCSTR(17i32 as _);
pub const CERT_STORE_PROV_PKCS7: windows_core::PCSTR = windows_core::PCSTR(5i32 as _);
pub const CERT_STORE_PROV_READ_CERT_FUNC: u32 = 1u32;
pub const CERT_STORE_PROV_READ_CRL_FUNC: u32 = 5u32;
pub const CERT_STORE_PROV_READ_CTL_FUNC: u32 = 9u32;
pub const CERT_STORE_PROV_REG: windows_core::PCSTR = windows_core::PCSTR(4i32 as _);
pub const CERT_STORE_PROV_SERIALIZED: windows_core::PCSTR = windows_core::PCSTR(6i32 as _);
pub const CERT_STORE_PROV_SET_CERT_PROPERTY_FUNC: u32 = 4u32;
pub const CERT_STORE_PROV_SET_CRL_PROPERTY_FUNC: u32 = 8u32;
pub const CERT_STORE_PROV_SET_CTL_PROPERTY_FUNC: u32 = 12u32;
pub const CERT_STORE_PROV_SHARED_USER_FLAG: u32 = 64u32;
pub const CERT_STORE_PROV_SMART_CARD: i32 = 15i32;
pub const CERT_STORE_PROV_SMART_CARD_W: windows_core::PCSTR = windows_core::PCSTR(15i32 as _);
pub const CERT_STORE_PROV_SYSTEM: i32 = 10i32;
pub const CERT_STORE_PROV_SYSTEM_A: windows_core::PCSTR = windows_core::PCSTR(9i32 as _);
pub const CERT_STORE_PROV_SYSTEM_REGISTRY: i32 = 13i32;
pub const CERT_STORE_PROV_SYSTEM_REGISTRY_A: windows_core::PCSTR = windows_core::PCSTR(12i32 as _);
pub const CERT_STORE_PROV_SYSTEM_REGISTRY_W: windows_core::PCSTR = windows_core::PCSTR(13i32 as _);
pub const CERT_STORE_PROV_SYSTEM_STORE_FLAG: CERT_STORE_PROV_FLAGS = CERT_STORE_PROV_FLAGS(8u32);
pub const CERT_STORE_PROV_SYSTEM_W: windows_core::PCSTR = windows_core::PCSTR(10i32 as _);
pub const CERT_STORE_PROV_WRITE_ADD_FLAG: u32 = 1u32;
pub const CERT_STORE_PROV_WRITE_CERT_FUNC: u32 = 2u32;
pub const CERT_STORE_PROV_WRITE_CRL_FUNC: u32 = 6u32;
pub const CERT_STORE_PROV_WRITE_CTL_FUNC: u32 = 10u32;
pub const CERT_STORE_READONLY_FLAG: CERT_OPEN_STORE_FLAGS = CERT_OPEN_STORE_FLAGS(32768u32);
pub const CERT_STORE_REVOCATION_FLAG: u32 = 4u32;
pub const CERT_STORE_SAVE_AS_PKCS12: u32 = 3u32;
pub const CERT_STORE_SAVE_AS_PKCS7: CERT_STORE_SAVE_AS = CERT_STORE_SAVE_AS(2u32);
pub const CERT_STORE_SAVE_AS_STORE: CERT_STORE_SAVE_AS = CERT_STORE_SAVE_AS(1u32);
pub const CERT_STORE_SAVE_TO_FILE: CERT_STORE_SAVE_TO = CERT_STORE_SAVE_TO(1u32);
pub const CERT_STORE_SAVE_TO_FILENAME: CERT_STORE_SAVE_TO = CERT_STORE_SAVE_TO(4u32);
pub const CERT_STORE_SAVE_TO_FILENAME_A: CERT_STORE_SAVE_TO = CERT_STORE_SAVE_TO(3u32);
pub const CERT_STORE_SAVE_TO_FILENAME_W: CERT_STORE_SAVE_TO = CERT_STORE_SAVE_TO(4u32);
pub const CERT_STORE_SAVE_TO_MEMORY: CERT_STORE_SAVE_TO = CERT_STORE_SAVE_TO(2u32);
pub const CERT_STORE_SET_LOCALIZED_NAME_FLAG: CERT_OPEN_STORE_FLAGS = CERT_OPEN_STORE_FLAGS(2u32);
pub const CERT_STORE_SHARE_CONTEXT_FLAG: CERT_OPEN_STORE_FLAGS = CERT_OPEN_STORE_FLAGS(128u32);
pub const CERT_STORE_SHARE_STORE_FLAG: u32 = 64u32;
pub const CERT_STORE_SIGNATURE_FLAG: u32 = 1u32;
pub const CERT_STORE_TIME_VALIDITY_FLAG: u32 = 2u32;
pub const CERT_STORE_UNSAFE_PHYSICAL_FLAG: u32 = 32u32;
pub const CERT_STORE_UPDATE_KEYID_FLAG: CERT_OPEN_STORE_FLAGS = CERT_OPEN_STORE_FLAGS(1024u32);
pub const CERT_STRONG_SIGN_ECDSA_ALGORITHM: windows_core::PCWSTR = windows_core::w!("ECDSA");
pub const CERT_STRONG_SIGN_ENABLE_CRL_CHECK: CERT_STRONG_SIGN_FLAGS = CERT_STRONG_SIGN_FLAGS(1u32);
pub const CERT_STRONG_SIGN_ENABLE_OCSP_CHECK: CERT_STRONG_SIGN_FLAGS = CERT_STRONG_SIGN_FLAGS(2u32);
pub const CERT_STRONG_SIGN_OID_INFO_CHOICE: u32 = 2u32;
pub const CERT_STRONG_SIGN_SERIALIZED_INFO_CHOICE: u32 = 1u32;
pub const CERT_SUBJECT_DISABLE_CRL_PROP_ID: u32 = 86u32;
pub const CERT_SUBJECT_INFO_ACCESS_PROP_ID: u32 = 80u32;
pub const CERT_SUBJECT_NAME_MD5_HASH_PROP_ID: u32 = 29u32;
pub const CERT_SUBJECT_OCSP_AUTHORITY_INFO_ACCESS_PROP_ID: u32 = 85u32;
pub const CERT_SUBJECT_PUBLIC_KEY_MD5_HASH_PROP_ID: u32 = 25u32;
pub const CERT_SUBJECT_PUB_KEY_BIT_LENGTH_PROP_ID: u32 = 92u32;
pub const CERT_SYSTEM_STORE_CURRENT_SERVICE_ID: u32 = 4u32;
pub const CERT_SYSTEM_STORE_CURRENT_USER_GROUP_POLICY_ID: u32 = 7u32;
pub const CERT_SYSTEM_STORE_CURRENT_USER_ID: u32 = 1u32;
pub const CERT_SYSTEM_STORE_DEFER_READ_FLAG: u32 = 536870912u32;
pub const CERT_SYSTEM_STORE_LOCAL_MACHINE_ENTERPRISE_ID: u32 = 9u32;
pub const CERT_SYSTEM_STORE_LOCAL_MACHINE_GROUP_POLICY_ID: u32 = 8u32;
pub const CERT_SYSTEM_STORE_LOCAL_MACHINE_ID: u32 = 2u32;
pub const CERT_SYSTEM_STORE_LOCAL_MACHINE_WCOS_ID: u32 = 10u32;
pub const CERT_SYSTEM_STORE_LOCATION_MASK: CERT_SYSTEM_STORE_FLAGS = CERT_SYSTEM_STORE_FLAGS(16711680u32);
pub const CERT_SYSTEM_STORE_LOCATION_SHIFT: u32 = 16u32;
pub const CERT_SYSTEM_STORE_MASK: u32 = 4294901760u32;
pub const CERT_SYSTEM_STORE_RELOCATE_FLAG: CERT_SYSTEM_STORE_FLAGS = CERT_SYSTEM_STORE_FLAGS(2147483648u32);
pub const CERT_SYSTEM_STORE_SERVICES_ID: u32 = 5u32;
pub const CERT_SYSTEM_STORE_UNPROTECTED_FLAG: u32 = 1073741824u32;
pub const CERT_SYSTEM_STORE_USERS_ID: u32 = 6u32;
pub const CERT_TIMESTAMP_HASH_USE_TYPE: u32 = 2u32;
pub const CERT_TRUST_AUTO_UPDATE_CA_REVOCATION: u32 = 16u32;
pub const CERT_TRUST_AUTO_UPDATE_END_REVOCATION: u32 = 32u32;
pub const CERT_TRUST_BEFORE_DISALLOWED_CA_FILETIME: u32 = 2097152u32;
pub const CERT_TRUST_CTL_IS_NOT_SIGNATURE_VALID: u32 = 262144u32;
pub const CERT_TRUST_CTL_IS_NOT_TIME_VALID: u32 = 131072u32;
pub const CERT_TRUST_CTL_IS_NOT_VALID_FOR_USAGE: u32 = 524288u32;
pub const CERT_TRUST_HAS_ALLOW_WEAK_SIGNATURE: u32 = 131072u32;
pub const CERT_TRUST_HAS_AUTO_UPDATE_WEAK_SIGNATURE: u32 = 32768u32;
pub const CERT_TRUST_HAS_CRL_VALIDITY_EXTENDED: u32 = 4096u32;
pub const CERT_TRUST_HAS_EXACT_MATCH_ISSUER: u32 = 1u32;
pub const CERT_TRUST_HAS_EXCLUDED_NAME_CONSTRAINT: u32 = 32768u32;
pub const CERT_TRUST_HAS_ISSUANCE_CHAIN_POLICY: u32 = 512u32;
pub const CERT_TRUST_HAS_KEY_MATCH_ISSUER: u32 = 2u32;
pub const CERT_TRUST_HAS_NAME_MATCH_ISSUER: u32 = 4u32;
pub const CERT_TRUST_HAS_NOT_DEFINED_NAME_CONSTRAINT: u32 = 8192u32;
pub const CERT_TRUST_HAS_NOT_PERMITTED_NAME_CONSTRAINT: u32 = 16384u32;
pub const CERT_TRUST_HAS_NOT_SUPPORTED_CRITICAL_EXT: u32 = 134217728u32;
pub const CERT_TRUST_HAS_NOT_SUPPORTED_NAME_CONSTRAINT: u32 = 4096u32;
pub const CERT_TRUST_HAS_PREFERRED_ISSUER: u32 = 256u32;
pub const CERT_TRUST_HAS_VALID_NAME_CONSTRAINTS: u32 = 1024u32;
pub const CERT_TRUST_HAS_WEAK_HYGIENE: u32 = 2097152u32;
pub const CERT_TRUST_HAS_WEAK_SIGNATURE: u32 = 1048576u32;
pub const CERT_TRUST_INVALID_BASIC_CONSTRAINTS: u32 = 1024u32;
pub const CERT_TRUST_INVALID_EXTENSION: u32 = 256u32;
pub const CERT_TRUST_INVALID_NAME_CONSTRAINTS: u32 = 2048u32;
pub const CERT_TRUST_INVALID_POLICY_CONSTRAINTS: u32 = 512u32;
pub const CERT_TRUST_IS_CA_TRUSTED: u32 = 16384u32;
pub const CERT_TRUST_IS_COMPLEX_CHAIN: u32 = 65536u32;
pub const CERT_TRUST_IS_CYCLIC: u32 = 128u32;
pub const CERT_TRUST_IS_EXPLICIT_DISTRUST: u32 = 67108864u32;
pub const CERT_TRUST_IS_FROM_EXCLUSIVE_TRUST_STORE: u32 = 8192u32;
pub const CERT_TRUST_IS_KEY_ROLLOVER: u32 = 128u32;
pub const CERT_TRUST_IS_NOT_SIGNATURE_VALID: u32 = 8u32;
pub const CERT_TRUST_IS_NOT_TIME_NESTED: u32 = 2u32;
pub const CERT_TRUST_IS_NOT_TIME_VALID: u32 = 1u32;
pub const CERT_TRUST_IS_NOT_VALID_FOR_USAGE: u32 = 16u32;
pub const CERT_TRUST_IS_OFFLINE_REVOCATION: u32 = 16777216u32;
pub const CERT_TRUST_IS_PARTIAL_CHAIN: u32 = 65536u32;
pub const CERT_TRUST_IS_PEER_TRUSTED: u32 = 2048u32;
pub const CERT_TRUST_IS_REVOKED: u32 = 4u32;
pub const CERT_TRUST_IS_SELF_SIGNED: u32 = 8u32;
pub const CERT_TRUST_IS_UNTRUSTED_ROOT: u32 = 32u32;
pub const CERT_TRUST_NO_ERROR: u32 = 0u32;
pub const CERT_TRUST_NO_ISSUANCE_CHAIN_POLICY: u32 = 33554432u32;
pub const CERT_TRUST_NO_OCSP_FAILOVER_TO_CRL: u32 = 64u32;
pub const CERT_TRUST_NO_TIME_CHECK: u32 = 33554432u32;
pub const CERT_TRUST_PUB_ALLOW_END_USER_TRUST: u32 = 0u32;
pub const CERT_TRUST_PUB_ALLOW_ENTERPRISE_ADMIN_TRUST: u32 = 2u32;
pub const CERT_TRUST_PUB_ALLOW_MACHINE_ADMIN_TRUST: u32 = 1u32;
pub const CERT_TRUST_PUB_ALLOW_TRUST_MASK: u32 = 3u32;
pub const CERT_TRUST_PUB_AUTHENTICODE_FLAGS_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("AuthenticodeFlags");
pub const CERT_TRUST_PUB_CHECK_PUBLISHER_REV_FLAG: u32 = 256u32;
pub const CERT_TRUST_PUB_CHECK_TIMESTAMP_REV_FLAG: u32 = 512u32;
pub const CERT_TRUST_REVOCATION_STATUS_UNKNOWN: u32 = 64u32;
pub const CERT_TRUST_SSL_HANDSHAKE_OCSP: u32 = 262144u32;
pub const CERT_TRUST_SSL_RECONNECT_OCSP: u32 = 1048576u32;
pub const CERT_TRUST_SSL_TIME_VALID: u32 = 16777216u32;
pub const CERT_TRUST_SSL_TIME_VALID_OCSP: u32 = 524288u32;
pub const CERT_UNICODE_ATTR_ERR_INDEX_MASK: u32 = 63u32;
pub const CERT_UNICODE_ATTR_ERR_INDEX_SHIFT: u32 = 16u32;
pub const CERT_UNICODE_IS_RDN_ATTRS_FLAG: u32 = 1u32;
pub const CERT_UNICODE_RDN_ERR_INDEX_MASK: u32 = 1023u32;
pub const CERT_UNICODE_RDN_ERR_INDEX_SHIFT: u32 = 22u32;
pub const CERT_UNICODE_VALUE_ERR_INDEX_MASK: u32 = 65535u32;
pub const CERT_UNICODE_VALUE_ERR_INDEX_SHIFT: u32 = 0u32;
pub const CERT_V1: u32 = 0u32;
pub const CERT_V2: u32 = 1u32;
pub const CERT_V3: u32 = 2u32;
pub const CERT_VERIFY_ALLOW_MORE_USAGE_FLAG: u32 = 8u32;
pub const CERT_VERIFY_CACHE_ONLY_BASED_REVOCATION: u32 = 2u32;
pub const CERT_VERIFY_INHIBIT_CTL_UPDATE_FLAG: u32 = 1u32;
pub const CERT_VERIFY_NO_TIME_CHECK_FLAG: u32 = 4u32;
pub const CERT_VERIFY_REV_ACCUMULATIVE_TIMEOUT_FLAG: u32 = 4u32;
pub const CERT_VERIFY_REV_CHAIN_FLAG: u32 = 1u32;
pub const CERT_VERIFY_REV_NO_OCSP_FAILOVER_TO_CRL_FLAG: u32 = 16u32;
pub const CERT_VERIFY_REV_SERVER_OCSP_FLAG: u32 = 8u32;
pub const CERT_VERIFY_REV_SERVER_OCSP_WIRE_ONLY_FLAG: u32 = 32u32;
pub const CERT_VERIFY_TRUSTED_SIGNERS_FLAG: u32 = 2u32;
pub const CERT_VERIFY_UPDATED_CTL_FLAG: u32 = 1u32;
pub const CERT_X500_NAME_STR: CERT_STRING_TYPE = CERT_STRING_TYPE(3u32);
pub const CERT_XML_NAME_STR: u32 = 4u32;
pub const CMC_ADD_ATTRIBUTES: windows_core::PCSTR = windows_core::PCSTR(63i32 as _);
pub const CMC_ADD_EXTENSIONS: windows_core::PCSTR = windows_core::PCSTR(62i32 as _);
pub const CMC_DATA: windows_core::PCSTR = windows_core::PCSTR(59i32 as _);
pub const CMC_FAIL_BAD_ALG: u32 = 0u32;
pub const CMC_FAIL_BAD_CERT_ID: u32 = 4u32;
pub const CMC_FAIL_BAD_IDENTITY: u32 = 7u32;
pub const CMC_FAIL_BAD_MESSAGE_CHECK: u32 = 1u32;
pub const CMC_FAIL_BAD_REQUEST: u32 = 2u32;
pub const CMC_FAIL_BAD_TIME: u32 = 3u32;
pub const CMC_FAIL_INTERNAL_CA_ERROR: u32 = 11u32;
pub const CMC_FAIL_MUST_ARCHIVE_KEYS: u32 = 6u32;
pub const CMC_FAIL_NO_KEY_REUSE: u32 = 10u32;
pub const CMC_FAIL_POP_FAILED: u32 = 9u32;
pub const CMC_FAIL_POP_REQUIRED: u32 = 8u32;
pub const CMC_FAIL_TRY_LATER: u32 = 12u32;
pub const CMC_FAIL_UNSUPORTED_EXT: u32 = 5u32;
pub const CMC_OTHER_INFO_FAIL_CHOICE: u32 = 1u32;
pub const CMC_OTHER_INFO_NO_CHOICE: u32 = 0u32;
pub const CMC_OTHER_INFO_PEND_CHOICE: u32 = 2u32;
pub const CMC_RESPONSE: windows_core::PCSTR = windows_core::PCSTR(60i32 as _);
pub const CMC_STATUS: windows_core::PCSTR = windows_core::PCSTR(61i32 as _);
pub const CMC_STATUS_CONFIRM_REQUIRED: u32 = 5u32;
pub const CMC_STATUS_FAILED: u32 = 2u32;
pub const CMC_STATUS_NO_SUPPORT: u32 = 4u32;
pub const CMC_STATUS_PENDING: u32 = 3u32;
pub const CMC_STATUS_SUCCESS: u32 = 0u32;
pub const CMC_TAGGED_CERT_REQUEST_CHOICE: u32 = 1u32;
pub const CMSG_ATTR_CERT_COUNT_PARAM: u32 = 31u32;
pub const CMSG_ATTR_CERT_PARAM: u32 = 32u32;
pub const CMSG_AUTHENTICATED_ATTRIBUTES_FLAG: u32 = 8u32;
pub const CMSG_BARE_CONTENT_FLAG: u32 = 1u32;
pub const CMSG_BARE_CONTENT_PARAM: u32 = 3u32;
pub const CMSG_CERT_COUNT_PARAM: u32 = 11u32;
pub const CMSG_CERT_PARAM: u32 = 12u32;
pub const CMSG_CMS_ENCAPSULATED_CONTENT_FLAG: u32 = 64u32;
pub const CMSG_CMS_ENCAPSULATED_CTL_FLAG: u32 = 32768u32;
pub const CMSG_CMS_RECIPIENT_COUNT_PARAM: u32 = 33u32;
pub const CMSG_CMS_RECIPIENT_ENCRYPTED_KEY_INDEX_PARAM: u32 = 35u32;
pub const CMSG_CMS_RECIPIENT_INDEX_PARAM: u32 = 34u32;
pub const CMSG_CMS_RECIPIENT_INFO_PARAM: u32 = 36u32;
pub const CMSG_CMS_SIGNER_INFO_PARAM: u32 = 39u32;
pub const CMSG_COMPUTED_HASH_PARAM: u32 = 22u32;
pub const CMSG_CONTENTS_OCTETS_FLAG: u32 = 16u32;
pub const CMSG_CONTENT_ENCRYPT_FREE_OBJID_FLAG: u32 = 2u32;
pub const CMSG_CONTENT_ENCRYPT_FREE_PARA_FLAG: u32 = 1u32;
pub const CMSG_CONTENT_ENCRYPT_PAD_ENCODED_LEN_FLAG: u32 = 1u32;
pub const CMSG_CONTENT_ENCRYPT_RELEASE_CONTEXT_FLAG: u32 = 32768u32;
pub const CMSG_CONTENT_PARAM: u32 = 2u32;
pub const CMSG_CRL_COUNT_PARAM: u32 = 13u32;
pub const CMSG_CRL_PARAM: u32 = 14u32;
pub const CMSG_CRYPT_RELEASE_CONTEXT_FLAG: u32 = 32768u32;
pub const CMSG_CTRL_ADD_ATTR_CERT: u32 = 14u32;
pub const CMSG_CTRL_ADD_CERT: u32 = 10u32;
pub const CMSG_CTRL_ADD_CMS_SIGNER_INFO: u32 = 20u32;
pub const CMSG_CTRL_ADD_CRL: u32 = 12u32;
pub const CMSG_CTRL_ADD_SIGNER: u32 = 6u32;
pub const CMSG_CTRL_ADD_SIGNER_UNAUTH_ATTR: u32 = 8u32;
pub const CMSG_CTRL_DECRYPT: u32 = 2u32;
pub const CMSG_CTRL_DEL_ATTR_CERT: u32 = 15u32;
pub const CMSG_CTRL_DEL_CERT: u32 = 11u32;
pub const CMSG_CTRL_DEL_CRL: u32 = 13u32;
pub const CMSG_CTRL_DEL_SIGNER: u32 = 7u32;
pub const CMSG_CTRL_DEL_SIGNER_UNAUTH_ATTR: u32 = 9u32;
pub const CMSG_CTRL_ENABLE_STRONG_SIGNATURE: u32 = 21u32;
pub const CMSG_CTRL_KEY_AGREE_DECRYPT: u32 = 17u32;
pub const CMSG_CTRL_KEY_TRANS_DECRYPT: u32 = 16u32;
pub const CMSG_CTRL_MAIL_LIST_DECRYPT: u32 = 18u32;
pub const CMSG_CTRL_VERIFY_HASH: u32 = 5u32;
pub const CMSG_CTRL_VERIFY_SIGNATURE: u32 = 1u32;
pub const CMSG_CTRL_VERIFY_SIGNATURE_EX: u32 = 19u32;
pub const CMSG_DATA: CRYPT_MSG_TYPE = CRYPT_MSG_TYPE(1u32);
pub const CMSG_DEFAULT_INSTALLABLE_FUNC_OID: windows_core::PCSTR = windows_core::PCSTR(1i32 as _);
pub const CMSG_DETACHED_FLAG: u32 = 4u32;
pub const CMSG_ENCODED_MESSAGE: u32 = 29u32;
pub const CMSG_ENCODED_SIGNER: u32 = 28u32;
pub const CMSG_ENCODE_HASHED_SUBJECT_IDENTIFIER_FLAG: u32 = 2u32;
pub const CMSG_ENCODE_SORTED_CTL_FLAG: u32 = 1u32;
pub const CMSG_ENCODING_TYPE_MASK: u32 = 4294901760u32;
pub const CMSG_ENCRYPTED: u32 = 6u32;
pub const CMSG_ENCRYPTED_DIGEST: u32 = 27u32;
pub const CMSG_ENCRYPT_PARAM: u32 = 26u32;
pub const CMSG_ENVELOPED: CRYPT_MSG_TYPE = CRYPT_MSG_TYPE(3u32);
pub const CMSG_ENVELOPED_DATA_CMS_VERSION: u32 = 2u32;
pub const CMSG_ENVELOPED_DATA_PKCS_1_5_VERSION: u32 = 0u32;
pub const CMSG_ENVELOPED_DATA_V0: u32 = 0u32;
pub const CMSG_ENVELOPED_DATA_V2: u32 = 2u32;
pub const CMSG_ENVELOPED_RECIPIENT_V0: u32 = 0u32;
pub const CMSG_ENVELOPED_RECIPIENT_V2: u32 = 2u32;
pub const CMSG_ENVELOPED_RECIPIENT_V3: u32 = 3u32;
pub const CMSG_ENVELOPED_RECIPIENT_V4: u32 = 4u32;
pub const CMSG_ENVELOPE_ALGORITHM_PARAM: u32 = 15u32;
pub const CMSG_HASHED: CRYPT_MSG_TYPE = CRYPT_MSG_TYPE(5u32);
pub const CMSG_HASHED_DATA_CMS_VERSION: u32 = 2u32;
pub const CMSG_HASHED_DATA_PKCS_1_5_VERSION: u32 = 0u32;
pub const CMSG_HASHED_DATA_V0: u32 = 0u32;
pub const CMSG_HASHED_DATA_V2: u32 = 2u32;
pub const CMSG_HASH_ALGORITHM_PARAM: u32 = 20u32;
pub const CMSG_HASH_DATA_PARAM: u32 = 21u32;
pub const CMSG_INDEFINITE_LENGTH: u32 = 4294967295u32;
pub const CMSG_INNER_CONTENT_TYPE_PARAM: u32 = 4u32;
pub const CMSG_KEY_AGREE_ENCRYPT_FREE_MATERIAL_FLAG: u32 = 2u32;
pub const CMSG_KEY_AGREE_ENCRYPT_FREE_OBJID_FLAG: u32 = 32u32;
pub const CMSG_KEY_AGREE_ENCRYPT_FREE_PARA_FLAG: u32 = 1u32;
pub const CMSG_KEY_AGREE_ENCRYPT_FREE_PUBKEY_ALG_FLAG: u32 = 4u32;
pub const CMSG_KEY_AGREE_ENCRYPT_FREE_PUBKEY_BITS_FLAG: u32 = 16u32;
pub const CMSG_KEY_AGREE_ENCRYPT_FREE_PUBKEY_PARA_FLAG: u32 = 8u32;
pub const CMSG_KEY_AGREE_EPHEMERAL_KEY_CHOICE: CMSG_KEY_AGREE_OPTION = CMSG_KEY_AGREE_OPTION(1u32);
pub const CMSG_KEY_AGREE_ORIGINATOR_CERT: CMSG_KEY_AGREE_ORIGINATOR = CMSG_KEY_AGREE_ORIGINATOR(1u32);
pub const CMSG_KEY_AGREE_ORIGINATOR_PUBLIC_KEY: CMSG_KEY_AGREE_ORIGINATOR = CMSG_KEY_AGREE_ORIGINATOR(2u32);
pub const CMSG_KEY_AGREE_RECIPIENT: u32 = 2u32;
pub const CMSG_KEY_AGREE_STATIC_KEY_CHOICE: CMSG_KEY_AGREE_OPTION = CMSG_KEY_AGREE_OPTION(2u32);
pub const CMSG_KEY_AGREE_VERSION: u32 = 3u32;
pub const CMSG_KEY_TRANS_CMS_VERSION: u32 = 2u32;
pub const CMSG_KEY_TRANS_ENCRYPT_FREE_OBJID_FLAG: u32 = 2u32;
pub const CMSG_KEY_TRANS_ENCRYPT_FREE_PARA_FLAG: u32 = 1u32;
pub const CMSG_KEY_TRANS_PKCS_1_5_VERSION: u32 = 0u32;
pub const CMSG_KEY_TRANS_RECIPIENT: u32 = 1u32;
pub const CMSG_LENGTH_ONLY_FLAG: u32 = 2u32;
pub const CMSG_MAIL_LIST_ENCRYPT_FREE_OBJID_FLAG: u32 = 2u32;
pub const CMSG_MAIL_LIST_ENCRYPT_FREE_PARA_FLAG: u32 = 1u32;
pub const CMSG_MAIL_LIST_HANDLE_KEY_CHOICE: u32 = 1u32;
pub const CMSG_MAIL_LIST_RECIPIENT: u32 = 3u32;
pub const CMSG_MAIL_LIST_VERSION: u32 = 4u32;
pub const CMSG_MAX_LENGTH_FLAG: u32 = 32u32;
pub const CMSG_OID_CAPI1_EXPORT_KEY_AGREE_FUNC: windows_core::PCWSTR = windows_core::w!("CryptMsgDllExportKeyAgree");
pub const CMSG_OID_CAPI1_EXPORT_KEY_TRANS_FUNC: windows_core::PCWSTR = windows_core::w!("CryptMsgDllExportKeyTrans");
pub const CMSG_OID_CAPI1_EXPORT_MAIL_LIST_FUNC: windows_core::PCWSTR = windows_core::w!("CryptMsgDllExportMailList");
pub const CMSG_OID_CAPI1_GEN_CONTENT_ENCRYPT_KEY_FUNC: windows_core::PCWSTR = windows_core::w!("CryptMsgDllGenContentEncryptKey");
pub const CMSG_OID_CAPI1_IMPORT_KEY_AGREE_FUNC: windows_core::PCWSTR = windows_core::w!("CryptMsgDllImportKeyAgree");
pub const CMSG_OID_CAPI1_IMPORT_KEY_TRANS_FUNC: windows_core::PCWSTR = windows_core::w!("CryptMsgDllImportKeyTrans");
pub const CMSG_OID_CAPI1_IMPORT_MAIL_LIST_FUNC: windows_core::PCWSTR = windows_core::w!("CryptMsgDllImportMailList");
pub const CMSG_OID_CNG_EXPORT_KEY_AGREE_FUNC: windows_core::PCSTR = windows_core::s!("CryptMsgDllCNGExportKeyAgree");
pub const CMSG_OID_CNG_EXPORT_KEY_TRANS_FUNC: windows_core::PCSTR = windows_core::s!("CryptMsgDllCNGExportKeyTrans");
pub const CMSG_OID_CNG_GEN_CONTENT_ENCRYPT_KEY_FUNC: windows_core::PCSTR = windows_core::s!("CryptMsgDllCNGGenContentEncryptKey");
pub const CMSG_OID_CNG_IMPORT_CONTENT_ENCRYPT_KEY_FUNC: windows_core::PCSTR = windows_core::s!("CryptMsgDllCNGImportContentEncryptKey");
pub const CMSG_OID_CNG_IMPORT_KEY_AGREE_FUNC: windows_core::PCSTR = windows_core::s!("CryptMsgDllCNGImportKeyAgree");
pub const CMSG_OID_CNG_IMPORT_KEY_TRANS_FUNC: windows_core::PCSTR = windows_core::s!("CryptMsgDllCNGImportKeyTrans");
pub const CMSG_OID_EXPORT_ENCRYPT_KEY_FUNC: windows_core::PCSTR = windows_core::s!("CryptMsgDllExportEncryptKey");
pub const CMSG_OID_EXPORT_KEY_AGREE_FUNC: windows_core::PCSTR = windows_core::s!("CryptMsgDllExportKeyAgree");
pub const CMSG_OID_EXPORT_KEY_TRANS_FUNC: windows_core::PCSTR = windows_core::s!("CryptMsgDllExportKeyTrans");
pub const CMSG_OID_EXPORT_MAIL_LIST_FUNC: windows_core::PCSTR = windows_core::s!("CryptMsgDllExportMailList");
pub const CMSG_OID_GEN_CONTENT_ENCRYPT_KEY_FUNC: windows_core::PCSTR = windows_core::s!("CryptMsgDllGenContentEncryptKey");
pub const CMSG_OID_GEN_ENCRYPT_KEY_FUNC: windows_core::PCSTR = windows_core::s!("CryptMsgDllGenEncryptKey");
pub const CMSG_OID_IMPORT_ENCRYPT_KEY_FUNC: windows_core::PCSTR = windows_core::s!("CryptMsgDllImportEncryptKey");
pub const CMSG_OID_IMPORT_KEY_AGREE_FUNC: windows_core::PCSTR = windows_core::s!("CryptMsgDllImportKeyAgree");
pub const CMSG_OID_IMPORT_KEY_TRANS_FUNC: windows_core::PCSTR = windows_core::s!("CryptMsgDllImportKeyTrans");
pub const CMSG_OID_IMPORT_MAIL_LIST_FUNC: windows_core::PCSTR = windows_core::s!("CryptMsgDllImportMailList");
pub const CMSG_RC4_NO_SALT_FLAG: u32 = 1073741824u32;
pub const CMSG_RECIPIENT_COUNT_PARAM: u32 = 17u32;
pub const CMSG_RECIPIENT_INDEX_PARAM: u32 = 18u32;
pub const CMSG_RECIPIENT_INFO_PARAM: u32 = 19u32;
pub const CMSG_SIGNED: CRYPT_MSG_TYPE = CRYPT_MSG_TYPE(2u32);
pub const CMSG_SIGNED_AND_ENVELOPED: CRYPT_MSG_TYPE = CRYPT_MSG_TYPE(4u32);
pub const CMSG_SIGNED_DATA_CMS_VERSION: u32 = 3u32;
pub const CMSG_SIGNED_DATA_NO_SIGN_FLAG: u32 = 128u32;
pub const CMSG_SIGNED_DATA_PKCS_1_5_VERSION: u32 = 1u32;
pub const CMSG_SIGNED_DATA_V1: u32 = 1u32;
pub const CMSG_SIGNED_DATA_V3: u32 = 3u32;
pub const CMSG_SIGNER_AUTH_ATTR_PARAM: u32 = 9u32;
pub const CMSG_SIGNER_CERT_ID_PARAM: u32 = 38u32;
pub const CMSG_SIGNER_CERT_INFO_PARAM: u32 = 7u32;
pub const CMSG_SIGNER_COUNT_PARAM: u32 = 5u32;
pub const CMSG_SIGNER_HASH_ALGORITHM_PARAM: u32 = 8u32;
pub const CMSG_SIGNER_INFO_CMS_VERSION: u32 = 3u32;
pub const CMSG_SIGNER_INFO_PARAM: u32 = 6u32;
pub const CMSG_SIGNER_INFO_PKCS_1_5_VERSION: u32 = 1u32;
pub const CMSG_SIGNER_INFO_V1: u32 = 1u32;
pub const CMSG_SIGNER_INFO_V3: u32 = 3u32;
pub const CMSG_SIGNER_ONLY_FLAG: u32 = 2u32;
pub const CMSG_SIGNER_UNAUTH_ATTR_PARAM: u32 = 10u32;
pub const CMSG_SP3_COMPATIBLE_ENCRYPT_FLAG: u32 = 2147483648u32;
pub const CMSG_TRUSTED_SIGNER_FLAG: u32 = 1u32;
pub const CMSG_TYPE_PARAM: u32 = 1u32;
pub const CMSG_UNPROTECTED_ATTR_PARAM: u32 = 37u32;
pub const CMSG_USE_SIGNER_INDEX_FLAG: u32 = 4u32;
pub const CMSG_VERIFY_COUNTER_SIGN_ENABLE_STRONG_FLAG: u32 = 1u32;
pub const CMSG_VERIFY_SIGNER_CERT: u32 = 2u32;
pub const CMSG_VERIFY_SIGNER_CHAIN: u32 = 3u32;
pub const CMSG_VERIFY_SIGNER_NULL: u32 = 4u32;
pub const CMSG_VERIFY_SIGNER_PUBKEY: u32 = 1u32;
pub const CMSG_VERSION_PARAM: u32 = 30u32;
pub const CMS_SIGNER_INFO: windows_core::PCSTR = windows_core::PCSTR(501i32 as _);
pub const CNG_RSA_PRIVATE_KEY_BLOB: windows_core::PCSTR = windows_core::PCSTR(83i32 as _);
pub const CNG_RSA_PUBLIC_KEY_BLOB: windows_core::PCSTR = windows_core::PCSTR(72i32 as _);
pub const CONTEXT_OID_CAPI2_ANY: windows_core::PCSTR = windows_core::PCSTR(5i32 as _);
pub const CONTEXT_OID_CERTIFICATE: windows_core::PCSTR = windows_core::PCSTR(1i32 as _);
pub const CONTEXT_OID_CREATE_OBJECT_CONTEXT_FUNC: windows_core::PCSTR = windows_core::s!("ContextDllCreateObjectContext");
pub const CONTEXT_OID_CRL: windows_core::PCSTR = windows_core::PCSTR(2i32 as _);
pub const CONTEXT_OID_CTL: windows_core::PCSTR = windows_core::PCSTR(3i32 as _);
pub const CONTEXT_OID_OCSP_RESP: windows_core::PCSTR = windows_core::PCSTR(6i32 as _);
pub const CONTEXT_OID_PKCS7: windows_core::PCSTR = windows_core::PCSTR(4i32 as _);
pub const CREDENTIAL_OID_PASSWORD_CREDENTIALS: i32 = 2i32;
pub const CREDENTIAL_OID_PASSWORD_CREDENTIALS_A: windows_core::PCSTR = windows_core::PCSTR(1i32 as _);
pub const CREDENTIAL_OID_PASSWORD_CREDENTIALS_W: windows_core::PCSTR = windows_core::PCSTR(2i32 as _);
pub const CRL_DIST_POINT_ERR_CRL_ISSUER_BIT: i32 = -2147483648i32;
pub const CRL_DIST_POINT_ERR_INDEX_MASK: u32 = 127u32;
pub const CRL_DIST_POINT_ERR_INDEX_SHIFT: u32 = 24u32;
pub const CRL_DIST_POINT_FULL_NAME: u32 = 1u32;
pub const CRL_DIST_POINT_ISSUER_RDN_NAME: u32 = 2u32;
pub const CRL_DIST_POINT_NO_NAME: u32 = 0u32;
pub const CRL_FIND_ANY: u32 = 0u32;
pub const CRL_FIND_EXISTING: u32 = 2u32;
pub const CRL_FIND_ISSUED_BY: u32 = 1u32;
pub const CRL_FIND_ISSUED_BY_AKI_FLAG: u32 = 1u32;
pub const CRL_FIND_ISSUED_BY_BASE_FLAG: u32 = 8u32;
pub const CRL_FIND_ISSUED_BY_DELTA_FLAG: u32 = 4u32;
pub const CRL_FIND_ISSUED_BY_SIGNATURE_FLAG: u32 = 2u32;
pub const CRL_FIND_ISSUED_FOR: u32 = 3u32;
pub const CRL_FIND_ISSUED_FOR_SET_STRONG_PROPERTIES_FLAG: u32 = 16u32;
pub const CRL_REASON_AA_COMPROMISE: u32 = 10u32;
pub const CRL_REASON_AA_COMPROMISE_FLAG: u32 = 128u32;
pub const CRL_REASON_AFFILIATION_CHANGED: CERT_REVOCATION_STATUS_REASON = CERT_REVOCATION_STATUS_REASON(3u32);
pub const CRL_REASON_AFFILIATION_CHANGED_FLAG: u32 = 16u32;
pub const CRL_REASON_CA_COMPROMISE: CERT_REVOCATION_STATUS_REASON = CERT_REVOCATION_STATUS_REASON(2u32);
pub const CRL_REASON_CA_COMPROMISE_FLAG: u32 = 32u32;
pub const CRL_REASON_CERTIFICATE_HOLD: CERT_REVOCATION_STATUS_REASON = CERT_REVOCATION_STATUS_REASON(6u32);
pub const CRL_REASON_CERTIFICATE_HOLD_FLAG: u32 = 2u32;
pub const CRL_REASON_CESSATION_OF_OPERATION: CERT_REVOCATION_STATUS_REASON = CERT_REVOCATION_STATUS_REASON(5u32);
pub const CRL_REASON_CESSATION_OF_OPERATION_FLAG: u32 = 4u32;
pub const CRL_REASON_KEY_COMPROMISE: CERT_REVOCATION_STATUS_REASON = CERT_REVOCATION_STATUS_REASON(1u32);
pub const CRL_REASON_KEY_COMPROMISE_FLAG: u32 = 64u32;
pub const CRL_REASON_PRIVILEGE_WITHDRAWN: u32 = 9u32;
pub const CRL_REASON_PRIVILEGE_WITHDRAWN_FLAG: u32 = 1u32;
pub const CRL_REASON_REMOVE_FROM_CRL: CERT_REVOCATION_STATUS_REASON = CERT_REVOCATION_STATUS_REASON(8u32);
pub const CRL_REASON_SUPERSEDED: CERT_REVOCATION_STATUS_REASON = CERT_REVOCATION_STATUS_REASON(4u32);
pub const CRL_REASON_SUPERSEDED_FLAG: u32 = 8u32;
pub const CRL_REASON_UNSPECIFIED: CERT_REVOCATION_STATUS_REASON = CERT_REVOCATION_STATUS_REASON(0u32);
pub const CRL_REASON_UNUSED_FLAG: u32 = 128u32;
pub const CRL_V1: u32 = 0u32;
pub const CRL_V2: u32 = 1u32;
pub const CROSS_CERT_DIST_POINT_ERR_INDEX_MASK: u32 = 255u32;
pub const CROSS_CERT_DIST_POINT_ERR_INDEX_SHIFT: u32 = 24u32;
pub const CRYPTNET_CACHED_OCSP_SWITCH_TO_CRL_COUNT_DEFAULT: u32 = 50u32;
pub const CRYPTNET_CACHED_OCSP_SWITCH_TO_CRL_COUNT_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("CryptnetCachedOcspSwitchToCrlCount");
pub const CRYPTNET_CRL_BEFORE_OCSP_ENABLE: u32 = 4294967295u32;
pub const CRYPTNET_CRL_PRE_FETCH_DISABLE_INFORMATION_EVENTS_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("DisableInformationEvents");
pub const CRYPTNET_CRL_PRE_FETCH_LOG_FILE_NAME_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("LogFileName");
pub const CRYPTNET_CRL_PRE_FETCH_MAX_AGE_SECONDS_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("MaxAgeSeconds");
pub const CRYPTNET_CRL_PRE_FETCH_MIN_AFTER_NEXT_UPDATE_SECONDS_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("MinAfterNextUpdateSeconds");
pub const CRYPTNET_CRL_PRE_FETCH_MIN_BEFORE_NEXT_UPDATE_SECONDS_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("MinBeforeNextUpdateSeconds");
pub const CRYPTNET_CRL_PRE_FETCH_PROCESS_NAME_LIST_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("ProcessNameList");
pub const CRYPTNET_CRL_PRE_FETCH_PUBLISH_BEFORE_NEXT_UPDATE_SECONDS_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("PublishBeforeNextUpdateSeconds");
pub const CRYPTNET_CRL_PRE_FETCH_PUBLISH_RANDOM_INTERVAL_SECONDS_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("PublishRandomIntervalSeconds");
pub const CRYPTNET_CRL_PRE_FETCH_TIMEOUT_SECONDS_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("TimeoutSeconds");
pub const CRYPTNET_CRL_PRE_FETCH_URL_LIST_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("PreFetchUrlList");
pub const CRYPTNET_MAX_CACHED_OCSP_PER_CRL_COUNT_DEFAULT: u32 = 500u32;
pub const CRYPTNET_MAX_CACHED_OCSP_PER_CRL_COUNT_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("CryptnetMaxCachedOcspPerCrlCount");
pub const CRYPTNET_OCSP_AFTER_CRL_DISABLE: u32 = 4294967295u32;
pub const CRYPTNET_PRE_FETCH_AFTER_CURRENT_TIME_PRE_FETCH_PERIOD_SECONDS_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("CryptnetPreFetchAfterCurrentTimePreFetchPeriodSeconds");
pub const CRYPTNET_PRE_FETCH_AFTER_PUBLISH_PRE_FETCH_DIVISOR_DEFAULT: u32 = 10u32;
pub const CRYPTNET_PRE_FETCH_AFTER_PUBLISH_PRE_FETCH_DIVISOR_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("CryptnetPreFetchAfterPublishPreFetchDivisor");
pub const CRYPTNET_PRE_FETCH_BEFORE_NEXT_UPDATE_PRE_FETCH_DIVISOR_DEFAULT: u32 = 20u32;
pub const CRYPTNET_PRE_FETCH_BEFORE_NEXT_UPDATE_PRE_FETCH_DIVISOR_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("CryptnetPreFetchBeforeNextUpdatePreFetchDivisor");
pub const CRYPTNET_PRE_FETCH_MAX_AFTER_NEXT_UPDATE_PRE_FETCH_PERIOD_SECONDS_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("CryptnetPreFetchMaxAfterNextUpdatePreFetchPeriodSeconds");
pub const CRYPTNET_PRE_FETCH_MAX_MAX_AGE_SECONDS_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("CryptnetPreFetchMaxMaxAgeSeconds");
pub const CRYPTNET_PRE_FETCH_MIN_AFTER_NEXT_UPDATE_PRE_FETCH_PERIOD_SECONDS_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("CryptnetPreFetchMinAfterNextUpdatePreFetchPeriodSeconds");
pub const CRYPTNET_PRE_FETCH_MIN_BEFORE_NEXT_UPDATE_PRE_FETCH_PERIOD_SECONDS_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("CryptnetPreFetchMinBeforeNextUpdatePreFetchSeconds");
pub const CRYPTNET_PRE_FETCH_MIN_MAX_AGE_SECONDS_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("CryptnetPreFetchMinMaxAgeSeconds");
pub const CRYPTNET_PRE_FETCH_MIN_OCSP_VALIDITY_PERIOD_SECONDS_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("CryptnetPreFetchMinOcspValidityPeriodSeconds");
pub const CRYPTNET_PRE_FETCH_RETRIEVAL_TIMEOUT_SECONDS_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("CryptnetPreFetchRetrievalTimeoutSeconds");
pub const CRYPTNET_PRE_FETCH_SCAN_AFTER_TRIGGER_DELAY_SECONDS_DEFAULT: u32 = 60u32;
pub const CRYPTNET_PRE_FETCH_SCAN_AFTER_TRIGGER_DELAY_SECONDS_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("CryptnetPreFetchScanAfterTriggerDelaySeconds");
pub const CRYPTNET_PRE_FETCH_TRIGGER_DISABLE: u32 = 4294967295u32;
pub const CRYPTNET_PRE_FETCH_TRIGGER_PERIOD_SECONDS_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("CryptnetPreFetchTriggerPeriodSeconds");
pub const CRYPTNET_PRE_FETCH_VALIDITY_PERIOD_AFTER_NEXT_UPDATE_PRE_FETCH_DIVISOR_DEFAULT: u32 = 10u32;
pub const CRYPTNET_PRE_FETCH_VALIDITY_PERIOD_AFTER_NEXT_UPDATE_PRE_FETCH_DIVISOR_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("CryptnetPreFetchValidityPeriodAfterNextUpdatePreFetchDivisor");
pub const CRYPTNET_URL_CACHE_DEFAULT_FLUSH: u32 = 0u32;
pub const CRYPTNET_URL_CACHE_DEFAULT_FLUSH_EXEMPT_SECONDS_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("CryptnetDefaultFlushExemptSeconds");
pub const CRYPTNET_URL_CACHE_DISABLE_FLUSH: u32 = 4294967295u32;
pub const CRYPTNET_URL_CACHE_PRE_FETCH_AUTOROOT_CAB: u32 = 5u32;
pub const CRYPTNET_URL_CACHE_PRE_FETCH_BLOB: u32 = 1u32;
pub const CRYPTNET_URL_CACHE_PRE_FETCH_CRL: u32 = 2u32;
pub const CRYPTNET_URL_CACHE_PRE_FETCH_DISALLOWED_CERT_CAB: u32 = 6u32;
pub const CRYPTNET_URL_CACHE_PRE_FETCH_NONE: u32 = 0u32;
pub const CRYPTNET_URL_CACHE_PRE_FETCH_OCSP: u32 = 3u32;
pub const CRYPTNET_URL_CACHE_PRE_FETCH_PIN_RULES_CAB: u32 = 7u32;
pub const CRYPTNET_URL_CACHE_RESPONSE_HTTP: u32 = 1u32;
pub const CRYPTNET_URL_CACHE_RESPONSE_NONE: u32 = 0u32;
pub const CRYPTNET_URL_CACHE_RESPONSE_VALIDATED: u32 = 32768u32;
pub const CRYPTPROTECTMEMORY_BLOCK_SIZE: u32 = 16u32;
pub const CRYPTPROTECTMEMORY_CROSS_PROCESS: u32 = 1u32;
pub const CRYPTPROTECTMEMORY_SAME_LOGON: u32 = 2u32;
pub const CRYPTPROTECTMEMORY_SAME_PROCESS: u32 = 0u32;
pub const CRYPTPROTECT_AUDIT: u32 = 16u32;
pub const CRYPTPROTECT_CRED_REGENERATE: u32 = 128u32;
pub const CRYPTPROTECT_CRED_SYNC: u32 = 8u32;
pub const CRYPTPROTECT_DEFAULT_PROVIDER: windows_core::GUID = windows_core::GUID::from_u128(0xdf9d8cd0_1501_11d1_8c7a_00c04fc297eb);
pub const CRYPTPROTECT_FIRST_RESERVED_FLAGVAL: u32 = 268435455u32;
pub const CRYPTPROTECT_LAST_RESERVED_FLAGVAL: u32 = 4294967295u32;
pub const CRYPTPROTECT_LOCAL_MACHINE: u32 = 4u32;
pub const CRYPTPROTECT_NO_RECOVERY: u32 = 32u32;
pub const CRYPTPROTECT_PROMPT_ON_PROTECT: u32 = 2u32;
pub const CRYPTPROTECT_PROMPT_ON_UNPROTECT: u32 = 1u32;
pub const CRYPTPROTECT_PROMPT_REQUIRE_STRONG: u32 = 16u32;
pub const CRYPTPROTECT_PROMPT_RESERVED: u32 = 4u32;
pub const CRYPTPROTECT_PROMPT_STRONG: u32 = 8u32;
pub const CRYPTPROTECT_UI_FORBIDDEN: u32 = 1u32;
pub const CRYPTPROTECT_VERIFY_PROTECTION: u32 = 64u32;
pub const CRYPT_ACCUMULATIVE_TIMEOUT: u32 = 2048u32;
pub const CRYPT_ACQUIRE_ALLOW_NCRYPT_KEY_FLAG: CRYPT_ACQUIRE_FLAGS = CRYPT_ACQUIRE_FLAGS(65536u32);
pub const CRYPT_ACQUIRE_CACHE_FLAG: CRYPT_ACQUIRE_FLAGS = CRYPT_ACQUIRE_FLAGS(1u32);
pub const CRYPT_ACQUIRE_COMPARE_KEY_FLAG: CRYPT_ACQUIRE_FLAGS = CRYPT_ACQUIRE_FLAGS(4u32);
pub const CRYPT_ACQUIRE_NCRYPT_KEY_FLAGS_MASK: CRYPT_ACQUIRE_FLAGS = CRYPT_ACQUIRE_FLAGS(458752u32);
pub const CRYPT_ACQUIRE_NO_HEALING: CRYPT_ACQUIRE_FLAGS = CRYPT_ACQUIRE_FLAGS(8u32);
pub const CRYPT_ACQUIRE_ONLY_NCRYPT_KEY_FLAG: CRYPT_ACQUIRE_FLAGS = CRYPT_ACQUIRE_FLAGS(262144u32);
pub const CRYPT_ACQUIRE_PREFER_NCRYPT_KEY_FLAG: CRYPT_ACQUIRE_FLAGS = CRYPT_ACQUIRE_FLAGS(131072u32);
pub const CRYPT_ACQUIRE_SILENT_FLAG: CRYPT_ACQUIRE_FLAGS = CRYPT_ACQUIRE_FLAGS(64u32);
pub const CRYPT_ACQUIRE_USE_PROV_INFO_FLAG: CRYPT_ACQUIRE_FLAGS = CRYPT_ACQUIRE_FLAGS(2u32);
pub const CRYPT_ACQUIRE_WINDOW_HANDLE_FLAG: CRYPT_ACQUIRE_FLAGS = CRYPT_ACQUIRE_FLAGS(128u32);
pub const CRYPT_AIA_RETRIEVAL: u32 = 524288u32;
pub const CRYPT_ALL_FUNCTIONS: BCRYPT_RESOLVE_PROVIDERS_FLAGS = BCRYPT_RESOLVE_PROVIDERS_FLAGS(1u32);
pub const CRYPT_ALL_PROVIDERS: BCRYPT_RESOLVE_PROVIDERS_FLAGS = BCRYPT_RESOLVE_PROVIDERS_FLAGS(2u32);
pub const CRYPT_ANY: BCRYPT_QUERY_PROVIDER_MODE = BCRYPT_QUERY_PROVIDER_MODE(4u32);
pub const CRYPT_ARCHIVABLE: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(16384u32);
pub const CRYPT_ARCHIVE: u32 = 256u32;
pub const CRYPT_ASN_ENCODING: u32 = 1u32;
pub const CRYPT_ASYNC_RETRIEVAL: u32 = 16u32;
pub const CRYPT_BLOB_VER3: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(128u32);
pub const CRYPT_CACHE_ONLY_RETRIEVAL: u32 = 2u32;
pub const CRYPT_CHECK_FRESHNESS_TIME_VALIDITY: u32 = 1024u32;
pub const CRYPT_CREATE_IV: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(512u32);
pub const CRYPT_CREATE_NEW_FLUSH_ENTRY: u32 = 268435456u32;
pub const CRYPT_CREATE_SALT: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(4u32);
pub const CRYPT_DATA_KEY: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(2048u32);
pub const CRYPT_DECODE_ALLOC_FLAG: u32 = 32768u32;
pub const CRYPT_DECODE_ENABLE_PUNYCODE_FLAG: u32 = 33554432u32;
pub const CRYPT_DECODE_ENABLE_UTF8PERCENT_FLAG: u32 = 67108864u32;
pub const CRYPT_DECODE_NOCOPY_FLAG: u32 = 1u32;
pub const CRYPT_DECODE_NO_SIGNATURE_BYTE_REVERSAL_FLAG: u32 = 8u32;
pub const CRYPT_DECODE_SHARE_OID_STRING_FLAG: u32 = 4u32;
pub const CRYPT_DECODE_TO_BE_SIGNED_FLAG: u32 = 2u32;
pub const CRYPT_DECRYPT: u32 = 2u32;
pub const CRYPT_DECRYPT_RSA_NO_PADDING_CHECK: u32 = 32u32;
pub const CRYPT_DEFAULT_CONTAINER_OPTIONAL: u32 = 128u32;
pub const CRYPT_DEFAULT_CONTEXT: windows_core::PCWSTR = windows_core::w!("Default");
pub const CRYPT_DEFAULT_CONTEXT_AUTO_RELEASE_FLAG: CRYPT_DEFAULT_CONTEXT_FLAGS = CRYPT_DEFAULT_CONTEXT_FLAGS(1u32);
pub const CRYPT_DEFAULT_CONTEXT_CERT_SIGN_OID: CRYPT_DEFAULT_CONTEXT_TYPE = CRYPT_DEFAULT_CONTEXT_TYPE(1u32);
pub const CRYPT_DEFAULT_CONTEXT_MULTI_CERT_SIGN_OID: CRYPT_DEFAULT_CONTEXT_TYPE = CRYPT_DEFAULT_CONTEXT_TYPE(2u32);
pub const CRYPT_DEFAULT_CONTEXT_PROCESS_FLAG: CRYPT_DEFAULT_CONTEXT_FLAGS = CRYPT_DEFAULT_CONTEXT_FLAGS(2u32);
pub const CRYPT_DEFAULT_OID: windows_core::PCSTR = windows_core::s!("DEFAULT");
pub const CRYPT_DELETEKEYSET: u32 = 16u32;
pub const CRYPT_DELETE_DEFAULT: u32 = 4u32;
pub const CRYPT_DELETE_KEYSET: u32 = 16u32;
pub const CRYPT_DESTROYKEY: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(4u32);
pub const CRYPT_DOMAIN: BCRYPT_TABLE = BCRYPT_TABLE(2u32);
pub const CRYPT_DONT_CACHE_RESULT: u32 = 8u32;
pub const CRYPT_DONT_CHECK_TIME_VALIDITY: u32 = 512u32;
pub const CRYPT_DONT_VERIFY_SIGNATURE: u32 = 256u32;
pub const CRYPT_ECC_CMS_SHARED_INFO_SUPPPUBINFO_BYTE_LENGTH: u32 = 4u32;
pub const CRYPT_ECC_PRIVATE_KEY_INFO_v1: u32 = 1u32;
pub const CRYPT_ENABLE_FILE_RETRIEVAL: u32 = 134217728u32;
pub const CRYPT_ENABLE_SSL_REVOCATION_RETRIEVAL: u32 = 8388608u32;
pub const CRYPT_ENCODE_ALLOC_FLAG: CRYPT_ENCODE_OBJECT_FLAGS = CRYPT_ENCODE_OBJECT_FLAGS(32768u32);
pub const CRYPT_ENCODE_DECODE_NONE: u32 = 0u32;
pub const CRYPT_ENCODE_ENABLE_PUNYCODE_FLAG: CRYPT_ENCODE_OBJECT_FLAGS = CRYPT_ENCODE_OBJECT_FLAGS(131072u32);
pub const CRYPT_ENCODE_ENABLE_UTF8PERCENT_FLAG: u32 = 262144u32;
pub const CRYPT_ENCODE_NO_SIGNATURE_BYTE_REVERSAL_FLAG: u32 = 8u32;
pub const CRYPT_ENCRYPT: u32 = 1u32;
pub const CRYPT_ENCRYPT_ALG_OID_GROUP_ID: u32 = 2u32;
pub const CRYPT_ENHKEY_USAGE_OID_GROUP_ID: u32 = 7u32;
pub const CRYPT_EXCLUSIVE: CRYPT_CONTEXT_CONFIG_FLAGS = CRYPT_CONTEXT_CONFIG_FLAGS(1u32);
pub const CRYPT_EXPORT: u32 = 4u32;
pub const CRYPT_EXPORTABLE: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(1u32);
pub const CRYPT_EXPORT_KEY: u32 = 64u32;
pub const CRYPT_EXT_OR_ATTR_OID_GROUP_ID: u32 = 6u32;
pub const CRYPT_FAILED: u32 = 0u32;
pub const CRYPT_FASTSGC: u32 = 2u32;
pub const CRYPT_FIND_MACHINE_KEYSET_FLAG: CRYPT_FIND_FLAGS = CRYPT_FIND_FLAGS(2u32);
pub const CRYPT_FIND_SILENT_KEYSET_FLAG: CRYPT_FIND_FLAGS = CRYPT_FIND_FLAGS(64u32);
pub const CRYPT_FIND_USER_KEYSET_FLAG: CRYPT_FIND_FLAGS = CRYPT_FIND_FLAGS(1u32);
pub const CRYPT_FIRST: u32 = 1u32;
pub const CRYPT_FIRST_ALG_OID_GROUP_ID: u32 = 1u32;
pub const CRYPT_FLAG_IPSEC: u32 = 16u32;
pub const CRYPT_FLAG_PCT1: u32 = 1u32;
pub const CRYPT_FLAG_SIGNING: u32 = 32u32;
pub const CRYPT_FLAG_SSL2: u32 = 2u32;
pub const CRYPT_FLAG_SSL3: u32 = 4u32;
pub const CRYPT_FLAG_TLS1: u32 = 8u32;
pub const CRYPT_FORCE_KEY_PROTECTION_HIGH: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(32768u32);
pub const CRYPT_FORMAT_COMMA: u32 = 4096u32;
pub const CRYPT_FORMAT_CRLF: u32 = 512u32;
pub const CRYPT_FORMAT_OID: u32 = 4u32;
pub const CRYPT_FORMAT_RDN_CRLF: u32 = 512u32;
pub const CRYPT_FORMAT_RDN_REVERSE: u32 = 2048u32;
pub const CRYPT_FORMAT_RDN_SEMICOLON: u32 = 256u32;
pub const CRYPT_FORMAT_RDN_UNQUOTE: u32 = 1024u32;
pub const CRYPT_FORMAT_SEMICOLON: u32 = 256u32;
pub const CRYPT_FORMAT_SIMPLE: u32 = 1u32;
pub const CRYPT_FORMAT_STR_MULTI_LINE: u32 = 1u32;
pub const CRYPT_FORMAT_STR_NO_HEX: u32 = 16u32;
pub const CRYPT_FORMAT_X509: u32 = 2u32;
pub const CRYPT_GET_INSTALLED_OID_FUNC_FLAG: u32 = 1u32;
pub const CRYPT_GET_URL_FROM_AUTH_ATTRIBUTE: CRYPT_GET_URL_FLAGS = CRYPT_GET_URL_FLAGS(8u32);
pub const CRYPT_GET_URL_FROM_EXTENSION: CRYPT_GET_URL_FLAGS = CRYPT_GET_URL_FLAGS(2u32);
pub const CRYPT_GET_URL_FROM_PROPERTY: CRYPT_GET_URL_FLAGS = CRYPT_GET_URL_FLAGS(1u32);
pub const CRYPT_GET_URL_FROM_UNAUTH_ATTRIBUTE: CRYPT_GET_URL_FLAGS = CRYPT_GET_URL_FLAGS(4u32);
pub const CRYPT_HASH_ALG_OID_GROUP_ID: u32 = 1u32;
pub const CRYPT_HTTP_POST_RETRIEVAL: u32 = 1048576u32;
pub const CRYPT_IMPL_HARDWARE: u32 = 1u32;
pub const CRYPT_IMPL_MIXED: u32 = 3u32;
pub const CRYPT_IMPL_REMOVABLE: u32 = 8u32;
pub const CRYPT_IMPL_SOFTWARE: u32 = 2u32;
pub const CRYPT_IMPL_UNKNOWN: u32 = 4u32;
pub const CRYPT_IMPORT_KEY: u32 = 128u32;
pub const CRYPT_INITIATOR: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(64u32);
pub const CRYPT_INSTALL_OID_FUNC_BEFORE_FLAG: u32 = 1u32;
pub const CRYPT_INSTALL_OID_INFO_BEFORE_FLAG: u32 = 1u32;
pub const CRYPT_IPSEC_HMAC_KEY: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(256u32);
pub const CRYPT_KDF_OID_GROUP_ID: u32 = 10u32;
pub const CRYPT_KEEP_TIME_VALID: u32 = 128u32;
pub const CRYPT_KEK: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(1024u32);
pub const CRYPT_KEYID_ALLOC_FLAG: u32 = 32768u32;
pub const CRYPT_KEYID_DELETE_FLAG: u32 = 16u32;
pub const CRYPT_KEYID_MACHINE_FLAG: u32 = 32u32;
pub const CRYPT_KEYID_SET_NEW_FLAG: u32 = 8192u32;
pub const CRYPT_KM: BCRYPT_QUERY_PROVIDER_MODE = BCRYPT_QUERY_PROVIDER_MODE(2u32);
pub const CRYPT_LAST_ALG_OID_GROUP_ID: u32 = 4u32;
pub const CRYPT_LAST_OID_GROUP_ID: u32 = 10u32;
pub const CRYPT_LDAP_AREC_EXCLUSIVE_RETRIEVAL: u32 = 262144u32;
pub const CRYPT_LDAP_INSERT_ENTRY_ATTRIBUTE: u32 = 32768u32;
pub const CRYPT_LDAP_SCOPE_BASE_ONLY_RETRIEVAL: u32 = 8192u32;
pub const CRYPT_LDAP_SIGN_RETRIEVAL: u32 = 65536u32;
pub const CRYPT_LITTLE_ENDIAN: u32 = 1u32;
pub const CRYPT_LOCAL: BCRYPT_TABLE = BCRYPT_TABLE(1u32);
pub const CRYPT_LOCALIZED_NAME_ENCODING_TYPE: u32 = 0u32;
pub const CRYPT_LOCALIZED_NAME_OID: windows_core::PCSTR = windows_core::s!("LocalizedNames");
pub const CRYPT_MAC: u32 = 32u32;
pub const CRYPT_MACHINE_DEFAULT: u32 = 1u32;
pub const CRYPT_MACHINE_KEYSET: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(32u32);
pub const CRYPT_MATCH_ANY_ENCODING_TYPE: u32 = 4294967295u32;
pub const CRYPT_MESSAGE_BARE_CONTENT_OUT_FLAG: u32 = 1u32;
pub const CRYPT_MESSAGE_ENCAPSULATED_CONTENT_OUT_FLAG: u32 = 2u32;
pub const CRYPT_MESSAGE_KEYID_RECIPIENT_FLAG: u32 = 4u32;
pub const CRYPT_MESSAGE_KEYID_SIGNER_FLAG: u32 = 4u32;
pub const CRYPT_MESSAGE_SILENT_KEYSET_FLAG: u32 = 64u32;
pub const CRYPT_MIN_DEPENDENCIES: CRYPT_IMAGE_REF_FLAGS = CRYPT_IMAGE_REF_FLAGS(1u32);
pub const CRYPT_MM: BCRYPT_QUERY_PROVIDER_MODE = BCRYPT_QUERY_PROVIDER_MODE(3u32);
pub const CRYPT_MODE_CBC: u32 = 1u32;
pub const CRYPT_MODE_CBCI: u32 = 6u32;
pub const CRYPT_MODE_CBCOFM: u32 = 9u32;
pub const CRYPT_MODE_CBCOFMI: u32 = 10u32;
pub const CRYPT_MODE_CFB: u32 = 4u32;
pub const CRYPT_MODE_CFBP: u32 = 7u32;
pub const CRYPT_MODE_CTS: u32 = 5u32;
pub const CRYPT_MODE_ECB: u32 = 2u32;
pub const CRYPT_MODE_OFB: u32 = 3u32;
pub const CRYPT_MODE_OFBP: u32 = 8u32;
pub const CRYPT_NDR_ENCODING: u32 = 2u32;
pub const CRYPT_NEWKEYSET: u32 = 8u32;
pub const CRYPT_NEXT: u32 = 2u32;
pub const CRYPT_NOHASHOID: u32 = 1u32;
pub const CRYPT_NOT_MODIFIED_RETRIEVAL: u32 = 4194304u32;
pub const CRYPT_NO_AUTH_RETRIEVAL: u32 = 131072u32;
pub const CRYPT_NO_OCSP_FAILOVER_TO_CRL_RETRIEVAL: u32 = 33554432u32;
pub const CRYPT_NO_SALT: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(16u32);
pub const CRYPT_OAEP: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(64u32);
pub const CRYPT_OBJECT_LOCATOR_FIRST_RESERVED_USER_NAME_TYPE: u32 = 33u32;
pub const CRYPT_OBJECT_LOCATOR_LAST_RESERVED_NAME_TYPE: u32 = 32u32;
pub const CRYPT_OBJECT_LOCATOR_LAST_RESERVED_USER_NAME_TYPE: u32 = 65535u32;
pub const CRYPT_OBJECT_LOCATOR_RELEASE_DLL_UNLOAD: CRYPT_OBJECT_LOCATOR_RELEASE_REASON = CRYPT_OBJECT_LOCATOR_RELEASE_REASON(4u32);
pub const CRYPT_OBJECT_LOCATOR_RELEASE_PROCESS_EXIT: CRYPT_OBJECT_LOCATOR_RELEASE_REASON = CRYPT_OBJECT_LOCATOR_RELEASE_REASON(3u32);
pub const CRYPT_OBJECT_LOCATOR_RELEASE_SERVICE_STOP: CRYPT_OBJECT_LOCATOR_RELEASE_REASON = CRYPT_OBJECT_LOCATOR_RELEASE_REASON(2u32);
pub const CRYPT_OBJECT_LOCATOR_RELEASE_SYSTEM_SHUTDOWN: CRYPT_OBJECT_LOCATOR_RELEASE_REASON = CRYPT_OBJECT_LOCATOR_RELEASE_REASON(1u32);
pub const CRYPT_OBJECT_LOCATOR_SPN_NAME_TYPE: u32 = 1u32;
pub const CRYPT_OCSP_ONLY_RETRIEVAL: u32 = 16777216u32;
pub const CRYPT_OFFLINE_CHECK_RETRIEVAL: u32 = 16384u32;
pub const CRYPT_OID_CREATE_COM_OBJECT_FUNC: windows_core::PCSTR = windows_core::s!("CryptDllCreateCOMObject");
pub const CRYPT_OID_DECODE_OBJECT_EX_FUNC: windows_core::PCSTR = windows_core::s!("CryptDllDecodeObjectEx");
pub const CRYPT_OID_DECODE_OBJECT_FUNC: windows_core::PCSTR = windows_core::s!("CryptDllDecodeObject");
pub const CRYPT_OID_DISABLE_SEARCH_DS_FLAG: u32 = 2147483648u32;
pub const CRYPT_OID_ENCODE_OBJECT_EX_FUNC: windows_core::PCSTR = windows_core::s!("CryptDllEncodeObjectEx");
pub const CRYPT_OID_ENCODE_OBJECT_FUNC: windows_core::PCSTR = windows_core::s!("CryptDllEncodeObject");
pub const CRYPT_OID_ENUM_PHYSICAL_STORE_FUNC: windows_core::PCSTR = windows_core::s!("CertDllEnumPhysicalStore");
pub const CRYPT_OID_ENUM_SYSTEM_STORE_FUNC: windows_core::PCSTR = windows_core::s!("CertDllEnumSystemStore");
pub const CRYPT_OID_EXPORT_PRIVATE_KEY_INFO_FUNC: windows_core::PCSTR = windows_core::s!("CryptDllExportPrivateKeyInfoEx");
pub const CRYPT_OID_EXPORT_PUBLIC_KEY_INFO_EX2_FUNC: windows_core::PCSTR = windows_core::s!("CryptDllExportPublicKeyInfoEx2");
pub const CRYPT_OID_EXPORT_PUBLIC_KEY_INFO_FROM_BCRYPT_HANDLE_FUNC: windows_core::PCSTR = windows_core::s!("CryptDllExportPublicKeyInfoFromBCryptKeyHandle");
pub const CRYPT_OID_EXPORT_PUBLIC_KEY_INFO_FUNC: windows_core::PCSTR = windows_core::s!("CryptDllExportPublicKeyInfoEx");
pub const CRYPT_OID_EXTRACT_ENCODED_SIGNATURE_PARAMETERS_FUNC: windows_core::PCSTR = windows_core::s!("CryptDllExtractEncodedSignatureParameters");
pub const CRYPT_OID_FIND_LOCALIZED_NAME_FUNC: windows_core::PCSTR = windows_core::s!("CryptDllFindLocalizedName");
pub const CRYPT_OID_FIND_OID_INFO_FUNC: windows_core::PCSTR = windows_core::s!("CryptDllFindOIDInfo");
pub const CRYPT_OID_FORMAT_OBJECT_FUNC: windows_core::PCSTR = windows_core::s!("CryptDllFormatObject");
pub const CRYPT_OID_IMPORT_PRIVATE_KEY_INFO_FUNC: windows_core::PCSTR = windows_core::s!("CryptDllImportPrivateKeyInfoEx");
pub const CRYPT_OID_IMPORT_PUBLIC_KEY_INFO_EX2_FUNC: windows_core::PCSTR = windows_core::s!("CryptDllImportPublicKeyInfoEx2");
pub const CRYPT_OID_IMPORT_PUBLIC_KEY_INFO_FUNC: windows_core::PCSTR = windows_core::s!("CryptDllImportPublicKeyInfoEx");
pub const CRYPT_OID_INFO_ALGID_KEY: u32 = 3u32;
pub const CRYPT_OID_INFO_CNG_ALGID_KEY: u32 = 5u32;
pub const CRYPT_OID_INFO_CNG_SIGN_KEY: u32 = 6u32;
pub const CRYPT_OID_INFO_ECC_PARAMETERS_ALGORITHM: windows_core::PCWSTR = windows_core::w!("CryptOIDInfoECCParameters");
pub const CRYPT_OID_INFO_ECC_WRAP_PARAMETERS_ALGORITHM: windows_core::PCWSTR = windows_core::w!("CryptOIDInfoECCWrapParameters");
pub const CRYPT_OID_INFO_HASH_PARAMETERS_ALGORITHM: windows_core::PCWSTR = windows_core::w!("CryptOIDInfoHashParameters");
pub const CRYPT_OID_INFO_MGF1_PARAMETERS_ALGORITHM: windows_core::PCWSTR = windows_core::w!("CryptOIDInfoMgf1Parameters");
pub const CRYPT_OID_INFO_NAME_KEY: u32 = 2u32;
pub const CRYPT_OID_INFO_NO_PARAMETERS_ALGORITHM: windows_core::PCWSTR = windows_core::w!("CryptOIDInfoNoParameters");
pub const CRYPT_OID_INFO_NO_SIGN_ALGORITHM: windows_core::PCWSTR = windows_core::w!("CryptOIDInfoNoSign");
pub const CRYPT_OID_INFO_OAEP_PARAMETERS_ALGORITHM: windows_core::PCWSTR = windows_core::w!("CryptOIDInfoOAEPParameters");
pub const CRYPT_OID_INFO_OID_GROUP_BIT_LEN_MASK: u32 = 268369920u32;
pub const CRYPT_OID_INFO_OID_GROUP_BIT_LEN_SHIFT: u32 = 16u32;
pub const CRYPT_OID_INFO_OID_KEY: u32 = 1u32;
pub const CRYPT_OID_INFO_OID_KEY_FLAGS_MASK: u32 = 4294901760u32;
pub const CRYPT_OID_INFO_PUBKEY_ENCRYPT_KEY_FLAG: CRYPT_IMPORT_PUBLIC_KEY_FLAGS = CRYPT_IMPORT_PUBLIC_KEY_FLAGS(1073741824u32);
pub const CRYPT_OID_INFO_PUBKEY_SIGN_KEY_FLAG: CRYPT_IMPORT_PUBLIC_KEY_FLAGS = CRYPT_IMPORT_PUBLIC_KEY_FLAGS(2147483648u32);
pub const CRYPT_OID_INFO_SIGN_KEY: u32 = 4u32;
pub const CRYPT_OID_INHIBIT_SIGNATURE_FORMAT_FLAG: u32 = 1u32;
pub const CRYPT_OID_NO_NULL_ALGORITHM_PARA_FLAG: u32 = 4u32;
pub const CRYPT_OID_OPEN_STORE_PROV_FUNC: windows_core::PCSTR = windows_core::s!("CertDllOpenStoreProv");
pub const CRYPT_OID_OPEN_SYSTEM_STORE_PROV_FUNC: windows_core::PCSTR = windows_core::s!("CertDllOpenSystemStoreProv");
pub const CRYPT_OID_PREFER_CNG_ALGID_FLAG: u32 = 1073741824u32;
pub const CRYPT_OID_PUBKEY_ENCRYPT_ONLY_FLAG: u32 = 1073741824u32;
pub const CRYPT_OID_PUBKEY_SIGN_ONLY_FLAG: u32 = 2147483648u32;
pub const CRYPT_OID_REGISTER_PHYSICAL_STORE_FUNC: windows_core::PCSTR = windows_core::s!("CertDllRegisterPhysicalStore");
pub const CRYPT_OID_REGISTER_SYSTEM_STORE_FUNC: windows_core::PCSTR = windows_core::s!("CertDllRegisterSystemStore");
pub const CRYPT_OID_REGPATH: windows_core::PCSTR = windows_core::s!("Software\\Microsoft\\Cryptography\\OID");
pub const CRYPT_OID_REG_DLL_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("Dll");
pub const CRYPT_OID_REG_ENCODING_TYPE_PREFIX: windows_core::PCSTR = windows_core::s!("EncodingType ");
pub const CRYPT_OID_REG_FLAGS_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("CryptFlags");
pub const CRYPT_OID_REG_FUNC_NAME_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("FuncName");
pub const CRYPT_OID_REG_FUNC_NAME_VALUE_NAME_A: windows_core::PCSTR = windows_core::s!("FuncName");
pub const CRYPT_OID_SIGN_AND_ENCODE_HASH_FUNC: windows_core::PCSTR = windows_core::s!("CryptDllSignAndEncodeHash");
pub const CRYPT_OID_SYSTEM_STORE_LOCATION_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("SystemStoreLocation");
pub const CRYPT_OID_UNREGISTER_PHYSICAL_STORE_FUNC: windows_core::PCSTR = windows_core::s!("CertDllUnregisterPhysicalStore");
pub const CRYPT_OID_UNREGISTER_SYSTEM_STORE_FUNC: windows_core::PCSTR = windows_core::s!("CertDllUnregisterSystemStore");
pub const CRYPT_OID_USE_CURVE_NAME_FOR_ENCODE_FLAG: u32 = 536870912u32;
pub const CRYPT_OID_USE_CURVE_PARAMETERS_FOR_ENCODE_FLAG: u32 = 268435456u32;
pub const CRYPT_OID_USE_PUBKEY_PARA_FOR_PKCS7_FLAG: u32 = 2u32;
pub const CRYPT_OID_VERIFY_CERTIFICATE_CHAIN_POLICY_FUNC: windows_core::PCSTR = windows_core::s!("CertDllVerifyCertificateChainPolicy");
pub const CRYPT_OID_VERIFY_CTL_USAGE_FUNC: windows_core::PCSTR = windows_core::s!("CertDllVerifyCTLUsage");
pub const CRYPT_OID_VERIFY_ENCODED_SIGNATURE_FUNC: windows_core::PCSTR = windows_core::s!("CryptDllVerifyEncodedSignature");
pub const CRYPT_OID_VERIFY_REVOCATION_FUNC: windows_core::PCSTR = windows_core::s!("CertDllVerifyRevocation");
pub const CRYPT_ONLINE: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(128u32);
pub const CRYPT_OVERRIDE: CRYPT_CONTEXT_CONFIG_FLAGS = CRYPT_CONTEXT_CONFIG_FLAGS(65536u32);
pub const CRYPT_OVERWRITE: u32 = 1u32;
pub const CRYPT_OWF_REPL_LM_HASH: u32 = 1u32;
pub const CRYPT_PARAM_ASYNC_RETRIEVAL_COMPLETION: windows_core::PCSTR = windows_core::PCSTR(1i32 as _);
pub const CRYPT_PARAM_CANCEL_ASYNC_RETRIEVAL: windows_core::PCSTR = windows_core::PCSTR(2i32 as _);
pub const CRYPT_POLICY_OID_GROUP_ID: u32 = 8u32;
pub const CRYPT_PREGEN: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(64u32);
pub const CRYPT_PRIORITY_BOTTOM: u32 = 4294967295u32;
pub const CRYPT_PRIORITY_TOP: u32 = 0u32;
pub const CRYPT_PROCESS_ISOLATE: CRYPT_IMAGE_REF_FLAGS = CRYPT_IMAGE_REF_FLAGS(65536u32);
pub const CRYPT_PROXY_CACHE_RETRIEVAL: u32 = 2097152u32;
pub const CRYPT_PSTORE: u32 = 2u32;
pub const CRYPT_PUBKEY_ALG_OID_GROUP_ID: u32 = 3u32;
pub const CRYPT_RANDOM_QUERY_STRING_RETRIEVAL: u32 = 67108864u32;
pub const CRYPT_RC2_128BIT_VERSION: u32 = 58u32;
pub const CRYPT_RC2_40BIT_VERSION: u32 = 160u32;
pub const CRYPT_RC2_56BIT_VERSION: u32 = 52u32;
pub const CRYPT_RC2_64BIT_VERSION: u32 = 120u32;
pub const CRYPT_RDN_ATTR_OID_GROUP_ID: u32 = 5u32;
pub const CRYPT_READ: u32 = 8u32;
pub const CRYPT_RECIPIENT: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(16u32);
pub const CRYPT_REGISTER_FIRST_INDEX: u32 = 0u32;
pub const CRYPT_REGISTER_LAST_INDEX: u32 = 4294967295u32;
pub const CRYPT_RETRIEVE_MAX_ERROR_CONTENT_LENGTH: u32 = 4096u32;
pub const CRYPT_RETRIEVE_MULTIPLE_OBJECTS: u32 = 1u32;
pub const CRYPT_SECRETDIGEST: u32 = 1u32;
pub const CRYPT_SEC_DESCR: u32 = 1u32;
pub const CRYPT_SERVER: u32 = 1024u32;
pub const CRYPT_SF: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(256u32);
pub const CRYPT_SGC: u32 = 1u32;
pub const CRYPT_SGCKEY: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(8192u32);
pub const CRYPT_SGC_ENUM: u32 = 4u32;
pub const CRYPT_SIGN_ALG_OID_GROUP_ID: u32 = 4u32;
pub const CRYPT_SILENT: u32 = 64u32;
pub const CRYPT_SORTED_CTL_ENCODE_HASHED_SUBJECT_IDENTIFIER_FLAG: u32 = 65536u32;
pub const CRYPT_SSL2_FALLBACK: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(2u32);
pub const CRYPT_STICKY_CACHE_RETRIEVAL: u32 = 4096u32;
pub const CRYPT_STRING_ANY: CRYPT_STRING = CRYPT_STRING(7u32);
pub const CRYPT_STRING_BASE64: CRYPT_STRING = CRYPT_STRING(1u32);
pub const CRYPT_STRING_BASE64HEADER: CRYPT_STRING = CRYPT_STRING(0u32);
pub const CRYPT_STRING_BASE64REQUESTHEADER: CRYPT_STRING = CRYPT_STRING(3u32);
pub const CRYPT_STRING_BASE64URI: u32 = 13u32;
pub const CRYPT_STRING_BASE64X509CRLHEADER: CRYPT_STRING = CRYPT_STRING(9u32);
pub const CRYPT_STRING_BASE64_ANY: CRYPT_STRING = CRYPT_STRING(6u32);
pub const CRYPT_STRING_BINARY: CRYPT_STRING = CRYPT_STRING(2u32);
pub const CRYPT_STRING_ENCODEMASK: u32 = 255u32;
pub const CRYPT_STRING_HASHDATA: u32 = 268435456u32;
pub const CRYPT_STRING_HEX: CRYPT_STRING = CRYPT_STRING(4u32);
pub const CRYPT_STRING_HEXADDR: CRYPT_STRING = CRYPT_STRING(10u32);
pub const CRYPT_STRING_HEXASCII: CRYPT_STRING = CRYPT_STRING(5u32);
pub const CRYPT_STRING_HEXASCIIADDR: CRYPT_STRING = CRYPT_STRING(11u32);
pub const CRYPT_STRING_HEXRAW: CRYPT_STRING = CRYPT_STRING(12u32);
pub const CRYPT_STRING_HEX_ANY: CRYPT_STRING = CRYPT_STRING(8u32);
pub const CRYPT_STRING_NOCR: u32 = 2147483648u32;
pub const CRYPT_STRING_NOCRLF: u32 = 1073741824u32;
pub const CRYPT_STRING_PERCENTESCAPE: u32 = 134217728u32;
pub const CRYPT_STRING_RESERVED100: u32 = 256u32;
pub const CRYPT_STRING_RESERVED200: u32 = 512u32;
pub const CRYPT_STRING_STRICT: CRYPT_STRING = CRYPT_STRING(536870912u32);
pub const CRYPT_SUCCEED: u32 = 1u32;
pub const CRYPT_TEMPLATE_OID_GROUP_ID: u32 = 9u32;
pub const CRYPT_TYPE2_FORMAT: u32 = 2u32;
pub const CRYPT_UI_PROMPT: u32 = 4u32;
pub const CRYPT_UM: BCRYPT_QUERY_PROVIDER_MODE = BCRYPT_QUERY_PROVIDER_MODE(1u32);
pub const CRYPT_UNICODE_NAME_DECODE_DISABLE_IE4_UTF8_FLAG: u32 = 16777216u32;
pub const CRYPT_UNICODE_NAME_ENCODE_DISABLE_CHECK_TYPE_FLAG: CRYPT_ENCODE_OBJECT_FLAGS = CRYPT_ENCODE_OBJECT_FLAGS(1073741824u32);
pub const CRYPT_UNICODE_NAME_ENCODE_ENABLE_T61_UNICODE_FLAG: CRYPT_ENCODE_OBJECT_FLAGS = CRYPT_ENCODE_OBJECT_FLAGS(2147483648u32);
pub const CRYPT_UNICODE_NAME_ENCODE_ENABLE_UTF8_UNICODE_FLAG: CRYPT_ENCODE_OBJECT_FLAGS = CRYPT_ENCODE_OBJECT_FLAGS(536870912u32);
pub const CRYPT_UNICODE_NAME_ENCODE_FORCE_UTF8_UNICODE_FLAG: u32 = 268435456u32;
pub const CRYPT_UPDATE_KEY: u32 = 8u32;
pub const CRYPT_USERDATA: u32 = 1u32;
pub const CRYPT_USER_DEFAULT: u32 = 2u32;
pub const CRYPT_USER_KEYSET: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(4096u32);
pub const CRYPT_USER_PROTECTED: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(2u32);
pub const CRYPT_USER_PROTECTED_STRONG: u32 = 1048576u32;
pub const CRYPT_VERIFYCONTEXT: u32 = 4026531840u32;
pub const CRYPT_VERIFY_CERT_SIGN_CHECK_WEAK_HASH_FLAG: u32 = 8u32;
pub const CRYPT_VERIFY_CERT_SIGN_DISABLE_MD2_MD4_FLAG: CRYPT_VERIFY_CERT_FLAGS = CRYPT_VERIFY_CERT_FLAGS(1u32);
pub const CRYPT_VERIFY_CERT_SIGN_ISSUER_CERT: u32 = 2u32;
pub const CRYPT_VERIFY_CERT_SIGN_ISSUER_CHAIN: u32 = 3u32;
pub const CRYPT_VERIFY_CERT_SIGN_ISSUER_NULL: u32 = 4u32;
pub const CRYPT_VERIFY_CERT_SIGN_ISSUER_PUBKEY: u32 = 1u32;
pub const CRYPT_VERIFY_CERT_SIGN_RETURN_STRONG_PROPERTIES_FLAG: CRYPT_VERIFY_CERT_FLAGS = CRYPT_VERIFY_CERT_FLAGS(4u32);
pub const CRYPT_VERIFY_CERT_SIGN_SET_STRONG_PROPERTIES_FLAG: CRYPT_VERIFY_CERT_FLAGS = CRYPT_VERIFY_CERT_FLAGS(2u32);
pub const CRYPT_VERIFY_CERT_SIGN_SUBJECT_BLOB: u32 = 1u32;
pub const CRYPT_VERIFY_CERT_SIGN_SUBJECT_CERT: u32 = 2u32;
pub const CRYPT_VERIFY_CERT_SIGN_SUBJECT_CRL: u32 = 3u32;
pub const CRYPT_VERIFY_CERT_SIGN_SUBJECT_OCSP_BASIC_SIGNED_RESPONSE: u32 = 4u32;
pub const CRYPT_VERIFY_CONTEXT_SIGNATURE: u32 = 32u32;
pub const CRYPT_VERIFY_DATA_HASH: u32 = 64u32;
pub const CRYPT_VOLATILE: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(4096u32);
pub const CRYPT_WIRE_ONLY_RETRIEVAL: u32 = 4u32;
pub const CRYPT_WRITE: u32 = 16u32;
pub const CRYPT_X931_FORMAT: u32 = 4u32;
pub const CRYPT_X942_COUNTER_BYTE_LENGTH: u32 = 4u32;
pub const CRYPT_X942_KEY_LENGTH_BYTE_LENGTH: u32 = 4u32;
pub const CRYPT_XML_ALGORITHM_INFO_FIND_BY_CNG_ALGID: u32 = 3u32;
pub const CRYPT_XML_ALGORITHM_INFO_FIND_BY_CNG_SIGN_ALGID: u32 = 4u32;
pub const CRYPT_XML_ALGORITHM_INFO_FIND_BY_NAME: u32 = 2u32;
pub const CRYPT_XML_ALGORITHM_INFO_FIND_BY_URI: u32 = 1u32;
pub const CRYPT_XML_BLOB_MAX: u32 = 2147483640u32;
pub const CRYPT_XML_CHARSET_AUTO: CRYPT_XML_CHARSET = CRYPT_XML_CHARSET(0i32);
pub const CRYPT_XML_CHARSET_UTF16BE: CRYPT_XML_CHARSET = CRYPT_XML_CHARSET(3i32);
pub const CRYPT_XML_CHARSET_UTF16LE: CRYPT_XML_CHARSET = CRYPT_XML_CHARSET(2i32);
pub const CRYPT_XML_CHARSET_UTF8: CRYPT_XML_CHARSET = CRYPT_XML_CHARSET(1i32);
pub const CRYPT_XML_DIGEST_REFERENCE_DATA_TRANSFORMED: u32 = 1u32;
pub const CRYPT_XML_DIGEST_VALUE_MAX: u32 = 128u32;
pub const CRYPT_XML_E_ALGORITHM: windows_core::HRESULT = windows_core::HRESULT(0x80092104_u32 as _);
pub const CRYPT_XML_E_BASE: windows_core::HRESULT = windows_core::HRESULT(0x80092100_u32 as _);
pub const CRYPT_XML_E_ENCODING: windows_core::HRESULT = windows_core::HRESULT(0x80092103_u32 as _);
pub const CRYPT_XML_E_HANDLE: windows_core::HRESULT = windows_core::HRESULT(0x80092106_u32 as _);
pub const CRYPT_XML_E_HASH_FAILED: windows_core::HRESULT = windows_core::HRESULT(0x8009210B_u32 as _);
pub const CRYPT_XML_E_INVALID_DIGEST: windows_core::HRESULT = windows_core::HRESULT(0x80092109_u32 as _);
pub const CRYPT_XML_E_INVALID_KEYVALUE: windows_core::HRESULT = windows_core::HRESULT(0x8009210F_u32 as _);
pub const CRYPT_XML_E_INVALID_SIGNATURE: windows_core::HRESULT = windows_core::HRESULT(0x8009210A_u32 as _);
pub const CRYPT_XML_E_LARGE: windows_core::HRESULT = windows_core::HRESULT(0x80092101_u32 as _);
pub const CRYPT_XML_E_LAST: windows_core::HRESULT = windows_core::HRESULT(0x80092112_u32 as _);
pub const CRYPT_XML_E_NON_UNIQUE_ID: windows_core::HRESULT = windows_core::HRESULT(0x80092112_u32 as _);
pub const CRYPT_XML_E_OPERATION: windows_core::HRESULT = windows_core::HRESULT(0x80092107_u32 as _);
pub const CRYPT_XML_E_SIGNER: windows_core::HRESULT = windows_core::HRESULT(0x80092111_u32 as _);
pub const CRYPT_XML_E_SIGN_FAILED: windows_core::HRESULT = windows_core::HRESULT(0x8009210C_u32 as _);
pub const CRYPT_XML_E_TOO_MANY_SIGNATURES: windows_core::HRESULT = windows_core::HRESULT(0x8009210E_u32 as _);
pub const CRYPT_XML_E_TOO_MANY_TRANSFORMS: windows_core::HRESULT = windows_core::HRESULT(0x80092102_u32 as _);
pub const CRYPT_XML_E_TRANSFORM: windows_core::HRESULT = windows_core::HRESULT(0x80092105_u32 as _);
pub const CRYPT_XML_E_UNEXPECTED_XML: windows_core::HRESULT = windows_core::HRESULT(0x80092110_u32 as _);
pub const CRYPT_XML_E_UNRESOLVED_REFERENCE: windows_core::HRESULT = windows_core::HRESULT(0x80092108_u32 as _);
pub const CRYPT_XML_E_VERIFY_FAILED: windows_core::HRESULT = windows_core::HRESULT(0x8009210D_u32 as _);
pub const CRYPT_XML_FLAG_ADD_OBJECT_CREATE_COPY: u32 = 1u32;
pub const CRYPT_XML_FLAG_ALWAYS_RETURN_ENCODED_OBJECT: u32 = 1073741824u32;
pub const CRYPT_XML_FLAG_CREATE_REFERENCE_AS_OBJECT: u32 = 1u32;
pub const CRYPT_XML_FLAG_DISABLE_EXTENSIONS: CRYPT_XML_FLAGS = CRYPT_XML_FLAGS(268435456u32);
pub const CRYPT_XML_FLAG_ECDSA_DSIG11: u32 = 67108864u32;
pub const CRYPT_XML_FLAG_ENFORCE_ID_NAME_FORMAT: u32 = 134217728u32;
pub const CRYPT_XML_FLAG_ENFORCE_ID_NCNAME_FORMAT: u32 = 536870912u32;
pub const CRYPT_XML_FLAG_NO_SERIALIZE: CRYPT_XML_FLAGS = CRYPT_XML_FLAGS(2147483648u32);
pub const CRYPT_XML_GROUP_ID_HASH: CRYPT_XML_GROUP_ID = CRYPT_XML_GROUP_ID(1u32);
pub const CRYPT_XML_GROUP_ID_SIGN: CRYPT_XML_GROUP_ID = CRYPT_XML_GROUP_ID(2u32);
pub const CRYPT_XML_ID_MAX: u32 = 256u32;
pub const CRYPT_XML_KEYINFO_SPEC_ENCODED: CRYPT_XML_KEYINFO_SPEC = CRYPT_XML_KEYINFO_SPEC(1i32);
pub const CRYPT_XML_KEYINFO_SPEC_NONE: CRYPT_XML_KEYINFO_SPEC = CRYPT_XML_KEYINFO_SPEC(0i32);
pub const CRYPT_XML_KEYINFO_SPEC_PARAM: CRYPT_XML_KEYINFO_SPEC = CRYPT_XML_KEYINFO_SPEC(2i32);
pub const CRYPT_XML_KEYINFO_TYPE_CUSTOM: CRYPT_XML_KEYINFO_TYPE = CRYPT_XML_KEYINFO_TYPE(5u32);
pub const CRYPT_XML_KEYINFO_TYPE_KEYNAME: CRYPT_XML_KEYINFO_TYPE = CRYPT_XML_KEYINFO_TYPE(1u32);
pub const CRYPT_XML_KEYINFO_TYPE_KEYVALUE: CRYPT_XML_KEYINFO_TYPE = CRYPT_XML_KEYINFO_TYPE(2u32);
pub const CRYPT_XML_KEYINFO_TYPE_RETRIEVAL: CRYPT_XML_KEYINFO_TYPE = CRYPT_XML_KEYINFO_TYPE(3u32);
pub const CRYPT_XML_KEYINFO_TYPE_X509DATA: CRYPT_XML_KEYINFO_TYPE = CRYPT_XML_KEYINFO_TYPE(4u32);
pub const CRYPT_XML_KEY_VALUE_TYPE_CUSTOM: CRYPT_XML_KEY_VALUE_TYPE = CRYPT_XML_KEY_VALUE_TYPE(4u32);
pub const CRYPT_XML_KEY_VALUE_TYPE_DSA: CRYPT_XML_KEY_VALUE_TYPE = CRYPT_XML_KEY_VALUE_TYPE(1u32);
pub const CRYPT_XML_KEY_VALUE_TYPE_ECDSA: CRYPT_XML_KEY_VALUE_TYPE = CRYPT_XML_KEY_VALUE_TYPE(3u32);
pub const CRYPT_XML_KEY_VALUE_TYPE_RSA: CRYPT_XML_KEY_VALUE_TYPE = CRYPT_XML_KEY_VALUE_TYPE(2u32);
pub const CRYPT_XML_OBJECTS_MAX: u32 = 256u32;
pub const CRYPT_XML_PROPERTY_DOC_DECLARATION: CRYPT_XML_PROPERTY_ID = CRYPT_XML_PROPERTY_ID(4i32);
pub const CRYPT_XML_PROPERTY_MAX_HEAP_SIZE: CRYPT_XML_PROPERTY_ID = CRYPT_XML_PROPERTY_ID(1i32);
pub const CRYPT_XML_PROPERTY_MAX_SIGNATURES: CRYPT_XML_PROPERTY_ID = CRYPT_XML_PROPERTY_ID(3i32);
pub const CRYPT_XML_PROPERTY_SIGNATURE_LOCATION: CRYPT_XML_PROPERTY_ID = CRYPT_XML_PROPERTY_ID(2i32);
pub const CRYPT_XML_PROPERTY_XML_OUTPUT_CHARSET: CRYPT_XML_PROPERTY_ID = CRYPT_XML_PROPERTY_ID(5i32);
pub const CRYPT_XML_REFERENCES_MAX: u32 = 32760u32;
pub const CRYPT_XML_SIGNATURES_MAX: u32 = 16u32;
pub const CRYPT_XML_SIGNATURE_VALUE_MAX: u32 = 2048u32;
pub const CRYPT_XML_SIGN_ADD_KEYVALUE: CRYPT_XML_FLAGS = CRYPT_XML_FLAGS(1u32);
pub const CRYPT_XML_STATUS_DIGESTING: CRYPT_XML_STATUS_INFO_STATUS = CRYPT_XML_STATUS_INFO_STATUS(4u32);
pub const CRYPT_XML_STATUS_DIGEST_VALID: CRYPT_XML_STATUS_INFO_STATUS = CRYPT_XML_STATUS_INFO_STATUS(8u32);
pub const CRYPT_XML_STATUS_ERROR_DIGEST_INVALID: CRYPT_XML_STATUS_ERROR_STATUS = CRYPT_XML_STATUS_ERROR_STATUS(2u32);
pub const CRYPT_XML_STATUS_ERROR_KEYINFO_NOT_PARSED: CRYPT_XML_STATUS_ERROR_STATUS = CRYPT_XML_STATUS_ERROR_STATUS(131072u32);
pub const CRYPT_XML_STATUS_ERROR_NOT_RESOLVED: CRYPT_XML_STATUS_ERROR_STATUS = CRYPT_XML_STATUS_ERROR_STATUS(1u32);
pub const CRYPT_XML_STATUS_ERROR_NOT_SUPPORTED_ALGORITHM: CRYPT_XML_STATUS_ERROR_STATUS = CRYPT_XML_STATUS_ERROR_STATUS(5u32);
pub const CRYPT_XML_STATUS_ERROR_NOT_SUPPORTED_TRANSFORM: CRYPT_XML_STATUS_ERROR_STATUS = CRYPT_XML_STATUS_ERROR_STATUS(8u32);
pub const CRYPT_XML_STATUS_ERROR_SIGNATURE_INVALID: CRYPT_XML_STATUS_ERROR_STATUS = CRYPT_XML_STATUS_ERROR_STATUS(65536u32);
pub const CRYPT_XML_STATUS_INTERNAL_REFERENCE: CRYPT_XML_STATUS_INFO_STATUS = CRYPT_XML_STATUS_INFO_STATUS(1u32);
pub const CRYPT_XML_STATUS_KEY_AVAILABLE: CRYPT_XML_STATUS_INFO_STATUS = CRYPT_XML_STATUS_INFO_STATUS(2u32);
pub const CRYPT_XML_STATUS_NO_ERROR: u32 = 0u32;
pub const CRYPT_XML_STATUS_OPENED_TO_ENCODE: CRYPT_XML_STATUS_INFO_STATUS = CRYPT_XML_STATUS_INFO_STATUS(2147483648u32);
pub const CRYPT_XML_STATUS_SIGNATURE_VALID: CRYPT_XML_STATUS_INFO_STATUS = CRYPT_XML_STATUS_INFO_STATUS(65536u32);
pub const CRYPT_XML_TRANSFORM_MAX: u32 = 16u32;
pub const CRYPT_XML_TRANSFORM_ON_NODESET: CRYPT_XML_TRANSFORM_FLAGS = CRYPT_XML_TRANSFORM_FLAGS(2u32);
pub const CRYPT_XML_TRANSFORM_ON_STREAM: CRYPT_XML_TRANSFORM_FLAGS = CRYPT_XML_TRANSFORM_FLAGS(1u32);
pub const CRYPT_XML_TRANSFORM_URI_QUERY_STRING: CRYPT_XML_TRANSFORM_FLAGS = CRYPT_XML_TRANSFORM_FLAGS(3u32);
pub const CRYPT_XML_X509DATA_TYPE_CERTIFICATE: CRYPT_XML_X509DATA_TYPE = CRYPT_XML_X509DATA_TYPE(4u32);
pub const CRYPT_XML_X509DATA_TYPE_CRL: CRYPT_XML_X509DATA_TYPE = CRYPT_XML_X509DATA_TYPE(5u32);
pub const CRYPT_XML_X509DATA_TYPE_CUSTOM: CRYPT_XML_X509DATA_TYPE = CRYPT_XML_X509DATA_TYPE(6u32);
pub const CRYPT_XML_X509DATA_TYPE_ISSUER_SERIAL: CRYPT_XML_X509DATA_TYPE = CRYPT_XML_X509DATA_TYPE(1u32);
pub const CRYPT_XML_X509DATA_TYPE_SKI: CRYPT_XML_X509DATA_TYPE = CRYPT_XML_X509DATA_TYPE(2u32);
pub const CRYPT_XML_X509DATA_TYPE_SUBJECT_NAME: CRYPT_XML_X509DATA_TYPE = CRYPT_XML_X509DATA_TYPE(3u32);
pub const CRYPT_Y_ONLY: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(1u32);
pub const CTL_ANY_SUBJECT_TYPE: u32 = 1u32;
pub const CTL_CERT_SUBJECT_TYPE: u32 = 2u32;
pub const CTL_ENTRY_FROM_PROP_CHAIN_FLAG: u32 = 1u32;
pub const CTL_FIND_ANY: CERT_FIND_TYPE = CERT_FIND_TYPE(0u32);
pub const CTL_FIND_EXISTING: CERT_FIND_TYPE = CERT_FIND_TYPE(5u32);
pub const CTL_FIND_MD5_HASH: CERT_FIND_TYPE = CERT_FIND_TYPE(2u32);
pub const CTL_FIND_NO_LIST_ID_CBDATA: u32 = 4294967295u32;
pub const CTL_FIND_SAME_USAGE_FLAG: CERT_FIND_TYPE = CERT_FIND_TYPE(1u32);
pub const CTL_FIND_SHA1_HASH: CERT_FIND_TYPE = CERT_FIND_TYPE(1u32);
pub const CTL_FIND_SUBJECT: CERT_FIND_TYPE = CERT_FIND_TYPE(4u32);
pub const CTL_FIND_USAGE: CERT_FIND_TYPE = CERT_FIND_TYPE(3u32);
pub const CTL_V1: u32 = 0u32;
pub const CUR_BLOB_VERSION: u32 = 2u32;
pub const DSA_FIPS186_2: DSAFIPSVERSION_ENUM = DSAFIPSVERSION_ENUM(0i32);
pub const DSA_FIPS186_3: DSAFIPSVERSION_ENUM = DSAFIPSVERSION_ENUM(1i32);
pub const DSA_HASH_ALGORITHM_SHA1: HASHALGORITHM_ENUM = HASHALGORITHM_ENUM(0i32);
pub const DSA_HASH_ALGORITHM_SHA256: HASHALGORITHM_ENUM = HASHALGORITHM_ENUM(1i32);
pub const DSA_HASH_ALGORITHM_SHA512: HASHALGORITHM_ENUM = HASHALGORITHM_ENUM(2i32);
pub const DirectionDecrypt: Direction = Direction(2i32);
pub const DirectionEncrypt: Direction = Direction(1i32);
pub const ECC_CMS_SHARED_INFO: windows_core::PCSTR = windows_core::PCSTR(77i32 as _);
pub const ENUM_CEPSETUPPROP_AUTHENTICATION: CEPSetupProperty = CEPSetupProperty(0i32);
pub const ENUM_CEPSETUPPROP_CAINFORMATION: MSCEPSetupProperty = MSCEPSetupProperty(11i32);
pub const ENUM_CEPSETUPPROP_CHALLENGEURL: MSCEPSetupProperty = MSCEPSetupProperty(13i32);
pub const ENUM_CEPSETUPPROP_EXCHANGEKEYINFORMATION: MSCEPSetupProperty = MSCEPSetupProperty(10i32);
pub const ENUM_CEPSETUPPROP_KEYBASED_RENEWAL: CEPSetupProperty = CEPSetupProperty(3i32);
pub const ENUM_CEPSETUPPROP_MSCEPURL: MSCEPSetupProperty = MSCEPSetupProperty(12i32);
pub const ENUM_CEPSETUPPROP_RANAME_CITY: MSCEPSetupProperty = MSCEPSetupProperty(6i32);
pub const ENUM_CEPSETUPPROP_RANAME_CN: MSCEPSetupProperty = MSCEPSetupProperty(2i32);
pub const ENUM_CEPSETUPPROP_RANAME_COMPANY: MSCEPSetupProperty = MSCEPSetupProperty(4i32);
pub const ENUM_CEPSETUPPROP_RANAME_COUNTRY: MSCEPSetupProperty = MSCEPSetupProperty(8i32);
pub const ENUM_CEPSETUPPROP_RANAME_DEPT: MSCEPSetupProperty = MSCEPSetupProperty(5i32);
pub const ENUM_CEPSETUPPROP_RANAME_EMAIL: MSCEPSetupProperty = MSCEPSetupProperty(3i32);
pub const ENUM_CEPSETUPPROP_RANAME_STATE: MSCEPSetupProperty = MSCEPSetupProperty(7i32);
pub const ENUM_CEPSETUPPROP_SIGNINGKEYINFORMATION: MSCEPSetupProperty = MSCEPSetupProperty(9i32);
pub const ENUM_CEPSETUPPROP_SSLCERTHASH: CEPSetupProperty = CEPSetupProperty(1i32);
pub const ENUM_CEPSETUPPROP_URL: CEPSetupProperty = CEPSetupProperty(2i32);
pub const ENUM_CEPSETUPPROP_USECHALLENGE: MSCEPSetupProperty = MSCEPSetupProperty(1i32);
pub const ENUM_CEPSETUPPROP_USELOCALSYSTEM: MSCEPSetupProperty = MSCEPSetupProperty(0i32);
pub const ENUM_CESSETUPPROP_ALLOW_KEYBASED_RENEWAL: CESSetupProperty = CESSetupProperty(6i32);
pub const ENUM_CESSETUPPROP_AUTHENTICATION: CESSetupProperty = CESSetupProperty(2i32);
pub const ENUM_CESSETUPPROP_CACONFIG: CESSetupProperty = CESSetupProperty(1i32);
pub const ENUM_CESSETUPPROP_RENEWALONLY: CESSetupProperty = CESSetupProperty(5i32);
pub const ENUM_CESSETUPPROP_SSLCERTHASH: CESSetupProperty = CESSetupProperty(3i32);
pub const ENUM_CESSETUPPROP_URL: CESSetupProperty = CESSetupProperty(4i32);
pub const ENUM_CESSETUPPROP_USE_IISAPPPOOLIDENTITY: CESSetupProperty = CESSetupProperty(0i32);
pub const ENUM_SETUPPROP_CADSSUFFIX: CASetupProperty = CASetupProperty(4i32);
pub const ENUM_SETUPPROP_CAKEYINFORMATION: CASetupProperty = CASetupProperty(1i32);
pub const ENUM_SETUPPROP_CANAME: CASetupProperty = CASetupProperty(3i32);
pub const ENUM_SETUPPROP_CATYPE: CASetupProperty = CASetupProperty(0i32);
pub const ENUM_SETUPPROP_DATABASEDIRECTORY: CASetupProperty = CASetupProperty(9i32);
pub const ENUM_SETUPPROP_EXPIRATIONDATE: CASetupProperty = CASetupProperty(7i32);
pub const ENUM_SETUPPROP_INTERACTIVE: CASetupProperty = CASetupProperty(2i32);
pub const ENUM_SETUPPROP_INVALID: CASetupProperty = CASetupProperty(-1i32);
pub const ENUM_SETUPPROP_LOGDIRECTORY: CASetupProperty = CASetupProperty(10i32);
pub const ENUM_SETUPPROP_PARENTCAMACHINE: CASetupProperty = CASetupProperty(12i32);
pub const ENUM_SETUPPROP_PARENTCANAME: CASetupProperty = CASetupProperty(13i32);
pub const ENUM_SETUPPROP_PRESERVEDATABASE: CASetupProperty = CASetupProperty(8i32);
pub const ENUM_SETUPPROP_REQUESTFILE: CASetupProperty = CASetupProperty(14i32);
pub const ENUM_SETUPPROP_SHAREDFOLDER: CASetupProperty = CASetupProperty(11i32);
pub const ENUM_SETUPPROP_VALIDITYPERIOD: CASetupProperty = CASetupProperty(5i32);
pub const ENUM_SETUPPROP_VALIDITYPERIODUNIT: CASetupProperty = CASetupProperty(6i32);
pub const ENUM_SETUPPROP_WEBCAMACHINE: CASetupProperty = CASetupProperty(15i32);
pub const ENUM_SETUPPROP_WEBCANAME: CASetupProperty = CASetupProperty(16i32);
pub const EXPORT_PRIVATE_KEYS: u32 = 4u32;
pub const EXPO_OFFLOAD_FUNC_NAME: windows_core::PCSTR = windows_core::s!("OffloadModExpo");
pub const EXPO_OFFLOAD_REG_VALUE: windows_core::PCSTR = windows_core::s!("ExpoOffload");
pub const E_ICARD_ARGUMENT: windows_core::HRESULT = windows_core::HRESULT(0xC0050105_u32 as _);
pub const E_ICARD_COMMUNICATION: windows_core::HRESULT = windows_core::HRESULT(0xC0050100_u32 as _);
pub const E_ICARD_DATA_ACCESS: windows_core::HRESULT = windows_core::HRESULT(0xC0050101_u32 as _);
pub const E_ICARD_EXPORT: windows_core::HRESULT = windows_core::HRESULT(0xC0050102_u32 as _);
pub const E_ICARD_FAIL: windows_core::HRESULT = windows_core::HRESULT(0xC0050115_u32 as _);
pub const E_ICARD_FAILED_REQUIRED_CLAIMS: windows_core::HRESULT = windows_core::HRESULT(0xC0050184_u32 as _);
pub const E_ICARD_IDENTITY: windows_core::HRESULT = windows_core::HRESULT(0xC0050103_u32 as _);
pub const E_ICARD_IMPORT: windows_core::HRESULT = windows_core::HRESULT(0xC0050104_u32 as _);
pub const E_ICARD_INFORMATIONCARD: windows_core::HRESULT = windows_core::HRESULT(0xC0050107_u32 as _);
pub const E_ICARD_INVALID_PROOF_KEY: windows_core::HRESULT = windows_core::HRESULT(0xC0050182_u32 as _);
pub const E_ICARD_LOGOVALIDATION: windows_core::HRESULT = windows_core::HRESULT(0xC0050109_u32 as _);
pub const E_ICARD_MISSING_APPLIESTO: windows_core::HRESULT = windows_core::HRESULT(0xC0050181_u32 as _);
pub const E_ICARD_PASSWORDVALIDATION: windows_core::HRESULT = windows_core::HRESULT(0xC005010A_u32 as _);
pub const E_ICARD_POLICY: windows_core::HRESULT = windows_core::HRESULT(0xC005010B_u32 as _);
pub const E_ICARD_PROCESSDIED: windows_core::HRESULT = windows_core::HRESULT(0xC005010C_u32 as _);
pub const E_ICARD_REFRESH_REQUIRED: windows_core::HRESULT = windows_core::HRESULT(0xC0050180_u32 as _);
pub const E_ICARD_REQUEST: windows_core::HRESULT = windows_core::HRESULT(0xC0050106_u32 as _);
pub const E_ICARD_SERVICE: windows_core::HRESULT = windows_core::HRESULT(0xC005010E_u32 as _);
pub const E_ICARD_SERVICEBUSY: windows_core::HRESULT = windows_core::HRESULT(0xC005010D_u32 as _);
pub const E_ICARD_SHUTTINGDOWN: windows_core::HRESULT = windows_core::HRESULT(0xC005010F_u32 as _);
pub const E_ICARD_STOREKEY: windows_core::HRESULT = windows_core::HRESULT(0xC0050108_u32 as _);
pub const E_ICARD_STORE_IMPORT: windows_core::HRESULT = windows_core::HRESULT(0xC0050114_u32 as _);
pub const E_ICARD_TOKENCREATION: windows_core::HRESULT = windows_core::HRESULT(0xC0050110_u32 as _);
pub const E_ICARD_TRUSTEXCHANGE: windows_core::HRESULT = windows_core::HRESULT(0xC0050111_u32 as _);
pub const E_ICARD_UI_INITIALIZATION: windows_core::HRESULT = windows_core::HRESULT(0xC005011A_u32 as _);
pub const E_ICARD_UNKNOWN_REFERENCE: windows_core::HRESULT = windows_core::HRESULT(0xC0050183_u32 as _);
pub const E_ICARD_UNTRUSTED: windows_core::HRESULT = windows_core::HRESULT(0xC0050112_u32 as _);
pub const E_ICARD_USERCANCELLED: windows_core::HRESULT = windows_core::HRESULT(0xC0050113_u32 as _);
pub const HP_ALGID: u32 = 1u32;
pub const HP_HASHSIZE: u32 = 4u32;
pub const HP_HASHVAL: CRYPT_SET_HASH_PARAM = CRYPT_SET_HASH_PARAM(2u32);
pub const HP_HMAC_INFO: CRYPT_SET_HASH_PARAM = CRYPT_SET_HASH_PARAM(5u32);
pub const HP_TLS1PRF_LABEL: u32 = 6u32;
pub const HP_TLS1PRF_SEED: u32 = 7u32;
pub const IFX_RSA_KEYGEN_VUL_AFFECTED_LEVEL_1: u32 = 1u32;
pub const IFX_RSA_KEYGEN_VUL_AFFECTED_LEVEL_2: u32 = 2u32;
pub const IFX_RSA_KEYGEN_VUL_NOT_AFFECTED: u32 = 0u32;
pub const INTERNATIONAL_USAGE: u32 = 1u32;
pub const KDF_ALGORITHMID: u32 = 8u32;
pub const KDF_CONTEXT: u32 = 14u32;
pub const KDF_GENERIC_PARAMETER: u32 = 17u32;
pub const KDF_HASH_ALGORITHM: u32 = 0u32;
pub const KDF_HKDF_INFO: u32 = 20u32;
pub const KDF_HKDF_SALT: u32 = 19u32;
pub const KDF_HMAC_KEY: u32 = 3u32;
pub const KDF_ITERATION_COUNT: u32 = 16u32;
pub const KDF_KEYBITLENGTH: u32 = 18u32;
pub const KDF_LABEL: u32 = 13u32;
pub const KDF_PARTYUINFO: u32 = 9u32;
pub const KDF_PARTYVINFO: u32 = 10u32;
pub const KDF_SALT: u32 = 15u32;
pub const KDF_SECRET_APPEND: u32 = 2u32;
pub const KDF_SECRET_HANDLE: u32 = 6u32;
pub const KDF_SECRET_PREPEND: u32 = 1u32;
pub const KDF_SUPPPRIVINFO: u32 = 12u32;
pub const KDF_SUPPPUBINFO: u32 = 11u32;
pub const KDF_TLS_PRF_LABEL: u32 = 4u32;
pub const KDF_TLS_PRF_PROTOCOL: u32 = 7u32;
pub const KDF_TLS_PRF_SEED: u32 = 5u32;
pub const KDF_USE_SECRET_AS_HMAC_KEY_FLAG: u32 = 1u32;
pub const KEYSTATEBLOB: u32 = 12u32;
pub const KEY_LENGTH_MASK: u32 = 4294901760u32;
pub const KP_ADMIN_PIN: u32 = 31u32;
pub const KP_ALGID: CRYPT_KEY_PARAM_ID = CRYPT_KEY_PARAM_ID(7u32);
pub const KP_BLOCKLEN: CRYPT_KEY_PARAM_ID = CRYPT_KEY_PARAM_ID(8u32);
pub const KP_CERTIFICATE: CRYPT_KEY_PARAM_ID = CRYPT_KEY_PARAM_ID(26u32);
pub const KP_CLEAR_KEY: u32 = 27u32;
pub const KP_CLIENT_RANDOM: u32 = 21u32;
pub const KP_CMS_DH_KEY_INFO: u32 = 38u32;
pub const KP_CMS_KEY_INFO: u32 = 37u32;
pub const KP_EFFECTIVE_KEYLEN: u32 = 19u32;
pub const KP_G: u32 = 12u32;
pub const KP_GET_USE_COUNT: CRYPT_KEY_PARAM_ID = CRYPT_KEY_PARAM_ID(42u32);
pub const KP_HIGHEST_VERSION: u32 = 41u32;
pub const KP_INFO: u32 = 18u32;
pub const KP_IV: u32 = 1u32;
pub const KP_KEYEXCHANGE_PIN: u32 = 32u32;
pub const KP_KEYLEN: CRYPT_KEY_PARAM_ID = CRYPT_KEY_PARAM_ID(9u32);
pub const KP_KEYVAL: u32 = 30u32;
pub const KP_MODE: u32 = 4u32;
pub const KP_MODE_BITS: u32 = 5u32;
pub const KP_OAEP_PARAMS: u32 = 36u32;
pub const KP_P: u32 = 11u32;
pub const KP_PADDING: u32 = 3u32;
pub const KP_PERMISSIONS: CRYPT_KEY_PARAM_ID = CRYPT_KEY_PARAM_ID(6u32);
pub const KP_PIN_ID: u32 = 43u32;
pub const KP_PIN_INFO: u32 = 44u32;
pub const KP_PRECOMP_MD5: u32 = 24u32;
pub const KP_PRECOMP_SHA: u32 = 25u32;
pub const KP_PREHASH: u32 = 34u32;
pub const KP_PUB_EX_LEN: u32 = 28u32;
pub const KP_PUB_EX_VAL: u32 = 29u32;
pub const KP_PUB_PARAMS: u32 = 39u32;
pub const KP_Q: u32 = 13u32;
pub const KP_RA: u32 = 16u32;
pub const KP_RB: u32 = 17u32;
pub const KP_ROUNDS: u32 = 35u32;
pub const KP_RP: u32 = 23u32;
pub const KP_SALT: CRYPT_KEY_PARAM_ID = CRYPT_KEY_PARAM_ID(2u32);
pub const KP_SALT_EX: CRYPT_KEY_PARAM_ID = CRYPT_KEY_PARAM_ID(10u32);
pub const KP_SCHANNEL_ALG: u32 = 20u32;
pub const KP_SERVER_RANDOM: u32 = 22u32;
pub const KP_SIGNATURE_PIN: u32 = 33u32;
pub const KP_VERIFY_PARAMS: u32 = 40u32;
pub const KP_X: u32 = 14u32;
pub const KP_Y: u32 = 15u32;
pub const KeyTypeHardware: CertKeyType = CertKeyType(6u32);
pub const KeyTypeOther: CertKeyType = CertKeyType(0u32);
pub const KeyTypePassport: CertKeyType = CertKeyType(3u32);
pub const KeyTypePassportRemote: CertKeyType = CertKeyType(4u32);
pub const KeyTypePassportSmartCard: CertKeyType = CertKeyType(5u32);
pub const KeyTypePhysicalSmartCard: CertKeyType = CertKeyType(2u32);
pub const KeyTypeSelfSigned: CertKeyType = CertKeyType(8u32);
pub const KeyTypeSoftware: CertKeyType = CertKeyType(7u32);
pub const KeyTypeVirtualSmartCard: CertKeyType = CertKeyType(1u32);
pub const LEGACY_DH_PRIVATE_BLOB: windows_core::PCWSTR = windows_core::w!("CAPIDHPRIVATEBLOB");
pub const LEGACY_DH_PUBLIC_BLOB: windows_core::PCWSTR = windows_core::w!("CAPIDHPUBLICBLOB");
pub const LEGACY_DSA_PRIVATE_BLOB: windows_core::PCWSTR = windows_core::w!("CAPIDSAPRIVATEBLOB");
pub const LEGACY_DSA_PUBLIC_BLOB: windows_core::PCWSTR = windows_core::w!("CAPIDSAPUBLICBLOB");
pub const LEGACY_DSA_V2_PRIVATE_BLOB: windows_core::PCWSTR = windows_core::w!("V2CAPIDSAPRIVATEBLOB");
pub const LEGACY_DSA_V2_PUBLIC_BLOB: windows_core::PCWSTR = windows_core::w!("V2CAPIDSAPUBLICBLOB");
pub const LEGACY_RSAPRIVATE_BLOB: windows_core::PCWSTR = windows_core::w!("CAPIPRIVATEBLOB");
pub const LEGACY_RSAPUBLIC_BLOB: windows_core::PCWSTR = windows_core::w!("CAPIPUBLICBLOB");
pub const MAXUIDLEN: u32 = 64u32;
pub const MICROSOFT_ROOT_CERT_CHAIN_POLICY_CHECK_APPLICATION_ROOT_FLAG: u32 = 131072u32;
pub const MICROSOFT_ROOT_CERT_CHAIN_POLICY_DISABLE_FLIGHT_ROOT_FLAG: u32 = 262144u32;
pub const MICROSOFT_ROOT_CERT_CHAIN_POLICY_ENABLE_TEST_ROOT_FLAG: u32 = 65536u32;
pub const MS_DEF_DH_SCHANNEL_PROV: windows_core::PCWSTR = windows_core::w!("Microsoft DH SChannel Cryptographic Provider");
pub const MS_DEF_DH_SCHANNEL_PROV_A: windows_core::PCSTR = windows_core::s!("Microsoft DH SChannel Cryptographic Provider");
pub const MS_DEF_DH_SCHANNEL_PROV_W: windows_core::PCWSTR = windows_core::w!("Microsoft DH SChannel Cryptographic Provider");
pub const MS_DEF_DSS_DH_PROV: windows_core::PCWSTR = windows_core::w!("Microsoft Base DSS and Diffie-Hellman Cryptographic Provider");
pub const MS_DEF_DSS_DH_PROV_A: windows_core::PCSTR = windows_core::s!("Microsoft Base DSS and Diffie-Hellman Cryptographic Provider");
pub const MS_DEF_DSS_DH_PROV_W: windows_core::PCWSTR = windows_core::w!("Microsoft Base DSS and Diffie-Hellman Cryptographic Provider");
pub const MS_DEF_DSS_PROV: windows_core::PCWSTR = windows_core::w!("Microsoft Base DSS Cryptographic Provider");
pub const MS_DEF_DSS_PROV_A: windows_core::PCSTR = windows_core::s!("Microsoft Base DSS Cryptographic Provider");
pub const MS_DEF_DSS_PROV_W: windows_core::PCWSTR = windows_core::w!("Microsoft Base DSS Cryptographic Provider");
pub const MS_DEF_PROV: windows_core::PCWSTR = windows_core::w!("Microsoft Base Cryptographic Provider v1.0");
pub const MS_DEF_PROV_A: windows_core::PCSTR = windows_core::s!("Microsoft Base Cryptographic Provider v1.0");
pub const MS_DEF_PROV_W: windows_core::PCWSTR = windows_core::w!("Microsoft Base Cryptographic Provider v1.0");
pub const MS_DEF_RSA_SCHANNEL_PROV: windows_core::PCWSTR = windows_core::w!("Microsoft RSA SChannel Cryptographic Provider");
pub const MS_DEF_RSA_SCHANNEL_PROV_A: windows_core::PCSTR = windows_core::s!("Microsoft RSA SChannel Cryptographic Provider");
pub const MS_DEF_RSA_SCHANNEL_PROV_W: windows_core::PCWSTR = windows_core::w!("Microsoft RSA SChannel Cryptographic Provider");
pub const MS_DEF_RSA_SIG_PROV: windows_core::PCWSTR = windows_core::w!("Microsoft RSA Signature Cryptographic Provider");
pub const MS_DEF_RSA_SIG_PROV_A: windows_core::PCSTR = windows_core::s!("Microsoft RSA Signature Cryptographic Provider");
pub const MS_DEF_RSA_SIG_PROV_W: windows_core::PCWSTR = windows_core::w!("Microsoft RSA Signature Cryptographic Provider");
pub const MS_ENHANCED_PROV: windows_core::PCWSTR = windows_core::w!("Microsoft Enhanced Cryptographic Provider v1.0");
pub const MS_ENHANCED_PROV_A: windows_core::PCSTR = windows_core::s!("Microsoft Enhanced Cryptographic Provider v1.0");
pub const MS_ENHANCED_PROV_W: windows_core::PCWSTR = windows_core::w!("Microsoft Enhanced Cryptographic Provider v1.0");
pub const MS_ENH_DSS_DH_PROV: windows_core::PCWSTR = windows_core::w!("Microsoft Enhanced DSS and Diffie-Hellman Cryptographic Provider");
pub const MS_ENH_DSS_DH_PROV_A: windows_core::PCSTR = windows_core::s!("Microsoft Enhanced DSS and Diffie-Hellman Cryptographic Provider");
pub const MS_ENH_DSS_DH_PROV_W: windows_core::PCWSTR = windows_core::w!("Microsoft Enhanced DSS and Diffie-Hellman Cryptographic Provider");
pub const MS_ENH_RSA_AES_PROV: windows_core::PCWSTR = windows_core::w!("Microsoft Enhanced RSA and AES Cryptographic Provider");
pub const MS_ENH_RSA_AES_PROV_A: windows_core::PCSTR = windows_core::s!("Microsoft Enhanced RSA and AES Cryptographic Provider");
pub const MS_ENH_RSA_AES_PROV_W: windows_core::PCWSTR = windows_core::w!("Microsoft Enhanced RSA and AES Cryptographic Provider");
pub const MS_ENH_RSA_AES_PROV_XP: windows_core::PCWSTR = windows_core::w!("Microsoft Enhanced RSA and AES Cryptographic Provider (Prototype)");
pub const MS_ENH_RSA_AES_PROV_XP_A: windows_core::PCSTR = windows_core::s!("Microsoft Enhanced RSA and AES Cryptographic Provider (Prototype)");
pub const MS_ENH_RSA_AES_PROV_XP_W: windows_core::PCWSTR = windows_core::w!("Microsoft Enhanced RSA and AES Cryptographic Provider (Prototype)");
pub const MS_KEY_PROTECTION_PROVIDER: windows_core::PCWSTR = windows_core::w!("Microsoft Key Protection Provider");
pub const MS_KEY_STORAGE_PROVIDER: windows_core::PCWSTR = windows_core::w!("Microsoft Software Key Storage Provider");
pub const MS_NGC_KEY_STORAGE_PROVIDER: windows_core::PCWSTR = windows_core::w!("Microsoft Passport Key Storage Provider");
pub const MS_PLATFORM_CRYPTO_PROVIDER: windows_core::PCWSTR = windows_core::w!("Microsoft Platform Crypto Provider");
pub const MS_PLATFORM_KEY_STORAGE_PROVIDER: windows_core::PCWSTR = windows_core::w!("Microsoft Platform Crypto Provider");
pub const MS_PRIMITIVE_PROVIDER: windows_core::PCWSTR = windows_core::w!("Microsoft Primitive Provider");
pub const MS_SCARD_PROV: windows_core::PCWSTR = windows_core::w!("Microsoft Base Smart Card Crypto Provider");
pub const MS_SCARD_PROV_A: windows_core::PCSTR = windows_core::s!("Microsoft Base Smart Card Crypto Provider");
pub const MS_SCARD_PROV_W: windows_core::PCWSTR = windows_core::w!("Microsoft Base Smart Card Crypto Provider");
pub const MS_SMART_CARD_KEY_STORAGE_PROVIDER: windows_core::PCWSTR = windows_core::w!("Microsoft Smart Card Key Storage Provider");
pub const MS_STRONG_PROV: windows_core::PCWSTR = windows_core::w!("Microsoft Strong Cryptographic Provider");
pub const MS_STRONG_PROV_A: windows_core::PCSTR = windows_core::s!("Microsoft Strong Cryptographic Provider");
pub const MS_STRONG_PROV_W: windows_core::PCWSTR = windows_core::w!("Microsoft Strong Cryptographic Provider");
pub const NCRYPTBUFFER_ATTESTATIONSTATEMENT_BLOB: u32 = 51u32;
pub const NCRYPTBUFFER_ATTESTATION_CLAIM_CHALLENGE_REQUIRED: u32 = 53u32;
pub const NCRYPTBUFFER_ATTESTATION_CLAIM_TYPE: u32 = 52u32;
pub const NCRYPTBUFFER_CERT_BLOB: u32 = 47u32;
pub const NCRYPTBUFFER_CLAIM_IDBINDING_NONCE: u32 = 48u32;
pub const NCRYPTBUFFER_CLAIM_KEYATTESTATION_NONCE: u32 = 49u32;
pub const NCRYPTBUFFER_DATA: u32 = 1u32;
pub const NCRYPTBUFFER_ECC_CURVE_NAME: u32 = 60u32;
pub const NCRYPTBUFFER_ECC_PARAMETERS: u32 = 61u32;
pub const NCRYPTBUFFER_EMPTY: u32 = 0u32;
pub const NCRYPTBUFFER_KEY_PROPERTY_FLAGS: u32 = 50u32;
pub const NCRYPTBUFFER_PKCS_ALG_ID: u32 = 43u32;
pub const NCRYPTBUFFER_PKCS_ALG_OID: u32 = 41u32;
pub const NCRYPTBUFFER_PKCS_ALG_PARAM: u32 = 42u32;
pub const NCRYPTBUFFER_PKCS_ATTRS: u32 = 44u32;
pub const NCRYPTBUFFER_PKCS_KEY_NAME: u32 = 45u32;
pub const NCRYPTBUFFER_PKCS_OID: u32 = 40u32;
pub const NCRYPTBUFFER_PKCS_SECRET: u32 = 46u32;
pub const NCRYPTBUFFER_PROTECTION_DESCRIPTOR_STRING: u32 = 3u32;
pub const NCRYPTBUFFER_PROTECTION_FLAGS: u32 = 4u32;
pub const NCRYPTBUFFER_SSL_CLEAR_KEY: u32 = 23u32;
pub const NCRYPTBUFFER_SSL_CLIENT_RANDOM: u32 = 20u32;
pub const NCRYPTBUFFER_SSL_HIGHEST_VERSION: u32 = 22u32;
pub const NCRYPTBUFFER_SSL_KEY_ARG_DATA: u32 = 24u32;
pub const NCRYPTBUFFER_SSL_SERVER_RANDOM: u32 = 21u32;
pub const NCRYPTBUFFER_SSL_SESSION_HASH: u32 = 25u32;
pub const NCRYPTBUFFER_TPM_PLATFORM_CLAIM_NONCE: u32 = 81u32;
pub const NCRYPTBUFFER_TPM_PLATFORM_CLAIM_PCR_MASK: u32 = 80u32;
pub const NCRYPTBUFFER_TPM_PLATFORM_CLAIM_STATIC_CREATE: u32 = 82u32;
pub const NCRYPTBUFFER_TPM_SEAL_NO_DA_PROTECTION: u32 = 73u32;
pub const NCRYPTBUFFER_TPM_SEAL_PASSWORD: u32 = 70u32;
pub const NCRYPTBUFFER_TPM_SEAL_POLICYINFO: u32 = 71u32;
pub const NCRYPTBUFFER_TPM_SEAL_TICKET: u32 = 72u32;
pub const NCRYPTBUFFER_VERSION: u32 = 0u32;
pub const NCRYPTBUFFER_VSM_KEY_ATTESTATION_CLAIM_RESTRICTIONS: u32 = 54u32;
pub const NCRYPT_3DES_112_ALGORITHM: windows_core::PCWSTR = windows_core::w!("3DES_112");
pub const NCRYPT_3DES_ALGORITHM: windows_core::PCWSTR = windows_core::w!("3DES");
pub const NCRYPT_AES_ALGORITHM: windows_core::PCWSTR = windows_core::w!("AES");
pub const NCRYPT_AES_ALGORITHM_GROUP: windows_core::PCWSTR = windows_core::w!("AES");
pub const NCRYPT_ALGORITHM_GROUP_PROPERTY: windows_core::PCWSTR = windows_core::w!("Algorithm Group");
pub const NCRYPT_ALGORITHM_PROPERTY: windows_core::PCWSTR = windows_core::w!("Algorithm Name");
pub const NCRYPT_ALLOW_ALL_USAGES: u32 = 16777215u32;
pub const NCRYPT_ALLOW_ARCHIVING_FLAG: u32 = 4u32;
pub const NCRYPT_ALLOW_DECRYPT_FLAG: u32 = 1u32;
pub const NCRYPT_ALLOW_EXPORT_FLAG: u32 = 1u32;
pub const NCRYPT_ALLOW_KEY_AGREEMENT_FLAG: u32 = 4u32;
pub const NCRYPT_ALLOW_KEY_IMPORT_FLAG: u32 = 8u32;
pub const NCRYPT_ALLOW_PLAINTEXT_ARCHIVING_FLAG: u32 = 8u32;
pub const NCRYPT_ALLOW_PLAINTEXT_EXPORT_FLAG: u32 = 2u32;
pub const NCRYPT_ALLOW_SIGNING_FLAG: u32 = 2u32;
pub const NCRYPT_ALLOW_SILENT_KEY_ACCESS: u32 = 1u32;
pub const NCRYPT_ALTERNATE_KEY_STORAGE_LOCATION_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_ALTERNATE_KEY_STORAGE_LOCATION");
pub const NCRYPT_ASSOCIATED_ECDH_KEY: windows_core::PCWSTR = windows_core::w!("SmartCardAssociatedECDHKey");
pub const NCRYPT_ASYMMETRIC_ENCRYPTION_INTERFACE: NCRYPT_ALGORITHM_NAME_CLASS = NCRYPT_ALGORITHM_NAME_CLASS(3u32);
pub const NCRYPT_ASYMMETRIC_ENCRYPTION_OPERATION: NCRYPT_OPERATION = NCRYPT_OPERATION(4u32);
pub const NCRYPT_ATTESTATION_FLAG: u32 = 32u32;
pub const NCRYPT_AUTHORITY_KEY_FLAG: u32 = 256u32;
pub const NCRYPT_AUTH_TAG_LENGTH: windows_core::PCWSTR = windows_core::w!("AuthTagLength");
pub const NCRYPT_BLOCK_LENGTH_PROPERTY: windows_core::PCWSTR = windows_core::w!("Block Length");
pub const NCRYPT_CAPI_KDF_ALGORITHM: windows_core::PCWSTR = windows_core::w!("CAPI_KDF");
pub const NCRYPT_CERTIFICATE_PROPERTY: windows_core::PCWSTR = windows_core::w!("SmartCardKeyCertificate");
pub const NCRYPT_CHAINING_MODE_PROPERTY: windows_core::PCWSTR = windows_core::w!("Chaining Mode");
pub const NCRYPT_CHANGEPASSWORD_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_CHANGEPASSWORD");
pub const NCRYPT_CIPHER_BLOCK_PADDING_FLAG: u32 = 1u32;
pub const NCRYPT_CIPHER_KEY_BLOB: windows_core::PCWSTR = windows_core::w!("CipherKeyBlob");
pub const NCRYPT_CIPHER_KEY_BLOB_MAGIC: u32 = 1380470851u32;
pub const NCRYPT_CIPHER_NO_PADDING_FLAG: u32 = 0u32;
pub const NCRYPT_CIPHER_OPERATION: NCRYPT_OPERATION = NCRYPT_OPERATION(1u32);
pub const NCRYPT_CIPHER_OTHER_PADDING_FLAG: u32 = 2u32;
pub const NCRYPT_CLAIM_AUTHORITY_AND_SUBJECT: u32 = 3u32;
pub const NCRYPT_CLAIM_AUTHORITY_ONLY: u32 = 1u32;
pub const NCRYPT_CLAIM_PLATFORM: u32 = 65536u32;
pub const NCRYPT_CLAIM_SUBJECT_ONLY: u32 = 2u32;
pub const NCRYPT_CLAIM_UNKNOWN: u32 = 4096u32;
pub const NCRYPT_CLAIM_VSM_KEY_ATTESTATION_STATEMENT: u32 = 4u32;
pub const NCRYPT_CLAIM_WEB_AUTH_SUBJECT_ONLY: u32 = 258u32;
pub const NCRYPT_DESCR_DELIMITER_AND: windows_core::PCWSTR = windows_core::w!("AND");
pub const NCRYPT_DESCR_DELIMITER_OR: windows_core::PCWSTR = windows_core::w!("OR");
pub const NCRYPT_DESCR_EQUAL: windows_core::PCWSTR = windows_core::w!("=");
pub const NCRYPT_DESX_ALGORITHM: windows_core::PCWSTR = windows_core::w!("DESX");
pub const NCRYPT_DES_ALGORITHM: windows_core::PCWSTR = windows_core::w!("DES");
pub const NCRYPT_DES_ALGORITHM_GROUP: windows_core::PCWSTR = windows_core::w!("DES");
pub const NCRYPT_DH_ALGORITHM: windows_core::PCWSTR = windows_core::w!("DH");
pub const NCRYPT_DH_ALGORITHM_GROUP: windows_core::PCWSTR = windows_core::w!("DH");
pub const NCRYPT_DH_PARAMETERS_PROPERTY: windows_core::PCWSTR = windows_core::w!("DHParameters");
pub const NCRYPT_DISMISS_UI_TIMEOUT_SEC_PROPERTY: windows_core::PCWSTR = windows_core::w!("SmartCardDismissUITimeoutSeconds");
pub const NCRYPT_DO_NOT_FINALIZE_FLAG: u32 = 1024u32;
pub const NCRYPT_DSA_ALGORITHM: windows_core::PCWSTR = windows_core::w!("DSA");
pub const NCRYPT_DSA_ALGORITHM_GROUP: windows_core::PCWSTR = windows_core::w!("DSA");
pub const NCRYPT_ECC_CURVE_NAME_LIST_PROPERTY: windows_core::PCWSTR = windows_core::w!("ECCCurveNameList");
pub const NCRYPT_ECC_CURVE_NAME_PROPERTY: windows_core::PCWSTR = windows_core::w!("ECCCurveName");
pub const NCRYPT_ECC_PARAMETERS_PROPERTY: windows_core::PCWSTR = windows_core::w!("ECCParameters");
pub const NCRYPT_ECDH_ALGORITHM: windows_core::PCWSTR = windows_core::w!("ECDH");
pub const NCRYPT_ECDH_ALGORITHM_GROUP: windows_core::PCWSTR = windows_core::w!("ECDH");
pub const NCRYPT_ECDH_P256_ALGORITHM: windows_core::PCWSTR = windows_core::w!("ECDH_P256");
pub const NCRYPT_ECDH_P384_ALGORITHM: windows_core::PCWSTR = windows_core::w!("ECDH_P384");
pub const NCRYPT_ECDH_P521_ALGORITHM: windows_core::PCWSTR = windows_core::w!("ECDH_P521");
pub const NCRYPT_ECDSA_ALGORITHM: windows_core::PCWSTR = windows_core::w!("ECDSA");
pub const NCRYPT_ECDSA_ALGORITHM_GROUP: windows_core::PCWSTR = windows_core::w!("ECDSA");
pub const NCRYPT_ECDSA_P256_ALGORITHM: windows_core::PCWSTR = windows_core::w!("ECDSA_P256");
pub const NCRYPT_ECDSA_P384_ALGORITHM: windows_core::PCWSTR = windows_core::w!("ECDSA_P384");
pub const NCRYPT_ECDSA_P521_ALGORITHM: windows_core::PCWSTR = windows_core::w!("ECDSA_P521");
pub const NCRYPT_EXPORTED_ISOLATED_KEY_HEADER_CURRENT_VERSION: u32 = 0u32;
pub const NCRYPT_EXPORTED_ISOLATED_KEY_HEADER_V0: u32 = 0u32;
pub const NCRYPT_EXPORT_LEGACY_FLAG: u32 = 2048u32;
pub const NCRYPT_EXPORT_POLICY_PROPERTY: windows_core::PCWSTR = windows_core::w!("Export Policy");
pub const NCRYPT_EXTENDED_ERRORS_FLAG: u32 = 268435456u32;
pub const NCRYPT_HASH_OPERATION: NCRYPT_OPERATION = NCRYPT_OPERATION(2u32);
pub const NCRYPT_HMAC_SHA256_ALGORITHM: windows_core::PCWSTR = windows_core::w!("HMAC-SHA256");
pub const NCRYPT_IGNORE_DEVICE_STATE_FLAG: u32 = 4096u32;
pub const NCRYPT_IMPL_HARDWARE_FLAG: u32 = 1u32;
pub const NCRYPT_IMPL_HARDWARE_RNG_FLAG: u32 = 16u32;
pub const NCRYPT_IMPL_REMOVABLE_FLAG: u32 = 8u32;
pub const NCRYPT_IMPL_SOFTWARE_FLAG: u32 = 2u32;
pub const NCRYPT_IMPL_TYPE_PROPERTY: windows_core::PCWSTR = windows_core::w!("Impl Type");
pub const NCRYPT_IMPL_VIRTUAL_ISOLATION_FLAG: u32 = 32u32;
pub const NCRYPT_INITIALIZATION_VECTOR: windows_core::PCWSTR = windows_core::w!("IV");
pub const NCRYPT_ISOLATED_KEY_ATTESTED_ATTRIBUTES_CURRENT_VERSION: u32 = 0u32;
pub const NCRYPT_ISOLATED_KEY_ATTESTED_ATTRIBUTES_V0: u32 = 0u32;
pub const NCRYPT_ISOLATED_KEY_ENVELOPE_BLOB: windows_core::PCWSTR = windows_core::w!("ISOLATED_KEY_ENVELOPE");
pub const NCRYPT_ISOLATED_KEY_FLAG_CREATED_IN_ISOLATION: u32 = 1u32;
pub const NCRYPT_ISOLATED_KEY_FLAG_IMPORT_ONLY: u32 = 2u32;
pub const NCRYPT_KDF_KEY_BLOB: windows_core::PCWSTR = windows_core::w!("KDFKeyBlob");
pub const NCRYPT_KDF_KEY_BLOB_MAGIC: u32 = 826688587u32;
pub const NCRYPT_KDF_SECRET_VALUE: windows_core::PCWSTR = windows_core::w!("KDFKeySecret");
pub const NCRYPT_KEY_ACCESS_POLICY_PROPERTY: windows_core::PCWSTR = windows_core::w!("Key Access Policy");
pub const NCRYPT_KEY_ACCESS_POLICY_VERSION: u32 = 1u32;
pub const NCRYPT_KEY_ATTEST_MAGIC: u32 = 1146110283u32;
pub const NCRYPT_KEY_DERIVATION_GROUP: windows_core::PCWSTR = windows_core::w!("KEY_DERIVATION");
pub const NCRYPT_KEY_DERIVATION_INTERFACE: u32 = 7u32;
pub const NCRYPT_KEY_DERIVATION_OPERATION: u32 = 64u32;
pub const NCRYPT_KEY_PROTECTION_ALGORITHM_CERTIFICATE: windows_core::PCWSTR = windows_core::w!("CERTIFICATE");
pub const NCRYPT_KEY_PROTECTION_ALGORITHM_LOCAL: windows_core::PCWSTR = windows_core::w!("LOCAL");
pub const NCRYPT_KEY_PROTECTION_ALGORITHM_LOCKEDCREDENTIALS: windows_core::PCWSTR = windows_core::w!("LOCKEDCREDENTIALS");
pub const NCRYPT_KEY_PROTECTION_ALGORITHM_SDDL: windows_core::PCWSTR = windows_core::w!("SDDL");
pub const NCRYPT_KEY_PROTECTION_ALGORITHM_SID: windows_core::PCWSTR = windows_core::w!("SID");
pub const NCRYPT_KEY_PROTECTION_ALGORITHM_WEBCREDENTIALS: windows_core::PCWSTR = windows_core::w!("WEBCREDENTIALS");
pub const NCRYPT_KEY_PROTECTION_CERT_CERTBLOB: windows_core::PCWSTR = windows_core::w!("CertBlob");
pub const NCRYPT_KEY_PROTECTION_CERT_HASHID: windows_core::PCWSTR = windows_core::w!("HashId");
pub const NCRYPT_KEY_PROTECTION_INTERFACE: u32 = 65540u32;
pub const NCRYPT_KEY_PROTECTION_LOCAL_LOGON: windows_core::PCWSTR = windows_core::w!("logon");
pub const NCRYPT_KEY_PROTECTION_LOCAL_MACHINE: windows_core::PCWSTR = windows_core::w!("machine");
pub const NCRYPT_KEY_PROTECTION_LOCAL_USER: windows_core::PCWSTR = windows_core::w!("user");
pub const NCRYPT_KEY_STORAGE_ALGORITHM: windows_core::PCWSTR = windows_core::w!("KEY_STORAGE");
pub const NCRYPT_KEY_STORAGE_INTERFACE: BCRYPT_INTERFACE = BCRYPT_INTERFACE(65537u32);
pub const NCRYPT_KEY_TYPE_PROPERTY: windows_core::PCWSTR = windows_core::w!("Key Type");
pub const NCRYPT_KEY_USAGE_PROPERTY: windows_core::PCWSTR = windows_core::w!("Key Usage");
pub const NCRYPT_LAST_MODIFIED_PROPERTY: windows_core::PCWSTR = windows_core::w!("Modified");
pub const NCRYPT_LENGTHS_PROPERTY: windows_core::PCWSTR = windows_core::w!("Lengths");
pub const NCRYPT_LENGTH_PROPERTY: windows_core::PCWSTR = windows_core::w!("Length");
pub const NCRYPT_MACHINE_KEY_FLAG: NCRYPT_FLAGS = NCRYPT_FLAGS(32u32);
pub const NCRYPT_MAX_ALG_ID_LENGTH: u32 = 512u32;
pub const NCRYPT_MAX_KEY_NAME_LENGTH: u32 = 512u32;
pub const NCRYPT_MAX_NAME_LENGTH_PROPERTY: windows_core::PCWSTR = windows_core::w!("Max Name Length");
pub const NCRYPT_MAX_PROPERTY_DATA: u32 = 1048576u32;
pub const NCRYPT_MAX_PROPERTY_NAME: u32 = 64u32;
pub const NCRYPT_MD2_ALGORITHM: windows_core::PCWSTR = windows_core::w!("MD2");
pub const NCRYPT_MD4_ALGORITHM: windows_core::PCWSTR = windows_core::w!("MD4");
pub const NCRYPT_MD5_ALGORITHM: windows_core::PCWSTR = windows_core::w!("MD5");
pub const NCRYPT_NAMED_DESCRIPTOR_FLAG: u32 = 1u32;
pub const NCRYPT_NAME_PROPERTY: windows_core::PCWSTR = windows_core::w!("Name");
pub const NCRYPT_NO_CACHED_PASSWORD: u32 = 16384u32;
pub const NCRYPT_NO_KEY_VALIDATION: NCRYPT_FLAGS = NCRYPT_FLAGS(8u32);
pub const NCRYPT_NO_PADDING_FLAG: NCRYPT_FLAGS = NCRYPT_FLAGS(1u32);
pub const NCRYPT_OPAQUETRANSPORT_BLOB: windows_core::PCWSTR = windows_core::w!("OpaqueTransport");
pub const NCRYPT_OVERWRITE_KEY_FLAG: NCRYPT_FLAGS = NCRYPT_FLAGS(128u32);
pub const NCRYPT_PAD_CIPHER_FLAG: u32 = 16u32;
pub const NCRYPT_PAD_OAEP_FLAG: NCRYPT_FLAGS = NCRYPT_FLAGS(4u32);
pub const NCRYPT_PAD_PKCS1_FLAG: NCRYPT_FLAGS = NCRYPT_FLAGS(2u32);
pub const NCRYPT_PAD_PSS_FLAG: NCRYPT_FLAGS = NCRYPT_FLAGS(8u32);
pub const NCRYPT_PBKDF2_ALGORITHM: windows_core::PCWSTR = windows_core::w!("PBKDF2");
pub const NCRYPT_PCP_ALTERNATE_KEY_STORAGE_LOCATION_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_ALTERNATE_KEY_STORAGE_LOCATION");
pub const NCRYPT_PCP_CHANGEPASSWORD_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_CHANGEPASSWORD");
pub const NCRYPT_PCP_ECC_EKCERT_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_ECC_EKCERT");
pub const NCRYPT_PCP_ECC_EKNVCERT_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_ECC_EKNVCERT");
pub const NCRYPT_PCP_ECC_EKPUB_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_ECC_EKPUB");
pub const NCRYPT_PCP_EKCERT_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_EKCERT");
pub const NCRYPT_PCP_EKNVCERT_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_EKNVCERT");
pub const NCRYPT_PCP_EKPUB_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_EKPUB");
pub const NCRYPT_PCP_ENCRYPTION_KEY: u32 = 2u32;
pub const NCRYPT_PCP_EXPORT_ALLOWED_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_EXPORT_ALLOWED");
pub const NCRYPT_PCP_HMACVERIFICATION_KEY: u32 = 16u32;
pub const NCRYPT_PCP_HMAC_AUTH_NONCE: windows_core::PCWSTR = windows_core::w!("PCP_HMAC_AUTH_NONCE");
pub const NCRYPT_PCP_HMAC_AUTH_POLICYINFO: windows_core::PCWSTR = windows_core::w!("PCP_HMAC_AUTH_POLICYINFO");
pub const NCRYPT_PCP_HMAC_AUTH_POLICYREF: windows_core::PCWSTR = windows_core::w!("PCP_HMAC_AUTH_POLICYREF");
pub const NCRYPT_PCP_HMAC_AUTH_SIGNATURE: windows_core::PCWSTR = windows_core::w!("PCP_HMAC_AUTH_SIGNATURE");
pub const NCRYPT_PCP_HMAC_AUTH_TICKET: windows_core::PCWSTR = windows_core::w!("PCP_HMAC_AUTH_TICKET");
pub const NCRYPT_PCP_IDENTITY_KEY: u32 = 8u32;
pub const NCRYPT_PCP_INTERMEDIATE_CA_EKCERT_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_INTERMEDIATE_CA_EKCERT");
pub const NCRYPT_PCP_KEYATTESTATION_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_TPM12_KEYATTESTATION");
pub const NCRYPT_PCP_KEY_CREATIONHASH_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_KEY_CREATIONHASH");
pub const NCRYPT_PCP_KEY_CREATIONTICKET_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_KEY_CREATIONTICKET");
pub const NCRYPT_PCP_KEY_USAGE_POLICY_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_KEY_USAGE_POLICY");
pub const NCRYPT_PCP_MIGRATIONPASSWORD_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_MIGRATIONPASSWORD");
pub const NCRYPT_PCP_NO_DA_PROTECTION_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_NO_DA_PROTECTION");
pub const NCRYPT_PCP_PASSWORD_REQUIRED_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_PASSWORD_REQUIRED");
pub const NCRYPT_PCP_PCRTABLE_ALGORITHM_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_PCRTABLE_ALGORITHM");
pub const NCRYPT_PCP_PCRTABLE_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_PCRTABLE");
pub const NCRYPT_PCP_PLATFORMHANDLE_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_PLATFORMHANDLE");
pub const NCRYPT_PCP_PLATFORM_BINDING_PCRALGID_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_PLATFORM_BINDING_PCRALGID");
pub const NCRYPT_PCP_PLATFORM_BINDING_PCRDIGESTLIST_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_PLATFORM_BINDING_PCRDIGESTLIST");
pub const NCRYPT_PCP_PLATFORM_BINDING_PCRDIGEST_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_PLATFORM_BINDING_PCRDIGEST");
pub const NCRYPT_PCP_PLATFORM_BINDING_PCRMASK_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_PLATFORM_BINDING_PCRMASK");
pub const NCRYPT_PCP_PLATFORM_TYPE_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_PLATFORM_TYPE");
pub const NCRYPT_PCP_PROVIDERHANDLE_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_PROVIDERMHANDLE");
pub const NCRYPT_PCP_PROVIDER_VERSION_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_PROVIDER_VERSION");
pub const NCRYPT_PCP_PSS_SALT_SIZE_PROPERTY: windows_core::PCWSTR = windows_core::w!("PSS Salt Size");
pub const NCRYPT_PCP_RAW_POLICYDIGEST_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_RAW_POLICYDIGEST");
pub const NCRYPT_PCP_RSA_EKCERT_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_RSA_EKCERT");
pub const NCRYPT_PCP_RSA_EKNVCERT_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_RSA_EKNVCERT");
pub const NCRYPT_PCP_RSA_EKPUB_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_RSA_EKPUB");
pub const NCRYPT_PCP_RSA_SCHEME_HASH_ALG_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_RSA_SCHEME_HASH_ALG");
pub const NCRYPT_PCP_RSA_SCHEME_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_RSA_SCHEME");
pub const NCRYPT_PCP_SESSIONID_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_SESSIONID");
pub const NCRYPT_PCP_SIGNATURE_KEY: u32 = 1u32;
pub const NCRYPT_PCP_SRKPUB_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_SRKPUB");
pub const NCRYPT_PCP_STORAGEPARENT_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_STORAGEPARENT");
pub const NCRYPT_PCP_STORAGE_KEY: u32 = 4u32;
pub const NCRYPT_PCP_SYMMETRIC_KEYBITS_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_SYMMETRIC_KEYBITS");
pub const NCRYPT_PCP_TPM12_IDACTIVATION_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_TPM12_IDACTIVATION");
pub const NCRYPT_PCP_TPM12_IDBINDING_DYNAMIC_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_TPM12_IDBINDING_DYNAMIC");
pub const NCRYPT_PCP_TPM12_IDBINDING_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_TPM12_IDBINDING");
pub const NCRYPT_PCP_TPM2BNAME_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_TPM2BNAME");
pub const NCRYPT_PCP_TPM_FW_VERSION_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_TPM_FW_VERSION");
pub const NCRYPT_PCP_TPM_IFX_RSA_KEYGEN_PROHIBITED_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_TPM_IFX_RSA_KEYGEN_PROHIBITED");
pub const NCRYPT_PCP_TPM_IFX_RSA_KEYGEN_VULNERABILITY_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_TPM_IFX_RSA_KEYGEN_VULNERABILITY");
pub const NCRYPT_PCP_TPM_MANUFACTURER_ID_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_TPM_MANUFACTURER_ID");
pub const NCRYPT_PCP_TPM_VERSION_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_TPM_VERSION");
pub const NCRYPT_PCP_USAGEAUTH_PROPERTY: windows_core::PCWSTR = windows_core::w!("PCP_USAGEAUTH");
pub const NCRYPT_PERSIST_FLAG: NCRYPT_FLAGS = NCRYPT_FLAGS(2147483648u32);
pub const NCRYPT_PERSIST_ONLY_FLAG: NCRYPT_FLAGS = NCRYPT_FLAGS(1073741824u32);
pub const NCRYPT_PIN_CACHE_APPLICATION_IMAGE_PROPERTY: windows_core::PCWSTR = windows_core::w!("PinCacheApplicationImage");
pub const NCRYPT_PIN_CACHE_APPLICATION_STATUS_PROPERTY: windows_core::PCWSTR = windows_core::w!("PinCacheApplicationStatus");
pub const NCRYPT_PIN_CACHE_APPLICATION_TICKET_BYTE_LENGTH: u32 = 90u32;
pub const NCRYPT_PIN_CACHE_APPLICATION_TICKET_PROPERTY: windows_core::PCWSTR = windows_core::w!("PinCacheApplicationTicket");
pub const NCRYPT_PIN_CACHE_CLEAR_FOR_CALLING_PROCESS_OPTION: u32 = 1u32;
pub const NCRYPT_PIN_CACHE_CLEAR_PROPERTY: windows_core::PCWSTR = windows_core::w!("PinCacheClear");
pub const NCRYPT_PIN_CACHE_DISABLE_DPL_FLAG: u32 = 1u32;
pub const NCRYPT_PIN_CACHE_FLAGS_PROPERTY: windows_core::PCWSTR = windows_core::w!("PinCacheFlags");
pub const NCRYPT_PIN_CACHE_FREE_APPLICATION_TICKET_PROPERTY: windows_core::PCWSTR = windows_core::w!("PinCacheFreeApplicationTicket");
pub const NCRYPT_PIN_CACHE_IS_GESTURE_REQUIRED_PROPERTY: windows_core::PCWSTR = windows_core::w!("PinCacheIsGestureRequired");
pub const NCRYPT_PIN_CACHE_PIN_PROPERTY: windows_core::PCWSTR = windows_core::w!("PinCachePin");
pub const NCRYPT_PIN_CACHE_REQUIRE_GESTURE_FLAG: u32 = 1u32;
pub const NCRYPT_PIN_PROMPT_PROPERTY: windows_core::PCWSTR = windows_core::w!("SmartCardPinPrompt");
pub const NCRYPT_PIN_PROPERTY: windows_core::PCWSTR = windows_core::w!("SmartCardPin");
pub const NCRYPT_PKCS7_ENVELOPE_BLOB: windows_core::PCWSTR = windows_core::w!("PKCS7_ENVELOPE");
pub const NCRYPT_PKCS8_PRIVATE_KEY_BLOB: windows_core::PCWSTR = windows_core::w!("PKCS8_PRIVATEKEY");
pub const NCRYPT_PLATFORM_ATTEST_MAGIC: u32 = 1146110288u32;
pub const NCRYPT_PREFER_VIRTUAL_ISOLATION_FLAG: u32 = 65536u32;
pub const NCRYPT_PROTECTED_KEY_BLOB: windows_core::PCWSTR = windows_core::w!("ProtectedKeyBlob");
pub const NCRYPT_PROTECTED_KEY_BLOB_MAGIC: u32 = 1263817296u32;
pub const NCRYPT_PROTECTION_INFO_TYPE_DESCRIPTOR_STRING: u32 = 1u32;
pub const NCRYPT_PROTECT_TO_LOCAL_SYSTEM: u32 = 32768u32;
pub const NCRYPT_PROVIDER_HANDLE_PROPERTY: windows_core::PCWSTR = windows_core::w!("Provider Handle");
pub const NCRYPT_PUBLIC_LENGTH_PROPERTY: windows_core::PCWSTR = windows_core::w!("PublicKeyLength");
pub const NCRYPT_RC2_ALGORITHM: windows_core::PCWSTR = windows_core::w!("RC2");
pub const NCRYPT_RC2_ALGORITHM_GROUP: windows_core::PCWSTR = windows_core::w!("RC2");
pub const NCRYPT_READER_ICON_PROPERTY: windows_core::PCWSTR = windows_core::w!("SmartCardReaderIcon");
pub const NCRYPT_READER_PROPERTY: windows_core::PCWSTR = windows_core::w!("SmartCardReader");
pub const NCRYPT_REGISTER_NOTIFY_FLAG: NCRYPT_FLAGS = NCRYPT_FLAGS(1u32);
pub const NCRYPT_REQUIRE_KDS_LRPC_BIND_FLAG: u32 = 536870912u32;
pub const NCRYPT_ROOT_CERTSTORE_PROPERTY: windows_core::PCWSTR = windows_core::w!("SmartcardRootCertStore");
pub const NCRYPT_RSA_ALGORITHM: windows_core::PCWSTR = windows_core::w!("RSA");
pub const NCRYPT_RSA_ALGORITHM_GROUP: windows_core::PCWSTR = windows_core::w!("RSA");
pub const NCRYPT_RSA_SIGN_ALGORITHM: windows_core::PCWSTR = windows_core::w!("RSA_SIGN");
pub const NCRYPT_SCARD_NGC_KEY_NAME: windows_core::PCWSTR = windows_core::w!("SmartCardNgcKeyName");
pub const NCRYPT_SCARD_PIN_ID: windows_core::PCWSTR = windows_core::w!("SmartCardPinId");
pub const NCRYPT_SCARD_PIN_INFO: windows_core::PCWSTR = windows_core::w!("SmartCardPinInfo");
pub const NCRYPT_SCHANNEL_INTERFACE: BCRYPT_INTERFACE = BCRYPT_INTERFACE(65538u32);
pub const NCRYPT_SCHANNEL_SIGNATURE_INTERFACE: BCRYPT_INTERFACE = BCRYPT_INTERFACE(65539u32);
pub const NCRYPT_SEALING_FLAG: u32 = 256u32;
pub const NCRYPT_SECRET_AGREEMENT_INTERFACE: NCRYPT_ALGORITHM_NAME_CLASS = NCRYPT_ALGORITHM_NAME_CLASS(4u32);
pub const NCRYPT_SECRET_AGREEMENT_OPERATION: NCRYPT_OPERATION = NCRYPT_OPERATION(8u32);
pub const NCRYPT_SECURE_PIN_PROPERTY: windows_core::PCWSTR = windows_core::w!("SmartCardSecurePin");
pub const NCRYPT_SECURITY_DESCR_PROPERTY: windows_core::PCWSTR = windows_core::w!("Security Descr");
pub const NCRYPT_SECURITY_DESCR_SUPPORT_PROPERTY: windows_core::PCWSTR = windows_core::w!("Security Descr Support");
pub const NCRYPT_SHA1_ALGORITHM: windows_core::PCWSTR = windows_core::w!("SHA1");
pub const NCRYPT_SHA256_ALGORITHM: windows_core::PCWSTR = windows_core::w!("SHA256");
pub const NCRYPT_SHA384_ALGORITHM: windows_core::PCWSTR = windows_core::w!("SHA384");
pub const NCRYPT_SHA512_ALGORITHM: windows_core::PCWSTR = windows_core::w!("SHA512");
pub const NCRYPT_SIGNATURE_INTERFACE: NCRYPT_ALGORITHM_NAME_CLASS = NCRYPT_ALGORITHM_NAME_CLASS(5u32);
pub const NCRYPT_SIGNATURE_LENGTH_PROPERTY: windows_core::PCWSTR = windows_core::w!("SignatureLength");
pub const NCRYPT_SIGNATURE_OPERATION: NCRYPT_OPERATION = NCRYPT_OPERATION(16u32);
pub const NCRYPT_SILENT_FLAG: NCRYPT_FLAGS = NCRYPT_FLAGS(64u32);
pub const NCRYPT_SMARTCARD_GUID_PROPERTY: windows_core::PCWSTR = windows_core::w!("SmartCardGuid");
pub const NCRYPT_SP800108_CTR_HMAC_ALGORITHM: windows_core::PCWSTR = windows_core::w!("SP800_108_CTR_HMAC");
pub const NCRYPT_SP80056A_CONCAT_ALGORITHM: windows_core::PCWSTR = windows_core::w!("SP800_56A_CONCAT");
pub const NCRYPT_TPM12_PROVIDER: u32 = 65536u32;
pub const NCRYPT_TPM_LOADABLE_KEY_BLOB: windows_core::PCWSTR = windows_core::w!("PcpTpmProtectedKeyBlob");
pub const NCRYPT_TPM_LOADABLE_KEY_BLOB_MAGIC: u32 = 1297371211u32;
pub const NCRYPT_TPM_PAD_PSS_IGNORE_SALT: u32 = 32u32;
pub const NCRYPT_TPM_PLATFORM_ATTESTATION_STATEMENT_CURRENT_VERSION: u32 = 0u32;
pub const NCRYPT_TPM_PLATFORM_ATTESTATION_STATEMENT_V0: u32 = 0u32;
pub const NCRYPT_TPM_PSS_SALT_SIZE_HASHSIZE: u32 = 2u32;
pub const NCRYPT_TPM_PSS_SALT_SIZE_MAXIMUM: u32 = 1u32;
pub const NCRYPT_TPM_PSS_SALT_SIZE_UNKNOWN: u32 = 0u32;
pub const NCRYPT_TREAT_NIST_AS_GENERIC_ECC_FLAG: u32 = 8192u32;
pub const NCRYPT_UI_APPCONTAINER_ACCESS_MEDIUM_FLAG: u32 = 8u32;
pub const NCRYPT_UI_FINGERPRINT_PROTECTION_FLAG: u32 = 4u32;
pub const NCRYPT_UI_FORCE_HIGH_PROTECTION_FLAG: u32 = 2u32;
pub const NCRYPT_UI_POLICY_PROPERTY: windows_core::PCWSTR = windows_core::w!("UI Policy");
pub const NCRYPT_UI_PROTECT_KEY_FLAG: u32 = 1u32;
pub const NCRYPT_UNIQUE_NAME_PROPERTY: windows_core::PCWSTR = windows_core::w!("Unique Name");
pub const NCRYPT_UNPROTECT_NO_DECRYPT: NCRYPT_FLAGS = NCRYPT_FLAGS(1u32);
pub const NCRYPT_UNREGISTER_NOTIFY_FLAG: NCRYPT_FLAGS = NCRYPT_FLAGS(2u32);
pub const NCRYPT_USER_CERTSTORE_PROPERTY: windows_core::PCWSTR = windows_core::w!("SmartCardUserCertStore");
pub const NCRYPT_USE_CONTEXT_PROPERTY: windows_core::PCWSTR = windows_core::w!("Use Context");
pub const NCRYPT_USE_COUNT_ENABLED_PROPERTY: windows_core::PCWSTR = windows_core::w!("Enabled Use Count");
pub const NCRYPT_USE_COUNT_PROPERTY: windows_core::PCWSTR = windows_core::w!("Use Count");
pub const NCRYPT_USE_PER_BOOT_KEY_FLAG: u32 = 262144u32;
pub const NCRYPT_USE_PER_BOOT_KEY_PROPERTY: windows_core::PCWSTR = windows_core::w!("Per Boot Key");
pub const NCRYPT_USE_VIRTUAL_ISOLATION_FLAG: u32 = 131072u32;
pub const NCRYPT_USE_VIRTUAL_ISOLATION_PROPERTY: windows_core::PCWSTR = windows_core::w!("Virtual Iso");
pub const NCRYPT_VERSION_PROPERTY: windows_core::PCWSTR = windows_core::w!("Version");
pub const NCRYPT_VSM_KEY_ATTESTATION_CLAIM_RESTRICTIONS_CURRENT_VERSION: u32 = 0u32;
pub const NCRYPT_VSM_KEY_ATTESTATION_CLAIM_RESTRICTIONS_V0: u32 = 0u32;
pub const NCRYPT_VSM_KEY_ATTESTATION_STATEMENT_CURRENT_VERSION: u32 = 0u32;
pub const NCRYPT_VSM_KEY_ATTESTATION_STATEMENT_V0: u32 = 0u32;
pub const NCRYPT_WINDOW_HANDLE_PROPERTY: windows_core::PCWSTR = windows_core::w!("HWND Handle");
pub const NCRYPT_WRITE_KEY_TO_LEGACY_STORE_FLAG: NCRYPT_FLAGS = NCRYPT_FLAGS(512u32);
pub const NETSCAPE_SIGN_CA_CERT_TYPE: u32 = 1u32;
pub const NETSCAPE_SIGN_CERT_TYPE: u32 = 16u32;
pub const NETSCAPE_SMIME_CA_CERT_TYPE: u32 = 2u32;
pub const NETSCAPE_SMIME_CERT_TYPE: u32 = 32u32;
pub const NETSCAPE_SSL_CA_CERT_TYPE: u32 = 4u32;
pub const NETSCAPE_SSL_CLIENT_AUTH_CERT_TYPE: u32 = 128u32;
pub const NETSCAPE_SSL_SERVER_AUTH_CERT_TYPE: u32 = 64u32;
pub const OCSP_BASIC_BY_KEY_RESPONDER_ID: u32 = 2u32;
pub const OCSP_BASIC_BY_NAME_RESPONDER_ID: u32 = 1u32;
pub const OCSP_BASIC_GOOD_CERT_STATUS: u32 = 0u32;
pub const OCSP_BASIC_RESPONSE: windows_core::PCSTR = windows_core::PCSTR(69i32 as _);
pub const OCSP_BASIC_RESPONSE_V1: u32 = 0u32;
pub const OCSP_BASIC_REVOKED_CERT_STATUS: u32 = 1u32;
pub const OCSP_BASIC_SIGNED_RESPONSE: windows_core::PCSTR = windows_core::PCSTR(68i32 as _);
pub const OCSP_BASIC_UNKNOWN_CERT_STATUS: u32 = 2u32;
pub const OCSP_INTERNAL_ERROR_RESPONSE: u32 = 2u32;
pub const OCSP_MALFORMED_REQUEST_RESPONSE: u32 = 1u32;
pub const OCSP_REQUEST: windows_core::PCSTR = windows_core::PCSTR(66i32 as _);
pub const OCSP_REQUEST_V1: u32 = 0u32;
pub const OCSP_RESPONSE: windows_core::PCSTR = windows_core::PCSTR(67i32 as _);
pub const OCSP_SIGNED_REQUEST: windows_core::PCSTR = windows_core::PCSTR(65i32 as _);
pub const OCSP_SIG_REQUIRED_RESPONSE: u32 = 5u32;
pub const OCSP_SUCCESSFUL_RESPONSE: u32 = 0u32;
pub const OCSP_TRY_LATER_RESPONSE: u32 = 3u32;
pub const OCSP_UNAUTHORIZED_RESPONSE: u32 = 6u32;
pub const OPAQUEKEYBLOB: u32 = 9u32;
pub const PKCS12_ALLOW_OVERWRITE_KEY: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(16384u32);
pub const PKCS12_ALWAYS_CNG_KSP: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(512u32);
pub const PKCS12_CONFIG_REGPATH: windows_core::PCWSTR = windows_core::w!("Software\\Microsoft\\Windows\\CurrentVersion\\PFX");
pub const PKCS12_DISABLE_ENCRYPT_CERTIFICATES: u32 = 256u32;
pub const PKCS12_ENCRYPT_CERTIFICATES: u32 = 512u32;
pub const PKCS12_ENCRYPT_CERTIFICATES_VALUE_NAME: windows_core::PCWSTR = windows_core::w!("EncryptCertificates");
pub const PKCS12_EXPORT_ECC_CURVE_OID: u32 = 8192u32;
pub const PKCS12_EXPORT_ECC_CURVE_PARAMETERS: u32 = 4096u32;
pub const PKCS12_EXPORT_PBES2_PARAMS: u32 = 128u32;
pub const PKCS12_EXPORT_RESERVED_MASK: u32 = 4294901760u32;
pub const PKCS12_EXPORT_SILENT: u32 = 64u32;
pub const PKCS12_IMPORT_RESERVED_MASK: u32 = 4294901760u32;
pub const PKCS12_IMPORT_SILENT: u32 = 64u32;
pub const PKCS12_INCLUDE_EXTENDED_PROPERTIES: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(16u32);
pub const PKCS12_NO_PERSIST_KEY: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(32768u32);
pub const PKCS12_ONLY_CERTIFICATES: u32 = 1024u32;
pub const PKCS12_ONLY_CERTIFICATES_CONTAINER_NAME: windows_core::PCWSTR = windows_core::w!("PfxContainer");
pub const PKCS12_ONLY_CERTIFICATES_PROVIDER_NAME: windows_core::PCWSTR = windows_core::w!("PfxProvider");
pub const PKCS12_ONLY_CERTIFICATES_PROVIDER_TYPE: u32 = 0u32;
pub const PKCS12_ONLY_NOT_ENCRYPTED_CERTIFICATES: u32 = 2048u32;
pub const PKCS12_PBES2_ALG_AES256_SHA256: windows_core::PCWSTR = windows_core::w!("AES256-SHA256");
pub const PKCS12_PBKDF2_ID_HMAC_SHA1: windows_core::PCSTR = windows_core::s!("1.2.840.113549.2.7");
pub const PKCS12_PBKDF2_ID_HMAC_SHA256: windows_core::PCSTR = windows_core::s!("1.2.840.113549.2.9");
pub const PKCS12_PBKDF2_ID_HMAC_SHA384: windows_core::PCSTR = windows_core::s!("1.2.840.113549.2.10");
pub const PKCS12_PBKDF2_ID_HMAC_SHA512: windows_core::PCSTR = windows_core::s!("1.2.840.113549.2.11");
pub const PKCS12_PREFER_CNG_KSP: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(256u32);
pub const PKCS12_PROTECT_TO_DOMAIN_SIDS: u32 = 32u32;
pub const PKCS12_VIRTUAL_ISOLATION_KEY: u32 = 65536u32;
pub const PKCS5_PADDING: u32 = 1u32;
pub const PKCS7_SIGNER_INFO: windows_core::PCSTR = windows_core::PCSTR(500i32 as _);
pub const PKCS_7_ASN_ENCODING: CERT_QUERY_ENCODING_TYPE = CERT_QUERY_ENCODING_TYPE(65536u32);
pub const PKCS_7_NDR_ENCODING: u32 = 131072u32;
pub const PKCS_ATTRIBUTE: windows_core::PCSTR = windows_core::PCSTR(22i32 as _);
pub const PKCS_ATTRIBUTES: windows_core::PCSTR = windows_core::PCSTR(48i32 as _);
pub const PKCS_CONTENT_INFO: windows_core::PCSTR = windows_core::PCSTR(33i32 as _);
pub const PKCS_CONTENT_INFO_SEQUENCE_OF_ANY: windows_core::PCSTR = windows_core::PCSTR(23i32 as _);
pub const PKCS_CTL: windows_core::PCSTR = windows_core::PCSTR(37i32 as _);
pub const PKCS_ENCRYPTED_PRIVATE_KEY_INFO: windows_core::PCSTR = windows_core::PCSTR(45i32 as _);
pub const PKCS_PRIVATE_KEY_INFO: windows_core::PCSTR = windows_core::PCSTR(44i32 as _);
pub const PKCS_RC2_CBC_PARAMETERS: windows_core::PCSTR = windows_core::PCSTR(41i32 as _);
pub const PKCS_RSAES_OAEP_PARAMETERS: windows_core::PCSTR = windows_core::PCSTR(76i32 as _);
pub const PKCS_RSA_PRIVATE_KEY: windows_core::PCSTR = windows_core::PCSTR(43i32 as _);
pub const PKCS_RSA_SSA_PSS_PARAMETERS: windows_core::PCSTR = windows_core::PCSTR(75i32 as _);
pub const PKCS_RSA_SSA_PSS_TRAILER_FIELD_BC: u32 = 1u32;
pub const PKCS_SMIME_CAPABILITIES: windows_core::PCSTR = windows_core::PCSTR(42i32 as _);
pub const PKCS_SORTED_CTL: windows_core::PCSTR = windows_core::PCSTR(49i32 as _);
pub const PKCS_TIME_REQUEST: windows_core::PCSTR = windows_core::PCSTR(18i32 as _);
pub const PKCS_UTC_TIME: windows_core::PCSTR = windows_core::PCSTR(17i32 as _);
pub const PLAINTEXTKEYBLOB: u32 = 8u32;
pub const PP_ADMIN_PIN: u32 = 31u32;
pub const PP_APPLI_CERT: u32 = 18u32;
pub const PP_CERTCHAIN: u32 = 9u32;
pub const PP_CHANGE_PASSWORD: u32 = 7u32;
pub const PP_CLIENT_HWND: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(1u32);
pub const PP_CONTAINER: u32 = 6u32;
pub const PP_CONTEXT_INFO: u32 = 11u32;
pub const PP_CRYPT_COUNT_KEY_USE: u32 = 41u32;
pub const PP_DELETEKEY: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(24u32);
pub const PP_DISMISS_PIN_UI_SEC: u32 = 49u32;
pub const PP_ENUMALGS: u32 = 1u32;
pub const PP_ENUMALGS_EX: u32 = 22u32;
pub const PP_ENUMCONTAINERS: u32 = 2u32;
pub const PP_ENUMELECTROOTS: u32 = 26u32;
pub const PP_ENUMEX_SIGNING_PROT: u32 = 40u32;
pub const PP_ENUMMANDROOTS: u32 = 25u32;
pub const PP_IMPTYPE: u32 = 3u32;
pub const PP_IS_PFX_EPHEMERAL: u32 = 50u32;
pub const PP_KEYEXCHANGE_ALG: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(14u32);
pub const PP_KEYEXCHANGE_KEYSIZE: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(12u32);
pub const PP_KEYEXCHANGE_PIN: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(32u32);
pub const PP_KEYSET_SEC_DESCR: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(8u32);
pub const PP_KEYSET_TYPE: u32 = 27u32;
pub const PP_KEYSPEC: u32 = 39u32;
pub const PP_KEYSTORAGE: u32 = 17u32;
pub const PP_KEYX_KEYSIZE_INC: u32 = 35u32;
pub const PP_KEY_TYPE_SUBTYPE: u32 = 10u32;
pub const PP_NAME: u32 = 4u32;
pub const PP_PIN_PROMPT_STRING: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(44u32);
pub const PP_PROVTYPE: u32 = 16u32;
pub const PP_ROOT_CERTSTORE: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(46u32);
pub const PP_SECURE_KEYEXCHANGE_PIN: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(47u32);
pub const PP_SECURE_SIGNATURE_PIN: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(48u32);
pub const PP_SESSION_KEYSIZE: u32 = 20u32;
pub const PP_SGC_INFO: u32 = 37u32;
pub const PP_SIGNATURE_ALG: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(15u32);
pub const PP_SIGNATURE_KEYSIZE: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(13u32);
pub const PP_SIGNATURE_PIN: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(33u32);
pub const PP_SIG_KEYSIZE_INC: u32 = 34u32;
pub const PP_SMARTCARD_GUID: u32 = 45u32;
pub const PP_SMARTCARD_READER: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(43u32);
pub const PP_SMARTCARD_READER_ICON: u32 = 47u32;
pub const PP_SYM_KEYSIZE: u32 = 19u32;
pub const PP_UI_PROMPT: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(21u32);
pub const PP_UNIQUE_CONTAINER: u32 = 36u32;
pub const PP_USER_CERTSTORE: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(42u32);
pub const PP_USE_HARDWARE_RNG: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(38u32);
pub const PP_VERSION: u32 = 5u32;
pub const PRIVATEKEYBLOB: u32 = 7u32;
pub const PROV_DH_SCHANNEL: u32 = 18u32;
pub const PROV_DSS: u32 = 3u32;
pub const PROV_DSS_DH: u32 = 13u32;
pub const PROV_EC_ECDSA_FULL: u32 = 16u32;
pub const PROV_EC_ECDSA_SIG: u32 = 14u32;
pub const PROV_EC_ECNRA_FULL: u32 = 17u32;
pub const PROV_EC_ECNRA_SIG: u32 = 15u32;
pub const PROV_FORTEZZA: u32 = 4u32;
pub const PROV_INTEL_SEC: u32 = 22u32;
pub const PROV_MS_EXCHANGE: u32 = 5u32;
pub const PROV_REPLACE_OWF: u32 = 23u32;
pub const PROV_RNG: u32 = 21u32;
pub const PROV_RSA_AES: u32 = 24u32;
pub const PROV_RSA_FULL: u32 = 1u32;
pub const PROV_RSA_SCHANNEL: u32 = 12u32;
pub const PROV_RSA_SIG: u32 = 2u32;
pub const PROV_SPYRUS_LYNKS: u32 = 20u32;
pub const PROV_SSL: u32 = 6u32;
pub const PROV_STT_ACQ: u32 = 8u32;
pub const PROV_STT_BRND: u32 = 9u32;
pub const PROV_STT_ISS: u32 = 11u32;
pub const PROV_STT_MER: u32 = 7u32;
pub const PROV_STT_ROOT: u32 = 10u32;
pub const PUBLICKEYBLOB: u32 = 6u32;
pub const PUBLICKEYBLOBEX: u32 = 10u32;
pub const PVK_TYPE_FILE_NAME: SIGNER_PRIVATE_KEY_CHOICE = SIGNER_PRIVATE_KEY_CHOICE(1u32);
pub const PVK_TYPE_KEYCONTAINER: SIGNER_PRIVATE_KEY_CHOICE = SIGNER_PRIVATE_KEY_CHOICE(2u32);
pub const RANDOM_PADDING: u32 = 2u32;
pub const RECIPIENTPOLICYV1: u32 = 1u32;
pub const RECIPIENTPOLICYV2: u32 = 2u32;
pub const REPORT_NOT_ABLE_TO_EXPORT_PRIVATE_KEY: u32 = 2u32;
pub const REPORT_NO_PRIVATE_KEY: u32 = 1u32;
pub const REVOCATION_OID_CRL_REVOCATION: windows_core::PCSTR = windows_core::PCSTR(1i32 as _);
pub const RSA1024BIT_KEY: u32 = 67108864u32;
pub const RSA_CSP_PUBLICKEYBLOB: windows_core::PCSTR = windows_core::PCSTR(19i32 as _);
pub const SCHANNEL_ENC_KEY: u32 = 1u32;
pub const SCHANNEL_MAC_KEY: u32 = 0u32;
pub const SCHEME_OID_RETRIEVE_ENCODED_OBJECTW_FUNC: windows_core::PCSTR = windows_core::s!("SchemeDllRetrieveEncodedObjectW");
pub const SCHEME_OID_RETRIEVE_ENCODED_OBJECT_FUNC: windows_core::PCSTR = windows_core::s!("SchemeDllRetrieveEncodedObject");
pub const SIGNATURE_RESOURCE_NUMBER: u32 = 666u32;
pub const SIGNER_AUTHCODE_ATTR: SIGNER_SIGNATURE_ATTRIBUTE_CHOICE = SIGNER_SIGNATURE_ATTRIBUTE_CHOICE(1u32);
pub const SIGNER_CERT_POLICY_CHAIN: SIGNER_CERT_POLICY = SIGNER_CERT_POLICY(2u32);
pub const SIGNER_CERT_POLICY_CHAIN_NO_ROOT: SIGNER_CERT_POLICY = SIGNER_CERT_POLICY(8u32);
pub const SIGNER_CERT_POLICY_SPC: SIGNER_CERT_POLICY = SIGNER_CERT_POLICY(4u32);
pub const SIGNER_CERT_POLICY_STORE: SIGNER_CERT_POLICY = SIGNER_CERT_POLICY(1u32);
pub const SIGNER_CERT_SPC_CHAIN: SIGNER_CERT_CHOICE = SIGNER_CERT_CHOICE(3u32);
pub const SIGNER_CERT_SPC_FILE: SIGNER_CERT_CHOICE = SIGNER_CERT_CHOICE(1u32);
pub const SIGNER_CERT_STORE: SIGNER_CERT_CHOICE = SIGNER_CERT_CHOICE(2u32);
pub const SIGNER_NO_ATTR: SIGNER_SIGNATURE_ATTRIBUTE_CHOICE = SIGNER_SIGNATURE_ATTRIBUTE_CHOICE(0u32);
pub const SIGNER_SUBJECT_BLOB: SIGNER_SUBJECT_CHOICE = SIGNER_SUBJECT_CHOICE(2u32);
pub const SIGNER_SUBJECT_FILE: SIGNER_SUBJECT_CHOICE = SIGNER_SUBJECT_CHOICE(1u32);
pub const SIGNER_TIMESTAMP_AUTHENTICODE: SIGNER_TIMESTAMP_FLAGS = SIGNER_TIMESTAMP_FLAGS(1u32);
pub const SIGNER_TIMESTAMP_RFC3161: SIGNER_TIMESTAMP_FLAGS = SIGNER_TIMESTAMP_FLAGS(2u32);
pub const SIG_APPEND: SIGNER_SIGN_FLAGS = SIGNER_SIGN_FLAGS(4096u32);
pub const SIMPLEBLOB: u32 = 1u32;
pub const SITE_PIN_RULES_ALL_SUBDOMAINS_FLAG: u32 = 1u32;
pub const SORTED_CTL_EXT_HASHED_SUBJECT_IDENTIFIER_FLAG: u32 = 1u32;
pub const SPC_DIGEST_GENERATE_FLAG: SIGNER_SIGN_FLAGS = SIGNER_SIGN_FLAGS(512u32);
pub const SPC_DIGEST_SIGN_EX_FLAG: SIGNER_SIGN_FLAGS = SIGNER_SIGN_FLAGS(16384u32);
pub const SPC_DIGEST_SIGN_FLAG: SIGNER_SIGN_FLAGS = SIGNER_SIGN_FLAGS(1024u32);
pub const SPC_EXC_PE_PAGE_HASHES_FLAG: SIGNER_SIGN_FLAGS = SIGNER_SIGN_FLAGS(16u32);
pub const SPC_INC_PE_DEBUG_INFO_FLAG: SIGNER_SIGN_FLAGS = SIGNER_SIGN_FLAGS(64u32);
pub const SPC_INC_PE_IMPORT_ADDR_TABLE_FLAG: SIGNER_SIGN_FLAGS = SIGNER_SIGN_FLAGS(32u32);
pub const SPC_INC_PE_PAGE_HASHES_FLAG: SIGNER_SIGN_FLAGS = SIGNER_SIGN_FLAGS(256u32);
pub const SPC_INC_PE_RESOURCES_FLAG: SIGNER_SIGN_FLAGS = SIGNER_SIGN_FLAGS(128u32);
pub const SSL_ECCPUBLIC_BLOB: windows_core::PCWSTR = windows_core::w!("SSLECCPUBLICBLOB");
pub const SSL_F12_ERROR_TEXT_LENGTH: u32 = 256u32;
pub const SSL_HPKP_HEADER_COUNT: u32 = 2u32;
pub const SSL_HPKP_PKP_HEADER_INDEX: u32 = 0u32;
pub const SSL_HPKP_PKP_RO_HEADER_INDEX: u32 = 1u32;
pub const SSL_KEY_PIN_ERROR_TEXT_LENGTH: u32 = 512u32;
pub const SSL_OBJECT_LOCATOR_CERT_VALIDATION_CONFIG_FUNC: windows_core::PCSTR = windows_core::s!("SslObjectLocatorInitializeCertValidationConfig");
pub const SSL_OBJECT_LOCATOR_ISSUER_LIST_FUNC: windows_core::PCSTR = windows_core::s!("SslObjectLocatorInitializeIssuerList");
pub const SSL_OBJECT_LOCATOR_PFX_FUNC: windows_core::PCSTR = windows_core::s!("SslObjectLocatorInitializePfx");
pub const SYMMETRICWRAPKEYBLOB: u32 = 11u32;
pub const TIMESTAMP_DONT_HASH_DATA: u32 = 1u32;
pub const TIMESTAMP_FAILURE_BAD_ALG: u32 = 0u32;
pub const TIMESTAMP_FAILURE_BAD_FORMAT: u32 = 5u32;
pub const TIMESTAMP_FAILURE_BAD_REQUEST: u32 = 2u32;
pub const TIMESTAMP_FAILURE_EXTENSION_NOT_SUPPORTED: u32 = 16u32;
pub const TIMESTAMP_FAILURE_INFO_NOT_AVAILABLE: u32 = 17u32;
pub const TIMESTAMP_FAILURE_POLICY_NOT_SUPPORTED: u32 = 15u32;
pub const TIMESTAMP_FAILURE_SYSTEM_FAILURE: u32 = 25u32;
pub const TIMESTAMP_FAILURE_TIME_NOT_AVAILABLE: u32 = 14u32;
pub const TIMESTAMP_INFO: windows_core::PCSTR = windows_core::PCSTR(80i32 as _);
pub const TIMESTAMP_NO_AUTH_RETRIEVAL: u32 = 131072u32;
pub const TIMESTAMP_REQUEST: windows_core::PCSTR = windows_core::PCSTR(78i32 as _);
pub const TIMESTAMP_RESPONSE: windows_core::PCSTR = windows_core::PCSTR(79i32 as _);
pub const TIMESTAMP_STATUS_GRANTED: CRYPT_TIMESTAMP_RESPONSE_STATUS = CRYPT_TIMESTAMP_RESPONSE_STATUS(0u32);
pub const TIMESTAMP_STATUS_GRANTED_WITH_MODS: CRYPT_TIMESTAMP_RESPONSE_STATUS = CRYPT_TIMESTAMP_RESPONSE_STATUS(1u32);
pub const TIMESTAMP_STATUS_REJECTED: CRYPT_TIMESTAMP_RESPONSE_STATUS = CRYPT_TIMESTAMP_RESPONSE_STATUS(2u32);
pub const TIMESTAMP_STATUS_REVOCATION_WARNING: CRYPT_TIMESTAMP_RESPONSE_STATUS = CRYPT_TIMESTAMP_RESPONSE_STATUS(4u32);
pub const TIMESTAMP_STATUS_REVOKED: CRYPT_TIMESTAMP_RESPONSE_STATUS = CRYPT_TIMESTAMP_RESPONSE_STATUS(5u32);
pub const TIMESTAMP_STATUS_WAITING: CRYPT_TIMESTAMP_RESPONSE_STATUS = CRYPT_TIMESTAMP_RESPONSE_STATUS(3u32);
pub const TIMESTAMP_VERIFY_CONTEXT_SIGNATURE: u32 = 32u32;
pub const TIMESTAMP_VERSION: CRYPT_TIMESTAMP_VERSION = CRYPT_TIMESTAMP_VERSION(1u32);
pub const TIME_VALID_OID_FLUSH_CRL: windows_core::PCSTR = windows_core::PCSTR(2i32 as _);
pub const TIME_VALID_OID_FLUSH_CRL_FROM_CERT: windows_core::PCSTR = windows_core::PCSTR(3i32 as _);
pub const TIME_VALID_OID_FLUSH_CTL: windows_core::PCSTR = windows_core::PCSTR(1i32 as _);
pub const TIME_VALID_OID_FLUSH_FRESHEST_CRL_FROM_CERT: windows_core::PCSTR = windows_core::PCSTR(4i32 as _);
pub const TIME_VALID_OID_FLUSH_FRESHEST_CRL_FROM_CRL: windows_core::PCSTR = windows_core::PCSTR(5i32 as _);
pub const TIME_VALID_OID_FLUSH_OBJECT_FUNC: windows_core::PCSTR = windows_core::s!("TimeValidDllFlushObject");
pub const TIME_VALID_OID_GET_CRL: windows_core::PCSTR = windows_core::PCSTR(2i32 as _);
pub const TIME_VALID_OID_GET_CRL_FROM_CERT: windows_core::PCSTR = windows_core::PCSTR(3i32 as _);
pub const TIME_VALID_OID_GET_CTL: windows_core::PCSTR = windows_core::PCSTR(1i32 as _);
pub const TIME_VALID_OID_GET_FRESHEST_CRL_FROM_CERT: windows_core::PCSTR = windows_core::PCSTR(4i32 as _);
pub const TIME_VALID_OID_GET_FRESHEST_CRL_FROM_CRL: windows_core::PCSTR = windows_core::PCSTR(5i32 as _);
pub const TIME_VALID_OID_GET_OBJECT_FUNC: windows_core::PCSTR = windows_core::s!("TimeValidDllGetObject");
pub const TPM_RSA_SRK_SEAL_KEY: windows_core::PCWSTR = windows_core::w!("MICROSOFT_PCP_KSP_RSA_SEAL_KEY_3BD1C4BF-004E-4E2F-8A4D-0BF633DCB074");
pub const URL_OID_CERTIFICATE_CRL_DIST_POINT: windows_core::PCSTR = windows_core::PCSTR(2i32 as _);
pub const URL_OID_CERTIFICATE_CRL_DIST_POINT_AND_OCSP: windows_core::PCSTR = windows_core::PCSTR(11i32 as _);
pub const URL_OID_CERTIFICATE_FRESHEST_CRL: windows_core::PCSTR = windows_core::PCSTR(6i32 as _);
pub const URL_OID_CERTIFICATE_ISSUER: windows_core::PCSTR = windows_core::PCSTR(1i32 as _);
pub const URL_OID_CERTIFICATE_OCSP: windows_core::PCSTR = windows_core::PCSTR(9i32 as _);
pub const URL_OID_CERTIFICATE_OCSP_AND_CRL_DIST_POINT: windows_core::PCSTR = windows_core::PCSTR(10i32 as _);
pub const URL_OID_CERTIFICATE_ONLY_OCSP: windows_core::PCSTR = windows_core::PCSTR(13i32 as _);
pub const URL_OID_CRL_FRESHEST_CRL: windows_core::PCSTR = windows_core::PCSTR(7i32 as _);
pub const URL_OID_CRL_ISSUER: windows_core::PCSTR = windows_core::PCSTR(5i32 as _);
pub const URL_OID_CROSS_CERT_DIST_POINT: windows_core::PCSTR = windows_core::PCSTR(8i32 as _);
pub const URL_OID_CROSS_CERT_SUBJECT_INFO_ACCESS: windows_core::PCSTR = windows_core::PCSTR(12i32 as _);
pub const URL_OID_CTL_ISSUER: windows_core::PCSTR = windows_core::PCSTR(3i32 as _);
pub const URL_OID_CTL_NEXT_UPDATE: windows_core::PCSTR = windows_core::PCSTR(4i32 as _);
pub const URL_OID_GET_OBJECT_URL_FUNC: windows_core::PCSTR = windows_core::s!("UrlDllGetObjectUrl");
pub const USAGE_MATCH_TYPE_AND: u32 = 0u32;
pub const USAGE_MATCH_TYPE_OR: u32 = 1u32;
pub const X509_ALGORITHM_IDENTIFIER: windows_core::PCSTR = windows_core::PCSTR(74i32 as _);
pub const X509_ALTERNATE_NAME: windows_core::PCSTR = windows_core::PCSTR(12i32 as _);
pub const X509_ANY_STRING: i32 = 6i32;
pub const X509_ASN_ENCODING: CERT_QUERY_ENCODING_TYPE = CERT_QUERY_ENCODING_TYPE(1u32);
pub const X509_AUTHORITY_INFO_ACCESS: windows_core::PCSTR = windows_core::PCSTR(32i32 as _);
pub const X509_AUTHORITY_KEY_ID: windows_core::PCSTR = windows_core::PCSTR(9i32 as _);
pub const X509_AUTHORITY_KEY_ID2: windows_core::PCSTR = windows_core::PCSTR(31i32 as _);
pub const X509_BASIC_CONSTRAINTS: windows_core::PCSTR = windows_core::PCSTR(13i32 as _);
pub const X509_BASIC_CONSTRAINTS2: windows_core::PCSTR = windows_core::PCSTR(15i32 as _);
pub const X509_BIOMETRIC_EXT: windows_core::PCSTR = windows_core::PCSTR(71i32 as _);
pub const X509_BITS: windows_core::PCSTR = windows_core::PCSTR(26i32 as _);
pub const X509_BITS_WITHOUT_TRAILING_ZEROES: windows_core::PCSTR = windows_core::PCSTR(51i32 as _);
pub const X509_CERT: windows_core::PCSTR = windows_core::PCSTR(1i32 as _);
pub const X509_CERTIFICATE_TEMPLATE: windows_core::PCSTR = windows_core::PCSTR(64i32 as _);
pub const X509_CERT_BUNDLE: windows_core::PCSTR = windows_core::PCSTR(81i32 as _);
pub const X509_CERT_CRL_TO_BE_SIGNED: windows_core::PCSTR = windows_core::PCSTR(3i32 as _);
pub const X509_CERT_PAIR: windows_core::PCSTR = windows_core::PCSTR(53i32 as _);
pub const X509_CERT_POLICIES: windows_core::PCSTR = windows_core::PCSTR(16i32 as _);
pub const X509_CERT_REQUEST_TO_BE_SIGNED: windows_core::PCSTR = windows_core::PCSTR(4i32 as _);
pub const X509_CERT_TO_BE_SIGNED: windows_core::PCSTR = windows_core::PCSTR(2i32 as _);
pub const X509_CHOICE_OF_TIME: windows_core::PCSTR = windows_core::PCSTR(30i32 as _);
pub const X509_CRL_DIST_POINTS: windows_core::PCSTR = windows_core::PCSTR(35i32 as _);
pub const X509_CRL_REASON_CODE: i32 = 29i32;
pub const X509_CROSS_CERT_DIST_POINTS: windows_core::PCSTR = windows_core::PCSTR(58i32 as _);
pub const X509_DH_PARAMETERS: windows_core::PCSTR = windows_core::PCSTR(47i32 as _);
pub const X509_DH_PUBLICKEY: i32 = 38i32;
pub const X509_DSS_PARAMETERS: windows_core::PCSTR = windows_core::PCSTR(39i32 as _);
pub const X509_DSS_PUBLICKEY: i32 = 38i32;
pub const X509_DSS_SIGNATURE: windows_core::PCSTR = windows_core::PCSTR(40i32 as _);
pub const X509_ECC_PARAMETERS: windows_core::PCSTR = windows_core::PCSTR(85i32 as _);
pub const X509_ECC_PRIVATE_KEY: windows_core::PCSTR = windows_core::PCSTR(82i32 as _);
pub const X509_ECC_SIGNATURE: windows_core::PCSTR = windows_core::PCSTR(47i32 as _);
pub const X509_ENHANCED_KEY_USAGE: windows_core::PCSTR = windows_core::PCSTR(36i32 as _);
pub const X509_ENUMERATED: windows_core::PCSTR = windows_core::PCSTR(29i32 as _);
pub const X509_EXTENSIONS: windows_core::PCSTR = windows_core::PCSTR(5i32 as _);
pub const X509_INTEGER: windows_core::PCSTR = windows_core::PCSTR(27i32 as _);
pub const X509_ISSUING_DIST_POINT: windows_core::PCSTR = windows_core::PCSTR(54i32 as _);
pub const X509_KEYGEN_REQUEST_TO_BE_SIGNED: windows_core::PCSTR = windows_core::PCSTR(21i32 as _);
pub const X509_KEY_ATTRIBUTES: windows_core::PCSTR = windows_core::PCSTR(10i32 as _);
pub const X509_KEY_USAGE: windows_core::PCSTR = windows_core::PCSTR(14i32 as _);
pub const X509_KEY_USAGE_RESTRICTION: windows_core::PCSTR = windows_core::PCSTR(11i32 as _);
pub const X509_LOGOTYPE_EXT: windows_core::PCSTR = windows_core::PCSTR(70i32 as _);
pub const X509_MULTI_BYTE_INTEGER: windows_core::PCSTR = windows_core::PCSTR(28i32 as _);
pub const X509_MULTI_BYTE_UINT: windows_core::PCSTR = windows_core::PCSTR(38i32 as _);
pub const X509_NAME: windows_core::PCSTR = windows_core::PCSTR(7i32 as _);
pub const X509_NAME_CONSTRAINTS: windows_core::PCSTR = windows_core::PCSTR(55i32 as _);
pub const X509_NAME_VALUE: windows_core::PCSTR = windows_core::PCSTR(6i32 as _);
pub const X509_NDR_ENCODING: u32 = 2u32;
pub const X509_OBJECT_IDENTIFIER: windows_core::PCSTR = windows_core::PCSTR(73i32 as _);
pub const X509_OCTET_STRING: windows_core::PCSTR = windows_core::PCSTR(25i32 as _);
pub const X509_PKIX_POLICY_QUALIFIER_USERNOTICE: windows_core::PCSTR = windows_core::PCSTR(46i32 as _);
pub const X509_POLICY_CONSTRAINTS: windows_core::PCSTR = windows_core::PCSTR(57i32 as _);
pub const X509_POLICY_MAPPINGS: windows_core::PCSTR = windows_core::PCSTR(56i32 as _);
pub const X509_PUBLIC_KEY_INFO: windows_core::PCSTR = windows_core::PCSTR(8i32 as _);
pub const X509_QC_STATEMENTS_EXT: windows_core::PCSTR = windows_core::PCSTR(42i32 as _);
pub const X509_SEQUENCE_OF_ANY: windows_core::PCSTR = windows_core::PCSTR(34i32 as _);
pub const X509_SUBJECT_DIR_ATTRS: windows_core::PCSTR = windows_core::PCSTR(84i32 as _);
pub const X509_SUBJECT_INFO_ACCESS: i32 = 32i32;
pub const X509_UNICODE_ANY_STRING: i32 = 24i32;
pub const X509_UNICODE_NAME: windows_core::PCSTR = windows_core::PCSTR(20i32 as _);
pub const X509_UNICODE_NAME_VALUE: windows_core::PCSTR = windows_core::PCSTR(24i32 as _);
pub const X942_DH_PARAMETERS: windows_core::PCSTR = windows_core::PCSTR(50i32 as _);
pub const X942_OTHER_INFO: windows_core::PCSTR = windows_core::PCSTR(52i32 as _);
pub const ZERO_PADDING: u32 = 3u32;
pub const cPRIV_KEY_CACHE_MAX_ITEMS_DEFAULT: u32 = 20u32;
pub const cPRIV_KEY_CACHE_PURGE_INTERVAL_SECONDS_DEFAULT: u32 = 86400u32;
pub const dwFORCE_KEY_PROTECTION_DISABLED: u32 = 0u32;
pub const dwFORCE_KEY_PROTECTION_HIGH: u32 = 2u32;
pub const dwFORCE_KEY_PROTECTION_USER_SELECT: u32 = 1u32;
pub const szFORCE_KEY_PROTECTION: windows_core::PCSTR = windows_core::s!("ForceKeyProtection");
pub const szKEY_CACHE_ENABLED: windows_core::PCSTR = windows_core::s!("CachePrivateKeys");
pub const szKEY_CACHE_SECONDS: windows_core::PCSTR = windows_core::s!("PrivateKeyLifetimeSeconds");
pub const szKEY_CRYPTOAPI_PRIVATE_KEY_OPTIONS: windows_core::PCSTR = windows_core::s!("Software\\Policies\\Microsoft\\Cryptography");
pub const szOIDVerisign_FailInfo: windows_core::PCSTR = windows_core::s!("2.16.840.1.113733.1.9.4");
pub const szOIDVerisign_MessageType: windows_core::PCSTR = windows_core::s!("2.16.840.1.113733.1.9.2");
pub const szOIDVerisign_PkiStatus: windows_core::PCSTR = windows_core::s!("2.16.840.1.113733.1.9.3");
pub const szOIDVerisign_RecipientNonce: windows_core::PCSTR = windows_core::s!("2.16.840.1.113733.1.9.6");
pub const szOIDVerisign_SenderNonce: windows_core::PCSTR = windows_core::s!("2.16.840.1.113733.1.9.5");
pub const szOIDVerisign_TransactionID: windows_core::PCSTR = windows_core::s!("2.16.840.1.113733.1.9.7");
pub const szOID_ANSI_X942: windows_core::PCSTR = windows_core::s!("1.2.840.10046");
pub const szOID_ANSI_X942_DH: windows_core::PCSTR = windows_core::s!("1.2.840.10046.2.1");
pub const szOID_ANY_APPLICATION_POLICY: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.12.1");
pub const szOID_ANY_CERT_POLICY: windows_core::PCSTR = windows_core::s!("2.5.29.32.0");
pub const szOID_ANY_ENHANCED_KEY_USAGE: windows_core::PCSTR = windows_core::s!("2.5.29.37.0");
pub const szOID_APPLICATION_CERT_POLICIES: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.21.10");
pub const szOID_APPLICATION_POLICY_CONSTRAINTS: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.21.12");
pub const szOID_APPLICATION_POLICY_MAPPINGS: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.21.11");
pub const szOID_ARCHIVED_KEY_ATTR: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.21.13");
pub const szOID_ARCHIVED_KEY_CERT_HASH: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.21.16");
pub const szOID_ATTEST_WHQL_CRYPTO: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.3.5.1");
pub const szOID_ATTR_PLATFORM_SPECIFICATION: windows_core::PCSTR = windows_core::s!("2.23.133.2.17");
pub const szOID_ATTR_SUPPORTED_ALGORITHMS: windows_core::PCSTR = windows_core::s!("2.5.4.52");
pub const szOID_ATTR_TPM_SECURITY_ASSERTIONS: windows_core::PCSTR = windows_core::s!("2.23.133.2.18");
pub const szOID_ATTR_TPM_SPECIFICATION: windows_core::PCSTR = windows_core::s!("2.23.133.2.16");
pub const szOID_AUTHORITY_INFO_ACCESS: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.1.1");
pub const szOID_AUTHORITY_KEY_IDENTIFIER: windows_core::PCSTR = windows_core::s!("2.5.29.1");
pub const szOID_AUTHORITY_KEY_IDENTIFIER2: windows_core::PCSTR = windows_core::s!("2.5.29.35");
pub const szOID_AUTHORITY_REVOCATION_LIST: windows_core::PCSTR = windows_core::s!("2.5.4.38");
pub const szOID_AUTO_ENROLL_CTL_USAGE: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.20.1");
pub const szOID_BACKGROUND_OTHER_LOGOTYPE: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.20.2");
pub const szOID_BASIC_CONSTRAINTS: windows_core::PCSTR = windows_core::s!("2.5.29.10");
pub const szOID_BASIC_CONSTRAINTS2: windows_core::PCSTR = windows_core::s!("2.5.29.19");
pub const szOID_BIOMETRIC_EXT: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.1.2");
pub const szOID_BIOMETRIC_SIGNING: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.3.41");
pub const szOID_BUSINESS_CATEGORY: windows_core::PCSTR = windows_core::s!("2.5.4.15");
pub const szOID_CA_CERTIFICATE: windows_core::PCSTR = windows_core::s!("2.5.4.37");
pub const szOID_CERTIFICATE_REVOCATION_LIST: windows_core::PCSTR = windows_core::s!("2.5.4.39");
pub const szOID_CERTIFICATE_TEMPLATE: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.21.7");
pub const szOID_CERTSRV_CA_VERSION: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.21.1");
pub const szOID_CERTSRV_CROSSCA_VERSION: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.21.22");
pub const szOID_CERTSRV_PREVIOUS_CERT_HASH: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.21.2");
pub const szOID_CERT_DISALLOWED_CA_FILETIME_PROP_ID: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.11.128");
pub const szOID_CERT_DISALLOWED_FILETIME_PROP_ID: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.11.104");
pub const szOID_CERT_EXTENSIONS: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.2.1.14");
pub const szOID_CERT_ISSUER_SERIAL_NUMBER_MD5_HASH_PROP_ID: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.11.28");
pub const szOID_CERT_KEY_IDENTIFIER_PROP_ID: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.11.20");
pub const szOID_CERT_MANIFOLD: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.20.3");
pub const szOID_CERT_MD5_HASH_PROP_ID: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.11.4");
pub const szOID_CERT_POLICIES: windows_core::PCSTR = windows_core::s!("2.5.29.32");
pub const szOID_CERT_POLICIES_95: windows_core::PCSTR = windows_core::s!("2.5.29.3");
pub const szOID_CERT_POLICIES_95_QUALIFIER1: windows_core::PCSTR = windows_core::s!("2.16.840.1.113733.1.7.1.1");
pub const szOID_CERT_PROP_ID_PREFIX: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.11.");
pub const szOID_CERT_SIGNATURE_HASH_PROP_ID: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.11.15");
pub const szOID_CERT_STRONG_KEY_OS_1: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.72.2.1");
pub const szOID_CERT_STRONG_KEY_OS_CURRENT: windows_core::PCWSTR = windows_core::w!("1.3.6.1.4.1.311.72.2.1");
pub const szOID_CERT_STRONG_KEY_OS_PREFIX: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.72.2.");
pub const szOID_CERT_STRONG_SIGN_OS_1: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.72.1.1");
pub const szOID_CERT_STRONG_SIGN_OS_CURRENT: windows_core::PCWSTR = windows_core::w!("1.3.6.1.4.1.311.72.1.1");
pub const szOID_CERT_STRONG_SIGN_OS_PREFIX: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.72.1.");
pub const szOID_CERT_SUBJECT_NAME_MD5_HASH_PROP_ID: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.11.29");
pub const szOID_CMC: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.7");
pub const szOID_CMC_ADD_ATTRIBUTES: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.10.1");
pub const szOID_CMC_ADD_EXTENSIONS: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.7.8");
pub const szOID_CMC_DATA_RETURN: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.7.4");
pub const szOID_CMC_DECRYPTED_POP: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.7.10");
pub const szOID_CMC_ENCRYPTED_POP: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.7.9");
pub const szOID_CMC_GET_CERT: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.7.15");
pub const szOID_CMC_GET_CRL: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.7.16");
pub const szOID_CMC_IDENTIFICATION: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.7.2");
pub const szOID_CMC_IDENTITY_PROOF: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.7.3");
pub const szOID_CMC_ID_CONFIRM_CERT_ACCEPTANCE: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.7.24");
pub const szOID_CMC_ID_POP_LINK_RANDOM: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.7.22");
pub const szOID_CMC_ID_POP_LINK_WITNESS: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.7.23");
pub const szOID_CMC_LRA_POP_WITNESS: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.7.11");
pub const szOID_CMC_QUERY_PENDING: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.7.21");
pub const szOID_CMC_RECIPIENT_NONCE: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.7.7");
pub const szOID_CMC_REG_INFO: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.7.18");
pub const szOID_CMC_RESPONSE_INFO: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.7.19");
pub const szOID_CMC_REVOKE_REQUEST: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.7.17");
pub const szOID_CMC_SENDER_NONCE: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.7.6");
pub const szOID_CMC_STATUS_INFO: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.7.1");
pub const szOID_CMC_TRANSACTION_ID: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.7.5");
pub const szOID_CN_ECDSA_SHA256: windows_core::PCSTR = windows_core::s!("1.2.156.11235.1.1.1");
pub const szOID_COMMON_NAME: windows_core::PCSTR = windows_core::s!("2.5.4.3");
pub const szOID_COUNTRY_NAME: windows_core::PCSTR = windows_core::s!("2.5.4.6");
pub const szOID_CRL_DIST_POINTS: windows_core::PCSTR = windows_core::s!("2.5.29.31");
pub const szOID_CRL_NEXT_PUBLISH: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.21.4");
pub const szOID_CRL_NUMBER: windows_core::PCSTR = windows_core::s!("2.5.29.20");
pub const szOID_CRL_REASON_CODE: windows_core::PCSTR = windows_core::s!("2.5.29.21");
pub const szOID_CRL_SELF_CDP: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.21.14");
pub const szOID_CRL_VIRTUAL_BASE: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.21.3");
pub const szOID_CROSS_CERTIFICATE_PAIR: windows_core::PCSTR = windows_core::s!("2.5.4.40");
pub const szOID_CROSS_CERT_DIST_POINTS: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.9.1");
pub const szOID_CTL: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.1");
pub const szOID_CT_CERT_SCTLIST: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.11129.2.4.2");
pub const szOID_CT_PKI_DATA: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.12.2");
pub const szOID_CT_PKI_RESPONSE: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.12.3");
pub const szOID_DELTA_CRL_INDICATOR: windows_core::PCSTR = windows_core::s!("2.5.29.27");
pub const szOID_DESCRIPTION: windows_core::PCSTR = windows_core::s!("2.5.4.13");
pub const szOID_DESTINATION_INDICATOR: windows_core::PCSTR = windows_core::s!("2.5.4.27");
pub const szOID_DEVICE_SERIAL_NUMBER: windows_core::PCSTR = windows_core::s!("2.5.4.5");
pub const szOID_DH_SINGLE_PASS_STDDH_SHA1_KDF: windows_core::PCSTR = windows_core::s!("1.3.133.16.840.63.0.2");
pub const szOID_DH_SINGLE_PASS_STDDH_SHA256_KDF: windows_core::PCSTR = windows_core::s!("1.3.132.1.11.1");
pub const szOID_DH_SINGLE_PASS_STDDH_SHA384_KDF: windows_core::PCSTR = windows_core::s!("1.3.132.1.11.2");
pub const szOID_DISALLOWED_HASH: windows_core::PCWSTR = windows_core::w!("1.3.6.1.4.1.311.10.11.15");
pub const szOID_DISALLOWED_LIST: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.3.30");
pub const szOID_DN_QUALIFIER: windows_core::PCSTR = windows_core::s!("2.5.4.46");
pub const szOID_DOMAIN_COMPONENT: windows_core::PCSTR = windows_core::s!("0.9.2342.19200300.100.1.25");
pub const szOID_DRM: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.5.1");
pub const szOID_DRM_INDIVIDUALIZATION: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.5.2");
pub const szOID_DS: windows_core::PCSTR = windows_core::s!("2.5");
pub const szOID_DSALG: windows_core::PCSTR = windows_core::s!("2.5.8");
pub const szOID_DSALG_CRPT: windows_core::PCSTR = windows_core::s!("2.5.8.1");
pub const szOID_DSALG_HASH: windows_core::PCSTR = windows_core::s!("2.5.8.2");
pub const szOID_DSALG_RSA: windows_core::PCSTR = windows_core::s!("2.5.8.1.1");
pub const szOID_DSALG_SIGN: windows_core::PCSTR = windows_core::s!("2.5.8.3");
pub const szOID_DS_EMAIL_REPLICATION: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.21.19");
pub const szOID_DYNAMIC_CODE_GEN_SIGNER: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.76.5.1");
pub const szOID_ECC_CURVE_BRAINPOOLP160R1: windows_core::PCSTR = windows_core::s!("1.3.36.3.3.2.8.1.1.1");
pub const szOID_ECC_CURVE_BRAINPOOLP160T1: windows_core::PCSTR = windows_core::s!("1.3.36.3.3.2.8.1.1.2");
pub const szOID_ECC_CURVE_BRAINPOOLP192R1: windows_core::PCSTR = windows_core::s!("1.3.36.3.3.2.8.1.1.3");
pub const szOID_ECC_CURVE_BRAINPOOLP192T1: windows_core::PCSTR = windows_core::s!("1.3.36.3.3.2.8.1.1.4");
pub const szOID_ECC_CURVE_BRAINPOOLP224R1: windows_core::PCSTR = windows_core::s!("1.3.36.3.3.2.8.1.1.5");
pub const szOID_ECC_CURVE_BRAINPOOLP224T1: windows_core::PCSTR = windows_core::s!("1.3.36.3.3.2.8.1.1.6");
pub const szOID_ECC_CURVE_BRAINPOOLP256R1: windows_core::PCSTR = windows_core::s!("1.3.36.3.3.2.8.1.1.7");
pub const szOID_ECC_CURVE_BRAINPOOLP256T1: windows_core::PCSTR = windows_core::s!("1.3.36.3.3.2.8.1.1.8");
pub const szOID_ECC_CURVE_BRAINPOOLP320R1: windows_core::PCSTR = windows_core::s!("1.3.36.3.3.2.8.1.1.9");
pub const szOID_ECC_CURVE_BRAINPOOLP320T1: windows_core::PCSTR = windows_core::s!("1.3.36.3.3.2.8.1.1.10");
pub const szOID_ECC_CURVE_BRAINPOOLP384R1: windows_core::PCSTR = windows_core::s!("1.3.36.3.3.2.8.1.1.11");
pub const szOID_ECC_CURVE_BRAINPOOLP384T1: windows_core::PCSTR = windows_core::s!("1.3.36.3.3.2.8.1.1.12");
pub const szOID_ECC_CURVE_BRAINPOOLP512R1: windows_core::PCSTR = windows_core::s!("1.3.36.3.3.2.8.1.1.13");
pub const szOID_ECC_CURVE_BRAINPOOLP512T1: windows_core::PCSTR = windows_core::s!("1.3.36.3.3.2.8.1.1.14");
pub const szOID_ECC_CURVE_EC192WAPI: windows_core::PCSTR = windows_core::s!("1.2.156.11235.1.1.2.1");
pub const szOID_ECC_CURVE_NISTP192: windows_core::PCSTR = windows_core::s!("1.2.840.10045.3.1.1");
pub const szOID_ECC_CURVE_NISTP224: windows_core::PCSTR = windows_core::s!("1.3.132.0.33");
pub const szOID_ECC_CURVE_NISTP256: windows_core::PCWSTR = windows_core::w!("1.2.840.10045.3.1.7");
pub const szOID_ECC_CURVE_NISTP384: windows_core::PCWSTR = windows_core::w!("1.3.132.0.34");
pub const szOID_ECC_CURVE_NISTP521: windows_core::PCWSTR = windows_core::w!("1.3.132.0.35");
pub const szOID_ECC_CURVE_P256: windows_core::PCSTR = windows_core::s!("1.2.840.10045.3.1.7");
pub const szOID_ECC_CURVE_P384: windows_core::PCSTR = windows_core::s!("1.3.132.0.34");
pub const szOID_ECC_CURVE_P521: windows_core::PCSTR = windows_core::s!("1.3.132.0.35");
pub const szOID_ECC_CURVE_SECP160K1: windows_core::PCSTR = windows_core::s!("1.3.132.0.9");
pub const szOID_ECC_CURVE_SECP160R1: windows_core::PCSTR = windows_core::s!("1.3.132.0.8");
pub const szOID_ECC_CURVE_SECP160R2: windows_core::PCSTR = windows_core::s!("1.3.132.0.30");
pub const szOID_ECC_CURVE_SECP192K1: windows_core::PCSTR = windows_core::s!("1.3.132.0.31");
pub const szOID_ECC_CURVE_SECP192R1: windows_core::PCWSTR = windows_core::w!("1.2.840.10045.3.1.1");
pub const szOID_ECC_CURVE_SECP224K1: windows_core::PCSTR = windows_core::s!("1.3.132.0.32");
pub const szOID_ECC_CURVE_SECP224R1: windows_core::PCWSTR = windows_core::w!("1.3.132.0.33");
pub const szOID_ECC_CURVE_SECP256K1: windows_core::PCSTR = windows_core::s!("1.3.132.0.10");
pub const szOID_ECC_CURVE_SECP256R1: windows_core::PCWSTR = windows_core::w!("1.2.840.10045.3.1.7");
pub const szOID_ECC_CURVE_SECP384R1: windows_core::PCWSTR = windows_core::w!("1.3.132.0.34");
pub const szOID_ECC_CURVE_SECP521R1: windows_core::PCWSTR = windows_core::w!("1.3.132.0.35");
pub const szOID_ECC_CURVE_WTLS12: windows_core::PCWSTR = windows_core::w!("1.3.132.0.33");
pub const szOID_ECC_CURVE_WTLS7: windows_core::PCWSTR = windows_core::w!("1.3.132.0.30");
pub const szOID_ECC_CURVE_WTLS9: windows_core::PCSTR = windows_core::s!("2.23.43.1.4.9");
pub const szOID_ECC_CURVE_X962P192V1: windows_core::PCSTR = windows_core::s!("1.2.840.10045.3.1.1");
pub const szOID_ECC_CURVE_X962P192V2: windows_core::PCSTR = windows_core::s!("1.2.840.10045.3.1.2");
pub const szOID_ECC_CURVE_X962P192V3: windows_core::PCSTR = windows_core::s!("1.2.840.10045.3.1.3");
pub const szOID_ECC_CURVE_X962P239V1: windows_core::PCSTR = windows_core::s!("1.2.840.10045.3.1.4");
pub const szOID_ECC_CURVE_X962P239V2: windows_core::PCSTR = windows_core::s!("1.2.840.10045.3.1.5");
pub const szOID_ECC_CURVE_X962P239V3: windows_core::PCSTR = windows_core::s!("1.2.840.10045.3.1.6");
pub const szOID_ECC_CURVE_X962P256V1: windows_core::PCWSTR = windows_core::w!("1.2.840.10045.3.1.7");
pub const szOID_ECC_PUBLIC_KEY: windows_core::PCSTR = windows_core::s!("1.2.840.10045.2.1");
pub const szOID_ECDSA_SHA1: windows_core::PCSTR = windows_core::s!("1.2.840.10045.4.1");
pub const szOID_ECDSA_SHA256: windows_core::PCSTR = windows_core::s!("1.2.840.10045.4.3.2");
pub const szOID_ECDSA_SHA384: windows_core::PCSTR = windows_core::s!("1.2.840.10045.4.3.3");
pub const szOID_ECDSA_SHA512: windows_core::PCSTR = windows_core::s!("1.2.840.10045.4.3.4");
pub const szOID_ECDSA_SPECIFIED: windows_core::PCSTR = windows_core::s!("1.2.840.10045.4.3");
pub const szOID_EFS_RECOVERY: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.3.4.1");
pub const szOID_EMBEDDED_NT_CRYPTO: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.3.8");
pub const szOID_ENCLAVE_SIGNING: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.3.42");
pub const szOID_ENCRYPTED_KEY_HASH: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.21.21");
pub const szOID_ENHANCED_KEY_USAGE: windows_core::PCSTR = windows_core::s!("2.5.29.37");
pub const szOID_ENROLLMENT_AGENT: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.20.2.1");
pub const szOID_ENROLLMENT_CSP_PROVIDER: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.13.2.2");
pub const szOID_ENROLLMENT_NAME_VALUE_PAIR: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.13.2.1");
pub const szOID_ENROLL_AIK_INFO: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.21.39");
pub const szOID_ENROLL_ATTESTATION_CHALLENGE: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.21.28");
pub const szOID_ENROLL_ATTESTATION_STATEMENT: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.21.24");
pub const szOID_ENROLL_CAXCHGCERT_HASH: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.21.27");
pub const szOID_ENROLL_CERTTYPE_EXTENSION: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.20.2");
pub const szOID_ENROLL_EKPUB_CHALLENGE: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.21.26");
pub const szOID_ENROLL_EKVERIFYCERT: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.21.31");
pub const szOID_ENROLL_EKVERIFYCREDS: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.21.32");
pub const szOID_ENROLL_EKVERIFYKEY: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.21.30");
pub const szOID_ENROLL_EK_CA_KEYID: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.21.43");
pub const szOID_ENROLL_EK_INFO: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.21.23");
pub const szOID_ENROLL_ENCRYPTION_ALGORITHM: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.21.29");
pub const szOID_ENROLL_KEY_AFFINITY: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.21.41");
pub const szOID_ENROLL_KSP_NAME: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.21.25");
pub const szOID_ENROLL_SCEP_CHALLENGE_ANSWER: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.21.35");
pub const szOID_ENROLL_SCEP_CLIENT_REQUEST: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.21.37");
pub const szOID_ENROLL_SCEP_ERROR: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.21.33");
pub const szOID_ENROLL_SCEP_SERVER_MESSAGE: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.21.38");
pub const szOID_ENROLL_SCEP_SERVER_SECRET: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.21.40");
pub const szOID_ENROLL_SCEP_SERVER_STATE: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.21.34");
pub const szOID_ENROLL_SCEP_SIGNER_HASH: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.21.42");
pub const szOID_ENTERPRISE_OID_ROOT: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.21.8");
pub const szOID_EV_RDN_COUNTRY: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.60.2.1.3");
pub const szOID_EV_RDN_LOCALE: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.60.2.1.1");
pub const szOID_EV_RDN_STATE_OR_PROVINCE: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.60.2.1.2");
pub const szOID_EV_WHQL_CRYPTO: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.3.39");
pub const szOID_FACSIMILE_TELEPHONE_NUMBER: windows_core::PCSTR = windows_core::s!("2.5.4.23");
pub const szOID_FRESHEST_CRL: windows_core::PCSTR = windows_core::s!("2.5.29.46");
pub const szOID_GIVEN_NAME: windows_core::PCSTR = windows_core::s!("2.5.4.42");
pub const szOID_HPKP_DOMAIN_NAME_CTL: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.3.60");
pub const szOID_HPKP_HEADER_VALUE_CTL: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.3.61");
pub const szOID_INFOSEC: windows_core::PCSTR = windows_core::s!("2.16.840.1.101.2.1");
pub const szOID_INFOSEC_SuiteAConfidentiality: windows_core::PCSTR = windows_core::s!("2.16.840.1.101.2.1.1.14");
pub const szOID_INFOSEC_SuiteAIntegrity: windows_core::PCSTR = windows_core::s!("2.16.840.1.101.2.1.1.15");
pub const szOID_INFOSEC_SuiteAKMandSig: windows_core::PCSTR = windows_core::s!("2.16.840.1.101.2.1.1.18");
pub const szOID_INFOSEC_SuiteAKeyManagement: windows_core::PCSTR = windows_core::s!("2.16.840.1.101.2.1.1.17");
pub const szOID_INFOSEC_SuiteASignature: windows_core::PCSTR = windows_core::s!("2.16.840.1.101.2.1.1.13");
pub const szOID_INFOSEC_SuiteATokenProtection: windows_core::PCSTR = windows_core::s!("2.16.840.1.101.2.1.1.16");
pub const szOID_INFOSEC_mosaicConfidentiality: windows_core::PCSTR = windows_core::s!("2.16.840.1.101.2.1.1.4");
pub const szOID_INFOSEC_mosaicIntegrity: windows_core::PCSTR = windows_core::s!("2.16.840.1.101.2.1.1.6");
pub const szOID_INFOSEC_mosaicKMandSig: windows_core::PCSTR = windows_core::s!("2.16.840.1.101.2.1.1.12");
pub const szOID_INFOSEC_mosaicKMandUpdSig: windows_core::PCSTR = windows_core::s!("2.16.840.1.101.2.1.1.20");
pub const szOID_INFOSEC_mosaicKeyManagement: windows_core::PCSTR = windows_core::s!("2.16.840.1.101.2.1.1.10");
pub const szOID_INFOSEC_mosaicSignature: windows_core::PCSTR = windows_core::s!("2.16.840.1.101.2.1.1.2");
pub const szOID_INFOSEC_mosaicTokenProtection: windows_core::PCSTR = windows_core::s!("2.16.840.1.101.2.1.1.8");
pub const szOID_INFOSEC_mosaicUpdatedInteg: windows_core::PCSTR = windows_core::s!("2.16.840.1.101.2.1.1.21");
pub const szOID_INFOSEC_mosaicUpdatedSig: windows_core::PCSTR = windows_core::s!("2.16.840.1.101.2.1.1.19");
pub const szOID_INFOSEC_sdnsConfidentiality: windows_core::PCSTR = windows_core::s!("2.16.840.1.101.2.1.1.3");
pub const szOID_INFOSEC_sdnsIntegrity: windows_core::PCSTR = windows_core::s!("2.16.840.1.101.2.1.1.5");
pub const szOID_INFOSEC_sdnsKMandSig: windows_core::PCSTR = windows_core::s!("2.16.840.1.101.2.1.1.11");
pub const szOID_INFOSEC_sdnsKeyManagement: windows_core::PCSTR = windows_core::s!("2.16.840.1.101.2.1.1.9");
pub const szOID_INFOSEC_sdnsSignature: windows_core::PCSTR = windows_core::s!("2.16.840.1.101.2.1.1.1");
pub const szOID_INFOSEC_sdnsTokenProtection: windows_core::PCSTR = windows_core::s!("2.16.840.1.101.2.1.1.7");
pub const szOID_INHIBIT_ANY_POLICY: windows_core::PCSTR = windows_core::s!("2.5.29.54");
pub const szOID_INITIALS: windows_core::PCSTR = windows_core::s!("2.5.4.43");
pub const szOID_INTERNATIONALIZED_EMAIL_ADDRESS: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.20.2.4");
pub const szOID_INTERNATIONAL_ISDN_NUMBER: windows_core::PCSTR = windows_core::s!("2.5.4.25");
pub const szOID_IPSEC_KP_IKE_INTERMEDIATE: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.8.2.2");
pub const szOID_ISSUED_CERT_HASH: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.21.17");
pub const szOID_ISSUER_ALT_NAME: windows_core::PCSTR = windows_core::s!("2.5.29.8");
pub const szOID_ISSUER_ALT_NAME2: windows_core::PCSTR = windows_core::s!("2.5.29.18");
pub const szOID_ISSUING_DIST_POINT: windows_core::PCSTR = windows_core::s!("2.5.29.28");
pub const szOID_IUM_SIGNING: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.3.37");
pub const szOID_KEYID_RDN: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.7.1");
pub const szOID_KEY_ATTRIBUTES: windows_core::PCSTR = windows_core::s!("2.5.29.2");
pub const szOID_KEY_USAGE: windows_core::PCSTR = windows_core::s!("2.5.29.15");
pub const szOID_KEY_USAGE_RESTRICTION: windows_core::PCSTR = windows_core::s!("2.5.29.4");
pub const szOID_KP_CA_EXCHANGE: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.21.5");
pub const szOID_KP_CSP_SIGNATURE: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.3.16");
pub const szOID_KP_CTL_USAGE_SIGNING: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.3.1");
pub const szOID_KP_DOCUMENT_SIGNING: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.3.12");
pub const szOID_KP_EFS: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.3.4");
pub const szOID_KP_FLIGHT_SIGNING: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.3.27");
pub const szOID_KP_KERNEL_MODE_CODE_SIGNING: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.61.1.1");
pub const szOID_KP_KERNEL_MODE_HAL_EXTENSION_SIGNING: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.61.5.1");
pub const szOID_KP_KERNEL_MODE_TRUSTED_BOOT_SIGNING: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.61.4.1");
pub const szOID_KP_KEY_RECOVERY: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.3.11");
pub const szOID_KP_KEY_RECOVERY_AGENT: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.21.6");
pub const szOID_KP_LIFETIME_SIGNING: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.3.13");
pub const szOID_KP_MOBILE_DEVICE_SOFTWARE: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.3.14");
pub const szOID_KP_PRIVACY_CA: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.21.36");
pub const szOID_KP_QUALIFIED_SUBORDINATION: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.3.10");
pub const szOID_KP_SMARTCARD_LOGON: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.20.2.2");
pub const szOID_KP_SMART_DISPLAY: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.3.15");
pub const szOID_KP_TIME_STAMP_SIGNING: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.3.2");
pub const szOID_KP_TPM_AIK_CERTIFICATE: windows_core::PCSTR = windows_core::s!("2.23.133.8.3");
pub const szOID_KP_TPM_EK_CERTIFICATE: windows_core::PCSTR = windows_core::s!("2.23.133.8.1");
pub const szOID_KP_TPM_PLATFORM_CERTIFICATE: windows_core::PCSTR = windows_core::s!("2.23.133.8.2");
pub const szOID_LEGACY_POLICY_MAPPINGS: windows_core::PCSTR = windows_core::s!("2.5.29.5");
pub const szOID_LICENSES: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.6.1");
pub const szOID_LICENSE_SERVER: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.6.2");
pub const szOID_LOCALITY_NAME: windows_core::PCSTR = windows_core::s!("2.5.4.7");
pub const szOID_LOCAL_MACHINE_KEYSET: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.17.2");
pub const szOID_LOGOTYPE_EXT: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.1.12");
pub const szOID_LOYALTY_OTHER_LOGOTYPE: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.20.1");
pub const szOID_MEMBER: windows_core::PCSTR = windows_core::s!("2.5.4.31");
pub const szOID_MICROSOFT_PUBLISHER_SIGNER: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.76.8.1");
pub const szOID_NAME_CONSTRAINTS: windows_core::PCSTR = windows_core::s!("2.5.29.30");
pub const szOID_NETSCAPE: windows_core::PCSTR = windows_core::s!("2.16.840.1.113730");
pub const szOID_NETSCAPE_BASE_URL: windows_core::PCSTR = windows_core::s!("2.16.840.1.113730.1.2");
pub const szOID_NETSCAPE_CA_POLICY_URL: windows_core::PCSTR = windows_core::s!("2.16.840.1.113730.1.8");
pub const szOID_NETSCAPE_CA_REVOCATION_URL: windows_core::PCSTR = windows_core::s!("2.16.840.1.113730.1.4");
pub const szOID_NETSCAPE_CERT_EXTENSION: windows_core::PCSTR = windows_core::s!("2.16.840.1.113730.1");
pub const szOID_NETSCAPE_CERT_RENEWAL_URL: windows_core::PCSTR = windows_core::s!("2.16.840.1.113730.1.7");
pub const szOID_NETSCAPE_CERT_SEQUENCE: windows_core::PCSTR = windows_core::s!("2.16.840.1.113730.2.5");
pub const szOID_NETSCAPE_CERT_TYPE: windows_core::PCSTR = windows_core::s!("2.16.840.1.113730.1.1");
pub const szOID_NETSCAPE_COMMENT: windows_core::PCSTR = windows_core::s!("2.16.840.1.113730.1.13");
pub const szOID_NETSCAPE_DATA_TYPE: windows_core::PCSTR = windows_core::s!("2.16.840.1.113730.2");
pub const szOID_NETSCAPE_REVOCATION_URL: windows_core::PCSTR = windows_core::s!("2.16.840.1.113730.1.3");
pub const szOID_NETSCAPE_SSL_SERVER_NAME: windows_core::PCSTR = windows_core::s!("2.16.840.1.113730.1.12");
pub const szOID_NEXT_UPDATE_LOCATION: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.2");
pub const szOID_NIST_AES128_CBC: windows_core::PCSTR = windows_core::s!("2.16.840.1.101.3.4.1.2");
pub const szOID_NIST_AES128_WRAP: windows_core::PCSTR = windows_core::s!("2.16.840.1.101.3.4.1.5");
pub const szOID_NIST_AES192_CBC: windows_core::PCSTR = windows_core::s!("2.16.840.1.101.3.4.1.22");
pub const szOID_NIST_AES192_WRAP: windows_core::PCSTR = windows_core::s!("2.16.840.1.101.3.4.1.25");
pub const szOID_NIST_AES256_CBC: windows_core::PCSTR = windows_core::s!("2.16.840.1.101.3.4.1.42");
pub const szOID_NIST_AES256_WRAP: windows_core::PCSTR = windows_core::s!("2.16.840.1.101.3.4.1.45");
pub const szOID_NIST_sha256: windows_core::PCSTR = windows_core::s!("2.16.840.1.101.3.4.2.1");
pub const szOID_NIST_sha384: windows_core::PCSTR = windows_core::s!("2.16.840.1.101.3.4.2.2");
pub const szOID_NIST_sha512: windows_core::PCSTR = windows_core::s!("2.16.840.1.101.3.4.2.3");
pub const szOID_NT5_CRYPTO: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.3.6");
pub const szOID_NTDS_CA_SECURITY_EXT: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.25.2");
pub const szOID_NTDS_OBJECTSID: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.25.2.1");
pub const szOID_NTDS_REPLICATION: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.25.1");
pub const szOID_NT_PRINCIPAL_NAME: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.20.2.3");
pub const szOID_OEM_WHQL_CRYPTO: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.3.7");
pub const szOID_OIW: windows_core::PCSTR = windows_core::s!("1.3.14");
pub const szOID_OIWDIR: windows_core::PCSTR = windows_core::s!("1.3.14.7.2");
pub const szOID_OIWDIR_CRPT: windows_core::PCSTR = windows_core::s!("1.3.14.7.2.1");
pub const szOID_OIWDIR_HASH: windows_core::PCSTR = windows_core::s!("1.3.14.7.2.2");
pub const szOID_OIWDIR_SIGN: windows_core::PCSTR = windows_core::s!("1.3.14.7.2.3");
pub const szOID_OIWDIR_md2: windows_core::PCSTR = windows_core::s!("1.3.14.7.2.2.1");
pub const szOID_OIWDIR_md2RSA: windows_core::PCSTR = windows_core::s!("1.3.14.7.2.3.1");
pub const szOID_OIWSEC: windows_core::PCSTR = windows_core::s!("1.3.14.3.2");
pub const szOID_OIWSEC_desCBC: windows_core::PCSTR = windows_core::s!("1.3.14.3.2.7");
pub const szOID_OIWSEC_desCFB: windows_core::PCSTR = windows_core::s!("1.3.14.3.2.9");
pub const szOID_OIWSEC_desECB: windows_core::PCSTR = windows_core::s!("1.3.14.3.2.6");
pub const szOID_OIWSEC_desEDE: windows_core::PCSTR = windows_core::s!("1.3.14.3.2.17");
pub const szOID_OIWSEC_desMAC: windows_core::PCSTR = windows_core::s!("1.3.14.3.2.10");
pub const szOID_OIWSEC_desOFB: windows_core::PCSTR = windows_core::s!("1.3.14.3.2.8");
pub const szOID_OIWSEC_dhCommMod: windows_core::PCSTR = windows_core::s!("1.3.14.3.2.16");
pub const szOID_OIWSEC_dsa: windows_core::PCSTR = windows_core::s!("1.3.14.3.2.12");
pub const szOID_OIWSEC_dsaComm: windows_core::PCSTR = windows_core::s!("1.3.14.3.2.20");
pub const szOID_OIWSEC_dsaCommSHA: windows_core::PCSTR = windows_core::s!("1.3.14.3.2.21");
pub const szOID_OIWSEC_dsaCommSHA1: windows_core::PCSTR = windows_core::s!("1.3.14.3.2.28");
pub const szOID_OIWSEC_dsaSHA1: windows_core::PCSTR = windows_core::s!("1.3.14.3.2.27");
pub const szOID_OIWSEC_keyHashSeal: windows_core::PCSTR = windows_core::s!("1.3.14.3.2.23");
pub const szOID_OIWSEC_md2RSASign: windows_core::PCSTR = windows_core::s!("1.3.14.3.2.24");
pub const szOID_OIWSEC_md4RSA: windows_core::PCSTR = windows_core::s!("1.3.14.3.2.2");
pub const szOID_OIWSEC_md4RSA2: windows_core::PCSTR = windows_core::s!("1.3.14.3.2.4");
pub const szOID_OIWSEC_md5RSA: windows_core::PCSTR = windows_core::s!("1.3.14.3.2.3");
pub const szOID_OIWSEC_md5RSASign: windows_core::PCSTR = windows_core::s!("1.3.14.3.2.25");
pub const szOID_OIWSEC_mdc2: windows_core::PCSTR = windows_core::s!("1.3.14.3.2.19");
pub const szOID_OIWSEC_mdc2RSA: windows_core::PCSTR = windows_core::s!("1.3.14.3.2.14");
pub const szOID_OIWSEC_rsaSign: windows_core::PCSTR = windows_core::s!("1.3.14.3.2.11");
pub const szOID_OIWSEC_rsaXchg: windows_core::PCSTR = windows_core::s!("1.3.14.3.2.22");
pub const szOID_OIWSEC_sha: windows_core::PCSTR = windows_core::s!("1.3.14.3.2.18");
pub const szOID_OIWSEC_sha1: windows_core::PCSTR = windows_core::s!("1.3.14.3.2.26");
pub const szOID_OIWSEC_sha1RSASign: windows_core::PCSTR = windows_core::s!("1.3.14.3.2.29");
pub const szOID_OIWSEC_shaDSA: windows_core::PCSTR = windows_core::s!("1.3.14.3.2.13");
pub const szOID_OIWSEC_shaRSA: windows_core::PCSTR = windows_core::s!("1.3.14.3.2.15");
pub const szOID_ORGANIZATIONAL_UNIT_NAME: windows_core::PCSTR = windows_core::s!("2.5.4.11");
pub const szOID_ORGANIZATION_NAME: windows_core::PCSTR = windows_core::s!("2.5.4.10");
pub const szOID_OS_VERSION: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.13.2.3");
pub const szOID_OWNER: windows_core::PCSTR = windows_core::s!("2.5.4.32");
pub const szOID_PHYSICAL_DELIVERY_OFFICE_NAME: windows_core::PCSTR = windows_core::s!("2.5.4.19");
pub const szOID_PIN_RULES_CTL: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.3.32");
pub const szOID_PIN_RULES_DOMAIN_NAME: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.3.34");
pub const szOID_PIN_RULES_EXT: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.3.33");
pub const szOID_PIN_RULES_LOG_END_DATE_EXT: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.3.35");
pub const szOID_PIN_RULES_SIGNER: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.3.31");
pub const szOID_PKCS: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1");
pub const szOID_PKCS_1: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.1");
pub const szOID_PKCS_10: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.10");
pub const szOID_PKCS_12: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.12");
pub const szOID_PKCS_12_EXTENDED_ATTRIBUTES: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.17.3");
pub const szOID_PKCS_12_FRIENDLY_NAME_ATTR: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.9.20");
pub const szOID_PKCS_12_KEY_PROVIDER_NAME_ATTR: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.17.1");
pub const szOID_PKCS_12_LOCAL_KEY_ID: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.9.21");
pub const szOID_PKCS_12_PROTECTED_PASSWORD_SECRET_BAG_TYPE_ID: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.17.4");
pub const szOID_PKCS_12_PbeIds: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.12.1");
pub const szOID_PKCS_12_pbeWithSHA1And128BitRC2: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.12.1.5");
pub const szOID_PKCS_12_pbeWithSHA1And128BitRC4: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.12.1.1");
pub const szOID_PKCS_12_pbeWithSHA1And2KeyTripleDES: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.12.1.4");
pub const szOID_PKCS_12_pbeWithSHA1And3KeyTripleDES: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.12.1.3");
pub const szOID_PKCS_12_pbeWithSHA1And40BitRC2: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.12.1.6");
pub const szOID_PKCS_12_pbeWithSHA1And40BitRC4: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.12.1.2");
pub const szOID_PKCS_2: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.2");
pub const szOID_PKCS_3: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.3");
pub const szOID_PKCS_4: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.4");
pub const szOID_PKCS_5: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.5");
pub const szOID_PKCS_5_PBES2: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.5.13");
pub const szOID_PKCS_5_PBKDF2: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.5.12");
pub const szOID_PKCS_6: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.6");
pub const szOID_PKCS_7: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.7");
pub const szOID_PKCS_7_DATA: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.7.1");
pub const szOID_PKCS_7_DIGESTED: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.7.5");
pub const szOID_PKCS_7_ENCRYPTED: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.7.6");
pub const szOID_PKCS_7_ENVELOPED: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.7.3");
pub const szOID_PKCS_7_SIGNED: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.7.2");
pub const szOID_PKCS_7_SIGNEDANDENVELOPED: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.7.4");
pub const szOID_PKCS_8: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.8");
pub const szOID_PKCS_9: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.9");
pub const szOID_PKCS_9_CONTENT_TYPE: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.9.3");
pub const szOID_PKCS_9_MESSAGE_DIGEST: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.9.4");
pub const szOID_PKINIT_KP_KDC: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.2.3.5");
pub const szOID_PKIX: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7");
pub const szOID_PKIX_ACC_DESCR: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.48");
pub const szOID_PKIX_CA_ISSUERS: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.48.2");
pub const szOID_PKIX_CA_REPOSITORY: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.48.5");
pub const szOID_PKIX_KP: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.3");
pub const szOID_PKIX_KP_CLIENT_AUTH: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.3.2");
pub const szOID_PKIX_KP_CODE_SIGNING: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.3.3");
pub const szOID_PKIX_KP_EMAIL_PROTECTION: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.3.4");
pub const szOID_PKIX_KP_IPSEC_END_SYSTEM: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.3.5");
pub const szOID_PKIX_KP_IPSEC_TUNNEL: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.3.6");
pub const szOID_PKIX_KP_IPSEC_USER: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.3.7");
pub const szOID_PKIX_KP_OCSP_SIGNING: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.3.9");
pub const szOID_PKIX_KP_SERVER_AUTH: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.3.1");
pub const szOID_PKIX_KP_TIMESTAMP_SIGNING: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.3.8");
pub const szOID_PKIX_NO_SIGNATURE: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.6.2");
pub const szOID_PKIX_OCSP: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.48.1");
pub const szOID_PKIX_OCSP_BASIC_SIGNED_RESPONSE: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.48.1.1");
pub const szOID_PKIX_OCSP_NOCHECK: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.48.1.5");
pub const szOID_PKIX_OCSP_NONCE: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.48.1.2");
pub const szOID_PKIX_PE: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.1");
pub const szOID_PKIX_POLICY_QUALIFIER_CPS: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.2.1");
pub const szOID_PKIX_POLICY_QUALIFIER_USERNOTICE: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.2.2");
pub const szOID_PKIX_TIME_STAMPING: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.48.3");
pub const szOID_PLATFORM_MANIFEST_BINARY_ID: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.3.28");
pub const szOID_POLICY_CONSTRAINTS: windows_core::PCSTR = windows_core::s!("2.5.29.36");
pub const szOID_POLICY_MAPPINGS: windows_core::PCSTR = windows_core::s!("2.5.29.33");
pub const szOID_POSTAL_ADDRESS: windows_core::PCSTR = windows_core::s!("2.5.4.16");
pub const szOID_POSTAL_CODE: windows_core::PCSTR = windows_core::s!("2.5.4.17");
pub const szOID_POST_OFFICE_BOX: windows_core::PCSTR = windows_core::s!("2.5.4.18");
pub const szOID_PREFERRED_DELIVERY_METHOD: windows_core::PCSTR = windows_core::s!("2.5.4.28");
pub const szOID_PRESENTATION_ADDRESS: windows_core::PCSTR = windows_core::s!("2.5.4.29");
pub const szOID_PRIVATEKEY_USAGE_PERIOD: windows_core::PCSTR = windows_core::s!("2.5.29.16");
pub const szOID_PRODUCT_UPDATE: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.31.1");
pub const szOID_PROTECTED_PROCESS_LIGHT_SIGNER: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.3.22");
pub const szOID_PROTECTED_PROCESS_SIGNER: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.3.24");
pub const szOID_QC_EU_COMPLIANCE: windows_core::PCSTR = windows_core::s!("0.4.0.1862.1.1");
pub const szOID_QC_SSCD: windows_core::PCSTR = windows_core::s!("0.4.0.1862.1.4");
pub const szOID_QC_STATEMENTS_EXT: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.1.3");
pub const szOID_RDN_DUMMY_SIGNER: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.21.9");
pub const szOID_RDN_TCG_PLATFORM_MANUFACTURER: windows_core::PCSTR = windows_core::s!("2.23.133.2.4");
pub const szOID_RDN_TCG_PLATFORM_MODEL: windows_core::PCSTR = windows_core::s!("2.23.133.2.5");
pub const szOID_RDN_TCG_PLATFORM_VERSION: windows_core::PCSTR = windows_core::s!("2.23.133.2.6");
pub const szOID_RDN_TPM_MANUFACTURER: windows_core::PCSTR = windows_core::s!("2.23.133.2.1");
pub const szOID_RDN_TPM_MODEL: windows_core::PCSTR = windows_core::s!("2.23.133.2.2");
pub const szOID_RDN_TPM_VERSION: windows_core::PCSTR = windows_core::s!("2.23.133.2.3");
pub const szOID_REASON_CODE_HOLD: windows_core::PCSTR = windows_core::s!("2.5.29.23");
pub const szOID_REGISTERED_ADDRESS: windows_core::PCSTR = windows_core::s!("2.5.4.26");
pub const szOID_REMOVE_CERTIFICATE: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.8.1");
pub const szOID_RENEWAL_CERTIFICATE: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.13.1");
pub const szOID_REQUEST_CLIENT_INFO: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.21.20");
pub const szOID_REQUIRE_CERT_CHAIN_POLICY: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.21.15");
pub const szOID_REVOKED_LIST_SIGNER: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.3.19");
pub const szOID_RFC3161_counterSign: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.3.3.1");
pub const szOID_RFC3161v21_counterSign: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.3.3.2");
pub const szOID_RFC3161v21_thumbprints: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.3.3.3");
pub const szOID_ROLE_OCCUPANT: windows_core::PCSTR = windows_core::s!("2.5.4.33");
pub const szOID_ROOT_LIST_SIGNER: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.3.9");
pub const szOID_ROOT_PROGRAM_AUTO_UPDATE_CA_REVOCATION: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.60.3.1");
pub const szOID_ROOT_PROGRAM_AUTO_UPDATE_END_REVOCATION: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.60.3.2");
pub const szOID_ROOT_PROGRAM_FLAGS: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.60.1.1");
pub const szOID_ROOT_PROGRAM_NO_OCSP_FAILOVER_TO_CRL: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.60.3.3");
pub const szOID_RSA: windows_core::PCSTR = windows_core::s!("1.2.840.113549");
pub const szOID_RSAES_OAEP: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.1.7");
pub const szOID_RSA_DES_EDE3_CBC: windows_core::PCSTR = windows_core::s!("1.2.840.113549.3.7");
pub const szOID_RSA_DH: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.3.1");
pub const szOID_RSA_ENCRYPT: windows_core::PCSTR = windows_core::s!("1.2.840.113549.3");
pub const szOID_RSA_HASH: windows_core::PCSTR = windows_core::s!("1.2.840.113549.2");
pub const szOID_RSA_MD2: windows_core::PCSTR = windows_core::s!("1.2.840.113549.2.2");
pub const szOID_RSA_MD2RSA: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.1.2");
pub const szOID_RSA_MD4: windows_core::PCSTR = windows_core::s!("1.2.840.113549.2.4");
pub const szOID_RSA_MD4RSA: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.1.3");
pub const szOID_RSA_MD5: windows_core::PCSTR = windows_core::s!("1.2.840.113549.2.5");
pub const szOID_RSA_MD5RSA: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.1.4");
pub const szOID_RSA_MGF1: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.1.8");
pub const szOID_RSA_PSPECIFIED: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.1.9");
pub const szOID_RSA_RC2CBC: windows_core::PCSTR = windows_core::s!("1.2.840.113549.3.2");
pub const szOID_RSA_RC4: windows_core::PCSTR = windows_core::s!("1.2.840.113549.3.4");
pub const szOID_RSA_RC5_CBCPad: windows_core::PCSTR = windows_core::s!("1.2.840.113549.3.9");
pub const szOID_RSA_RSA: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.1.1");
pub const szOID_RSA_SETOAEP_RSA: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.1.6");
pub const szOID_RSA_SHA1RSA: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.1.5");
pub const szOID_RSA_SHA256RSA: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.1.11");
pub const szOID_RSA_SHA384RSA: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.1.12");
pub const szOID_RSA_SHA512RSA: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.1.13");
pub const szOID_RSA_SMIMECapabilities: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.9.15");
pub const szOID_RSA_SMIMEalg: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.9.16.3");
pub const szOID_RSA_SMIMEalgCMS3DESwrap: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.9.16.3.6");
pub const szOID_RSA_SMIMEalgCMSRC2wrap: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.9.16.3.7");
pub const szOID_RSA_SMIMEalgESDH: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.9.16.3.5");
pub const szOID_RSA_SSA_PSS: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.1.10");
pub const szOID_RSA_certExtensions: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.9.14");
pub const szOID_RSA_challengePwd: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.9.7");
pub const szOID_RSA_contentType: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.9.3");
pub const szOID_RSA_counterSign: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.9.6");
pub const szOID_RSA_data: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.7.1");
pub const szOID_RSA_digestedData: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.7.5");
pub const szOID_RSA_emailAddr: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.9.1");
pub const szOID_RSA_encryptedData: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.7.6");
pub const szOID_RSA_envelopedData: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.7.3");
pub const szOID_RSA_extCertAttrs: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.9.9");
pub const szOID_RSA_hashedData: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.7.5");
pub const szOID_RSA_messageDigest: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.9.4");
pub const szOID_RSA_preferSignedData: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.9.15.1");
pub const szOID_RSA_signEnvData: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.7.4");
pub const szOID_RSA_signedData: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.7.2");
pub const szOID_RSA_signingTime: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.9.5");
pub const szOID_RSA_unstructAddr: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.9.8");
pub const szOID_RSA_unstructName: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.9.2");
pub const szOID_SEARCH_GUIDE: windows_core::PCSTR = windows_core::s!("2.5.4.14");
pub const szOID_SEE_ALSO: windows_core::PCSTR = windows_core::s!("2.5.4.34");
pub const szOID_SERIALIZED: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.3.3.1");
pub const szOID_SERVER_GATED_CRYPTO: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.3.3");
pub const szOID_SGC_NETSCAPE: windows_core::PCSTR = windows_core::s!("2.16.840.1.113730.4.1");
pub const szOID_SITE_PIN_RULES_FLAGS_ATTR: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.4.3");
pub const szOID_SITE_PIN_RULES_INDEX_ATTR: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.4.2");
pub const szOID_SORTED_CTL: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.1.1");
pub const szOID_STATE_OR_PROVINCE_NAME: windows_core::PCSTR = windows_core::s!("2.5.4.8");
pub const szOID_STREET_ADDRESS: windows_core::PCSTR = windows_core::s!("2.5.4.9");
pub const szOID_SUBJECT_ALT_NAME: windows_core::PCSTR = windows_core::s!("2.5.29.7");
pub const szOID_SUBJECT_ALT_NAME2: windows_core::PCSTR = windows_core::s!("2.5.29.17");
pub const szOID_SUBJECT_DIR_ATTRS: windows_core::PCSTR = windows_core::s!("2.5.29.9");
pub const szOID_SUBJECT_INFO_ACCESS: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.1.11");
pub const szOID_SUBJECT_KEY_IDENTIFIER: windows_core::PCSTR = windows_core::s!("2.5.29.14");
pub const szOID_SUPPORTED_APPLICATION_CONTEXT: windows_core::PCSTR = windows_core::s!("2.5.4.30");
pub const szOID_SUR_NAME: windows_core::PCSTR = windows_core::s!("2.5.4.4");
pub const szOID_SYNC_ROOT_CTL_EXT: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.3.50");
pub const szOID_TELEPHONE_NUMBER: windows_core::PCSTR = windows_core::s!("2.5.4.20");
pub const szOID_TELETEXT_TERMINAL_IDENTIFIER: windows_core::PCSTR = windows_core::s!("2.5.4.22");
pub const szOID_TELEX_NUMBER: windows_core::PCSTR = windows_core::s!("2.5.4.21");
pub const szOID_TIMESTAMP_TOKEN: windows_core::PCSTR = windows_core::s!("1.2.840.113549.1.9.16.1.4");
pub const szOID_TITLE: windows_core::PCSTR = windows_core::s!("2.5.4.12");
pub const szOID_TLS_FEATURES_EXT: windows_core::PCSTR = windows_core::s!("1.3.6.1.5.5.7.1.24");
pub const szOID_USER_CERTIFICATE: windows_core::PCSTR = windows_core::s!("2.5.4.36");
pub const szOID_USER_PASSWORD: windows_core::PCSTR = windows_core::s!("2.5.4.35");
pub const szOID_VERISIGN_BITSTRING_6_13: windows_core::PCSTR = windows_core::s!("2.16.840.1.113733.1.6.13");
pub const szOID_VERISIGN_ISS_STRONG_CRYPTO: windows_core::PCSTR = windows_core::s!("2.16.840.1.113733.1.8.1");
pub const szOID_VERISIGN_ONSITE_JURISDICTION_HASH: windows_core::PCSTR = windows_core::s!("2.16.840.1.113733.1.6.11");
pub const szOID_VERISIGN_PRIVATE_6_9: windows_core::PCSTR = windows_core::s!("2.16.840.1.113733.1.6.9");
pub const szOID_WHQL_CRYPTO: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.3.5");
pub const szOID_WINDOWS_KITS_SIGNER: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.3.20");
pub const szOID_WINDOWS_RT_SIGNER: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.3.21");
pub const szOID_WINDOWS_SOFTWARE_EXTENSION_SIGNER: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.3.26");
pub const szOID_WINDOWS_STORE_SIGNER: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.76.3.1");
pub const szOID_WINDOWS_TCB_SIGNER: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.3.23");
pub const szOID_WINDOWS_THIRD_PARTY_COMPONENT_SIGNER: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.3.25");
pub const szOID_X21_ADDRESS: windows_core::PCSTR = windows_core::s!("2.5.4.24");
pub const szOID_X957: windows_core::PCSTR = windows_core::s!("1.2.840.10040");
pub const szOID_X957_DSA: windows_core::PCSTR = windows_core::s!("1.2.840.10040.4.1");
pub const szOID_X957_SHA1DSA: windows_core::PCSTR = windows_core::s!("1.2.840.10040.4.3");
pub const szOID_YESNO_TRUST_ATTR: windows_core::PCSTR = windows_core::s!("1.3.6.1.4.1.311.10.4.1");
pub const szPRIV_KEY_CACHE_MAX_ITEMS: windows_core::PCSTR = windows_core::s!("PrivKeyCacheMaxItems");
pub const szPRIV_KEY_CACHE_PURGE_INTERVAL_SECONDS: windows_core::PCSTR = windows_core::s!("PrivKeyCachePurgeIntervalSeconds");
pub const sz_CERT_STORE_PROV_COLLECTION: windows_core::PCSTR = windows_core::s!("Collection");
pub const sz_CERT_STORE_PROV_FILENAME: windows_core::PCWSTR = windows_core::w!("File");
pub const sz_CERT_STORE_PROV_FILENAME_W: windows_core::PCSTR = windows_core::s!("File");
pub const sz_CERT_STORE_PROV_LDAP: windows_core::PCWSTR = windows_core::w!("Ldap");
pub const sz_CERT_STORE_PROV_LDAP_W: windows_core::PCSTR = windows_core::s!("Ldap");
pub const sz_CERT_STORE_PROV_MEMORY: windows_core::PCSTR = windows_core::s!("Memory");
pub const sz_CERT_STORE_PROV_PHYSICAL: windows_core::PCWSTR = windows_core::w!("Physical");
pub const sz_CERT_STORE_PROV_PHYSICAL_W: windows_core::PCSTR = windows_core::s!("Physical");
pub const sz_CERT_STORE_PROV_PKCS12: windows_core::PCSTR = windows_core::s!("PKCS12");
pub const sz_CERT_STORE_PROV_PKCS7: windows_core::PCSTR = windows_core::s!("PKCS7");
pub const sz_CERT_STORE_PROV_SERIALIZED: windows_core::PCSTR = windows_core::s!("Serialized");
pub const sz_CERT_STORE_PROV_SMART_CARD: windows_core::PCWSTR = windows_core::w!("SmartCard");
pub const sz_CERT_STORE_PROV_SMART_CARD_W: windows_core::PCSTR = windows_core::s!("SmartCard");
pub const sz_CERT_STORE_PROV_SYSTEM: windows_core::PCWSTR = windows_core::w!("System");
pub const sz_CERT_STORE_PROV_SYSTEM_REGISTRY: windows_core::PCWSTR = windows_core::w!("SystemRegistry");
pub const sz_CERT_STORE_PROV_SYSTEM_REGISTRY_W: windows_core::PCSTR = windows_core::s!("SystemRegistry");
pub const sz_CERT_STORE_PROV_SYSTEM_W: windows_core::PCSTR = windows_core::s!("System");
pub const wszURI_CANONICALIZATION_C14N: windows_core::PCWSTR = windows_core::w!("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
pub const wszURI_CANONICALIZATION_C14NC: windows_core::PCWSTR = windows_core::w!("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
pub const wszURI_CANONICALIZATION_EXSLUSIVE_C14N: windows_core::PCWSTR = windows_core::w!("http://www.w3.org/2001/10/xml-exc-c14n#");
pub const wszURI_CANONICALIZATION_EXSLUSIVE_C14NC: windows_core::PCWSTR = windows_core::w!("http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
pub const wszURI_NTDS_OBJECTSID_PREFIX: windows_core::PCWSTR = windows_core::w!("tag:microsoft.com,2022-09-14:sid:");
pub const wszURI_TRANSFORM_XPATH: windows_core::PCWSTR = windows_core::w!("http://www.w3.org/TR/1999/REC-xpath-19991116");
pub const wszURI_XMLNS_DIGSIG_BASE64: windows_core::PCWSTR = windows_core::w!("http://www.w3.org/2000/09/xmldsig#base64");
pub const wszURI_XMLNS_DIGSIG_DSA_SHA1: windows_core::PCWSTR = windows_core::w!("http://www.w3.org/2000/09/xmldsig#dsa-sha1");
pub const wszURI_XMLNS_DIGSIG_ECDSA_SHA1: windows_core::PCWSTR = windows_core::w!("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1");
pub const wszURI_XMLNS_DIGSIG_ECDSA_SHA256: windows_core::PCWSTR = windows_core::w!("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256");
pub const wszURI_XMLNS_DIGSIG_ECDSA_SHA384: windows_core::PCWSTR = windows_core::w!("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384");
pub const wszURI_XMLNS_DIGSIG_ECDSA_SHA512: windows_core::PCWSTR = windows_core::w!("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512");
pub const wszURI_XMLNS_DIGSIG_HMAC_SHA1: windows_core::PCWSTR = windows_core::w!("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
pub const wszURI_XMLNS_DIGSIG_HMAC_SHA256: windows_core::PCWSTR = windows_core::w!("http://www.w3.org/2001/04/xmldsig-more#hmac-sha256");
pub const wszURI_XMLNS_DIGSIG_HMAC_SHA384: windows_core::PCWSTR = windows_core::w!("http://www.w3.org/2001/04/xmldsig-more#hmac-sha384");
pub const wszURI_XMLNS_DIGSIG_HMAC_SHA512: windows_core::PCWSTR = windows_core::w!("http://www.w3.org/2001/04/xmldsig-more#hmac-sha512");
pub const wszURI_XMLNS_DIGSIG_RSA_SHA1: windows_core::PCWSTR = windows_core::w!("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
pub const wszURI_XMLNS_DIGSIG_RSA_SHA256: windows_core::PCWSTR = windows_core::w!("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
pub const wszURI_XMLNS_DIGSIG_RSA_SHA384: windows_core::PCWSTR = windows_core::w!("http://www.w3.org/2001/04/xmldsig-more#rsa-sha384");
pub const wszURI_XMLNS_DIGSIG_RSA_SHA512: windows_core::PCWSTR = windows_core::w!("http://www.w3.org/2001/04/xmldsig-more#rsa-sha512");
pub const wszURI_XMLNS_DIGSIG_SHA1: windows_core::PCWSTR = windows_core::w!("http://www.w3.org/2000/09/xmldsig#sha1");
pub const wszURI_XMLNS_DIGSIG_SHA256: windows_core::PCWSTR = windows_core::w!("http://www.w3.org/2001/04/xmlenc#sha256");
pub const wszURI_XMLNS_DIGSIG_SHA384: windows_core::PCWSTR = windows_core::w!("http://www.w3.org/2001/04/xmldsig-more#sha384");
pub const wszURI_XMLNS_DIGSIG_SHA512: windows_core::PCWSTR = windows_core::w!("http://www.w3.org/2001/04/xmlenc#sha512");
pub const wszURI_XMLNS_TRANSFORM_BASE64: windows_core::PCWSTR = windows_core::w!("http://www.w3.org/2000/09/xmldsig#base64");
pub const wszURI_XMLNS_TRANSFORM_ENVELOPED: windows_core::PCWSTR = windows_core::w!("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
pub const wszXMLNS_DIGSIG: windows_core::PCWSTR = windows_core::w!("http://www.w3.org/2000/09/xmldsig#");
pub const wszXMLNS_DIGSIG_Id: windows_core::PCWSTR = windows_core::w!("Id");
pub const wszXMLNS_DIGSIG_SignatureProperties: windows_core::PCWSTR = windows_core::w!("http://www.w3.org/2000/09/xmldsig#SignatureProperties");
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct ALG_ID(pub u32);
impl windows_core::TypeKind for ALG_ID {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for ALG_ID {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("ALG_ID").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct BCRYPTGENRANDOM_FLAGS(pub u32);
impl windows_core::TypeKind for BCRYPTGENRANDOM_FLAGS {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for BCRYPTGENRANDOM_FLAGS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("BCRYPTGENRANDOM_FLAGS").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct BCRYPT_DH_KEY_BLOB_MAGIC(pub u32);
impl windows_core::TypeKind for BCRYPT_DH_KEY_BLOB_MAGIC {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for BCRYPT_DH_KEY_BLOB_MAGIC {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("BCRYPT_DH_KEY_BLOB_MAGIC").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct BCRYPT_DSA_MAGIC(pub u32);
impl windows_core::TypeKind for BCRYPT_DSA_MAGIC {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for BCRYPT_DSA_MAGIC {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("BCRYPT_DSA_MAGIC").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct BCRYPT_FLAGS(pub u32);
impl windows_core::TypeKind for BCRYPT_FLAGS {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for BCRYPT_FLAGS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("BCRYPT_FLAGS").field(&self.0).finish()
    }
}
impl BCRYPT_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for BCRYPT_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for BCRYPT_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for BCRYPT_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for BCRYPT_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for BCRYPT_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct BCRYPT_HASH_OPERATION_TYPE(pub i32);
impl windows_core::TypeKind for BCRYPT_HASH_OPERATION_TYPE {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for BCRYPT_HASH_OPERATION_TYPE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("BCRYPT_HASH_OPERATION_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct BCRYPT_INTERFACE(pub u32);
impl windows_core::TypeKind for BCRYPT_INTERFACE {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for BCRYPT_INTERFACE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("BCRYPT_INTERFACE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct BCRYPT_MULTI_OPERATION_TYPE(pub i32);
impl windows_core::TypeKind for BCRYPT_MULTI_OPERATION_TYPE {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for BCRYPT_MULTI_OPERATION_TYPE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("BCRYPT_MULTI_OPERATION_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS(pub u32);
impl windows_core::TypeKind for BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS").field(&self.0).finish()
    }
}
impl BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct BCRYPT_OPERATION(pub u32);
impl windows_core::TypeKind for BCRYPT_OPERATION {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for BCRYPT_OPERATION {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("BCRYPT_OPERATION").field(&self.0).finish()
    }
}
impl BCRYPT_OPERATION {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for BCRYPT_OPERATION {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for BCRYPT_OPERATION {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for BCRYPT_OPERATION {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for BCRYPT_OPERATION {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for BCRYPT_OPERATION {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct BCRYPT_QUERY_PROVIDER_MODE(pub u32);
impl windows_core::TypeKind for BCRYPT_QUERY_PROVIDER_MODE {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for BCRYPT_QUERY_PROVIDER_MODE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("BCRYPT_QUERY_PROVIDER_MODE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct BCRYPT_RESOLVE_PROVIDERS_FLAGS(pub u32);
impl windows_core::TypeKind for BCRYPT_RESOLVE_PROVIDERS_FLAGS {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for BCRYPT_RESOLVE_PROVIDERS_FLAGS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("BCRYPT_RESOLVE_PROVIDERS_FLAGS").field(&self.0).finish()
    }
}
impl BCRYPT_RESOLVE_PROVIDERS_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for BCRYPT_RESOLVE_PROVIDERS_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for BCRYPT_RESOLVE_PROVIDERS_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for BCRYPT_RESOLVE_PROVIDERS_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for BCRYPT_RESOLVE_PROVIDERS_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for BCRYPT_RESOLVE_PROVIDERS_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct BCRYPT_RSAKEY_BLOB_MAGIC(pub u32);
impl windows_core::TypeKind for BCRYPT_RSAKEY_BLOB_MAGIC {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for BCRYPT_RSAKEY_BLOB_MAGIC {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("BCRYPT_RSAKEY_BLOB_MAGIC").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct BCRYPT_TABLE(pub u32);
impl windows_core::TypeKind for BCRYPT_TABLE {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for BCRYPT_TABLE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("BCRYPT_TABLE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CASetupProperty(pub i32);
impl windows_core::TypeKind for CASetupProperty {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CASetupProperty {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CASetupProperty").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CEPSetupProperty(pub i32);
impl windows_core::TypeKind for CEPSetupProperty {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CEPSetupProperty {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CEPSetupProperty").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CERT_BIOMETRIC_DATA_TYPE(pub u32);
impl windows_core::TypeKind for CERT_BIOMETRIC_DATA_TYPE {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CERT_BIOMETRIC_DATA_TYPE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CERT_BIOMETRIC_DATA_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CERT_CHAIN_POLICY_FLAGS(pub u32);
impl windows_core::TypeKind for CERT_CHAIN_POLICY_FLAGS {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CERT_CHAIN_POLICY_FLAGS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CERT_CHAIN_POLICY_FLAGS").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CERT_CONTROL_STORE_FLAGS(pub u32);
impl windows_core::TypeKind for CERT_CONTROL_STORE_FLAGS {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CERT_CONTROL_STORE_FLAGS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CERT_CONTROL_STORE_FLAGS").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CERT_CREATE_SELFSIGN_FLAGS(pub u32);
impl windows_core::TypeKind for CERT_CREATE_SELFSIGN_FLAGS {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CERT_CREATE_SELFSIGN_FLAGS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CERT_CREATE_SELFSIGN_FLAGS").field(&self.0).finish()
    }
}
impl CERT_CREATE_SELFSIGN_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for CERT_CREATE_SELFSIGN_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for CERT_CREATE_SELFSIGN_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for CERT_CREATE_SELFSIGN_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for CERT_CREATE_SELFSIGN_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for CERT_CREATE_SELFSIGN_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CERT_FIND_CHAIN_IN_STORE_FLAGS(pub u32);
impl windows_core::TypeKind for CERT_FIND_CHAIN_IN_STORE_FLAGS {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CERT_FIND_CHAIN_IN_STORE_FLAGS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CERT_FIND_CHAIN_IN_STORE_FLAGS").field(&self.0).finish()
    }
}
impl CERT_FIND_CHAIN_IN_STORE_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for CERT_FIND_CHAIN_IN_STORE_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for CERT_FIND_CHAIN_IN_STORE_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for CERT_FIND_CHAIN_IN_STORE_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for CERT_FIND_CHAIN_IN_STORE_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for CERT_FIND_CHAIN_IN_STORE_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CERT_FIND_FLAGS(pub u32);
impl windows_core::TypeKind for CERT_FIND_FLAGS {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CERT_FIND_FLAGS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CERT_FIND_FLAGS").field(&self.0).finish()
    }
}
impl CERT_FIND_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for CERT_FIND_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for CERT_FIND_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for CERT_FIND_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for CERT_FIND_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for CERT_FIND_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CERT_FIND_TYPE(pub u32);
impl windows_core::TypeKind for CERT_FIND_TYPE {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CERT_FIND_TYPE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CERT_FIND_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CERT_ID_OPTION(pub u32);
impl windows_core::TypeKind for CERT_ID_OPTION {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CERT_ID_OPTION {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CERT_ID_OPTION").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CERT_KEY_SPEC(pub u32);
impl windows_core::TypeKind for CERT_KEY_SPEC {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CERT_KEY_SPEC {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CERT_KEY_SPEC").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CERT_LOGOTYPE_CHOICE(pub u32);
impl windows_core::TypeKind for CERT_LOGOTYPE_CHOICE {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CERT_LOGOTYPE_CHOICE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CERT_LOGOTYPE_CHOICE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CERT_LOGOTYPE_IMAGE_INFO_TYPE(pub u32);
impl windows_core::TypeKind for CERT_LOGOTYPE_IMAGE_INFO_TYPE {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CERT_LOGOTYPE_IMAGE_INFO_TYPE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CERT_LOGOTYPE_IMAGE_INFO_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CERT_LOGOTYPE_OPTION(pub u32);
impl windows_core::TypeKind for CERT_LOGOTYPE_OPTION {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CERT_LOGOTYPE_OPTION {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CERT_LOGOTYPE_OPTION").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CERT_OPEN_STORE_FLAGS(pub u32);
impl windows_core::TypeKind for CERT_OPEN_STORE_FLAGS {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CERT_OPEN_STORE_FLAGS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CERT_OPEN_STORE_FLAGS").field(&self.0).finish()
    }
}
impl CERT_OPEN_STORE_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for CERT_OPEN_STORE_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for CERT_OPEN_STORE_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for CERT_OPEN_STORE_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for CERT_OPEN_STORE_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for CERT_OPEN_STORE_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CERT_QUERY_CONTENT_TYPE(pub u32);
impl windows_core::TypeKind for CERT_QUERY_CONTENT_TYPE {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CERT_QUERY_CONTENT_TYPE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CERT_QUERY_CONTENT_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CERT_QUERY_CONTENT_TYPE_FLAGS(pub u32);
impl windows_core::TypeKind for CERT_QUERY_CONTENT_TYPE_FLAGS {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CERT_QUERY_CONTENT_TYPE_FLAGS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CERT_QUERY_CONTENT_TYPE_FLAGS").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CERT_QUERY_ENCODING_TYPE(pub u32);
impl windows_core::TypeKind for CERT_QUERY_ENCODING_TYPE {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CERT_QUERY_ENCODING_TYPE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CERT_QUERY_ENCODING_TYPE").field(&self.0).finish()
    }
}
impl CERT_QUERY_ENCODING_TYPE {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for CERT_QUERY_ENCODING_TYPE {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for CERT_QUERY_ENCODING_TYPE {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for CERT_QUERY_ENCODING_TYPE {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for CERT_QUERY_ENCODING_TYPE {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for CERT_QUERY_ENCODING_TYPE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CERT_QUERY_FORMAT_TYPE(pub u32);
impl windows_core::TypeKind for CERT_QUERY_FORMAT_TYPE {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CERT_QUERY_FORMAT_TYPE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CERT_QUERY_FORMAT_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CERT_QUERY_FORMAT_TYPE_FLAGS(pub u32);
impl windows_core::TypeKind for CERT_QUERY_FORMAT_TYPE_FLAGS {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CERT_QUERY_FORMAT_TYPE_FLAGS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CERT_QUERY_FORMAT_TYPE_FLAGS").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CERT_QUERY_OBJECT_TYPE(pub u32);
impl windows_core::TypeKind for CERT_QUERY_OBJECT_TYPE {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CERT_QUERY_OBJECT_TYPE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CERT_QUERY_OBJECT_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CERT_RDN_ATTR_VALUE_TYPE(pub i32);
impl windows_core::TypeKind for CERT_RDN_ATTR_VALUE_TYPE {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CERT_RDN_ATTR_VALUE_TYPE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CERT_RDN_ATTR_VALUE_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CERT_REVOCATION_STATUS_REASON(pub u32);
impl windows_core::TypeKind for CERT_REVOCATION_STATUS_REASON {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CERT_REVOCATION_STATUS_REASON {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CERT_REVOCATION_STATUS_REASON").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CERT_ROOT_PROGRAM_FLAGS(pub u32);
impl windows_core::TypeKind for CERT_ROOT_PROGRAM_FLAGS {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CERT_ROOT_PROGRAM_FLAGS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CERT_ROOT_PROGRAM_FLAGS").field(&self.0).finish()
    }
}
impl CERT_ROOT_PROGRAM_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for CERT_ROOT_PROGRAM_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for CERT_ROOT_PROGRAM_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for CERT_ROOT_PROGRAM_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for CERT_ROOT_PROGRAM_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for CERT_ROOT_PROGRAM_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CERT_SELECT_CRITERIA_TYPE(pub u32);
impl windows_core::TypeKind for CERT_SELECT_CRITERIA_TYPE {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CERT_SELECT_CRITERIA_TYPE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CERT_SELECT_CRITERIA_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CERT_STORE_PROV_FLAGS(pub u32);
impl windows_core::TypeKind for CERT_STORE_PROV_FLAGS {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CERT_STORE_PROV_FLAGS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CERT_STORE_PROV_FLAGS").field(&self.0).finish()
    }
}
impl CERT_STORE_PROV_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for CERT_STORE_PROV_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for CERT_STORE_PROV_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for CERT_STORE_PROV_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for CERT_STORE_PROV_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for CERT_STORE_PROV_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CERT_STORE_SAVE_AS(pub u32);
impl windows_core::TypeKind for CERT_STORE_SAVE_AS {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CERT_STORE_SAVE_AS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CERT_STORE_SAVE_AS").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CERT_STORE_SAVE_TO(pub u32);
impl windows_core::TypeKind for CERT_STORE_SAVE_TO {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CERT_STORE_SAVE_TO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CERT_STORE_SAVE_TO").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CERT_STRING_TYPE(pub u32);
impl windows_core::TypeKind for CERT_STRING_TYPE {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CERT_STRING_TYPE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CERT_STRING_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CERT_STRONG_SIGN_FLAGS(pub u32);
impl windows_core::TypeKind for CERT_STRONG_SIGN_FLAGS {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CERT_STRONG_SIGN_FLAGS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CERT_STRONG_SIGN_FLAGS").field(&self.0).finish()
    }
}
impl CERT_STRONG_SIGN_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for CERT_STRONG_SIGN_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for CERT_STRONG_SIGN_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for CERT_STRONG_SIGN_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for CERT_STRONG_SIGN_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for CERT_STRONG_SIGN_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CERT_SYSTEM_STORE_FLAGS(pub u32);
impl windows_core::TypeKind for CERT_SYSTEM_STORE_FLAGS {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CERT_SYSTEM_STORE_FLAGS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CERT_SYSTEM_STORE_FLAGS").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CESSetupProperty(pub i32);
impl windows_core::TypeKind for CESSetupProperty {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CESSetupProperty {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CESSetupProperty").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CMSG_KEY_AGREE_OPTION(pub u32);
impl windows_core::TypeKind for CMSG_KEY_AGREE_OPTION {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CMSG_KEY_AGREE_OPTION {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CMSG_KEY_AGREE_OPTION").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CMSG_KEY_AGREE_ORIGINATOR(pub u32);
impl windows_core::TypeKind for CMSG_KEY_AGREE_ORIGINATOR {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CMSG_KEY_AGREE_ORIGINATOR {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CMSG_KEY_AGREE_ORIGINATOR").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CRYPT_ACQUIRE_FLAGS(pub u32);
impl windows_core::TypeKind for CRYPT_ACQUIRE_FLAGS {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CRYPT_ACQUIRE_FLAGS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CRYPT_ACQUIRE_FLAGS").field(&self.0).finish()
    }
}
impl CRYPT_ACQUIRE_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for CRYPT_ACQUIRE_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for CRYPT_ACQUIRE_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for CRYPT_ACQUIRE_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for CRYPT_ACQUIRE_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for CRYPT_ACQUIRE_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CRYPT_CONTEXT_CONFIG_FLAGS(pub u32);
impl windows_core::TypeKind for CRYPT_CONTEXT_CONFIG_FLAGS {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CRYPT_CONTEXT_CONFIG_FLAGS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CRYPT_CONTEXT_CONFIG_FLAGS").field(&self.0).finish()
    }
}
impl CRYPT_CONTEXT_CONFIG_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for CRYPT_CONTEXT_CONFIG_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for CRYPT_CONTEXT_CONFIG_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for CRYPT_CONTEXT_CONFIG_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for CRYPT_CONTEXT_CONFIG_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for CRYPT_CONTEXT_CONFIG_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CRYPT_DEFAULT_CONTEXT_FLAGS(pub u32);
impl windows_core::TypeKind for CRYPT_DEFAULT_CONTEXT_FLAGS {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CRYPT_DEFAULT_CONTEXT_FLAGS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CRYPT_DEFAULT_CONTEXT_FLAGS").field(&self.0).finish()
    }
}
impl CRYPT_DEFAULT_CONTEXT_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for CRYPT_DEFAULT_CONTEXT_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for CRYPT_DEFAULT_CONTEXT_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for CRYPT_DEFAULT_CONTEXT_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for CRYPT_DEFAULT_CONTEXT_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for CRYPT_DEFAULT_CONTEXT_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CRYPT_DEFAULT_CONTEXT_TYPE(pub u32);
impl windows_core::TypeKind for CRYPT_DEFAULT_CONTEXT_TYPE {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CRYPT_DEFAULT_CONTEXT_TYPE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CRYPT_DEFAULT_CONTEXT_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CRYPT_ENCODE_OBJECT_FLAGS(pub u32);
impl windows_core::TypeKind for CRYPT_ENCODE_OBJECT_FLAGS {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CRYPT_ENCODE_OBJECT_FLAGS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CRYPT_ENCODE_OBJECT_FLAGS").field(&self.0).finish()
    }
}
impl CRYPT_ENCODE_OBJECT_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for CRYPT_ENCODE_OBJECT_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for CRYPT_ENCODE_OBJECT_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for CRYPT_ENCODE_OBJECT_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for CRYPT_ENCODE_OBJECT_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for CRYPT_ENCODE_OBJECT_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CRYPT_FIND_FLAGS(pub u32);
impl windows_core::TypeKind for CRYPT_FIND_FLAGS {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CRYPT_FIND_FLAGS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CRYPT_FIND_FLAGS").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CRYPT_GET_URL_FLAGS(pub u32);
impl windows_core::TypeKind for CRYPT_GET_URL_FLAGS {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CRYPT_GET_URL_FLAGS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CRYPT_GET_URL_FLAGS").field(&self.0).finish()
    }
}
impl CRYPT_GET_URL_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for CRYPT_GET_URL_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for CRYPT_GET_URL_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for CRYPT_GET_URL_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for CRYPT_GET_URL_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for CRYPT_GET_URL_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CRYPT_IMAGE_REF_FLAGS(pub u32);
impl windows_core::TypeKind for CRYPT_IMAGE_REF_FLAGS {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CRYPT_IMAGE_REF_FLAGS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CRYPT_IMAGE_REF_FLAGS").field(&self.0).finish()
    }
}
impl CRYPT_IMAGE_REF_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for CRYPT_IMAGE_REF_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for CRYPT_IMAGE_REF_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for CRYPT_IMAGE_REF_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for CRYPT_IMAGE_REF_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for CRYPT_IMAGE_REF_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CRYPT_IMPORT_PUBLIC_KEY_FLAGS(pub u32);
impl windows_core::TypeKind for CRYPT_IMPORT_PUBLIC_KEY_FLAGS {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CRYPT_IMPORT_PUBLIC_KEY_FLAGS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CRYPT_IMPORT_PUBLIC_KEY_FLAGS").field(&self.0).finish()
    }
}
impl CRYPT_IMPORT_PUBLIC_KEY_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for CRYPT_IMPORT_PUBLIC_KEY_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for CRYPT_IMPORT_PUBLIC_KEY_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for CRYPT_IMPORT_PUBLIC_KEY_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for CRYPT_IMPORT_PUBLIC_KEY_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for CRYPT_IMPORT_PUBLIC_KEY_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CRYPT_KEY_FLAGS(pub u32);
impl windows_core::TypeKind for CRYPT_KEY_FLAGS {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CRYPT_KEY_FLAGS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CRYPT_KEY_FLAGS").field(&self.0).finish()
    }
}
impl CRYPT_KEY_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for CRYPT_KEY_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for CRYPT_KEY_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for CRYPT_KEY_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for CRYPT_KEY_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for CRYPT_KEY_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CRYPT_KEY_PARAM_ID(pub u32);
impl windows_core::TypeKind for CRYPT_KEY_PARAM_ID {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CRYPT_KEY_PARAM_ID {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CRYPT_KEY_PARAM_ID").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CRYPT_MSG_TYPE(pub u32);
impl windows_core::TypeKind for CRYPT_MSG_TYPE {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CRYPT_MSG_TYPE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CRYPT_MSG_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CRYPT_OBJECT_LOCATOR_RELEASE_REASON(pub u32);
impl windows_core::TypeKind for CRYPT_OBJECT_LOCATOR_RELEASE_REASON {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CRYPT_OBJECT_LOCATOR_RELEASE_REASON {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CRYPT_OBJECT_LOCATOR_RELEASE_REASON").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CRYPT_SET_HASH_PARAM(pub u32);
impl windows_core::TypeKind for CRYPT_SET_HASH_PARAM {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CRYPT_SET_HASH_PARAM {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CRYPT_SET_HASH_PARAM").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CRYPT_SET_PROV_PARAM_ID(pub u32);
impl windows_core::TypeKind for CRYPT_SET_PROV_PARAM_ID {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CRYPT_SET_PROV_PARAM_ID {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CRYPT_SET_PROV_PARAM_ID").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CRYPT_STRING(pub u32);
impl windows_core::TypeKind for CRYPT_STRING {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CRYPT_STRING {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CRYPT_STRING").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CRYPT_TIMESTAMP_RESPONSE_STATUS(pub u32);
impl windows_core::TypeKind for CRYPT_TIMESTAMP_RESPONSE_STATUS {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CRYPT_TIMESTAMP_RESPONSE_STATUS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CRYPT_TIMESTAMP_RESPONSE_STATUS").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CRYPT_TIMESTAMP_VERSION(pub u32);
impl windows_core::TypeKind for CRYPT_TIMESTAMP_VERSION {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CRYPT_TIMESTAMP_VERSION {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CRYPT_TIMESTAMP_VERSION").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CRYPT_VERIFY_CERT_FLAGS(pub u32);
impl windows_core::TypeKind for CRYPT_VERIFY_CERT_FLAGS {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CRYPT_VERIFY_CERT_FLAGS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CRYPT_VERIFY_CERT_FLAGS").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CRYPT_XML_CHARSET(pub i32);
impl windows_core::TypeKind for CRYPT_XML_CHARSET {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CRYPT_XML_CHARSET {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CRYPT_XML_CHARSET").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CRYPT_XML_FLAGS(pub u32);
impl windows_core::TypeKind for CRYPT_XML_FLAGS {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CRYPT_XML_FLAGS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CRYPT_XML_FLAGS").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CRYPT_XML_GROUP_ID(pub u32);
impl windows_core::TypeKind for CRYPT_XML_GROUP_ID {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CRYPT_XML_GROUP_ID {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CRYPT_XML_GROUP_ID").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CRYPT_XML_KEYINFO_SPEC(pub i32);
impl windows_core::TypeKind for CRYPT_XML_KEYINFO_SPEC {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CRYPT_XML_KEYINFO_SPEC {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CRYPT_XML_KEYINFO_SPEC").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CRYPT_XML_KEYINFO_TYPE(pub u32);
impl windows_core::TypeKind for CRYPT_XML_KEYINFO_TYPE {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CRYPT_XML_KEYINFO_TYPE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CRYPT_XML_KEYINFO_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CRYPT_XML_KEY_VALUE_TYPE(pub u32);
impl windows_core::TypeKind for CRYPT_XML_KEY_VALUE_TYPE {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CRYPT_XML_KEY_VALUE_TYPE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CRYPT_XML_KEY_VALUE_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CRYPT_XML_PROPERTY_ID(pub i32);
impl windows_core::TypeKind for CRYPT_XML_PROPERTY_ID {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CRYPT_XML_PROPERTY_ID {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CRYPT_XML_PROPERTY_ID").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CRYPT_XML_STATUS_ERROR_STATUS(pub u32);
impl windows_core::TypeKind for CRYPT_XML_STATUS_ERROR_STATUS {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CRYPT_XML_STATUS_ERROR_STATUS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CRYPT_XML_STATUS_ERROR_STATUS").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CRYPT_XML_STATUS_INFO_STATUS(pub u32);
impl windows_core::TypeKind for CRYPT_XML_STATUS_INFO_STATUS {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CRYPT_XML_STATUS_INFO_STATUS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CRYPT_XML_STATUS_INFO_STATUS").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CRYPT_XML_TRANSFORM_FLAGS(pub u32);
impl windows_core::TypeKind for CRYPT_XML_TRANSFORM_FLAGS {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CRYPT_XML_TRANSFORM_FLAGS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CRYPT_XML_TRANSFORM_FLAGS").field(&self.0).finish()
    }
}
impl CRYPT_XML_TRANSFORM_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for CRYPT_XML_TRANSFORM_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for CRYPT_XML_TRANSFORM_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for CRYPT_XML_TRANSFORM_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for CRYPT_XML_TRANSFORM_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for CRYPT_XML_TRANSFORM_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CRYPT_XML_X509DATA_TYPE(pub u32);
impl windows_core::TypeKind for CRYPT_XML_X509DATA_TYPE {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CRYPT_XML_X509DATA_TYPE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CRYPT_XML_X509DATA_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct CertKeyType(pub u32);
impl windows_core::TypeKind for CertKeyType {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for CertKeyType {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("CertKeyType").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct DSAFIPSVERSION_ENUM(pub i32);
impl windows_core::TypeKind for DSAFIPSVERSION_ENUM {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for DSAFIPSVERSION_ENUM {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("DSAFIPSVERSION_ENUM").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct Direction(pub i32);
impl windows_core::TypeKind for Direction {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for Direction {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("Direction").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct ECC_CURVE_ALG_ID_ENUM(pub i32);
impl windows_core::TypeKind for ECC_CURVE_ALG_ID_ENUM {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for ECC_CURVE_ALG_ID_ENUM {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("ECC_CURVE_ALG_ID_ENUM").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct ECC_CURVE_TYPE_ENUM(pub i32);
impl windows_core::TypeKind for ECC_CURVE_TYPE_ENUM {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for ECC_CURVE_TYPE_ENUM {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("ECC_CURVE_TYPE_ENUM").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct HASHALGORITHM_ENUM(pub i32);
impl windows_core::TypeKind for HASHALGORITHM_ENUM {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for HASHALGORITHM_ENUM {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("HASHALGORITHM_ENUM").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct HTTPSPOLICY_CALLBACK_DATA_AUTH_TYPE(pub u32);
impl windows_core::TypeKind for HTTPSPOLICY_CALLBACK_DATA_AUTH_TYPE {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for HTTPSPOLICY_CALLBACK_DATA_AUTH_TYPE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("HTTPSPOLICY_CALLBACK_DATA_AUTH_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct HandleType(pub i32);
impl HandleType {
    pub const Asymmetric: Self = Self(1i32);
    pub const Symmetric: Self = Self(2i32);
    pub const Transform: Self = Self(3i32);
    pub const Hash: Self = Self(4i32);
}
impl windows_core::TypeKind for HandleType {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for HandleType {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("HandleType").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct MSCEPSetupProperty(pub i32);
impl windows_core::TypeKind for MSCEPSetupProperty {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for MSCEPSetupProperty {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("MSCEPSetupProperty").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct NCRYPT_ALGORITHM_NAME_CLASS(pub u32);
impl windows_core::TypeKind for NCRYPT_ALGORITHM_NAME_CLASS {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for NCRYPT_ALGORITHM_NAME_CLASS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("NCRYPT_ALGORITHM_NAME_CLASS").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct NCRYPT_FLAGS(pub u32);
impl windows_core::TypeKind for NCRYPT_FLAGS {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for NCRYPT_FLAGS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("NCRYPT_FLAGS").field(&self.0).finish()
    }
}
impl NCRYPT_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for NCRYPT_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for NCRYPT_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for NCRYPT_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for NCRYPT_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for NCRYPT_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct NCRYPT_OPERATION(pub u32);
impl windows_core::TypeKind for NCRYPT_OPERATION {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for NCRYPT_OPERATION {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("NCRYPT_OPERATION").field(&self.0).finish()
    }
}
impl NCRYPT_OPERATION {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for NCRYPT_OPERATION {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for NCRYPT_OPERATION {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for NCRYPT_OPERATION {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for NCRYPT_OPERATION {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for NCRYPT_OPERATION {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct PaddingMode(pub i32);
impl PaddingMode {
    pub const None: Self = Self(1i32);
    pub const PKCS7: Self = Self(2i32);
    pub const Zeros: Self = Self(3i32);
    pub const ANSIX923: Self = Self(4i32);
    pub const ISO10126: Self = Self(5i32);
}
impl windows_core::TypeKind for PaddingMode {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for PaddingMode {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("PaddingMode").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct SIGNER_CERT_CHOICE(pub u32);
impl windows_core::TypeKind for SIGNER_CERT_CHOICE {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for SIGNER_CERT_CHOICE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("SIGNER_CERT_CHOICE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct SIGNER_CERT_POLICY(pub u32);
impl windows_core::TypeKind for SIGNER_CERT_POLICY {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for SIGNER_CERT_POLICY {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("SIGNER_CERT_POLICY").field(&self.0).finish()
    }
}
impl SIGNER_CERT_POLICY {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for SIGNER_CERT_POLICY {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for SIGNER_CERT_POLICY {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for SIGNER_CERT_POLICY {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for SIGNER_CERT_POLICY {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for SIGNER_CERT_POLICY {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct SIGNER_PRIVATE_KEY_CHOICE(pub u32);
impl windows_core::TypeKind for SIGNER_PRIVATE_KEY_CHOICE {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for SIGNER_PRIVATE_KEY_CHOICE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("SIGNER_PRIVATE_KEY_CHOICE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct SIGNER_SIGNATURE_ATTRIBUTE_CHOICE(pub u32);
impl windows_core::TypeKind for SIGNER_SIGNATURE_ATTRIBUTE_CHOICE {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for SIGNER_SIGNATURE_ATTRIBUTE_CHOICE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("SIGNER_SIGNATURE_ATTRIBUTE_CHOICE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct SIGNER_SIGN_FLAGS(pub u32);
impl windows_core::TypeKind for SIGNER_SIGN_FLAGS {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for SIGNER_SIGN_FLAGS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("SIGNER_SIGN_FLAGS").field(&self.0).finish()
    }
}
impl SIGNER_SIGN_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for SIGNER_SIGN_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for SIGNER_SIGN_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for SIGNER_SIGN_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for SIGNER_SIGN_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for SIGNER_SIGN_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct SIGNER_SUBJECT_CHOICE(pub u32);
impl windows_core::TypeKind for SIGNER_SUBJECT_CHOICE {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for SIGNER_SUBJECT_CHOICE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("SIGNER_SUBJECT_CHOICE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq, Copy, Clone, Default)]
pub struct SIGNER_TIMESTAMP_FLAGS(pub u32);
impl windows_core::TypeKind for SIGNER_TIMESTAMP_FLAGS {
    type TypeKind = windows_core::CopyType;
}
impl core::fmt::Debug for SIGNER_TIMESTAMP_FLAGS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("SIGNER_TIMESTAMP_FLAGS").field(&self.0).finish()
    }
}
#[repr(C)]
pub struct AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_PARA {
    pub cbSize: u32,
    pub dwRegPolicySettings: u32,
    pub pSignerInfo: *mut CMSG_SIGNER_INFO,
}
impl Copy for AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_PARA {}
impl Clone for AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_PARA {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_PARA {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_PARA").field("cbSize", &self.cbSize).field("dwRegPolicySettings", &self.dwRegPolicySettings).field("pSignerInfo", &self.pSignerInfo).finish()
    }
}
impl windows_core::TypeKind for AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_PARA {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwRegPolicySettings == other.dwRegPolicySettings && self.pSignerInfo == other.pSignerInfo
    }
}
impl Eq for AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_PARA {}
impl Default for AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_PARA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_STATUS {
    pub cbSize: u32,
    pub fCommercial: super::super::Foundation::BOOL,
}
impl Copy for AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_STATUS {}
impl Clone for AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_STATUS {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_STATUS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_STATUS").field("cbSize", &self.cbSize).field("fCommercial", &self.fCommercial).finish()
    }
}
impl windows_core::TypeKind for AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_STATUS {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_STATUS {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.fCommercial == other.fCommercial
    }
}
impl Eq for AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_STATUS {}
impl Default for AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_STATUS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct AUTHENTICODE_TS_EXTRA_CERT_CHAIN_POLICY_PARA {
    pub cbSize: u32,
    pub dwRegPolicySettings: u32,
    pub fCommercial: super::super::Foundation::BOOL,
}
impl Copy for AUTHENTICODE_TS_EXTRA_CERT_CHAIN_POLICY_PARA {}
impl Clone for AUTHENTICODE_TS_EXTRA_CERT_CHAIN_POLICY_PARA {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for AUTHENTICODE_TS_EXTRA_CERT_CHAIN_POLICY_PARA {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("AUTHENTICODE_TS_EXTRA_CERT_CHAIN_POLICY_PARA").field("cbSize", &self.cbSize).field("dwRegPolicySettings", &self.dwRegPolicySettings).field("fCommercial", &self.fCommercial).finish()
    }
}
impl windows_core::TypeKind for AUTHENTICODE_TS_EXTRA_CERT_CHAIN_POLICY_PARA {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for AUTHENTICODE_TS_EXTRA_CERT_CHAIN_POLICY_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwRegPolicySettings == other.dwRegPolicySettings && self.fCommercial == other.fCommercial
    }
}
impl Eq for AUTHENTICODE_TS_EXTRA_CERT_CHAIN_POLICY_PARA {}
impl Default for AUTHENTICODE_TS_EXTRA_CERT_CHAIN_POLICY_PARA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct BCRYPT_ALGORITHM_IDENTIFIER {
    pub pszName: windows_core::PWSTR,
    pub dwClass: u32,
    pub dwFlags: u32,
}
impl Copy for BCRYPT_ALGORITHM_IDENTIFIER {}
impl Clone for BCRYPT_ALGORITHM_IDENTIFIER {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for BCRYPT_ALGORITHM_IDENTIFIER {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("BCRYPT_ALGORITHM_IDENTIFIER").field("pszName", &self.pszName).field("dwClass", &self.dwClass).field("dwFlags", &self.dwFlags).finish()
    }
}
impl windows_core::TypeKind for BCRYPT_ALGORITHM_IDENTIFIER {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for BCRYPT_ALGORITHM_IDENTIFIER {
    fn eq(&self, other: &Self) -> bool {
        self.pszName == other.pszName && self.dwClass == other.dwClass && self.dwFlags == other.dwFlags
    }
}
impl Eq for BCRYPT_ALGORITHM_IDENTIFIER {}
impl Default for BCRYPT_ALGORITHM_IDENTIFIER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq)]
pub struct BCRYPT_ALG_HANDLE(pub *mut core::ffi::c_void);
impl BCRYPT_ALG_HANDLE {
    pub fn is_invalid(&self) -> bool {
        self.0.is_null()
    }
}
impl Default for BCRYPT_ALG_HANDLE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
impl Clone for BCRYPT_ALG_HANDLE {
    fn clone(&self) -> Self {
        *self
    }
}
impl Copy for BCRYPT_ALG_HANDLE {}
impl core::fmt::Debug for BCRYPT_ALG_HANDLE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("BCRYPT_ALG_HANDLE").field(&self.0).finish()
    }
}
impl windows_core::TypeKind for BCRYPT_ALG_HANDLE {
    type TypeKind = windows_core::CopyType;
}
impl windows_core::CanInto<BCRYPT_HANDLE> for BCRYPT_ALG_HANDLE {}
impl From<BCRYPT_ALG_HANDLE> for BCRYPT_HANDLE {
    fn from(value: BCRYPT_ALG_HANDLE) -> Self {
        Self(value.0)
    }
}
#[repr(C)]
pub struct BCRYPT_AUTHENTICATED_CIPHER_MODE_INFO {
    pub cbSize: u32,
    pub dwInfoVersion: u32,
    pub pbNonce: *mut u8,
    pub cbNonce: u32,
    pub pbAuthData: *mut u8,
    pub cbAuthData: u32,
    pub pbTag: *mut u8,
    pub cbTag: u32,
    pub pbMacContext: *mut u8,
    pub cbMacContext: u32,
    pub cbAAD: u32,
    pub cbData: u64,
    pub dwFlags: u32,
}
impl Copy for BCRYPT_AUTHENTICATED_CIPHER_MODE_INFO {}
impl Clone for BCRYPT_AUTHENTICATED_CIPHER_MODE_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for BCRYPT_AUTHENTICATED_CIPHER_MODE_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("BCRYPT_AUTHENTICATED_CIPHER_MODE_INFO")
            .field("cbSize", &self.cbSize)
            .field("dwInfoVersion", &self.dwInfoVersion)
            .field("pbNonce", &self.pbNonce)
            .field("cbNonce", &self.cbNonce)
            .field("pbAuthData", &self.pbAuthData)
            .field("cbAuthData", &self.cbAuthData)
            .field("pbTag", &self.pbTag)
            .field("cbTag", &self.cbTag)
            .field("pbMacContext", &self.pbMacContext)
            .field("cbMacContext", &self.cbMacContext)
            .field("cbAAD", &self.cbAAD)
            .field("cbData", &self.cbData)
            .field("dwFlags", &self.dwFlags)
            .finish()
    }
}
impl windows_core::TypeKind for BCRYPT_AUTHENTICATED_CIPHER_MODE_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for BCRYPT_AUTHENTICATED_CIPHER_MODE_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwInfoVersion == other.dwInfoVersion && self.pbNonce == other.pbNonce && self.cbNonce == other.cbNonce && self.pbAuthData == other.pbAuthData && self.cbAuthData == other.cbAuthData && self.pbTag == other.pbTag && self.cbTag == other.cbTag && self.pbMacContext == other.pbMacContext && self.cbMacContext == other.cbMacContext && self.cbAAD == other.cbAAD && self.cbData == other.cbData && self.dwFlags == other.dwFlags
    }
}
impl Eq for BCRYPT_AUTHENTICATED_CIPHER_MODE_INFO {}
impl Default for BCRYPT_AUTHENTICATED_CIPHER_MODE_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct BCRYPT_DH_KEY_BLOB {
    pub dwMagic: BCRYPT_DH_KEY_BLOB_MAGIC,
    pub cbKey: u32,
}
impl Copy for BCRYPT_DH_KEY_BLOB {}
impl Clone for BCRYPT_DH_KEY_BLOB {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for BCRYPT_DH_KEY_BLOB {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("BCRYPT_DH_KEY_BLOB").field("dwMagic", &self.dwMagic).field("cbKey", &self.cbKey).finish()
    }
}
impl windows_core::TypeKind for BCRYPT_DH_KEY_BLOB {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for BCRYPT_DH_KEY_BLOB {
    fn eq(&self, other: &Self) -> bool {
        self.dwMagic == other.dwMagic && self.cbKey == other.cbKey
    }
}
impl Eq for BCRYPT_DH_KEY_BLOB {}
impl Default for BCRYPT_DH_KEY_BLOB {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct BCRYPT_DH_PARAMETER_HEADER {
    pub cbLength: u32,
    pub dwMagic: u32,
    pub cbKeyLength: u32,
}
impl Copy for BCRYPT_DH_PARAMETER_HEADER {}
impl Clone for BCRYPT_DH_PARAMETER_HEADER {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for BCRYPT_DH_PARAMETER_HEADER {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("BCRYPT_DH_PARAMETER_HEADER").field("cbLength", &self.cbLength).field("dwMagic", &self.dwMagic).field("cbKeyLength", &self.cbKeyLength).finish()
    }
}
impl windows_core::TypeKind for BCRYPT_DH_PARAMETER_HEADER {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for BCRYPT_DH_PARAMETER_HEADER {
    fn eq(&self, other: &Self) -> bool {
        self.cbLength == other.cbLength && self.dwMagic == other.dwMagic && self.cbKeyLength == other.cbKeyLength
    }
}
impl Eq for BCRYPT_DH_PARAMETER_HEADER {}
impl Default for BCRYPT_DH_PARAMETER_HEADER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct BCRYPT_DSA_KEY_BLOB {
    pub dwMagic: BCRYPT_DSA_MAGIC,
    pub cbKey: u32,
    pub Count: [u8; 4],
    pub Seed: [u8; 20],
    pub q: [u8; 20],
}
impl Copy for BCRYPT_DSA_KEY_BLOB {}
impl Clone for BCRYPT_DSA_KEY_BLOB {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for BCRYPT_DSA_KEY_BLOB {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("BCRYPT_DSA_KEY_BLOB").field("dwMagic", &self.dwMagic).field("cbKey", &self.cbKey).field("Count", &self.Count).field("Seed", &self.Seed).field("q", &self.q).finish()
    }
}
impl windows_core::TypeKind for BCRYPT_DSA_KEY_BLOB {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for BCRYPT_DSA_KEY_BLOB {
    fn eq(&self, other: &Self) -> bool {
        self.dwMagic == other.dwMagic && self.cbKey == other.cbKey && self.Count == other.Count && self.Seed == other.Seed && self.q == other.q
    }
}
impl Eq for BCRYPT_DSA_KEY_BLOB {}
impl Default for BCRYPT_DSA_KEY_BLOB {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct BCRYPT_DSA_KEY_BLOB_V2 {
    pub dwMagic: BCRYPT_DSA_MAGIC,
    pub cbKey: u32,
    pub hashAlgorithm: HASHALGORITHM_ENUM,
    pub standardVersion: DSAFIPSVERSION_ENUM,
    pub cbSeedLength: u32,
    pub cbGroupSize: u32,
    pub Count: [u8; 4],
}
impl Copy for BCRYPT_DSA_KEY_BLOB_V2 {}
impl Clone for BCRYPT_DSA_KEY_BLOB_V2 {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for BCRYPT_DSA_KEY_BLOB_V2 {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("BCRYPT_DSA_KEY_BLOB_V2").field("dwMagic", &self.dwMagic).field("cbKey", &self.cbKey).field("hashAlgorithm", &self.hashAlgorithm).field("standardVersion", &self.standardVersion).field("cbSeedLength", &self.cbSeedLength).field("cbGroupSize", &self.cbGroupSize).field("Count", &self.Count).finish()
    }
}
impl windows_core::TypeKind for BCRYPT_DSA_KEY_BLOB_V2 {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for BCRYPT_DSA_KEY_BLOB_V2 {
    fn eq(&self, other: &Self) -> bool {
        self.dwMagic == other.dwMagic && self.cbKey == other.cbKey && self.hashAlgorithm == other.hashAlgorithm && self.standardVersion == other.standardVersion && self.cbSeedLength == other.cbSeedLength && self.cbGroupSize == other.cbGroupSize && self.Count == other.Count
    }
}
impl Eq for BCRYPT_DSA_KEY_BLOB_V2 {}
impl Default for BCRYPT_DSA_KEY_BLOB_V2 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct BCRYPT_DSA_PARAMETER_HEADER {
    pub cbLength: u32,
    pub dwMagic: u32,
    pub cbKeyLength: u32,
    pub Count: [u8; 4],
    pub Seed: [u8; 20],
    pub q: [u8; 20],
}
impl Copy for BCRYPT_DSA_PARAMETER_HEADER {}
impl Clone for BCRYPT_DSA_PARAMETER_HEADER {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for BCRYPT_DSA_PARAMETER_HEADER {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("BCRYPT_DSA_PARAMETER_HEADER").field("cbLength", &self.cbLength).field("dwMagic", &self.dwMagic).field("cbKeyLength", &self.cbKeyLength).field("Count", &self.Count).field("Seed", &self.Seed).field("q", &self.q).finish()
    }
}
impl windows_core::TypeKind for BCRYPT_DSA_PARAMETER_HEADER {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for BCRYPT_DSA_PARAMETER_HEADER {
    fn eq(&self, other: &Self) -> bool {
        self.cbLength == other.cbLength && self.dwMagic == other.dwMagic && self.cbKeyLength == other.cbKeyLength && self.Count == other.Count && self.Seed == other.Seed && self.q == other.q
    }
}
impl Eq for BCRYPT_DSA_PARAMETER_HEADER {}
impl Default for BCRYPT_DSA_PARAMETER_HEADER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct BCRYPT_DSA_PARAMETER_HEADER_V2 {
    pub cbLength: u32,
    pub dwMagic: u32,
    pub cbKeyLength: u32,
    pub hashAlgorithm: HASHALGORITHM_ENUM,
    pub standardVersion: DSAFIPSVERSION_ENUM,
    pub cbSeedLength: u32,
    pub cbGroupSize: u32,
    pub Count: [u8; 4],
}
impl Copy for BCRYPT_DSA_PARAMETER_HEADER_V2 {}
impl Clone for BCRYPT_DSA_PARAMETER_HEADER_V2 {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for BCRYPT_DSA_PARAMETER_HEADER_V2 {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("BCRYPT_DSA_PARAMETER_HEADER_V2").field("cbLength", &self.cbLength).field("dwMagic", &self.dwMagic).field("cbKeyLength", &self.cbKeyLength).field("hashAlgorithm", &self.hashAlgorithm).field("standardVersion", &self.standardVersion).field("cbSeedLength", &self.cbSeedLength).field("cbGroupSize", &self.cbGroupSize).field("Count", &self.Count).finish()
    }
}
impl windows_core::TypeKind for BCRYPT_DSA_PARAMETER_HEADER_V2 {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for BCRYPT_DSA_PARAMETER_HEADER_V2 {
    fn eq(&self, other: &Self) -> bool {
        self.cbLength == other.cbLength && self.dwMagic == other.dwMagic && self.cbKeyLength == other.cbKeyLength && self.hashAlgorithm == other.hashAlgorithm && self.standardVersion == other.standardVersion && self.cbSeedLength == other.cbSeedLength && self.cbGroupSize == other.cbGroupSize && self.Count == other.Count
    }
}
impl Eq for BCRYPT_DSA_PARAMETER_HEADER_V2 {}
impl Default for BCRYPT_DSA_PARAMETER_HEADER_V2 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct BCRYPT_ECCFULLKEY_BLOB {
    pub dwMagic: u32,
    pub dwVersion: u32,
    pub dwCurveType: ECC_CURVE_TYPE_ENUM,
    pub dwCurveGenerationAlgId: ECC_CURVE_ALG_ID_ENUM,
    pub cbFieldLength: u32,
    pub cbSubgroupOrder: u32,
    pub cbCofactor: u32,
    pub cbSeed: u32,
}
impl Copy for BCRYPT_ECCFULLKEY_BLOB {}
impl Clone for BCRYPT_ECCFULLKEY_BLOB {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for BCRYPT_ECCFULLKEY_BLOB {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("BCRYPT_ECCFULLKEY_BLOB").field("dwMagic", &self.dwMagic).field("dwVersion", &self.dwVersion).field("dwCurveType", &self.dwCurveType).field("dwCurveGenerationAlgId", &self.dwCurveGenerationAlgId).field("cbFieldLength", &self.cbFieldLength).field("cbSubgroupOrder", &self.cbSubgroupOrder).field("cbCofactor", &self.cbCofactor).field("cbSeed", &self.cbSeed).finish()
    }
}
impl windows_core::TypeKind for BCRYPT_ECCFULLKEY_BLOB {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for BCRYPT_ECCFULLKEY_BLOB {
    fn eq(&self, other: &Self) -> bool {
        self.dwMagic == other.dwMagic && self.dwVersion == other.dwVersion && self.dwCurveType == other.dwCurveType && self.dwCurveGenerationAlgId == other.dwCurveGenerationAlgId && self.cbFieldLength == other.cbFieldLength && self.cbSubgroupOrder == other.cbSubgroupOrder && self.cbCofactor == other.cbCofactor && self.cbSeed == other.cbSeed
    }
}
impl Eq for BCRYPT_ECCFULLKEY_BLOB {}
impl Default for BCRYPT_ECCFULLKEY_BLOB {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct BCRYPT_ECCKEY_BLOB {
    pub dwMagic: u32,
    pub cbKey: u32,
}
impl Copy for BCRYPT_ECCKEY_BLOB {}
impl Clone for BCRYPT_ECCKEY_BLOB {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for BCRYPT_ECCKEY_BLOB {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("BCRYPT_ECCKEY_BLOB").field("dwMagic", &self.dwMagic).field("cbKey", &self.cbKey).finish()
    }
}
impl windows_core::TypeKind for BCRYPT_ECCKEY_BLOB {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for BCRYPT_ECCKEY_BLOB {
    fn eq(&self, other: &Self) -> bool {
        self.dwMagic == other.dwMagic && self.cbKey == other.cbKey
    }
}
impl Eq for BCRYPT_ECCKEY_BLOB {}
impl Default for BCRYPT_ECCKEY_BLOB {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct BCRYPT_ECC_CURVE_NAMES {
    pub dwEccCurveNames: u32,
    pub pEccCurveNames: *mut windows_core::PWSTR,
}
impl Copy for BCRYPT_ECC_CURVE_NAMES {}
impl Clone for BCRYPT_ECC_CURVE_NAMES {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for BCRYPT_ECC_CURVE_NAMES {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("BCRYPT_ECC_CURVE_NAMES").field("dwEccCurveNames", &self.dwEccCurveNames).field("pEccCurveNames", &self.pEccCurveNames).finish()
    }
}
impl windows_core::TypeKind for BCRYPT_ECC_CURVE_NAMES {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for BCRYPT_ECC_CURVE_NAMES {
    fn eq(&self, other: &Self) -> bool {
        self.dwEccCurveNames == other.dwEccCurveNames && self.pEccCurveNames == other.pEccCurveNames
    }
}
impl Eq for BCRYPT_ECC_CURVE_NAMES {}
impl Default for BCRYPT_ECC_CURVE_NAMES {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq)]
pub struct BCRYPT_HANDLE(pub *mut core::ffi::c_void);
impl BCRYPT_HANDLE {
    pub fn is_invalid(&self) -> bool {
        self.0.is_null()
    }
}
impl Default for BCRYPT_HANDLE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
impl Clone for BCRYPT_HANDLE {
    fn clone(&self) -> Self {
        *self
    }
}
impl Copy for BCRYPT_HANDLE {}
impl core::fmt::Debug for BCRYPT_HANDLE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("BCRYPT_HANDLE").field(&self.0).finish()
    }
}
impl windows_core::TypeKind for BCRYPT_HANDLE {
    type TypeKind = windows_core::CopyType;
}
#[repr(transparent)]
#[derive(PartialEq, Eq)]
pub struct BCRYPT_HASH_HANDLE(pub *mut core::ffi::c_void);
impl BCRYPT_HASH_HANDLE {
    pub fn is_invalid(&self) -> bool {
        self.0.is_null()
    }
}
impl Default for BCRYPT_HASH_HANDLE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
impl Clone for BCRYPT_HASH_HANDLE {
    fn clone(&self) -> Self {
        *self
    }
}
impl Copy for BCRYPT_HASH_HANDLE {}
impl core::fmt::Debug for BCRYPT_HASH_HANDLE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("BCRYPT_HASH_HANDLE").field(&self.0).finish()
    }
}
impl windows_core::TypeKind for BCRYPT_HASH_HANDLE {
    type TypeKind = windows_core::CopyType;
}
impl windows_core::CanInto<BCRYPT_HANDLE> for BCRYPT_HASH_HANDLE {}
impl From<BCRYPT_HASH_HANDLE> for BCRYPT_HANDLE {
    fn from(value: BCRYPT_HASH_HANDLE) -> Self {
        Self(value.0)
    }
}
#[repr(C)]
pub struct BCRYPT_INTERFACE_VERSION {
    pub MajorVersion: u16,
    pub MinorVersion: u16,
}
impl Copy for BCRYPT_INTERFACE_VERSION {}
impl Clone for BCRYPT_INTERFACE_VERSION {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for BCRYPT_INTERFACE_VERSION {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("BCRYPT_INTERFACE_VERSION").field("MajorVersion", &self.MajorVersion).field("MinorVersion", &self.MinorVersion).finish()
    }
}
impl windows_core::TypeKind for BCRYPT_INTERFACE_VERSION {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for BCRYPT_INTERFACE_VERSION {
    fn eq(&self, other: &Self) -> bool {
        self.MajorVersion == other.MajorVersion && self.MinorVersion == other.MinorVersion
    }
}
impl Eq for BCRYPT_INTERFACE_VERSION {}
impl Default for BCRYPT_INTERFACE_VERSION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct BCRYPT_KEY_BLOB {
    pub Magic: u32,
}
impl Copy for BCRYPT_KEY_BLOB {}
impl Clone for BCRYPT_KEY_BLOB {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for BCRYPT_KEY_BLOB {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("BCRYPT_KEY_BLOB").field("Magic", &self.Magic).finish()
    }
}
impl windows_core::TypeKind for BCRYPT_KEY_BLOB {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for BCRYPT_KEY_BLOB {
    fn eq(&self, other: &Self) -> bool {
        self.Magic == other.Magic
    }
}
impl Eq for BCRYPT_KEY_BLOB {}
impl Default for BCRYPT_KEY_BLOB {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct BCRYPT_KEY_DATA_BLOB_HEADER {
    pub dwMagic: u32,
    pub dwVersion: u32,
    pub cbKeyData: u32,
}
impl Copy for BCRYPT_KEY_DATA_BLOB_HEADER {}
impl Clone for BCRYPT_KEY_DATA_BLOB_HEADER {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for BCRYPT_KEY_DATA_BLOB_HEADER {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("BCRYPT_KEY_DATA_BLOB_HEADER").field("dwMagic", &self.dwMagic).field("dwVersion", &self.dwVersion).field("cbKeyData", &self.cbKeyData).finish()
    }
}
impl windows_core::TypeKind for BCRYPT_KEY_DATA_BLOB_HEADER {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for BCRYPT_KEY_DATA_BLOB_HEADER {
    fn eq(&self, other: &Self) -> bool {
        self.dwMagic == other.dwMagic && self.dwVersion == other.dwVersion && self.cbKeyData == other.cbKeyData
    }
}
impl Eq for BCRYPT_KEY_DATA_BLOB_HEADER {}
impl Default for BCRYPT_KEY_DATA_BLOB_HEADER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq)]
pub struct BCRYPT_KEY_HANDLE(pub *mut core::ffi::c_void);
impl BCRYPT_KEY_HANDLE {
    pub fn is_invalid(&self) -> bool {
        self.0.is_null()
    }
}
impl Default for BCRYPT_KEY_HANDLE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
impl Clone for BCRYPT_KEY_HANDLE {
    fn clone(&self) -> Self {
        *self
    }
}
impl Copy for BCRYPT_KEY_HANDLE {}
impl core::fmt::Debug for BCRYPT_KEY_HANDLE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("BCRYPT_KEY_HANDLE").field(&self.0).finish()
    }
}
impl windows_core::TypeKind for BCRYPT_KEY_HANDLE {
    type TypeKind = windows_core::CopyType;
}
impl windows_core::CanInto<BCRYPT_HANDLE> for BCRYPT_KEY_HANDLE {}
impl From<BCRYPT_KEY_HANDLE> for BCRYPT_HANDLE {
    fn from(value: BCRYPT_KEY_HANDLE) -> Self {
        Self(value.0)
    }
}
#[repr(C)]
pub struct BCRYPT_KEY_LENGTHS_STRUCT {
    pub dwMinLength: u32,
    pub dwMaxLength: u32,
    pub dwIncrement: u32,
}
impl Copy for BCRYPT_KEY_LENGTHS_STRUCT {}
impl Clone for BCRYPT_KEY_LENGTHS_STRUCT {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for BCRYPT_KEY_LENGTHS_STRUCT {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("BCRYPT_KEY_LENGTHS_STRUCT").field("dwMinLength", &self.dwMinLength).field("dwMaxLength", &self.dwMaxLength).field("dwIncrement", &self.dwIncrement).finish()
    }
}
impl windows_core::TypeKind for BCRYPT_KEY_LENGTHS_STRUCT {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for BCRYPT_KEY_LENGTHS_STRUCT {
    fn eq(&self, other: &Self) -> bool {
        self.dwMinLength == other.dwMinLength && self.dwMaxLength == other.dwMaxLength && self.dwIncrement == other.dwIncrement
    }
}
impl Eq for BCRYPT_KEY_LENGTHS_STRUCT {}
impl Default for BCRYPT_KEY_LENGTHS_STRUCT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct BCRYPT_MULTI_HASH_OPERATION {
    pub iHash: u32,
    pub hashOperation: BCRYPT_HASH_OPERATION_TYPE,
    pub pbBuffer: *mut u8,
    pub cbBuffer: u32,
}
impl Copy for BCRYPT_MULTI_HASH_OPERATION {}
impl Clone for BCRYPT_MULTI_HASH_OPERATION {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for BCRYPT_MULTI_HASH_OPERATION {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("BCRYPT_MULTI_HASH_OPERATION").field("iHash", &self.iHash).field("hashOperation", &self.hashOperation).field("pbBuffer", &self.pbBuffer).field("cbBuffer", &self.cbBuffer).finish()
    }
}
impl windows_core::TypeKind for BCRYPT_MULTI_HASH_OPERATION {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for BCRYPT_MULTI_HASH_OPERATION {
    fn eq(&self, other: &Self) -> bool {
        self.iHash == other.iHash && self.hashOperation == other.hashOperation && self.pbBuffer == other.pbBuffer && self.cbBuffer == other.cbBuffer
    }
}
impl Eq for BCRYPT_MULTI_HASH_OPERATION {}
impl Default for BCRYPT_MULTI_HASH_OPERATION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct BCRYPT_MULTI_OBJECT_LENGTH_STRUCT {
    pub cbPerObject: u32,
    pub cbPerElement: u32,
}
impl Copy for BCRYPT_MULTI_OBJECT_LENGTH_STRUCT {}
impl Clone for BCRYPT_MULTI_OBJECT_LENGTH_STRUCT {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for BCRYPT_MULTI_OBJECT_LENGTH_STRUCT {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("BCRYPT_MULTI_OBJECT_LENGTH_STRUCT").field("cbPerObject", &self.cbPerObject).field("cbPerElement", &self.cbPerElement).finish()
    }
}
impl windows_core::TypeKind for BCRYPT_MULTI_OBJECT_LENGTH_STRUCT {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for BCRYPT_MULTI_OBJECT_LENGTH_STRUCT {
    fn eq(&self, other: &Self) -> bool {
        self.cbPerObject == other.cbPerObject && self.cbPerElement == other.cbPerElement
    }
}
impl Eq for BCRYPT_MULTI_OBJECT_LENGTH_STRUCT {}
impl Default for BCRYPT_MULTI_OBJECT_LENGTH_STRUCT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct BCRYPT_OAEP_PADDING_INFO {
    pub pszAlgId: windows_core::PCWSTR,
    pub pbLabel: *mut u8,
    pub cbLabel: u32,
}
impl Copy for BCRYPT_OAEP_PADDING_INFO {}
impl Clone for BCRYPT_OAEP_PADDING_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for BCRYPT_OAEP_PADDING_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("BCRYPT_OAEP_PADDING_INFO").field("pszAlgId", &self.pszAlgId).field("pbLabel", &self.pbLabel).field("cbLabel", &self.cbLabel).finish()
    }
}
impl windows_core::TypeKind for BCRYPT_OAEP_PADDING_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for BCRYPT_OAEP_PADDING_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.pszAlgId == other.pszAlgId && self.pbLabel == other.pbLabel && self.cbLabel == other.cbLabel
    }
}
impl Eq for BCRYPT_OAEP_PADDING_INFO {}
impl Default for BCRYPT_OAEP_PADDING_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct BCRYPT_OID {
    pub cbOID: u32,
    pub pbOID: *mut u8,
}
impl Copy for BCRYPT_OID {}
impl Clone for BCRYPT_OID {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for BCRYPT_OID {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("BCRYPT_OID").field("cbOID", &self.cbOID).field("pbOID", &self.pbOID).finish()
    }
}
impl windows_core::TypeKind for BCRYPT_OID {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for BCRYPT_OID {
    fn eq(&self, other: &Self) -> bool {
        self.cbOID == other.cbOID && self.pbOID == other.pbOID
    }
}
impl Eq for BCRYPT_OID {}
impl Default for BCRYPT_OID {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct BCRYPT_OID_LIST {
    pub dwOIDCount: u32,
    pub pOIDs: *mut BCRYPT_OID,
}
impl Copy for BCRYPT_OID_LIST {}
impl Clone for BCRYPT_OID_LIST {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for BCRYPT_OID_LIST {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("BCRYPT_OID_LIST").field("dwOIDCount", &self.dwOIDCount).field("pOIDs", &self.pOIDs).finish()
    }
}
impl windows_core::TypeKind for BCRYPT_OID_LIST {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for BCRYPT_OID_LIST {
    fn eq(&self, other: &Self) -> bool {
        self.dwOIDCount == other.dwOIDCount && self.pOIDs == other.pOIDs
    }
}
impl Eq for BCRYPT_OID_LIST {}
impl Default for BCRYPT_OID_LIST {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct BCRYPT_PKCS1_PADDING_INFO {
    pub pszAlgId: windows_core::PCWSTR,
}
impl Copy for BCRYPT_PKCS1_PADDING_INFO {}
impl Clone for BCRYPT_PKCS1_PADDING_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for BCRYPT_PKCS1_PADDING_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("BCRYPT_PKCS1_PADDING_INFO").field("pszAlgId", &self.pszAlgId).finish()
    }
}
impl windows_core::TypeKind for BCRYPT_PKCS1_PADDING_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for BCRYPT_PKCS1_PADDING_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.pszAlgId == other.pszAlgId
    }
}
impl Eq for BCRYPT_PKCS1_PADDING_INFO {}
impl Default for BCRYPT_PKCS1_PADDING_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct BCRYPT_PROVIDER_NAME {
    pub pszProviderName: windows_core::PWSTR,
}
impl Copy for BCRYPT_PROVIDER_NAME {}
impl Clone for BCRYPT_PROVIDER_NAME {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for BCRYPT_PROVIDER_NAME {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("BCRYPT_PROVIDER_NAME").field("pszProviderName", &self.pszProviderName).finish()
    }
}
impl windows_core::TypeKind for BCRYPT_PROVIDER_NAME {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for BCRYPT_PROVIDER_NAME {
    fn eq(&self, other: &Self) -> bool {
        self.pszProviderName == other.pszProviderName
    }
}
impl Eq for BCRYPT_PROVIDER_NAME {}
impl Default for BCRYPT_PROVIDER_NAME {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct BCRYPT_PSS_PADDING_INFO {
    pub pszAlgId: windows_core::PCWSTR,
    pub cbSalt: u32,
}
impl Copy for BCRYPT_PSS_PADDING_INFO {}
impl Clone for BCRYPT_PSS_PADDING_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for BCRYPT_PSS_PADDING_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("BCRYPT_PSS_PADDING_INFO").field("pszAlgId", &self.pszAlgId).field("cbSalt", &self.cbSalt).finish()
    }
}
impl windows_core::TypeKind for BCRYPT_PSS_PADDING_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for BCRYPT_PSS_PADDING_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.pszAlgId == other.pszAlgId && self.cbSalt == other.cbSalt
    }
}
impl Eq for BCRYPT_PSS_PADDING_INFO {}
impl Default for BCRYPT_PSS_PADDING_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct BCRYPT_RSAKEY_BLOB {
    pub Magic: BCRYPT_RSAKEY_BLOB_MAGIC,
    pub BitLength: u32,
    pub cbPublicExp: u32,
    pub cbModulus: u32,
    pub cbPrime1: u32,
    pub cbPrime2: u32,
}
impl Copy for BCRYPT_RSAKEY_BLOB {}
impl Clone for BCRYPT_RSAKEY_BLOB {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for BCRYPT_RSAKEY_BLOB {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("BCRYPT_RSAKEY_BLOB").field("Magic", &self.Magic).field("BitLength", &self.BitLength).field("cbPublicExp", &self.cbPublicExp).field("cbModulus", &self.cbModulus).field("cbPrime1", &self.cbPrime1).field("cbPrime2", &self.cbPrime2).finish()
    }
}
impl windows_core::TypeKind for BCRYPT_RSAKEY_BLOB {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for BCRYPT_RSAKEY_BLOB {
    fn eq(&self, other: &Self) -> bool {
        self.Magic == other.Magic && self.BitLength == other.BitLength && self.cbPublicExp == other.cbPublicExp && self.cbModulus == other.cbModulus && self.cbPrime1 == other.cbPrime1 && self.cbPrime2 == other.cbPrime2
    }
}
impl Eq for BCRYPT_RSAKEY_BLOB {}
impl Default for BCRYPT_RSAKEY_BLOB {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(PartialEq, Eq)]
pub struct BCRYPT_SECRET_HANDLE(pub *mut core::ffi::c_void);
impl BCRYPT_SECRET_HANDLE {
    pub fn is_invalid(&self) -> bool {
        self.0.is_null()
    }
}
impl Default for BCRYPT_SECRET_HANDLE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
impl Clone for BCRYPT_SECRET_HANDLE {
    fn clone(&self) -> Self {
        *self
    }
}
impl Copy for BCRYPT_SECRET_HANDLE {}
impl core::fmt::Debug for BCRYPT_SECRET_HANDLE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_tuple("BCRYPT_SECRET_HANDLE").field(&self.0).finish()
    }
}
impl windows_core::TypeKind for BCRYPT_SECRET_HANDLE {
    type TypeKind = windows_core::CopyType;
}
impl windows_core::CanInto<BCRYPT_HANDLE> for BCRYPT_SECRET_HANDLE {}
impl From<BCRYPT_SECRET_HANDLE> for BCRYPT_HANDLE {
    fn from(value: BCRYPT_SECRET_HANDLE) -> Self {
        Self(value.0)
    }
}
#[repr(C)]
pub struct BCryptBuffer {
    pub cbBuffer: u32,
    pub BufferType: u32,
    pub pvBuffer: *mut core::ffi::c_void,
}
impl Copy for BCryptBuffer {}
impl Clone for BCryptBuffer {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for BCryptBuffer {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("BCryptBuffer").field("cbBuffer", &self.cbBuffer).field("BufferType", &self.BufferType).field("pvBuffer", &self.pvBuffer).finish()
    }
}
impl windows_core::TypeKind for BCryptBuffer {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for BCryptBuffer {
    fn eq(&self, other: &Self) -> bool {
        self.cbBuffer == other.cbBuffer && self.BufferType == other.BufferType && self.pvBuffer == other.pvBuffer
    }
}
impl Eq for BCryptBuffer {}
impl Default for BCryptBuffer {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct BCryptBufferDesc {
    pub ulVersion: u32,
    pub cBuffers: u32,
    pub pBuffers: *mut BCryptBuffer,
}
impl Copy for BCryptBufferDesc {}
impl Clone for BCryptBufferDesc {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for BCryptBufferDesc {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("BCryptBufferDesc").field("ulVersion", &self.ulVersion).field("cBuffers", &self.cBuffers).field("pBuffers", &self.pBuffers).finish()
    }
}
impl windows_core::TypeKind for BCryptBufferDesc {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for BCryptBufferDesc {
    fn eq(&self, other: &Self) -> bool {
        self.ulVersion == other.ulVersion && self.cBuffers == other.cBuffers && self.pBuffers == other.pBuffers
    }
}
impl Eq for BCryptBufferDesc {}
impl Default for BCryptBufferDesc {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const CCertSrvSetup: windows_core::GUID = windows_core::GUID::from_u128(0x961f180f_f55c_413d_a9b3_7d2af4d8e42f);
pub const CCertSrvSetupKeyInformation: windows_core::GUID = windows_core::GUID::from_u128(0x38373906_5433_4633_b0fb_29b7e78262e1);
pub const CCertificateEnrollmentPolicyServerSetup: windows_core::GUID = windows_core::GUID::from_u128(0xafe2fa32_41b1_459d_a5de_49add8a72182);
pub const CCertificateEnrollmentServerSetup: windows_core::GUID = windows_core::GUID::from_u128(0x9902f3bc_88af_4cf8_ae62_7140531552b6);
#[repr(C)]
pub struct CERTIFICATE_CHAIN_BLOB {
    pub certCount: u32,
    pub rawCertificates: *mut CRYPT_INTEGER_BLOB,
}
impl Copy for CERTIFICATE_CHAIN_BLOB {}
impl Clone for CERTIFICATE_CHAIN_BLOB {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERTIFICATE_CHAIN_BLOB {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERTIFICATE_CHAIN_BLOB").field("certCount", &self.certCount).field("rawCertificates", &self.rawCertificates).finish()
    }
}
impl windows_core::TypeKind for CERTIFICATE_CHAIN_BLOB {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERTIFICATE_CHAIN_BLOB {
    fn eq(&self, other: &Self) -> bool {
        self.certCount == other.certCount && self.rawCertificates == other.rawCertificates
    }
}
impl Eq for CERTIFICATE_CHAIN_BLOB {}
impl Default for CERTIFICATE_CHAIN_BLOB {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_ACCESS_DESCRIPTION {
    pub pszAccessMethod: windows_core::PSTR,
    pub AccessLocation: CERT_ALT_NAME_ENTRY,
}
impl Copy for CERT_ACCESS_DESCRIPTION {}
impl Clone for CERT_ACCESS_DESCRIPTION {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CERT_ACCESS_DESCRIPTION {
    type TypeKind = windows_core::CopyType;
}
impl Default for CERT_ACCESS_DESCRIPTION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_ALT_NAME_ENTRY {
    pub dwAltNameChoice: u32,
    pub Anonymous: CERT_ALT_NAME_ENTRY_0,
}
impl Copy for CERT_ALT_NAME_ENTRY {}
impl Clone for CERT_ALT_NAME_ENTRY {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CERT_ALT_NAME_ENTRY {
    type TypeKind = windows_core::CopyType;
}
impl Default for CERT_ALT_NAME_ENTRY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub union CERT_ALT_NAME_ENTRY_0 {
    pub pOtherName: *mut CERT_OTHER_NAME,
    pub pwszRfc822Name: windows_core::PWSTR,
    pub pwszDNSName: windows_core::PWSTR,
    pub DirectoryName: CRYPT_INTEGER_BLOB,
    pub pwszURL: windows_core::PWSTR,
    pub IPAddress: CRYPT_INTEGER_BLOB,
    pub pszRegisteredID: windows_core::PSTR,
}
impl Copy for CERT_ALT_NAME_ENTRY_0 {}
impl Clone for CERT_ALT_NAME_ENTRY_0 {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CERT_ALT_NAME_ENTRY_0 {
    type TypeKind = windows_core::CopyType;
}
impl Default for CERT_ALT_NAME_ENTRY_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_ALT_NAME_INFO {
    pub cAltEntry: u32,
    pub rgAltEntry: *mut CERT_ALT_NAME_ENTRY,
}
impl Copy for CERT_ALT_NAME_INFO {}
impl Clone for CERT_ALT_NAME_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_ALT_NAME_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_ALT_NAME_INFO").field("cAltEntry", &self.cAltEntry).field("rgAltEntry", &self.rgAltEntry).finish()
    }
}
impl windows_core::TypeKind for CERT_ALT_NAME_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_ALT_NAME_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cAltEntry == other.cAltEntry && self.rgAltEntry == other.rgAltEntry
    }
}
impl Eq for CERT_ALT_NAME_INFO {}
impl Default for CERT_ALT_NAME_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_AUTHORITY_INFO_ACCESS {
    pub cAccDescr: u32,
    pub rgAccDescr: *mut CERT_ACCESS_DESCRIPTION,
}
impl Copy for CERT_AUTHORITY_INFO_ACCESS {}
impl Clone for CERT_AUTHORITY_INFO_ACCESS {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_AUTHORITY_INFO_ACCESS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_AUTHORITY_INFO_ACCESS").field("cAccDescr", &self.cAccDescr).field("rgAccDescr", &self.rgAccDescr).finish()
    }
}
impl windows_core::TypeKind for CERT_AUTHORITY_INFO_ACCESS {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_AUTHORITY_INFO_ACCESS {
    fn eq(&self, other: &Self) -> bool {
        self.cAccDescr == other.cAccDescr && self.rgAccDescr == other.rgAccDescr
    }
}
impl Eq for CERT_AUTHORITY_INFO_ACCESS {}
impl Default for CERT_AUTHORITY_INFO_ACCESS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_AUTHORITY_KEY_ID2_INFO {
    pub KeyId: CRYPT_INTEGER_BLOB,
    pub AuthorityCertIssuer: CERT_ALT_NAME_INFO,
    pub AuthorityCertSerialNumber: CRYPT_INTEGER_BLOB,
}
impl Copy for CERT_AUTHORITY_KEY_ID2_INFO {}
impl Clone for CERT_AUTHORITY_KEY_ID2_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_AUTHORITY_KEY_ID2_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_AUTHORITY_KEY_ID2_INFO").field("KeyId", &self.KeyId).field("AuthorityCertIssuer", &self.AuthorityCertIssuer).field("AuthorityCertSerialNumber", &self.AuthorityCertSerialNumber).finish()
    }
}
impl windows_core::TypeKind for CERT_AUTHORITY_KEY_ID2_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_AUTHORITY_KEY_ID2_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.KeyId == other.KeyId && self.AuthorityCertIssuer == other.AuthorityCertIssuer && self.AuthorityCertSerialNumber == other.AuthorityCertSerialNumber
    }
}
impl Eq for CERT_AUTHORITY_KEY_ID2_INFO {}
impl Default for CERT_AUTHORITY_KEY_ID2_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_AUTHORITY_KEY_ID_INFO {
    pub KeyId: CRYPT_INTEGER_BLOB,
    pub CertIssuer: CRYPT_INTEGER_BLOB,
    pub CertSerialNumber: CRYPT_INTEGER_BLOB,
}
impl Copy for CERT_AUTHORITY_KEY_ID_INFO {}
impl Clone for CERT_AUTHORITY_KEY_ID_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_AUTHORITY_KEY_ID_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_AUTHORITY_KEY_ID_INFO").field("KeyId", &self.KeyId).field("CertIssuer", &self.CertIssuer).field("CertSerialNumber", &self.CertSerialNumber).finish()
    }
}
impl windows_core::TypeKind for CERT_AUTHORITY_KEY_ID_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_AUTHORITY_KEY_ID_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.KeyId == other.KeyId && self.CertIssuer == other.CertIssuer && self.CertSerialNumber == other.CertSerialNumber
    }
}
impl Eq for CERT_AUTHORITY_KEY_ID_INFO {}
impl Default for CERT_AUTHORITY_KEY_ID_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_BASIC_CONSTRAINTS2_INFO {
    pub fCA: super::super::Foundation::BOOL,
    pub fPathLenConstraint: super::super::Foundation::BOOL,
    pub dwPathLenConstraint: u32,
}
impl Copy for CERT_BASIC_CONSTRAINTS2_INFO {}
impl Clone for CERT_BASIC_CONSTRAINTS2_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_BASIC_CONSTRAINTS2_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_BASIC_CONSTRAINTS2_INFO").field("fCA", &self.fCA).field("fPathLenConstraint", &self.fPathLenConstraint).field("dwPathLenConstraint", &self.dwPathLenConstraint).finish()
    }
}
impl windows_core::TypeKind for CERT_BASIC_CONSTRAINTS2_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_BASIC_CONSTRAINTS2_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.fCA == other.fCA && self.fPathLenConstraint == other.fPathLenConstraint && self.dwPathLenConstraint == other.dwPathLenConstraint
    }
}
impl Eq for CERT_BASIC_CONSTRAINTS2_INFO {}
impl Default for CERT_BASIC_CONSTRAINTS2_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_BASIC_CONSTRAINTS_INFO {
    pub SubjectType: CRYPT_BIT_BLOB,
    pub fPathLenConstraint: super::super::Foundation::BOOL,
    pub dwPathLenConstraint: u32,
    pub cSubtreesConstraint: u32,
    pub rgSubtreesConstraint: *mut CRYPT_INTEGER_BLOB,
}
impl Copy for CERT_BASIC_CONSTRAINTS_INFO {}
impl Clone for CERT_BASIC_CONSTRAINTS_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_BASIC_CONSTRAINTS_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_BASIC_CONSTRAINTS_INFO").field("SubjectType", &self.SubjectType).field("fPathLenConstraint", &self.fPathLenConstraint).field("dwPathLenConstraint", &self.dwPathLenConstraint).field("cSubtreesConstraint", &self.cSubtreesConstraint).field("rgSubtreesConstraint", &self.rgSubtreesConstraint).finish()
    }
}
impl windows_core::TypeKind for CERT_BASIC_CONSTRAINTS_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_BASIC_CONSTRAINTS_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.SubjectType == other.SubjectType && self.fPathLenConstraint == other.fPathLenConstraint && self.dwPathLenConstraint == other.dwPathLenConstraint && self.cSubtreesConstraint == other.cSubtreesConstraint && self.rgSubtreesConstraint == other.rgSubtreesConstraint
    }
}
impl Eq for CERT_BASIC_CONSTRAINTS_INFO {}
impl Default for CERT_BASIC_CONSTRAINTS_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_BIOMETRIC_DATA {
    pub dwTypeOfBiometricDataChoice: CERT_BIOMETRIC_DATA_TYPE,
    pub Anonymous: CERT_BIOMETRIC_DATA_0,
    pub HashedUrl: CERT_HASHED_URL,
}
impl Copy for CERT_BIOMETRIC_DATA {}
impl Clone for CERT_BIOMETRIC_DATA {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CERT_BIOMETRIC_DATA {
    type TypeKind = windows_core::CopyType;
}
impl Default for CERT_BIOMETRIC_DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub union CERT_BIOMETRIC_DATA_0 {
    pub dwPredefined: u32,
    pub pszObjId: windows_core::PSTR,
}
impl Copy for CERT_BIOMETRIC_DATA_0 {}
impl Clone for CERT_BIOMETRIC_DATA_0 {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CERT_BIOMETRIC_DATA_0 {
    type TypeKind = windows_core::CopyType;
}
impl Default for CERT_BIOMETRIC_DATA_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_BIOMETRIC_EXT_INFO {
    pub cBiometricData: u32,
    pub rgBiometricData: *mut CERT_BIOMETRIC_DATA,
}
impl Copy for CERT_BIOMETRIC_EXT_INFO {}
impl Clone for CERT_BIOMETRIC_EXT_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_BIOMETRIC_EXT_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_BIOMETRIC_EXT_INFO").field("cBiometricData", &self.cBiometricData).field("rgBiometricData", &self.rgBiometricData).finish()
    }
}
impl windows_core::TypeKind for CERT_BIOMETRIC_EXT_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_BIOMETRIC_EXT_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cBiometricData == other.cBiometricData && self.rgBiometricData == other.rgBiometricData
    }
}
impl Eq for CERT_BIOMETRIC_EXT_INFO {}
impl Default for CERT_BIOMETRIC_EXT_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_CHAIN {
    pub cCerts: u32,
    pub certs: *mut CRYPT_INTEGER_BLOB,
    pub keyLocatorInfo: CRYPT_KEY_PROV_INFO,
}
impl Copy for CERT_CHAIN {}
impl Clone for CERT_CHAIN {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_CHAIN {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_CHAIN").field("cCerts", &self.cCerts).field("certs", &self.certs).field("keyLocatorInfo", &self.keyLocatorInfo).finish()
    }
}
impl windows_core::TypeKind for CERT_CHAIN {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_CHAIN {
    fn eq(&self, other: &Self) -> bool {
        self.cCerts == other.cCerts && self.certs == other.certs && self.keyLocatorInfo == other.keyLocatorInfo
    }
}
impl Eq for CERT_CHAIN {}
impl Default for CERT_CHAIN {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_CHAIN_CONTEXT {
    pub cbSize: u32,
    pub TrustStatus: CERT_TRUST_STATUS,
    pub cChain: u32,
    pub rgpChain: *mut *mut CERT_SIMPLE_CHAIN,
    pub cLowerQualityChainContext: u32,
    pub rgpLowerQualityChainContext: *mut *mut CERT_CHAIN_CONTEXT,
    pub fHasRevocationFreshnessTime: super::super::Foundation::BOOL,
    pub dwRevocationFreshnessTime: u32,
    pub dwCreateFlags: u32,
    pub ChainId: windows_core::GUID,
}
impl Copy for CERT_CHAIN_CONTEXT {}
impl Clone for CERT_CHAIN_CONTEXT {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_CHAIN_CONTEXT {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_CHAIN_CONTEXT")
            .field("cbSize", &self.cbSize)
            .field("TrustStatus", &self.TrustStatus)
            .field("cChain", &self.cChain)
            .field("rgpChain", &self.rgpChain)
            .field("cLowerQualityChainContext", &self.cLowerQualityChainContext)
            .field("rgpLowerQualityChainContext", &self.rgpLowerQualityChainContext)
            .field("fHasRevocationFreshnessTime", &self.fHasRevocationFreshnessTime)
            .field("dwRevocationFreshnessTime", &self.dwRevocationFreshnessTime)
            .field("dwCreateFlags", &self.dwCreateFlags)
            .field("ChainId", &self.ChainId)
            .finish()
    }
}
impl windows_core::TypeKind for CERT_CHAIN_CONTEXT {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_CHAIN_CONTEXT {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.TrustStatus == other.TrustStatus && self.cChain == other.cChain && self.rgpChain == other.rgpChain && self.cLowerQualityChainContext == other.cLowerQualityChainContext && self.rgpLowerQualityChainContext == other.rgpLowerQualityChainContext && self.fHasRevocationFreshnessTime == other.fHasRevocationFreshnessTime && self.dwRevocationFreshnessTime == other.dwRevocationFreshnessTime && self.dwCreateFlags == other.dwCreateFlags && self.ChainId == other.ChainId
    }
}
impl Eq for CERT_CHAIN_CONTEXT {}
impl Default for CERT_CHAIN_CONTEXT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_CHAIN_ELEMENT {
    pub cbSize: u32,
    pub pCertContext: *const CERT_CONTEXT,
    pub TrustStatus: CERT_TRUST_STATUS,
    pub pRevocationInfo: *mut CERT_REVOCATION_INFO,
    pub pIssuanceUsage: *mut CTL_USAGE,
    pub pApplicationUsage: *mut CTL_USAGE,
    pub pwszExtendedErrorInfo: windows_core::PCWSTR,
}
impl Copy for CERT_CHAIN_ELEMENT {}
impl Clone for CERT_CHAIN_ELEMENT {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_CHAIN_ELEMENT {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_CHAIN_ELEMENT").field("cbSize", &self.cbSize).field("pCertContext", &self.pCertContext).field("TrustStatus", &self.TrustStatus).field("pRevocationInfo", &self.pRevocationInfo).field("pIssuanceUsage", &self.pIssuanceUsage).field("pApplicationUsage", &self.pApplicationUsage).field("pwszExtendedErrorInfo", &self.pwszExtendedErrorInfo).finish()
    }
}
impl windows_core::TypeKind for CERT_CHAIN_ELEMENT {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_CHAIN_ELEMENT {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.pCertContext == other.pCertContext && self.TrustStatus == other.TrustStatus && self.pRevocationInfo == other.pRevocationInfo && self.pIssuanceUsage == other.pIssuanceUsage && self.pApplicationUsage == other.pApplicationUsage && self.pwszExtendedErrorInfo == other.pwszExtendedErrorInfo
    }
}
impl Eq for CERT_CHAIN_ELEMENT {}
impl Default for CERT_CHAIN_ELEMENT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_CHAIN_ENGINE_CONFIG {
    pub cbSize: u32,
    pub hRestrictedRoot: HCERTSTORE,
    pub hRestrictedTrust: HCERTSTORE,
    pub hRestrictedOther: HCERTSTORE,
    pub cAdditionalStore: u32,
    pub rghAdditionalStore: *mut HCERTSTORE,
    pub dwFlags: u32,
    pub dwUrlRetrievalTimeout: u32,
    pub MaximumCachedCertificates: u32,
    pub CycleDetectionModulus: u32,
    pub hExclusiveRoot: HCERTSTORE,
    pub hExclusiveTrustedPeople: HCERTSTORE,
    pub dwExclusiveFlags: u32,
}
impl Copy for CERT_CHAIN_ENGINE_CONFIG {}
impl Clone for CERT_CHAIN_ENGINE_CONFIG {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_CHAIN_ENGINE_CONFIG {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_CHAIN_ENGINE_CONFIG")
            .field("cbSize", &self.cbSize)
            .field("hRestrictedRoot", &self.hRestrictedRoot)
            .field("hRestrictedTrust", &self.hRestrictedTrust)
            .field("hRestrictedOther", &self.hRestrictedOther)
            .field("cAdditionalStore", &self.cAdditionalStore)
            .field("rghAdditionalStore", &self.rghAdditionalStore)
            .field("dwFlags", &self.dwFlags)
            .field("dwUrlRetrievalTimeout", &self.dwUrlRetrievalTimeout)
            .field("MaximumCachedCertificates", &self.MaximumCachedCertificates)
            .field("CycleDetectionModulus", &self.CycleDetectionModulus)
            .field("hExclusiveRoot", &self.hExclusiveRoot)
            .field("hExclusiveTrustedPeople", &self.hExclusiveTrustedPeople)
            .field("dwExclusiveFlags", &self.dwExclusiveFlags)
            .finish()
    }
}
impl windows_core::TypeKind for CERT_CHAIN_ENGINE_CONFIG {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_CHAIN_ENGINE_CONFIG {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.hRestrictedRoot == other.hRestrictedRoot && self.hRestrictedTrust == other.hRestrictedTrust && self.hRestrictedOther == other.hRestrictedOther && self.cAdditionalStore == other.cAdditionalStore && self.rghAdditionalStore == other.rghAdditionalStore && self.dwFlags == other.dwFlags && self.dwUrlRetrievalTimeout == other.dwUrlRetrievalTimeout && self.MaximumCachedCertificates == other.MaximumCachedCertificates && self.CycleDetectionModulus == other.CycleDetectionModulus && self.hExclusiveRoot == other.hExclusiveRoot && self.hExclusiveTrustedPeople == other.hExclusiveTrustedPeople && self.dwExclusiveFlags == other.dwExclusiveFlags
    }
}
impl Eq for CERT_CHAIN_ENGINE_CONFIG {}
impl Default for CERT_CHAIN_ENGINE_CONFIG {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_CHAIN_FIND_BY_ISSUER_PARA {
    pub cbSize: u32,
    pub pszUsageIdentifier: windows_core::PCSTR,
    pub dwKeySpec: u32,
    pub dwAcquirePrivateKeyFlags: u32,
    pub cIssuer: u32,
    pub rgIssuer: *mut CRYPT_INTEGER_BLOB,
    pub pfnFindCallback: PFN_CERT_CHAIN_FIND_BY_ISSUER_CALLBACK,
    pub pvFindArg: *mut core::ffi::c_void,
}
impl Copy for CERT_CHAIN_FIND_BY_ISSUER_PARA {}
impl Clone for CERT_CHAIN_FIND_BY_ISSUER_PARA {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_CHAIN_FIND_BY_ISSUER_PARA {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_CHAIN_FIND_BY_ISSUER_PARA").field("cbSize", &self.cbSize).field("pszUsageIdentifier", &self.pszUsageIdentifier).field("dwKeySpec", &self.dwKeySpec).field("dwAcquirePrivateKeyFlags", &self.dwAcquirePrivateKeyFlags).field("cIssuer", &self.cIssuer).field("rgIssuer", &self.rgIssuer).field("pvFindArg", &self.pvFindArg).finish()
    }
}
impl windows_core::TypeKind for CERT_CHAIN_FIND_BY_ISSUER_PARA {
    type TypeKind = windows_core::CopyType;
}
impl Default for CERT_CHAIN_FIND_BY_ISSUER_PARA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_CHAIN_PARA {
    pub cbSize: u32,
    pub RequestedUsage: CERT_USAGE_MATCH,
}
impl Copy for CERT_CHAIN_PARA {}
impl Clone for CERT_CHAIN_PARA {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_CHAIN_PARA {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_CHAIN_PARA").field("cbSize", &self.cbSize).field("RequestedUsage", &self.RequestedUsage).finish()
    }
}
impl windows_core::TypeKind for CERT_CHAIN_PARA {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_CHAIN_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.RequestedUsage == other.RequestedUsage
    }
}
impl Eq for CERT_CHAIN_PARA {}
impl Default for CERT_CHAIN_PARA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_CHAIN_POLICY_PARA {
    pub cbSize: u32,
    pub dwFlags: CERT_CHAIN_POLICY_FLAGS,
    pub pvExtraPolicyPara: *mut core::ffi::c_void,
}
impl Copy for CERT_CHAIN_POLICY_PARA {}
impl Clone for CERT_CHAIN_POLICY_PARA {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_CHAIN_POLICY_PARA {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_CHAIN_POLICY_PARA").field("cbSize", &self.cbSize).field("dwFlags", &self.dwFlags).field("pvExtraPolicyPara", &self.pvExtraPolicyPara).finish()
    }
}
impl windows_core::TypeKind for CERT_CHAIN_POLICY_PARA {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_CHAIN_POLICY_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwFlags == other.dwFlags && self.pvExtraPolicyPara == other.pvExtraPolicyPara
    }
}
impl Eq for CERT_CHAIN_POLICY_PARA {}
impl Default for CERT_CHAIN_POLICY_PARA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_CHAIN_POLICY_STATUS {
    pub cbSize: u32,
    pub dwError: u32,
    pub lChainIndex: i32,
    pub lElementIndex: i32,
    pub pvExtraPolicyStatus: *mut core::ffi::c_void,
}
impl Copy for CERT_CHAIN_POLICY_STATUS {}
impl Clone for CERT_CHAIN_POLICY_STATUS {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_CHAIN_POLICY_STATUS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_CHAIN_POLICY_STATUS").field("cbSize", &self.cbSize).field("dwError", &self.dwError).field("lChainIndex", &self.lChainIndex).field("lElementIndex", &self.lElementIndex).field("pvExtraPolicyStatus", &self.pvExtraPolicyStatus).finish()
    }
}
impl windows_core::TypeKind for CERT_CHAIN_POLICY_STATUS {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_CHAIN_POLICY_STATUS {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwError == other.dwError && self.lChainIndex == other.lChainIndex && self.lElementIndex == other.lElementIndex && self.pvExtraPolicyStatus == other.pvExtraPolicyStatus
    }
}
impl Eq for CERT_CHAIN_POLICY_STATUS {}
impl Default for CERT_CHAIN_POLICY_STATUS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_CONTEXT {
    pub dwCertEncodingType: CERT_QUERY_ENCODING_TYPE,
    pub pbCertEncoded: *mut u8,
    pub cbCertEncoded: u32,
    pub pCertInfo: *mut CERT_INFO,
    pub hCertStore: HCERTSTORE,
}
impl Copy for CERT_CONTEXT {}
impl Clone for CERT_CONTEXT {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_CONTEXT {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_CONTEXT").field("dwCertEncodingType", &self.dwCertEncodingType).field("pbCertEncoded", &self.pbCertEncoded).field("cbCertEncoded", &self.cbCertEncoded).field("pCertInfo", &self.pCertInfo).field("hCertStore", &self.hCertStore).finish()
    }
}
impl windows_core::TypeKind for CERT_CONTEXT {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_CONTEXT {
    fn eq(&self, other: &Self) -> bool {
        self.dwCertEncodingType == other.dwCertEncodingType && self.pbCertEncoded == other.pbCertEncoded && self.cbCertEncoded == other.cbCertEncoded && self.pCertInfo == other.pCertInfo && self.hCertStore == other.hCertStore
    }
}
impl Eq for CERT_CONTEXT {}
impl Default for CERT_CONTEXT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_CREATE_CONTEXT_PARA {
    pub cbSize: u32,
    pub pfnFree: PFN_CRYPT_FREE,
    pub pvFree: *mut core::ffi::c_void,
    pub pfnSort: PFN_CERT_CREATE_CONTEXT_SORT_FUNC,
    pub pvSort: *mut core::ffi::c_void,
}
impl Copy for CERT_CREATE_CONTEXT_PARA {}
impl Clone for CERT_CREATE_CONTEXT_PARA {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_CREATE_CONTEXT_PARA {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_CREATE_CONTEXT_PARA").field("cbSize", &self.cbSize).field("pvFree", &self.pvFree).field("pvSort", &self.pvSort).finish()
    }
}
impl windows_core::TypeKind for CERT_CREATE_CONTEXT_PARA {
    type TypeKind = windows_core::CopyType;
}
impl Default for CERT_CREATE_CONTEXT_PARA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_CRL_CONTEXT_PAIR {
    pub pCertContext: *const CERT_CONTEXT,
    pub pCrlContext: *mut CRL_CONTEXT,
}
impl Copy for CERT_CRL_CONTEXT_PAIR {}
impl Clone for CERT_CRL_CONTEXT_PAIR {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_CRL_CONTEXT_PAIR {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_CRL_CONTEXT_PAIR").field("pCertContext", &self.pCertContext).field("pCrlContext", &self.pCrlContext).finish()
    }
}
impl windows_core::TypeKind for CERT_CRL_CONTEXT_PAIR {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_CRL_CONTEXT_PAIR {
    fn eq(&self, other: &Self) -> bool {
        self.pCertContext == other.pCertContext && self.pCrlContext == other.pCrlContext
    }
}
impl Eq for CERT_CRL_CONTEXT_PAIR {}
impl Default for CERT_CRL_CONTEXT_PAIR {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_DH_PARAMETERS {
    pub p: CRYPT_INTEGER_BLOB,
    pub g: CRYPT_INTEGER_BLOB,
}
impl Copy for CERT_DH_PARAMETERS {}
impl Clone for CERT_DH_PARAMETERS {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_DH_PARAMETERS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_DH_PARAMETERS").field("p", &self.p).field("g", &self.g).finish()
    }
}
impl windows_core::TypeKind for CERT_DH_PARAMETERS {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_DH_PARAMETERS {
    fn eq(&self, other: &Self) -> bool {
        self.p == other.p && self.g == other.g
    }
}
impl Eq for CERT_DH_PARAMETERS {}
impl Default for CERT_DH_PARAMETERS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_DSS_PARAMETERS {
    pub p: CRYPT_INTEGER_BLOB,
    pub q: CRYPT_INTEGER_BLOB,
    pub g: CRYPT_INTEGER_BLOB,
}
impl Copy for CERT_DSS_PARAMETERS {}
impl Clone for CERT_DSS_PARAMETERS {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_DSS_PARAMETERS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_DSS_PARAMETERS").field("p", &self.p).field("q", &self.q).field("g", &self.g).finish()
    }
}
impl windows_core::TypeKind for CERT_DSS_PARAMETERS {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_DSS_PARAMETERS {
    fn eq(&self, other: &Self) -> bool {
        self.p == other.p && self.q == other.q && self.g == other.g
    }
}
impl Eq for CERT_DSS_PARAMETERS {}
impl Default for CERT_DSS_PARAMETERS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_ECC_SIGNATURE {
    pub r: CRYPT_INTEGER_BLOB,
    pub s: CRYPT_INTEGER_BLOB,
}
impl Copy for CERT_ECC_SIGNATURE {}
impl Clone for CERT_ECC_SIGNATURE {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_ECC_SIGNATURE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_ECC_SIGNATURE").field("r", &self.r).field("s", &self.s).finish()
    }
}
impl windows_core::TypeKind for CERT_ECC_SIGNATURE {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_ECC_SIGNATURE {
    fn eq(&self, other: &Self) -> bool {
        self.r == other.r && self.s == other.s
    }
}
impl Eq for CERT_ECC_SIGNATURE {}
impl Default for CERT_ECC_SIGNATURE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_EXTENSION {
    pub pszObjId: windows_core::PSTR,
    pub fCritical: super::super::Foundation::BOOL,
    pub Value: CRYPT_INTEGER_BLOB,
}
impl Copy for CERT_EXTENSION {}
impl Clone for CERT_EXTENSION {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_EXTENSION {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_EXTENSION").field("pszObjId", &self.pszObjId).field("fCritical", &self.fCritical).field("Value", &self.Value).finish()
    }
}
impl windows_core::TypeKind for CERT_EXTENSION {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_EXTENSION {
    fn eq(&self, other: &Self) -> bool {
        self.pszObjId == other.pszObjId && self.fCritical == other.fCritical && self.Value == other.Value
    }
}
impl Eq for CERT_EXTENSION {}
impl Default for CERT_EXTENSION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_EXTENSIONS {
    pub cExtension: u32,
    pub rgExtension: *mut CERT_EXTENSION,
}
impl Copy for CERT_EXTENSIONS {}
impl Clone for CERT_EXTENSIONS {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_EXTENSIONS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_EXTENSIONS").field("cExtension", &self.cExtension).field("rgExtension", &self.rgExtension).finish()
    }
}
impl windows_core::TypeKind for CERT_EXTENSIONS {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_EXTENSIONS {
    fn eq(&self, other: &Self) -> bool {
        self.cExtension == other.cExtension && self.rgExtension == other.rgExtension
    }
}
impl Eq for CERT_EXTENSIONS {}
impl Default for CERT_EXTENSIONS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_FORTEZZA_DATA_PROP {
    pub SerialNumber: [u8; 8],
    pub CertIndex: i32,
    pub CertLabel: [u8; 36],
}
impl Copy for CERT_FORTEZZA_DATA_PROP {}
impl Clone for CERT_FORTEZZA_DATA_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_FORTEZZA_DATA_PROP {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_FORTEZZA_DATA_PROP").field("SerialNumber", &self.SerialNumber).field("CertIndex", &self.CertIndex).field("CertLabel", &self.CertLabel).finish()
    }
}
impl windows_core::TypeKind for CERT_FORTEZZA_DATA_PROP {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_FORTEZZA_DATA_PROP {
    fn eq(&self, other: &Self) -> bool {
        self.SerialNumber == other.SerialNumber && self.CertIndex == other.CertIndex && self.CertLabel == other.CertLabel
    }
}
impl Eq for CERT_FORTEZZA_DATA_PROP {}
impl Default for CERT_FORTEZZA_DATA_PROP {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_GENERAL_SUBTREE {
    pub Base: CERT_ALT_NAME_ENTRY,
    pub dwMinimum: u32,
    pub fMaximum: super::super::Foundation::BOOL,
    pub dwMaximum: u32,
}
impl Copy for CERT_GENERAL_SUBTREE {}
impl Clone for CERT_GENERAL_SUBTREE {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CERT_GENERAL_SUBTREE {
    type TypeKind = windows_core::CopyType;
}
impl Default for CERT_GENERAL_SUBTREE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_HASHED_URL {
    pub HashAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub Hash: CRYPT_INTEGER_BLOB,
    pub pwszUrl: windows_core::PWSTR,
}
impl Copy for CERT_HASHED_URL {}
impl Clone for CERT_HASHED_URL {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_HASHED_URL {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_HASHED_URL").field("HashAlgorithm", &self.HashAlgorithm).field("Hash", &self.Hash).field("pwszUrl", &self.pwszUrl).finish()
    }
}
impl windows_core::TypeKind for CERT_HASHED_URL {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_HASHED_URL {
    fn eq(&self, other: &Self) -> bool {
        self.HashAlgorithm == other.HashAlgorithm && self.Hash == other.Hash && self.pwszUrl == other.pwszUrl
    }
}
impl Eq for CERT_HASHED_URL {}
impl Default for CERT_HASHED_URL {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_ID {
    pub dwIdChoice: CERT_ID_OPTION,
    pub Anonymous: CERT_ID_0,
}
impl Copy for CERT_ID {}
impl Clone for CERT_ID {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CERT_ID {
    type TypeKind = windows_core::CopyType;
}
impl Default for CERT_ID {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub union CERT_ID_0 {
    pub IssuerSerialNumber: CERT_ISSUER_SERIAL_NUMBER,
    pub KeyId: CRYPT_INTEGER_BLOB,
    pub HashId: CRYPT_INTEGER_BLOB,
}
impl Copy for CERT_ID_0 {}
impl Clone for CERT_ID_0 {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CERT_ID_0 {
    type TypeKind = windows_core::CopyType;
}
impl Default for CERT_ID_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_INFO {
    pub dwVersion: u32,
    pub SerialNumber: CRYPT_INTEGER_BLOB,
    pub SignatureAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub Issuer: CRYPT_INTEGER_BLOB,
    pub NotBefore: super::super::Foundation::FILETIME,
    pub NotAfter: super::super::Foundation::FILETIME,
    pub Subject: CRYPT_INTEGER_BLOB,
    pub SubjectPublicKeyInfo: CERT_PUBLIC_KEY_INFO,
    pub IssuerUniqueId: CRYPT_BIT_BLOB,
    pub SubjectUniqueId: CRYPT_BIT_BLOB,
    pub cExtension: u32,
    pub rgExtension: *mut CERT_EXTENSION,
}
impl Copy for CERT_INFO {}
impl Clone for CERT_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_INFO")
            .field("dwVersion", &self.dwVersion)
            .field("SerialNumber", &self.SerialNumber)
            .field("SignatureAlgorithm", &self.SignatureAlgorithm)
            .field("Issuer", &self.Issuer)
            .field("NotBefore", &self.NotBefore)
            .field("NotAfter", &self.NotAfter)
            .field("Subject", &self.Subject)
            .field("SubjectPublicKeyInfo", &self.SubjectPublicKeyInfo)
            .field("IssuerUniqueId", &self.IssuerUniqueId)
            .field("SubjectUniqueId", &self.SubjectUniqueId)
            .field("cExtension", &self.cExtension)
            .field("rgExtension", &self.rgExtension)
            .finish()
    }
}
impl windows_core::TypeKind for CERT_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwVersion == other.dwVersion && self.SerialNumber == other.SerialNumber && self.SignatureAlgorithm == other.SignatureAlgorithm && self.Issuer == other.Issuer && self.NotBefore == other.NotBefore && self.NotAfter == other.NotAfter && self.Subject == other.Subject && self.SubjectPublicKeyInfo == other.SubjectPublicKeyInfo && self.IssuerUniqueId == other.IssuerUniqueId && self.SubjectUniqueId == other.SubjectUniqueId && self.cExtension == other.cExtension && self.rgExtension == other.rgExtension
    }
}
impl Eq for CERT_INFO {}
impl Default for CERT_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_ISSUER_SERIAL_NUMBER {
    pub Issuer: CRYPT_INTEGER_BLOB,
    pub SerialNumber: CRYPT_INTEGER_BLOB,
}
impl Copy for CERT_ISSUER_SERIAL_NUMBER {}
impl Clone for CERT_ISSUER_SERIAL_NUMBER {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_ISSUER_SERIAL_NUMBER {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_ISSUER_SERIAL_NUMBER").field("Issuer", &self.Issuer).field("SerialNumber", &self.SerialNumber).finish()
    }
}
impl windows_core::TypeKind for CERT_ISSUER_SERIAL_NUMBER {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_ISSUER_SERIAL_NUMBER {
    fn eq(&self, other: &Self) -> bool {
        self.Issuer == other.Issuer && self.SerialNumber == other.SerialNumber
    }
}
impl Eq for CERT_ISSUER_SERIAL_NUMBER {}
impl Default for CERT_ISSUER_SERIAL_NUMBER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_KEYGEN_REQUEST_INFO {
    pub dwVersion: u32,
    pub SubjectPublicKeyInfo: CERT_PUBLIC_KEY_INFO,
    pub pwszChallengeString: windows_core::PWSTR,
}
impl Copy for CERT_KEYGEN_REQUEST_INFO {}
impl Clone for CERT_KEYGEN_REQUEST_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_KEYGEN_REQUEST_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_KEYGEN_REQUEST_INFO").field("dwVersion", &self.dwVersion).field("SubjectPublicKeyInfo", &self.SubjectPublicKeyInfo).field("pwszChallengeString", &self.pwszChallengeString).finish()
    }
}
impl windows_core::TypeKind for CERT_KEYGEN_REQUEST_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_KEYGEN_REQUEST_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwVersion == other.dwVersion && self.SubjectPublicKeyInfo == other.SubjectPublicKeyInfo && self.pwszChallengeString == other.pwszChallengeString
    }
}
impl Eq for CERT_KEYGEN_REQUEST_INFO {}
impl Default for CERT_KEYGEN_REQUEST_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_KEY_ATTRIBUTES_INFO {
    pub KeyId: CRYPT_INTEGER_BLOB,
    pub IntendedKeyUsage: CRYPT_BIT_BLOB,
    pub pPrivateKeyUsagePeriod: *mut CERT_PRIVATE_KEY_VALIDITY,
}
impl Copy for CERT_KEY_ATTRIBUTES_INFO {}
impl Clone for CERT_KEY_ATTRIBUTES_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_KEY_ATTRIBUTES_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_KEY_ATTRIBUTES_INFO").field("KeyId", &self.KeyId).field("IntendedKeyUsage", &self.IntendedKeyUsage).field("pPrivateKeyUsagePeriod", &self.pPrivateKeyUsagePeriod).finish()
    }
}
impl windows_core::TypeKind for CERT_KEY_ATTRIBUTES_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_KEY_ATTRIBUTES_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.KeyId == other.KeyId && self.IntendedKeyUsage == other.IntendedKeyUsage && self.pPrivateKeyUsagePeriod == other.pPrivateKeyUsagePeriod
    }
}
impl Eq for CERT_KEY_ATTRIBUTES_INFO {}
impl Default for CERT_KEY_ATTRIBUTES_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_KEY_CONTEXT {
    pub cbSize: u32,
    pub Anonymous: CERT_KEY_CONTEXT_0,
    pub dwKeySpec: u32,
}
impl Copy for CERT_KEY_CONTEXT {}
impl Clone for CERT_KEY_CONTEXT {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CERT_KEY_CONTEXT {
    type TypeKind = windows_core::CopyType;
}
impl Default for CERT_KEY_CONTEXT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub union CERT_KEY_CONTEXT_0 {
    pub hCryptProv: usize,
    pub hNCryptKey: NCRYPT_KEY_HANDLE,
}
impl Copy for CERT_KEY_CONTEXT_0 {}
impl Clone for CERT_KEY_CONTEXT_0 {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CERT_KEY_CONTEXT_0 {
    type TypeKind = windows_core::CopyType;
}
impl Default for CERT_KEY_CONTEXT_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_KEY_USAGE_RESTRICTION_INFO {
    pub cCertPolicyId: u32,
    pub rgCertPolicyId: *mut CERT_POLICY_ID,
    pub RestrictedKeyUsage: CRYPT_BIT_BLOB,
}
impl Copy for CERT_KEY_USAGE_RESTRICTION_INFO {}
impl Clone for CERT_KEY_USAGE_RESTRICTION_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_KEY_USAGE_RESTRICTION_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_KEY_USAGE_RESTRICTION_INFO").field("cCertPolicyId", &self.cCertPolicyId).field("rgCertPolicyId", &self.rgCertPolicyId).field("RestrictedKeyUsage", &self.RestrictedKeyUsage).finish()
    }
}
impl windows_core::TypeKind for CERT_KEY_USAGE_RESTRICTION_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_KEY_USAGE_RESTRICTION_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cCertPolicyId == other.cCertPolicyId && self.rgCertPolicyId == other.rgCertPolicyId && self.RestrictedKeyUsage == other.RestrictedKeyUsage
    }
}
impl Eq for CERT_KEY_USAGE_RESTRICTION_INFO {}
impl Default for CERT_KEY_USAGE_RESTRICTION_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_LDAP_STORE_OPENED_PARA {
    pub pvLdapSessionHandle: *mut core::ffi::c_void,
    pub pwszLdapUrl: windows_core::PCWSTR,
}
impl Copy for CERT_LDAP_STORE_OPENED_PARA {}
impl Clone for CERT_LDAP_STORE_OPENED_PARA {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_LDAP_STORE_OPENED_PARA {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_LDAP_STORE_OPENED_PARA").field("pvLdapSessionHandle", &self.pvLdapSessionHandle).field("pwszLdapUrl", &self.pwszLdapUrl).finish()
    }
}
impl windows_core::TypeKind for CERT_LDAP_STORE_OPENED_PARA {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_LDAP_STORE_OPENED_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.pvLdapSessionHandle == other.pvLdapSessionHandle && self.pwszLdapUrl == other.pwszLdapUrl
    }
}
impl Eq for CERT_LDAP_STORE_OPENED_PARA {}
impl Default for CERT_LDAP_STORE_OPENED_PARA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_LOGOTYPE_AUDIO {
    pub LogotypeDetails: CERT_LOGOTYPE_DETAILS,
    pub pLogotypeAudioInfo: *mut CERT_LOGOTYPE_AUDIO_INFO,
}
impl Copy for CERT_LOGOTYPE_AUDIO {}
impl Clone for CERT_LOGOTYPE_AUDIO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_LOGOTYPE_AUDIO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_LOGOTYPE_AUDIO").field("LogotypeDetails", &self.LogotypeDetails).field("pLogotypeAudioInfo", &self.pLogotypeAudioInfo).finish()
    }
}
impl windows_core::TypeKind for CERT_LOGOTYPE_AUDIO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_LOGOTYPE_AUDIO {
    fn eq(&self, other: &Self) -> bool {
        self.LogotypeDetails == other.LogotypeDetails && self.pLogotypeAudioInfo == other.pLogotypeAudioInfo
    }
}
impl Eq for CERT_LOGOTYPE_AUDIO {}
impl Default for CERT_LOGOTYPE_AUDIO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_LOGOTYPE_AUDIO_INFO {
    pub dwFileSize: u32,
    pub dwPlayTime: u32,
    pub dwChannels: u32,
    pub dwSampleRate: u32,
    pub pwszLanguage: windows_core::PWSTR,
}
impl Copy for CERT_LOGOTYPE_AUDIO_INFO {}
impl Clone for CERT_LOGOTYPE_AUDIO_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_LOGOTYPE_AUDIO_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_LOGOTYPE_AUDIO_INFO").field("dwFileSize", &self.dwFileSize).field("dwPlayTime", &self.dwPlayTime).field("dwChannels", &self.dwChannels).field("dwSampleRate", &self.dwSampleRate).field("pwszLanguage", &self.pwszLanguage).finish()
    }
}
impl windows_core::TypeKind for CERT_LOGOTYPE_AUDIO_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_LOGOTYPE_AUDIO_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwFileSize == other.dwFileSize && self.dwPlayTime == other.dwPlayTime && self.dwChannels == other.dwChannels && self.dwSampleRate == other.dwSampleRate && self.pwszLanguage == other.pwszLanguage
    }
}
impl Eq for CERT_LOGOTYPE_AUDIO_INFO {}
impl Default for CERT_LOGOTYPE_AUDIO_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_LOGOTYPE_DATA {
    pub cLogotypeImage: u32,
    pub rgLogotypeImage: *mut CERT_LOGOTYPE_IMAGE,
    pub cLogotypeAudio: u32,
    pub rgLogotypeAudio: *mut CERT_LOGOTYPE_AUDIO,
}
impl Copy for CERT_LOGOTYPE_DATA {}
impl Clone for CERT_LOGOTYPE_DATA {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_LOGOTYPE_DATA {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_LOGOTYPE_DATA").field("cLogotypeImage", &self.cLogotypeImage).field("rgLogotypeImage", &self.rgLogotypeImage).field("cLogotypeAudio", &self.cLogotypeAudio).field("rgLogotypeAudio", &self.rgLogotypeAudio).finish()
    }
}
impl windows_core::TypeKind for CERT_LOGOTYPE_DATA {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_LOGOTYPE_DATA {
    fn eq(&self, other: &Self) -> bool {
        self.cLogotypeImage == other.cLogotypeImage && self.rgLogotypeImage == other.rgLogotypeImage && self.cLogotypeAudio == other.cLogotypeAudio && self.rgLogotypeAudio == other.rgLogotypeAudio
    }
}
impl Eq for CERT_LOGOTYPE_DATA {}
impl Default for CERT_LOGOTYPE_DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_LOGOTYPE_DETAILS {
    pub pwszMimeType: windows_core::PWSTR,
    pub cHashedUrl: u32,
    pub rgHashedUrl: *mut CERT_HASHED_URL,
}
impl Copy for CERT_LOGOTYPE_DETAILS {}
impl Clone for CERT_LOGOTYPE_DETAILS {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_LOGOTYPE_DETAILS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_LOGOTYPE_DETAILS").field("pwszMimeType", &self.pwszMimeType).field("cHashedUrl", &self.cHashedUrl).field("rgHashedUrl", &self.rgHashedUrl).finish()
    }
}
impl windows_core::TypeKind for CERT_LOGOTYPE_DETAILS {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_LOGOTYPE_DETAILS {
    fn eq(&self, other: &Self) -> bool {
        self.pwszMimeType == other.pwszMimeType && self.cHashedUrl == other.cHashedUrl && self.rgHashedUrl == other.rgHashedUrl
    }
}
impl Eq for CERT_LOGOTYPE_DETAILS {}
impl Default for CERT_LOGOTYPE_DETAILS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_LOGOTYPE_EXT_INFO {
    pub cCommunityLogo: u32,
    pub rgCommunityLogo: *mut CERT_LOGOTYPE_INFO,
    pub pIssuerLogo: *mut CERT_LOGOTYPE_INFO,
    pub pSubjectLogo: *mut CERT_LOGOTYPE_INFO,
    pub cOtherLogo: u32,
    pub rgOtherLogo: *mut CERT_OTHER_LOGOTYPE_INFO,
}
impl Copy for CERT_LOGOTYPE_EXT_INFO {}
impl Clone for CERT_LOGOTYPE_EXT_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_LOGOTYPE_EXT_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_LOGOTYPE_EXT_INFO").field("cCommunityLogo", &self.cCommunityLogo).field("rgCommunityLogo", &self.rgCommunityLogo).field("pIssuerLogo", &self.pIssuerLogo).field("pSubjectLogo", &self.pSubjectLogo).field("cOtherLogo", &self.cOtherLogo).field("rgOtherLogo", &self.rgOtherLogo).finish()
    }
}
impl windows_core::TypeKind for CERT_LOGOTYPE_EXT_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_LOGOTYPE_EXT_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cCommunityLogo == other.cCommunityLogo && self.rgCommunityLogo == other.rgCommunityLogo && self.pIssuerLogo == other.pIssuerLogo && self.pSubjectLogo == other.pSubjectLogo && self.cOtherLogo == other.cOtherLogo && self.rgOtherLogo == other.rgOtherLogo
    }
}
impl Eq for CERT_LOGOTYPE_EXT_INFO {}
impl Default for CERT_LOGOTYPE_EXT_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_LOGOTYPE_IMAGE {
    pub LogotypeDetails: CERT_LOGOTYPE_DETAILS,
    pub pLogotypeImageInfo: *mut CERT_LOGOTYPE_IMAGE_INFO,
}
impl Copy for CERT_LOGOTYPE_IMAGE {}
impl Clone for CERT_LOGOTYPE_IMAGE {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_LOGOTYPE_IMAGE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_LOGOTYPE_IMAGE").field("LogotypeDetails", &self.LogotypeDetails).field("pLogotypeImageInfo", &self.pLogotypeImageInfo).finish()
    }
}
impl windows_core::TypeKind for CERT_LOGOTYPE_IMAGE {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_LOGOTYPE_IMAGE {
    fn eq(&self, other: &Self) -> bool {
        self.LogotypeDetails == other.LogotypeDetails && self.pLogotypeImageInfo == other.pLogotypeImageInfo
    }
}
impl Eq for CERT_LOGOTYPE_IMAGE {}
impl Default for CERT_LOGOTYPE_IMAGE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_LOGOTYPE_IMAGE_INFO {
    pub dwLogotypeImageInfoChoice: CERT_LOGOTYPE_IMAGE_INFO_TYPE,
    pub dwFileSize: u32,
    pub dwXSize: u32,
    pub dwYSize: u32,
    pub dwLogotypeImageResolutionChoice: CERT_LOGOTYPE_CHOICE,
    pub Anonymous: CERT_LOGOTYPE_IMAGE_INFO_0,
    pub pwszLanguage: windows_core::PWSTR,
}
impl Copy for CERT_LOGOTYPE_IMAGE_INFO {}
impl Clone for CERT_LOGOTYPE_IMAGE_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CERT_LOGOTYPE_IMAGE_INFO {
    type TypeKind = windows_core::CopyType;
}
impl Default for CERT_LOGOTYPE_IMAGE_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub union CERT_LOGOTYPE_IMAGE_INFO_0 {
    pub dwNumBits: u32,
    pub dwTableSize: u32,
}
impl Copy for CERT_LOGOTYPE_IMAGE_INFO_0 {}
impl Clone for CERT_LOGOTYPE_IMAGE_INFO_0 {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CERT_LOGOTYPE_IMAGE_INFO_0 {
    type TypeKind = windows_core::CopyType;
}
impl Default for CERT_LOGOTYPE_IMAGE_INFO_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_LOGOTYPE_INFO {
    pub dwLogotypeInfoChoice: CERT_LOGOTYPE_OPTION,
    pub Anonymous: CERT_LOGOTYPE_INFO_0,
}
impl Copy for CERT_LOGOTYPE_INFO {}
impl Clone for CERT_LOGOTYPE_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CERT_LOGOTYPE_INFO {
    type TypeKind = windows_core::CopyType;
}
impl Default for CERT_LOGOTYPE_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub union CERT_LOGOTYPE_INFO_0 {
    pub pLogotypeDirectInfo: *mut CERT_LOGOTYPE_DATA,
    pub pLogotypeIndirectInfo: *mut CERT_LOGOTYPE_REFERENCE,
}
impl Copy for CERT_LOGOTYPE_INFO_0 {}
impl Clone for CERT_LOGOTYPE_INFO_0 {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CERT_LOGOTYPE_INFO_0 {
    type TypeKind = windows_core::CopyType;
}
impl Default for CERT_LOGOTYPE_INFO_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_LOGOTYPE_REFERENCE {
    pub cHashedUrl: u32,
    pub rgHashedUrl: *mut CERT_HASHED_URL,
}
impl Copy for CERT_LOGOTYPE_REFERENCE {}
impl Clone for CERT_LOGOTYPE_REFERENCE {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_LOGOTYPE_REFERENCE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_LOGOTYPE_REFERENCE").field("cHashedUrl", &self.cHashedUrl).field("rgHashedUrl", &self.rgHashedUrl).finish()
    }
}
impl windows_core::TypeKind for CERT_LOGOTYPE_REFERENCE {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_LOGOTYPE_REFERENCE {
    fn eq(&self, other: &Self) -> bool {
        self.cHashedUrl == other.cHashedUrl && self.rgHashedUrl == other.rgHashedUrl
    }
}
impl Eq for CERT_LOGOTYPE_REFERENCE {}
impl Default for CERT_LOGOTYPE_REFERENCE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_NAME_CONSTRAINTS_INFO {
    pub cPermittedSubtree: u32,
    pub rgPermittedSubtree: *mut CERT_GENERAL_SUBTREE,
    pub cExcludedSubtree: u32,
    pub rgExcludedSubtree: *mut CERT_GENERAL_SUBTREE,
}
impl Copy for CERT_NAME_CONSTRAINTS_INFO {}
impl Clone for CERT_NAME_CONSTRAINTS_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_NAME_CONSTRAINTS_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_NAME_CONSTRAINTS_INFO").field("cPermittedSubtree", &self.cPermittedSubtree).field("rgPermittedSubtree", &self.rgPermittedSubtree).field("cExcludedSubtree", &self.cExcludedSubtree).field("rgExcludedSubtree", &self.rgExcludedSubtree).finish()
    }
}
impl windows_core::TypeKind for CERT_NAME_CONSTRAINTS_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_NAME_CONSTRAINTS_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cPermittedSubtree == other.cPermittedSubtree && self.rgPermittedSubtree == other.rgPermittedSubtree && self.cExcludedSubtree == other.cExcludedSubtree && self.rgExcludedSubtree == other.rgExcludedSubtree
    }
}
impl Eq for CERT_NAME_CONSTRAINTS_INFO {}
impl Default for CERT_NAME_CONSTRAINTS_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_NAME_INFO {
    pub cRDN: u32,
    pub rgRDN: *mut CERT_RDN,
}
impl Copy for CERT_NAME_INFO {}
impl Clone for CERT_NAME_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_NAME_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_NAME_INFO").field("cRDN", &self.cRDN).field("rgRDN", &self.rgRDN).finish()
    }
}
impl windows_core::TypeKind for CERT_NAME_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_NAME_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cRDN == other.cRDN && self.rgRDN == other.rgRDN
    }
}
impl Eq for CERT_NAME_INFO {}
impl Default for CERT_NAME_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_NAME_VALUE {
    pub dwValueType: u32,
    pub Value: CRYPT_INTEGER_BLOB,
}
impl Copy for CERT_NAME_VALUE {}
impl Clone for CERT_NAME_VALUE {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_NAME_VALUE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_NAME_VALUE").field("dwValueType", &self.dwValueType).field("Value", &self.Value).finish()
    }
}
impl windows_core::TypeKind for CERT_NAME_VALUE {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_NAME_VALUE {
    fn eq(&self, other: &Self) -> bool {
        self.dwValueType == other.dwValueType && self.Value == other.Value
    }
}
impl Eq for CERT_NAME_VALUE {}
impl Default for CERT_NAME_VALUE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_OR_CRL_BLOB {
    pub dwChoice: u32,
    pub cbEncoded: u32,
    pub pbEncoded: *mut u8,
}
impl Copy for CERT_OR_CRL_BLOB {}
impl Clone for CERT_OR_CRL_BLOB {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_OR_CRL_BLOB {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_OR_CRL_BLOB").field("dwChoice", &self.dwChoice).field("cbEncoded", &self.cbEncoded).field("pbEncoded", &self.pbEncoded).finish()
    }
}
impl windows_core::TypeKind for CERT_OR_CRL_BLOB {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_OR_CRL_BLOB {
    fn eq(&self, other: &Self) -> bool {
        self.dwChoice == other.dwChoice && self.cbEncoded == other.cbEncoded && self.pbEncoded == other.pbEncoded
    }
}
impl Eq for CERT_OR_CRL_BLOB {}
impl Default for CERT_OR_CRL_BLOB {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_OR_CRL_BUNDLE {
    pub cItem: u32,
    pub rgItem: *mut CERT_OR_CRL_BLOB,
}
impl Copy for CERT_OR_CRL_BUNDLE {}
impl Clone for CERT_OR_CRL_BUNDLE {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_OR_CRL_BUNDLE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_OR_CRL_BUNDLE").field("cItem", &self.cItem).field("rgItem", &self.rgItem).finish()
    }
}
impl windows_core::TypeKind for CERT_OR_CRL_BUNDLE {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_OR_CRL_BUNDLE {
    fn eq(&self, other: &Self) -> bool {
        self.cItem == other.cItem && self.rgItem == other.rgItem
    }
}
impl Eq for CERT_OR_CRL_BUNDLE {}
impl Default for CERT_OR_CRL_BUNDLE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_OTHER_LOGOTYPE_INFO {
    pub pszObjId: windows_core::PSTR,
    pub LogotypeInfo: CERT_LOGOTYPE_INFO,
}
impl Copy for CERT_OTHER_LOGOTYPE_INFO {}
impl Clone for CERT_OTHER_LOGOTYPE_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CERT_OTHER_LOGOTYPE_INFO {
    type TypeKind = windows_core::CopyType;
}
impl Default for CERT_OTHER_LOGOTYPE_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_OTHER_NAME {
    pub pszObjId: windows_core::PSTR,
    pub Value: CRYPT_INTEGER_BLOB,
}
impl Copy for CERT_OTHER_NAME {}
impl Clone for CERT_OTHER_NAME {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_OTHER_NAME {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_OTHER_NAME").field("pszObjId", &self.pszObjId).field("Value", &self.Value).finish()
    }
}
impl windows_core::TypeKind for CERT_OTHER_NAME {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_OTHER_NAME {
    fn eq(&self, other: &Self) -> bool {
        self.pszObjId == other.pszObjId && self.Value == other.Value
    }
}
impl Eq for CERT_OTHER_NAME {}
impl Default for CERT_OTHER_NAME {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_PAIR {
    pub Forward: CRYPT_INTEGER_BLOB,
    pub Reverse: CRYPT_INTEGER_BLOB,
}
impl Copy for CERT_PAIR {}
impl Clone for CERT_PAIR {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_PAIR {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_PAIR").field("Forward", &self.Forward).field("Reverse", &self.Reverse).finish()
    }
}
impl windows_core::TypeKind for CERT_PAIR {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_PAIR {
    fn eq(&self, other: &Self) -> bool {
        self.Forward == other.Forward && self.Reverse == other.Reverse
    }
}
impl Eq for CERT_PAIR {}
impl Default for CERT_PAIR {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_PHYSICAL_STORE_INFO {
    pub cbSize: u32,
    pub pszOpenStoreProvider: windows_core::PSTR,
    pub dwOpenEncodingType: u32,
    pub dwOpenFlags: u32,
    pub OpenParameters: CRYPT_INTEGER_BLOB,
    pub dwFlags: u32,
    pub dwPriority: u32,
}
impl Copy for CERT_PHYSICAL_STORE_INFO {}
impl Clone for CERT_PHYSICAL_STORE_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_PHYSICAL_STORE_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_PHYSICAL_STORE_INFO").field("cbSize", &self.cbSize).field("pszOpenStoreProvider", &self.pszOpenStoreProvider).field("dwOpenEncodingType", &self.dwOpenEncodingType).field("dwOpenFlags", &self.dwOpenFlags).field("OpenParameters", &self.OpenParameters).field("dwFlags", &self.dwFlags).field("dwPriority", &self.dwPriority).finish()
    }
}
impl windows_core::TypeKind for CERT_PHYSICAL_STORE_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_PHYSICAL_STORE_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.pszOpenStoreProvider == other.pszOpenStoreProvider && self.dwOpenEncodingType == other.dwOpenEncodingType && self.dwOpenFlags == other.dwOpenFlags && self.OpenParameters == other.OpenParameters && self.dwFlags == other.dwFlags && self.dwPriority == other.dwPriority
    }
}
impl Eq for CERT_PHYSICAL_STORE_INFO {}
impl Default for CERT_PHYSICAL_STORE_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_POLICIES_INFO {
    pub cPolicyInfo: u32,
    pub rgPolicyInfo: *mut CERT_POLICY_INFO,
}
impl Copy for CERT_POLICIES_INFO {}
impl Clone for CERT_POLICIES_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_POLICIES_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_POLICIES_INFO").field("cPolicyInfo", &self.cPolicyInfo).field("rgPolicyInfo", &self.rgPolicyInfo).finish()
    }
}
impl windows_core::TypeKind for CERT_POLICIES_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_POLICIES_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cPolicyInfo == other.cPolicyInfo && self.rgPolicyInfo == other.rgPolicyInfo
    }
}
impl Eq for CERT_POLICIES_INFO {}
impl Default for CERT_POLICIES_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_POLICY95_QUALIFIER1 {
    pub pszPracticesReference: windows_core::PWSTR,
    pub pszNoticeIdentifier: windows_core::PSTR,
    pub pszNSINoticeIdentifier: windows_core::PSTR,
    pub cCPSURLs: u32,
    pub rgCPSURLs: *mut CPS_URLS,
}
impl Copy for CERT_POLICY95_QUALIFIER1 {}
impl Clone for CERT_POLICY95_QUALIFIER1 {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_POLICY95_QUALIFIER1 {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_POLICY95_QUALIFIER1").field("pszPracticesReference", &self.pszPracticesReference).field("pszNoticeIdentifier", &self.pszNoticeIdentifier).field("pszNSINoticeIdentifier", &self.pszNSINoticeIdentifier).field("cCPSURLs", &self.cCPSURLs).field("rgCPSURLs", &self.rgCPSURLs).finish()
    }
}
impl windows_core::TypeKind for CERT_POLICY95_QUALIFIER1 {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_POLICY95_QUALIFIER1 {
    fn eq(&self, other: &Self) -> bool {
        self.pszPracticesReference == other.pszPracticesReference && self.pszNoticeIdentifier == other.pszNoticeIdentifier && self.pszNSINoticeIdentifier == other.pszNSINoticeIdentifier && self.cCPSURLs == other.cCPSURLs && self.rgCPSURLs == other.rgCPSURLs
    }
}
impl Eq for CERT_POLICY95_QUALIFIER1 {}
impl Default for CERT_POLICY95_QUALIFIER1 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_POLICY_CONSTRAINTS_INFO {
    pub fRequireExplicitPolicy: super::super::Foundation::BOOL,
    pub dwRequireExplicitPolicySkipCerts: u32,
    pub fInhibitPolicyMapping: super::super::Foundation::BOOL,
    pub dwInhibitPolicyMappingSkipCerts: u32,
}
impl Copy for CERT_POLICY_CONSTRAINTS_INFO {}
impl Clone for CERT_POLICY_CONSTRAINTS_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_POLICY_CONSTRAINTS_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_POLICY_CONSTRAINTS_INFO").field("fRequireExplicitPolicy", &self.fRequireExplicitPolicy).field("dwRequireExplicitPolicySkipCerts", &self.dwRequireExplicitPolicySkipCerts).field("fInhibitPolicyMapping", &self.fInhibitPolicyMapping).field("dwInhibitPolicyMappingSkipCerts", &self.dwInhibitPolicyMappingSkipCerts).finish()
    }
}
impl windows_core::TypeKind for CERT_POLICY_CONSTRAINTS_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_POLICY_CONSTRAINTS_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.fRequireExplicitPolicy == other.fRequireExplicitPolicy && self.dwRequireExplicitPolicySkipCerts == other.dwRequireExplicitPolicySkipCerts && self.fInhibitPolicyMapping == other.fInhibitPolicyMapping && self.dwInhibitPolicyMappingSkipCerts == other.dwInhibitPolicyMappingSkipCerts
    }
}
impl Eq for CERT_POLICY_CONSTRAINTS_INFO {}
impl Default for CERT_POLICY_CONSTRAINTS_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_POLICY_ID {
    pub cCertPolicyElementId: u32,
    pub rgpszCertPolicyElementId: *mut windows_core::PSTR,
}
impl Copy for CERT_POLICY_ID {}
impl Clone for CERT_POLICY_ID {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_POLICY_ID {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_POLICY_ID").field("cCertPolicyElementId", &self.cCertPolicyElementId).field("rgpszCertPolicyElementId", &self.rgpszCertPolicyElementId).finish()
    }
}
impl windows_core::TypeKind for CERT_POLICY_ID {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_POLICY_ID {
    fn eq(&self, other: &Self) -> bool {
        self.cCertPolicyElementId == other.cCertPolicyElementId && self.rgpszCertPolicyElementId == other.rgpszCertPolicyElementId
    }
}
impl Eq for CERT_POLICY_ID {}
impl Default for CERT_POLICY_ID {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_POLICY_INFO {
    pub pszPolicyIdentifier: windows_core::PSTR,
    pub cPolicyQualifier: u32,
    pub rgPolicyQualifier: *mut CERT_POLICY_QUALIFIER_INFO,
}
impl Copy for CERT_POLICY_INFO {}
impl Clone for CERT_POLICY_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_POLICY_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_POLICY_INFO").field("pszPolicyIdentifier", &self.pszPolicyIdentifier).field("cPolicyQualifier", &self.cPolicyQualifier).field("rgPolicyQualifier", &self.rgPolicyQualifier).finish()
    }
}
impl windows_core::TypeKind for CERT_POLICY_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_POLICY_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.pszPolicyIdentifier == other.pszPolicyIdentifier && self.cPolicyQualifier == other.cPolicyQualifier && self.rgPolicyQualifier == other.rgPolicyQualifier
    }
}
impl Eq for CERT_POLICY_INFO {}
impl Default for CERT_POLICY_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_POLICY_MAPPING {
    pub pszIssuerDomainPolicy: windows_core::PSTR,
    pub pszSubjectDomainPolicy: windows_core::PSTR,
}
impl Copy for CERT_POLICY_MAPPING {}
impl Clone for CERT_POLICY_MAPPING {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_POLICY_MAPPING {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_POLICY_MAPPING").field("pszIssuerDomainPolicy", &self.pszIssuerDomainPolicy).field("pszSubjectDomainPolicy", &self.pszSubjectDomainPolicy).finish()
    }
}
impl windows_core::TypeKind for CERT_POLICY_MAPPING {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_POLICY_MAPPING {
    fn eq(&self, other: &Self) -> bool {
        self.pszIssuerDomainPolicy == other.pszIssuerDomainPolicy && self.pszSubjectDomainPolicy == other.pszSubjectDomainPolicy
    }
}
impl Eq for CERT_POLICY_MAPPING {}
impl Default for CERT_POLICY_MAPPING {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_POLICY_MAPPINGS_INFO {
    pub cPolicyMapping: u32,
    pub rgPolicyMapping: *mut CERT_POLICY_MAPPING,
}
impl Copy for CERT_POLICY_MAPPINGS_INFO {}
impl Clone for CERT_POLICY_MAPPINGS_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_POLICY_MAPPINGS_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_POLICY_MAPPINGS_INFO").field("cPolicyMapping", &self.cPolicyMapping).field("rgPolicyMapping", &self.rgPolicyMapping).finish()
    }
}
impl windows_core::TypeKind for CERT_POLICY_MAPPINGS_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_POLICY_MAPPINGS_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cPolicyMapping == other.cPolicyMapping && self.rgPolicyMapping == other.rgPolicyMapping
    }
}
impl Eq for CERT_POLICY_MAPPINGS_INFO {}
impl Default for CERT_POLICY_MAPPINGS_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_POLICY_QUALIFIER_INFO {
    pub pszPolicyQualifierId: windows_core::PSTR,
    pub Qualifier: CRYPT_INTEGER_BLOB,
}
impl Copy for CERT_POLICY_QUALIFIER_INFO {}
impl Clone for CERT_POLICY_QUALIFIER_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_POLICY_QUALIFIER_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_POLICY_QUALIFIER_INFO").field("pszPolicyQualifierId", &self.pszPolicyQualifierId).field("Qualifier", &self.Qualifier).finish()
    }
}
impl windows_core::TypeKind for CERT_POLICY_QUALIFIER_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_POLICY_QUALIFIER_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.pszPolicyQualifierId == other.pszPolicyQualifierId && self.Qualifier == other.Qualifier
    }
}
impl Eq for CERT_POLICY_QUALIFIER_INFO {}
impl Default for CERT_POLICY_QUALIFIER_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_POLICY_QUALIFIER_NOTICE_REFERENCE {
    pub pszOrganization: windows_core::PSTR,
    pub cNoticeNumbers: u32,
    pub rgNoticeNumbers: *mut i32,
}
impl Copy for CERT_POLICY_QUALIFIER_NOTICE_REFERENCE {}
impl Clone for CERT_POLICY_QUALIFIER_NOTICE_REFERENCE {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_POLICY_QUALIFIER_NOTICE_REFERENCE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_POLICY_QUALIFIER_NOTICE_REFERENCE").field("pszOrganization", &self.pszOrganization).field("cNoticeNumbers", &self.cNoticeNumbers).field("rgNoticeNumbers", &self.rgNoticeNumbers).finish()
    }
}
impl windows_core::TypeKind for CERT_POLICY_QUALIFIER_NOTICE_REFERENCE {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_POLICY_QUALIFIER_NOTICE_REFERENCE {
    fn eq(&self, other: &Self) -> bool {
        self.pszOrganization == other.pszOrganization && self.cNoticeNumbers == other.cNoticeNumbers && self.rgNoticeNumbers == other.rgNoticeNumbers
    }
}
impl Eq for CERT_POLICY_QUALIFIER_NOTICE_REFERENCE {}
impl Default for CERT_POLICY_QUALIFIER_NOTICE_REFERENCE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_POLICY_QUALIFIER_USER_NOTICE {
    pub pNoticeReference: *mut CERT_POLICY_QUALIFIER_NOTICE_REFERENCE,
    pub pszDisplayText: windows_core::PWSTR,
}
impl Copy for CERT_POLICY_QUALIFIER_USER_NOTICE {}
impl Clone for CERT_POLICY_QUALIFIER_USER_NOTICE {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_POLICY_QUALIFIER_USER_NOTICE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_POLICY_QUALIFIER_USER_NOTICE").field("pNoticeReference", &self.pNoticeReference).field("pszDisplayText", &self.pszDisplayText).finish()
    }
}
impl windows_core::TypeKind for CERT_POLICY_QUALIFIER_USER_NOTICE {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_POLICY_QUALIFIER_USER_NOTICE {
    fn eq(&self, other: &Self) -> bool {
        self.pNoticeReference == other.pNoticeReference && self.pszDisplayText == other.pszDisplayText
    }
}
impl Eq for CERT_POLICY_QUALIFIER_USER_NOTICE {}
impl Default for CERT_POLICY_QUALIFIER_USER_NOTICE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_PRIVATE_KEY_VALIDITY {
    pub NotBefore: super::super::Foundation::FILETIME,
    pub NotAfter: super::super::Foundation::FILETIME,
}
impl Copy for CERT_PRIVATE_KEY_VALIDITY {}
impl Clone for CERT_PRIVATE_KEY_VALIDITY {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_PRIVATE_KEY_VALIDITY {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_PRIVATE_KEY_VALIDITY").field("NotBefore", &self.NotBefore).field("NotAfter", &self.NotAfter).finish()
    }
}
impl windows_core::TypeKind for CERT_PRIVATE_KEY_VALIDITY {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_PRIVATE_KEY_VALIDITY {
    fn eq(&self, other: &Self) -> bool {
        self.NotBefore == other.NotBefore && self.NotAfter == other.NotAfter
    }
}
impl Eq for CERT_PRIVATE_KEY_VALIDITY {}
impl Default for CERT_PRIVATE_KEY_VALIDITY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_PUBLIC_KEY_INFO {
    pub Algorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub PublicKey: CRYPT_BIT_BLOB,
}
impl Copy for CERT_PUBLIC_KEY_INFO {}
impl Clone for CERT_PUBLIC_KEY_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_PUBLIC_KEY_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_PUBLIC_KEY_INFO").field("Algorithm", &self.Algorithm).field("PublicKey", &self.PublicKey).finish()
    }
}
impl windows_core::TypeKind for CERT_PUBLIC_KEY_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_PUBLIC_KEY_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.Algorithm == other.Algorithm && self.PublicKey == other.PublicKey
    }
}
impl Eq for CERT_PUBLIC_KEY_INFO {}
impl Default for CERT_PUBLIC_KEY_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_QC_STATEMENT {
    pub pszStatementId: windows_core::PSTR,
    pub StatementInfo: CRYPT_INTEGER_BLOB,
}
impl Copy for CERT_QC_STATEMENT {}
impl Clone for CERT_QC_STATEMENT {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_QC_STATEMENT {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_QC_STATEMENT").field("pszStatementId", &self.pszStatementId).field("StatementInfo", &self.StatementInfo).finish()
    }
}
impl windows_core::TypeKind for CERT_QC_STATEMENT {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_QC_STATEMENT {
    fn eq(&self, other: &Self) -> bool {
        self.pszStatementId == other.pszStatementId && self.StatementInfo == other.StatementInfo
    }
}
impl Eq for CERT_QC_STATEMENT {}
impl Default for CERT_QC_STATEMENT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_QC_STATEMENTS_EXT_INFO {
    pub cStatement: u32,
    pub rgStatement: *mut CERT_QC_STATEMENT,
}
impl Copy for CERT_QC_STATEMENTS_EXT_INFO {}
impl Clone for CERT_QC_STATEMENTS_EXT_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_QC_STATEMENTS_EXT_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_QC_STATEMENTS_EXT_INFO").field("cStatement", &self.cStatement).field("rgStatement", &self.rgStatement).finish()
    }
}
impl windows_core::TypeKind for CERT_QC_STATEMENTS_EXT_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_QC_STATEMENTS_EXT_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cStatement == other.cStatement && self.rgStatement == other.rgStatement
    }
}
impl Eq for CERT_QC_STATEMENTS_EXT_INFO {}
impl Default for CERT_QC_STATEMENTS_EXT_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_RDN {
    pub cRDNAttr: u32,
    pub rgRDNAttr: *mut CERT_RDN_ATTR,
}
impl Copy for CERT_RDN {}
impl Clone for CERT_RDN {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_RDN {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_RDN").field("cRDNAttr", &self.cRDNAttr).field("rgRDNAttr", &self.rgRDNAttr).finish()
    }
}
impl windows_core::TypeKind for CERT_RDN {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_RDN {
    fn eq(&self, other: &Self) -> bool {
        self.cRDNAttr == other.cRDNAttr && self.rgRDNAttr == other.rgRDNAttr
    }
}
impl Eq for CERT_RDN {}
impl Default for CERT_RDN {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_RDN_ATTR {
    pub pszObjId: windows_core::PSTR,
    pub dwValueType: u32,
    pub Value: CRYPT_INTEGER_BLOB,
}
impl Copy for CERT_RDN_ATTR {}
impl Clone for CERT_RDN_ATTR {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_RDN_ATTR {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_RDN_ATTR").field("pszObjId", &self.pszObjId).field("dwValueType", &self.dwValueType).field("Value", &self.Value).finish()
    }
}
impl windows_core::TypeKind for CERT_RDN_ATTR {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_RDN_ATTR {
    fn eq(&self, other: &Self) -> bool {
        self.pszObjId == other.pszObjId && self.dwValueType == other.dwValueType && self.Value == other.Value
    }
}
impl Eq for CERT_RDN_ATTR {}
impl Default for CERT_RDN_ATTR {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_System_Registry")]
pub struct CERT_REGISTRY_STORE_CLIENT_GPT_PARA {
    pub hKeyBase: super::super::System::Registry::HKEY,
    pub pwszRegPath: windows_core::PWSTR,
}
#[cfg(feature = "Win32_System_Registry")]
impl Copy for CERT_REGISTRY_STORE_CLIENT_GPT_PARA {}
#[cfg(feature = "Win32_System_Registry")]
impl Clone for CERT_REGISTRY_STORE_CLIENT_GPT_PARA {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_System_Registry")]
impl core::fmt::Debug for CERT_REGISTRY_STORE_CLIENT_GPT_PARA {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_REGISTRY_STORE_CLIENT_GPT_PARA").field("hKeyBase", &self.hKeyBase).field("pwszRegPath", &self.pwszRegPath).finish()
    }
}
#[cfg(feature = "Win32_System_Registry")]
impl windows_core::TypeKind for CERT_REGISTRY_STORE_CLIENT_GPT_PARA {
    type TypeKind = windows_core::CopyType;
}
#[cfg(feature = "Win32_System_Registry")]
impl PartialEq for CERT_REGISTRY_STORE_CLIENT_GPT_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.hKeyBase == other.hKeyBase && self.pwszRegPath == other.pwszRegPath
    }
}
#[cfg(feature = "Win32_System_Registry")]
impl Eq for CERT_REGISTRY_STORE_CLIENT_GPT_PARA {}
#[cfg(feature = "Win32_System_Registry")]
impl Default for CERT_REGISTRY_STORE_CLIENT_GPT_PARA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_System_Registry")]
pub struct CERT_REGISTRY_STORE_ROAMING_PARA {
    pub hKey: super::super::System::Registry::HKEY,
    pub pwszStoreDirectory: windows_core::PWSTR,
}
#[cfg(feature = "Win32_System_Registry")]
impl Copy for CERT_REGISTRY_STORE_ROAMING_PARA {}
#[cfg(feature = "Win32_System_Registry")]
impl Clone for CERT_REGISTRY_STORE_ROAMING_PARA {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_System_Registry")]
impl core::fmt::Debug for CERT_REGISTRY_STORE_ROAMING_PARA {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_REGISTRY_STORE_ROAMING_PARA").field("hKey", &self.hKey).field("pwszStoreDirectory", &self.pwszStoreDirectory).finish()
    }
}
#[cfg(feature = "Win32_System_Registry")]
impl windows_core::TypeKind for CERT_REGISTRY_STORE_ROAMING_PARA {
    type TypeKind = windows_core::CopyType;
}
#[cfg(feature = "Win32_System_Registry")]
impl PartialEq for CERT_REGISTRY_STORE_ROAMING_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.hKey == other.hKey && self.pwszStoreDirectory == other.pwszStoreDirectory
    }
}
#[cfg(feature = "Win32_System_Registry")]
impl Eq for CERT_REGISTRY_STORE_ROAMING_PARA {}
#[cfg(feature = "Win32_System_Registry")]
impl Default for CERT_REGISTRY_STORE_ROAMING_PARA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_REQUEST_INFO {
    pub dwVersion: u32,
    pub Subject: CRYPT_INTEGER_BLOB,
    pub SubjectPublicKeyInfo: CERT_PUBLIC_KEY_INFO,
    pub cAttribute: u32,
    pub rgAttribute: *mut CRYPT_ATTRIBUTE,
}
impl Copy for CERT_REQUEST_INFO {}
impl Clone for CERT_REQUEST_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_REQUEST_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_REQUEST_INFO").field("dwVersion", &self.dwVersion).field("Subject", &self.Subject).field("SubjectPublicKeyInfo", &self.SubjectPublicKeyInfo).field("cAttribute", &self.cAttribute).field("rgAttribute", &self.rgAttribute).finish()
    }
}
impl windows_core::TypeKind for CERT_REQUEST_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_REQUEST_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwVersion == other.dwVersion && self.Subject == other.Subject && self.SubjectPublicKeyInfo == other.SubjectPublicKeyInfo && self.cAttribute == other.cAttribute && self.rgAttribute == other.rgAttribute
    }
}
impl Eq for CERT_REQUEST_INFO {}
impl Default for CERT_REQUEST_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_REVOCATION_CHAIN_PARA {
    pub cbSize: u32,
    pub hChainEngine: HCERTCHAINENGINE,
    pub hAdditionalStore: HCERTSTORE,
    pub dwChainFlags: u32,
    pub dwUrlRetrievalTimeout: u32,
    pub pftCurrentTime: *mut super::super::Foundation::FILETIME,
    pub pftCacheResync: *mut super::super::Foundation::FILETIME,
    pub cbMaxUrlRetrievalByteCount: u32,
}
impl Copy for CERT_REVOCATION_CHAIN_PARA {}
impl Clone for CERT_REVOCATION_CHAIN_PARA {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_REVOCATION_CHAIN_PARA {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_REVOCATION_CHAIN_PARA").field("cbSize", &self.cbSize).field("hChainEngine", &self.hChainEngine).field("hAdditionalStore", &self.hAdditionalStore).field("dwChainFlags", &self.dwChainFlags).field("dwUrlRetrievalTimeout", &self.dwUrlRetrievalTimeout).field("pftCurrentTime", &self.pftCurrentTime).field("pftCacheResync", &self.pftCacheResync).field("cbMaxUrlRetrievalByteCount", &self.cbMaxUrlRetrievalByteCount).finish()
    }
}
impl windows_core::TypeKind for CERT_REVOCATION_CHAIN_PARA {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_REVOCATION_CHAIN_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.hChainEngine == other.hChainEngine && self.hAdditionalStore == other.hAdditionalStore && self.dwChainFlags == other.dwChainFlags && self.dwUrlRetrievalTimeout == other.dwUrlRetrievalTimeout && self.pftCurrentTime == other.pftCurrentTime && self.pftCacheResync == other.pftCacheResync && self.cbMaxUrlRetrievalByteCount == other.cbMaxUrlRetrievalByteCount
    }
}
impl Eq for CERT_REVOCATION_CHAIN_PARA {}
impl Default for CERT_REVOCATION_CHAIN_PARA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_REVOCATION_CRL_INFO {
    pub cbSize: u32,
    pub pBaseCrlContext: *mut CRL_CONTEXT,
    pub pDeltaCrlContext: *mut CRL_CONTEXT,
    pub pCrlEntry: *mut CRL_ENTRY,
    pub fDeltaCrlEntry: super::super::Foundation::BOOL,
}
impl Copy for CERT_REVOCATION_CRL_INFO {}
impl Clone for CERT_REVOCATION_CRL_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_REVOCATION_CRL_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_REVOCATION_CRL_INFO").field("cbSize", &self.cbSize).field("pBaseCrlContext", &self.pBaseCrlContext).field("pDeltaCrlContext", &self.pDeltaCrlContext).field("pCrlEntry", &self.pCrlEntry).field("fDeltaCrlEntry", &self.fDeltaCrlEntry).finish()
    }
}
impl windows_core::TypeKind for CERT_REVOCATION_CRL_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_REVOCATION_CRL_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.pBaseCrlContext == other.pBaseCrlContext && self.pDeltaCrlContext == other.pDeltaCrlContext && self.pCrlEntry == other.pCrlEntry && self.fDeltaCrlEntry == other.fDeltaCrlEntry
    }
}
impl Eq for CERT_REVOCATION_CRL_INFO {}
impl Default for CERT_REVOCATION_CRL_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_REVOCATION_INFO {
    pub cbSize: u32,
    pub dwRevocationResult: u32,
    pub pszRevocationOid: windows_core::PCSTR,
    pub pvOidSpecificInfo: *mut core::ffi::c_void,
    pub fHasFreshnessTime: super::super::Foundation::BOOL,
    pub dwFreshnessTime: u32,
    pub pCrlInfo: *mut CERT_REVOCATION_CRL_INFO,
}
impl Copy for CERT_REVOCATION_INFO {}
impl Clone for CERT_REVOCATION_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_REVOCATION_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_REVOCATION_INFO").field("cbSize", &self.cbSize).field("dwRevocationResult", &self.dwRevocationResult).field("pszRevocationOid", &self.pszRevocationOid).field("pvOidSpecificInfo", &self.pvOidSpecificInfo).field("fHasFreshnessTime", &self.fHasFreshnessTime).field("dwFreshnessTime", &self.dwFreshnessTime).field("pCrlInfo", &self.pCrlInfo).finish()
    }
}
impl windows_core::TypeKind for CERT_REVOCATION_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_REVOCATION_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwRevocationResult == other.dwRevocationResult && self.pszRevocationOid == other.pszRevocationOid && self.pvOidSpecificInfo == other.pvOidSpecificInfo && self.fHasFreshnessTime == other.fHasFreshnessTime && self.dwFreshnessTime == other.dwFreshnessTime && self.pCrlInfo == other.pCrlInfo
    }
}
impl Eq for CERT_REVOCATION_INFO {}
impl Default for CERT_REVOCATION_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_REVOCATION_PARA {
    pub cbSize: u32,
    pub pIssuerCert: *const CERT_CONTEXT,
    pub cCertStore: u32,
    pub rgCertStore: *mut HCERTSTORE,
    pub hCrlStore: HCERTSTORE,
    pub pftTimeToUse: *mut super::super::Foundation::FILETIME,
}
impl Copy for CERT_REVOCATION_PARA {}
impl Clone for CERT_REVOCATION_PARA {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_REVOCATION_PARA {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_REVOCATION_PARA").field("cbSize", &self.cbSize).field("pIssuerCert", &self.pIssuerCert).field("cCertStore", &self.cCertStore).field("rgCertStore", &self.rgCertStore).field("hCrlStore", &self.hCrlStore).field("pftTimeToUse", &self.pftTimeToUse).finish()
    }
}
impl windows_core::TypeKind for CERT_REVOCATION_PARA {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_REVOCATION_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.pIssuerCert == other.pIssuerCert && self.cCertStore == other.cCertStore && self.rgCertStore == other.rgCertStore && self.hCrlStore == other.hCrlStore && self.pftTimeToUse == other.pftTimeToUse
    }
}
impl Eq for CERT_REVOCATION_PARA {}
impl Default for CERT_REVOCATION_PARA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_REVOCATION_STATUS {
    pub cbSize: u32,
    pub dwIndex: u32,
    pub dwError: u32,
    pub dwReason: CERT_REVOCATION_STATUS_REASON,
    pub fHasFreshnessTime: super::super::Foundation::BOOL,
    pub dwFreshnessTime: u32,
}
impl Copy for CERT_REVOCATION_STATUS {}
impl Clone for CERT_REVOCATION_STATUS {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_REVOCATION_STATUS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_REVOCATION_STATUS").field("cbSize", &self.cbSize).field("dwIndex", &self.dwIndex).field("dwError", &self.dwError).field("dwReason", &self.dwReason).field("fHasFreshnessTime", &self.fHasFreshnessTime).field("dwFreshnessTime", &self.dwFreshnessTime).finish()
    }
}
impl windows_core::TypeKind for CERT_REVOCATION_STATUS {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_REVOCATION_STATUS {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwIndex == other.dwIndex && self.dwError == other.dwError && self.dwReason == other.dwReason && self.fHasFreshnessTime == other.fHasFreshnessTime && self.dwFreshnessTime == other.dwFreshnessTime
    }
}
impl Eq for CERT_REVOCATION_STATUS {}
impl Default for CERT_REVOCATION_STATUS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_SELECT_CHAIN_PARA {
    pub hChainEngine: HCERTCHAINENGINE,
    pub pTime: *mut super::super::Foundation::FILETIME,
    pub hAdditionalStore: HCERTSTORE,
    pub pChainPara: *mut CERT_CHAIN_PARA,
    pub dwFlags: u32,
}
impl Copy for CERT_SELECT_CHAIN_PARA {}
impl Clone for CERT_SELECT_CHAIN_PARA {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_SELECT_CHAIN_PARA {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_SELECT_CHAIN_PARA").field("hChainEngine", &self.hChainEngine).field("pTime", &self.pTime).field("hAdditionalStore", &self.hAdditionalStore).field("pChainPara", &self.pChainPara).field("dwFlags", &self.dwFlags).finish()
    }
}
impl windows_core::TypeKind for CERT_SELECT_CHAIN_PARA {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_SELECT_CHAIN_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.hChainEngine == other.hChainEngine && self.pTime == other.pTime && self.hAdditionalStore == other.hAdditionalStore && self.pChainPara == other.pChainPara && self.dwFlags == other.dwFlags
    }
}
impl Eq for CERT_SELECT_CHAIN_PARA {}
impl Default for CERT_SELECT_CHAIN_PARA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_SELECT_CRITERIA {
    pub dwType: CERT_SELECT_CRITERIA_TYPE,
    pub cPara: u32,
    pub ppPara: *mut *mut core::ffi::c_void,
}
impl Copy for CERT_SELECT_CRITERIA {}
impl Clone for CERT_SELECT_CRITERIA {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_SELECT_CRITERIA {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_SELECT_CRITERIA").field("dwType", &self.dwType).field("cPara", &self.cPara).field("ppPara", &self.ppPara).finish()
    }
}
impl windows_core::TypeKind for CERT_SELECT_CRITERIA {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_SELECT_CRITERIA {
    fn eq(&self, other: &Self) -> bool {
        self.dwType == other.dwType && self.cPara == other.cPara && self.ppPara == other.ppPara
    }
}
impl Eq for CERT_SELECT_CRITERIA {}
impl Default for CERT_SELECT_CRITERIA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_SERVER_OCSP_RESPONSE_CONTEXT {
    pub cbSize: u32,
    pub pbEncodedOcspResponse: *mut u8,
    pub cbEncodedOcspResponse: u32,
}
impl Copy for CERT_SERVER_OCSP_RESPONSE_CONTEXT {}
impl Clone for CERT_SERVER_OCSP_RESPONSE_CONTEXT {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_SERVER_OCSP_RESPONSE_CONTEXT {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_SERVER_OCSP_RESPONSE_CONTEXT").field("cbSize", &self.cbSize).field("pbEncodedOcspResponse", &self.pbEncodedOcspResponse).field("cbEncodedOcspResponse", &self.cbEncodedOcspResponse).finish()
    }
}
impl windows_core::TypeKind for CERT_SERVER_OCSP_RESPONSE_CONTEXT {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_SERVER_OCSP_RESPONSE_CONTEXT {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.pbEncodedOcspResponse == other.pbEncodedOcspResponse && self.cbEncodedOcspResponse == other.cbEncodedOcspResponse
    }
}
impl Eq for CERT_SERVER_OCSP_RESPONSE_CONTEXT {}
impl Default for CERT_SERVER_OCSP_RESPONSE_CONTEXT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_SERVER_OCSP_RESPONSE_OPEN_PARA {
    pub cbSize: u32,
    pub dwFlags: u32,
    pub pcbUsedSize: *mut u32,
    pub pwszOcspDirectory: windows_core::PWSTR,
    pub pfnUpdateCallback: PFN_CERT_SERVER_OCSP_RESPONSE_UPDATE_CALLBACK,
    pub pvUpdateCallbackArg: *mut core::ffi::c_void,
}
impl Copy for CERT_SERVER_OCSP_RESPONSE_OPEN_PARA {}
impl Clone for CERT_SERVER_OCSP_RESPONSE_OPEN_PARA {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_SERVER_OCSP_RESPONSE_OPEN_PARA {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_SERVER_OCSP_RESPONSE_OPEN_PARA").field("cbSize", &self.cbSize).field("dwFlags", &self.dwFlags).field("pcbUsedSize", &self.pcbUsedSize).field("pwszOcspDirectory", &self.pwszOcspDirectory).field("pvUpdateCallbackArg", &self.pvUpdateCallbackArg).finish()
    }
}
impl windows_core::TypeKind for CERT_SERVER_OCSP_RESPONSE_OPEN_PARA {
    type TypeKind = windows_core::CopyType;
}
impl Default for CERT_SERVER_OCSP_RESPONSE_OPEN_PARA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_SIGNED_CONTENT_INFO {
    pub ToBeSigned: CRYPT_INTEGER_BLOB,
    pub SignatureAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub Signature: CRYPT_BIT_BLOB,
}
impl Copy for CERT_SIGNED_CONTENT_INFO {}
impl Clone for CERT_SIGNED_CONTENT_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_SIGNED_CONTENT_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_SIGNED_CONTENT_INFO").field("ToBeSigned", &self.ToBeSigned).field("SignatureAlgorithm", &self.SignatureAlgorithm).field("Signature", &self.Signature).finish()
    }
}
impl windows_core::TypeKind for CERT_SIGNED_CONTENT_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_SIGNED_CONTENT_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.ToBeSigned == other.ToBeSigned && self.SignatureAlgorithm == other.SignatureAlgorithm && self.Signature == other.Signature
    }
}
impl Eq for CERT_SIGNED_CONTENT_INFO {}
impl Default for CERT_SIGNED_CONTENT_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_SIMPLE_CHAIN {
    pub cbSize: u32,
    pub TrustStatus: CERT_TRUST_STATUS,
    pub cElement: u32,
    pub rgpElement: *mut *mut CERT_CHAIN_ELEMENT,
    pub pTrustListInfo: *mut CERT_TRUST_LIST_INFO,
    pub fHasRevocationFreshnessTime: super::super::Foundation::BOOL,
    pub dwRevocationFreshnessTime: u32,
}
impl Copy for CERT_SIMPLE_CHAIN {}
impl Clone for CERT_SIMPLE_CHAIN {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_SIMPLE_CHAIN {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_SIMPLE_CHAIN").field("cbSize", &self.cbSize).field("TrustStatus", &self.TrustStatus).field("cElement", &self.cElement).field("rgpElement", &self.rgpElement).field("pTrustListInfo", &self.pTrustListInfo).field("fHasRevocationFreshnessTime", &self.fHasRevocationFreshnessTime).field("dwRevocationFreshnessTime", &self.dwRevocationFreshnessTime).finish()
    }
}
impl windows_core::TypeKind for CERT_SIMPLE_CHAIN {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_SIMPLE_CHAIN {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.TrustStatus == other.TrustStatus && self.cElement == other.cElement && self.rgpElement == other.rgpElement && self.pTrustListInfo == other.pTrustListInfo && self.fHasRevocationFreshnessTime == other.fHasRevocationFreshnessTime && self.dwRevocationFreshnessTime == other.dwRevocationFreshnessTime
    }
}
impl Eq for CERT_SIMPLE_CHAIN {}
impl Default for CERT_SIMPLE_CHAIN {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_STORE_PROV_FIND_INFO {
    pub cbSize: u32,
    pub dwMsgAndCertEncodingType: u32,
    pub dwFindFlags: u32,
    pub dwFindType: u32,
    pub pvFindPara: *const core::ffi::c_void,
}
impl Copy for CERT_STORE_PROV_FIND_INFO {}
impl Clone for CERT_STORE_PROV_FIND_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_STORE_PROV_FIND_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_STORE_PROV_FIND_INFO").field("cbSize", &self.cbSize).field("dwMsgAndCertEncodingType", &self.dwMsgAndCertEncodingType).field("dwFindFlags", &self.dwFindFlags).field("dwFindType", &self.dwFindType).field("pvFindPara", &self.pvFindPara).finish()
    }
}
impl windows_core::TypeKind for CERT_STORE_PROV_FIND_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_STORE_PROV_FIND_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwMsgAndCertEncodingType == other.dwMsgAndCertEncodingType && self.dwFindFlags == other.dwFindFlags && self.dwFindType == other.dwFindType && self.pvFindPara == other.pvFindPara
    }
}
impl Eq for CERT_STORE_PROV_FIND_INFO {}
impl Default for CERT_STORE_PROV_FIND_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_STORE_PROV_INFO {
    pub cbSize: u32,
    pub cStoreProvFunc: u32,
    pub rgpvStoreProvFunc: *mut *mut core::ffi::c_void,
    pub hStoreProv: HCERTSTOREPROV,
    pub dwStoreProvFlags: CERT_STORE_PROV_FLAGS,
    pub hStoreProvFuncAddr2: *mut core::ffi::c_void,
}
impl Copy for CERT_STORE_PROV_INFO {}
impl Clone for CERT_STORE_PROV_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_STORE_PROV_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_STORE_PROV_INFO").field("cbSize", &self.cbSize).field("cStoreProvFunc", &self.cStoreProvFunc).field("rgpvStoreProvFunc", &self.rgpvStoreProvFunc).field("hStoreProv", &self.hStoreProv).field("dwStoreProvFlags", &self.dwStoreProvFlags).field("hStoreProvFuncAddr2", &self.hStoreProvFuncAddr2).finish()
    }
}
impl windows_core::TypeKind for CERT_STORE_PROV_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_STORE_PROV_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.cStoreProvFunc == other.cStoreProvFunc && self.rgpvStoreProvFunc == other.rgpvStoreProvFunc && self.hStoreProv == other.hStoreProv && self.dwStoreProvFlags == other.dwStoreProvFlags && self.hStoreProvFuncAddr2 == other.hStoreProvFuncAddr2
    }
}
impl Eq for CERT_STORE_PROV_INFO {}
impl Default for CERT_STORE_PROV_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_STRONG_SIGN_PARA {
    pub cbSize: u32,
    pub dwInfoChoice: u32,
    pub Anonymous: CERT_STRONG_SIGN_PARA_0,
}
impl Copy for CERT_STRONG_SIGN_PARA {}
impl Clone for CERT_STRONG_SIGN_PARA {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CERT_STRONG_SIGN_PARA {
    type TypeKind = windows_core::CopyType;
}
impl Default for CERT_STRONG_SIGN_PARA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub union CERT_STRONG_SIGN_PARA_0 {
    pub pvInfo: *mut core::ffi::c_void,
    pub pSerializedInfo: *mut CERT_STRONG_SIGN_SERIALIZED_INFO,
    pub pszOID: windows_core::PSTR,
}
impl Copy for CERT_STRONG_SIGN_PARA_0 {}
impl Clone for CERT_STRONG_SIGN_PARA_0 {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CERT_STRONG_SIGN_PARA_0 {
    type TypeKind = windows_core::CopyType;
}
impl Default for CERT_STRONG_SIGN_PARA_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_STRONG_SIGN_SERIALIZED_INFO {
    pub dwFlags: CERT_STRONG_SIGN_FLAGS,
    pub pwszCNGSignHashAlgids: windows_core::PWSTR,
    pub pwszCNGPubKeyMinBitLengths: windows_core::PWSTR,
}
impl Copy for CERT_STRONG_SIGN_SERIALIZED_INFO {}
impl Clone for CERT_STRONG_SIGN_SERIALIZED_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_STRONG_SIGN_SERIALIZED_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_STRONG_SIGN_SERIALIZED_INFO").field("dwFlags", &self.dwFlags).field("pwszCNGSignHashAlgids", &self.pwszCNGSignHashAlgids).field("pwszCNGPubKeyMinBitLengths", &self.pwszCNGPubKeyMinBitLengths).finish()
    }
}
impl windows_core::TypeKind for CERT_STRONG_SIGN_SERIALIZED_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_STRONG_SIGN_SERIALIZED_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwFlags == other.dwFlags && self.pwszCNGSignHashAlgids == other.pwszCNGSignHashAlgids && self.pwszCNGPubKeyMinBitLengths == other.pwszCNGPubKeyMinBitLengths
    }
}
impl Eq for CERT_STRONG_SIGN_SERIALIZED_INFO {}
impl Default for CERT_STRONG_SIGN_SERIALIZED_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_SUPPORTED_ALGORITHM_INFO {
    pub Algorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub IntendedKeyUsage: CRYPT_BIT_BLOB,
    pub IntendedCertPolicies: CERT_POLICIES_INFO,
}
impl Copy for CERT_SUPPORTED_ALGORITHM_INFO {}
impl Clone for CERT_SUPPORTED_ALGORITHM_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_SUPPORTED_ALGORITHM_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_SUPPORTED_ALGORITHM_INFO").field("Algorithm", &self.Algorithm).field("IntendedKeyUsage", &self.IntendedKeyUsage).field("IntendedCertPolicies", &self.IntendedCertPolicies).finish()
    }
}
impl windows_core::TypeKind for CERT_SUPPORTED_ALGORITHM_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_SUPPORTED_ALGORITHM_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.Algorithm == other.Algorithm && self.IntendedKeyUsage == other.IntendedKeyUsage && self.IntendedCertPolicies == other.IntendedCertPolicies
    }
}
impl Eq for CERT_SUPPORTED_ALGORITHM_INFO {}
impl Default for CERT_SUPPORTED_ALGORITHM_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_SYSTEM_STORE_INFO {
    pub cbSize: u32,
}
impl Copy for CERT_SYSTEM_STORE_INFO {}
impl Clone for CERT_SYSTEM_STORE_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_SYSTEM_STORE_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_SYSTEM_STORE_INFO").field("cbSize", &self.cbSize).finish()
    }
}
impl windows_core::TypeKind for CERT_SYSTEM_STORE_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_SYSTEM_STORE_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize
    }
}
impl Eq for CERT_SYSTEM_STORE_INFO {}
impl Default for CERT_SYSTEM_STORE_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_System_Registry")]
pub struct CERT_SYSTEM_STORE_RELOCATE_PARA {
    pub Anonymous1: CERT_SYSTEM_STORE_RELOCATE_PARA_0,
    pub Anonymous2: CERT_SYSTEM_STORE_RELOCATE_PARA_1,
}
#[cfg(feature = "Win32_System_Registry")]
impl Copy for CERT_SYSTEM_STORE_RELOCATE_PARA {}
#[cfg(feature = "Win32_System_Registry")]
impl Clone for CERT_SYSTEM_STORE_RELOCATE_PARA {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_System_Registry")]
impl windows_core::TypeKind for CERT_SYSTEM_STORE_RELOCATE_PARA {
    type TypeKind = windows_core::CopyType;
}
#[cfg(feature = "Win32_System_Registry")]
impl Default for CERT_SYSTEM_STORE_RELOCATE_PARA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_System_Registry")]
pub union CERT_SYSTEM_STORE_RELOCATE_PARA_0 {
    pub hKeyBase: super::super::System::Registry::HKEY,
    pub pvBase: *mut core::ffi::c_void,
}
#[cfg(feature = "Win32_System_Registry")]
impl Copy for CERT_SYSTEM_STORE_RELOCATE_PARA_0 {}
#[cfg(feature = "Win32_System_Registry")]
impl Clone for CERT_SYSTEM_STORE_RELOCATE_PARA_0 {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_System_Registry")]
impl windows_core::TypeKind for CERT_SYSTEM_STORE_RELOCATE_PARA_0 {
    type TypeKind = windows_core::CopyType;
}
#[cfg(feature = "Win32_System_Registry")]
impl Default for CERT_SYSTEM_STORE_RELOCATE_PARA_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_System_Registry")]
pub union CERT_SYSTEM_STORE_RELOCATE_PARA_1 {
    pub pvSystemStore: *mut core::ffi::c_void,
    pub pszSystemStore: windows_core::PCSTR,
    pub pwszSystemStore: windows_core::PCWSTR,
}
#[cfg(feature = "Win32_System_Registry")]
impl Copy for CERT_SYSTEM_STORE_RELOCATE_PARA_1 {}
#[cfg(feature = "Win32_System_Registry")]
impl Clone for CERT_SYSTEM_STORE_RELOCATE_PARA_1 {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_System_Registry")]
impl windows_core::TypeKind for CERT_SYSTEM_STORE_RELOCATE_PARA_1 {
    type TypeKind = windows_core::CopyType;
}
#[cfg(feature = "Win32_System_Registry")]
impl Default for CERT_SYSTEM_STORE_RELOCATE_PARA_1 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_TEMPLATE_EXT {
    pub pszObjId: windows_core::PSTR,
    pub dwMajorVersion: u32,
    pub fMinorVersion: super::super::Foundation::BOOL,
    pub dwMinorVersion: u32,
}
impl Copy for CERT_TEMPLATE_EXT {}
impl Clone for CERT_TEMPLATE_EXT {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_TEMPLATE_EXT {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_TEMPLATE_EXT").field("pszObjId", &self.pszObjId).field("dwMajorVersion", &self.dwMajorVersion).field("fMinorVersion", &self.fMinorVersion).field("dwMinorVersion", &self.dwMinorVersion).finish()
    }
}
impl windows_core::TypeKind for CERT_TEMPLATE_EXT {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_TEMPLATE_EXT {
    fn eq(&self, other: &Self) -> bool {
        self.pszObjId == other.pszObjId && self.dwMajorVersion == other.dwMajorVersion && self.fMinorVersion == other.fMinorVersion && self.dwMinorVersion == other.dwMinorVersion
    }
}
impl Eq for CERT_TEMPLATE_EXT {}
impl Default for CERT_TEMPLATE_EXT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_TPM_SPECIFICATION_INFO {
    pub pwszFamily: windows_core::PWSTR,
    pub dwLevel: u32,
    pub dwRevision: u32,
}
impl Copy for CERT_TPM_SPECIFICATION_INFO {}
impl Clone for CERT_TPM_SPECIFICATION_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_TPM_SPECIFICATION_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_TPM_SPECIFICATION_INFO").field("pwszFamily", &self.pwszFamily).field("dwLevel", &self.dwLevel).field("dwRevision", &self.dwRevision).finish()
    }
}
impl windows_core::TypeKind for CERT_TPM_SPECIFICATION_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_TPM_SPECIFICATION_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.pwszFamily == other.pwszFamily && self.dwLevel == other.dwLevel && self.dwRevision == other.dwRevision
    }
}
impl Eq for CERT_TPM_SPECIFICATION_INFO {}
impl Default for CERT_TPM_SPECIFICATION_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_TRUST_LIST_INFO {
    pub cbSize: u32,
    pub pCtlEntry: *mut CTL_ENTRY,
    pub pCtlContext: *mut CTL_CONTEXT,
}
impl Copy for CERT_TRUST_LIST_INFO {}
impl Clone for CERT_TRUST_LIST_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_TRUST_LIST_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_TRUST_LIST_INFO").field("cbSize", &self.cbSize).field("pCtlEntry", &self.pCtlEntry).field("pCtlContext", &self.pCtlContext).finish()
    }
}
impl windows_core::TypeKind for CERT_TRUST_LIST_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_TRUST_LIST_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.pCtlEntry == other.pCtlEntry && self.pCtlContext == other.pCtlContext
    }
}
impl Eq for CERT_TRUST_LIST_INFO {}
impl Default for CERT_TRUST_LIST_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_TRUST_STATUS {
    pub dwErrorStatus: u32,
    pub dwInfoStatus: u32,
}
impl Copy for CERT_TRUST_STATUS {}
impl Clone for CERT_TRUST_STATUS {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_TRUST_STATUS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_TRUST_STATUS").field("dwErrorStatus", &self.dwErrorStatus).field("dwInfoStatus", &self.dwInfoStatus).finish()
    }
}
impl windows_core::TypeKind for CERT_TRUST_STATUS {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_TRUST_STATUS {
    fn eq(&self, other: &Self) -> bool {
        self.dwErrorStatus == other.dwErrorStatus && self.dwInfoStatus == other.dwInfoStatus
    }
}
impl Eq for CERT_TRUST_STATUS {}
impl Default for CERT_TRUST_STATUS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_USAGE_MATCH {
    pub dwType: u32,
    pub Usage: CTL_USAGE,
}
impl Copy for CERT_USAGE_MATCH {}
impl Clone for CERT_USAGE_MATCH {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_USAGE_MATCH {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_USAGE_MATCH").field("dwType", &self.dwType).field("Usage", &self.Usage).finish()
    }
}
impl windows_core::TypeKind for CERT_USAGE_MATCH {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_USAGE_MATCH {
    fn eq(&self, other: &Self) -> bool {
        self.dwType == other.dwType && self.Usage == other.Usage
    }
}
impl Eq for CERT_USAGE_MATCH {}
impl Default for CERT_USAGE_MATCH {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_X942_DH_PARAMETERS {
    pub p: CRYPT_INTEGER_BLOB,
    pub g: CRYPT_INTEGER_BLOB,
    pub q: CRYPT_INTEGER_BLOB,
    pub j: CRYPT_INTEGER_BLOB,
    pub pValidationParams: *mut CERT_X942_DH_VALIDATION_PARAMS,
}
impl Copy for CERT_X942_DH_PARAMETERS {}
impl Clone for CERT_X942_DH_PARAMETERS {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_X942_DH_PARAMETERS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_X942_DH_PARAMETERS").field("p", &self.p).field("g", &self.g).field("q", &self.q).field("j", &self.j).field("pValidationParams", &self.pValidationParams).finish()
    }
}
impl windows_core::TypeKind for CERT_X942_DH_PARAMETERS {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_X942_DH_PARAMETERS {
    fn eq(&self, other: &Self) -> bool {
        self.p == other.p && self.g == other.g && self.q == other.q && self.j == other.j && self.pValidationParams == other.pValidationParams
    }
}
impl Eq for CERT_X942_DH_PARAMETERS {}
impl Default for CERT_X942_DH_PARAMETERS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CERT_X942_DH_VALIDATION_PARAMS {
    pub seed: CRYPT_BIT_BLOB,
    pub pgenCounter: u32,
}
impl Copy for CERT_X942_DH_VALIDATION_PARAMS {}
impl Clone for CERT_X942_DH_VALIDATION_PARAMS {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CERT_X942_DH_VALIDATION_PARAMS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CERT_X942_DH_VALIDATION_PARAMS").field("seed", &self.seed).field("pgenCounter", &self.pgenCounter).finish()
    }
}
impl windows_core::TypeKind for CERT_X942_DH_VALIDATION_PARAMS {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CERT_X942_DH_VALIDATION_PARAMS {
    fn eq(&self, other: &Self) -> bool {
        self.seed == other.seed && self.pgenCounter == other.pgenCounter
    }
}
impl Eq for CERT_X942_DH_VALIDATION_PARAMS {}
impl Default for CERT_X942_DH_VALIDATION_PARAMS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CLAIMLIST {
    pub count: u32,
    pub claims: *const windows_core::PCWSTR,
}
impl Copy for CLAIMLIST {}
impl Clone for CLAIMLIST {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CLAIMLIST {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CLAIMLIST").field("count", &self.count).field("claims", &self.claims).finish()
    }
}
impl windows_core::TypeKind for CLAIMLIST {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CLAIMLIST {
    fn eq(&self, other: &Self) -> bool {
        self.count == other.count && self.claims == other.claims
    }
}
impl Eq for CLAIMLIST {}
impl Default for CLAIMLIST {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMC_ADD_ATTRIBUTES_INFO {
    pub dwCmcDataReference: u32,
    pub cCertReference: u32,
    pub rgdwCertReference: *mut u32,
    pub cAttribute: u32,
    pub rgAttribute: *mut CRYPT_ATTRIBUTE,
}
impl Copy for CMC_ADD_ATTRIBUTES_INFO {}
impl Clone for CMC_ADD_ATTRIBUTES_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CMC_ADD_ATTRIBUTES_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CMC_ADD_ATTRIBUTES_INFO").field("dwCmcDataReference", &self.dwCmcDataReference).field("cCertReference", &self.cCertReference).field("rgdwCertReference", &self.rgdwCertReference).field("cAttribute", &self.cAttribute).field("rgAttribute", &self.rgAttribute).finish()
    }
}
impl windows_core::TypeKind for CMC_ADD_ATTRIBUTES_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CMC_ADD_ATTRIBUTES_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwCmcDataReference == other.dwCmcDataReference && self.cCertReference == other.cCertReference && self.rgdwCertReference == other.rgdwCertReference && self.cAttribute == other.cAttribute && self.rgAttribute == other.rgAttribute
    }
}
impl Eq for CMC_ADD_ATTRIBUTES_INFO {}
impl Default for CMC_ADD_ATTRIBUTES_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMC_ADD_EXTENSIONS_INFO {
    pub dwCmcDataReference: u32,
    pub cCertReference: u32,
    pub rgdwCertReference: *mut u32,
    pub cExtension: u32,
    pub rgExtension: *mut CERT_EXTENSION,
}
impl Copy for CMC_ADD_EXTENSIONS_INFO {}
impl Clone for CMC_ADD_EXTENSIONS_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CMC_ADD_EXTENSIONS_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CMC_ADD_EXTENSIONS_INFO").field("dwCmcDataReference", &self.dwCmcDataReference).field("cCertReference", &self.cCertReference).field("rgdwCertReference", &self.rgdwCertReference).field("cExtension", &self.cExtension).field("rgExtension", &self.rgExtension).finish()
    }
}
impl windows_core::TypeKind for CMC_ADD_EXTENSIONS_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CMC_ADD_EXTENSIONS_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwCmcDataReference == other.dwCmcDataReference && self.cCertReference == other.cCertReference && self.rgdwCertReference == other.rgdwCertReference && self.cExtension == other.cExtension && self.rgExtension == other.rgExtension
    }
}
impl Eq for CMC_ADD_EXTENSIONS_INFO {}
impl Default for CMC_ADD_EXTENSIONS_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMC_DATA_INFO {
    pub cTaggedAttribute: u32,
    pub rgTaggedAttribute: *mut CMC_TAGGED_ATTRIBUTE,
    pub cTaggedRequest: u32,
    pub rgTaggedRequest: *mut CMC_TAGGED_REQUEST,
    pub cTaggedContentInfo: u32,
    pub rgTaggedContentInfo: *mut CMC_TAGGED_CONTENT_INFO,
    pub cTaggedOtherMsg: u32,
    pub rgTaggedOtherMsg: *mut CMC_TAGGED_OTHER_MSG,
}
impl Copy for CMC_DATA_INFO {}
impl Clone for CMC_DATA_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CMC_DATA_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CMC_DATA_INFO").field("cTaggedAttribute", &self.cTaggedAttribute).field("rgTaggedAttribute", &self.rgTaggedAttribute).field("cTaggedRequest", &self.cTaggedRequest).field("rgTaggedRequest", &self.rgTaggedRequest).field("cTaggedContentInfo", &self.cTaggedContentInfo).field("rgTaggedContentInfo", &self.rgTaggedContentInfo).field("cTaggedOtherMsg", &self.cTaggedOtherMsg).field("rgTaggedOtherMsg", &self.rgTaggedOtherMsg).finish()
    }
}
impl windows_core::TypeKind for CMC_DATA_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CMC_DATA_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cTaggedAttribute == other.cTaggedAttribute && self.rgTaggedAttribute == other.rgTaggedAttribute && self.cTaggedRequest == other.cTaggedRequest && self.rgTaggedRequest == other.rgTaggedRequest && self.cTaggedContentInfo == other.cTaggedContentInfo && self.rgTaggedContentInfo == other.rgTaggedContentInfo && self.cTaggedOtherMsg == other.cTaggedOtherMsg && self.rgTaggedOtherMsg == other.rgTaggedOtherMsg
    }
}
impl Eq for CMC_DATA_INFO {}
impl Default for CMC_DATA_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMC_PEND_INFO {
    pub PendToken: CRYPT_INTEGER_BLOB,
    pub PendTime: super::super::Foundation::FILETIME,
}
impl Copy for CMC_PEND_INFO {}
impl Clone for CMC_PEND_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CMC_PEND_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CMC_PEND_INFO").field("PendToken", &self.PendToken).field("PendTime", &self.PendTime).finish()
    }
}
impl windows_core::TypeKind for CMC_PEND_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CMC_PEND_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.PendToken == other.PendToken && self.PendTime == other.PendTime
    }
}
impl Eq for CMC_PEND_INFO {}
impl Default for CMC_PEND_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMC_RESPONSE_INFO {
    pub cTaggedAttribute: u32,
    pub rgTaggedAttribute: *mut CMC_TAGGED_ATTRIBUTE,
    pub cTaggedContentInfo: u32,
    pub rgTaggedContentInfo: *mut CMC_TAGGED_CONTENT_INFO,
    pub cTaggedOtherMsg: u32,
    pub rgTaggedOtherMsg: *mut CMC_TAGGED_OTHER_MSG,
}
impl Copy for CMC_RESPONSE_INFO {}
impl Clone for CMC_RESPONSE_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CMC_RESPONSE_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CMC_RESPONSE_INFO").field("cTaggedAttribute", &self.cTaggedAttribute).field("rgTaggedAttribute", &self.rgTaggedAttribute).field("cTaggedContentInfo", &self.cTaggedContentInfo).field("rgTaggedContentInfo", &self.rgTaggedContentInfo).field("cTaggedOtherMsg", &self.cTaggedOtherMsg).field("rgTaggedOtherMsg", &self.rgTaggedOtherMsg).finish()
    }
}
impl windows_core::TypeKind for CMC_RESPONSE_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CMC_RESPONSE_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cTaggedAttribute == other.cTaggedAttribute && self.rgTaggedAttribute == other.rgTaggedAttribute && self.cTaggedContentInfo == other.cTaggedContentInfo && self.rgTaggedContentInfo == other.rgTaggedContentInfo && self.cTaggedOtherMsg == other.cTaggedOtherMsg && self.rgTaggedOtherMsg == other.rgTaggedOtherMsg
    }
}
impl Eq for CMC_RESPONSE_INFO {}
impl Default for CMC_RESPONSE_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMC_STATUS_INFO {
    pub dwStatus: u32,
    pub cBodyList: u32,
    pub rgdwBodyList: *mut u32,
    pub pwszStatusString: windows_core::PWSTR,
    pub dwOtherInfoChoice: u32,
    pub Anonymous: CMC_STATUS_INFO_0,
}
impl Copy for CMC_STATUS_INFO {}
impl Clone for CMC_STATUS_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CMC_STATUS_INFO {
    type TypeKind = windows_core::CopyType;
}
impl Default for CMC_STATUS_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub union CMC_STATUS_INFO_0 {
    pub dwFailInfo: u32,
    pub pPendInfo: *mut CMC_PEND_INFO,
}
impl Copy for CMC_STATUS_INFO_0 {}
impl Clone for CMC_STATUS_INFO_0 {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CMC_STATUS_INFO_0 {
    type TypeKind = windows_core::CopyType;
}
impl Default for CMC_STATUS_INFO_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMC_TAGGED_ATTRIBUTE {
    pub dwBodyPartID: u32,
    pub Attribute: CRYPT_ATTRIBUTE,
}
impl Copy for CMC_TAGGED_ATTRIBUTE {}
impl Clone for CMC_TAGGED_ATTRIBUTE {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CMC_TAGGED_ATTRIBUTE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CMC_TAGGED_ATTRIBUTE").field("dwBodyPartID", &self.dwBodyPartID).field("Attribute", &self.Attribute).finish()
    }
}
impl windows_core::TypeKind for CMC_TAGGED_ATTRIBUTE {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CMC_TAGGED_ATTRIBUTE {
    fn eq(&self, other: &Self) -> bool {
        self.dwBodyPartID == other.dwBodyPartID && self.Attribute == other.Attribute
    }
}
impl Eq for CMC_TAGGED_ATTRIBUTE {}
impl Default for CMC_TAGGED_ATTRIBUTE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMC_TAGGED_CERT_REQUEST {
    pub dwBodyPartID: u32,
    pub SignedCertRequest: CRYPT_INTEGER_BLOB,
}
impl Copy for CMC_TAGGED_CERT_REQUEST {}
impl Clone for CMC_TAGGED_CERT_REQUEST {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CMC_TAGGED_CERT_REQUEST {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CMC_TAGGED_CERT_REQUEST").field("dwBodyPartID", &self.dwBodyPartID).field("SignedCertRequest", &self.SignedCertRequest).finish()
    }
}
impl windows_core::TypeKind for CMC_TAGGED_CERT_REQUEST {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CMC_TAGGED_CERT_REQUEST {
    fn eq(&self, other: &Self) -> bool {
        self.dwBodyPartID == other.dwBodyPartID && self.SignedCertRequest == other.SignedCertRequest
    }
}
impl Eq for CMC_TAGGED_CERT_REQUEST {}
impl Default for CMC_TAGGED_CERT_REQUEST {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMC_TAGGED_CONTENT_INFO {
    pub dwBodyPartID: u32,
    pub EncodedContentInfo: CRYPT_INTEGER_BLOB,
}
impl Copy for CMC_TAGGED_CONTENT_INFO {}
impl Clone for CMC_TAGGED_CONTENT_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CMC_TAGGED_CONTENT_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CMC_TAGGED_CONTENT_INFO").field("dwBodyPartID", &self.dwBodyPartID).field("EncodedContentInfo", &self.EncodedContentInfo).finish()
    }
}
impl windows_core::TypeKind for CMC_TAGGED_CONTENT_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CMC_TAGGED_CONTENT_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwBodyPartID == other.dwBodyPartID && self.EncodedContentInfo == other.EncodedContentInfo
    }
}
impl Eq for CMC_TAGGED_CONTENT_INFO {}
impl Default for CMC_TAGGED_CONTENT_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMC_TAGGED_OTHER_MSG {
    pub dwBodyPartID: u32,
    pub pszObjId: windows_core::PSTR,
    pub Value: CRYPT_INTEGER_BLOB,
}
impl Copy for CMC_TAGGED_OTHER_MSG {}
impl Clone for CMC_TAGGED_OTHER_MSG {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CMC_TAGGED_OTHER_MSG {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CMC_TAGGED_OTHER_MSG").field("dwBodyPartID", &self.dwBodyPartID).field("pszObjId", &self.pszObjId).field("Value", &self.Value).finish()
    }
}
impl windows_core::TypeKind for CMC_TAGGED_OTHER_MSG {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CMC_TAGGED_OTHER_MSG {
    fn eq(&self, other: &Self) -> bool {
        self.dwBodyPartID == other.dwBodyPartID && self.pszObjId == other.pszObjId && self.Value == other.Value
    }
}
impl Eq for CMC_TAGGED_OTHER_MSG {}
impl Default for CMC_TAGGED_OTHER_MSG {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMC_TAGGED_REQUEST {
    pub dwTaggedRequestChoice: u32,
    pub Anonymous: CMC_TAGGED_REQUEST_0,
}
impl Copy for CMC_TAGGED_REQUEST {}
impl Clone for CMC_TAGGED_REQUEST {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CMC_TAGGED_REQUEST {
    type TypeKind = windows_core::CopyType;
}
impl Default for CMC_TAGGED_REQUEST {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub union CMC_TAGGED_REQUEST_0 {
    pub pTaggedCertRequest: *mut CMC_TAGGED_CERT_REQUEST,
}
impl Copy for CMC_TAGGED_REQUEST_0 {}
impl Clone for CMC_TAGGED_REQUEST_0 {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CMC_TAGGED_REQUEST_0 {
    type TypeKind = windows_core::CopyType;
}
impl Default for CMC_TAGGED_REQUEST_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const CMSCEPSetup: windows_core::GUID = windows_core::GUID::from_u128(0xaa4f5c02_8e7c_49c4_94fa_67a5cc5eadb4);
#[repr(C)]
pub struct CMSG_CMS_RECIPIENT_INFO {
    pub dwRecipientChoice: u32,
    pub Anonymous: CMSG_CMS_RECIPIENT_INFO_0,
}
impl Copy for CMSG_CMS_RECIPIENT_INFO {}
impl Clone for CMSG_CMS_RECIPIENT_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CMSG_CMS_RECIPIENT_INFO {
    type TypeKind = windows_core::CopyType;
}
impl Default for CMSG_CMS_RECIPIENT_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub union CMSG_CMS_RECIPIENT_INFO_0 {
    pub pKeyTrans: *mut CMSG_KEY_TRANS_RECIPIENT_INFO,
    pub pKeyAgree: *mut CMSG_KEY_AGREE_RECIPIENT_INFO,
    pub pMailList: *mut CMSG_MAIL_LIST_RECIPIENT_INFO,
}
impl Copy for CMSG_CMS_RECIPIENT_INFO_0 {}
impl Clone for CMSG_CMS_RECIPIENT_INFO_0 {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CMSG_CMS_RECIPIENT_INFO_0 {
    type TypeKind = windows_core::CopyType;
}
impl Default for CMSG_CMS_RECIPIENT_INFO_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMSG_CMS_SIGNER_INFO {
    pub dwVersion: u32,
    pub SignerId: CERT_ID,
    pub HashAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub HashEncryptionAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub EncryptedHash: CRYPT_INTEGER_BLOB,
    pub AuthAttrs: CRYPT_ATTRIBUTES,
    pub UnauthAttrs: CRYPT_ATTRIBUTES,
}
impl Copy for CMSG_CMS_SIGNER_INFO {}
impl Clone for CMSG_CMS_SIGNER_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CMSG_CMS_SIGNER_INFO {
    type TypeKind = windows_core::CopyType;
}
impl Default for CMSG_CMS_SIGNER_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMSG_CNG_CONTENT_DECRYPT_INFO {
    pub cbSize: u32,
    pub ContentEncryptionAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub pfnAlloc: PFN_CMSG_ALLOC,
    pub pfnFree: PFN_CMSG_FREE,
    pub hNCryptKey: NCRYPT_KEY_HANDLE,
    pub pbContentEncryptKey: *mut u8,
    pub cbContentEncryptKey: u32,
    pub hCNGContentEncryptKey: BCRYPT_KEY_HANDLE,
    pub pbCNGContentEncryptKeyObject: *mut u8,
}
impl Copy for CMSG_CNG_CONTENT_DECRYPT_INFO {}
impl Clone for CMSG_CNG_CONTENT_DECRYPT_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CMSG_CNG_CONTENT_DECRYPT_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CMSG_CNG_CONTENT_DECRYPT_INFO").field("cbSize", &self.cbSize).field("ContentEncryptionAlgorithm", &self.ContentEncryptionAlgorithm).field("hNCryptKey", &self.hNCryptKey).field("pbContentEncryptKey", &self.pbContentEncryptKey).field("cbContentEncryptKey", &self.cbContentEncryptKey).field("hCNGContentEncryptKey", &self.hCNGContentEncryptKey).field("pbCNGContentEncryptKeyObject", &self.pbCNGContentEncryptKeyObject).finish()
    }
}
impl windows_core::TypeKind for CMSG_CNG_CONTENT_DECRYPT_INFO {
    type TypeKind = windows_core::CopyType;
}
impl Default for CMSG_CNG_CONTENT_DECRYPT_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMSG_CONTENT_ENCRYPT_INFO {
    pub cbSize: u32,
    pub hCryptProv: HCRYPTPROV_LEGACY,
    pub ContentEncryptionAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub pvEncryptionAuxInfo: *mut core::ffi::c_void,
    pub cRecipients: u32,
    pub rgCmsRecipients: *mut CMSG_RECIPIENT_ENCODE_INFO,
    pub pfnAlloc: PFN_CMSG_ALLOC,
    pub pfnFree: PFN_CMSG_FREE,
    pub dwEncryptFlags: u32,
    pub Anonymous: CMSG_CONTENT_ENCRYPT_INFO_0,
    pub dwFlags: u32,
    pub fCNG: super::super::Foundation::BOOL,
    pub pbCNGContentEncryptKeyObject: *mut u8,
    pub pbContentEncryptKey: *mut u8,
    pub cbContentEncryptKey: u32,
}
impl Copy for CMSG_CONTENT_ENCRYPT_INFO {}
impl Clone for CMSG_CONTENT_ENCRYPT_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CMSG_CONTENT_ENCRYPT_INFO {
    type TypeKind = windows_core::CopyType;
}
impl Default for CMSG_CONTENT_ENCRYPT_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub union CMSG_CONTENT_ENCRYPT_INFO_0 {
    pub hContentEncryptKey: usize,
    pub hCNGContentEncryptKey: BCRYPT_KEY_HANDLE,
}
impl Copy for CMSG_CONTENT_ENCRYPT_INFO_0 {}
impl Clone for CMSG_CONTENT_ENCRYPT_INFO_0 {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CMSG_CONTENT_ENCRYPT_INFO_0 {
    type TypeKind = windows_core::CopyType;
}
impl Default for CMSG_CONTENT_ENCRYPT_INFO_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMSG_CTRL_ADD_SIGNER_UNAUTH_ATTR_PARA {
    pub cbSize: u32,
    pub dwSignerIndex: u32,
    pub blob: CRYPT_INTEGER_BLOB,
}
impl Copy for CMSG_CTRL_ADD_SIGNER_UNAUTH_ATTR_PARA {}
impl Clone for CMSG_CTRL_ADD_SIGNER_UNAUTH_ATTR_PARA {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CMSG_CTRL_ADD_SIGNER_UNAUTH_ATTR_PARA {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CMSG_CTRL_ADD_SIGNER_UNAUTH_ATTR_PARA").field("cbSize", &self.cbSize).field("dwSignerIndex", &self.dwSignerIndex).field("blob", &self.blob).finish()
    }
}
impl windows_core::TypeKind for CMSG_CTRL_ADD_SIGNER_UNAUTH_ATTR_PARA {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CMSG_CTRL_ADD_SIGNER_UNAUTH_ATTR_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwSignerIndex == other.dwSignerIndex && self.blob == other.blob
    }
}
impl Eq for CMSG_CTRL_ADD_SIGNER_UNAUTH_ATTR_PARA {}
impl Default for CMSG_CTRL_ADD_SIGNER_UNAUTH_ATTR_PARA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMSG_CTRL_DECRYPT_PARA {
    pub cbSize: u32,
    pub Anonymous: CMSG_CTRL_DECRYPT_PARA_0,
    pub dwKeySpec: u32,
    pub dwRecipientIndex: u32,
}
impl Copy for CMSG_CTRL_DECRYPT_PARA {}
impl Clone for CMSG_CTRL_DECRYPT_PARA {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CMSG_CTRL_DECRYPT_PARA {
    type TypeKind = windows_core::CopyType;
}
impl Default for CMSG_CTRL_DECRYPT_PARA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub union CMSG_CTRL_DECRYPT_PARA_0 {
    pub hCryptProv: usize,
    pub hNCryptKey: NCRYPT_KEY_HANDLE,
}
impl Copy for CMSG_CTRL_DECRYPT_PARA_0 {}
impl Clone for CMSG_CTRL_DECRYPT_PARA_0 {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CMSG_CTRL_DECRYPT_PARA_0 {
    type TypeKind = windows_core::CopyType;
}
impl Default for CMSG_CTRL_DECRYPT_PARA_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMSG_CTRL_DEL_SIGNER_UNAUTH_ATTR_PARA {
    pub cbSize: u32,
    pub dwSignerIndex: u32,
    pub dwUnauthAttrIndex: u32,
}
impl Copy for CMSG_CTRL_DEL_SIGNER_UNAUTH_ATTR_PARA {}
impl Clone for CMSG_CTRL_DEL_SIGNER_UNAUTH_ATTR_PARA {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CMSG_CTRL_DEL_SIGNER_UNAUTH_ATTR_PARA {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CMSG_CTRL_DEL_SIGNER_UNAUTH_ATTR_PARA").field("cbSize", &self.cbSize).field("dwSignerIndex", &self.dwSignerIndex).field("dwUnauthAttrIndex", &self.dwUnauthAttrIndex).finish()
    }
}
impl windows_core::TypeKind for CMSG_CTRL_DEL_SIGNER_UNAUTH_ATTR_PARA {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CMSG_CTRL_DEL_SIGNER_UNAUTH_ATTR_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwSignerIndex == other.dwSignerIndex && self.dwUnauthAttrIndex == other.dwUnauthAttrIndex
    }
}
impl Eq for CMSG_CTRL_DEL_SIGNER_UNAUTH_ATTR_PARA {}
impl Default for CMSG_CTRL_DEL_SIGNER_UNAUTH_ATTR_PARA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMSG_CTRL_KEY_AGREE_DECRYPT_PARA {
    pub cbSize: u32,
    pub Anonymous: CMSG_CTRL_KEY_AGREE_DECRYPT_PARA_0,
    pub dwKeySpec: u32,
    pub pKeyAgree: *mut CMSG_KEY_AGREE_RECIPIENT_INFO,
    pub dwRecipientIndex: u32,
    pub dwRecipientEncryptedKeyIndex: u32,
    pub OriginatorPublicKey: CRYPT_BIT_BLOB,
}
impl Copy for CMSG_CTRL_KEY_AGREE_DECRYPT_PARA {}
impl Clone for CMSG_CTRL_KEY_AGREE_DECRYPT_PARA {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CMSG_CTRL_KEY_AGREE_DECRYPT_PARA {
    type TypeKind = windows_core::CopyType;
}
impl Default for CMSG_CTRL_KEY_AGREE_DECRYPT_PARA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub union CMSG_CTRL_KEY_AGREE_DECRYPT_PARA_0 {
    pub hCryptProv: usize,
    pub hNCryptKey: NCRYPT_KEY_HANDLE,
}
impl Copy for CMSG_CTRL_KEY_AGREE_DECRYPT_PARA_0 {}
impl Clone for CMSG_CTRL_KEY_AGREE_DECRYPT_PARA_0 {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CMSG_CTRL_KEY_AGREE_DECRYPT_PARA_0 {
    type TypeKind = windows_core::CopyType;
}
impl Default for CMSG_CTRL_KEY_AGREE_DECRYPT_PARA_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMSG_CTRL_KEY_TRANS_DECRYPT_PARA {
    pub cbSize: u32,
    pub Anonymous: CMSG_CTRL_KEY_TRANS_DECRYPT_PARA_0,
    pub dwKeySpec: u32,
    pub pKeyTrans: *mut CMSG_KEY_TRANS_RECIPIENT_INFO,
    pub dwRecipientIndex: u32,
}
impl Copy for CMSG_CTRL_KEY_TRANS_DECRYPT_PARA {}
impl Clone for CMSG_CTRL_KEY_TRANS_DECRYPT_PARA {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CMSG_CTRL_KEY_TRANS_DECRYPT_PARA {
    type TypeKind = windows_core::CopyType;
}
impl Default for CMSG_CTRL_KEY_TRANS_DECRYPT_PARA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub union CMSG_CTRL_KEY_TRANS_DECRYPT_PARA_0 {
    pub hCryptProv: usize,
    pub hNCryptKey: NCRYPT_KEY_HANDLE,
}
impl Copy for CMSG_CTRL_KEY_TRANS_DECRYPT_PARA_0 {}
impl Clone for CMSG_CTRL_KEY_TRANS_DECRYPT_PARA_0 {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CMSG_CTRL_KEY_TRANS_DECRYPT_PARA_0 {
    type TypeKind = windows_core::CopyType;
}
impl Default for CMSG_CTRL_KEY_TRANS_DECRYPT_PARA_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMSG_CTRL_MAIL_LIST_DECRYPT_PARA {
    pub cbSize: u32,
    pub hCryptProv: usize,
    pub pMailList: *mut CMSG_MAIL_LIST_RECIPIENT_INFO,
    pub dwRecipientIndex: u32,
    pub dwKeyChoice: u32,
    pub Anonymous: CMSG_CTRL_MAIL_LIST_DECRYPT_PARA_0,
}
impl Copy for CMSG_CTRL_MAIL_LIST_DECRYPT_PARA {}
impl Clone for CMSG_CTRL_MAIL_LIST_DECRYPT_PARA {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CMSG_CTRL_MAIL_LIST_DECRYPT_PARA {
    type TypeKind = windows_core::CopyType;
}
impl Default for CMSG_CTRL_MAIL_LIST_DECRYPT_PARA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub union CMSG_CTRL_MAIL_LIST_DECRYPT_PARA_0 {
    pub hKeyEncryptionKey: usize,
    pub pvKeyEncryptionKey: *mut core::ffi::c_void,
}
impl Copy for CMSG_CTRL_MAIL_LIST_DECRYPT_PARA_0 {}
impl Clone for CMSG_CTRL_MAIL_LIST_DECRYPT_PARA_0 {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CMSG_CTRL_MAIL_LIST_DECRYPT_PARA_0 {
    type TypeKind = windows_core::CopyType;
}
impl Default for CMSG_CTRL_MAIL_LIST_DECRYPT_PARA_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMSG_CTRL_VERIFY_SIGNATURE_EX_PARA {
    pub cbSize: u32,
    pub hCryptProv: HCRYPTPROV_LEGACY,
    pub dwSignerIndex: u32,
    pub dwSignerType: u32,
    pub pvSigner: *mut core::ffi::c_void,
}
impl Copy for CMSG_CTRL_VERIFY_SIGNATURE_EX_PARA {}
impl Clone for CMSG_CTRL_VERIFY_SIGNATURE_EX_PARA {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CMSG_CTRL_VERIFY_SIGNATURE_EX_PARA {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CMSG_CTRL_VERIFY_SIGNATURE_EX_PARA").field("cbSize", &self.cbSize).field("hCryptProv", &self.hCryptProv).field("dwSignerIndex", &self.dwSignerIndex).field("dwSignerType", &self.dwSignerType).field("pvSigner", &self.pvSigner).finish()
    }
}
impl windows_core::TypeKind for CMSG_CTRL_VERIFY_SIGNATURE_EX_PARA {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CMSG_CTRL_VERIFY_SIGNATURE_EX_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.hCryptProv == other.hCryptProv && self.dwSignerIndex == other.dwSignerIndex && self.dwSignerType == other.dwSignerType && self.pvSigner == other.pvSigner
    }
}
impl Eq for CMSG_CTRL_VERIFY_SIGNATURE_EX_PARA {}
impl Default for CMSG_CTRL_VERIFY_SIGNATURE_EX_PARA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMSG_ENCRYPTED_ENCODE_INFO {
    pub cbSize: u32,
    pub ContentEncryptionAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub pvEncryptionAuxInfo: *mut core::ffi::c_void,
}
impl Copy for CMSG_ENCRYPTED_ENCODE_INFO {}
impl Clone for CMSG_ENCRYPTED_ENCODE_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CMSG_ENCRYPTED_ENCODE_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CMSG_ENCRYPTED_ENCODE_INFO").field("cbSize", &self.cbSize).field("ContentEncryptionAlgorithm", &self.ContentEncryptionAlgorithm).field("pvEncryptionAuxInfo", &self.pvEncryptionAuxInfo).finish()
    }
}
impl windows_core::TypeKind for CMSG_ENCRYPTED_ENCODE_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CMSG_ENCRYPTED_ENCODE_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.ContentEncryptionAlgorithm == other.ContentEncryptionAlgorithm && self.pvEncryptionAuxInfo == other.pvEncryptionAuxInfo
    }
}
impl Eq for CMSG_ENCRYPTED_ENCODE_INFO {}
impl Default for CMSG_ENCRYPTED_ENCODE_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMSG_ENVELOPED_ENCODE_INFO {
    pub cbSize: u32,
    pub hCryptProv: HCRYPTPROV_LEGACY,
    pub ContentEncryptionAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub pvEncryptionAuxInfo: *mut core::ffi::c_void,
    pub cRecipients: u32,
    pub rgpRecipients: *mut *mut CERT_INFO,
}
impl Copy for CMSG_ENVELOPED_ENCODE_INFO {}
impl Clone for CMSG_ENVELOPED_ENCODE_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CMSG_ENVELOPED_ENCODE_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CMSG_ENVELOPED_ENCODE_INFO").field("cbSize", &self.cbSize).field("hCryptProv", &self.hCryptProv).field("ContentEncryptionAlgorithm", &self.ContentEncryptionAlgorithm).field("pvEncryptionAuxInfo", &self.pvEncryptionAuxInfo).field("cRecipients", &self.cRecipients).field("rgpRecipients", &self.rgpRecipients).finish()
    }
}
impl windows_core::TypeKind for CMSG_ENVELOPED_ENCODE_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CMSG_ENVELOPED_ENCODE_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.hCryptProv == other.hCryptProv && self.ContentEncryptionAlgorithm == other.ContentEncryptionAlgorithm && self.pvEncryptionAuxInfo == other.pvEncryptionAuxInfo && self.cRecipients == other.cRecipients && self.rgpRecipients == other.rgpRecipients
    }
}
impl Eq for CMSG_ENVELOPED_ENCODE_INFO {}
impl Default for CMSG_ENVELOPED_ENCODE_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMSG_HASHED_ENCODE_INFO {
    pub cbSize: u32,
    pub hCryptProv: HCRYPTPROV_LEGACY,
    pub HashAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub pvHashAuxInfo: *mut core::ffi::c_void,
}
impl Copy for CMSG_HASHED_ENCODE_INFO {}
impl Clone for CMSG_HASHED_ENCODE_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CMSG_HASHED_ENCODE_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CMSG_HASHED_ENCODE_INFO").field("cbSize", &self.cbSize).field("hCryptProv", &self.hCryptProv).field("HashAlgorithm", &self.HashAlgorithm).field("pvHashAuxInfo", &self.pvHashAuxInfo).finish()
    }
}
impl windows_core::TypeKind for CMSG_HASHED_ENCODE_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CMSG_HASHED_ENCODE_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.hCryptProv == other.hCryptProv && self.HashAlgorithm == other.HashAlgorithm && self.pvHashAuxInfo == other.pvHashAuxInfo
    }
}
impl Eq for CMSG_HASHED_ENCODE_INFO {}
impl Default for CMSG_HASHED_ENCODE_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMSG_KEY_AGREE_ENCRYPT_INFO {
    pub cbSize: u32,
    pub dwRecipientIndex: u32,
    pub KeyEncryptionAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub UserKeyingMaterial: CRYPT_INTEGER_BLOB,
    pub dwOriginatorChoice: CMSG_KEY_AGREE_ORIGINATOR,
    pub Anonymous: CMSG_KEY_AGREE_ENCRYPT_INFO_0,
    pub cKeyAgreeKeyEncryptInfo: u32,
    pub rgpKeyAgreeKeyEncryptInfo: *mut *mut CMSG_KEY_AGREE_KEY_ENCRYPT_INFO,
    pub dwFlags: u32,
}
impl Copy for CMSG_KEY_AGREE_ENCRYPT_INFO {}
impl Clone for CMSG_KEY_AGREE_ENCRYPT_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CMSG_KEY_AGREE_ENCRYPT_INFO {
    type TypeKind = windows_core::CopyType;
}
impl Default for CMSG_KEY_AGREE_ENCRYPT_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub union CMSG_KEY_AGREE_ENCRYPT_INFO_0 {
    pub OriginatorCertId: CERT_ID,
    pub OriginatorPublicKeyInfo: CERT_PUBLIC_KEY_INFO,
}
impl Copy for CMSG_KEY_AGREE_ENCRYPT_INFO_0 {}
impl Clone for CMSG_KEY_AGREE_ENCRYPT_INFO_0 {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CMSG_KEY_AGREE_ENCRYPT_INFO_0 {
    type TypeKind = windows_core::CopyType;
}
impl Default for CMSG_KEY_AGREE_ENCRYPT_INFO_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMSG_KEY_AGREE_KEY_ENCRYPT_INFO {
    pub cbSize: u32,
    pub EncryptedKey: CRYPT_INTEGER_BLOB,
}
impl Copy for CMSG_KEY_AGREE_KEY_ENCRYPT_INFO {}
impl Clone for CMSG_KEY_AGREE_KEY_ENCRYPT_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CMSG_KEY_AGREE_KEY_ENCRYPT_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CMSG_KEY_AGREE_KEY_ENCRYPT_INFO").field("cbSize", &self.cbSize).field("EncryptedKey", &self.EncryptedKey).finish()
    }
}
impl windows_core::TypeKind for CMSG_KEY_AGREE_KEY_ENCRYPT_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CMSG_KEY_AGREE_KEY_ENCRYPT_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.EncryptedKey == other.EncryptedKey
    }
}
impl Eq for CMSG_KEY_AGREE_KEY_ENCRYPT_INFO {}
impl Default for CMSG_KEY_AGREE_KEY_ENCRYPT_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMSG_KEY_AGREE_RECIPIENT_ENCODE_INFO {
    pub cbSize: u32,
    pub KeyEncryptionAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub pvKeyEncryptionAuxInfo: *mut core::ffi::c_void,
    pub KeyWrapAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub pvKeyWrapAuxInfo: *mut core::ffi::c_void,
    pub hCryptProv: HCRYPTPROV_LEGACY,
    pub dwKeySpec: u32,
    pub dwKeyChoice: CMSG_KEY_AGREE_OPTION,
    pub Anonymous: CMSG_KEY_AGREE_RECIPIENT_ENCODE_INFO_0,
    pub UserKeyingMaterial: CRYPT_INTEGER_BLOB,
    pub cRecipientEncryptedKeys: u32,
    pub rgpRecipientEncryptedKeys: *mut *mut CMSG_RECIPIENT_ENCRYPTED_KEY_ENCODE_INFO,
}
impl Copy for CMSG_KEY_AGREE_RECIPIENT_ENCODE_INFO {}
impl Clone for CMSG_KEY_AGREE_RECIPIENT_ENCODE_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CMSG_KEY_AGREE_RECIPIENT_ENCODE_INFO {
    type TypeKind = windows_core::CopyType;
}
impl Default for CMSG_KEY_AGREE_RECIPIENT_ENCODE_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub union CMSG_KEY_AGREE_RECIPIENT_ENCODE_INFO_0 {
    pub pEphemeralAlgorithm: *mut CRYPT_ALGORITHM_IDENTIFIER,
    pub pSenderId: *mut CERT_ID,
}
impl Copy for CMSG_KEY_AGREE_RECIPIENT_ENCODE_INFO_0 {}
impl Clone for CMSG_KEY_AGREE_RECIPIENT_ENCODE_INFO_0 {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CMSG_KEY_AGREE_RECIPIENT_ENCODE_INFO_0 {
    type TypeKind = windows_core::CopyType;
}
impl Default for CMSG_KEY_AGREE_RECIPIENT_ENCODE_INFO_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMSG_KEY_AGREE_RECIPIENT_INFO {
    pub dwVersion: u32,
    pub dwOriginatorChoice: CMSG_KEY_AGREE_ORIGINATOR,
    pub Anonymous: CMSG_KEY_AGREE_RECIPIENT_INFO_0,
    pub UserKeyingMaterial: CRYPT_INTEGER_BLOB,
    pub KeyEncryptionAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub cRecipientEncryptedKeys: u32,
    pub rgpRecipientEncryptedKeys: *mut *mut CMSG_RECIPIENT_ENCRYPTED_KEY_INFO,
}
impl Copy for CMSG_KEY_AGREE_RECIPIENT_INFO {}
impl Clone for CMSG_KEY_AGREE_RECIPIENT_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CMSG_KEY_AGREE_RECIPIENT_INFO {
    type TypeKind = windows_core::CopyType;
}
impl Default for CMSG_KEY_AGREE_RECIPIENT_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub union CMSG_KEY_AGREE_RECIPIENT_INFO_0 {
    pub OriginatorCertId: CERT_ID,
    pub OriginatorPublicKeyInfo: CERT_PUBLIC_KEY_INFO,
}
impl Copy for CMSG_KEY_AGREE_RECIPIENT_INFO_0 {}
impl Clone for CMSG_KEY_AGREE_RECIPIENT_INFO_0 {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CMSG_KEY_AGREE_RECIPIENT_INFO_0 {
    type TypeKind = windows_core::CopyType;
}
impl Default for CMSG_KEY_AGREE_RECIPIENT_INFO_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMSG_KEY_TRANS_ENCRYPT_INFO {
    pub cbSize: u32,
    pub dwRecipientIndex: u32,
    pub KeyEncryptionAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub EncryptedKey: CRYPT_INTEGER_BLOB,
    pub dwFlags: u32,
}
impl Copy for CMSG_KEY_TRANS_ENCRYPT_INFO {}
impl Clone for CMSG_KEY_TRANS_ENCRYPT_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CMSG_KEY_TRANS_ENCRYPT_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CMSG_KEY_TRANS_ENCRYPT_INFO").field("cbSize", &self.cbSize).field("dwRecipientIndex", &self.dwRecipientIndex).field("KeyEncryptionAlgorithm", &self.KeyEncryptionAlgorithm).field("EncryptedKey", &self.EncryptedKey).field("dwFlags", &self.dwFlags).finish()
    }
}
impl windows_core::TypeKind for CMSG_KEY_TRANS_ENCRYPT_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CMSG_KEY_TRANS_ENCRYPT_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwRecipientIndex == other.dwRecipientIndex && self.KeyEncryptionAlgorithm == other.KeyEncryptionAlgorithm && self.EncryptedKey == other.EncryptedKey && self.dwFlags == other.dwFlags
    }
}
impl Eq for CMSG_KEY_TRANS_ENCRYPT_INFO {}
impl Default for CMSG_KEY_TRANS_ENCRYPT_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMSG_KEY_TRANS_RECIPIENT_ENCODE_INFO {
    pub cbSize: u32,
    pub KeyEncryptionAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub pvKeyEncryptionAuxInfo: *mut core::ffi::c_void,
    pub hCryptProv: HCRYPTPROV_LEGACY,
    pub RecipientPublicKey: CRYPT_BIT_BLOB,
    pub RecipientId: CERT_ID,
}
impl Copy for CMSG_KEY_TRANS_RECIPIENT_ENCODE_INFO {}
impl Clone for CMSG_KEY_TRANS_RECIPIENT_ENCODE_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CMSG_KEY_TRANS_RECIPIENT_ENCODE_INFO {
    type TypeKind = windows_core::CopyType;
}
impl Default for CMSG_KEY_TRANS_RECIPIENT_ENCODE_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMSG_KEY_TRANS_RECIPIENT_INFO {
    pub dwVersion: u32,
    pub RecipientId: CERT_ID,
    pub KeyEncryptionAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub EncryptedKey: CRYPT_INTEGER_BLOB,
}
impl Copy for CMSG_KEY_TRANS_RECIPIENT_INFO {}
impl Clone for CMSG_KEY_TRANS_RECIPIENT_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CMSG_KEY_TRANS_RECIPIENT_INFO {
    type TypeKind = windows_core::CopyType;
}
impl Default for CMSG_KEY_TRANS_RECIPIENT_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMSG_MAIL_LIST_ENCRYPT_INFO {
    pub cbSize: u32,
    pub dwRecipientIndex: u32,
    pub KeyEncryptionAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub EncryptedKey: CRYPT_INTEGER_BLOB,
    pub dwFlags: u32,
}
impl Copy for CMSG_MAIL_LIST_ENCRYPT_INFO {}
impl Clone for CMSG_MAIL_LIST_ENCRYPT_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CMSG_MAIL_LIST_ENCRYPT_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CMSG_MAIL_LIST_ENCRYPT_INFO").field("cbSize", &self.cbSize).field("dwRecipientIndex", &self.dwRecipientIndex).field("KeyEncryptionAlgorithm", &self.KeyEncryptionAlgorithm).field("EncryptedKey", &self.EncryptedKey).field("dwFlags", &self.dwFlags).finish()
    }
}
impl windows_core::TypeKind for CMSG_MAIL_LIST_ENCRYPT_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CMSG_MAIL_LIST_ENCRYPT_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwRecipientIndex == other.dwRecipientIndex && self.KeyEncryptionAlgorithm == other.KeyEncryptionAlgorithm && self.EncryptedKey == other.EncryptedKey && self.dwFlags == other.dwFlags
    }
}
impl Eq for CMSG_MAIL_LIST_ENCRYPT_INFO {}
impl Default for CMSG_MAIL_LIST_ENCRYPT_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMSG_MAIL_LIST_RECIPIENT_ENCODE_INFO {
    pub cbSize: u32,
    pub KeyEncryptionAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub pvKeyEncryptionAuxInfo: *mut core::ffi::c_void,
    pub hCryptProv: usize,
    pub dwKeyChoice: u32,
    pub Anonymous: CMSG_MAIL_LIST_RECIPIENT_ENCODE_INFO_0,
    pub KeyId: CRYPT_INTEGER_BLOB,
    pub Date: super::super::Foundation::FILETIME,
    pub pOtherAttr: *mut CRYPT_ATTRIBUTE_TYPE_VALUE,
}
impl Copy for CMSG_MAIL_LIST_RECIPIENT_ENCODE_INFO {}
impl Clone for CMSG_MAIL_LIST_RECIPIENT_ENCODE_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CMSG_MAIL_LIST_RECIPIENT_ENCODE_INFO {
    type TypeKind = windows_core::CopyType;
}
impl Default for CMSG_MAIL_LIST_RECIPIENT_ENCODE_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub union CMSG_MAIL_LIST_RECIPIENT_ENCODE_INFO_0 {
    pub hKeyEncryptionKey: usize,
    pub pvKeyEncryptionKey: *mut core::ffi::c_void,
}
impl Copy for CMSG_MAIL_LIST_RECIPIENT_ENCODE_INFO_0 {}
impl Clone for CMSG_MAIL_LIST_RECIPIENT_ENCODE_INFO_0 {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CMSG_MAIL_LIST_RECIPIENT_ENCODE_INFO_0 {
    type TypeKind = windows_core::CopyType;
}
impl Default for CMSG_MAIL_LIST_RECIPIENT_ENCODE_INFO_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMSG_MAIL_LIST_RECIPIENT_INFO {
    pub dwVersion: u32,
    pub KeyId: CRYPT_INTEGER_BLOB,
    pub KeyEncryptionAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub EncryptedKey: CRYPT_INTEGER_BLOB,
    pub Date: super::super::Foundation::FILETIME,
    pub pOtherAttr: *mut CRYPT_ATTRIBUTE_TYPE_VALUE,
}
impl Copy for CMSG_MAIL_LIST_RECIPIENT_INFO {}
impl Clone for CMSG_MAIL_LIST_RECIPIENT_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CMSG_MAIL_LIST_RECIPIENT_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CMSG_MAIL_LIST_RECIPIENT_INFO").field("dwVersion", &self.dwVersion).field("KeyId", &self.KeyId).field("KeyEncryptionAlgorithm", &self.KeyEncryptionAlgorithm).field("EncryptedKey", &self.EncryptedKey).field("Date", &self.Date).field("pOtherAttr", &self.pOtherAttr).finish()
    }
}
impl windows_core::TypeKind for CMSG_MAIL_LIST_RECIPIENT_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CMSG_MAIL_LIST_RECIPIENT_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwVersion == other.dwVersion && self.KeyId == other.KeyId && self.KeyEncryptionAlgorithm == other.KeyEncryptionAlgorithm && self.EncryptedKey == other.EncryptedKey && self.Date == other.Date && self.pOtherAttr == other.pOtherAttr
    }
}
impl Eq for CMSG_MAIL_LIST_RECIPIENT_INFO {}
impl Default for CMSG_MAIL_LIST_RECIPIENT_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMSG_RC2_AUX_INFO {
    pub cbSize: u32,
    pub dwBitLen: u32,
}
impl Copy for CMSG_RC2_AUX_INFO {}
impl Clone for CMSG_RC2_AUX_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CMSG_RC2_AUX_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CMSG_RC2_AUX_INFO").field("cbSize", &self.cbSize).field("dwBitLen", &self.dwBitLen).finish()
    }
}
impl windows_core::TypeKind for CMSG_RC2_AUX_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CMSG_RC2_AUX_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwBitLen == other.dwBitLen
    }
}
impl Eq for CMSG_RC2_AUX_INFO {}
impl Default for CMSG_RC2_AUX_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMSG_RC4_AUX_INFO {
    pub cbSize: u32,
    pub dwBitLen: u32,
}
impl Copy for CMSG_RC4_AUX_INFO {}
impl Clone for CMSG_RC4_AUX_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CMSG_RC4_AUX_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CMSG_RC4_AUX_INFO").field("cbSize", &self.cbSize).field("dwBitLen", &self.dwBitLen).finish()
    }
}
impl windows_core::TypeKind for CMSG_RC4_AUX_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CMSG_RC4_AUX_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwBitLen == other.dwBitLen
    }
}
impl Eq for CMSG_RC4_AUX_INFO {}
impl Default for CMSG_RC4_AUX_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMSG_RECIPIENT_ENCODE_INFO {
    pub dwRecipientChoice: u32,
    pub Anonymous: CMSG_RECIPIENT_ENCODE_INFO_0,
}
impl Copy for CMSG_RECIPIENT_ENCODE_INFO {}
impl Clone for CMSG_RECIPIENT_ENCODE_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CMSG_RECIPIENT_ENCODE_INFO {
    type TypeKind = windows_core::CopyType;
}
impl Default for CMSG_RECIPIENT_ENCODE_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub union CMSG_RECIPIENT_ENCODE_INFO_0 {
    pub pKeyTrans: *mut CMSG_KEY_TRANS_RECIPIENT_ENCODE_INFO,
    pub pKeyAgree: *mut CMSG_KEY_AGREE_RECIPIENT_ENCODE_INFO,
    pub pMailList: *mut CMSG_MAIL_LIST_RECIPIENT_ENCODE_INFO,
}
impl Copy for CMSG_RECIPIENT_ENCODE_INFO_0 {}
impl Clone for CMSG_RECIPIENT_ENCODE_INFO_0 {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CMSG_RECIPIENT_ENCODE_INFO_0 {
    type TypeKind = windows_core::CopyType;
}
impl Default for CMSG_RECIPIENT_ENCODE_INFO_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMSG_RECIPIENT_ENCRYPTED_KEY_ENCODE_INFO {
    pub cbSize: u32,
    pub RecipientPublicKey: CRYPT_BIT_BLOB,
    pub RecipientId: CERT_ID,
    pub Date: super::super::Foundation::FILETIME,
    pub pOtherAttr: *mut CRYPT_ATTRIBUTE_TYPE_VALUE,
}
impl Copy for CMSG_RECIPIENT_ENCRYPTED_KEY_ENCODE_INFO {}
impl Clone for CMSG_RECIPIENT_ENCRYPTED_KEY_ENCODE_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CMSG_RECIPIENT_ENCRYPTED_KEY_ENCODE_INFO {
    type TypeKind = windows_core::CopyType;
}
impl Default for CMSG_RECIPIENT_ENCRYPTED_KEY_ENCODE_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMSG_RECIPIENT_ENCRYPTED_KEY_INFO {
    pub RecipientId: CERT_ID,
    pub EncryptedKey: CRYPT_INTEGER_BLOB,
    pub Date: super::super::Foundation::FILETIME,
    pub pOtherAttr: *mut CRYPT_ATTRIBUTE_TYPE_VALUE,
}
impl Copy for CMSG_RECIPIENT_ENCRYPTED_KEY_INFO {}
impl Clone for CMSG_RECIPIENT_ENCRYPTED_KEY_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CMSG_RECIPIENT_ENCRYPTED_KEY_INFO {
    type TypeKind = windows_core::CopyType;
}
impl Default for CMSG_RECIPIENT_ENCRYPTED_KEY_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMSG_SIGNED_AND_ENVELOPED_ENCODE_INFO {
    pub cbSize: u32,
    pub SignedInfo: CMSG_SIGNED_ENCODE_INFO,
    pub EnvelopedInfo: CMSG_ENVELOPED_ENCODE_INFO,
}
impl Copy for CMSG_SIGNED_AND_ENVELOPED_ENCODE_INFO {}
impl Clone for CMSG_SIGNED_AND_ENVELOPED_ENCODE_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CMSG_SIGNED_AND_ENVELOPED_ENCODE_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CMSG_SIGNED_AND_ENVELOPED_ENCODE_INFO").field("cbSize", &self.cbSize).field("SignedInfo", &self.SignedInfo).field("EnvelopedInfo", &self.EnvelopedInfo).finish()
    }
}
impl windows_core::TypeKind for CMSG_SIGNED_AND_ENVELOPED_ENCODE_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CMSG_SIGNED_AND_ENVELOPED_ENCODE_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.SignedInfo == other.SignedInfo && self.EnvelopedInfo == other.EnvelopedInfo
    }
}
impl Eq for CMSG_SIGNED_AND_ENVELOPED_ENCODE_INFO {}
impl Default for CMSG_SIGNED_AND_ENVELOPED_ENCODE_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMSG_SIGNED_ENCODE_INFO {
    pub cbSize: u32,
    pub cSigners: u32,
    pub rgSigners: *mut CMSG_SIGNER_ENCODE_INFO,
    pub cCertEncoded: u32,
    pub rgCertEncoded: *mut CRYPT_INTEGER_BLOB,
    pub cCrlEncoded: u32,
    pub rgCrlEncoded: *mut CRYPT_INTEGER_BLOB,
}
impl Copy for CMSG_SIGNED_ENCODE_INFO {}
impl Clone for CMSG_SIGNED_ENCODE_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CMSG_SIGNED_ENCODE_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CMSG_SIGNED_ENCODE_INFO").field("cbSize", &self.cbSize).field("cSigners", &self.cSigners).field("rgSigners", &self.rgSigners).field("cCertEncoded", &self.cCertEncoded).field("rgCertEncoded", &self.rgCertEncoded).field("cCrlEncoded", &self.cCrlEncoded).field("rgCrlEncoded", &self.rgCrlEncoded).finish()
    }
}
impl windows_core::TypeKind for CMSG_SIGNED_ENCODE_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CMSG_SIGNED_ENCODE_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.cSigners == other.cSigners && self.rgSigners == other.rgSigners && self.cCertEncoded == other.cCertEncoded && self.rgCertEncoded == other.rgCertEncoded && self.cCrlEncoded == other.cCrlEncoded && self.rgCrlEncoded == other.rgCrlEncoded
    }
}
impl Eq for CMSG_SIGNED_ENCODE_INFO {}
impl Default for CMSG_SIGNED_ENCODE_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMSG_SIGNER_ENCODE_INFO {
    pub cbSize: u32,
    pub pCertInfo: *mut CERT_INFO,
    pub Anonymous: CMSG_SIGNER_ENCODE_INFO_0,
    pub dwKeySpec: u32,
    pub HashAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub pvHashAuxInfo: *mut core::ffi::c_void,
    pub cAuthAttr: u32,
    pub rgAuthAttr: *mut CRYPT_ATTRIBUTE,
    pub cUnauthAttr: u32,
    pub rgUnauthAttr: *mut CRYPT_ATTRIBUTE,
}
impl Copy for CMSG_SIGNER_ENCODE_INFO {}
impl Clone for CMSG_SIGNER_ENCODE_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CMSG_SIGNER_ENCODE_INFO {
    type TypeKind = windows_core::CopyType;
}
impl Default for CMSG_SIGNER_ENCODE_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub union CMSG_SIGNER_ENCODE_INFO_0 {
    pub hCryptProv: usize,
    pub hNCryptKey: NCRYPT_KEY_HANDLE,
}
impl Copy for CMSG_SIGNER_ENCODE_INFO_0 {}
impl Clone for CMSG_SIGNER_ENCODE_INFO_0 {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CMSG_SIGNER_ENCODE_INFO_0 {
    type TypeKind = windows_core::CopyType;
}
impl Default for CMSG_SIGNER_ENCODE_INFO_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMSG_SIGNER_INFO {
    pub dwVersion: u32,
    pub Issuer: CRYPT_INTEGER_BLOB,
    pub SerialNumber: CRYPT_INTEGER_BLOB,
    pub HashAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub HashEncryptionAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub EncryptedHash: CRYPT_INTEGER_BLOB,
    pub AuthAttrs: CRYPT_ATTRIBUTES,
    pub UnauthAttrs: CRYPT_ATTRIBUTES,
}
impl Copy for CMSG_SIGNER_INFO {}
impl Clone for CMSG_SIGNER_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CMSG_SIGNER_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CMSG_SIGNER_INFO").field("dwVersion", &self.dwVersion).field("Issuer", &self.Issuer).field("SerialNumber", &self.SerialNumber).field("HashAlgorithm", &self.HashAlgorithm).field("HashEncryptionAlgorithm", &self.HashEncryptionAlgorithm).field("EncryptedHash", &self.EncryptedHash).field("AuthAttrs", &self.AuthAttrs).field("UnauthAttrs", &self.UnauthAttrs).finish()
    }
}
impl windows_core::TypeKind for CMSG_SIGNER_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CMSG_SIGNER_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwVersion == other.dwVersion && self.Issuer == other.Issuer && self.SerialNumber == other.SerialNumber && self.HashAlgorithm == other.HashAlgorithm && self.HashEncryptionAlgorithm == other.HashEncryptionAlgorithm && self.EncryptedHash == other.EncryptedHash && self.AuthAttrs == other.AuthAttrs && self.UnauthAttrs == other.UnauthAttrs
    }
}
impl Eq for CMSG_SIGNER_INFO {}
impl Default for CMSG_SIGNER_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMSG_SP3_COMPATIBLE_AUX_INFO {
    pub cbSize: u32,
    pub dwFlags: u32,
}
impl Copy for CMSG_SP3_COMPATIBLE_AUX_INFO {}
impl Clone for CMSG_SP3_COMPATIBLE_AUX_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CMSG_SP3_COMPATIBLE_AUX_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CMSG_SP3_COMPATIBLE_AUX_INFO").field("cbSize", &self.cbSize).field("dwFlags", &self.dwFlags).finish()
    }
}
impl windows_core::TypeKind for CMSG_SP3_COMPATIBLE_AUX_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CMSG_SP3_COMPATIBLE_AUX_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwFlags == other.dwFlags
    }
}
impl Eq for CMSG_SP3_COMPATIBLE_AUX_INFO {}
impl Default for CMSG_SP3_COMPATIBLE_AUX_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMSG_STREAM_INFO {
    pub cbContent: u32,
    pub pfnStreamOutput: PFN_CMSG_STREAM_OUTPUT,
    pub pvArg: *mut core::ffi::c_void,
}
impl Copy for CMSG_STREAM_INFO {}
impl Clone for CMSG_STREAM_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CMSG_STREAM_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CMSG_STREAM_INFO").field("cbContent", &self.cbContent).field("pvArg", &self.pvArg).finish()
    }
}
impl windows_core::TypeKind for CMSG_STREAM_INFO {
    type TypeKind = windows_core::CopyType;
}
impl Default for CMSG_STREAM_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMS_DH_KEY_INFO {
    pub dwVersion: u32,
    pub Algid: ALG_ID,
    pub pszContentEncObjId: windows_core::PSTR,
    pub PubInfo: CRYPT_INTEGER_BLOB,
    pub pReserved: *mut core::ffi::c_void,
}
impl Copy for CMS_DH_KEY_INFO {}
impl Clone for CMS_DH_KEY_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CMS_DH_KEY_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CMS_DH_KEY_INFO").field("dwVersion", &self.dwVersion).field("Algid", &self.Algid).field("pszContentEncObjId", &self.pszContentEncObjId).field("PubInfo", &self.PubInfo).field("pReserved", &self.pReserved).finish()
    }
}
impl windows_core::TypeKind for CMS_DH_KEY_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CMS_DH_KEY_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwVersion == other.dwVersion && self.Algid == other.Algid && self.pszContentEncObjId == other.pszContentEncObjId && self.PubInfo == other.PubInfo && self.pReserved == other.pReserved
    }
}
impl Eq for CMS_DH_KEY_INFO {}
impl Default for CMS_DH_KEY_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CMS_KEY_INFO {
    pub dwVersion: u32,
    pub Algid: ALG_ID,
    pub pbOID: *mut u8,
    pub cbOID: u32,
}
impl Copy for CMS_KEY_INFO {}
impl Clone for CMS_KEY_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CMS_KEY_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CMS_KEY_INFO").field("dwVersion", &self.dwVersion).field("Algid", &self.Algid).field("pbOID", &self.pbOID).field("cbOID", &self.cbOID).finish()
    }
}
impl windows_core::TypeKind for CMS_KEY_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CMS_KEY_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwVersion == other.dwVersion && self.Algid == other.Algid && self.pbOID == other.pbOID && self.cbOID == other.cbOID
    }
}
impl Eq for CMS_KEY_INFO {}
impl Default for CMS_KEY_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CPS_URLS {
    pub pszURL: windows_core::PWSTR,
    pub pAlgorithm: *mut CRYPT_ALGORITHM_IDENTIFIER,
    pub pDigest: *mut CRYPT_INTEGER_BLOB,
}
impl Copy for CPS_URLS {}
impl Clone for CPS_URLS {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CPS_URLS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CPS_URLS").field("pszURL", &self.pszURL).field("pAlgorithm", &self.pAlgorithm).field("pDigest", &self.pDigest).finish()
    }
}
impl windows_core::TypeKind for CPS_URLS {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CPS_URLS {
    fn eq(&self, other: &Self) -> bool {
        self.pszURL == other.pszURL && self.pAlgorithm == other.pAlgorithm && self.pDigest == other.pDigest
    }
}
impl Eq for CPS_URLS {}
impl Default for CPS_URLS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRL_CONTEXT {
    pub dwCertEncodingType: CERT_QUERY_ENCODING_TYPE,
    pub pbCrlEncoded: *mut u8,
    pub cbCrlEncoded: u32,
    pub pCrlInfo: *mut CRL_INFO,
    pub hCertStore: HCERTSTORE,
}
impl Copy for CRL_CONTEXT {}
impl Clone for CRL_CONTEXT {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRL_CONTEXT {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRL_CONTEXT").field("dwCertEncodingType", &self.dwCertEncodingType).field("pbCrlEncoded", &self.pbCrlEncoded).field("cbCrlEncoded", &self.cbCrlEncoded).field("pCrlInfo", &self.pCrlInfo).field("hCertStore", &self.hCertStore).finish()
    }
}
impl windows_core::TypeKind for CRL_CONTEXT {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRL_CONTEXT {
    fn eq(&self, other: &Self) -> bool {
        self.dwCertEncodingType == other.dwCertEncodingType && self.pbCrlEncoded == other.pbCrlEncoded && self.cbCrlEncoded == other.cbCrlEncoded && self.pCrlInfo == other.pCrlInfo && self.hCertStore == other.hCertStore
    }
}
impl Eq for CRL_CONTEXT {}
impl Default for CRL_CONTEXT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRL_DIST_POINT {
    pub DistPointName: CRL_DIST_POINT_NAME,
    pub ReasonFlags: CRYPT_BIT_BLOB,
    pub CRLIssuer: CERT_ALT_NAME_INFO,
}
impl Copy for CRL_DIST_POINT {}
impl Clone for CRL_DIST_POINT {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CRL_DIST_POINT {
    type TypeKind = windows_core::CopyType;
}
impl Default for CRL_DIST_POINT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRL_DIST_POINTS_INFO {
    pub cDistPoint: u32,
    pub rgDistPoint: *mut CRL_DIST_POINT,
}
impl Copy for CRL_DIST_POINTS_INFO {}
impl Clone for CRL_DIST_POINTS_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRL_DIST_POINTS_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRL_DIST_POINTS_INFO").field("cDistPoint", &self.cDistPoint).field("rgDistPoint", &self.rgDistPoint).finish()
    }
}
impl windows_core::TypeKind for CRL_DIST_POINTS_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRL_DIST_POINTS_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cDistPoint == other.cDistPoint && self.rgDistPoint == other.rgDistPoint
    }
}
impl Eq for CRL_DIST_POINTS_INFO {}
impl Default for CRL_DIST_POINTS_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRL_DIST_POINT_NAME {
    pub dwDistPointNameChoice: u32,
    pub Anonymous: CRL_DIST_POINT_NAME_0,
}
impl Copy for CRL_DIST_POINT_NAME {}
impl Clone for CRL_DIST_POINT_NAME {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CRL_DIST_POINT_NAME {
    type TypeKind = windows_core::CopyType;
}
impl Default for CRL_DIST_POINT_NAME {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub union CRL_DIST_POINT_NAME_0 {
    pub FullName: CERT_ALT_NAME_INFO,
}
impl Copy for CRL_DIST_POINT_NAME_0 {}
impl Clone for CRL_DIST_POINT_NAME_0 {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CRL_DIST_POINT_NAME_0 {
    type TypeKind = windows_core::CopyType;
}
impl Default for CRL_DIST_POINT_NAME_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRL_ENTRY {
    pub SerialNumber: CRYPT_INTEGER_BLOB,
    pub RevocationDate: super::super::Foundation::FILETIME,
    pub cExtension: u32,
    pub rgExtension: *mut CERT_EXTENSION,
}
impl Copy for CRL_ENTRY {}
impl Clone for CRL_ENTRY {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRL_ENTRY {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRL_ENTRY").field("SerialNumber", &self.SerialNumber).field("RevocationDate", &self.RevocationDate).field("cExtension", &self.cExtension).field("rgExtension", &self.rgExtension).finish()
    }
}
impl windows_core::TypeKind for CRL_ENTRY {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRL_ENTRY {
    fn eq(&self, other: &Self) -> bool {
        self.SerialNumber == other.SerialNumber && self.RevocationDate == other.RevocationDate && self.cExtension == other.cExtension && self.rgExtension == other.rgExtension
    }
}
impl Eq for CRL_ENTRY {}
impl Default for CRL_ENTRY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRL_FIND_ISSUED_FOR_PARA {
    pub pSubjectCert: *const CERT_CONTEXT,
    pub pIssuerCert: *const CERT_CONTEXT,
}
impl Copy for CRL_FIND_ISSUED_FOR_PARA {}
impl Clone for CRL_FIND_ISSUED_FOR_PARA {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRL_FIND_ISSUED_FOR_PARA {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRL_FIND_ISSUED_FOR_PARA").field("pSubjectCert", &self.pSubjectCert).field("pIssuerCert", &self.pIssuerCert).finish()
    }
}
impl windows_core::TypeKind for CRL_FIND_ISSUED_FOR_PARA {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRL_FIND_ISSUED_FOR_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.pSubjectCert == other.pSubjectCert && self.pIssuerCert == other.pIssuerCert
    }
}
impl Eq for CRL_FIND_ISSUED_FOR_PARA {}
impl Default for CRL_FIND_ISSUED_FOR_PARA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRL_INFO {
    pub dwVersion: u32,
    pub SignatureAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub Issuer: CRYPT_INTEGER_BLOB,
    pub ThisUpdate: super::super::Foundation::FILETIME,
    pub NextUpdate: super::super::Foundation::FILETIME,
    pub cCRLEntry: u32,
    pub rgCRLEntry: *mut CRL_ENTRY,
    pub cExtension: u32,
    pub rgExtension: *mut CERT_EXTENSION,
}
impl Copy for CRL_INFO {}
impl Clone for CRL_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRL_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRL_INFO").field("dwVersion", &self.dwVersion).field("SignatureAlgorithm", &self.SignatureAlgorithm).field("Issuer", &self.Issuer).field("ThisUpdate", &self.ThisUpdate).field("NextUpdate", &self.NextUpdate).field("cCRLEntry", &self.cCRLEntry).field("rgCRLEntry", &self.rgCRLEntry).field("cExtension", &self.cExtension).field("rgExtension", &self.rgExtension).finish()
    }
}
impl windows_core::TypeKind for CRL_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRL_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwVersion == other.dwVersion && self.SignatureAlgorithm == other.SignatureAlgorithm && self.Issuer == other.Issuer && self.ThisUpdate == other.ThisUpdate && self.NextUpdate == other.NextUpdate && self.cCRLEntry == other.cCRLEntry && self.rgCRLEntry == other.rgCRLEntry && self.cExtension == other.cExtension && self.rgExtension == other.rgExtension
    }
}
impl Eq for CRL_INFO {}
impl Default for CRL_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRL_ISSUING_DIST_POINT {
    pub DistPointName: CRL_DIST_POINT_NAME,
    pub fOnlyContainsUserCerts: super::super::Foundation::BOOL,
    pub fOnlyContainsCACerts: super::super::Foundation::BOOL,
    pub OnlySomeReasonFlags: CRYPT_BIT_BLOB,
    pub fIndirectCRL: super::super::Foundation::BOOL,
}
impl Copy for CRL_ISSUING_DIST_POINT {}
impl Clone for CRL_ISSUING_DIST_POINT {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CRL_ISSUING_DIST_POINT {
    type TypeKind = windows_core::CopyType;
}
impl Default for CRL_ISSUING_DIST_POINT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRL_REVOCATION_INFO {
    pub pCrlEntry: *mut CRL_ENTRY,
    pub pCrlContext: *mut CRL_CONTEXT,
    pub pCrlIssuerChain: *mut CERT_CHAIN_CONTEXT,
}
impl Copy for CRL_REVOCATION_INFO {}
impl Clone for CRL_REVOCATION_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRL_REVOCATION_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRL_REVOCATION_INFO").field("pCrlEntry", &self.pCrlEntry).field("pCrlContext", &self.pCrlContext).field("pCrlIssuerChain", &self.pCrlIssuerChain).finish()
    }
}
impl windows_core::TypeKind for CRL_REVOCATION_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRL_REVOCATION_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.pCrlEntry == other.pCrlEntry && self.pCrlContext == other.pCrlContext && self.pCrlIssuerChain == other.pCrlIssuerChain
    }
}
impl Eq for CRL_REVOCATION_INFO {}
impl Default for CRL_REVOCATION_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CROSS_CERT_DIST_POINTS_INFO {
    pub dwSyncDeltaTime: u32,
    pub cDistPoint: u32,
    pub rgDistPoint: *mut CERT_ALT_NAME_INFO,
}
impl Copy for CROSS_CERT_DIST_POINTS_INFO {}
impl Clone for CROSS_CERT_DIST_POINTS_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CROSS_CERT_DIST_POINTS_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CROSS_CERT_DIST_POINTS_INFO").field("dwSyncDeltaTime", &self.dwSyncDeltaTime).field("cDistPoint", &self.cDistPoint).field("rgDistPoint", &self.rgDistPoint).finish()
    }
}
impl windows_core::TypeKind for CROSS_CERT_DIST_POINTS_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CROSS_CERT_DIST_POINTS_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwSyncDeltaTime == other.dwSyncDeltaTime && self.cDistPoint == other.cDistPoint && self.rgDistPoint == other.rgDistPoint
    }
}
impl Eq for CROSS_CERT_DIST_POINTS_INFO {}
impl Default for CROSS_CERT_DIST_POINTS_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPTNET_URL_CACHE_FLUSH_INFO {
    pub cbSize: u32,
    pub dwExemptSeconds: u32,
    pub ExpireTime: super::super::Foundation::FILETIME,
}
impl Copy for CRYPTNET_URL_CACHE_FLUSH_INFO {}
impl Clone for CRYPTNET_URL_CACHE_FLUSH_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPTNET_URL_CACHE_FLUSH_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPTNET_URL_CACHE_FLUSH_INFO").field("cbSize", &self.cbSize).field("dwExemptSeconds", &self.dwExemptSeconds).field("ExpireTime", &self.ExpireTime).finish()
    }
}
impl windows_core::TypeKind for CRYPTNET_URL_CACHE_FLUSH_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPTNET_URL_CACHE_FLUSH_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwExemptSeconds == other.dwExemptSeconds && self.ExpireTime == other.ExpireTime
    }
}
impl Eq for CRYPTNET_URL_CACHE_FLUSH_INFO {}
impl Default for CRYPTNET_URL_CACHE_FLUSH_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPTNET_URL_CACHE_PRE_FETCH_INFO {
    pub cbSize: u32,
    pub dwObjectType: u32,
    pub dwError: u32,
    pub dwReserved: u32,
    pub ThisUpdateTime: super::super::Foundation::FILETIME,
    pub NextUpdateTime: super::super::Foundation::FILETIME,
    pub PublishTime: super::super::Foundation::FILETIME,
}
impl Copy for CRYPTNET_URL_CACHE_PRE_FETCH_INFO {}
impl Clone for CRYPTNET_URL_CACHE_PRE_FETCH_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPTNET_URL_CACHE_PRE_FETCH_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPTNET_URL_CACHE_PRE_FETCH_INFO").field("cbSize", &self.cbSize).field("dwObjectType", &self.dwObjectType).field("dwError", &self.dwError).field("dwReserved", &self.dwReserved).field("ThisUpdateTime", &self.ThisUpdateTime).field("NextUpdateTime", &self.NextUpdateTime).field("PublishTime", &self.PublishTime).finish()
    }
}
impl windows_core::TypeKind for CRYPTNET_URL_CACHE_PRE_FETCH_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPTNET_URL_CACHE_PRE_FETCH_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwObjectType == other.dwObjectType && self.dwError == other.dwError && self.dwReserved == other.dwReserved && self.ThisUpdateTime == other.ThisUpdateTime && self.NextUpdateTime == other.NextUpdateTime && self.PublishTime == other.PublishTime
    }
}
impl Eq for CRYPTNET_URL_CACHE_PRE_FETCH_INFO {}
impl Default for CRYPTNET_URL_CACHE_PRE_FETCH_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPTNET_URL_CACHE_RESPONSE_INFO {
    pub cbSize: u32,
    pub wResponseType: u16,
    pub wResponseFlags: u16,
    pub LastModifiedTime: super::super::Foundation::FILETIME,
    pub dwMaxAge: u32,
    pub pwszETag: windows_core::PCWSTR,
    pub dwProxyId: u32,
}
impl Copy for CRYPTNET_URL_CACHE_RESPONSE_INFO {}
impl Clone for CRYPTNET_URL_CACHE_RESPONSE_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPTNET_URL_CACHE_RESPONSE_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPTNET_URL_CACHE_RESPONSE_INFO").field("cbSize", &self.cbSize).field("wResponseType", &self.wResponseType).field("wResponseFlags", &self.wResponseFlags).field("LastModifiedTime", &self.LastModifiedTime).field("dwMaxAge", &self.dwMaxAge).field("pwszETag", &self.pwszETag).field("dwProxyId", &self.dwProxyId).finish()
    }
}
impl windows_core::TypeKind for CRYPTNET_URL_CACHE_RESPONSE_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPTNET_URL_CACHE_RESPONSE_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.wResponseType == other.wResponseType && self.wResponseFlags == other.wResponseFlags && self.LastModifiedTime == other.LastModifiedTime && self.dwMaxAge == other.dwMaxAge && self.pwszETag == other.pwszETag && self.dwProxyId == other.dwProxyId
    }
}
impl Eq for CRYPTNET_URL_CACHE_RESPONSE_INFO {}
impl Default for CRYPTNET_URL_CACHE_RESPONSE_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPTPROTECT_PROMPTSTRUCT {
    pub cbSize: u32,
    pub dwPromptFlags: u32,
    pub hwndApp: super::super::Foundation::HWND,
    pub szPrompt: windows_core::PCWSTR,
}
impl Copy for CRYPTPROTECT_PROMPTSTRUCT {}
impl Clone for CRYPTPROTECT_PROMPTSTRUCT {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPTPROTECT_PROMPTSTRUCT {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPTPROTECT_PROMPTSTRUCT").field("cbSize", &self.cbSize).field("dwPromptFlags", &self.dwPromptFlags).field("hwndApp", &self.hwndApp).field("szPrompt", &self.szPrompt).finish()
    }
}
impl windows_core::TypeKind for CRYPTPROTECT_PROMPTSTRUCT {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPTPROTECT_PROMPTSTRUCT {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwPromptFlags == other.dwPromptFlags && self.hwndApp == other.hwndApp && self.szPrompt == other.szPrompt
    }
}
impl Eq for CRYPTPROTECT_PROMPTSTRUCT {}
impl Default for CRYPTPROTECT_PROMPTSTRUCT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_3DES_KEY_STATE {
    pub Key: [u8; 24],
    pub IV: [u8; 8],
    pub Feedback: [u8; 8],
}
impl Copy for CRYPT_3DES_KEY_STATE {}
impl Clone for CRYPT_3DES_KEY_STATE {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_3DES_KEY_STATE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_3DES_KEY_STATE").field("Key", &self.Key).field("IV", &self.IV).field("Feedback", &self.Feedback).finish()
    }
}
impl windows_core::TypeKind for CRYPT_3DES_KEY_STATE {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_3DES_KEY_STATE {
    fn eq(&self, other: &Self) -> bool {
        self.Key == other.Key && self.IV == other.IV && self.Feedback == other.Feedback
    }
}
impl Eq for CRYPT_3DES_KEY_STATE {}
impl Default for CRYPT_3DES_KEY_STATE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_AES_128_KEY_STATE {
    pub Key: [u8; 16],
    pub IV: [u8; 16],
    pub EncryptionState: [u8; 176],
    pub DecryptionState: [u8; 176],
    pub Feedback: [u8; 16],
}
impl Copy for CRYPT_AES_128_KEY_STATE {}
impl Clone for CRYPT_AES_128_KEY_STATE {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_AES_128_KEY_STATE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_AES_128_KEY_STATE").field("Key", &self.Key).field("IV", &self.IV).field("EncryptionState", &self.EncryptionState).field("DecryptionState", &self.DecryptionState).field("Feedback", &self.Feedback).finish()
    }
}
impl windows_core::TypeKind for CRYPT_AES_128_KEY_STATE {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_AES_128_KEY_STATE {
    fn eq(&self, other: &Self) -> bool {
        self.Key == other.Key && self.IV == other.IV && self.EncryptionState == other.EncryptionState && self.DecryptionState == other.DecryptionState && self.Feedback == other.Feedback
    }
}
impl Eq for CRYPT_AES_128_KEY_STATE {}
impl Default for CRYPT_AES_128_KEY_STATE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_AES_256_KEY_STATE {
    pub Key: [u8; 32],
    pub IV: [u8; 16],
    pub EncryptionState: [u8; 240],
    pub DecryptionState: [u8; 240],
    pub Feedback: [u8; 16],
}
impl Copy for CRYPT_AES_256_KEY_STATE {}
impl Clone for CRYPT_AES_256_KEY_STATE {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_AES_256_KEY_STATE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_AES_256_KEY_STATE").field("Key", &self.Key).field("IV", &self.IV).field("EncryptionState", &self.EncryptionState).field("DecryptionState", &self.DecryptionState).field("Feedback", &self.Feedback).finish()
    }
}
impl windows_core::TypeKind for CRYPT_AES_256_KEY_STATE {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_AES_256_KEY_STATE {
    fn eq(&self, other: &Self) -> bool {
        self.Key == other.Key && self.IV == other.IV && self.EncryptionState == other.EncryptionState && self.DecryptionState == other.DecryptionState && self.Feedback == other.Feedback
    }
}
impl Eq for CRYPT_AES_256_KEY_STATE {}
impl Default for CRYPT_AES_256_KEY_STATE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_ALGORITHM_IDENTIFIER {
    pub pszObjId: windows_core::PSTR,
    pub Parameters: CRYPT_INTEGER_BLOB,
}
impl Copy for CRYPT_ALGORITHM_IDENTIFIER {}
impl Clone for CRYPT_ALGORITHM_IDENTIFIER {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_ALGORITHM_IDENTIFIER {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_ALGORITHM_IDENTIFIER").field("pszObjId", &self.pszObjId).field("Parameters", &self.Parameters).finish()
    }
}
impl windows_core::TypeKind for CRYPT_ALGORITHM_IDENTIFIER {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_ALGORITHM_IDENTIFIER {
    fn eq(&self, other: &Self) -> bool {
        self.pszObjId == other.pszObjId && self.Parameters == other.Parameters
    }
}
impl Eq for CRYPT_ALGORITHM_IDENTIFIER {}
impl Default for CRYPT_ALGORITHM_IDENTIFIER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_ASYNC_RETRIEVAL_COMPLETION {
    pub pfnCompletion: PFN_CRYPT_ASYNC_RETRIEVAL_COMPLETION_FUNC,
    pub pvCompletion: *mut core::ffi::c_void,
}
impl Copy for CRYPT_ASYNC_RETRIEVAL_COMPLETION {}
impl Clone for CRYPT_ASYNC_RETRIEVAL_COMPLETION {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_ASYNC_RETRIEVAL_COMPLETION {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_ASYNC_RETRIEVAL_COMPLETION").field("pvCompletion", &self.pvCompletion).finish()
    }
}
impl windows_core::TypeKind for CRYPT_ASYNC_RETRIEVAL_COMPLETION {
    type TypeKind = windows_core::CopyType;
}
impl Default for CRYPT_ASYNC_RETRIEVAL_COMPLETION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_ATTRIBUTE {
    pub pszObjId: windows_core::PSTR,
    pub cValue: u32,
    pub rgValue: *mut CRYPT_INTEGER_BLOB,
}
impl Copy for CRYPT_ATTRIBUTE {}
impl Clone for CRYPT_ATTRIBUTE {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_ATTRIBUTE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_ATTRIBUTE").field("pszObjId", &self.pszObjId).field("cValue", &self.cValue).field("rgValue", &self.rgValue).finish()
    }
}
impl windows_core::TypeKind for CRYPT_ATTRIBUTE {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_ATTRIBUTE {
    fn eq(&self, other: &Self) -> bool {
        self.pszObjId == other.pszObjId && self.cValue == other.cValue && self.rgValue == other.rgValue
    }
}
impl Eq for CRYPT_ATTRIBUTE {}
impl Default for CRYPT_ATTRIBUTE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_ATTRIBUTES {
    pub cAttr: u32,
    pub rgAttr: *mut CRYPT_ATTRIBUTE,
}
impl Copy for CRYPT_ATTRIBUTES {}
impl Clone for CRYPT_ATTRIBUTES {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_ATTRIBUTES {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_ATTRIBUTES").field("cAttr", &self.cAttr).field("rgAttr", &self.rgAttr).finish()
    }
}
impl windows_core::TypeKind for CRYPT_ATTRIBUTES {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_ATTRIBUTES {
    fn eq(&self, other: &Self) -> bool {
        self.cAttr == other.cAttr && self.rgAttr == other.rgAttr
    }
}
impl Eq for CRYPT_ATTRIBUTES {}
impl Default for CRYPT_ATTRIBUTES {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_ATTRIBUTE_TYPE_VALUE {
    pub pszObjId: windows_core::PSTR,
    pub Value: CRYPT_INTEGER_BLOB,
}
impl Copy for CRYPT_ATTRIBUTE_TYPE_VALUE {}
impl Clone for CRYPT_ATTRIBUTE_TYPE_VALUE {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_ATTRIBUTE_TYPE_VALUE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_ATTRIBUTE_TYPE_VALUE").field("pszObjId", &self.pszObjId).field("Value", &self.Value).finish()
    }
}
impl windows_core::TypeKind for CRYPT_ATTRIBUTE_TYPE_VALUE {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_ATTRIBUTE_TYPE_VALUE {
    fn eq(&self, other: &Self) -> bool {
        self.pszObjId == other.pszObjId && self.Value == other.Value
    }
}
impl Eq for CRYPT_ATTRIBUTE_TYPE_VALUE {}
impl Default for CRYPT_ATTRIBUTE_TYPE_VALUE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_BIT_BLOB {
    pub cbData: u32,
    pub pbData: *mut u8,
    pub cUnusedBits: u32,
}
impl Copy for CRYPT_BIT_BLOB {}
impl Clone for CRYPT_BIT_BLOB {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_BIT_BLOB {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_BIT_BLOB").field("cbData", &self.cbData).field("pbData", &self.pbData).field("cUnusedBits", &self.cUnusedBits).finish()
    }
}
impl windows_core::TypeKind for CRYPT_BIT_BLOB {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_BIT_BLOB {
    fn eq(&self, other: &Self) -> bool {
        self.cbData == other.cbData && self.pbData == other.pbData && self.cUnusedBits == other.cUnusedBits
    }
}
impl Eq for CRYPT_BIT_BLOB {}
impl Default for CRYPT_BIT_BLOB {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_BLOB_ARRAY {
    pub cBlob: u32,
    pub rgBlob: *mut CRYPT_INTEGER_BLOB,
}
impl Copy for CRYPT_BLOB_ARRAY {}
impl Clone for CRYPT_BLOB_ARRAY {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_BLOB_ARRAY {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_BLOB_ARRAY").field("cBlob", &self.cBlob).field("rgBlob", &self.rgBlob).finish()
    }
}
impl windows_core::TypeKind for CRYPT_BLOB_ARRAY {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_BLOB_ARRAY {
    fn eq(&self, other: &Self) -> bool {
        self.cBlob == other.cBlob && self.rgBlob == other.rgBlob
    }
}
impl Eq for CRYPT_BLOB_ARRAY {}
impl Default for CRYPT_BLOB_ARRAY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_CONTENT_INFO {
    pub pszObjId: windows_core::PSTR,
    pub Content: CRYPT_INTEGER_BLOB,
}
impl Copy for CRYPT_CONTENT_INFO {}
impl Clone for CRYPT_CONTENT_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_CONTENT_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_CONTENT_INFO").field("pszObjId", &self.pszObjId).field("Content", &self.Content).finish()
    }
}
impl windows_core::TypeKind for CRYPT_CONTENT_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_CONTENT_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.pszObjId == other.pszObjId && self.Content == other.Content
    }
}
impl Eq for CRYPT_CONTENT_INFO {}
impl Default for CRYPT_CONTENT_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_CONTENT_INFO_SEQUENCE_OF_ANY {
    pub pszObjId: windows_core::PSTR,
    pub cValue: u32,
    pub rgValue: *mut CRYPT_INTEGER_BLOB,
}
impl Copy for CRYPT_CONTENT_INFO_SEQUENCE_OF_ANY {}
impl Clone for CRYPT_CONTENT_INFO_SEQUENCE_OF_ANY {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_CONTENT_INFO_SEQUENCE_OF_ANY {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_CONTENT_INFO_SEQUENCE_OF_ANY").field("pszObjId", &self.pszObjId).field("cValue", &self.cValue).field("rgValue", &self.rgValue).finish()
    }
}
impl windows_core::TypeKind for CRYPT_CONTENT_INFO_SEQUENCE_OF_ANY {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_CONTENT_INFO_SEQUENCE_OF_ANY {
    fn eq(&self, other: &Self) -> bool {
        self.pszObjId == other.pszObjId && self.cValue == other.cValue && self.rgValue == other.rgValue
    }
}
impl Eq for CRYPT_CONTENT_INFO_SEQUENCE_OF_ANY {}
impl Default for CRYPT_CONTENT_INFO_SEQUENCE_OF_ANY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_CONTEXTS {
    pub cContexts: u32,
    pub rgpszContexts: *mut windows_core::PWSTR,
}
impl Copy for CRYPT_CONTEXTS {}
impl Clone for CRYPT_CONTEXTS {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_CONTEXTS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_CONTEXTS").field("cContexts", &self.cContexts).field("rgpszContexts", &self.rgpszContexts).finish()
    }
}
impl windows_core::TypeKind for CRYPT_CONTEXTS {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_CONTEXTS {
    fn eq(&self, other: &Self) -> bool {
        self.cContexts == other.cContexts && self.rgpszContexts == other.rgpszContexts
    }
}
impl Eq for CRYPT_CONTEXTS {}
impl Default for CRYPT_CONTEXTS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_CONTEXT_CONFIG {
    pub dwFlags: CRYPT_CONTEXT_CONFIG_FLAGS,
    pub dwReserved: u32,
}
impl Copy for CRYPT_CONTEXT_CONFIG {}
impl Clone for CRYPT_CONTEXT_CONFIG {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_CONTEXT_CONFIG {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_CONTEXT_CONFIG").field("dwFlags", &self.dwFlags).field("dwReserved", &self.dwReserved).finish()
    }
}
impl windows_core::TypeKind for CRYPT_CONTEXT_CONFIG {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_CONTEXT_CONFIG {
    fn eq(&self, other: &Self) -> bool {
        self.dwFlags == other.dwFlags && self.dwReserved == other.dwReserved
    }
}
impl Eq for CRYPT_CONTEXT_CONFIG {}
impl Default for CRYPT_CONTEXT_CONFIG {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_CONTEXT_FUNCTIONS {
    pub cFunctions: u32,
    pub rgpszFunctions: *mut windows_core::PWSTR,
}
impl Copy for CRYPT_CONTEXT_FUNCTIONS {}
impl Clone for CRYPT_CONTEXT_FUNCTIONS {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_CONTEXT_FUNCTIONS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_CONTEXT_FUNCTIONS").field("cFunctions", &self.cFunctions).field("rgpszFunctions", &self.rgpszFunctions).finish()
    }
}
impl windows_core::TypeKind for CRYPT_CONTEXT_FUNCTIONS {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_CONTEXT_FUNCTIONS {
    fn eq(&self, other: &Self) -> bool {
        self.cFunctions == other.cFunctions && self.rgpszFunctions == other.rgpszFunctions
    }
}
impl Eq for CRYPT_CONTEXT_FUNCTIONS {}
impl Default for CRYPT_CONTEXT_FUNCTIONS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_CONTEXT_FUNCTION_CONFIG {
    pub dwFlags: u32,
    pub dwReserved: u32,
}
impl Copy for CRYPT_CONTEXT_FUNCTION_CONFIG {}
impl Clone for CRYPT_CONTEXT_FUNCTION_CONFIG {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_CONTEXT_FUNCTION_CONFIG {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_CONTEXT_FUNCTION_CONFIG").field("dwFlags", &self.dwFlags).field("dwReserved", &self.dwReserved).finish()
    }
}
impl windows_core::TypeKind for CRYPT_CONTEXT_FUNCTION_CONFIG {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_CONTEXT_FUNCTION_CONFIG {
    fn eq(&self, other: &Self) -> bool {
        self.dwFlags == other.dwFlags && self.dwReserved == other.dwReserved
    }
}
impl Eq for CRYPT_CONTEXT_FUNCTION_CONFIG {}
impl Default for CRYPT_CONTEXT_FUNCTION_CONFIG {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_CONTEXT_FUNCTION_PROVIDERS {
    pub cProviders: u32,
    pub rgpszProviders: *mut windows_core::PWSTR,
}
impl Copy for CRYPT_CONTEXT_FUNCTION_PROVIDERS {}
impl Clone for CRYPT_CONTEXT_FUNCTION_PROVIDERS {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_CONTEXT_FUNCTION_PROVIDERS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_CONTEXT_FUNCTION_PROVIDERS").field("cProviders", &self.cProviders).field("rgpszProviders", &self.rgpszProviders).finish()
    }
}
impl windows_core::TypeKind for CRYPT_CONTEXT_FUNCTION_PROVIDERS {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_CONTEXT_FUNCTION_PROVIDERS {
    fn eq(&self, other: &Self) -> bool {
        self.cProviders == other.cProviders && self.rgpszProviders == other.rgpszProviders
    }
}
impl Eq for CRYPT_CONTEXT_FUNCTION_PROVIDERS {}
impl Default for CRYPT_CONTEXT_FUNCTION_PROVIDERS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_CREDENTIALS {
    pub cbSize: u32,
    pub pszCredentialsOid: windows_core::PCSTR,
    pub pvCredentials: *mut core::ffi::c_void,
}
impl Copy for CRYPT_CREDENTIALS {}
impl Clone for CRYPT_CREDENTIALS {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_CREDENTIALS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_CREDENTIALS").field("cbSize", &self.cbSize).field("pszCredentialsOid", &self.pszCredentialsOid).field("pvCredentials", &self.pvCredentials).finish()
    }
}
impl windows_core::TypeKind for CRYPT_CREDENTIALS {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_CREDENTIALS {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.pszCredentialsOid == other.pszCredentialsOid && self.pvCredentials == other.pvCredentials
    }
}
impl Eq for CRYPT_CREDENTIALS {}
impl Default for CRYPT_CREDENTIALS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_CSP_PROVIDER {
    pub dwKeySpec: u32,
    pub pwszProviderName: windows_core::PWSTR,
    pub Signature: CRYPT_BIT_BLOB,
}
impl Copy for CRYPT_CSP_PROVIDER {}
impl Clone for CRYPT_CSP_PROVIDER {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_CSP_PROVIDER {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_CSP_PROVIDER").field("dwKeySpec", &self.dwKeySpec).field("pwszProviderName", &self.pwszProviderName).field("Signature", &self.Signature).finish()
    }
}
impl windows_core::TypeKind for CRYPT_CSP_PROVIDER {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_CSP_PROVIDER {
    fn eq(&self, other: &Self) -> bool {
        self.dwKeySpec == other.dwKeySpec && self.pwszProviderName == other.pwszProviderName && self.Signature == other.Signature
    }
}
impl Eq for CRYPT_CSP_PROVIDER {}
impl Default for CRYPT_CSP_PROVIDER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_DECODE_PARA {
    pub cbSize: u32,
    pub pfnAlloc: PFN_CRYPT_ALLOC,
    pub pfnFree: PFN_CRYPT_FREE,
}
impl Copy for CRYPT_DECODE_PARA {}
impl Clone for CRYPT_DECODE_PARA {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_DECODE_PARA {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_DECODE_PARA").field("cbSize", &self.cbSize).finish()
    }
}
impl windows_core::TypeKind for CRYPT_DECODE_PARA {
    type TypeKind = windows_core::CopyType;
}
impl Default for CRYPT_DECODE_PARA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_DECRYPT_MESSAGE_PARA {
    pub cbSize: u32,
    pub dwMsgAndCertEncodingType: u32,
    pub cCertStore: u32,
    pub rghCertStore: *mut HCERTSTORE,
}
impl Copy for CRYPT_DECRYPT_MESSAGE_PARA {}
impl Clone for CRYPT_DECRYPT_MESSAGE_PARA {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_DECRYPT_MESSAGE_PARA {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_DECRYPT_MESSAGE_PARA").field("cbSize", &self.cbSize).field("dwMsgAndCertEncodingType", &self.dwMsgAndCertEncodingType).field("cCertStore", &self.cCertStore).field("rghCertStore", &self.rghCertStore).finish()
    }
}
impl windows_core::TypeKind for CRYPT_DECRYPT_MESSAGE_PARA {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_DECRYPT_MESSAGE_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwMsgAndCertEncodingType == other.dwMsgAndCertEncodingType && self.cCertStore == other.cCertStore && self.rghCertStore == other.rghCertStore
    }
}
impl Eq for CRYPT_DECRYPT_MESSAGE_PARA {}
impl Default for CRYPT_DECRYPT_MESSAGE_PARA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_DEFAULT_CONTEXT_MULTI_OID_PARA {
    pub cOID: u32,
    pub rgpszOID: *mut windows_core::PSTR,
}
impl Copy for CRYPT_DEFAULT_CONTEXT_MULTI_OID_PARA {}
impl Clone for CRYPT_DEFAULT_CONTEXT_MULTI_OID_PARA {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_DEFAULT_CONTEXT_MULTI_OID_PARA {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_DEFAULT_CONTEXT_MULTI_OID_PARA").field("cOID", &self.cOID).field("rgpszOID", &self.rgpszOID).finish()
    }
}
impl windows_core::TypeKind for CRYPT_DEFAULT_CONTEXT_MULTI_OID_PARA {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_DEFAULT_CONTEXT_MULTI_OID_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.cOID == other.cOID && self.rgpszOID == other.rgpszOID
    }
}
impl Eq for CRYPT_DEFAULT_CONTEXT_MULTI_OID_PARA {}
impl Default for CRYPT_DEFAULT_CONTEXT_MULTI_OID_PARA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_DES_KEY_STATE {
    pub Key: [u8; 8],
    pub IV: [u8; 8],
    pub Feedback: [u8; 8],
}
impl Copy for CRYPT_DES_KEY_STATE {}
impl Clone for CRYPT_DES_KEY_STATE {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_DES_KEY_STATE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_DES_KEY_STATE").field("Key", &self.Key).field("IV", &self.IV).field("Feedback", &self.Feedback).finish()
    }
}
impl windows_core::TypeKind for CRYPT_DES_KEY_STATE {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_DES_KEY_STATE {
    fn eq(&self, other: &Self) -> bool {
        self.Key == other.Key && self.IV == other.IV && self.Feedback == other.Feedback
    }
}
impl Eq for CRYPT_DES_KEY_STATE {}
impl Default for CRYPT_DES_KEY_STATE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_ECC_CMS_SHARED_INFO {
    pub Algorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub EntityUInfo: CRYPT_INTEGER_BLOB,
    pub rgbSuppPubInfo: [u8; 4],
}
impl Copy for CRYPT_ECC_CMS_SHARED_INFO {}
impl Clone for CRYPT_ECC_CMS_SHARED_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_ECC_CMS_SHARED_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_ECC_CMS_SHARED_INFO").field("Algorithm", &self.Algorithm).field("EntityUInfo", &self.EntityUInfo).field("rgbSuppPubInfo", &self.rgbSuppPubInfo).finish()
    }
}
impl windows_core::TypeKind for CRYPT_ECC_CMS_SHARED_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_ECC_CMS_SHARED_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.Algorithm == other.Algorithm && self.EntityUInfo == other.EntityUInfo && self.rgbSuppPubInfo == other.rgbSuppPubInfo
    }
}
impl Eq for CRYPT_ECC_CMS_SHARED_INFO {}
impl Default for CRYPT_ECC_CMS_SHARED_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_ECC_PRIVATE_KEY_INFO {
    pub dwVersion: u32,
    pub PrivateKey: CRYPT_INTEGER_BLOB,
    pub szCurveOid: windows_core::PSTR,
    pub PublicKey: CRYPT_BIT_BLOB,
}
impl Copy for CRYPT_ECC_PRIVATE_KEY_INFO {}
impl Clone for CRYPT_ECC_PRIVATE_KEY_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_ECC_PRIVATE_KEY_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_ECC_PRIVATE_KEY_INFO").field("dwVersion", &self.dwVersion).field("PrivateKey", &self.PrivateKey).field("szCurveOid", &self.szCurveOid).field("PublicKey", &self.PublicKey).finish()
    }
}
impl windows_core::TypeKind for CRYPT_ECC_PRIVATE_KEY_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_ECC_PRIVATE_KEY_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwVersion == other.dwVersion && self.PrivateKey == other.PrivateKey && self.szCurveOid == other.szCurveOid && self.PublicKey == other.PublicKey
    }
}
impl Eq for CRYPT_ECC_PRIVATE_KEY_INFO {}
impl Default for CRYPT_ECC_PRIVATE_KEY_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_ENCODE_PARA {
    pub cbSize: u32,
    pub pfnAlloc: PFN_CRYPT_ALLOC,
    pub pfnFree: PFN_CRYPT_FREE,
}
impl Copy for CRYPT_ENCODE_PARA {}
impl Clone for CRYPT_ENCODE_PARA {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_ENCODE_PARA {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_ENCODE_PARA").field("cbSize", &self.cbSize).finish()
    }
}
impl windows_core::TypeKind for CRYPT_ENCODE_PARA {
    type TypeKind = windows_core::CopyType;
}
impl Default for CRYPT_ENCODE_PARA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_ENCRYPTED_PRIVATE_KEY_INFO {
    pub EncryptionAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub EncryptedPrivateKey: CRYPT_INTEGER_BLOB,
}
impl Copy for CRYPT_ENCRYPTED_PRIVATE_KEY_INFO {}
impl Clone for CRYPT_ENCRYPTED_PRIVATE_KEY_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_ENCRYPTED_PRIVATE_KEY_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_ENCRYPTED_PRIVATE_KEY_INFO").field("EncryptionAlgorithm", &self.EncryptionAlgorithm).field("EncryptedPrivateKey", &self.EncryptedPrivateKey).finish()
    }
}
impl windows_core::TypeKind for CRYPT_ENCRYPTED_PRIVATE_KEY_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_ENCRYPTED_PRIVATE_KEY_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.EncryptionAlgorithm == other.EncryptionAlgorithm && self.EncryptedPrivateKey == other.EncryptedPrivateKey
    }
}
impl Eq for CRYPT_ENCRYPTED_PRIVATE_KEY_INFO {}
impl Default for CRYPT_ENCRYPTED_PRIVATE_KEY_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_ENCRYPT_MESSAGE_PARA {
    pub cbSize: u32,
    pub dwMsgEncodingType: u32,
    pub hCryptProv: HCRYPTPROV_LEGACY,
    pub ContentEncryptionAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub pvEncryptionAuxInfo: *mut core::ffi::c_void,
    pub dwFlags: u32,
    pub dwInnerContentType: u32,
}
impl Copy for CRYPT_ENCRYPT_MESSAGE_PARA {}
impl Clone for CRYPT_ENCRYPT_MESSAGE_PARA {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_ENCRYPT_MESSAGE_PARA {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_ENCRYPT_MESSAGE_PARA").field("cbSize", &self.cbSize).field("dwMsgEncodingType", &self.dwMsgEncodingType).field("hCryptProv", &self.hCryptProv).field("ContentEncryptionAlgorithm", &self.ContentEncryptionAlgorithm).field("pvEncryptionAuxInfo", &self.pvEncryptionAuxInfo).field("dwFlags", &self.dwFlags).field("dwInnerContentType", &self.dwInnerContentType).finish()
    }
}
impl windows_core::TypeKind for CRYPT_ENCRYPT_MESSAGE_PARA {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_ENCRYPT_MESSAGE_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwMsgEncodingType == other.dwMsgEncodingType && self.hCryptProv == other.hCryptProv && self.ContentEncryptionAlgorithm == other.ContentEncryptionAlgorithm && self.pvEncryptionAuxInfo == other.pvEncryptionAuxInfo && self.dwFlags == other.dwFlags && self.dwInnerContentType == other.dwInnerContentType
    }
}
impl Eq for CRYPT_ENCRYPT_MESSAGE_PARA {}
impl Default for CRYPT_ENCRYPT_MESSAGE_PARA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_ENROLLMENT_NAME_VALUE_PAIR {
    pub pwszName: windows_core::PWSTR,
    pub pwszValue: windows_core::PWSTR,
}
impl Copy for CRYPT_ENROLLMENT_NAME_VALUE_PAIR {}
impl Clone for CRYPT_ENROLLMENT_NAME_VALUE_PAIR {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_ENROLLMENT_NAME_VALUE_PAIR {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_ENROLLMENT_NAME_VALUE_PAIR").field("pwszName", &self.pwszName).field("pwszValue", &self.pwszValue).finish()
    }
}
impl windows_core::TypeKind for CRYPT_ENROLLMENT_NAME_VALUE_PAIR {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_ENROLLMENT_NAME_VALUE_PAIR {
    fn eq(&self, other: &Self) -> bool {
        self.pwszName == other.pwszName && self.pwszValue == other.pwszValue
    }
}
impl Eq for CRYPT_ENROLLMENT_NAME_VALUE_PAIR {}
impl Default for CRYPT_ENROLLMENT_NAME_VALUE_PAIR {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_GET_TIME_VALID_OBJECT_EXTRA_INFO {
    pub cbSize: u32,
    pub iDeltaCrlIndicator: i32,
    pub pftCacheResync: *mut super::super::Foundation::FILETIME,
    pub pLastSyncTime: *mut super::super::Foundation::FILETIME,
    pub pMaxAgeTime: *mut super::super::Foundation::FILETIME,
    pub pChainPara: *mut CERT_REVOCATION_CHAIN_PARA,
    pub pDeltaCrlIndicator: *mut CRYPT_INTEGER_BLOB,
}
impl Copy for CRYPT_GET_TIME_VALID_OBJECT_EXTRA_INFO {}
impl Clone for CRYPT_GET_TIME_VALID_OBJECT_EXTRA_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_GET_TIME_VALID_OBJECT_EXTRA_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_GET_TIME_VALID_OBJECT_EXTRA_INFO").field("cbSize", &self.cbSize).field("iDeltaCrlIndicator", &self.iDeltaCrlIndicator).field("pftCacheResync", &self.pftCacheResync).field("pLastSyncTime", &self.pLastSyncTime).field("pMaxAgeTime", &self.pMaxAgeTime).field("pChainPara", &self.pChainPara).field("pDeltaCrlIndicator", &self.pDeltaCrlIndicator).finish()
    }
}
impl windows_core::TypeKind for CRYPT_GET_TIME_VALID_OBJECT_EXTRA_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_GET_TIME_VALID_OBJECT_EXTRA_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.iDeltaCrlIndicator == other.iDeltaCrlIndicator && self.pftCacheResync == other.pftCacheResync && self.pLastSyncTime == other.pLastSyncTime && self.pMaxAgeTime == other.pMaxAgeTime && self.pChainPara == other.pChainPara && self.pDeltaCrlIndicator == other.pDeltaCrlIndicator
    }
}
impl Eq for CRYPT_GET_TIME_VALID_OBJECT_EXTRA_INFO {}
impl Default for CRYPT_GET_TIME_VALID_OBJECT_EXTRA_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_HASH_INFO {
    pub HashAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub Hash: CRYPT_INTEGER_BLOB,
}
impl Copy for CRYPT_HASH_INFO {}
impl Clone for CRYPT_HASH_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_HASH_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_HASH_INFO").field("HashAlgorithm", &self.HashAlgorithm).field("Hash", &self.Hash).finish()
    }
}
impl windows_core::TypeKind for CRYPT_HASH_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_HASH_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.HashAlgorithm == other.HashAlgorithm && self.Hash == other.Hash
    }
}
impl Eq for CRYPT_HASH_INFO {}
impl Default for CRYPT_HASH_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_HASH_MESSAGE_PARA {
    pub cbSize: u32,
    pub dwMsgEncodingType: u32,
    pub hCryptProv: HCRYPTPROV_LEGACY,
    pub HashAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub pvHashAuxInfo: *mut core::ffi::c_void,
}
impl Copy for CRYPT_HASH_MESSAGE_PARA {}
impl Clone for CRYPT_HASH_MESSAGE_PARA {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_HASH_MESSAGE_PARA {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_HASH_MESSAGE_PARA").field("cbSize", &self.cbSize).field("dwMsgEncodingType", &self.dwMsgEncodingType).field("hCryptProv", &self.hCryptProv).field("HashAlgorithm", &self.HashAlgorithm).field("pvHashAuxInfo", &self.pvHashAuxInfo).finish()
    }
}
impl windows_core::TypeKind for CRYPT_HASH_MESSAGE_PARA {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_HASH_MESSAGE_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwMsgEncodingType == other.dwMsgEncodingType && self.hCryptProv == other.hCryptProv && self.HashAlgorithm == other.HashAlgorithm && self.pvHashAuxInfo == other.pvHashAuxInfo
    }
}
impl Eq for CRYPT_HASH_MESSAGE_PARA {}
impl Default for CRYPT_HASH_MESSAGE_PARA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_IMAGE_REF {
    pub pszImage: windows_core::PWSTR,
    pub dwFlags: CRYPT_IMAGE_REF_FLAGS,
}
impl Copy for CRYPT_IMAGE_REF {}
impl Clone for CRYPT_IMAGE_REF {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_IMAGE_REF {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_IMAGE_REF").field("pszImage", &self.pszImage).field("dwFlags", &self.dwFlags).finish()
    }
}
impl windows_core::TypeKind for CRYPT_IMAGE_REF {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_IMAGE_REF {
    fn eq(&self, other: &Self) -> bool {
        self.pszImage == other.pszImage && self.dwFlags == other.dwFlags
    }
}
impl Eq for CRYPT_IMAGE_REF {}
impl Default for CRYPT_IMAGE_REF {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_IMAGE_REG {
    pub pszImage: windows_core::PWSTR,
    pub cInterfaces: u32,
    pub rgpInterfaces: *mut *mut CRYPT_INTERFACE_REG,
}
impl Copy for CRYPT_IMAGE_REG {}
impl Clone for CRYPT_IMAGE_REG {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_IMAGE_REG {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_IMAGE_REG").field("pszImage", &self.pszImage).field("cInterfaces", &self.cInterfaces).field("rgpInterfaces", &self.rgpInterfaces).finish()
    }
}
impl windows_core::TypeKind for CRYPT_IMAGE_REG {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_IMAGE_REG {
    fn eq(&self, other: &Self) -> bool {
        self.pszImage == other.pszImage && self.cInterfaces == other.cInterfaces && self.rgpInterfaces == other.rgpInterfaces
    }
}
impl Eq for CRYPT_IMAGE_REG {}
impl Default for CRYPT_IMAGE_REG {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_INTEGER_BLOB {
    pub cbData: u32,
    pub pbData: *mut u8,
}
impl Copy for CRYPT_INTEGER_BLOB {}
impl Clone for CRYPT_INTEGER_BLOB {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_INTEGER_BLOB {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_INTEGER_BLOB").field("cbData", &self.cbData).field("pbData", &self.pbData).finish()
    }
}
impl windows_core::TypeKind for CRYPT_INTEGER_BLOB {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_INTEGER_BLOB {
    fn eq(&self, other: &Self) -> bool {
        self.cbData == other.cbData && self.pbData == other.pbData
    }
}
impl Eq for CRYPT_INTEGER_BLOB {}
impl Default for CRYPT_INTEGER_BLOB {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_INTERFACE_REG {
    pub dwInterface: BCRYPT_INTERFACE,
    pub dwFlags: BCRYPT_TABLE,
    pub cFunctions: u32,
    pub rgpszFunctions: *mut windows_core::PWSTR,
}
impl Copy for CRYPT_INTERFACE_REG {}
impl Clone for CRYPT_INTERFACE_REG {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_INTERFACE_REG {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_INTERFACE_REG").field("dwInterface", &self.dwInterface).field("dwFlags", &self.dwFlags).field("cFunctions", &self.cFunctions).field("rgpszFunctions", &self.rgpszFunctions).finish()
    }
}
impl windows_core::TypeKind for CRYPT_INTERFACE_REG {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_INTERFACE_REG {
    fn eq(&self, other: &Self) -> bool {
        self.dwInterface == other.dwInterface && self.dwFlags == other.dwFlags && self.cFunctions == other.cFunctions && self.rgpszFunctions == other.rgpszFunctions
    }
}
impl Eq for CRYPT_INTERFACE_REG {}
impl Default for CRYPT_INTERFACE_REG {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_KEY_PROV_INFO {
    pub pwszContainerName: windows_core::PWSTR,
    pub pwszProvName: windows_core::PWSTR,
    pub dwProvType: u32,
    pub dwFlags: CRYPT_KEY_FLAGS,
    pub cProvParam: u32,
    pub rgProvParam: *mut CRYPT_KEY_PROV_PARAM,
    pub dwKeySpec: u32,
}
impl Copy for CRYPT_KEY_PROV_INFO {}
impl Clone for CRYPT_KEY_PROV_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_KEY_PROV_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_KEY_PROV_INFO").field("pwszContainerName", &self.pwszContainerName).field("pwszProvName", &self.pwszProvName).field("dwProvType", &self.dwProvType).field("dwFlags", &self.dwFlags).field("cProvParam", &self.cProvParam).field("rgProvParam", &self.rgProvParam).field("dwKeySpec", &self.dwKeySpec).finish()
    }
}
impl windows_core::TypeKind for CRYPT_KEY_PROV_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_KEY_PROV_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.pwszContainerName == other.pwszContainerName && self.pwszProvName == other.pwszProvName && self.dwProvType == other.dwProvType && self.dwFlags == other.dwFlags && self.cProvParam == other.cProvParam && self.rgProvParam == other.rgProvParam && self.dwKeySpec == other.dwKeySpec
    }
}
impl Eq for CRYPT_KEY_PROV_INFO {}
impl Default for CRYPT_KEY_PROV_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_KEY_PROV_PARAM {
    pub dwParam: u32,
    pub pbData: *mut u8,
    pub cbData: u32,
    pub dwFlags: u32,
}
impl Copy for CRYPT_KEY_PROV_PARAM {}
impl Clone for CRYPT_KEY_PROV_PARAM {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_KEY_PROV_PARAM {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_KEY_PROV_PARAM").field("dwParam", &self.dwParam).field("pbData", &self.pbData).field("cbData", &self.cbData).field("dwFlags", &self.dwFlags).finish()
    }
}
impl windows_core::TypeKind for CRYPT_KEY_PROV_PARAM {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_KEY_PROV_PARAM {
    fn eq(&self, other: &Self) -> bool {
        self.dwParam == other.dwParam && self.pbData == other.pbData && self.cbData == other.cbData && self.dwFlags == other.dwFlags
    }
}
impl Eq for CRYPT_KEY_PROV_PARAM {}
impl Default for CRYPT_KEY_PROV_PARAM {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_KEY_SIGN_MESSAGE_PARA {
    pub cbSize: u32,
    pub dwMsgAndCertEncodingType: CERT_QUERY_ENCODING_TYPE,
    pub Anonymous: CRYPT_KEY_SIGN_MESSAGE_PARA_0,
    pub dwKeySpec: CERT_KEY_SPEC,
    pub HashAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub pvHashAuxInfo: *mut core::ffi::c_void,
    pub PubKeyAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
}
impl Copy for CRYPT_KEY_SIGN_MESSAGE_PARA {}
impl Clone for CRYPT_KEY_SIGN_MESSAGE_PARA {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CRYPT_KEY_SIGN_MESSAGE_PARA {
    type TypeKind = windows_core::CopyType;
}
impl Default for CRYPT_KEY_SIGN_MESSAGE_PARA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub union CRYPT_KEY_SIGN_MESSAGE_PARA_0 {
    pub hCryptProv: usize,
    pub hNCryptKey: NCRYPT_KEY_HANDLE,
}
impl Copy for CRYPT_KEY_SIGN_MESSAGE_PARA_0 {}
impl Clone for CRYPT_KEY_SIGN_MESSAGE_PARA_0 {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CRYPT_KEY_SIGN_MESSAGE_PARA_0 {
    type TypeKind = windows_core::CopyType;
}
impl Default for CRYPT_KEY_SIGN_MESSAGE_PARA_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_KEY_VERIFY_MESSAGE_PARA {
    pub cbSize: u32,
    pub dwMsgEncodingType: u32,
    pub hCryptProv: HCRYPTPROV_LEGACY,
}
impl Copy for CRYPT_KEY_VERIFY_MESSAGE_PARA {}
impl Clone for CRYPT_KEY_VERIFY_MESSAGE_PARA {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_KEY_VERIFY_MESSAGE_PARA {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_KEY_VERIFY_MESSAGE_PARA").field("cbSize", &self.cbSize).field("dwMsgEncodingType", &self.dwMsgEncodingType).field("hCryptProv", &self.hCryptProv).finish()
    }
}
impl windows_core::TypeKind for CRYPT_KEY_VERIFY_MESSAGE_PARA {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_KEY_VERIFY_MESSAGE_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwMsgEncodingType == other.dwMsgEncodingType && self.hCryptProv == other.hCryptProv
    }
}
impl Eq for CRYPT_KEY_VERIFY_MESSAGE_PARA {}
impl Default for CRYPT_KEY_VERIFY_MESSAGE_PARA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_MASK_GEN_ALGORITHM {
    pub pszObjId: windows_core::PSTR,
    pub HashAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
}
impl Copy for CRYPT_MASK_GEN_ALGORITHM {}
impl Clone for CRYPT_MASK_GEN_ALGORITHM {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_MASK_GEN_ALGORITHM {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_MASK_GEN_ALGORITHM").field("pszObjId", &self.pszObjId).field("HashAlgorithm", &self.HashAlgorithm).finish()
    }
}
impl windows_core::TypeKind for CRYPT_MASK_GEN_ALGORITHM {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_MASK_GEN_ALGORITHM {
    fn eq(&self, other: &Self) -> bool {
        self.pszObjId == other.pszObjId && self.HashAlgorithm == other.HashAlgorithm
    }
}
impl Eq for CRYPT_MASK_GEN_ALGORITHM {}
impl Default for CRYPT_MASK_GEN_ALGORITHM {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_OBJECT_LOCATOR_PROVIDER_TABLE {
    pub cbSize: u32,
    pub pfnGet: PFN_CRYPT_OBJECT_LOCATOR_PROVIDER_GET,
    pub pfnRelease: PFN_CRYPT_OBJECT_LOCATOR_PROVIDER_RELEASE,
    pub pfnFreePassword: PFN_CRYPT_OBJECT_LOCATOR_PROVIDER_FREE_PASSWORD,
    pub pfnFree: PFN_CRYPT_OBJECT_LOCATOR_PROVIDER_FREE,
    pub pfnFreeIdentifier: PFN_CRYPT_OBJECT_LOCATOR_PROVIDER_FREE_IDENTIFIER,
}
impl Copy for CRYPT_OBJECT_LOCATOR_PROVIDER_TABLE {}
impl Clone for CRYPT_OBJECT_LOCATOR_PROVIDER_TABLE {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_OBJECT_LOCATOR_PROVIDER_TABLE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_OBJECT_LOCATOR_PROVIDER_TABLE").field("cbSize", &self.cbSize).finish()
    }
}
impl windows_core::TypeKind for CRYPT_OBJECT_LOCATOR_PROVIDER_TABLE {
    type TypeKind = windows_core::CopyType;
}
impl Default for CRYPT_OBJECT_LOCATOR_PROVIDER_TABLE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_OBJID_TABLE {
    pub dwAlgId: u32,
    pub pszObjId: windows_core::PCSTR,
}
impl Copy for CRYPT_OBJID_TABLE {}
impl Clone for CRYPT_OBJID_TABLE {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_OBJID_TABLE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_OBJID_TABLE").field("dwAlgId", &self.dwAlgId).field("pszObjId", &self.pszObjId).finish()
    }
}
impl windows_core::TypeKind for CRYPT_OBJID_TABLE {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_OBJID_TABLE {
    fn eq(&self, other: &Self) -> bool {
        self.dwAlgId == other.dwAlgId && self.pszObjId == other.pszObjId
    }
}
impl Eq for CRYPT_OBJID_TABLE {}
impl Default for CRYPT_OBJID_TABLE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_OID_FUNC_ENTRY {
    pub pszOID: windows_core::PCSTR,
    pub pvFuncAddr: *mut core::ffi::c_void,
}
impl Copy for CRYPT_OID_FUNC_ENTRY {}
impl Clone for CRYPT_OID_FUNC_ENTRY {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_OID_FUNC_ENTRY {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_OID_FUNC_ENTRY").field("pszOID", &self.pszOID).field("pvFuncAddr", &self.pvFuncAddr).finish()
    }
}
impl windows_core::TypeKind for CRYPT_OID_FUNC_ENTRY {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_OID_FUNC_ENTRY {
    fn eq(&self, other: &Self) -> bool {
        self.pszOID == other.pszOID && self.pvFuncAddr == other.pvFuncAddr
    }
}
impl Eq for CRYPT_OID_FUNC_ENTRY {}
impl Default for CRYPT_OID_FUNC_ENTRY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_OID_INFO {
    pub cbSize: u32,
    pub pszOID: windows_core::PCSTR,
    pub pwszName: windows_core::PCWSTR,
    pub dwGroupId: u32,
    pub Anonymous: CRYPT_OID_INFO_0,
    pub ExtraInfo: CRYPT_INTEGER_BLOB,
}
impl Copy for CRYPT_OID_INFO {}
impl Clone for CRYPT_OID_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CRYPT_OID_INFO {
    type TypeKind = windows_core::CopyType;
}
impl Default for CRYPT_OID_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub union CRYPT_OID_INFO_0 {
    pub dwValue: u32,
    pub Algid: ALG_ID,
    pub dwLength: u32,
}
impl Copy for CRYPT_OID_INFO_0 {}
impl Clone for CRYPT_OID_INFO_0 {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CRYPT_OID_INFO_0 {
    type TypeKind = windows_core::CopyType;
}
impl Default for CRYPT_OID_INFO_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_PASSWORD_CREDENTIALSA {
    pub cbSize: u32,
    pub pszUsername: windows_core::PSTR,
    pub pszPassword: windows_core::PSTR,
}
impl Copy for CRYPT_PASSWORD_CREDENTIALSA {}
impl Clone for CRYPT_PASSWORD_CREDENTIALSA {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_PASSWORD_CREDENTIALSA {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_PASSWORD_CREDENTIALSA").field("cbSize", &self.cbSize).field("pszUsername", &self.pszUsername).field("pszPassword", &self.pszPassword).finish()
    }
}
impl windows_core::TypeKind for CRYPT_PASSWORD_CREDENTIALSA {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_PASSWORD_CREDENTIALSA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.pszUsername == other.pszUsername && self.pszPassword == other.pszPassword
    }
}
impl Eq for CRYPT_PASSWORD_CREDENTIALSA {}
impl Default for CRYPT_PASSWORD_CREDENTIALSA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_PASSWORD_CREDENTIALSW {
    pub cbSize: u32,
    pub pszUsername: windows_core::PWSTR,
    pub pszPassword: windows_core::PWSTR,
}
impl Copy for CRYPT_PASSWORD_CREDENTIALSW {}
impl Clone for CRYPT_PASSWORD_CREDENTIALSW {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_PASSWORD_CREDENTIALSW {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_PASSWORD_CREDENTIALSW").field("cbSize", &self.cbSize).field("pszUsername", &self.pszUsername).field("pszPassword", &self.pszPassword).finish()
    }
}
impl windows_core::TypeKind for CRYPT_PASSWORD_CREDENTIALSW {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_PASSWORD_CREDENTIALSW {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.pszUsername == other.pszUsername && self.pszPassword == other.pszPassword
    }
}
impl Eq for CRYPT_PASSWORD_CREDENTIALSW {}
impl Default for CRYPT_PASSWORD_CREDENTIALSW {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_PKCS12_PBE_PARAMS {
    pub iIterations: i32,
    pub cbSalt: u32,
}
impl Copy for CRYPT_PKCS12_PBE_PARAMS {}
impl Clone for CRYPT_PKCS12_PBE_PARAMS {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_PKCS12_PBE_PARAMS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_PKCS12_PBE_PARAMS").field("iIterations", &self.iIterations).field("cbSalt", &self.cbSalt).finish()
    }
}
impl windows_core::TypeKind for CRYPT_PKCS12_PBE_PARAMS {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_PKCS12_PBE_PARAMS {
    fn eq(&self, other: &Self) -> bool {
        self.iIterations == other.iIterations && self.cbSalt == other.cbSalt
    }
}
impl Eq for CRYPT_PKCS12_PBE_PARAMS {}
impl Default for CRYPT_PKCS12_PBE_PARAMS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_PKCS8_EXPORT_PARAMS {
    pub hCryptProv: usize,
    pub dwKeySpec: u32,
    pub pszPrivateKeyObjId: windows_core::PSTR,
    pub pEncryptPrivateKeyFunc: PCRYPT_ENCRYPT_PRIVATE_KEY_FUNC,
    pub pVoidEncryptFunc: *mut core::ffi::c_void,
}
impl Copy for CRYPT_PKCS8_EXPORT_PARAMS {}
impl Clone for CRYPT_PKCS8_EXPORT_PARAMS {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_PKCS8_EXPORT_PARAMS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_PKCS8_EXPORT_PARAMS").field("hCryptProv", &self.hCryptProv).field("dwKeySpec", &self.dwKeySpec).field("pszPrivateKeyObjId", &self.pszPrivateKeyObjId).field("pVoidEncryptFunc", &self.pVoidEncryptFunc).finish()
    }
}
impl windows_core::TypeKind for CRYPT_PKCS8_EXPORT_PARAMS {
    type TypeKind = windows_core::CopyType;
}
impl Default for CRYPT_PKCS8_EXPORT_PARAMS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_PKCS8_IMPORT_PARAMS {
    pub PrivateKey: CRYPT_INTEGER_BLOB,
    pub pResolvehCryptProvFunc: PCRYPT_RESOLVE_HCRYPTPROV_FUNC,
    pub pVoidResolveFunc: *mut core::ffi::c_void,
    pub pDecryptPrivateKeyFunc: PCRYPT_DECRYPT_PRIVATE_KEY_FUNC,
    pub pVoidDecryptFunc: *mut core::ffi::c_void,
}
impl Copy for CRYPT_PKCS8_IMPORT_PARAMS {}
impl Clone for CRYPT_PKCS8_IMPORT_PARAMS {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_PKCS8_IMPORT_PARAMS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_PKCS8_IMPORT_PARAMS").field("PrivateKey", &self.PrivateKey).field("pVoidResolveFunc", &self.pVoidResolveFunc).field("pVoidDecryptFunc", &self.pVoidDecryptFunc).finish()
    }
}
impl windows_core::TypeKind for CRYPT_PKCS8_IMPORT_PARAMS {
    type TypeKind = windows_core::CopyType;
}
impl Default for CRYPT_PKCS8_IMPORT_PARAMS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_PRIVATE_KEY_INFO {
    pub Version: u32,
    pub Algorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub PrivateKey: CRYPT_INTEGER_BLOB,
    pub pAttributes: *mut CRYPT_ATTRIBUTES,
}
impl Copy for CRYPT_PRIVATE_KEY_INFO {}
impl Clone for CRYPT_PRIVATE_KEY_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_PRIVATE_KEY_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_PRIVATE_KEY_INFO").field("Version", &self.Version).field("Algorithm", &self.Algorithm).field("PrivateKey", &self.PrivateKey).field("pAttributes", &self.pAttributes).finish()
    }
}
impl windows_core::TypeKind for CRYPT_PRIVATE_KEY_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_PRIVATE_KEY_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.Version == other.Version && self.Algorithm == other.Algorithm && self.PrivateKey == other.PrivateKey && self.pAttributes == other.pAttributes
    }
}
impl Eq for CRYPT_PRIVATE_KEY_INFO {}
impl Default for CRYPT_PRIVATE_KEY_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_PROPERTY_REF {
    pub pszProperty: windows_core::PWSTR,
    pub cbValue: u32,
    pub pbValue: *mut u8,
}
impl Copy for CRYPT_PROPERTY_REF {}
impl Clone for CRYPT_PROPERTY_REF {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_PROPERTY_REF {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_PROPERTY_REF").field("pszProperty", &self.pszProperty).field("cbValue", &self.cbValue).field("pbValue", &self.pbValue).finish()
    }
}
impl windows_core::TypeKind for CRYPT_PROPERTY_REF {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_PROPERTY_REF {
    fn eq(&self, other: &Self) -> bool {
        self.pszProperty == other.pszProperty && self.cbValue == other.cbValue && self.pbValue == other.pbValue
    }
}
impl Eq for CRYPT_PROPERTY_REF {}
impl Default for CRYPT_PROPERTY_REF {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_PROVIDERS {
    pub cProviders: u32,
    pub rgpszProviders: *mut windows_core::PWSTR,
}
impl Copy for CRYPT_PROVIDERS {}
impl Clone for CRYPT_PROVIDERS {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_PROVIDERS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_PROVIDERS").field("cProviders", &self.cProviders).field("rgpszProviders", &self.rgpszProviders).finish()
    }
}
impl windows_core::TypeKind for CRYPT_PROVIDERS {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_PROVIDERS {
    fn eq(&self, other: &Self) -> bool {
        self.cProviders == other.cProviders && self.rgpszProviders == other.rgpszProviders
    }
}
impl Eq for CRYPT_PROVIDERS {}
impl Default for CRYPT_PROVIDERS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_PROVIDER_REF {
    pub dwInterface: u32,
    pub pszFunction: windows_core::PWSTR,
    pub pszProvider: windows_core::PWSTR,
    pub cProperties: u32,
    pub rgpProperties: *mut *mut CRYPT_PROPERTY_REF,
    pub pUM: *mut CRYPT_IMAGE_REF,
    pub pKM: *mut CRYPT_IMAGE_REF,
}
impl Copy for CRYPT_PROVIDER_REF {}
impl Clone for CRYPT_PROVIDER_REF {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_PROVIDER_REF {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_PROVIDER_REF").field("dwInterface", &self.dwInterface).field("pszFunction", &self.pszFunction).field("pszProvider", &self.pszProvider).field("cProperties", &self.cProperties).field("rgpProperties", &self.rgpProperties).field("pUM", &self.pUM).field("pKM", &self.pKM).finish()
    }
}
impl windows_core::TypeKind for CRYPT_PROVIDER_REF {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_PROVIDER_REF {
    fn eq(&self, other: &Self) -> bool {
        self.dwInterface == other.dwInterface && self.pszFunction == other.pszFunction && self.pszProvider == other.pszProvider && self.cProperties == other.cProperties && self.rgpProperties == other.rgpProperties && self.pUM == other.pUM && self.pKM == other.pKM
    }
}
impl Eq for CRYPT_PROVIDER_REF {}
impl Default for CRYPT_PROVIDER_REF {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_PROVIDER_REFS {
    pub cProviders: u32,
    pub rgpProviders: *mut *mut CRYPT_PROVIDER_REF,
}
impl Copy for CRYPT_PROVIDER_REFS {}
impl Clone for CRYPT_PROVIDER_REFS {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_PROVIDER_REFS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_PROVIDER_REFS").field("cProviders", &self.cProviders).field("rgpProviders", &self.rgpProviders).finish()
    }
}
impl windows_core::TypeKind for CRYPT_PROVIDER_REFS {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_PROVIDER_REFS {
    fn eq(&self, other: &Self) -> bool {
        self.cProviders == other.cProviders && self.rgpProviders == other.rgpProviders
    }
}
impl Eq for CRYPT_PROVIDER_REFS {}
impl Default for CRYPT_PROVIDER_REFS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_PROVIDER_REG {
    pub cAliases: u32,
    pub rgpszAliases: *mut windows_core::PWSTR,
    pub pUM: *mut CRYPT_IMAGE_REG,
    pub pKM: *mut CRYPT_IMAGE_REG,
}
impl Copy for CRYPT_PROVIDER_REG {}
impl Clone for CRYPT_PROVIDER_REG {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_PROVIDER_REG {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_PROVIDER_REG").field("cAliases", &self.cAliases).field("rgpszAliases", &self.rgpszAliases).field("pUM", &self.pUM).field("pKM", &self.pKM).finish()
    }
}
impl windows_core::TypeKind for CRYPT_PROVIDER_REG {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_PROVIDER_REG {
    fn eq(&self, other: &Self) -> bool {
        self.cAliases == other.cAliases && self.rgpszAliases == other.rgpszAliases && self.pUM == other.pUM && self.pKM == other.pKM
    }
}
impl Eq for CRYPT_PROVIDER_REG {}
impl Default for CRYPT_PROVIDER_REG {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_PSOURCE_ALGORITHM {
    pub pszObjId: windows_core::PSTR,
    pub EncodingParameters: CRYPT_INTEGER_BLOB,
}
impl Copy for CRYPT_PSOURCE_ALGORITHM {}
impl Clone for CRYPT_PSOURCE_ALGORITHM {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_PSOURCE_ALGORITHM {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_PSOURCE_ALGORITHM").field("pszObjId", &self.pszObjId).field("EncodingParameters", &self.EncodingParameters).finish()
    }
}
impl windows_core::TypeKind for CRYPT_PSOURCE_ALGORITHM {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_PSOURCE_ALGORITHM {
    fn eq(&self, other: &Self) -> bool {
        self.pszObjId == other.pszObjId && self.EncodingParameters == other.EncodingParameters
    }
}
impl Eq for CRYPT_PSOURCE_ALGORITHM {}
impl Default for CRYPT_PSOURCE_ALGORITHM {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_RC2_CBC_PARAMETERS {
    pub dwVersion: u32,
    pub fIV: super::super::Foundation::BOOL,
    pub rgbIV: [u8; 8],
}
impl Copy for CRYPT_RC2_CBC_PARAMETERS {}
impl Clone for CRYPT_RC2_CBC_PARAMETERS {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_RC2_CBC_PARAMETERS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_RC2_CBC_PARAMETERS").field("dwVersion", &self.dwVersion).field("fIV", &self.fIV).field("rgbIV", &self.rgbIV).finish()
    }
}
impl windows_core::TypeKind for CRYPT_RC2_CBC_PARAMETERS {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_RC2_CBC_PARAMETERS {
    fn eq(&self, other: &Self) -> bool {
        self.dwVersion == other.dwVersion && self.fIV == other.fIV && self.rgbIV == other.rgbIV
    }
}
impl Eq for CRYPT_RC2_CBC_PARAMETERS {}
impl Default for CRYPT_RC2_CBC_PARAMETERS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_RC4_KEY_STATE {
    pub Key: [u8; 16],
    pub SBox: [u8; 256],
    pub i: u8,
    pub j: u8,
}
impl Copy for CRYPT_RC4_KEY_STATE {}
impl Clone for CRYPT_RC4_KEY_STATE {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_RC4_KEY_STATE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_RC4_KEY_STATE").field("Key", &self.Key).field("SBox", &self.SBox).field("i", &self.i).field("j", &self.j).finish()
    }
}
impl windows_core::TypeKind for CRYPT_RC4_KEY_STATE {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_RC4_KEY_STATE {
    fn eq(&self, other: &Self) -> bool {
        self.Key == other.Key && self.SBox == other.SBox && self.i == other.i && self.j == other.j
    }
}
impl Eq for CRYPT_RC4_KEY_STATE {}
impl Default for CRYPT_RC4_KEY_STATE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_RETRIEVE_AUX_INFO {
    pub cbSize: u32,
    pub pLastSyncTime: *mut super::super::Foundation::FILETIME,
    pub dwMaxUrlRetrievalByteCount: u32,
    pub pPreFetchInfo: *mut CRYPTNET_URL_CACHE_PRE_FETCH_INFO,
    pub pFlushInfo: *mut CRYPTNET_URL_CACHE_FLUSH_INFO,
    pub ppResponseInfo: *mut *mut CRYPTNET_URL_CACHE_RESPONSE_INFO,
    pub pwszCacheFileNamePrefix: windows_core::PWSTR,
    pub pftCacheResync: *mut super::super::Foundation::FILETIME,
    pub fProxyCacheRetrieval: super::super::Foundation::BOOL,
    pub dwHttpStatusCode: u32,
    pub ppwszErrorResponseHeaders: *mut windows_core::PWSTR,
    pub ppErrorContentBlob: *mut *mut CRYPT_INTEGER_BLOB,
}
impl Copy for CRYPT_RETRIEVE_AUX_INFO {}
impl Clone for CRYPT_RETRIEVE_AUX_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_RETRIEVE_AUX_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_RETRIEVE_AUX_INFO")
            .field("cbSize", &self.cbSize)
            .field("pLastSyncTime", &self.pLastSyncTime)
            .field("dwMaxUrlRetrievalByteCount", &self.dwMaxUrlRetrievalByteCount)
            .field("pPreFetchInfo", &self.pPreFetchInfo)
            .field("pFlushInfo", &self.pFlushInfo)
            .field("ppResponseInfo", &self.ppResponseInfo)
            .field("pwszCacheFileNamePrefix", &self.pwszCacheFileNamePrefix)
            .field("pftCacheResync", &self.pftCacheResync)
            .field("fProxyCacheRetrieval", &self.fProxyCacheRetrieval)
            .field("dwHttpStatusCode", &self.dwHttpStatusCode)
            .field("ppwszErrorResponseHeaders", &self.ppwszErrorResponseHeaders)
            .field("ppErrorContentBlob", &self.ppErrorContentBlob)
            .finish()
    }
}
impl windows_core::TypeKind for CRYPT_RETRIEVE_AUX_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_RETRIEVE_AUX_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.pLastSyncTime == other.pLastSyncTime && self.dwMaxUrlRetrievalByteCount == other.dwMaxUrlRetrievalByteCount && self.pPreFetchInfo == other.pPreFetchInfo && self.pFlushInfo == other.pFlushInfo && self.ppResponseInfo == other.ppResponseInfo && self.pwszCacheFileNamePrefix == other.pwszCacheFileNamePrefix && self.pftCacheResync == other.pftCacheResync && self.fProxyCacheRetrieval == other.fProxyCacheRetrieval && self.dwHttpStatusCode == other.dwHttpStatusCode && self.ppwszErrorResponseHeaders == other.ppwszErrorResponseHeaders && self.ppErrorContentBlob == other.ppErrorContentBlob
    }
}
impl Eq for CRYPT_RETRIEVE_AUX_INFO {}
impl Default for CRYPT_RETRIEVE_AUX_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_RSAES_OAEP_PARAMETERS {
    pub HashAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub MaskGenAlgorithm: CRYPT_MASK_GEN_ALGORITHM,
    pub PSourceAlgorithm: CRYPT_PSOURCE_ALGORITHM,
}
impl Copy for CRYPT_RSAES_OAEP_PARAMETERS {}
impl Clone for CRYPT_RSAES_OAEP_PARAMETERS {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_RSAES_OAEP_PARAMETERS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_RSAES_OAEP_PARAMETERS").field("HashAlgorithm", &self.HashAlgorithm).field("MaskGenAlgorithm", &self.MaskGenAlgorithm).field("PSourceAlgorithm", &self.PSourceAlgorithm).finish()
    }
}
impl windows_core::TypeKind for CRYPT_RSAES_OAEP_PARAMETERS {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_RSAES_OAEP_PARAMETERS {
    fn eq(&self, other: &Self) -> bool {
        self.HashAlgorithm == other.HashAlgorithm && self.MaskGenAlgorithm == other.MaskGenAlgorithm && self.PSourceAlgorithm == other.PSourceAlgorithm
    }
}
impl Eq for CRYPT_RSAES_OAEP_PARAMETERS {}
impl Default for CRYPT_RSAES_OAEP_PARAMETERS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_RSA_SSA_PSS_PARAMETERS {
    pub HashAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub MaskGenAlgorithm: CRYPT_MASK_GEN_ALGORITHM,
    pub dwSaltLength: u32,
    pub dwTrailerField: u32,
}
impl Copy for CRYPT_RSA_SSA_PSS_PARAMETERS {}
impl Clone for CRYPT_RSA_SSA_PSS_PARAMETERS {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_RSA_SSA_PSS_PARAMETERS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_RSA_SSA_PSS_PARAMETERS").field("HashAlgorithm", &self.HashAlgorithm).field("MaskGenAlgorithm", &self.MaskGenAlgorithm).field("dwSaltLength", &self.dwSaltLength).field("dwTrailerField", &self.dwTrailerField).finish()
    }
}
impl windows_core::TypeKind for CRYPT_RSA_SSA_PSS_PARAMETERS {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_RSA_SSA_PSS_PARAMETERS {
    fn eq(&self, other: &Self) -> bool {
        self.HashAlgorithm == other.HashAlgorithm && self.MaskGenAlgorithm == other.MaskGenAlgorithm && self.dwSaltLength == other.dwSaltLength && self.dwTrailerField == other.dwTrailerField
    }
}
impl Eq for CRYPT_RSA_SSA_PSS_PARAMETERS {}
impl Default for CRYPT_RSA_SSA_PSS_PARAMETERS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_SEQUENCE_OF_ANY {
    pub cValue: u32,
    pub rgValue: *mut CRYPT_INTEGER_BLOB,
}
impl Copy for CRYPT_SEQUENCE_OF_ANY {}
impl Clone for CRYPT_SEQUENCE_OF_ANY {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_SEQUENCE_OF_ANY {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_SEQUENCE_OF_ANY").field("cValue", &self.cValue).field("rgValue", &self.rgValue).finish()
    }
}
impl windows_core::TypeKind for CRYPT_SEQUENCE_OF_ANY {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_SEQUENCE_OF_ANY {
    fn eq(&self, other: &Self) -> bool {
        self.cValue == other.cValue && self.rgValue == other.rgValue
    }
}
impl Eq for CRYPT_SEQUENCE_OF_ANY {}
impl Default for CRYPT_SEQUENCE_OF_ANY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_SIGN_MESSAGE_PARA {
    pub cbSize: u32,
    pub dwMsgEncodingType: u32,
    pub pSigningCert: *const CERT_CONTEXT,
    pub HashAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub pvHashAuxInfo: *mut core::ffi::c_void,
    pub cMsgCert: u32,
    pub rgpMsgCert: *mut *mut CERT_CONTEXT,
    pub cMsgCrl: u32,
    pub rgpMsgCrl: *mut *mut CRL_CONTEXT,
    pub cAuthAttr: u32,
    pub rgAuthAttr: *mut CRYPT_ATTRIBUTE,
    pub cUnauthAttr: u32,
    pub rgUnauthAttr: *mut CRYPT_ATTRIBUTE,
    pub dwFlags: u32,
    pub dwInnerContentType: u32,
}
impl Copy for CRYPT_SIGN_MESSAGE_PARA {}
impl Clone for CRYPT_SIGN_MESSAGE_PARA {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_SIGN_MESSAGE_PARA {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_SIGN_MESSAGE_PARA")
            .field("cbSize", &self.cbSize)
            .field("dwMsgEncodingType", &self.dwMsgEncodingType)
            .field("pSigningCert", &self.pSigningCert)
            .field("HashAlgorithm", &self.HashAlgorithm)
            .field("pvHashAuxInfo", &self.pvHashAuxInfo)
            .field("cMsgCert", &self.cMsgCert)
            .field("rgpMsgCert", &self.rgpMsgCert)
            .field("cMsgCrl", &self.cMsgCrl)
            .field("rgpMsgCrl", &self.rgpMsgCrl)
            .field("cAuthAttr", &self.cAuthAttr)
            .field("rgAuthAttr", &self.rgAuthAttr)
            .field("cUnauthAttr", &self.cUnauthAttr)
            .field("rgUnauthAttr", &self.rgUnauthAttr)
            .field("dwFlags", &self.dwFlags)
            .field("dwInnerContentType", &self.dwInnerContentType)
            .finish()
    }
}
impl windows_core::TypeKind for CRYPT_SIGN_MESSAGE_PARA {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_SIGN_MESSAGE_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwMsgEncodingType == other.dwMsgEncodingType && self.pSigningCert == other.pSigningCert && self.HashAlgorithm == other.HashAlgorithm && self.pvHashAuxInfo == other.pvHashAuxInfo && self.cMsgCert == other.cMsgCert && self.rgpMsgCert == other.rgpMsgCert && self.cMsgCrl == other.cMsgCrl && self.rgpMsgCrl == other.rgpMsgCrl && self.cAuthAttr == other.cAuthAttr && self.rgAuthAttr == other.rgAuthAttr && self.cUnauthAttr == other.cUnauthAttr && self.rgUnauthAttr == other.rgUnauthAttr && self.dwFlags == other.dwFlags && self.dwInnerContentType == other.dwInnerContentType
    }
}
impl Eq for CRYPT_SIGN_MESSAGE_PARA {}
impl Default for CRYPT_SIGN_MESSAGE_PARA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_SMART_CARD_ROOT_INFO {
    pub rgbCardID: [u8; 16],
    pub luid: ROOT_INFO_LUID,
}
impl Copy for CRYPT_SMART_CARD_ROOT_INFO {}
impl Clone for CRYPT_SMART_CARD_ROOT_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_SMART_CARD_ROOT_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_SMART_CARD_ROOT_INFO").field("rgbCardID", &self.rgbCardID).field("luid", &self.luid).finish()
    }
}
impl windows_core::TypeKind for CRYPT_SMART_CARD_ROOT_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_SMART_CARD_ROOT_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.rgbCardID == other.rgbCardID && self.luid == other.luid
    }
}
impl Eq for CRYPT_SMART_CARD_ROOT_INFO {}
impl Default for CRYPT_SMART_CARD_ROOT_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_SMIME_CAPABILITIES {
    pub cCapability: u32,
    pub rgCapability: *mut CRYPT_SMIME_CAPABILITY,
}
impl Copy for CRYPT_SMIME_CAPABILITIES {}
impl Clone for CRYPT_SMIME_CAPABILITIES {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_SMIME_CAPABILITIES {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_SMIME_CAPABILITIES").field("cCapability", &self.cCapability).field("rgCapability", &self.rgCapability).finish()
    }
}
impl windows_core::TypeKind for CRYPT_SMIME_CAPABILITIES {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_SMIME_CAPABILITIES {
    fn eq(&self, other: &Self) -> bool {
        self.cCapability == other.cCapability && self.rgCapability == other.rgCapability
    }
}
impl Eq for CRYPT_SMIME_CAPABILITIES {}
impl Default for CRYPT_SMIME_CAPABILITIES {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_SMIME_CAPABILITY {
    pub pszObjId: windows_core::PSTR,
    pub Parameters: CRYPT_INTEGER_BLOB,
}
impl Copy for CRYPT_SMIME_CAPABILITY {}
impl Clone for CRYPT_SMIME_CAPABILITY {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_SMIME_CAPABILITY {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_SMIME_CAPABILITY").field("pszObjId", &self.pszObjId).field("Parameters", &self.Parameters).finish()
    }
}
impl windows_core::TypeKind for CRYPT_SMIME_CAPABILITY {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_SMIME_CAPABILITY {
    fn eq(&self, other: &Self) -> bool {
        self.pszObjId == other.pszObjId && self.Parameters == other.Parameters
    }
}
impl Eq for CRYPT_SMIME_CAPABILITY {}
impl Default for CRYPT_SMIME_CAPABILITY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_TIMESTAMP_ACCURACY {
    pub dwSeconds: u32,
    pub dwMillis: u32,
    pub dwMicros: u32,
}
impl Copy for CRYPT_TIMESTAMP_ACCURACY {}
impl Clone for CRYPT_TIMESTAMP_ACCURACY {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_TIMESTAMP_ACCURACY {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_TIMESTAMP_ACCURACY").field("dwSeconds", &self.dwSeconds).field("dwMillis", &self.dwMillis).field("dwMicros", &self.dwMicros).finish()
    }
}
impl windows_core::TypeKind for CRYPT_TIMESTAMP_ACCURACY {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_TIMESTAMP_ACCURACY {
    fn eq(&self, other: &Self) -> bool {
        self.dwSeconds == other.dwSeconds && self.dwMillis == other.dwMillis && self.dwMicros == other.dwMicros
    }
}
impl Eq for CRYPT_TIMESTAMP_ACCURACY {}
impl Default for CRYPT_TIMESTAMP_ACCURACY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_TIMESTAMP_CONTEXT {
    pub cbEncoded: u32,
    pub pbEncoded: *mut u8,
    pub pTimeStamp: *mut CRYPT_TIMESTAMP_INFO,
}
impl Copy for CRYPT_TIMESTAMP_CONTEXT {}
impl Clone for CRYPT_TIMESTAMP_CONTEXT {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_TIMESTAMP_CONTEXT {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_TIMESTAMP_CONTEXT").field("cbEncoded", &self.cbEncoded).field("pbEncoded", &self.pbEncoded).field("pTimeStamp", &self.pTimeStamp).finish()
    }
}
impl windows_core::TypeKind for CRYPT_TIMESTAMP_CONTEXT {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_TIMESTAMP_CONTEXT {
    fn eq(&self, other: &Self) -> bool {
        self.cbEncoded == other.cbEncoded && self.pbEncoded == other.pbEncoded && self.pTimeStamp == other.pTimeStamp
    }
}
impl Eq for CRYPT_TIMESTAMP_CONTEXT {}
impl Default for CRYPT_TIMESTAMP_CONTEXT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_TIMESTAMP_INFO {
    pub dwVersion: u32,
    pub pszTSAPolicyId: windows_core::PSTR,
    pub HashAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub HashedMessage: CRYPT_INTEGER_BLOB,
    pub SerialNumber: CRYPT_INTEGER_BLOB,
    pub ftTime: super::super::Foundation::FILETIME,
    pub pvAccuracy: *mut CRYPT_TIMESTAMP_ACCURACY,
    pub fOrdering: super::super::Foundation::BOOL,
    pub Nonce: CRYPT_INTEGER_BLOB,
    pub Tsa: CRYPT_INTEGER_BLOB,
    pub cExtension: u32,
    pub rgExtension: *mut CERT_EXTENSION,
}
impl Copy for CRYPT_TIMESTAMP_INFO {}
impl Clone for CRYPT_TIMESTAMP_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_TIMESTAMP_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_TIMESTAMP_INFO")
            .field("dwVersion", &self.dwVersion)
            .field("pszTSAPolicyId", &self.pszTSAPolicyId)
            .field("HashAlgorithm", &self.HashAlgorithm)
            .field("HashedMessage", &self.HashedMessage)
            .field("SerialNumber", &self.SerialNumber)
            .field("ftTime", &self.ftTime)
            .field("pvAccuracy", &self.pvAccuracy)
            .field("fOrdering", &self.fOrdering)
            .field("Nonce", &self.Nonce)
            .field("Tsa", &self.Tsa)
            .field("cExtension", &self.cExtension)
            .field("rgExtension", &self.rgExtension)
            .finish()
    }
}
impl windows_core::TypeKind for CRYPT_TIMESTAMP_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_TIMESTAMP_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwVersion == other.dwVersion && self.pszTSAPolicyId == other.pszTSAPolicyId && self.HashAlgorithm == other.HashAlgorithm && self.HashedMessage == other.HashedMessage && self.SerialNumber == other.SerialNumber && self.ftTime == other.ftTime && self.pvAccuracy == other.pvAccuracy && self.fOrdering == other.fOrdering && self.Nonce == other.Nonce && self.Tsa == other.Tsa && self.cExtension == other.cExtension && self.rgExtension == other.rgExtension
    }
}
impl Eq for CRYPT_TIMESTAMP_INFO {}
impl Default for CRYPT_TIMESTAMP_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_TIMESTAMP_PARA {
    pub pszTSAPolicyId: windows_core::PCSTR,
    pub fRequestCerts: super::super::Foundation::BOOL,
    pub Nonce: CRYPT_INTEGER_BLOB,
    pub cExtension: u32,
    pub rgExtension: *mut CERT_EXTENSION,
}
impl Copy for CRYPT_TIMESTAMP_PARA {}
impl Clone for CRYPT_TIMESTAMP_PARA {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_TIMESTAMP_PARA {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_TIMESTAMP_PARA").field("pszTSAPolicyId", &self.pszTSAPolicyId).field("fRequestCerts", &self.fRequestCerts).field("Nonce", &self.Nonce).field("cExtension", &self.cExtension).field("rgExtension", &self.rgExtension).finish()
    }
}
impl windows_core::TypeKind for CRYPT_TIMESTAMP_PARA {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_TIMESTAMP_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.pszTSAPolicyId == other.pszTSAPolicyId && self.fRequestCerts == other.fRequestCerts && self.Nonce == other.Nonce && self.cExtension == other.cExtension && self.rgExtension == other.rgExtension
    }
}
impl Eq for CRYPT_TIMESTAMP_PARA {}
impl Default for CRYPT_TIMESTAMP_PARA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_TIMESTAMP_REQUEST {
    pub dwVersion: CRYPT_TIMESTAMP_VERSION,
    pub HashAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub HashedMessage: CRYPT_INTEGER_BLOB,
    pub pszTSAPolicyId: windows_core::PSTR,
    pub Nonce: CRYPT_INTEGER_BLOB,
    pub fCertReq: super::super::Foundation::BOOL,
    pub cExtension: u32,
    pub rgExtension: *mut CERT_EXTENSION,
}
impl Copy for CRYPT_TIMESTAMP_REQUEST {}
impl Clone for CRYPT_TIMESTAMP_REQUEST {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_TIMESTAMP_REQUEST {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_TIMESTAMP_REQUEST").field("dwVersion", &self.dwVersion).field("HashAlgorithm", &self.HashAlgorithm).field("HashedMessage", &self.HashedMessage).field("pszTSAPolicyId", &self.pszTSAPolicyId).field("Nonce", &self.Nonce).field("fCertReq", &self.fCertReq).field("cExtension", &self.cExtension).field("rgExtension", &self.rgExtension).finish()
    }
}
impl windows_core::TypeKind for CRYPT_TIMESTAMP_REQUEST {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_TIMESTAMP_REQUEST {
    fn eq(&self, other: &Self) -> bool {
        self.dwVersion == other.dwVersion && self.HashAlgorithm == other.HashAlgorithm && self.HashedMessage == other.HashedMessage && self.pszTSAPolicyId == other.pszTSAPolicyId && self.Nonce == other.Nonce && self.fCertReq == other.fCertReq && self.cExtension == other.cExtension && self.rgExtension == other.rgExtension
    }
}
impl Eq for CRYPT_TIMESTAMP_REQUEST {}
impl Default for CRYPT_TIMESTAMP_REQUEST {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_TIMESTAMP_RESPONSE {
    pub dwStatus: CRYPT_TIMESTAMP_RESPONSE_STATUS,
    pub cFreeText: u32,
    pub rgFreeText: *mut windows_core::PWSTR,
    pub FailureInfo: CRYPT_BIT_BLOB,
    pub ContentInfo: CRYPT_INTEGER_BLOB,
}
impl Copy for CRYPT_TIMESTAMP_RESPONSE {}
impl Clone for CRYPT_TIMESTAMP_RESPONSE {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_TIMESTAMP_RESPONSE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_TIMESTAMP_RESPONSE").field("dwStatus", &self.dwStatus).field("cFreeText", &self.cFreeText).field("rgFreeText", &self.rgFreeText).field("FailureInfo", &self.FailureInfo).field("ContentInfo", &self.ContentInfo).finish()
    }
}
impl windows_core::TypeKind for CRYPT_TIMESTAMP_RESPONSE {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_TIMESTAMP_RESPONSE {
    fn eq(&self, other: &Self) -> bool {
        self.dwStatus == other.dwStatus && self.cFreeText == other.cFreeText && self.rgFreeText == other.rgFreeText && self.FailureInfo == other.FailureInfo && self.ContentInfo == other.ContentInfo
    }
}
impl Eq for CRYPT_TIMESTAMP_RESPONSE {}
impl Default for CRYPT_TIMESTAMP_RESPONSE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_TIME_STAMP_REQUEST_INFO {
    pub pszTimeStampAlgorithm: windows_core::PSTR,
    pub pszContentType: windows_core::PSTR,
    pub Content: CRYPT_INTEGER_BLOB,
    pub cAttribute: u32,
    pub rgAttribute: *mut CRYPT_ATTRIBUTE,
}
impl Copy for CRYPT_TIME_STAMP_REQUEST_INFO {}
impl Clone for CRYPT_TIME_STAMP_REQUEST_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_TIME_STAMP_REQUEST_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_TIME_STAMP_REQUEST_INFO").field("pszTimeStampAlgorithm", &self.pszTimeStampAlgorithm).field("pszContentType", &self.pszContentType).field("Content", &self.Content).field("cAttribute", &self.cAttribute).field("rgAttribute", &self.rgAttribute).finish()
    }
}
impl windows_core::TypeKind for CRYPT_TIME_STAMP_REQUEST_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_TIME_STAMP_REQUEST_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.pszTimeStampAlgorithm == other.pszTimeStampAlgorithm && self.pszContentType == other.pszContentType && self.Content == other.Content && self.cAttribute == other.cAttribute && self.rgAttribute == other.rgAttribute
    }
}
impl Eq for CRYPT_TIME_STAMP_REQUEST_INFO {}
impl Default for CRYPT_TIME_STAMP_REQUEST_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_URL_ARRAY {
    pub cUrl: u32,
    pub rgwszUrl: *mut windows_core::PWSTR,
}
impl Copy for CRYPT_URL_ARRAY {}
impl Clone for CRYPT_URL_ARRAY {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_URL_ARRAY {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_URL_ARRAY").field("cUrl", &self.cUrl).field("rgwszUrl", &self.rgwszUrl).finish()
    }
}
impl windows_core::TypeKind for CRYPT_URL_ARRAY {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_URL_ARRAY {
    fn eq(&self, other: &Self) -> bool {
        self.cUrl == other.cUrl && self.rgwszUrl == other.rgwszUrl
    }
}
impl Eq for CRYPT_URL_ARRAY {}
impl Default for CRYPT_URL_ARRAY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_URL_INFO {
    pub cbSize: u32,
    pub dwSyncDeltaTime: u32,
    pub cGroup: u32,
    pub rgcGroupEntry: *mut u32,
}
impl Copy for CRYPT_URL_INFO {}
impl Clone for CRYPT_URL_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_URL_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_URL_INFO").field("cbSize", &self.cbSize).field("dwSyncDeltaTime", &self.dwSyncDeltaTime).field("cGroup", &self.cGroup).field("rgcGroupEntry", &self.rgcGroupEntry).finish()
    }
}
impl windows_core::TypeKind for CRYPT_URL_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_URL_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwSyncDeltaTime == other.dwSyncDeltaTime && self.cGroup == other.cGroup && self.rgcGroupEntry == other.rgcGroupEntry
    }
}
impl Eq for CRYPT_URL_INFO {}
impl Default for CRYPT_URL_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_VERIFY_CERT_SIGN_STRONG_PROPERTIES_INFO {
    pub CertSignHashCNGAlgPropData: CRYPT_INTEGER_BLOB,
    pub CertIssuerPubKeyBitLengthPropData: CRYPT_INTEGER_BLOB,
}
impl Copy for CRYPT_VERIFY_CERT_SIGN_STRONG_PROPERTIES_INFO {}
impl Clone for CRYPT_VERIFY_CERT_SIGN_STRONG_PROPERTIES_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_VERIFY_CERT_SIGN_STRONG_PROPERTIES_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_VERIFY_CERT_SIGN_STRONG_PROPERTIES_INFO").field("CertSignHashCNGAlgPropData", &self.CertSignHashCNGAlgPropData).field("CertIssuerPubKeyBitLengthPropData", &self.CertIssuerPubKeyBitLengthPropData).finish()
    }
}
impl windows_core::TypeKind for CRYPT_VERIFY_CERT_SIGN_STRONG_PROPERTIES_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_VERIFY_CERT_SIGN_STRONG_PROPERTIES_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.CertSignHashCNGAlgPropData == other.CertSignHashCNGAlgPropData && self.CertIssuerPubKeyBitLengthPropData == other.CertIssuerPubKeyBitLengthPropData
    }
}
impl Eq for CRYPT_VERIFY_CERT_SIGN_STRONG_PROPERTIES_INFO {}
impl Default for CRYPT_VERIFY_CERT_SIGN_STRONG_PROPERTIES_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_VERIFY_CERT_SIGN_WEAK_HASH_INFO {
    pub cCNGHashAlgid: u32,
    pub rgpwszCNGHashAlgid: *const windows_core::PCWSTR,
    pub dwWeakIndex: u32,
}
impl Copy for CRYPT_VERIFY_CERT_SIGN_WEAK_HASH_INFO {}
impl Clone for CRYPT_VERIFY_CERT_SIGN_WEAK_HASH_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_VERIFY_CERT_SIGN_WEAK_HASH_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_VERIFY_CERT_SIGN_WEAK_HASH_INFO").field("cCNGHashAlgid", &self.cCNGHashAlgid).field("rgpwszCNGHashAlgid", &self.rgpwszCNGHashAlgid).field("dwWeakIndex", &self.dwWeakIndex).finish()
    }
}
impl windows_core::TypeKind for CRYPT_VERIFY_CERT_SIGN_WEAK_HASH_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_VERIFY_CERT_SIGN_WEAK_HASH_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cCNGHashAlgid == other.cCNGHashAlgid && self.rgpwszCNGHashAlgid == other.rgpwszCNGHashAlgid && self.dwWeakIndex == other.dwWeakIndex
    }
}
impl Eq for CRYPT_VERIFY_CERT_SIGN_WEAK_HASH_INFO {}
impl Default for CRYPT_VERIFY_CERT_SIGN_WEAK_HASH_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_VERIFY_MESSAGE_PARA {
    pub cbSize: u32,
    pub dwMsgAndCertEncodingType: u32,
    pub hCryptProv: HCRYPTPROV_LEGACY,
    pub pfnGetSignerCertificate: PFN_CRYPT_GET_SIGNER_CERTIFICATE,
    pub pvGetArg: *mut core::ffi::c_void,
}
impl Copy for CRYPT_VERIFY_MESSAGE_PARA {}
impl Clone for CRYPT_VERIFY_MESSAGE_PARA {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_VERIFY_MESSAGE_PARA {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_VERIFY_MESSAGE_PARA").field("cbSize", &self.cbSize).field("dwMsgAndCertEncodingType", &self.dwMsgAndCertEncodingType).field("hCryptProv", &self.hCryptProv).field("pvGetArg", &self.pvGetArg).finish()
    }
}
impl windows_core::TypeKind for CRYPT_VERIFY_MESSAGE_PARA {
    type TypeKind = windows_core::CopyType;
}
impl Default for CRYPT_VERIFY_MESSAGE_PARA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_X942_OTHER_INFO {
    pub pszContentEncryptionObjId: windows_core::PSTR,
    pub rgbCounter: [u8; 4],
    pub rgbKeyLength: [u8; 4],
    pub PubInfo: CRYPT_INTEGER_BLOB,
}
impl Copy for CRYPT_X942_OTHER_INFO {}
impl Clone for CRYPT_X942_OTHER_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_X942_OTHER_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_X942_OTHER_INFO").field("pszContentEncryptionObjId", &self.pszContentEncryptionObjId).field("rgbCounter", &self.rgbCounter).field("rgbKeyLength", &self.rgbKeyLength).field("PubInfo", &self.PubInfo).finish()
    }
}
impl windows_core::TypeKind for CRYPT_X942_OTHER_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_X942_OTHER_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.pszContentEncryptionObjId == other.pszContentEncryptionObjId && self.rgbCounter == other.rgbCounter && self.rgbKeyLength == other.rgbKeyLength && self.PubInfo == other.PubInfo
    }
}
impl Eq for CRYPT_X942_OTHER_INFO {}
impl Default for CRYPT_X942_OTHER_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_XML_ALGORITHM {
    pub cbSize: u32,
    pub wszAlgorithm: windows_core::PCWSTR,
    pub Encoded: CRYPT_XML_BLOB,
}
impl Copy for CRYPT_XML_ALGORITHM {}
impl Clone for CRYPT_XML_ALGORITHM {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_XML_ALGORITHM {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_XML_ALGORITHM").field("cbSize", &self.cbSize).field("wszAlgorithm", &self.wszAlgorithm).field("Encoded", &self.Encoded).finish()
    }
}
impl windows_core::TypeKind for CRYPT_XML_ALGORITHM {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_XML_ALGORITHM {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.wszAlgorithm == other.wszAlgorithm && self.Encoded == other.Encoded
    }
}
impl Eq for CRYPT_XML_ALGORITHM {}
impl Default for CRYPT_XML_ALGORITHM {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_XML_ALGORITHM_INFO {
    pub cbSize: u32,
    pub wszAlgorithmURI: windows_core::PWSTR,
    pub wszName: windows_core::PWSTR,
    pub dwGroupId: CRYPT_XML_GROUP_ID,
    pub wszCNGAlgid: windows_core::PWSTR,
    pub wszCNGExtraAlgid: windows_core::PWSTR,
    pub dwSignFlags: u32,
    pub dwVerifyFlags: u32,
    pub pvPaddingInfo: *mut core::ffi::c_void,
    pub pvExtraInfo: *mut core::ffi::c_void,
}
impl Copy for CRYPT_XML_ALGORITHM_INFO {}
impl Clone for CRYPT_XML_ALGORITHM_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_XML_ALGORITHM_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_XML_ALGORITHM_INFO").field("cbSize", &self.cbSize).field("wszAlgorithmURI", &self.wszAlgorithmURI).field("wszName", &self.wszName).field("dwGroupId", &self.dwGroupId).field("wszCNGAlgid", &self.wszCNGAlgid).field("wszCNGExtraAlgid", &self.wszCNGExtraAlgid).field("dwSignFlags", &self.dwSignFlags).field("dwVerifyFlags", &self.dwVerifyFlags).field("pvPaddingInfo", &self.pvPaddingInfo).field("pvExtraInfo", &self.pvExtraInfo).finish()
    }
}
impl windows_core::TypeKind for CRYPT_XML_ALGORITHM_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_XML_ALGORITHM_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.wszAlgorithmURI == other.wszAlgorithmURI && self.wszName == other.wszName && self.dwGroupId == other.dwGroupId && self.wszCNGAlgid == other.wszCNGAlgid && self.wszCNGExtraAlgid == other.wszCNGExtraAlgid && self.dwSignFlags == other.dwSignFlags && self.dwVerifyFlags == other.dwVerifyFlags && self.pvPaddingInfo == other.pvPaddingInfo && self.pvExtraInfo == other.pvExtraInfo
    }
}
impl Eq for CRYPT_XML_ALGORITHM_INFO {}
impl Default for CRYPT_XML_ALGORITHM_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_XML_BLOB {
    pub dwCharset: CRYPT_XML_CHARSET,
    pub cbData: u32,
    pub pbData: *mut u8,
}
impl Copy for CRYPT_XML_BLOB {}
impl Clone for CRYPT_XML_BLOB {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_XML_BLOB {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_XML_BLOB").field("dwCharset", &self.dwCharset).field("cbData", &self.cbData).field("pbData", &self.pbData).finish()
    }
}
impl windows_core::TypeKind for CRYPT_XML_BLOB {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_XML_BLOB {
    fn eq(&self, other: &Self) -> bool {
        self.dwCharset == other.dwCharset && self.cbData == other.cbData && self.pbData == other.pbData
    }
}
impl Eq for CRYPT_XML_BLOB {}
impl Default for CRYPT_XML_BLOB {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_XML_CRYPTOGRAPHIC_INTERFACE {
    pub cbSize: u32,
    pub fpCryptXmlEncodeAlgorithm: CryptXmlDllEncodeAlgorithm,
    pub fpCryptXmlCreateDigest: CryptXmlDllCreateDigest,
    pub fpCryptXmlDigestData: CryptXmlDllDigestData,
    pub fpCryptXmlFinalizeDigest: CryptXmlDllFinalizeDigest,
    pub fpCryptXmlCloseDigest: CryptXmlDllCloseDigest,
    pub fpCryptXmlSignData: CryptXmlDllSignData,
    pub fpCryptXmlVerifySignature: CryptXmlDllVerifySignature,
    pub fpCryptXmlGetAlgorithmInfo: CryptXmlDllGetAlgorithmInfo,
}
impl Copy for CRYPT_XML_CRYPTOGRAPHIC_INTERFACE {}
impl Clone for CRYPT_XML_CRYPTOGRAPHIC_INTERFACE {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_XML_CRYPTOGRAPHIC_INTERFACE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_XML_CRYPTOGRAPHIC_INTERFACE").field("cbSize", &self.cbSize).finish()
    }
}
impl windows_core::TypeKind for CRYPT_XML_CRYPTOGRAPHIC_INTERFACE {
    type TypeKind = windows_core::CopyType;
}
impl Default for CRYPT_XML_CRYPTOGRAPHIC_INTERFACE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_XML_DATA_BLOB {
    pub cbData: u32,
    pub pbData: *mut u8,
}
impl Copy for CRYPT_XML_DATA_BLOB {}
impl Clone for CRYPT_XML_DATA_BLOB {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_XML_DATA_BLOB {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_XML_DATA_BLOB").field("cbData", &self.cbData).field("pbData", &self.pbData).finish()
    }
}
impl windows_core::TypeKind for CRYPT_XML_DATA_BLOB {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_XML_DATA_BLOB {
    fn eq(&self, other: &Self) -> bool {
        self.cbData == other.cbData && self.pbData == other.pbData
    }
}
impl Eq for CRYPT_XML_DATA_BLOB {}
impl Default for CRYPT_XML_DATA_BLOB {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_XML_DATA_PROVIDER {
    pub pvCallbackState: *mut core::ffi::c_void,
    pub cbBufferSize: u32,
    pub pfnRead: PFN_CRYPT_XML_DATA_PROVIDER_READ,
    pub pfnClose: PFN_CRYPT_XML_DATA_PROVIDER_CLOSE,
}
impl Copy for CRYPT_XML_DATA_PROVIDER {}
impl Clone for CRYPT_XML_DATA_PROVIDER {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_XML_DATA_PROVIDER {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_XML_DATA_PROVIDER").field("pvCallbackState", &self.pvCallbackState).field("cbBufferSize", &self.cbBufferSize).finish()
    }
}
impl windows_core::TypeKind for CRYPT_XML_DATA_PROVIDER {
    type TypeKind = windows_core::CopyType;
}
impl Default for CRYPT_XML_DATA_PROVIDER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_XML_DOC_CTXT {
    pub cbSize: u32,
    pub hDocCtxt: *mut core::ffi::c_void,
    pub pTransformsConfig: *mut CRYPT_XML_TRANSFORM_CHAIN_CONFIG,
    pub cSignature: u32,
    pub rgpSignature: *mut *mut CRYPT_XML_SIGNATURE,
}
impl Copy for CRYPT_XML_DOC_CTXT {}
impl Clone for CRYPT_XML_DOC_CTXT {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_XML_DOC_CTXT {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_XML_DOC_CTXT").field("cbSize", &self.cbSize).field("hDocCtxt", &self.hDocCtxt).field("pTransformsConfig", &self.pTransformsConfig).field("cSignature", &self.cSignature).field("rgpSignature", &self.rgpSignature).finish()
    }
}
impl windows_core::TypeKind for CRYPT_XML_DOC_CTXT {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_XML_DOC_CTXT {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.hDocCtxt == other.hDocCtxt && self.pTransformsConfig == other.pTransformsConfig && self.cSignature == other.cSignature && self.rgpSignature == other.rgpSignature
    }
}
impl Eq for CRYPT_XML_DOC_CTXT {}
impl Default for CRYPT_XML_DOC_CTXT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_XML_ISSUER_SERIAL {
    pub wszIssuer: windows_core::PCWSTR,
    pub wszSerial: windows_core::PCWSTR,
}
impl Copy for CRYPT_XML_ISSUER_SERIAL {}
impl Clone for CRYPT_XML_ISSUER_SERIAL {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_XML_ISSUER_SERIAL {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_XML_ISSUER_SERIAL").field("wszIssuer", &self.wszIssuer).field("wszSerial", &self.wszSerial).finish()
    }
}
impl windows_core::TypeKind for CRYPT_XML_ISSUER_SERIAL {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_XML_ISSUER_SERIAL {
    fn eq(&self, other: &Self) -> bool {
        self.wszIssuer == other.wszIssuer && self.wszSerial == other.wszSerial
    }
}
impl Eq for CRYPT_XML_ISSUER_SERIAL {}
impl Default for CRYPT_XML_ISSUER_SERIAL {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_XML_KEYINFO_PARAM {
    pub wszId: windows_core::PCWSTR,
    pub wszKeyName: windows_core::PCWSTR,
    pub SKI: CRYPT_INTEGER_BLOB,
    pub wszSubjectName: windows_core::PCWSTR,
    pub cCertificate: u32,
    pub rgCertificate: *mut CRYPT_INTEGER_BLOB,
    pub cCRL: u32,
    pub rgCRL: *mut CRYPT_INTEGER_BLOB,
}
impl Copy for CRYPT_XML_KEYINFO_PARAM {}
impl Clone for CRYPT_XML_KEYINFO_PARAM {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_XML_KEYINFO_PARAM {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_XML_KEYINFO_PARAM").field("wszId", &self.wszId).field("wszKeyName", &self.wszKeyName).field("SKI", &self.SKI).field("wszSubjectName", &self.wszSubjectName).field("cCertificate", &self.cCertificate).field("rgCertificate", &self.rgCertificate).field("cCRL", &self.cCRL).field("rgCRL", &self.rgCRL).finish()
    }
}
impl windows_core::TypeKind for CRYPT_XML_KEYINFO_PARAM {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_XML_KEYINFO_PARAM {
    fn eq(&self, other: &Self) -> bool {
        self.wszId == other.wszId && self.wszKeyName == other.wszKeyName && self.SKI == other.SKI && self.wszSubjectName == other.wszSubjectName && self.cCertificate == other.cCertificate && self.rgCertificate == other.rgCertificate && self.cCRL == other.cCRL && self.rgCRL == other.rgCRL
    }
}
impl Eq for CRYPT_XML_KEYINFO_PARAM {}
impl Default for CRYPT_XML_KEYINFO_PARAM {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_XML_KEY_DSA_KEY_VALUE {
    pub P: CRYPT_XML_DATA_BLOB,
    pub Q: CRYPT_XML_DATA_BLOB,
    pub G: CRYPT_XML_DATA_BLOB,
    pub Y: CRYPT_XML_DATA_BLOB,
    pub J: CRYPT_XML_DATA_BLOB,
    pub Seed: CRYPT_XML_DATA_BLOB,
    pub Counter: CRYPT_XML_DATA_BLOB,
}
impl Copy for CRYPT_XML_KEY_DSA_KEY_VALUE {}
impl Clone for CRYPT_XML_KEY_DSA_KEY_VALUE {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_XML_KEY_DSA_KEY_VALUE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_XML_KEY_DSA_KEY_VALUE").field("P", &self.P).field("Q", &self.Q).field("G", &self.G).field("Y", &self.Y).field("J", &self.J).field("Seed", &self.Seed).field("Counter", &self.Counter).finish()
    }
}
impl windows_core::TypeKind for CRYPT_XML_KEY_DSA_KEY_VALUE {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_XML_KEY_DSA_KEY_VALUE {
    fn eq(&self, other: &Self) -> bool {
        self.P == other.P && self.Q == other.Q && self.G == other.G && self.Y == other.Y && self.J == other.J && self.Seed == other.Seed && self.Counter == other.Counter
    }
}
impl Eq for CRYPT_XML_KEY_DSA_KEY_VALUE {}
impl Default for CRYPT_XML_KEY_DSA_KEY_VALUE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_XML_KEY_ECDSA_KEY_VALUE {
    pub wszNamedCurve: windows_core::PCWSTR,
    pub X: CRYPT_XML_DATA_BLOB,
    pub Y: CRYPT_XML_DATA_BLOB,
    pub ExplicitPara: CRYPT_XML_BLOB,
}
impl Copy for CRYPT_XML_KEY_ECDSA_KEY_VALUE {}
impl Clone for CRYPT_XML_KEY_ECDSA_KEY_VALUE {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_XML_KEY_ECDSA_KEY_VALUE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_XML_KEY_ECDSA_KEY_VALUE").field("wszNamedCurve", &self.wszNamedCurve).field("X", &self.X).field("Y", &self.Y).field("ExplicitPara", &self.ExplicitPara).finish()
    }
}
impl windows_core::TypeKind for CRYPT_XML_KEY_ECDSA_KEY_VALUE {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_XML_KEY_ECDSA_KEY_VALUE {
    fn eq(&self, other: &Self) -> bool {
        self.wszNamedCurve == other.wszNamedCurve && self.X == other.X && self.Y == other.Y && self.ExplicitPara == other.ExplicitPara
    }
}
impl Eq for CRYPT_XML_KEY_ECDSA_KEY_VALUE {}
impl Default for CRYPT_XML_KEY_ECDSA_KEY_VALUE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_XML_KEY_INFO {
    pub cbSize: u32,
    pub wszId: windows_core::PCWSTR,
    pub cKeyInfo: u32,
    pub rgKeyInfo: *mut CRYPT_XML_KEY_INFO_ITEM,
    pub hVerifyKey: BCRYPT_KEY_HANDLE,
}
impl Copy for CRYPT_XML_KEY_INFO {}
impl Clone for CRYPT_XML_KEY_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_XML_KEY_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_XML_KEY_INFO").field("cbSize", &self.cbSize).field("wszId", &self.wszId).field("cKeyInfo", &self.cKeyInfo).field("rgKeyInfo", &self.rgKeyInfo).field("hVerifyKey", &self.hVerifyKey).finish()
    }
}
impl windows_core::TypeKind for CRYPT_XML_KEY_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_XML_KEY_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.wszId == other.wszId && self.cKeyInfo == other.cKeyInfo && self.rgKeyInfo == other.rgKeyInfo && self.hVerifyKey == other.hVerifyKey
    }
}
impl Eq for CRYPT_XML_KEY_INFO {}
impl Default for CRYPT_XML_KEY_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_XML_KEY_INFO_ITEM {
    pub dwType: CRYPT_XML_KEYINFO_TYPE,
    pub Anonymous: CRYPT_XML_KEY_INFO_ITEM_0,
}
impl Copy for CRYPT_XML_KEY_INFO_ITEM {}
impl Clone for CRYPT_XML_KEY_INFO_ITEM {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CRYPT_XML_KEY_INFO_ITEM {
    type TypeKind = windows_core::CopyType;
}
impl Default for CRYPT_XML_KEY_INFO_ITEM {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub union CRYPT_XML_KEY_INFO_ITEM_0 {
    pub wszKeyName: windows_core::PCWSTR,
    pub KeyValue: CRYPT_XML_KEY_VALUE,
    pub RetrievalMethod: CRYPT_XML_BLOB,
    pub X509Data: CRYPT_XML_X509DATA,
    pub Custom: CRYPT_XML_BLOB,
}
impl Copy for CRYPT_XML_KEY_INFO_ITEM_0 {}
impl Clone for CRYPT_XML_KEY_INFO_ITEM_0 {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CRYPT_XML_KEY_INFO_ITEM_0 {
    type TypeKind = windows_core::CopyType;
}
impl Default for CRYPT_XML_KEY_INFO_ITEM_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_XML_KEY_RSA_KEY_VALUE {
    pub Modulus: CRYPT_XML_DATA_BLOB,
    pub Exponent: CRYPT_XML_DATA_BLOB,
}
impl Copy for CRYPT_XML_KEY_RSA_KEY_VALUE {}
impl Clone for CRYPT_XML_KEY_RSA_KEY_VALUE {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_XML_KEY_RSA_KEY_VALUE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_XML_KEY_RSA_KEY_VALUE").field("Modulus", &self.Modulus).field("Exponent", &self.Exponent).finish()
    }
}
impl windows_core::TypeKind for CRYPT_XML_KEY_RSA_KEY_VALUE {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_XML_KEY_RSA_KEY_VALUE {
    fn eq(&self, other: &Self) -> bool {
        self.Modulus == other.Modulus && self.Exponent == other.Exponent
    }
}
impl Eq for CRYPT_XML_KEY_RSA_KEY_VALUE {}
impl Default for CRYPT_XML_KEY_RSA_KEY_VALUE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_XML_KEY_VALUE {
    pub dwType: CRYPT_XML_KEY_VALUE_TYPE,
    pub Anonymous: CRYPT_XML_KEY_VALUE_0,
}
impl Copy for CRYPT_XML_KEY_VALUE {}
impl Clone for CRYPT_XML_KEY_VALUE {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CRYPT_XML_KEY_VALUE {
    type TypeKind = windows_core::CopyType;
}
impl Default for CRYPT_XML_KEY_VALUE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub union CRYPT_XML_KEY_VALUE_0 {
    pub DSAKeyValue: CRYPT_XML_KEY_DSA_KEY_VALUE,
    pub RSAKeyValue: CRYPT_XML_KEY_RSA_KEY_VALUE,
    pub ECDSAKeyValue: CRYPT_XML_KEY_ECDSA_KEY_VALUE,
    pub Custom: CRYPT_XML_BLOB,
}
impl Copy for CRYPT_XML_KEY_VALUE_0 {}
impl Clone for CRYPT_XML_KEY_VALUE_0 {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CRYPT_XML_KEY_VALUE_0 {
    type TypeKind = windows_core::CopyType;
}
impl Default for CRYPT_XML_KEY_VALUE_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_XML_OBJECT {
    pub cbSize: u32,
    pub hObject: *mut core::ffi::c_void,
    pub wszId: windows_core::PCWSTR,
    pub wszMimeType: windows_core::PCWSTR,
    pub wszEncoding: windows_core::PCWSTR,
    pub Manifest: CRYPT_XML_REFERENCES,
    pub Encoded: CRYPT_XML_BLOB,
}
impl Copy for CRYPT_XML_OBJECT {}
impl Clone for CRYPT_XML_OBJECT {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_XML_OBJECT {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_XML_OBJECT").field("cbSize", &self.cbSize).field("hObject", &self.hObject).field("wszId", &self.wszId).field("wszMimeType", &self.wszMimeType).field("wszEncoding", &self.wszEncoding).field("Manifest", &self.Manifest).field("Encoded", &self.Encoded).finish()
    }
}
impl windows_core::TypeKind for CRYPT_XML_OBJECT {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_XML_OBJECT {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.hObject == other.hObject && self.wszId == other.wszId && self.wszMimeType == other.wszMimeType && self.wszEncoding == other.wszEncoding && self.Manifest == other.Manifest && self.Encoded == other.Encoded
    }
}
impl Eq for CRYPT_XML_OBJECT {}
impl Default for CRYPT_XML_OBJECT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_XML_PROPERTY {
    pub dwPropId: CRYPT_XML_PROPERTY_ID,
    pub pvValue: *const core::ffi::c_void,
    pub cbValue: u32,
}
impl Copy for CRYPT_XML_PROPERTY {}
impl Clone for CRYPT_XML_PROPERTY {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_XML_PROPERTY {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_XML_PROPERTY").field("dwPropId", &self.dwPropId).field("pvValue", &self.pvValue).field("cbValue", &self.cbValue).finish()
    }
}
impl windows_core::TypeKind for CRYPT_XML_PROPERTY {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_XML_PROPERTY {
    fn eq(&self, other: &Self) -> bool {
        self.dwPropId == other.dwPropId && self.pvValue == other.pvValue && self.cbValue == other.cbValue
    }
}
impl Eq for CRYPT_XML_PROPERTY {}
impl Default for CRYPT_XML_PROPERTY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_XML_REFERENCE {
    pub cbSize: u32,
    pub hReference: *mut core::ffi::c_void,
    pub wszId: windows_core::PCWSTR,
    pub wszUri: windows_core::PCWSTR,
    pub wszType: windows_core::PCWSTR,
    pub DigestMethod: CRYPT_XML_ALGORITHM,
    pub DigestValue: CRYPT_INTEGER_BLOB,
    pub cTransform: u32,
    pub rgTransform: *mut CRYPT_XML_ALGORITHM,
}
impl Copy for CRYPT_XML_REFERENCE {}
impl Clone for CRYPT_XML_REFERENCE {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_XML_REFERENCE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_XML_REFERENCE").field("cbSize", &self.cbSize).field("hReference", &self.hReference).field("wszId", &self.wszId).field("wszUri", &self.wszUri).field("wszType", &self.wszType).field("DigestMethod", &self.DigestMethod).field("DigestValue", &self.DigestValue).field("cTransform", &self.cTransform).field("rgTransform", &self.rgTransform).finish()
    }
}
impl windows_core::TypeKind for CRYPT_XML_REFERENCE {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_XML_REFERENCE {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.hReference == other.hReference && self.wszId == other.wszId && self.wszUri == other.wszUri && self.wszType == other.wszType && self.DigestMethod == other.DigestMethod && self.DigestValue == other.DigestValue && self.cTransform == other.cTransform && self.rgTransform == other.rgTransform
    }
}
impl Eq for CRYPT_XML_REFERENCE {}
impl Default for CRYPT_XML_REFERENCE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_XML_REFERENCES {
    pub cReference: u32,
    pub rgpReference: *mut *mut CRYPT_XML_REFERENCE,
}
impl Copy for CRYPT_XML_REFERENCES {}
impl Clone for CRYPT_XML_REFERENCES {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_XML_REFERENCES {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_XML_REFERENCES").field("cReference", &self.cReference).field("rgpReference", &self.rgpReference).finish()
    }
}
impl windows_core::TypeKind for CRYPT_XML_REFERENCES {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_XML_REFERENCES {
    fn eq(&self, other: &Self) -> bool {
        self.cReference == other.cReference && self.rgpReference == other.rgpReference
    }
}
impl Eq for CRYPT_XML_REFERENCES {}
impl Default for CRYPT_XML_REFERENCES {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_XML_SIGNATURE {
    pub cbSize: u32,
    pub hSignature: *mut core::ffi::c_void,
    pub wszId: windows_core::PCWSTR,
    pub SignedInfo: CRYPT_XML_SIGNED_INFO,
    pub SignatureValue: CRYPT_INTEGER_BLOB,
    pub pKeyInfo: *mut CRYPT_XML_KEY_INFO,
    pub cObject: u32,
    pub rgpObject: *mut *mut CRYPT_XML_OBJECT,
}
impl Copy for CRYPT_XML_SIGNATURE {}
impl Clone for CRYPT_XML_SIGNATURE {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_XML_SIGNATURE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_XML_SIGNATURE").field("cbSize", &self.cbSize).field("hSignature", &self.hSignature).field("wszId", &self.wszId).field("SignedInfo", &self.SignedInfo).field("SignatureValue", &self.SignatureValue).field("pKeyInfo", &self.pKeyInfo).field("cObject", &self.cObject).field("rgpObject", &self.rgpObject).finish()
    }
}
impl windows_core::TypeKind for CRYPT_XML_SIGNATURE {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_XML_SIGNATURE {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.hSignature == other.hSignature && self.wszId == other.wszId && self.SignedInfo == other.SignedInfo && self.SignatureValue == other.SignatureValue && self.pKeyInfo == other.pKeyInfo && self.cObject == other.cObject && self.rgpObject == other.rgpObject
    }
}
impl Eq for CRYPT_XML_SIGNATURE {}
impl Default for CRYPT_XML_SIGNATURE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_XML_SIGNED_INFO {
    pub cbSize: u32,
    pub wszId: windows_core::PCWSTR,
    pub Canonicalization: CRYPT_XML_ALGORITHM,
    pub SignatureMethod: CRYPT_XML_ALGORITHM,
    pub cReference: u32,
    pub rgpReference: *mut *mut CRYPT_XML_REFERENCE,
    pub Encoded: CRYPT_XML_BLOB,
}
impl Copy for CRYPT_XML_SIGNED_INFO {}
impl Clone for CRYPT_XML_SIGNED_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_XML_SIGNED_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_XML_SIGNED_INFO").field("cbSize", &self.cbSize).field("wszId", &self.wszId).field("Canonicalization", &self.Canonicalization).field("SignatureMethod", &self.SignatureMethod).field("cReference", &self.cReference).field("rgpReference", &self.rgpReference).field("Encoded", &self.Encoded).finish()
    }
}
impl windows_core::TypeKind for CRYPT_XML_SIGNED_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_XML_SIGNED_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.wszId == other.wszId && self.Canonicalization == other.Canonicalization && self.SignatureMethod == other.SignatureMethod && self.cReference == other.cReference && self.rgpReference == other.rgpReference && self.Encoded == other.Encoded
    }
}
impl Eq for CRYPT_XML_SIGNED_INFO {}
impl Default for CRYPT_XML_SIGNED_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_XML_STATUS {
    pub cbSize: u32,
    pub dwErrorStatus: CRYPT_XML_STATUS_ERROR_STATUS,
    pub dwInfoStatus: CRYPT_XML_STATUS_INFO_STATUS,
}
impl Copy for CRYPT_XML_STATUS {}
impl Clone for CRYPT_XML_STATUS {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_XML_STATUS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_XML_STATUS").field("cbSize", &self.cbSize).field("dwErrorStatus", &self.dwErrorStatus).field("dwInfoStatus", &self.dwInfoStatus).finish()
    }
}
impl windows_core::TypeKind for CRYPT_XML_STATUS {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_XML_STATUS {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwErrorStatus == other.dwErrorStatus && self.dwInfoStatus == other.dwInfoStatus
    }
}
impl Eq for CRYPT_XML_STATUS {}
impl Default for CRYPT_XML_STATUS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_XML_TRANSFORM_CHAIN_CONFIG {
    pub cbSize: u32,
    pub cTransformInfo: u32,
    pub rgpTransformInfo: *mut *mut CRYPT_XML_TRANSFORM_INFO,
}
impl Copy for CRYPT_XML_TRANSFORM_CHAIN_CONFIG {}
impl Clone for CRYPT_XML_TRANSFORM_CHAIN_CONFIG {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_XML_TRANSFORM_CHAIN_CONFIG {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_XML_TRANSFORM_CHAIN_CONFIG").field("cbSize", &self.cbSize).field("cTransformInfo", &self.cTransformInfo).field("rgpTransformInfo", &self.rgpTransformInfo).finish()
    }
}
impl windows_core::TypeKind for CRYPT_XML_TRANSFORM_CHAIN_CONFIG {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_XML_TRANSFORM_CHAIN_CONFIG {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.cTransformInfo == other.cTransformInfo && self.rgpTransformInfo == other.rgpTransformInfo
    }
}
impl Eq for CRYPT_XML_TRANSFORM_CHAIN_CONFIG {}
impl Default for CRYPT_XML_TRANSFORM_CHAIN_CONFIG {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_XML_TRANSFORM_INFO {
    pub cbSize: u32,
    pub wszAlgorithm: windows_core::PCWSTR,
    pub cbBufferSize: u32,
    pub dwFlags: CRYPT_XML_TRANSFORM_FLAGS,
    pub pfnCreateTransform: PFN_CRYPT_XML_CREATE_TRANSFORM,
}
impl Copy for CRYPT_XML_TRANSFORM_INFO {}
impl Clone for CRYPT_XML_TRANSFORM_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_XML_TRANSFORM_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_XML_TRANSFORM_INFO").field("cbSize", &self.cbSize).field("wszAlgorithm", &self.wszAlgorithm).field("cbBufferSize", &self.cbBufferSize).field("dwFlags", &self.dwFlags).finish()
    }
}
impl windows_core::TypeKind for CRYPT_XML_TRANSFORM_INFO {
    type TypeKind = windows_core::CopyType;
}
impl Default for CRYPT_XML_TRANSFORM_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_XML_X509DATA {
    pub cX509Data: u32,
    pub rgX509Data: *mut CRYPT_XML_X509DATA_ITEM,
}
impl Copy for CRYPT_XML_X509DATA {}
impl Clone for CRYPT_XML_X509DATA {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CRYPT_XML_X509DATA {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CRYPT_XML_X509DATA").field("cX509Data", &self.cX509Data).field("rgX509Data", &self.rgX509Data).finish()
    }
}
impl windows_core::TypeKind for CRYPT_XML_X509DATA {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CRYPT_XML_X509DATA {
    fn eq(&self, other: &Self) -> bool {
        self.cX509Data == other.cX509Data && self.rgX509Data == other.rgX509Data
    }
}
impl Eq for CRYPT_XML_X509DATA {}
impl Default for CRYPT_XML_X509DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CRYPT_XML_X509DATA_ITEM {
    pub dwType: CRYPT_XML_X509DATA_TYPE,
    pub Anonymous: CRYPT_XML_X509DATA_ITEM_0,
}
impl Copy for CRYPT_XML_X509DATA_ITEM {}
impl Clone for CRYPT_XML_X509DATA_ITEM {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CRYPT_XML_X509DATA_ITEM {
    type TypeKind = windows_core::CopyType;
}
impl Default for CRYPT_XML_X509DATA_ITEM {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub union CRYPT_XML_X509DATA_ITEM_0 {
    pub IssuerSerial: CRYPT_XML_ISSUER_SERIAL,
    pub SKI: CRYPT_XML_DATA_BLOB,
    pub wszSubjectName: windows_core::PCWSTR,
    pub Certificate: CRYPT_XML_DATA_BLOB,
    pub CRL: CRYPT_XML_DATA_BLOB,
    pub Custom: CRYPT_XML_BLOB,
}
impl Copy for CRYPT_XML_X509DATA_ITEM_0 {}
impl Clone for CRYPT_XML_X509DATA_ITEM_0 {
    fn clone(&self) -> Self {
        *self
    }
}
impl windows_core::TypeKind for CRYPT_XML_X509DATA_ITEM_0 {
    type TypeKind = windows_core::CopyType;
}
impl Default for CRYPT_XML_X509DATA_ITEM_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CTL_ANY_SUBJECT_INFO {
    pub SubjectAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub SubjectIdentifier: CRYPT_INTEGER_BLOB,
}
impl Copy for CTL_ANY_SUBJECT_INFO {}
impl Clone for CTL_ANY_SUBJECT_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CTL_ANY_SUBJECT_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CTL_ANY_SUBJECT_INFO").field("SubjectAlgorithm", &self.SubjectAlgorithm).field("SubjectIdentifier", &self.SubjectIdentifier).finish()
    }
}
impl windows_core::TypeKind for CTL_ANY_SUBJECT_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CTL_ANY_SUBJECT_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.SubjectAlgorithm == other.SubjectAlgorithm && self.SubjectIdentifier == other.SubjectIdentifier
    }
}
impl Eq for CTL_ANY_SUBJECT_INFO {}
impl Default for CTL_ANY_SUBJECT_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CTL_CONTEXT {
    pub dwMsgAndCertEncodingType: u32,
    pub pbCtlEncoded: *mut u8,
    pub cbCtlEncoded: u32,
    pub pCtlInfo: *mut CTL_INFO,
    pub hCertStore: HCERTSTORE,
    pub hCryptMsg: *mut core::ffi::c_void,
    pub pbCtlContent: *mut u8,
    pub cbCtlContent: u32,
}
impl Copy for CTL_CONTEXT {}
impl Clone for CTL_CONTEXT {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CTL_CONTEXT {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CTL_CONTEXT").field("dwMsgAndCertEncodingType", &self.dwMsgAndCertEncodingType).field("pbCtlEncoded", &self.pbCtlEncoded).field("cbCtlEncoded", &self.cbCtlEncoded).field("pCtlInfo", &self.pCtlInfo).field("hCertStore", &self.hCertStore).field("hCryptMsg", &self.hCryptMsg).field("pbCtlContent", &self.pbCtlContent).field("cbCtlContent", &self.cbCtlContent).finish()
    }
}
impl windows_core::TypeKind for CTL_CONTEXT {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CTL_CONTEXT {
    fn eq(&self, other: &Self) -> bool {
        self.dwMsgAndCertEncodingType == other.dwMsgAndCertEncodingType && self.pbCtlEncoded == other.pbCtlEncoded && self.cbCtlEncoded == other.cbCtlEncoded && self.pCtlInfo == other.pCtlInfo && self.hCertStore == other.hCertStore && self.hCryptMsg == other.hCryptMsg && self.pbCtlContent == other.pbCtlContent && self.cbCtlContent == other.cbCtlContent
    }
}
impl Eq for CTL_CONTEXT {}
impl Default for CTL_CONTEXT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CTL_ENTRY {
    pub SubjectIdentifier: CRYPT_INTEGER_BLOB,
    pub cAttribute: u32,
    pub rgAttribute: *mut CRYPT_ATTRIBUTE,
}
impl Copy for CTL_ENTRY {}
impl Clone for CTL_ENTRY {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CTL_ENTRY {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CTL_ENTRY").field("SubjectIdentifier", &self.SubjectIdentifier).field("cAttribute", &self.cAttribute).field("rgAttribute", &self.rgAttribute).finish()
    }
}
impl windows_core::TypeKind for CTL_ENTRY {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CTL_ENTRY {
    fn eq(&self, other: &Self) -> bool {
        self.SubjectIdentifier == other.SubjectIdentifier && self.cAttribute == other.cAttribute && self.rgAttribute == other.rgAttribute
    }
}
impl Eq for CTL_ENTRY {}
impl Default for CTL_ENTRY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CTL_FIND_SUBJECT_PARA {
    pub cbSize: u32,
    pub pUsagePara: *mut CTL_FIND_USAGE_PARA,
    pub dwSubjectType: u32,
    pub pvSubject: *mut core::ffi::c_void,
}
impl Copy for CTL_FIND_SUBJECT_PARA {}
impl Clone for CTL_FIND_SUBJECT_PARA {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CTL_FIND_SUBJECT_PARA {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CTL_FIND_SUBJECT_PARA").field("cbSize", &self.cbSize).field("pUsagePara", &self.pUsagePara).field("dwSubjectType", &self.dwSubjectType).field("pvSubject", &self.pvSubject).finish()
    }
}
impl windows_core::TypeKind for CTL_FIND_SUBJECT_PARA {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CTL_FIND_SUBJECT_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.pUsagePara == other.pUsagePara && self.dwSubjectType == other.dwSubjectType && self.pvSubject == other.pvSubject
    }
}
impl Eq for CTL_FIND_SUBJECT_PARA {}
impl Default for CTL_FIND_SUBJECT_PARA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CTL_FIND_USAGE_PARA {
    pub cbSize: u32,
    pub SubjectUsage: CTL_USAGE,
    pub ListIdentifier: CRYPT_INTEGER_BLOB,
    pub pSigner: *mut CERT_INFO,
}
impl Copy for CTL_FIND_USAGE_PARA {}
impl Clone for CTL_FIND_USAGE_PARA {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CTL_FIND_USAGE_PARA {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CTL_FIND_USAGE_PARA").field("cbSize", &self.cbSize).field("SubjectUsage", &self.SubjectUsage).field("ListIdentifier", &self.ListIdentifier).field("pSigner", &self.pSigner).finish()
    }
}
impl windows_core::TypeKind for CTL_FIND_USAGE_PARA {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CTL_FIND_USAGE_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.SubjectUsage == other.SubjectUsage && self.ListIdentifier == other.ListIdentifier && self.pSigner == other.pSigner
    }
}
impl Eq for CTL_FIND_USAGE_PARA {}
impl Default for CTL_FIND_USAGE_PARA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CTL_INFO {
    pub dwVersion: u32,
    pub SubjectUsage: CTL_USAGE,
    pub ListIdentifier: CRYPT_INTEGER_BLOB,
    pub SequenceNumber: CRYPT_INTEGER_BLOB,
    pub ThisUpdate: super::super::Foundation::FILETIME,
    pub NextUpdate: super::super::Foundation::FILETIME,
    pub SubjectAlgorithm: CRYPT_ALGORITHM_IDENTIFIER,
    pub cCTLEntry: u32,
    pub rgCTLEntry: *mut CTL_ENTRY,
    pub cExtension: u32,
    pub rgExtension: *mut CERT_EXTENSION,
}
impl Copy for CTL_INFO {}
impl Clone for CTL_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CTL_INFO {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CTL_INFO")
            .field("dwVersion", &self.dwVersion)
            .field("SubjectUsage", &self.SubjectUsage)
            .field("ListIdentifier", &self.ListIdentifier)
            .field("SequenceNumber", &self.SequenceNumber)
            .field("ThisUpdate", &self.ThisUpdate)
            .field("NextUpdate", &self.NextUpdate)
            .field("SubjectAlgorithm", &self.SubjectAlgorithm)
            .field("cCTLEntry", &self.cCTLEntry)
            .field("rgCTLEntry", &self.rgCTLEntry)
            .field("cExtension", &self.cExtension)
            .field("rgExtension", &self.rgExtension)
            .finish()
    }
}
impl windows_core::TypeKind for CTL_INFO {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CTL_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwVersion == other.dwVersion && self.SubjectUsage == other.SubjectUsage && self.ListIdentifier == other.ListIdentifier && self.SequenceNumber == other.SequenceNumber && self.ThisUpdate == other.ThisUpdate && self.NextUpdate == other.NextUpdate && self.SubjectAlgorithm == other.SubjectAlgorithm && self.cCTLEntry == other.cCTLEntry && self.rgCTLEntry == other.rgCTLEntry && self.cExtension == other.cExtension && self.rgExtension == other.rgExtension
    }
}
impl Eq for CTL_INFO {}
impl Default for CTL_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CTL_USAGE {
    pub cUsageIdentifier: u32,
    pub rgpszUsageIdentifier: *mut windows_core::PSTR,
}
impl Copy for CTL_USAGE {}
impl Clone for CTL_USAGE {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CTL_USAGE {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CTL_USAGE").field("cUsageIdentifier", &self.cUsageIdentifier).field("rgpszUsageIdentifier", &self.rgpszUsageIdentifier).finish()
    }
}
impl windows_core::TypeKind for CTL_USAGE {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CTL_USAGE {
    fn eq(&self, other: &Self) -> bool {
        self.cUsageIdentifier == other.cUsageIdentifier && self.rgpszUsageIdentifier == other.rgpszUsageIdentifier
    }
}
impl Eq for CTL_USAGE {}
impl Default for CTL_USAGE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CTL_USAGE_MATCH {
    pub dwType: u32,
    pub Usage: CTL_USAGE,
}
impl Copy for CTL_USAGE_MATCH {}
impl Clone for CTL_USAGE_MATCH {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CTL_USAGE_MATCH {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CTL_USAGE_MATCH").field("dwType", &self.dwType).field("Usage", &self.Usage).finish()
    }
}
impl windows_core::TypeKind for CTL_USAGE_MATCH {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CTL_USAGE_MATCH {
    fn eq(&self, other: &Self) -> bool {
        self.dwType == other.dwType && self.Usage == other.Usage
    }
}
impl Eq for CTL_USAGE_MATCH {}
impl Default for CTL_USAGE_MATCH {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CTL_VERIFY_USAGE_PARA {
    pub cbSize: u32,
    pub ListIdentifier: CRYPT_INTEGER_BLOB,
    pub cCtlStore: u32,
    pub rghCtlStore: *mut HCERTSTORE,
    pub cSignerStore: u32,
    pub rghSignerStore: *mut HCERTSTORE,
}
impl Copy for CTL_VERIFY_USAGE_PARA {}
impl Clone for CTL_VERIFY_USAGE_PARA {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CTL_VERIFY_USAGE_PARA {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CTL_VERIFY_USAGE_PARA").field("cbSize", &self.cbSize).field("ListIdentifier", &self.ListIdentifier).field("cCtlStore", &self.cCtlStore).field("rghCtlStore", &self.rghCtlStore).field("cSignerStore", &self.cSignerStore).field("rghSignerStore", &self.rghSignerStore).finish()
    }
}
impl windows_core::TypeKind for CTL_VERIFY_USAGE_PARA {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CTL_VERIFY_USAGE_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.ListIdentifier == other.ListIdentifier && self.cCtlStore == other.cCtlStore && self.rghCtlStore == other.rghCtlStore && self.cSignerStore == other.cSignerStore && self.rghSignerStore == other.rghSignerStore
    }
}
impl Eq for CTL_VERIFY_USAGE_PARA {}
impl Default for CTL_VERIFY_USAGE_PARA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct CTL_VERIFY_USAGE_STATUS {
    pub cbSize: u32,
    pub dwError: u32,
    pub dwFlags: u32,
    pub ppCtl: *mut *mut CTL_CONTEXT,
    pub dwCtlEntryIndex: u32,
    pub ppSigner: *mut *mut CERT_CONTEXT,
    pub dwSignerIndex: u32,
}
impl Copy for CTL_VERIFY_USAGE_STATUS {}
impl Clone for CTL_VERIFY_USAGE_STATUS {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for CTL_VERIFY_USAGE_STATUS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("CTL_VERIFY_USAGE_STATUS").field("cbSize", &self.cbSize).field("dwError", &self.dwError).field("dwFlags", &self.dwFlags).field("ppCtl", &self.ppCtl).field("dwCtlEntryIndex", &self.dwCtlEntryIndex).field("ppSigner", &self.ppSigner).field("dwSignerIndex", &self.dwSignerIndex).finish()
    }
}
impl windows_core::TypeKind for CTL_VERIFY_USAGE_STATUS {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for CTL_VERIFY_USAGE_STATUS {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwError == other.dwError && self.dwFlags == other.dwFlags && self.ppCtl == other.ppCtl && self.dwCtlEntryIndex == other.dwCtlEntryIndex && self.ppSigner == other.ppSigner && self.dwSignerIndex == other.dwSignerIndex
    }
}
impl Eq for CTL_VERIFY_USAGE_STATUS {}
impl Default for CTL_VERIFY_USAGE_STATUS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct DSSSEED {
    pub counter: u32,
    pub seed: [u8; 20],
}
impl Copy for DSSSEED {}
impl Clone for DSSSEED {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for DSSSEED {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("DSSSEED").field("counter", &self.counter).field("seed", &self.seed).finish()
    }
}
impl windows_core::TypeKind for DSSSEED {
    type TypeKind = windows_core::CopyType;
}
impl PartialEq for DSSSEED {
    fn eq(&self, other: &Self) -> bool {
        self.counter == other.counter && self.seed == other.seed
    }
}
impl Eq for DSSSEED {}
impl Default for DSSSEED {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct ENDPOINTADDRESS {
    pub serviceUrl: windows_core::PCWSTR,
    pub policyUrl: windows_core::PCWSTR,
    pub rawCertificate: CRYPT_INTEGER_BLOB,
}
impl Copy for ENDPOINTADDRESS {}
impl Clone for ENDPOINTADDRESS {
    fn clone(&self) -> Self {
        *self
    }
}
impl core::fmt::Debug for ENDPOINTADDRESS {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        f.debug_struct("ENDPOINTADDRESS").field("serviceUrl", &self.serv