/*
 * Copyright Amazon.com Inc. or its affiliates. All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 *
 */

#ifndef SHARE_GC_SHENANDOAH_HEURISTICS_SHENANDOAHSPACEINFO_HPP
#define SHARE_GC_SHENANDOAH_HEURISTICS_SHENANDOAHSPACEINFO_HPP

#include "utilities/globalDefinitions.hpp"

/*
 * The purpose of this interface is to decouple the heuristics from a
 * direct dependency on the ShenandoahHeap singleton instance. This is
 * done to facilitate future unit testing of the heuristics and to support
 * future operational modes of Shenandoah in which the heap may be split
 * into generations.
 */
class ShenandoahSpaceInfo {
public:
  virtual const char* name() const = 0;
  virtual size_t max_capacity() const = 0;
  virtual size_t soft_mutator_available() const = 0;
  virtual size_t available() const = 0;
  virtual size_t used() const = 0;

  // Return an approximation of the bytes allocated since GC start.  The value returned is monotonically non-decreasing
  // in time within each GC cycle.  For certain GC cycles, the value returned may include some bytes allocated before
  // the start of the current GC cycle.
  virtual size_t bytes_allocated_since_gc_start() const = 0;
};

#endif //SHARE_GC_SHENANDOAH_HEURISTICS_SHENANDOAHSPACEINFO_HPP
