/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.problems.internal.services;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.problems.ProblemId;
import org.gradle.api.problems.internal.InternalProblem;
import org.gradle.api.problems.internal.ProblemSummaryData;
import org.gradle.problems.internal.services.ProblemSummaryInfo;

public class SummarizerStrategy {
    private final Map<ProblemId, ProblemSummaryInfo> seenProblemsWithCounts = new HashMap<ProblemId, ProblemSummaryInfo>();
    private final int threshold;

    public SummarizerStrategy(int threshold) {
        this.threshold = threshold;
    }

    synchronized List<ProblemSummaryData> getCutOffProblems() {
        return (List)this.seenProblemsWithCounts.entrySet().stream().filter(entry -> ((ProblemSummaryInfo)entry.getValue()).getCount() > this.threshold).map(entry -> new ProblemSummaryData((ProblemId)entry.getKey(), ((ProblemSummaryInfo)entry.getValue()).getCount() - this.threshold)).collect(ImmutableList.toImmutableList());
    }

    synchronized boolean shouldEmit(InternalProblem problem) {
        ProblemSummaryInfo summaryInfo = this.seenProblemsWithCounts.computeIfAbsent(problem.getDefinition().getId(), key -> new ProblemSummaryInfo());
        return summaryInfo.shouldEmit(problem.hashCode(), this.threshold);
    }
}

