/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.draw2d.AbstractBackground;
import org.eclipse.draw2d.AncestorHelper;
import org.eclipse.draw2d.AncestorListener;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.CoordinateListener;
import org.eclipse.draw2d.EventDispatcher;
import org.eclipse.draw2d.EventListenerList;
import org.eclipse.draw2d.ExclusionSearch;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.FocusEvent;
import org.eclipse.draw2d.FocusListener;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GraphicsSource;
import org.eclipse.draw2d.IClippingStrategy;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.KeyEvent;
import org.eclipse.draw2d.KeyListener;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.MouseWheelListener;
import org.eclipse.draw2d.Orientable;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.UpdateManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionDimension;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionPointList;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;

public class Figure
implements IFigure {
    private static final Rectangle PRIVATE_RECT = new Rectangle();
    private static final Point PRIVATE_POINT = new Point();
    private static final int FLAG_VALID = 1;
    private static final int FLAG_OPAQUE = 2;
    private static final int FLAG_VISIBLE = 4;
    private static final int FLAG_FOCUSABLE = 8;
    private static final int FLAG_ENABLED = 16;
    private static final int FLAG_FOCUS_TRAVERSABLE = 32;
    static final int FLAG_REALIZED = Integer.MIN_VALUE;
    protected static int MAX_FLAG = 32;
    protected Rectangle bounds = new Rectangle(0, 0, 0, 0);
    private LayoutManager layoutManager;
    protected int flags = 20;
    private IFigure parent;
    private IClippingStrategy clippingStrategy = null;
    private Cursor cursor;
    private PropertyChangeSupport propertyListeners;
    private final EventListenerList eventListeners = new EventListenerList();
    private List<IFigure> children = Collections.emptyList();
    protected Dimension prefSize;
    protected Dimension minSize;
    protected Dimension maxSize;
    @Deprecated(forRemoval=true, since="2025-09")
    protected Font font;
    @Deprecated(forRemoval=true, since="2025-09")
    protected Color bgColor;
    @Deprecated(forRemoval=true, since="2025-09")
    protected Color fgColor;
    @Deprecated(forRemoval=true, since="2025-09")
    protected Border border;
    @Deprecated(forRemoval=true, since="2025-09")
    protected IFigure toolTip;
    private AncestorHelper ancestorHelper;
    protected static final UpdateManager NO_MANAGER = new UpdateManager(){

        @Override
        public void addDirtyRegion(IFigure figure, int x, int y, int w, int h) {
        }

        @Override
        public void addInvalidFigure(IFigure f) {
        }

        @Override
        public void performUpdate() {
        }

        @Override
        public void performUpdate(Rectangle region) {
        }

        @Override
        public void setRoot(IFigure root) {
        }

        @Override
        public void setGraphicsSource(GraphicsSource gs) {
        }
    };

    @Override
    public final void add(IFigure figure, Object constraint) {
        this.add(figure, constraint, -1);
    }

    @Override
    public void add(IFigure figure, Object constraint, int index) {
        if (this.children.equals(Collections.emptyList())) {
            this.children = new ArrayList<IFigure>(2);
        }
        if (index < -1 || index > this.children.size()) {
            throw new IndexOutOfBoundsException("Index does not exist");
        }
        IFigure f = this;
        while (f != null) {
            if (figure == f) {
                throw new IllegalArgumentException("Figure being added introduces cycle");
            }
            f = f.getParent();
        }
        if (figure.getParent() != null) {
            figure.getParent().remove(figure);
        }
        if (index == -1) {
            this.children.add(figure);
        } else {
            this.children.add(index, figure);
        }
        figure.setParent(this);
        if (this.layoutManager != null) {
            this.layoutManager.setConstraint(figure, constraint);
        }
        this.revalidate();
        if (this.getFlag(Integer.MIN_VALUE)) {
            figure.addNotify();
        }
        figure.repaint();
    }

    @Override
    public final void add(IFigure figure) {
        this.add(figure, null, -1);
    }

    @Override
    public final void add(IFigure figure, int index) {
        this.add(figure, null, index);
    }

    @Override
    public void addAncestorListener(AncestorListener ancestorListener) {
        if (this.ancestorHelper == null) {
            this.ancestorHelper = new AncestorHelper(this);
        }
        this.ancestorHelper.addAncestorListener(ancestorListener);
    }

    @Override
    public void addCoordinateListener(CoordinateListener listener) {
        this.eventListeners.addListener(CoordinateListener.class, listener);
    }

    @Override
    public void addFigureListener(FigureListener listener) {
        this.eventListeners.addListener(FigureListener.class, listener);
    }

    @Override
    public void addFocusListener(FocusListener listener) {
        this.eventListeners.addListener(FocusListener.class, listener);
    }

    @Override
    public void addKeyListener(KeyListener listener) {
        this.eventListeners.addListener(KeyListener.class, listener);
    }

    @Override
    public void addLayoutListener(LayoutListener listener) {
        LayoutManager layoutManager = this.layoutManager;
        if (layoutManager instanceof LayoutNotifier) {
            LayoutNotifier notifier = (LayoutNotifier)layoutManager;
            notifier.listeners.add(listener);
        } else {
            this.layoutManager = new LayoutNotifier(this.layoutManager, listener);
        }
    }

    protected <T> void addListener(Class<T> clazz, Object listener) {
        this.eventListeners.addListener(clazz, listener);
    }

    @Override
    public void addMouseListener(MouseListener listener) {
        this.eventListeners.addListener(MouseListener.class, listener);
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener listener) {
        this.eventListeners.addListener(MouseMotionListener.class, listener);
    }

    @Override
    public void addMouseWheelListener(MouseWheelListener listener) {
        this.eventListeners.addListener(MouseWheelListener.class, listener);
    }

    @Override
    public void addNotify() {
        if (this.getFlag(Integer.MIN_VALUE)) {
            throw new RuntimeException("addNotify() should not be called multiple times");
        }
        this.setFlag(Integer.MIN_VALUE, true);
        this.children.forEach(IFigure::addNotify);
    }

    @Override
    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        if (this.propertyListeners == null) {
            this.propertyListeners = new PropertyChangeSupport(this);
        }
        this.propertyListeners.addPropertyChangeListener(property, listener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyListeners == null) {
            this.propertyListeners = new PropertyChangeSupport(this);
        }
        this.propertyListeners.addPropertyChangeListener(listener);
    }

    @Override
    public final boolean containsPoint(Point p) {
        return this.containsPoint(p.x, p.y);
    }

    @Override
    public boolean containsPoint(int x, int y) {
        return this.getBounds().contains(x, y);
    }

    @Override
    public void erase() {
        if (this.getParent() == null || !this.isVisible()) {
            return;
        }
        Rectangle r = new Rectangle(this.getBounds());
        this.getParent().translateToParent(r);
        this.getParent().repaint(r.x, r.y, r.width, r.height);
    }

    protected IFigure findDescendantAtExcluding(int x, int y, TreeSearch search) {
        PRIVATE_POINT.setLocation(x, y);
        this.translateFromParent(PRIVATE_POINT);
        if (!this.getClientArea(Rectangle.SINGLETON).contains(PRIVATE_POINT)) {
            return null;
        }
        x = Figure.PRIVATE_POINT.x;
        y = Figure.PRIVATE_POINT.y;
        for (IFigure fig : this.getChildrenRevIterable()) {
            if (!fig.isVisible() || (fig = fig.findFigureAt(x, y, search)) == null) continue;
            return fig;
        }
        return null;
    }

    @Override
    public final IFigure findFigureAt(Point pt) {
        return this.findFigureAtExcluding(pt.x, pt.y, Collections.emptyList());
    }

    @Override
    public final IFigure findFigureAt(int x, int y) {
        return this.findFigureAt(x, y, IdentitySearch.INSTANCE);
    }

    @Override
    public IFigure findFigureAt(int x, int y, TreeSearch search) {
        if (!this.containsPoint(x, y)) {
            return null;
        }
        if (search.prune(this)) {
            return null;
        }
        IFigure child = this.findDescendantAtExcluding(x, y, search);
        if (child != null) {
            return child;
        }
        if (search.accept(this)) {
            return this;
        }
        return null;
    }

    @Override
    public final IFigure findFigureAtExcluding(int x, int y, Collection<IFigure> c) {
        return this.findFigureAt(x, y, new ExclusionSearch(c));
    }

    @Override
    public IFigure findMouseEventTargetAt(int x, int y) {
        if (!this.containsPoint(x, y)) {
            return null;
        }
        IFigure f = this.findMouseEventTargetInDescendantsAt(x, y);
        if (f != null) {
            return f;
        }
        if (this.isMouseEventTarget()) {
            return this;
        }
        return null;
    }

    protected IFigure findMouseEventTargetInDescendantsAt(int x, int y) {
        PRIVATE_POINT.setLocation(x, y);
        this.translateFromParent(PRIVATE_POINT);
        x = Figure.PRIVATE_POINT.x;
        y = Figure.PRIVATE_POINT.y;
        if (!this.getClientArea(Rectangle.SINGLETON).contains(x, y)) {
            return null;
        }
        for (IFigure fig : this.getChildrenRevIterable()) {
            if (!fig.isVisible() || !fig.isEnabled() || !fig.containsPoint(x, y) || (fig = fig.findMouseEventTargetAt(x, y)) == null) continue;
            return fig;
        }
        return null;
    }

    protected void fireCoordinateSystemChanged() {
        if (!this.eventListeners.containsListener(CoordinateListener.class)) {
            return;
        }
        this.eventListeners.getListenersIterable(CoordinateListener.class).forEach(lst -> lst.coordinateSystemChanged(this));
    }

    protected void fireFigureMoved() {
        if (!this.eventListeners.containsListener(FigureListener.class)) {
            return;
        }
        this.eventListeners.getListenersIterable(FigureListener.class).forEach(lst -> lst.figureMoved(this));
    }

    @Deprecated
    protected void fireMoved() {
        this.fireFigureMoved();
        this.fireCoordinateSystemChanged();
    }

    protected void firePropertyChange(String property, boolean old, boolean current) {
        if (this.propertyListeners == null) {
            return;
        }
        this.propertyListeners.firePropertyChange(property, old, current);
    }

    protected void firePropertyChange(String property, Object old, Object current) {
        if (this.propertyListeners == null) {
            return;
        }
        this.propertyListeners.firePropertyChange(property, old, current);
    }

    protected void firePropertyChange(String property, int old, int current) {
        if (this.propertyListeners == null) {
            return;
        }
        this.propertyListeners.firePropertyChange(property, old, current);
    }

    @Override
    public Color getBackgroundColor() {
        if (this.getLocalBackgroundColor() == null && this.getParent() != null) {
            return this.getParent().getBackgroundColor();
        }
        return this.getLocalBackgroundColor();
    }

    @Override
    public Border getBorder() {
        return this.border;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public List<? extends IFigure> getChildren() {
        return this.children;
    }

    public Iterable<IFigure> getChildrenRevIterable() {
        return () -> new ReverseFigureChildrenIterator(this);
    }

    @Override
    public Rectangle getClientArea(Rectangle rect) {
        rect.setBounds(this.getBounds());
        rect.shrink(this.getInsets());
        if (this.useLocalCoordinates()) {
            rect.setLocation(0, 0);
        }
        return rect;
    }

    @Override
    public final Rectangle getClientArea() {
        return this.getClientArea(new Rectangle());
    }

    @Override
    public IClippingStrategy getClippingStrategy() {
        return this.clippingStrategy;
    }

    @Override
    public Cursor getCursor() {
        if (this.cursor == null && this.getParent() != null) {
            return this.getParent().getCursor();
        }
        return this.cursor;
    }

    protected boolean getFlag(int flag) {
        return (this.flags & flag) != 0;
    }

    @Override
    public Font getFont() {
        if (this.getLocalFont() != null) {
            return this.getLocalFont();
        }
        if (this.getParent() != null) {
            return this.getParent().getFont();
        }
        return null;
    }

    @Override
    public Color getForegroundColor() {
        if (this.getLocalForegroundColor() == null && this.getParent() != null) {
            return this.getParent().getForegroundColor();
        }
        return this.getLocalForegroundColor();
    }

    @Override
    public Insets getInsets() {
        if (this.getBorder() != null) {
            return this.getBorder().getInsets(this);
        }
        return NO_INSETS;
    }

    @Override
    public LayoutManager getLayoutManager() {
        LayoutManager layoutManager = this.layoutManager;
        if (layoutManager instanceof LayoutNotifier) {
            LayoutNotifier layoutNotifier = (LayoutNotifier)layoutManager;
            return layoutNotifier.realLayout;
        }
        return this.layoutManager;
    }

    protected <T> Iterator<T> getListeners(Class<T> clazz) {
        return this.eventListeners.getListeners(clazz);
    }

    protected <T> Iterable<T> getListenersIterable(Class<T> listenerType) {
        return this.eventListeners.getListenersIterable(listenerType);
    }

    @Override
    public Color getLocalBackgroundColor() {
        return this.bgColor;
    }

    protected Font getLocalFont() {
        return this.font;
    }

    @Override
    public Color getLocalForegroundColor() {
        return this.fgColor;
    }

    @Override
    public final Point getLocation() {
        return IFigure.super.getLocation();
    }

    @Override
    public Dimension getMaximumSize() {
        if (this.maxSize != null) {
            return this.maxSize;
        }
        return MAX_DIMENSION;
    }

    @Override
    public final Dimension getMinimumSize() {
        return this.getMinimumSize(-1, -1);
    }

    @Override
    public Dimension getMinimumSize(int wHint, int hHint) {
        Dimension d;
        if (this.minSize != null) {
            return this.minSize;
        }
        if (this.getLayoutManager() != null && (d = this.getLayoutManager().getMinimumSize(this, wHint, hHint)) != null) {
            return d;
        }
        return this.getPreferredSize(wHint, hHint);
    }

    @Override
    public IFigure getParent() {
        return this.parent;
    }

    @Override
    public final Dimension getPreferredSize() {
        return this.getPreferredSize(-1, -1);
    }

    @Override
    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension d;
        if (this.prefSize != null) {
            return this.prefSize;
        }
        if (this.getLayoutManager() != null && (d = this.getLayoutManager().getPreferredSize(this, wHint, hHint)) != null) {
            return d;
        }
        return this.getSize();
    }

    @Override
    public final Dimension getSize() {
        return this.getBounds().getSize();
    }

    @Override
    public IFigure getToolTip() {
        return this.toolTip;
    }

    @Override
    public UpdateManager getUpdateManager() {
        if (this.getParent() != null) {
            return this.getParent().getUpdateManager();
        }
        return NO_MANAGER;
    }

    @Override
    public void handleFocusGained(FocusEvent event) {
        this.eventListeners.getListenersIterable(FocusListener.class).forEach(lst -> lst.focusGained(event));
    }

    @Override
    public void handleFocusLost(FocusEvent event) {
        this.eventListeners.getListenersIterable(FocusListener.class).forEach(lst -> lst.focusLost(event));
    }

    @Override
    public void handleKeyPressed(KeyEvent event) {
        Iterator<KeyListener> iter = this.eventListeners.getListeners(KeyListener.class);
        while (!event.isConsumed() && iter.hasNext()) {
            iter.next().keyPressed(event);
        }
    }

    @Override
    public void handleKeyReleased(KeyEvent event) {
        Iterator<KeyListener> iter = this.eventListeners.getListeners(KeyListener.class);
        while (!event.isConsumed() && iter.hasNext()) {
            iter.next().keyReleased(event);
        }
    }

    @Override
    public void handleMouseDoubleClicked(MouseEvent event) {
        Iterator<MouseListener> iter = this.eventListeners.getListeners(MouseListener.class);
        while (!event.isConsumed() && iter.hasNext()) {
            iter.next().mouseDoubleClicked(event);
        }
    }

    @Override
    public void handleMouseDragged(MouseEvent event) {
        Iterator<MouseMotionListener> iter = this.eventListeners.getListeners(MouseMotionListener.class);
        while (!event.isConsumed() && iter.hasNext()) {
            iter.next().mouseDragged(event);
        }
    }

    @Override
    public void handleMouseEntered(MouseEvent event) {
        Iterator<MouseMotionListener> iter = this.eventListeners.getListeners(MouseMotionListener.class);
        while (!event.isConsumed() && iter.hasNext()) {
            iter.next().mouseEntered(event);
        }
    }

    @Override
    public void handleMouseExited(MouseEvent event) {
        Iterator<MouseMotionListener> iter = this.eventListeners.getListeners(MouseMotionListener.class);
        while (!event.isConsumed() && iter.hasNext()) {
            iter.next().mouseExited(event);
        }
    }

    @Override
    public void handleMouseHover(MouseEvent event) {
        Iterator<MouseMotionListener> iter = this.eventListeners.getListeners(MouseMotionListener.class);
        while (!event.isConsumed() && iter.hasNext()) {
            iter.next().mouseHover(event);
        }
    }

    @Override
    public void handleMouseMoved(MouseEvent event) {
        Iterator<MouseMotionListener> iter = this.eventListeners.getListeners(MouseMotionListener.class);
        while (!event.isConsumed() && iter.hasNext()) {
            iter.next().mouseMoved(event);
        }
    }

    @Override
    public void handleMousePressed(MouseEvent event) {
        Iterator<MouseListener> iter = this.eventListeners.getListeners(MouseListener.class);
        while (!event.isConsumed() && iter.hasNext()) {
            iter.next().mousePressed(event);
        }
    }

    @Override
    public void handleMouseReleased(MouseEvent event) {
        Iterator<MouseListener> iter = this.eventListeners.getListeners(MouseListener.class);
        while (!event.isConsumed() && iter.hasNext()) {
            iter.next().mouseReleased(event);
        }
    }

    @Override
    public void handleMouseWheelScrolled(MouseEvent event) {
        Iterator<MouseWheelListener> iter = this.eventListeners.getListeners(MouseWheelListener.class);
        while (!event.isConsumed() && iter.hasNext()) {
            iter.next().mouseWheelMoved(event);
        }
    }

    @Override
    public boolean hasFocus() {
        EventDispatcher dispatcher = this.internalGetEventDispatcher();
        if (dispatcher == null) {
            return false;
        }
        return dispatcher.getFocusOwner() == this;
    }

    @Override
    public EventDispatcher internalGetEventDispatcher() {
        if (this.getParent() != null) {
            return this.getParent().internalGetEventDispatcher();
        }
        return null;
    }

    @Override
    public boolean intersects(Rectangle rect) {
        return this.getBounds().intersects(rect);
    }

    @Override
    public void invalidate() {
        if (this.layoutManager != null) {
            this.layoutManager.invalidate();
        }
        this.setValid(false);
    }

    @Override
    public void invalidateTree() {
        this.invalidate();
        this.children.forEach(IFigure::invalidateTree);
    }

    @Override
    public boolean isCoordinateSystem() {
        return this.useLocalCoordinates();
    }

    @Override
    public boolean isEnabled() {
        return (this.flags & 0x10) != 0;
    }

    @Override
    public boolean isFocusTraversable() {
        return (this.flags & 0x20) != 0;
    }

    protected boolean isMouseEventTarget() {
        return this.eventListeners.containsListener(MouseListener.class) || this.eventListeners.containsListener(MouseMotionListener.class);
    }

    @Override
    public boolean isMirrored() {
        if (this.getParent() != null) {
            return this.getParent().isMirrored();
        }
        return false;
    }

    @Override
    public boolean isOpaque() {
        return (this.flags & 2) != 0;
    }

    @Override
    public boolean isRequestFocusEnabled() {
        return (this.flags & 8) != 0;
    }

    @Override
    public boolean isShowing() {
        return this.isVisible() && (this.getParent() == null || this.getParent().isShowing());
    }

    protected boolean isValid() {
        return (this.flags & 1) != 0;
    }

    protected boolean isValidationRoot() {
        return false;
    }

    @Override
    public boolean isVisible() {
        return this.getFlag(4);
    }

    protected void layout() {
        if (this.layoutManager != null) {
            this.layoutManager.layout(this);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.getLocalBackgroundColor() != null) {
            graphics.setBackgroundColor(this.getLocalBackgroundColor());
        }
        if (this.getLocalForegroundColor() != null) {
            graphics.setForegroundColor(this.getLocalForegroundColor());
        }
        if (this.getLocalFont() != null) {
            graphics.setFont(this.getLocalFont());
        }
        graphics.pushState();
        try {
            this.paintFigure(graphics);
            graphics.restoreState();
            this.paintClientArea(graphics);
            this.paintBorder(graphics);
        }
        finally {
            graphics.popState();
        }
    }

    protected void paintBorder(Graphics graphics) {
        if (this.getBorder() != null) {
            this.getBorder().paint(this, graphics, NO_INSETS);
        }
    }

    protected void paintChildren(Graphics graphics) {
        for (IFigure child : this.children) {
            if (!child.isVisible()) continue;
            Rectangle[] clipping = null;
            clipping = this.clippingStrategy != null ? this.clippingStrategy.getClip(child) : new Rectangle[]{child.getBounds()};
            Rectangle[] rectangleArray = clipping;
            int n = clipping.length;
            int n2 = 0;
            while (n2 < n) {
                Rectangle element = rectangleArray[n2];
                if (element.intersects(graphics.getClip(Rectangle.SINGLETON))) {
                    graphics.clipRect(element);
                    child.paint(graphics);
                    graphics.restoreState();
                }
                ++n2;
            }
        }
    }

    protected void paintClientArea(Graphics graphics) {
        if (this.children.isEmpty()) {
            return;
        }
        if (this.useLocalCoordinates()) {
            graphics.translate(this.getBounds().x + this.getInsets().left, this.getBounds().y + this.getInsets().top);
            if (!this.optimizeClip()) {
                graphics.clipRect(this.getClientArea(PRIVATE_RECT));
            }
            graphics.pushState();
            this.paintChildren(graphics);
            graphics.popState();
            graphics.restoreState();
        } else if (this.optimizeClip()) {
            this.paintChildren(graphics);
        } else {
            graphics.clipRect(this.getClientArea(PRIVATE_RECT));
            graphics.pushState();
            this.paintChildren(graphics);
            graphics.popState();
            graphics.restoreState();
        }
    }

    protected boolean optimizeClip() {
        return this.getBorder() == null || this.getBorder().isOpaque();
    }

    protected void paintFigure(Graphics graphics) {
        Border border;
        if (this.isOpaque()) {
            graphics.fillRectangle(this.getBounds());
        }
        if ((border = this.getBorder()) instanceof AbstractBackground) {
            AbstractBackground abstractBackground = (AbstractBackground)border;
            abstractBackground.paintBackground(this, graphics, NO_INSETS);
        }
    }

    protected void primTranslate(int dx, int dy) {
        this.bounds.x += dx;
        this.bounds.y += dy;
        if (this.useLocalCoordinates()) {
            this.fireCoordinateSystemChanged();
            return;
        }
        this.children.forEach(child -> child.translate(dx, dy));
    }

    @Override
    public void remove(IFigure figure) {
        if (figure == null || figure.getParent() != this) {
            throw new IllegalArgumentException("Figure is not a child");
        }
        if (this.getFlag(Integer.MIN_VALUE)) {
            figure.removeNotify();
        }
        if (this.layoutManager != null) {
            this.layoutManager.remove(figure);
        }
        figure.erase();
        figure.setParent(null);
        this.children.remove(figure);
        this.revalidate();
    }

    public void removeAll() {
        ArrayList<? extends IFigure> list = new ArrayList<IFigure>(this.getChildren());
        list.forEach(this::remove);
    }

    @Override
    public void removeAncestorListener(AncestorListener listener) {
        if (this.ancestorHelper != null) {
            this.ancestorHelper.removeAncestorListener(listener);
            if (this.ancestorHelper.isEmpty()) {
                this.ancestorHelper.dispose();
                this.ancestorHelper = null;
            }
        }
    }

    @Override
    public void removeCoordinateListener(CoordinateListener listener) {
        this.eventListeners.removeListener(CoordinateListener.class, listener);
    }

    @Override
    public void removeFigureListener(FigureListener listener) {
        this.eventListeners.removeListener(FigureListener.class, listener);
    }

    @Override
    public void removeFocusListener(FocusListener listener) {
        this.eventListeners.removeListener(FocusListener.class, listener);
    }

    @Override
    public void removeKeyListener(KeyListener listener) {
        this.eventListeners.removeListener(KeyListener.class, listener);
    }

    @Override
    public void removeLayoutListener(LayoutListener listener) {
        LayoutManager layoutManager = this.layoutManager;
        if (layoutManager instanceof LayoutNotifier) {
            LayoutNotifier notifier = (LayoutNotifier)layoutManager;
            notifier.listeners.remove(listener);
            if (notifier.listeners.isEmpty()) {
                this.layoutManager = notifier.realLayout;
            }
        }
    }

    protected <T> void removeListener(Class<T> clazz, Object listener) {
        this.eventListeners.removeListener(clazz, listener);
    }

    @Override
    public void removeMouseListener(MouseListener listener) {
        this.eventListeners.removeListener(MouseListener.class, listener);
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener listener) {
        this.eventListeners.removeListener(MouseMotionListener.class, listener);
    }

    @Override
    public void removeMouseWheelListener(MouseWheelListener listener) {
        this.eventListeners.removeListener(MouseWheelListener.class, listener);
    }

    @Override
    public void removeNotify() {
        this.children.forEach(IFigure::removeNotify);
        if (this.internalGetEventDispatcher() != null) {
            this.internalGetEventDispatcher().requestRemoveFocus(this);
        }
        this.setFlag(Integer.MIN_VALUE, false);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyListeners == null) {
            return;
        }
        this.propertyListeners.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        if (this.propertyListeners == null) {
            return;
        }
        this.propertyListeners.removePropertyChangeListener(property, listener);
    }

    @Override
    public final void repaint(Rectangle rect) {
        this.repaint(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public void repaint(int x, int y, int w, int h) {
        if (this.isVisible()) {
            this.getUpdateManager().addDirtyRegion(this, x, y, w, h);
        }
    }

    @Override
    public void repaint() {
        this.repaint(this.getBounds());
    }

    @Override
    public final void requestFocus() {
        if (!this.isRequestFocusEnabled() || this.hasFocus()) {
            return;
        }
        EventDispatcher dispatcher = this.internalGetEventDispatcher();
        if (dispatcher == null) {
            return;
        }
        dispatcher.requestFocus(this);
    }

    @Override
    public void revalidate() {
        this.invalidate();
        if (this.getParent() == null || this.isValidationRoot()) {
            this.getUpdateManager().addInvalidFigure(this);
        } else {
            this.getParent().revalidate();
        }
    }

    @Override
    public void setBackgroundColor(Color bg) {
        if (Objects.equals(this.getLocalBackgroundColor(), bg)) {
            return;
        }
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        Color highContrastClr = null;
        try {
            if (display.getHighContrast()) {
                highContrastClr = display.getSystemColor(22);
            }
        }
        catch (SWTException e) {
            highContrastClr = null;
        }
        this.bgColor = highContrastClr == null ? bg : highContrastClr;
        this.repaint();
    }

    @Override
    public void setBorder(Border border) {
        if (this.getBorder() != border) {
            this.border = border;
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public void setBounds(Rectangle rect) {
        boolean translate;
        int x = this.bounds.x;
        int y = this.bounds.y;
        boolean resize = rect.width != this.bounds.width || rect.height != this.bounds.height;
        boolean bl = translate = rect.x != x || rect.y != y;
        if ((resize || translate) && this.isVisible()) {
            this.erase();
        }
        if (translate) {
            int dx = rect.x - x;
            int dy = rect.y - y;
            this.primTranslate(dx, dy);
        }
        this.bounds.width = rect.width;
        this.bounds.height = rect.height;
        if (translate || resize) {
            if (resize) {
                this.invalidate();
            }
            this.fireFigureMoved();
            this.repaint();
        }
    }

    protected void setChildrenDirection(int direction) {
        this.getChildrenRevIterable().forEach(child -> {
            if (child instanceof Orientable) {
                Orientable orientable = (Orientable)child;
                orientable.setDirection(direction);
            }
        });
    }

    protected void setChildrenEnabled(boolean value) {
        this.getChildrenRevIterable().forEach(child -> child.setEnabled(value));
    }

    protected void setChildrenOrientation(int orientation) {
        this.getChildrenRevIterable().forEach(child -> {
            if (child instanceof Orientable) {
                Orientable orientable = (Orientable)child;
                orientable.setOrientation(orientation);
            }
        });
    }

    @Override
    public void setConstraint(IFigure child, Object constraint) {
        if (child.getParent() != this) {
            throw new IllegalArgumentException("Figure must be a child");
        }
        if (this.layoutManager != null) {
            this.layoutManager.setConstraint(child, constraint);
        }
        this.revalidate();
    }

    @Override
    public void setClippingStrategy(IClippingStrategy clippingStrategy) {
        this.clippingStrategy = clippingStrategy;
    }

    @Override
    public void setCursor(Cursor cursor) {
        if (this.cursor == cursor) {
            return;
        }
        this.cursor = cursor;
        EventDispatcher dispatcher = this.internalGetEventDispatcher();
        if (dispatcher != null) {
            dispatcher.updateCursor();
        }
    }

    @Override
    public void setEnabled(boolean value) {
        if (this.isEnabled() == value) {
            return;
        }
        this.setFlag(16, value);
    }

    protected final void setFlag(int flag, boolean value) {
        this.flags = value ? (this.flags |= flag) : (this.flags &= ~flag);
    }

    @Override
    public void setFocusTraversable(boolean focusTraversable) {
        if (this.isFocusTraversable() == focusTraversable) {
            return;
        }
        this.setFlag(32, focusTraversable);
    }

    @Override
    public void setFont(Font f) {
        if (this.getLocalFont() != f) {
            this.font = f;
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public void setForegroundColor(Color fg) {
        if (Objects.equals(this.getLocalForegroundColor(), fg)) {
            return;
        }
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        Color highContrastClr = null;
        try {
            if (display.getHighContrast()) {
                highContrastClr = display.getSystemColor(21);
            }
        }
        catch (SWTException e) {
            highContrastClr = null;
        }
        this.fgColor = highContrastClr == null ? fg : highContrastClr;
        this.repaint();
    }

    @Override
    public void setLayoutManager(LayoutManager manager) {
        LayoutManager layoutManager = this.layoutManager;
        if (layoutManager instanceof LayoutNotifier) {
            LayoutNotifier layoutNotifier = (LayoutNotifier)layoutManager;
            layoutNotifier.realLayout = manager;
        } else {
            this.layoutManager = manager;
        }
        this.revalidate();
    }

    @Override
    public void setLocation(Point p) {
        if (this.getLocation().equals(p)) {
            return;
        }
        Rectangle r = new Rectangle(this.getBounds());
        r.setLocation(p);
        this.setBounds(r);
    }

    @Override
    public void setMaximumSize(Dimension d) {
        if (this.maxSize != null && this.maxSize.equals(d)) {
            return;
        }
        this.maxSize = d;
        this.revalidate();
    }

    @Override
    public void setMinimumSize(Dimension d) {
        if (this.minSize != null && this.minSize.equals(d)) {
            return;
        }
        this.minSize = d;
        this.revalidate();
    }

    @Override
    public void setOpaque(boolean opaque) {
        if (this.isOpaque() == opaque) {
            return;
        }
        this.setFlag(2, opaque);
        this.repaint();
    }

    @Override
    public void setParent(IFigure p) {
        IFigure oldParent = this.parent;
        this.parent = p;
        this.firePropertyChange("parent", oldParent, p);
    }

    @Override
    public void setPreferredSize(Dimension size) {
        if (this.prefSize != null && this.prefSize.equals(size)) {
            return;
        }
        this.prefSize = size;
        this.revalidate();
    }

    public final void setPreferredSize(int w, int h) {
        this.setPreferredSize(new Dimension(w, h));
    }

    @Override
    public void setRequestFocusEnabled(boolean requestFocusEnabled) {
        if (this.isRequestFocusEnabled() == requestFocusEnabled) {
            return;
        }
        this.setFlag(8, requestFocusEnabled);
    }

    @Override
    public final void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    @Override
    public void setSize(int w, int h) {
        Rectangle curBounds = this.getBounds();
        if (curBounds.width == w && curBounds.height == h) {
            return;
        }
        Rectangle r = new Rectangle(this.getBounds());
        r.setSize(w, h);
        this.setBounds(r);
    }

    @Override
    public void setToolTip(IFigure f) {
        if (this.toolTip == f) {
            return;
        }
        this.toolTip = f;
    }

    public void setValid(boolean value) {
        this.setFlag(1, value);
    }

    @Override
    public void setVisible(boolean visible) {
        boolean currentVisibility = this.isVisible();
        if (visible == currentVisibility) {
            return;
        }
        if (currentVisibility) {
            this.erase();
        }
        this.setFlag(4, visible);
        if (visible) {
            this.repaint();
        }
        this.revalidate();
    }

    @Override
    public final void translate(int x, int y) {
        this.primTranslate(x, y);
        this.fireFigureMoved();
    }

    @Override
    public void translateFromParent(Translatable t) {
        if (this.useLocalCoordinates()) {
            t.performTranslate(-this.getBounds().x - this.getInsets().left, -this.getBounds().y - this.getInsets().top);
        }
    }

    @Override
    public final void translateToAbsolute(Translatable t) {
        if (this.getParent() != null) {
            Translatable tPrecise = this.toPreciseShape(t);
            this.getParent().translateToParent(tPrecise);
            this.getParent().translateToAbsolute(tPrecise);
            this.fromPreciseShape(tPrecise, t);
        }
    }

    @Override
    public void translateToParent(Translatable t) {
        if (this.useLocalCoordinates()) {
            t.performTranslate(this.getBounds().x + this.getInsets().left, this.getBounds().y + this.getInsets().top);
        }
    }

    @Override
    public final void translateToRelative(Translatable t) {
        if (this.getParent() != null) {
            Translatable tPrecise = this.toPreciseShape(t);
            this.getParent().translateToRelative(tPrecise);
            this.getParent().translateFromParent(tPrecise);
            this.fromPreciseShape(tPrecise, t);
        }
    }

    private Translatable toPreciseShape(Translatable source) {
        Figure parentFigure;
        IFigure iFigure = this.getParent();
        if (iFigure instanceof Figure && (parentFigure = (Figure)iFigure).useDoublePrecision()) {
            if (source.getClass().equals(Point.class)) {
                return new PrecisionPoint((Point)source);
            }
            if (source.getClass().equals(Dimension.class)) {
                return new PrecisionDimension((Dimension)source);
            }
            if (source.getClass().equals(Rectangle.class)) {
                return new PrecisionRectangle((Rectangle)source);
            }
            if (source.getClass().equals(PointList.class)) {
                return new PrecisionPointList((PointList)source);
            }
        }
        return source;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void fromPreciseShape(Translatable source, Translatable target) {
        if (source == target) return;
        IFigure iFigure = this.getParent();
        if (!(iFigure instanceof Figure)) return;
        Figure parentFigure = (Figure)iFigure;
        if (!parentFigure.useDoublePrecision()) return;
        if (source instanceof PrecisionPoint) {
            PrecisionPoint p1 = (PrecisionPoint)source;
            if (target instanceof Point) {
                Point p2 = (Point)target;
                p2.setLocation(p1.x, p1.y);
                return;
            }
        }
        if (source instanceof PrecisionDimension) {
            PrecisionDimension d1 = (PrecisionDimension)source;
            if (target instanceof Dimension) {
                Dimension d2 = (Dimension)target;
                d2.setSize(d1.width, d1.height);
                return;
            }
        }
        if (source instanceof PrecisionRectangle) {
            PrecisionRectangle r1 = (PrecisionRectangle)source;
            if (target instanceof Rectangle) {
                Rectangle r2 = (Rectangle)target;
                r2.setBounds(r1.x, r1.y, (int)(Math.ceil(r1.preciseX() + r1.preciseWidth()) - Math.floor(r1.preciseX())), (int)(Math.ceil(r1.preciseY() + r1.preciseHeight()) - Math.floor(r1.preciseY())));
                return;
            }
        }
        if (!(source instanceof PrecisionPointList)) return;
        PrecisionPointList p1 = (PrecisionPointList)source;
        if (!(target instanceof PointList)) return;
        PointList p2 = (PointList)target;
        System.arraycopy(p1.toIntArray(), 0, p2.toIntArray(), 0, p2.size() * 2);
    }

    protected boolean useLocalCoordinates() {
        return false;
    }

    protected boolean useDoublePrecision() {
        return false;
    }

    @Override
    public void validate() {
        if (this.isValid()) {
            return;
        }
        this.setValid(true);
        this.layout();
        this.children.forEach(IFigure::validate);
    }

    @Deprecated(forRemoval=true, since="2025-09")
    public static class FigureIterator {
        private final List<? extends IFigure> list;
        private int index;

        public FigureIterator(IFigure figure) {
            this.list = figure.getChildren();
            this.index = this.list.size();
        }

        public IFigure nextFigure() {
            return this.list.get(--this.index);
        }

        public boolean hasNext() {
            return this.index > 0;
        }
    }

    protected static final class IdentitySearch
    implements TreeSearch {
        public static final TreeSearch INSTANCE = new IdentitySearch();

        private IdentitySearch() {
        }

        @Override
        public boolean accept(IFigure f) {
            return true;
        }

        @Override
        public boolean prune(IFigure f) {
            return false;
        }
    }

    final class LayoutNotifier
    implements LayoutManager {
        LayoutManager realLayout;
        List<LayoutListener> listeners = new CopyOnWriteArrayList<LayoutListener>();

        LayoutNotifier(LayoutManager layout, LayoutListener listener) {
            this.realLayout = layout;
            this.listeners.add(listener);
        }

        @Override
        public Object getConstraint(IFigure child) {
            if (this.realLayout != null) {
                return this.realLayout.getConstraint(child);
            }
            return null;
        }

        @Override
        public Dimension getMinimumSize(IFigure container, int wHint, int hHint) {
            if (this.realLayout != null) {
                return this.realLayout.getMinimumSize(container, wHint, hHint);
            }
            return null;
        }

        @Override
        public Dimension getPreferredSize(IFigure container, int wHint, int hHint) {
            if (this.realLayout != null) {
                return this.realLayout.getPreferredSize(container, wHint, hHint);
            }
            return null;
        }

        @Override
        public void invalidate() {
            this.listeners.forEach(listener -> listener.invalidate(Figure.this));
            if (this.realLayout != null) {
                this.realLayout.invalidate();
            }
        }

        @Override
        public void layout(IFigure container) {
            boolean consumed = false;
            for (LayoutListener listener2 : this.listeners) {
                consumed |= listener2.layout(container);
            }
            if (this.realLayout != null && !consumed) {
                this.realLayout.layout(container);
            }
            this.listeners.forEach(listener -> listener.postLayout(container));
        }

        @Override
        public void remove(IFigure child) {
            this.listeners.forEach(listener -> listener.remove(child));
            if (this.realLayout != null) {
                this.realLayout.remove(child);
            }
        }

        @Override
        public void setConstraint(IFigure child, Object constraint) {
            this.listeners.forEach(listener -> listener.setConstraint(child, constraint));
            if (this.realLayout != null) {
                this.realLayout.setConstraint(child, constraint);
            }
        }
    }

    public static final class ReverseFigureChildrenIterator
    extends FigureIterator
    implements Iterator<IFigure> {
        public ReverseFigureChildrenIterator(IFigure figure) {
            super(figure);
        }

        @Override
        public IFigure next() {
            return this.nextFigure();
        }
    }
}

