/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.GeomKind;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.geom.GeomBase;
import org.jetbrains.letsPlot.core.plot.base.geom.legend.VLineLegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.TargetCollectorHelper;
import org.jetbrains.letsPlot.core.plot.base.render.LegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/VLineGeom;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/GeomBase;", "()V", "legendKeyElementFactory", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "buildIntern", "", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "Companion", "plot-base"})
public final class VLineGeom
extends GeomBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final boolean HANDLES_GROUPS = false;
    @NotNull
    private static final LegendKeyElementFactory LEGEND_KEY_ELEMENT_FACTORY = new VLineLegendKeyElementFactory();

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        return LEGEND_KEY_ELEMENT_FACTORY;
    }

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics2, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        TargetCollectorHelper tooltipHelper2 = new TargetCollectorHelper(GeomKind.V_LINE, ctx2);
        GeomHelper geomHelper = new GeomHelper(pos, coord, ctx2);
        GeomHelper.SvgElementHelper helper2 = geomHelper.createSvgElementHelper();
        helper2.setStrokeAlphaEnabled(true);
        helper2.setResamplingEnabled(!coord.isLinear());
        DoubleRectangle viewPort = GeomBase.Companion.overallAesBounds(ctx2);
        for (DataPointAesthetics p : aesthetics2.dataPoints()) {
            Pair pair2;
            DoubleVector end;
            DoubleVector start2;
            Double d = p.interceptX();
            if (d == null) {
                continue;
            }
            double intercept = d;
            if (!viewPort.xRange().contains(intercept) || GeomHelper.SvgElementHelper.createLine$default(helper2, start2 = new DoubleVector(intercept, viewPort.getTop()), end = new DoubleVector(intercept, viewPort.getBottom()), p, null, 8, null) == null) continue;
            SvgNode svg = (SvgNode)pair2.component1();
            List geometry = (List)pair2.component2();
            tooltipHelper2.addLine(geometry, p);
            root.add(svg);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/VLineGeom$Companion;", "", "()V", "HANDLES_GROUPS", "", "LEGEND_KEY_ELEMENT_FACTORY", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "getLEGEND_KEY_ELEMENT_FACTORY", "()Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LegendKeyElementFactory getLEGEND_KEY_ELEMENT_FACTORY() {
            return LEGEND_KEY_ELEMENT_FACTORY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

