/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.stat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.commons.mutables.MutableDouble;
import org.jetbrains.letsPlot.core.plot.base.DataFrame;
import org.jetbrains.letsPlot.core.plot.base.data.TransformVar;
import org.jetbrains.letsPlot.core.plot.base.stat.BinStat;
import org.jetbrains.letsPlot.core.plot.base.stat.BinStatUtil;
import org.jetbrains.letsPlot.core.plot.base.stat.Stats;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00041234B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u001a\b\u0002\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\fJ \u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00102\u0006\u0010\u0011\u001a\u00020\bH\u0002J&\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00102\u0006\u0010\t\u001a\u00020\nJL\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00102\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\b2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u001a2\u0006\u0010\u001b\u001a\u00020\bH\u0002J>\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00102\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJt\u0010\"\u001a\u0014\u0012\u0004\u0012\u00020$\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00100#2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\b0\u00102$\u0010'\u001a \u0012\u0004\u0012\u00020$\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0010\u0012\u0004\u0012\u00020\b0\u001a0#2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\bH\u0002J~\u0010(\u001a\u0014\u0012\u0004\u0012\u00020$\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00100#2\u000e\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00102\u000e\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00102$\u0010'\u001a \u0012\u0004\u0012\u00020$\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0010\u0012\u0004\u0012\u00020\b0\u001a0#2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010+\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J?\u0010,\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0-2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b.J\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u001a2\u0006\u0010\u001d\u001a\u00020\u001eJ\u001e\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00102\u0006\u00100\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/BinStatUtil;", "", "()V", "MAX_BIN_COUNT", "", "binCountAndWidth", "Lorg/jetbrains/letsPlot/core/plot/base/stat/BinStatUtil$CountAndWidth;", "dataRange", "", "binOptions", "Lorg/jetbrains/letsPlot/core/plot/base/stat/BinStatUtil$BinOptions;", "countToWidth", "Lkotlin/Function2;", "computeDotdensityBins", "Lorg/jetbrains/letsPlot/core/plot/base/stat/BinStatUtil$BinsData;", "valuesX", "", "binWidth", "computeDotdensityStatSeries", "rangeX", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "computeHistogramBins", "Lorg/jetbrains/letsPlot/core/plot/base/stat/BinStatUtil$HistBinsData;", "startX", "binCount", "weightAtIndex", "Lkotlin/Function1;", "densityNormalizingFactor", "computeHistogramStatSeries", "data", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "xPosKind", "Lorg/jetbrains/letsPlot/core/plot/base/stat/BinStat$XPosKind;", "xPos", "computeSummaryBins", "", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;", "xValues", "yValues", "aggFunctions", "computeSummaryStatSeries", "xs", "ys", "defaultBinWidthCalculator", "getBinningParameters", "Lkotlin/Triple;", "getBinningParameters$plot_base", "weightVector", "dataLength", "BinOptions", "BinsData", "CountAndWidth", "HistBinsData", "plot-base"})
@SourceDebugExtension(value={"SMAP\nBinStatUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BinStatUtil.kt\norg/jetbrains/letsPlot/core/plot/base/stat/BinStatUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,318:1\n1#2:319\n372#3,7:320\n1271#4,2:327\n1285#4,4:329\n1549#4:333\n1620#4,3:334\n766#4:337\n857#4,2:338\n1549#4:340\n1620#4,3:341\n*S KotlinDebug\n*F\n+ 1 BinStatUtil.kt\norg/jetbrains/letsPlot/core/plot/base/stat/BinStatUtil\n*L\n174#1:320,7\n178#1:327,2\n178#1:329,4\n247#1:333\n247#1:334,3\n269#1:337\n269#1:338,2\n270#1:340\n270#1:341,3\n*E\n"})
public final class BinStatUtil {
    @NotNull
    public static final BinStatUtil INSTANCE = new BinStatUtil();
    private static final int MAX_BIN_COUNT = 500;

    private BinStatUtil() {
    }

    @NotNull
    public final Function1<Integer, Double> weightAtIndex(@NotNull DataFrame data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (data.has(TransformVar.INSTANCE.getWEIGHT())) {
            List<Double> weights = data.getNumeric(TransformVar.INSTANCE.getWEIGHT());
            return (Function1)new Function1<Integer, Double>(weights){
                final /* synthetic */ List<Double> $weights;
                {
                    this.$weights = $weights;
                    super(1);
                }

                @NotNull
                public final Double invoke(int index) {
                    Double d = SeriesUtil.INSTANCE.finiteOrNull(this.$weights.get(index));
                    return d != null ? d : 0.0;
                }
            };
        }
        return weightAtIndex.2.INSTANCE;
    }

    @NotNull
    public final List<Double> weightVector(int dataLength, @NotNull DataFrame data) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (data.has(TransformVar.INSTANCE.getWEIGHT())) {
            list2 = data.getNumeric(TransformVar.INSTANCE.getWEIGHT());
        } else {
            ArrayList<Double> arrayList = new ArrayList<Double>(dataLength);
            int n = 0;
            while (n < dataLength) {
                int n2;
                int n3 = n2 = n++;
                ArrayList<Double> arrayList2 = arrayList;
                boolean bl = false;
                arrayList2.add(1.0);
            }
            list2 = arrayList;
        }
        return list2;
    }

    @NotNull
    public final CountAndWidth binCountAndWidth(double dataRange, @NotNull BinOptions binOptions, @NotNull Function2<? super Double, ? super Integer, Double> countToWidth2) {
        Intrinsics.checkNotNullParameter((Object)binOptions, (String)"binOptions");
        Intrinsics.checkNotNullParameter(countToWidth2, (String)"countToWidth");
        int binCount = binOptions.getBinCount();
        double binWidth = 0.0;
        if (binOptions.hasBinWidth()) {
            Double d = binOptions.getBinWidth();
            Intrinsics.checkNotNull((Object)d);
            binWidth = d;
            double count2 = dataRange / binWidth;
            count2 = Math.min(500.0, count2);
            binCount = (int)Math.ceil(count2);
        } else {
            binWidth = ((Number)countToWidth2.invoke((Object)dataRange, (Object)binCount)).doubleValue();
        }
        return new CountAndWidth(binCount, binWidth);
    }

    public static /* synthetic */ CountAndWidth binCountAndWidth$default(BinStatUtil binStatUtil, double d, BinOptions binOptions, Function2 function2, int n, Object object) {
        if ((n & 4) != 0) {
            function2 = (Function2)new Function2<Double, Integer, Double>((Object)binStatUtil){

                @NotNull
                public final Double invoke(double p0, int p1) {
                    return BinStatUtil.access$defaultBinWidthCalculator((BinStatUtil)this.receiver, p0, p1);
                }
            };
        }
        return binStatUtil.binCountAndWidth(d, binOptions, (Function2<? super Double, ? super Integer, Double>)function2);
    }

    @NotNull
    public final Map<DataFrame.Variable, List<Double>> computeSummaryStatSeries(@NotNull List<Double> xs, @NotNull List<Double> ys, @NotNull Map<DataFrame.Variable, ? extends Function1<? super List<Double>, Double>> aggFunctions, @NotNull DoubleSpan rangeX, @NotNull BinStat.XPosKind xPosKind, double xPos, @NotNull BinOptions binOptions) {
        Intrinsics.checkNotNullParameter(xs, (String)"xs");
        Intrinsics.checkNotNullParameter(ys, (String)"ys");
        Intrinsics.checkNotNullParameter(aggFunctions, (String)"aggFunctions");
        Intrinsics.checkNotNullParameter((Object)rangeX, (String)"rangeX");
        Intrinsics.checkNotNullParameter((Object)((Object)xPosKind), (String)"xPosKind");
        Intrinsics.checkNotNullParameter((Object)binOptions, (String)"binOptions");
        List<List<Double>> list2 = SeriesUtil.INSTANCE.filterFinite(xs, ys);
        List<Double> xValues = list2.get(0);
        List<Double> yValues = list2.get(1);
        Triple<Integer, Double, Double> triple = this.getBinningParameters$plot_base(rangeX, xPosKind, xPos, binOptions);
        int binCount = ((Number)triple.component1()).intValue();
        double binWidth = ((Number)triple.component2()).doubleValue();
        double startX = ((Number)triple.component3()).doubleValue();
        Map<DataFrame.Variable, List<Double>> statData = this.computeSummaryBins(xValues, yValues, aggFunctions, startX, binCount, binWidth);
        List<Double> list3 = statData.get(Stats.INSTANCE.getX());
        if (!(list3 != null ? list3.size() == binCount : false)) {
            boolean bl = false;
            List<Double> list4 = statData.get(Stats.INSTANCE.getX());
            String string = "Internal: stat data size=" + (list4 != null ? Integer.valueOf(list4.size()) : null) + " expected bin count=" + binCount;
            throw new IllegalStateException(string.toString());
        }
        return statData;
    }

    @NotNull
    public final HistBinsData computeHistogramStatSeries(@NotNull DataFrame data, @NotNull DoubleSpan rangeX, @NotNull List<Double> valuesX, @NotNull BinStat.XPosKind xPosKind, double xPos, @NotNull BinOptions binOptions) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)rangeX, (String)"rangeX");
        Intrinsics.checkNotNullParameter(valuesX, (String)"valuesX");
        Intrinsics.checkNotNullParameter((Object)((Object)xPosKind), (String)"xPosKind");
        Intrinsics.checkNotNullParameter((Object)binOptions, (String)"binOptions");
        Triple<Integer, Double, Double> triple = this.getBinningParameters$plot_base(rangeX, xPosKind, xPos, binOptions);
        int binCount = ((Number)triple.component1()).intValue();
        double binWidth = ((Number)triple.component2()).doubleValue();
        double startX = ((Number)triple.component3()).doubleValue();
        double densityNormalizingFactor = binWidth > 0.0 ? 1.0 / binWidth : 1.0;
        HistBinsData binsData = this.computeHistogramBins(valuesX, startX, binCount, binWidth, this.weightAtIndex(data), densityNormalizingFactor);
        if (!(binsData.getX$plot_base().size() == binCount)) {
            boolean bl = false;
            String string = "Internal: stat data size=" + binsData.getX$plot_base().size() + " expected bin count=" + binCount;
            throw new IllegalStateException(string.toString());
        }
        return binsData;
    }

    @NotNull
    public final BinsData computeDotdensityStatSeries(@NotNull DoubleSpan rangeX, @NotNull List<Double> valuesX, @NotNull BinOptions binOptions) {
        Intrinsics.checkNotNullParameter((Object)rangeX, (String)"rangeX");
        Intrinsics.checkNotNullParameter(valuesX, (String)"valuesX");
        Intrinsics.checkNotNullParameter((Object)binOptions, (String)"binOptions");
        double spanX = rangeX.getLength();
        double binWidth = spanX > 0.0 ? BinStatUtil.binCountAndWidth$default(this, spanX, binOptions, null, 4, null).getWidth() : 1.0;
        return this.computeDotdensityBins(valuesX, binWidth);
    }

    @NotNull
    public final Triple<Integer, Double, Double> getBinningParameters$plot_base(@NotNull DoubleSpan rangeX, @NotNull BinStat.XPosKind xPosKind, double xPos, @NotNull BinOptions binOptions) {
        Intrinsics.checkNotNullParameter((Object)rangeX, (String)"rangeX");
        Intrinsics.checkNotNullParameter((Object)((Object)xPosKind), (String)"xPosKind");
        Intrinsics.checkNotNullParameter((Object)binOptions, (String)"binOptions");
        double startX = rangeX.getLowerEnd();
        double spanX = rangeX.getUpperEnd() - startX;
        CountAndWidth b2 = BinStatUtil.binCountAndWidth$default(this, spanX, binOptions, null, 4, null);
        startX -= b2.getWidth() * 0.7;
        CountAndWidth countAndWidth = BinStatUtil.binCountAndWidth$default(this, spanX += b2.getWidth() * 1.4, binOptions, null, 4, null);
        int binCount = countAndWidth.component1();
        double binWidth = countAndWidth.component2();
        if (xPosKind == BinStat.XPosKind.NONE) {
            return new Triple((Object)binCount, (Object)binWidth, (Object)startX);
        }
        double minDelta = WhenMappings.$EnumSwitchMapping$0[xPosKind.ordinal()] == 1 ? Double.MAX_VALUE : xPos - startX;
        for (int i = 0; i < binCount; ++i) {
            double delta;
            double binLeft = startX + (double)i * binWidth;
            double d = delta = WhenMappings.$EnumSwitchMapping$0[xPosKind.ordinal()] == 1 ? xPos - (binLeft + binWidth / (double)2) : xPos - (binLeft + binWidth);
            if (!(Math.abs(delta) < Math.abs(minDelta))) continue;
            minDelta = delta;
        }
        double offset = minDelta % (binWidth / (double)2);
        return new Triple((Object)binCount, (Object)binWidth, (Object)(startX += offset));
    }

    private final double defaultBinWidthCalculator(double dataRange, int binCount) {
        return dataRange / (double)binCount;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<DataFrame.Variable, List<Double>> computeSummaryBins(List<Double> xValues, List<Double> yValues, Map<DataFrame.Variable, ? extends Function1<? super List<Double>, Double>> aggFunctions, double startX, int binCount, double binWidth) {
        HashMap yValuesByBinIndex = new HashMap();
        for (Pair pair2 : CollectionsKt.zip((Iterable)xValues, (Iterable)yValues)) {
            Object object;
            void $this$getOrPut$iv;
            double x2 = ((Number)pair2.component1()).doubleValue();
            double y2 = ((Number)pair2.component2()).doubleValue();
            int binIndex = (int)Math.floor((x2 - startX) / binWidth);
            Map.Entry entry = yValuesByBinIndex;
            Integer key$iv = binIndex;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((List)object).add(y2);
        }
        ArrayList<Double> statX = new ArrayList<Double>();
        Iterable $this$associateWith$iv = aggFunctions.keySet();
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            DataFrame.Variable $i$f$getOrPut = (DataFrame.Variable)element$iv$iv;
            Object e = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            List list2 = new ArrayList();
            map2.put(e, list2);
        }
        Map summaryBins = result$iv;
        double lowerX = startX + binWidth / (double)2;
        for (int i = 0; i < binCount; ++i) {
            statX.add(lowerX + (double)i * binWidth);
            List list3 = (List)yValuesByBinIndex.get(i);
            if (list3 == null) {
                list3 = CollectionsKt.emptyList();
            }
            List sortedBin = CollectionsKt.sorted((Iterable)list3);
            for (Map.Entry entry : summaryBins.entrySet()) {
                DataFrame.Variable statVar = (DataFrame.Variable)entry.getKey();
                List aggValues = (List)entry.getValue();
                Function1 function1 = aggFunctions.get(statVar);
                if (function1 == null) {
                    function1 = computeSummaryBins.aggFunction.1.INSTANCE;
                }
                Function1 aggFunction2 = function1;
                aggValues.add(aggFunction2.invoke((Object)sortedBin));
            }
        }
        return MapsKt.plus((Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)Stats.INSTANCE.getX(), statX)), (Map)summaryBins);
    }

    /*
     * WARNING - void declaration
     */
    private final HistBinsData computeHistogramBins(List<Double> valuesX, double startX, int binCount, double binWidth, Function1<? super Integer, Double> weightAtIndex2, double densityNormalizingFactor) {
        ArrayList<Double> arrayList;
        Collection<Double> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        double totalCount = 0.0;
        HashMap countByBinIndex = new HashMap();
        int n = valuesX.size();
        for (int dataIndex = 0; dataIndex < n; ++dataIndex) {
            Double x2 = valuesX.get(dataIndex);
            if (!SeriesUtil.INSTANCE.isFinite(x2)) continue;
            double weight = ((Number)weightAtIndex2.invoke((Object)dataIndex)).doubleValue();
            totalCount += weight;
            Double d = x2;
            Intrinsics.checkNotNull((Object)d);
            int binIndex = (int)Math.floor((d - startX) / binWidth);
            if (!countByBinIndex.containsKey(binIndex)) {
                Integer n2 = binIndex;
                ((Map)countByBinIndex).put(n2, new MutableDouble(0.0));
            }
            Object v = countByBinIndex.get(binIndex);
            Intrinsics.checkNotNull(v);
            ((MutableDouble)v).getAndAdd(weight);
        }
        ArrayList<Double> x3 = new ArrayList<Double>();
        ArrayList<Double> counts = new ArrayList<Double>();
        ArrayList<Double> densities = new ArrayList<Double>();
        ArrayList<Double> sumProps = new ArrayList<Double>();
        double x0 = startX + binWidth / (double)2;
        for (int i = 0; i < binCount; ++i) {
            x3.add(x0 + (double)i * binWidth);
            double count2 = 0.0;
            if (countByBinIndex.containsKey(i)) {
                Object v = countByBinIndex.get(i);
                Intrinsics.checkNotNull(v);
                count2 = ((MutableDouble)v).get();
            }
            counts.add(count2);
            double sumProp = count2 / totalCount;
            sumProps.add(sumProp);
            double density2 = sumProp * densityNormalizingFactor;
            densities.add(density2);
        }
        Iterable i = sumProps;
        List list2 = sumProps;
        List list3 = densities;
        List list4 = counts;
        List list5 = x3;
        boolean $i$f$map = false;
        void var21_35 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        int $i$f$mapTo = 0;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            double d = ((Number)item$iv$iv).doubleValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((double)(it * (double)100));
        }
        collection = (List)destination$iv$iv;
        int n3 = x3.size();
        ArrayList<Double> arrayList2 = new ArrayList<Double>(n3);
        int n4 = 0;
        while (n4 < n3) {
            int n5;
            $i$f$mapTo = n5 = n4++;
            arrayList = arrayList2;
            boolean bl = false;
            arrayList.add(binWidth);
        }
        ArrayList<Double> arrayList3 = arrayList = (ArrayList<Double>)arrayList2;
        Collection<Double> collection2 = collection;
        List list6 = list2;
        List list7 = list3;
        List list8 = list4;
        List list9 = list5;
        return new HistBinsData(list9, list8, list7, list6, (List<Double>)collection2, (List<Double>)arrayList3);
    }

    /*
     * WARNING - void declaration
     */
    private final BinsData computeDotdensityBins(List<Double> valuesX, double binWidth) {
        Object[] $this$mapTo$iv$iv;
        void $this$map$iv;
        boolean bl;
        Double it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = valuesX;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object t : $this$filterTo$iv$iv) {
            it = (Double)t;
            bl = false;
            if (!SeriesUtil.INSTANCE.isFinite(it)) continue;
            destination$iv$iv.add(t);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv) {
            it = (Double)t;
            Collection collection = destination$iv$iv;
            bl = false;
            Double d = it;
            Intrinsics.checkNotNull((Object)d);
            collection.add(Double.valueOf(d));
        }
        List sortedX = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
        BinsData binsData = new BinsData(CollectionsKt.emptyList(), CollectionsKt.emptyList(), CollectionsKt.emptyList(), CollectionsKt.emptyList());
        if (sortedX.isEmpty()) {
            return binsData;
        }
        $this$mapTo$iv$iv = new Double[]{CollectionsKt.first((List)sortedX)};
        List stack2 = CollectionsKt.mutableListOf((Object[])$this$mapTo$iv$iv);
        int n = sortedX.size();
        for (int i = 1; i < n; ++i) {
            if (((Number)sortedX.get(i)).doubleValue() - ((Number)CollectionsKt.first((List)stack2)).doubleValue() < binWidth) {
                stack2.add(sortedX.get(i));
                continue;
            }
            binsData = BinStatUtil.computeDotdensityBins$updateBinsData(binWidth, binsData, stack2, sortedX.size());
            Object[] objectArray = new Double[]{sortedX.get(i)};
            stack2 = CollectionsKt.mutableListOf((Object[])objectArray);
        }
        binsData = BinStatUtil.computeDotdensityBins$updateBinsData(binWidth, binsData, stack2, sortedX.size());
        return binsData;
    }

    private static final BinsData computeDotdensityBins$updateBinsData(double $binWidth, BinsData binsData, List<Double> stack2, int dataSize) {
        double v = (((Number)CollectionsKt.last(stack2)).doubleValue() - ((Number)CollectionsKt.first(stack2)).doubleValue()) / 2.0;
        return new BinsData(CollectionsKt.plus((Collection)binsData.getX$plot_base(), (Iterable)CollectionsKt.listOf((Object)(((Number)CollectionsKt.first(stack2)).doubleValue() + v))), CollectionsKt.plus((Collection)binsData.getCount$plot_base(), (Iterable)CollectionsKt.listOf((Object)stack2.size())), CollectionsKt.plus((Collection)binsData.getDensity$plot_base(), (Iterable)CollectionsKt.listOf((Object)((double)stack2.size() / (double)dataSize))), CollectionsKt.plus((Collection)binsData.getBinWidth$plot_base(), (Iterable)CollectionsKt.listOf((Object)$binWidth)));
    }

    public static final /* synthetic */ double access$defaultBinWidthCalculator(BinStatUtil $this, double dataRange, int binCount) {
        return $this.defaultBinWidthCalculator(dataRange, binCount);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/BinStatUtil$BinOptions;", "", "binCount", "", "binWidth", "", "(ILjava/lang/Double;)V", "getBinCount", "()I", "getBinWidth", "()Ljava/lang/Double;", "Ljava/lang/Double;", "hasBinWidth", "", "plot-base"})
    public static final class BinOptions {
        @Nullable
        private final Double binWidth;
        private final int binCount;

        public BinOptions(int binCount, @Nullable Double binWidth) {
            this.binWidth = binWidth;
            this.binCount = Math.min(500, Math.max(1, binCount));
        }

        @Nullable
        public final Double getBinWidth() {
            return this.binWidth;
        }

        public final int getBinCount() {
            return this.binCount;
        }

        public final boolean hasBinWidth() {
            return this.binWidth != null && this.binWidth > 0.0;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\n\b\u0016\u0018\u00002\u00020\u0001B=\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\bR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/BinStatUtil$BinsData;", "", "x", "", "", "count", "density", "binWidth", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getBinWidth$plot_base", "()Ljava/util/List;", "getCount$plot_base", "getDensity$plot_base", "getX$plot_base", "plot-base"})
    public static class BinsData {
        @NotNull
        private final List<Double> x;
        @NotNull
        private final List<Double> count;
        @NotNull
        private final List<Double> density;
        @NotNull
        private final List<Double> binWidth;

        public BinsData(@NotNull List<Double> x2, @NotNull List<Double> count2, @NotNull List<Double> density2, @NotNull List<Double> binWidth) {
            Intrinsics.checkNotNullParameter(x2, (String)"x");
            Intrinsics.checkNotNullParameter(count2, (String)"count");
            Intrinsics.checkNotNullParameter(density2, (String)"density");
            Intrinsics.checkNotNullParameter(binWidth, (String)"binWidth");
            this.x = x2;
            this.count = count2;
            this.density = density2;
            this.binWidth = binWidth;
        }

        @NotNull
        public List<Double> getX$plot_base() {
            return this.x;
        }

        @NotNull
        public List<Double> getCount$plot_base() {
            return this.count;
        }

        @NotNull
        public List<Double> getDensity$plot_base() {
            return this.density;
        }

        @NotNull
        public List<Double> getBinWidth$plot_base() {
            return this.binWidth;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/BinStatUtil$CountAndWidth;", "", "count", "", "width", "", "(ID)V", "getCount", "()I", "getWidth", "()D", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "plot-base"})
    public static final class CountAndWidth {
        private final int count;
        private final double width;

        public CountAndWidth(int count2, double width2) {
            this.count = count2;
            this.width = width2;
        }

        public final int getCount() {
            return this.count;
        }

        public final double getWidth() {
            return this.width;
        }

        public final int component1() {
            return this.count;
        }

        public final double component2() {
            return this.width;
        }

        @NotNull
        public final CountAndWidth copy(int count2, double width2) {
            return new CountAndWidth(count2, width2);
        }

        public static /* synthetic */ CountAndWidth copy$default(CountAndWidth countAndWidth, int n, double d, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = countAndWidth.count;
            }
            if ((n2 & 2) != 0) {
                d = countAndWidth.width;
            }
            return countAndWidth.copy(n, d);
        }

        @NotNull
        public String toString() {
            return "CountAndWidth(count=" + this.count + ", width=" + this.width + ')';
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.count);
            result2 = result2 * 31 + Double.hashCode(this.width);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CountAndWidth)) {
                return false;
            }
            CountAndWidth countAndWidth = (CountAndWidth)other;
            if (this.count != countAndWidth.count) {
                return false;
            }
            return Double.compare(this.width, countAndWidth.width) == 0;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u000e\u0018\u00002\u00020\u0001BY\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\nR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\f\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/BinStatUtil$HistBinsData;", "Lorg/jetbrains/letsPlot/core/plot/base/stat/BinStatUtil$BinsData;", "x", "", "", "count", "density", "sumProp", "sumPct", "binWidth", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getBinWidth$plot_base", "()Ljava/util/List;", "getCount$plot_base", "getDensity$plot_base", "getSumPct$plot_base", "getSumProp$plot_base", "getX$plot_base", "plot-base"})
    public static final class HistBinsData
    extends BinsData {
        @NotNull
        private final List<Double> x;
        @NotNull
        private final List<Double> count;
        @NotNull
        private final List<Double> density;
        @NotNull
        private final List<Double> sumProp;
        @NotNull
        private final List<Double> sumPct;
        @NotNull
        private final List<Double> binWidth;

        public HistBinsData(@NotNull List<Double> x2, @NotNull List<Double> count2, @NotNull List<Double> density2, @NotNull List<Double> sumProp, @NotNull List<Double> sumPct, @NotNull List<Double> binWidth) {
            Intrinsics.checkNotNullParameter(x2, (String)"x");
            Intrinsics.checkNotNullParameter(count2, (String)"count");
            Intrinsics.checkNotNullParameter(density2, (String)"density");
            Intrinsics.checkNotNullParameter(sumProp, (String)"sumProp");
            Intrinsics.checkNotNullParameter(sumPct, (String)"sumPct");
            Intrinsics.checkNotNullParameter(binWidth, (String)"binWidth");
            super(x2, count2, density2, binWidth);
            this.x = x2;
            this.count = count2;
            this.density = density2;
            this.sumProp = sumProp;
            this.sumPct = sumPct;
            this.binWidth = binWidth;
        }

        @Override
        @NotNull
        public List<Double> getX$plot_base() {
            return this.x;
        }

        @Override
        @NotNull
        public List<Double> getCount$plot_base() {
            return this.count;
        }

        @Override
        @NotNull
        public List<Double> getDensity$plot_base() {
            return this.density;
        }

        @NotNull
        public final List<Double> getSumProp$plot_base() {
            return this.sumProp;
        }

        @NotNull
        public final List<Double> getSumPct$plot_base() {
            return this.sumPct;
        }

        @Override
        @NotNull
        public List<Double> getBinWidth$plot_base() {
            return this.binWidth;
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BinStat.XPosKind.values().length];
            try {
                nArray[BinStat.XPosKind.CENTER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

