/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.actionscript.psi.ActionScriptPsiImplUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.ecmascript6.TypeScriptQualifiedItemProcessor;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.flex.ActionScriptPsiExtensions;
import com.intellij.lang.javascript.flex.FlexSupportLoader;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptClassImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.generic.JSTypeSubstitutorImpl;
import com.intellij.lang.javascript.psi.types.JSAliasTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.lang.javascript.validation.fixes.MarkerPsiElementPointer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseCreateMembersFix<T extends JSElement> {
    private final Set<T> elementsToProcess = new LinkedHashSet<T>();
    @Nullable
    protected final PsiElement myJsClass;
    protected PsiElement anchor;

    public BaseCreateMembersFix(@Nullable PsiElement jsClass) {
        this.myJsClass = jsClass;
    }

    public void beforeInvoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            BaseCreateMembersFix.$$$reportNull$$$0(0);
        }
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        if (project == null) {
            BaseCreateMembersFix.$$$reportNull$$$0(1);
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(psiFile)) {
            return;
        }
        this.evalAnchor(editor, psiFile);
        MultiMap types2 = MultiMap.createSet();
        Set<T> elementsToProcess = this.getElementsToProcess();
        for (JSElement element2 : elementsToProcess) {
            this.fixName(element2);
        }
        for (JSElement e : elementsToProcess) {
            for (String type2 : this.getTypes(e)) {
                String resolved = JSImportHandlingUtil.resolveTypeName((String)type2, (PsiElement)e);
                if (type2.indexOf(46) == -1 && resolved.equals(type2)) continue;
                types2.putValue((Object)JSResolveUtil.getShortTypeName((String)type2, (boolean)false), (Object)resolved);
            }
        }
        this.processElements(project, (MultiMap<String, String>)types2, elementsToProcess);
    }

    protected void processElements(Project project, MultiMap<String, String> types2, Set<T> elementsToProcess) {
        ArrayList<MarkerPsiElementPointer> elementPointers = new ArrayList<MarkerPsiElementPointer>();
        for (JSElement element2 : elementsToProcess) {
            elementPointers.add(new MarkerPsiElementPointer((PsiElement)element2));
        }
        elementsToProcess.clear();
        for (MarkerPsiElementPointer e : elementPointers) {
            JSElement element3 = (JSElement)e.getElement();
            this.anchor = this.doAddOneMethod(project, this.buildFunctionText(element3, types2), this.anchor);
            elementsToProcess.add(element3);
        }
    }

    protected void fixName(T t) {
    }

    protected void evalAnchor(@Nullable Editor editor, PsiFile file) {
        PsiElement parent;
        this.anchor = null;
        if (editor == null) {
            return;
        }
        if (file instanceof XmlFile && this.myJsClass instanceof XmlBackedJSClassImpl) {
            PsiElement element2;
            file = ((XmlBackedJSClassImpl)this.myJsClass).createOrGetFirstScriptTag();
            editor = InjectedLanguageUtil.getInjectedEditorForInjectedFile((Editor)editor, (PsiFile)file);
            PsiElement lastChild = file.getLastChild();
            PsiElement psiElement = element2 = lastChild == null ? null : lastChild.getPrevSibling();
            if (element2 != null) {
                this.anchor = element2;
                return;
            }
        }
        PsiElement at = file.findElementAt(editor.getCaretModel().getOffset());
        if (this.myJsClass instanceof JSClass && at != null && at == ((JSClass)this.myJsClass).getNameIdentifier()) {
            PsiElement[] classMembers = ((StubBasedPsiElementBase)this.myJsClass).getStubOrPsiChildren(TypeScriptClassImpl.MEMBERS, JSElement.ARRAY_FACTORY);
            if (classMembers.length > 0) {
                this.anchor = classMembers[classMembers.length - 1];
            }
            if (this.anchor == null) {
                this.anchor = this.myJsClass.getNode().findChildByType(JSTokenTypes.LBRACE).getPsi();
            }
        }
        PsiElement psiElement = parent = at != null ? at.getParent() : null;
        if (at != null && (parent == this.myJsClass || parent instanceof JSFile && this.myJsClass != null && this.myJsClass.getParent() != null && parent.getContext() != null && this.myJsClass.getParent().getContainingFile() == parent.getContext().getContainingFile())) {
            ASTNode atNode = at.getNode();
            if (atNode.getElementType() == JSTokenTypes.RBRACE) {
                return;
            }
            for (ASTNode node = atNode; node != null; node = node.getTreeNext()) {
                if (node.getElementType() != JSTokenTypes.LBRACE) continue;
                return;
            }
            this.anchor = at;
        }
    }

    public PsiElement doAddOneMethod(Project project, String functionText, PsiElement anchor) throws IncorrectOperationException {
        assert (this.myJsClass != null);
        return BaseCreateMembersFix.addOneMethodToClass(this.myJsClass, project, functionText, anchor);
    }

    @Nullable
    public static PsiElement addOneMethodToClass(@NotNull PsiElement clazz, Project project, @Nullable String functionText, @Nullable PsiElement anchor) throws IncorrectOperationException {
        if (clazz == null) {
            BaseCreateMembersFix.$$$reportNull$$$0(2);
        }
        if (functionText != null && !functionText.isEmpty()) {
            JSLanguageDialect dialect = DialectDetector.languageDialectOfElement((PsiElement)clazz);
            PsiElement element2 = JSChangeUtil.createClassMemberFromText((Project)project, (String)functionText, (JSLanguageDialect)dialect).getPsi();
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
            if (element2 instanceof PsiWhiteSpace) {
                element2 = element2.getNextSibling();
            }
            if (anchor != null && anchor.isValid() && (!(anchor instanceof PsiWhiteSpace) || !FlexSupportLoader.ECMA_SCRIPT_L4.is((Language)dialect) || BaseCreateMembersFix.isNotSurroundedCDATA(anchor))) {
                PsiElement newAnchor = anchor.getParent().addAfter(element2, anchor);
                codeStyleManager.reformatNewlyAddedElement(newAnchor.getParent().getNode(), newAnchor.getNode());
                return newAnchor;
            }
            anchor = BaseCreateMembersFix.addMethodToClassWithoutAnchor(clazz, dialect, element2, codeStyleManager);
        }
        return anchor;
    }

    public static PsiElement addMethodToClassWithoutAnchor(@NotNull PsiElement jsClass, @Nullable JSLanguageDialect dialect, @NotNull PsiElement element2, @Nullable CodeStyleManager codeStyleManager) {
        PsiElement anchor;
        if (jsClass == null) {
            BaseCreateMembersFix.$$$reportNull$$$0(3);
        }
        if (element2 == null) {
            BaseCreateMembersFix.$$$reportNull$$$0(4);
        }
        if (!FlexSupportLoader.ECMA_SCRIPT_L4.is((Language)dialect)) {
            ASTNode possibleAnchor = jsClass.getNode().findChildByType(JSTokenTypes.LBRACE);
            assert (possibleAnchor != null);
            anchor = jsClass.addAfter(element2, possibleAnchor.getPsi());
            if (codeStyleManager != null) {
                PsiElement parent = anchor.getParent();
                codeStyleManager.reformatNewlyAddedElement(parent.getNode(), anchor.getNode());
            }
        } else {
            anchor = jsClass.add(element2);
        }
        return anchor;
    }

    private static boolean isNotSurroundedCDATA(PsiElement anchor) {
        String anchorText = anchor.getText();
        return !anchorText.contains("<![CDATA[") && !anchorText.contains("]]>");
    }

    private Collection<String> getTypes(T fun) {
        if (fun instanceof JSFunction) {
            return BaseCreateMembersFix.getFunctionTypes((JSFunction)fun);
        }
        if (fun instanceof JSVariable) {
            ArrayList<String> result2 = new ArrayList<String>();
            JSType type2 = ((JSVariable)fun).getJSType();
            if (type2 != null) {
                result2.add(type2.getTypeText(JSType.TypeTextFormat.CODE));
            }
            return result2;
        }
        return Collections.emptyList();
    }

    public static Collection<String> getFunctionTypes(JSFunction function) {
        ArrayList<String> result2 = new ArrayList<String>();
        if (function.getReturnType() != null) {
            result2.add(function.getReturnType().getTypeText(JSType.TypeTextFormat.CODE));
        }
        for (JSParameterListElement param : function.getParameterList().getParameters()) {
            JSType type2 = param.getJSType();
            if (type2 == null) continue;
            result2.add(type2.getTypeText(JSType.TypeTextFormat.CODE));
        }
        return result2;
    }

    public String buildFunctionText(T fun, @Nullable MultiMap<String, String> types2) {
        assert (this.myJsClass != null);
        String attrText = this.getAttributeListText(fun, types2);
        String typeString = null;
        JSParameterList parameterList = null;
        JSType type2 = null;
        if (fun instanceof JSVariable || fun instanceof JSFunction) {
            JSFunction function = fun instanceof JSFunction ? (JSFunction)fun : null;
            JSVariable var = fun instanceof JSVariable ? (JSVariable)fun : null;
            parameterList = function != null ? function.getParameterList() : null;
            JSType jSType = type2 = function != null ? function.getReturnType() : var.getJSType();
        }
        if (type2 != null) {
            typeString = this.getTypeString(type2, fun, types2);
        } else if (this.shouldHandleNoTypeAsAnyType()) {
            typeString = JSClassUtils.getAnyTypeString((PsiElement)this.myJsClass, (boolean)false);
        }
        Object functionText = attrText;
        if (!((String)functionText).isEmpty()) {
            functionText = (String)functionText + " ";
        }
        functionText = (String)functionText + JSClassUtils.createClassFunctionName((String)(this.buildFunctionKind(fun) + this.buildName(fun)), (PsiElement)this.myJsClass);
        functionText = (String)functionText + this.buildParameterList(parameterList, fun, types2);
        String string = typeString = typeString != null ? this.buildReturnType(typeString) : null;
        if (typeString != null && this.useReturnType(fun, type2)) {
            functionText = (String)functionText + ":" + typeString;
        }
        functionText = (String)functionText + this.buildFunctionBodyText(typeString, parameterList, fun);
        return functionText;
    }

    protected boolean useReturnType(@NotNull T fun, @Nullable JSType type2) {
        if (fun == null) {
            BaseCreateMembersFix.$$$reportNull$$$0(5);
        }
        if (!(type2 instanceof JSVoidType)) {
            return true;
        }
        return type2.isEcma() || JSCodeStyleSettings.getSettings(fun).PREFER_EXPLICIT_TYPES_FUNCTION_RETURNS;
    }

    protected String getAttributeListText(T fun, @Nullable MultiMap<String, String> types2) {
        assert (this.myJsClass != null);
        Object attrText = "";
        if (fun instanceof JSAttributeListOwner) {
            String namespace;
            JSAttributeList attributeList = ((JSAttributeListOwner)fun).getAttributeList();
            JSAttributeListWrapper attributeListWrapper = new JSAttributeListWrapper(attributeList);
            String string = namespace = attributeList != null ? ActionScriptPsiImplUtil.getNamespaceValue((JSAttributeList)attributeList) : null;
            if (namespace != null) {
                String namespaceId = ActionScriptPsiExtensions.getInstance().calcNamespaceId(attributeList, namespace, this.anchor != null ? this.anchor : this.myJsClass);
                namespaceId = this.importType(namespaceId, fun, types2);
                attributeListWrapper.overrideNamespace(namespaceId);
            }
            this.adjustAttributeList(attributeListWrapper, fun);
            attrText = attributeListWrapper.computeText((JSAttributeListOwner)fun, DialectDetector.dialectOfElement((PsiElement)this.myJsClass), true);
            if (fun instanceof JSFunction && ((JSFunction)fun).isGenerator()) {
                attrText = (String)attrText + " *";
            }
        }
        return attrText;
    }

    protected boolean shouldHandleNoTypeAsAnyType() {
        return false;
    }

    @NonNls
    protected String buildReturnType(String typeString) {
        return this.myJsClass != null && BaseCreateMembersFix.dialectSupportsTypes(this.myJsClass) ? typeString : null;
    }

    @Nullable
    protected String getTypeString(JSType type2, T fun, @Nullable MultiMap<String, String> types2) {
        if (type2 == null) {
            return null;
        }
        if (this.myJsClass == null || !BaseCreateMembersFix.dialectSupportsTypes(this.myJsClass)) {
            return null;
        }
        String typeString = null;
        if (DialectDetector.isActionScript((PsiElement)this.myJsClass)) {
            String resolvedTypeText = this.importType(type2.getTypeText(JSType.TypeTextFormat.CODE), fun, types2);
            if (!StringUtil.isEmpty((String)resolvedTypeText)) {
                typeString = resolvedTypeText;
            }
        } else {
            typeString = BaseCreateMembersFix.getProcessedType(type2, this.myJsClass, fun);
        }
        return typeString;
    }

    @Nullable
    public static String getProcessedType(@Nullable JSType type2, PsiElement surroundClass, PsiElement context2) {
        if (type2 == null || !BaseCreateMembersFix.dialectSupportsTypes(surroundClass)) {
            return null;
        }
        String stringType = (type2 = BaseCreateMembersFix.fixGenericsByOwner(type2, surroundClass, context2)).getTypeText(JSType.TypeTextFormat.CODE);
        if (TypeScriptUtil.hasAmbientExternalModuleInQName((String)stringType) && TypeScriptUtil.hasAmbientExternalModuleInQName((String)(stringType = type2.getTypeText()))) {
            return null;
        }
        return stringType;
    }

    @Contract(value="null, _, _ -> null")
    @Nullable
    public static JSType fixGenericsByOwner(@Nullable JSType type2, @Nullable PsiElement surroundClassOrLiteral, @Nullable PsiElement context2) {
        if (type2 == null) {
            return null;
        }
        if (surroundClassOrLiteral instanceof JSClass && JSTypeUtils.hasForeignGenericParameter((JSType)type2)) {
            type2 = TypeScriptUtil.applyGenericsToType((JSType)type2, (JSClass)((JSClass)surroundClassOrLiteral), (JSClass)(context2 instanceof JSClass ? (JSClass)context2 : JSResolveUtil.getClassOfContext((PsiElement)context2)));
        }
        if (surroundClassOrLiteral instanceof JSObjectLiteralExpression) {
            type2 = JSTypeUtils.applyGenericArguments((JSType)type2, (JSTypeSubstitutor)BaseCreateMembersFix.buildSubstitutorForLiteral((JSObjectLiteralExpression)surroundClassOrLiteral));
        }
        return type2;
    }

    @Nullable
    public static JSTypeSubstitutor buildSubstitutorForLiteral(@Nullable JSObjectLiteralExpression expression) {
        if (expression == null) {
            return null;
        }
        JSType expectedType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)expression);
        LinkedList substitutors = new LinkedList();
        JSTypeUtils.processExpandedType(t -> {
            JSType typeForDeclarations;
            JSType jSType = typeForDeclarations = (t = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive((JSType)t, (PsiElement)expression)) instanceof JSGenericTypeImpl ? ((JSGenericTypeImpl)t).getType() : t;
            if (!(typeForDeclarations instanceof JSResolvableType)) {
                if (typeForDeclarations instanceof JSAliasTypeImpl) {
                    t = ((JSAliasTypeImpl)typeForDeclarations).getAlias();
                    JSType jSType2 = typeForDeclarations = t instanceof JSGenericTypeImpl ? ((JSGenericTypeImpl)t).getType() : t;
                }
                if (!(typeForDeclarations instanceof JSResolvableType)) {
                    return true;
                }
            }
            Collection declarations = ((JSResolvableType)typeForDeclarations).resolveType().getDeclarationsOfType(JSClass.class);
            JSTypeSubstitutor substitutor = TypeScriptQualifiedItemProcessor.getTypeSubstitutor((JSType)t, (Collection)declarations);
            if (declarations.size() != 1) {
                substitutors.add(substitutor);
                return true;
            }
            TypeScriptUtil.JSClassHierarchyProcessor processor = (aClass, typeSubstitutor, fromImplements) -> substitutors.add(typeSubstitutor);
            JSClassUtils.processClassesInHierarchy((JSClass)((JSClass)declarations.iterator().next()), (boolean)true, (TypeScriptUtil.JSClassHierarchyProcessor)processor);
            for (JSTypeSubstitutor typeSubstitutor2 : substitutors) {
                if (substitutor == null) {
                    substitutor = typeSubstitutor2;
                    continue;
                }
                substitutor = JSTypeSubstitutorImpl.combine((JSTypeSubstitutor)substitutor, (JSTypeSubstitutor)typeSubstitutor2);
            }
            substitutors.add(substitutor);
            return true;
        }, (JSType)expectedType, (boolean)false, (boolean)true, (boolean)true);
        JSTypeSubstitutor substitutor = null;
        for (JSTypeSubstitutor typeSubstitutor : substitutors) {
            if (substitutor == null) {
                substitutor = typeSubstitutor;
                continue;
            }
            substitutor = JSTypeSubstitutorImpl.combine((JSTypeSubstitutor)substitutor, (JSTypeSubstitutor)typeSubstitutor);
        }
        return substitutor;
    }

    private static boolean dialectSupportsTypes(@NotNull PsiElement context2) {
        DialectOptionHolder holder;
        if (context2 == null) {
            BaseCreateMembersFix.$$$reportNull$$$0(6);
        }
        return (holder = DialectDetector.dialectOfElement((PsiElement)context2)) != null && holder.hasFeature(JSLanguageFeature.TYPES);
    }

    protected String importType(String s, T fun, @Nullable MultiMap<String, String> types2) {
        if (s == null) {
            return null;
        }
        if (fun instanceof JSFunction || fun instanceof JSVariable) {
            Collection fullNames;
            String resolvedTypeName = JSImportHandlingUtil.resolveTypeName((String)s, fun);
            if (StringUtil.isEmpty((String)resolvedTypeName)) {
                return s;
            }
            boolean allowShorten = types2 == null ? true : (fullNames = types2.get((Object)JSResolveUtil.getShortTypeName((String)s, (boolean)false))).isEmpty() || fullNames.size() == 1 && ((String)fullNames.iterator().next()).equals(resolvedTypeName);
            Pair<String, PsiElement> importResult = ImportUtils.importAndShortenReference(resolvedTypeName, this.anchor != null ? this.anchor : this.myJsClass, true, allowShorten);
            String result2 = (String)importResult.first;
            if (this.anchor != null) {
                this.anchor = (PsiElement)importResult.second;
            }
            return JSResolveUtil.getQualifiedTypeName((String)result2);
        }
        return s;
    }

    protected String buildParameterList(JSParameterList parameterList, T fun, MultiMap<String, String> types2) {
        if (!(fun instanceof JSFunction)) {
            return "";
        }
        if (parameterList != null) {
            boolean isTypeScriptFunction;
            StringBuilder signature = new StringBuilder();
            boolean isExpectedCodeTypeScript = this.myJsClass != null && DialectDetector.isTypeScript((PsiElement)this.myJsClass);
            boolean bl = isTypeScriptFunction = fun instanceof TypeScriptFunction && isExpectedCodeTypeScript;
            if (isTypeScriptFunction) {
                signature.append(TypeScriptUtil.buildParameterTypeListStringWithApplyingGenerics((TypeScriptFunction)((TypeScriptFunction)fun), (PsiElement)this.myJsClass));
            }
            signature.append('(');
            boolean firstParameter = true;
            for (JSParameterListElement param : parameterList.getParameters()) {
                JSExpression initializer;
                if (!firstParameter) {
                    signature.append(", ");
                }
                firstParameter = false;
                if (param.isRest()) {
                    signature.append("... ").append(param.getName());
                    continue;
                }
                JSType type2 = param.getJSType();
                String s = this.getTypeString(type2, fun, types2);
                signature.append(param.getName());
                if (isTypeScriptFunction && param.isOptional() && !param.hasInitializer()) {
                    signature.append("?");
                }
                if (!StringUtil.isEmpty((String)s)) {
                    signature.append(":").append(s);
                }
                if ((initializer = param.getInitializer()) == null) continue;
                signature.append(" = ").append(initializer.getText());
            }
            signature.append(")");
            return signature.toString();
        }
        return "()";
    }

    protected String buildName(T fun) {
        return fun instanceof JSNamedElementBase ? JSPsiImplUtils.getNameOrComputedPropertyName((JSNamedElementBase)((JSNamedElementBase)fun), (boolean)false) : null;
    }

    @NonNls
    protected String buildFunctionKind(T fun) {
        if (fun instanceof JSFunction) {
            JSFunction function = (JSFunction)fun;
            if (function.isGetProperty()) {
                return "get ";
            }
            if (function.isSetProperty()) {
                return "set ";
            }
        }
        return "";
    }

    @NonNls
    protected String buildFunctionBodyText(@NonNls String retType, JSParameterList parameterList, T func) {
        return " {}";
    }

    protected void adjustAttributeList(JSAttributeListWrapper attributeListWrapper, T function) {
        attributeListWrapper.overrideModifier(JSAttributeList.ModifierType.NATIVE, false);
        attributeListWrapper.overrideModifier(JSAttributeList.ModifierType.ABSTRACT, false);
    }

    public void addElementToProcess(T function) {
        this.elementsToProcess.add(function);
    }

    public Set<T> getElementsToProcess() {
        JSElement[] objects = this.elementsToProcess.toArray(JSElement.EMPTY_ARRAY);
        Comparator<JSElement> tComparator = Comparator.comparingInt(PsiElement::getTextOffset);
        int size = this.elementsToProcess.size();
        LinkedHashSet result2 = new LinkedHashSet(size);
        ArrayList<JSElement> objectsFromSameFile = new ArrayList<JSElement>();
        PsiFile containingFile = null;
        for (int i = 0; i < size; ++i) {
            JSElement object = objects[i];
            PsiFile currentContainingFile = object.getContainingFile();
            if (currentContainingFile != containingFile) {
                if (containingFile != null) {
                    objectsFromSameFile.sort(tComparator);
                    result2.addAll(objectsFromSameFile);
                    objectsFromSameFile.clear();
                }
                containingFile = currentContainingFile;
            }
            objectsFromSameFile.add(object);
        }
        objectsFromSameFile.sort(tComparator);
        result2.addAll(objectsFromSameFile);
        this.elementsToProcess.clear();
        this.elementsToProcess.addAll(result2);
        return this.elementsToProcess;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/BaseCreateMembersFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeInvoke";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addOneMethodToClass";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addMethodToClassWithoutAnchor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "useReturnType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "dialectSupportsTypes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

