/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch.dashboard;

import com.intellij.dvcs.branch.BranchType;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.git.branch.GitInOutCountersInProject;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.util.DataPackUtilKt;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitReference;
import git4idea.GitRemoteBranch;
import git4idea.GitTag;
import git4idea.branch.GitBranchIncomingOutgoingManager;
import git4idea.branch.GitRefType;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitRefUtil;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitBranchManager;
import git4idea.ui.branch.dashboard.BranchInfo;
import git4idea.ui.branch.dashboard.TagInfo;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\"\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\"\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00052\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ&\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J*\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J.\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0005H\u0002J\"\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000bH\u0002\u00a8\u0006%"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardUtil;", "", "<init>", "()V", "getLocalBranches", "", "Lgit4idea/ui/branch/dashboard/BranchInfo;", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "getRemoteBranches", "getTags", "Lgit4idea/ui/branch/dashboard/TagInfo;", "isFavoriteInAnyRepo", "", "repos", "gitBranchManager", "Lgit4idea/ui/branch/GitBranchManager;", "ref", "Lgit4idea/GitReference;", "checkIsMyBranchesSynchronously", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "branchesToCheck", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "findMyCommits", "", "isMyBranch", "branchName", "", "repo", "myCommits", "findExclusiveCommits", "Lit/unimi/dsi/fastutil/ints/IntSet;", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nBranchesDashboardUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BranchesDashboardUtil.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,142:1\n1869#2,2:143\n1761#2,3:150\n1869#2,2:154\n1869#2,2:162\n1761#2,3:168\n1761#2,3:172\n30#3,2:145\n30#3,2:156\n30#3,2:164\n126#4:147\n153#4,2:148\n155#4:153\n126#4:158\n153#4,3:159\n153#4,2:166\n155#4:171\n*S KotlinDebug\n*F\n+ 1 BranchesDashboardUtil.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardUtil\n*L\n27#1:143,2\n39#1:150,3\n50#1:154,2\n68#1:162,2\n75#1:168,3\n81#1:172,3\n36#1:145,2\n55#1:156,2\n73#1:164,2\n38#1:147\n38#1:148,2\n38#1:153\n56#1:158\n56#1:159,3\n74#1:166,2\n74#1:171\n*E\n"})
public final class BranchesDashboardUtil {
    @NotNull
    public static final BranchesDashboardUtil INSTANCE = new BranchesDashboardUtil();

    private BranchesDashboardUtil() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<BranchInfo> getLocalBranches(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        Map localMap = new LinkedHashMap();
        Iterable $this$forEach$iv = repositories;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GitRepository repo = (GitRepository)element$iv;
            boolean bl = false;
            for (GitLocalBranch branch : repo.getBranches().getLocalBranches()) {
                localMap.computeIfAbsent(branch, arg_0 -> BranchesDashboardUtil.getLocalBranches$lambda$0$1(BranchesDashboardUtil::getLocalBranches$lambda$0$0, arg_0)).add(repo);
            }
            GitLocalBranch currentBranch = repo.getCurrentBranch();
            if (currentBranch == null) continue;
            localMap.computeIfAbsent(currentBranch, arg_0 -> BranchesDashboardUtil.getLocalBranches$lambda$0$3(BranchesDashboardUtil::getLocalBranches$lambda$0$2, arg_0)).add(repo);
        }
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<GitBranchManager> serviceClass$iv = GitBranchManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        GitBranchManager gitBranchManager = (GitBranchManager)((Object)object);
        GitBranchIncomingOutgoingManager gitBranchIncomingOutgoingManager = GitBranchIncomingOutgoingManager.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)gitBranchIncomingOutgoingManager, (String)"getInstance(...)");
        GitBranchIncomingOutgoingManager incomingOutgoingManager = gitBranchIncomingOutgoingManager;
        Map $this$map$iv = localMap;
        boolean $i$f$map = false;
        Map bl = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            GitInOutCountersInProject gitInOutCountersInProject;
            boolean bl2;
            GitBranch gitBranch;
            Set repos;
            GitLocalBranch branch;
            Collection collection;
            block7: {
                void $this$any$iv;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                collection = destination$iv$iv;
                boolean bl3 = false;
                branch = (GitLocalBranch)((Object)entry.getKey());
                repos = (Set)entry.getValue();
                Iterable iterable = repos;
                gitBranch = (GitBranch)branch;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        GitRepository it = (GitRepository)element$iv;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual((Object)((Object)it.getCurrentBranch()), (Object)((Object)branch))) continue;
                        bl2 = true;
                        break block7;
                    }
                    bl2 = false;
                }
            }
            boolean bl5 = bl2;
            boolean bl6 = INSTANCE.isFavoriteInAnyRepo(repos, gitBranchManager, (GitReference)branch);
            Intrinsics.checkNotNullExpressionValue((Object)incomingOutgoingManager.getIncomingOutgoingState(repos, branch), (String)"getIncomingOutgoingState(...)");
            List list = CollectionsKt.toList((Iterable)repos);
            boolean bl7 = bl6;
            boolean bl8 = bl5;
            GitBranch gitBranch2 = gitBranch;
            collection.add(new BranchInfo(gitBranch2, bl8, bl7, gitInOutCountersInProject, list));
        }
        HashSet local = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
        return local;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<BranchInfo> getRemoteBranches(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        Map remoteMap = new LinkedHashMap();
        Iterable $this$forEach$iv = repositories;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GitRepository repo = (GitRepository)element$iv;
            boolean bl = false;
            for (GitRemoteBranch remoteBranch : repo.getBranches().getRemoteBranches()) {
                remoteMap.computeIfAbsent(remoteBranch, arg_0 -> BranchesDashboardUtil.getRemoteBranches$lambda$0$1(BranchesDashboardUtil::getRemoteBranches$lambda$0$0, arg_0)).add(repo);
            }
        }
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Object serviceClass$iv = GitBranchManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        GitBranchManager gitBranchManager = (GitBranchManager)((Object)object);
        Map $this$map$iv = remoteMap;
        boolean $i$f$map = false;
        serviceClass$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator<Object> iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = (Map.Entry)iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            GitBranch branch = (GitBranch)entry.getKey();
            List repos = (List)entry.getValue();
            collection.add(new BranchInfo(branch, false, INSTANCE.isFavoriteInAnyRepo(repos, gitBranchManager, (GitReference)branch), GitInOutCountersInProject.EMPTY, repos));
        }
        return CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<TagInfo> getTags(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories) {
        void destination$iv;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        if (!GitVcsSettings.getInstance((Project)project).showTags()) {
            return SetsKt.emptySet();
        }
        Map tags = new LinkedHashMap();
        Iterable $this$forEach$iv = repositories;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GitRepository repo = (GitRepository)element$iv;
            boolean bl = false;
            for (Map.Entry<GitTag, Hash> tag : repo.getTagHolder().getTags().entrySet()) {
                tags.computeIfAbsent(tag.getKey(), arg_0 -> BranchesDashboardUtil.getTags$lambda$0$1(BranchesDashboardUtil::getTags$lambda$0$0, arg_0)).add(repo);
            }
        }
        Object $this$service$iv = (ComponentManager)project;
        boolean $i$f$service22 = false;
        Class<GitBranchManager> serviceClass$iv = GitBranchManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        GitBranchManager gitBranchManager = (GitBranchManager)((Object)object);
        $this$service$iv = tags;
        Collection $i$f$service22 = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv : $this$mapTo$iv.entrySet()) {
            boolean bl;
            GitTag gitTag;
            List repos;
            GitTag tag;
            void var22_28;
            block8: {
                void $this$any$iv;
                Map.Entry entry = item$iv;
                var22_28 = destination$iv;
                boolean bl2 = false;
                tag = (GitTag)entry.getKey();
                repos = (List)entry.getValue();
                Iterable iterable = repos;
                gitTag = tag;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        GitRepository it = (GitRepository)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)GitRefUtil.getCurrentTag(it), (Object)tag)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            boolean bl4 = bl;
            List list = repos;
            boolean bl5 = INSTANCE.isFavoriteInAnyRepo(repos, gitBranchManager, (GitReference)tag);
            boolean bl6 = bl4;
            GitTag gitTag2 = gitTag;
            var22_28.add(new TagInfo(gitTag2, bl6, bl5, list));
        }
        return (Set)destination$iv;
    }

    private final boolean isFavoriteInAnyRepo(Collection<? extends GitRepository> repos, GitBranchManager gitBranchManager, GitReference ref) {
        boolean bl;
        block3: {
            GitRefType refType = GitRefType.Companion.of$default((GitRefType.Companion)GitRefType.Companion, (GitReference)ref, (boolean)false, (int)2, null);
            Iterable $this$any$iv = repos;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GitRepository it = (GitRepository)element$iv;
                    boolean bl2 = false;
                    if (!gitBranchManager.isFavorite((BranchType)refType, it, ref.getName())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final Set<BranchInfo> checkIsMyBranchesSynchronously(@NotNull VcsLogData logData, @NotNull Collection<BranchInfo> branchesToCheck, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
        Intrinsics.checkNotNullParameter(branchesToCheck, (String)"branchesToCheck");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Set<Integer> myCommits = this.findMyCommits(logData);
        if (myCommits.isEmpty()) {
            return SetsKt.emptySet();
        }
        indicator.setIndeterminate(false);
        HashSet<BranchInfo> myBranches = new HashSet<BranchInfo>();
        Iterator iterator = ((Iterable)branchesToCheck).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int step = n++;
            BranchInfo branch = (BranchInfo)iterator.next();
            indicator.setFraction((double)step / (double)branchesToCheck.size());
            for (GitRepository repo : branch.getRepositories()) {
                indicator.checkCanceled();
                if (!this.isMyBranch(logData, branch.getBranchName(), repo, myCommits)) continue;
                myBranches.add(branch);
            }
        }
        return myBranches;
    }

    private final Set<Integer> findMyCommits(VcsLogData logData) {
        VcsLogUserFilter filterByMe = VcsLogFilterObject.fromUserNames((Collection)CollectionsKt.listOf((Object)"*"), (VcsLogData)logData);
        IndexDataGetter indexDataGetter = logData.getIndex().getDataGetter();
        Intrinsics.checkNotNull((Object)indexDataGetter);
        IntSet intSet = indexDataGetter.filter(CollectionsKt.listOf((Object)filterByMe));
        Intrinsics.checkNotNullExpressionValue((Object)intSet, (String)"filter(...)");
        return (Set)intSet;
    }

    private final boolean isMyBranch(VcsLogData logData, String branchName, GitRepository repo, Set<Integer> myCommits) {
        IntSet intSet = this.findExclusiveCommits(logData, branchName, repo);
        if (intSet == null) {
            return false;
        }
        IntSet exclusiveCommits = intSet;
        if (exclusiveCommits.isEmpty()) {
            return false;
        }
        IntIterator intIterator = exclusiveCommits.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)intIterator, (String)"iterator(...)");
        IntIterator intIterator2 = intIterator;
        while (intIterator2.hasNext()) {
            Integer commit = intIterator2.next();
            if (myCommits.contains(commit)) continue;
            return false;
        }
        return true;
    }

    private final IntSet findExclusiveCommits(VcsLogData logData, String branchName, GitRepository repo) {
        DataPack dataPack = logData.getDataPack();
        VirtualFile virtualFile = repo.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
        VcsRef vcsRef = DataPackUtilKt.findBranch((DataPack)dataPack, (String)branchName, (VirtualFile)virtualFile);
        if (vcsRef == null) {
            return null;
        }
        VcsRef ref = vcsRef;
        if (!ref.getType().isBranch()) {
            return null;
        }
        RefsModel refsModel = dataPack.getRefsModel();
        Intrinsics.checkNotNullExpressionValue((Object)refsModel, (String)"getRefsModel(...)");
        return DataPackUtilKt.exclusiveCommits((DataPack)dataPack, (VcsRef)ref, (RefsModel)refsModel, (VcsLogStorage)logData.getStorage());
    }

    private static final Set getLocalBranches$lambda$0$0(GitLocalBranch it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return new HashSet();
    }

    private static final Set getLocalBranches$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }

    private static final Set getLocalBranches$lambda$0$2(GitLocalBranch it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return new HashSet();
    }

    private static final Set getLocalBranches$lambda$0$3(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }

    private static final List getRemoteBranches$lambda$0$0(GitBranch it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List getRemoteBranches$lambda$0$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final List getTags$lambda$0$0(GitTag it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List getTags$lambda$0$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }
}

