/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.data;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public enum V8EventType {
    Execute("V8.Execute", "execution", false, 0, false, false),
    External("V8.External", "external", false, 0, false, false),
    CompileFullCode("V8.CompileFullCode", "compile unopt", true, 0, false, true),
    RecompileSynchronous("V8.RecompileSynchronous", "recompile sync", true, 0, false, true),
    RecompileConcurrent("V8.RecompileConcurrent", "recompile async", false, 1, false, true),
    CompileEval("V8.CompileEval", "compile eval", true, 0, false, true),
    IcMiss("V8.IcMiss", "ic miss", false, 0, false, true),
    Parse("V8.Parse", "parse", true, 0, false, true),
    PreParse("V8.PreParse", "preparse", true, 0, false, true),
    ParseLazy("V8.ParseLazy", "lazy parse", true, 0, false, true),
    GCScavenger("V8.GCScavenger", "gc scavenge", true, 0, true, false),
    GCCompactor("V8.GCCompactor", "gc compaction", true, 0, true, false),
    GCContext("V8.GCContext", "gc context", true, 0, true, false);

    private static final Map<String, V8EventType> MAP_BY_CODE;
    private final String myCode;
    private final String myName;
    private final boolean myPause;
    private final int myThreadId;
    private final boolean myIsGc;
    private final boolean myIsEngine;

    private V8EventType(String code, String name, boolean pause, int threadId, boolean isGc, boolean isEngine) {
        this.myCode = code;
        this.myName = name;
        this.myPause = pause;
        this.myThreadId = threadId;
        this.myIsGc = isGc;
        this.myIsEngine = isEngine;
    }

    public String getCode() {
        return this.myCode;
    }

    public String getName() {
        return this.myName;
    }

    public boolean isPause() {
        return this.myPause;
    }

    public int getThreadId() {
        return this.myThreadId;
    }

    public boolean isGc() {
        return this.myIsGc;
    }

    public boolean isEngine() {
        return this.myIsEngine;
    }

    public static V8EventType getByCode(@NotNull String code) {
        if (code == null) {
            V8EventType.$$$reportNull$$$0(0);
        }
        return MAP_BY_CODE.get(code);
    }

    static {
        MAP_BY_CODE = new HashMap<String, V8EventType>();
        for (V8EventType type : V8EventType.values()) {
            MAP_BY_CODE.put(type.getCode(), type);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "code", "com/jetbrains/nodejs/run/profile/cpu/v8log/data/V8EventType", "getByCode"));
    }
}

