/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;

public class VAliasNode
extends Node {
    private String oldName;
    private String newName;

    public VAliasNode(SourcePosition position, String newName, String oldName) {
        super(position);
        this.oldName = oldName;
        this.newName = newName;
    }

    public boolean isSame(Node node) {
        if (!super.isSame(node)) {
            return false;
        }
        VAliasNode other = (VAliasNode)node;
        return this.getOldName().equals(other.getOldName()) && this.getNewName().equals(other.getNewName());
    }

    public NodeType getNodeType() {
        return NodeType.VALIASNODE;
    }

    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitVAliasNode(this);
    }

    public String getNewName() {
        return this.newName;
    }

    public String getOldName() {
        return this.oldName;
    }
}

