/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.backend.ed.annotation.attr;

import com.intellij.jpa.jpb.model.backend.ed.annotation.AnnotationHelper;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.AbstractDynamicAttributeAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.JpaAttributeAnnotation;
import com.intellij.jpa.jpb.model.core.backend.ed.annotation.AnnotationModel;
import com.intellij.jpa.jpb.model.core.backend.ed.annotation.AnnotationModelBuilder;
import com.intellij.jpa.jpb.model.core.backend.ed.annotation.ArrayParameter;
import com.intellij.jpa.jpb.model.core.backend.ed.annotation.BooleanParameter;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.LinkedHashMap;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class JoinColumnsAnnotation
extends AbstractDynamicAttributeAnnotation {
    public JoinColumnsAnnotation() {
        super(JpaAttributeAnnotation.JoinColumns);
    }

    public static AnnotationModel generateJoinColumnAnnotationModel(String name, String referencedColumnName, boolean isMandatory, Project project, Module module) {
        AnnotationModelBuilder modelBuilder = AnnotationModel.builder(JpaAttributeAnnotation.JoinColumn.getFqn(project, module)).add("name", name);
        if (StringUtil.isNotEmpty((String)referencedColumnName)) {
            modelBuilder = modelBuilder.add("referencedColumnName", referencedColumnName);
        }
        if (isMandatory) {
            modelBuilder.add("nullable", new BooleanParameter(false));
        }
        return modelBuilder.build();
    }

    @Override
    public boolean isInsert(@NotNull EntityAttribute attribute, @NotNull Entity entity) {
        if (attribute == null) {
            JoinColumnsAnnotation.$$$reportNull$$$0(0);
        }
        if (entity == null) {
            JoinColumnsAnnotation.$$$reportNull$$$0(1);
        }
        return AnnotationHelper.isEntity(attribute) && attribute.isCompKeyType() && !attribute.getJoinColumns().isEmpty() && (attribute.getCardinality() == EntityAttribute.Cardinality.MANY_TO_ONE || attribute.getCardinality() == EntityAttribute.Cardinality.ONE_TO_ONE && attribute.isOwner());
    }

    @Override
    public boolean isModify() {
        return false;
    }

    @Override
    public AnnotationModel generateModel(EntityAttribute attr, Entity entity, Project project) {
        LinkedHashMap<String, String> attrJoinColumns = attr.getJoinColumns();
        List joinColumns = StreamEx.of(attrJoinColumns.entrySet()).map(entry -> JoinColumnsAnnotation.generateJoinColumnAnnotationModel((String)entry.getKey(), (String)entry.getValue(), attr.isMandatory(), project, entity.getModule())).toList();
        return AnnotationModel.builder(this.getFqn(project, entity.getModule())).add("value", new ArrayParameter(joinColumns).multiline()).build();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "attribute";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "entity";
                break;
            }
        }
        objectArray[1] = "com/intellij/jpa/jpb/model/backend/ed/annotation/attr/JoinColumnsAnnotation";
        objectArray[2] = "isInsert";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

