/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.flex.JSResolveHelper;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGlobalModuleExportDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.lang.javascript.psi.resolve.JSResolveProcessorBase;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptResolveHelper
implements JSResolveHelper {
    @Override
    @Nullable
    public PsiElement findClassByQName(String link, Project project, String className, GlobalSearchScope scope) {
        return null;
    }

    @Override
    public boolean importClass(PsiScopeProcessor processor, PsiNamedElement file) {
        return true;
    }

    @Override
    public boolean processPackage(String packageQualifierText, String resolvedName, Processor<? super VirtualFile> processor, GlobalSearchScope globalSearchScope, Project project) {
        return true;
    }

    @Override
    public boolean isAdequatePlaceForImport(PsiElement place) {
        return false;
    }

    @Override
    public long getResolveResultTimestamp(PsiElement candidate) {
        return -1L;
    }

    @Override
    public JSReferenceExpression bindReferenceToElement(JSReferenceExpression ref, String name, String newName, boolean justMakeQualified, PsiNamedElement element) {
        if (DialectDetector.isTypeScript((PsiElement)element) && justMakeQualified && name != null && name.contains(".")) {
            ASTNode newChild = JSChangeUtil.createExpressionFromText(ref.getProject(), name);
            ref.getParent().getNode().replaceChild(ref.getNode(), newChild);
            ref = (JSReferenceExpression)newChild.getPsi();
        }
        return ref;
    }

    @Override
    public boolean isStrictTypeContext(PsiElement element) {
        return true;
    }

    public static boolean processGlobalThings(JSResolveProcessorBase processor, ResolveState state, @NotNull PsiElement place) {
        if (place == null) {
            TypeScriptResolveHelper.$$$reportNull$$$0(0);
        }
        boolean result = true;
        String resolvedName = processor.getName();
        Project project = place.getProject();
        if (resolvedName == null) {
            PsiFile placeOriginalFile = place.getContainingFile().getOriginalFile();
            TypeScriptConfig config = DialectDetector.isTypeScript(place) ? TypeScriptConfigUtil.getConfigForPsiFile(place.getContainingFile()) : null;
            boolean isModulePlace = config != null && config.isolatedModules() || ES6PsiUtil.findExternalModule(place) != null;
            Collection<JSElement> elements = TypeScriptClassResolver.getInstance().findAllGlobalElements(project, place);
            for (JSElement element : elements) {
                PsiElement scopeElement;
                if (!(element instanceof JSQualifiedNamedElement) && !(element instanceof ES6ImportExportSpecifier) || element instanceof TypeScriptGlobalModuleExportDeclaration && isModulePlace || (!((scopeElement = JSUseScopeProvider.getLexicalScopeOrFile((PsiElement)element)) instanceof PsiFile) || placeOriginalFile.equals((Object)scopeElement)) && !TypeScriptResolveHelper.isGlobalModuleAugmentation(scopeElement) || processor.execute((PsiElement)element, state)) continue;
                return false;
            }
        } else {
            Collection<JSQualifiedNamedElement> qualifiedElements = TypeScriptClassResolver.getInstance().findGlobalElementsByQName(resolvedName, place);
            for (JSQualifiedNamedElement element : qualifiedElements) {
                if (!element.isNamespaceExplicitlyDeclared()) continue;
                result &= processor.execute((PsiElement)element, state);
            }
            Collection<JSPsiNamedElementBase> exportedElements = TypeScriptClassResolver.getInstance().findGlobalExportedElementsByQName(resolvedName, place);
            for (JSPsiNamedElementBase element : exportedElements) {
                result &= processor.execute((PsiElement)element, state);
            }
        }
        return result;
    }

    public static boolean isGlobalModuleAugmentation(@Nullable PsiElement scopeElement) {
        return scopeElement instanceof TypeScriptModule && ((TypeScriptModule)scopeElement).isGlobalScopeAugmentation();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/typescript/TypeScriptResolveHelper", "processGlobalThings"));
    }
}

