/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.profiles;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringManager;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.spring.profiles.ChangeActiveProfileDialogUi;
import com.intellij.spring.profiles.SpringProfileCompletionProvider;
import com.intellij.spring.profiles.SpringProfilesService;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ChangeActiveProfileDialog
extends DialogWrapper {
    private final Project myProject;
    private final Module myModule;
    private final SpringFileSet myFileSet;
    private final SpringProfileCompletionProvider myCompletionProvider;
    private final ChangeActiveProfileDialogUi myUi;
    private String myActiveProfiles;
    private final Map<ActiveProfileScope, String> myScopeActiveProfiles;

    ChangeActiveProfileDialog(@NotNull Project project, @Nullable Module module, @Nullable SpringFileSet fileSet, boolean includeTests) {
        if (project == null) {
            ChangeActiveProfileDialog.$$$reportNull$$$0(0);
        }
        super(project);
        this.myActiveProfiles = "";
        this.myProject = project;
        this.myModule = module;
        this.myFileSet = fileSet;
        this.myCompletionProvider = new SpringProfileCompletionProvider(includeTests);
        final TextFieldWithAutoCompletion profilesField = new TextFieldWithAutoCompletion(this.myProject, (TextFieldWithAutoCompletionListProvider)this.myCompletionProvider, true, "aaaaa");
        profilesField.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                ChangeActiveProfileDialog.this.setOKActionEnabled(!ChangeActiveProfileDialog.this.myActiveProfiles.equals(profilesField.getText()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/spring/profiles/ChangeActiveProfileDialog$1", "documentChanged"));
            }
        });
        profilesField.setPreferredWidth(JBUI.scale((int)210));
        this.myUi = new ChangeActiveProfileDialogUi((TextFieldWithAutoCompletion<String>)profilesField);
        this.myScopeActiveProfiles = FactoryMap.create(scope -> {
            Set activeProfiles;
            switch (scope.ordinal()) {
                case 2: {
                    assert (this.myFileSet != null);
                    activeProfiles = this.myFileSet.getActiveProfiles();
                    break;
                }
                case 1: {
                    assert (this.myModule != null);
                    activeProfiles = SpringManager.getInstance((Project)this.myProject).getCombinedModel(this.myModule).getActiveProfiles();
                    break;
                }
                case 0: {
                    activeProfiles = new LinkedHashSet();
                    for (Module each : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                        Set profiles = SpringManager.getInstance((Project)this.myProject).getCombinedModel(each).getActiveProfiles();
                        if (profiles == null) continue;
                        activeProfiles.addAll(profiles);
                    }
                    break;
                }
                default: {
                    activeProfiles = null;
                }
            }
            return SpringProfileUtils.profilesAsString(activeProfiles);
        });
        this.setTitle(SpringBundle.message("change.active.profile.dialog.spring.profiles", new Object[0]));
        this.setOKButtonText(CommonBundle.getApplyButtonText());
        this.setOKActionEnabled(false);
        this.initScopeSelection();
        this.updateActiveProfiles();
        this.init();
        this.pack();
    }

    protected void doOKAction() {
        Set activeProfiles = SpringProfileUtils.profilesFromString((String)this.myUi.getProfilesText().getText());
        switch (this.getSelectedScope().ordinal()) {
            case 2: {
                this.myFileSet.setActiveProfiles(activeProfiles);
                break;
            }
            case 1: {
                ChangeActiveProfileDialog.setActiveProfilesForModule(this.myModule, activeProfiles);
                break;
            }
            case 0: {
                for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                    ChangeActiveProfileDialog.setActiveProfilesForModule(module, activeProfiles);
                }
                break;
            }
        }
        super.doOKAction();
    }

    private static void setActiveProfilesForModule(@NotNull Module module, @NotNull Set<String> activeProfiles) {
        SpringFacet springFacet;
        Set sets;
        if (module == null) {
            ChangeActiveProfileDialog.$$$reportNull$$$0(1);
        }
        if (activeProfiles == null) {
            ChangeActiveProfileDialog.$$$reportNull$$$0(2);
        }
        Set set = sets = (springFacet = SpringFacet.getInstance((Module)module)) == null ? Collections.emptySet() : SpringFileSetService.getInstance().getAllSets(springFacet);
        if (sets.isEmpty()) {
            SpringProfilesService.getInstance((Project)module.getProject()).setActiveProfiles(module, activeProfiles);
        } else {
            for (SpringFileSet fileSet : sets) {
                fileSet.setActiveProfiles(activeProfiles);
            }
        }
    }

    @Nullable
    protected String getHelpId() {
        return "change.active.spring.profiles";
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myUi.getMainPanel();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myUi.getProfilesText();
    }

    private void initScopeSelection() {
        ActionListener updateProfilesListListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChangeActiveProfileDialog.this.updateActiveProfiles();
            }
        };
        this.myUi.getProjectRadioButton().addActionListener(updateProfilesListListener);
        if (this.myModule == null) {
            this.myUi.getProjectRadioButton().setSelected(true);
            this.myUi.getModuleRadioButton().setEnabled(false);
            this.myUi.getContextRadioButton().setEnabled(false);
            return;
        }
        this.myUi.getModuleRadioButton().setEnabled(true);
        this.myUi.getModuleRadioButton().addActionListener(updateProfilesListListener);
        this.myUi.getModuleRadioButton().setText(SpringBundle.message("change.active.profile.dialog.module", this.myModule.getName()));
        if (this.myFileSet == null) {
            this.myUi.getModuleRadioButton().setSelected(true);
            this.myUi.getContextRadioButton().setEnabled(false);
            return;
        }
        this.myUi.getContextRadioButton().setEnabled(true);
        this.myUi.getContextRadioButton().addActionListener(updateProfilesListListener);
        this.myUi.getContextRadioButton().setText(SpringBundle.message("change.active.profile.dialog.context", this.myFileSet.getName()));
        this.myUi.getContextRadioButton().setSelected(true);
    }

    private ActiveProfileScope getSelectedScope() {
        if (this.myFileSet != null && this.myUi.getContextRadioButton().isSelected()) {
            return ActiveProfileScope.CONTEXT;
        }
        if (this.myModule != null && this.myUi.getModuleRadioButton().isSelected()) {
            return ActiveProfileScope.MODULE;
        }
        return ActiveProfileScope.PROJECT;
    }

    private void updateActiveProfiles() {
        ActiveProfileScope scope = this.getSelectedScope();
        if (scope == ActiveProfileScope.PROJECT) {
            SmartList modules = new SmartList((Object[])ModuleManager.getInstance((Project)this.myProject).getModules());
            this.myCompletionProvider.setContext((Collection)modules);
        } else {
            this.myCompletionProvider.setContext((Collection)(this.myModule != null ? new SmartList((Object)this.myModule) : Collections.emptyList()));
        }
        TextFieldWithAutoCompletion<String> profilesText = this.myUi.getProfilesText();
        if (this.myScopeActiveProfiles.containsKey((Object)scope)) {
            this.myActiveProfiles = this.myScopeActiveProfiles.get((Object)scope);
            profilesText.setText(this.myActiveProfiles);
            return;
        }
        profilesText.setText("");
        this.myUi.getLoadingLabel().setVisible(true);
        ReadAction.nonBlocking(() -> this.myScopeActiveProfiles.get((Object)scope)).coalesceBy(new Object[]{this}).expireWith(this.myDisposable).finishOnUiThread(ModalityState.stateForComponent((Component)this.getRootPane()), profiles -> {
            this.myActiveProfiles = profiles;
            this.myUi.getLoadingLabel().setVisible(false);
            if (profilesText.getText().isEmpty()) {
                profilesText.setText(this.myActiveProfiles);
            }
            this.setOKActionEnabled(!this.myActiveProfiles.equals(profilesText.getText()));
        }).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfiles";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/profiles/ChangeActiveProfileDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setActiveProfilesForModule";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum ActiveProfileScope {
        PROJECT,
        MODULE,
        CONTEXT;

    }
}

