/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.maven.shared.run;

import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.maven.shared.run.SpringBootMavenRemoteConnectionCreatorKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenApplicationConfigurationExecutionEnvironmentProvider;
import org.jetbrains.idea.maven.execution.MavenRemoteConnectionCreator;
import org.jetbrains.idea.maven.execution.MavenRunConfiguration;
import org.jetbrains.idea.maven.execution.run.MavenRemoteConnectionWrapper;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001(B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J\u0018\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0012H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0002J*\u0010!\u001a\u00020\"2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001a2\b\u0010$\u001a\u0004\u0018\u00010%H\u0002J\u0010\u0010&\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u001dH\u0002J\u0010\u0010'\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u001dH\u0002\u00a8\u0006)"}, d2={"Lcom/intellij/spring/boot/maven/shared/run/SpringBootMavenRemoteConnectionCreator;", "Lorg/jetbrains/idea/maven/execution/MavenRemoteConnectionCreator;", "<init>", "()V", "createRemoteConnectionForScript", "Lorg/jetbrains/idea/maven/execution/run/MavenRemoteConnectionWrapper;", "runConfiguration", "Lorg/jetbrains/idea/maven/execution/MavenRunConfiguration;", "createRemoteConnection", "Lcom/intellij/execution/configurations/RemoteConnection;", "javaParameters", "Lcom/intellij/execution/configurations/JavaParameters;", "getConnectionParameters", "Lcom/intellij/spring/boot/maven/shared/run/SpringBootMavenRemoteConnectionCreator$RemoteConnectionParams;", "doCreateRemoteConnection", "setProgramParamList", "", "argsPrefix", "", "programParametersList", "Lcom/intellij/execution/configurations/ParametersList;", "argsCommandLineArg", "createArgsForSpringBoot", "parameters", "argsStr", "findMavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "configuration", "findModule", "Lcom/intellij/openapi/module/Module;", "mavenProject", "project", "Lcom/intellij/openapi/project/Project;", "fork", "", "module", "mavenPlugin", "Lorg/jetbrains/idea/maven/model/MavenPlugin;", "getForkPropertyName", "getJvmArgsPropertyName", "RemoteConnectionParams", "intellij.spring.boot.maven.shared"})
@SourceDebugExtension(value={"SMAP\nSpringBootMavenRemoteConnectionCreator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringBootMavenRemoteConnectionCreator.kt\ncom/intellij/spring/boot/maven/shared/run/SpringBootMavenRemoteConnectionCreator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,201:1\n2746#2,3:202\n2746#2,3:205\n360#2,7:208\n360#2,7:216\n1#3:215\n*S KotlinDebug\n*F\n+ 1 SpringBootMavenRemoteConnectionCreator.kt\ncom/intellij/spring/boot/maven/shared/run/SpringBootMavenRemoteConnectionCreator\n*L\n27#1:202,3\n42#1:205,3\n117#1:208,7\n74#1:216,7\n*E\n"})
public final class SpringBootMavenRemoteConnectionCreator
extends MavenRemoteConnectionCreator {
    @Nullable
    public MavenRemoteConnectionWrapper createRemoteConnectionForScript(@NotNull MavenRunConfiguration runConfiguration) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
            List programParametersList = runConfiguration.getRunnerParameters().getGoals();
            Intrinsics.checkNotNull((Object)programParametersList);
            Iterable $this$none$iv = programParametersList;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!(SpringBootMavenRemoteConnectionCreatorKt.access$getSPRING_BOOT_GOALS$p().contains(it) || SpringBootMavenRemoteConnectionCreatorKt.access$getSPRING_BOOT_MAVEN_PLUGIN_PATTERN$p().matcher(it).matches())) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        if (bl) {
            return null;
        }
        JavaParameters parameters = new JavaParameters();
        RemoteConnectionParams remoteConnectionParams = this.getConnectionParameters(parameters, runConfiguration);
        if (remoteConnectionParams == null) {
            return null;
        }
        RemoteConnectionParams params = remoteConnectionParams;
        Project project = runConfiguration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RemoteConnection connection = this.createConnection(project, parameters);
        ParametersList args = this.createArgsForSpringBoot(parameters, params.getArgsString());
        return new MavenRemoteConnectionWrapper(connection, arg_0 -> SpringBootMavenRemoteConnectionCreator.createRemoteConnectionForScript$lambda$1(params, args, arg_0));
    }

    @Nullable
    public RemoteConnection createRemoteConnection(@NotNull JavaParameters javaParameters, @NotNull MavenRunConfiguration runConfiguration) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)javaParameters, (String)"javaParameters");
            Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
            ParametersList programParametersList = javaParameters.getProgramParametersList();
            List list = programParametersList.getList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getList(...)");
            Iterable $this$none$iv = list;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!(SpringBootMavenRemoteConnectionCreatorKt.access$getSPRING_BOOT_GOALS$p().contains(it) || SpringBootMavenRemoteConnectionCreatorKt.access$getSPRING_BOOT_MAVEN_PLUGIN_PATTERN$p().matcher(it).matches())) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (bl) {
            return null;
        }
        return this.doCreateRemoteConnection(javaParameters, runConfiguration);
    }

    private final RemoteConnectionParams getConnectionParameters(JavaParameters javaParameters, MavenRunConfiguration runConfiguration) {
        Object v1;
        MavenProject mavenProject;
        ParametersList programParametersList;
        block3: {
            programParametersList = javaParameters.getProgramParametersList();
            MavenProject mavenProject2 = this.findMavenProject(runConfiguration);
            if (mavenProject2 == null) {
                return null;
            }
            mavenProject = mavenProject2;
            Iterable iterable = mavenProject.getPlugins();
            for (Object t : iterable) {
                MavenPlugin it = (MavenPlugin)t;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getGroupId(), (Object)"org.springframework.boot") && Intrinsics.areEqual((Object)it.getArtifactId(), (Object)"spring-boot-maven-plugin"))) continue;
                v1 = t;
                break block3;
            }
            v1 = null;
        }
        MavenPlugin springBootMavenPlugin = v1;
        Module module = (Module)ReadAction.compute(() -> SpringBootMavenRemoteConnectionCreator.getConnectionParameters$lambda$1(this, mavenProject, runConfiguration));
        String jvmArgsPropertyName = (String)ReadAction.compute(() -> SpringBootMavenRemoteConnectionCreator.getConnectionParameters$lambda$2(this, module));
        String argsPrefix = "-D" + jvmArgsPropertyName + "=";
        String argsStr = (String)ReadAction.compute(() -> SpringBootMavenRemoteConnectionCreator.getConnectionParameters$lambda$3(this, javaParameters, module, mavenProject, springBootMavenPlugin, programParametersList, argsPrefix, jvmArgsPropertyName));
        if (argsStr == null) {
            return null;
        }
        Intrinsics.checkNotNull((Object)jvmArgsPropertyName);
        return new RemoteConnectionParams(jvmArgsPropertyName, argsStr);
    }

    @Nullable
    public final RemoteConnection doCreateRemoteConnection(@NotNull JavaParameters javaParameters, @NotNull MavenRunConfiguration runConfiguration) {
        Intrinsics.checkNotNullParameter((Object)javaParameters, (String)"javaParameters");
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        ParametersList programParametersList = javaParameters.getProgramParametersList();
        RemoteConnectionParams remoteConnectionParams = this.getConnectionParameters(javaParameters, runConfiguration);
        if (remoteConnectionParams == null) {
            return null;
        }
        RemoteConnectionParams params = remoteConnectionParams;
        JavaParameters parameters = new JavaParameters();
        Project project = runConfiguration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RemoteConnection connection = this.createConnection(project, parameters);
        ParametersList args = this.createArgsForSpringBoot(parameters, params.getArgsString());
        String argsCommandLineArg = params.getArgsPrefix() + args.getParametersString();
        String string = params.getArgsPrefix();
        Intrinsics.checkNotNull((Object)programParametersList);
        this.setProgramParamList(string, programParametersList, argsCommandLineArg);
        return connection;
    }

    private final void setProgramParamList(String argsPrefix, ParametersList programParametersList, String argsCommandLineArg) {
        int argsIndex;
        block4: {
            int n;
            List list = programParametersList.getList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getList(...)");
            List $this$indexOfFirst$iv = list;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                String it = (String)item$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (StringsKt.startsWith$default((String)it, (String)argsPrefix, (boolean)false, (int)2, null)) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = argsIndex = -1;
        }
        if (argsIndex != -1) {
            programParametersList.set(argsIndex, argsCommandLineArg);
        } else {
            programParametersList.add(argsCommandLineArg);
        }
    }

    private final ParametersList createArgsForSpringBoot(JavaParameters parameters, String argsStr) {
        ParametersList args = new ParametersList();
        args.addAll(MavenApplicationConfigurationExecutionEnvironmentProvider.patchVmParameters((ParametersList)parameters.getVMParametersList()));
        args.addParametersString(argsStr);
        return args;
    }

    private final MavenProject findMavenProject(MavenRunConfiguration configuration) {
        Object v2;
        block2: {
            String string = configuration.getRunnerParameters().getWorkingDirPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getWorkingDirPath(...)");
            String workingDirectory = string;
            if (StringsKt.isBlank((CharSequence)workingDirectory)) {
                return null;
            }
            MavenProjectsManager projectsManager = MavenProjectsManager.getInstance((Project)configuration.getProject());
            List list = projectsManager.getProjects();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getProjects(...)");
            Iterable iterable = list;
            for (Object t : iterable) {
                MavenProject it = (MavenProject)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getDirectory(), (Object)workingDirectory)) continue;
                v2 = t;
                break block2;
            }
            v2 = null;
        }
        return v2;
    }

    private final Module findModule(MavenProject mavenProject, Project project) {
        try {
            return MavenProjectsManager.getInstance((Project)project).findModule(mavenProject);
        }
        catch (IndexNotReadyException e) {
            return null;
        }
    }

    private final boolean fork(JavaParameters javaParameters, Module module, MavenProject mavenProject, MavenPlugin mavenPlugin) {
        Boolean fork;
        String forkStr;
        MavenPlugin mavenPlugin2;
        if (SpringBootLibraryUtil.isAtLeastVersion((Module)module, (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_3_0_0)) {
            return true;
        }
        String forkPropertyName = this.getForkPropertyName(module);
        String string = javaParameters.getProgramParametersList().getPropertyValue(forkPropertyName);
        if (string == null && ((mavenPlugin2 = mavenPlugin) != null && (mavenPlugin2 = mavenPlugin2.getConfigurationElement()) != null && (mavenPlugin2 = mavenPlugin2.getChild("fork")) != null ? mavenPlugin2.getValue() : (string = null)) == null) {
            Object object = mavenProject.getProperties().get(forkPropertyName);
            string = object != null ? object.toString() : null;
            if (string == null) {
                string = javaParameters.getVMParametersList().getPropertyValue(forkPropertyName);
            }
        }
        String string2 = forkStr = string;
        Boolean bl = fork = string2 != null ? StringsKt.toBooleanStrictOrNull((String)string2) : null;
        if (fork != null) {
            return fork;
        }
        return SpringBootLibraryUtil.isAtLeastVersion((Module)module, (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_2_2_0);
    }

    private final String getForkPropertyName(Module module) {
        return SpringBootLibraryUtil.isAtLeastVersion((Module)module, (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_2_0_0) ? "spring-boot.run.fork" : "fork";
    }

    private final String getJvmArgsPropertyName(Module module) {
        return SpringBootLibraryUtil.isAtLeastVersion((Module)module, (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_2_0_0) ? "spring-boot.run.jvmArguments" : "run.jvmArguments";
    }

    private static final String createRemoteConnectionForScript$lambda$1(RemoteConnectionParams $params, ParametersList $args, String mavenOpts) {
        Intrinsics.checkNotNullParameter((Object)mavenOpts, (String)"mavenOpts");
        return "-D" + $params.getJvmArgsPropertyName() + "=" + $args.getParametersString();
    }

    private static final Module getConnectionParameters$lambda$1(SpringBootMavenRemoteConnectionCreator this$0, MavenProject $mavenProject, MavenRunConfiguration $runConfiguration) {
        Project project = $runConfiguration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Module module = this$0.findModule($mavenProject, project);
        if (module == null) {
            return null;
        }
        return module;
    }

    private static final String getConnectionParameters$lambda$2(SpringBootMavenRemoteConnectionCreator this$0, Module $module) {
        Intrinsics.checkNotNull((Object)$module);
        return this$0.getJvmArgsPropertyName($module);
    }

    private static final String getConnectionParameters$lambda$3(SpringBootMavenRemoteConnectionCreator this$0, JavaParameters $javaParameters, Module $module, MavenProject $mavenProject, MavenPlugin $springBootMavenPlugin, ParametersList $programParametersList, String $argsPrefix, String $jvmArgsPropertyName) {
        Object object;
        int argsIndex;
        Object $this$indexOfFirst$iv;
        block8: {
            int n;
            Intrinsics.checkNotNull((Object)$module);
            if (!this$0.fork($javaParameters, $module, $mavenProject, $springBootMavenPlugin)) {
                return null;
            }
            List list = $programParametersList.getList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getList(...)");
            $this$indexOfFirst$iv = list;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                Object item$iv = iterator.next();
                String it = (String)item$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (StringsKt.startsWith$default((String)it, (String)$argsPrefix, (boolean)false, (int)2, null)) {
                    n = index$iv;
                    break block8;
                }
                ++index$iv;
            }
            n = argsIndex = -1;
        }
        if (argsIndex != -1) {
            String string = $programParametersList.get(argsIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
            $this$indexOfFirst$iv = string;
            int n = $argsPrefix.length();
            String string2 = ((String)$this$indexOfFirst$iv).substring(n);
            object = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            String configurationValue;
            MavenPlugin mavenPlugin = $springBootMavenPlugin;
            String string = mavenPlugin != null && (mavenPlugin = mavenPlugin.getConfigurationElement()) != null && (mavenPlugin = mavenPlugin.getChild("jvmArguments")) != null ? mavenPlugin.getValue() : (configurationValue = null);
            if (configurationValue != null) {
                object = null;
            } else {
                object = $mavenProject.getProperties().get($jvmArgsPropertyName);
                if ((object == null || (object = object.toString()) == null) && (object = $javaParameters.getVMParametersList().getPropertyValue($jvmArgsPropertyName)) == null) {
                    object = "";
                }
            }
        }
        return object;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/spring/boot/maven/shared/run/SpringBootMavenRemoteConnectionCreator$RemoteConnectionParams;", "", "jvmArgsPropertyName", "", "argsString", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getJvmArgsPropertyName", "()Ljava/lang/String;", "getArgsString", "argsPrefix", "getArgsPrefix", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.spring.boot.maven.shared"})
    private static final class RemoteConnectionParams {
        @NotNull
        private final String jvmArgsPropertyName;
        @NotNull
        private final String argsString;
        @NotNull
        private final String argsPrefix;

        public RemoteConnectionParams(@NotNull String jvmArgsPropertyName, @NotNull String argsString) {
            Intrinsics.checkNotNullParameter((Object)jvmArgsPropertyName, (String)"jvmArgsPropertyName");
            Intrinsics.checkNotNullParameter((Object)argsString, (String)"argsString");
            this.jvmArgsPropertyName = jvmArgsPropertyName;
            this.argsString = argsString;
            this.argsPrefix = "-D" + this.jvmArgsPropertyName + "=";
        }

        @NotNull
        public final String getJvmArgsPropertyName() {
            return this.jvmArgsPropertyName;
        }

        @NotNull
        public final String getArgsString() {
            return this.argsString;
        }

        @NotNull
        public final String getArgsPrefix() {
            return this.argsPrefix;
        }

        @NotNull
        public final String component1() {
            return this.jvmArgsPropertyName;
        }

        @NotNull
        public final String component2() {
            return this.argsString;
        }

        @NotNull
        public final RemoteConnectionParams copy(@NotNull String jvmArgsPropertyName, @NotNull String argsString) {
            Intrinsics.checkNotNullParameter((Object)jvmArgsPropertyName, (String)"jvmArgsPropertyName");
            Intrinsics.checkNotNullParameter((Object)argsString, (String)"argsString");
            return new RemoteConnectionParams(jvmArgsPropertyName, argsString);
        }

        public static /* synthetic */ RemoteConnectionParams copy$default(RemoteConnectionParams remoteConnectionParams, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = remoteConnectionParams.jvmArgsPropertyName;
            }
            if ((n & 2) != 0) {
                string2 = remoteConnectionParams.argsString;
            }
            return remoteConnectionParams.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "RemoteConnectionParams(jvmArgsPropertyName=" + this.jvmArgsPropertyName + ", argsString=" + this.argsString + ")";
        }

        public int hashCode() {
            int result = this.jvmArgsPropertyName.hashCode();
            result = result * 31 + this.argsString.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RemoteConnectionParams)) {
                return false;
            }
            RemoteConnectionParams remoteConnectionParams = (RemoteConnectionParams)other;
            if (!Intrinsics.areEqual((Object)this.jvmArgsPropertyName, (Object)remoteConnectionParams.jvmArgsPropertyName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.argsString, (Object)remoteConnectionParams.argsString);
        }
    }
}

