/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.scope.processor.MethodResolveProcessor;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.factories.SpringFactoryBeansManager;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.converters.SpringBeanMethodConverter;
import com.intellij.spring.model.values.PlaceholderUtils;
import com.intellij.spring.model.xml.AbstractDomSpringBean;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.SmartList;
import com.intellij.util.xml.DomUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringBeanFactoryMethodConverter
extends SpringBeanMethodConverter {
    protected static final String ASPECT_OF_METHOD_NAME = "aspectOf";

    @NotNull
    public static List<PsiMethod> getFactoryMethodCandidates(@NotNull AbstractDomSpringBean springBean, @NotNull String methodName) {
        if (springBean == null) {
            SpringBeanFactoryMethodConverter.$$$reportNull$$$0(0);
        }
        if (methodName == null) {
            SpringBeanFactoryMethodConverter.$$$reportNull$$$0(1);
        }
        PsiClass factoryClass = SpringBeanFactoryMethodConverter.getFactoryClass(springBean);
        SmartList result = new SmartList();
        if (factoryClass != null) {
            PsiMethod[] methods;
            if (ASPECT_OF_METHOD_NAME.equals(methodName)) {
                result.add(SpringBeanFactoryMethodConverter.createAspectOfLightMethod(springBean.getPsiManager()));
            }
            if ((methods = MethodResolveProcessor.findMethod((PsiClass)factoryClass, (String)methodName)).length > 0) {
                boolean fromFactoryBean = springBean.getFactoryBean().getValue() != null;
                for (PsiMethod method : methods) {
                    if (!SpringFactoryBeansManager.getInstance().isValidFactoryMethod(method, fromFactoryBean)) continue;
                    result.add(method);
                }
            }
        }
        SmartList smartList = result;
        if (smartList == null) {
            SpringBeanFactoryMethodConverter.$$$reportNull$$$0(2);
        }
        return smartList;
    }

    protected static LightMethodBuilder createAspectOfLightMethod(PsiManager manager) {
        return new LightMethodBuilder(manager, ASPECT_OF_METHOD_NAME).setModifiers(new String[]{"static", "public"}).setMethodReturnType("java.lang.Object");
    }

    @Nullable
    public static PsiClass getFactoryClass(AbstractDomSpringBean abstractDomSpringBean) {
        PsiClass beanClass = null;
        if (abstractDomSpringBean instanceof SpringBean) {
            SpringBean springBean = (SpringBean)((Object)abstractDomSpringBean);
            if (!DomUtil.hasXml(springBean.getFactoryBean())) {
                beanClass = PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType(false));
            } else {
                String beanPointerStringValue = springBean.getFactoryBean().getRawText();
                if (StringUtil.isEmptyOrSpaces((String)beanPointerStringValue) || PlaceholderUtils.getInstance().isDefaultPlaceholder(beanPointerStringValue)) {
                    return null;
                }
                SpringBeanPointer factoryBeanPointer = (SpringBeanPointer)springBean.getFactoryBean().getValue();
                if (factoryBeanPointer == null) {
                    return null;
                }
                Object factoryBean = factoryBeanPointer.getSpringBean();
                if (!factoryBean.equals(springBean)) {
                    beanClass = (PsiClass)RecursionManager.doPreventingRecursion(factoryBean, (boolean)true, () -> PsiTypesUtil.getPsiClass((PsiType)factoryBean.getBeanType(true)));
                }
            }
            if (beanClass != null && SpringFactoryBeansManager.getInstance().isFactoryBeanClass(beanClass)) {
                PsiType[] types;
                for (PsiType type : types = SpringFactoryBeansManager.getInstance().getObjectTypes((PsiType)PsiTypesUtil.getClassType((PsiClass)beanClass), springBean)) {
                    PsiClass aClass = PsiTypesUtil.getPsiClass((PsiType)type);
                    if (aClass == null) continue;
                    return aClass;
                }
            }
        }
        return beanClass;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springBean";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/converters/SpringBeanFactoryMethodConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/converters/SpringBeanFactoryMethodConverter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactoryMethodCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFactoryMethodCandidates";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

