// Unit Tests for PortageFiles.cpp
// SPDX-FileCopyrightText: 2024 <A Schenck> <galiven@users.sourceforge.net>
// SPDX-License-Identifier: GPL-2.0-only OR GPL-3.0-only OR LicenseRef-KDE-Accepted-GPL

#ifndef PORTAGEFILESTESTS_H
#define PORTAGEFILESTESTS_H

#include <QDir>
#include <QObject>

class PortageFilesTests : public QObject
{
	Q_OBJECT

private Q_SLOTS:
	void initTestCase();
	void cleanupTestCase();

	void init();
	void cleanup();

	void testRecursiveReadShouldReadFlat();
	void testRecursiveReadShouldRaedNested();
	void testRecursiveReadShouldExcludeTopLevelFile();
	void testRecursiveReadShouldExcludeTopLevelDir();
	void testRecursiveReaShouldExcludeNestedFile();
	
private:
	void setupRecursiveRead();
	QString		nestedTestDirPath;
	QStringList	nestedResults = { QLatin1String("test1"), QLatin1String("test2"), QLatin1String("test3"), QLatin1String("test4"), QLatin1String("test5"), QLatin1String("test6"), QLatin1String("test7") };
};

#endif // PORTAGEFILESTESTS_H
