# RCS: $Id: DegtUtils.pm,v 1.1 1997/09/28 19:31:15 grimaldo Exp $
#------------------------------------------------------------------------
#       DegtUtils.pm (c)1997 D. Emilio Grimaldo Tunon
#------------------------------------------------------------------------
# AUTHOR: D. Emilio Grimaldo T.         grimaldo@panama.iaehv.nl
# DESCRIPTION:
#          A small collection of Perl utility routines.
#

package DegtUtils;
    use Exporter;
    @ISA = qw(Exporter);
    # ********* GLOBAL SYMBOLS *********
    @EXPORT = qw( &Print &sPrint &GetVersion);
    # ********* GLOBAL VARIABLES *********
    # none
    # ********* LOCAL  VARIABLES *********
    # ************************************
    use strict;

# ********** LOCAL DATA SECTION **********

my $VERSION;	   
# ********* ********************* *********

sub BEGIN {
    $VERSION = '$Revision: 1.1 $';
    $VERSION =~ m/Revision: (\d+\.\d+\.*\d*\.*\d*)/;
    $VERSION = $1;
}

#************************************************
# FUNCTION : sPrint
# PROTOTYPE: sPrint REF VALUE
# RETURNS  : -
# GLOBALS  : -
# PRIVATES :
# DESCRIPTION
#         This routine is used to print to either
#       a file global (GLOB) or an array. The former
#       useful normally for immediate output and the
#       latter useful for buffering output.
#         
sub sPrint {
    my $where = shift;  # \@ or \*
    my $what  = shift;  # string/value

    if (ref($where) eq 'ARRAY') {
        push(@{$where}, $what);
	return;
    }
    if (ref($where) eq 'GLOB') {
        print $where $what;
	return;
    }	
}

#************************************************
# FUNCTION : Print
# PROTOTYPE: Print REF VALUE [.. VALUE]
# RETURNS  : -
# GLOBALS  : -
# PRIVATES :
# DESCRIPTION
#         This routine is used to print to either
#       a file global (GLOB) or an array. The former
#       useful normally for immediate output and the
#       latter useful for buffering output.
#         The VALUE can also be a reference to an
#       array in which case it is decomposed.
sub Print {
    my $where = shift;  # \@ or \*
    my $i;

    foreach $i (0 .. $#_) {
        if (ref(@_[$i]) eq 'ARRAY') {
	    my $j;
	    my $ref;

	    $ref = @_[$i];
	    foreach $j (0 .. $#$ref) {
	        &sPrint($where, $$ref[$j]);
	    }
        } else {
	    &sPrint($where, @_[$i]);
	}
    }
}    

sub GetVersion {
    return $VERSION;
}

sub END {
}
