# RCS: $Id: Interpret.pm,v 2.1 1997/09/28 20:47:04 grimaldo Exp $
#------------------------------------------------------------------------
#       Interpret.pm (c)1997 D. Emilio Grimaldo Tunon
#------------------------------------------------------------------------
# AUTHOR: D. Emilio Grimaldo T.         grimaldo@panama.iaehv.nl
# DESCRIPTION:
#          Process personal resource files a-la Tcl syntax so that it
#	can (in  most cases) be shared with Tcl scripts/GUI. The syntax
#	is quite restricted but we don't need anything bigger or more
#	complex.
#
# SYNTAX:
#          # This is a comment line, it will be ignored
#	   set  ChklogsConf  ~/devel/test/chklogs.conf
#	   set  ChklogsDb    ~grimaldo/devel/test/.chklogsdb
#	   mode ignore on
#	   # anything between ignore on & ignore off will be ignored
#          set  VarRun       /var/run

package Interpret;
    use Exporter;
    @ISA = qw(Exporter);
    # ********* GLOBAL SYMBOLS *********
    @EXPORT = qw( &interpretRc &GetVersion);
    # ********* GLOBAL VARIABLES *********
    # none
    # ********* LOCAL  VARIABLES *********
    use vars qw( %varMode );
    # ************************************
    use strict;

# ********** LOCAL DATA SECTION **********
%varMode = (
		'ignore'	=> 'off'
	   );
my $VERSION;	   
# ********* ********************* *********

sub BEGIN {
    $VERSION = '$Revision: 2.1 $';
    $VERSION =~ m/Revision: (\d+\.\d+\.*\d*\.*\d*)/;
    $VERSION = $1;
}

#************************************************
# FUNCTION : interpretRc
# PROTOTYPE: interpretRc($RcFile, \%variableMapping)
# RETURNS  : 0 if nothing done (no file), 1 otherwise.
# GLOBALS  : -
# DESCRIPTION
#		Reads the RcFile and parses it. The variableMapping
#	is used to assign values to the caller's name space variables
#	by mapping an Rc variable name to it's variable.

sub interpretRc {
    my $rc   = shift;
    my $href = shift;
    my $var;
    my $value;

    open(PRC,$rc) or return 0;
    while (<PRC>) {
        next if (/^\s*#/);

	#
	# COMMAND: mode Mode
	#
	if (/^\s*mode\s+(\w+)\s+(\w+)/) {
	    $var = $1;
	    $value = $2;
	    chomp $value;
	    if ( exists($varMode{$var}) ) {
	        $varMode{$var} = $value;
	    }
	    next;
	}

	next if ($varMode{'ignore'} eq "on");

	#
	# COMMAND: set VarName Value
	#
        if (/^\s*set\s+(\w+)\s+((\w|\W)+)/) {
	    $var = $1;
	    $value = $2;
	    chomp $value;
	    #
	    # Attempt to process the tilde
	    #
	    $value =~ s|^~/|$ENV{HOME}/|;	# ~/path-name form
	    $value =~ s|^~(\w+)|/home/$1|;	# ~logname/path-name form

	    # Now try to map an Rc variable to a public one
	    # but *only* if defined in the hash to avoid
	    # accidental pollution/corruption of name space

	    if ( exists($$href{$var}) ) {
		${$$href{$var}} = $value;
	    }
	}
    }	
    close(PRC);
    return 1;
}

sub GetVersion {
    return $VERSION;
}

sub END {
}
