/*

   hostid.c

   New hostid for Linux.

   Date:        1997-03-23 18:30:00
   Last Change: 1997-03-23 20:36:48

   Copyright (C) 1997 Sander van Malssen <svm@kozmix.ow.nl>

   This software is released under the GNU Public Licence. See the
   file `COPYING' for details.

*/

static char *rcsid = "$Id: hostid.c,v 1.1 1997/03/23 19:43:14 svm Exp svm $";

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>

char *progname;

void
usage (int exitval)
{
    fprintf (exitval ? stderr : stdout,
	     "usage:\n"
	     "  printing the hostid:\n"
	     "    %s\n"
	     "  setting the hostid:\n"
	     "    %s [id]\t\tset hostid to [id]\n"
	     "    %s -e\t\tset hostid to first ethernet address\n"
	     "  general options:\n"
	     "    -v\t\t\tverbose\n"
	     "    -x\t\t\tuse hexadecimal\n",
	     progname, progname, progname);
    exit (exitval);
}

int
main (int ac, char **av)
{
    int ret, verbose = 0, hex = 0, ether = 0;
    unsigned long id;

    progname = av[0];

    while ((ret = getopt (ac, av, "vxeh")) != EOF) {
	switch (ret) {
	case 'x': hex = 1;     break;
	case 'v': verbose = 1; break;
	case 'e': ether = 1;   break;
	case 'h': usage (0);   break;
	default:  usage (1);   break;
	}
    }

    if (ac == optind && !ether) {	/* GET */

	id = gethostid ();

	if (id == 0 && verbose) {
	    printf ("Hostid not set\n");
	    exit (0);
	}
	if (verbose)
	    printf ("hostid is %lu (0x%08lx)\n", id, id);
	else if (hex)
	    printf ("0x%08lx\n", id);
	else
	    printf ("%lu\n", id);
	exit (0);

    } else {				/* SET */

	if (ether && ac > optind) {
	    fprintf (stderr, "%s: can't both use -e and specify [id]\n\n",
		     progname);
	    usage(2);
	}

	if (ether) {
	    FILE *fp;
	    char line[1024], addrstring[32], *p = NULL, *q;

	    if ((fp = popen ("/sbin/ifconfig eth0", "r")) == NULL) {
		fprintf (stderr, "%s: can't run ifconfig: %s\n",
			 progname, strerror (errno));
		exit (1);
	    }
	    while (fgets (line, 1024, fp)) {
		if ((p = strstr (line, "HWaddr"))) {
		    p += 7;
		    break;
		}
	    }
	    pclose (fp);

	    if (p == NULL) {
		fprintf (stderr, "%s: no hardware address found\n",
			 progname);
		exit (1);
	    }

	    q = addrstring;
	    while (*p && *p != '\n') {
		if (*p != ':')
		    *q++ = *p++;
		else
		    p++;
	    }
	    id = strtoul (addrstring, NULL, 16);
	} else
	    id = strtoul (av[ac - 1], NULL, hex ? 16 : 10);

	ret = sethostid (id);
	if (ret) {
	    fprintf (stderr, "%s: sethostid: %s\n", progname, strerror (errno));
	    exit (1);
	}
	if (verbose)
	    printf ("hostid set to %lu (0x%08lx)\n", id, id);

	exit (0);

    }
}

/*
   Local variables:
   rm-trailing-spaces: t
   End:
 */
