#####################################################################
#
#	You should not need to modify anything below this.
#
#####################################################################
#
# Check that the SAHOME, SADBDIR or SADISTDIR variables are set.
#
if [info exist env(SAHOME)]==0&&[info exist env(SADBDIR)]==0 {
    puts stderr "the environment variables SAHOME or SADBDIR must be set"
    exit 1
}
if [info exist env(SAHOME)]==0&&[info exist env(SADISTDIR)]==0 {
    puts stderr "the environment variables SAHOME or SADISTDIR must be set"
    exit 1
}

#
# Set corect remote shell command to use.
#
set sysname [exec uname -s]
case $sysname {
    HP-UX {
	set SArsh remsh
    }
    default {
	set SArsh rsh
    }
}


#
# Set default directory.
#
if [info exist env(SADISTDIR)]==0 {
    set env(SADISTDIR) $env(SAHOME)/sadist
}

#
# Some routines for setting internal variables.
#
proc database {d} {
    global SAdatabase
    set SAdatabase $d
}

proc mode {m} {
    global SAmode
    set SAmode $m
}

proc owner {o} {
    global SAowner
    set SAowner $o
}

proc group {g} {
    global SAgroup
    set SAgroup $g
}

proc required_user {u} {
    global SArequired_user
    set SArequired_user $u
}

proc directory {d} {
    global SAdirectory
    set SAdirectory $d
}

proc hostname {h} {
    global SAhostname
    set SAhostname $h
}

proc hosts {h} {
    global SAhosts
    set SAhosts $h
}

proc whoami {w} {
    global SAwhoami
    set SAwhoami $w
}

proc rcmd {r} {
    global SArcmd
    set SArcmd $r
}

proc compare {c} {
    global SAcompare
    set SAcompare $c
}

proc pre_rcmd {c} {
    global SApre_rcmd
    set SApre_rcmd $c
}

proc post_rcmd {c} {
    global SApost_rcmd
    set SApost_rcmd $c
}

proc dest {d} {
    global SAdest
    set SAdest $d
}

proc preprocess {p} {
    global SApreprocess
    set SApreprocess $p
}

proc timeout {t} {
    global SAtimeout
    set SAtimeout $t
}

proc max_processes {m} {
    global SAmax_processes
    set SAmax_processes $m
}

#
# This routine is executed before data is generated for host.
#
proc preprocess_host {name} {
    global SApreprocess
    #
    # Execute in global level.
    #
    if [string length $SApreprocess]!=0 {
	uplevel 1 $SApreprocess
    }
}

#
# Procedure which returns the default list of machines to
# distribute to (only called by the C-code).
#
proc make_host_list {} {
    global SAhosts
    lsort [eval $SAhosts]
}

#
# Default command to execute when actually updating a host.
#
proc update_host {name file} {
    #
    # First mark some variables as globals.
    #
    global host SAmode SAowner SAgroup SAdest SAhostname SArcmd
    global SApre_rcmd SApost_rcmd
    global SAdistribution SAtimeout SABINDIR
    global SArsh dns_domain

    #
    # Clear chown and chgrp variables.
    #
    set SAchown ""
    set SAchgrp ""

    #
    # Re evaluate the SArcmd variable, it will probably contain
    # a reference to the $SAdest variable which is the in the Control
    # file.
    #
    if [string length $SAowner]!=0 {
    	set SAchown "chown $SAowner $SAdest.new &&"
    }
    if [string length $SAgroup]!=0 {
    	set SAchgrp "chgrp $SAgroup $SAdest.new &&"
    }

    if [string length $SApre_rcmd]!=0 {
    	set SArcmd "$SApre_rcmd && $SArcmd"
    }

    if [string length $SApost_rcmd]!=0 {
    	set SArcmd "$SArcmd ; $SApost_rcmd"
    }

    eval set SArcmd "\"$SArcmd;exit\""

    #
    # Do the distribution, if running on the machine to update
    # don't use rsh but use sh instead.
    #
    if [string compare $host $SAhostname]==0 {
	set rc [
	    catch {
	        exec $SABINDIR/bin/satimeout -$SAtimeout sh -c "$SArcmd" >/dev/null < $file
	    } result
	]

	set local 1
    } else {
	set real_host $host
	if [info exist dns_domain] {
	    if  [string compare $dns_domain ""] {
		set real_host $host.$dns_domain
	    }
	}

	set rc [
	    catch {
	        exec $SABINDIR/bin/satimeout -$SAtimeout $SArsh $real_host sh -c "'$SArcmd'" >/dev/null <$file
	    } result
	]
	set local 0
    }

    #
    # If any output is generated, consider it to be an error.
    #
    if [string length $result]!=0 {
	set rc 1
	set result [join [split $result \n]]
    }

    #
    # Write logging string.
    #
    puts -nonewline stdout "$SAdistribution => $name"
    if [string compare $name $host]!=0 {
        puts -nonewline stdout " (really $host)"
    }
    if $rc!=0 {
	puts stdout ": failed: $result"
    } else {
	puts stdout ": ok"
    }
}

proc compare_host {name file} {
    #
    # First mark some variables as globals.
    #
    global host SAdest SAhostname SAcompare SAdistribution

    #
    # Re evaluate the SAcompare variable, it will probably contain
    # a reference to the $SAdest variable which is the in the Control
    # file.
    #
    eval set SAcompare "\"$SAcompare\""

    #
    # Do the distribution, if running on the machine to update
    # don't use rsh but use sh instead.
    #
    if [string compare $host $SAhostname]==0 {
	set rc [catch {exec sh -c "$SAcompare > /dev/null" < $file} result]
	set local 1
    } else {
	set rc [catch {exec rsh $host "$SAcompare > /dev/null" < $file} result]
	set local 0
    }
    if [string length $result]!=0 {
    	set rc 1
    }

    #
    # Write logging string.
    #
    puts -nonewline stdout "$SAdistribution => $name"
    if [string compare $name $host]!=0 {
	puts -nonewline stdout " (really $host)"
    }
    if $rc!=0 {
	puts -nonewline stdout ": failed: [join $result]"
    } else {
    	puts -nonewline stdout ": ok"
    }
    puts stdout ""

}

#
# Show debugging info.
#
proc debug_host {name file} {
    global host SArcmd SAdest SAdistribution SAmode SAowner SAgroup
    global SApre_rcmd SApost_rcmd

    if [string length $SApre_rcmd]!=0 {
    	set SArcmd "$SApre_rcmd && $SArcmd"
    }

    if [string length $SApost_rcmd]!=0 {
    	set SArcmd "$SArcmd ; $SApost_rcmd"
    }

    puts stdout "Host: $name (really $host)"
    puts stdout "Destination: $SAdest"
    puts stdout "Owner: $SAowner"
    puts stdout "Group: $SAgroup"
    puts stdout "Mode: $SAmode"

    puts stdout "Remote command: '$SArcmd'"
    puts stdout "Distribution: $SAdistribution"
    puts stdout "Data:"
    puts stdout "---------- BEGIN ----------"
    flush stdout
    exec /bin/cat $file >@stdout
    puts stdout "----------- END -----------\n"
}

#
# Set the skip variable so that sadist will stop this distribution.
#
proc skip {} {
    global SAskip
    set SAskip 1
}

#
# Set the default remote command.
#
rcmd {cat > $SAdest.new && $SAchown $SAchgrp chmod $SAmode $SAdest.new || exit 1; mv $SAdest $SAdest.old 2>/dev/null;  mv $SAdest.new $SAdest}

#
# Set which sadist directory to use.
#
directory $env(SADISTDIR)

#
# Set the default comparising command.
#
compare {cat > $SAdest.new && cmp $SAdest $SAdest.new; rm -f $SAdest.new}

#
# Set the database name to use for getting information about hosts.
#
database machines

#
# Default owner, group and protection of destination file.
#
owner ""
group ""
mode 644

#
# Default set of machines to run on.
#
hosts {machines -exist true}

#
# Default is no preprocessing.
#
preprocess {}

#
# Default is no pre- and post_rcmd.
#
pre_rcmd {}
post_rcmd {}

#
# Default destination empty.
#
dest ""

#
# Default timeout 300 sec.
#
timeout 300

#
# Some useful commands to be used in Control-files.
#

# Turn the osvers into either sunos or solaris for Sun:s.
proc sunos.unify.osvers {} {
    global osname osvers
    if [string match "SunOS" $osname] {
    	if [string match "5.*" $osvers] {
	    set osvers solaris
    	} else {
    	    set osvers sunos
	}
    }
}

#
# Source local configuration files.
#
source $SABINDIR/lib/sadist.cfg
