//
// Copyright (C) 1995  Lars Berntzon
//
#include <sadblib.hh>
#include <sadist.hh>
#include <iostream.h>

//////////////////////////////////////////////////////////////////
//		P R O C _ I N C L U D E
//		-----------------------
// Description:
//	Handle include  and include-cond statements.
//
//////////////////////////////////////////////////////////////////
int
SADist::proc_include(int argc, char **argv)
{
    char buf[PATH_MAX];
    int rc = TCL_OK;
    int i;
    Archive archive;
    int cond = 0;		// True if it is the include-cond statement.
    int binary = 0;		// True if binary include.


    //
    // Check the name of the routine.
    //
    if (strcmp(argv[0], "include-cond") == 0 ||
        strcmp(argv[0], "include-bin-cond") == 0) {
    	cond = 1;
    }
    if (strcmp(argv[0], "include-bin") == 0 ||
        strcmp(argv[0], "include-bin-cond") == 0) {
    	binary = 1;
    }

    //
    // Shift away the routine name.
    //
    argc--, argv++;

    // 
    // Try to open files in turn.
    //
    for(i = 0; argv[i]; i++)
    {
	sprintf(buf, "%s/%s/%s", directory, distribution, argv[i]);
	if (archive.open(interp, buf) == 0) {
	    break;
	}
    }
    if (argv[i] == 0) {
    	//
    	// Different returns depending if include of include-cond
    	//
    	if (cond) {
	    Tcl_ResetResult(interp);
	    return TCL_OK;
	}
	else {
	    Tcl_ResetResult(interp);
	    for(i = 0; argv[i] != 0; i++) {
		Tcl_AppendElement(interp, argv[i]);
	    }
	    Tcl_AppendResult(interp, ": can't include files", 0);
	    return TCL_ERROR;
	}
    }

    //
    // Read the file, either in binary mode or postprocessed.
    //
    if (binary) {
    	int ch;
    	while((ch = archive.stream().get()) != EOF) {
    	    output.put(ch);
    	}
    }
    else {
	rc = process_input(archive.stream());
	if (rc != TCL_OK) {
	    return rc;
	}
    }

    return TCL_OK;
}

//
// History of changes:
// $Log: proc_include.cc,v $
// Revision 1.19  1996/09/14 18:33:35  lasse
// Added some things to the TODO and added pargs
//
// Revision 1.18  1995/09/23  13:46:08  lasse
// Imported from remote
//
// Revision 1.2  1995/09/22  19:05:52  qdtlarb
// Now runs ins parallel
//
// Revision 1.1.1.1  1995/09/11  09:23:08  qdtlarb
// THis is version 0.6
//
// Revision 1.17  1995/09/10  20:43:24  lasse
// Added copyright everywhere
//
// Revision 1.16  1995/09/10  19:03:42  lasse
// Corrected removed Log keyword
//
// Revision 1.1.1.1  1995/07/17  07:51:36  qdtlarb
// Original V0_3
//
// Revision 1.14  1995/06/11  12:26:22  lasse
// backup
//
// Revision 1.13  1995/06/08  19:20:58  lasse
// backup
//
// Revision 1.12  1995/06/07  20:29:43  lasse
// It seems as i managed to make the SADist object ok.
//
// Revision 1.11  1995/06/06  18:47:37  lasse
// Added include-bin and include-bin-cond
//
// Revision 1.10  1995/06/06  18:20:01  lasse
// added include-cond
//
// Revision 1.9  1995/06/06  17:55:33  lasse
// backup
//
// Revision 1.8  1995/06/05  12:40:58  lasse
// Seems to work allmost
//
// Revision 1.7  1995/06/05  12:30:45  lasse
// Backup
//
// Revision 1.6  1995/05/16  12:55:53  lasse
// backup
//
// Revision 1.5  1995/05/16  12:55:40  lasse
// backup
//
// Revision 1.4  1995/05/13  20:52:17  lasse
// backup
//
// Revision 1.3  1995/05/13  20:28:51  lasse
// backup
//
// Revision 1.2  1995/05/13  20:13:42  lasse
// backup
//
// Revision 1.1  1995/05/13  20:12:01  lasse
// backup
//
//
