//
// Copyright (C) 1995  Lars Berntzon
//
//////////////////////////////////////////////////////////////////
//
// Name:
//	SADIST
//
// Synopsis:
//	sadist [-d] [-l] distribution[,...] [machine ...]
//
// Description:
//	Distributes files to hosts. This is usually used for
//	distributing system files which are allmost identical on
//	most hosts with some exceptions for some hosts and
//	some lines in the files. The file needs not to be a file
//	on the destination machine, it can be fed as input to a
//	command e.g. crontab. It can also be a set of commands to
//	execute, e.g. lpadmin and its options.
//	The idea of dist is to have complete control of all hosts
// 	in the administrativ domain.
//
// Options:
//	-d	- Debug mode, don't update machine, only show the
//		  resulting data.
//
//	-c	- Compare data on remote host with data from the
//		  sadist directory.
//
//	-l	- Local mode, don't distribute subdirectories.
//
//	-n <number> 
//		- Maximum number of parallell processes.
//
//////////////////////////////////////////////////////////////////
#include <sadblib.hh>
#include <sadist.hh>
#include <iostream.h>
#include <fstream.h>
#include <stdio.h>

//  G l o b a l   s t u f f .
char *prog;			// Name of this program.


//////////////////////////////////////////////////////////////////
//		M A I N
//		-------
//
// Description:
//	Main routine for sadist.
//
//////////////////////////////////////////////////////////////////
int
main(int argc, char **argv)
{
    TextList hosts;		// Machines specified on the command line.
    TextList distributions;	// List of distributions to do.
    Options options;		// Command line options.
    int i;			// Temporary counter.
    char *dist;			// Distribution type.

    //
    // Examine name of the command.
    //
    if ((prog = strrchr(argv[0], '/'))) prog++;
    else prog = argv[0];
    argv++, argc--;

    //
    // Check arguments.
    //
    while(*argv)
    {
        if (strcmp(argv[0], "-d") == 0) {
            options.set_debug();
        }
        else if (strcmp(argv[0], "-c") == 0) {
            options.set_compare();
        }
        else if (strcmp(argv[0], "-l") == 0) {
            options.set_local();
        }
        else if (strcmp(argv[0], "-n") == 0) {
            if (argv[1] == 0) {
		cerr << prog << ": " << argv[0] << ": option needs argument\n";
		sadist_usage();
            }
            options.max_processes = atoi(argv[1]);
            argv++, argc--;
        }
        else if (argv[0][0] == '-') {
            cerr << prog << ": " << argv[0] << ": unknown option\n";
            sadist_usage();
        }
        else {
            break;
        }
        argv++, argc--;
    }

    //
    // Verify at least one distribution specified.
    //
    if (argc < 1) {
    	sadist_usage();
    }

    //
    // Make a list of sadist.
    //
    for(i = 1; i < argc; i++)
    {
    	hosts.append(TextEntry(argv[i]));
    }

    //
    // Create the SADist control object.
    //
    SADist sadist(options);
    if (sadist.status() != 0)
    {
    	cerr << prog << ": " << sadist.error_message() << endl;
    	return 1;
    }
   
    //
    // Get the distributions. If there are multiple distributions separated
    // by commands, split them up. If the "all" distribution is specified
    // do all distributions.
    //
    for(dist = strtok(argv[0], ","); dist != 0; dist = strtok(0, ","))
    {
    	if (strcmp(dist, "all") == 0) {
    	    distributions = sadist.list_distributions(0);
    	    break; // If everything is to be distributed, no need to get more.
	}
	else
	{
	    distributions.append(TextEntry(dist));
	}
    }

    //
    // Do the actual distribution.
    //
    if (sadist.distribute(distributions, hosts) != 0)
    {
	cerr << prog << ": " << sadist.error_message() << endl;
	return 1;
    }
}

//
// History of changes:
// $Log: sadist.cc,v $
// Revision 1.43  1996/11/10 00:02:57  lasse
// Corrected some testing
//
// Revision 1.42  1996/09/14 18:33:36  lasse
// Added some things to the TODO and added pargs
//
// Revision 1.41  1996/06/08 21:58:29  lasse
// *** empty log message ***
//
// Revision 1.40  1995/09/23  13:46:10  lasse
// Imported from remote
//
// Revision 1.1.1.1  1995/09/11  09:23:09  qdtlarb
// THis is version 0.6
//
// Revision 1.39  1995/09/10  20:43:25  lasse
// Added copyright everywhere
//
// Revision 1.38  1995/09/10  19:03:43  lasse
// Corrected removed Log keyword
//
// Revision 1.1.1.1  1995/07/17  07:51:37  qdtlarb
// Original V0_3
//
// Revision 1.34  1995/07/16  17:59:22  lasse
// The all distribution seems to work.
//
// Revision 1.33  1995/07/16  13:45:49  lasse
// merged differences
//
// Revision 1.32  1995/06/11  19:44:06  lasse
// Added option -l
//
// Revision 1.31  1995/06/11  12:26:22  lasse
// backup
//
// Revision 1.30  1995/06/11  10:35:18  lasse
// backup
//
// Revision 1.29  1995/06/09  21:37:05  lasse
// Now both sadbcmd and sadist seems to work with G++ DLList classes
//
// Revision 1.28  1995/06/07  20:29:44  lasse
// It seems as i managed to make the SADist object ok.
//
// Revision 1.27  1995/06/07  17:46:08  lasse
// backup
//
// Revision 1.26  1995/06/07  17:18:44  lasse
// Distributions can redefine destination host.
//
// Revision 1.25  1995/06/06  19:25:09  lasse
// backup
//
// Revision 1.24  1995/06/06  19:01:10  lasse
// Added text statement
//
// Revision 1.23  1995/06/06  18:47:38  lasse
// Added include-bin and include-bin-cond
//
// Revision 1.22  1995/06/06  18:27:24  lasse
// backup
//
// Revision 1.21  1995/06/06  18:20:01  lasse
// added include-cond
//
// Revision 1.20  1995/06/06  17:55:33  lasse
// backup
//
// Revision 1.19  1995/06/05  12:40:58  lasse
// Seems to work allmost
//
// Revision 1.18  1995/05/16  12:55:41  lasse
// backup
//
// Revision 1.17  1995/05/15  17:30:48  lasse
// Started to implement Archive.
//
// Revision 1.16  1995/05/15  09:03:04  lasse
// backup
//
// Revision 1.15  1995/05/13  23:37:43  lasse
// backup
//
// Revision 1.14  1995/05/13  22:57:30  lasse
// backup
//
// Revision 1.13  1995/05/13  22:40:56  lasse
// Getting there
//
// Revision 1.12  1995/05/13  22:03:19  lasse
// backup
//
// Revision 1.11  1995/05/13  21:01:28  lasse
// backup
//
// Revision 1.10  1995/05/13  20:52:17  lasse
// backup
//
// Revision 1.9  1995/05/13  20:30:08  lasse
// backup
//
// Revision 1.8  1995/05/13  20:28:52  lasse
// backup
//
// Revision 1.7  1995/05/13  20:12:02  lasse
// backup
//
// Revision 1.6  1995/05/13  17:54:56  lasse
// Added options for the database commands
//
// Revision 1.5  1995/05/13  16:32:03  lasse
// It seems much better now.
//
// Revision 1.4  1995/05/12  11:45:20  lasse
// backup
//
// Revision 1.3  1995/05/12  10:02:00  lasse
// backup
//
// Revision 1.2  1995/05/09  18:32:57  lasse
// Backup before converting List into a Proper List and adding Entry
//
// Revision 1.1  1995/05/09  11:30:51  lasse
// First embroy
//
//
