//
// Copyright (C) 1995  Lars Berntzon
//
#ifndef _SADIST_HH
#define _SADIST_HH
#include <iostream.h>
#include <fstream.h>
#include <tcl.h>
#ifdef USE_TCLX
#include <tclExtend.h>
#endif

// D e f i n e s .

// T y p e s .


class Options
{
public:
    Options() { pDebug = 0; pCompare = 0; pLocal = 0; max_processes = 1;}
    int is_debug(void) { return pDebug; }
    int is_compare(void) { return pCompare; }
    int is_local(void) { return pLocal; }
    void set_debug(void) { pDebug = 1; }
    void set_compare(void) { pCompare = 1; }
    void set_local(void) { pLocal = 1; }

    int max_processes;

private:
    int pDebug;
    int pCompare;
    int pLocal;
};

class ArchiveRep;
class Archive
{
public:
    Archive(void);
    open(Tcl_Interp *interp, const char *fileName);
    istream &stream(void);
    ~Archive();

private:
    cvs_open(const char *fileName);
    rcs_open(const char *fileName);
    sccs_open(const char *fileName);
    plain_open(const char *fileName);
    ArchiveRep *rep;
    Archive(Archive &a);	// Don't allow copy creator.
};

class ArchiveRep
{
public:
    virtual istream &stream(void) = 0;
    virtual ~ArchiveRep() = 0;
};

class FileRep : public ArchiveRep
{
public:
    FileRep(const char *fileName);
    virtual istream &stream(void);
    virtual ~FileRep(void);

private:
    ifstream s;
};

class SADist 
{
public:
    SADist(const Options &options);

    TextList list_distributions(const char *distName = 0);
    int distribute(TextList &distributions, TextList &hosts);
    int update_hosts(ListList &hosts, SADB &db, int useDatabase);

    int status(void);
    const char *error_message(void);
    int process_input(istream &in);

    ~SADist(void);

private:
    int source_setupfiles(void);
    int pDebugFlag;
    int skip;				// If this is set, skip host or distribution (set by the error or skip command).
    char outputFileName[PATH_MAX];	// Name of the output file being generated.
    char *directory;			// Distribution directory.
    char *distribution;			// Current distribution name.
    char *dataBase;			// Name of database to use.
    char *host;				// Current host being updated.
    int pStatus;			// Last status.
    ofstream output;			// Output file stream.
    Tcl_Interp *interp;			// Tcl interpreter used by this object.
    Options pOptions;			// List of options to use.

    //
    // Methods that maps to tcl procedures.
    //
    int proc_error(int argc, char **argv);
    int proc_include(int argc, char **argv);
    int proc_sadb(int argc, char **argv);
    int proc_sarand(int argc, char **argv);
    int proc_text(int argc, char **argv);

    static Tcl_CmdProc priv_proc_error;
    static Tcl_CmdProc priv_proc_include;
    static Tcl_CmdProc priv_proc_sadb;
    static Tcl_CmdProc priv_proc_sarand;
    static Tcl_CmdProc priv_proc_text;
};

// P r o c e d u r e s .

// V a r i a b l e s .

extern char *prog;			// Name of this program.

// F u n c t i o n s .

int process_input(Tcl_Interp *interp, istream &in);
void sadist_usage(void);

#endif // _SADIST_HH
