#include <Assoc.hh>
#include <string.h>

AssocBase::AssocBase(void) :
	list(0)
{
}

int
AssocBase::exist(const char *text)
{
    return find(text) != 0;
}

void *
AssocBase::find(const char *text)
{
    AssocElem *p;

    for(p = list; p != 0; p = p->next)
    {
    	if (strcmp(text, p->name) == 0) {
    	    return p->data;
    	}
    }

    return p;
}

void *
AssocBase::make(const char *text, int size)
{
    AssocElem *p;

    p = new AssocElem;
    p->next = list;
    list = p;
    p->name = strdup(text);
    p->data = (void *) new char[size];

    return p->data;
}
